/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.counter.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.common.Constants;
import org.apache.ratis.examples.counter.CounterCommand;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

public final class CounterClient
implements Closeable {
    private final RaftClient client = CounterClient.newClient();

    static RaftClient newClient() {
        return RaftClient.newBuilder().setProperties(new RaftProperties()).setRaftGroup(Constants.RAFT_GROUP).build();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static RaftClientReply assertReply(RaftClientReply reply) {
        Preconditions.assertTrue(reply.isSuccess(), "Failed");
        return reply;
    }

    static void send(int increment, Mode mode, RaftClient client) throws Exception {
        ArrayList futures = new ArrayList(increment);
        if (mode == Mode.IO) {
            for (int i = 0; i < increment; ++i) {
                RaftClientReply reply = client.io().send(CounterCommand.INCREMENT.getMessage());
                futures.add(CompletableFuture.completedFuture(reply));
            }
        } else if (mode == Mode.ASYNC) {
            for (int i = 0; i < increment; ++i) {
                futures.add(client.async().send(CounterCommand.INCREMENT.getMessage()).thenApply(CounterClient::assertReply));
            }
            JavaUtils.allOf(futures).get();
        }
    }

    private void send(int i, int increment, Mode mode) {
        System.out.println("Start client " + i);
        try (RaftClient c = CounterClient.newClient();){
            CounterClient.send(increment, mode, c);
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private RaftClientReply readCounter(RaftPeerId server) {
        try {
            return this.client.io().sendReadOnly(CounterCommand.GET.getMessage(), server);
        }
        catch (IOException e) {
            System.err.println("Failed read-only request");
            return RaftClientReply.newBuilder().setSuccess(false).build();
        }
    }

    private void readComplete(RaftClientReply reply, Throwable t2, RaftPeerId server, Timestamp readStarted) {
        if (t2 != null) {
            System.err.println("Failed to get counter from " + server + ": " + t2);
            return;
        }
        if (reply == null || !reply.isSuccess()) {
            System.err.println("Failed to get counter from " + server + " with reply = " + reply);
            return;
        }
        TimeDuration readElapsed = readStarted.elapsedTime();
        int countValue = reply.getMessage().getContent().asReadOnlyByteBuffer().getInt();
        System.out.printf("read from %s and get counter value: %d, time elapsed: %s.%n", server, countValue, readElapsed.toString(TimeUnit.SECONDS, 3));
    }

    private void run(int increment, Mode mode, int numClients, ExecutorService executor) throws Exception {
        Preconditions.assertTrue(increment > 0, "increment <= 0");
        Preconditions.assertTrue(numClients > 0, "numClients <= 0");
        System.out.printf("Sending %d %s command(s) in %s mode with %d client(s) ...%n", new Object[]{increment, CounterCommand.INCREMENT, mode, numClients});
        Timestamp sendStarted = Timestamp.currentTime();
        ConcurrentUtils.parallelForEachAsync(numClients, i -> this.send((int)i, increment, mode), (Executor)executor).get();
        TimeDuration sendElapsed = sendStarted.elapsedTime();
        long numOp = (long)numClients * (long)increment;
        System.out.println("******************************************************");
        System.out.printf("*   Completed sending %d command(s) in %s%n", numOp, sendElapsed.toString(TimeUnit.SECONDS, 3));
        System.out.printf("*   The rate is %01.2f op/s%n", (double)numOp * 1000.0 / (double)sendElapsed.toLong(TimeUnit.MILLISECONDS));
        System.out.println("******************************************************");
        if (mode == Mode.DRY_RUN) {
            return;
        }
        RaftClientReply reply = this.client.io().sendReadOnly(CounterCommand.GET.getMessage());
        int count = reply.getMessage().getContent().asReadOnlyByteBuffer().getInt();
        System.out.println("Current counter value: " + count);
        Timestamp readStarted = Timestamp.currentTime();
        List futures = Constants.PEERS.stream().map(RaftPeer::getId).map(server -> CompletableFuture.supplyAsync(() -> this.readCounter((RaftPeerId)server), executor).whenComplete((r, t2) -> this.readComplete((RaftClientReply)r, (Throwable)t2, (RaftPeerId)server, readStarted))).collect(Collectors.toList());
        for (Future f : futures) {
            f.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (CounterClient client = new CounterClient();){
            int increment = args.length > 0 ? Integer.parseInt(args[0]) : 10;
            Mode mode = Mode.parse(args.length > 1 ? args[1] : null);
            int numClients = args.length > 2 ? Integer.parseInt(args[2]) : 1;
            ExecutorService executor = Executors.newFixedThreadPool(Math.max(numClients, Constants.PEERS.size()));
            try {
                client.run(increment, mode, numClients, executor);
            }
            finally {
                executor.shutdown();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println();
            System.err.println("args = " + Arrays.toString(args));
            System.err.println();
            System.err.printf("Usage: java %s [INCREMENT] [DRY_RUN|ASYNC|IO] [CLIENTS]%n", CounterClient.class.getName());
            System.err.println();
            System.err.println("       INCREMENT: the number of INCREMENT commands to be sent (default is 10)");
            System.err.println("       DRY_RUN  : dry run only (default)");
            System.err.println("       ASYNC    : use the AsyncApi");
            System.err.println("       IO       : use the BlockingApi");
            System.err.println("       CLIENTS  : the number of clients (default is 1)");
            System.exit(1);
        }
    }

    static enum Mode {
        DRY_RUN,
        IO,
        ASYNC;


        static Mode parse(String s2) {
            for (Mode m4 : Mode.values()) {
                if (!m4.name().equalsIgnoreCase(s2)) continue;
                return m4;
            }
            return DRY_RUN;
        }
    }
}

