/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangerYarnAuditHandler
extends RangerDefaultAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerYarnAuditHandler.class);
    private final String yarnModuleName;
    private boolean isAuditEnabled = false;
    private AuthzAuditEvent auditEvent = null;

    public RangerYarnAuditHandler(String yarnModuleName) {
        this.yarnModuleName = yarnModuleName;
    }

    public void processResult(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuditHandler.logAudit(" + result + ")");
        }
        if (!this.isAuditEnabled && result.getIsAudited()) {
            this.isAuditEnabled = true;
        }
        this.auditEvent = super.getAuthzEvents(result);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuditHandler.logAudit(" + result + "): " + this.auditEvent);
        }
    }

    public void logYarnAclEvent(boolean accessGranted) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuditHandler.logYarnAclEvent(" + accessGranted + ")");
        }
        if (this.auditEvent != null) {
            this.auditEvent.setAccessResult((short)(accessGranted ? 1 : 0));
            this.auditEvent.setAclEnforcer(this.yarnModuleName);
            this.auditEvent.setPolicyId(-1L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuditHandler.logYarnAclEvent(" + accessGranted + "): " + this.auditEvent);
        }
    }

    public void flushAudit() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuditHandler.flushAudit(" + this.isAuditEnabled + ", " + this.auditEvent + ")");
        }
        if (this.isAuditEnabled) {
            super.logAuthzAudit(this.auditEvent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuditHandler.flushAudit(" + this.isAuditEnabled + ", " + this.auditEvent + ")");
        }
    }
}

