/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerServiceResourceMatcher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.CachedResourceEvaluators;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerServiceTagsDeltaUtil;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTagEnricher
extends RangerAbstractContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerTagEnricher.class);
    private static final Logger PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    private static final Logger PERF_SET_SERVICETAGS_LOG = RangerPerfTracer.getPerfLogger("tagenricher.setservicetags");
    private static final Logger PERF_SERVICETAGS_RETRIEVAL_LOG = RangerPerfTracer.getPerfLogger("tagenricher.tags.retrieval");
    private static final String TAG_REFRESHER_POLLINGINTERVAL_OPTION = "tagRefresherPollingInterval";
    public static final String TAG_RETRIEVER_CLASSNAME_OPTION = "tagRetrieverClassName";
    private static final String TAG_DISABLE_TRIE_PREFILTER_OPTION = "disableTrieLookupPrefilter";
    private RangerTagRefresher tagRefresher;
    private RangerTagRetriever tagRetriever;
    private boolean disableTrieLookupPrefilter;
    private EnrichedServiceTags enrichedServiceTags;
    private boolean disableCacheIfServiceNotFound = true;
    private boolean dedupStrings = true;
    private Timer tagDownloadTimer;
    private RangerServiceDefHelper serviceDefHelper;
    private final BlockingQueue<DownloadTrigger> tagDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private final RangerReadWriteLock lock = new RangerReadWriteLock(false);
    private final CachedResourceEvaluators cache = new CachedResourceEvaluators();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.init()");
        }
        super.init();
        String propertyPrefix = this.getPropertyPrefix();
        String tagRetrieverClassName = this.getOption(TAG_RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(TAG_REFRESHER_POLLINGINTERVAL_OPTION, 60000L);
        this.dedupStrings = this.getBooleanConfig(propertyPrefix + ".dedup.strings", true);
        this.disableTrieLookupPrefilter = this.getBooleanOption(TAG_DISABLE_TRIE_PREFILTER_OPTION, false);
        this.serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
        if (StringUtils.isNotBlank((String)tagRetrieverClassName)) {
            try {
                Class<?> tagRetriverClass = Class.forName(tagRetrieverClassName);
                this.tagRetriever = (RangerTagRetriever)tagRetriverClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error("Class " + tagRetrieverClassName + " not found, exception=" + exception);
            }
            catch (ClassCastException exception) {
                LOG.error("Class " + tagRetrieverClassName + " is not a type of RangerTagRetriever, exception=" + exception);
            }
            catch (IllegalAccessException exception) {
                LOG.error("Class " + tagRetrieverClassName + " illegally accessed, exception=" + exception);
            }
            catch (InstantiationException exception) {
                LOG.error("Class " + tagRetrieverClassName + " could not be instantiated, exception=" + exception);
            }
            if (this.tagRetriever != null) {
                this.disableCacheIfServiceNotFound = this.getBooleanConfig(propertyPrefix + ".disable.cache.if.servicenotfound", true);
                String cacheDir = this.getConfig(propertyPrefix + ".policy.cache.dir", null);
                String cacheFilename = String.format("%s_%s_tag.json", this.appId, this.serviceName);
                cacheFilename = cacheFilename.replace(File.separatorChar, '_');
                cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
                String cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
                this.createLock();
                this.tagRetriever.setServiceName(this.serviceName);
                this.tagRetriever.setServiceDef(this.serviceDef);
                this.tagRetriever.setAppId(this.appId);
                this.tagRetriever.setPluginConfig(this.getPluginConfig());
                this.tagRetriever.setPluginContext(this.getPluginContext());
                this.tagRetriever.init(this.enricherDef.getEnricherOptions());
                this.tagRefresher = new RangerTagRefresher(this.tagRetriever, this, -1L, this.tagDownloadQueue, cacheFile);
                LOG.info("Created RangerTagRefresher Thread(" + this.tagRefresher.getName() + ")");
                try {
                    this.tagRefresher.populateTags();
                }
                catch (Throwable exception) {
                    LOG.error("Exception when retrieving tag for the first time for this enricher", exception);
                }
                this.tagRefresher.setDaemon(true);
                this.tagRefresher.startRefresher();
                this.tagDownloadTimer = new Timer("policyDownloadTimer", true);
                try {
                    this.tagDownloadTimer.schedule((TimerTask)new DownloaderTask(this.tagDownloadQueue), pollingIntervalMs, pollingIntervalMs);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scheduled tagDownloadRefresher to download tags every " + pollingIntervalMs + " milliseconds");
                    }
                }
                catch (IllegalStateException exception) {
                    LOG.error("Error scheduling tagDownloadTimer:", (Throwable)exception);
                    LOG.error("*** Tags will NOT be downloaded every " + pollingIntervalMs + " milliseconds ***");
                    this.tagDownloadTimer = null;
                }
            }
        } else {
            LOG.error("No value specified for tagRetrieverClassName in the RangerTagEnricher options");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.init()");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.enrich(" + request + ")");
        }
        this.enrich(request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.enrich(" + request + ")");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        Set<RangerTagForEval> matchedTags;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]");
        }
        try (RangerReadWriteLock.RangerLock readLock = this.lock.getReadLock();){
            EnrichedServiceTags enrichedServiceTags;
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - " + readLock);
            }
            if (dataStore instanceof EnrichedServiceTags) {
                enrichedServiceTags = (EnrichedServiceTags)dataStore;
            } else {
                enrichedServiceTags = this.enrichedServiceTags;
                if (dataStore != null) {
                    LOG.warn("Incorrect type of dataStore :[" + dataStore.getClass().getName() + "], falling back to original enrich");
                }
            }
            matchedTags = enrichedServiceTags == null ? null : this.findMatchingTags(request, enrichedServiceTags);
            RangerAccessRequestUtil.setRequestTagsInContext(request.getContext(), matchedTags);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]): tags count=" + (matchedTags == null ? 0 : matchedTags.size()));
        }
    }

    public void setServiceTags(ServiceTags serviceTags) {
        boolean rebuildOnlyIndex = false;
        this.setServiceTags(serviceTags, rebuildOnlyIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServiceTags(ServiceTags serviceTags, boolean rebuildOnlyIndex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.setServiceTags(serviceTags=" + serviceTags + ", rebuildOnlyIndex=" + rebuildOnlyIndex + ")");
        }
        HashSet<String> keysToRemoveFromCache = new HashSet<String>();
        try (RangerReadWriteLock.RangerLock writeLock = this.lock.getWriteLock();){
            EnrichedServiceTags localEnrichedServiceTags;
            if (LOG.isDebugEnabled() && writeLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - " + writeLock);
            }
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_SET_SERVICETAGS_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_SET_SERVICETAGS_LOG, "RangerTagEnricher.setServiceTags(newTagVersion=" + serviceTags.getTagVersion() + ",isDelta=" + serviceTags.getIsDelta() + ")");
            }
            if (serviceTags == null) {
                LOG.info("ServiceTags is null for service " + this.serviceName);
                localEnrichedServiceTags = null;
            } else {
                if (this.dedupStrings) {
                    serviceTags.dedupStrings();
                }
                if (!serviceTags.getIsDelta().booleanValue()) {
                    if (serviceTags.getIsTagsDeduped().booleanValue()) {
                        int countOfDuplicateTags = serviceTags.dedupTags();
                        LOG.info("Number of duplicate tags removed from the received serviceTags:[" + countOfDuplicateTags + "]. Number of tags in the de-duplicated serviceTags :[" + serviceTags.getTags().size() + "].");
                    }
                    localEnrichedServiceTags = this.processServiceTags(serviceTags);
                } else {
                    ServiceTags allServiceTags;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received service-tag deltas:" + serviceTags);
                    }
                    ServiceTags oldServiceTags = this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceTags() : new ServiceTags();
                    ServiceTags serviceTags2 = allServiceTags = rebuildOnlyIndex ? oldServiceTags : RangerServiceTagsDeltaUtil.applyDelta(oldServiceTags, serviceTags, serviceTags.getIsTagsDeduped());
                    if (serviceTags.getTagsChangeExtent() == ServiceTags.TagsChangeExtent.NONE) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No change to service-tags other than version change");
                        }
                        localEnrichedServiceTags = this.enrichedServiceTags;
                    } else if (serviceTags.getTagsChangeExtent() != ServiceTags.TagsChangeExtent.TAGS) {
                        Map<Object, Object> trieMap = this.enrichedServiceTags == null ? new HashMap() : (writeLock.isLockingEnabled() ? this.enrichedServiceTags.getServiceResourceTrie() : this.copyServiceResourceTrie());
                        localEnrichedServiceTags = this.processServiceTagDeltas(serviceTags, allServiceTags, trieMap, keysToRemoveFromCache);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Delta contains only tag attribute changes");
                        }
                        ArrayList<RangerServiceResourceMatcher> resourceMatchers = this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceResourceMatchers() : new ArrayList();
                        HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceResourceTrie() : new HashMap();
                        localEnrichedServiceTags = new EnrichedServiceTags(allServiceTags, resourceMatchers, serviceResourceTrie);
                    }
                }
            }
            Class<RangerTagEnricher> clazz = RangerTagEnricher.class;
            synchronized (RangerTagEnricher.class) {
                this.enrichedServiceTags = localEnrichedServiceTags;
                if (serviceTags != null) {
                    if (serviceTags.getIsDelta().booleanValue()) {
                        this.cache.removeCacheEvaluators(keysToRemoveFromCache);
                        keysToRemoveFromCache.clear();
                    } else {
                        this.cache.clearCache();
                    }
                }
                this.setEnrichedServiceTagsInPlugin();
                // ** MonitorExit[var8_12] (shouldn't be in output)
                RangerPerfTracer.logAlways(perf);
            }
        }
        {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagEnricher.setServiceTags(serviceTags=" + serviceTags + ", rebuildOnlyIndex=" + rebuildOnlyIndex + ")");
            }
            return;
        }
    }

    public Long getServiceTagsVersion() {
        EnrichedServiceTags localEnrichedServiceTags = this.enrichedServiceTags;
        return localEnrichedServiceTags != null ? localEnrichedServiceTags.getServiceTags().getTagVersion() : -1L;
    }

    protected Long getResourceTrieVersion() {
        EnrichedServiceTags localEnrichedServiceTags = this.enrichedServiceTags;
        return localEnrichedServiceTags != null ? localEnrichedServiceTags.getResourceTrieVersion() : -1L;
    }

    @Override
    public boolean preCleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.preCleanup()");
        }
        super.preCleanup();
        Timer tagDownloadTimer = this.tagDownloadTimer;
        this.tagDownloadTimer = null;
        if (tagDownloadTimer != null) {
            tagDownloadTimer.cancel();
        }
        RangerTagRefresher tagRefresher = this.tagRefresher;
        this.tagRefresher = null;
        if (tagRefresher != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to clean up RangerTagRefresher(" + tagRefresher.getName() + ")");
            }
            tagRefresher.cleanup();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.preCleanup() : result=true");
        }
        return true;
    }

    public void syncTagsWithAdmin(DownloadTrigger token) throws InterruptedException {
        this.tagDownloadQueue.put(token);
        token.waitForCompletion();
    }

    public EnrichedServiceTags getEnrichedServiceTags() {
        return this.enrichedServiceTags;
    }

    protected RangerReadWriteLock createLock() {
        String propertyPrefix = this.getPropertyPrefix();
        RangerPluginConfig config = this.getPluginConfig();
        boolean deltasEnabled = config != null && config.getBoolean(propertyPrefix + ".supports.tag.deltas", false);
        boolean inPlaceUpdatesEnabled = config != null && config.getBoolean(propertyPrefix + ".supports.in.place.tag.updates", false);
        boolean useReadWriteLock = deltasEnabled && inPlaceUpdatesEnabled;
        LOG.info("Policy-Engine will" + (useReadWriteLock ? " " : " not ") + "use read-write locking to update tags in place when tag-deltas are provided");
        return new RangerReadWriteLock(useReadWriteLock);
    }

    private EnrichedServiceTags processServiceTags(ServiceTags serviceTags) {
        EnrichedServiceTags ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing all service-tags");
        }
        if (CollectionUtils.isEmpty(serviceTags.getServiceResources())) {
            LOG.info("There are no tagged resources for service " + this.serviceName);
            ret = null;
        } else {
            ResourceHierarchies hierarchies = new ResourceHierarchies();
            ArrayList<RangerServiceResourceMatcher> resourceMatchers = new ArrayList<RangerServiceResourceMatcher>();
            List<RangerServiceResource> serviceResources = serviceTags.getServiceResources();
            ListIterator<RangerServiceResource> iter = serviceResources.listIterator();
            while (iter.hasNext()) {
                RangerServiceResource serviceResource = iter.next();
                RangerServiceResourceMatcher serviceResourceMatcher = RangerTagEnricher.createRangerServiceResourceMatcher(serviceResource, this.serviceDefHelper, hierarchies, this.getPluginContext());
                if (serviceResourceMatcher != null) {
                    resourceMatchers.add(serviceResourceMatcher);
                    continue;
                }
                iter.remove();
                List<Long> tags = serviceTags.getResourceToTagIds().remove(serviceResource.getId());
                LOG.warn("Invalid resource [" + serviceResource + "]: failed to create resource-matcher. Ignoring " + (tags != null ? tags.size() : 0) + " tags associated with the resource");
            }
            HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = null;
            if (!this.disableTrieLookupPrefilter) {
                serviceResourceTrie = new HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>>();
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    serviceResourceTrie.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, resourceMatchers, this.getPolicyEngineOptions().optimizeTagTrieForRetrieval, this.getPolicyEngineOptions().optimizeTagTrieForSpace, null));
                }
            }
            ret = new EnrichedServiceTags(serviceTags, resourceMatchers, serviceResourceTrie);
        }
        return ret;
    }

    private EnrichedServiceTags processServiceTagDeltas(ServiceTags deltas, ServiceTags allServiceTags, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie, Set<String> keysToRemoveFromCache) {
        EnrichedServiceTags ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delta contains changes other than tag attribute changes, [" + (Object)((Object)deltas.getTagsChangeExtent()) + "]");
        }
        boolean isInError = false;
        ResourceHierarchies hierarchies = new ResourceHierarchies();
        ArrayList<RangerServiceResourceMatcher> resourceMatchers = new ArrayList<RangerServiceResourceMatcher>();
        if (this.enrichedServiceTags != null) {
            resourceMatchers.addAll(this.enrichedServiceTags.getServiceResourceMatchers());
        }
        List<RangerServiceResource> changedServiceResources = deltas.getServiceResources();
        for (RangerServiceResource rangerServiceResource : changedServiceResources) {
            RangerAccessResource removedAccessResource;
            RangerAccessResource rangerAccessResource = removedAccessResource = MapUtils.isEmpty(rangerServiceResource.getResourceElements()) ? null : this.removeOldServiceResource(rangerServiceResource, resourceMatchers, serviceResourceTrie);
            if (removedAccessResource != null) {
                if (!StringUtils.isEmpty((String)rangerServiceResource.getResourceSignature())) {
                    RangerServiceResourceMatcher resourceMatcher = RangerTagEnricher.createRangerServiceResourceMatcher(rangerServiceResource, this.serviceDefHelper, hierarchies, this.getPluginContext());
                    if (resourceMatcher != null) {
                        for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                            RangerPolicy.RangerPolicyResource policyResource = rangerServiceResource.getResourceElements().get(resourceDef.getName());
                            RangerResourceTrie<RangerServiceResourceMatcher> trie = serviceResourceTrie.get(resourceDef.getName());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Trying to add resource-matcher to " + (trie == null ? "new" : "existing") + " trie for " + resourceDef.getName());
                            }
                            if (trie != null) {
                                trie.add(policyResource, resourceMatcher);
                                trie.wrapUpUpdate();
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Added resource-matcher for policy-resource:[" + policyResource + "]");
                                continue;
                            }
                            trie = new RangerResourceTrie(resourceDef, Collections.singletonList(resourceMatcher), this.getPolicyEngineOptions().optimizeTagTrieForRetrieval, this.getPolicyEngineOptions().optimizeTagTrieForSpace, null);
                            serviceResourceTrie.put(resourceDef.getName(), trie);
                        }
                        resourceMatchers.add(resourceMatcher);
                    } else {
                        LOG.error("Could not create resource-matcher for resource: [" + rangerServiceResource + "]. Should NOT happen!!");
                        LOG.error("Setting tagVersion to -1 to ensure that in the next download all tags are downloaded");
                        isInError = true;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Service-resource:[id=" + rangerServiceResource.getId() + "] is deleted as its resource-signature is empty. No need to create it!");
                }
                keysToRemoveFromCache.add(removedAccessResource.getCacheKey());
            } else {
                isInError = true;
            }
            if (!isInError) continue;
            break;
        }
        if (isInError) {
            LOG.error("Error in processing tag-deltas. Will continue to use old tags");
            deltas.setTagVersion(-1L);
            keysToRemoveFromCache.clear();
            ret = this.enrichedServiceTags;
        } else {
            for (Map.Entry entry : serviceResourceTrie.entrySet()) {
                ((RangerResourceTrie)entry.getValue()).wrapUpUpdate();
            }
            ret = new EnrichedServiceTags(allServiceTags, resourceMatchers, serviceResourceTrie);
        }
        return ret;
    }

    private RangerAccessResource removeOldServiceResource(RangerServiceResource serviceResource, List<RangerServiceResourceMatcher> resourceMatchers, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> resourceTries) {
        RangerAccessResourceImpl ret;
        boolean result = true;
        if (this.enrichedServiceTags != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing service-resource:[" + serviceResource + "] from trie-map");
            }
            RangerAccessResourceImpl accessResource = new RangerAccessResourceImpl();
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : serviceResource.getResourceElements().entrySet()) {
                accessResource.setValue(entry.getKey(), entry.getValue().getValues());
            }
            accessResource.setServiceDef(this.serviceDef);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerAccessResource:[" + accessResource + "] created to represent service-resource[" + serviceResource + "] to find evaluators from trie-map");
            }
            RangerAccessRequestImpl request = new RangerAccessRequestImpl();
            request.setResource(accessResource);
            Collection<RangerServiceResourceMatcher> oldMatchers = CachedResourceEvaluators.getEvaluators(request, this.enrichedServiceTags.getServiceResourceTrie(), this.cache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found [" + oldMatchers + "] matchers for service-resource[" + serviceResource + "]");
            }
            if (CollectionUtils.isNotEmpty(oldMatchers)) {
                ArrayList<RangerServiceResourceMatcher> notMatched = new ArrayList<RangerServiceResourceMatcher>();
                for (RangerServiceResourceMatcher resourceMatcher : oldMatchers) {
                    RangerPolicyResourceMatcher.MatchType matchType = resourceMatcher.getMatchType(accessResource, request.getResourceElementMatchingScopes(), request.getContext());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("resource:[" + accessResource + ", MatchType:[" + (Object)((Object)matchType) + "]");
                    }
                    if (matchType == RangerPolicyResourceMatcher.MatchType.SELF) continue;
                    notMatched.add(resourceMatcher);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("oldMatchers : [" + notMatched + "] do not match resource:[" + accessResource + "] exactly and will be discarded");
                }
                oldMatchers.removeAll(notMatched);
            }
            block2: for (RangerServiceResourceMatcher matcher : oldMatchers) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    String resourceDefName = resourceDef.getName();
                    RangerResourceTrie<RangerServiceResourceMatcher> trie = resourceTries.get(resourceDefName);
                    if (trie != null) {
                        trie.delete(serviceResource.getResourceElements().get(resourceDefName), matcher);
                        continue;
                    }
                    LOG.error("Cannot find resourceDef with name:[" + resourceDefName + "]. Should NOT happen!!");
                    LOG.error("Setting tagVersion to -1 to ensure that in the next download all tags are downloaded");
                    result = false;
                    continue block2;
                }
            }
            if (result) {
                resourceMatchers.removeAll(oldMatchers);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found and removed [" + oldMatchers + "] matchers for service-resource[" + serviceResource + "] from trie-map");
                }
                ret = accessResource;
            } else {
                ret = null;
            }
        } else {
            ret = null;
        }
        return ret;
    }

    public static RangerServiceResourceMatcher createRangerServiceResourceMatcher(RangerServiceResource serviceResource, RangerServiceDefHelper serviceDefHelper, ResourceHierarchies hierarchies, RangerPluginContext pluginContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createRangerServiceResourceMatcher(serviceResource=" + serviceResource + ")");
        }
        RangerServiceResourceMatcher ret = null;
        Set<String> resourceKeys = serviceResource.getResourceElements().keySet();
        for (int policyType : RangerPolicy.POLICY_TYPES) {
            Boolean isValidHierarchy = hierarchies.isValidHierarchy(policyType, resourceKeys);
            if (isValidHierarchy == null) {
                isValidHierarchy = Boolean.FALSE;
                for (List<RangerServiceDef.RangerResourceDef> hierarchy : serviceDefHelper.getResourceHierarchies(policyType)) {
                    if (!serviceDefHelper.hierarchyHasAllResources(hierarchy, resourceKeys)) continue;
                    isValidHierarchy = Boolean.TRUE;
                    break;
                }
                hierarchies.addHierarchy(policyType, resourceKeys, isValidHierarchy);
            }
            if (!isValidHierarchy.booleanValue()) continue;
            RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
            matcher.setServiceDef(serviceDefHelper.getServiceDef());
            matcher.setPolicyResources(serviceResource.getResourceElements(), policyType);
            matcher.setPluginContext(pluginContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerTagEnricher.setServiceTags() - Initializing matcher with (resource=" + serviceResource + ", serviceDef=" + serviceDefHelper.getServiceDef() + ")");
            }
            matcher.setServiceDefHelper(serviceDefHelper);
            matcher.init();
            ret = new RangerServiceResourceMatcher(serviceResource, matcher);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== createRangerServiceResourceMatcher(serviceResource=" + serviceResource + ") : [" + ret + "]");
        }
        return ret;
    }

    private void setEnrichedServiceTagsInPlugin() {
        RangerAuthContext authContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setEnrichedServiceTagsInPlugin()");
        }
        if ((authContext = this.getAuthContext()) != null) {
            authContext.addOrReplaceRequestContextEnricher(this, this.enrichedServiceTags);
            this.notifyAuthContextChanged();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== setEnrichedServiceTagsInPlugin()");
        }
    }

    private Set<RangerTagForEval> findMatchingTags(RangerAccessRequest request, EnrichedServiceTags dataStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.findMatchingTags(" + request + ")");
        }
        EnrichedServiceTags enrichedServiceTags = dataStore != null ? dataStore : this.enrichedServiceTags;
        Set<RangerTagForEval> ret = null;
        RangerAccessResource resource = request.getResource();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_SERVICETAGS_RETRIEVAL_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_SERVICETAGS_RETRIEVAL_LOG, "RangerTagEnricher.findMatchingTags=" + resource.getAsString() + ")");
        }
        if ((resource == null || resource.getKeys() == null || resource.getKeys().isEmpty()) && request.isAccessTypeAny()) {
            ret = enrichedServiceTags.getTagsForEmptyResourceAndAnyAccess();
        } else {
            Collection<RangerServiceResourceMatcher> serviceResourceMatchers = CachedResourceEvaluators.getEvaluators(request, enrichedServiceTags.getServiceResourceTrie(), this.cache);
            if (CollectionUtils.isNotEmpty(serviceResourceMatchers)) {
                for (RangerServiceResourceMatcher resourceMatcher : serviceResourceMatchers) {
                    boolean isMatched;
                    RangerAccessRequest.ResourceMatchingScope resourceMatchingScope;
                    RangerPolicyResourceMatcher.MatchType matchType = resourceMatcher.getMatchType(resource, request.getResourceElementMatchingScopes(), request.getContext());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("resource:[" + resource + ", MatchType:[" + (Object)((Object)matchType) + "]");
                    }
                    RangerAccessRequest.ResourceMatchingScope resourceMatchingScope2 = resourceMatchingScope = request.getResourceMatchingScope() != null ? request.getResourceMatchingScope() : RangerAccessRequest.ResourceMatchingScope.SELF;
                    if (request.isAccessTypeAny() || resourceMatchingScope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                        isMatched = matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR || matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS || matchType == RangerPolicyResourceMatcher.MatchType.DESCENDANT;
                    } else {
                        boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR || matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
                    }
                    if (!isMatched) continue;
                    if (ret == null) {
                        ret = new HashSet<RangerTagForEval>();
                    }
                    ret.addAll(RangerTagEnricher.getTagsForServiceResource(request.getAccessTime(), enrichedServiceTags.getServiceTags(), resourceMatcher.getServiceResource(), matchType));
                }
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (CollectionUtils.isEmpty(ret)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerTagEnricher.findMatchingTags(" + resource + ") - No tags Found ");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("RangerTagEnricher.findMatchingTags(" + resource + ") - " + ret.size() + " tags Found ");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.findMatchingTags(" + request + ")");
        }
        return ret;
    }

    private static Set<RangerTagForEval> getTagsForServiceResource(Date accessTime, ServiceTags serviceTags, RangerServiceResource serviceResource, RangerPolicyResourceMatcher.MatchType matchType) {
        HashSet<RangerTagForEval> ret = new HashSet<RangerTagForEval>();
        Long resourceId = serviceResource.getId();
        Map<Long, List<Long>> resourceToTagIds = serviceTags.getResourceToTagIds();
        Map<Long, RangerTag> tags = serviceTags.getTags();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for tags for resource-id:[" + resourceId + "] in serviceTags:[" + serviceTags + "]");
        }
        if (resourceId != null && MapUtils.isNotEmpty(resourceToTagIds) && MapUtils.isNotEmpty(tags)) {
            List<Long> tagIds = resourceToTagIds.get(resourceId);
            if (CollectionUtils.isNotEmpty(tagIds)) {
                accessTime = accessTime == null ? new Date() : accessTime;
                for (Long tagId : tagIds) {
                    RangerTagForEval tagForEval;
                    RangerTag tag = tags.get(tagId);
                    if (tag == null || !(tagForEval = new RangerTagForEval(tag, matchType)).isApplicable(accessTime)) continue;
                    ret.add(tagForEval);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No tags mapping found for resource:[" + resourceId + "]");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("resourceId is null or resourceToTagTds mapping is null or tags mapping is null!");
        }
        return ret;
    }

    private Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> copyServiceResourceTrie() {
        HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> ret = new HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>>();
        if (this.enrichedServiceTags != null) {
            for (Map.Entry<String, RangerResourceTrie<RangerServiceResourceMatcher>> entry : this.enrichedServiceTags.getServiceResourceTrie().entrySet()) {
                RangerResourceTrie<RangerServiceResourceMatcher> resourceTrie = new RangerResourceTrie<RangerServiceResourceMatcher>(entry.getValue());
                ret.put(entry.getKey(), resourceTrie);
            }
        }
        return ret;
    }

    static class RangerTagRefresher
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(RangerTagRefresher.class);
        private final RangerTagRetriever tagRetriever;
        private final RangerTagEnricher tagEnricher;
        private long lastKnownVersion;
        private final BlockingQueue<DownloadTrigger> tagDownloadQueue;
        private long lastActivationTimeInMillis;
        private final String cacheFile;
        private boolean hasProvidedTagsToReceiver;

        RangerTagRefresher(RangerTagRetriever tagRetriever, RangerTagEnricher tagEnricher, long lastKnownVersion, BlockingQueue<DownloadTrigger> tagDownloadQueue, String cacheFile) {
            this.tagRetriever = tagRetriever;
            this.tagEnricher = tagEnricher;
            this.lastKnownVersion = lastKnownVersion;
            this.tagDownloadQueue = tagDownloadQueue;
            this.cacheFile = cacheFile;
            this.setName("RangerTagRefresher(serviceName=" + tagRetriever.getServiceName() + ")-" + this.getId());
        }

        public long getLastActivationTimeInMillis() {
            return this.lastActivationTimeInMillis;
        }

        public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
            this.lastActivationTimeInMillis = lastActivationTimeInMillis;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRefresher().run()");
            }
            while (true) {
                DownloadTrigger trigger = null;
                try {
                    RangerPerfTracer perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerTagRefresher(" + this.getName() + ").populateTags(lastKnownVersion=" + this.lastKnownVersion + ")");
                    }
                    trigger = this.tagDownloadQueue.take();
                    this.populateTags();
                    RangerPerfTracer.log(perf);
                    continue;
                }
                catch (InterruptedException excp) {
                    LOG.info("RangerTagRefresher(" + this.getName() + ").run(): Interrupted! Exiting thread", (Throwable)excp);
                }
                finally {
                    if (trigger == null) continue;
                    trigger.signalCompletion();
                    continue;
                }
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRefresher().run()");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void populateTags() throws InterruptedException {
            if (this.tagEnricher != null) {
                try {
                    ServiceTags serviceTags = this.tagRetriever.retrieveTags(this.lastKnownVersion, this.lastActivationTimeInMillis);
                    if (serviceTags == null) {
                        if (!this.hasProvidedTagsToReceiver) {
                            serviceTags = this.loadFromCache();
                        }
                    } else if (!serviceTags.getIsDelta().booleanValue()) {
                        this.saveToCache(serviceTags);
                    }
                    if (serviceTags != null) {
                        this.tagEnricher.setServiceTags(serviceTags);
                        if (serviceTags.getIsDelta().booleanValue() && serviceTags.getTagVersion() != -1L) {
                            this.saveToCache(this.tagEnricher.enrichedServiceTags.serviceTags);
                        }
                        LOG.info("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ").populateTags() - Updated tags-cache to new version of tags, lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + (serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion()));
                        this.hasProvidedTagsToReceiver = true;
                        this.lastKnownVersion = serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion();
                        this.setLastActivationTimeInMillis(System.currentTimeMillis());
                        return;
                    }
                    if (!LOG.isDebugEnabled()) return;
                    LOG.debug("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ").populateTags() - No need to update tags-cache. lastKnownVersion=" + this.lastKnownVersion);
                    return;
                }
                catch (RangerServiceNotFoundException snfe) {
                    LOG.error("Caught ServiceNotFound exception :", (Throwable)snfe);
                    if (!this.tagEnricher.disableCacheIfServiceNotFound) return;
                    this.disableCache();
                    this.tagEnricher.setServiceTags(null);
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    this.lastKnownVersion = -1L;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception e) {
                    LOG.error("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ").populateTags(): Encountered unexpected exception. Ignoring", (Throwable)e);
                    return;
                }
            } else {
                LOG.error("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ".populateTags() - no tag receiver to update tag-cache");
            }
        }

        void cleanup() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRefresher.cleanup()");
            }
            this.stopRefresher();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRefresher.cleanup()");
            }
        }

        final void startRefresher() {
            try {
                super.start();
            }
            catch (Exception excp) {
                LOG.error("RangerTagRefresher(" + this.getName() + ").startRetriever(): Failed to start, exception=" + excp);
            }
        }

        private void stopRefresher() {
            if (super.isAlive()) {
                super.interrupt();
                boolean setInterrupted = false;
                boolean isJoined = false;
                while (!isJoined) {
                    try {
                        super.join();
                        isJoined = true;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("RangerTagRefresher(" + this.getName() + ") is stopped");
                    }
                    catch (InterruptedException excp) {
                        LOG.warn("RangerTagRefresher(" + this.getName() + ").stopRefresher(): Error while waiting for thread to exit", (Throwable)excp);
                        LOG.warn("Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                        setInterrupted = true;
                    }
                }
                if (setInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        final ServiceTags loadFromCache() {
            serviceTags = null;
            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()");
            }
            v0 = cacheFile = StringUtils.isEmpty((String)this.cacheFile) != false ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                reader = null;
                try {
                    reader = new FileReader(cacheFile);
                    serviceTags = JsonUtils.jsonToObject(reader, ServiceTags.class);
                    if (serviceTags == null || StringUtils.equals((String)this.tagEnricher.getServiceName(), (String)serviceTags.getServiceName())) ** GOTO lbl26
                    RangerTagRefresher.LOG.warn("ignoring unexpected serviceName '" + serviceTags.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'");
                    serviceTags.setServiceName(this.tagEnricher.getServiceName());
                }
                catch (Exception excp) {
                    RangerTagRefresher.LOG.error("failed to load service-tags from cache file " + cacheFile.getAbsolutePath(), (Throwable)excp);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception excp) {
                            RangerTagRefresher.LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp);
                        }
                    }
                }
            } else {
                RangerTagRefresher.LOG.warn("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'");
            }
lbl26:
            // 4 sources

            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()");
            }
            return serviceTags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void saveToCache(ServiceTags serviceTags) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()");
            }
            if (serviceTags != null) {
                File cacheFile;
                File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
                if (cacheFile != null) {
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(cacheFile);
                        JsonUtils.objectToWriter(writer, serviceTags);
                    }
                    catch (Exception excp) {
                        LOG.error("failed to save service-tags to cache file '" + cacheFile.getAbsolutePath() + "'", (Throwable)excp);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Exception excp) {
                                LOG.error("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'", (Throwable)excp);
                            }
                        }
                    }
                }
            } else {
                LOG.info("service-tags is null for service=" + this.tagRetriever.getServiceName() + ". Nothing to save in cache");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()");
            }
        }

        final void disableCache() {
            File cacheFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRetriever.disableCache(serviceName=" + this.tagEnricher.getServiceName() + ")");
            }
            File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                LOG.warn("Cleaning up local tags cache");
                String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
                if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                    LOG.error("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
                } else {
                    LOG.warn("moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No local TAGS cache found. No need to disable it!");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRetriever.disableCache(serviceName=" + this.tagEnricher.getServiceName() + ")");
            }
        }
    }

    public static final class EnrichedServiceTags {
        private final ServiceTags serviceTags;
        private final List<RangerServiceResourceMatcher> serviceResourceMatchers;
        private final Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie;
        private final Set<RangerTagForEval> tagsForEmptyResourceAndAnyAccess;
        private final Long resourceTrieVersion;

        EnrichedServiceTags(ServiceTags serviceTags, List<RangerServiceResourceMatcher> serviceResourceMatchers, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie) {
            this.serviceTags = serviceTags;
            this.serviceResourceMatchers = serviceResourceMatchers;
            this.serviceResourceTrie = serviceResourceTrie;
            this.tagsForEmptyResourceAndAnyAccess = this.createTagsForEmptyResourceAndAnyAccess();
            this.resourceTrieVersion = serviceTags.getTagVersion();
        }

        public ServiceTags getServiceTags() {
            return this.serviceTags;
        }

        public List<RangerServiceResourceMatcher> getServiceResourceMatchers() {
            return this.serviceResourceMatchers;
        }

        public Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> getServiceResourceTrie() {
            return this.serviceResourceTrie;
        }

        public Long getResourceTrieVersion() {
            return this.resourceTrieVersion;
        }

        public Set<RangerTagForEval> getTagsForEmptyResourceAndAnyAccess() {
            return this.tagsForEmptyResourceAndAnyAccess;
        }

        private Set<RangerTagForEval> createTagsForEmptyResourceAndAnyAccess() {
            HashSet<RangerTagForEval> tagsForEmptyResourceAndAnyAccess = new HashSet<RangerTagForEval>();
            for (Map.Entry<Long, RangerTag> entry : this.serviceTags.getTags().entrySet()) {
                tagsForEmptyResourceAndAnyAccess.add(new RangerTagForEval(entry.getValue(), RangerPolicyResourceMatcher.MatchType.DESCENDANT));
            }
            return tagsForEmptyResourceAndAnyAccess;
        }
    }

    public static class ResourceHierarchies {
        private final Map<Collection<String>, Boolean> accessHierarchies = new HashMap<Collection<String>, Boolean>();
        private final Map<Collection<String>, Boolean> dataMaskHierarchies = new HashMap<Collection<String>, Boolean>();
        private final Map<Collection<String>, Boolean> rowFilterHierarchies = new HashMap<Collection<String>, Boolean>();

        Boolean isValidHierarchy(int policyType, Collection<String> resourceKeys) {
            switch (policyType) {
                case 0: {
                    return this.accessHierarchies.get(resourceKeys);
                }
                case 1: {
                    return this.dataMaskHierarchies.get(resourceKeys);
                }
                case 2: {
                    return this.rowFilterHierarchies.get(resourceKeys);
                }
            }
            return null;
        }

        void addHierarchy(int policyType, Collection<String> resourceKeys, Boolean isValid) {
            switch (policyType) {
                case 0: {
                    this.accessHierarchies.put(resourceKeys, isValid);
                    break;
                }
                case 1: {
                    this.dataMaskHierarchies.put(resourceKeys, isValid);
                    break;
                }
                case 2: {
                    this.rowFilterHierarchies.put(resourceKeys, isValid);
                    break;
                }
                default: {
                    LOG.error("unknown policy-type " + policyType);
                }
            }
        }
    }
}

