/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.plugin.util.ScriptEngineCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalScriptEngineCreator
implements ScriptEngineCreator {
    private static final Logger LOG = LoggerFactory.getLogger(GraalScriptEngineCreator.class);
    private static final String ENGINE_NAME = "graal.js";
    private static final String CONFIG_PREDIX_JVM = "polyglot";
    private static final String CONFIG_PREDIX_PLUGIN = "ranger.plugin.script.";
    private static final String CONFIG_JAVA_CLASS_PATH = "java.class.path";
    private final Map<String, Boolean> graalVmConfigs = new HashMap<String, Boolean>();

    public GraalScriptEngineCreator() {
        HashMap<String, Boolean> graalVmConfigsDefault = new HashMap<String, Boolean>(4);
        Configuration configuration = new Configuration();
        FilenameFilter fileNameFilter = (dir, name) -> name.startsWith("ranger-") && name.endsWith("security.xml");
        graalVmConfigsDefault.put("polyglot.js.allowHostAccess", Boolean.TRUE);
        graalVmConfigsDefault.put("polyglot.js.nashorn-compat", Boolean.TRUE);
        for (String file : this.findFiles(fileNameFilter)) {
            configuration.addResource(new Path(file));
        }
        this.graalVmConfigs.putAll(this.getGraalVmConfigs(configuration, graalVmConfigsDefault));
    }

    @Override
    public ScriptEngine getScriptEngine(ClassLoader clsLoader) {
        ScriptEngine ret = null;
        if (clsLoader == null) {
            clsLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            ScriptEngineManager mgr = new ScriptEngineManager(clsLoader);
            ret = mgr.getEngineByName(ENGINE_NAME);
            if (ret != null) {
                Bindings bindings = ret.getBindings(100);
                bindings.putAll((Map<? extends String, ? extends Object>)this.graalVmConfigs);
                ret.setBindings(bindings, 100);
            }
        }
        catch (Throwable t) {
            LOG.debug("GraalScriptEngineCreator.getScriptEngine(): failed to create engine type {}", (Object)ENGINE_NAME, (Object)t);
        }
        if (ret == null) {
            LOG.debug("GraalScriptEngineCreator.getScriptEngine(): failed to create engine type {}", (Object)ENGINE_NAME);
        }
        return ret;
    }

    private Map<String, Boolean> getGraalVmConfigs(Configuration configuration, Map<String, Boolean> graalVmConfigsDefault) {
        Object value;
        String key;
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> GraalScriptEngineCreator.getGraalVmConfigs()");
        }
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        for (Map.Entry entry : configuration.getPropsWithPrefix(CONFIG_PREDIX_PLUGIN).entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            ret.put(key, Boolean.valueOf((String)value));
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!entry.getKey().toString().startsWith(CONFIG_PREDIX_JVM)) continue;
            key = entry.getKey().toString();
            value = entry.getValue().toString();
            if (!StringUtils.isNotBlank((String)value) || ret.get(key) != null) continue;
            ret.put(key, Boolean.valueOf((String)value));
        }
        for (Map.Entry<Object, Object> entry : graalVmConfigsDefault.entrySet()) {
            key = (String)entry.getKey();
            value = (Boolean)entry.getValue();
            ret.putIfAbsent(key, (Boolean)value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<=== GraalScriptEngineCreator.getGraalVmConfigs(): ret={}", ret);
        }
        return ret;
    }

    private Set<String> findFiles(FilenameFilter filenameFilter) {
        String classPath = System.getProperty(CONFIG_JAVA_CLASS_PATH);
        ArrayList<String> configDirs = new ArrayList<String>(5);
        HashSet<String> ret = new HashSet<String>();
        for (String path : classPath.split(":")) {
            if (path.endsWith("jar")) continue;
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            configDirs.add(path);
        }
        for (String configDir : configDirs) {
            File confDir = new File(configDir);
            if (!confDir.isDirectory()) continue;
            for (File file : Objects.requireNonNull(confDir.listFiles(filenameFilter))) {
                ret.add(file.getAbsolutePath());
            }
        }
        return ret;
    }
}

