/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.SpanMatchNoDocsQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;

public class SpanBooleanQueryRewriteWithMaxClause
extends SpanMultiTermQueryWrapper.SpanRewriteMethod {
    private final int maxExpansions;
    private final boolean hardLimit;

    public SpanBooleanQueryRewriteWithMaxClause() {
        this(BooleanQuery.getMaxClauseCount(), true);
    }

    public SpanBooleanQueryRewriteWithMaxClause(int maxExpansions, boolean hardLimit) {
        this.maxExpansions = maxExpansions;
        this.hardLimit = hardLimit;
    }

    public int getMaxExpansions() {
        return this.maxExpansions;
    }

    public boolean isHardLimit() {
        return this.hardLimit;
    }

    public SpanQuery rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
        MultiTermQuery.RewriteMethod delegate = new MultiTermQuery.RewriteMethod(){

            public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
                Collection<SpanQuery> queries = this.collectTerms(reader, query);
                if (queries.size() == 0) {
                    return new SpanMatchNoDocsQuery(query.getField(), "no expansion found for " + query.toString());
                }
                if (queries.size() == 1) {
                    return (Query)queries.iterator().next();
                }
                return new SpanOrQuery(queries.toArray(new SpanQuery[0]));
            }

            private Collection<SpanQuery> collectTerms(IndexReader reader, MultiTermQuery query) throws IOException {
                HashSet<SpanQuery> queries = new HashSet<SpanQuery>();
                IndexReaderContext topReaderContext = reader.getContext();
                for (LeafReaderContext context : topReaderContext.leaves()) {
                    BytesRef bytes;
                    Terms terms = context.reader().terms(query.getField());
                    if (terms == null) continue;
                    TermsEnum termsEnum = this.getTermsEnum(query, terms, new AttributeSource());
                    assert (termsEnum != null);
                    if (termsEnum == TermsEnum.EMPTY) continue;
                    while ((bytes = termsEnum.next()) != null) {
                        if (queries.size() >= SpanBooleanQueryRewriteWithMaxClause.this.maxExpansions) {
                            if (SpanBooleanQueryRewriteWithMaxClause.this.hardLimit) {
                                throw new RuntimeException("[" + query.toString() + " ] exceeds maxClauseCount [ Boolean maxClauseCount is set to " + BooleanQuery.getMaxClauseCount() + "]");
                            }
                            return queries;
                        }
                        queries.add((SpanQuery)new SpanTermQuery(new Term(query.getField(), bytes)));
                    }
                }
                return queries;
            }
        };
        return (SpanQuery)delegate.rewrite(reader, query);
    }
}

