/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.futures;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientSynchronization;

public class ConservativeClientFuture<V>
extends ClientFuture<V> {
    public ConservativeClientFuture() {
        this(null);
    }

    public ConservativeClientFuture(ClientSynchronization<V> synchronization) {
        super(synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long amount, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isNotComplete() && amount > 0L) {
            long timeout = unit.toNanos(amount);
            long startTime = System.nanoTime();
            while (this.isNotComplete()) {
                long elapsed = System.nanoTime() - startTime;
                long diff = elapsed - timeout;
                if (diff >= 0L) {
                    throw new TimeoutException("Timed out waiting for completion");
                }
                ConservativeClientFuture conservativeClientFuture = this;
                synchronized (conservativeClientFuture) {
                    if (this.isComplete()) {
                        break;
                    }
                    if (this.getState() < 1) {
                        ++this.waiting;
                        try {
                            this.wait(-diff / 1000000L, (int)(-diff % 1000000L));
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw e;
                        }
                        finally {
                            --this.waiting;
                        }
                    }
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        while (this.isNotComplete()) {
            ConservativeClientFuture conservativeClientFuture = this;
            synchronized (conservativeClientFuture) {
                if (this.isComplete()) {
                    break;
                }
                if (this.getState() < 1) {
                    ++this.waiting;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw e;
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.getResult();
    }
}

