/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ResourceGroup;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about ResourceGroups"})
public class CmdResourceGroups
extends CmdBase {
    public CmdResourceGroups(Supplier<PulsarAdmin> admin) {
        super("resourcegroups", admin);
        this.addCommand("list", new List());
        this.addCommand("get", new Get());
        this.addCommand("create", new Create());
        this.addCommand("update", new Update());
        this.addCommand("delete", new Delete());
    }

    @CommandLine.Command(description={"List the existing resourcegroups"})
    private class List
    extends CliCommand {
        private List() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdResourceGroups.this.getAdmin().resourcegroups().getResourceGroups());
        }
    }

    @CommandLine.Command(description={"Gets the configuration of a resourcegroup"})
    private class Get
    extends CliCommand {
        @CommandLine.Parameters(description={"resourcegroup-name"}, arity="1")
        private String resourceGroupName;

        private Get() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdResourceGroups.this.getAdmin().resourcegroups().getResourceGroup(this.resourceGroupName));
        }
    }

    @CommandLine.Command(description={"Creates a new resourcegroup"})
    private class Create
    extends CliCommand {
        @CommandLine.Parameters(description={"resourcegroup-name"}, arity="1")
        private String resourceGroupName;
        @CommandLine.Option(names={"--msg-publish-rate", "-mp"}, description={"message-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private Integer publishRateInMsgs;
        @CommandLine.Option(names={"--byte-publish-rate", "-bp"}, description={"byte-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private Long publishRateInBytes;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private Integer dispatchRateInMsgs;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private Long dispatchRateInBytes;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            ResourceGroup resourcegroup = new ResourceGroup();
            resourcegroup.setDispatchRateInMsgs(this.dispatchRateInMsgs);
            resourcegroup.setDispatchRateInBytes(this.dispatchRateInBytes);
            resourcegroup.setPublishRateInMsgs(this.publishRateInMsgs);
            resourcegroup.setPublishRateInBytes(this.publishRateInBytes);
            CmdResourceGroups.this.getAdmin().resourcegroups().createResourceGroup(this.resourceGroupName, resourcegroup);
        }
    }

    @CommandLine.Command(description={"Updates a resourcegroup"})
    private class Update
    extends CliCommand {
        @CommandLine.Parameters(description={"resourcegroup-name"}, arity="1")
        private String resourceGroupName;
        @CommandLine.Option(names={"--msg-publish-rate", "-mp"}, description={"message-publish-rate "}, required=false)
        private Integer publishRateInMsgs;
        @CommandLine.Option(names={"--byte-publish-rate", "-bp"}, description={"byte-publish-rate "}, required=false)
        private Long publishRateInBytes;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate "}, required=false)
        private Integer dispatchRateInMsgs;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate "}, required=false)
        private Long dispatchRateInBytes;

        private Update() {
        }

        @Override
        void run() throws PulsarAdminException {
            ResourceGroup resourcegroup = new ResourceGroup();
            resourcegroup.setDispatchRateInMsgs(this.dispatchRateInMsgs);
            resourcegroup.setDispatchRateInBytes(this.dispatchRateInBytes);
            resourcegroup.setPublishRateInMsgs(this.publishRateInMsgs);
            resourcegroup.setPublishRateInBytes(this.publishRateInBytes);
            CmdResourceGroups.this.getAdmin().resourcegroups().updateResourceGroup(this.resourceGroupName, resourcegroup);
        }
    }

    @CommandLine.Command(description={"Deletes an existing ResourceGroup"})
    private class Delete
    extends CliCommand {
        @CommandLine.Parameters(description={"resourcegroup-name"}, arity="1")
        private String resourceGroupName;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            CmdResourceGroups.this.getAdmin().resourcegroups().deleteResourceGroup(this.resourceGroupName);
        }
    }
}

