/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FixedValueFeature;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.BKAsyncLogReader;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.BKSyncLogWriter;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestReader;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.LogWriter;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.BKTransmitException;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.apache.distributedlog.exceptions.IdleReaderException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.exceptions.ReadCancelledException;
import org.apache.distributedlog.exceptions.WriteException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.lock.DistributedLock;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.SimplePermitLimiter;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAsyncReaderWriter
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestAsyncReaderWriter.class);
    protected DistributedLogConfiguration testConf;
    @Rule
    public TestName runtime = new TestName();

    public TestAsyncReaderWriter() {
        this.testConf = new DistributedLogConfiguration();
        this.testConf.loadConf(conf);
        this.testConf.setReaderIdleErrorThresholdMillis(1200000);
        this.testConf.setReadAheadWaitTimeOnEndOfStream(20);
    }

    @Test(timeout=60000L)
    public void testWriteControlRecord() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(1024);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int txid = 1;
        for (long i = 0L; i < 3L; ++i) {
            long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            DLSN dlsn = (DLSN)Utils.ioResult((CompletableFuture)writer.writeControlRecord(new LogRecord((long)txid++, "control".getBytes(StandardCharsets.UTF_8))));
            Assert.assertEquals((long)currentLogSegmentSeqNo, (long)dlsn.getLogSegmentSequenceNo());
            Assert.assertEquals((long)0L, (long)dlsn.getEntryId());
            Assert.assertEquals((long)0L, (long)dlsn.getSlotId());
            for (long j = 1L; j < 10L; ++j) {
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                Utils.ioResult((CompletableFuture)writer.write(record));
            }
            writer.closeAndComplete();
        }
        dlm.close();
        BKDistributedLogManager readDlm = this.createNewDLM(confLocal, name);
        LogReader reader = readDlm.getInputStream(1L);
        long numTrans = 0L;
        long expectedTxId = 2L;
        LogRecordWithDLSN record = reader.readNext(false);
        while (null != record) {
            DLMTestUtil.verifyLargeLogRecord((LogRecord)record);
            ++numTrans;
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            expectedTxId = expectedTxId % 10L == 0L ? (expectedTxId += 2L) : ++expectedTxId;
            record = reader.readNext(false);
        }
        reader.close();
        Assert.assertEquals((long)27L, (long)numTrans);
        Assert.assertEquals((long)27L, (long)readDlm.getLogRecordCount());
        readDlm.close();
    }

    @Test(timeout=60000L)
    public void testAsyncWritePendingWritesAbortedWhenLedgerRollTriggerFails() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(1024);
        confLocal.setMaxLogSegmentBytes(1024L);
        confLocal.setLogSegmentRollingIntervalMinutes(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        int txid = 1;
        LogRecord record = DLMTestUtil.getLogRecordInstance(txid++, 2048);
        CompletableFuture result = writer.write(record);
        DLSN dlsn = (DLSN)Utils.ioResult((CompletableFuture)result, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)dlsn.getLogSegmentSequenceNo());
        record = DLMTestUtil.getLogRecordInstance(txid++, 1040385);
        result = writer.write(record);
        DLMTestUtil.validateFutureFailed(result, LogRecordTooLongException.class);
        record = DLMTestUtil.getLogRecordInstance(txid++, 1040385);
        result = writer.write(record);
        DLMTestUtil.validateFutureFailed(result, WriteException.class);
        record = DLMTestUtil.getLogRecordInstance(txid++, 1040385);
        result = writer.write(record);
        DLMTestUtil.validateFutureFailed(result, WriteException.class);
        writer.closeAndComplete();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncWrite() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(1024);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        final CountDownLatch syncLatch = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
        final AtomicBoolean errorsFound = new AtomicBoolean(false);
        final AtomicReference<DLSN> maxDLSN = new AtomicReference<DLSN>(DLSN.InvalidDLSN);
        int txid = 1;
        for (long i = 0L; i < (long)numLogSegments; ++i) {
            final long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            long j = 0L;
            while (j < (long)numRecordsPerLogSegment) {
                final long currentEntryId = j++;
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                CompletableFuture dlsnFuture = writer.write(record);
                dlsnFuture.whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

                    public void onSuccess(DLSN value) {
                        if (value.getLogSegmentSequenceNo() != currentLogSegmentSeqNo) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("LogSegmentSequenceNumber: {}, Expected {}", (Object)value.getLogSegmentSequenceNo(), (Object)currentLogSegmentSeqNo);
                            }
                            errorsFound.set(true);
                        }
                        if (value.getEntryId() != currentEntryId) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("EntryId: {}, Expected {}", (Object)value.getEntryId(), (Object)currentEntryId);
                            }
                            errorsFound.set(true);
                        }
                        if (value.compareTo((DLSN)maxDLSN.get()) > 0) {
                            maxDLSN.set(value);
                        }
                        syncLatch.countDown();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SyncLatch: {}", (Object)syncLatch.getCount());
                        }
                    }

                    public void onFailure(Throwable cause) {
                        LOG.error("Encountered exception on writing record {} in log segment {}", (Object)currentEntryId, (Object)currentLogSegmentSeqNo);
                        errorsFound.set(true);
                    }
                });
            }
            writer.closeAndComplete();
        }
        syncLatch.await();
        Assert.assertFalse((String)"Should not encounter any errors for async writes", (boolean)errorsFound.get());
        LogRecordWithDLSN last = dlm.getLastLogRecord();
        Assert.assertEquals((String)("Last DLSN" + last.getDlsn() + " isn't the maximum DLSN " + maxDLSN.get()), (Object)last.getDlsn(), (Object)maxDLSN.get());
        Assert.assertEquals((Object)last.getDlsn(), (Object)dlm.getLastDLSN());
        Assert.assertEquals((Object)last.getDlsn(), (Object)Utils.ioResult((CompletableFuture)dlm.getLastDLSNAsync()));
        DLMTestUtil.verifyLargeLogRecord((LogRecord)last);
        dlm.close();
    }

    private static long writeRecords(DistributedLogManager dlm, int numLogSegments, int numRecordsPerLogSegment, long startTxId, boolean emptyRecord) throws IOException {
        long txid = startTxId;
        for (long i = 0L; i < (long)numLogSegments; ++i) {
            BKSyncLogWriter writer = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= (long)numRecordsPerLogSegment; ++j) {
                if (emptyRecord) {
                    writer.write(DLMTestUtil.getEmptyLogRecordInstance(txid++));
                    continue;
                }
                writer.write(DLMTestUtil.getLargeLogRecordInstance(txid++));
            }
            writer.closeAndComplete();
        }
        return txid;
    }

    private static long writeLogSegment(DistributedLogManager dlm, int numRecords, long startTxId, int flushPerNumRecords, boolean emptyRecord) throws IOException {
        long txid = startTxId;
        LogWriter writer = dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= (long)numRecords; ++j) {
            if (emptyRecord) {
                writer.write(DLMTestUtil.getEmptyLogRecordInstance(txid++));
            } else {
                writer.write(DLMTestUtil.getLargeLogRecordInstance(txid++));
            }
            if (j % (long)flushPerNumRecords != 0L) continue;
            writer.flush();
            writer.commit();
        }
        writer.flush();
        writer.commit();
        writer.close();
        return txid;
    }

    private static void readNext(final AsyncLogReader reader, final DLSN startPosition, final long startSequenceId, final boolean monotonic, final CountDownLatch syncLatch, final CountDownLatch completionLatch, final AtomicBoolean errorsFound) {
        CompletableFuture record = reader.readNext();
        record.whenComplete((BiConsumer)new FutureEventListener<LogRecordWithDLSN>(){

            public void onSuccess(LogRecordWithDLSN value) {
                try {
                    if (monotonic) {
                        Assert.assertEquals((long)startSequenceId, (long)value.getSequenceId());
                    } else {
                        Assert.assertTrue((value.getSequenceId() < 0L ? 1 : 0) != 0);
                        Assert.assertTrue((value.getSequenceId() > startSequenceId ? 1 : 0) != 0);
                    }
                    LOG.info("Received record {} from {}", (Object)value, (Object)reader.getStreamName());
                    Assert.assertTrue((!value.isControl() ? 1 : 0) != 0);
                    Assert.assertTrue((value.getDlsn().getSlotId() == 0L ? 1 : 0) != 0);
                    Assert.assertTrue((value.getDlsn().compareTo(startPosition) >= 0 ? 1 : 0) != 0);
                    DLMTestUtil.verifyLargeLogRecord((LogRecord)value);
                }
                catch (Exception exc) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception Encountered when verifying log record {} : ", (Object)value.getDlsn(), (Object)exc);
                    }
                    errorsFound.set(true);
                    completionLatch.countDown();
                    return;
                }
                syncLatch.countDown();
                if (syncLatch.getCount() <= 0L) {
                    completionLatch.countDown();
                } else {
                    TestAsyncReaderWriter.readNext(reader, value.getDlsn().getNextDLSN(), monotonic ? value.getSequenceId() + 1L : value.getSequenceId(), monotonic, syncLatch, completionLatch, errorsFound);
                }
            }

            public void onFailure(Throwable cause) {
                LOG.error("Encountered Exception on reading {}", (Object)reader.getStreamName(), (Object)cause);
                errorsFound.set(true);
                completionLatch.countDown();
            }
        });
    }

    void simpleAsyncReadTest(String name, DistributedLogConfiguration confLocal) throws Exception {
        confLocal.setOutputBufferSize(1024);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, false);
        txid = TestAsyncReaderWriter.writeLogSegment((DistributedLogManager)dlm, 5, txid, 2, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        CountDownLatch syncLatch = new CountDownLatch((int)(txid - 1L));
        CountDownLatch completionLatch = new CountDownLatch(1);
        AtomicBoolean errorsFound = new AtomicBoolean(false);
        boolean monotonic = LogSegmentMetadata.supportsSequenceId((int)confLocal.getDLLedgerMetadataLayoutVersion());
        TestAsyncReaderWriter.readNext(reader, DLSN.InvalidDLSN, monotonic ? 0L : Long.MIN_VALUE, monotonic, syncLatch, completionLatch, errorsFound);
        completionLatch.await();
        Assert.assertFalse((String)"Errors encountered on reading records", (boolean)errorsFound.get());
        syncLatch.await();
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncRead() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        this.simpleAsyncReadTest(name, confLocal);
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncReadWriteWithMonitoredFuturePool() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setTaskExecutionWarnTimeMicros(1000L);
        confLocal.setEnableTaskExecutionStats(true);
        this.simpleAsyncReadTest(name, confLocal);
    }

    @Test(timeout=60000L)
    public void testBulkAsyncRead() throws Exception {
        String name = "distrlog-bulkasyncread";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadMaxRecords(10000);
        confLocal.setReadAheadBatchSize(10);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 20;
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, 1L, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InitialDLSN);
        int expectedTxID = 1;
        int numReads = 0;
        while (expectedTxID <= numLogSegments * numRecordsPerLogSegment && expectedTxID != numLogSegments * numRecordsPerLogSegment) {
            List records = (List)Utils.ioResult((CompletableFuture)reader.readBulk(20));
            LOG.info("Bulk read {} entries.", (Object)records.size());
            Assert.assertTrue((records.size() >= 1 ? 1 : 0) != 0);
            for (LogRecordWithDLSN record : records) {
                Assert.assertEquals((long)expectedTxID, (long)record.getTransactionId());
                ++expectedTxID;
            }
            ++numReads;
        }
        Assert.assertTrue((numReads < 60 ? 1 : 0) != 0);
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testBulkAsyncReadWithWriteBatch() throws Exception {
        String name = "distrlog-bulkasyncread-with-writebatch";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setOutputBufferSize(1024000);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadMaxRecords(10000);
        confLocal.setReadAheadBatchSize(10);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 20;
        TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, 1L, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InitialDLSN);
        int expectedTxID = 1;
        for (long i = 0L; i < 3L; ++i) {
            List records = (List)Utils.ioResult((CompletableFuture)reader.readBulk(20));
            Assert.assertEquals((long)20L, (long)records.size());
            for (LogRecordWithDLSN record : records) {
                Assert.assertEquals((long)expectedTxID, (long)record.getTransactionId());
                ++expectedTxID;
            }
        }
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testAsyncReadEmptyRecords() throws Exception {
        String name = "distrlog-simpleasyncreadempty";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, true);
        txid = TestAsyncReaderWriter.writeLogSegment((DistributedLogManager)dlm, 5, txid, 2, true);
        AsyncLogReader asyncReader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        Assert.assertEquals((String)("Expected stream name = " + name + " but " + asyncReader.getStreamName() + " found"), (Object)name, (Object)asyncReader.getStreamName());
        long numTrans = 0L;
        DLSN lastDLSN = DLSN.InvalidDLSN;
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)asyncReader.readNext());
        while (null != record) {
            DLMTestUtil.verifyEmptyLogRecord((LogRecord)record);
            Assert.assertEquals((long)0L, (long)record.getDlsn().getSlotId());
            Assert.assertTrue((record.getDlsn().compareTo(lastDLSN) > 0 ? 1 : 0) != 0);
            lastDLSN = record.getDlsn();
            if (++numTrans >= txid - 1L) break;
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)asyncReader.readNext());
        }
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
        Utils.close((AsyncCloseable)asyncReader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncReadPosition() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(1024);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, false);
        txid = TestAsyncReaderWriter.writeLogSegment((DistributedLogManager)dlm, 5, txid, Integer.MAX_VALUE, false);
        CountDownLatch syncLatch = new CountDownLatch((int)(txid - 14L));
        CountDownLatch doneLatch = new CountDownLatch(1);
        AtomicBoolean errorsFound = new AtomicBoolean(false);
        AsyncLogReader reader = dlm.getAsyncLogReader(new DLSN(2L, 2L, 4L));
        Assert.assertEquals((Object)name, (Object)reader.getStreamName());
        boolean monotonic = LogSegmentMetadata.supportsSequenceId((int)confLocal.getDLLedgerMetadataLayoutVersion());
        TestAsyncReaderWriter.readNext(reader, new DLSN(2L, 3L, 0L), monotonic ? 13L : Long.MIN_VALUE, monotonic, syncLatch, doneLatch, errorsFound);
        doneLatch.await();
        Assert.assertFalse((String)"Errors found on reading records", (boolean)errorsFound.get());
        syncLatch.await();
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncReadWrite() throws Exception {
        this.testSimpleAsyncReadWriteInternal(this.runtime.getMethodName(), false);
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncReadWriteImmediateFlush() throws Exception {
        this.testSimpleAsyncReadWriteInternal(this.runtime.getMethodName(), true);
    }

    @Test(timeout=60000L)
    public void testNoEnvelopeWriterEnvelopeReader() throws Exception {
        this.testSimpleAsyncReadWriteInternal(this.runtime.getMethodName(), true, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES.value - 1);
    }

    void testSimpleAsyncReadWriteInternal(String name, boolean immediateFlush) throws Exception {
        this.testSimpleAsyncReadWriteInternal(name, immediateFlush, LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
    }

    void testSimpleAsyncReadWriteInternal(String name, boolean immediateFlush, int logSegmentVersion) throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        confLocal.setOutputBufferSize(1024);
        confLocal.setDLLedgerMetadataLayoutVersion(logSegmentVersion);
        confLocal.setImmediateFlushEnabled(immediateFlush);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        CountDownLatch readLatch = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
        CountDownLatch readDoneLatch = new CountDownLatch(1);
        AtomicBoolean readErrors = new AtomicBoolean(false);
        CountDownLatch writeLatch = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
        AtomicBoolean writeErrors = new AtomicBoolean(false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        Assert.assertEquals((Object)name, (Object)reader.getStreamName());
        int txid = 1;
        for (long i = 0L; i < 3L; ++i) {
            long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            for (long j = 0L; j < 10L; ++j) {
                long currentEntryId = j;
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                CompletableFuture dlsnFuture = writer.write(record);
                dlsnFuture.whenComplete((BiConsumer)((Object)new WriteFutureEventListener(record, currentLogSegmentSeqNo, currentEntryId, writeLatch, writeErrors, true)));
                if (i != 0L || j != 0L) continue;
                boolean monotonic = LogSegmentMetadata.supportsSequenceId((int)logSegmentVersion);
                TestAsyncReaderWriter.readNext(reader, DLSN.InvalidDLSN, monotonic ? 0L : Long.MIN_VALUE, monotonic, readLatch, readDoneLatch, readErrors);
            }
            writer.closeAndComplete();
        }
        writeLatch.await();
        Assert.assertFalse((String)"All writes should succeed", (boolean)writeErrors.get());
        readDoneLatch.await();
        Assert.assertFalse((String)"All reads should succeed", (boolean)readErrors.get());
        readLatch.await();
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncReadWriteStartEmpty() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        confLocal.setOutputBufferSize(1024);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        CountDownLatch readerReadyLatch = new CountDownLatch(1);
        CountDownLatch readerDoneLatch = new CountDownLatch(1);
        CountDownLatch readerSyncLatch = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
        TestReader reader = new TestReader("test-reader", (DistributedLogManager)dlm, DLSN.InitialDLSN, false, 0, readerReadyLatch, readerSyncLatch, readerDoneLatch);
        reader.start();
        Thread.sleep(500L);
        AtomicBoolean writeErrors = new AtomicBoolean(false);
        CountDownLatch writeLatch = new CountDownLatch(30);
        int txid = 1;
        for (long i = 0L; i < 3L; ++i) {
            long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            long j = 0L;
            while (j < 10L) {
                long currentEntryId = j++;
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                CompletableFuture dlsnFuture = writer.write(record);
                dlsnFuture.whenComplete((BiConsumer)((Object)new WriteFutureEventListener(record, currentLogSegmentSeqNo, currentEntryId, writeLatch, writeErrors, true)));
            }
            writer.closeAndComplete();
        }
        writeLatch.await();
        Assert.assertFalse((String)"All writes should succeed", (boolean)writeErrors.get());
        readerDoneLatch.await();
        Assert.assertFalse((String)"Should not encounter errors during reading", (boolean)reader.areErrorsFound());
        readerSyncLatch.await();
        Assert.assertTrue((String)"Should position reader at least once", (reader.getNumReaderPositions().get() > 1 ? 1 : 0) != 0);
        reader.stop();
        dlm.close();
    }

    @Ignore
    @Test(timeout=120000L)
    public void testSimpleAsyncReadWriteStartEmptyFactory() throws Exception {
        int s;
        int count = 1;
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        confLocal.setOutputBufferSize(1024);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 1;
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).build();
        DistributedLogManager[] dlms = new DistributedLogManager[count];
        TestReader[] readers = new TestReader[count];
        CountDownLatch readyLatch = new CountDownLatch(count);
        CountDownLatch[] syncLatches = new CountDownLatch[count];
        CountDownLatch[] readerDoneLatches = new CountDownLatch[count];
        for (int s2 = 0; s2 < count; ++s2) {
            dlms[s2] = namespace.openLog(name + String.format("%d", s2));
            readerDoneLatches[s2] = new CountDownLatch(1);
            syncLatches[s2] = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
            readers[s2] = new TestReader("reader-" + s2, dlms[s2], DLSN.InitialDLSN, false, 0, readyLatch, syncLatches[s2], readerDoneLatches[s2]);
            readers[s2].start();
        }
        readyLatch.await();
        CountDownLatch writeLatch = new CountDownLatch(3 * count);
        AtomicBoolean writeErrors = new AtomicBoolean(false);
        int txid = 1;
        for (long i = 0L; i < 3L; ++i) {
            int s3;
            long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter[] writers = new BKAsyncLogWriter[count];
            for (s3 = 0; s3 < count; ++s3) {
                writers[s3] = (BKAsyncLogWriter)dlms[s3].startAsyncLogSegmentNonPartitioned();
            }
            for (long j = 0L; j < 1L; ++j) {
                long currentEntryId = j;
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                for (int s4 = 0; s4 < count; ++s4) {
                    CompletableFuture dlsnFuture = writers[s4].write(record);
                    dlsnFuture.whenComplete((BiConsumer)((Object)new WriteFutureEventListener(record, currentLogSegmentSeqNo, currentEntryId, writeLatch, writeErrors, true)));
                }
            }
            for (s3 = 0; s3 < count; ++s3) {
                writers[s3].closeAndComplete();
            }
        }
        writeLatch.await();
        Assert.assertFalse((String)"All writes should succeed", (boolean)writeErrors.get());
        for (s = 0; s < count; ++s) {
            readerDoneLatches[s].await();
            Assert.assertFalse((String)("Reader " + s + " should not encounter errors"), (boolean)readers[s].areErrorsFound());
            syncLatches[s].await();
            Assert.assertEquals((long)(numLogSegments * numRecordsPerLogSegment), (long)readers[s].getNumReads().get());
            Assert.assertTrue((String)("Reader " + s + " should position at least once"), (readers[s].getNumReaderPositions().get() > 0 ? 1 : 0) != 0);
        }
        for (s = 0; s < count; ++s) {
            readers[s].stop();
            dlms[s].close();
        }
    }

    @Test(timeout=300000L)
    public void testSimpleAsyncReadWriteSimulateErrors() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(10);
        confLocal.setOutputBufferSize(1024);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 5;
        int numRecordsPerLogSegment = 10;
        CountDownLatch doneLatch = new CountDownLatch(1);
        CountDownLatch syncLatch = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
        TestReader reader = new TestReader("test-reader", (DistributedLogManager)dlm, DLSN.InitialDLSN, true, 0, new CountDownLatch(1), syncLatch, doneLatch);
        reader.start();
        CountDownLatch writeLatch = new CountDownLatch(numLogSegments * numRecordsPerLogSegment);
        AtomicBoolean writeErrors = new AtomicBoolean(false);
        int txid = 1;
        for (long i = 0L; i < (long)numLogSegments; ++i) {
            long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            long j = 0L;
            while (j < (long)numRecordsPerLogSegment) {
                long currentEntryId = j++;
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                CompletableFuture dlsnFuture = writer.write(record);
                dlsnFuture.whenComplete((BiConsumer)((Object)new WriteFutureEventListener(record, currentLogSegmentSeqNo, currentEntryId, writeLatch, writeErrors, true)));
            }
            writer.closeAndComplete();
        }
        writeLatch.await();
        Assert.assertFalse((String)"All writes should succeed", (boolean)writeErrors.get());
        doneLatch.await();
        Assert.assertFalse((String)"Should not encounter errors during reading", (boolean)reader.areErrorsFound());
        syncLatch.await();
        Assert.assertTrue((String)"Should position reader at least once", (reader.getNumReaderPositions().get() > 1 ? 1 : 0) != 0);
        reader.stop();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testSimpleAsyncReadWritePiggyBack() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setEnableReadAhead(true);
        confLocal.setReadAheadWaitTime(500);
        confLocal.setReadAheadBatchSize(10);
        confLocal.setReadAheadMaxRecords(100);
        confLocal.setOutputBufferSize(1024);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(100);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        CountDownLatch readLatch = new CountDownLatch(30);
        CountDownLatch readDoneLatch = new CountDownLatch(1);
        AtomicBoolean readErrors = new AtomicBoolean(false);
        CountDownLatch writeLatch = new CountDownLatch(30);
        AtomicBoolean writeErrors = new AtomicBoolean(false);
        int txid = 1;
        for (long i = 0L; i < (long)numLogSegments; ++i) {
            long currentLogSegmentSeqNo = i + 1L;
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            for (long j = 0L; j < (long)numRecordsPerLogSegment; ++j) {
                Thread.sleep(50L);
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                CompletableFuture dlsnFuture = writer.write(record);
                dlsnFuture.whenComplete((BiConsumer)((Object)new WriteFutureEventListener(record, currentLogSegmentSeqNo, j, writeLatch, writeErrors, false)));
                if (i != 0L || j != 0L) continue;
                boolean monotonic = LogSegmentMetadata.supportsSequenceId((int)confLocal.getDLLedgerMetadataLayoutVersion());
                TestAsyncReaderWriter.readNext(reader, DLSN.InvalidDLSN, monotonic ? 0L : Long.MIN_VALUE, monotonic, readLatch, readDoneLatch, readErrors);
            }
            writer.closeAndComplete();
        }
        writeLatch.await();
        Assert.assertFalse((String)"All writes should succeed", (boolean)writeErrors.get());
        readDoneLatch.await();
        Assert.assertFalse((String)"All reads should succeed", (boolean)readErrors.get());
        readLatch.await();
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testCancelReadRequestOnReaderClosed() throws Exception {
        String name = "distrlog-cancel-read-requests-on-reader-closed";
        BKDistributedLogManager dlm = this.createNewDLM(this.testConf, "distrlog-cancel-read-requests-on-reader-closed");
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.closeAndComplete();
        final AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InitialDLSN);
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
        Assert.assertEquals((long)1L, (long)record.getTransactionId());
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        final CountDownLatch readLatch = new CountDownLatch(1);
        final AtomicBoolean receiveExpectedException = new AtomicBoolean(false);
        Thread readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.ioResult((CompletableFuture)reader.readNext());
                }
                catch (ReadCancelledException rce) {
                    receiveExpectedException.set(true);
                }
                catch (Throwable t) {
                    LOG.error("Receive unexpected exception on reading stream {} : ", (Object)"distrlog-cancel-read-requests-on-reader-closed", (Object)t);
                }
                readLatch.countDown();
            }
        }, "read-thread");
        readThread.start();
        Thread.sleep(1000L);
        Utils.close((AsyncCloseable)reader);
        readLatch.await();
        readThread.join();
        Assert.assertTrue((String)"Read request should be cancelled.", (boolean)receiveExpectedException.get());
        try {
            Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.fail((String)"Reader should reject readNext if it is closed.");
        }
        catch (ReadCancelledException readCancelledException) {
            // empty catch block
        }
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testAsyncWriteWithMinDelayBetweenFlushes() throws Exception {
        String name = "distrlog-asyncwrite-mindelay";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setMinDelayBetweenImmediateFlushMs(100);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        final Thread currentThread = Thread.currentThread();
        int count = 5000;
        final CountDownLatch syncLatch = new CountDownLatch(5000);
        int txid = 1;
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        Stopwatch executionTime = Stopwatch.createStarted();
        for (long i = 0L; i < 5000L; ++i) {
            Thread.sleep(1L);
            LogRecord record = DLMTestUtil.getLogRecordInstance(txid++);
            CompletableFuture dlsnFuture = writer.write(record);
            dlsnFuture.whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

                public void onSuccess(DLSN value) {
                    syncLatch.countDown();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SyncLatch: {} ; DLSN: {} ", (Object)syncLatch.getCount(), (Object)value);
                    }
                }

                public void onFailure(Throwable cause) {
                    currentThread.interrupt();
                }
            });
        }
        boolean success = false;
        if (!Thread.interrupted()) {
            try {
                success = syncLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
            }
        }
        writer.abort();
        executionTime.stop();
        Assert.assertTrue((!Thread.interrupted() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)success);
        LogRecordWithDLSN last = dlm.getLastLogRecord();
        LOG.info("Last Entry {}; elapsed time {}", (Object)last.getDlsn().getEntryId(), (Object)executionTime.elapsed(TimeUnit.MILLISECONDS));
        Assert.assertTrue((last.getDlsn().getEntryId() <= (executionTime.elapsed(TimeUnit.MILLISECONDS) / (long)confLocal.getMinDelayBetweenImmediateFlushMs() + 1L) * 2L ? 1 : 0) != 0);
        DLMTestUtil.verifyLogRecord((LogRecord)last);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testAsyncWriteWithMinDelayBetweenFlushesFlushFailure() throws Exception {
        BKAsyncLogWriter writer;
        DistributedLogManager dlm;
        block2: {
            String name = this.runtime.getMethodName();
            DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
            confLocal.loadConf(this.testConf);
            confLocal.setOutputBufferSize(0);
            confLocal.setImmediateFlushEnabled(true);
            confLocal.setMinDelayBetweenImmediateFlushMs(1);
            URI uri = this.createDLMURI("/" + name);
            this.ensureURICreated(uri);
            Namespace namespace = NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).clientId("gabbagoo").build();
            dlm = namespace.openLog(name);
            Namespace namespace1 = NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).clientId("tortellini").build();
            DistributedLogManager dlm1 = namespace1.openLog(name);
            int txid = 1;
            writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid++)));
            writer.flushAndCommit();
            BKLogSegmentWriter perStreamWriter = writer.getCachedLogWriter();
            DistributedLock lock = perStreamWriter.getLock();
            Utils.ioResult((CompletableFuture)lock.asyncClose());
            BKAsyncLogWriter writer2 = (BKAsyncLogWriter)dlm1.startAsyncLogSegmentNonPartitioned();
            try {
                writer.write(DLMTestUtil.getLogRecordInstance(txid++));
                Thread.sleep(100L);
                Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid++)));
                Assert.fail((String)"should have thrown");
            }
            catch (LockingException ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("caught exception ", (Throwable)ex);
            }
        }
        writer.close();
        dlm.close();
    }

    public void writeRecordsWithOutstandingWriteLimit(int stream, int global, boolean shouldFail) throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setPerWriterOutstandingWriteLimit(stream);
        confLocal.setOutstandingWriteLimitDarkmode(false);
        BKDistributedLogManager dlm = global > -1 ? this.createNewDLM(confLocal, this.runtime.getMethodName(), (PermitLimiter)new SimplePermitLimiter(false, global, (StatsLogger)new NullStatsLogger(), true, (Feature)new FixedValueFeature("", 0))) : this.createNewDLM(confLocal, this.runtime.getMethodName());
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        ArrayList<CompletableFuture> results = new ArrayList<CompletableFuture>(1000);
        for (int i = 0; i < 1000; ++i) {
            results.add(writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        }
        for (CompletableFuture result : results) {
            try {
                Utils.ioResult((CompletableFuture)result);
                if (!shouldFail) continue;
                Assert.fail((String)"should fail due to no outstanding writes permitted");
            }
            catch (OverCapacityException ex) {
                Assert.assertTrue((boolean)shouldFail);
            }
        }
        writer.closeAndComplete();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testOutstandingWriteLimitNoLimit() throws Exception {
        this.writeRecordsWithOutstandingWriteLimit(-1, -1, false);
    }

    @Test(timeout=60000L)
    public void testOutstandingWriteLimitVeryHighLimit() throws Exception {
        this.writeRecordsWithOutstandingWriteLimit(Integer.MAX_VALUE, Integer.MAX_VALUE, false);
    }

    @Test(timeout=60000L)
    public void testOutstandingWriteLimitBlockAllStreamLimit() throws Exception {
        this.writeRecordsWithOutstandingWriteLimit(0, Integer.MAX_VALUE, true);
    }

    @Test(timeout=60000L)
    public void testOutstandingWriteLimitBlockAllGlobalLimit() throws Exception {
        this.writeRecordsWithOutstandingWriteLimit(Integer.MAX_VALUE, 0, true);
    }

    @Test(timeout=60000L)
    public void testOutstandingWriteLimitBlockAllLimitWithDarkmode() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setPerWriterOutstandingWriteLimit(0);
        confLocal.setOutstandingWriteLimitDarkmode(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, this.runtime.getMethodName());
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        ArrayList<CompletableFuture> results = new ArrayList<CompletableFuture>(1000);
        for (int i = 0; i < 1000; ++i) {
            results.add(writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        }
        for (CompletableFuture result : results) {
            Utils.ioResult((CompletableFuture)result);
        }
        writer.closeAndComplete();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testCloseAndCompleteLogSegmentWhenStreamIsInError() throws Exception {
        String name = "distrlog-close-and-complete-logsegment-when-stream-is-in-error";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        long txId = 1L;
        for (int i = 0; i < 5; ++i) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txId++)));
        }
        BKLogSegmentWriter logWriter = writer.getCachedLogWriter();
        BKNamespaceDriver driver = (BKNamespaceDriver)dlm.getNamespaceDriver();
        driver.getReaderBKC().get().openLedger(logWriter.getLogSegmentId(), BookKeeper.DigestType.CRC32, confLocal.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
        try {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txId++)));
            Assert.fail((String)"Should fail write to a fenced ledger with BKTransmitException");
        }
        catch (BKTransmitException bKTransmitException) {
            // empty catch block
        }
        try {
            writer.closeAndComplete();
            Assert.fail((String)"Should fail to complete a log segment when its ledger is fenced");
        }
        catch (BKTransmitException bKTransmitException) {
            // empty catch block
        }
        List segments = dlm.getLogSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((boolean)((LogSegmentMetadata)segments.get(0)).isInProgress());
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testCloseAndCompleteLogSegmentWhenCloseFailed() throws Exception {
        String name = "distrlog-close-and-complete-logsegment-when-close-failed";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        long txId = 1L;
        for (int i = 0; i < 5; ++i) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txId++)));
        }
        BKLogSegmentWriter logWriter = writer.getCachedLogWriter();
        BKNamespaceDriver driver = (BKNamespaceDriver)dlm.getNamespaceDriver();
        driver.getReaderBKC().get().openLedger(logWriter.getLogSegmentId(), BookKeeper.DigestType.CRC32, confLocal.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
        try {
            writer.write(DLMTestUtil.getLogRecordInstance(txId++));
            writer.closeAndComplete();
            Assert.fail((String)"Should fail to complete a log segment when its ledger is fenced");
        }
        catch (IOException ioe) {
            LOG.error("Failed to close and complete log segment {} : ", (Object)logWriter.getFullyQualifiedLogSegment(), (Object)ioe);
        }
        List segments = dlm.getLogSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((boolean)((LogSegmentMetadata)segments.get(0)).isInProgress());
        dlm.close();
    }

    private void testAsyncReadIdleErrorInternal(String name, int idleReaderErrorThreshold, boolean heartBeatUsingControlRecs, boolean simulateReaderStall) throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadBatchSize(1);
        confLocal.setReadAheadMaxRecords(1);
        confLocal.setReaderIdleWarnThresholdMillis(0);
        confLocal.setReaderIdleErrorThresholdMillis(idleReaderErrorThreshold);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        Thread currentThread = Thread.currentThread();
        int segmentSize = 3;
        int numSegments = 3;
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.schedule(new Runnable((DistributedLogManager)dlm, latch, heartBeatUsingControlRecs, idleReaderErrorThreshold, executor, currentThread){
            final /* synthetic */ DistributedLogManager val$dlm;
            final /* synthetic */ CountDownLatch val$latch;
            final /* synthetic */ boolean val$heartBeatUsingControlRecs;
            final /* synthetic */ int val$idleReaderErrorThreshold;
            final /* synthetic */ ScheduledThreadPoolExecutor val$executor;
            final /* synthetic */ Thread val$currentThread;
            {
                this.val$dlm = distributedLogManager;
                this.val$latch = countDownLatch;
                this.val$heartBeatUsingControlRecs = bl;
                this.val$idleReaderErrorThreshold = n;
                this.val$executor = scheduledThreadPoolExecutor;
                this.val$currentThread = thread;
            }

            @Override
            public void run() {
                block6: {
                    try {
                        int txid = 1;
                        for (long i = 0L; i < 3L; ++i) {
                            long start = txid;
                            BKSyncLogWriter writer = (BKSyncLogWriter)this.val$dlm.startLogSegmentNonPartitioned();
                            for (long j = 1L; j <= 3L; ++j) {
                                writer.write(DLMTestUtil.getLargeLogRecordInstance(txid++));
                                if (i != 0L || j != 1L) continue;
                                this.val$latch.countDown();
                            }
                            if (this.val$heartBeatUsingControlRecs) {
                                int threadSleepTime = this.val$idleReaderErrorThreshold - 200 - 100;
                                for (int iter = 1; iter <= 2 * this.val$idleReaderErrorThreshold / threadSleepTime; ++iter) {
                                    Thread.sleep(threadSleepTime);
                                    writer.write(DLMTestUtil.getLargeLogRecordInstance(txid, true));
                                    writer.flush();
                                }
                                Thread.sleep(threadSleepTime);
                            }
                            writer.closeAndComplete();
                            if (this.val$heartBeatUsingControlRecs) continue;
                            Thread.sleep(2 * this.val$idleReaderErrorThreshold);
                        }
                    }
                    catch (Exception exc) {
                        if (this.val$executor.isShutdown()) break block6;
                        this.val$currentThread.interrupt();
                    }
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        latch.await();
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        if (simulateReaderStall) {
            reader.disableProcessingReadRequests();
        }
        boolean exceptionEncountered = false;
        int recordCount = 0;
        try {
            do {
                CompletableFuture record = reader.readNext();
                Utils.ioResult((CompletableFuture)record);
            } while (++recordCount < 9);
        }
        catch (IdleReaderException exc) {
            exceptionEncountered = true;
        }
        if (simulateReaderStall) {
            Assert.assertTrue((boolean)exceptionEncountered);
        } else if (heartBeatUsingControlRecs) {
            Assert.assertFalse((boolean)exceptionEncountered);
            Assert.assertEquals((long)9L, (long)recordCount);
        } else {
            Assert.assertTrue((boolean)exceptionEncountered);
            Assert.assertEquals((long)3L, (long)recordCount);
        }
        Assert.assertFalse((boolean)currentThread.isInterrupted());
        Utils.close((AsyncCloseable)reader);
        executor.shutdown();
    }

    @Test(timeout=10000L)
    public void testAsyncReadIdleControlRecord() throws Exception {
        String name = "distrlog-async-reader-idle-error-control";
        this.testAsyncReadIdleErrorInternal(name, 500, true, false);
    }

    @Test(timeout=10000L)
    public void testAsyncReadIdleError() throws Exception {
        String name = "distrlog-async-reader-idle-error";
        this.testAsyncReadIdleErrorInternal(name, 1000, false, false);
    }

    @Test(timeout=10000L)
    public void testAsyncReadIdleError2() throws Exception {
        String name = "distrlog-async-reader-idle-error-2";
        this.testAsyncReadIdleErrorInternal(name, 1000, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReleaseLockAfterFailedToRecover() throws Exception {
        String name = "release-lock-after-failed-to-recover";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setLockTimeout(0L);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setOutputBufferSize(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        writer.abort();
        for (int i = 0; i < 2; ++i) {
            FailpointUtils.setFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_RecoverIncompleteLogSegments, (FailpointUtils.FailPointActions)FailpointUtils.FailPointActions.FailPointAction_Throw);
            try {
                dlm.startAsyncLogSegmentNonPartitioned();
                Assert.fail((String)"Should fail during recovering incomplete log segments");
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                FailpointUtils.removeFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_RecoverIncompleteLogSegments);
            }
        }
        writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        List segments = dlm.getLogSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertFalse((boolean)((LogSegmentMetadata)segments.get(0)).isInProgress());
        writer.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testAsyncReadMissingLogSegmentsNotification() throws Exception {
        String name = "distrlog-async-reader-missing-zk-notification";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadBatchSize(1);
        confLocal.setReadAheadMaxRecords(1);
        confLocal.setReadLACLongPollTimeout(49);
        confLocal.setReaderIdleWarnThresholdMillis(100);
        confLocal.setReaderIdleErrorThresholdMillis(20000);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        Thread currentThread = Thread.currentThread();
        int segmentSize = 10;
        int numSegments = 3;
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch readLatch = new CountDownLatch(1);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.schedule(new Runnable((DistributedLogManager)dlm, latch, readLatch, executor, currentThread){
            final /* synthetic */ DistributedLogManager val$dlm;
            final /* synthetic */ CountDownLatch val$latch;
            final /* synthetic */ CountDownLatch val$readLatch;
            final /* synthetic */ ScheduledThreadPoolExecutor val$executor;
            final /* synthetic */ Thread val$currentThread;
            {
                this.val$dlm = distributedLogManager;
                this.val$latch = countDownLatch;
                this.val$readLatch = countDownLatch2;
                this.val$executor = scheduledThreadPoolExecutor;
                this.val$currentThread = thread;
            }

            @Override
            public void run() {
                block5: {
                    try {
                        int txid = 1;
                        for (long i = 0L; i < 3L; ++i) {
                            BKSyncLogWriter writer = (BKSyncLogWriter)this.val$dlm.startLogSegmentNonPartitioned();
                            for (long j = 1L; j <= 10L; ++j) {
                                writer.write(DLMTestUtil.getLargeLogRecordInstance(txid++));
                                if (i == 0L && j == 1L) {
                                    this.val$latch.countDown();
                                    continue;
                                }
                                this.val$readLatch.await();
                            }
                            writer.closeAndComplete();
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception exc) {
                        if (this.val$executor.isShutdown()) break block5;
                        this.val$currentThread.interrupt();
                    }
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        latch.await();
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        reader.disableReadAheadLogSegmentsNotification();
        boolean exceptionEncountered = false;
        int recordCount = 0;
        try {
            do {
                CompletableFuture record = reader.readNext();
                Utils.ioResult((CompletableFuture)record);
                if (recordCount != 0) continue;
                readLatch.countDown();
            } while (++recordCount < 30);
        }
        catch (IdleReaderException exc) {
            exceptionEncountered = true;
        }
        Assert.assertTrue((!exceptionEncountered ? 1 : 0) != 0);
        Assert.assertEquals((long)recordCount, (long)30L);
        Assert.assertTrue((!currentThread.isInterrupted() ? 1 : 0) != 0);
        Utils.close((AsyncCloseable)reader);
        executor.shutdown();
    }

    @Test(timeout=60000L)
    public void testGetLastTxId() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        int numRecords = 10;
        for (int i = 0; i < numRecords; ++i) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(i)));
            Assert.assertEquals((String)("last tx id should become " + i), (long)i, (long)writer.getLastTxId());
        }
        AsyncLogWriter recoverWriter = dlm.startAsyncLogSegmentNonPartitioned();
        Assert.assertEquals((String)("recovered last tx id should be " + (numRecords - 1)), (long)(numRecords - 1), (long)recoverWriter.getLastTxId());
    }

    @Test(timeout=60000L)
    public void testMaxReadAheadRecords() throws Exception {
        int maxRecords = 1;
        int batchSize = 8;
        int maxAllowedCachedRecords = maxRecords + batchSize - 1;
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(Integer.MAX_VALUE);
        confLocal.setReadAheadMaxRecords(maxRecords);
        confLocal.setReadAheadBatchSize(batchSize);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        int numRecords = 40;
        for (int i = 1; i <= numRecords; ++i) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(i)));
            Assert.assertEquals((String)("last tx id should become " + i), (long)i, (long)writer.getLastTxId());
        }
        LogRecord record = DLMTestUtil.getLogRecordInstance(numRecords);
        record.setControl();
        Utils.ioResult((CompletableFuture)writer.write(record));
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        record = (LogRecord)Utils.ioResult((CompletableFuture)reader.readNext());
        LOG.info("Read record {}", (Object)record);
        Assert.assertEquals((long)1L, (long)record.getTransactionId());
        Assert.assertNotNull((Object)reader.getReadAheadReader());
        Assert.assertTrue((reader.getReadAheadReader().getNumCachedEntries() <= maxAllowedCachedRecords ? 1 : 0) != 0);
        for (int i = 2; i <= numRecords; ++i) {
            record = (LogRecord)Utils.ioResult((CompletableFuture)reader.readNext());
            LOG.info("Read record {}", (Object)record);
            Assert.assertEquals((long)i, (long)record.getTransactionId());
            TimeUnit.MILLISECONDS.sleep(20L);
            int numCachedEntries = reader.getReadAheadReader().getNumCachedEntries();
            Assert.assertTrue((String)("Should cache less than " + batchSize + " records but already found " + numCachedEntries + " records when reading " + i + "th record"), (numCachedEntries <= maxAllowedCachedRecords ? 1 : 0) != 0);
        }
        Utils.close((AsyncCloseable)reader);
    }

    @Test(timeout=60000L)
    public void testMarkEndOfStream() throws Exception {
        int i;
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        int numRecords = 10;
        for (i = 1; i <= 10; ++i) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(i)));
            Assert.assertEquals((String)("last tx id should become " + i), (long)i, (long)writer.getLastTxId());
        }
        Utils.ioResult((CompletableFuture)writer.markEndOfStream());
        Utils.ioResult((CompletableFuture)writer.markEndOfStream());
        try {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(i)));
            Assert.fail((String)"Should have thrown");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        LogRecord record = null;
        for (int j = 0; j < 10; ++j) {
            record = (LogRecord)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.assertEquals((long)(j + 1), (long)record.getTransactionId());
        }
        try {
            record = (LogRecord)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.fail((String)"Should have thrown");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)reader);
    }

    @Test(timeout=60000L)
    public void testMarkEndOfStreamAtBeginningOfSegment() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.markEndOfStream());
        try {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
            Assert.fail((String)"Should have thrown");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
        writer.close();
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        try {
            LogRecord record = (LogRecord)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.fail((String)"Should have thrown");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)reader);
    }

    @Test(timeout=60000L)
    public void testBulkReadWaitingMoreRecords() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        LogRecord controlRecord = DLMTestUtil.getLogRecordInstance(1L);
        controlRecord.setControl();
        Utils.ioResult((CompletableFuture)writer.write(controlRecord));
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        CompletableFuture bulkReadFuture = reader.readBulk(2, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        CompletableFuture readFuture = reader.readNext();
        for (int i = 0; i < 5; ++i) {
            long txid = 2L + (long)i;
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid)));
            controlRecord = DLMTestUtil.getLogRecordInstance(txid);
            controlRecord.setControl();
            Utils.ioResult((CompletableFuture)writer.write(controlRecord));
        }
        List bulkReadRecords = (List)Utils.ioResult((CompletableFuture)bulkReadFuture);
        Assert.assertEquals((long)2L, (long)bulkReadRecords.size());
        Assert.assertEquals((long)1L, (long)((LogRecordWithDLSN)bulkReadRecords.get(0)).getTransactionId());
        Assert.assertEquals((long)2L, (long)((LogRecordWithDLSN)bulkReadRecords.get(1)).getTransactionId());
        for (LogRecordWithDLSN record : bulkReadRecords) {
            DLMTestUtil.verifyLogRecord((LogRecord)record);
        }
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)readFuture);
        Assert.assertEquals((long)3L, (long)record.getTransactionId());
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        Utils.close((AsyncCloseable)reader);
        writer.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testBulkReadNotWaitingMoreRecords() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        LogRecord controlRecord = DLMTestUtil.getLogRecordInstance(1L);
        controlRecord.setControl();
        Utils.ioResult((CompletableFuture)writer.write(controlRecord));
        BKAsyncLogReader reader = (BKAsyncLogReader)dlm.getAsyncLogReader(DLSN.InitialDLSN);
        CompletableFuture bulkReadFuture = reader.readBulk(2, 0L, TimeUnit.MILLISECONDS);
        CompletableFuture readFuture = reader.readNext();
        List bulkReadRecords = (List)Utils.ioResult((CompletableFuture)bulkReadFuture);
        Assert.assertEquals((long)1L, (long)bulkReadRecords.size());
        Assert.assertEquals((long)1L, (long)((LogRecordWithDLSN)bulkReadRecords.get(0)).getTransactionId());
        for (LogRecordWithDLSN record : bulkReadRecords) {
            DLMTestUtil.verifyLogRecord((LogRecord)record);
        }
        for (int i = 0; i < 5; ++i) {
            long txid = 2L + (long)i;
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid)));
            controlRecord = DLMTestUtil.getLogRecordInstance(txid);
            controlRecord.setControl();
            Utils.ioResult((CompletableFuture)writer.write(controlRecord));
        }
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)readFuture);
        Assert.assertEquals((long)2L, (long)record.getTransactionId());
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        Utils.close((AsyncCloseable)reader);
        writer.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadBrokenEntries() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(1);
        confLocal.setPositionGapDetectionEnabled(false);
        confLocal.setReadAheadSkipBrokenEntries(true);
        confLocal.setEIInjectReadAheadBrokenEntries(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 10;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        for (int i = 0; i < 27; ++i) {
            LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.assertFalse((record.getDlsn().getEntryId() % 10L == 0L ? 1 : 0) != 0);
        }
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadBrokenEntriesWithGapDetection() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(1);
        confLocal.setPositionGapDetectionEnabled(true);
        confLocal.setReadAheadSkipBrokenEntries(true);
        confLocal.setEIInjectReadAheadBrokenEntries(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 1;
        int numRecordsPerLogSegment = 100;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        try {
            for (int i = 0; i < 30; ++i) {
                LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
                Assert.assertFalse((record.getDlsn().getEntryId() % 10L == 0L ? 1 : 0) != 0);
            }
            Assert.fail((String)"should have thrown");
        }
        catch (DLIllegalStateException dLIllegalStateException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadBrokenEntriesAndLargeBatchSize() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(5);
        confLocal.setPositionGapDetectionEnabled(false);
        confLocal.setReadAheadSkipBrokenEntries(true);
        confLocal.setEIInjectReadAheadBrokenEntries(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 1;
        int numRecordsPerLogSegment = 100;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        for (int i = 0; i < 50; ++i) {
            LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.assertFalse((record.getDlsn().getEntryId() % 10L == 0L ? 1 : 0) != 0);
        }
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadBrokenEntriesAndLargeBatchSizeCrossSegment() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setReadAheadWaitTime(10);
        confLocal.setReadAheadBatchSize(8);
        confLocal.setPositionGapDetectionEnabled(false);
        confLocal.setReadAheadSkipBrokenEntries(true);
        confLocal.setEIInjectReadAheadBrokenEntries(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        int numLogSegments = 3;
        int numRecordsPerLogSegment = 5;
        long txid = 1L;
        txid = TestAsyncReaderWriter.writeRecords((DistributedLogManager)dlm, numLogSegments, numRecordsPerLogSegment, txid, false);
        AsyncLogReader reader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        for (int i = 0; i < 12; ++i) {
            LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.assertFalse((record.getDlsn().getEntryId() % 10L == 0L ? 1 : 0) != 0);
        }
        Utils.close((AsyncCloseable)reader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testCreateLogStreamWithDifferentReplicationFactor() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        ConcurrentConstConfiguration baseConf = new ConcurrentConstConfiguration((Configuration)confLocal);
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration((ConcurrentBaseConfiguration)baseConf);
        dynConf.setProperty("bkcEnsembleSize", (Object)2);
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).build();
        DistributedLogManager dlm = namespace.openLog(name + "-pool");
        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        List segments = dlm.getLogSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        long ledgerId = ((LogSegmentMetadata)segments.get(0)).getLogSegmentId();
        LedgerHandle lh = ((BKNamespaceDriver)namespace.getNamespaceDriver()).getReaderBKC().get().openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.CRC32, confLocal.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
        LedgerMetadata metadata = lh.getLedgerMetadata();
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        lh.close();
        Utils.close((AsyncCloseable)writer);
        dlm.close();
        dlm = namespace.openLog(name + "-custom", Optional.empty(), Optional.of(dynConf), Optional.empty());
        writer = dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        segments = dlm.getLogSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        ledgerId = ((LogSegmentMetadata)segments.get(0)).getLogSegmentId();
        lh = ((BKNamespaceDriver)namespace.getNamespaceDriver()).getReaderBKC().get().openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.CRC32, confLocal.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
        metadata = lh.getLedgerMetadata();
        Assert.assertEquals((long)2L, (long)metadata.getEnsembleSize());
        lh.close();
        Utils.close((AsyncCloseable)writer);
        dlm.close();
        namespace.close();
    }

    @Test(timeout=60000L)
    public void testWriteRecordSet() throws Exception {
        int i;
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        ArrayList writeFutures = Lists.newArrayList();
        for (int i2 = 0; i2 < 5; ++i2) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(1L + (long)i2);
            writeFutures.add(writer.write(record));
        }
        ArrayList recordSetFutures = Lists.newArrayList();
        final LogRecordSet.Writer recordSetWriter = LogRecordSet.newWriter((int)4096, (CompressionCodec.Type)CompressionCodec.Type.LZ4);
        for (int i3 = 0; i3 < 5; ++i3) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(6L + (long)i3);
            CompletableFuture writePromise = new CompletableFuture();
            recordSetWriter.writeRecord(ByteBuffer.wrap(record.getPayload()), writePromise);
            recordSetFutures.add(writePromise);
        }
        ByteBuf recordSetBuffer = recordSetWriter.getBuffer();
        LogRecord setRecord = new LogRecord(6L, recordSetBuffer);
        setRecord.setRecordSet();
        CompletableFuture writeRecordSetFuture = writer.write(setRecord);
        writeRecordSetFuture.whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

            public void onSuccess(DLSN dlsn) {
                recordSetWriter.completeTransmit(dlsn.getLogSegmentSequenceNo(), dlsn.getEntryId(), dlsn.getSlotId());
            }

            public void onFailure(Throwable cause) {
                recordSetWriter.abortTransmit(cause);
            }
        });
        writeFutures.add(writeRecordSetFuture);
        Utils.ioResult((CompletableFuture)writeRecordSetFuture);
        for (int i4 = 0; i4 < 5; ++i4) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(11L + (long)i4);
            CompletableFuture writeFuture = writer.write(record);
            writeFutures.add(writeFuture);
            if (i4 != 0) continue;
            Utils.ioResult((CompletableFuture)writeFuture);
            Assert.assertEquals((long)10L, (long)dlm.getLogRecordCount());
        }
        List writeResults = (List)Utils.ioResult((CompletableFuture)FutureUtils.collect((List)writeFutures));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)new DLSN(1L, (long)i, 0L), writeResults.get(i));
        }
        Assert.assertEquals((Object)new DLSN(1L, 5L, 0L), writeResults.get(5));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)new DLSN(1L, 6L + (long)i, 0L), writeResults.get(6 + i));
        }
        List recordSetWriteResults = (List)Utils.ioResult((CompletableFuture)FutureUtils.collect((List)recordSetFutures));
        for (int i5 = 0; i5 < 5; ++i5) {
            Assert.assertEquals((Object)new DLSN(1L, 5L, (long)i5), recordSetWriteResults.get(i5));
        }
        Utils.ioResult((CompletableFuture)writer.flushAndCommit());
        DistributedLogConfiguration readConf1 = new DistributedLogConfiguration();
        readConf1.addConfiguration((Configuration)confLocal);
        readConf1.setDeserializeRecordSetOnReads(true);
        BKDistributedLogManager readDLM1 = this.createNewDLM(readConf1, name);
        AsyncLogReader reader1 = readDLM1.getAsyncLogReader(DLSN.InitialDLSN);
        for (int i6 = 0; i6 < 15; ++i6) {
            LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader1.readNext());
            if (i6 < 5) {
                Assert.assertEquals((Object)new DLSN(1L, (long)i6, 0L), (Object)record.getDlsn());
                Assert.assertEquals((long)(1L + (long)i6), (long)record.getTransactionId());
            } else if (i6 >= 10) {
                Assert.assertEquals((Object)new DLSN(1L, 6L + (long)i6 - 10L, 0L), (Object)record.getDlsn());
                Assert.assertEquals((long)(11L + (long)i6 - 10L), (long)record.getTransactionId());
            } else {
                Assert.assertEquals((Object)new DLSN(1L, 5L, (long)(i6 - 5)), (Object)record.getDlsn());
                Assert.assertEquals((long)6L, (long)record.getTransactionId());
            }
            Assert.assertEquals((long)(i6 + 1), (long)record.getPositionWithinLogSegment());
            Assert.assertArrayEquals((byte[])DLMTestUtil.generatePayload(i6 + 1), (byte[])record.getPayload());
        }
        Utils.close((AsyncCloseable)reader1);
        readDLM1.close();
        DistributedLogConfiguration readConf2 = new DistributedLogConfiguration();
        readConf2.addConfiguration((Configuration)confLocal);
        readConf2.setDeserializeRecordSetOnReads(false);
        BKDistributedLogManager readDLM2 = this.createNewDLM(readConf2, name);
        AsyncLogReader reader2 = readDLM2.getAsyncLogReader(DLSN.InitialDLSN);
        for (int i7 = 0; i7 < 11; ++i7) {
            LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader2.readNext());
            LOG.info("Read record {}", (Object)record);
            if (i7 < 5) {
                Assert.assertEquals((Object)new DLSN(1L, (long)i7, 0L), (Object)record.getDlsn());
                Assert.assertEquals((long)(1L + (long)i7), (long)record.getTransactionId());
                Assert.assertEquals((long)(i7 + 1), (long)record.getPositionWithinLogSegment());
                Assert.assertArrayEquals((byte[])DLMTestUtil.generatePayload(i7 + 1), (byte[])record.getPayload());
                continue;
            }
            if ((long)i7 >= 6L) {
                Assert.assertEquals((Object)new DLSN(1L, 6L + (long)i7 - 6L, 0L), (Object)record.getDlsn());
                Assert.assertEquals((long)(11L + (long)i7 - 6L), (long)record.getTransactionId());
                Assert.assertEquals((long)(11 + i7 - 6), (long)record.getPositionWithinLogSegment());
                Assert.assertArrayEquals((byte[])DLMTestUtil.generatePayload(11L + (long)i7 - 6L), (byte[])record.getPayload());
                continue;
            }
            Assert.assertEquals((Object)new DLSN(1L, 5L, 0L), (Object)record.getDlsn());
            Assert.assertEquals((long)6L, (long)record.getTransactionId());
            Assert.assertEquals((long)6L, (long)record.getPositionWithinLogSegment());
            Assert.assertTrue((boolean)record.isRecordSet());
            Assert.assertEquals((long)5L, (long)LogRecordSet.numRecords((LogRecord)record));
        }
        Utils.close((AsyncCloseable)reader2);
        readDLM2.close();
    }

    @Test(timeout=60000L)
    public void testIdleReaderExceptionWhenKeepAliveIsDisabled() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        confLocal.setPeriodicKeepAliveMilliSeconds(0);
        confLocal.setReadLACLongPollTimeout(9);
        confLocal.setReaderIdleWarnThresholdMillis(20);
        confLocal.setReaderIdleErrorThresholdMillis(40);
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        AsyncLogReader reader = (AsyncLogReader)Utils.ioResult((CompletableFuture)dlm.openAsyncLogReader(DLSN.InitialDLSN));
        try {
            Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.fail((String)"Should fail when stream is idle");
        }
        catch (IdleReaderException idleReaderException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)reader);
        writer.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testIdleReaderExceptionWhenKeepAliveIsEnabled() throws Exception {
        String name = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.testConf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(0);
        confLocal.setPeriodicKeepAliveMilliSeconds(1000);
        confLocal.setReadLACLongPollTimeout(999);
        confLocal.setReaderIdleWarnThresholdMillis(2000);
        confLocal.setReaderIdleErrorThresholdMillis(4000);
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        AsyncLogReader reader = (AsyncLogReader)Utils.ioResult((CompletableFuture)dlm.openAsyncLogReader(DLSN.InitialDLSN));
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
        Assert.assertEquals((long)1L, (long)record.getTransactionId());
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        Utils.close((AsyncCloseable)reader);
        writer.close();
        dlm.close();
    }

    static class WriteFutureEventListener
    implements FutureEventListener<DLSN> {
        private final LogRecord record;
        private final long currentLogSegmentSeqNo;
        private final long currentEntryId;
        private final CountDownLatch syncLatch;
        private final AtomicBoolean errorsFound;
        private final boolean verifyEntryId;

        WriteFutureEventListener(LogRecord record, long currentLogSegmentSeqNo, long currentEntryId, CountDownLatch syncLatch, AtomicBoolean errorsFound, boolean verifyEntryId) {
            this.record = record;
            this.currentLogSegmentSeqNo = currentLogSegmentSeqNo;
            this.currentEntryId = currentEntryId;
            this.syncLatch = syncLatch;
            this.errorsFound = errorsFound;
            this.verifyEntryId = verifyEntryId;
        }

        public void onSuccess(DLSN value) {
            if (value.getLogSegmentSequenceNo() != this.currentLogSegmentSeqNo) {
                LOG.error("Ledger Seq No: {}, Expected: {}", (Object)value.getLogSegmentSequenceNo(), (Object)this.currentLogSegmentSeqNo);
                this.errorsFound.set(true);
            }
            if (this.verifyEntryId && value.getEntryId() != this.currentEntryId) {
                LOG.error("EntryId: {}, Expected: {}", (Object)value.getEntryId(), (Object)this.currentEntryId);
                this.errorsFound.set(true);
            }
            this.syncLatch.countDown();
        }

        public void onFailure(Throwable cause) {
            LOG.error("Encountered failures on writing record as (lid = {}, eid = {}) :", new Object[]{this.currentLogSegmentSeqNo, this.currentEntryId, cause});
            this.errorsFound.set(true);
            this.syncLatch.countDown();
        }
    }
}

