/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.AnnotatedTypeLoader;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployerEnvironmentFactory;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.executor.IterativeWorkerTaskFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.reflection.Reflections;

public class ConcurrentBeanDeployer
extends BeanDeployer {
    private final ExecutorServices executor;

    public ConcurrentBeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        super(manager, ejbDescriptors, services, BeanDeployerEnvironmentFactory.newConcurrentEnvironment(ejbDescriptors, manager));
        this.executor = services.get(ExecutorServices.class);
    }

    @Override
    public BeanDeployer addClasses(Iterable<String> c) {
        final AnnotatedTypeLoader loader = this.createAnnotatedTypeLoader();
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<String>(c){

            @Override
            protected void doWork(String className) {
                ConcurrentBeanDeployer.this.addClass(className, loader);
            }
        });
        return this;
    }

    @Override
    public void createClassBeans() {
        final LoadingCache otherWeldClasses = Multimaps.newConcurrentSetMultimap();
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<SlimAnnotatedTypeContext<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()){

            @Override
            protected void doWork(SlimAnnotatedTypeContext<?> ctx) {
                ConcurrentBeanDeployer.this.createClassBean(ctx.getAnnotatedType(), otherWeldClasses);
            }
        });
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<InternalEjbDescriptor<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()){

            @Override
            protected void doWork(InternalEjbDescriptor<?> descriptor) {
                if (!((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment()).isVetoed(descriptor.getBeanClass()) && !Beans.isVetoed(descriptor.getBeanClass()) && (descriptor.isSingleton() || descriptor.isStateful() || descriptor.isStateless())) {
                    if (otherWeldClasses.getIfPresent(descriptor.getBeanClass()) != null) {
                        for (SlimAnnotatedType annotatedType : (Set)LoadingCacheUtils.getCacheValue(otherWeldClasses, descriptor.getBeanClass())) {
                            EnhancedAnnotatedType weldClass = ConcurrentBeanDeployer.this.classTransformer.getEnhancedAnnotatedType(annotatedType);
                            ConcurrentBeanDeployer.this.createSessionBean(descriptor, (EnhancedAnnotatedType)Reflections.cast(weldClass));
                        }
                    } else {
                        ConcurrentBeanDeployer.this.createSessionBean(descriptor);
                    }
                }
            }
        });
    }

    @Override
    public void createProducersAndObservers() {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<AbstractClassBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans()){

            @Override
            protected void doWork(AbstractClassBean<?> bean) {
                ConcurrentBeanDeployer.this.createObserversProducersDisposers(bean);
            }
        });
    }

    @Override
    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        this.executor.invokeAllAndCheckForExceptions(new AfterBeanDiscoveryInitializerFactory((Iterable<? extends Bean<?>>)beanList));
    }

    @Override
    public AbstractBeanDeployer<BeanDeployerEnvironment> initializeBeans() {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<RIBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getBeans()){

            @Override
            protected void doWork(RIBean<?> bean) {
                bean.initialize((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment());
            }
        });
        return this;
    }

    private static class AfterBeanDiscoveryInitializerFactory
    extends IterativeWorkerTaskFactory<Bean<?>> {
        public AfterBeanDiscoveryInitializerFactory(Iterable<? extends Bean<?>> iterable) {
            super(iterable);
        }

        @Override
        protected void doWork(Bean<?> bean) {
            if (bean instanceof RIBean) {
                ((RIBean)bean).initializeAfterBeanDiscovery();
            }
        }
    }
}

