/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class ClassFileBuffer
implements DataInput {
    private byte[] buffer;
    private int size;
    private int pointer;

    ClassFileBuffer() {
        this(8192);
    }

    ClassFileBuffer(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("initialCapacity < 1: " + n);
        }
        this.buffer = new byte[n];
    }

    public void readFrom(InputStream inputStream) throws IOException {
        int n;
        this.pointer = 0;
        this.size = 0;
        do {
            if ((n = inputStream.read(this.buffer, this.size, this.buffer.length - this.size)) > 0) {
                this.size += n;
            }
            this.resizeIfNeeded();
        } while (n >= 0);
    }

    public void seek(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("position < 0: " + n);
        }
        if (n > this.size) {
            throw new EOFException();
        }
        this.pointer = n;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pointer + n2 > this.size) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, this.pointer, byArray, n, n2);
        this.pointer += n2;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seek(this.pointer + n);
        return n;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pointer >= this.size) {
            throw new EOFException();
        }
        return this.buffer[this.pointer++];
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.pointer >= this.size) {
            throw new EOFException();
        }
        return this.read();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.pointer + 2 > this.size) {
            throw new EOFException();
        }
        return (this.read() << 8) + this.read();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.pointer + 4 > this.size) {
            throw new EOFException();
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    @Override
    public long readLong() throws IOException {
        if (this.pointer + 8 > this.size) {
            throw new EOFException();
        }
        return ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + (long)(this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() is deprecated and not supported");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    private int read() {
        return this.buffer[this.pointer++] & 0xFF;
    }

    private void resizeIfNeeded() {
        if (this.size >= this.buffer.length) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }
}

