/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.pluto.container.bean.mvc;

import java.util.Collections;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.mvc.locale.LocaleResolver;


/**
 * @author  Neil Griffin
 */
@ApplicationScoped
public class LocaleResolverChain {

	private static List<LocaleResolver> localeResolvers;

	@Inject
	private BeanManager _beanManager;

	public List<LocaleResolver> getLocaleResolvers() {
		return localeResolvers;
	}

	@PostConstruct
	private void postConstruct() {

		localeResolvers = BeanUtil.getBeanInstances(_beanManager, LocaleResolver.class);

		Collections.sort(localeResolvers, new DescendingPriorityComparator(1000));
	}
}
