/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.cli;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.Assembler;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.AssemblerFactory;

public class AssemblerCLI {
    private Options options;
    private String[] args;

    public AssemblerCLI(String[] args) {
        this.args = args;
        this.options = new Options();
        Option destination = new Option("d", "destination", true, "specify where the resulting webapp should be written ");
        destination.setArgName("file");
        Option debug = new Option("debug", false, "print debug information.");
        this.options.addOption(destination);
        this.options.addOption(debug);
    }

    public void run() throws ParseException, IOException, UtilityException {
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(this.options, this.args);
        String[] args = line.getArgs();
        if (args.length != 1) {
            this.abort();
            return;
        }
        String dest = line.getOptionValue("file");
        if (dest == null) {
            dest = args[0];
        }
        File source = new File(args[0]);
        File result = new File(dest);
        result.getParentFile().mkdirs();
        if (!source.exists()) {
            System.out.println("File does not exist: " + source.getCanonicalPath());
        }
        System.out.println("-----------------------------------------------");
        System.out.println("Assembling: " + source.getCanonicalPath());
        System.out.println("        to: " + result.getCanonicalPath());
        File webXml = new File(args[0], "WEB-INF/web.xml");
        File portletXml = new File(args[0], "WEB-INF/portlet.xml");
        AssemblerConfig config = new AssemblerConfig();
        config.setWebappDescriptor(webXml);
        config.setPortletDescriptor(portletXml);
        config.setDestination(webXml);
        Assembler assembler = AssemblerFactory.getFactory().createAssembler(config);
        config.setPortletDescriptor(portletXml);
        config.setWebappDescriptor(webXml);
        assembler.assemble(config);
        System.out.println("Complete!");
    }

    public void abort() {
        HelpFormatter help = new HelpFormatter();
        help.defaultArgName = "webapp";
        help.defaultWidth = 60;
        help.printHelp("assemble", this.options);
    }

    public static void main(String[] args) throws ParseException, IOException, UtilityException {
        new AssemblerCLI(args).run();
    }
}

