/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method getLocalName returns the local part of the qualified name of this node.
 * Ceate two new element nodes and atribute nodes, with and without namespace prefixes.
 * Retreive the local part of their qualified names using getLocalName and verrify
 * if it is correct.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSLocalN">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSLocalN</a>
 */
public class nodegetlocalname03 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staff", false);
        Element element = doc.createElementNS("http://www.w3.org/DOM/Test/elem", "elem");
        Element qelement = doc.createElementNS("http://www.w3.org/DOM/Test/elem", "qual:qelem");
        Attr attr = doc.createAttributeNS("http://www.w3.org/DOM/Test/attr", "attr");
        Attr qattr = doc.createAttributeNS("http://www.w3.org/DOM/Test/attr", "qual:qattr");
        String localElemName = element.getLocalName();
        String localQElemName = qelement.getLocalName();
        String localAttrName = attr.getLocalName();
        String localQAttrName = qattr.getLocalName();
        assertEquals("elem", localElemName, "nodegetlocalname03_localElemName");
        assertEquals("qelem", localQElemName, "nodegetlocalname03_localQElemName");
        assertEquals("attr", localAttrName, "nodegetlocalname03_localAttrName");
        assertEquals("qattr", localQAttrName, "nodegetlocalname03_localQAttrName");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodegetlocalname03";
    }

}
