/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setNamedItemNS adds a node using its namespaceURI and localName and
 * raises a NO_MODIFICATION_ALLOWED_ERR if this map is readonly.
 * Create a new attribute node and attempt to add it to the nodemap of entities and notations
 * for this documenttype.  This should reaise a NO_MODIFICATION_ALLOWED_ERR.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
 */
public class namednodemapsetnameditemns09 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        DocumentType docType = doc.getDoctype();
        NamedNodeMap entities = docType.getEntities();
        NamedNodeMap notations = docType.getNotations();
        Attr attr = doc.createAttributeNS("http://www.w3.org/DOM/Test", "test");

        DOMException ex1 = assertThrows(DOMException.class, () -> entities.setNamedItemNS(attr));
        assertEquals(DOMException.NO_MODIFICATION_ALLOWED_ERR, ex1.code, "namednodemapsetnameditemns09_entities");

        DOMException ex2 = assertThrows(DOMException.class, () -> notations.setNamedItemNS(attr));
        assertEquals(DOMException.NO_MODIFICATION_ALLOWED_ERR, ex2.code, "namednodemapsetnameditemns09_notations");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapsetnameditemns09";
    }

}
