/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method createAttributeNS raises a NAMESPACE_ERR if the qualifiedName has a prefix that
 * is "xml" and the namespaceURI is different from "http://www.w3.org/XML/1998/namespace".
 * Invoke the createAttributeNS method on a new DOMImplementation object with  the qualifiedName
 * as xml:root and namespaceURI as http://www.w3.org/XML/1998 /namespace.
 * Check if the NAMESPACE_ERR exception is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS</a>
 */
public class documentcreateattributeNS06 {
    @Test
    void testRun() throws Throwable {
        DocumentType docType = null;

        String namespaceURI = "http://www.w3.org/XML/1998 /namespace";
        String qualifiedName = "xml:root";
        Document doc = load("staffNS", false);
        DOMImplementation domImpl = doc.getImplementation();
        Document newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "dom:doc", docType);

        DOMException ex = assertThrows(DOMException.class, () -> newDoc.createAttributeNS(namespaceURI, qualifiedName));
        assertEquals(DOMException.NAMESPACE_ERR, ex.code, "documentcreateattributeNS06,xml:root and namespaceURI as http://www.w3.org/XML/1998 /namespace.");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateattributeNS06";
    }

}
