/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The "getNamespaceURI()" method for a Node
 * returns the namespace URI of this node, or null if unspecified.
 * <p>
 * Retrieve the second employee node and invoke the "getNamespaceURI()"
 * method.   The method should return "null".
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSname">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSname</a>
 */
public class namespaceURI04 {
    @Test
    void testRun() throws Throwable {
        String sExpected = "";//TODO null;
        Document doc = load("staffNS", false);
        NodeList elementList = doc.getElementsByTagName("employee");
        Node testEmployee = elementList.item(1);
        String employeeNamespace = testEmployee.getNamespaceURI();
        assertEquals(sExpected, employeeNamespace, "throw_Null");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namespaceURI04";
    }

}
