#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

{"sql":"SELECT DivReachedDest, FirstDepTime, DepDelayMinutes FROM mytable WHERE DestState IN ('VI', 'UT', 'VA') OR ArrTime < 806 ORDER BY OriginAirportSeqID, ArrivalDelayGroups LIMIT 10"}
{"sql":"SELECT DistanceGroup, Carrier, DepTime FROM mytable WHERE Cancelled IN (1, 0) AND Flights BETWEEN 1 AND 1 OR TaxiOut <> 32 LIMIT 7"}
{"sql":"SELECT ActualElapsedTime, CancellationCode, DivArrDelay, MIN(\"Month\"), AVG(DivAirportLandings) FROM mytable WHERE DayofMonth BETWEEN 12 AND 24 GROUP BY ActualElapsedTime, CancellationCode, DivArrDelay LIMIT 29","hsqls":["SELECT ActualElapsedTime, CancellationCode, DivArrDelay, MIN(`Month`), AVG(DivAirportLandings) FROM mytable WHERE DayofMonth BETWEEN 12 AND 24 GROUP BY ActualElapsedTime, CancellationCode, DivArrDelay LIMIT 29"]}
{"sql":"SELECT Diverted, FlightDate, OriginStateName FROM mytable WHERE Diverted < 1 AND DivTailNums BETWEEN 'N8320J' AND 'N233SW' LIMIT 1","hsqls":["SELECT Diverted, FlightDate, OriginStateName FROM mytable WHERE Diverted < 1 AND (DivTailNums[1] BETWEEN 'N8320J' AND 'N233SW' OR DivTailNums[2] BETWEEN 'N8320J' AND 'N233SW' OR DivTailNums[3] BETWEEN 'N8320J' AND 'N233SW' OR DivTailNums[4] BETWEEN 'N8320J' AND 'N233SW' OR DivTailNums[5] BETWEEN 'N8320J' AND 'N233SW') LIMIT 10000"]}
{"sql":"SELECT DestAirportID, MIN(DepartureDelayGroups), COUNT(DivDistance) FROM mytable GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 6","hsqls":["SELECT DestAirportID, MIN(DepartureDelayGroups), COUNT(DivDistance) FROM mytable GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 6"]}
{"sql":"SELECT DivReachedDest FROM mytable WHERE FlightNum <= 1881 AND TailNum < 'N3JLAA' ORDER BY DaysSinceEpoch LIMIT 10"}
{"sql":"SELECT DestWac FROM mytable WHERE NASDelay BETWEEN 226 AND 69 AND Quarter <= 1 ORDER BY DivDistance, ArrDelayMinutes LIMIT 11"}
{"sql":"SELECT ArrDelayMinutes, CRSDepTime FROM mytable WHERE DaysSinceEpoch NOT IN (16087, 16074, 16086, 16076) AND DepartureDelayGroups NOT IN (6, 5, 11) AND DivActualElapsedTime <= 654 ORDER BY UniqueCarrier LIMIT 29"}
{"sql":"SELECT DivAirportLandings FROM mytable ORDER BY OriginAirportSeqID, OriginWac, AirTime LIMIT 6"}
{"sql":"SELECT ActualElapsedTime FROM mytable"}
{"sql":"SELECT TailNum FROM mytable LIMIT 15"}
{"sql":"SELECT DivDistance, CRSArrTime, OriginStateName, MIN(Diverted), SUM(OriginWac) FROM mytable WHERE DivAirportIDs IN (13830, 10397) GROUP BY DivDistance, CRSArrTime, OriginStateName LIMIT 11","hsqls":["SELECT DivDistance, CRSArrTime, OriginStateName, MIN(Diverted), SUM(OriginWac) FROM mytable WHERE (ARRAY_CONTAINS(DivAirportIDs, 13830) OR ARRAY_CONTAINS(DivAirportIDs, 10397)) GROUP BY DivDistance, CRSArrTime, OriginStateName LIMIT 10000"]}
{"sql":"SELECT WheelsOff, OriginWac, UniqueCarrier, MIN(NASDelay) FROM mytable WHERE CRSElapsedTime IN (352, 339, 187) OR TaxiIn IN (43, 47) OR OriginAirportID BETWEEN 11278 AND 13424 GROUP BY WheelsOff, OriginWac, UniqueCarrier  ORDER BY WheelsOff, OriginWac, UniqueCarrier LIMIT 7","hsqls":["SELECT WheelsOff, OriginWac, UniqueCarrier, MIN(NASDelay) FROM mytable WHERE CRSElapsedTime IN (352, 339, 187) OR TaxiIn IN (43, 47) OR OriginAirportID BETWEEN 11278 AND 13424 GROUP BY WheelsOff, OriginWac, UniqueCarrier  ORDER BY WheelsOff, OriginWac, UniqueCarrier LIMIT 7"]}
{"sql":"SELECT SecurityDelay, MAX(LongestAddGTime), COUNT(TotalAddGTime), AVG(WheelsOff) FROM mytable WHERE DestAirportID < 10157 OR DivDistance BETWEEN 170 AND 24 OR WheelsOff BETWEEN 559 AND 1713 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 20","hsqls":["SELECT SecurityDelay, MAX(LongestAddGTime), COUNT(TotalAddGTime), AVG(WheelsOff) FROM mytable WHERE DestAirportID < 10157 OR DivDistance BETWEEN 170 AND 24 OR WheelsOff BETWEEN 559 AND 1713 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 20"]}
{"sql":"SELECT OriginStateFips, DestCityMarketID, DayOfWeek, MIN(DivReachedDest) FROM mytable WHERE OriginCityName BETWEEN 'Midland/Odessa, TX' AND 'Santa Barbara, CA' AND DivWheelsOffs BETWEEN 58 AND 1321 AND Cancelled > 1 GROUP BY OriginStateFips, DestCityMarketID, DayOfWeek LIMIT 24","hsqls":["SELECT OriginStateFips, DestCityMarketID, DayOfWeek, MIN(DivReachedDest) FROM mytable WHERE OriginCityName BETWEEN 'Midland/Odessa, TX' AND 'Santa Barbara, CA' AND (DivWheelsOffs[1] BETWEEN 58 AND 1321 OR DivWheelsOffs[2] BETWEEN 58 AND 1321 OR DivWheelsOffs[3] BETWEEN 58 AND 1321 OR DivWheelsOffs[4] BETWEEN 58 AND 1321 OR DivWheelsOffs[5] BETWEEN 58 AND 1321) AND Cancelled > 1 GROUP BY OriginStateFips, DestCityMarketID, DayOfWeek LIMIT 10000"]}
{"sql":"SELECT CRSArrTime, DivActualElapsedTime FROM mytable WHERE DivAirportLandings <= 1 LIMIT 7"}
{"sql":"SELECT SUM(TotalAddGTime) FROM mytable WHERE AirTime > 202 AND DestStateName BETWEEN 'Louisiana' AND 'Alaska' LIMIT 7"}
{"sql":"SELECT OriginStateFips, FlightNum, AVG(DestAirportSeqID), MAX(Quarter), AVG(WheelsOff) FROM mytable WHERE WeatherDelay <> 27 OR ArrDelay = 238.0 OR CRSDepTime = 1332 GROUP BY OriginStateFips, FlightNum  ORDER BY OriginStateFips, FlightNum LIMIT 28","hsqls":["SELECT OriginStateFips, FlightNum, AVG(DestAirportSeqID), MAX(Quarter), AVG(WheelsOff) FROM mytable WHERE WeatherDelay <> 27 OR ArrDelay = 238.0 OR CRSDepTime = 1332 GROUP BY OriginStateFips, FlightNum  ORDER BY OriginStateFips, FlightNum LIMIT 28"]}
{"sql":"SELECT MAX(ArrTime) FROM mytable WHERE TailNum IN ('N822SK', 'N14731', 'N003AA', 'N77430') OR Origin IN ('MOB', 'MMH', 'RAP', 'EGE') LIMIT 14"}
{"sql":"SELECT DestState, DivTailNums FROM mytable WHERE OriginState <> 'MS' AND TaxiIn = 162 OR SecurityDelay BETWEEN 27 AND 8 ORDER BY LateAircraftDelay LIMIT 11","hsqls":["SELECT DestState, DivTailNums FROM mytable WHERE OriginState <> 'MS' AND TaxiIn = 162 OR SecurityDelay BETWEEN 27 AND 8 ORDER BY LateAircraftDelay LIMIT 10000"]}
{"sql":"SELECT TailNum, DivAirportIDs FROM mytable WHERE OriginAirportSeqID BETWEEN 1288403 AND 1537602 AND OriginCityName BETWEEN 'Columbus, GA' AND 'San Antonio, TX' LIMIT 22","hsqls":["SELECT TailNum, DivAirportIDs FROM mytable WHERE OriginAirportSeqID BETWEEN 1288403 AND 1537602 AND OriginCityName BETWEEN 'Columbus, GA' AND 'San Antonio, TX' LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, DestStateFips, Origin, SUM(Cancelled), AVG(ArrDel15) FROM mytable GROUP BY LateAircraftDelay, DestStateFips, Origin  ORDER BY LateAircraftDelay, DestStateFips, Origin LIMIT 19","hsqls":["SELECT LateAircraftDelay, DestStateFips, Origin, SUM(Cancelled), AVG(ArrDel15) FROM mytable GROUP BY LateAircraftDelay, DestStateFips, Origin  ORDER BY LateAircraftDelay, DestStateFips, Origin LIMIT 19"]}
{"sql":"SELECT SUM(CarrierDelay), SUM(OriginWac) FROM mytable WHERE DepartureDelayGroups >= 0 LIMIT 14"}
{"sql":"SELECT SecurityDelay, AVG(OriginAirportSeqID), AVG(OriginStateFips) FROM mytable WHERE DestCityName BETWEEN 'Melbourne, FL' AND 'Washington, DC' AND DepartureDelayGroups >= 10 AND DivArrDelay IN (802, 107, 305, 343, 130) GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 6","hsqls":["SELECT SecurityDelay, AVG(OriginAirportSeqID), AVG(OriginStateFips) FROM mytable WHERE DestCityName BETWEEN 'Melbourne, FL' AND 'Washington, DC' AND DepartureDelayGroups >= 10 AND DivArrDelay IN (802, 107, 305, 343, 130) GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 6"]}
{"sql":"SELECT Flights, DaysSinceEpoch FROM mytable WHERE \"Year\" NOT IN (2014) OR DestCityName NOT IN ('Burlington, VT') OR ArrDelay BETWEEN 46.0 AND 39.0 ORDER BY DestState, CRSElapsedTime LIMIT 3","hsqls":["SELECT Flights, DaysSinceEpoch FROM mytable WHERE `Year` NOT IN (2014) OR DestCityName NOT IN ('Burlington, VT') OR ArrDelay BETWEEN 46.0 AND 39.0 ORDER BY DestState, CRSElapsedTime LIMIT 3"]}
{"sql":"SELECT SecurityDelay FROM mytable WHERE OriginCityName NOT IN ('Kalispell, MT', 'Manhattan/Ft. Riley, KS', 'Sioux Falls, SD') AND Dest NOT IN ('IMT', 'BTV') ORDER BY TaxiIn, Origin LIMIT 21"}
{"sql":"SELECT DivTailNums FROM mytable ORDER BY DestAirportID LIMIT 7","hsqls":["SELECT DivTailNums FROM mytable ORDER BY DestAirportID LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE DivTotalGTimes >= 87 OR DivAirportIDs = 14098 LIMIT 16","hsqls":["SELECT ArrDelayMinutes FROM mytable WHERE (DivTotalGTimes[1] >= 87 OR DivTotalGTimes[2] >= 87 OR DivTotalGTimes[3] >= 87 OR DivTotalGTimes[4] >= 87 OR DivTotalGTimes[5] >= 87) OR ARRAY_CONTAINS(DivAirportIDs, 14098) LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, Dest, DestCityMarketID FROM mytable WHERE DivActualElapsedTime >= 271 OR OriginStateFips NOT IN (56, 5, 23) LIMIT 5"}
{"sql":"SELECT SUM(WheelsOn), MIN(NASDelay), SUM(ArrTime) FROM mytable WHERE LongestAddGTime = 23 OR WheelsOn < 101 LIMIT 5"}
{"sql":"SELECT OriginStateName, AVG(DaysSinceEpoch) FROM mytable WHERE DepartureDelayGroups BETWEEN 1 AND -9999 OR DivAirportIDs BETWEEN 15070 AND 14288 GROUP BY OriginStateName LIMIT 19","hsqls":["SELECT OriginStateName, AVG(CAST(DaysSinceEpoch AS DOUBLE)) FROM mytable WHERE DepartureDelayGroups BETWEEN 1 AND -9999 OR (DivAirportIDs[1] BETWEEN 15070 AND 14288 OR DivAirportIDs[2] BETWEEN 15070 AND 14288 OR DivAirportIDs[3] BETWEEN 15070 AND 14288 OR DivAirportIDs[4] BETWEEN 15070 AND 14288 OR DivAirportIDs[5] BETWEEN 15070 AND 14288) GROUP BY OriginStateName LIMIT 10000"]}
{"sql":"SELECT Cancelled, TailNum, WheelsOn FROM mytable WHERE Distance > 934 AND TaxiIn IN (14, 89) ORDER BY TaxiOut, LateAircraftDelay, CancellationCode LIMIT 28"}
{"sql":"SELECT ArrTime, AirTime FROM mytable WHERE CancellationCode NOT IN ('A', 'B', 'C', 'noodles') AND ArrDelay NOT IN (90.0) OR ArrDel15 BETWEEN 1 AND -9999 ORDER BY DepDelay, DepTimeBlk, OriginAirportID LIMIT 3"}
{"sql":"SELECT DepDelay, ArrTime, TaxiIn FROM mytable WHERE ActualElapsedTime <= 60 ORDER BY DepartureDelayGroups, Flights, DepTime LIMIT 17"}
{"sql":"SELECT ArrDelay, COUNT(Quarter), COUNT(OriginWac), COUNT(LongestAddGTime) FROM mytable WHERE DepTime >= 548 AND DepDelay BETWEEN 186.0 AND 1.0 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 8","hsqls":["SELECT ArrDelay, COUNT(Quarter), COUNT(OriginWac), COUNT(LongestAddGTime) FROM mytable WHERE DepTime >= 548 AND DepDelay BETWEEN 186.0 AND 1.0 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 8"]}
{"sql":"SELECT DestAirportID, COUNT(DivArrDelay), MAX(Cancelled), MAX(OriginStateFips) FROM mytable GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 11","hsqls":["SELECT DestAirportID, COUNT(DivArrDelay), MAX(Cancelled), MAX(OriginStateFips) FROM mytable GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 11"]}
{"sql":"SELECT DepartureDelayGroups, DivAirports FROM mytable ORDER BY Origin LIMIT 16","hsqls":["SELECT DepartureDelayGroups, DivAirports FROM mytable ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT MIN(ArrDelayMinutes), MAX(DepDelay) FROM mytable LIMIT 14"}
{"sql":"SELECT OriginStateName FROM mytable WHERE Carrier BETWEEN 'FL' AND 'HA' AND DivActualElapsedTime <= 1968 LIMIT 1"}
{"sql":"SELECT WeatherDelay, COUNT(*) FROM mytable WHERE TailNum NOT IN ('N937WN', 'N905WN', 'N477WN') OR DestStateFips BETWEEN 12 AND 31 AND ArrTime BETWEEN 1258 AND 806 GROUP BY WeatherDelay  ORDER BY WeatherDelay LIMIT 16","hsqls":["SELECT WeatherDelay, COUNT(*) FROM mytable WHERE TailNum NOT IN ('N937WN', 'N905WN', 'N477WN') OR DestStateFips BETWEEN 12 AND 31 AND ArrTime BETWEEN 1258 AND 806 GROUP BY WeatherDelay  ORDER BY WeatherDelay LIMIT 16"]}
{"sql":"SELECT DivDistance, Carrier, DivTailNums FROM mytable WHERE DestAirportSeqID IN (1409803, 1288802, 1504102, 1014002) OR OriginAirportID BETWEEN 13198 AND 12335 OR Quarter IN (1) LIMIT 11","hsqls":["SELECT DivDistance, Carrier, DivTailNums FROM mytable WHERE DestAirportSeqID IN (1409803, 1288802, 1504102, 1014002) OR OriginAirportID BETWEEN 13198 AND 12335 OR Quarter IN (1) LIMIT 10000"]}
{"sql":"SELECT DestStateFips, DivAirportSeqIDs, WheelsOn FROM mytable WHERE DivTotalGTimes IN (62) AND DestAirportID NOT IN (14252, 10821, 11337) LIMIT 9","hsqls":["SELECT DestStateFips, DivAirportSeqIDs WheelsOn FROM mytable WHERE ARRAY_CONTAINS(DivTotalGTimes, 62) AND DestAirportID NOT IN (14252, 10821, 11337) LIMIT 10000"]}
{"sql":"SELECT ArrTime, OriginAirportID, COUNT(DestCityName) FROM mytable WHERE WheelsOff BETWEEN 1226 AND 2102 OR Flights >= 1 GROUP BY ArrTime, OriginAirportID  ORDER BY ArrTime, OriginAirportID LIMIT 28","hsqls":["SELECT ArrTime, OriginAirportID, COUNT(DestCityName) FROM mytable WHERE WheelsOff BETWEEN 1226 AND 2102 OR Flights >= 1 GROUP BY ArrTime, OriginAirportID  ORDER BY ArrTime, OriginAirportID LIMIT 28"]}
{"sql":"SELECT OriginAirportSeqID, CRSDepTime, DivArrDelay, COUNT(*) FROM mytable WHERE FirstDepTime BETWEEN 1534 AND 2145 GROUP BY OriginAirportSeqID, CRSDepTime, DivArrDelay  ORDER BY OriginAirportSeqID, CRSDepTime, DivArrDelay LIMIT 14","hsqls":["SELECT OriginAirportSeqID, CRSDepTime, DivArrDelay, COUNT(*) FROM mytable WHERE FirstDepTime BETWEEN 1534 AND 2145 GROUP BY OriginAirportSeqID, CRSDepTime, DivArrDelay  ORDER BY OriginAirportSeqID, CRSDepTime, DivArrDelay LIMIT 14"]}
{"sql":"SELECT OriginCityName, AVG(LongestAddGTime), MAX(OriginStateFips) FROM mytable WHERE DayofMonth >= 15 OR ArrDel15 BETWEEN 0 AND 1 AND DestCityMarketID BETWEEN 30140 AND 33388 GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 17","hsqls":["SELECT OriginCityName, AVG(LongestAddGTime), MAX(OriginStateFips) FROM mytable WHERE DayofMonth >= 15 OR ArrDel15 BETWEEN 0 AND 1 AND DestCityMarketID BETWEEN 30140 AND 33388 GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 17"]}
{"sql":"SELECT ArrTime FROM mytable WHERE DayofMonth BETWEEN 29 AND 9 OR SecurityDelay IN (10, 1, 14) ORDER BY CarrierDelay, Cancelled, DepDel15 LIMIT 6"}
{"sql":"SELECT DestAirportSeqID, MAX(DestWac) FROM mytable GROUP BY DestAirportSeqID  ORDER BY DestAirportSeqID LIMIT 25","hsqls":["SELECT DestAirportSeqID, MAX(DestWac) FROM mytable GROUP BY DestAirportSeqID  ORDER BY DestAirportSeqID LIMIT 25"]}
{"sql":"SELECT AVG(\"Year\"), MAX(DaysSinceEpoch), MAX(CarrierDelay) FROM mytable WHERE Origin BETWEEN 'GEG' AND 'ORH'","hsqls":["SELECT AVG(`Year`), MAX(DaysSinceEpoch), MAX(CarrierDelay) FROM mytable WHERE Origin BETWEEN 'GEG' AND 'ORH'"]}
{"sql":"SELECT OriginAirportSeqID, DestCityMarketID, \"Month\" FROM mytable WHERE TaxiOut NOT IN (138, 55, 83) AND AirTime BETWEEN 279 AND 347 ORDER BY FlightDate LIMIT 1","hsqls":["SELECT OriginAirportSeqID, DestCityMarketID, `Month` FROM mytable WHERE TaxiOut NOT IN (138, 55, 83) AND AirTime BETWEEN 279 AND 347 ORDER BY FlightDate LIMIT 1"]}
{"sql":"SELECT TaxiOut, OriginStateFips, MAX(DepTime) FROM mytable GROUP BY TaxiOut, OriginStateFips  ORDER BY TaxiOut, OriginStateFips LIMIT 21","hsqls":["SELECT TaxiOut, OriginStateFips, MAX(DepTime) FROM mytable GROUP BY TaxiOut, OriginStateFips  ORDER BY TaxiOut, OriginStateFips LIMIT 21"]}
{"sql":"SELECT ArrDel15, DestStateName, \"Month\", MIN(DayOfWeek) FROM mytable WHERE DivReachedDest <> -9999 GROUP BY ArrDel15, DestStateName, \"Month\" LIMIT 4","hsqls":["SELECT ArrDel15, DestStateName, Month, MIN(DayOfWeek) FROM mytable WHERE DivReachedDest <> -9999 GROUP BY ArrDel15, DestStateName, `Month` LIMIT 4"]}
{"sql":"SELECT MIN(DepDelay) FROM mytable WHERE DivAirportIDs IN (15323, 10627) LIMIT 18","hsqls":["SELECT MIN(DepDelay) FROM mytable WHERE (ARRAY_CONTAINS(DivAirportIDs, 15323) OR ARRAY_CONTAINS(DivAirportIDs, 10627)) LIMIT 10000"]}
{"sql":"SELECT MIN(FlightNum), SUM(DestAirportSeqID) FROM mytable LIMIT 26"}
{"sql":"SELECT DivReachedDest, DestWac FROM mytable ORDER BY DestAirportSeqID, DestCityMarketID LIMIT 26"}
{"sql":"SELECT DepTimeBlk, AirTime, CRSDepTime, COUNT(DistanceGroup), COUNT(DivReachedDest), MIN(Cancelled) FROM mytable WHERE OriginAirportSeqID < 1150303 GROUP BY DepTimeBlk, AirTime, CRSDepTime  ORDER BY DepTimeBlk, AirTime, CRSDepTime LIMIT 24","hsqls":["SELECT DepTimeBlk, AirTime, CRSDepTime, COUNT(DistanceGroup), COUNT(DivReachedDest), MIN(Cancelled) FROM mytable WHERE OriginAirportSeqID < 1150303 GROUP BY DepTimeBlk, AirTime, CRSDepTime  ORDER BY DepTimeBlk, AirTime, CRSDepTime LIMIT 24"]}
{"sql":"SELECT DivAirports, DepDel15, DivActualElapsedTime FROM mytable ORDER BY NASDelay, DestCityName LIMIT 1","hsqls":["SELECT DivAirports, DepDel15, DivActualElapsedTime FROM mytable ORDER BY NASDelay, DestCityName LIMIT 10000"]}
{"sql":"SELECT TaxiOut, COUNT(*) FROM mytable GROUP BY TaxiOut  ORDER BY TaxiOut LIMIT 18","hsqls":["SELECT TaxiOut, COUNT(*) FROM mytable GROUP BY TaxiOut  ORDER BY TaxiOut LIMIT 18"]}
{"sql":"SELECT TailNum, CRSDepTime, COUNT(*) FROM mytable WHERE LateAircraftDelay = 7 OR DayOfWeek IN (3, 1, 7, 5) OR OriginState <> 'NJ' GROUP BY TailNum, CRSDepTime","hsqls":["SELECT TailNum, CRSDepTime, COUNT(*) FROM mytable WHERE LateAircraftDelay = 7 OR DayOfWeek IN (3, 1, 7, 5) OR OriginState <> 'NJ' GROUP BY TailNum, CRSDepTime"]}
{"sql":"SELECT Distance, TotalAddGTime FROM mytable ORDER BY DivReachedDest, ArrDel15 LIMIT 5"}
{"sql":"SELECT DivWheelsOns, TailNum, OriginStateName FROM mytable WHERE FirstDepTime < 1043 AND DivAirportSeqIDs IN (1289605) ORDER BY FlightDate, ArrDelay, DivAirportLandings LIMIT 6","hsqls":["SELECT DivWheelsOns, TailNum, OriginStateName FROM mytable WHERE FirstDepTime < 1043 AND ARRAY_CONTAINS(DivAirportSeqIDs, 1289605) ORDER BY FlightDate, ArrDelay, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT Diverted, Origin, CRSDepTime, COUNT(*) FROM mytable WHERE Origin BETWEEN 'SAT' AND 'DLH' GROUP BY Diverted, Origin, CRSDepTime  ORDER BY Diverted, Origin, CRSDepTime LIMIT 10","hsqls":["SELECT Diverted, Origin, CRSDepTime, COUNT(*) FROM mytable WHERE Origin BETWEEN 'SAT' AND 'DLH' GROUP BY Diverted, Origin, CRSDepTime  ORDER BY Diverted, Origin, CRSDepTime LIMIT 10"]}
{"sql":"SELECT CarrierDelay FROM mytable WHERE ArrDelay NOT IN (157.0, 108.0, 996.0, 463.0) ORDER BY ActualElapsedTime, DestCityName, DestAirportID LIMIT 10"}
{"sql":"SELECT LateAircraftDelay, TailNum, \"Month\", SUM(NASDelay) FROM mytable WHERE FirstDepTime NOT IN (1856, 903, 624) GROUP BY LateAircraftDelay, TailNum, \"Month\" LIMIT 11","hsqls":["SELECT LateAircraftDelay, TailNum, Month, SUM(NASDelay) FROM mytable WHERE FirstDepTime NOT IN (1856, 903, 624) GROUP BY LateAircraftDelay, TailNum, `Month` LIMIT 11"]}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE DestCityName IN ('Bristol/Johnson City/Kingsport, TN', 'Tulsa, OK') OR FlightNum BETWEEN 5401 AND 1197 ORDER BY WeatherDelay LIMIT 27","hsqls":["SELECT DivAirportIDs FROM mytable WHERE DestCityName IN ('Bristol/Johnson City/Kingsport, TN', 'Tulsa, OK') OR FlightNum BETWEEN 5401 AND 1197 ORDER BY WeatherDelay LIMIT 10000"]}
{"sql":"SELECT OriginCityName FROM mytable WHERE AirlineID IN (20366, 19930, 20409) OR UniqueCarrier <= 'VX' ORDER BY CarrierDelay, Flights, Distance LIMIT 7"}
{"sql":"SELECT DivReachedDest, AirTime FROM mytable WHERE FlightNum < 4453 ORDER BY DepartureDelayGroups, CarrierDelay, CRSElapsedTime LIMIT 28"}
{"sql":"SELECT TaxiOut FROM mytable ORDER BY DepTimeBlk, DayOfWeek LIMIT 19"}
{"sql":"SELECT OriginCityName FROM mytable ORDER BY OriginState LIMIT 9"}
{"sql":"SELECT AVG(DistanceGroup), COUNT(CancellationCode), COUNT(FlightDate) FROM mytable WHERE OriginState IN ('IL') LIMIT 11"}
{"sql":"SELECT NASDelay, SUM(DestWac) FROM mytable WHERE DaysSinceEpoch IN (16082, 16087, 16079) OR DivWheelsOns BETWEEN 1814 AND 1918 OR Flights BETWEEN 1 AND 1 GROUP BY NASDelay LIMIT 23","hsqls":["SELECT NASDelay, SUM(DestWac) FROM mytable WHERE DaysSinceEpoch IN (16082, 16087, 16079) OR (DivWheelsOns[1] BETWEEN 1814 AND 1918 OR DivWheelsOns[2] BETWEEN 1814 AND 1918 OR DivWheelsOns[3] BETWEEN 1814 AND 1918 OR DivWheelsOns[4] BETWEEN 1814 AND 1918 OR DivWheelsOns[5] BETWEEN 1814 AND 1918) OR Flights BETWEEN 1 AND 1 GROUP BY NASDelay LIMIT 10000"]}
{"sql":"SELECT Quarter, NASDelay, DestAirportID, AVG(DivReachedDest) FROM mytable WHERE DayofMonth NOT IN (4, 16) GROUP BY Quarter, NASDelay, DestAirportID  ORDER BY Quarter, NASDelay, DestAirportID LIMIT 25","hsqls":["SELECT Quarter, NASDelay, DestAirportID, AVG(DivReachedDest) FROM mytable WHERE DayofMonth NOT IN (4, 16) GROUP BY Quarter, NASDelay, DestAirportID  ORDER BY Quarter, NASDelay, DestAirportID LIMIT 25"]}
{"sql":"SELECT DayofMonth FROM mytable ORDER BY Cancelled, DestStateName LIMIT 26"}
{"sql":"SELECT DestCityName FROM mytable ORDER BY CRSArrTime, WheelsOn LIMIT 12"}
{"sql":"SELECT Flights, DivActualElapsedTime, AVG(DestStateFips), MIN(DistanceGroup), MAX(OriginStateFips) FROM mytable WHERE DivActualElapsedTime BETWEEN 414 AND 503 OR CRSDepTime IN (1744, 2232, 1552) GROUP BY Flights, DivActualElapsedTime  ORDER BY Flights, DivActualElapsedTime LIMIT 29","hsqls":["SELECT Flights, DivActualElapsedTime, AVG(DestStateFips), MIN(DistanceGroup), MAX(OriginStateFips) FROM mytable WHERE DivActualElapsedTime BETWEEN 414 AND 503 OR CRSDepTime IN (1744, 2232, 1552) GROUP BY Flights, DivActualElapsedTime  ORDER BY Flights, DivActualElapsedTime LIMIT 29"]}
{"sql":"SELECT Carrier, DestAirportSeqID FROM mytable WHERE NASDelay NOT IN (67, 20, 110, 8, 38) AND \"Month\" IN (1) ORDER BY Distance, \"Month\" LIMIT 21","hsqls":["SELECT Carrier, DestAirportSeqID FROM mytable WHERE NASDelay NOT IN (67, 20, 110, 8, 38) AND `Month` IN (1) ORDER BY Distance, `Month` LIMIT 21"]}
{"sql":"SELECT MAX(OriginWac), AVG(OriginStateFips) FROM mytable WHERE AirTime BETWEEN 191 AND 240 AND DestState < 'MS' AND DepTimeBlk BETWEEN '1800-1859' AND '2200-2259' LIMIT 3"}
{"sql":"SELECT MAX(DepTime), MIN(LateAircraftDelay), COUNT(WheelsOff) FROM mytable WHERE OriginState NOT IN ('MO', 'MN', 'FL') AND DistanceGroup BETWEEN 3 AND 11 LIMIT 3"}
{"sql":"SELECT CancellationCode, COUNT(DepDelay), AVG(DivActualElapsedTime) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 19","hsqls":["SELECT CancellationCode, COUNT(DepDelay), AVG(DivActualElapsedTime) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 19"]}
{"sql":"SELECT FlightNum, ArrDelay, OriginAirportID, COUNT(*) FROM mytable WHERE DestState NOT IN ('TN', 'SC', 'ME') OR Cancelled IN (1) GROUP BY FlightNum, ArrDelay, OriginAirportID  ORDER BY FlightNum, ArrDelay, OriginAirportID LIMIT 29","hsqls":["SELECT FlightNum, ArrDelay, OriginAirportID, COUNT(*) FROM mytable WHERE DestState NOT IN ('TN', 'SC', 'ME') OR Cancelled IN (1) GROUP BY FlightNum, ArrDelay, OriginAirportID  ORDER BY FlightNum, ArrDelay, OriginAirportID LIMIT 29"]}
{"sql":"SELECT MIN(DayOfWeek) FROM mytable WHERE DivAirportLandings BETWEEN 1 AND 1 AND ArrivalDelayGroups <> 6 OR ArrTimeBlk BETWEEN '0900-0959' AND '1200-1259' LIMIT 20"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestCityName <> 'Evansville, IN' AND \"Year\" BETWEEN 2014 AND 2014 LIMIT 3","hsqls":["SELECT COUNT(*) FROM mytable WHERE DestCityName <> 'Evansville, IN' AND `Year` BETWEEN 2014 AND 2014 LIMIT 3"]}
{"sql":"SELECT AVG(WheelsOn) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) LIMIT 29"}
{"sql":"SELECT Diverted, DepDel15, COUNT(DestState) FROM mytable WHERE DestCityMarketID IN (30431, 35323, 31986) OR Origin BETWEEN 'IAH' AND 'BUR' AND DivAirportSeqIDs < 1029904 GROUP BY Diverted, DepDel15 LIMIT 11","hsqls":["SELECT Diverted, DepDel15, COUNT(DestState) FROM mytable WHERE DestCityMarketID IN (30431, 35323, 31986) OR Origin BETWEEN 'IAH' AND 'BUR' AND (DivAirportSeqIDs[1] < 1029904 OR DivAirportSeqIDs[2] < 1029904 OR DivAirportSeqIDs[3] < 1029904 OR DivAirportSeqIDs[4] < 1029904 OR DivAirportSeqIDs[5] < 1029904) GROUP BY Diverted, DepDel15 LIMIT 10000"]}
{"sql":"SELECT Cancelled, ArrTimeBlk, AirTime FROM mytable LIMIT 9"}
{"sql":"SELECT DivAirports FROM mytable ORDER BY TaxiIn, DivArrDelay, CRSElapsedTime LIMIT 11","hsqls":["SELECT DivAirports FROM mytable ORDER BY TaxiIn, DivArrDelay, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT DepDelay, CancellationCode FROM mytable WHERE DivLongestGTimes <= 7.0 OR OriginAirportSeqID <= 1109702 AND DayofMonth IN (25) ORDER BY CancellationCode, ArrDelay, OriginAirportID LIMIT 11","hsqls":["SELECT DepDelay, CancellationCode FROM mytable WHERE (DivLongestGTimes[1] <= 7.0 OR DivLongestGTimes[2] <= 7.0 OR DivLongestGTimes[3] <= 7.0 OR DivLongestGTimes[4] <= 7.0 OR DivLongestGTimes[5] <= 7.0) OR OriginAirportSeqID <= 1109702 AND DayofMonth IN (25) ORDER BY CancellationCode, ArrDelay, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT DepDelay, FlightDate, OriginStateName, COUNT(*) FROM mytable WHERE ArrivalDelayGroups BETWEEN -1 AND 0 AND FlightDate BETWEEN '2014-01-20' AND '2014-01-31' OR DepDel15 >= 1 GROUP BY DepDelay, FlightDate, OriginStateName  ORDER BY DepDelay, FlightDate, OriginStateName LIMIT 17","hsqls":["SELECT DepDelay, FlightDate, OriginStateName, COUNT(*) FROM mytable WHERE ArrivalDelayGroups BETWEEN -1 AND 0 AND FlightDate BETWEEN '2014-01-20' AND '2014-01-31' OR DepDel15 >= 1 GROUP BY DepDelay, FlightDate, OriginStateName  ORDER BY DepDelay, FlightDate, OriginStateName LIMIT 17"]}
{"sql":"SELECT DivReachedDest, Diverted FROM mytable WHERE FlightDate BETWEEN '2014-01-21' AND '2014-01-27' AND TaxiIn <= 42 ORDER BY TaxiOut LIMIT 27"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 5"}
{"sql":"SELECT DepTime, OriginStateName FROM mytable ORDER BY LongestAddGTime, OriginCityName, WheelsOn LIMIT 28"}
{"sql":"SELECT OriginState, MIN(DestAirportID), MIN(DepartureDelayGroups) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 14","hsqls":["SELECT OriginState, MIN(DestAirportID), MIN(DepartureDelayGroups) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 14"]}
{"sql":"SELECT SUM(SecurityDelay) FROM mytable WHERE DestWac IN (66, 81, 11) LIMIT 9"}
{"sql":"SELECT OriginState, DivTailNums FROM mytable WHERE DivDistance >= 71 LIMIT 5","hsqls":["SELECT OriginState, DivTailNums FROM mytable WHERE DivDistance >= 71 LIMIT 10000"]}
{"sql":"SELECT TaxiIn, CRSElapsedTime, DayOfWeek FROM mytable LIMIT 11"}
{"sql":"SELECT LateAircraftDelay, COUNT(*) FROM mytable WHERE Distance < 143 AND DivWheelsOns <= 2254 OR DivAirportIDs >= 13796 GROUP BY LateAircraftDelay LIMIT 19","hsqls":["SELECT LateAircraftDelay, COUNT(*) FROM mytable WHERE Distance < 143 AND (DivWheelsOns[1] <= 2254 OR DivWheelsOns[2] <= 2254 OR DivWheelsOns[3] <= 2254 OR DivWheelsOns[4] <= 2254 OR DivWheelsOns[5] <= 2254) OR (DivAirportIDs[1] >= 13796 OR DivAirportIDs[2] >= 13796 OR DivAirportIDs[3] >= 13796 OR DivAirportIDs[4] >= 13796 OR DivAirportIDs[5] >= 13796) GROUP BY LateAircraftDelay LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, SecurityDelay, DivWheelsOffs FROM mytable WHERE Flights < 1 AND DivActualElapsedTime NOT IN (594, 207) AND DepDelayMinutes IN (246.0, 201.0, 151.0, 17.0) ORDER BY OriginStateFips LIMIT 27","hsqls":["SELECT DepDelayMinutes, SecurityDelay, DivWheelsOffs FROM mytable WHERE Flights < 1 AND DivActualElapsedTime NOT IN (594, 207) AND DepDelayMinutes IN (246.0, 201.0, 151.0, 17.0) ORDER BY OriginStateFips LIMIT 10000"]}
{"sql":"SELECT \"Year\", MIN(AirTime), SUM(LongestAddGTime), MAX(\"Month\") FROM mytable WHERE SecurityDelay IN (1) AND DestAirportID BETWEEN 10849 AND 10397 GROUP BY \"Year\" LIMIT 28","hsqls":["SELECT Year, MIN(AirTime), SUM(LongestAddGTime), MAX(`Month`) FROM mytable WHERE SecurityDelay IN (1) AND DestAirportID BETWEEN 10849 AND 10397 GROUP BY `Year` LIMIT 28"]}
{"sql":"SELECT MAX(AirTime) FROM mytable WHERE DaysSinceEpoch <> 16071 OR DivTailNums IN ('N713SK') AND DivActualElapsedTime BETWEEN 153 AND 1043 LIMIT 10","hsqls":["SELECT MAX(AirTime) FROM mytable WHERE DaysSinceEpoch <> 16071 OR ARRAY_CONTAINS(DivTailNums,'N713SK') AND DivActualElapsedTime BETWEEN 153 AND 1043 LIMIT 10000"]}
{"sql":"SELECT OriginState, DepDelay, FlightDate FROM mytable ORDER BY OriginWac LIMIT 3"}
{"sql":"SELECT MAX(DepDelay) FROM mytable LIMIT 10"}
{"sql":"SELECT LateAircraftDelay, DepTime, OriginAirportID FROM mytable WHERE DestWac = 39 OR OriginCityMarketID > 32177 ORDER BY FirstDepTime LIMIT 29"}
{"sql":"SELECT ActualElapsedTime, DivAirportLandings, CRSDepTime, MAX(Quarter), COUNT(CarrierDelay), SUM(DivActualElapsedTime) FROM mytable GROUP BY ActualElapsedTime, DivAirportLandings, CRSDepTime  ORDER BY ActualElapsedTime, DivAirportLandings, CRSDepTime LIMIT 19","hsqls":["SELECT ActualElapsedTime, DivAirportLandings, CRSDepTime, MAX(Quarter), COUNT(CarrierDelay), SUM(DivActualElapsedTime) FROM mytable GROUP BY ActualElapsedTime, DivAirportLandings, CRSDepTime  ORDER BY ActualElapsedTime, DivAirportLandings, CRSDepTime LIMIT 19"]}
{"sql":"SELECT SUM(LongestAddGTime), COUNT(WheelsOff), SUM(TaxiIn) FROM mytable WHERE DestStateFips NOT IN (30, 5, 24, 37, 28) LIMIT 7"}
{"sql":"SELECT DestWac, DepDelay, Dest FROM mytable WHERE WheelsOff >= 2011 AND DepTimeBlk IN ('1200-1259', '1400-1459', '1500-1559') LIMIT 24"}
{"sql":"SELECT DistanceGroup FROM mytable ORDER BY FlightNum, ArrTime, DayOfWeek LIMIT 12"}
{"sql":"SELECT DivReachedDest, Diverted, ArrDelay FROM mytable LIMIT 24"}
{"sql":"SELECT OriginState, DivAirportIDs, OriginAirportID FROM mytable WHERE OriginStateName BETWEEN 'Alaska' AND 'Illinois' ORDER BY DestAirportID LIMIT 10","hsqls":["SELECT OriginState, DivAirportIDs, OriginAirportID FROM mytable WHERE OriginStateName BETWEEN 'Alaska' AND 'Illinois' ORDER BY DestAirportID LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, CRSElapsedTime, OriginStateName, COUNT(*) FROM mytable GROUP BY DistanceGroup, CRSElapsedTime, OriginStateName  ORDER BY DistanceGroup, CRSElapsedTime, OriginStateName LIMIT 14","hsqls":["SELECT DistanceGroup, CRSElapsedTime, OriginStateName, COUNT(*) FROM mytable GROUP BY DistanceGroup, CRSElapsedTime, OriginStateName  ORDER BY DistanceGroup, CRSElapsedTime, OriginStateName LIMIT 14"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrTime BETWEEN 1707 AND 2206 LIMIT 18"}
{"sql":"SELECT Origin FROM mytable LIMIT 20"}
{"sql":"SELECT FlightDate, OriginCityName, DestAirportID, MAX(Quarter) FROM mytable WHERE DestCityMarketID IN (30732, 34520, 31295, 30599) OR DepDelayMinutes IN (334.0) GROUP BY FlightDate, OriginCityName, DestAirportID  ORDER BY FlightDate, OriginCityName, DestAirportID LIMIT 10","hsqls":["SELECT FlightDate, OriginCityName, DestAirportID, MAX(Quarter) FROM mytable WHERE DestCityMarketID IN (30732, 34520, 31295, 30599) OR DepDelayMinutes IN (334.0) GROUP BY FlightDate, OriginCityName, DestAirportID  ORDER BY FlightDate, OriginCityName, DestAirportID LIMIT 10"]}
{"sql":"SELECT DivDistance, DepDelayMinutes, DivAirportLandings, COUNT(*) FROM mytable WHERE OriginStateFips IN (42) GROUP BY DivDistance, DepDelayMinutes, DivAirportLandings  ORDER BY DivDistance, DepDelayMinutes, DivAirportLandings LIMIT 23","hsqls":["SELECT DivDistance, DepDelayMinutes, DivAirportLandings, COUNT(*) FROM mytable WHERE OriginStateFips IN (42) GROUP BY DivDistance, DepDelayMinutes, DivAirportLandings  ORDER BY DivDistance, DepDelayMinutes, DivAirportLandings LIMIT 23"]}
{"sql":"SELECT MIN(\"Year\"), AVG(OriginAirportSeqID), COUNT(DaysSinceEpoch) FROM mytable WHERE Quarter = 1 LIMIT 7","hsqls":["SELECT MIN(`Year`), AVG(OriginAirportSeqID), COUNT(DaysSinceEpoch) FROM mytable WHERE Quarter = 1 LIMIT 7"]}
{"sql":"SELECT AVG(OriginCityMarketID) FROM mytable LIMIT 22"}
{"sql":"SELECT WheelsOff, FirstDepTime, DayofMonth FROM mytable ORDER BY Cancelled, TailNum, OriginStateName LIMIT 12"}
{"sql":"SELECT DestState, CRSElapsedTime, OriginStateName FROM mytable WHERE DivTailNums BETWEEN 'N506JB' AND 'N640JB' ORDER BY NASDelay, CRSDepTime LIMIT 17","hsqls":["SELECT DestState, CRSElapsedTime, OriginStateName FROM mytable WHERE (DivTailNums[1] BETWEEN 'N506JB' AND 'N640JB' OR DivTailNums[2] BETWEEN 'N506JB' AND 'N640JB' OR DivTailNums[3] BETWEEN 'N506JB' AND 'N640JB' OR DivTailNums[4] BETWEEN 'N506JB' AND 'N640JB' OR DivTailNums[5] BETWEEN 'N506JB' AND 'N640JB') ORDER BY NASDelay, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DestStateFips, SUM(CarrierDelay), SUM(ArrDelayMinutes) FROM mytable GROUP BY WeatherDelay, DestStateFips  ORDER BY WeatherDelay, DestStateFips LIMIT 26","hsqls":["SELECT WeatherDelay, DestStateFips, SUM(CarrierDelay), SUM(ArrDelayMinutes) FROM mytable GROUP BY WeatherDelay, DestStateFips  ORDER BY WeatherDelay, DestStateFips LIMIT 26"]}
{"sql":"SELECT ArrDelay, MAX(DepartureDelayGroups), SUM(OriginAirportID), AVG(Distance) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 1","hsqls":["SELECT ArrDelay, MAX(DepartureDelayGroups), SUM(OriginAirportID), AVG(Distance) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 1"]}
{"sql":"SELECT DestWac, LateAircraftDelay, DayofMonth, COUNT(*) FROM mytable WHERE DivTailNums IN ('N587JB', 'N811MQ', 'N3AEMQ') OR DivReachedDest BETWEEN 1 AND 0 GROUP BY DestWac, LateAircraftDelay, DayofMonth LIMIT 19","hsqls":["SELECT DestWac, LateAircraftDelay, DayofMonth, COUNT(*) FROM mytable WHERE (DivTailNums[1] IN ('N587JB', 'N811MQ', 'N3AEMQ') OR DivTailNums[2] IN ('N587JB', 'N811MQ', 'N3AEMQ') OR DivTailNums[3] IN ('N587JB', 'N811MQ', 'N3AEMQ') OR DivTailNums[4] IN ('N587JB', 'N811MQ', 'N3AEMQ') OR DivTailNums[5] IN ('N587JB', 'N811MQ', 'N3AEMQ')) OR DivReachedDest BETWEEN 1 AND 0 GROUP BY DestWac, LateAircraftDelay, DayofMonth LIMIT 10000"]}
{"sql":"SELECT ArrDel15, DestStateName FROM mytable ORDER BY DivDistance LIMIT 12"}
{"sql":"SELECT CRSArrTime, DestStateName, WheelsOn FROM mytable WHERE DivAirportLandings NOT IN (2, 1, 0, 9) ORDER BY AirTime LIMIT 19"}
{"sql":"SELECT AVG(DepDel15), MIN(DepDelay), COUNT(DivAirportLandings) FROM mytable WHERE SecurityDelay = 4 LIMIT 28"}
{"sql":"SELECT DestAirportSeqID, DivTailNums FROM mytable WHERE DivDistance BETWEEN 397 AND 67 AND SecurityDelay BETWEEN 8 AND 18 LIMIT 21","hsqls":["SELECT DestAirportSeqID, DivTailNums FROM mytable WHERE DivDistance BETWEEN 397 AND 67 AND SecurityDelay BETWEEN 8 AND 18 LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE DestWac IN (42, 53) OR LateAircraftDelay NOT IN (21, 96, 187, 100) ORDER BY DestAirportID LIMIT 14"}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE UniqueCarrier NOT IN ('US') AND LongestAddGTime NOT IN (8) OR DestWac NOT IN (67, 66, 39) ORDER BY Dest LIMIT 2"}
{"sql":"SELECT Quarter, OriginCityMarketID FROM mytable ORDER BY DestWac, DepDelayMinutes, DepTimeBlk LIMIT 18"}
{"sql":"SELECT \"Year\", Dest FROM mytable LIMIT 24","hsqls":["SELECT Year, Dest FROM mytable LIMIT 24"]}
{"sql":"SELECT DivAirports FROM mytable WHERE ArrTime BETWEEN 1912 AND 2106 OR OriginStateFips <= 24 OR OriginCityMarketID BETWEEN 31337 AND 33195 ORDER BY DistanceGroup, OriginCityMarketID, Cancelled LIMIT 2","hsqls":["SELECT DivAirports FROM mytable WHERE ArrTime BETWEEN 1912 AND 2106 OR OriginStateFips <= 24 OR OriginCityMarketID BETWEEN 31337 AND 33195 ORDER BY DistanceGroup, OriginCityMarketID, Cancelled LIMIT 10000"]}
{"sql":"SELECT DayofMonth FROM mytable WHERE FlightNum IN (787) OR ArrivalDelayGroups NOT IN (1, -1, 8, 11) AND LateAircraftDelay BETWEEN 106 AND 194 ORDER BY ArrivalDelayGroups LIMIT 29"}
{"sql":"SELECT DestWac FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR OriginCityMarketID BETWEEN 33277 AND 33570 LIMIT 14"}
{"sql":"SELECT AVG(WheelsOn), AVG(WheelsOff) FROM mytable LIMIT 27"}
{"sql":"SELECT DivTailNums FROM mytable WHERE FirstDepTime <= 1309 AND FirstDepTime IN (814, 726, 1902, 710, 900) AND OriginState IN ('MI') ORDER BY DivReachedDest, NASDelay, CRSDepTime LIMIT 16","hsqls":["SELECT DivTailNums FROM mytable WHERE FirstDepTime <= 1309 AND FirstDepTime IN (814, 726, 1902, 710, 900) AND OriginState IN ('MI') ORDER BY DivReachedDest, NASDelay, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(ArrivalDelayGroups), MAX(TaxiIn), MAX(CRSDepTime) FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259') GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 5","hsqls":["SELECT DaysSinceEpoch, COUNT(ArrivalDelayGroups), MAX(TaxiIn), MAX(CRSDepTime) FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259') GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 5"]}
{"sql":"SELECT DestWac FROM mytable WHERE DestCityName BETWEEN 'Manhattan/Ft. Riley, KS' AND 'Cedar City, UT' AND OriginCityMarketID BETWEEN 30868 AND 31097 AND DaysSinceEpoch < 16076 ORDER BY ActualElapsedTime, DestAirportSeqID LIMIT 28"}
{"sql":"SELECT WheelsOff, DayofMonth, MIN(\"Month\"), MAX(OriginStateFips) FROM mytable GROUP BY WheelsOff, DayofMonth LIMIT 6","hsqls":["SELECT WheelsOff, DayofMonth, MIN(`Month`), MAX(OriginStateFips) FROM mytable GROUP BY WheelsOff, DayofMonth LIMIT 6"]}
{"sql":"SELECT Diverted, DivAirportLandings FROM mytable LIMIT 29"}
{"sql":"SELECT Diverted, CarrierDelay FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR FlightNum BETWEEN 366 AND 2608 LIMIT 16"}
{"sql":"SELECT SecurityDelay, ActualElapsedTime, AVG(\"Year\") FROM mytable GROUP BY SecurityDelay, ActualElapsedTime LIMIT 9","hsqls":["SELECT SecurityDelay, ActualElapsedTime, AVG(`Year`) FROM mytable GROUP BY SecurityDelay, ActualElapsedTime LIMIT 9"]}
{"sql":"SELECT WeatherDelay FROM mytable WHERE FlightDate > '2014-01-23' AND DivActualElapsedTime NOT IN (773, 359, 332, 196) AND OriginCityMarketID <= 32600 ORDER BY OriginState, DepTimeBlk, ArrivalDelayGroups LIMIT 10"}
{"sql":"SELECT DivTailNums, \"Month\", CRSElapsedTime FROM mytable LIMIT 21","hsqls":["SELECT DivTailNums, Month, CRSElapsedTime FROM mytable LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, CancellationCode, COUNT(*) FROM mytable GROUP BY DivReachedDest, CancellationCode  ORDER BY DivReachedDest, CancellationCode LIMIT 19","hsqls":["SELECT DivReachedDest, CancellationCode, COUNT(*) FROM mytable GROUP BY DivReachedDest, CancellationCode  ORDER BY DivReachedDest, CancellationCode LIMIT 19"]}
{"sql":"SELECT DivReachedDest, FlightDate, Origin FROM mytable WHERE ArrivalDelayGroups BETWEEN 3 AND -1"}
{"sql":"SELECT DepartureDelayGroups, SecurityDelay FROM mytable WHERE DestState NOT IN ('TX', 'NE', 'ME') OR DepDelayMinutes < 113.0 ORDER BY Origin, DepTimeBlk LIMIT 22"}
{"sql":"SELECT Distance, DivAirportLandings, OriginWac FROM mytable ORDER BY DaysSinceEpoch LIMIT 20"}
{"sql":"SELECT LongestAddGTime, DestCityMarketID FROM mytable WHERE DivAirportSeqIDs < 1320402 OR DestCityName <= 'Orlando, FL' LIMIT 17","hsqls":["SELECT LongestAddGTime, DestCityMarketID FROM mytable WHERE (DivAirportSeqIDs[1] < 1320402 OR DivAirportSeqIDs[2] < 1320402 OR DivAirportSeqIDs[3] < 1320402 OR DivAirportSeqIDs[4] < 1320402 OR DivAirportSeqIDs[5] < 1320402) OR DestCityName <= 'Orlando, FL' LIMIT 10000"]}
{"sql":"SELECT WheelsOn FROM mytable WHERE DestAirportID IN (11042, 14771, 14006, 11111, 15096) ORDER BY CarrierDelay LIMIT 8"}
{"sql":"SELECT \"Month\", SUM(WheelsOn) FROM mytable WHERE Quarter <> 1 GROUP BY \"Month\" LIMIT 24","hsqls":["SELECT Month, SUM(WheelsOn) FROM mytable WHERE Quarter <> 1 GROUP BY `Month` LIMIT 24"]}
{"sql":"SELECT DestAirportSeqID, ArrDelay FROM mytable WHERE ArrTime = 523 ORDER BY DepDelayMinutes LIMIT 14"}
{"sql":"SELECT CarrierDelay FROM mytable WHERE AirlineID > 20437 ORDER BY Distance LIMIT 2"}
{"sql":"SELECT OriginCityMarketID, AVG(NASDelay), COUNT(OriginState) FROM mytable WHERE TotalAddGTime >= 45 OR DepTime BETWEEN 945 AND 546 GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 5","hsqls":["SELECT OriginCityMarketID, AVG(NASDelay), COUNT(OriginState) FROM mytable WHERE TotalAddGTime >= 45 OR DepTime BETWEEN 945 AND 546 GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 5"]}
{"sql":"SELECT DestStateName, CancellationCode, COUNT(UniqueCarrier), MIN(AirlineID), AVG(DepDelayMinutes) FROM mytable WHERE WheelsOff = 1911 GROUP BY DestStateName, CancellationCode  ORDER BY DestStateName, CancellationCode LIMIT 10","hsqls":["SELECT DestStateName, CancellationCode, COUNT(UniqueCarrier), MIN(AirlineID), AVG(DepDelayMinutes) FROM mytable WHERE WheelsOff = 1911 GROUP BY DestStateName, CancellationCode  ORDER BY DestStateName, CancellationCode LIMIT 10"]}
{"sql":"SELECT OriginWac, COUNT(\"Month\"), MIN(DestAirportID), COUNT(CRSElapsedTime) FROM mytable WHERE ArrTime BETWEEN 57 AND 1304 AND DestStateName NOT IN ('Wyoming', 'South Dakota', 'Oklahoma') OR DivLongestGTimes IN (24.0, 79.0, 88.0) GROUP BY OriginWac LIMIT 18","hsqls":["SELECT OriginWac, COUNT(`Month`), MIN(DestAirportID), COUNT(CRSElapsedTime) FROM mytable WHERE ArrTime BETWEEN 57 AND 1304 AND DestStateName NOT IN ('Wyoming', 'South Dakota', 'Oklahoma') OR (DivLongestGTimes[1] IN (24.0, 79.0, 88.0) OR DivLongestGTimes[2] IN (24.0, 79.0, 88.0) OR DivLongestGTimes[3] IN (24.0, 79.0, 88.0) OR DivLongestGTimes[4] IN (24.0, 79.0, 88.0) OR DivLongestGTimes[5] IN (24.0, 79.0, 88.0)) GROUP BY OriginWac LIMIT 10000"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DestCityName IN ('Hilo, HI', 'Indianapolis, IN') AND DestCityName BETWEEN 'Christiansted, VI' AND 'Bismarck/Mandan, ND' AND \"Month\" >= 1 LIMIT 6","hsqls":["SELECT ArrDel15 FROM mytable WHERE DestCityName IN ('Hilo, HI', 'Indianapolis, IN') AND DestCityName BETWEEN 'Christiansted, VI' AND 'Bismarck/Mandan, ND' AND `Month` >= 1 LIMIT 6"]}
{"sql":"SELECT OriginStateFips, DaysSinceEpoch, COUNT(OriginStateFips), AVG(CarrierDelay) FROM mytable GROUP BY OriginStateFips, DaysSinceEpoch  ORDER BY OriginStateFips, DaysSinceEpoch LIMIT 1","hsqls":["SELECT OriginStateFips, DaysSinceEpoch, COUNT(OriginStateFips), AVG(CarrierDelay) FROM mytable GROUP BY OriginStateFips, DaysSinceEpoch  ORDER BY OriginStateFips, DaysSinceEpoch LIMIT 1"]}
{"sql":"SELECT LateAircraftDelay FROM mytable WHERE ArrTime > 1449 OR Diverted BETWEEN 0 AND 0 LIMIT 10"}
{"sql":"SELECT DestWac, DivTailNums FROM mytable WHERE LongestAddGTime BETWEEN 31 AND 42 OR TotalAddGTime < 55 ORDER BY DivReachedDest, FlightNum LIMIT 20","hsqls":["SELECT DestWac, DivTailNums FROM mytable WHERE LongestAddGTime BETWEEN 31 AND 42 OR TotalAddGTime < 55 ORDER BY DivReachedDest, FlightNum LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, \"Year\" FROM mytable WHERE ArrDelayMinutes IN (122.0) ORDER BY Distance, ActualElapsedTime LIMIT 2","hsqls":["SELECT OriginAirportSeqID, `Year` FROM mytable WHERE ArrDelayMinutes IN (122.0) ORDER BY Distance, ActualElapsedTime LIMIT 2"]}
{"sql":"SELECT Distance, SUM(\"Month\"), AVG(ArrDelayMinutes), SUM(TaxiIn) FROM mytable WHERE TaxiOut = 74 OR DayOfWeek IN (3, 6, 5) GROUP BY Distance LIMIT 23","hsqls":["SELECT Distance, SUM(`Month`), AVG(ArrDelayMinutes), SUM(TaxiIn) FROM mytable WHERE TaxiOut = 74 OR DayOfWeek IN (3, 6, 5) GROUP BY Distance LIMIT 23"]}
{"sql":"SELECT DepTime, COUNT(*) FROM mytable GROUP BY DepTime  ORDER BY DepTime LIMIT 27","hsqls":["SELECT DepTime, COUNT(*) FROM mytable GROUP BY DepTime  ORDER BY DepTime LIMIT 27"]}
{"sql":"SELECT OriginAirportSeqID, DivLongestGTimes FROM mytable ORDER BY CarrierDelay LIMIT 29","hsqls":["SELECT OriginAirportSeqID, DivLongestGTimes FROM mytable ORDER BY CarrierDelay LIMIT 10000"]}
{"sql":"SELECT TailNum FROM mytable WHERE DestAirportID BETWEEN 14520 AND 13930 AND DivTailNums IN ('N674MQ') AND ArrivalDelayGroups BETWEEN 9 AND 5 ORDER BY AirlineID LIMIT 19","hsqls":["SELECT TailNum FROM mytable WHERE DestAirportID BETWEEN 14520 AND 13930 AND (DivTailNums[1] IN ('N674MQ') OR DivTailNums[2] IN ('N674MQ') OR DivTailNums[3] IN ('N674MQ') OR DivTailNums[4] IN ('N674MQ') OR DivTailNums[5] IN ('N674MQ')) AND ArrivalDelayGroups BETWEEN 9 AND 5 ORDER BY AirlineID LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, DepDel15 FROM mytable WHERE CRSDepTime IN (832, 1218, 2001) OR ArrTime >= 1906 ORDER BY DestWac LIMIT 22"}
{"sql":"SELECT DivTailNums, DaysSinceEpoch FROM mytable ORDER BY DivArrDelay, OriginAirportID LIMIT 13","hsqls":["SELECT DivTailNums, DaysSinceEpoch FROM mytable ORDER BY DivArrDelay, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT Diverted, CRSDepTime, COUNT(*) FROM mytable WHERE DivReachedDest BETWEEN 0 AND -9999 GROUP BY Diverted, CRSDepTime  ORDER BY Diverted, CRSDepTime LIMIT 10","hsqls":["SELECT Diverted, CRSDepTime, COUNT(*) FROM mytable WHERE DivReachedDest BETWEEN 0 AND -9999 GROUP BY Diverted, CRSDepTime  ORDER BY Diverted, CRSDepTime LIMIT 10"]}
{"sql":"SELECT MIN(Cancelled), SUM(DistanceGroup), MAX(LateAircraftDelay) FROM mytable WHERE ActualElapsedTime IN (133, 186, 99) OR OriginCityMarketID BETWEEN 30279 AND 31641 LIMIT 13"}
{"sql":"SELECT TaxiOut, DayOfWeek FROM mytable WHERE CancellationCode BETWEEN 'B' AND 'A' AND OriginWac > 44 ORDER BY FlightDate, WheelsOn, UniqueCarrier"}
{"sql":"SELECT LongestAddGTime FROM mytable LIMIT 21"}
{"sql":"SELECT DepDel15 FROM mytable WHERE ArrDel15 IN (1, 0, -9999) ORDER BY LongestAddGTime, ArrDelayMinutes, Cancelled LIMIT 3"}
{"sql":"SELECT OriginWac, DivActualElapsedTime FROM mytable WHERE ArrDel15 >= 1 ORDER BY DepartureDelayGroups, Cancelled LIMIT 5"}
{"sql":"SELECT OriginStateFips, Quarter, CancellationCode FROM mytable WHERE CRSArrTime NOT IN (2140, 956, 2010, 1824, 947) OR ArrTimeBlk NOT IN ('2000-2059', '2200-2259', '0700-0759', '0600-0659', '0001-0559') ORDER BY SecurityDelay LIMIT 9"}
{"sql":"SELECT DistanceGroup, DivActualElapsedTime, OriginAirportID, AVG(Distance) FROM mytable WHERE NASDelay <= 56 AND FlightNum NOT IN (409, 573, 2093) OR DestWac BETWEEN 11 AND 12 GROUP BY DistanceGroup, DivActualElapsedTime, OriginAirportID  ORDER BY DistanceGroup, DivActualElapsedTime, OriginAirportID LIMIT 18","hsqls":["SELECT DistanceGroup, DivActualElapsedTime, OriginAirportID, AVG(Distance) FROM mytable WHERE NASDelay <= 56 AND FlightNum NOT IN (409, 573, 2093) OR DestWac BETWEEN 11 AND 12 GROUP BY DistanceGroup, DivActualElapsedTime, OriginAirportID  ORDER BY DistanceGroup, DivActualElapsedTime, OriginAirportID LIMIT 18"]}
{"sql":"SELECT DestAirportID FROM mytable WHERE CRSDepTime BETWEEN 1818 AND 1402 OR OriginState > 'CA' ORDER BY Diverted, DepTime, ArrTime LIMIT 22"}
{"sql":"SELECT OriginAirportSeqID, UniqueCarrier, AVG(OriginWac), SUM(WheelsOff), AVG(CRSArrTime) FROM mytable WHERE DivWheelsOffs BETWEEN 1150 AND 2138 GROUP BY OriginAirportSeqID, UniqueCarrier LIMIT 9","hsqls":["SELECT OriginAirportSeqID, UniqueCarrier, AVG(OriginWac), SUM(WheelsOff), AVG(CRSArrTime) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1150 AND 2138 OR DivWheelsOffs[2] BETWEEN 1150 AND 2138 OR DivWheelsOffs[3] BETWEEN 1150 AND 2138 OR DivWheelsOffs[4] BETWEEN 1150 AND 2138 OR DivWheelsOffs[5] BETWEEN 1150 AND 2138) GROUP BY OriginAirportSeqID, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT TaxiOut, WeatherDelay FROM mytable WHERE DivAirportSeqIDs IN (1410702, 1306104) LIMIT 13","hsqls":["SELECT TaxiOut, WeatherDelay FROM mytable WHERE (DivAirportSeqIDs[1] IN (1410702, 1306104) OR DivAirportSeqIDs[2] IN (1410702, 1306104) OR DivAirportSeqIDs[3] IN (1410702, 1306104) OR DivAirportSeqIDs[4] IN (1410702, 1306104) OR DivAirportSeqIDs[5] IN (1410702, 1306104)) LIMIT 10000"]}
{"sql":"SELECT DivTailNums, ArrDel15 FROM mytable WHERE UniqueCarrier BETWEEN 'AS' AND 'DL' ORDER BY Flights, ActualElapsedTime, NASDelay LIMIT 22","hsqls":["SELECT DivTailNums, ArrDel15 FROM mytable WHERE UniqueCarrier BETWEEN 'AS' AND 'DL' ORDER BY Flights, ActualElapsedTime, NASDelay LIMIT 10000"]}
{"sql":"SELECT WheelsOn FROM mytable ORDER BY OriginAirportSeqID, WheelsOff, AirlineID LIMIT 29"}
{"sql":"SELECT OriginState, FirstDepTime, Origin, MIN(OriginStateFips), MIN(DivArrDelay), COUNT(LongestAddGTime) FROM mytable WHERE CRSElapsedTime = 340 OR ArrDelayMinutes <> 59.0 OR CRSArrTime >= 801 GROUP BY OriginState, FirstDepTime, Origin  ORDER BY OriginState, FirstDepTime, Origin LIMIT 1","hsqls":["SELECT OriginState, FirstDepTime, Origin, MIN(OriginStateFips), MIN(DivArrDelay), COUNT(LongestAddGTime) FROM mytable WHERE CRSElapsedTime = 340 OR ArrDelayMinutes <> 59.0 OR CRSArrTime >= 801 GROUP BY OriginState, FirstDepTime, Origin  ORDER BY OriginState, FirstDepTime, Origin LIMIT 1"]}
{"sql":"SELECT DivWheelsOns FROM mytable ORDER BY Quarter, TaxiIn LIMIT 19","hsqls":["SELECT DivWheelsOns FROM mytable ORDER BY Quarter, TaxiIn LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, ActualElapsedTime, DivAirportIDs FROM mytable ORDER BY OriginCityMarketID, DivAirportLandings, WheelsOn LIMIT 12","hsqls":["SELECT DivReachedDest, ActualElapsedTime, DivAirportIDs FROM mytable ORDER BY OriginCityMarketID, DivAirportLandings, WheelsOn LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DaysSinceEpoch BETWEEN 16090 AND 16073 OR DivAirports BETWEEN 'SMF' AND 'SRQ' LIMIT 10","hsqls":["SELECT COUNT(*) FROM mytable WHERE DaysSinceEpoch BETWEEN 16090 AND 16073 OR (DivAirports[1] BETWEEN 'SMF' AND 'SRQ' OR DivAirports[2] BETWEEN 'SMF' AND 'SRQ' OR DivAirports[3] BETWEEN 'SMF' AND 'SRQ' OR DivAirports[4] BETWEEN 'SMF' AND 'SRQ' OR DivAirports[5] BETWEEN 'SMF' AND 'SRQ') LIMIT 10000"]}
{"sql":"SELECT WheelsOn, COUNT(*) FROM mytable GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 25","hsqls":["SELECT WheelsOn, COUNT(*) FROM mytable GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 25"]}
{"sql":"SELECT OriginWac FROM mytable WHERE LateAircraftDelay BETWEEN 14 AND 250 AND OriginCityMarketID BETWEEN 31401 AND 34520 ORDER BY OriginAirportSeqID, NASDelay, DivArrDelay LIMIT 17"}
{"sql":"SELECT TotalAddGTime, DivAirportLandings FROM mytable WHERE DestStateFips BETWEEN 37 AND 75 ORDER BY DepDel15, CRSDepTime LIMIT 18"}
{"sql":"SELECT SecurityDelay, DepTime, DestAirportID, COUNT(OriginAirportID) FROM mytable GROUP BY SecurityDelay, DepTime, DestAirportID  ORDER BY SecurityDelay, DepTime, DestAirportID LIMIT 6","hsqls":["SELECT SecurityDelay, DepTime, DestAirportID, COUNT(OriginAirportID) FROM mytable GROUP BY SecurityDelay, DepTime, DestAirportID  ORDER BY SecurityDelay, DepTime, DestAirportID LIMIT 6"]}
{"sql":"SELECT DestWac, FirstDepTime, OriginAirportID, AVG(DayofMonth), MIN(DayofMonth) FROM mytable WHERE DayOfWeek NOT IN (7, 6, 5, 4) GROUP BY DestWac, FirstDepTime, OriginAirportID  ORDER BY DestWac, FirstDepTime, OriginAirportID LIMIT 8","hsqls":["SELECT DestWac, FirstDepTime, OriginAirportID, AVG(DayofMonth), MIN(DayofMonth) FROM mytable WHERE DayOfWeek NOT IN (7, 6, 5, 4) GROUP BY DestWac, FirstDepTime, OriginAirportID  ORDER BY DestWac, FirstDepTime, OriginAirportID LIMIT 8"]}
{"sql":"SELECT ActualElapsedTime, COUNT(*) FROM mytable WHERE DivTailNums <= 'N940DN' AND ArrDel15 < 1 AND DestCityMarketID IN (35550, 34696) GROUP BY ActualElapsedTime LIMIT 17","hsqls":["SELECT ActualElapsedTime, COUNT(*) FROM mytable WHERE (DivTailNums[1] <= 'N940DN' OR DivTailNums[2] <= 'N940DN' OR DivTailNums[3] <= 'N940DN' OR DivTailNums[4] <= 'N940DN' OR DivTailNums[5] <= 'N940DN') AND ArrDel15 < 1 AND DestCityMarketID IN (35550, 34696) GROUP BY ActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT WheelsOff, ActualElapsedTime, COUNT(DepDelay), MAX(DivArrDelay), MAX(AirTime) FROM mytable WHERE TaxiIn <= 19 GROUP BY WheelsOff, ActualElapsedTime  ORDER BY WheelsOff, ActualElapsedTime LIMIT 15","hsqls":["SELECT WheelsOff, ActualElapsedTime, COUNT(DepDelay), MAX(DivArrDelay), MAX(AirTime) FROM mytable WHERE TaxiIn <= 19 GROUP BY WheelsOff, ActualElapsedTime  ORDER BY WheelsOff, ActualElapsedTime LIMIT 15"]}
{"sql":"SELECT OriginStateFips, MAX(OriginAirportSeqID), MIN(ArrDelay) FROM mytable WHERE DepDel15 <> 0 OR SecurityDelay IN (1, 0, 4, 18, 14) GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 20","hsqls":["SELECT OriginStateFips, MAX(OriginAirportSeqID), MIN(ArrDelay) FROM mytable WHERE DepDel15 <> 0 OR SecurityDelay IN (1, 0, 4, 18, 14) GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 20"]}
{"sql":"SELECT DistanceGroup, ActualElapsedTime, COUNT(*) FROM mytable GROUP BY DistanceGroup, ActualElapsedTime  ORDER BY DistanceGroup, ActualElapsedTime LIMIT 1","hsqls":["SELECT DistanceGroup, ActualElapsedTime, COUNT(*) FROM mytable GROUP BY DistanceGroup, ActualElapsedTime  ORDER BY DistanceGroup, ActualElapsedTime LIMIT 1"]}
{"sql":"SELECT Distance, DestCityName, AirTime, COUNT(*) FROM mytable GROUP BY Distance, DestCityName, AirTime  ORDER BY Distance, DestCityName, AirTime LIMIT 23","hsqls":["SELECT Distance, DestCityName, AirTime, COUNT(*) FROM mytable GROUP BY Distance, DestCityName, AirTime  ORDER BY Distance, DestCityName, AirTime LIMIT 23"]}
{"sql":"SELECT OriginCityName FROM mytable WHERE DistanceGroup = 11 OR CarrierDelay >= 105 AND ArrivalDelayGroups BETWEEN 6 AND 11 ORDER BY Diverted, FlightNum LIMIT 18"}
{"sql":"SELECT Origin, WheelsOn FROM mytable WHERE ArrDelayMinutes BETWEEN 343.0 AND 138.0 ORDER BY FlightNum LIMIT 20"}
{"sql":"SELECT MIN(DivDistance) FROM mytable LIMIT 18"}
{"sql":"SELECT DestWac, NASDelay, COUNT(*) FROM mytable WHERE FlightDate IN ('2014-01-22') AND DepDelayMinutes > 332.0 GROUP BY DestWac, NASDelay  ORDER BY DestWac, NASDelay LIMIT 16","hsqls":["SELECT DestWac, NASDelay, COUNT(*) FROM mytable WHERE FlightDate IN ('2014-01-22') AND DepDelayMinutes > 332.0 GROUP BY DestWac, NASDelay  ORDER BY DestWac, NASDelay LIMIT 16"]}
{"sql":"SELECT MIN(OriginAirportSeqID) FROM mytable WHERE ArrDelay >= 181.0 OR CRSElapsedTime NOT IN (251, 96, 333, 158) AND DestCityMarketID BETWEEN 30731 AND 33495 LIMIT 27"}
{"sql":"SELECT DestState, TotalAddGTime, TaxiIn FROM mytable ORDER BY Carrier, DepDelayMinutes, OriginStateName LIMIT 1"}
{"sql":"SELECT SUM(DepDel15), COUNT(AirTime) FROM mytable WHERE DivTailNums IN ('N3751B', 'N296WN', 'N416SW', 'N472WN') LIMIT 7","hsqls":["SELECT SUM(DepDel15), COUNT(AirTime) FROM mytable WHERE (DivTailNums[1] IN ('N3751B', 'N296WN', 'N416SW', 'N472WN') OR DivTailNums[2] IN ('N3751B', 'N296WN', 'N416SW', 'N472WN') OR DivTailNums[3] IN ('N3751B', 'N296WN', 'N416SW', 'N472WN') OR DivTailNums[4] IN ('N3751B', 'N296WN', 'N416SW', 'N472WN') OR DivTailNums[5] IN ('N3751B', 'N296WN', 'N416SW', 'N472WN')) LIMIT 10000"]}
{"sql":"SELECT DestWac, TailNum FROM mytable ORDER BY DestAirportSeqID LIMIT 3"}
{"sql":"SELECT OriginState, ArrDelay, DivArrDelay FROM mytable WHERE WheelsOn BETWEEN 1128 AND 1548 AND CRSDepTime < 1619 LIMIT 14"}
{"sql":"SELECT OriginAirportSeqID, ArrTimeBlk, COUNT(*) FROM mytable GROUP BY OriginAirportSeqID, ArrTimeBlk  ORDER BY OriginAirportSeqID, ArrTimeBlk LIMIT 26","hsqls":["SELECT OriginAirportSeqID, ArrTimeBlk, COUNT(*) FROM mytable GROUP BY OriginAirportSeqID, ArrTimeBlk  ORDER BY OriginAirportSeqID, ArrTimeBlk LIMIT 26"]}
{"sql":"SELECT FlightNum, ActualElapsedTime FROM mytable WHERE DepartureDelayGroups NOT IN (1, -1, 6, 11, 12) ORDER BY DistanceGroup, Dest LIMIT 23"}
{"sql":"SELECT DepDel15, \"Month\" FROM mytable WHERE OriginAirportSeqID BETWEEN 1020803 AND 1281902 OR ArrDel15 IN (1, 0, -9999) AND AirlineID IN (20398, 20437) ORDER BY DepDelay LIMIT 4","hsqls":["SELECT DepDel15, `Month` FROM mytable WHERE OriginAirportSeqID BETWEEN 1020803 AND 1281902 OR ArrDel15 IN (1, 0, -9999) AND AirlineID IN (20398, 20437) ORDER BY DepDelay LIMIT 4"]}
{"sql":"SELECT Carrier, ArrDelay, AVG(CRSDepTime), SUM(OriginCityMarketID), SUM(DepartureDelayGroups) FROM mytable WHERE DayofMonth <= 1 OR ActualElapsedTime BETWEEN 91 AND 253 GROUP BY Carrier, ArrDelay  ORDER BY Carrier, ArrDelay LIMIT 5","hsqls":["SELECT Carrier, ArrDelay, AVG(CRSDepTime), SUM(OriginCityMarketID), SUM(DepartureDelayGroups) FROM mytable WHERE DayofMonth <= 1 OR ActualElapsedTime BETWEEN 91 AND 253 GROUP BY Carrier, ArrDelay  ORDER BY Carrier, ArrDelay LIMIT 5"]}
{"sql":"SELECT DestCityName, DaysSinceEpoch, AVG(SecurityDelay), AVG(OriginAirportID) FROM mytable WHERE OriginStateName NOT IN ('Louisiana', 'Maine', 'West Virginia', 'Indiana', 'Rhode Island') OR CRSElapsedTime IN (200, 176) GROUP BY DestCityName, DaysSinceEpoch  ORDER BY DestCityName, DaysSinceEpoch LIMIT 12","hsqls":["SELECT DestCityName, DaysSinceEpoch, AVG(SecurityDelay), AVG(OriginAirportID) FROM mytable WHERE OriginStateName NOT IN ('Louisiana', 'Maine', 'West Virginia', 'Indiana', 'Rhode Island') OR CRSElapsedTime IN (200, 176) GROUP BY DestCityName, DaysSinceEpoch  ORDER BY DestCityName, DaysSinceEpoch LIMIT 12"]}
{"sql":"SELECT TotalAddGTime, DivActualElapsedTime FROM mytable ORDER BY OriginStateName LIMIT 4"}
{"sql":"SELECT AirlineID, COUNT(*) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 9","hsqls":["SELECT AirlineID, COUNT(*) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 9"]}
{"sql":"SELECT Carrier, DepDelayMinutes, CRSElapsedTime, COUNT(*) FROM mytable WHERE Flights BETWEEN 1 AND 1 AND DaysSinceEpoch BETWEEN 16083 AND 16078 OR CRSArrTime BETWEEN 2253 AND 1621 GROUP BY Carrier, DepDelayMinutes, CRSElapsedTime  ORDER BY Carrier, DepDelayMinutes, CRSElapsedTime LIMIT 17","hsqls":["SELECT Carrier, DepDelayMinutes, CRSElapsedTime, COUNT(*) FROM mytable WHERE Flights BETWEEN 1 AND 1 AND DaysSinceEpoch BETWEEN 16083 AND 16078 OR CRSArrTime BETWEEN 2253 AND 1621 GROUP BY Carrier, DepDelayMinutes, CRSElapsedTime  ORDER BY Carrier, DepDelayMinutes, CRSElapsedTime LIMIT 17"]}
{"sql":"SELECT FlightNum, Dest, COUNT(DestStateName), SUM(DivDistance) FROM mytable WHERE DivArrDelay <= 74 AND LateAircraftDelay >= 63 OR DepTimeBlk BETWEEN '1900-1959' AND '1500-1559' GROUP BY FlightNum, Dest  ORDER BY FlightNum, Dest LIMIT 14","hsqls":["SELECT FlightNum, Dest, COUNT(DestStateName), SUM(DivDistance) FROM mytable WHERE DivArrDelay <= 74 AND LateAircraftDelay >= 63 OR DepTimeBlk BETWEEN '1900-1959' AND '1500-1559' GROUP BY FlightNum, Dest  ORDER BY FlightNum, Dest LIMIT 14"]}
{"sql":"SELECT DepartureDelayGroups, DivWheelsOffs, DivTotalGTimes FROM mytable WHERE OriginCityName BETWEEN 'Wrangell, AK' AND 'Omaha, NE' AND OriginCityMarketID > 33792 AND DivAirports IN ('ACY') ORDER BY DestStateFips, ArrDel15 LIMIT 27","hsqls":["SELECT DepartureDelayGroups, DivWheelsOffs, DivTotalGTimes FROM mytable WHERE OriginCityName BETWEEN 'Wrangell, AK' AND 'Omaha, NE' AND OriginCityMarketID > 33792 AND (DivAirports[1] IN ('ACY') OR DivAirports[2] IN ('ACY') OR DivAirports[3] IN ('ACY') OR DivAirports[4] IN ('ACY') OR DivAirports[5] IN ('ACY')) ORDER BY DestStateFips, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT AVG(\"Year\"), MAX(WheelsOn), AVG(Cancelled) FROM mytable WHERE ArrDelayMinutes BETWEEN 106.0 AND 224.0 OR DestWac IN (65, 83, 72) LIMIT 14","hsqls":["SELECT AVG(`Year`), MAX(WheelsOn), AVG(Cancelled) FROM mytable WHERE ArrDelayMinutes BETWEEN 106.0 AND 224.0 OR DestWac IN (65, 83, 72) LIMIT 14"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE DestStateFips IN (42, 56, 55) ORDER BY ArrivalDelayGroups"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE AirlineID BETWEEN 19790 AND 19805 AND DepTimeBlk <= '1000-1059' LIMIT 20"}
{"sql":"SELECT DivLongestGTimes FROM mytable WHERE CRSArrTime IN (1947, 650, 1940, 50, 2242) OR OriginStateFips >= 75 ORDER BY OriginStateFips, DivActualElapsedTime LIMIT 4","hsqls":["SELECT DivLongestGTimes FROM mytable WHERE CRSArrTime IN (1947, 650, 1940, 50, 2242) OR OriginStateFips >= 75 ORDER BY OriginStateFips, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT Flights, DestStateFips, CRSDepTime FROM mytable ORDER BY FirstDepTime, DepTime LIMIT 9"}
{"sql":"SELECT FlightNum, ActualElapsedTime FROM mytable ORDER BY ArrDelayMinutes LIMIT 15"}
{"sql":"SELECT Dest, DivTotalGTimes FROM mytable WHERE DestAirportID BETWEEN 10423 AND 10140 AND NASDelay BETWEEN 2 AND 12 ORDER BY DepTimeBlk LIMIT 4","hsqls":["SELECT Dest, DivTotalGTimes FROM mytable WHERE DestAirportID BETWEEN 10423 AND 10140 AND NASDelay BETWEEN 2 AND 12 ORDER BY DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT Flights, LongestAddGTime, CarrierDelay, COUNT(\"Month\"), MAX(TaxiIn) FROM mytable WHERE DestState BETWEEN 'MS' AND 'MD' GROUP BY Flights, LongestAddGTime, CarrierDelay LIMIT 18","hsqls":["SELECT Flights, LongestAddGTime, CarrierDelay, COUNT(`Month`), MAX(TaxiIn) FROM mytable WHERE DestState BETWEEN 'MS' AND 'MD' GROUP BY Flights, LongestAddGTime, CarrierDelay LIMIT 18"]}
{"sql":"SELECT TailNum, DestCityMarketID, COUNT(*) FROM mytable WHERE DestAirportSeqID BETWEEN 1199603 AND 1425603 OR TotalAddGTime BETWEEN 78 AND 47 AND ArrivalDelayGroups >= 4 GROUP BY TailNum, DestCityMarketID","hsqls":["SELECT TailNum, DestCityMarketID, COUNT(*) FROM mytable WHERE DestAirportSeqID BETWEEN 1199603 AND 1425603 OR TotalAddGTime BETWEEN 78 AND 47 AND ArrivalDelayGroups >= 4 GROUP BY TailNum, DestCityMarketID"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE DestWac BETWEEN 12 AND 85 ORDER BY DepTimeBlk"}
{"sql":"SELECT LateAircraftDelay, ArrDel15, MIN(Diverted) FROM mytable WHERE OriginAirportSeqID BETWEEN 1087402 AND 1324402 OR DayOfWeek BETWEEN 1 AND 1 GROUP BY LateAircraftDelay, ArrDel15  ORDER BY LateAircraftDelay, ArrDel15 LIMIT 23","hsqls":["SELECT LateAircraftDelay, ArrDel15, MIN(Diverted) FROM mytable WHERE OriginAirportSeqID BETWEEN 1087402 AND 1324402 OR DayOfWeek BETWEEN 1 AND 1 GROUP BY LateAircraftDelay, ArrDel15  ORDER BY LateAircraftDelay, ArrDel15 LIMIT 23"]}
{"sql":"SELECT CarrierDelay, FlightDate, AVG(LongestAddGTime), SUM(FirstDepTime), COUNT(DepTime) FROM mytable GROUP BY CarrierDelay, FlightDate  ORDER BY CarrierDelay, FlightDate LIMIT 28","hsqls":["SELECT CarrierDelay, FlightDate, AVG(LongestAddGTime), SUM(FirstDepTime), COUNT(DepTime) FROM mytable GROUP BY CarrierDelay, FlightDate  ORDER BY CarrierDelay, FlightDate LIMIT 28"]}
{"sql":"SELECT DistanceGroup, DepDelay, Cancelled, COUNT(*) FROM mytable GROUP BY DistanceGroup, DepDelay, Cancelled  ORDER BY DistanceGroup, DepDelay, Cancelled LIMIT 1","hsqls":["SELECT DistanceGroup, DepDelay, Cancelled, COUNT(*) FROM mytable GROUP BY DistanceGroup, DepDelay, Cancelled  ORDER BY DistanceGroup, DepDelay, Cancelled LIMIT 1"]}
{"sql":"SELECT DepartureDelayGroups, DestWac, ArrDelay FROM mytable WHERE Diverted >= 1 AND DivAirportSeqIDs < 1410803 OR DestStateFips BETWEEN 31 AND 53 ORDER BY DepDelayMinutes LIMIT 15","hsqls":["SELECT DepartureDelayGroups, DestWac, ArrDelay FROM mytable WHERE Diverted >= 1 AND (DivAirportSeqIDs[1] < 1410803 OR DivAirportSeqIDs[2] < 1410803 OR DivAirportSeqIDs[3] < 1410803 OR DivAirportSeqIDs[4] < 1410803 OR DivAirportSeqIDs[5] < 1410803) OR DestStateFips BETWEEN 31 AND 53 ORDER BY DepDelayMinutes LIMIT 10000"]}
{"sql":"SELECT AVG(FlightNum), AVG(Distance), SUM(DivActualElapsedTime) FROM mytable WHERE CRSDepTime IN (1644, 1333, 1911) LIMIT 10"}
{"sql":"SELECT TaxiIn, DaysSinceEpoch FROM mytable WHERE OriginStateFips BETWEEN 16 AND 27 AND DivAirportIDs <= 15991 ORDER BY FlightNum, DaysSinceEpoch LIMIT 13","hsqls":["SELECT TaxiIn, DaysSinceEpoch FROM mytable WHERE OriginStateFips BETWEEN 16 AND 27 AND (DivAirportIDs[1] <= 15991 OR DivAirportIDs[2] <= 15991 OR DivAirportIDs[3] <= 15991 OR DivAirportIDs[4] <= 15991 OR DivAirportIDs[5] <= 15991) ORDER BY FlightNum, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT ArrDelay, MIN(ArrivalDelayGroups) FROM mytable WHERE FlightNum IN (5280) GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 17","hsqls":["SELECT ArrDelay, MIN(ArrivalDelayGroups) FROM mytable WHERE FlightNum IN (5280) GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 17"]}
{"sql":"SELECT TaxiOut, \"Year\" FROM mytable LIMIT 10","hsqls":["SELECT TaxiOut, `Year` FROM mytable LIMIT 10"]}
{"sql":"SELECT DivDistance, DestAirportSeqID, Origin, COUNT(DestAirportSeqID), COUNT(Diverted), MIN(CRSArrTime) FROM mytable GROUP BY DivDistance, DestAirportSeqID, Origin  ORDER BY DivDistance, DestAirportSeqID, Origin LIMIT 18","hsqls":["SELECT DivDistance, DestAirportSeqID, Origin, COUNT(DestAirportSeqID), COUNT(Diverted), MIN(CRSArrTime) FROM mytable GROUP BY DivDistance, DestAirportSeqID, Origin  ORDER BY DivDistance, DestAirportSeqID, Origin LIMIT 18"]}
{"sql":"SELECT OriginCityMarketID, NASDelay FROM mytable ORDER BY OriginStateFips, \"Month\" LIMIT 15","hsqls":["SELECT OriginCityMarketID, NASDelay FROM mytable ORDER BY OriginStateFips, `Month` LIMIT 15"]}
{"sql":"SELECT DepDelayMinutes, WheelsOn, OriginStateName FROM mytable WHERE OriginStateFips IN (6, 47, 55, 33, 13) ORDER BY OriginStateFips LIMIT 17"}
{"sql":"SELECT OriginAirportSeqID, ArrDel15, AirlineID FROM mytable LIMIT 19"}
{"sql":"SELECT Origin, DestAirportID, MIN(LateAircraftDelay), AVG(OriginWac), MAX(TaxiIn) FROM mytable WHERE DestCityMarketID IN (30747, 32389, 30189) AND DepDelayMinutes <> 134.0 GROUP BY Origin, DestAirportID  ORDER BY Origin, DestAirportID LIMIT 10","hsqls":["SELECT Origin, DestAirportID, MIN(LateAircraftDelay), AVG(OriginWac), MAX(TaxiIn) FROM mytable WHERE DestCityMarketID IN (30747, 32389, 30189) AND DepDelayMinutes <> 134.0 GROUP BY Origin, DestAirportID  ORDER BY Origin, DestAirportID LIMIT 10"]}
{"sql":"SELECT Quarter, ArrTimeBlk, UniqueCarrier FROM mytable WHERE DepDelayMinutes BETWEEN 114.0 AND 141.0 AND AirlineID < 19790 AND DestAirportSeqID IN (1244805, 1074702, 1073905, 1393003) ORDER BY FlightNum, SecurityDelay LIMIT 12"}
{"sql":"SELECT DepDelay, DestAirportSeqID, DivWheelsOffs FROM mytable WHERE Distance <> 1352 AND DivWheelsOns IN (1953, 1816) ORDER BY Origin LIMIT 27","hsqls":["SELECT DepDelay, DestAirportSeqID, DivWheelsOffs FROM mytable WHERE Distance <> 1352 AND (DivWheelsOns[1] IN (1953, 1816) OR DivWheelsOns[2] IN (1953, 1816) OR DivWheelsOns[3] IN (1953, 1816) OR DivWheelsOns[4] IN (1953, 1816) OR DivWheelsOns[5] IN (1953, 1816)) ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT CRSElapsedTime, MAX(WheelsOn), COUNT(ActualElapsedTime) FROM mytable WHERE TaxiIn NOT IN (25, 13, 140, 29) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 5","hsqls":["SELECT CRSElapsedTime, MAX(WheelsOn), COUNT(ActualElapsedTime) FROM mytable WHERE TaxiIn NOT IN (25, 13, 140, 29) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 5"]}
{"sql":"SELECT DestWac, DivAirports FROM mytable ORDER BY Quarter, Origin LIMIT 19","hsqls":["SELECT DestWac, DivAirports FROM mytable ORDER BY Quarter, Origin LIMIT 10000"]}
{"sql":"SELECT ArrTime, ArrivalDelayGroups, DaysSinceEpoch, AVG(ActualElapsedTime), COUNT(Diverted) FROM mytable WHERE ArrTime BETWEEN 1804 AND 107 GROUP BY ArrTime, ArrivalDelayGroups, DaysSinceEpoch  ORDER BY ArrTime, ArrivalDelayGroups, DaysSinceEpoch LIMIT 11","hsqls":["SELECT ArrTime, ArrivalDelayGroups, DaysSinceEpoch, AVG(ActualElapsedTime), COUNT(Diverted) FROM mytable WHERE ArrTime BETWEEN 1804 AND 107 GROUP BY ArrTime, ArrivalDelayGroups, DaysSinceEpoch  ORDER BY ArrTime, ArrivalDelayGroups, DaysSinceEpoch LIMIT 11"]}
{"sql":"SELECT Distance, AirTime, DivActualElapsedTime, MAX(DivActualElapsedTime), SUM(WheelsOff) FROM mytable WHERE NASDelay >= 305 AND DivActualElapsedTime IN (200, 232, 485, 307, 834) AND FirstDepTime BETWEEN 2009 AND 921 GROUP BY Distance, AirTime, DivActualElapsedTime  ORDER BY Distance, AirTime, DivActualElapsedTime LIMIT 8","hsqls":["SELECT Distance, AirTime, DivActualElapsedTime, MAX(DivActualElapsedTime), SUM(WheelsOff) FROM mytable WHERE NASDelay >= 305 AND DivActualElapsedTime IN (200, 232, 485, 307, 834) AND FirstDepTime BETWEEN 2009 AND 921 GROUP BY Distance, AirTime, DivActualElapsedTime  ORDER BY Distance, AirTime, DivActualElapsedTime LIMIT 8"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE Carrier BETWEEN 'MQ' AND 'HA' ORDER BY TaxiIn LIMIT 10","hsqls":["SELECT DivWheelsOns FROM mytable WHERE Carrier BETWEEN 'MQ' AND 'HA' ORDER BY TaxiIn LIMIT 10000"]}
{"sql":"SELECT DestCityName, DestCityMarketID, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE DivActualElapsedTime IN (433, 307, 834) GROUP BY DestCityName, DestCityMarketID, ArrivalDelayGroups  ORDER BY DestCityName, DestCityMarketID, ArrivalDelayGroups LIMIT 14","hsqls":["SELECT DestCityName, DestCityMarketID, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE DivActualElapsedTime IN (433, 307, 834) GROUP BY DestCityName, DestCityMarketID, ArrivalDelayGroups  ORDER BY DestCityName, DestCityMarketID, ArrivalDelayGroups LIMIT 14"]}
{"sql":"SELECT TaxiOut, WeatherDelay, ActualElapsedTime, MIN(WheelsOn), SUM(DepDelay) FROM mytable WHERE DepDel15 BETWEEN 0 AND -9999 AND DivTotalGTimes IN (2) AND DivTailNums BETWEEN 'N436WN' AND 'N986CA' GROUP BY TaxiOut, WeatherDelay, ActualElapsedTime LIMIT 4","hsqls":["SELECT TaxiOut, WeatherDelay, ActualElapsedTime, MIN(WheelsOn), SUM(DepDelay) FROM mytable WHERE DepDel15 BETWEEN 0 AND -9999 AND (DivTotalGTimes[1] IN (2) OR DivTotalGTimes[2] IN (2) OR DivTotalGTimes[3] IN (2) OR DivTotalGTimes[4] IN (2) OR DivTotalGTimes[5] IN (2)) AND (DivTailNums[1] BETWEEN 'N436WN' AND 'N986CA' OR DivTailNums[2] BETWEEN 'N436WN' AND 'N986CA' OR DivTailNums[3] BETWEEN 'N436WN' AND 'N986CA' OR DivTailNums[4] BETWEEN 'N436WN' AND 'N986CA' OR DivTailNums[5] BETWEEN 'N436WN' AND 'N986CA') GROUP BY TaxiOut, WeatherDelay, ActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DestAirportID FROM mytable WHERE ArrTimeBlk IN ('2200-2259') ORDER BY DestState LIMIT 5"}
{"sql":"SELECT Carrier FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND FirstDepTime NOT IN (944, 921) ORDER BY Quarter, ArrDelay LIMIT 26","hsqls":["SELECT Carrier FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND FirstDepTime NOT IN (944, 921) ORDER BY Quarter, ArrDelay LIMIT 26"]}
{"sql":"SELECT Dest, OriginAirportID FROM mytable WHERE DestStateName IN ('Wisconsin', 'Oregon') OR DaysSinceEpoch BETWEEN 16089 AND 16075 OR WheelsOff NOT IN (623, 1028) ORDER BY DivDistance, Flights, DepTimeBlk LIMIT 22"}
{"sql":"SELECT Diverted, MAX(ArrDel15) FROM mytable WHERE ArrTimeBlk <> '0900-0959' AND Origin BETWEEN 'SHV' AND 'RAP' AND DivActualElapsedTime IN (738, 227, 324, 305, 563) GROUP BY Diverted  ORDER BY Diverted LIMIT 7","hsqls":["SELECT Diverted, MAX(ArrDel15) FROM mytable WHERE ArrTimeBlk <> '0900-0959' AND Origin BETWEEN 'SHV' AND 'RAP' AND DivActualElapsedTime IN (738, 227, 324, 305, 563) GROUP BY Diverted  ORDER BY Diverted LIMIT 7"]}
{"sql":"SELECT DivAirportIDs, DepDel15, CancellationCode FROM mytable WHERE DestCityName < 'State College, PA' OR DivAirportIDs BETWEEN 10868 AND 11267 AND DivAirportLandings IN (2, 0, 9) ORDER BY DestStateName LIMIT 12","hsqls":["SELECT DivAirportIDs, DepDel15, CancellationCode FROM mytable WHERE DestCityName < 'State College, PA' OR (DivAirportIDs[1] BETWEEN 10868 AND 11267 OR DivAirportIDs[2] BETWEEN 10868 AND 11267 OR DivAirportIDs[3] BETWEEN 10868 AND 11267 OR DivAirportIDs[4] BETWEEN 10868 AND 11267 OR DivAirportIDs[5] BETWEEN 10868 AND 11267) AND DivAirportLandings IN (2, 0, 9) ORDER BY DestStateName LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes, ArrTimeBlk, CRSDepTime FROM mytable WHERE DestStateName BETWEEN 'West Virginia' AND 'Nebraska' ORDER BY DepTime LIMIT 4","hsqls":["SELECT DivLongestGTimes, ArrTimeBlk, CRSDepTime FROM mytable WHERE DestStateName BETWEEN 'West Virginia' AND 'Nebraska' ORDER BY DepTime LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, \"Year\", DivTailNums FROM mytable WHERE Carrier > 'F9' ORDER BY Carrier, WeatherDelay, OriginCityName LIMIT 22","hsqls":["SELECT DistanceGroup, Year, DivTailNums FROM mytable WHERE Carrier > 'F9' ORDER BY Carrier, WeatherDelay, OriginCityName LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, DepTimeBlk, DestAirportID, COUNT(*) FROM mytable WHERE DivDistance <= 813 OR Dest BETWEEN 'ACT' AND 'AEX' AND OriginCityName > 'Huntsville, AL' GROUP BY OriginStateFips, DepTimeBlk, DestAirportID  ORDER BY OriginStateFips, DepTimeBlk, DestAirportID LIMIT 5","hsqls":["SELECT OriginStateFips, DepTimeBlk, DestAirportID, COUNT(*) FROM mytable WHERE DivDistance <= 813 OR Dest BETWEEN 'ACT' AND 'AEX' AND OriginCityName > 'Huntsville, AL' GROUP BY OriginStateFips, DepTimeBlk, DestAirportID  ORDER BY OriginStateFips, DepTimeBlk, DestAirportID LIMIT 5"]}
{"sql":"SELECT OriginStateFips, FlightNum, \"Month\" FROM mytable WHERE DivReachedDest IN (0, -9999) AND DestAirportSeqID BETWEEN 1348602 AND 1467402 OR DivWheelsOffs BETWEEN 13 AND 2011 LIMIT 22","hsqls":["SELECT OriginStateFips, FlightNum, `Month` FROM mytable WHERE DivReachedDest IN (0, -9999) AND DestAirportSeqID BETWEEN 1348602 AND 1467402 OR (DivWheelsOffs[1] BETWEEN 13 AND 2011 OR DivWheelsOffs[2] BETWEEN 13 AND 2011 OR DivWheelsOffs[3] BETWEEN 13 AND 2011 OR DivWheelsOffs[4] BETWEEN 13 AND 2011 OR DivWheelsOffs[5] BETWEEN 13 AND 2011) LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, DepDelayMinutes, COUNT(*) FROM mytable GROUP BY LateAircraftDelay, DepDelayMinutes  ORDER BY LateAircraftDelay, DepDelayMinutes LIMIT 2","hsqls":["SELECT LateAircraftDelay, DepDelayMinutes, COUNT(*) FROM mytable GROUP BY LateAircraftDelay, DepDelayMinutes  ORDER BY LateAircraftDelay, DepDelayMinutes LIMIT 2"]}
{"sql":"SELECT MIN(DepTime) FROM mytable LIMIT 25"}
{"sql":"SELECT \"Year\", DestWac FROM mytable WHERE DepDelay IN (414.0, 174.0, 142.0, 38.0) AND Flights BETWEEN 1 AND 1 ORDER BY TailNum LIMIT 4","hsqls":["SELECT Year, DestWac FROM mytable WHERE DepDelay IN (414.0, 174.0, 142.0, 38.0) AND Flights BETWEEN 1 AND 1 ORDER BY TailNum LIMIT 4"]}
{"sql":"SELECT ActualElapsedTime, \"Month\", CRSElapsedTime FROM mytable WHERE OriginCityName NOT IN ('Little Rock, AR', 'Wrangell, AK', 'Austin, TX', 'Aguadilla, PR') LIMIT 4","hsqls":["SELECT ActualElapsedTime, Month, CRSElapsedTime FROM mytable WHERE OriginCityName NOT IN ('Little Rock, AR', 'Wrangell, AK', 'Austin, TX', 'Aguadilla, PR') LIMIT 4"]}
{"sql":"SELECT ArrTime, OriginStateName FROM mytable WHERE DayOfWeek NOT IN (3, 2) AND UniqueCarrier = 'F9' ORDER BY DivDistance LIMIT 16"}
{"sql":"SELECT DepTime, TotalAddGTime FROM mytable ORDER BY OriginStateFips LIMIT 11"}
{"sql":"SELECT DivDistance, TaxiIn, MIN(Diverted) FROM mytable WHERE LongestAddGTime NOT IN (2, 24, 103, 11, 38) OR DivTotalGTimes IN (54) GROUP BY DivDistance, TaxiIn LIMIT 21","hsqls":["SELECT DivDistance, TaxiIn, MIN(Diverted) FROM mytable WHERE LongestAddGTime NOT IN (2, 24, 103, 11, 38) OR (DivTotalGTimes[1] IN (54) OR DivTotalGTimes[2] IN (54) OR DivTotalGTimes[3] IN (54) OR DivTotalGTimes[4] IN (54) OR DivTotalGTimes[5] IN (54)) GROUP BY DivDistance, TaxiIn LIMIT 10000"]}
{"sql":"SELECT CRSElapsedTime, AVG(DestAirportID) FROM mytable WHERE FirstDepTime <= 1119 OR DivAirportSeqIDs BETWEEN 1215602 AND 1348502 GROUP BY CRSElapsedTime LIMIT 10","hsqls":["SELECT CRSElapsedTime, AVG(CAST(DestAirportID AS DOUBLE)) FROM mytable WHERE FirstDepTime <= 1119 OR (DivAirportSeqIDs[1] BETWEEN 1215602 AND 1348502 OR DivAirportSeqIDs[2] BETWEEN 1215602 AND 1348502 OR DivAirportSeqIDs[3] BETWEEN 1215602 AND 1348502 OR DivAirportSeqIDs[4] BETWEEN 1215602 AND 1348502 OR DivAirportSeqIDs[5] BETWEEN 1215602 AND 1348502) GROUP BY CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT Distance, DestStateFips, NASDelay, COUNT(NASDelay), AVG(FlightNum), MIN(CRSElapsedTime) FROM mytable GROUP BY Distance, DestStateFips, NASDelay  ORDER BY Distance, DestStateFips, NASDelay LIMIT 26","hsqls":["SELECT Distance, DestStateFips, NASDelay, COUNT(NASDelay), AVG(FlightNum), MIN(CRSElapsedTime) FROM mytable GROUP BY Distance, DestStateFips, NASDelay  ORDER BY Distance, DestStateFips, NASDelay LIMIT 26"]}
{"sql":"SELECT CRSElapsedTime FROM mytable WHERE TaxiOut BETWEEN 60 AND 36 OR OriginStateName IN ('Michigan', 'Puerto Rico', 'Hawaii', 'Florida') ORDER BY Distance, ArrTime LIMIT 8"}
{"sql":"SELECT CancellationCode, COUNT(*) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 27","hsqls":["SELECT CancellationCode, COUNT(*) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 27"]}
{"sql":"SELECT DivReachedDest, DestState, DivWheelsOffs FROM mytable WHERE WeatherDelay <> 47 AND ArrTimeBlk BETWEEN '1700-1759' AND '1200-1259' ORDER BY LateAircraftDelay, SecurityDelay, WheelsOn LIMIT 13","hsqls":["SELECT DivReachedDest, DestState, DivWheelsOffs FROM mytable WHERE WeatherDelay <> 47 AND ArrTimeBlk BETWEEN '1700-1759' AND '1200-1259' ORDER BY LateAircraftDelay, SecurityDelay, WheelsOn LIMIT 10000"]}
{"sql":"SELECT ArrTime, DepTimeBlk, OriginWac FROM mytable WHERE DayofMonth BETWEEN 18 AND 12 AND DayofMonth NOT IN (17) ORDER BY OriginCityName, ActualElapsedTime LIMIT 23"}
{"sql":"SELECT DestAirportSeqID, DestCityMarketID, \"Month\" FROM mytable WHERE CarrierDelay IN (44) OR WheelsOff BETWEEN 2301 AND 1623 AND Cancelled NOT IN (1, 0) LIMIT 14","hsqls":["SELECT DestAirportSeqID, DestCityMarketID, `Month` FROM mytable WHERE CarrierDelay IN (44) OR WheelsOff BETWEEN 2301 AND 1623 AND Cancelled NOT IN (1, 0) LIMIT 14"]}
{"sql":"SELECT DepartureDelayGroups, COUNT(*) FROM mytable WHERE DepartureDelayGroups >= 6 GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 22","hsqls":["SELECT DepartureDelayGroups, COUNT(*) FROM mytable WHERE DepartureDelayGroups >= 6 GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 22"]}
{"sql":"SELECT DivAirportLandings, DaysSinceEpoch FROM mytable ORDER BY Quarter LIMIT 27"}
{"sql":"SELECT WeatherDelay, DivAirportLandings, DestAirportID, MAX(TaxiOut) FROM mytable GROUP BY WeatherDelay, DivAirportLandings, DestAirportID  ORDER BY WeatherDelay, DivAirportLandings, DestAirportID LIMIT 27","hsqls":["SELECT WeatherDelay, DivAirportLandings, DestAirportID, MAX(TaxiOut) FROM mytable GROUP BY WeatherDelay, DivAirportLandings, DestAirportID  ORDER BY WeatherDelay, DivAirportLandings, DestAirportID LIMIT 27"]}
{"sql":"SELECT OriginStateFips FROM mytable WHERE AirTime <= 161 AND DivAirportIDs = 14487 AND ActualElapsedTime IN (173, 72, 142) ORDER BY TotalAddGTime, DayOfWeek LIMIT 25","hsqls":["SELECT OriginStateFips FROM mytable WHERE AirTime <= 161 AND (DivAirportIDs[1] = 14487 OR DivAirportIDs[2] = 14487 OR DivAirportIDs[3] = 14487 OR DivAirportIDs[4] = 14487 OR DivAirportIDs[5] = 14487) AND ActualElapsedTime IN (173, 72, 142) ORDER BY TotalAddGTime, DayOfWeek LIMIT 10000"]}
{"sql":"SELECT MAX(DivActualElapsedTime) FROM mytable WHERE Diverted <> 1 AND DivActualElapsedTime NOT IN (546, 401, 344, 249, 266) LIMIT 2"}
{"sql":"SELECT DivReachedDest FROM mytable WHERE SecurityDelay NOT IN (1, 0, 4, 27, -9999) OR DivArrDelay = 322 ORDER BY Origin, CRSDepTime LIMIT 7"}
{"sql":"SELECT SecurityDelay, ArrDel15, DivActualElapsedTime, COUNT(*) FROM mytable WHERE CRSArrTime <> 1802 GROUP BY SecurityDelay, ArrDel15, DivActualElapsedTime  ORDER BY SecurityDelay, ArrDel15, DivActualElapsedTime LIMIT 25","hsqls":["SELECT SecurityDelay, ArrDel15, DivActualElapsedTime, COUNT(*) FROM mytable WHERE CRSArrTime <> 1802 GROUP BY SecurityDelay, ArrDel15, DivActualElapsedTime  ORDER BY SecurityDelay, ArrDel15, DivActualElapsedTime LIMIT 25"]}
{"sql":"SELECT DestCityMarketID, CRSDepTime, AVG(ArrivalDelayGroups) FROM mytable WHERE Quarter NOT IN (1) GROUP BY DestCityMarketID, CRSDepTime  ORDER BY DestCityMarketID, CRSDepTime LIMIT 16","hsqls":["SELECT DestCityMarketID, CRSDepTime, AVG(ArrivalDelayGroups) FROM mytable WHERE Quarter NOT IN (1) GROUP BY DestCityMarketID, CRSDepTime  ORDER BY DestCityMarketID, CRSDepTime LIMIT 16"]}
{"sql":"SELECT COUNT(DestWac), AVG(Diverted), SUM(\"Year\") FROM mytable WHERE OriginWac NOT IN (45, 51, 37) OR ArrDelay BETWEEN 109.0 AND 211.0 AND TailNum > 'N3HHAA' LIMIT 3","hsqls":["SELECT COUNT(DestWac), AVG(Diverted), SUM(`Year`) FROM mytable WHERE OriginWac NOT IN (45, 51, 37) OR ArrDelay BETWEEN 109.0 AND 211.0 AND TailNum > 'N3HHAA' LIMIT 3"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(OriginAirportSeqID) FROM mytable WHERE DepTimeBlk BETWEEN '1000-1059' AND '1400-1459' GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 23","hsqls":["SELECT DaysSinceEpoch, COUNT(OriginAirportSeqID) FROM mytable WHERE DepTimeBlk BETWEEN '1000-1059' AND '1400-1459' GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 23"]}
{"sql":"SELECT ActualElapsedTime, OriginStateName FROM mytable ORDER BY WeatherDelay, ActualElapsedTime LIMIT 4"}
{"sql":"SELECT Distance FROM mytable WHERE DepDelayMinutes BETWEEN 257.0 AND 259.0 OR DestStateFips BETWEEN 13 AND 44 ORDER BY WheelsOff, Dest LIMIT 16"}
{"sql":"SELECT Diverted, COUNT(Origin), COUNT(ArrDel15), COUNT(FlightDate) FROM mytable GROUP BY Diverted  ORDER BY Diverted LIMIT 5","hsqls":["SELECT Diverted, COUNT(Origin), COUNT(ArrDel15), COUNT(FlightDate) FROM mytable GROUP BY Diverted  ORDER BY Diverted LIMIT 5"]}
{"sql":"SELECT DivArrDelay FROM mytable WHERE AirlineID IN (20304, 20398, 19393, 19790, 21171) ORDER BY ArrDel15, DestAirportID LIMIT 23"}
{"sql":"SELECT ActualElapsedTime, DestCityName, OriginStateName FROM mytable WHERE DivDistance BETWEEN 272 AND 74 AND LongestAddGTime IN (7, 73) OR DestCityMarketID NOT IN (33795, 31135) ORDER BY LateAircraftDelay LIMIT 17"}
{"sql":"SELECT TaxiIn, DestCityName, ArrivalDelayGroups FROM mytable WHERE ArrTimeBlk NOT IN ('2000-2059', '1000-1059', '1100-1159', '1200-1259', '1900-1959') OR DivLongestGTimes BETWEEN 3.0 AND 32.0 AND DepTime = 2154 ORDER BY Quarter, ArrTimeBlk, DivAirportLandings LIMIT 10","hsqls":["SELECT TaxiIn, DestCityName, ArrivalDelayGroups FROM mytable WHERE ArrTimeBlk NOT IN ('2000-2059', '1000-1059', '1100-1159', '1200-1259', '1900-1959') OR (DivLongestGTimes[1] BETWEEN 3.0 AND 32.0 OR DivLongestGTimes[2] BETWEEN 3.0 AND 32.0 OR DivLongestGTimes[3] BETWEEN 3.0 AND 32.0 OR DivLongestGTimes[4] BETWEEN 3.0 AND 32.0 OR DivLongestGTimes[5] BETWEEN 3.0 AND 32.0) AND DepTime = 2154 ORDER BY Quarter, ArrTimeBlk, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT DepTime, TaxiIn, TailNum FROM mytable WHERE AirlineID >= 20437 AND LongestAddGTime > 47 ORDER BY DestCityName, ArrivalDelayGroups, OriginStateName LIMIT 6"}
{"sql":"SELECT DestAirportSeqID FROM mytable WHERE DepDelayMinutes BETWEEN 286.0 AND 29.0 OR NASDelay <> 4 AND DivReachedDest NOT IN (1) ORDER BY WheelsOff, TotalAddGTime, DestAirportSeqID LIMIT 9"}
{"sql":"SELECT NASDelay, ArrDelay FROM mytable ORDER BY Dest, ArrDel15 LIMIT 13"}
{"sql":"SELECT ArrTime, \"Month\", SUM(ArrDelayMinutes), COUNT(Cancelled), COUNT(ArrTime) FROM mytable GROUP BY ArrTime, \"Month\" LIMIT 3","hsqls":["SELECT ArrTime, Month, SUM(ArrDelayMinutes), COUNT(Cancelled), COUNT(ArrTime) FROM mytable GROUP BY ArrTime, `Month` LIMIT 3"]}
{"sql":"SELECT ActualElapsedTime FROM mytable ORDER BY DivReachedDest, Distance LIMIT 25"}
{"sql":"SELECT FlightDate FROM mytable WHERE OriginWac IN (35, 52, 72, 61, 12) AND ActualElapsedTime BETWEEN 139 AND 114 ORDER BY DestWac, TailNum LIMIT 24"}
{"sql":"SELECT ArrDelayMinutes, DestCityName, OriginWac, COUNT(LateAircraftDelay) FROM mytable WHERE LateAircraftDelay BETWEEN 250 AND 47 GROUP BY ArrDelayMinutes, DestCityName, OriginWac","hsqls":["SELECT ArrDelayMinutes, DestCityName, OriginWac, COUNT(LateAircraftDelay) FROM mytable WHERE LateAircraftDelay BETWEEN 250 AND 47 GROUP BY ArrDelayMinutes, DestCityName, OriginWac"]}
{"sql":"SELECT CRSDepTime, DivActualElapsedTime, AVG(DepDel15), MIN(Quarter) FROM mytable WHERE OriginStateName BETWEEN 'South Carolina' AND 'Illinois' OR OriginWac > 87 OR DepDelayMinutes < 580.0 GROUP BY CRSDepTime, DivActualElapsedTime  ORDER BY CRSDepTime, DivActualElapsedTime LIMIT 3","hsqls":["SELECT CRSDepTime, DivActualElapsedTime, AVG(DepDel15), MIN(Quarter) FROM mytable WHERE OriginStateName BETWEEN 'South Carolina' AND 'Illinois' OR OriginWac > 87 OR DepDelayMinutes < 580.0 GROUP BY CRSDepTime, DivActualElapsedTime  ORDER BY CRSDepTime, DivActualElapsedTime LIMIT 3"]}
{"sql":"SELECT LateAircraftDelay, OriginStateFips, DayOfWeek FROM mytable WHERE DivDistance IN (68, 577) AND DestAirportID NOT IN (14100, 10792, 13487) ORDER BY CRSArrTime, AirTime, DayofMonth LIMIT 25"}
{"sql":"SELECT DivWheelsOns, LateAircraftDelay, OriginCityName FROM mytable WHERE ArrTimeBlk BETWEEN '2200-2259' AND '1200-1259' AND ActualElapsedTime <> 373 OR Cancelled > 1 LIMIT 16","hsqls":["SELECT DivWheelsOns, LateAircraftDelay, OriginCityName FROM mytable WHERE ArrTimeBlk BETWEEN '2200-2259' AND '1200-1259' AND ActualElapsedTime <> 373 OR Cancelled > 1 LIMIT 10000"]}
{"sql":"SELECT TaxiOut, OriginWac, COUNT(TaxiIn) FROM mytable WHERE CRSDepTime NOT IN (1654, 1349) OR TaxiIn NOT IN (2, 8, 12, -9999) GROUP BY TaxiOut, OriginWac  ORDER BY TaxiOut, OriginWac LIMIT 7","hsqls":["SELECT TaxiOut, OriginWac, COUNT(TaxiIn) FROM mytable WHERE CRSDepTime NOT IN (1654, 1349) OR TaxiIn NOT IN (2, 8, 12, -9999) GROUP BY TaxiOut, OriginWac  ORDER BY TaxiOut, OriginWac LIMIT 7"]}
{"sql":"SELECT Diverted, FlightNum, AirTime FROM mytable WHERE LateAircraftDelay <= 39 AND ArrDelayMinutes BETWEEN 198.0 AND 238.0 ORDER BY DepartureDelayGroups LIMIT 23"}
{"sql":"SELECT DestStateName FROM mytable WHERE DivAirports <= 'ILM' AND DepDel15 > -9999 LIMIT 5","hsqls":["SELECT DestStateName FROM mytable WHERE (DivAirports[1] <= 'ILM' OR DivAirports[2] <= 'ILM' OR DivAirports[3] <= 'ILM' OR DivAirports[4] <= 'ILM' OR DivAirports[5] <= 'ILM') AND DepDel15 > -9999 LIMIT 10000"]}
{"sql":"SELECT COUNT(ArrTime) FROM mytable LIMIT 1"}
{"sql":"SELECT SecurityDelay, MIN(Diverted), MAX(Quarter) FROM mytable WHERE FirstDepTime <= 1136 OR FirstDepTime BETWEEN 1859 AND 726 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 17","hsqls":["SELECT SecurityDelay, MIN(Diverted), MAX(Quarter) FROM mytable WHERE FirstDepTime <= 1136 OR FirstDepTime BETWEEN 1859 AND 726 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 17"]}
{"sql":"SELECT OriginState, DestWac, Diverted FROM mytable ORDER BY Diverted, DestAirportID LIMIT 13"}
{"sql":"SELECT DestState, COUNT(NASDelay), MAX(ArrDelayMinutes) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 10","hsqls":["SELECT DestState, COUNT(NASDelay), MAX(ArrDelayMinutes) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 10"]}
{"sql":"SELECT DivReachedDest, DivAirportIDs, DestCityName FROM mytable ORDER BY TaxiOut, DepDel15 LIMIT 11","hsqls":["SELECT DivReachedDest, DivAirportIDs, DestCityName FROM mytable ORDER BY TaxiOut, DepDel15 LIMIT 10000"]}
{"sql":"SELECT AirTime, AVG(LongestAddGTime), AVG(OriginCityMarketID) FROM mytable GROUP BY AirTime  ORDER BY AirTime LIMIT 8","hsqls":["SELECT AirTime, AVG(LongestAddGTime), AVG(OriginCityMarketID) FROM mytable GROUP BY AirTime  ORDER BY AirTime LIMIT 8"]}
{"sql":"SELECT ActualElapsedTime, UniqueCarrier FROM mytable WHERE Distance BETWEEN 2288 AND 3711 ORDER BY DestStateFips, SecurityDelay, CancellationCode LIMIT 26"}
{"sql":"SELECT NASDelay, DepTimeBlk, ArrDelay, SUM(DestAirportID) FROM mytable WHERE DestAirportID <> 13476 OR Diverted NOT IN (1, 0) GROUP BY NASDelay, DepTimeBlk, ArrDelay  ORDER BY NASDelay, DepTimeBlk, ArrDelay LIMIT 10","hsqls":["SELECT NASDelay, DepTimeBlk, ArrDelay, SUM(DestAirportID) FROM mytable WHERE DestAirportID <> 13476 OR Diverted NOT IN (1, 0) GROUP BY NASDelay, DepTimeBlk, ArrDelay  ORDER BY NASDelay, DepTimeBlk, ArrDelay LIMIT 10"]}
{"sql":"SELECT WeatherDelay, ArrTimeBlk, MAX(OriginAirportSeqID), AVG(DaysSinceEpoch) FROM mytable WHERE AirlineID IN (20436, 19790, 20437, 19930, 21171) GROUP BY WeatherDelay, ArrTimeBlk  ORDER BY WeatherDelay, ArrTimeBlk LIMIT 23","hsqls":["SELECT WeatherDelay, ArrTimeBlk, MAX(OriginAirportSeqID), AVG(DaysSinceEpoch) FROM mytable WHERE AirlineID IN (20436, 19790, 20437, 19930, 21171) GROUP BY WeatherDelay, ArrTimeBlk  ORDER BY WeatherDelay, ArrTimeBlk LIMIT 23"]}
{"sql":"SELECT DivArrDelay FROM mytable ORDER BY OriginWac LIMIT 8"}
{"sql":"SELECT DestCityMarketID, AVG(WheelsOn) FROM mytable WHERE DivLongestGTimes <= 34.0 AND DivDistance = 416 AND DivWheelsOns BETWEEN 1026 AND 1623 GROUP BY DestCityMarketID LIMIT 24","hsqls":["SELECT DestCityMarketID, AVG(CAST(WheelsOn AS DOUBLE)) FROM mytable WHERE (DivLongestGTimes[1] <= 34.0 OR DivLongestGTimes[2] <= 34.0 OR DivLongestGTimes[3] <= 34.0 OR DivLongestGTimes[4] <= 34.0 OR DivLongestGTimes[5] <= 34.0) AND DivDistance = 416 AND (DivWheelsOns[1] BETWEEN 1026 AND 1623 OR DivWheelsOns[2] BETWEEN 1026 AND 1623 OR DivWheelsOns[3] BETWEEN 1026 AND 1623 OR DivWheelsOns[4] BETWEEN 1026 AND 1623 OR DivWheelsOns[5] BETWEEN 1026 AND 1623) GROUP BY DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, CRSDepTime FROM mytable WHERE CRSDepTime BETWEEN 2127 AND 659 ORDER BY FlightNum LIMIT 5"}
{"sql":"SELECT WheelsOff, COUNT(*) FROM mytable WHERE \"Year\" IN (2014) GROUP BY WheelsOff LIMIT 5","hsqls":["SELECT WheelsOff, COUNT(*) FROM mytable WHERE `Year` IN (2014) GROUP BY WheelsOff LIMIT 5"]}
{"sql":"SELECT DestWac, ArrTime, Origin, MAX(DestAirportSeqID), AVG(FlightNum) FROM mytable WHERE Flights > 1 OR Flights BETWEEN 1 AND 1 AND DayOfWeek = 2 GROUP BY DestWac, ArrTime, Origin  ORDER BY DestWac, ArrTime, Origin LIMIT 15","hsqls":["SELECT DestWac, ArrTime, Origin, MAX(DestAirportSeqID), AVG(FlightNum) FROM mytable WHERE Flights > 1 OR Flights BETWEEN 1 AND 1 AND DayOfWeek = 2 GROUP BY DestWac, ArrTime, Origin  ORDER BY DestWac, ArrTime, Origin LIMIT 15"]}
{"sql":"SELECT Quarter, TaxiIn, DivActualElapsedTime, AVG(DayOfWeek), COUNT(DistanceGroup), MAX(DivReachedDest) FROM mytable WHERE DivLongestGTimes IN (128.0) GROUP BY Quarter, TaxiIn, DivActualElapsedTime","hsqls":["SELECT Quarter, TaxiIn, DivActualElapsedTime, AVG(DayOfWeek), COUNT(DistanceGroup), MAX(DivReachedDest) FROM mytable WHERE (DivLongestGTimes[1] IN (128.0) OR DivLongestGTimes[2] IN (128.0) OR DivLongestGTimes[3] IN (128.0) OR DivLongestGTimes[4] IN (128.0) OR DivLongestGTimes[5] IN (128.0)) GROUP BY Quarter, TaxiIn, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, DestAirportSeqID, ArrDelay FROM mytable WHERE OriginAirportSeqID BETWEEN 1058102 AND 1426202 ORDER BY OriginState, OriginStateFips LIMIT 27"}
{"sql":"SELECT TotalAddGTime, DepTime, MAX(DivActualElapsedTime), MIN(DepTime), AVG(WheelsOn) FROM mytable WHERE DivTailNums <= 'N483AA' GROUP BY TotalAddGTime, DepTime LIMIT 23","hsqls":["SELECT TotalAddGTime, DepTime, MAX(DivActualElapsedTime), MIN(DepTime), AVG(WheelsOn) FROM mytable WHERE (DivTailNums[1] <= 'N483AA' OR DivTailNums[2] <= 'N483AA' OR DivTailNums[3] <= 'N483AA' OR DivTailNums[4] <= 'N483AA' OR DivTailNums[5] <= 'N483AA') GROUP BY TotalAddGTime, DepTime LIMIT 10000"]}
{"sql":"SELECT MIN(DivActualElapsedTime), MAX(WheelsOn), MAX(\"Month\") FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) LIMIT 17","hsqls":["SELECT MIN(DivActualElapsedTime), MAX(WheelsOn), MAX(`Month`) FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) LIMIT 17"]}
{"sql":"SELECT MAX(Flights), MAX(DepDel15), MIN(AirlineID) FROM mytable WHERE ArrDelayMinutes NOT IN (33.0, 27.0, 252.0) AND Origin BETWEEN 'SIT' AND 'TYS' OR OriginAirportSeqID >= 1251102 LIMIT 9"}
{"sql":"SELECT OriginCityMarketID, AirTime FROM mytable WHERE DistanceGroup IN (2, 10, 9, 8) AND OriginStateFips <> 54 AND SecurityDelay NOT IN (1, 18, 8, 27, 14) ORDER BY DivAirportLandings LIMIT 29"}
{"sql":"SELECT DivLongestGTimes, ArrTime, DivAirportLandings FROM mytable WHERE DestWac > 33 OR DepDelay IN (-9999.0, 133.0, 233.0, 8.0, 14.0) ORDER BY DepDelay, TotalAddGTime LIMIT 14","hsqls":["SELECT DivLongestGTimes, ArrTime, DivAirportLandings FROM mytable WHERE DestWac > 33 OR DepDelay IN (-9999.0, 133.0, 233.0, 8.0, 14.0) ORDER BY DepDelay, TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT OriginState, AirlineID, ArrivalDelayGroups, MAX(DivArrDelay), COUNT(LateAircraftDelay), COUNT(DepTime) FROM mytable WHERE CRSElapsedTime BETWEEN 267 AND 308 AND Dest IN ('SGU', 'MLI', 'BGR') OR Quarter BETWEEN 1 AND 1 GROUP BY OriginState, AirlineID, ArrivalDelayGroups  ORDER BY OriginState, AirlineID, ArrivalDelayGroups LIMIT 3","hsqls":["SELECT OriginState, AirlineID, ArrivalDelayGroups, MAX(DivArrDelay), COUNT(LateAircraftDelay), COUNT(DepTime) FROM mytable WHERE CRSElapsedTime BETWEEN 267 AND 308 AND Dest IN ('SGU', 'MLI', 'BGR') OR Quarter BETWEEN 1 AND 1 GROUP BY OriginState, AirlineID, ArrivalDelayGroups  ORDER BY OriginState, AirlineID, ArrivalDelayGroups LIMIT 3"]}
{"sql":"SELECT ArrDelayMinutes, DestAirportID FROM mytable WHERE ArrDelayMinutes <> 245.0 OR Cancelled >= 1 OR DistanceGroup BETWEEN 9 AND 11 ORDER BY DestWac, Diverted LIMIT 9"}
{"sql":"SELECT DestStateFips, DestAirportID FROM mytable WHERE OriginCityMarketID IN (34992) AND DivAirportSeqIDs = 1323002 ORDER BY Carrier, ArrDelayMinutes, OriginWac LIMIT 3","hsqls":["SELECT DestStateFips, DestAirportID FROM mytable WHERE OriginCityMarketID IN (34992) AND (DivAirportSeqIDs[1] = 1323002 OR DivAirportSeqIDs[2] = 1323002 OR DivAirportSeqIDs[3] = 1323002 OR DivAirportSeqIDs[4] = 1323002 OR DivAirportSeqIDs[5] = 1323002) ORDER BY Carrier, ArrDelayMinutes, OriginWac LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 15"}
{"sql":"SELECT DepartureDelayGroups, Cancelled, DivTotalGTimes FROM mytable WHERE DivLongestGTimes > 2.0 AND DivTotalGTimes IN (8, 73, 27) ORDER BY DayofMonth LIMIT 17","hsqls":["SELECT DepartureDelayGroups, Cancelled, DivTotalGTimes FROM mytable WHERE (DivLongestGTimes[1] > 2.0 OR DivLongestGTimes[2] > 2.0 OR DivLongestGTimes[3] > 2.0 OR DivLongestGTimes[4] > 2.0 OR DivLongestGTimes[5] > 2.0) AND (DivTotalGTimes[1] IN (8, 73, 27) OR DivTotalGTimes[2] IN (8, 73, 27) OR DivTotalGTimes[3] IN (8, 73, 27) OR DivTotalGTimes[4] IN (8, 73, 27) OR DivTotalGTimes[5] IN (8, 73, 27)) ORDER BY DayofMonth LIMIT 10000"]}
{"sql":"SELECT TaxiOut, SecurityDelay, DepTimeBlk FROM mytable WHERE FirstDepTime BETWEEN 227 AND 2110 OR DestCityName >= 'Cordova, AK' OR \"Year\" <= 2014 LIMIT 25","hsqls":["SELECT TaxiOut, SecurityDelay, DepTimeBlk FROM mytable WHERE FirstDepTime BETWEEN 227 AND 2110 OR DestCityName >= 'Cordova, AK' OR `Year` <= 2014 LIMIT 25"]}
{"sql":"SELECT Origin, DepTimeBlk, DayofMonth FROM mytable WHERE DivTotalGTimes < 45 OR DivTotalGTimes IN (97, 79, 56, 111) AND ArrTime IN (1750, 1009) ORDER BY DivAirportLandings, DaysSinceEpoch LIMIT 3","hsqls":["SELECT Origin, DepTimeBlk, DayofMonth FROM mytable WHERE (DivTotalGTimes[1] < 45 OR DivTotalGTimes[2] < 45 OR DivTotalGTimes[3] < 45 OR DivTotalGTimes[4] < 45 OR DivTotalGTimes[5] < 45) OR (DivTotalGTimes[1] IN (97, 79, 56, 111) OR DivTotalGTimes[2] IN (97, 79, 56, 111) OR DivTotalGTimes[3] IN (97, 79, 56, 111) OR DivTotalGTimes[4] IN (97, 79, 56, 111) OR DivTotalGTimes[5] IN (97, 79, 56, 111)) AND ArrTime IN (1750, 1009) ORDER BY DivAirportLandings, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT \"Month\", AVG(\"Month\"), AVG(AirTime) FROM mytable GROUP BY \"Month\" LIMIT 10","hsqls":["SELECT Month, AVG(`Month`), AVG(AirTime) FROM mytable GROUP BY `Month` LIMIT 10"]}
{"sql":"SELECT ArrDelayMinutes, WheelsOn, OriginAirportID FROM mytable WHERE CRSDepTime = 2205 OR DepDel15 NOT IN (1, 0, -9999) OR UniqueCarrier <= 'FL' ORDER BY TailNum, AirlineID, DivActualElapsedTime LIMIT 10"}
{"sql":"SELECT AVG(DayOfWeek) FROM mytable WHERE TailNum >= 'N7741C' LIMIT 9"}
{"sql":"SELECT AVG(DestStateFips), MAX(LateAircraftDelay), COUNT(FlightDate) FROM mytable LIMIT 15"}
{"sql":"SELECT OriginStateName, COUNT(*) FROM mytable WHERE AirlineID BETWEEN 19805 AND 20409 OR DivAirportIDs IN (10257, 15919) OR OriginState BETWEEN 'TN' AND 'NC' GROUP BY OriginStateName LIMIT 24","hsqls":["SELECT OriginStateName, COUNT(*) FROM mytable WHERE AirlineID BETWEEN 19805 AND 20409 OR (DivAirportIDs[1] IN (10257, 15919) OR DivAirportIDs[2] IN (10257, 15919) OR DivAirportIDs[3] IN (10257, 15919) OR DivAirportIDs[4] IN (10257, 15919) OR DivAirportIDs[5] IN (10257, 15919)) OR OriginState BETWEEN 'TN' AND 'NC' GROUP BY OriginStateName LIMIT 10000"]}
{"sql":"SELECT MIN(CarrierDelay), SUM(Diverted), SUM(DestWac) FROM mytable LIMIT 16"}
{"sql":"SELECT Dest, AVG(DaysSinceEpoch), SUM(OriginCityMarketID) FROM mytable GROUP BY Dest  ORDER BY Dest LIMIT 27","hsqls":["SELECT Dest, AVG(DaysSinceEpoch), SUM(OriginCityMarketID) FROM mytable GROUP BY Dest  ORDER BY Dest LIMIT 27"]}
{"sql":"SELECT DivDistance, CRSArrTime, FlightNum FROM mytable WHERE CRSElapsedTime <> 225 AND TaxiIn BETWEEN 84 AND 57 LIMIT 18"}
{"sql":"SELECT SecurityDelay, ArrDel15 FROM mytable WHERE Flights >= 1 OR TaxiOut BETWEEN 41 AND 71"}
{"sql":"SELECT DestAirportID, \"Month\", COUNT(*) FROM mytable WHERE FlightNum <> 4672 OR UniqueCarrier BETWEEN 'WN' AND 'WN' GROUP BY DestAirportID, \"Month\" LIMIT 15","hsqls":["SELECT DestAirportID, Month, COUNT(*) FROM mytable WHERE FlightNum <> 4672 OR UniqueCarrier BETWEEN 'WN' AND 'WN' GROUP BY DestAirportID, `Month` LIMIT 15"]}
{"sql":"SELECT \"Year\", DaysSinceEpoch, MIN(Quarter) FROM mytable GROUP BY \"Year\", DaysSinceEpoch LIMIT 15","hsqls":["SELECT Year, DaysSinceEpoch, MIN(Quarter) FROM mytable GROUP BY Year, DaysSinceEpoch LIMIT 15"]}
{"sql":"SELECT DaysSinceEpoch, SUM(DepTime) FROM mytable GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 18","hsqls":["SELECT DaysSinceEpoch, SUM(DepTime) FROM mytable GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 18"]}
{"sql":"SELECT CRSArrTime, DivWheelsOffs FROM mytable WHERE DivAirportIDs = 11921 AND LongestAddGTime BETWEEN 14 AND 148 AND Quarter BETWEEN 1 AND 1 LIMIT 29","hsqls":["SELECT CRSArrTime, DivWheelsOffs FROM mytable WHERE (DivAirportIDs[1] = 11921 OR DivAirportIDs[2] = 11921 OR DivAirportIDs[3] = 11921 OR DivAirportIDs[4] = 11921 OR DivAirportIDs[5] = 11921) AND LongestAddGTime BETWEEN 14 AND 148 AND Quarter BETWEEN 1 AND 1 LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, DestState, DepDel15, COUNT(*) FROM mytable GROUP BY FirstDepTime, DestState, DepDel15  ORDER BY FirstDepTime, DestState, DepDel15 LIMIT 18","hsqls":["SELECT FirstDepTime, DestState, DepDel15, COUNT(*) FROM mytable GROUP BY FirstDepTime, DestState, DepDel15  ORDER BY FirstDepTime, DestState, DepDel15 LIMIT 18"]}
{"sql":"SELECT NASDelay, Origin, SUM(CRSElapsedTime), MAX(FlightNum) FROM mytable WHERE DivActualElapsedTime IN (543, 193) GROUP BY NASDelay, Origin  ORDER BY NASDelay, Origin LIMIT 1","hsqls":["SELECT NASDelay, Origin, SUM(CRSElapsedTime), MAX(FlightNum) FROM mytable WHERE DivActualElapsedTime IN (543, 193) GROUP BY NASDelay, Origin  ORDER BY NASDelay, Origin LIMIT 1"]}
{"sql":"SELECT SUM(Flights) FROM mytable WHERE OriginAirportID >= 11638 LIMIT 25"}
{"sql":"SELECT WeatherDelay, MAX(\"Month\") FROM mytable WHERE ActualElapsedTime NOT IN (97, 128, 122, 241) GROUP BY WeatherDelay LIMIT 2","hsqls":["SELECT WeatherDelay, MAX(`Month`) FROM mytable WHERE ActualElapsedTime NOT IN (97, 128, 122, 241) GROUP BY WeatherDelay LIMIT 2"]}
{"sql":"SELECT Carrier, LongestAddGTime FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR DepartureDelayGroups BETWEEN 11 AND -9999 AND DivWheelsOffs BETWEEN 2135 AND 1955 LIMIT 20","hsqls":["SELECT Carrier, LongestAddGTime FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR DepartureDelayGroups BETWEEN 11 AND -9999 AND (DivWheelsOffs[1] BETWEEN 2135 AND 1955 OR DivWheelsOffs[2] BETWEEN 2135 AND 1955 OR DivWheelsOffs[3] BETWEEN 2135 AND 1955 OR DivWheelsOffs[4] BETWEEN 2135 AND 1955 OR DivWheelsOffs[5] BETWEEN 2135 AND 1955) LIMIT 10000"]}
{"sql":"SELECT NASDelay, OriginStateName FROM mytable ORDER BY FlightDate, DivAirportLandings LIMIT 17"}
{"sql":"SELECT DepTime, DepTimeBlk, CRSDepTime FROM mytable ORDER BY SecurityDelay, OriginStateName LIMIT 12"}
{"sql":"SELECT Diverted, \"Month\", COUNT(AirlineID), AVG(DivAirportLandings) FROM mytable WHERE ArrivalDelayGroups IN (1) OR DestCityName <> 'Muskegon, MI' GROUP BY Diverted, \"Month\" LIMIT 29","hsqls":["SELECT Diverted, Month, COUNT(AirlineID), AVG(DivAirportLandings) FROM mytable WHERE ArrivalDelayGroups IN (1) OR DestCityName <> 'Muskegon, MI' GROUP BY Diverted, `Month` LIMIT 29"]}
{"sql":"SELECT TaxiOut, DepDelayMinutes, DepDel15, COUNT(*) FROM mytable WHERE Origin NOT IN ('RIC', 'EVV', 'MRY', 'PSE') GROUP BY TaxiOut, DepDelayMinutes, DepDel15  ORDER BY TaxiOut, DepDelayMinutes, DepDel15 LIMIT 3","hsqls":["SELECT TaxiOut, DepDelayMinutes, DepDel15, COUNT(*) FROM mytable WHERE Origin NOT IN ('RIC', 'EVV', 'MRY', 'PSE') GROUP BY TaxiOut, DepDelayMinutes, DepDel15  ORDER BY TaxiOut, DepDelayMinutes, DepDel15 LIMIT 3"]}
{"sql":"SELECT Distance FROM mytable ORDER BY Diverted, AirlineID LIMIT 9"}
{"sql":"SELECT DivWheelsOns, DepDelayMinutes, CRSDepTime FROM mytable LIMIT 24","hsqls":["SELECT DivWheelsOns, DepDelayMinutes, CRSDepTime FROM mytable LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, NASDelay, DestAirportID FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'C' ORDER BY ArrDelayMinutes, CRSDepTime LIMIT 11"}
{"sql":"SELECT DivAirportLandings, COUNT(*) FROM mytable GROUP BY DivAirportLandings  ORDER BY DivAirportLandings LIMIT 12","hsqls":["SELECT DivAirportLandings, COUNT(*) FROM mytable GROUP BY DivAirportLandings  ORDER BY DivAirportLandings LIMIT 12"]}
{"sql":"SELECT LateAircraftDelay, DestStateFips, DivArrDelay, AVG(DestAirportID), COUNT(DivArrDelay), COUNT(ArrDel15) FROM mytable GROUP BY LateAircraftDelay, DestStateFips, DivArrDelay  ORDER BY LateAircraftDelay, DestStateFips, DivArrDelay LIMIT 1","hsqls":["SELECT LateAircraftDelay, DestStateFips, DivArrDelay, AVG(DestAirportID), COUNT(DivArrDelay), COUNT(ArrDel15) FROM mytable GROUP BY LateAircraftDelay, DestStateFips, DivArrDelay  ORDER BY LateAircraftDelay, DestStateFips, DivArrDelay LIMIT 1"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE OriginCityName BETWEEN 'Des Moines, IA' AND 'Brunswick, GA' OR ArrTime IN (1107) OR CRSDepTime BETWEEN 500 AND 851 ORDER BY LateAircraftDelay, Distance, DepDel15 LIMIT 4"}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE DivActualElapsedTime IN (996, 543, 231) AND WheelsOff NOT IN (1210, 625) OR ArrivalDelayGroups >= 8 ORDER BY DepTimeBlk, CancellationCode LIMIT 5"}
{"sql":"SELECT SecurityDelay, UniqueCarrier, COUNT(*) FROM mytable WHERE DivLongestGTimes = 20.0 GROUP BY SecurityDelay, UniqueCarrier LIMIT 19","hsqls":["SELECT SecurityDelay, UniqueCarrier, COUNT(*) FROM mytable WHERE (DivLongestGTimes[1] = 20.0 OR DivLongestGTimes[2] = 20.0 OR DivLongestGTimes[3] = 20.0 OR DivLongestGTimes[4] = 20.0 OR DivLongestGTimes[5] = 20.0) GROUP BY SecurityDelay, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT Carrier, FlightNum, DestAirportID FROM mytable ORDER BY OriginCityMarketID, CarrierDelay LIMIT 7"}
{"sql":"SELECT AirlineID, SUM(AirlineID), COUNT(CRSElapsedTime) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 10","hsqls":["SELECT AirlineID, SUM(AirlineID), COUNT(CRSElapsedTime) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 10"]}
{"sql":"SELECT MAX(DestStateFips) FROM mytable WHERE DaysSinceEpoch > 16091 LIMIT 29"}
{"sql":"SELECT COUNT(Flights), AVG(ArrDel15), AVG(AirlineID) FROM mytable WHERE DivLongestGTimes IN (55.0) LIMIT 12","hsqls":["SELECT COUNT(Flights), AVG(ArrDel15), AVG(AirlineID)  FROM mytable WHERE (DivLongestGTimes[1] IN (55.0) OR DivLongestGTimes[2] IN (55.0) OR DivLongestGTimes[3] IN (55.0) OR DivLongestGTimes[4] IN (55.0) OR DivLongestGTimes[5] IN (55.0)) LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, COUNT(DestAirportID) FROM mytable WHERE AirlineID > 20355 GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 24","hsqls":["SELECT DivReachedDest, COUNT(DestAirportID) FROM mytable WHERE AirlineID > 20355 GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 24"]}
{"sql":"SELECT Flights, CRSElapsedTime FROM mytable WHERE DivWheelsOffs IN (2142, 1857, 1216, 1729, 1231) OR WheelsOn BETWEEN 1521 AND 1846 ORDER BY Quarter LIMIT 21","hsqls":["SELECT Flights, CRSElapsedTime FROM mytable WHERE (DivWheelsOffs[1] IN (2142, 1857, 1216, 1729, 1231) OR DivWheelsOffs[2] IN (2142, 1857, 1216, 1729, 1231) OR DivWheelsOffs[3] IN (2142, 1857, 1216, 1729, 1231) OR DivWheelsOffs[4] IN (2142, 1857, 1216, 1729, 1231) OR DivWheelsOffs[5] IN (2142, 1857, 1216, 1729, 1231)) OR WheelsOn BETWEEN 1521 AND 1846 ORDER BY Quarter LIMIT 10000"]}
{"sql":"SELECT \"Year\", LongestAddGTime, SUM(NASDelay), MAX(ActualElapsedTime), AVG(DestWac) FROM mytable WHERE CRSElapsedTime BETWEEN 257 AND 224 AND DayofMonth NOT IN (20, 18, 13) OR DepTimeBlk >= '1600-1659' GROUP BY \"Year\", LongestAddGTime LIMIT 3","hsqls":["SELECT Year, LongestAddGTime, SUM(NASDelay), MAX(ActualElapsedTime), AVG(DestWac) FROM mytable WHERE CRSElapsedTime BETWEEN 257 AND 224 AND DayofMonth NOT IN (20, 18, 13) OR DepTimeBlk >= '1600-1659' GROUP BY Year, LongestAddGTime LIMIT 3"]}
{"sql":"SELECT Quarter, FlightDate, TailNum FROM mytable WHERE Cancelled > 1 AND DayofMonth NOT IN (21, 20, 18, 8, 14) ORDER BY OriginStateFips, CarrierDelay, Distance LIMIT 29"}
{"sql":"SELECT DivActualElapsedTime, SUM(TaxiOut), AVG(Quarter), MAX(Cancelled) FROM mytable WHERE OriginAirportID IN (10141, 14685, 13433, 13367, 10408) AND ArrivalDelayGroups >= 5 GROUP BY DivActualElapsedTime  ORDER BY DivActualElapsedTime LIMIT 12","hsqls":["SELECT DivActualElapsedTime, SUM(TaxiOut), AVG(Quarter), MAX(Cancelled) FROM mytable WHERE OriginAirportID IN (10141, 14685, 13433, 13367, 10408) AND ArrivalDelayGroups >= 5 GROUP BY DivActualElapsedTime  ORDER BY DivActualElapsedTime LIMIT 12"]}
{"sql":"SELECT DivWheelsOffs FROM mytable ORDER BY DepDelay, ArrDel15 LIMIT 4","hsqls":["SELECT DivWheelsOffs FROM mytable ORDER BY DepDelay, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, Distance, DepTime FROM mytable WHERE NASDelay BETWEEN 23 AND 11 OR DivTotalGTimes BETWEEN 48 AND 42 LIMIT 4","hsqls":["SELECT LateAircraftDelay, Distance, DepTime FROM mytable WHERE NASDelay BETWEEN 23 AND 11 OR (DivTotalGTimes[1] BETWEEN 48 AND 42 OR DivTotalGTimes[2] BETWEEN 48 AND 42 OR DivTotalGTimes[3] BETWEEN 48 AND 42 OR DivTotalGTimes[4] BETWEEN 48 AND 42 OR DivTotalGTimes[5] BETWEEN 48 AND 42) LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE LongestAddGTime <> 51 LIMIT 15"}
{"sql":"SELECT DestAirportSeqID, DestStateName, DivAirportLandings, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, DestStateName, DivAirportLandings  ORDER BY DestAirportSeqID, DestStateName, DivAirportLandings LIMIT 17","hsqls":["SELECT DestAirportSeqID, DestStateName, DivAirportLandings, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, DestStateName, DivAirportLandings  ORDER BY DestAirportSeqID, DestStateName, DivAirportLandings LIMIT 17"]}
{"sql":"SELECT Dest, SUM(Quarter), AVG(DivActualElapsedTime) FROM mytable WHERE OriginStateName = 'Puerto Rico' OR DivWheelsOns IN (1055, 1500, 2003, 1129, 939) GROUP BY Dest LIMIT 7","hsqls":["SELECT Dest, SUM(Quarter), AVG(DivActualElapsedTime) FROM mytable WHERE OriginStateName = 'Puerto Rico' OR (DivWheelsOns[1] IN (1055, 1500, 2003, 1129, 939) OR DivWheelsOns[2] IN (1055, 1500, 2003, 1129, 939) OR DivWheelsOns[3] IN (1055, 1500, 2003, 1129, 939) OR DivWheelsOns[4] IN (1055, 1500, 2003, 1129, 939) OR DivWheelsOns[5] IN (1055, 1500, 2003, 1129, 939)) GROUP BY Dest LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, AVG(DepDel15), COUNT(Distance) FROM mytable WHERE Quarter >= 1 GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 10","hsqls":["SELECT DepDelayMinutes, AVG(DepDel15), COUNT(Distance) FROM mytable WHERE Quarter >= 1 GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 10"]}
{"sql":"SELECT CRSArrTime, Cancelled, CRSDepTime, COUNT(*) FROM mytable GROUP BY CRSArrTime, Cancelled, CRSDepTime  ORDER BY CRSArrTime, Cancelled, CRSDepTime LIMIT 13","hsqls":["SELECT CRSArrTime, Cancelled, CRSDepTime, COUNT(*) FROM mytable GROUP BY CRSArrTime, Cancelled, CRSDepTime  ORDER BY CRSArrTime, Cancelled, CRSDepTime LIMIT 13"]}
{"sql":"SELECT CancellationCode, MIN(Flights), MAX(\"Month\") FROM mytable WHERE \"Month\" < 1 GROUP BY CancellationCode LIMIT 23","hsqls":["SELECT CancellationCode, MIN(Flights), MAX(`Month`) FROM mytable WHERE `Month` < 1 GROUP BY CancellationCode LIMIT 23"]}
{"sql":"SELECT DepDelayMinutes, TotalAddGTime, DestCityMarketID FROM mytable WHERE Flights NOT IN (1) AND OriginCityName > 'Duluth, MN' ORDER BY FlightDate, DepTimeBlk LIMIT 3"}
{"sql":"SELECT DestStateFips, ArrDelayMinutes, DepDel15, COUNT(*) FROM mytable GROUP BY DestStateFips, ArrDelayMinutes, DepDel15  ORDER BY DestStateFips, ArrDelayMinutes, DepDel15 LIMIT 21","hsqls":["SELECT DestStateFips, ArrDelayMinutes, DepDel15, COUNT(*) FROM mytable GROUP BY DestStateFips, ArrDelayMinutes, DepDel15  ORDER BY DestStateFips, ArrDelayMinutes, DepDel15 LIMIT 21"]}
{"sql":"SELECT DepTime FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND Distance IN (1389, 852, 744) AND AirTime NOT IN (181, 132, 259, 271) LIMIT 1"}
{"sql":"SELECT DivAirportLandings, UniqueCarrier FROM mytable WHERE OriginCityName NOT IN ('Tampa, FL', 'Pasco/Kennewick/Richland, WA') AND WheelsOn = 917 AND DivTotalGTimes BETWEEN 6 AND 67 ORDER BY Diverted, WeatherDelay LIMIT 18","hsqls":["SELECT DivAirportLandings, UniqueCarrier FROM mytable WHERE OriginCityName NOT IN ('Tampa, FL', 'Pasco/Kennewick/Richland, WA') AND WheelsOn = 917 AND (DivTotalGTimes[1] BETWEEN 6 AND 67 OR DivTotalGTimes[2] BETWEEN 6 AND 67 OR DivTotalGTimes[3] BETWEEN 6 AND 67 OR DivTotalGTimes[4] BETWEEN 6 AND 67 OR DivTotalGTimes[5] BETWEEN 6 AND 67) ORDER BY Diverted, WeatherDelay LIMIT 10000"]}
{"sql":"SELECT DestCityName, CRSElapsedTime FROM mytable ORDER BY CRSArrTime, AirTime LIMIT 7"}
{"sql":"SELECT Diverted, WeatherDelay, Dest, COUNT(OriginCityMarketID), MAX(Distance) FROM mytable GROUP BY Diverted, WeatherDelay, Dest  ORDER BY Diverted, WeatherDelay, Dest LIMIT 5","hsqls":["SELECT Diverted, WeatherDelay, Dest, COUNT(OriginCityMarketID), MAX(Distance) FROM mytable GROUP BY Diverted, WeatherDelay, Dest  ORDER BY Diverted, WeatherDelay, Dest LIMIT 5"]}
{"sql":"SELECT DestStateFips, Cancelled, DestAirportID FROM mytable WHERE NASDelay > 281 AND DivWheelsOns IN (2235, 1645, 819) ORDER BY Diverted, DaysSinceEpoch LIMIT 12","hsqls":["SELECT DestStateFips, Cancelled, DestAirportID FROM mytable WHERE NASDelay > 281 AND (DivWheelsOns[1] IN (2235, 1645, 819) OR DivWheelsOns[2] IN (2235, 1645, 819) OR DivWheelsOns[3] IN (2235, 1645, 819) OR DivWheelsOns[4] IN (2235, 1645, 819) OR DivWheelsOns[5] IN (2235, 1645, 819)) ORDER BY Diverted, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT Diverted, OriginCityName, Origin FROM mytable ORDER BY TaxiIn, DaysSinceEpoch LIMIT 27"}
{"sql":"SELECT DestWac, DayofMonth FROM mytable WHERE Flights BETWEEN 1 AND 1 OR \"Month\" BETWEEN 1 AND 1 ORDER BY LongestAddGTime, TailNum LIMIT 20","hsqls":["SELECT DestWac, DayofMonth FROM mytable WHERE Flights BETWEEN 1 AND 1 OR `Month` BETWEEN 1 AND 1 ORDER BY LongestAddGTime, TailNum LIMIT 20"]}
{"sql":"SELECT COUNT(DayofMonth), SUM(WeatherDelay), MAX(AirTime) FROM mytable WHERE TaxiOut >= 57 AND DivDistance BETWEEN 261 AND 190 LIMIT 15"}
{"sql":"SELECT OriginAirportSeqID, Diverted, Origin FROM mytable ORDER BY OriginStateName LIMIT 10"}
{"sql":"SELECT DestState FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) AND DestStateName IN ('Idaho', 'Kansas') LIMIT 17"}
{"sql":"SELECT DivReachedDest, DestStateFips FROM mytable WHERE DestAirportID <> 14831 OR \"Year\" = 2014 ORDER BY \"Month\" LIMIT 19","hsqls":["SELECT DivReachedDest, DestStateFips FROM mytable WHERE DestAirportID <> 14831 OR `Year` = 2014 ORDER BY `Month` LIMIT 19"]}
{"sql":"SELECT DivDistance, COUNT(FlightDate) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 8","hsqls":["SELECT DivDistance, COUNT(FlightDate) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 8"]}
{"sql":"SELECT Cancelled, DayofMonth, ArrivalDelayGroups FROM mytable WHERE DivAirportIDs IN (12892, 11630, 14492, 12217, 12173) AND DayOfWeek IN (3, 1, 5, 4) ORDER BY CarrierDelay, ArrDel15 LIMIT 22","hsqls":["SELECT Cancelled, DayofMonth, ArrivalDelayGroups FROM mytable WHERE (DivAirportIDs[1] IN (12892, 11630, 14492, 12217, 12173) OR DivAirportIDs[2] IN (12892, 11630, 14492, 12217, 12173) OR DivAirportIDs[3] IN (12892, 11630, 14492, 12217, 12173) OR DivAirportIDs[4] IN (12892, 11630, 14492, 12217, 12173) OR DivAirportIDs[5] IN (12892, 11630, 14492, 12217, 12173)) AND DayOfWeek IN (3, 1, 5, 4) ORDER BY CarrierDelay, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT SUM(TotalAddGTime) FROM mytable WHERE DivArrDelay NOT IN (67, 260) AND Carrier IN ('F9', 'B6') OR DepTime BETWEEN 2144 AND 1926 LIMIT 28"}
{"sql":"SELECT DivWheelsOns, DayofMonth FROM mytable WHERE TaxiIn BETWEEN 102 AND 140 OR WeatherDelay BETWEEN 62 AND 132 LIMIT 7","hsqls":["SELECT DivWheelsOns, DayofMonth FROM mytable WHERE TaxiIn BETWEEN 102 AND 140 OR WeatherDelay BETWEEN 62 AND 132 LIMIT 10000"]}
{"sql":"SELECT AVG(Distance), MIN(\"Month\") FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 LIMIT 4","hsqls":["SELECT AVG(Distance), MIN(`Month`) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 LIMIT 4"]}
{"sql":"SELECT OriginCityName, DivArrDelay, COUNT(DivActualElapsedTime) FROM mytable GROUP BY OriginCityName, DivArrDelay  ORDER BY OriginCityName, DivArrDelay LIMIT 10","hsqls":["SELECT OriginCityName, DivArrDelay, COUNT(DivActualElapsedTime) FROM mytable GROUP BY OriginCityName, DivArrDelay  ORDER BY OriginCityName, DivArrDelay LIMIT 10"]}
{"sql":"SELECT DivReachedDest, ActualElapsedTime, DivTotalGTimes FROM mytable WHERE TotalAddGTime <= 40 LIMIT 6","hsqls":["SELECT DivReachedDest, ActualElapsedTime, DivTotalGTimes FROM mytable WHERE TotalAddGTime <= 40 LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, CRSDepTime, COUNT(*) FROM mytable WHERE ActualElapsedTime > 363 GROUP BY DivReachedDest, CRSDepTime  ORDER BY DivReachedDest, CRSDepTime LIMIT 24","hsqls":["SELECT DivReachedDest, CRSDepTime, COUNT(*) FROM mytable WHERE ActualElapsedTime > 363 GROUP BY DivReachedDest, CRSDepTime  ORDER BY DivReachedDest, CRSDepTime LIMIT 24"]}
{"sql":"SELECT AVG(TotalAddGTime) FROM mytable LIMIT 10"}
{"sql":"SELECT DayOfWeek FROM mytable WHERE Cancelled < 1 OR Origin = 'COD' AND OriginCityName NOT IN ('Dallas, TX') ORDER BY DepartureDelayGroups, CRSArrTime LIMIT 19"}
{"sql":"SELECT ArrTimeBlk, AVG(TaxiOut), AVG(ActualElapsedTime) FROM mytable WHERE OriginAirportID BETWEEN 10754 AND 10279 GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 25","hsqls":["SELECT ArrTimeBlk, AVG(TaxiOut), AVG(ActualElapsedTime) FROM mytable WHERE OriginAirportID BETWEEN 10754 AND 10279 GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 25"]}
{"sql":"SELECT DestState FROM mytable WHERE Diverted <= 1 ORDER BY DepDelay, FlightDate, CRSElapsedTime LIMIT 28"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DayofMonth IN (1, 5) LIMIT 6"}
{"sql":"SELECT OriginCityName, SUM(TotalAddGTime), SUM(DivReachedDest) FROM mytable GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 26","hsqls":["SELECT OriginCityName, SUM(TotalAddGTime), SUM(DivReachedDest) FROM mytable GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 26"]}
{"sql":"SELECT CRSElapsedTime FROM mytable LIMIT 8"}
{"sql":"SELECT DestWac, LongestAddGTime, AirlineID FROM mytable ORDER BY DepartureDelayGroups, CRSArrTime, ArrTime LIMIT 18"}
{"sql":"SELECT LongestAddGTime, Origin, CRSDepTime, SUM(ArrDelayMinutes), MAX(CRSArrTime), SUM(DepartureDelayGroups) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) GROUP BY LongestAddGTime, Origin, CRSDepTime  ORDER BY LongestAddGTime, Origin, CRSDepTime LIMIT 2","hsqls":["SELECT LongestAddGTime, Origin, CRSDepTime, SUM(ArrDelayMinutes), MAX(CRSArrTime), SUM(DepartureDelayGroups) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) GROUP BY LongestAddGTime, Origin, CRSDepTime  ORDER BY LongestAddGTime, Origin, CRSDepTime LIMIT 2"]}
{"sql":"SELECT DivAirports, WeatherDelay, DepTimeBlk FROM mytable WHERE Cancelled BETWEEN 0 AND 0 AND DaysSinceEpoch >= 16098 OR Flights NOT IN (1) LIMIT 12","hsqls":["SELECT DivAirports, WeatherDelay, DepTimeBlk FROM mytable WHERE Cancelled BETWEEN 0 AND 0 AND DaysSinceEpoch >= 16098 OR Flights NOT IN (1) LIMIT 10000"]}
{"sql":"SELECT OriginState, DepDelay, Flights FROM mytable WHERE ArrDelay BETWEEN 106.0 AND -46.0 OR DestWac >= 12 ORDER BY FirstDepTime, Dest LIMIT 5"}
{"sql":"SELECT DepDelayMinutes, LongestAddGTime FROM mytable WHERE WheelsOff <= 2300 ORDER BY LongestAddGTime, ArrTime, Cancelled LIMIT 8"}
{"sql":"SELECT DepDelay, LateAircraftDelay, DivAirportIDs FROM mytable WHERE UniqueCarrier IN ('HA') ORDER BY OriginAirportSeqID, LateAircraftDelay, DepDel15 LIMIT 6","hsqls":["SELECT DepDelay, LateAircraftDelay, DivAirportIDs FROM mytable WHERE UniqueCarrier IN ('HA') ORDER BY OriginAirportSeqID, LateAircraftDelay, DepDel15 LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ActualElapsedTime <> 264 OR WheelsOff BETWEEN 722 AND 1243 LIMIT 20"}
{"sql":"SELECT OriginStateFips, FirstDepTime, DestState, AVG(DestAirportSeqID), COUNT(DepartureDelayGroups), MAX(ActualElapsedTime) FROM mytable WHERE DistanceGroup < 5 OR ArrTime <> 1755 OR WheelsOff IN (1138, 2225, 532, 643, 2010) GROUP BY OriginStateFips, FirstDepTime, DestState  ORDER BY OriginStateFips, FirstDepTime, DestState LIMIT 9","hsqls":["SELECT OriginStateFips, FirstDepTime, DestState, AVG(DestAirportSeqID), COUNT(DepartureDelayGroups), MAX(ActualElapsedTime) FROM mytable WHERE DistanceGroup < 5 OR ArrTime <> 1755 OR WheelsOff IN (1138, 2225, 532, 643, 2010) GROUP BY OriginStateFips, FirstDepTime, DestState  ORDER BY OriginStateFips, FirstDepTime, DestState LIMIT 9"]}
{"sql":"SELECT OriginAirportSeqID, WheelsOff, TailNum, AVG(\"Month\"), COUNT(DistanceGroup), MIN(DepDelay) FROM mytable WHERE CRSDepTime NOT IN (935, 1012, 1809) OR DivAirports IN ('SJC', 'FNT') GROUP BY OriginAirportSeqID, WheelsOff, TailNum LIMIT 20","hsqls":["SELECT OriginAirportSeqID, WheelsOff, TailNum, AVG(`Month`), COUNT(DistanceGroup), MIN(DepDelay) FROM mytable WHERE CRSDepTime NOT IN (935, 1012, 1809) OR (DivAirports[1] IN ('SJC', 'FNT') OR DivAirports[2] IN ('SJC', 'FNT') OR DivAirports[3] IN ('SJC', 'FNT') OR DivAirports[4] IN ('SJC', 'FNT') OR DivAirports[5] IN ('SJC', 'FNT')) GROUP BY OriginAirportSeqID, WheelsOff, TailNum LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, ArrDelayMinutes, NASDelay, COUNT(*) FROM mytable WHERE ArrDelayMinutes IN (108.0, 0.0, 82.0, 147.0, 87.0) OR Flights >= 1 GROUP BY LateAircraftDelay, ArrDelayMinutes, NASDelay  ORDER BY LateAircraftDelay, ArrDelayMinutes, NASDelay LIMIT 18","hsqls":["SELECT LateAircraftDelay, ArrDelayMinutes, NASDelay, COUNT(*) FROM mytable WHERE ArrDelayMinutes IN (108.0, 0.0, 82.0, 147.0, 87.0) OR Flights >= 1 GROUP BY LateAircraftDelay, ArrDelayMinutes, NASDelay  ORDER BY LateAircraftDelay, ArrDelayMinutes, NASDelay LIMIT 18"]}
{"sql":"SELECT DivDistance, COUNT(*) FROM mytable WHERE CRSElapsedTime = 76 AND DistanceGroup IN (3, 1, 5, 4) GROUP BY DivDistance  ORDER BY DivDistance LIMIT 14","hsqls":["SELECT DivDistance, COUNT(*) FROM mytable WHERE CRSElapsedTime = 76 AND DistanceGroup IN (3, 1, 5, 4) GROUP BY DivDistance  ORDER BY DivDistance LIMIT 14"]}
{"sql":"SELECT OriginState FROM mytable ORDER BY Distance, ArrDelayMinutes LIMIT 26"}
{"sql":"SELECT DistanceGroup FROM mytable WHERE DestAirportSeqID BETWEEN 1463502 AND 1338801 LIMIT 24"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrDel15 <> -9999 OR DistanceGroup IN (2)"}
{"sql":"SELECT MAX(OriginStateFips) FROM mytable WHERE FirstDepTime <= 835 AND ActualElapsedTime IN (109, 157, 361, 118) LIMIT 22"}
{"sql":"SELECT DivDistance, Carrier, UniqueCarrier, COUNT(*) FROM mytable WHERE DivTailNums BETWEEN 'N221SW' AND 'N638SW' GROUP BY DivDistance, Carrier, UniqueCarrier LIMIT 18","hsqls":["SELECT DivDistance, Carrier, UniqueCarrier, COUNT(*) FROM mytable WHERE (DivTailNums[1] BETWEEN 'N221SW' AND 'N638SW' OR DivTailNums[2] BETWEEN 'N221SW' AND 'N638SW' OR DivTailNums[3] BETWEEN 'N221SW' AND 'N638SW' OR DivTailNums[4] BETWEEN 'N221SW' AND 'N638SW' OR DivTailNums[5] BETWEEN 'N221SW' AND 'N638SW') GROUP BY DivDistance, Carrier, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT CRSArrTime FROM mytable ORDER BY FirstDepTime, ActualElapsedTime LIMIT 5"}
{"sql":"SELECT CRSArrTime FROM mytable ORDER BY WheelsOff LIMIT 16"}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE OriginStateFips NOT IN (47, 36, 15, 25, 27) AND NASDelay IN (113, 106, 25, 39) AND TailNum NOT IN ('N958UW', 'N913DL', 'N8603F', 'N779CA', 'N398SW') ORDER BY DivAirportLandings LIMIT 15"}
{"sql":"SELECT FirstDepTime, MIN(DivActualElapsedTime), MAX(DistanceGroup), MAX(ArrDelayMinutes) FROM mytable WHERE AirTime <= 200 OR Diverted > 1 OR CRSDepTime BETWEEN 612 AND 1653 GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 29","hsqls":["SELECT FirstDepTime, MIN(DivActualElapsedTime), MAX(DistanceGroup), MAX(ArrDelayMinutes) FROM mytable WHERE AirTime <= 200 OR Diverted > 1 OR CRSDepTime BETWEEN 612 AND 1653 GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 29"]}
{"sql":"SELECT DepartureDelayGroups, OriginAirportID, AVG(CRSElapsedTime), MIN(WheelsOff) FROM mytable WHERE LateAircraftDelay BETWEEN 77 AND 27 OR ArrDelay IN (262.0, -26.0, -58.0) AND OriginStateFips IN (1, 26) GROUP BY DepartureDelayGroups, OriginAirportID  ORDER BY DepartureDelayGroups, OriginAirportID LIMIT 13","hsqls":["SELECT DepartureDelayGroups, OriginAirportID, AVG(CRSElapsedTime), MIN(WheelsOff) FROM mytable WHERE LateAircraftDelay BETWEEN 77 AND 27 OR ArrDelay IN (262.0, -26.0, -58.0) AND OriginStateFips IN (1, 26) GROUP BY DepartureDelayGroups, OriginAirportID  ORDER BY DepartureDelayGroups, OriginAirportID LIMIT 13"]}
{"sql":"SELECT TotalAddGTime, ArrTimeBlk, DivWheelsOffs FROM mytable WHERE LateAircraftDelay BETWEEN 33 AND 32 OR DepDelay IN (246.0, 164.0, 171.0, 39.0, 340.0) OR DayOfWeek NOT IN (2, 7, 6, 4) ORDER BY WeatherDelay, UniqueCarrier LIMIT 28","hsqls":["SELECT TotalAddGTime, ArrTimeBlk, DivWheelsOffs FROM mytable WHERE LateAircraftDelay BETWEEN 33 AND 32 OR DepDelay IN (246.0, 164.0, 171.0, 39.0, 340.0) OR DayOfWeek NOT IN (2, 7, 6, 4) ORDER BY WeatherDelay, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT Diverted, DepTimeBlk, DivAirportLandings, COUNT(DepTimeBlk), MIN(TaxiOut), SUM(DepartureDelayGroups) FROM mytable WHERE OriginCityName BETWEEN 'Tyler, TX' AND 'Dayton, OH' AND OriginStateName <= 'New Hampshire' OR DivTotalGTimes BETWEEN 107 AND 62 GROUP BY Diverted, DepTimeBlk, DivAirportLandings LIMIT 29","hsqls":["SELECT Diverted, DepTimeBlk, DivAirportLandings, COUNT(DepTimeBlk), MIN(TaxiOut), SUM(DepartureDelayGroups) FROM mytable WHERE OriginCityName BETWEEN 'Tyler, TX' AND 'Dayton, OH' AND OriginStateName <= 'New Hampshire' OR (DivTotalGTimes[1] BETWEEN 107 AND 62 OR DivTotalGTimes[2] BETWEEN 107 AND 62 OR DivTotalGTimes[3] BETWEEN 107 AND 62 OR DivTotalGTimes[4] BETWEEN 107 AND 62 OR DivTotalGTimes[5] BETWEEN 107 AND 62) GROUP BY Diverted, DepTimeBlk, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT DivDistance, DivWheelsOffs FROM mytable WHERE DepDelay IN (58.0, 93.0, 8.0, 106.0, -18.0) OR Flights <= 1 OR NASDelay IN (202, 104, 60, 74) ORDER BY DestState, DepTimeBlk, UniqueCarrier LIMIT 24","hsqls":["SELECT DivDistance, DivWheelsOffs FROM mytable WHERE DepDelay IN (58.0, 93.0, 8.0, 106.0, -18.0) OR Flights <= 1 OR NASDelay IN (202, 104, 60, 74) ORDER BY DestState, DepTimeBlk, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE OriginStateFips NOT IN (42, 47, 51, 24, 75) OR DivTailNums IN ('N462WN') AND ArrivalDelayGroups < 7 ORDER BY CRSArrTime, DepTimeBlk LIMIT 11","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE OriginStateFips NOT IN (42, 47, 51, 24, 75) OR (DivTailNums[1] IN ('N462WN') OR DivTailNums[2] IN ('N462WN') OR DivTailNums[3] IN ('N462WN') OR DivTailNums[4] IN ('N462WN') OR DivTailNums[5] IN ('N462WN')) AND ArrivalDelayGroups < 7 ORDER BY CRSArrTime, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DayofMonth, COUNT(DivActualElapsedTime), AVG(Diverted), AVG(Flights) FROM mytable GROUP BY OriginAirportSeqID, DayofMonth  ORDER BY OriginAirportSeqID, DayofMonth LIMIT 18","hsqls":["SELECT OriginAirportSeqID, DayofMonth, COUNT(DivActualElapsedTime), AVG(Diverted), AVG(Flights) FROM mytable GROUP BY OriginAirportSeqID, DayofMonth  ORDER BY OriginAirportSeqID, DayofMonth LIMIT 18"]}
{"sql":"SELECT SUM(WheelsOn) FROM mytable LIMIT 23"}
{"sql":"SELECT Diverted, ArrDel15, OriginWac FROM mytable WHERE AirlineID BETWEEN 20436 AND 19805 ORDER BY CRSArrTime LIMIT 24"}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE DivActualElapsedTime <= 349 OR FirstDepTime NOT IN (1653, 721) ORDER BY TaxiOut, FirstDepTime LIMIT 17","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE DivActualElapsedTime <= 349 OR FirstDepTime NOT IN (1653, 721) ORDER BY TaxiOut, FirstDepTime LIMIT 10000"]}
{"sql":"SELECT Quarter, CRSArrTime, AVG(WheelsOff), MAX(DestWac) FROM mytable WHERE DestStateFips IN (9, 38) AND DaysSinceEpoch <= 16077 GROUP BY Quarter, CRSArrTime  ORDER BY Quarter, CRSArrTime LIMIT 5","hsqls":["SELECT Quarter, CRSArrTime, AVG(WheelsOff), MAX(DestWac) FROM mytable WHERE DestStateFips IN (9, 38) AND DaysSinceEpoch <= 16077 GROUP BY Quarter, CRSArrTime  ORDER BY Quarter, CRSArrTime LIMIT 5"]}
{"sql":"SELECT SecurityDelay FROM mytable WHERE DivTailNums BETWEEN 'N8319F' AND 'N960AT' OR Dest BETWEEN 'BQN' AND 'SAN' ORDER BY ArrivalDelayGroups LIMIT 26","hsqls":["SELECT SecurityDelay FROM mytable WHERE (DivTailNums[1] BETWEEN 'N8319F' AND 'N960AT' OR DivTailNums[2] BETWEEN 'N8319F' AND 'N960AT' OR DivTailNums[3] BETWEEN 'N8319F' AND 'N960AT' OR DivTailNums[4] BETWEEN 'N8319F' AND 'N960AT' OR DivTailNums[5] BETWEEN 'N8319F' AND 'N960AT') OR Dest BETWEEN 'BQN' AND 'SAN' ORDER BY ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT CarrierDelay FROM mytable WHERE FlightNum BETWEEN 5343 AND 4768 ORDER BY WheelsOff, ArrivalDelayGroups LIMIT 11"}
{"sql":"SELECT CRSArrTime, ArrivalDelayGroups, OriginStateName FROM mytable WHERE DivLongestGTimes BETWEEN 99.0 AND 79.0 ORDER BY AirTime, DaysSinceEpoch LIMIT 21","hsqls":["SELECT CRSArrTime, ArrivalDelayGroups, OriginStateName FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 99.0 AND 79.0 OR DivLongestGTimes[2] BETWEEN 99.0 AND 79.0 OR DivLongestGTimes[3] BETWEEN 99.0 AND 79.0 OR DivLongestGTimes[4] BETWEEN 99.0 AND 79.0 OR DivLongestGTimes[5] BETWEEN 99.0 AND 79.0) ORDER BY AirTime, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns, DepDelay, FlightDate FROM mytable ORDER BY FlightNum, OriginWac LIMIT 14","hsqls":["SELECT DivWheelsOns, DepDelay, FlightDate FROM mytable ORDER BY FlightNum, OriginWac LIMIT 10000"]}
{"sql":"SELECT DepDel15, DivArrDelay, MAX(CRSElapsedTime) FROM mytable WHERE TailNum NOT IN ('N001AA', 'N889AS', 'N314NB', 'N902MQ', 'N952DN') GROUP BY DepDel15, DivArrDelay  ORDER BY DepDel15, DivArrDelay LIMIT 28","hsqls":["SELECT DepDel15, DivArrDelay, MAX(CRSElapsedTime) FROM mytable WHERE TailNum NOT IN ('N001AA', 'N889AS', 'N314NB', 'N902MQ', 'N952DN') GROUP BY DepDel15, DivArrDelay  ORDER BY DepDel15, DivArrDelay LIMIT 28"]}
{"sql":"SELECT DistanceGroup, Quarter, DestCityName FROM mytable WHERE Distance BETWEEN 1138 AND 1147 ORDER BY OriginAirportSeqID, WheelsOff, FlightDate LIMIT 5"}
{"sql":"SELECT SecurityDelay FROM mytable WHERE OriginCityName <> 'Wilmington, NC' AND DepDelay IN (2.0) OR DivDistance <> 91 ORDER BY DepDelay LIMIT 10"}
{"sql":"SELECT WheelsOff, TaxiIn, DivArrDelay, COUNT(DistanceGroup), MIN(WheelsOff), MAX(Diverted) FROM mytable WHERE DivWheelsOffs IN (1231, 858, 2118) AND OriginWac BETWEEN 31 AND 14 OR CarrierDelay NOT IN (290) GROUP BY WheelsOff, TaxiIn, DivArrDelay LIMIT 10","hsqls":["SELECT WheelsOff, TaxiIn, DivArrDelay, COUNT(DistanceGroup), MIN(WheelsOff), MAX(Diverted) FROM mytable WHERE (DivWheelsOffs[1] IN (1231, 858, 2118) OR DivWheelsOffs[2] IN (1231, 858, 2118) OR DivWheelsOffs[3] IN (1231, 858, 2118) OR DivWheelsOffs[4] IN (1231, 858, 2118) OR DivWheelsOffs[5] IN (1231, 858, 2118)) AND OriginWac BETWEEN 31 AND 14 OR CarrierDelay NOT IN (290) GROUP BY WheelsOff, TaxiIn, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT FlightNum FROM mytable WHERE LateAircraftDelay > 132 LIMIT 25"}
{"sql":"SELECT DepDelay, Carrier, DepTimeBlk, SUM(DivArrDelay) FROM mytable GROUP BY DepDelay, Carrier, DepTimeBlk","hsqls":["SELECT DepDelay, Carrier, DepTimeBlk, SUM(DivArrDelay) FROM mytable GROUP BY DepDelay, Carrier, DepTimeBlk"]}
{"sql":"SELECT UniqueCarrier FROM mytable WHERE DivAirports IN ('MSO') OR OriginState IN ('CA') AND ArrTimeBlk <> '2200-2259' ORDER BY Origin, DivActualElapsedTime LIMIT 18","hsqls":["SELECT UniqueCarrier FROM mytable WHERE (DivAirports[1] IN ('MSO') OR DivAirports[2] IN ('MSO') OR DivAirports[3] IN ('MSO') OR DivAirports[4] IN ('MSO') OR DivAirports[5] IN ('MSO')) OR OriginState IN ('CA') AND ArrTimeBlk <> '2200-2259' ORDER BY Origin, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DivDistance, Dest FROM mytable WHERE DepDelay NOT IN (243.0) LIMIT 4"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestState BETWEEN 'WY' AND 'AK' OR ActualElapsedTime BETWEEN 261 AND 250 LIMIT 27"}
{"sql":"SELECT DepDelay, DivAirportIDs, DepDel15 FROM mytable LIMIT 9","hsqls":["SELECT DepDelay, DivAirportIDs, DepDel15 FROM mytable LIMIT 10000"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE DaysSinceEpoch BETWEEN 16073 AND 16100 AND Origin = 'DHN' AND Origin <= 'ACT' ORDER BY DepartureDelayGroups, DestWac, Carrier LIMIT 10"}
{"sql":"SELECT CRSDepTime FROM mytable WHERE CarrierDelay NOT IN (79, 174, 43, 228, 176) ORDER BY Quarter, DestAirportID LIMIT 1"}
{"sql":"SELECT Dest, SUM(SecurityDelay) FROM mytable WHERE DepDelay BETWEEN 198.0 AND 27.0 AND Flights <> 1 OR DestAirportID IN (10279, 11097, 10693) GROUP BY Dest  ORDER BY Dest LIMIT 5","hsqls":["SELECT Dest, SUM(SecurityDelay) FROM mytable WHERE DepDelay BETWEEN 198.0 AND 27.0 AND Flights <> 1 OR DestAirportID IN (10279, 11097, 10693) GROUP BY Dest  ORDER BY Dest LIMIT 5"]}
{"sql":"SELECT DivReachedDest, AVG(WheelsOff) FROM mytable WHERE CarrierDelay < 280 AND DestWac BETWEEN 2 AND 13 AND TaxiIn BETWEEN 162 AND 6 GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 10","hsqls":["SELECT DivReachedDest, AVG(WheelsOff) FROM mytable WHERE CarrierDelay < 280 AND DestWac BETWEEN 2 AND 13 AND TaxiIn BETWEEN 162 AND 6 GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 10"]}
{"sql":"SELECT MIN(NASDelay), MAX(DivReachedDest) FROM mytable WHERE DivAirportSeqIDs = 1474703 OR ActualElapsedTime BETWEEN 402 AND 535 OR DivWheelsOffs > 2338 LIMIT 3","hsqls":["SELECT MIN(NASDelay), MAX(DivReachedDest) FROM mytable WHERE (DivAirportSeqIDs[1] = 1474703 OR DivAirportSeqIDs[2] = 1474703 OR DivAirportSeqIDs[3] = 1474703 OR DivAirportSeqIDs[4] = 1474703 OR DivAirportSeqIDs[5] = 1474703) OR ActualElapsedTime BETWEEN 402 AND 535 OR (DivWheelsOffs[1] > 2338 OR DivWheelsOffs[2] > 2338 OR DivWheelsOffs[3] > 2338 OR DivWheelsOffs[4] > 2338 OR DivWheelsOffs[5] > 2338) LIMIT 10000"]}
{"sql":"SELECT DestStateFips FROM mytable WHERE DepDel15 NOT IN (1, 0, -9999) OR DepartureDelayGroups NOT IN (2, 4) OR DepDelayMinutes BETWEEN 126.0 AND 140.0 LIMIT 26"}
{"sql":"SELECT Diverted, DestAirportID, DivArrDelay FROM mytable WHERE OriginCityName NOT IN ('Shreveport, LA') OR DestStateFips = 72 ORDER BY OriginCityName, DivArrDelay LIMIT 20"}
{"sql":"SELECT OriginState, Dest FROM mytable WHERE DestAirportSeqID BETWEEN 1201202 AND 1056103 OR Flights BETWEEN 1 AND 1 ORDER BY CRSElapsedTime LIMIT 23"}
{"sql":"SELECT Quarter, DestStateFips, UniqueCarrier, COUNT(*) FROM mytable WHERE LateAircraftDelay BETWEEN 182 AND 120 GROUP BY Quarter, DestStateFips, UniqueCarrier  ORDER BY Quarter, DestStateFips, UniqueCarrier LIMIT 2","hsqls":["SELECT Quarter, DestStateFips, UniqueCarrier, COUNT(*) FROM mytable WHERE LateAircraftDelay BETWEEN 182 AND 120 GROUP BY Quarter, DestStateFips, UniqueCarrier  ORDER BY Quarter, DestStateFips, UniqueCarrier LIMIT 2"]}
{"sql":"SELECT CRSArrTime FROM mytable LIMIT 14"}
{"sql":"SELECT OriginState, DivArrDelay, MIN(\"Year\") FROM mytable GROUP BY OriginState, DivArrDelay LIMIT 26","hsqls":["SELECT OriginState, DivArrDelay, MIN(`Year`) FROM mytable GROUP BY OriginState, DivArrDelay LIMIT 26"]}
{"sql":"SELECT DepartureDelayGroups, ArrTimeBlk, CRSElapsedTime, SUM(ArrDel15), AVG(DivActualElapsedTime) FROM mytable WHERE FlightDate >= '2014-01-03' GROUP BY DepartureDelayGroups, ArrTimeBlk, CRSElapsedTime  ORDER BY DepartureDelayGroups, ArrTimeBlk, CRSElapsedTime LIMIT 10","hsqls":["SELECT DepartureDelayGroups, ArrTimeBlk, CRSElapsedTime, SUM(ArrDel15), AVG(DivActualElapsedTime) FROM mytable WHERE FlightDate >= '2014-01-03' GROUP BY DepartureDelayGroups, ArrTimeBlk, CRSElapsedTime  ORDER BY DepartureDelayGroups, ArrTimeBlk, CRSElapsedTime LIMIT 10"]}
{"sql":"SELECT AirTime, AirlineID FROM mytable WHERE Distance BETWEEN 365 AND 1774 OR DepTimeBlk NOT IN ('1600-1659', '2000-2059', '1300-1359', '2300-2359') OR AirlineID < 19790 ORDER BY DepDelay, DepTime, Cancelled LIMIT 16"}
{"sql":"SELECT ArrDel15, OriginStateName FROM mytable WHERE OriginCityName BETWEEN 'International Falls, MN' AND 'Pensacola, FL' ORDER BY WeatherDelay, DayofMonth LIMIT 24"}
{"sql":"SELECT AVG(\"Month\"), AVG(WheelsOff) FROM mytable LIMIT 29","hsqls":["SELECT AVG(`Month`), AVG(WheelsOff) FROM mytable LIMIT 29"]}
{"sql":"SELECT WheelsOff, ArrTimeBlk, UniqueCarrier FROM mytable WHERE DepDel15 IN (1, 0, -9999) LIMIT 3"}
{"sql":"SELECT FirstDepTime, DepDelayMinutes, ArrDelay, SUM(DepDel15), AVG(ActualElapsedTime) FROM mytable WHERE ArrDel15 BETWEEN 0 AND -9999 OR OriginStateName BETWEEN 'U.S. Pacific Trust Territories and Possessions' AND 'South Carolina' OR \"Year\" NOT IN (2014) GROUP BY FirstDepTime, DepDelayMinutes, ArrDelay LIMIT 11","hsqls":["SELECT FirstDepTime, DepDelayMinutes, ArrDelay, SUM(DepDel15), AVG(ActualElapsedTime) FROM mytable WHERE ArrDel15 BETWEEN 0 AND -9999 OR OriginStateName BETWEEN 'U.S. Pacific Trust Territories and Possessions' AND 'South Carolina' OR `Year` NOT IN (2014) GROUP BY FirstDepTime, DepDelayMinutes, ArrDelay LIMIT 11"]}
{"sql":"SELECT ActualElapsedTime, DivAirportIDs, Dest FROM mytable LIMIT 9","hsqls":["SELECT ActualElapsedTime, DivAirportIDs, Dest FROM mytable LIMIT 10000"]}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups >= -1 AND DivWheelsOns BETWEEN 938 AND 1127 AND DestAirportID <= 11778 ORDER BY OriginStateFips, LongestAddGTime LIMIT 18","hsqls":["SELECT DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups >= -1 AND (DivWheelsOns[1] BETWEEN 938 AND 1127 OR DivWheelsOns[2] BETWEEN 938 AND 1127 OR DivWheelsOns[3] BETWEEN 938 AND 1127 OR DivWheelsOns[4] BETWEEN 938 AND 1127 OR DivWheelsOns[5] BETWEEN 938 AND 1127) AND DestAirportID <= 11778 ORDER BY OriginStateFips, LongestAddGTime LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, DepTime, COUNT(TaxiOut) FROM mytable WHERE DivAirportSeqIDs = 1015804 AND DepDelayMinutes NOT IN (359.0, 44.0, 151.0) OR NASDelay < 66 GROUP BY DivReachedDest, DepTime LIMIT 21","hsqls":["SELECT DivReachedDest, DepTime, COUNT(TaxiOut) FROM mytable WHERE (DivAirportSeqIDs[1] = 1015804 OR DivAirportSeqIDs[2] = 1015804 OR DivAirportSeqIDs[3] = 1015804 OR DivAirportSeqIDs[4] = 1015804 OR DivAirportSeqIDs[5] = 1015804) AND DepDelayMinutes NOT IN (359.0, 44.0, 151.0) OR NASDelay < 66 GROUP BY DivReachedDest, DepTime LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE OriginWac <= 23 AND DepDelay NOT IN (146.0, 580.0, 37.0, 127.0) ORDER BY LateAircraftDelay, DepDelayMinutes, ArrDel15 LIMIT 10"}
{"sql":"SELECT TotalAddGTime, \"Month\", OriginAirportID, COUNT(*) FROM mytable GROUP BY TotalAddGTime, \"Month\", OriginAirportID LIMIT 19","hsqls":["SELECT TotalAddGTime, Month, OriginAirportID, COUNT(*) FROM mytable GROUP BY TotalAddGTime, Month, OriginAirportID LIMIT 19"]}
{"sql":"SELECT ArrTimeBlk FROM mytable WHERE DestAirportSeqID BETWEEN 1298202 AND 1379502 ORDER BY DestAirportSeqID, DepTimeBlk LIMIT 10"}
{"sql":"SELECT Carrier, COUNT(*) FROM mytable WHERE FirstDepTime BETWEEN 1800 AND 550 AND DivAirportSeqIDs IN (1182304, 1075402) AND ArrDelayMinutes BETWEEN 95.0 AND 94.0 GROUP BY Carrier LIMIT 6","hsqls":["SELECT Carrier, COUNT(*) FROM mytable WHERE FirstDepTime BETWEEN 1800 AND 550 AND (DivAirportSeqIDs[1] IN (1182304, 1075402) OR DivAirportSeqIDs[2] IN (1182304, 1075402) OR DivAirportSeqIDs[3] IN (1182304, 1075402) OR DivAirportSeqIDs[4] IN (1182304, 1075402) OR DivAirportSeqIDs[5] IN (1182304, 1075402)) AND ArrDelayMinutes BETWEEN 95.0 AND 94.0 GROUP BY Carrier LIMIT 10000"]}
{"sql":"SELECT DestStateName, MAX(DestStateFips), COUNT(TaxiIn) FROM mytable WHERE Quarter >= 1 OR DivDistance BETWEEN 1036 AND 50 OR DivDistance BETWEEN 448 AND 696 GROUP BY DestStateName  ORDER BY DestStateName LIMIT 22","hsqls":["SELECT DestStateName, MAX(DestStateFips), COUNT(TaxiIn) FROM mytable WHERE Quarter >= 1 OR DivDistance BETWEEN 1036 AND 50 OR DivDistance BETWEEN 448 AND 696 GROUP BY DestStateName  ORDER BY DestStateName LIMIT 22"]}
{"sql":"SELECT ActualElapsedTime, AirTime FROM mytable WHERE Cancelled > 0 LIMIT 27"}
{"sql":"SELECT DivAirports, TotalAddGTime, Origin FROM mytable ORDER BY \"Year\", FlightNum, OriginCityName LIMIT 19","hsqls":["SELECT DivAirports, TotalAddGTime, Origin FROM mytable ORDER BY Year, FlightNum, OriginCityName LIMIT 10000"]}
{"sql":"SELECT COUNT(OriginCityName), AVG(DivActualElapsedTime) FROM mytable WHERE Flights IN (1) LIMIT 10"}
{"sql":"SELECT CRSArrTime, FlightDate, ArrDel15, COUNT(Dest), COUNT(FlightNum), COUNT(ArrivalDelayGroups) FROM mytable WHERE WheelsOn NOT IN (1402) AND DivTailNums BETWEEN 'N703TW' AND 'N216FR' OR DepDelayMinutes > 102.0 GROUP BY CRSArrTime, FlightDate, ArrDel15 LIMIT 27","hsqls":["SELECT CRSArrTime, FlightDate, ArrDel15, COUNT(Dest), COUNT(FlightNum), COUNT(ArrivalDelayGroups) FROM mytable WHERE WheelsOn NOT IN (1402) AND (DivTailNums[1] BETWEEN 'N703TW' AND 'N216FR' OR DivTailNums[2] BETWEEN 'N703TW' AND 'N216FR' OR DivTailNums[3] BETWEEN 'N703TW' AND 'N216FR' OR DivTailNums[4] BETWEEN 'N703TW' AND 'N216FR' OR DivTailNums[5] BETWEEN 'N703TW' AND 'N216FR') OR DepDelayMinutes > 102.0 GROUP BY CRSArrTime, FlightDate, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT NASDelay, DestCityName FROM mytable WHERE DepDelay BETWEEN 210.0 AND 65.0 LIMIT 10"}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE DestState BETWEEN 'SD' AND 'CO' AND DestAirportSeqID BETWEEN 1020803 AND 1342202 ORDER BY ArrTimeBlk, NASDelay LIMIT 25","hsqls":["SELECT DivAirportIDs FROM mytable WHERE DestState BETWEEN 'SD' AND 'CO' AND DestAirportSeqID BETWEEN 1020803 AND 1342202 ORDER BY ArrTimeBlk, NASDelay LIMIT 10000"]}
{"sql":"SELECT DivAirports, DestAirportID FROM mytable WHERE DestAirportID IN (14698, 13487, 11921, 10747, 11274) OR Dest <> 'SCC' ORDER BY CRSArrTime, CRSElapsedTime LIMIT 1","hsqls":["SELECT DivAirports, DestAirportID FROM mytable WHERE DestAirportID IN (14698, 13487, 11921, 10747, 11274) OR Dest <> 'SCC' ORDER BY CRSArrTime, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestState BETWEEN 'CA' AND 'NH' AND LongestAddGTime BETWEEN 60 AND 19 LIMIT 8"}
{"sql":"SELECT DivReachedDest, DivWheelsOns, OriginCityMarketID FROM mytable ORDER BY OriginCityMarketID LIMIT 29","hsqls":["SELECT DivReachedDest, DivWheelsOns, OriginCityMarketID FROM mytable ORDER BY OriginCityMarketID LIMIT 10000"]}
{"sql":"SELECT Carrier, FlightDate, DestCityName, COUNT(*) FROM mytable WHERE DepTimeBlk <= '0900-0959' GROUP BY Carrier, FlightDate, DestCityName  ORDER BY Carrier, FlightDate, DestCityName LIMIT 6","hsqls":["SELECT Carrier, FlightDate, DestCityName, COUNT(*) FROM mytable WHERE DepTimeBlk <= '0900-0959' GROUP BY Carrier, FlightDate, DestCityName  ORDER BY Carrier, FlightDate, DestCityName LIMIT 6"]}
{"sql":"SELECT DestCityName, COUNT(*) FROM mytable WHERE DepTime BETWEEN 420 AND 1123 AND DestCityName NOT IN ('Juneau, AK', 'Minot, ND', 'Lawton/Fort Sill, OK', 'Ketchikan, AK') GROUP BY DestCityName  ORDER BY DestCityName LIMIT 25","hsqls":["SELECT DestCityName, COUNT(*) FROM mytable WHERE DepTime BETWEEN 420 AND 1123 AND DestCityName NOT IN ('Juneau, AK', 'Minot, ND', 'Lawton/Fort Sill, OK', 'Ketchikan, AK') GROUP BY DestCityName  ORDER BY DestCityName LIMIT 25"]}
{"sql":"SELECT DestWac, LateAircraftDelay, ArrDel15, COUNT(*) FROM mytable GROUP BY DestWac, LateAircraftDelay, ArrDel15  ORDER BY DestWac, LateAircraftDelay, ArrDel15 LIMIT 12","hsqls":["SELECT DestWac, LateAircraftDelay, ArrDel15, COUNT(*) FROM mytable GROUP BY DestWac, LateAircraftDelay, ArrDel15  ORDER BY DestWac, LateAircraftDelay, ArrDel15 LIMIT 12"]}
{"sql":"SELECT OriginStateFips, MAX(DepartureDelayGroups) FROM mytable WHERE DestStateFips IN (2, 8) OR DepDelayMinutes < 192.0 GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 23","hsqls":["SELECT OriginStateFips, MAX(DepartureDelayGroups) FROM mytable WHERE DestStateFips IN (2, 8) OR DepDelayMinutes < 192.0 GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 23"]}
{"sql":"SELECT Carrier FROM mytable WHERE DepartureDelayGroups IN (10, -2) LIMIT 6"}
{"sql":"SELECT TaxiOut, DivArrDelay, COUNT(OriginStateFips) FROM mytable WHERE OriginAirportSeqID <= 1379602 OR OriginCityMarketID IN (31624, 31905, 30779, 30476) GROUP BY TaxiOut, DivArrDelay  ORDER BY TaxiOut, DivArrDelay LIMIT 8","hsqls":["SELECT TaxiOut, DivArrDelay, COUNT(OriginStateFips) FROM mytable WHERE OriginAirportSeqID <= 1379602 OR OriginCityMarketID IN (31624, 31905, 30779, 30476) GROUP BY TaxiOut, DivArrDelay  ORDER BY TaxiOut, DivArrDelay LIMIT 8"]}
{"sql":"SELECT DistanceGroup, DestWac, COUNT(*) FROM mytable WHERE FlightDate BETWEEN '2014-01-11' AND '2014-01-05' OR OriginWac BETWEEN 14 AND 41 GROUP BY DistanceGroup, DestWac  ORDER BY DistanceGroup, DestWac LIMIT 26","hsqls":["SELECT DistanceGroup, DestWac, COUNT(*) FROM mytable WHERE FlightDate BETWEEN '2014-01-11' AND '2014-01-05' OR OriginWac BETWEEN 14 AND 41 GROUP BY DistanceGroup, DestWac  ORDER BY DistanceGroup, DestWac LIMIT 26"]}
{"sql":"SELECT CRSArrTime, COUNT(*) FROM mytable WHERE CRSDepTime IN (1156, 2025, 905, 857) OR DivAirports <= 'RSW' GROUP BY CRSArrTime LIMIT 12","hsqls":["SELECT CRSArrTime, COUNT(*) FROM mytable WHERE CRSDepTime IN (1156, 2025, 905, 857) OR (DivAirports[1] <= 'RSW' OR DivAirports[2] <= 'RSW' OR DivAirports[3] <= 'RSW' OR DivAirports[4] <= 'RSW' OR DivAirports[5] <= 'RSW') GROUP BY CRSArrTime LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, SecurityDelay, Distance, COUNT(DivDistance) FROM mytable WHERE DayofMonth <= 22 OR DivDistance BETWEEN 181 AND 91 GROUP BY WeatherDelay, SecurityDelay, Distance  ORDER BY WeatherDelay, SecurityDelay, Distance LIMIT 17","hsqls":["SELECT WeatherDelay, SecurityDelay, Distance, COUNT(DivDistance) FROM mytable WHERE DayofMonth <= 22 OR DivDistance BETWEEN 181 AND 91 GROUP BY WeatherDelay, SecurityDelay, Distance  ORDER BY WeatherDelay, SecurityDelay, Distance LIMIT 17"]}
{"sql":"SELECT TaxiOut, DestWac, DestState FROM mytable WHERE FirstDepTime BETWEEN 2145 AND 612 OR UniqueCarrier BETWEEN 'MQ' AND 'VX' OR Diverted >= 1 ORDER BY Carrier, DivAirportLandings LIMIT 16"}
{"sql":"SELECT OriginAirportSeqID, DestAirportSeqID, COUNT(*) FROM mytable GROUP BY OriginAirportSeqID, DestAirportSeqID  ORDER BY OriginAirportSeqID, DestAirportSeqID LIMIT 12","hsqls":["SELECT OriginAirportSeqID, DestAirportSeqID, COUNT(*) FROM mytable GROUP BY OriginAirportSeqID, DestAirportSeqID  ORDER BY OriginAirportSeqID, DestAirportSeqID LIMIT 12"]}
{"sql":"SELECT CRSDepTime, AVG(TaxiIn) FROM mytable WHERE DestStateFips BETWEEN 46 AND 49 AND FirstDepTime BETWEEN 1859 AND 1957 AND DivWheelsOffs IN (2318, 918, 1010) GROUP BY CRSDepTime LIMIT 21","hsqls":["SELECT CRSDepTime, AVG(CAST(TaxiIn AS DOUBLE)) FROM mytable WHERE DestStateFips BETWEEN 46 AND 49 AND FirstDepTime BETWEEN 1859 AND 1957 AND (DivWheelsOffs[1] IN (2318, 918, 1010) OR DivWheelsOffs[2] IN (2318, 918, 1010) OR DivWheelsOffs[3] IN (2318, 918, 1010) OR DivWheelsOffs[4] IN (2318, 918, 1010) OR DivWheelsOffs[5] IN (2318, 918, 1010)) GROUP BY CRSDepTime LIMIT 10000"]}
{"sql":"SELECT WheelsOff, LongestAddGTime FROM mytable WHERE DivTotalGTimes BETWEEN 92 AND 49 AND ActualElapsedTime <> 274 OR WheelsOff BETWEEN 1033 AND 1318 ORDER BY FlightNum, FlightDate, SecurityDelay LIMIT 21","hsqls":["SELECT WheelsOff, LongestAddGTime FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 92 AND 49 OR DivTotalGTimes[2] BETWEEN 92 AND 49 OR DivTotalGTimes[3] BETWEEN 92 AND 49 OR DivTotalGTimes[4] BETWEEN 92 AND 49 OR DivTotalGTimes[5] BETWEEN 92 AND 49) AND ActualElapsedTime <> 274 OR WheelsOff BETWEEN 1033 AND 1318 ORDER BY FlightNum, FlightDate, SecurityDelay LIMIT 10000"]}
{"sql":"SELECT OriginCityName, AirTime FROM mytable WHERE OriginStateFips > 47 OR LateAircraftDelay BETWEEN 72 AND 250 OR OriginCityMarketID BETWEEN 32177 AND 32335 ORDER BY DepDelay, WeatherDelay LIMIT 17"}
{"sql":"SELECT OriginCityMarketID, AVG(FirstDepTime) FROM mytable GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 23","hsqls":["SELECT OriginCityMarketID, AVG(FirstDepTime) FROM mytable GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 23"]}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE Quarter NOT IN (1) AND AirTime IN (312, 273) OR DestState BETWEEN 'PR' AND 'LA' LIMIT 10","hsqls":["SELECT DivAirportIDs FROM mytable WHERE Quarter NOT IN (1) AND AirTime IN (312, 273) OR DestState BETWEEN 'PR' AND 'LA' LIMIT 10000"]}
{"sql":"SELECT DestCityMarketID FROM mytable WHERE WheelsOff < 1403 ORDER BY SecurityDelay, TailNum, ArrDelay LIMIT 20"}
{"sql":"SELECT Distance, CRSElapsedTime FROM mytable ORDER BY Cancelled, DepTimeBlk LIMIT 23"}
{"sql":"SELECT TaxiOut, DestStateName FROM mytable WHERE Carrier <> 'AA' LIMIT 29"}
{"sql":"SELECT ActualElapsedTime, ArrTime, MIN(CRSArrTime), COUNT(Distance) FROM mytable GROUP BY ActualElapsedTime, ArrTime  ORDER BY ActualElapsedTime, ArrTime LIMIT 18","hsqls":["SELECT ActualElapsedTime, ArrTime, MIN(CRSArrTime), COUNT(Distance) FROM mytable GROUP BY ActualElapsedTime, ArrTime  ORDER BY ActualElapsedTime, ArrTime LIMIT 18"]}
{"sql":"SELECT OriginCityName, ArrDelayMinutes, MIN(SecurityDelay), SUM(Quarter) FROM mytable WHERE DivReachedDest <> 0 GROUP BY OriginCityName, ArrDelayMinutes  ORDER BY OriginCityName, ArrDelayMinutes LIMIT 20","hsqls":["SELECT OriginCityName, ArrDelayMinutes, MIN(SecurityDelay), SUM(Quarter) FROM mytable WHERE DivReachedDest <> 0 GROUP BY OriginCityName, ArrDelayMinutes  ORDER BY OriginCityName, ArrDelayMinutes LIMIT 20"]}
{"sql":"SELECT ActualElapsedTime, DestAirportID, SUM(DestAirportID), AVG(AirlineID), AVG(DivActualElapsedTime) FROM mytable WHERE ArrDelay BETWEEN -34.0 AND -13.0 OR DestStateName BETWEEN 'Connecticut' AND 'Texas' GROUP BY ActualElapsedTime, DestAirportID  ORDER BY ActualElapsedTime, DestAirportID LIMIT 20","hsqls":["SELECT ActualElapsedTime, DestAirportID, SUM(DestAirportID), AVG(AirlineID), AVG(DivActualElapsedTime) FROM mytable WHERE ArrDelay BETWEEN -34.0 AND -13.0 OR DestStateName BETWEEN 'Connecticut' AND 'Texas' GROUP BY ActualElapsedTime, DestAirportID  ORDER BY ActualElapsedTime, DestAirportID LIMIT 20"]}
{"sql":"SELECT DepartureDelayGroups, AVG(DestAirportSeqID), SUM(DistanceGroup) FROM mytable WHERE LongestAddGTime BETWEEN 78 AND 47 OR TaxiOut IN (49, 57, 55) AND Diverted NOT IN (1, 0) GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 25","hsqls":["SELECT DepartureDelayGroups, AVG(DestAirportSeqID), SUM(DistanceGroup) FROM mytable WHERE LongestAddGTime BETWEEN 78 AND 47 OR TaxiOut IN (49, 57, 55) AND Diverted NOT IN (1, 0) GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 25"]}
{"sql":"SELECT DestWac, DestCityName, SUM(WheelsOff) FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 OR ArrivalDelayGroups <= 10 GROUP BY DestWac, DestCityName LIMIT 10","hsqls":["SELECT DestWac, DestCityName, SUM(WheelsOff) FROM mytable WHERE `Month` BETWEEN 1 AND 1 OR ArrivalDelayGroups <= 10 GROUP BY DestWac, DestCityName LIMIT 10"]}
{"sql":"SELECT AirlineID, AVG(DivReachedDest), AVG(Distance) FROM mytable WHERE DayOfWeek NOT IN (3, 7, 4) AND DivAirportSeqIDs BETWEEN 1537002 AND 1104202 OR DestAirportSeqID < 1232303 GROUP BY AirlineID LIMIT 24","hsqls":["SELECT AirlineID, AVG(DivReachedDest), AVG(Distance) FROM mytable WHERE DayOfWeek NOT IN (3, 7, 4) AND (DivAirportSeqIDs[1] BETWEEN 1537002 AND 1104202 OR DivAirportSeqIDs[2] BETWEEN 1537002 AND 1104202 OR DivAirportSeqIDs[3] BETWEEN 1537002 AND 1104202 OR DivAirportSeqIDs[4] BETWEEN 1537002 AND 1104202 OR DivAirportSeqIDs[5] BETWEEN 1537002 AND 1104202) OR DestAirportSeqID < 1232303 GROUP BY AirlineID LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE AirTime BETWEEN 480 AND 314 OR TaxiOut <> 42 AND NASDelay = 202 LIMIT 18"}
{"sql":"SELECT Quarter, SUM(TaxiOut), MAX(ArrDelayMinutes), SUM(DestCityMarketID) FROM mytable WHERE DistanceGroup > 4 OR AirlineID NOT IN (19690, 19930, 21171) GROUP BY Quarter  ORDER BY Quarter LIMIT 21","hsqls":["SELECT Quarter, SUM(TaxiOut), MAX(ArrDelayMinutes), SUM(DestCityMarketID) FROM mytable WHERE DistanceGroup > 4 OR AirlineID NOT IN (19690, 19930, 21171) GROUP BY Quarter  ORDER BY Quarter LIMIT 21"]}
{"sql":"SELECT SUM(DaysSinceEpoch) FROM mytable WHERE TailNum < 'N172US' LIMIT 29"}
{"sql":"SELECT ArrDelay, OriginStateName, AVG(\"Year\"), MIN(ArrDelay) FROM mytable GROUP BY ArrDelay, OriginStateName","hsqls":["SELECT ArrDelay, OriginStateName, AVG(`Year`), MIN(ArrDelay) FROM mytable GROUP BY ArrDelay, OriginStateName"]}
{"sql":"SELECT DestWac, ArrDelay, UniqueCarrier, MIN(TaxiIn) FROM mytable WHERE DepartureDelayGroups <> -9999 AND DestCityMarketID IN (30693, 31650, 31617, 31823) AND ArrDelayMinutes NOT IN (150.0, 201.0, 184.0, 181.0) GROUP BY DestWac, ArrDelay, UniqueCarrier  ORDER BY DestWac, ArrDelay, UniqueCarrier LIMIT 22","hsqls":["SELECT DestWac, ArrDelay, UniqueCarrier, MIN(TaxiIn) FROM mytable WHERE DepartureDelayGroups <> -9999 AND DestCityMarketID IN (30693, 31650, 31617, 31823) AND ArrDelayMinutes NOT IN (150.0, 201.0, 184.0, 181.0) GROUP BY DestWac, ArrDelay, UniqueCarrier  ORDER BY DestWac, ArrDelay, UniqueCarrier LIMIT 22"]}
{"sql":"SELECT DepartureDelayGroups, FirstDepTime, UniqueCarrier FROM mytable WHERE DivAirportIDs < 12478 ORDER BY DepTime LIMIT 29","hsqls":["SELECT DepartureDelayGroups, FirstDepTime, UniqueCarrier FROM mytable WHERE (DivAirportIDs[1] < 12478 OR DivAirportIDs[2] < 12478 OR DivAirportIDs[3] < 12478 OR DivAirportIDs[4] < 12478 OR DivAirportIDs[5] < 12478) ORDER BY DepTime LIMIT 10000"]}
{"sql":"SELECT DivDistance, Origin, COUNT(DivDistance), MIN(ActualElapsedTime) FROM mytable WHERE OriginAirportID NOT IN (15016, 13377) OR DestAirportID <= 15096 GROUP BY DivDistance, Origin","hsqls":["SELECT DivDistance, Origin, COUNT(DivDistance), MIN(ActualElapsedTime) FROM mytable WHERE OriginAirportID NOT IN (15016, 13377) OR DestAirportID <= 15096 GROUP BY DivDistance, Origin"]}
{"sql":"SELECT FirstDepTime, CarrierDelay, COUNT(*) FROM mytable WHERE DivLongestGTimes <= 61.0 GROUP BY FirstDepTime, CarrierDelay LIMIT 14","hsqls":["SELECT FirstDepTime, CarrierDelay, COUNT(*) FROM mytable WHERE (DivLongestGTimes[1] <= 61.0 OR DivLongestGTimes[2] <= 61.0 OR DivLongestGTimes[3] <= 61.0 OR DivLongestGTimes[4] <= 61.0 OR DivLongestGTimes[5] <= 61.0) GROUP BY FirstDepTime, CarrierDelay LIMIT 10000"]}
{"sql":"SELECT DestWac, OriginStateFips, MIN(ArrDelayMinutes), SUM(FirstDepTime), MIN(DepDelay) FROM mytable GROUP BY DestWac, OriginStateFips  ORDER BY DestWac, OriginStateFips LIMIT 17","hsqls":["SELECT DestWac, OriginStateFips, MIN(ArrDelayMinutes), SUM(FirstDepTime), MIN(DepDelay) FROM mytable GROUP BY DestWac, OriginStateFips  ORDER BY DestWac, OriginStateFips LIMIT 17"]}
{"sql":"SELECT DivAirports, DepTimeBlk, ArrivalDelayGroups FROM mytable WHERE OriginCityMarketID BETWEEN 33830 AND 30436 OR TaxiIn = 65 ORDER BY NASDelay, UniqueCarrier LIMIT 25","hsqls":["SELECT DivAirports, DepTimeBlk, ArrivalDelayGroups FROM mytable WHERE OriginCityMarketID BETWEEN 33830 AND 30436 OR TaxiIn = 65 ORDER BY NASDelay, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT ArrTimeBlk, SUM(CRSDepTime), COUNT(DestAirportID), MIN(CarrierDelay) FROM mytable WHERE DivTotalGTimes BETWEEN 25 AND 139 GROUP BY ArrTimeBlk LIMIT 10","hsqls":["SELECT ArrTimeBlk, SUM(CRSDepTime), COUNT(DestAirportID), MIN(CarrierDelay) FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 25 AND 139 OR DivTotalGTimes[2] BETWEEN 25 AND 139 OR DivTotalGTimes[3] BETWEEN 25 AND 139 OR DivTotalGTimes[4] BETWEEN 25 AND 139 OR DivTotalGTimes[5] BETWEEN 25 AND 139) GROUP BY ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT DivDistance, Carrier, WeatherDelay, SUM(LongestAddGTime), SUM(CRSElapsedTime) FROM mytable WHERE \"Month\" >= 1 AND DivAirportSeqIDs < 1043403 OR ArrivalDelayGroups BETWEEN -1 AND 3 GROUP BY DivDistance, Carrier, WeatherDelay LIMIT 24","hsqls":["SELECT DivDistance, Carrier, WeatherDelay, SUM(LongestAddGTime), SUM(CRSElapsedTime) FROM mytable WHERE `Month` >= 1 AND (DivAirportSeqIDs[1] < 1043403 OR DivAirportSeqIDs[2] < 1043403 OR DivAirportSeqIDs[3] < 1043403 OR DivAirportSeqIDs[4] < 1043403 OR DivAirportSeqIDs[5] < 1043403) OR ArrivalDelayGroups BETWEEN -1 AND 3 GROUP BY DivDistance, Carrier, WeatherDelay LIMIT 10000"]}
{"sql":"SELECT MIN(DivDistance), SUM(DestWac), MIN(CRSElapsedTime) FROM mytable WHERE DivActualElapsedTime >= 265 LIMIT 2"}
{"sql":"SELECT Carrier, OriginCityMarketID, DestCityName FROM mytable WHERE DepartureDelayGroups IN (6, 9, -9999) OR DepDelayMinutes IN (238.0, 36.0, 91.0, 135.0) ORDER BY DivDistance, LateAircraftDelay, AirTime LIMIT 19"}
{"sql":"SELECT COUNT(SecurityDelay), SUM(TaxiOut), AVG(DestWac) FROM mytable WHERE Diverted < 1 AND DistanceGroup NOT IN (7, 5, 11) LIMIT 9"}
{"sql":"SELECT SecurityDelay, MIN(FlightNum), SUM(DaysSinceEpoch) FROM mytable GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 17","hsqls":["SELECT SecurityDelay, MIN(FlightNum), SUM(DaysSinceEpoch) FROM mytable GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 17"]}
{"sql":"SELECT OriginCityName FROM mytable WHERE DivAirportLandings BETWEEN 1 AND 2 AND DivAirportIDs < 14869 OR OriginStateFips <> 75 ORDER BY CRSArrTime, DestCityName LIMIT 4","hsqls":["SELECT OriginCityName FROM mytable WHERE DivAirportLandings BETWEEN 1 AND 2 AND (DivAirportIDs[1] < 14869 OR DivAirportIDs[2] < 14869 OR DivAirportIDs[3] < 14869 OR DivAirportIDs[4] < 14869 OR DivAirportIDs[5] < 14869) OR OriginStateFips <> 75 ORDER BY CRSArrTime, DestCityName LIMIT 10000"]}
{"sql":"SELECT WheelsOff, OriginStateFips, FlightDate, MIN(AirlineID), SUM(DivActualElapsedTime) FROM mytable WHERE DivDistance <= 169 AND DestCityName > 'Melbourne, FL' OR ArrivalDelayGroups IN (7, -2, 6, 5, 11) GROUP BY WheelsOff, OriginStateFips, FlightDate  ORDER BY WheelsOff, OriginStateFips, FlightDate LIMIT 23","hsqls":["SELECT WheelsOff, OriginStateFips, FlightDate, MIN(AirlineID), SUM(DivActualElapsedTime) FROM mytable WHERE DivDistance <= 169 AND DestCityName > 'Melbourne, FL' OR ArrivalDelayGroups IN (7, -2, 6, 5, 11) GROUP BY WheelsOff, OriginStateFips, FlightDate  ORDER BY WheelsOff, OriginStateFips, FlightDate LIMIT 23"]}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE DestStateName <> 'Wyoming' ORDER BY OriginCityName, ArrTime LIMIT 2","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE DestStateName <> 'Wyoming' ORDER BY OriginCityName, ArrTime LIMIT 10000"]}
{"sql":"SELECT TaxiOut, DivArrDelay FROM mytable WHERE TaxiIn NOT IN (46, 102, 73, 28, 29) AND DayofMonth <= 10 ORDER BY OriginStateFips LIMIT 22"}
{"sql":"SELECT Origin, SUM(CarrierDelay), MAX(DestAirportSeqID), SUM(CRSDepTime) FROM mytable WHERE DepDelayMinutes BETWEEN 141.0 AND 192.0 AND DestAirportID IN (11042, 11630, 11481, 10693) GROUP BY Origin  ORDER BY Origin LIMIT 20","hsqls":["SELECT Origin, SUM(CarrierDelay), MAX(DestAirportSeqID), SUM(CRSDepTime) FROM mytable WHERE DepDelayMinutes BETWEEN 141.0 AND 192.0 AND DestAirportID IN (11042, 11630, 11481, 10693) GROUP BY Origin  ORDER BY Origin LIMIT 20"]}
{"sql":"SELECT DepDelay, CarrierDelay, DivAirportSeqIDs FROM mytable ORDER BY Quarter, DepDelayMinutes, DepTime LIMIT 24","hsqls":["SELECT DepDelay, CarrierDelay, DivAirportSeqIDs FROM mytable ORDER BY Quarter, DepDelayMinutes, DepTime LIMIT 10000"]}
{"sql":"SELECT DestState, FlightDate, MIN(WeatherDelay), AVG(DestStateFips), MIN(ArrivalDelayGroups) FROM mytable GROUP BY DestState, FlightDate  ORDER BY DestState, FlightDate LIMIT 6","hsqls":["SELECT DestState, FlightDate, MIN(WeatherDelay), AVG(DestStateFips), MIN(ArrivalDelayGroups) FROM mytable GROUP BY DestState, FlightDate  ORDER BY DestState, FlightDate LIMIT 6"]}
{"sql":"SELECT CancellationCode, DayOfWeek FROM mytable WHERE \"Year\" >= 2014 AND ArrTimeBlk IN ('2200-2259') LIMIT 16","hsqls":["SELECT CancellationCode, DayOfWeek FROM mytable WHERE `Year` >= 2014 AND ArrTimeBlk IN ('2200-2259') LIMIT 16"]}
{"sql":"SELECT DivActualElapsedTime, DayOfWeek, COUNT(*) FROM mytable GROUP BY DivActualElapsedTime, DayOfWeek  ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 10","hsqls":["SELECT DivActualElapsedTime, DayOfWeek, COUNT(*) FROM mytable GROUP BY DivActualElapsedTime, DayOfWeek  ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 10"]}
{"sql":"SELECT DivAirports, \"Month\" FROM mytable LIMIT 2","hsqls":["SELECT DivAirports, `Month` FROM mytable LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, MIN(DaysSinceEpoch), SUM(CRSElapsedTime) FROM mytable WHERE OriginState BETWEEN 'NC' AND 'NM' AND OriginStateName IN ('Hawaii', 'Oklahoma') GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 26","hsqls":["SELECT CarrierDelay, MIN(DaysSinceEpoch), SUM(CRSElapsedTime) FROM mytable WHERE OriginState BETWEEN 'NC' AND 'NM' AND OriginStateName IN ('Hawaii', 'Oklahoma') GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 26"]}
{"sql":"SELECT COUNT(DestWac) FROM mytable LIMIT 10"}
{"sql":"SELECT AVG(DivActualElapsedTime) FROM mytable LIMIT 10"}
{"sql":"SELECT OriginStateName, COUNT(*) FROM mytable WHERE DepDelayMinutes IN (68.0, 306.0, 116.0, 293.0) GROUP BY OriginStateName  ORDER BY OriginStateName LIMIT 21","hsqls":["SELECT OriginStateName, COUNT(*) FROM mytable WHERE DepDelayMinutes IN (68.0, 306.0, 116.0, 293.0) GROUP BY OriginStateName  ORDER BY OriginStateName LIMIT 21"]}
{"sql":"SELECT OriginCityMarketID, Flights, DepDelayMinutes, COUNT(*) FROM mytable GROUP BY OriginCityMarketID, Flights, DepDelayMinutes  ORDER BY OriginCityMarketID, Flights, DepDelayMinutes LIMIT 19","hsqls":["SELECT OriginCityMarketID, Flights, DepDelayMinutes, COUNT(*) FROM mytable GROUP BY OriginCityMarketID, Flights, DepDelayMinutes  ORDER BY OriginCityMarketID, Flights, DepDelayMinutes LIMIT 19"]}
{"sql":"SELECT TotalAddGTime FROM mytable WHERE DepDelayMinutes = 298.0 ORDER BY DestStateFips, ArrTime, DestAirportID LIMIT 14"}
{"sql":"SELECT DepartureDelayGroups, CRSArrTime FROM mytable WHERE AirlineID > 20355 AND OriginState BETWEEN 'PA' AND 'DE' AND DepTime <> 2202 ORDER BY CRSArrTime, Dest LIMIT 21"}
{"sql":"SELECT ArrDel15 FROM mytable WHERE CRSArrTime NOT IN (1426) ORDER BY DestStateName LIMIT 25"}
{"sql":"SELECT DepDel15, TailNum, DepTimeBlk FROM mytable WHERE DepDelay = 165.0 AND FirstDepTime BETWEEN 2009 AND 907 ORDER BY OriginAirportID LIMIT 10"}
{"sql":"SELECT ArrDelayMinutes, Origin, COUNT(*) FROM mytable WHERE DayOfWeek <= 6 AND DivTailNums BETWEEN 'N711HK' AND 'N582AA' AND DivDistance BETWEEN 509 AND 93 GROUP BY ArrDelayMinutes, Origin LIMIT 29","hsqls":["SELECT ArrDelayMinutes, Origin, COUNT(*) FROM mytable WHERE DayOfWeek <= 6 AND (DivTailNums[1] BETWEEN 'N711HK' AND 'N582AA' OR DivTailNums[2] BETWEEN 'N711HK' AND 'N582AA' OR DivTailNums[3] BETWEEN 'N711HK' AND 'N582AA' OR DivTailNums[4] BETWEEN 'N711HK' AND 'N582AA' OR DivTailNums[5] BETWEEN 'N711HK' AND 'N582AA') AND DivDistance BETWEEN 509 AND 93 GROUP BY ArrDelayMinutes, Origin LIMIT 10000"]}
{"sql":"SELECT CancellationCode FROM mytable WHERE AirTime > 233 ORDER BY WeatherDelay, DestAirportSeqID, OriginWac LIMIT 8"}
{"sql":"SELECT DestWac FROM mytable ORDER BY OriginStateFips, NASDelay, DestAirportID LIMIT 17"}
{"sql":"SELECT DestState, FirstDepTime FROM mytable ORDER BY DistanceGroup, DivActualElapsedTime LIMIT 23"}
{"sql":"SELECT OriginAirportSeqID, DaysSinceEpoch FROM mytable WHERE AirlineID IN (20398, 19393) ORDER BY ArrDel15, CRSElapsedTime LIMIT 4"}
{"sql":"SELECT OriginStateFips, \"Month\" FROM mytable ORDER BY \"Year\", Flights LIMIT 11","hsqls":["SELECT OriginStateFips, `Month` FROM mytable ORDER BY Year, Flights LIMIT 11"]}
{"sql":"SELECT DivAirportSeqIDs, DestAirportSeqID FROM mytable WHERE Cancelled NOT IN (1, 0) AND DivTotalGTimes > 54 ORDER BY OriginStateFips, SecurityDelay, OriginStateName LIMIT 8","hsqls":["SELECT DivAirportSeqIDs, DestAirportSeqID FROM mytable WHERE Cancelled NOT IN (1, 0) AND (DivTotalGTimes[1] > 54 OR DivTotalGTimes[2] > 54 OR DivTotalGTimes[3] > 54 OR DivTotalGTimes[4] > 54 OR DivTotalGTimes[5] > 54) ORDER BY OriginStateFips, SecurityDelay, OriginStateName LIMIT 10000"]}
{"sql":"SELECT DestWac, Quarter, Dest, COUNT(OriginWac) FROM mytable GROUP BY DestWac, Quarter, Dest  ORDER BY DestWac, Quarter, Dest LIMIT 5","hsqls":["SELECT DestWac, Quarter, Dest, COUNT(OriginWac) FROM mytable GROUP BY DestWac, Quarter, Dest  ORDER BY DestWac, Quarter, Dest LIMIT 5"]}
{"sql":"SELECT DestCityMarketID FROM mytable WHERE FirstDepTime NOT IN (1030, 721) OR OriginWac BETWEEN 16 AND 65 ORDER BY DestStateFips LIMIT 15"}
{"sql":"SELECT DivReachedDest, DivWheelsOffs, ArrDelay FROM mytable ORDER BY DepDelayMinutes, CRSElapsedTime LIMIT 22","hsqls":["SELECT DivReachedDest, DivWheelsOffs, ArrDelay FROM mytable ORDER BY DepDelayMinutes, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT DestWac, DestStateFips, DivArrDelay, COUNT(*) FROM mytable WHERE UniqueCarrier IN ('DL', 'OO', 'AA', 'VX') OR DestWac <> 86 OR CancellationCode BETWEEN 'C' AND 'C' GROUP BY DestWac, DestStateFips, DivArrDelay  ORDER BY DestWac, DestStateFips, DivArrDelay LIMIT 9","hsqls":["SELECT DestWac, DestStateFips, DivArrDelay, COUNT(*) FROM mytable WHERE UniqueCarrier IN ('DL', 'OO', 'AA', 'VX') OR DestWac <> 86 OR CancellationCode BETWEEN 'C' AND 'C' GROUP BY DestWac, DestStateFips, DivArrDelay  ORDER BY DestWac, DestStateFips, DivArrDelay LIMIT 9"]}
{"sql":"SELECT TaxiIn, DestAirportID, DivArrDelay, COUNT(*) FROM mytable WHERE DivAirportIDs IN (10299, 11233, 11109, 13487, 14006) AND DestAirportID BETWEEN 13198 AND 10643 OR OriginWac BETWEEN 92 AND 92 GROUP BY TaxiIn, DestAirportID, DivArrDelay LIMIT 23","hsqls":["SELECT TaxiIn, DestAirportID, DivArrDelay, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] IN (10299, 11233, 11109, 13487, 14006) OR DivAirportIDs[2] IN (10299, 11233, 11109, 13487, 14006) OR DivAirportIDs[3] IN (10299, 11233, 11109, 13487, 14006) OR DivAirportIDs[4] IN (10299, 11233, 11109, 13487, 14006) OR DivAirportIDs[5] IN (10299, 11233, 11109, 13487, 14006)) AND DestAirportID BETWEEN 13198 AND 10643 OR OriginWac BETWEEN 92 AND 92 GROUP BY TaxiIn, DestAirportID, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT TaxiIn FROM mytable WHERE Diverted <> 0 OR DepDel15 NOT IN (1, -9999) AND DivActualElapsedTime NOT IN (481, 642, 243, 196) ORDER BY Quarter LIMIT 5"}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE DivTailNums < 'N3CEAA' OR Carrier > 'DL' AND DestWac > 12 ORDER BY OriginAirportSeqID, WeatherDelay, CRSDepTime LIMIT 10","hsqls":["SELECT DaysSinceEpoch FROM mytable WHERE (DivTailNums[1] < 'N3CEAA' OR DivTailNums[2] < 'N3CEAA' OR DivTailNums[3] < 'N3CEAA' OR DivTailNums[4] < 'N3CEAA' OR DivTailNums[5] < 'N3CEAA') OR Carrier > 'DL' AND DestWac > 12 ORDER BY OriginAirportSeqID, WeatherDelay, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT WheelsOff, Carrier, DayOfWeek, MAX(DivDistance) FROM mytable WHERE DayofMonth IN (20, 19, 31, 17) AND Flights <= 1 AND DayofMonth BETWEEN 7 AND 4 GROUP BY WheelsOff, Carrier, DayOfWeek  ORDER BY WheelsOff, Carrier, DayOfWeek LIMIT 14","hsqls":["SELECT WheelsOff, Carrier, DayOfWeek, MAX(DivDistance) FROM mytable WHERE DayofMonth IN (20, 19, 31, 17) AND Flights <= 1 AND DayofMonth BETWEEN 7 AND 4 GROUP BY WheelsOff, Carrier, DayOfWeek  ORDER BY WheelsOff, Carrier, DayOfWeek LIMIT 14"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE WheelsOff <= 1500 LIMIT 15"}
{"sql":"SELECT Origin, \"Month\" FROM mytable WHERE \"Year\" NOT IN (2014) ORDER BY CRSArrTime, DestCityMarketID, DivArrDelay LIMIT 21","hsqls":["SELECT Origin, `Month` FROM mytable WHERE `Year` NOT IN (2014) ORDER BY CRSArrTime, DestCityMarketID, DivArrDelay LIMIT 21"]}
{"sql":"SELECT ArrDelayMinutes, DayOfWeek, COUNT(*) FROM mytable WHERE DepartureDelayGroups IN (7, 8, 11) AND ArrDelay BETWEEN 0.0 AND -31.0 GROUP BY ArrDelayMinutes, DayOfWeek  ORDER BY ArrDelayMinutes, DayOfWeek LIMIT 15","hsqls":["SELECT ArrDelayMinutes, DayOfWeek, COUNT(*) FROM mytable WHERE DepartureDelayGroups IN (7, 8, 11) AND ArrDelay BETWEEN 0.0 AND -31.0 GROUP BY ArrDelayMinutes, DayOfWeek  ORDER BY ArrDelayMinutes, DayOfWeek LIMIT 15"]}
{"sql":"SELECT ArrDel15, DestCityMarketID FROM mytable WHERE DivAirports IN ('HOU', 'GJT') AND TotalAddGTime BETWEEN 74 AND 23 AND DayOfWeek IN (2, 7) ORDER BY DivActualElapsedTime LIMIT 3","hsqls":["SELECT ArrDel15, DestCityMarketID FROM mytable WHERE (DivAirports[1] IN ('HOU', 'GJT') OR DivAirports[2] IN ('HOU', 'GJT') OR DivAirports[3] IN ('HOU', 'GJT') OR DivAirports[4] IN ('HOU', 'GJT') OR DivAirports[5] IN ('HOU', 'GJT')) AND TotalAddGTime BETWEEN 74 AND 23 AND DayOfWeek IN (2, 7) ORDER BY DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE UniqueCarrier = 'EV' ORDER BY WeatherDelay LIMIT 19"}
{"sql":"SELECT ArrDelay, CancellationCode FROM mytable ORDER BY OriginAirportSeqID LIMIT 7"}
{"sql":"SELECT DestAirportSeqID FROM mytable WHERE FirstDepTime BETWEEN 903 AND 903 ORDER BY DestStateName LIMIT 27"}
{"sql":"SELECT DepTimeBlk, ArrDelay, DayofMonth FROM mytable WHERE FlightNum <> 4360 LIMIT 23"}
{"sql":"SELECT TaxiOut, Carrier FROM mytable WHERE OriginAirportSeqID IN (1197302, 1251102, 1463303) OR TaxiOut NOT IN (7, 108, 4, 26) OR DaysSinceEpoch <> 16085 ORDER BY WheelsOff LIMIT 6"}
{"sql":"SELECT ArrDelayMinutes, DivWheelsOffs FROM mytable WHERE DestStateFips IN (32, 55, 51, 36) AND DepartureDelayGroups BETWEEN 1 AND -9999 ORDER BY Origin LIMIT 9","hsqls":["SELECT ArrDelayMinutes, DivWheelsOffs FROM mytable WHERE DestStateFips IN (32, 55, 51, 36) AND DepartureDelayGroups BETWEEN 1 AND -9999 ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT DivAirportSeqIDs, DestAirportSeqID FROM mytable WHERE AirTime BETWEEN 300 AND 335 OR CRSElapsedTime BETWEEN 294 AND 366 LIMIT 13","hsqls":["SELECT DivAirportSeqIDs, DestAirportSeqID FROM mytable WHERE AirTime BETWEEN 300 AND 335 OR CRSElapsedTime BETWEEN 294 AND 366 LIMIT 10000"]}
{"sql":"SELECT DivWheelsOffs FROM mytable LIMIT 4","hsqls":["SELECT DivWheelsOffs FROM mytable LIMIT 10000"]}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE AirTime NOT IN (115, 11, 100, 351) ORDER BY Quarter, TailNum LIMIT 4","hsqls":["SELECT DivAirportIDs FROM mytable WHERE AirTime NOT IN (115, 11, 100, 351) ORDER BY Quarter, TailNum LIMIT 10000"]}
{"sql":"SELECT DepTime, DivAirportSeqIDs FROM mytable WHERE DivAirportSeqIDs <= 1482802 OR DivDistance <> 234 OR SecurityDelay BETWEEN 14 AND 27 ORDER BY OriginCityName, DestAirportSeqID LIMIT 10","hsqls":["SELECT DepTime, DivAirportSeqIDs FROM mytable WHERE (DivAirportSeqIDs[1] <= 1482802 OR DivAirportSeqIDs[2] <= 1482802 OR DivAirportSeqIDs[3] <= 1482802 OR DivAirportSeqIDs[4] <= 1482802 OR DivAirportSeqIDs[5] <= 1482802) OR DivDistance <> 234 OR SecurityDelay BETWEEN 14 AND 27 ORDER BY OriginCityName, DestAirportSeqID LIMIT 10000"]}
{"sql":"SELECT AVG(CRSDepTime), MIN(DepartureDelayGroups), SUM(ArrTime) FROM mytable WHERE CancellationCode IN ('C') AND DestWac = 86 LIMIT 16"}
{"sql":"SELECT ArrTime, \"Month\", COUNT(*) FROM mytable WHERE ArrTimeBlk IN ('1600-1659', '2200-2259', '1100-1159', '1800-1859') GROUP BY ArrTime, \"Month\" LIMIT 18","hsqls":["SELECT ArrTime, Month, COUNT(*) FROM mytable WHERE ArrTimeBlk IN ('1600-1659', '2200-2259', '1100-1159', '1800-1859') GROUP BY ArrTime, `Month` LIMIT 18"]}
{"sql":"SELECT COUNT(DepDelay), SUM(DepDelayMinutes), MAX(OriginAirportID) FROM mytable WHERE DestCityMarketID NOT IN (30620) LIMIT 9"}
{"sql":"SELECT DestState, COUNT(ArrivalDelayGroups), AVG(FlightNum) FROM mytable WHERE LateAircraftDelay BETWEEN 48 AND 75 GROUP BY DestState  ORDER BY DestState LIMIT 20","hsqls":["SELECT DestState, COUNT(ArrivalDelayGroups), AVG(FlightNum) FROM mytable WHERE LateAircraftDelay BETWEEN 48 AND 75 GROUP BY DestState  ORDER BY DestState LIMIT 20"]}
{"sql":"SELECT Flights, DivActualElapsedTime FROM mytable WHERE CRSArrTime BETWEEN 100 AND 632 OR DivWheelsOns IN (1414, 1706, 838, 1113, 1326) LIMIT 13","hsqls":["SELECT Flights, DivActualElapsedTime FROM mytable WHERE CRSArrTime BETWEEN 100 AND 632 OR (DivWheelsOns[1] IN (1414, 1706, 838, 1113, 1326) OR DivWheelsOns[2] IN (1414, 1706, 838, 1113, 1326) OR DivWheelsOns[3] IN (1414, 1706, 838, 1113, 1326) OR DivWheelsOns[4] IN (1414, 1706, 838, 1113, 1326) OR DivWheelsOns[5] IN (1414, 1706, 838, 1113, 1326)) LIMIT 10000"]}
{"sql":"SELECT WheelsOff, LongestAddGTime, CancellationCode FROM mytable ORDER BY AirTime LIMIT 29"}
{"sql":"SELECT FirstDepTime, ArrTime, DivAirportLandings FROM mytable WHERE DayOfWeek >= 5 OR AirlineID <= 20437 OR DivReachedDest BETWEEN 0 AND 1 ORDER BY OriginCityMarketID, ActualElapsedTime, OriginAirportID LIMIT 20"}
{"sql":"SELECT Diverted, FlightNum, COUNT(*) FROM mytable WHERE SecurityDelay BETWEEN 4 AND 18 GROUP BY Diverted, FlightNum  ORDER BY Diverted, FlightNum LIMIT 14","hsqls":["SELECT Diverted, FlightNum, COUNT(*) FROM mytable WHERE SecurityDelay BETWEEN 4 AND 18 GROUP BY Diverted, FlightNum  ORDER BY Diverted, FlightNum LIMIT 14"]}
{"sql":"SELECT DistanceGroup, TaxiIn, OriginAirportID, MIN(DivReachedDest), MIN(AirlineID) FROM mytable WHERE OriginAirportSeqID NOT IN (1219102) OR Cancelled >= 1 GROUP BY DistanceGroup, TaxiIn, OriginAirportID  ORDER BY DistanceGroup, TaxiIn, OriginAirportID LIMIT 18","hsqls":["SELECT DistanceGroup, TaxiIn, OriginAirportID, MIN(DivReachedDest), MIN(AirlineID) FROM mytable WHERE OriginAirportSeqID NOT IN (1219102) OR Cancelled >= 1 GROUP BY DistanceGroup, TaxiIn, OriginAirportID  ORDER BY DistanceGroup, TaxiIn, OriginAirportID LIMIT 18"]}
{"sql":"SELECT LateAircraftDelay, TotalAddGTime, COUNT(OriginCityName) FROM mytable WHERE CarrierDelay < 66 AND OriginCityName = 'San Juan, PR' GROUP BY LateAircraftDelay, TotalAddGTime","hsqls":["SELECT LateAircraftDelay, TotalAddGTime, COUNT(OriginCityName) FROM mytable WHERE CarrierDelay < 66 AND OriginCityName = 'San Juan, PR' GROUP BY LateAircraftDelay, TotalAddGTime"]}
{"sql":"SELECT DivReachedDest, DestAirportID FROM mytable WHERE DivAirports IN ('AVP', 'ORF', 'TYS') AND DivAirportSeqIDs BETWEEN 1086803 AND 1599102 AND SecurityDelay BETWEEN 4 AND 1 ORDER BY OriginCityMarketID LIMIT 9","hsqls":["SELECT DivReachedDest, DestAirportID FROM mytable WHERE (DivAirports[1] IN ('AVP', 'ORF', 'TYS') OR DivAirports[2] IN ('AVP', 'ORF', 'TYS') OR DivAirports[3] IN ('AVP', 'ORF', 'TYS') OR DivAirports[4] IN ('AVP', 'ORF', 'TYS') OR DivAirports[5] IN ('AVP', 'ORF', 'TYS')) AND (DivAirportSeqIDs[1] BETWEEN 1086803 AND 1599102 OR DivAirportSeqIDs[2] BETWEEN 1086803 AND 1599102 OR DivAirportSeqIDs[3] BETWEEN 1086803 AND 1599102 OR DivAirportSeqIDs[4] BETWEEN 1086803 AND 1599102 OR DivAirportSeqIDs[5] BETWEEN 1086803 AND 1599102) AND SecurityDelay BETWEEN 4 AND 1 ORDER BY OriginCityMarketID LIMIT 10000"]}
{"sql":"SELECT WheelsOff, WeatherDelay, ArrDelayMinutes FROM mytable WHERE ArrDelay > 62.0 AND WheelsOn < 2043 OR DivAirportSeqIDs BETWEEN 1468902 AND 1483103 ORDER BY Dest LIMIT 26","hsqls":["SELECT WheelsOff, WeatherDelay, ArrDelayMinutes FROM mytable WHERE ArrDelay > 62.0 AND WheelsOn < 2043 OR (DivAirportSeqIDs[1] BETWEEN 1468902 AND 1483103 OR DivAirportSeqIDs[2] BETWEEN 1468902 AND 1483103 OR DivAirportSeqIDs[3] BETWEEN 1468902 AND 1483103 OR DivAirportSeqIDs[4] BETWEEN 1468902 AND 1483103 OR DivAirportSeqIDs[5] BETWEEN 1468902 AND 1483103) ORDER BY Dest LIMIT 10000"]}
{"sql":"SELECT DestWac, ArrDel15, TailNum, MIN(ArrDelay), COUNT(NASDelay) FROM mytable WHERE ArrTime = 1528 GROUP BY DestWac, ArrDel15, TailNum  ORDER BY DestWac, ArrDel15, TailNum LIMIT 11","hsqls":["SELECT DestWac, ArrDel15, TailNum, MIN(ArrDelay), COUNT(NASDelay) FROM mytable WHERE ArrTime = 1528 GROUP BY DestWac, ArrDel15, TailNum  ORDER BY DestWac, ArrDel15, TailNum LIMIT 11"]}
{"sql":"SELECT FlightDate, Cancelled, COUNT(DestAirportID) FROM mytable WHERE ArrTime NOT IN (1752, 2339, 2123) GROUP BY FlightDate, Cancelled  ORDER BY FlightDate, Cancelled LIMIT 28","hsqls":["SELECT FlightDate, Cancelled, COUNT(DestAirportID) FROM mytable WHERE ArrTime NOT IN (1752, 2339, 2123) GROUP BY FlightDate, Cancelled  ORDER BY FlightDate, Cancelled LIMIT 28"]}
{"sql":"SELECT FlightDate, DayOfWeek, COUNT(TaxiOut), MAX(DepDelay), SUM(OriginCityMarketID) FROM mytable WHERE OriginStateFips >= 23 AND DivDistance < 47 GROUP BY FlightDate, DayOfWeek  ORDER BY FlightDate, DayOfWeek LIMIT 16","hsqls":["SELECT FlightDate, DayOfWeek, COUNT(TaxiOut), MAX(DepDelay), SUM(OriginCityMarketID) FROM mytable WHERE OriginStateFips >= 23 AND DivDistance < 47 GROUP BY FlightDate, DayOfWeek  ORDER BY FlightDate, DayOfWeek LIMIT 16"]}
{"sql":"SELECT TailNum FROM mytable WHERE ActualElapsedTime BETWEEN 125 AND 299 AND OriginCityMarketID NOT IN (31884, 35991, 30073, 32335, 33264) AND DepDelayMinutes BETWEEN 338.0 AND 186.0 ORDER BY OriginCityName, Dest LIMIT 18"}
{"sql":"SELECT OriginStateName FROM mytable WHERE DestStateName BETWEEN 'Hawaii' AND 'Alabama' OR DivWheelsOns >= 1600 ORDER BY DepDel15 LIMIT 25","hsqls":["SELECT OriginStateName FROM mytable WHERE DestStateName BETWEEN 'Hawaii' AND 'Alabama' OR (DivWheelsOns[1] >= 1600 OR DivWheelsOns[2] >= 1600 OR DivWheelsOns[3] >= 1600 OR DivWheelsOns[4] >= 1600 OR DivWheelsOns[5] >= 1600) ORDER BY DepDel15 LIMIT 10000"]}
{"sql":"SELECT DestWac, DivAirportLandings, CancellationCode, COUNT(OriginCityName), COUNT(AirlineID) FROM mytable WHERE WeatherDelay IN (16) GROUP BY DestWac, DivAirportLandings, CancellationCode  ORDER BY DestWac, DivAirportLandings, CancellationCode LIMIT 19","hsqls":["SELECT DestWac, DivAirportLandings, CancellationCode, COUNT(OriginCityName), COUNT(AirlineID) FROM mytable WHERE WeatherDelay IN (16) GROUP BY DestWac, DivAirportLandings, CancellationCode  ORDER BY DestWac, DivAirportLandings, CancellationCode LIMIT 19"]}
{"sql":"SELECT LongestAddGTime, DepDel15, UniqueCarrier, COUNT(*) FROM mytable WHERE Dest BETWEEN 'FWA' AND 'BTR' OR DepDelayMinutes < 81.0 GROUP BY LongestAddGTime, DepDel15, UniqueCarrier","hsqls":["SELECT LongestAddGTime, DepDel15, UniqueCarrier, COUNT(*) FROM mytable WHERE Dest BETWEEN 'FWA' AND 'BTR' OR DepDelayMinutes < 81.0 GROUP BY LongestAddGTime, DepDel15, UniqueCarrier"]}
{"sql":"SELECT Diverted, WeatherDelay FROM mytable WHERE OriginCityMarketID BETWEEN 32896 AND 33785 AND DepTimeBlk IN ('2200-2259', '2100-2159', '2300-2359', '1200-1259') LIMIT 20"}
{"sql":"SELECT LongestAddGTime, COUNT(*) FROM mytable WHERE OriginStateFips BETWEEN 33 AND 6 AND CRSArrTime = 2249 AND ArrTimeBlk <> '1200-1259' GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 8","hsqls":["SELECT LongestAddGTime, COUNT(*) FROM mytable WHERE OriginStateFips BETWEEN 33 AND 6 AND CRSArrTime = 2249 AND ArrTimeBlk <> '1200-1259' GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 8"]}
{"sql":"SELECT DestWac, OriginAirportID FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND DestState BETWEEN 'IN' AND 'NV' ORDER BY DestState LIMIT 26"}
{"sql":"SELECT UniqueCarrier, DivArrDelay FROM mytable ORDER BY DivReachedDest, WeatherDelay, LongestAddGTime LIMIT 17"}
{"sql":"SELECT Carrier, FlightNum, ArrDelayMinutes, COUNT(\"Year\"), MIN(ArrTime) FROM mytable WHERE DivAirportLandings IN (2, 1, 0, 9) AND NASDelay BETWEEN 281 AND 29 OR TailNum < 'N914EV' GROUP BY Carrier, FlightNum, ArrDelayMinutes LIMIT 26","hsqls":["SELECT Carrier, FlightNum, ArrDelayMinutes, COUNT(`Year`), MIN(ArrTime) FROM mytable WHERE DivAirportLandings IN (2, 1, 0, 9) AND NASDelay BETWEEN 281 AND 29 OR TailNum < 'N914EV' GROUP BY Carrier, FlightNum, ArrDelayMinutes LIMIT 26"]}
{"sql":"SELECT \"Year\", FlightNum, MAX(DestStateFips), AVG(NASDelay), MIN(DepTime) FROM mytable WHERE DivAirports IN ('CPR', 'GPT', 'RDM') GROUP BY \"Year\", FlightNum LIMIT 14","hsqls":["SELECT Year, FlightNum, MAX(DestStateFips), AVG(NASDelay), MIN(DepTime) FROM mytable WHERE (DivAirports[1] IN ('CPR', 'GPT', 'RDM') OR DivAirports[2] IN ('CPR', 'GPT', 'RDM') OR DivAirports[3] IN ('CPR', 'GPT', 'RDM') OR DivAirports[4] IN ('CPR', 'GPT', 'RDM') OR DivAirports[5] IN ('CPR', 'GPT', 'RDM')) GROUP BY Year, FlightNum LIMIT 10000"]}
{"sql":"SELECT COUNT(WheelsOn), MIN(TaxiOut) FROM mytable LIMIT 10"}
{"sql":"SELECT LongestAddGTime, ArrivalDelayGroups, DivTotalGTimes FROM mytable WHERE OriginAirportID > 13577 OR ArrivalDelayGroups <= 6 AND WheelsOn BETWEEN 1940 AND 1008 ORDER BY AirlineID LIMIT 25","hsqls":["SELECT LongestAddGTime, ArrivalDelayGroups, DivTotalGTimes FROM mytable WHERE OriginAirportID > 13577 OR ArrivalDelayGroups <= 6 AND WheelsOn BETWEEN 1940 AND 1008 ORDER BY AirlineID LIMIT 10000"]}
{"sql":"SELECT TaxiOut, DepDelayMinutes, DivArrDelay FROM mytable ORDER BY DestWac, DayofMonth LIMIT 15"}
{"sql":"SELECT DivWheelsOffs, DivTotalGTimes FROM mytable WHERE AirlineID = 19790 LIMIT 6","hsqls":["SELECT DivWheelsOffs, DivTotalGTimes FROM mytable WHERE AirlineID = 19790 LIMIT 10000"]}
{"sql":"SELECT DivDistance, ArrTimeBlk, ArrDel15 FROM mytable WHERE Distance IN (257, 476, 1129) AND DivTotalGTimes IN (89) OR UniqueCarrier <> 'MQ' LIMIT 3","hsqls":["SELECT DivDistance, ArrTimeBlk, ArrDel15 FROM mytable WHERE Distance IN (257, 476, 1129) AND (DivTotalGTimes[1] IN (89) OR DivTotalGTimes[2] IN (89) OR DivTotalGTimes[3] IN (89) OR DivTotalGTimes[4] IN (89) OR DivTotalGTimes[5] IN (89)) OR UniqueCarrier <> 'MQ' LIMIT 10000"]}
{"sql":"SELECT Dest FROM mytable WHERE OriginAirportSeqID > 1201602 AND ActualElapsedTime BETWEEN 32 AND 35 LIMIT 10"}
{"sql":"SELECT Flights, DivWheelsOffs, DayofMonth FROM mytable LIMIT 17","hsqls":["SELECT Flights, DivWheelsOffs, DayofMonth FROM mytable LIMIT 10000"]}
{"sql":"SELECT DivArrDelay, AVG(DestAirportSeqID), MIN(OriginStateFips) FROM mytable WHERE FlightDate BETWEEN '2014-01-19' AND '2014-01-23' GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 6","hsqls":["SELECT DivArrDelay, AVG(DestAirportSeqID), MIN(OriginStateFips) FROM mytable WHERE FlightDate BETWEEN '2014-01-19' AND '2014-01-23' GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 6"]}
{"sql":"SELECT DivAirportSeqIDs FROM mytable WHERE DivTotalGTimes BETWEEN 35 AND 31 ORDER BY Distance LIMIT 12","hsqls":["SELECT DivAirportSeqIDs FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 35 AND 31 OR DivTotalGTimes[2] BETWEEN 35 AND 31 OR DivTotalGTimes[3] BETWEEN 35 AND 31 OR DivTotalGTimes[4] BETWEEN 35 AND 31 OR DivTotalGTimes[5] BETWEEN 35 AND 31) ORDER BY Distance LIMIT 10000"]}
{"sql":"SELECT Diverted, DepDel15, DivTailNums FROM mytable WHERE ArrivalDelayGroups <= 5 AND \"Month\" BETWEEN 1 AND 1 OR DepTime <> 1045 ORDER BY Diverted, DestAirportID LIMIT 25","hsqls":["SELECT Diverted, DepDel15, DivTailNums FROM mytable WHERE ArrivalDelayGroups <= 5 AND `Month` BETWEEN 1 AND 1 OR DepTime <> 1045 ORDER BY Diverted, DestAirportID LIMIT 10000"]}
{"sql":"SELECT WheelsOff, \"Year\", DivActualElapsedTime, MAX(ArrivalDelayGroups), AVG(DivArrDelay), MAX(DivAirportLandings) FROM mytable WHERE SecurityDelay BETWEEN 27 AND 18 AND DivActualElapsedTime BETWEEN 398 AND 425 GROUP BY WheelsOff, \"Year\", DivActualElapsedTime LIMIT 19","hsqls":["SELECT WheelsOff, Year, DivActualElapsedTime, MAX(ArrivalDelayGroups), AVG(DivArrDelay), MAX(DivAirportLandings) FROM mytable WHERE SecurityDelay BETWEEN 27 AND 18 AND DivActualElapsedTime BETWEEN 398 AND 425 GROUP BY WheelsOff, Year, DivActualElapsedTime LIMIT 19"]}
{"sql":"SELECT UniqueCarrier, \"Month\", AVG(Diverted), AVG(DestWac) FROM mytable WHERE WeatherDelay <= 205 GROUP BY UniqueCarrier, \"Month\" LIMIT 16","hsqls":["SELECT UniqueCarrier, Month, AVG(Diverted), AVG(DestWac) FROM mytable WHERE WeatherDelay <= 205 GROUP BY UniqueCarrier, `Month` LIMIT 16"]}
{"sql":"SELECT DivAirportIDs, CRSDepTime FROM mytable WHERE DivWheelsOffs >= 2111 AND DivLongestGTimes BETWEEN 5.0 AND 20.0 AND DestWac <= 87 ORDER BY LongestAddGTime, Cancelled, OriginWac LIMIT 13","hsqls":["SELECT DivAirportIDs, CRSDepTime FROM mytable WHERE (DivWheelsOffs[1] >= 2111 OR DivWheelsOffs[2] >= 2111 OR DivWheelsOffs[3] >= 2111 OR DivWheelsOffs[4] >= 2111 OR DivWheelsOffs[5] >= 2111) AND (DivLongestGTimes[1] BETWEEN 5.0 AND 20.0 OR DivLongestGTimes[2] BETWEEN 5.0 AND 20.0 OR DivLongestGTimes[3] BETWEEN 5.0 AND 20.0 OR DivLongestGTimes[4] BETWEEN 5.0 AND 20.0 OR DivLongestGTimes[5] BETWEEN 5.0 AND 20.0) AND DestWac <= 87 ORDER BY LongestAddGTime, Cancelled, OriginWac LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, UniqueCarrier FROM mytable ORDER BY DestStateFips, WheelsOn LIMIT 11"}
{"sql":"SELECT OriginCityName, TaxiIn, COUNT(*) FROM mytable GROUP BY OriginCityName, TaxiIn  ORDER BY OriginCityName, TaxiIn LIMIT 25","hsqls":["SELECT OriginCityName, TaxiIn, COUNT(*) FROM mytable GROUP BY OriginCityName, TaxiIn  ORDER BY OriginCityName, TaxiIn LIMIT 25"]}
{"sql":"SELECT DivReachedDest, ArrDelayMinutes, COUNT(*) FROM mytable WHERE DivArrDelay > 49 OR Flights IN (1) AND Distance IN (544) GROUP BY DivReachedDest, ArrDelayMinutes  ORDER BY DivReachedDest, ArrDelayMinutes LIMIT 7","hsqls":["SELECT DivReachedDest, ArrDelayMinutes, COUNT(*) FROM mytable WHERE DivArrDelay > 49 OR Flights IN (1) AND Distance IN (544) GROUP BY DivReachedDest, ArrDelayMinutes  ORDER BY DivReachedDest, ArrDelayMinutes LIMIT 7"]}
{"sql":"SELECT DayofMonth FROM mytable ORDER BY OriginCityMarketID LIMIT 12"}
{"sql":"SELECT DivLongestGTimes, CRSDepTime FROM mytable ORDER BY LateAircraftDelay, DepTimeBlk LIMIT 16","hsqls":["SELECT DivLongestGTimes, CRSDepTime FROM mytable ORDER BY LateAircraftDelay, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT DayOfWeek FROM mytable WHERE FlightDate >= '2014-01-23' ORDER BY ActualElapsedTime, ArrivalDelayGroups LIMIT 16"}
{"sql":"SELECT Dest, OriginWac, CRSElapsedTime FROM mytable WHERE DestWac >= 64 AND DayofMonth BETWEEN 2 AND 4 OR DestWac NOT IN (1) ORDER BY DepDelay, OriginStateFips, CRSElapsedTime LIMIT 16"}
{"sql":"SELECT DestCityMarketID, MAX(ArrDel15), SUM(WheelsOn), SUM(AirTime) FROM mytable GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 29","hsqls":["SELECT DestCityMarketID, MAX(ArrDel15), SUM(WheelsOn), SUM(AirTime) FROM mytable GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 29"]}
{"sql":"SELECT DivAirports, DestCityName, DivActualElapsedTime FROM mytable WHERE WheelsOff IN (852) ORDER BY DayofMonth LIMIT 16","hsqls":["SELECT DivAirports, DestCityName, DivActualElapsedTime FROM mytable WHERE WheelsOff IN (852) ORDER BY DayofMonth LIMIT 10000"]}
{"sql":"SELECT UniqueCarrier, MAX(CRSDepTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND 1 AND ArrDelayMinutes NOT IN (78.0, 49.0, 152.0, 144.0) GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 6","hsqls":["SELECT UniqueCarrier, MAX(CRSDepTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND 1 AND ArrDelayMinutes NOT IN (78.0, 49.0, 152.0, 144.0) GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 6"]}
{"sql":"SELECT DivDistance FROM mytable WHERE AirlineID BETWEEN 20436 AND 19690 AND LongestAddGTime <= 78 ORDER BY DivReachedDest, WeatherDelay, ArrTime LIMIT 28"}
{"sql":"SELECT WheelsOff, UniqueCarrier, DayOfWeek FROM mytable ORDER BY DepDelay, ArrTime, DivAirportLandings LIMIT 22"}
{"sql":"SELECT Carrier, COUNT(DepTimeBlk) FROM mytable WHERE Quarter IN (1) AND DivActualElapsedTime IN (213, 324, 243, 495, 142) OR FlightDate IN ('2014-01-25') GROUP BY Carrier  ORDER BY Carrier LIMIT 15","hsqls":["SELECT Carrier, COUNT(DepTimeBlk) FROM mytable WHERE Quarter IN (1) AND DivActualElapsedTime IN (213, 324, 243, 495, 142) OR FlightDate IN ('2014-01-25') GROUP BY Carrier  ORDER BY Carrier LIMIT 15"]}
{"sql":"SELECT DestAirportID, WheelsOn FROM mytable WHERE DivAirportIDs IN (14113, 14794, 14679, 13230) AND ArrTimeBlk IN ('2000-2059', '1700-1759', '1100-1159') OR ArrTimeBlk BETWEEN '1900-1959' AND '1100-1159' ORDER BY DistanceGroup, Diverted LIMIT 22","hsqls":["SELECT DestAirportID, WheelsOn FROM mytable WHERE (DivAirportIDs[1] IN (14113, 14794, 14679, 13230) OR DivAirportIDs[2] IN (14113, 14794, 14679, 13230) OR DivAirportIDs[3] IN (14113, 14794, 14679, 13230) OR DivAirportIDs[4] IN (14113, 14794, 14679, 13230) OR DivAirportIDs[5] IN (14113, 14794, 14679, 13230)) AND ArrTimeBlk IN ('2000-2059', '1700-1759', '1100-1159') OR ArrTimeBlk BETWEEN '1900-1959' AND '1100-1159' ORDER BY DistanceGroup, Diverted LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime, DepTimeBlk, COUNT(OriginCityMarketID), SUM(Flights) FROM mytable WHERE ArrTime BETWEEN 44 AND 955 AND UniqueCarrier IN ('F9', 'US', 'B6', 'OO', 'VX') GROUP BY ActualElapsedTime, DepTimeBlk  ORDER BY ActualElapsedTime, DepTimeBlk LIMIT 6","hsqls":["SELECT ActualElapsedTime, DepTimeBlk, COUNT(OriginCityMarketID), SUM(Flights) FROM mytable WHERE ArrTime BETWEEN 44 AND 955 AND UniqueCarrier IN ('F9', 'US', 'B6', 'OO', 'VX') GROUP BY ActualElapsedTime, DepTimeBlk  ORDER BY ActualElapsedTime, DepTimeBlk LIMIT 6"]}
{"sql":"SELECT ArrTimeBlk FROM mytable WHERE SecurityDelay NOT IN (0, 4, 8, 14, -9999) AND DayofMonth < 28 AND TotalAddGTime = 51 ORDER BY DivDistance, CRSDepTime LIMIT 29"}
{"sql":"SELECT COUNT(TotalAddGTime) FROM mytable WHERE OriginState NOT IN ('PA', 'AK') LIMIT 23"}
{"sql":"SELECT MAX(NASDelay), MIN(DepDelay) FROM mytable WHERE DestState <> 'FL' LIMIT 25"}
{"sql":"SELECT CarrierDelay, ArrivalDelayGroups, SUM(AirTime), MIN(CRSDepTime), MIN(ArrivalDelayGroups) FROM mytable WHERE DestAirportID >= 15096 AND DestWac BETWEEN 15 AND 74 OR ArrTime BETWEEN 1941 AND 951 GROUP BY CarrierDelay, ArrivalDelayGroups  ORDER BY CarrierDelay, ArrivalDelayGroups LIMIT 29","hsqls":["SELECT CarrierDelay, ArrivalDelayGroups, SUM(AirTime), MIN(CRSDepTime), MIN(ArrivalDelayGroups) FROM mytable WHERE DestAirportID >= 15096 AND DestWac BETWEEN 15 AND 74 OR ArrTime BETWEEN 1941 AND 951 GROUP BY CarrierDelay, ArrivalDelayGroups  ORDER BY CarrierDelay, ArrivalDelayGroups LIMIT 29"]}
{"sql":"SELECT Quarter, AVG(CRSDepTime), SUM(OriginAirportID) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 6","hsqls":["SELECT Quarter, AVG(CRSDepTime), SUM(OriginAirportID) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 6"]}
{"sql":"SELECT DayofMonth, DaysSinceEpoch FROM mytable WHERE DivWheelsOffs IN (1228, 1812, 1509) OR TaxiIn < 5 ORDER BY TaxiOut, DivArrDelay LIMIT 3","hsqls":["SELECT DayofMonth, DaysSinceEpoch FROM mytable WHERE (DivWheelsOffs[1] IN (1228, 1812, 1509) OR DivWheelsOffs[2] IN (1228, 1812, 1509) OR DivWheelsOffs[3] IN (1228, 1812, 1509) OR DivWheelsOffs[4] IN (1228, 1812, 1509) OR DivWheelsOffs[5] IN (1228, 1812, 1509)) OR TaxiIn < 5 ORDER BY TaxiOut, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT DestAirportID FROM mytable WHERE TotalAddGTime BETWEEN 111 AND 27 AND DepDelayMinutes BETWEEN 223.0 AND 86.0 LIMIT 29"}
{"sql":"SELECT LateAircraftDelay, Carrier, OriginWac, COUNT(*) FROM mytable WHERE ArrTime BETWEEN 21 AND 1225 GROUP BY LateAircraftDelay, Carrier, OriginWac  ORDER BY LateAircraftDelay, Carrier, OriginWac LIMIT 10","hsqls":["SELECT LateAircraftDelay, Carrier, OriginWac, COUNT(*) FROM mytable WHERE ArrTime BETWEEN 21 AND 1225 GROUP BY LateAircraftDelay, Carrier, OriginWac  ORDER BY LateAircraftDelay, Carrier, OriginWac LIMIT 10"]}
{"sql":"SELECT DayofMonth FROM mytable WHERE OriginCityMarketID BETWEEN 33304 AND 35401 AND LateAircraftDelay < 44 AND FlightNum <> 2386 LIMIT 1"}
{"sql":"SELECT OriginState, Flights, OriginCityName, COUNT(DestStateName) FROM mytable WHERE OriginState BETWEEN 'VA' AND 'CO' AND DestAirportID <> 11278 GROUP BY OriginState, Flights, OriginCityName  ORDER BY OriginState, Flights, OriginCityName LIMIT 8","hsqls":["SELECT OriginState, Flights, OriginCityName, COUNT(DestStateName) FROM mytable WHERE OriginState BETWEEN 'VA' AND 'CO' AND DestAirportID <> 11278 GROUP BY OriginState, Flights, OriginCityName  ORDER BY OriginState, Flights, OriginCityName LIMIT 8"]}
{"sql":"SELECT ActualElapsedTime, DivAirportSeqIDs, DivTotalGTimes FROM mytable ORDER BY WeatherDelay, Dest LIMIT 14","hsqls":["SELECT ActualElapsedTime, DivAirportSeqIDs, DivTotalGTimes FROM mytable ORDER BY WeatherDelay, Dest LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DestCityName FROM mytable WHERE DivAirportLandings BETWEEN 9 AND 0 AND FirstDepTime <> 907 ORDER BY DestStateFips LIMIT 8"}
{"sql":"SELECT WeatherDelay, ArrTimeBlk FROM mytable WHERE OriginState < 'AL' AND ArrivalDelayGroups >= 6 ORDER BY OriginStateFips, LateAircraftDelay, ArrDelay LIMIT 13"}
{"sql":"SELECT WheelsOff, ActualElapsedTime, NASDelay, COUNT(*) FROM mytable WHERE ArrTimeBlk BETWEEN '2200-2259' AND '1900-1959' OR ActualElapsedTime IN (394) OR Distance > 1597 GROUP BY WheelsOff, ActualElapsedTime, NASDelay  ORDER BY WheelsOff, ActualElapsedTime, NASDelay LIMIT 24","hsqls":["SELECT WheelsOff, ActualElapsedTime, NASDelay, COUNT(*) FROM mytable WHERE ArrTimeBlk BETWEEN '2200-2259' AND '1900-1959' OR ActualElapsedTime IN (394) OR Distance > 1597 GROUP BY WheelsOff, ActualElapsedTime, NASDelay  ORDER BY WheelsOff, ActualElapsedTime, NASDelay LIMIT 24"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 4"}
{"sql":"SELECT OriginStateFips, TotalAddGTime, ArrTimeBlk, COUNT(OriginAirportSeqID), AVG(DepDelayMinutes) FROM mytable GROUP BY OriginStateFips, TotalAddGTime, ArrTimeBlk  ORDER BY OriginStateFips, TotalAddGTime, ArrTimeBlk LIMIT 14","hsqls":["SELECT OriginStateFips, TotalAddGTime, ArrTimeBlk, COUNT(OriginAirportSeqID), AVG(DepDelayMinutes) FROM mytable GROUP BY OriginStateFips, TotalAddGTime, ArrTimeBlk  ORDER BY OriginStateFips, TotalAddGTime, ArrTimeBlk LIMIT 14"]}
{"sql":"SELECT COUNT(Carrier), COUNT(OriginCityMarketID), SUM(\"Year\") FROM mytable WHERE OriginStateName = 'Hawaii' LIMIT 4","hsqls":["SELECT COUNT(Carrier), COUNT(OriginCityMarketID), SUM(`Year`) FROM mytable WHERE OriginStateName = 'Hawaii' LIMIT 4"]}
{"sql":"SELECT DepDelay, DivTotalGTimes FROM mytable WHERE FlightNum NOT IN (3627) OR ArrTime <> 107 LIMIT 22","hsqls":["SELECT DepDelay, DivTotalGTimes FROM mytable WHERE FlightNum NOT IN (3627) OR ArrTime <> 107 LIMIT 10000"]}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DivActualElapsedTime >= 330 AND ActualElapsedTime IN (224, 91, 233, 282) ORDER BY WheelsOff, ActualElapsedTime, OriginStateName LIMIT 16"}
{"sql":"SELECT AVG(FirstDepTime), COUNT(LongestAddGTime) FROM mytable WHERE Origin <= 'LIT' LIMIT 10"}
{"sql":"SELECT FlightDate, OriginCityName, ArrTime FROM mytable ORDER BY SecurityDelay LIMIT 2"}
{"sql":"SELECT TaxiIn FROM mytable WHERE OriginStateName BETWEEN 'Alaska' AND 'Maryland' OR ArrDel15 NOT IN (1, 0, -9999) ORDER BY DivReachedDest, Carrier LIMIT 20"}
{"sql":"SELECT DepTime, DayofMonth, AVG(OriginAirportSeqID), MAX(ArrTime) FROM mytable WHERE OriginCityMarketID BETWEEN 30476 AND 30747 AND DepDelay NOT IN (64.0, 144.0, 118.0, 39.0) OR TaxiIn >= 37 GROUP BY DepTime, DayofMonth","hsqls":["SELECT DepTime, DayofMonth, AVG(OriginAirportSeqID), MAX(ArrTime) FROM mytable WHERE OriginCityMarketID BETWEEN 30476 AND 30747 AND DepDelay NOT IN (64.0, 144.0, 118.0, 39.0) OR TaxiIn >= 37 GROUP BY DepTime, DayofMonth"]}
{"sql":"SELECT Carrier, AirTime FROM mytable WHERE ArrivalDelayGroups >= 2 ORDER BY TotalAddGTime, DestCityMarketID, UniqueCarrier LIMIT 19"}
{"sql":"SELECT DivDistance, OriginStateName, SUM(Cancelled), SUM(OriginAirportID), MAX(DayOfWeek) FROM mytable GROUP BY DivDistance, OriginStateName  ORDER BY DivDistance, OriginStateName LIMIT 7","hsqls":["SELECT DivDistance, OriginStateName, SUM(Cancelled), SUM(OriginAirportID), MAX(DayOfWeek) FROM mytable GROUP BY DivDistance, OriginStateName  ORDER BY DivDistance, OriginStateName LIMIT 7"]}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DivAirports IN ('MGM', 'PDX') LIMIT 3","hsqls":["SELECT CRSArrTime FROM mytable WHERE (DivAirports[1] IN ('MGM', 'PDX') OR DivAirports[2] IN ('MGM', 'PDX') OR DivAirports[3] IN ('MGM', 'PDX') OR DivAirports[4] IN ('MGM', 'PDX') OR DivAirports[5] IN ('MGM', 'PDX')) LIMIT 10000"]}
{"sql":"SELECT TaxiOut FROM mytable ORDER BY FlightNum, SecurityDelay, Cancelled LIMIT 16"}
{"sql":"SELECT \"Month\" FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 0 ORDER BY DivDistance, ArrDelayMinutes, DivAirportLandings LIMIT 12","hsqls":["SELECT `Month` FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 0 ORDER BY DivDistance, ArrDelayMinutes, DivAirportLandings LIMIT 12"]}
{"sql":"SELECT COUNT(\"Month\"), MIN(DepDel15) FROM mytable WHERE DivAirports IN ('CPR', 'SGU', 'SPS', 'PHX') LIMIT 13","hsqls":["SELECT COUNT(`Month`), MIN(DepDel15) FROM mytable WHERE (DivAirports[1] IN ('CPR', 'SGU', 'SPS', 'PHX') OR DivAirports[2] IN ('CPR', 'SGU', 'SPS', 'PHX') OR DivAirports[3] IN ('CPR', 'SGU', 'SPS', 'PHX') OR DivAirports[4] IN ('CPR', 'SGU', 'SPS', 'PHX') OR DivAirports[5] IN ('CPR', 'SGU', 'SPS', 'PHX')) LIMIT 10000"]}
{"sql":"SELECT ArrTimeBlk, SUM(TaxiOut) FROM mytable WHERE DivDistance IN (237) OR CancellationCode BETWEEN 'B' AND 'B' OR DivTotalGTimes > 49 GROUP BY ArrTimeBlk LIMIT 29","hsqls":["SELECT ArrTimeBlk, SUM(TaxiOut) FROM mytable WHERE DivDistance IN (237) OR CancellationCode BETWEEN 'B' AND 'B' OR (DivTotalGTimes[1] > 49 OR DivTotalGTimes[2] > 49 OR DivTotalGTimes[3] > 49 OR DivTotalGTimes[4] > 49 OR DivTotalGTimes[5] > 49) GROUP BY ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, DestStateName, DivActualElapsedTime FROM mytable WHERE DestCityName NOT IN ('Minot, ND', 'San Angelo, TX') LIMIT 23"}
{"sql":"SELECT DepDelayMinutes FROM mytable WHERE Cancelled >= 1 AND TailNum < 'N37413' AND DestStateName IN ('South Carolina', 'Alaska', 'California', 'Nevada') ORDER BY Dest LIMIT 15"}
{"sql":"SELECT OriginState FROM mytable WHERE DestCityName NOT IN ('Chattanooga, TN', 'Shreveport, LA', 'Tampa, FL') LIMIT 4"}
{"sql":"SELECT DistanceGroup FROM mytable WHERE DivLongestGTimes IN (136.0, 92.0, 7.0, 47.0) AND Dest NOT IN ('ISP') OR DestState IN ('IA', 'OK', 'NH') LIMIT 12","hsqls":["SELECT DistanceGroup FROM mytable WHERE (DivLongestGTimes[1] IN (136.0, 92.0, 7.0, 47.0) OR DivLongestGTimes[2] IN (136.0, 92.0, 7.0, 47.0) OR DivLongestGTimes[3] IN (136.0, 92.0, 7.0, 47.0) OR DivLongestGTimes[4] IN (136.0, 92.0, 7.0, 47.0) OR DivLongestGTimes[5] IN (136.0, 92.0, 7.0, 47.0)) AND Dest NOT IN ('ISP') OR DestState IN ('IA', 'OK', 'NH') LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, OriginCityMarketID, DestAirportID FROM mytable WHERE ArrDel15 BETWEEN 1 AND -9999 OR DepTimeBlk = '0800-0859' AND SecurityDelay <= 1 ORDER BY DepartureDelayGroups, DivReachedDest, ArrivalDelayGroups LIMIT 22"}
{"sql":"SELECT DivDistance, DivArrDelay FROM mytable WHERE Origin >= 'BGR' AND ArrDel15 IN (1, 0, -9999) OR DestCityName IN ('Williston, ND', 'Memphis, TN', 'Montrose/Delta, CO', 'Washington, DC') ORDER BY DestState, ArrDelay, CRSDepTime LIMIT 11"}
{"sql":"SELECT OriginStateFips FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) ORDER BY DestCityMarketID LIMIT 29"}
{"sql":"SELECT DaysSinceEpoch, MAX(DestAirportID), SUM(DestAirportSeqID), AVG(FirstDepTime) FROM mytable WHERE DivWheelsOffs BETWEEN 1156 AND 1307 AND DepDelayMinutes BETWEEN 18.0 AND 61.0 AND Origin IN ('DAY') GROUP BY DaysSinceEpoch LIMIT 10","hsqls":["SELECT DaysSinceEpoch, MAX(DestAirportID), SUM(DestAirportSeqID), AVG(FirstDepTime) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1156 AND 1307 OR DivWheelsOffs[2] BETWEEN 1156 AND 1307 OR DivWheelsOffs[3] BETWEEN 1156 AND 1307 OR DivWheelsOffs[4] BETWEEN 1156 AND 1307 OR DivWheelsOffs[5] BETWEEN 1156 AND 1307) AND DepDelayMinutes BETWEEN 18.0 AND 61.0 AND Origin IN ('DAY') GROUP BY DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT MAX(DestCityMarketID) FROM mytable WHERE DestState IN ('CA', 'IN', 'VA', 'KS', 'MA') OR DestStateName = 'Georgia' OR DestAirportID IN (13158, 11540, 12888, 10785, 15624) LIMIT 10"}
{"sql":"SELECT Origin, CRSDepTime FROM mytable WHERE CRSElapsedTime IN (299, 39) OR Dest NOT IN ('ABI', 'SRQ') LIMIT 26"}
{"sql":"SELECT AVG(FlightNum), COUNT(CRSArrTime) FROM mytable WHERE Cancelled <> 0 OR OriginCityName BETWEEN 'Charleston, SC' AND 'Hartford, CT' OR OriginState BETWEEN 'OH' AND 'ME' LIMIT 14"}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE DivAirportSeqIDs IN (1219102, 1348502, 1306104) ORDER BY DestStateFips, ArrTime LIMIT 5","hsqls":["SELECT ArrDelayMinutes FROM mytable WHERE (DivAirportSeqIDs[1] IN (1219102, 1348502, 1306104) OR DivAirportSeqIDs[2] IN (1219102, 1348502, 1306104) OR DivAirportSeqIDs[3] IN (1219102, 1348502, 1306104) OR DivAirportSeqIDs[4] IN (1219102, 1348502, 1306104) OR DivAirportSeqIDs[5] IN (1219102, 1348502, 1306104)) ORDER BY DestStateFips, ArrTime LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DestState, CRSDepTime, AVG(NASDelay), MIN(NASDelay), MAX(AirTime) FROM mytable GROUP BY WheelsOff, DestState, CRSDepTime  ORDER BY WheelsOff, DestState, CRSDepTime LIMIT 22","hsqls":["SELECT WheelsOff, DestState, CRSDepTime, AVG(NASDelay), MIN(NASDelay), MAX(AirTime) FROM mytable GROUP BY WheelsOff, DestState, CRSDepTime  ORDER BY WheelsOff, DestState, CRSDepTime LIMIT 22"]}
{"sql":"SELECT DestWac, Dest, COUNT(*) FROM mytable WHERE LateAircraftDelay < 98 OR Cancelled BETWEEN 1 AND 1 GROUP BY DestWac, Dest  ORDER BY DestWac, Dest LIMIT 9","hsqls":["SELECT DestWac, Dest, COUNT(*) FROM mytable WHERE LateAircraftDelay < 98 OR Cancelled BETWEEN 1 AND 1 GROUP BY DestWac, Dest  ORDER BY DestWac, Dest LIMIT 9"]}
{"sql":"SELECT ArrDelayMinutes, \"Month\", OriginAirportID FROM mytable WHERE DivTailNums BETWEEN 'N8617E' AND 'N592JB' OR CRSArrTime BETWEEN 2314 AND 839 ORDER BY WeatherDelay, ArrTimeBlk LIMIT 22","hsqls":["SELECT ArrDelayMinutes, Month, OriginAirportID FROM mytable WHERE (DivTailNums[1] BETWEEN 'N8617E' AND 'N592JB' OR DivTailNums[2] BETWEEN 'N8617E' AND 'N592JB' OR DivTailNums[3] BETWEEN 'N8617E' AND 'N592JB' OR DivTailNums[4] BETWEEN 'N8617E' AND 'N592JB' OR DivTailNums[5] BETWEEN 'N8617E' AND 'N592JB') OR CRSArrTime BETWEEN 2314 AND 839 ORDER BY WeatherDelay, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, SecurityDelay, COUNT(CancellationCode), MAX(DayofMonth) FROM mytable WHERE DepartureDelayGroups <> -9999 GROUP BY DepartureDelayGroups, SecurityDelay  ORDER BY DepartureDelayGroups, SecurityDelay LIMIT 27","hsqls":["SELECT DepartureDelayGroups, SecurityDelay, COUNT(CancellationCode), MAX(DayofMonth) FROM mytable WHERE DepartureDelayGroups <> -9999 GROUP BY DepartureDelayGroups, SecurityDelay  ORDER BY DepartureDelayGroups, SecurityDelay LIMIT 27"]}
{"sql":"SELECT SUM(DivAirportLandings), AVG(ArrivalDelayGroups), COUNT(WeatherDelay) FROM mytable WHERE AirlineID IN (20304, 20436, 21171) OR Dest BETWEEN 'ASE' AND 'STX' OR OriginAirportID < 10747 LIMIT 10"}
{"sql":"SELECT OriginCityMarketID, LongestAddGTime FROM mytable WHERE OriginStateName BETWEEN 'U.S. Virgin Islands' AND 'New Mexico' AND ArrDel15 = -9999 ORDER BY FlightDate, TaxiIn LIMIT 25"}
{"sql":"SELECT UniqueCarrier FROM mytable WHERE DivTotalGTimes BETWEEN 84 AND 50 OR OriginStateName IN ('Missouri') ORDER BY WheelsOff, DepTimeBlk LIMIT 26","hsqls":["SELECT UniqueCarrier FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 84 AND 50 OR DivTotalGTimes[2] BETWEEN 84 AND 50 OR DivTotalGTimes[3] BETWEEN 84 AND 50 OR DivTotalGTimes[4] BETWEEN 84 AND 50 OR DivTotalGTimes[5] BETWEEN 84 AND 50) OR OriginStateName IN ('Missouri') ORDER BY WheelsOff, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, COUNT(*) FROM mytable GROUP BY DistanceGroup  ORDER BY DistanceGroup LIMIT 21","hsqls":["SELECT DistanceGroup, COUNT(*) FROM mytable GROUP BY DistanceGroup  ORDER BY DistanceGroup LIMIT 21"]}
{"sql":"SELECT LongestAddGTime, CRSDepTime, AVG(DivActualElapsedTime) FROM mytable WHERE DivWheelsOffs BETWEEN 109 AND 2247 AND \"Year\" NOT IN (2014) AND ArrDel15 <= -9999 GROUP BY LongestAddGTime, CRSDepTime LIMIT 14","hsqls":["SELECT LongestAddGTime, CRSDepTime, AVG(CAST(DivActualElapsedTime AS DOUBLE)) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 109 AND 2247 OR DivWheelsOffs[2] BETWEEN 109 AND 2247 OR DivWheelsOffs[3] BETWEEN 109 AND 2247 OR DivWheelsOffs[4] BETWEEN 109 AND 2247 OR DivWheelsOffs[5] BETWEEN 109 AND 2247) AND `Year` NOT IN (2014) AND ArrDel15 <= -9999 GROUP BY LongestAddGTime, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT AVG(DivDistance), MAX(Diverted) FROM mytable WHERE DepTime BETWEEN 1531 AND 2048 LIMIT 10"}
{"sql":"SELECT Cancelled, NASDelay FROM mytable ORDER BY Dest LIMIT 21"}
{"sql":"SELECT Diverted, WeatherDelay, ActualElapsedTime FROM mytable ORDER BY DepTimeBlk, DivArrDelay LIMIT 11"}
{"sql":"SELECT Dest FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR OriginWac <= 16 OR OriginAirportSeqID >= 1062002 LIMIT 7"}
{"sql":"SELECT WeatherDelay FROM mytable WHERE Origin NOT IN ('MRY', 'ICT', 'GSP') OR DivTailNums BETWEEN 'N956AT' AND 'N374JB' AND DivAirports BETWEEN 'ABE' AND 'GSP' ORDER BY DepTime, DestAirportSeqID, DepDel15 LIMIT 12","hsqls":["SELECT WeatherDelay FROM mytable WHERE Origin NOT IN ('MRY', 'ICT', 'GSP') OR (DivTailNums[1] BETWEEN 'N956AT' AND 'N374JB' OR DivTailNums[2] BETWEEN 'N956AT' AND 'N374JB' OR DivTailNums[3] BETWEEN 'N956AT' AND 'N374JB' OR DivTailNums[4] BETWEEN 'N956AT' AND 'N374JB' OR DivTailNums[5] BETWEEN 'N956AT' AND 'N374JB') AND (DivAirports[1] BETWEEN 'ABE' AND 'GSP' OR DivAirports[2] BETWEEN 'ABE' AND 'GSP' OR DivAirports[3] BETWEEN 'ABE' AND 'GSP' OR DivAirports[4] BETWEEN 'ABE' AND 'GSP' OR DivAirports[5] BETWEEN 'ABE' AND 'GSP') ORDER BY DepTime, DestAirportSeqID, DepDel15 LIMIT 10000"]}
{"sql":"SELECT TaxiOut, ActualElapsedTime, DayOfWeek, MAX(LongestAddGTime), MAX(DivActualElapsedTime) FROM mytable WHERE DestStateName IN ('Wyoming', 'Virginia', 'Hawaii', 'Alabama', 'Iowa') AND CRSArrTime NOT IN (1401, 1025) GROUP BY TaxiOut, ActualElapsedTime, DayOfWeek  ORDER BY TaxiOut, ActualElapsedTime, DayOfWeek LIMIT 8","hsqls":["SELECT TaxiOut, ActualElapsedTime, DayOfWeek, MAX(LongestAddGTime), MAX(DivActualElapsedTime) FROM mytable WHERE DestStateName IN ('Wyoming', 'Virginia', 'Hawaii', 'Alabama', 'Iowa') AND CRSArrTime NOT IN (1401, 1025) GROUP BY TaxiOut, ActualElapsedTime, DayOfWeek  ORDER BY TaxiOut, ActualElapsedTime, DayOfWeek LIMIT 8"]}
{"sql":"SELECT DestWac, OriginState, MIN(Flights) FROM mytable GROUP BY DestWac, OriginState  ORDER BY DestWac, OriginState LIMIT 17","hsqls":["SELECT DestWac, OriginState, MIN(Flights) FROM mytable GROUP BY DestWac, OriginState  ORDER BY DestWac, OriginState LIMIT 17"]}
{"sql":"SELECT CRSDepTime FROM mytable ORDER BY Cancelled, OriginWac LIMIT 6"}
{"sql":"SELECT OriginAirportSeqID, TaxiOut, DivAirports FROM mytable ORDER BY OriginStateFips, DepTimeBlk LIMIT 8","hsqls":["SELECT OriginAirportSeqID, TaxiOut, DivAirports FROM mytable ORDER BY OriginStateFips, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT Cancelled, DestCityMarketID FROM mytable WHERE NASDelay < 37 OR DepTime >= 1503 OR ArrTime BETWEEN 757 AND 1112 ORDER BY ArrDel15 LIMIT 27"}
{"sql":"SELECT Carrier, OriginCityName, DayOfWeek FROM mytable WHERE WeatherDelay > 198 LIMIT 20"}
{"sql":"SELECT LateAircraftDelay, Flights, LongestAddGTime, SUM(ArrDel15), AVG(ArrivalDelayGroups), COUNT(DepTime) FROM mytable WHERE TailNum BETWEEN 'N15527' AND 'N531JB' AND OriginWac IN (5, 35, 22, 73, 13) GROUP BY LateAircraftDelay, Flights, LongestAddGTime  ORDER BY LateAircraftDelay, Flights, LongestAddGTime LIMIT 14","hsqls":["SELECT LateAircraftDelay, Flights, LongestAddGTime, SUM(ArrDel15), AVG(ArrivalDelayGroups), COUNT(DepTime) FROM mytable WHERE TailNum BETWEEN 'N15527' AND 'N531JB' AND OriginWac IN (5, 35, 22, 73, 13) GROUP BY LateAircraftDelay, Flights, LongestAddGTime  ORDER BY LateAircraftDelay, Flights, LongestAddGTime LIMIT 14"]}
{"sql":"SELECT DivAirportLandings, WheelsOn FROM mytable WHERE ArrDelayMinutes BETWEEN 237.0 AND 269.0 AND DepTime >= 108 OR NASDelay BETWEEN 113 AND 40 ORDER BY \"Year\" LIMIT 6","hsqls":["SELECT DivAirportLandings, WheelsOn FROM mytable WHERE ArrDelayMinutes BETWEEN 237.0 AND 269.0 AND DepTime >= 108 OR NASDelay BETWEEN 113 AND 40 ORDER BY `Year` LIMIT 6"]}
{"sql":"SELECT MIN(DivDistance), MIN(CarrierDelay), SUM(DepDelay) FROM mytable WHERE DivTotalGTimes = 47 LIMIT 9","hsqls":["SELECT MIN(DivDistance), MIN(CarrierDelay), SUM(DepDelay)  FROM mytable WHERE (DivTotalGTimes[1] = 47 OR DivTotalGTimes[2] = 47 OR DivTotalGTimes[3] = 47 OR DivTotalGTimes[4] = 47 OR DivTotalGTimes[5] = 47) LIMIT 10000"]}
{"sql":"SELECT COUNT(OriginWac), MAX(Diverted) FROM mytable"}
{"sql":"SELECT DepTime, DestAirportID FROM mytable WHERE WheelsOn BETWEEN 1528 AND 1608 OR DestCityMarketID NOT IN (30647, 32441) LIMIT 18"}
{"sql":"SELECT DepartureDelayGroups, TaxiOut, SecurityDelay FROM mytable WHERE OriginStateName IN ('Arizona', 'Wisconsin', 'Florida') AND DivTailNums IN ('N13994') ORDER BY TaxiOut, DestCityMarketID LIMIT 13","hsqls":["SELECT DepartureDelayGroups, TaxiOut, SecurityDelay FROM mytable WHERE OriginStateName IN ('Arizona', 'Wisconsin', 'Florida') AND (DivTailNums[1] IN ('N13994') OR DivTailNums[2] IN ('N13994') OR DivTailNums[3] IN ('N13994') OR DivTailNums[4] IN ('N13994') OR DivTailNums[5] IN ('N13994')) ORDER BY TaxiOut, DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID FROM mytable WHERE Origin = 'FCA' OR CRSArrTime BETWEEN 1521 AND 2305 ORDER BY DivDistance LIMIT 29"}
{"sql":"SELECT Cancelled, DepDel15, UniqueCarrier FROM mytable WHERE DaysSinceEpoch NOT IN (16100) AND ArrTimeBlk IN ('2200-2259', '1900-1959') LIMIT 16"}
{"sql":"SELECT Distance, Dest, DepDel15 FROM mytable WHERE LateAircraftDelay > 59 OR OriginCityName > 'El Paso, TX' ORDER BY FlightDate, AirlineID LIMIT 16"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 20"}
{"sql":"SELECT Flights, MAX(ArrDelay), MIN(DestCityMarketID), MIN(DestAirportSeqID) FROM mytable WHERE DivAirportSeqIDs >= 1219102 AND DepDelay NOT IN (123.0) GROUP BY Flights LIMIT 13","hsqls":["SELECT Flights, MAX(ArrDelay), MIN(DestCityMarketID), MIN(DestAirportSeqID) FROM mytable WHERE (DivAirportSeqIDs[1] >= 1219102 OR DivAirportSeqIDs[2] >= 1219102 OR DivAirportSeqIDs[3] >= 1219102 OR DivAirportSeqIDs[4] >= 1219102 OR DivAirportSeqIDs[5] >= 1219102) AND DepDelay NOT IN (123.0) GROUP BY Flights LIMIT 10000"]}
{"sql":"SELECT \"Year\", DivActualElapsedTime, OriginAirportID, MIN(TotalAddGTime) FROM mytable GROUP BY \"Year\", DivActualElapsedTime, OriginAirportID LIMIT 8","hsqls":["SELECT Year, DivActualElapsedTime, OriginAirportID, MIN(TotalAddGTime) FROM mytable GROUP BY Year, DivActualElapsedTime, OriginAirportID LIMIT 8"]}
{"sql":"SELECT NASDelay, DestCityMarketID, COUNT(*) FROM mytable WHERE FlightDate BETWEEN '2014-01-28' AND '2014-01-08' GROUP BY NASDelay, DestCityMarketID  ORDER BY NASDelay, DestCityMarketID LIMIT 9","hsqls":["SELECT NASDelay, DestCityMarketID, COUNT(*) FROM mytable WHERE FlightDate BETWEEN '2014-01-28' AND '2014-01-08' GROUP BY NASDelay, DestCityMarketID  ORDER BY NASDelay, DestCityMarketID LIMIT 9"]}
{"sql":"SELECT Flights FROM mytable WHERE OriginStateName NOT IN ('Colorado', 'Massachusetts') AND DivLongestGTimes IN (102.0, 80.0) ORDER BY OriginState, OriginCityName LIMIT 9","hsqls":["SELECT Flights FROM mytable WHERE OriginStateName NOT IN ('Colorado', 'Massachusetts') AND (DivLongestGTimes[1] IN (102.0, 80.0) OR DivLongestGTimes[2] IN (102.0, 80.0) OR DivLongestGTimes[3] IN (102.0, 80.0) OR DivLongestGTimes[4] IN (102.0, 80.0) OR DivLongestGTimes[5] IN (102.0, 80.0)) ORDER BY OriginState, OriginCityName LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime, DestAirportID FROM mytable WHERE ArrDelay <> 125.0 OR OriginState BETWEEN 'UT' AND 'IN' ORDER BY TotalAddGTime, DestCityMarketID LIMIT 9"}
{"sql":"SELECT Quarter, DivActualElapsedTime FROM mytable WHERE WeatherDelay NOT IN (166) OR OriginStateFips BETWEEN 27 AND 36 OR DepDelayMinutes <> 212.0 LIMIT 20"}
{"sql":"SELECT LateAircraftDelay FROM mytable WHERE TailNum IN ('N684DA', 'N299WN', 'N765US', 'N5CCAA', 'N12924') ORDER BY LongestAddGTime, DepTime, DestStateName LIMIT 22"}
{"sql":"SELECT \"Year\", MAX(OriginAirportSeqID) FROM mytable WHERE OriginCityMarketID <= 31695 GROUP BY \"Year\" LIMIT 1","hsqls":["SELECT Year, MAX(OriginAirportSeqID) FROM mytable WHERE OriginCityMarketID <= 31695 GROUP BY `Year` LIMIT 1"]}
{"sql":"SELECT DivDistance, DestStateFips FROM mytable WHERE Origin BETWEEN 'SGF' AND 'LAR' AND FlightNum <> 1855 ORDER BY WheelsOn, UniqueCarrier LIMIT 4"}
{"sql":"SELECT DepTimeBlk FROM mytable WHERE Distance <= 1849 OR OriginAirportSeqID IN (1244805, 1198202) ORDER BY CarrierDelay LIMIT 18"}
{"sql":"SELECT DestWac, DivDistance, ArrTimeBlk FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'noodles' AND AirTime BETWEEN 271 AND 442 ORDER BY Flights, WeatherDelay, DestStateName"}
{"sql":"SELECT OriginStateFips, Carrier, DestCityMarketID, COUNT(WheelsOff), MAX(Cancelled), MAX(Distance) FROM mytable WHERE CarrierDelay NOT IN (455) GROUP BY OriginStateFips, Carrier, DestCityMarketID  ORDER BY OriginStateFips, Carrier, DestCityMarketID LIMIT 26","hsqls":["SELECT OriginStateFips, Carrier, DestCityMarketID, COUNT(WheelsOff), MAX(Cancelled), MAX(Distance) FROM mytable WHERE CarrierDelay NOT IN (455) GROUP BY OriginStateFips, Carrier, DestCityMarketID  ORDER BY OriginStateFips, Carrier, DestCityMarketID LIMIT 26"]}
{"sql":"SELECT DivTailNums FROM mytable WHERE ArrTime BETWEEN 113 AND 1749 AND DepDelayMinutes BETWEEN 179.0 AND 644.0 ORDER BY FlightDate, DivArrDelay LIMIT 14","hsqls":["SELECT DivTailNums FROM mytable WHERE ArrTime BETWEEN 113 AND 1749 AND DepDelayMinutes BETWEEN 179.0 AND 644.0 ORDER BY FlightDate, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT CancellationCode FROM mytable WHERE DivTailNums BETWEEN 'N882AS' AND 'N614QX' OR LateAircraftDelay IN (35) AND DivArrDelay BETWEEN 331 AND 133 ORDER BY OriginCityMarketID, Distance, DestAirportSeqID LIMIT 21","hsqls":["SELECT CancellationCode FROM mytable WHERE (DivTailNums[1] BETWEEN 'N882AS' AND 'N614QX' OR DivTailNums[2] BETWEEN 'N882AS' AND 'N614QX' OR DivTailNums[3] BETWEEN 'N882AS' AND 'N614QX' OR DivTailNums[4] BETWEEN 'N882AS' AND 'N614QX' OR DivTailNums[5] BETWEEN 'N882AS' AND 'N614QX') OR LateAircraftDelay IN (35) AND DivArrDelay BETWEEN 331 AND 133 ORDER BY OriginCityMarketID, Distance, DestAirportSeqID LIMIT 10000"]}
{"sql":"SELECT Dest FROM mytable WHERE DestAirportID <> 12915 LIMIT 16"}
{"sql":"SELECT FlightDate FROM mytable WHERE ArrTimeBlk IN ('1600-1659', '1300-1359', '1800-1859') OR DivTotalGTimes = 87 OR TotalAddGTime <> 30 ORDER BY OriginCityMarketID, DepDelayMinutes, CRSDepTime LIMIT 24","hsqls":["SELECT FlightDate FROM mytable WHERE ArrTimeBlk IN ('1600-1659', '1300-1359', '1800-1859') OR (DivTotalGTimes[1] = 87 OR DivTotalGTimes[2] = 87 OR DivTotalGTimes[3] = 87 OR DivTotalGTimes[4] = 87 OR DivTotalGTimes[5] = 87) OR TotalAddGTime <> 30 ORDER BY OriginCityMarketID, DepDelayMinutes, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT Cancelled, DestAirportID, UniqueCarrier, COUNT(*) FROM mytable GROUP BY Cancelled, DestAirportID, UniqueCarrier  ORDER BY Cancelled, DestAirportID, UniqueCarrier LIMIT 10","hsqls":["SELECT Cancelled, DestAirportID, UniqueCarrier, COUNT(*) FROM mytable GROUP BY Cancelled, DestAirportID, UniqueCarrier  ORDER BY Cancelled, DestAirportID, UniqueCarrier LIMIT 10"]}
{"sql":"SELECT \"Month\" FROM mytable ORDER BY Carrier, DestStateName, DepTimeBlk LIMIT 5","hsqls":["SELECT `Month` FROM mytable ORDER BY Carrier, DestStateName, DepTimeBlk LIMIT 5"]}
{"sql":"SELECT OriginState, ArrDelay, AVG(DaysSinceEpoch) FROM mytable WHERE Distance IN (1447, 851, 627, 2465, 255) AND DestState <> 'WV' AND DestWac BETWEEN 92 AND 64 GROUP BY OriginState, ArrDelay  ORDER BY OriginState, ArrDelay LIMIT 26","hsqls":["SELECT OriginState, ArrDelay, AVG(DaysSinceEpoch) FROM mytable WHERE Distance IN (1447, 851, 627, 2465, 255) AND DestState <> 'WV' AND DestWac BETWEEN 92 AND 64 GROUP BY OriginState, ArrDelay  ORDER BY OriginState, ArrDelay LIMIT 26"]}
{"sql":"SELECT OriginAirportSeqID, DistanceGroup, DestWac FROM mytable LIMIT 8"}
{"sql":"SELECT DivTailNums, TailNum, AirlineID FROM mytable WHERE DestAirportID IN (10170, 14524, 15070, 10693, 12819) OR OriginCityName NOT IN ('Barrow, AK', 'Fort Wayne, IN', 'Portland, OR', 'Wilmington, DE', 'Bozeman, MT') OR SecurityDelay BETWEEN 1 AND 27 LIMIT 14","hsqls":["SELECT DivTailNums, TailNum, AirlineID FROM mytable WHERE DestAirportID IN (10170, 14524, 15070, 10693, 12819) OR OriginCityName NOT IN ('Barrow, AK', 'Fort Wayne, IN', 'Portland, OR', 'Wilmington, DE', 'Bozeman, MT') OR SecurityDelay BETWEEN 1 AND 27 LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, OriginWac FROM mytable WHERE SecurityDelay < 4 AND WheelsOff NOT IN (2003, 2011) LIMIT 25"}
{"sql":"SELECT ArrDelay FROM mytable ORDER BY ArrDelay LIMIT 15"}
{"sql":"SELECT Carrier, SecurityDelay FROM mytable WHERE \"Year\" NOT IN (2014) OR LongestAddGTime NOT IN (2, 78, 74) ORDER BY WheelsOff, OriginStateName, OriginAirportID LIMIT 20","hsqls":["SELECT Carrier, SecurityDelay FROM mytable WHERE `Year` NOT IN (2014) OR LongestAddGTime NOT IN (2, 78, 74) ORDER BY WheelsOff, OriginStateName, OriginAirportID LIMIT 20"]}
{"sql":"SELECT OriginCityName, DestStateName, MIN(DepTime), AVG(DivAirportLandings) FROM mytable WHERE AirlineID NOT IN (19690) OR OriginCityMarketID >= 31921 OR ActualElapsedTime NOT IN (240, 340, 35, 73) GROUP BY OriginCityName, DestStateName  ORDER BY OriginCityName, DestStateName LIMIT 29","hsqls":["SELECT OriginCityName, DestStateName, MIN(DepTime), AVG(DivAirportLandings) FROM mytable WHERE AirlineID NOT IN (19690) OR OriginCityMarketID >= 31921 OR ActualElapsedTime NOT IN (240, 340, 35, 73) GROUP BY OriginCityName, DestStateName  ORDER BY OriginCityName, DestStateName LIMIT 29"]}
{"sql":"SELECT Distance, COUNT(DepDelay) FROM mytable WHERE ArrivalDelayGroups NOT IN (10) GROUP BY Distance  ORDER BY Distance LIMIT 28","hsqls":["SELECT Distance, COUNT(DepDelay) FROM mytable WHERE ArrivalDelayGroups NOT IN (10) GROUP BY Distance  ORDER BY Distance LIMIT 28"]}
{"sql":"SELECT Dest, DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups < 8 AND OriginStateName BETWEEN 'Idaho' AND 'U.S. Pacific Trust Territories and Possessions' AND DivAirports IN ('MLI') LIMIT 5","hsqls":["SELECT Dest, DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups < 8 AND OriginStateName BETWEEN 'Idaho' AND 'U.S. Pacific Trust Territories and Possessions' AND (DivAirports[1] IN ('MLI') OR DivAirports[2] IN ('MLI') OR DivAirports[3] IN ('MLI') OR DivAirports[4] IN ('MLI') OR DivAirports[5] IN ('MLI')) LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, ArrDel15 FROM mytable WHERE DivTotalGTimes BETWEEN 9 AND 121 OR Distance <> 576 ORDER BY DayOfWeek LIMIT 19","hsqls":["SELECT SecurityDelay, ArrDel15 FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 9 AND 121 OR DivTotalGTimes[2] BETWEEN 9 AND 121 OR DivTotalGTimes[3] BETWEEN 9 AND 121 OR DivTotalGTimes[4] BETWEEN 9 AND 121 OR DivTotalGTimes[5] BETWEEN 9 AND 121) OR Distance <> 576 ORDER BY DayOfWeek LIMIT 10000"]}
{"sql":"SELECT DestState, \"Month\" FROM mytable LIMIT 17","hsqls":["SELECT DestState, `Month` FROM mytable LIMIT 17"]}
{"sql":"SELECT OriginWac, MIN(Diverted), AVG(ActualElapsedTime), MAX(\"Month\") FROM mytable WHERE Origin BETWEEN 'ROA' AND 'BIL' AND DestAirportSeqID NOT IN (1315802, 1329604) OR Dest >= 'ISN' GROUP BY OriginWac LIMIT 4","hsqls":["SELECT OriginWac, MIN(Diverted), AVG(ActualElapsedTime), MAX(`Month`) FROM mytable WHERE Origin BETWEEN 'ROA' AND 'BIL' AND DestAirportSeqID NOT IN (1315802, 1329604) OR Dest >= 'ISN' GROUP BY OriginWac LIMIT 4"]}
{"sql":"SELECT TotalAddGTime, UniqueCarrier FROM mytable WHERE Flights NOT IN (1) OR DepTimeBlk BETWEEN '1900-1959' AND '1700-1759' OR SecurityDelay > 18 ORDER BY CarrierDelay LIMIT 6"}
{"sql":"SELECT ArrTime, CRSDepTime, CRSElapsedTime FROM mytable LIMIT 26"}
{"sql":"SELECT DepartureDelayGroups, OriginCityName, DivAirportLandings, COUNT(*) FROM mytable GROUP BY DepartureDelayGroups, OriginCityName, DivAirportLandings  ORDER BY DepartureDelayGroups, OriginCityName, DivAirportLandings LIMIT 27","hsqls":["SELECT DepartureDelayGroups, OriginCityName, DivAirportLandings, COUNT(*) FROM mytable GROUP BY DepartureDelayGroups, OriginCityName, DivAirportLandings  ORDER BY DepartureDelayGroups, OriginCityName, DivAirportLandings LIMIT 27"]}
{"sql":"SELECT OriginAirportSeqID, OriginCityName FROM mytable WHERE Distance IN (2007, 1670) OR DivLongestGTimes IN (10.0, 2.0, 7.0, 75.0) AND OriginStateFips BETWEEN 8 AND 20 ORDER BY AirlineID, DayofMonth, CRSDepTime LIMIT 3","hsqls":["SELECT OriginAirportSeqID, OriginCityName FROM mytable WHERE Distance IN (2007, 1670) OR (DivLongestGTimes[1] IN (10.0, 2.0, 7.0, 75.0) OR DivLongestGTimes[2] IN (10.0, 2.0, 7.0, 75.0) OR DivLongestGTimes[3] IN (10.0, 2.0, 7.0, 75.0) OR DivLongestGTimes[4] IN (10.0, 2.0, 7.0, 75.0) OR DivLongestGTimes[5] IN (10.0, 2.0, 7.0, 75.0)) AND OriginStateFips BETWEEN 8 AND 20 ORDER BY AirlineID, DayofMonth, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes, AVG(CRSDepTime), MAX(SecurityDelay) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 15","hsqls":["SELECT ArrDelayMinutes, AVG(CRSDepTime), MAX(SecurityDelay) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 15"]}
{"sql":"SELECT DepTime FROM mytable WHERE DepDelayMinutes IN (3.0, 102.0, 113.0, 60.0, 47.0) AND OriginAirportSeqID BETWEEN 1056103 AND 1336003 OR WeatherDelay > 205 LIMIT 11"}
{"sql":"SELECT TaxiOut, DaysSinceEpoch FROM mytable WHERE LateAircraftDelay <= 1 ORDER BY NASDelay, \"Month\", CRSDepTime LIMIT 24","hsqls":["SELECT TaxiOut, DaysSinceEpoch FROM mytable WHERE LateAircraftDelay <= 1 ORDER BY NASDelay, Month, CRSDepTime LIMIT 24"]}
{"sql":"SELECT SecurityDelay FROM mytable WHERE DayOfWeek NOT IN (2, 1, 7, 6) OR TailNum NOT IN ('N830UA', 'N3DYAA') ORDER BY WheelsOff, SecurityDelay, WheelsOn LIMIT 5"}
{"sql":"SELECT DepDelayMinutes, SecurityDelay, DestCityName FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'A' OR DivAirportLandings BETWEEN 2 AND 2 ORDER BY TaxiOut, OriginAirportSeqID, OriginStateFips LIMIT 14"}
{"sql":"SELECT DestState FROM mytable WHERE DestAirportSeqID <> 1015502 OR TaxiOut BETWEEN 11 AND 141 ORDER BY TaxiOut, Quarter, UniqueCarrier LIMIT 26"}
{"sql":"SELECT DivReachedDest, DivAirports, AirTime FROM mytable WHERE DayofMonth > 20 ORDER BY DestWac, LongestAddGTime","hsqls":["SELECT DivReachedDest, DivAirports, AirTime FROM mytable WHERE DayofMonth > 20 ORDER BY DestWac, LongestAddGTime LIMIT 10000"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE OriginCityMarketID = 32575 ORDER BY Flights, AirTime, CRSDepTime LIMIT 16"}
{"sql":"SELECT ActualElapsedTime FROM mytable WHERE ActualElapsedTime IN (251, 389, 314, 243) AND DayOfWeek BETWEEN 7 AND 1 OR DestState > 'TN' ORDER BY SecurityDelay LIMIT 1"}
{"sql":"SELECT MIN(DivActualElapsedTime), MAX(DistanceGroup), MAX(WeatherDelay) FROM mytable LIMIT 24"}
{"sql":"SELECT UniqueCarrier, AVG(DayOfWeek), SUM(Diverted), COUNT(Distance) FROM mytable WHERE DivAirportIDs BETWEEN 12523 AND 10257 AND CarrierDelay NOT IN (78) OR AirlineID NOT IN (20436, 19393, 19930, 20355) GROUP BY UniqueCarrier LIMIT 1","hsqls":["SELECT UniqueCarrier, AVG(DayOfWeek), SUM(Diverted), COUNT(Distance) FROM mytable WHERE (DivAirportIDs[1] BETWEEN 12523 AND 10257 OR DivAirportIDs[2] BETWEEN 12523 AND 10257 OR DivAirportIDs[3] BETWEEN 12523 AND 10257 OR DivAirportIDs[4] BETWEEN 12523 AND 10257 OR DivAirportIDs[5] BETWEEN 12523 AND 10257) AND CarrierDelay NOT IN (78) OR AirlineID NOT IN (20436, 19393, 19930, 20355) GROUP BY UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT TailNum, AirTime, COUNT(*) FROM mytable WHERE Dest <> 'CRW' OR DepDel15 = -9999 AND DestCityName IN ('Butte, MT') GROUP BY TailNum, AirTime  ORDER BY TailNum, AirTime LIMIT 26","hsqls":["SELECT TailNum, AirTime, COUNT(*) FROM mytable WHERE Dest <> 'CRW' OR DepDel15 = -9999 AND DestCityName IN ('Butte, MT') GROUP BY TailNum, AirTime  ORDER BY TailNum, AirTime LIMIT 26"]}
{"sql":"SELECT WheelsOff, COUNT(*) FROM mytable WHERE Flights IN (1) GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 18","hsqls":["SELECT WheelsOff, COUNT(*) FROM mytable WHERE Flights IN (1) GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 18"]}
{"sql":"SELECT TaxiOut, DepDelayMinutes, ArrDel15 FROM mytable ORDER BY DayofMonth LIMIT 28"}
{"sql":"SELECT DepDelay, DivAirportLandings, COUNT(*) FROM mytable GROUP BY DepDelay, DivAirportLandings  ORDER BY DepDelay, DivAirportLandings LIMIT 23","hsqls":["SELECT DepDelay, DivAirportLandings, COUNT(*) FROM mytable GROUP BY DepDelay, DivAirportLandings  ORDER BY DepDelay, DivAirportLandings LIMIT 23"]}
{"sql":"SELECT TaxiOut, CRSArrTime FROM mytable WHERE DestStateName BETWEEN 'New Hampshire' AND 'Ohio' ORDER BY ArrTimeBlk, DayofMonth, DaysSinceEpoch LIMIT 19"}
{"sql":"SELECT Cancelled, OriginWac FROM mytable ORDER BY OriginState, TailNum, ArrivalDelayGroups LIMIT 18"}
{"sql":"SELECT LongestAddGTime, DivTailNums FROM mytable WHERE TaxiIn BETWEEN 1 AND 36 AND ArrDelay NOT IN (32.0, 151.0, 149.0, -22.0) LIMIT 15","hsqls":["SELECT LongestAddGTime, DivTailNums FROM mytable WHERE TaxiIn BETWEEN 1 AND 36 AND ArrDelay NOT IN (32.0, 151.0, 149.0, -22.0) LIMIT 10000"]}
{"sql":"SELECT AirTime, DivActualElapsedTime, AVG(DepTime) FROM mytable WHERE DepartureDelayGroups = -2 OR DivActualElapsedTime < 514 GROUP BY AirTime, DivActualElapsedTime  ORDER BY AirTime, DivActualElapsedTime LIMIT 22","hsqls":["SELECT AirTime, DivActualElapsedTime, AVG(DepTime) FROM mytable WHERE DepartureDelayGroups = -2 OR DivActualElapsedTime < 514 GROUP BY AirTime, DivActualElapsedTime  ORDER BY AirTime, DivActualElapsedTime LIMIT 22"]}
{"sql":"SELECT DepDelay, FirstDepTime, DayOfWeek, MAX(LongestAddGTime) FROM mytable WHERE FirstDepTime BETWEEN 2254 AND 1534 GROUP BY DepDelay, FirstDepTime, DayOfWeek  ORDER BY DepDelay, FirstDepTime, DayOfWeek LIMIT 2","hsqls":["SELECT DepDelay, FirstDepTime, DayOfWeek, MAX(LongestAddGTime) FROM mytable WHERE FirstDepTime BETWEEN 2254 AND 1534 GROUP BY DepDelay, FirstDepTime, DayOfWeek  ORDER BY DepDelay, FirstDepTime, DayOfWeek LIMIT 2"]}
{"sql":"SELECT DivArrDelay, COUNT(*) FROM mytable GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 22","hsqls":["SELECT DivArrDelay, COUNT(*) FROM mytable GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 22"]}
{"sql":"SELECT DivReachedDest FROM mytable WHERE LongestAddGTime >= 40 AND WheelsOn < 133 AND NASDelay <= 24"}
{"sql":"SELECT DestState, TotalAddGTime, \"Month\" FROM mytable WHERE DivDistance BETWEEN 290 AND 104 OR DepTime BETWEEN 1632 AND 539 OR DivAirports BETWEEN 'ALB' AND 'LIT' ORDER BY FlightDate, TailNum LIMIT 10","hsqls":["SELECT DestState, TotalAddGTime, `Month` FROM mytable WHERE DivDistance BETWEEN 290 AND 104 OR DepTime BETWEEN 1632 AND 539 OR (DivAirports[1] BETWEEN 'ALB' AND 'LIT' OR DivAirports[2] BETWEEN 'ALB' AND 'LIT' OR DivAirports[3] BETWEEN 'ALB' AND 'LIT' OR DivAirports[4] BETWEEN 'ALB' AND 'LIT' OR DivAirports[5] BETWEEN 'ALB' AND 'LIT') ORDER BY FlightDate, TailNum LIMIT 10000"]}
{"sql":"SELECT Carrier, Flights, CRSElapsedTime FROM mytable WHERE Flights NOT IN (1) AND LateAircraftDelay BETWEEN 32 AND 187 LIMIT 17"}
{"sql":"SELECT DestAirportSeqID, AirTime FROM mytable WHERE UniqueCarrier BETWEEN 'B6' AND 'VX' OR WheelsOn < 1700 LIMIT 19"}
{"sql":"SELECT NASDelay, SUM(TaxiOut), MAX(Distance) FROM mytable WHERE CancellationCode > 'C' GROUP BY NASDelay  ORDER BY NASDelay LIMIT 6","hsqls":["SELECT NASDelay, SUM(TaxiOut), MAX(Distance) FROM mytable WHERE CancellationCode > 'C' GROUP BY NASDelay  ORDER BY NASDelay LIMIT 6"]}
{"sql":"SELECT DepTime FROM mytable LIMIT 14"}
{"sql":"SELECT FlightNum, DivAirportLandings, CRSElapsedTime, COUNT(*) FROM mytable GROUP BY FlightNum, DivAirportLandings, CRSElapsedTime  ORDER BY FlightNum, DivAirportLandings, CRSElapsedTime LIMIT 20","hsqls":["SELECT FlightNum, DivAirportLandings, CRSElapsedTime, COUNT(*) FROM mytable GROUP BY FlightNum, DivAirportLandings, CRSElapsedTime  ORDER BY FlightNum, DivAirportLandings, CRSElapsedTime LIMIT 20"]}
{"sql":"SELECT UniqueCarrier, DivActualElapsedTime, COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'US' AND 'US' OR DestAirportSeqID NOT IN (1457002, 1200302, 1182304, 1295103) GROUP BY UniqueCarrier, DivActualElapsedTime  ORDER BY UniqueCarrier, DivActualElapsedTime LIMIT 26","hsqls":["SELECT UniqueCarrier, DivActualElapsedTime, COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'US' AND 'US' OR DestAirportSeqID NOT IN (1457002, 1200302, 1182304, 1295103) GROUP BY UniqueCarrier, DivActualElapsedTime  ORDER BY UniqueCarrier, DivActualElapsedTime LIMIT 26"]}
{"sql":"SELECT MIN(CRSElapsedTime), MAX(Distance), AVG(DepDelayMinutes) FROM mytable WHERE CRSElapsedTime IN (57, 316, 254) AND ArrivalDelayGroups BETWEEN 1 AND -1 LIMIT 11"}
{"sql":"SELECT DestState, Carrier, AirlineID, SUM(CarrierDelay), MIN(Flights) FROM mytable WHERE OriginState IN ('OK') GROUP BY DestState, Carrier, AirlineID  ORDER BY DestState, Carrier, AirlineID LIMIT 18","hsqls":["SELECT DestState, Carrier, AirlineID, SUM(CarrierDelay), MIN(Flights) FROM mytable WHERE OriginState IN ('OK') GROUP BY DestState, Carrier, AirlineID  ORDER BY DestState, Carrier, AirlineID LIMIT 18"]}
{"sql":"SELECT DepTime, AirlineID FROM mytable WHERE CRSElapsedTime BETWEEN 390 AND 314 AND UniqueCarrier > 'HA' AND DivTailNums IN ('N378SW', 'N957DN', 'N274WN', 'N728SW', 'N16999') ORDER BY DepDel15, AirlineID, DayOfWeek LIMIT 8","hsqls":["SELECT DepTime, AirlineID FROM mytable WHERE CRSElapsedTime BETWEEN 390 AND 314 AND UniqueCarrier > 'HA' AND (DivTailNums[1] IN ('N378SW', 'N957DN', 'N274WN', 'N728SW', 'N16999') OR DivTailNums[2] IN ('N378SW', 'N957DN', 'N274WN', 'N728SW', 'N16999') OR DivTailNums[3] IN ('N378SW', 'N957DN', 'N274WN', 'N728SW', 'N16999') OR DivTailNums[4] IN ('N378SW', 'N957DN', 'N274WN', 'N728SW', 'N16999') OR DivTailNums[5] IN ('N378SW', 'N957DN', 'N274WN', 'N728SW', 'N16999')) ORDER BY DepDel15, AirlineID, DayOfWeek LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, NASDelay FROM mytable ORDER BY DepartureDelayGroups LIMIT 10"}
{"sql":"SELECT OriginCityMarketID, DepTimeBlk, OriginStateName, COUNT(*) FROM mytable WHERE DivAirports IN ('BIS') AND DestWac BETWEEN 31 AND 12 GROUP BY OriginCityMarketID, DepTimeBlk, OriginStateName LIMIT 3","hsqls":["SELECT OriginCityMarketID, DepTimeBlk, OriginStateName, COUNT(*) FROM mytable WHERE (DivAirports[1] IN ('BIS') OR DivAirports[2] IN ('BIS') OR DivAirports[3] IN ('BIS') OR DivAirports[4] IN ('BIS') OR DivAirports[5] IN ('BIS')) AND DestWac BETWEEN 31 AND 12 GROUP BY OriginCityMarketID, DepTimeBlk, OriginStateName LIMIT 10000"]}
{"sql":"SELECT Quarter FROM mytable ORDER BY FirstDepTime, DestCityMarketID, CRSElapsedTime LIMIT 29"}
{"sql":"SELECT TaxiOut, DestWac FROM mytable WHERE WheelsOn BETWEEN 1149 AND 848 OR TailNum BETWEEN 'N727TW' AND 'N13988' OR Diverted <> 0 ORDER BY CarrierDelay LIMIT 1"}
{"sql":"SELECT \"Year\" FROM mytable ORDER BY DepartureDelayGroups, Flights LIMIT 27","hsqls":["SELECT `Year` FROM mytable ORDER BY DepartureDelayGroups, Flights LIMIT 27"]}
{"sql":"SELECT \"Year\", DivAirports, ArrDel15 FROM mytable ORDER BY DistanceGroup, Distance, ArrDelayMinutes LIMIT 5","hsqls":["SELECT Year, DivAirports, ArrDel15 FROM mytable ORDER BY DistanceGroup, Distance, ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DepDelayMinutes FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) OR DestCityName = 'Moline, IL' ORDER BY DistanceGroup, DestWac, TotalAddGTime LIMIT 15"}
{"sql":"SELECT DistanceGroup, AirlineID, DayOfWeek, MAX(Flights) FROM mytable WHERE FlightDate = '2014-01-05' OR AirlineID IN (19690, 19977) GROUP BY DistanceGroup, AirlineID, DayOfWeek  ORDER BY DistanceGroup, AirlineID, DayOfWeek LIMIT 24","hsqls":["SELECT DistanceGroup, AirlineID, DayOfWeek, MAX(Flights) FROM mytable WHERE FlightDate = '2014-01-05' OR AirlineID IN (19690, 19977) GROUP BY DistanceGroup, AirlineID, DayOfWeek  ORDER BY DistanceGroup, AirlineID, DayOfWeek LIMIT 24"]}
{"sql":"SELECT LongestAddGTime, CRSArrTime, Dest, MAX(ArrDelayMinutes) FROM mytable WHERE NASDelay NOT IN (78, 5, 35) AND DivReachedDest IN (1, 0, -9999) OR CarrierDelay BETWEEN 47 AND 17 GROUP BY LongestAddGTime, CRSArrTime, Dest  ORDER BY LongestAddGTime, CRSArrTime, Dest LIMIT 10","hsqls":["SELECT LongestAddGTime, CRSArrTime, Dest, MAX(ArrDelayMinutes) FROM mytable WHERE NASDelay NOT IN (78, 5, 35) AND DivReachedDest IN (1, 0, -9999) OR CarrierDelay BETWEEN 47 AND 17 GROUP BY LongestAddGTime, CRSArrTime, Dest  ORDER BY LongestAddGTime, CRSArrTime, Dest LIMIT 10"]}
{"sql":"SELECT ActualElapsedTime, UniqueCarrier, OriginAirportID FROM mytable WHERE \"Year\" IN (2014) LIMIT 14","hsqls":["SELECT ActualElapsedTime, UniqueCarrier, OriginAirportID FROM mytable WHERE `Year` IN (2014) LIMIT 14"]}
{"sql":"SELECT OriginAirportSeqID, LateAircraftDelay, DaysSinceEpoch, AVG(DistanceGroup) FROM mytable WHERE \"Month\" > 1 OR DivAirportIDs BETWEEN 12280 AND 14256 OR DivDistance BETWEEN 581 AND 49 GROUP BY OriginAirportSeqID, LateAircraftDelay, DaysSinceEpoch LIMIT 9","hsqls":["SELECT OriginAirportSeqID, LateAircraftDelay, DaysSinceEpoch, AVG(CAST(DistanceGroup AS DOUBLE)) FROM mytable WHERE `Month` > 1 OR (DivAirportIDs[1] BETWEEN 12280 AND 14256 OR DivAirportIDs[2] BETWEEN 12280 AND 14256 OR DivAirportIDs[3] BETWEEN 12280 AND 14256 OR DivAirportIDs[4] BETWEEN 12280 AND 14256 OR DivAirportIDs[5] BETWEEN 12280 AND 14256) OR DivDistance BETWEEN 581 AND 49 GROUP BY OriginAirportSeqID, LateAircraftDelay, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT WheelsOff, SUM(ActualElapsedTime), AVG(DepDelayMinutes) FROM mytable GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 29","hsqls":["SELECT WheelsOff, SUM(ActualElapsedTime), AVG(DepDelayMinutes) FROM mytable GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 29"]}
{"sql":"SELECT DivLongestGTimes, DestAirportSeqID FROM mytable WHERE CancellationCode = 'noodles' ORDER BY CarrierDelay LIMIT 27","hsqls":["SELECT DivLongestGTimes, DestAirportSeqID FROM mytable WHERE CancellationCode = 'noodles' ORDER BY CarrierDelay LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay FROM mytable WHERE OriginState = 'OR' ORDER BY Quarter, NASDelay, DayofMonth LIMIT 8"}
{"sql":"SELECT \"Year\", DayOfWeek FROM mytable WHERE WheelsOff NOT IN (811, 2005, 1222) AND NASDelay BETWEEN 7 AND 202 AND DestStateFips < 35 ORDER BY Carrier LIMIT 19","hsqls":["SELECT Year, DayOfWeek FROM mytable WHERE WheelsOff NOT IN (811, 2005, 1222) AND NASDelay BETWEEN 7 AND 202 AND DestStateFips < 35 ORDER BY Carrier LIMIT 19"]}
{"sql":"SELECT TaxiOut, DayOfWeek FROM mytable WHERE WheelsOn BETWEEN 753 AND 1659 ORDER BY DepDel15 LIMIT 29"}
{"sql":"SELECT Diverted, WeatherDelay, DivAirportIDs FROM mytable WHERE LongestAddGTime BETWEEN 45 AND 29 OR DepTime IN (2008, 705) LIMIT 29","hsqls":["SELECT Diverted, WeatherDelay, DivAirportIDs FROM mytable WHERE LongestAddGTime BETWEEN 45 AND 29 OR DepTime IN (2008, 705) LIMIT 10000"]}
{"sql":"SELECT DestCityName FROM mytable ORDER BY FlightNum, DepTime LIMIT 7"}
{"sql":"SELECT DaysSinceEpoch, COUNT(*) FROM mytable WHERE LongestAddGTime IN (41) GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 18","hsqls":["SELECT DaysSinceEpoch, COUNT(*) FROM mytable WHERE LongestAddGTime IN (41) GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 18"]}
{"sql":"SELECT DivDistance, DivAirportSeqIDs, DivAirportIDs FROM mytable WHERE WheelsOn NOT IN (2216, 2317, 2010) ORDER BY DestStateName, OriginWac, DestAirportID LIMIT 12","hsqls":["SELECT DivDistance, DivAirportSeqIDs, DivAirportIDs FROM mytable WHERE WheelsOn NOT IN (2216, 2317, 2010) ORDER BY DestStateName, OriginWac, DestAirportID LIMIT 10000"]}
{"sql":"SELECT DivAirports, OriginStateName FROM mytable ORDER BY TaxiOut, ArrTimeBlk LIMIT 10","hsqls":["SELECT DivAirports, OriginStateName FROM mytable ORDER BY TaxiOut, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE DestStateFips BETWEEN 22 AND 31 ORDER BY TailNum, DepTimeBlk, \"Month\" LIMIT 16","hsqls":["SELECT DepartureDelayGroups FROM mytable WHERE DestStateFips BETWEEN 22 AND 31 ORDER BY TailNum, DepTimeBlk, `Month` LIMIT 16"]}
{"sql":"SELECT WheelsOn, OriginStateName, AVG(DepDel15) FROM mytable GROUP BY WheelsOn, OriginStateName  ORDER BY WheelsOn, OriginStateName LIMIT 18","hsqls":["SELECT WheelsOn, OriginStateName, AVG(DepDel15) FROM mytable GROUP BY WheelsOn, OriginStateName  ORDER BY WheelsOn, OriginStateName LIMIT 18"]}
{"sql":"SELECT Cancelled, UniqueCarrier, COUNT(DepTimeBlk), AVG(DivAirportLandings) FROM mytable WHERE DivDistance BETWEEN 589 AND 745 AND OriginState <> 'WY' GROUP BY Cancelled, UniqueCarrier  ORDER BY Cancelled, UniqueCarrier LIMIT 5","hsqls":["SELECT Cancelled, UniqueCarrier, COUNT(DepTimeBlk), AVG(DivAirportLandings) FROM mytable WHERE DivDistance BETWEEN 589 AND 745 AND OriginState <> 'WY' GROUP BY Cancelled, UniqueCarrier  ORDER BY Cancelled, UniqueCarrier LIMIT 5"]}
{"sql":"SELECT TaxiIn, ArrDel15, AirTime FROM mytable WHERE DivAirportIDs BETWEEN 12992 AND 14107 AND CRSElapsedTime IN (224, 179, 208, 29) LIMIT 16","hsqls":["SELECT TaxiIn, ArrDel15, AirTime FROM mytable WHERE (DivAirportIDs[1] BETWEEN 12992 AND 14107 OR DivAirportIDs[2] BETWEEN 12992 AND 14107 OR DivAirportIDs[3] BETWEEN 12992 AND 14107 OR DivAirportIDs[4] BETWEEN 12992 AND 14107 OR DivAirportIDs[5] BETWEEN 12992 AND 14107) AND CRSElapsedTime IN (224, 179, 208, 29) LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, SecurityDelay, OriginAirportID, MAX(AirlineID), MAX(Quarter) FROM mytable WHERE WheelsOff <= 958 OR DaysSinceEpoch > 16092 OR DivAirportIDs IN (16101, 11540, 11996, 13830, 10521) GROUP BY DepartureDelayGroups, SecurityDelay, OriginAirportID LIMIT 13","hsqls":["SELECT DepartureDelayGroups, SecurityDelay, OriginAirportID, MAX(AirlineID), MAX(Quarter) FROM mytable WHERE WheelsOff <= 958 OR DaysSinceEpoch > 16092 OR (DivAirportIDs[1] IN (16101, 11540, 11996, 13830, 10521) OR DivAirportIDs[2] IN (16101, 11540, 11996, 13830, 10521) OR DivAirportIDs[3] IN (16101, 11540, 11996, 13830, 10521) OR DivAirportIDs[4] IN (16101, 11540, 11996, 13830, 10521) OR DivAirportIDs[5] IN (16101, 11540, 11996, 13830, 10521)) GROUP BY DepartureDelayGroups, SecurityDelay, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT MIN(DepDelayMinutes), COUNT(\"Year\") FROM mytable WHERE AirlineID BETWEEN 19930 AND 20355 LIMIT 1","hsqls":["SELECT MIN(DepDelayMinutes), COUNT(`Year`) FROM mytable WHERE AirlineID BETWEEN 19930 AND 20355 LIMIT 1"]}
{"sql":"SELECT TotalAddGTime, DayofMonth, DestAirportID, COUNT(OriginAirportSeqID), MIN(DestStateFips) FROM mytable WHERE TailNum BETWEEN 'N3KRAA' AND 'N764NC' AND DivArrDelay BETWEEN 126 AND 250 GROUP BY TotalAddGTime, DayofMonth, DestAirportID  ORDER BY TotalAddGTime, DayofMonth, DestAirportID LIMIT 9","hsqls":["SELECT TotalAddGTime, DayofMonth, DestAirportID, COUNT(OriginAirportSeqID), MIN(DestStateFips) FROM mytable WHERE TailNum BETWEEN 'N3KRAA' AND 'N764NC' AND DivArrDelay BETWEEN 126 AND 250 GROUP BY TotalAddGTime, DayofMonth, DestAirportID  ORDER BY TotalAddGTime, DayofMonth, DestAirportID LIMIT 9"]}
{"sql":"SELECT DivReachedDest, AVG(CRSElapsedTime), SUM(ActualElapsedTime), COUNT(ArrDel15) FROM mytable WHERE CRSArrTime NOT IN (1700, 2242) GROUP BY DivReachedDest","hsqls":["SELECT DivReachedDest, AVG(CRSElapsedTime), SUM(ActualElapsedTime), COUNT(ArrDel15) FROM mytable WHERE CRSArrTime NOT IN (1700, 2242) GROUP BY DivReachedDest"]}
{"sql":"SELECT DepTime FROM mytable WHERE \"Year\" NOT IN (2014) OR DivAirportSeqIDs <= 1129202 OR TaxiIn BETWEEN 3 AND 24 ORDER BY Carrier, FlightNum LIMIT 10","hsqls":["SELECT DepTime FROM mytable WHERE `Year` NOT IN (2014) OR (DivAirportSeqIDs[1] <= 1129202 OR DivAirportSeqIDs[2] <= 1129202 OR DivAirportSeqIDs[3] <= 1129202 OR DivAirportSeqIDs[4] <= 1129202 OR DivAirportSeqIDs[5] <= 1129202) OR TaxiIn BETWEEN 3 AND 24 ORDER BY Carrier, FlightNum LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, DivActualElapsedTime FROM mytable WHERE CRSElapsedTime IN (376, 130) AND LateAircraftDelay IN (55, 100, 88) AND DivAirportLandings BETWEEN 0 AND 0 LIMIT 25"}
{"sql":"SELECT \"Year\" FROM mytable WHERE DestWac BETWEEN 54 AND 67 ORDER BY OriginAirportSeqID, OriginState LIMIT 15","hsqls":["SELECT `Year` FROM mytable WHERE DestWac BETWEEN 54 AND 67 ORDER BY OriginAirportSeqID, OriginState LIMIT 15"]}
{"sql":"SELECT DivActualElapsedTime FROM mytable WHERE DestAirportID BETWEEN 13485 AND 14747 AND OriginState IN ('IL', 'AK', 'VA', 'RI') LIMIT 19"}
{"sql":"SELECT Diverted FROM mytable WHERE ArrDelay BETWEEN 85.0 AND -31.0 AND DestStateName BETWEEN 'Arkansas' AND 'Arizona' ORDER BY DivArrDelay LIMIT 1"}
{"sql":"SELECT OriginState FROM mytable WHERE OriginStateName > 'Arizona' LIMIT 24"}
{"sql":"SELECT \"Month\" FROM mytable ORDER BY SecurityDelay, Origin LIMIT 28","hsqls":["SELECT `Month` FROM mytable ORDER BY SecurityDelay, Origin LIMIT 28"]}
{"sql":"SELECT CancellationCode, SUM(NASDelay), SUM(OriginWac), MIN(FirstDepTime) FROM mytable WHERE FlightDate BETWEEN '2014-01-01' AND '2014-01-21' OR OriginCityName < 'Tampa, FL' GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 7","hsqls":["SELECT CancellationCode, SUM(NASDelay), SUM(OriginWac), MIN(FirstDepTime) FROM mytable WHERE FlightDate BETWEEN '2014-01-01' AND '2014-01-21' OR OriginCityName < 'Tampa, FL' GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 7"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE CRSArrTime IN (2225, 2219, 1620, 1417, 1534) LIMIT 18"}
{"sql":"SELECT DivWheelsOns, CancellationCode FROM mytable WHERE NASDelay BETWEEN 211 AND 110 ORDER BY LateAircraftDelay LIMIT 19","hsqls":["SELECT DivWheelsOns, CancellationCode FROM mytable WHERE NASDelay BETWEEN 211 AND 110 ORDER BY LateAircraftDelay LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, WheelsOff, CRSArrTime, MIN(OriginAirportSeqID), MAX(\"Year\"), AVG(DistanceGroup) FROM mytable WHERE OriginState <= 'FL' OR DivWheelsOffs >= 1200 AND DepartureDelayGroups <> 8 GROUP BY OriginAirportSeqID, WheelsOff, CRSArrTime LIMIT 14","hsqls":["SELECT OriginAirportSeqID, WheelsOff, CRSArrTime, MIN(OriginAirportSeqID), MAX(`Year`), AVG(DistanceGroup) FROM mytable WHERE OriginState <= 'FL' OR (DivWheelsOffs[1] >= 1200 OR DivWheelsOffs[2] >= 1200 OR DivWheelsOffs[3] >= 1200 OR DivWheelsOffs[4] >= 1200 OR DivWheelsOffs[5] >= 1200) AND DepartureDelayGroups <> 8 GROUP BY OriginAirportSeqID, WheelsOff, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 4"}
{"sql":"SELECT Distance, DepTime FROM mytable WHERE DivWheelsOns BETWEEN 1755 AND 1017 OR DivAirportLandings >= 9 ORDER BY ActualElapsedTime, CancellationCode, DivArrDelay LIMIT 14","hsqls":["SELECT Distance, DepTime FROM mytable WHERE (DivWheelsOns[1] BETWEEN 1755 AND 1017 OR DivWheelsOns[2] BETWEEN 1755 AND 1017 OR DivWheelsOns[3] BETWEEN 1755 AND 1017 OR DivWheelsOns[4] BETWEEN 1755 AND 1017 OR DivWheelsOns[5] BETWEEN 1755 AND 1017) OR DivAirportLandings >= 9 ORDER BY ActualElapsedTime, CancellationCode, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT UniqueCarrier FROM mytable WHERE OriginAirportID BETWEEN 10990 AND 15919 AND TailNum IN ('N658SW', 'N519UW', 'N489HA') OR Flights > 1 ORDER BY Origin LIMIT 2"}
{"sql":"SELECT CRSArrTime FROM mytable ORDER BY DivActualElapsedTime LIMIT 4"}
{"sql":"SELECT SUM(ActualElapsedTime) FROM mytable WHERE DepDelay < 177.0 AND TailNum BETWEEN 'N176PQ' AND 'N181PQ' AND LateAircraftDelay BETWEEN 96 AND 123 LIMIT 24"}
{"sql":"SELECT DepTime FROM mytable ORDER BY DestAirportSeqID LIMIT 2"}
{"sql":"SELECT OriginCityMarketID, DestAirportSeqID FROM mytable WHERE DestCityMarketID IN (31504, 30739) AND DivWheelsOns = 1407 OR OriginAirportID BETWEEN 11315 AND 10918 LIMIT 13","hsqls":["SELECT OriginCityMarketID, DestAirportSeqID FROM mytable WHERE DestCityMarketID IN (31504, 30739) AND (DivWheelsOns[1] = 1407 OR DivWheelsOns[2] = 1407 OR DivWheelsOns[3] = 1407 OR DivWheelsOns[4] = 1407 OR DivWheelsOns[5] = 1407) OR OriginAirportID BETWEEN 11315 AND 10918 LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DivDistance FROM mytable WHERE DistanceGroup <> 5 OR DepDelay NOT IN (166.0) OR ArrTimeBlk <= '1200-1259' LIMIT 11"}
{"sql":"SELECT DayofMonth, AirTime FROM mytable WHERE AirTime BETWEEN 189 AND 355 AND ArrDel15 = -9999 AND DaysSinceEpoch IN (16096, 16097, 16076, 16085) ORDER BY LateAircraftDelay, DepTimeBlk LIMIT 27"}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE NASDelay <> 45 OR AirlineID BETWEEN 20398 AND 20304 ORDER BY DepDel15 LIMIT 13"}
{"sql":"SELECT WeatherDelay, Distance FROM mytable ORDER BY LateAircraftDelay, CancellationCode, DivAirportLandings LIMIT 11"}
{"sql":"SELECT Flights FROM mytable WHERE DivAirports > 'BUR' AND DayofMonth NOT IN (1, 25) LIMIT 21","hsqls":["SELECT Flights FROM mytable WHERE (DivAirports[1] > 'BUR' OR DivAirports[2] > 'BUR' OR DivAirports[3] > 'BUR' OR DivAirports[4] > 'BUR' OR DivAirports[5] > 'BUR') AND DayofMonth NOT IN (1, 25) LIMIT 10000"]}
{"sql":"SELECT DestCityName FROM mytable WHERE DepDelay BETWEEN 140.0 AND 137.0 ORDER BY ArrDelayMinutes LIMIT 17"}
{"sql":"SELECT ActualElapsedTime, AVG(DayOfWeek), MAX(DistanceGroup), AVG(CRSElapsedTime) FROM mytable WHERE AirlineID NOT IN (20355) AND \"Month\" BETWEEN 1 AND 1 GROUP BY ActualElapsedTime LIMIT 11","hsqls":["SELECT ActualElapsedTime, AVG(DayOfWeek), MAX(DistanceGroup), AVG(CRSElapsedTime) FROM mytable WHERE AirlineID NOT IN (20355) AND `Month` BETWEEN 1 AND 1 GROUP BY ActualElapsedTime LIMIT 11"]}
{"sql":"SELECT CRSElapsedTime, MAX(DepDelayMinutes), COUNT(DepTimeBlk), SUM(DayOfWeek) FROM mytable WHERE CRSElapsedTime NOT IN (305, 234) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 19","hsqls":["SELECT CRSElapsedTime, MAX(DepDelayMinutes), COUNT(DepTimeBlk), SUM(DayOfWeek) FROM mytable WHERE CRSElapsedTime NOT IN (305, 234) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 19"]}
{"sql":"SELECT DestWac, CRSDepTime, COUNT(*) FROM mytable WHERE WheelsOff <= 2130 OR AirTime > 361 AND DayOfWeek < 5 GROUP BY DestWac, CRSDepTime  ORDER BY DestWac, CRSDepTime LIMIT 9","hsqls":["SELECT DestWac, CRSDepTime, COUNT(*) FROM mytable WHERE WheelsOff <= 2130 OR AirTime > 361 AND DayOfWeek < 5 GROUP BY DestWac, CRSDepTime  ORDER BY DestWac, CRSDepTime LIMIT 9"]}
{"sql":"SELECT OriginState, DestState, WeatherDelay FROM mytable WHERE DivAirportLandings > 9 ORDER BY DepartureDelayGroups, Quarter, OriginStateName LIMIT 8"}
{"sql":"SELECT OriginState, FirstDepTime, DayofMonth FROM mytable WHERE OriginStateFips NOT IN (31, 51, 28) OR ArrDelay > 158.0 ORDER BY ArrDelayMinutes, \"Month\" LIMIT 13","hsqls":["SELECT OriginState, FirstDepTime, DayofMonth FROM mytable WHERE OriginStateFips NOT IN (31, 51, 28) OR ArrDelay > 158.0 ORDER BY ArrDelayMinutes, `Month` LIMIT 13"]}
{"sql":"SELECT OriginStateFips, COUNT(*) FROM mytable WHERE OriginWac <> 86 AND OriginAirportID NOT IN (10140, 14457, 11525) GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 19","hsqls":["SELECT OriginStateFips, COUNT(*) FROM mytable WHERE OriginWac <> 86 AND OriginAirportID NOT IN (10140, 14457, 11525) GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 19"]}
{"sql":"SELECT AVG(FlightNum), COUNT(DivReachedDest), MIN(DestCityMarketID) FROM mytable WHERE DivAirportLandings <> 9 LIMIT 4"}
{"sql":"SELECT FlightNum, CancellationCode, SUM(DayOfWeek) FROM mytable GROUP BY FlightNum, CancellationCode  ORDER BY FlightNum, CancellationCode LIMIT 22","hsqls":["SELECT FlightNum, CancellationCode, SUM(DayOfWeek) FROM mytable GROUP BY FlightNum, CancellationCode  ORDER BY FlightNum, CancellationCode LIMIT 22"]}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE Carrier < 'MQ' LIMIT 4","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE Carrier < 'MQ' LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, COUNT(*) FROM mytable GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 17","hsqls":["SELECT DepartureDelayGroups, COUNT(*) FROM mytable GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 17"]}
{"sql":"SELECT CRSArrTime, Cancelled, CancellationCode FROM mytable WHERE ActualElapsedTime BETWEEN 64 AND 268 ORDER BY ArrTime, UniqueCarrier, OriginAirportID"}
{"sql":"SELECT DistanceGroup FROM mytable WHERE DepDelay BETWEEN 109.0 AND 92.0 OR ActualElapsedTime > 222 ORDER BY OriginState, Distance, ArrTimeBlk LIMIT 12"}
{"sql":"SELECT OriginCityMarketID, COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 42.0 AND 165.0 OR Carrier BETWEEN 'B6' AND 'EV' GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 23","hsqls":["SELECT OriginCityMarketID, COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 42.0 AND 165.0 OR Carrier BETWEEN 'B6' AND 'EV' GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 23"]}
{"sql":"SELECT DestWac, DestState, DepTime FROM mytable WHERE \"Month\" < 1 AND DivActualElapsedTime >= 500 ORDER BY Diverted, DepDelay, OriginCityName LIMIT 21","hsqls":["SELECT DestWac, DestState, DepTime FROM mytable WHERE `Month` < 1 AND DivActualElapsedTime >= 500 ORDER BY Diverted, DepDelay, OriginCityName LIMIT 21"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE OriginCityMarketID IN (32575) AND SecurityDelay BETWEEN 8 AND 18 LIMIT 14"}
{"sql":"SELECT DestStateName FROM mytable WHERE ActualElapsedTime > 163 AND DivAirportLandings <> 2 ORDER BY ArrDelay, DayofMonth, OriginAirportID LIMIT 1"}
{"sql":"SELECT DivLongestGTimes, DestAirportSeqID, UniqueCarrier FROM mytable WHERE OriginCityMarketID BETWEEN 30615 AND 30073 ORDER BY LateAircraftDelay, ArrDelay LIMIT 8","hsqls":["SELECT DivLongestGTimes, DestAirportSeqID, UniqueCarrier FROM mytable WHERE OriginCityMarketID BETWEEN 30615 AND 30073 ORDER BY LateAircraftDelay, ArrDelay LIMIT 10000"]}
{"sql":"SELECT Quarter, \"Month\", ArrivalDelayGroups FROM mytable WHERE SecurityDelay NOT IN (0, 4, 27) OR FirstDepTime IN (2009, 750, 612, 550) OR ActualElapsedTime IN (127, 243) ORDER BY CRSArrTime LIMIT 9","hsqls":["SELECT Quarter, Month, ArrivalDelayGroups FROM mytable WHERE SecurityDelay NOT IN (0, 4, 27) OR FirstDepTime IN (2009, 750, 612, 550) OR ActualElapsedTime IN (127, 243) ORDER BY CRSArrTime LIMIT 9"]}
{"sql":"SELECT ArrTime, MIN(WheelsOff) FROM mytable WHERE \"Year\" NOT IN (2014) OR ArrDel15 BETWEEN -9999 AND 1 GROUP BY ArrTime LIMIT 28","hsqls":["SELECT ArrTime, MIN(WheelsOff) FROM mytable WHERE `Year` NOT IN (2014) OR ArrDel15 BETWEEN -9999 AND 1 GROUP BY ArrTime LIMIT 28"]}
{"sql":"SELECT Quarter FROM mytable WHERE DivArrDelay BETWEEN 868 AND 308 LIMIT 5"}
{"sql":"SELECT OriginState, DestState, DestCityMarketID FROM mytable WHERE UniqueCarrier > 'US' AND DepTimeBlk NOT IN ('1300-1359', '1400-1459') ORDER BY DivArrDelay, WheelsOn LIMIT 7"}
{"sql":"SELECT Diverted, OriginCityMarketID, TaxiIn FROM mytable WHERE ArrDelay <> 228.0 OR LongestAddGTime < 31 ORDER BY CRSArrTime LIMIT 29"}
{"sql":"SELECT Flights, DestAirportSeqID, OriginStateName, MAX(OriginCityMarketID), COUNT(ArrTime) FROM mytable WHERE DistanceGroup NOT IN (9, 11) OR TaxiIn BETWEEN 41 AND 116 GROUP BY Flights, DestAirportSeqID, OriginStateName  ORDER BY Flights, DestAirportSeqID, OriginStateName LIMIT 3","hsqls":["SELECT Flights, DestAirportSeqID, OriginStateName, MAX(OriginCityMarketID), COUNT(ArrTime) FROM mytable WHERE DistanceGroup NOT IN (9, 11) OR TaxiIn BETWEEN 41 AND 116 GROUP BY Flights, DestAirportSeqID, OriginStateName  ORDER BY Flights, DestAirportSeqID, OriginStateName LIMIT 3"]}
{"sql":"SELECT Quarter, COUNT(*) FROM mytable WHERE Distance NOT IN (745, 968, 2586, 1407, 981) GROUP BY Quarter  ORDER BY Quarter LIMIT 11","hsqls":["SELECT Quarter, COUNT(*) FROM mytable WHERE Distance NOT IN (745, 968, 2586, 1407, 981) GROUP BY Quarter  ORDER BY Quarter LIMIT 11"]}
{"sql":"SELECT DepDelay, SUM(DivReachedDest), SUM(ArrDelay) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DestStateName IN ('Pennsylvania', 'North Dakota', 'Puerto Rico', 'New Mexico') OR ArrDel15 IN (1, 0, -9999) GROUP BY DepDelay  ORDER BY DepDelay LIMIT 4","hsqls":["SELECT DepDelay, SUM(DivReachedDest), SUM(ArrDelay) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DestStateName IN ('Pennsylvania', 'North Dakota', 'Puerto Rico', 'New Mexico') OR ArrDel15 IN (1, 0, -9999) GROUP BY DepDelay  ORDER BY DepDelay LIMIT 4"]}
{"sql":"SELECT Quarter FROM mytable WHERE WeatherDelay IN (27) ORDER BY DestState, OriginStateFips, SecurityDelay LIMIT 19"}
{"sql":"SELECT CRSElapsedTime FROM mytable LIMIT 23"}
{"sql":"SELECT WheelsOff FROM mytable LIMIT 24"}
{"sql":"SELECT DepDelay, TaxiIn, ArrTimeBlk, SUM(DestAirportSeqID) FROM mytable WHERE DestCityName NOT IN ('Rhinelander, WI', 'Bethel, AK', 'International Falls, MN') GROUP BY DepDelay, TaxiIn, ArrTimeBlk  ORDER BY DepDelay, TaxiIn, ArrTimeBlk LIMIT 17","hsqls":["SELECT DepDelay, TaxiIn, ArrTimeBlk, SUM(DestAirportSeqID) FROM mytable WHERE DestCityName NOT IN ('Rhinelander, WI', 'Bethel, AK', 'International Falls, MN') GROUP BY DepDelay, TaxiIn, ArrTimeBlk  ORDER BY DepDelay, TaxiIn, ArrTimeBlk LIMIT 17"]}
{"sql":"SELECT UniqueCarrier, COUNT(DestWac), MIN(DestCityMarketID), SUM(DepTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 28","hsqls":["SELECT UniqueCarrier, COUNT(DestWac), MIN(DestCityMarketID), SUM(DepTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 28"]}
{"sql":"SELECT DestStateFips, ArrTimeBlk, UniqueCarrier FROM mytable ORDER BY OriginCityMarketID, ActualElapsedTime, \"Month\" LIMIT 3","hsqls":["SELECT DestStateFips, ArrTimeBlk, UniqueCarrier FROM mytable ORDER BY OriginCityMarketID, ActualElapsedTime, `Month` LIMIT 3"]}
{"sql":"SELECT DestStateName, DivArrDelay FROM mytable ORDER BY WeatherDelay LIMIT 24"}
{"sql":"SELECT DestStateFips, DivActualElapsedTime FROM mytable WHERE DepDel15 IN (1) AND OriginCityMarketID IN (32402, 35841, 33192) ORDER BY CRSDepTime LIMIT 10"}
{"sql":"SELECT DestAirportSeqID, DestStateName, OriginStateName, COUNT(OriginStateFips), MAX(OriginWac) FROM mytable WHERE OriginCityMarketID >= 31401 GROUP BY DestAirportSeqID, DestStateName, OriginStateName  ORDER BY DestAirportSeqID, DestStateName, OriginStateName LIMIT 7","hsqls":["SELECT DestAirportSeqID, DestStateName, OriginStateName, COUNT(OriginStateFips), MAX(OriginWac) FROM mytable WHERE OriginCityMarketID >= 31401 GROUP BY DestAirportSeqID, DestStateName, OriginStateName  ORDER BY DestAirportSeqID, DestStateName, OriginStateName LIMIT 7"]}
{"sql":"SELECT Diverted, ArrivalDelayGroups FROM mytable WHERE NASDelay > 32 OR DaysSinceEpoch BETWEEN 16090 AND 16091 ORDER BY ActualElapsedTime LIMIT 18"}
{"sql":"SELECT WeatherDelay FROM mytable WHERE LongestAddGTime NOT IN (20, 11) OR DivLongestGTimes IN (45.0) ORDER BY AirlineID LIMIT 18","hsqls":["SELECT WeatherDelay FROM mytable WHERE LongestAddGTime NOT IN (20, 11) OR (DivLongestGTimes[1] IN (45.0) OR DivLongestGTimes[2] IN (45.0) OR DivLongestGTimes[3] IN (45.0) OR DivLongestGTimes[4] IN (45.0) OR DivLongestGTimes[5] IN (45.0)) ORDER BY AirlineID LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, TailNum, DaysSinceEpoch, COUNT(OriginCityMarketID), SUM(ArrDelay) FROM mytable WHERE DivDistance > 575 OR DestStateFips IN (49) AND OriginCityMarketID BETWEEN 30849 AND 34108 GROUP BY DistanceGroup, TailNum, DaysSinceEpoch  ORDER BY DistanceGroup, TailNum, DaysSinceEpoch LIMIT 2","hsqls":["SELECT DistanceGroup, TailNum, DaysSinceEpoch, COUNT(OriginCityMarketID), SUM(ArrDelay) FROM mytable WHERE DivDistance > 575 OR DestStateFips IN (49) AND OriginCityMarketID BETWEEN 30849 AND 34108 GROUP BY DistanceGroup, TailNum, DaysSinceEpoch  ORDER BY DistanceGroup, TailNum, DaysSinceEpoch LIMIT 2"]}
{"sql":"SELECT ArrDelay FROM mytable WHERE ArrDel15 BETWEEN 0 AND 0 OR DepDelayMinutes >= 51.0 ORDER BY DepartureDelayGroups, UniqueCarrier LIMIT 6"}
{"sql":"SELECT DepDel15, SUM(ArrDelay), MIN(\"Month\"), MAX(ArrTime) FROM mytable WHERE FlightDate BETWEEN '2014-01-28' AND '2014-01-18' OR DestAirportID NOT IN (11977, 13198, 11109, 12007, 11995) GROUP BY DepDel15 LIMIT 7","hsqls":["SELECT DepDel15, SUM(ArrDelay), MIN(`Month`), MAX(ArrTime) FROM mytable WHERE FlightDate BETWEEN '2014-01-28' AND '2014-01-18' OR DestAirportID NOT IN (11977, 13198, 11109, 12007, 11995) GROUP BY DepDel15 LIMIT 7"]}
{"sql":"SELECT DestWac, Dest, MIN(OriginAirportID) FROM mytable WHERE TailNum IN ('N406WN', 'N363AA', 'N13970') GROUP BY DestWac, Dest  ORDER BY DestWac, Dest LIMIT 18","hsqls":["SELECT DestWac, Dest, MIN(OriginAirportID) FROM mytable WHERE TailNum IN ('N406WN', 'N363AA', 'N13970') GROUP BY DestWac, Dest  ORDER BY DestWac, Dest LIMIT 18"]}
{"sql":"SELECT Dest, COUNT(*) FROM mytable WHERE Flights = 1 GROUP BY Dest  ORDER BY Dest LIMIT 26","hsqls":["SELECT Dest, COUNT(*) FROM mytable WHERE Flights = 1 GROUP BY Dest  ORDER BY Dest LIMIT 26"]}
{"sql":"SELECT FlightNum FROM mytable WHERE TaxiOut IN (97, 69, 4, 14, 29) AND Diverted = 1 LIMIT 26"}
{"sql":"SELECT MAX(AirlineID) FROM mytable WHERE DayofMonth IN (13, 27, 14, 29) OR DestCityMarketID >= 31726 OR DivAirportLandings < 0 LIMIT 1"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestStateName BETWEEN 'Washington' AND 'New Hampshire' LIMIT 2"}
{"sql":"SELECT Origin, DivWheelsOffs, DestCityMarketID FROM mytable WHERE DaysSinceEpoch NOT IN (16092, 16076) OR DestAirportSeqID BETWEEN 1524903 AND 1226402 ORDER BY DestWac LIMIT 19","hsqls":["SELECT Origin, DivWheelsOffs, DestCityMarketID FROM mytable WHERE DaysSinceEpoch NOT IN (16092, 16076) OR DestAirportSeqID BETWEEN 1524903 AND 1226402 ORDER BY DestWac LIMIT 10000"]}
{"sql":"SELECT OriginState, DayofMonth, AirlineID, COUNT(ArrDel15), SUM(DestStateFips) FROM mytable WHERE TotalAddGTime < 19 GROUP BY OriginState, DayofMonth, AirlineID  ORDER BY OriginState, DayofMonth, AirlineID LIMIT 27","hsqls":["SELECT OriginState, DayofMonth, AirlineID, COUNT(ArrDel15), SUM(DestStateFips) FROM mytable WHERE TotalAddGTime < 19 GROUP BY OriginState, DayofMonth, AirlineID  ORDER BY OriginState, DayofMonth, AirlineID LIMIT 27"]}
{"sql":"SELECT CRSDepTime, COUNT(*) FROM mytable WHERE DepDelay BETWEEN -34.0 AND 310.0 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 10","hsqls":["SELECT CRSDepTime, COUNT(*) FROM mytable WHERE DepDelay BETWEEN -34.0 AND 310.0 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 10"]}
{"sql":"SELECT DepartureDelayGroups, LongestAddGTime, AVG(DivReachedDest), SUM(Flights), MAX(AirTime) FROM mytable WHERE DestAirportSeqID <> 1080003 AND OriginStateFips BETWEEN 18 AND 1 AND DivDistance < 509 GROUP BY DepartureDelayGroups, LongestAddGTime  ORDER BY DepartureDelayGroups, LongestAddGTime LIMIT 8","hsqls":["SELECT DepartureDelayGroups, LongestAddGTime, AVG(DivReachedDest), SUM(Flights), MAX(AirTime) FROM mytable WHERE DestAirportSeqID <> 1080003 AND OriginStateFips BETWEEN 18 AND 1 AND DivDistance < 509 GROUP BY DepartureDelayGroups, LongestAddGTime  ORDER BY DepartureDelayGroups, LongestAddGTime LIMIT 8"]}
{"sql":"SELECT MAX(ArrDelayMinutes) FROM mytable LIMIT 21"}
{"sql":"SELECT CarrierDelay, MIN(DepTime), SUM(ArrTime), MAX(\"Month\") FROM mytable WHERE DestCityMarketID NOT IN (30529) AND OriginState NOT IN ('OH', 'NM', 'DE', 'CO', 'MI') GROUP BY CarrierDelay LIMIT 23","hsqls":["SELECT CarrierDelay, MIN(DepTime), SUM(ArrTime), MAX(`Month`) FROM mytable WHERE DestCityMarketID NOT IN (30529) AND OriginState NOT IN ('OH', 'NM', 'DE', 'CO', 'MI') GROUP BY CarrierDelay LIMIT 23"]}
{"sql":"SELECT DepDelayMinutes, ArrTimeBlk, OriginWac, SUM(DestCityMarketID) FROM mytable WHERE Distance >= 1208 AND ArrTime NOT IN (111) GROUP BY DepDelayMinutes, ArrTimeBlk, OriginWac  ORDER BY DepDelayMinutes, ArrTimeBlk, OriginWac LIMIT 15","hsqls":["SELECT DepDelayMinutes, ArrTimeBlk, OriginWac, SUM(DestCityMarketID) FROM mytable WHERE Distance >= 1208 AND ArrTime NOT IN (111) GROUP BY DepDelayMinutes, ArrTimeBlk, OriginWac  ORDER BY DepDelayMinutes, ArrTimeBlk, OriginWac LIMIT 15"]}
{"sql":"SELECT ArrDelay FROM mytable WHERE OriginCityName >= 'International Falls, MN' AND ArrTime = 2319 AND FlightNum BETWEEN 3454 AND 3541 ORDER BY WeatherDelay, DepDelayMinutes, OriginCityName LIMIT 27"}
{"sql":"SELECT ArrDelayMinutes, WheelsOn, OriginAirportID, MIN(DivActualElapsedTime), MAX(DepDel15), COUNT(TailNum) FROM mytable WHERE LateAircraftDelay IN (128) OR OriginStateFips > 51 AND Diverted = 0 GROUP BY ArrDelayMinutes, WheelsOn, OriginAirportID  ORDER BY ArrDelayMinutes, WheelsOn, OriginAirportID LIMIT 1","hsqls":["SELECT ArrDelayMinutes, WheelsOn, OriginAirportID, MIN(DivActualElapsedTime), MAX(DepDel15), COUNT(TailNum) FROM mytable WHERE LateAircraftDelay IN (128) OR OriginStateFips > 51 AND Diverted = 0 GROUP BY ArrDelayMinutes, WheelsOn, OriginAirportID  ORDER BY ArrDelayMinutes, WheelsOn, OriginAirportID LIMIT 1"]}
{"sql":"SELECT AVG(DestAirportSeqID), MIN(ArrivalDelayGroups) FROM mytable WHERE DivDistance >= 402 LIMIT 21"}
{"sql":"SELECT DepartureDelayGroups, CancellationCode, AVG(OriginCityMarketID) FROM mytable WHERE DestStateName BETWEEN 'U.S. Pacific Trust Territories and Possessions' AND 'Massachusetts' GROUP BY DepartureDelayGroups, CancellationCode  ORDER BY DepartureDelayGroups, CancellationCode LIMIT 26","hsqls":["SELECT DepartureDelayGroups, CancellationCode, AVG(OriginCityMarketID) FROM mytable WHERE DestStateName BETWEEN 'U.S. Pacific Trust Territories and Possessions' AND 'Massachusetts' GROUP BY DepartureDelayGroups, CancellationCode  ORDER BY DepartureDelayGroups, CancellationCode LIMIT 26"]}
{"sql":"SELECT OriginState, \"Month\", OriginAirportID, MIN(OriginAirportSeqID) FROM mytable WHERE TotalAddGTime NOT IN (25) OR DepDelayMinutes BETWEEN 199.0 AND 245.0 OR DestAirportID BETWEEN 13204 AND 14108 GROUP BY OriginState, \"Month\", OriginAirportID LIMIT 28","hsqls":["SELECT OriginState, Month, OriginAirportID, MIN(OriginAirportSeqID) FROM mytable WHERE TotalAddGTime NOT IN (25) OR DepDelayMinutes BETWEEN 199.0 AND 245.0 OR DestAirportID BETWEEN 13204 AND 14108 GROUP BY OriginState, Month, OriginAirportID LIMIT 28"]}
{"sql":"SELECT DivTailNums FROM mytable WHERE DestStateFips > 1 OR DepTime NOT IN (1523, 1237, 1053, 1636, 2212) AND AirTime BETWEEN 319 AND 328 ORDER BY Dest, DayOfWeek LIMIT 4","hsqls":["SELECT DivTailNums FROM mytable WHERE DestStateFips > 1 OR DepTime NOT IN (1523, 1237, 1053, 1636, 2212) AND AirTime BETWEEN 319 AND 328 ORDER BY Dest, DayOfWeek LIMIT 10000"]}
{"sql":"SELECT DayofMonth FROM mytable WHERE UniqueCarrier NOT IN ('UA') LIMIT 26"}
{"sql":"SELECT DepartureDelayGroups, OriginWac, MIN(AirTime), SUM(DayofMonth) FROM mytable GROUP BY DepartureDelayGroups, OriginWac  ORDER BY DepartureDelayGroups, OriginWac LIMIT 5","hsqls":["SELECT DepartureDelayGroups, OriginWac, MIN(AirTime), SUM(DayofMonth) FROM mytable GROUP BY DepartureDelayGroups, OriginWac  ORDER BY DepartureDelayGroups, OriginWac LIMIT 5"]}
{"sql":"SELECT AirlineID FROM mytable WHERE DestCityMarketID BETWEEN 32467 AND 32012 AND TaxiIn BETWEEN 109 AND 56 ORDER BY TaxiIn, DestCityName, CRSElapsedTime LIMIT 19"}
{"sql":"SELECT WheelsOff, DestCityName, DestStateName FROM mytable ORDER BY FlightDate LIMIT 14"}
{"sql":"SELECT DestAirportID, WheelsOn, MIN(OriginStateFips), COUNT(OriginAirportID), SUM(DayOfWeek) FROM mytable WHERE DestStateFips BETWEEN 21 AND 26 OR AirlineID IN (20437, 19805) AND LateAircraftDelay <= 247 GROUP BY DestAirportID, WheelsOn  ORDER BY DestAirportID, WheelsOn LIMIT 14","hsqls":["SELECT DestAirportID, WheelsOn, MIN(OriginStateFips), COUNT(OriginAirportID), SUM(DayOfWeek) FROM mytable WHERE DestStateFips BETWEEN 21 AND 26 OR AirlineID IN (20437, 19805) AND LateAircraftDelay <= 247 GROUP BY DestAirportID, WheelsOn  ORDER BY DestAirportID, WheelsOn LIMIT 14"]}
{"sql":"SELECT TotalAddGTime, TaxiIn, COUNT(*) FROM mytable WHERE ArrDel15 IN (-9999) OR ArrDelayMinutes BETWEEN 44.0 AND 196.0 AND DivActualElapsedTime BETWEEN 466 AND 296 GROUP BY TotalAddGTime, TaxiIn  ORDER BY TotalAddGTime, TaxiIn LIMIT 24","hsqls":["SELECT TotalAddGTime, TaxiIn, COUNT(*) FROM mytable WHERE ArrDel15 IN (-9999) OR ArrDelayMinutes BETWEEN 44.0 AND 196.0 AND DivActualElapsedTime BETWEEN 466 AND 296 GROUP BY TotalAddGTime, TaxiIn  ORDER BY TotalAddGTime, TaxiIn LIMIT 24"]}
{"sql":"SELECT Carrier, Distance, Cancelled, SUM(\"Year\") FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'noodles' AND \"Month\" IN (1) GROUP BY Carrier, Distance, Cancelled LIMIT 4","hsqls":["SELECT Carrier, Distance, Cancelled, SUM(`Year`) FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'noodles' AND `Month` IN (1) GROUP BY Carrier, Distance, Cancelled LIMIT 4"]}
{"sql":"SELECT DestAirportSeqID FROM mytable ORDER BY Cancelled, DestStateName, CancellationCode LIMIT 25"}
{"sql":"SELECT FlightDate, DayOfWeek, COUNT(OriginStateName), COUNT(DivArrDelay), COUNT(DestCityName) FROM mytable WHERE ArrDel15 <= 0 GROUP BY FlightDate, DayOfWeek  ORDER BY FlightDate, DayOfWeek LIMIT 16","hsqls":["SELECT FlightDate, DayOfWeek, COUNT(OriginStateName), COUNT(DivArrDelay), COUNT(DestCityName) FROM mytable WHERE ArrDel15 <= 0 GROUP BY FlightDate, DayOfWeek  ORDER BY FlightDate, DayOfWeek LIMIT 16"]}
{"sql":"SELECT TaxiOut FROM mytable ORDER BY DestAirportSeqID, ArrDelay LIMIT 27"}
{"sql":"SELECT DivDistance, COUNT(*) FROM mytable WHERE DestCityMarketID < 33728 AND CarrierDelay >= 189 GROUP BY DivDistance  ORDER BY DivDistance LIMIT 7","hsqls":["SELECT DivDistance, COUNT(*) FROM mytable WHERE DestCityMarketID < 33728 AND CarrierDelay >= 189 GROUP BY DivDistance  ORDER BY DivDistance LIMIT 7"]}
{"sql":"SELECT OriginAirportSeqID, Diverted, DestStateName, MIN(DepDelayMinutes), COUNT(Diverted), MIN(TaxiIn) FROM mytable WHERE Dest NOT IN ('GEG', 'CHO', 'BRO', 'ALO') OR DivWheelsOns IN (1330, 757) AND DestAirportSeqID >= 1501603 GROUP BY OriginAirportSeqID, Diverted, DestStateName LIMIT 6","hsqls":["SELECT OriginAirportSeqID, Diverted, DestStateName, MIN(DepDelayMinutes), COUNT(Diverted), MIN(TaxiIn) FROM mytable WHERE Dest NOT IN ('GEG', 'CHO', 'BRO', 'ALO') OR (DivWheelsOns[1] IN (1330, 757) OR DivWheelsOns[2] IN (1330, 757) OR DivWheelsOns[3] IN (1330, 757) OR DivWheelsOns[4] IN (1330, 757) OR DivWheelsOns[5] IN (1330, 757)) AND DestAirportSeqID >= 1501603 GROUP BY OriginAirportSeqID, Diverted, DestStateName LIMIT 10000"]}
{"sql":"SELECT DepTime, DivAirportIDs, UniqueCarrier FROM mytable WHERE CRSDepTime > 951 OR DepDelayMinutes > 157.0 AND AirlineID IN (20436, 19790, 19930, 20409) ORDER BY DayOfWeek LIMIT 16","hsqls":["SELECT DepTime, DivAirportIDs, UniqueCarrier FROM mytable WHERE CRSDepTime > 951 OR DepDelayMinutes > 157.0 AND AirlineID IN (20436, 19790, 19930, 20409) ORDER BY DayOfWeek LIMIT 10000"]}
{"sql":"SELECT DestStateName, DepTimeBlk, UniqueCarrier FROM mytable ORDER BY Diverted, ArrTimeBlk, ArrivalDelayGroups LIMIT 26"}
{"sql":"SELECT \"Year\" FROM mytable WHERE DayofMonth IN (7, 6, 8) OR DestCityMarketID < 34254 AND AirlineID IN (20304, 20436, 19393, 20437, 20355) ORDER BY WheelsOff, DepartureDelayGroups, DestAirportSeqID LIMIT 26","hsqls":["SELECT `Year` FROM mytable WHERE DayofMonth IN (7, 6, 8) OR DestCityMarketID < 34254 AND AirlineID IN (20304, 20436, 19393, 20437, 20355) ORDER BY WheelsOff, DepartureDelayGroups, DestAirportSeqID LIMIT 26"]}
{"sql":"SELECT DestCityMarketID FROM mytable ORDER BY \"Year\", ArrTime, ArrTimeBlk LIMIT 25","hsqls":["SELECT DestCityMarketID FROM mytable ORDER BY Year, ArrTime, ArrTimeBlk LIMIT 25"]}
{"sql":"SELECT TotalAddGTime, DepDel15 FROM mytable WHERE Cancelled BETWEEN 1 AND 1 AND OriginCityMarketID BETWEEN 32012 AND 31921 ORDER BY FlightDate, OriginStateName LIMIT 15"}
{"sql":"SELECT DivDistance, Distance, DepDel15, AVG(DayOfWeek), AVG(CRSElapsedTime) FROM mytable WHERE DepTime IN (1307, 1309, 1505, 1153, 1900) AND DayOfWeek IN (4) OR ArrDelayMinutes BETWEEN 418.0 AND 209.0 GROUP BY DivDistance, Distance, DepDel15  ORDER BY DivDistance, Distance, DepDel15 LIMIT 13","hsqls":["SELECT DivDistance, Distance, DepDel15, AVG(DayOfWeek), AVG(CRSElapsedTime) FROM mytable WHERE DepTime IN (1307, 1309, 1505, 1153, 1900) AND DayOfWeek IN (4) OR ArrDelayMinutes BETWEEN 418.0 AND 209.0 GROUP BY DivDistance, Distance, DepDel15  ORDER BY DivDistance, Distance, DepDel15 LIMIT 13"]}
{"sql":"SELECT DepDelay, ArrDelayMinutes, DivWheelsOffs FROM mytable WHERE ArrTime IN (601, 1840, 702) AND DayOfWeek > 6 AND CarrierDelay BETWEEN 150 AND 189 LIMIT 20","hsqls":["SELECT DepDelay, ArrDelayMinutes, DivWheelsOffs FROM mytable WHERE ArrTime IN (601, 1840, 702) AND DayOfWeek > 6 AND CarrierDelay BETWEEN 150 AND 189 LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DestWac, COUNT(NASDelay), MIN(DivArrDelay), MIN(DistanceGroup) FROM mytable WHERE DivWheelsOns IN (2146, 2254) AND DepDelayMinutes BETWEEN 251.0 AND 234.0 OR LongestAddGTime < 24 GROUP BY OriginAirportSeqID, DestWac LIMIT 2","hsqls":["SELECT OriginAirportSeqID, DestWac, COUNT(NASDelay), MIN(DivArrDelay), MIN(DistanceGroup) FROM mytable WHERE (DivWheelsOns[1] IN (2146, 2254) OR DivWheelsOns[2] IN (2146, 2254) OR DivWheelsOns[3] IN (2146, 2254) OR DivWheelsOns[4] IN (2146, 2254) OR DivWheelsOns[5] IN (2146, 2254)) AND DepDelayMinutes BETWEEN 251.0 AND 234.0 OR LongestAddGTime < 24 GROUP BY OriginAirportSeqID, DestWac LIMIT 10000"]}
{"sql":"SELECT OriginWac FROM mytable WHERE DestState BETWEEN 'WV' AND 'NY' AND Diverted = 0 ORDER BY ArrTime LIMIT 26"}
{"sql":"SELECT OriginWac FROM mytable WHERE FlightNum IN (3629, 1949) ORDER BY DepTime, ArrDelayMinutes, DivArrDelay LIMIT 1"}
{"sql":"SELECT AVG(NASDelay), MAX(NASDelay), SUM(CRSArrTime) FROM mytable WHERE DayofMonth <= 12 AND FlightDate BETWEEN '2014-01-31' AND '2014-01-30' OR LateAircraftDelay NOT IN (195) LIMIT 19"}
{"sql":"SELECT TaxiIn, DayofMonth, DivActualElapsedTime FROM mytable LIMIT 26"}
{"sql":"SELECT CRSArrTime, ArrTime, Cancelled, SUM(Cancelled) FROM mytable WHERE DivDistance BETWEEN 47 AND 581 AND OriginCityName BETWEEN 'Huntsville, AL' AND 'Wichita, KS' OR DestStateName BETWEEN 'Wisconsin' AND 'Nebraska' GROUP BY CRSArrTime, ArrTime, Cancelled  ORDER BY CRSArrTime, ArrTime, Cancelled LIMIT 23","hsqls":["SELECT CRSArrTime, ArrTime, Cancelled, SUM(Cancelled) FROM mytable WHERE DivDistance BETWEEN 47 AND 581 AND OriginCityName BETWEEN 'Huntsville, AL' AND 'Wichita, KS' OR DestStateName BETWEEN 'Wisconsin' AND 'Nebraska' GROUP BY CRSArrTime, ArrTime, Cancelled  ORDER BY CRSArrTime, ArrTime, Cancelled LIMIT 23"]}
{"sql":"SELECT DivArrDelay FROM mytable WHERE Flights BETWEEN 1 AND 1 ORDER BY DivReachedDest, DestStateFips, ActualElapsedTime LIMIT 11"}
{"sql":"SELECT DepDelayMinutes, WheelsOn, COUNT(*) FROM mytable WHERE ArrTime <= 1114 GROUP BY DepDelayMinutes, WheelsOn  ORDER BY DepDelayMinutes, WheelsOn LIMIT 10","hsqls":["SELECT DepDelayMinutes, WheelsOn, COUNT(*) FROM mytable WHERE ArrTime <= 1114 GROUP BY DepDelayMinutes, WheelsOn  ORDER BY DepDelayMinutes, WheelsOn LIMIT 10"]}
{"sql":"SELECT WheelsOff FROM mytable WHERE ArrTimeBlk IN ('1600-1659') AND OriginAirportSeqID >= 1393102 AND OriginWac BETWEEN 65 AND 1 LIMIT 7"}
{"sql":"SELECT DestState, DepTimeBlk, DayofMonth FROM mytable WHERE TaxiIn BETWEEN 59 AND 93 ORDER BY Carrier LIMIT 23"}
{"sql":"SELECT OriginCityMarketID, DestCityMarketID, MIN(DestAirportID), MAX(OriginWac) FROM mytable WHERE DivWheelsOns <= 2254 GROUP BY OriginCityMarketID, DestCityMarketID LIMIT 17","hsqls":["SELECT OriginCityMarketID, DestCityMarketID, MIN(DestAirportID), MAX(OriginWac) FROM mytable WHERE (DivWheelsOns[1] <= 2254 OR DivWheelsOns[2] <= 2254 OR DivWheelsOns[3] <= 2254 OR DivWheelsOns[4] <= 2254 OR DivWheelsOns[5] <= 2254) GROUP BY OriginCityMarketID, DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT Diverted, TailNum, DaysSinceEpoch, SUM(ArrivalDelayGroups), MAX(DivReachedDest) FROM mytable WHERE FlightDate = '2014-01-26' AND DepDelay BETWEEN 99.0 AND 86.0 AND DepTimeBlk = '1400-1459' GROUP BY Diverted, TailNum, DaysSinceEpoch  ORDER BY Diverted, TailNum, DaysSinceEpoch LIMIT 4","hsqls":["SELECT Diverted, TailNum, DaysSinceEpoch, SUM(ArrivalDelayGroups), MAX(DivReachedDest) FROM mytable WHERE FlightDate = '2014-01-26' AND DepDelay BETWEEN 99.0 AND 86.0 AND DepTimeBlk = '1400-1459' GROUP BY Diverted, TailNum, DaysSinceEpoch  ORDER BY Diverted, TailNum, DaysSinceEpoch LIMIT 4"]}
{"sql":"SELECT CancellationCode, MAX(SecurityDelay), COUNT(CarrierDelay) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 10","hsqls":["SELECT CancellationCode, MAX(SecurityDelay), COUNT(CarrierDelay) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 10"]}
{"sql":"SELECT DivReachedDest, OriginCityMarketID, COUNT(*) FROM mytable WHERE ArrDelay <= 4.0 GROUP BY DivReachedDest, OriginCityMarketID  ORDER BY DivReachedDest, OriginCityMarketID LIMIT 3","hsqls":["SELECT DivReachedDest, OriginCityMarketID, COUNT(*) FROM mytable WHERE ArrDelay <= 4.0 GROUP BY DivReachedDest, OriginCityMarketID  ORDER BY DivReachedDest, OriginCityMarketID LIMIT 3"]}
{"sql":"SELECT Carrier, AVG(DaysSinceEpoch), SUM(OriginWac), SUM(DestCityMarketID) FROM mytable GROUP BY Carrier","hsqls":["SELECT Carrier, AVG(DaysSinceEpoch), SUM(OriginWac), SUM(DestCityMarketID) FROM mytable GROUP BY Carrier"]}
{"sql":"SELECT ArrTimeBlk, ArrDelay FROM mytable WHERE Quarter NOT IN (1) ORDER BY DestStateFips, FlightDate, DivAirportLandings LIMIT 25"}
{"sql":"SELECT WeatherDelay, DestCityMarketID FROM mytable WHERE FlightNum BETWEEN 5571 AND 4591 OR FlightNum = 6431 ORDER BY DepTime LIMIT 26"}
{"sql":"SELECT DestCityName FROM mytable LIMIT 10"}
{"sql":"SELECT WheelsOff, OriginStateFips, DepDel15 FROM mytable WHERE FlightDate IN ('2014-01-12', '2014-01-03', '2014-01-29', '2014-01-13', '2014-01-20') ORDER BY OriginCityName LIMIT 16"}
{"sql":"SELECT DepDelayMinutes, COUNT(DepDelay), COUNT(CarrierDelay), SUM(Distance) FROM mytable WHERE TaxiIn <> 37 OR DestState BETWEEN 'CO' AND 'MO' AND DivTailNums BETWEEN 'N303DQ' AND 'N873AS' GROUP BY DepDelayMinutes LIMIT 18","hsqls":["SELECT DepDelayMinutes, COUNT(DepDelay), COUNT(CarrierDelay), SUM(Distance) FROM mytable WHERE TaxiIn <> 37 OR DestState BETWEEN 'CO' AND 'MO' AND (DivTailNums[1] BETWEEN 'N303DQ' AND 'N873AS' OR DivTailNums[2] BETWEEN 'N303DQ' AND 'N873AS' OR DivTailNums[3] BETWEEN 'N303DQ' AND 'N873AS' OR DivTailNums[4] BETWEEN 'N303DQ' AND 'N873AS' OR DivTailNums[5] BETWEEN 'N303DQ' AND 'N873AS') GROUP BY DepDelayMinutes LIMIT 10000"]}
{"sql":"SELECT Dest, SUM(TaxiOut), SUM(DestAirportSeqID) FROM mytable WHERE DivWheelsOns BETWEEN 855 AND 1434 AND DestStateName BETWEEN 'Connecticut' AND 'Mississippi' OR DepTime >= 1755 GROUP BY Dest LIMIT 15","hsqls":["SELECT Dest, SUM(TaxiOut), SUM(DestAirportSeqID) FROM mytable WHERE (DivWheelsOns[1] BETWEEN 855 AND 1434 OR DivWheelsOns[2] BETWEEN 855 AND 1434 OR DivWheelsOns[3] BETWEEN 855 AND 1434 OR DivWheelsOns[4] BETWEEN 855 AND 1434 OR DivWheelsOns[5] BETWEEN 855 AND 1434) AND DestStateName BETWEEN 'Connecticut' AND 'Mississippi' OR DepTime >= 1755 GROUP BY Dest LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, DestCityMarketID, DaysSinceEpoch FROM mytable WHERE Origin <= 'BMI' AND DestStateName NOT IN ('Colorado', 'Kentucky') ORDER BY FlightNum, CRSDepTime LIMIT 22"}
{"sql":"SELECT MAX(Flights), SUM(WeatherDelay), AVG(Diverted) FROM mytable WHERE WeatherDelay BETWEEN 43 AND 55 LIMIT 4"}
{"sql":"SELECT ArrTime, Origin FROM mytable ORDER BY LongestAddGTime, DestCityName, DayOfWeek LIMIT 8"}
{"sql":"SELECT Quarter, DestState FROM mytable WHERE ActualElapsedTime >= 182 LIMIT 26"}
{"sql":"SELECT DestStateFips, COUNT(*) FROM mytable WHERE WheelsOn NOT IN (1614, 1415, 1320, 1819) GROUP BY DestStateFips  ORDER BY DestStateFips LIMIT 27","hsqls":["SELECT DestStateFips, COUNT(*) FROM mytable WHERE WheelsOn NOT IN (1614, 1415, 1320, 1819) GROUP BY DestStateFips  ORDER BY DestStateFips LIMIT 27"]}
{"sql":"SELECT OriginStateFips, Cancelled, AirlineID, AVG(DivReachedDest), COUNT(TaxiIn) FROM mytable WHERE DepDelay NOT IN (243.0, 0.0, 67.0, 168.0) AND LateAircraftDelay IN (182, 121, 56, 159, 142) AND ActualElapsedTime < 75 GROUP BY OriginStateFips, Cancelled, AirlineID","hsqls":["SELECT OriginStateFips, Cancelled, AirlineID, AVG(DivReachedDest), COUNT(TaxiIn) FROM mytable WHERE DepDelay NOT IN (243.0, 0.0, 67.0, 168.0) AND LateAircraftDelay IN (182, 121, 56, 159, 142) AND ActualElapsedTime < 75 GROUP BY OriginStateFips, Cancelled, AirlineID"]}
{"sql":"SELECT MAX(OriginCityMarketID), COUNT(DayOfWeek), AVG(DayofMonth) FROM mytable WHERE TotalAddGTime BETWEEN 4 AND 32 AND Distance IN (683, 2447, 2846, 606, 2136) AND \"Month\" <= 1 LIMIT 25","hsqls":["SELECT MAX(OriginCityMarketID), COUNT(DayOfWeek), AVG(DayofMonth) FROM mytable WHERE TotalAddGTime BETWEEN 4 AND 32 AND Distance IN (683, 2447, 2846, 606, 2136) AND `Month` <= 1 LIMIT 25"]}
{"sql":"SELECT OriginState, FirstDepTime, FlightNum FROM mytable ORDER BY Origin, OriginStateName, DaysSinceEpoch LIMIT 16"}
{"sql":"SELECT FlightNum, Dest, ArrivalDelayGroups FROM mytable WHERE ArrDel15 NOT IN (1, 0, -9999) OR DivTailNums BETWEEN 'N16981' AND 'N806JB' AND DestStateName IN ('Massachusetts') LIMIT 12","hsqls":["SELECT FlightNum, Dest, ArrivalDelayGroups FROM mytable WHERE ArrDel15 NOT IN (1, 0, -9999) OR (DivTailNums[1] BETWEEN 'N16981' AND 'N806JB' OR DivTailNums[2] BETWEEN 'N16981' AND 'N806JB' OR DivTailNums[3] BETWEEN 'N16981' AND 'N806JB' OR DivTailNums[4] BETWEEN 'N16981' AND 'N806JB' OR DivTailNums[5] BETWEEN 'N16981' AND 'N806JB') AND DestStateName IN ('Massachusetts') LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, COUNT(\"Month\"), SUM(DayOfWeek) FROM mytable WHERE DivWheelsOns IN (1541, 1518, 1942) AND CRSArrTime BETWEEN 1758 AND 1107 GROUP BY LongestAddGTime LIMIT 9","hsqls":["SELECT LongestAddGTime, COUNT(`Month`), SUM(DayOfWeek) FROM mytable WHERE (DivWheelsOns[1] IN (1541, 1518, 1942) OR DivWheelsOns[2] IN (1541, 1518, 1942) OR DivWheelsOns[3] IN (1541, 1518, 1942) OR DivWheelsOns[4] IN (1541, 1518, 1942) OR DivWheelsOns[5] IN (1541, 1518, 1942)) AND CRSArrTime BETWEEN 1758 AND 1107 GROUP BY LongestAddGTime LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, OriginWac FROM mytable ORDER BY Carrier, ArrTimeBlk LIMIT 19"}
{"sql":"SELECT TaxiIn, \"Month\" FROM mytable WHERE DaysSinceEpoch BETWEEN 16100 AND 16071 ORDER BY FirstDepTime, TotalAddGTime","hsqls":["SELECT TaxiIn, `Month` FROM mytable WHERE DaysSinceEpoch BETWEEN 16100 AND 16071 ORDER BY FirstDepTime, TotalAddGTime"]}
{"sql":"SELECT FlightDate FROM mytable WHERE DivWheelsOns BETWEEN 1937 AND 2329 OR DepDelayMinutes <> 27.0 OR DayofMonth IN (17) ORDER BY OriginCityName LIMIT 24","hsqls":["SELECT FlightDate FROM mytable WHERE (DivWheelsOns[1] BETWEEN 1937 AND 2329 OR DivWheelsOns[2] BETWEEN 1937 AND 2329 OR DivWheelsOns[3] BETWEEN 1937 AND 2329 OR DivWheelsOns[4] BETWEEN 1937 AND 2329 OR DivWheelsOns[5] BETWEEN 1937 AND 2329) OR DepDelayMinutes <> 27.0 OR DayofMonth IN (17) ORDER BY OriginCityName LIMIT 10000"]}
{"sql":"SELECT DivActualElapsedTime, OriginStateName, SUM(ArrDelayMinutes), MIN(DepDel15) FROM mytable WHERE DivTotalGTimes IN (6, 39, 85) AND ArrDelayMinutes > 184.0 AND DestAirportSeqID NOT IN (1342402, 1486903, 1125203) GROUP BY DivActualElapsedTime, OriginStateName LIMIT 19","hsqls":["SELECT DivActualElapsedTime, OriginStateName, SUM(ArrDelayMinutes), MIN(DepDel15) FROM mytable WHERE (DivTotalGTimes[1] IN (6, 39, 85) OR DivTotalGTimes[2] IN (6, 39, 85) OR DivTotalGTimes[3] IN (6, 39, 85) OR DivTotalGTimes[4] IN (6, 39, 85) OR DivTotalGTimes[5] IN (6, 39, 85)) AND ArrDelayMinutes > 184.0 AND DestAirportSeqID NOT IN (1342402, 1486903, 1125203) GROUP BY DivActualElapsedTime, OriginStateName LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes FROM mytable WHERE DivReachedDest IN (1, 0, -9999) OR Distance BETWEEN 911 AND 691 AND Flights BETWEEN 1 AND 1 ORDER BY DivArrDelay LIMIT 11"}
{"sql":"SELECT \"Year\", SecurityDelay, Cancelled, AVG(\"Month\"), SUM(\"Month\"), AVG(FlightNum) FROM mytable WHERE TaxiOut NOT IN (6) GROUP BY \"Year\", SecurityDelay, Cancelled LIMIT 19","hsqls":["SELECT Year, SecurityDelay, Cancelled, AVG(`Month`), SUM(`Month`), AVG(FlightNum) FROM mytable WHERE TaxiOut NOT IN (6) GROUP BY Year, SecurityDelay, Cancelled LIMIT 19"]}
{"sql":"SELECT DepTime, DestCityName, Origin, AVG(CarrierDelay), AVG(OriginWac), COUNT(DivActualElapsedTime) FROM mytable WHERE DepDelay IN (116.0) OR DepDelayMinutes = 87.0 OR DivAirports = 'TYS' GROUP BY DepTime, DestCityName, Origin LIMIT 5","hsqls":["SELECT DepTime, DestCityName, Origin, AVG(CarrierDelay), AVG(OriginWac), COUNT(DivActualElapsedTime) FROM mytable WHERE DepDelay IN (116.0) OR DepDelayMinutes = 87.0 OR (DivAirports[1] = 'TYS' OR DivAirports[2] = 'TYS' OR DivAirports[3] = 'TYS' OR DivAirports[4] = 'TYS' OR DivAirports[5] = 'TYS') GROUP BY DepTime, DestCityName, Origin LIMIT 10000"]}
{"sql":"SELECT SUM(Cancelled), SUM(DaysSinceEpoch), COUNT(DestState) FROM mytable LIMIT 20"}
{"sql":"SELECT Carrier, LongestAddGTime, CancellationCode, MIN(WeatherDelay), SUM(OriginStateFips) FROM mytable WHERE DestState BETWEEN 'NJ' AND 'AZ' GROUP BY Carrier, LongestAddGTime, CancellationCode  ORDER BY Carrier, LongestAddGTime, CancellationCode LIMIT 15","hsqls":["SELECT Carrier, LongestAddGTime, CancellationCode, MIN(WeatherDelay), SUM(OriginStateFips) FROM mytable WHERE DestState BETWEEN 'NJ' AND 'AZ' GROUP BY Carrier, LongestAddGTime, CancellationCode  ORDER BY Carrier, LongestAddGTime, CancellationCode LIMIT 15"]}
{"sql":"SELECT DepDelay FROM mytable LIMIT 10"}
{"sql":"SELECT CarrierDelay, DivArrDelay, ArrivalDelayGroups FROM mytable WHERE FirstDepTime <> -9999 AND Cancelled >= 1 OR DestAirportID BETWEEN 14783 AND 10732 ORDER BY ActualElapsedTime, ArrTime, DepTimeBlk LIMIT 5"}
{"sql":"SELECT TaxiIn, COUNT(*) FROM mytable WHERE OriginStateFips BETWEEN 4 AND 13 GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 18","hsqls":["SELECT TaxiIn, COUNT(*) FROM mytable WHERE OriginStateFips BETWEEN 4 AND 13 GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 18"]}
{"sql":"SELECT OriginAirportSeqID, DepDelay, Dest FROM mytable WHERE OriginCityName BETWEEN 'Flagstaff, AZ' AND 'Longview, TX' AND FlightDate NOT IN ('2014-01-15', '2014-01-07') OR WheelsOff IN (723, 720, 1320, 1552) ORDER BY FlightNum LIMIT 28"}
{"sql":"SELECT WheelsOff, OriginCityMarketID, OriginStateName FROM mytable WHERE DestStateFips BETWEEN 51 AND 6 OR ArrivalDelayGroups <= 1 OR OriginStateName BETWEEN 'California' AND 'New Hampshire' ORDER BY FlightNum, ArrTimeBlk LIMIT 14"}
{"sql":"SELECT TaxiOut, NASDelay FROM mytable LIMIT 6"}
{"sql":"SELECT DepTime, TaxiIn, DivArrDelay FROM mytable WHERE TailNum IN ('N17146', 'N540AA', 'N924WN') AND OriginStateName < 'Hawaii' OR OriginCityMarketID BETWEEN 32335 AND 30189 ORDER BY CRSElapsedTime LIMIT 9"}
{"sql":"SELECT CarrierDelay, AVG(LongestAddGTime) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 12","hsqls":["SELECT CarrierDelay, AVG(LongestAddGTime) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 12"]}
{"sql":"SELECT ArrTime, DivAirportIDs, CancellationCode FROM mytable ORDER BY OriginCityMarketID, ArrDel15 LIMIT 4","hsqls":["SELECT ArrTime, DivAirportIDs, CancellationCode FROM mytable ORDER BY OriginCityMarketID, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT TailNum, CRSDepTime, MAX(CRSElapsedTime) FROM mytable WHERE CRSDepTime IN (2053, 727, 2350, 857) GROUP BY TailNum, CRSDepTime  ORDER BY TailNum, CRSDepTime LIMIT 15","hsqls":["SELECT TailNum, CRSDepTime, MAX(CRSElapsedTime) FROM mytable WHERE CRSDepTime IN (2053, 727, 2350, 857) GROUP BY TailNum, CRSDepTime  ORDER BY TailNum, CRSDepTime LIMIT 15"]}
{"sql":"SELECT DivDistance, UniqueCarrier FROM mytable WHERE DayofMonth BETWEEN 18 AND 27 ORDER BY \"Year\", DaysSinceEpoch LIMIT 13","hsqls":["SELECT DivDistance, UniqueCarrier FROM mytable WHERE DayofMonth BETWEEN 18 AND 27 ORDER BY Year, DaysSinceEpoch LIMIT 13"]}
{"sql":"SELECT DistanceGroup, UniqueCarrier, DayOfWeek FROM mytable WHERE FirstDepTime NOT IN (1200, 1957, 1136, 1605) OR ArrivalDelayGroups BETWEEN 4 AND 8 AND Flights BETWEEN 1 AND 1 LIMIT 24"}
{"sql":"SELECT Diverted, DestStateName, DaysSinceEpoch FROM mytable WHERE DepDel15 BETWEEN 0 AND 1 AND CRSElapsedTime >= 57 OR FlightNum = 2718 LIMIT 4"}
{"sql":"SELECT COUNT(DepDel15), MIN(DepDelay), SUM(OriginCityMarketID) FROM mytable WHERE CRSDepTime < 955 OR DivWheelsOns <= 1911 OR OriginCityMarketID < 32575 LIMIT 1","hsqls":["SELECT COUNT(DepDel15), MIN(DepDelay), SUM(OriginCityMarketID)  FROM mytable WHERE CRSDepTime < 955 OR (DivWheelsOns[1] <= 1911 OR DivWheelsOns[2] <= 1911 OR DivWheelsOns[3] <= 1911 OR DivWheelsOns[4] <= 1911 OR DivWheelsOns[5] <= 1911) OR OriginCityMarketID < 32575 LIMIT 10000"]}
{"sql":"SELECT DivAirports, FlightNum, DepTimeBlk FROM mytable WHERE DepDel15 IN (1, 0, -9999) LIMIT 5","hsqls":["SELECT DivAirports, FlightNum, DepTimeBlk FROM mytable WHERE DepDel15 IN (1, 0, -9999) LIMIT 10000"]}
{"sql":"SELECT DestStateFips, ArrTimeBlk, ArrDelay, SUM(ArrivalDelayGroups), SUM(DivActualElapsedTime) FROM mytable WHERE CRSElapsedTime BETWEEN 505 AND 395 AND DivTotalGTimes > 201 GROUP BY DestStateFips, ArrTimeBlk, ArrDelay LIMIT 16","hsqls":["SELECT DestStateFips, ArrTimeBlk, ArrDelay, SUM(ArrivalDelayGroups), SUM(DivActualElapsedTime) FROM mytable WHERE CRSElapsedTime BETWEEN 505 AND 395 AND (DivTotalGTimes[1] > 201 OR DivTotalGTimes[2] > 201 OR DivTotalGTimes[3] > 201 OR DivTotalGTimes[4] > 201 OR DivTotalGTimes[5] > 201) GROUP BY DestStateFips, ArrTimeBlk, ArrDelay LIMIT 10000"]}
{"sql":"SELECT FlightNum, DivActualElapsedTime FROM mytable WHERE DivAirportLandings > 2 OR OriginCityMarketID IN (30279) AND OriginCityName BETWEEN 'Wilmington, NC' AND 'Saginaw/Bay City/Midland, MI' ORDER BY Flights LIMIT 5"}
{"sql":"SELECT TailNum, MIN(TotalAddGTime) FROM mytable WHERE TotalAddGTime BETWEEN 41 AND -9999 OR OriginWac < 86 OR \"Month\" NOT IN (1) GROUP BY TailNum LIMIT 12","hsqls":["SELECT TailNum, MIN(TotalAddGTime) FROM mytable WHERE TotalAddGTime BETWEEN 41 AND -9999 OR OriginWac < 86 OR `Month` NOT IN (1) GROUP BY TailNum LIMIT 12"]}
{"sql":"SELECT OriginStateFips, ArrTime, DayofMonth, MAX(WheelsOn) FROM mytable GROUP BY OriginStateFips, ArrTime, DayofMonth  ORDER BY OriginStateFips, ArrTime, DayofMonth LIMIT 2","hsqls":["SELECT OriginStateFips, ArrTime, DayofMonth, MAX(WheelsOn) FROM mytable GROUP BY OriginStateFips, ArrTime, DayofMonth  ORDER BY OriginStateFips, ArrTime, DayofMonth LIMIT 2"]}
{"sql":"SELECT CRSArrTime FROM mytable WHERE OriginCityName NOT IN ('Waco, TX') AND DaysSinceEpoch NOT IN (16098, 16077, 16076, 16091) OR CRSDepTime IN (1139, 1802, 956) LIMIT 10"}
{"sql":"SELECT DepDelay FROM mytable WHERE DepTime IN (1653, 1937, 2052, 707, 550) ORDER BY Carrier, DepTimeBlk LIMIT 20"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrivalDelayGroups >= 2 OR OriginStateName IN ('Mississippi', 'Idaho', 'Hawaii') AND DivDistance BETWEEN 302 AND 254 LIMIT 12"}
{"sql":"SELECT DestStateFips, ActualElapsedTime, MAX(OriginAirportSeqID), AVG(TaxiIn), SUM(TaxiIn) FROM mytable WHERE TaxiIn BETWEEN 65 AND 73 OR CRSElapsedTime NOT IN (81) AND FlightNum BETWEEN 908 AND 4512 GROUP BY DestStateFips, ActualElapsedTime  ORDER BY DestStateFips, ActualElapsedTime LIMIT 3","hsqls":["SELECT DestStateFips, ActualElapsedTime, MAX(OriginAirportSeqID), AVG(TaxiIn), SUM(TaxiIn) FROM mytable WHERE TaxiIn BETWEEN 65 AND 73 OR CRSElapsedTime NOT IN (81) AND FlightNum BETWEEN 908 AND 4512 GROUP BY DestStateFips, ActualElapsedTime  ORDER BY DestStateFips, ActualElapsedTime LIMIT 3"]}
{"sql":"SELECT DestAirportID, OriginStateName, COUNT(*) FROM mytable WHERE WheelsOn IN (230, 624, 1300) OR Cancelled = 0 AND DivLongestGTimes BETWEEN 34.0 AND 108.0 GROUP BY DestAirportID, OriginStateName LIMIT 20","hsqls":["SELECT DestAirportID, OriginStateName, COUNT(*) FROM mytable WHERE WheelsOn IN (230, 624, 1300) OR Cancelled = 0 AND (DivLongestGTimes[1] BETWEEN 34.0 AND 108.0 OR DivLongestGTimes[2] BETWEEN 34.0 AND 108.0 OR DivLongestGTimes[3] BETWEEN 34.0 AND 108.0 OR DivLongestGTimes[4] BETWEEN 34.0 AND 108.0 OR DivLongestGTimes[5] BETWEEN 34.0 AND 108.0) GROUP BY DestAirportID, OriginStateName LIMIT 10000"]}
{"sql":"SELECT TaxiOut, CRSArrTime, FlightNum FROM mytable WHERE FlightNum <= 1512 OR ArrDelay IN (245.0, -37.0) ORDER BY CRSArrTime LIMIT 7"}
{"sql":"SELECT DepartureDelayGroups, DepDelayMinutes, SUM(ArrivalDelayGroups) FROM mytable WHERE Distance IN (3302) GROUP BY DepartureDelayGroups, DepDelayMinutes  ORDER BY DepartureDelayGroups, DepDelayMinutes LIMIT 9","hsqls":["SELECT DepartureDelayGroups, DepDelayMinutes, SUM(ArrivalDelayGroups) FROM mytable WHERE Distance IN (3302) GROUP BY DepartureDelayGroups, DepDelayMinutes  ORDER BY DepartureDelayGroups, DepDelayMinutes LIMIT 9"]}
{"sql":"SELECT DestWac, ActualElapsedTime, CRSElapsedTime, AVG(ArrDel15), MIN(DivDistance) FROM mytable GROUP BY DestWac, ActualElapsedTime, CRSElapsedTime  ORDER BY DestWac, ActualElapsedTime, CRSElapsedTime LIMIT 7","hsqls":["SELECT DestWac, ActualElapsedTime, CRSElapsedTime, AVG(ArrDel15), MIN(DivDistance) FROM mytable GROUP BY DestWac, ActualElapsedTime, CRSElapsedTime  ORDER BY DestWac, ActualElapsedTime, CRSElapsedTime LIMIT 7"]}
{"sql":"SELECT DivReachedDest, DivTailNums FROM mytable WHERE DivAirportSeqIDs >= 1387102 AND DestStateFips NOT IN (21, 40, 23, 37, 75) AND DayOfWeek IN (3, 2, 6, 4) ORDER BY CRSDepTime, OriginStateName LIMIT 22","hsqls":["SELECT DivReachedDest, DivTailNums FROM mytable WHERE (DivAirportSeqIDs[1] >= 1387102 OR DivAirportSeqIDs[2] >= 1387102 OR DivAirportSeqIDs[3] >= 1387102 OR DivAirportSeqIDs[4] >= 1387102 OR DivAirportSeqIDs[5] >= 1387102) AND DestStateFips NOT IN (21, 40, 23, 37, 75) AND DayOfWeek IN (3, 2, 6, 4) ORDER BY CRSDepTime, OriginStateName LIMIT 10000"]}
{"sql":"SELECT Diverted, DivDistance, Quarter, MIN(OriginWac), AVG(DivActualElapsedTime) FROM mytable GROUP BY Diverted, DivDistance, Quarter  ORDER BY Diverted, DivDistance, Quarter LIMIT 10","hsqls":["SELECT Diverted, DivDistance, Quarter, MIN(OriginWac), AVG(DivActualElapsedTime) FROM mytable GROUP BY Diverted, DivDistance, Quarter  ORDER BY Diverted, DivDistance, Quarter LIMIT 10"]}
{"sql":"SELECT DepDelayMinutes, DestStateFips, FlightDate, MAX(TaxiIn), SUM(DivReachedDest) FROM mytable WHERE WheelsOn NOT IN (2309, 1824) GROUP BY DepDelayMinutes, DestStateFips, FlightDate  ORDER BY DepDelayMinutes, DestStateFips, FlightDate LIMIT 15","hsqls":["SELECT DepDelayMinutes, DestStateFips, FlightDate, MAX(TaxiIn), SUM(DivReachedDest) FROM mytable WHERE WheelsOn NOT IN (2309, 1824) GROUP BY DepDelayMinutes, DestStateFips, FlightDate  ORDER BY DepDelayMinutes, DestStateFips, FlightDate LIMIT 15"]}
{"sql":"SELECT DestCityMarketID FROM mytable ORDER BY DepDel15 LIMIT 17"}
{"sql":"SELECT Quarter, ArrDelayMinutes, AVG(WeatherDelay) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR LateAircraftDelay NOT IN (159) GROUP BY Quarter, ArrDelayMinutes  ORDER BY Quarter, ArrDelayMinutes LIMIT 12","hsqls":["SELECT Quarter, ArrDelayMinutes, AVG(WeatherDelay) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR LateAircraftDelay NOT IN (159) GROUP BY Quarter, ArrDelayMinutes  ORDER BY Quarter, ArrDelayMinutes LIMIT 12"]}
{"sql":"SELECT DestStateFips FROM mytable WHERE OriginStateFips BETWEEN 19 AND 40 OR OriginCityMarketID BETWEEN 30140 AND 31454 ORDER BY FirstDepTime, ArrivalDelayGroups LIMIT 11"}
{"sql":"SELECT DestCityMarketID FROM mytable WHERE ArrDelay <= -2.0 ORDER BY ArrTimeBlk LIMIT 10"}
{"sql":"SELECT TaxiOut, Flights, TotalAddGTime FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'B' AND DayofMonth IN (2, 4, 31, 16, 12) ORDER BY DivArrDelay LIMIT 24"}
{"sql":"SELECT DivWheelsOffs, Origin, DivArrDelay FROM mytable WHERE TaxiIn BETWEEN 55 AND 32 OR ArrivalDelayGroups NOT IN (7) OR ArrTime >= 2108 ORDER BY DestStateName, DivActualElapsedTime LIMIT 6","hsqls":["SELECT DivWheelsOffs, Origin, DivArrDelay FROM mytable WHERE TaxiIn BETWEEN 55 AND 32 OR ArrivalDelayGroups NOT IN (7) OR ArrTime >= 2108 ORDER BY DestStateName, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DepDelayMinutes, DayofMonth, SUM(DepartureDelayGroups) FROM mytable WHERE CarrierDelay BETWEEN 65 AND 27 GROUP BY WheelsOff, DepDelayMinutes, DayofMonth  ORDER BY WheelsOff, DepDelayMinutes, DayofMonth LIMIT 15","hsqls":["SELECT WheelsOff, DepDelayMinutes, DayofMonth, SUM(DepartureDelayGroups) FROM mytable WHERE CarrierDelay BETWEEN 65 AND 27 GROUP BY WheelsOff, DepDelayMinutes, DayofMonth  ORDER BY WheelsOff, DepDelayMinutes, DayofMonth LIMIT 15"]}
{"sql":"SELECT DepTimeBlk, WheelsOn, MIN(Flights) FROM mytable WHERE OriginCityMarketID NOT IN (31140, 32156, 31865, 34457) GROUP BY DepTimeBlk, WheelsOn  ORDER BY DepTimeBlk, WheelsOn LIMIT 9","hsqls":["SELECT DepTimeBlk, WheelsOn, MIN(Flights) FROM mytable WHERE OriginCityMarketID NOT IN (31140, 32156, 31865, 34457) GROUP BY DepTimeBlk, WheelsOn  ORDER BY DepTimeBlk, WheelsOn LIMIT 9"]}
{"sql":"SELECT WeatherDelay, ArrDelay, COUNT(*) FROM mytable WHERE DayOfWeek NOT IN (3, 4) OR ArrTime BETWEEN 1037 AND 17 GROUP BY WeatherDelay, ArrDelay  ORDER BY WeatherDelay, ArrDelay LIMIT 18","hsqls":["SELECT WeatherDelay, ArrDelay, COUNT(*) FROM mytable WHERE DayOfWeek NOT IN (3, 4) OR ArrTime BETWEEN 1037 AND 17 GROUP BY WeatherDelay, ArrDelay  ORDER BY WeatherDelay, ArrDelay LIMIT 18"]}
{"sql":"SELECT Diverted, OriginCityMarketID, DivArrDelay FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 OR DivWheelsOns > 1125 LIMIT 6","hsqls":["SELECT Diverted, OriginCityMarketID, DivArrDelay FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 OR (DivWheelsOns[1] > 1125 OR DivWheelsOns[2] > 1125 OR DivWheelsOns[3] > 1125 OR DivWheelsOns[4] > 1125 OR DivWheelsOns[5] > 1125) LIMIT 10000"]}
{"sql":"SELECT COUNT(CRSArrTime), COUNT(DepTime) FROM mytable WHERE OriginStateName = 'U.S. Pacific Trust Territories and Possessions' OR DepartureDelayGroups >= 8 LIMIT 20"}
{"sql":"SELECT OriginState, COUNT(*) FROM mytable WHERE DivWheelsOffs BETWEEN 1144 AND 1025 OR DestStateFips BETWEEN 56 AND 55 OR OriginCityMarketID BETWEEN 31049 AND 32402 GROUP BY OriginState LIMIT 7","hsqls":["SELECT OriginState, COUNT(*) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1144 AND 1025 OR DivWheelsOffs[2] BETWEEN 1144 AND 1025 OR DivWheelsOffs[3] BETWEEN 1144 AND 1025 OR DivWheelsOffs[4] BETWEEN 1144 AND 1025 OR DivWheelsOffs[5] BETWEEN 1144 AND 1025) OR DestStateFips BETWEEN 56 AND 55 OR OriginCityMarketID BETWEEN 31049 AND 32402 GROUP BY OriginState LIMIT 10000"]}
{"sql":"SELECT DivDistance FROM mytable WHERE CRSElapsedTime BETWEEN 570 AND 266 OR DepTimeBlk IN ('2000-2059', '1100-1159', '0700-0759') LIMIT 22"}
{"sql":"SELECT TotalAddGTime, DepTime, CancellationCode FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DivLongestGTimes > 97.0 AND DivAirportSeqIDs BETWEEN 1457402 AND 1025702 LIMIT 10","hsqls":["SELECT TotalAddGTime, DepTime, CancellationCode FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR (DivLongestGTimes[1] > 97.0 OR DivLongestGTimes[2] > 97.0 OR DivLongestGTimes[3] > 97.0 OR DivLongestGTimes[4] > 97.0 OR DivLongestGTimes[5] > 97.0) AND (DivAirportSeqIDs[1] BETWEEN 1457402 AND 1025702 OR DivAirportSeqIDs[2] BETWEEN 1457402 AND 1025702 OR DivAirportSeqIDs[3] BETWEEN 1457402 AND 1025702 OR DivAirportSeqIDs[4] BETWEEN 1457402 AND 1025702 OR DivAirportSeqIDs[5] BETWEEN 1457402 AND 1025702) LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, WheelsOn, DaysSinceEpoch, SUM(NASDelay), MAX(OriginCityMarketID), SUM(WheelsOff) FROM mytable GROUP BY OriginCityMarketID, WheelsOn, DaysSinceEpoch  ORDER BY OriginCityMarketID, WheelsOn, DaysSinceEpoch LIMIT 6","hsqls":["SELECT OriginCityMarketID, WheelsOn, DaysSinceEpoch, SUM(NASDelay), MAX(OriginCityMarketID), SUM(WheelsOff) FROM mytable GROUP BY OriginCityMarketID, WheelsOn, DaysSinceEpoch  ORDER BY OriginCityMarketID, WheelsOn, DaysSinceEpoch LIMIT 6"]}
{"sql":"SELECT ArrTimeBlk FROM mytable WHERE DestAirportSeqID IN (1484304, 1072102, 1348502, 1383002) OR OriginCityName BETWEEN 'Fort Lauderdale, FL' AND 'Minot, ND' OR Carrier > 'B6' LIMIT 24"}
{"sql":"SELECT CarrierDelay, DestStateFips, MIN(Quarter), COUNT(CancellationCode), AVG(DivActualElapsedTime) FROM mytable WHERE Cancelled BETWEEN 0 AND 1 OR DestState BETWEEN 'MI' AND 'CO' AND CancellationCode BETWEEN 'A' AND 'A' GROUP BY CarrierDelay, DestStateFips  ORDER BY CarrierDelay, DestStateFips LIMIT 9","hsqls":["SELECT CarrierDelay, DestStateFips, MIN(Quarter), COUNT(CancellationCode), AVG(DivActualElapsedTime) FROM mytable WHERE Cancelled BETWEEN 0 AND 1 OR DestState BETWEEN 'MI' AND 'CO' AND CancellationCode BETWEEN 'A' AND 'A' GROUP BY CarrierDelay, DestStateFips  ORDER BY CarrierDelay, DestStateFips LIMIT 9"]}
{"sql":"SELECT DestCityMarketID, OriginStateName FROM mytable ORDER BY DepTime, TaxiIn, DivAirportLandings LIMIT 11"}
{"sql":"SELECT ArrDelay, CRSElapsedTime, OriginAirportID, COUNT(DivAirportLandings) FROM mytable GROUP BY ArrDelay, CRSElapsedTime, OriginAirportID  ORDER BY ArrDelay, CRSElapsedTime, OriginAirportID LIMIT 19","hsqls":["SELECT ArrDelay, CRSElapsedTime, OriginAirportID, COUNT(DivAirportLandings) FROM mytable GROUP BY ArrDelay, CRSElapsedTime, OriginAirportID  ORDER BY ArrDelay, CRSElapsedTime, OriginAirportID LIMIT 19"]}
{"sql":"SELECT DepartureDelayGroups, CRSDepTime FROM mytable WHERE DivAirportSeqIDs <= 1474703 ORDER BY FlightNum, TailNum, OriginWac LIMIT 16","hsqls":["SELECT DepartureDelayGroups, CRSDepTime FROM mytable WHERE (DivAirportSeqIDs[1] <= 1474703 OR DivAirportSeqIDs[2] <= 1474703 OR DivAirportSeqIDs[3] <= 1474703 OR DivAirportSeqIDs[4] <= 1474703 OR DivAirportSeqIDs[5] <= 1474703) ORDER BY FlightNum, TailNum, OriginWac LIMIT 10000"]}
{"sql":"SELECT DepDelay, OriginStateFips, COUNT(*) FROM mytable WHERE OriginCityName BETWEEN 'Springfield, MO' AND 'Albuquerque, NM' AND Carrier BETWEEN 'DL' AND 'UA' AND LongestAddGTime IN (148, 103) GROUP BY DepDelay, OriginStateFips  ORDER BY DepDelay, OriginStateFips LIMIT 15","hsqls":["SELECT DepDelay, OriginStateFips, COUNT(*) FROM mytable WHERE OriginCityName BETWEEN 'Springfield, MO' AND 'Albuquerque, NM' AND Carrier BETWEEN 'DL' AND 'UA' AND LongestAddGTime IN (148, 103) GROUP BY DepDelay, OriginStateFips  ORDER BY DepDelay, OriginStateFips LIMIT 15"]}
{"sql":"SELECT CRSElapsedTime, COUNT(*) FROM mytable WHERE OriginCityMarketID NOT IN (34113, 32457, 30285, 30073, 32891) AND LongestAddGTime NOT IN (78, 30) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 6","hsqls":["SELECT CRSElapsedTime, COUNT(*) FROM mytable WHERE OriginCityMarketID NOT IN (34113, 32457, 30285, 30073, 32891) AND LongestAddGTime NOT IN (78, 30) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 6"]}
{"sql":"SELECT COUNT(TaxiIn), SUM(DivReachedDest) FROM mytable WHERE DestStateFips <= 23 OR Quarter NOT IN (1) LIMIT 23"}
{"sql":"SELECT DestAirportSeqID FROM mytable ORDER BY SecurityDelay LIMIT 21"}
{"sql":"SELECT TailNum, DivAirportIDs FROM mytable LIMIT 13","hsqls":["SELECT TailNum, DivAirportIDs FROM mytable LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, LongestAddGTime FROM mytable WHERE CRSElapsedTime BETWEEN 296 AND 311 ORDER BY DestStateName LIMIT 5"}
{"sql":"SELECT Cancelled FROM mytable WHERE WheelsOff BETWEEN 836 AND 2348 OR DepartureDelayGroups >= 3 ORDER BY SecurityDelay, TaxiIn, CRSDepTime LIMIT 26"}
{"sql":"SELECT OriginState, DestStateFips, CancellationCode FROM mytable WHERE WheelsOff <> 1434 LIMIT 1"}
{"sql":"SELECT DestState, COUNT(*) FROM mytable WHERE Flights <> 1 OR TotalAddGTime BETWEEN 4 AND 24 GROUP BY DestState  ORDER BY DestState LIMIT 19","hsqls":["SELECT DestState, COUNT(*) FROM mytable WHERE Flights <> 1 OR TotalAddGTime BETWEEN 4 AND 24 GROUP BY DestState  ORDER BY DestState LIMIT 19"]}
{"sql":"SELECT DestStateFips, DestCityMarketID, OriginAirportID, SUM(DivActualElapsedTime) FROM mytable WHERE OriginAirportSeqID >= 1504102 AND DepartureDelayGroups BETWEEN 4 AND 4 GROUP BY DestStateFips, DestCityMarketID, OriginAirportID  ORDER BY DestStateFips, DestCityMarketID, OriginAirportID LIMIT 13","hsqls":["SELECT DestStateFips, DestCityMarketID, OriginAirportID, SUM(DivActualElapsedTime) FROM mytable WHERE OriginAirportSeqID >= 1504102 AND DepartureDelayGroups BETWEEN 4 AND 4 GROUP BY DestStateFips, DestCityMarketID, OriginAirportID  ORDER BY DestStateFips, DestCityMarketID, OriginAirportID LIMIT 13"]}
{"sql":"SELECT UniqueCarrier, AVG(DayOfWeek), MAX(DivReachedDest), MAX(ActualElapsedTime) FROM mytable GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 29","hsqls":["SELECT UniqueCarrier, AVG(DayOfWeek), MAX(DivReachedDest), MAX(ActualElapsedTime) FROM mytable GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 29"]}
{"sql":"SELECT DepDelay, NASDelay, ArrivalDelayGroups, COUNT(ArrTimeBlk), MIN(TaxiOut) FROM mytable WHERE ArrDelayMinutes NOT IN (332.0, 98.0, 162.0, 134.0, 291.0) AND NASDelay NOT IN (234, 24, 34) GROUP BY DepDelay, NASDelay, ArrivalDelayGroups  ORDER BY DepDelay, NASDelay, ArrivalDelayGroups LIMIT 13","hsqls":["SELECT DepDelay, NASDelay, ArrivalDelayGroups, COUNT(ArrTimeBlk), MIN(TaxiOut) FROM mytable WHERE ArrDelayMinutes NOT IN (332.0, 98.0, 162.0, 134.0, 291.0) AND NASDelay NOT IN (234, 24, 34) GROUP BY DepDelay, NASDelay, ArrivalDelayGroups  ORDER BY DepDelay, NASDelay, ArrivalDelayGroups LIMIT 13"]}
{"sql":"SELECT DistanceGroup, DepDelayMinutes, SUM(Cancelled), MAX(DaysSinceEpoch), MIN(DayOfWeek) FROM mytable WHERE OriginCityMarketID <= 34492 GROUP BY DistanceGroup, DepDelayMinutes  ORDER BY DistanceGroup, DepDelayMinutes LIMIT 25","hsqls":["SELECT DistanceGroup, DepDelayMinutes, SUM(Cancelled), MAX(DaysSinceEpoch), MIN(DayOfWeek) FROM mytable WHERE OriginCityMarketID <= 34492 GROUP BY DistanceGroup, DepDelayMinutes  ORDER BY DistanceGroup, DepDelayMinutes LIMIT 25"]}
{"sql":"SELECT AVG(ActualElapsedTime), SUM(ArrTime) FROM mytable WHERE CRSElapsedTime IN (193) AND DivAirportIDs IN (13158, 13198) AND DistanceGroup BETWEEN 2 AND 1 LIMIT 12","hsqls":["SELECT AVG(ActualElapsedTime), SUM(ArrTime)  FROM mytable WHERE CRSElapsedTime IN (193) AND (DivAirportIDs[1] IN (13158, 13198) OR DivAirportIDs[2] IN (13158, 13198) OR DivAirportIDs[3] IN (13158, 13198) OR DivAirportIDs[4] IN (13158, 13198) OR DivAirportIDs[5] IN (13158, 13198)) AND DistanceGroup BETWEEN 2 AND 1 LIMIT 10000"]}
{"sql":"SELECT SUM(DepDel15), COUNT(ArrivalDelayGroups), MIN(ArrTime) FROM mytable WHERE WheelsOn BETWEEN 1009 AND 722 OR DestCityMarketID BETWEEN 31895 AND 32389 AND ArrTime = 1013 LIMIT 15"}
{"sql":"SELECT MIN(OriginCityMarketID) FROM mytable LIMIT 27"}
{"sql":"SELECT SecurityDelay, TaxiIn, DivActualElapsedTime FROM mytable WHERE CarrierDelay BETWEEN 21 AND 157 ORDER BY FlightDate, WheelsOn LIMIT 28"}
{"sql":"SELECT NASDelay, AirTime FROM mytable WHERE DepDelayMinutes BETWEEN 329.0 AND 419.0 AND CarrierDelay IN (139, 22, 243, 74) OR ArrDelayMinutes NOT IN (220.0, 185.0, 269.0, 174.0) ORDER BY Dest, DestCityMarketID LIMIT 22"}
{"sql":"SELECT ArrTime, DayofMonth, AirlineID FROM mytable WHERE TaxiOut NOT IN (22, 15) AND SecurityDelay BETWEEN 8 AND 4 ORDER BY ArrTime LIMIT 24"}
{"sql":"SELECT DestCityName, DaysSinceEpoch FROM mytable ORDER BY CarrierDelay, OriginAirportID, OriginStateName LIMIT 26"}
{"sql":"SELECT FirstDepTime, OriginCityName, ActualElapsedTime FROM mytable ORDER BY Carrier, TailNum, \"Month\" LIMIT 14","hsqls":["SELECT FirstDepTime, OriginCityName, ActualElapsedTime FROM mytable ORDER BY Carrier, TailNum, `Month` LIMIT 14"]}
{"sql":"SELECT COUNT(Carrier), MAX(DivReachedDest) FROM mytable WHERE DivLongestGTimes BETWEEN 14.0 AND 36.0 OR CRSDepTime < 832 LIMIT 3","hsqls":["SELECT COUNT(Carrier), MAX(DivReachedDest)  FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 14.0 AND 36.0 OR DivLongestGTimes[2] BETWEEN 14.0 AND 36.0 OR DivLongestGTimes[3] BETWEEN 14.0 AND 36.0 OR DivLongestGTimes[4] BETWEEN 14.0 AND 36.0 OR DivLongestGTimes[5] BETWEEN 14.0 AND 36.0) OR CRSDepTime < 832 LIMIT 10000"]}
{"sql":"SELECT CRSElapsedTime FROM mytable WHERE DivAirportIDs IN (15249, 10135, 11471, 10620, 11721) ORDER BY Flights LIMIT 17","hsqls":["SELECT CRSElapsedTime FROM mytable WHERE (DivAirportIDs[1] IN (15249, 10135, 11471, 10620, 11721) OR DivAirportIDs[2] IN (15249, 10135, 11471, 10620, 11721) OR DivAirportIDs[3] IN (15249, 10135, 11471, 10620, 11721) OR DivAirportIDs[4] IN (15249, 10135, 11471, 10620, 11721) OR DivAirportIDs[5] IN (15249, 10135, 11471, 10620, 11721)) ORDER BY Flights LIMIT 10000"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE TaxiOut NOT IN (55) OR Distance NOT IN (985) OR OriginCityMarketID >= 31041 ORDER BY DestWac, DestStateName, OriginStateName LIMIT 28"}
{"sql":"SELECT DivAirports, OriginStateFips, DestCityMarketID FROM mytable ORDER BY Dest LIMIT 28","hsqls":["SELECT DivAirports, OriginStateFips, DestCityMarketID FROM mytable ORDER BY Dest LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime FROM mytable WHERE DivDistance >= 277 ORDER BY DepTime, DestAirportSeqID, DayOfWeek LIMIT 10"}
{"sql":"SELECT Origin FROM mytable WHERE SecurityDelay BETWEEN 0 AND 14 OR DestAirportID BETWEEN 10781 AND 11503 ORDER BY Dest LIMIT 5"}
{"sql":"SELECT Flights, OriginStateName, MIN(DepDelayMinutes), COUNT(DestState) FROM mytable GROUP BY Flights, OriginStateName  ORDER BY Flights, OriginStateName LIMIT 16","hsqls":["SELECT Flights, OriginStateName, MIN(DepDelayMinutes), COUNT(DestState) FROM mytable GROUP BY Flights, OriginStateName  ORDER BY Flights, OriginStateName LIMIT 16"]}
{"sql":"SELECT Carrier, DivActualElapsedTime, CRSElapsedTime FROM mytable WHERE DestCityName BETWEEN 'Newark, NJ' AND 'Augusta, GA' ORDER BY ArrDelay LIMIT 14"}
{"sql":"SELECT TaxiOut, DivTailNums, AirlineID FROM mytable WHERE CancellationCode = 'B' ORDER BY ArrTimeBlk LIMIT 5","hsqls":["SELECT TaxiOut, DivTailNums, AirlineID FROM mytable WHERE CancellationCode = 'B' ORDER BY ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT FirstDepTime FROM mytable ORDER BY DivDistance, LongestAddGTime, DepTime LIMIT 16"}
{"sql":"SELECT ArrTime, DepDel15, DivArrDelay FROM mytable LIMIT 19"}
{"sql":"SELECT Flights, ArrDelayMinutes, DivWheelsOffs FROM mytable WHERE DivAirportLandings BETWEEN 9 AND 0 ORDER BY Flights, DestCityMarketID, DayofMonth LIMIT 24","hsqls":["SELECT Flights, ArrDelayMinutes, DivWheelsOffs FROM mytable WHERE DivAirportLandings BETWEEN 9 AND 0 ORDER BY Flights, DestCityMarketID, DayofMonth LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, DestState, MAX(DestAirportID), MAX(TaxiIn) FROM mytable GROUP BY DepartureDelayGroups, DestState  ORDER BY DepartureDelayGroups, DestState LIMIT 14","hsqls":["SELECT DepartureDelayGroups, DestState, MAX(DestAirportID), MAX(TaxiIn) FROM mytable GROUP BY DepartureDelayGroups, DestState  ORDER BY DepartureDelayGroups, DestState LIMIT 14"]}
{"sql":"SELECT Diverted, DepDelay, DestStateFips FROM mytable WHERE TailNum NOT IN ('N757AT', 'N552NW', 'N755SK') ORDER BY FirstDepTime, DepTime LIMIT 13"}
{"sql":"SELECT CarrierDelay, SUM(Cancelled) FROM mytable WHERE SecurityDelay < 14 OR CancellationCode NOT IN ('C') AND ArrTimeBlk BETWEEN '1800-1859' AND '1500-1559' GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 4","hsqls":["SELECT CarrierDelay, SUM(Cancelled) FROM mytable WHERE SecurityDelay < 14 OR CancellationCode NOT IN ('C') AND ArrTimeBlk BETWEEN '1800-1859' AND '1500-1559' GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 4"]}
{"sql":"SELECT ArrDelay FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 OR OriginState NOT IN ('NV', 'VA', 'AR', 'MA', 'AL') ORDER BY OriginAirportSeqID, CRSArrTime LIMIT 10","hsqls":["SELECT ArrDelay FROM mytable WHERE `Month` BETWEEN 1 AND 1 OR OriginState NOT IN ('NV', 'VA', 'AR', 'MA', 'AL') ORDER BY OriginAirportSeqID, CRSArrTime LIMIT 10"]}
{"sql":"SELECT DivAirportSeqIDs FROM mytable WHERE OriginStateName >= 'Alaska' ORDER BY DestStateFips, Distance, CRSDepTime LIMIT 4","hsqls":["SELECT DivAirportSeqIDs FROM mytable WHERE OriginStateName >= 'Alaska' ORDER BY DestStateFips, Distance, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT Dest, OriginAirportID, MIN(Quarter), COUNT(DestCityName), MIN(DepTime) FROM mytable WHERE Distance IN (2358, 2434, 642, 1066) AND OriginCityName >= 'Ketchikan, AK' GROUP BY Dest, OriginAirportID  ORDER BY Dest, OriginAirportID LIMIT 28","hsqls":["SELECT Dest, OriginAirportID, MIN(Quarter), COUNT(DestCityName), MIN(DepTime) FROM mytable WHERE Distance IN (2358, 2434, 642, 1066) AND OriginCityName >= 'Ketchikan, AK' GROUP BY Dest, OriginAirportID  ORDER BY Dest, OriginAirportID LIMIT 28"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE DivAirports >= 'ONT' OR ArrivalDelayGroups BETWEEN 1 AND 3 OR DivAirportIDs IN (11066) ORDER BY DivReachedDest, Carrier, OriginWac LIMIT 7","hsqls":["SELECT DivAirportLandings FROM mytable WHERE (DivAirports[1] >= 'ONT' OR DivAirports[2] >= 'ONT' OR DivAirports[3] >= 'ONT' OR DivAirports[4] >= 'ONT' OR DivAirports[5] >= 'ONT') OR ArrivalDelayGroups BETWEEN 1 AND 3 OR (DivAirportIDs[1] IN (11066) OR DivAirportIDs[2] IN (11066) OR DivAirportIDs[3] IN (11066) OR DivAirportIDs[4] IN (11066) OR DivAirportIDs[5] IN (11066)) ORDER BY DivReachedDest, Carrier, OriginWac LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, ArrivalDelayGroups, SUM(DestAirportSeqID), MAX(DestCityMarketID) FROM mytable WHERE UniqueCarrier NOT IN ('EV', 'DL', 'AA', 'VX') OR DivLongestGTimes > 108.0 OR NASDelay BETWEEN 13 AND 14 GROUP BY LateAircraftDelay, ArrivalDelayGroups LIMIT 8","hsqls":["SELECT LateAircraftDelay, ArrivalDelayGroups, SUM(DestAirportSeqID), MAX(DestCityMarketID) FROM mytable WHERE UniqueCarrier NOT IN ('EV', 'DL', 'AA', 'VX') OR (DivLongestGTimes[1] > 108.0 OR DivLongestGTimes[2] > 108.0 OR DivLongestGTimes[3] > 108.0 OR DivLongestGTimes[4] > 108.0 OR DivLongestGTimes[5] > 108.0) OR NASDelay BETWEEN 13 AND 14 GROUP BY LateAircraftDelay, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime FROM mytable ORDER BY AirlineID, CRSElapsedTime"}
{"sql":"SELECT DestStateName, DestAirportID, OriginStateName, MIN(SecurityDelay), MIN(DivArrDelay), SUM(DepDelay) FROM mytable GROUP BY DestStateName, DestAirportID, OriginStateName","hsqls":["SELECT DestStateName, DestAirportID, OriginStateName, MIN(SecurityDelay), MIN(DivArrDelay), SUM(DepDelay) FROM mytable GROUP BY DestStateName, DestAirportID, OriginStateName"]}
{"sql":"SELECT Flights, TotalAddGTime, DestAirportID FROM mytable WHERE CRSElapsedTime NOT IN (190) OR DivArrDelay > 944 ORDER BY Diverted, DestWac LIMIT 13"}
{"sql":"SELECT OriginState, DestState FROM mytable ORDER BY CarrierDelay, Distance LIMIT 7"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivTotalGTimes BETWEEN 64 AND 2 OR TaxiIn <= 32 AND DistanceGroup <> 8 LIMIT 5","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 64 AND 2 OR DivTotalGTimes[2] BETWEEN 64 AND 2 OR DivTotalGTimes[3] BETWEEN 64 AND 2 OR DivTotalGTimes[4] BETWEEN 64 AND 2 OR DivTotalGTimes[5] BETWEEN 64 AND 2) OR TaxiIn <= 32 AND DistanceGroup <> 8 LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, MAX(LongestAddGTime) FROM mytable GROUP BY WeatherDelay  ORDER BY WeatherDelay LIMIT 12","hsqls":["SELECT WeatherDelay, MAX(LongestAddGTime) FROM mytable GROUP BY WeatherDelay  ORDER BY WeatherDelay LIMIT 12"]}
{"sql":"SELECT DestWac, TailNum FROM mytable ORDER BY DepTime, DestAirportSeqID LIMIT 4"}
{"sql":"SELECT ArrTime, MIN(FlightNum) FROM mytable WHERE DepDelay = 134.0 GROUP BY ArrTime  ORDER BY ArrTime LIMIT 28","hsqls":["SELECT ArrTime, MIN(FlightNum) FROM mytable WHERE DepDelay = 134.0 GROUP BY ArrTime  ORDER BY ArrTime LIMIT 28"]}
{"sql":"SELECT OriginWac, SUM(DivAirportLandings), MAX(TaxiIn), MAX(OriginAirportID) FROM mytable GROUP BY OriginWac  ORDER BY OriginWac LIMIT 21","hsqls":["SELECT OriginWac, SUM(DivAirportLandings), MAX(TaxiIn), MAX(OriginAirportID) FROM mytable GROUP BY OriginWac  ORDER BY OriginWac LIMIT 21"]}
{"sql":"SELECT OriginState, COUNT(DaysSinceEpoch), MIN(DestStateFips) FROM mytable WHERE UniqueCarrier >= 'DL' GROUP BY OriginState  ORDER BY OriginState LIMIT 17","hsqls":["SELECT OriginState, COUNT(DaysSinceEpoch), MIN(DestStateFips) FROM mytable WHERE UniqueCarrier >= 'DL' GROUP BY OriginState  ORDER BY OriginState LIMIT 17"]}
{"sql":"SELECT NASDelay, MAX(Flights), SUM(DepartureDelayGroups) FROM mytable WHERE DestState BETWEEN 'CT' AND 'HI' AND ArrDelayMinutes IN (155.0, 218.0, 343.0) AND DivArrDelay <> 167 GROUP BY NASDelay  ORDER BY NASDelay LIMIT 13","hsqls":["SELECT NASDelay, MAX(Flights), SUM(DepartureDelayGroups) FROM mytable WHERE DestState BETWEEN 'CT' AND 'HI' AND ArrDelayMinutes IN (155.0, 218.0, 343.0) AND DivArrDelay <> 167 GROUP BY NASDelay  ORDER BY NASDelay LIMIT 13"]}
{"sql":"SELECT AirlineID, SUM(\"Month\"), SUM(DepDelayMinutes), MAX(FlightNum) FROM mytable WHERE DivAirportIDs BETWEEN 12448 AND 12448 OR DepDelayMinutes IN (220.0, 118.0, 247.0, 304.0, 54.0) AND DivArrDelay <= 1651 GROUP BY AirlineID LIMIT 6","hsqls":["SELECT AirlineID, SUM(`Month`), SUM(DepDelayMinutes), MAX(FlightNum) FROM mytable WHERE (DivAirportIDs[1] BETWEEN 12448 AND 12448 OR DivAirportIDs[2] BETWEEN 12448 AND 12448 OR DivAirportIDs[3] BETWEEN 12448 AND 12448 OR DivAirportIDs[4] BETWEEN 12448 AND 12448 OR DivAirportIDs[5] BETWEEN 12448 AND 12448) OR DepDelayMinutes IN (220.0, 118.0, 247.0, 304.0, 54.0) AND DivArrDelay <= 1651 GROUP BY AirlineID LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, SUM(AirTime), MAX(DestCityMarketID), MIN(AirlineID) FROM mytable GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 16","hsqls":["SELECT OriginCityMarketID, SUM(AirTime), MAX(DestCityMarketID), MIN(AirlineID) FROM mytable GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 16"]}
{"sql":"SELECT WeatherDelay, OriginCityName, ArrivalDelayGroups FROM mytable ORDER BY Carrier LIMIT 23"}
{"sql":"SELECT FlightDate, AVG(\"Month\"), SUM(WheelsOn), MAX(ArrivalDelayGroups) FROM mytable WHERE DepTime BETWEEN 1432 AND 1333 OR DestCityMarketID > 31481 GROUP BY FlightDate LIMIT 29","hsqls":["SELECT FlightDate, AVG(`Month`), SUM(WheelsOn), MAX(ArrivalDelayGroups) FROM mytable WHERE DepTime BETWEEN 1432 AND 1333 OR DestCityMarketID > 31481 GROUP BY FlightDate LIMIT 29"]}
{"sql":"SELECT DivDistance, OriginWac, MAX(NASDelay), SUM(\"Year\"), MIN(CarrierDelay) FROM mytable WHERE OriginStateName NOT IN ('Louisiana', 'Iowa', 'South Dakota', 'Nevada', 'Washington') GROUP BY DivDistance, OriginWac LIMIT 9","hsqls":["SELECT DivDistance, OriginWac, MAX(NASDelay), SUM(`Year`), MIN(CarrierDelay) FROM mytable WHERE OriginStateName NOT IN ('Louisiana', 'Iowa', 'South Dakota', 'Nevada', 'Washington') GROUP BY DivDistance, OriginWac LIMIT 9"]}
{"sql":"SELECT Diverted, FirstDepTime, DivDistance FROM mytable WHERE OriginCityMarketID <= 32523 OR DivAirportSeqIDs >= 1393102 OR DepTimeBlk BETWEEN '1200-1259' AND '1800-1859' ORDER BY DivReachedDest, DepDelayMinutes, CarrierDelay LIMIT 21","hsqls":["SELECT Diverted, FirstDepTime, DivDistance FROM mytable WHERE OriginCityMarketID <= 32523 OR (DivAirportSeqIDs[1] >= 1393102 OR DivAirportSeqIDs[2] >= 1393102 OR DivAirportSeqIDs[3] >= 1393102 OR DivAirportSeqIDs[4] >= 1393102 OR DivAirportSeqIDs[5] >= 1393102) OR DepTimeBlk BETWEEN '1200-1259' AND '1800-1859' ORDER BY DivReachedDest, DepDelayMinutes, CarrierDelay LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DivAirports BETWEEN 'RDM' AND 'PSC' AND DivLongestGTimes = 44.0 GROUP BY DestAirportSeqID, DivActualElapsedTime LIMIT 8","hsqls":["SELECT DestAirportSeqID, DivActualElapsedTime, COUNT(*) FROM mytable WHERE (DivAirports[1] BETWEEN 'RDM' AND 'PSC' OR DivAirports[2] BETWEEN 'RDM' AND 'PSC' OR DivAirports[3] BETWEEN 'RDM' AND 'PSC' OR DivAirports[4] BETWEEN 'RDM' AND 'PSC' OR DivAirports[5] BETWEEN 'RDM' AND 'PSC') AND (DivLongestGTimes[1] = 44.0 OR DivLongestGTimes[2] = 44.0 OR DivLongestGTimes[3] = 44.0 OR DivLongestGTimes[4] = 44.0 OR DivLongestGTimes[5] = 44.0) GROUP BY DestAirportSeqID, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DivAirportLandings, AVG(\"Month\"), MAX(DivArrDelay) FROM mytable WHERE WheelsOn BETWEEN 1228 AND 1920 OR Cancelled <> 0 GROUP BY DivAirportLandings LIMIT 23","hsqls":["SELECT DivAirportLandings, AVG(`Month`), MAX(DivArrDelay) FROM mytable WHERE WheelsOn BETWEEN 1228 AND 1920 OR Cancelled <> 0 GROUP BY DivAirportLandings LIMIT 23"]}
{"sql":"SELECT FlightNum, ArrTime, COUNT(AirTime), AVG(DivArrDelay), COUNT(CancellationCode) FROM mytable WHERE DestStateName BETWEEN 'Ohio' AND 'South Carolina' AND \"Year\" < 2014 GROUP BY FlightNum, ArrTime","hsqls":["SELECT FlightNum, ArrTime, COUNT(AirTime), AVG(DivArrDelay), COUNT(CancellationCode) FROM mytable WHERE DestStateName BETWEEN 'Ohio' AND 'South Carolina' AND `Year` < 2014 GROUP BY FlightNum, ArrTime"]}
{"sql":"SELECT DepTime, DepTimeBlk, CRSElapsedTime, MAX(OriginAirportSeqID), COUNT(FirstDepTime), COUNT(ArrDelay) FROM mytable GROUP BY DepTime, DepTimeBlk, CRSElapsedTime  ORDER BY DepTime, DepTimeBlk, CRSElapsedTime LIMIT 29","hsqls":["SELECT DepTime, DepTimeBlk, CRSElapsedTime, MAX(OriginAirportSeqID), COUNT(FirstDepTime), COUNT(ArrDelay) FROM mytable GROUP BY DepTime, DepTimeBlk, CRSElapsedTime  ORDER BY DepTime, DepTimeBlk, CRSElapsedTime LIMIT 29"]}
{"sql":"SELECT OriginAirportSeqID FROM mytable WHERE DestCityMarketID <= 31834 AND CRSDepTime IN (654) ORDER BY Quarter, ArrDel15, OriginStateName LIMIT 10"}
{"sql":"SELECT DepDelayMinutes, DivWheelsOffs, CancellationCode FROM mytable WHERE DepDelay BETWEEN -13.0 AND 188.0 AND DivActualElapsedTime < 322 OR TaxiOut BETWEEN 57 AND 37 ORDER BY CRSDepTime, \"Month\"","hsqls":["SELECT DepDelayMinutes, DivWheelsOffs, CancellationCode FROM mytable WHERE DepDelay BETWEEN -13.0 AND 188.0 AND DivActualElapsedTime < 322 OR TaxiOut BETWEEN 57 AND 37 ORDER BY CRSDepTime, `Month` LIMIT 10000"]}
{"sql":"SELECT Quarter, DepTime, DestCityMarketID, COUNT(DepDelay), COUNT(TaxiIn) FROM mytable WHERE DestAirportSeqID BETWEEN 1385103 AND 1291503 AND \"Year\" BETWEEN 2014 AND 2014 GROUP BY Quarter, DepTime, DestCityMarketID LIMIT 25","hsqls":["SELECT Quarter, DepTime, DestCityMarketID, COUNT(DepDelay), COUNT(TaxiIn) FROM mytable WHERE DestAirportSeqID BETWEEN 1385103 AND 1291503 AND `Year` BETWEEN 2014 AND 2014 GROUP BY Quarter, DepTime, DestCityMarketID LIMIT 25"]}
{"sql":"SELECT DepDelayMinutes, TailNum, DaysSinceEpoch, SUM(Diverted), MAX(DestCityMarketID), MAX(ActualElapsedTime) FROM mytable WHERE Carrier IN ('F9', 'HA', 'AA') AND DestAirportSeqID <> 1298202 GROUP BY DepDelayMinutes, TailNum, DaysSinceEpoch  ORDER BY DepDelayMinutes, TailNum, DaysSinceEpoch LIMIT 4","hsqls":["SELECT DepDelayMinutes, TailNum, DaysSinceEpoch, SUM(Diverted), MAX(DestCityMarketID), MAX(ActualElapsedTime) FROM mytable WHERE Carrier IN ('F9', 'HA', 'AA') AND DestAirportSeqID <> 1298202 GROUP BY DepDelayMinutes, TailNum, DaysSinceEpoch  ORDER BY DepDelayMinutes, TailNum, DaysSinceEpoch LIMIT 4"]}
{"sql":"SELECT ArrivalDelayGroups, MIN(LateAircraftDelay), MIN(NASDelay), SUM(Quarter) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 20","hsqls":["SELECT ArrivalDelayGroups, MIN(LateAircraftDelay), MIN(NASDelay), SUM(Quarter) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 20"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE CarrierDelay NOT IN (144, 153, 199, 62, 87) OR Carrier IN ('WN', 'OO') LIMIT 3"}
{"sql":"SELECT Carrier, OriginAirportID FROM mytable WHERE CRSElapsedTime <= 90 OR DestCityMarketID = 30980 LIMIT 13"}
{"sql":"SELECT TaxiOut, DistanceGroup FROM mytable WHERE TailNum BETWEEN 'N557AS' AND 'N3748Y' ORDER BY Dest, DestStateName, DepTimeBlk LIMIT 8"}
{"sql":"SELECT LateAircraftDelay, OriginAirportID, MIN(FirstDepTime) FROM mytable WHERE OriginStateFips NOT IN (47, 24) OR OriginState <= 'AZ' GROUP BY LateAircraftDelay, OriginAirportID  ORDER BY LateAircraftDelay, OriginAirportID LIMIT 12","hsqls":["SELECT LateAircraftDelay, OriginAirportID, MIN(FirstDepTime) FROM mytable WHERE OriginStateFips NOT IN (47, 24) OR OriginState <= 'AZ' GROUP BY LateAircraftDelay, OriginAirportID  ORDER BY LateAircraftDelay, OriginAirportID LIMIT 12"]}
{"sql":"SELECT AirTime, CancellationCode FROM mytable WHERE Diverted IN (1, 0) ORDER BY OriginCityMarketID LIMIT 21"}
{"sql":"SELECT FlightNum, COUNT(*) FROM mytable GROUP BY FlightNum  ORDER BY FlightNum LIMIT 1","hsqls":["SELECT FlightNum, COUNT(*) FROM mytable GROUP BY FlightNum  ORDER BY FlightNum LIMIT 1"]}
{"sql":"SELECT CarrierDelay, DestCityName, DivActualElapsedTime FROM mytable WHERE Cancelled BETWEEN 1 AND 1 OR TailNum BETWEEN 'N16732' AND 'N3BJAA' LIMIT 9"}
{"sql":"SELECT TotalAddGTime, ActualElapsedTime, DestStateName, AVG(LateAircraftDelay), SUM(DayOfWeek) FROM mytable GROUP BY TotalAddGTime, ActualElapsedTime, DestStateName  ORDER BY TotalAddGTime, ActualElapsedTime, DestStateName LIMIT 5","hsqls":["SELECT TotalAddGTime, ActualElapsedTime, DestStateName, AVG(LateAircraftDelay), SUM(DayOfWeek) FROM mytable GROUP BY TotalAddGTime, ActualElapsedTime, DestStateName  ORDER BY TotalAddGTime, ActualElapsedTime, DestStateName LIMIT 5"]}
{"sql":"SELECT FlightNum, COUNT(*) FROM mytable GROUP BY FlightNum  ORDER BY FlightNum LIMIT 2","hsqls":["SELECT FlightNum, COUNT(*) FROM mytable GROUP BY FlightNum  ORDER BY FlightNum LIMIT 2"]}
{"sql":"SELECT TotalAddGTime, DepDel15 FROM mytable WHERE CRSElapsedTime NOT IN (349, 183, 356, 41, 315) OR TaxiOut BETWEEN 78 AND 25 ORDER BY CancellationCode, DivArrDelay LIMIT 13"}
{"sql":"SELECT DivWheelsOffs, ArrDelay, UniqueCarrier FROM mytable WHERE OriginState NOT IN ('GA', 'NC', 'SD', 'IL', 'KY') OR DepartureDelayGroups <= 1 OR DepDelay <= 104.0 ORDER BY TaxiOut LIMIT 13","hsqls":["SELECT DivWheelsOffs, ArrDelay, UniqueCarrier FROM mytable WHERE OriginState NOT IN ('GA', 'NC', 'SD', 'IL', 'KY') OR DepartureDelayGroups <= 1 OR DepDelay <= 104.0 ORDER BY TaxiOut LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, ArrDel15, ArrDelay, MIN(DepDelayMinutes), SUM(DepDel15), MIN(ArrDelayMinutes) FROM mytable WHERE OriginStateFips BETWEEN 32 AND 53 OR DivAirportIDs >= 13303 GROUP BY SecurityDelay, ArrDel15, ArrDelay LIMIT 19","hsqls":["SELECT SecurityDelay, ArrDel15, ArrDelay, MIN(DepDelayMinutes), SUM(DepDel15), MIN(ArrDelayMinutes) FROM mytable WHERE OriginStateFips BETWEEN 32 AND 53 OR (DivAirportIDs[1] >= 13303 OR DivAirportIDs[2] >= 13303 OR DivAirportIDs[3] >= 13303 OR DivAirportIDs[4] >= 13303 OR DivAirportIDs[5] >= 13303) GROUP BY SecurityDelay, ArrDel15, ArrDelay LIMIT 10000"]}
{"sql":"SELECT Quarter, ArrDelayMinutes, ArrDelay, AVG(DivActualElapsedTime) FROM mytable WHERE ArrTimeBlk <= '0600-0659' GROUP BY Quarter, ArrDelayMinutes, ArrDelay  ORDER BY Quarter, ArrDelayMinutes, ArrDelay LIMIT 28","hsqls":["SELECT Quarter, ArrDelayMinutes, ArrDelay, AVG(DivActualElapsedTime) FROM mytable WHERE ArrTimeBlk <= '0600-0659' GROUP BY Quarter, ArrDelayMinutes, ArrDelay  ORDER BY Quarter, ArrDelayMinutes, ArrDelay LIMIT 28"]}
{"sql":"SELECT TailNum, ArrDelay, AVG(NASDelay), COUNT(DayOfWeek), MIN(CarrierDelay) FROM mytable WHERE TaxiIn NOT IN (31, 18, 73, 11) GROUP BY TailNum, ArrDelay  ORDER BY TailNum, ArrDelay LIMIT 12","hsqls":["SELECT TailNum, ArrDelay, AVG(NASDelay), COUNT(DayOfWeek), MIN(CarrierDelay) FROM mytable WHERE TaxiIn NOT IN (31, 18, 73, 11) GROUP BY TailNum, ArrDelay  ORDER BY TailNum, ArrDelay LIMIT 12"]}
{"sql":"SELECT WheelsOff, ArrTimeBlk, OriginStateName FROM mytable WHERE DepDel15 NOT IN (0) AND DayofMonth BETWEEN 20 AND 14 ORDER BY Diverted, SecurityDelay, ArrDelayMinutes LIMIT 14"}
{"sql":"SELECT Origin, DaysSinceEpoch FROM mytable WHERE ArrDelay IN (12.0, 60.0, 148.0) AND DivReachedDest IN (-9999) LIMIT 10"}
{"sql":"SELECT DivAirportSeqIDs, DivAirportIDs FROM mytable WHERE OriginAirportSeqID NOT IN (1457604, 1357702, 1349503, 1014602, 1212903) OR FlightNum BETWEEN 1994 AND 2164 OR LateAircraftDelay >= 90 ORDER BY DestState, FlightDate LIMIT 28","hsqls":["SELECT DivAirportSeqIDs, DivAirportIDs FROM mytable WHERE OriginAirportSeqID NOT IN (1457604, 1357702, 1349503, 1014602, 1212903) OR FlightNum BETWEEN 1994 AND 2164 OR LateAircraftDelay >= 90 ORDER BY DestState, FlightDate LIMIT 10000"]}
{"sql":"SELECT TaxiIn FROM mytable WHERE DaysSinceEpoch IN (16101, 16099, 16092, 16079) OR ArrDel15 BETWEEN -9999 AND 1 OR NASDelay NOT IN (185, 92, 305, 26, 130) ORDER BY DivReachedDest, ArrDelay LIMIT 17"}
{"sql":"SELECT DepDelay, NASDelay, AVG(NASDelay), MIN(TotalAddGTime), MIN(FirstDepTime) FROM mytable GROUP BY DepDelay, NASDelay  ORDER BY DepDelay, NASDelay LIMIT 2","hsqls":["SELECT DepDelay, NASDelay, AVG(NASDelay), MIN(TotalAddGTime), MIN(FirstDepTime) FROM mytable GROUP BY DepDelay, NASDelay  ORDER BY DepDelay, NASDelay LIMIT 2"]}
{"sql":"SELECT DivReachedDest, Diverted, AVG(ArrDel15) FROM mytable WHERE FlightDate IN ('2014-01-09') GROUP BY DivReachedDest, Diverted  ORDER BY DivReachedDest, Diverted LIMIT 5","hsqls":["SELECT DivReachedDest, Diverted, AVG(ArrDel15) FROM mytable WHERE FlightDate IN ('2014-01-09') GROUP BY DivReachedDest, Diverted  ORDER BY DivReachedDest, Diverted LIMIT 5"]}
{"sql":"SELECT TotalAddGTime, CRSDepTime, CRSElapsedTime FROM mytable WHERE DivDistance <> 198 AND DivTailNums IN ('N12564') AND SecurityDelay BETWEEN 14 AND -9999 ORDER BY OriginCityMarketID, TotalAddGTime LIMIT 3","hsqls":["SELECT TotalAddGTime, CRSDepTime, CRSElapsedTime FROM mytable WHERE DivDistance <> 198 AND (DivTailNums[1] IN ('N12564') OR DivTailNums[2] IN ('N12564') OR DivTailNums[3] IN ('N12564') OR DivTailNums[4] IN ('N12564') OR DivTailNums[5] IN ('N12564')) AND SecurityDelay BETWEEN 14 AND -9999 ORDER BY OriginCityMarketID, TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT TailNum, CancellationCode FROM mytable LIMIT 29"}
{"sql":"SELECT OriginAirportID, SUM(Diverted) FROM mytable WHERE OriginCityMarketID <> 32337 AND DepDel15 BETWEEN 1 AND -9999 GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 15","hsqls":["SELECT OriginAirportID, SUM(Diverted) FROM mytable WHERE OriginCityMarketID <> 32337 AND DepDel15 BETWEEN 1 AND -9999 GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 15"]}
{"sql":"SELECT OriginWac, SUM(Diverted), AVG(Quarter) FROM mytable GROUP BY OriginWac  ORDER BY OriginWac LIMIT 5","hsqls":["SELECT OriginWac, SUM(Diverted), AVG(Quarter) FROM mytable GROUP BY OriginWac  ORDER BY OriginWac LIMIT 5"]}
{"sql":"SELECT DivLongestGTimes, AirTime FROM mytable WHERE FlightDate BETWEEN '2014-01-21' AND '2014-01-16' AND CancellationCode <= 'C' AND DepDel15 NOT IN (1, -9999) ORDER BY ArrTime, DestStateName, ArrDel15 LIMIT 2","hsqls":["SELECT DivLongestGTimes, AirTime FROM mytable WHERE FlightDate BETWEEN '2014-01-21' AND '2014-01-16' AND CancellationCode <= 'C' AND DepDel15 NOT IN (1, -9999) ORDER BY ArrTime, DestStateName, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT Carrier, CRSArrTime, UniqueCarrier FROM mytable WHERE DestStateName BETWEEN 'Nebraska' AND 'Illinois' OR DayOfWeek > 3 ORDER BY DivArrDelay LIMIT 20"}
{"sql":"SELECT DivReachedDest, Carrier, WeatherDelay FROM mytable WHERE Cancelled BETWEEN 0 AND 0 AND UniqueCarrier IN ('EV', 'US', 'AS', 'AA') AND LateAircraftDelay BETWEEN 52 AND 151 ORDER BY DestCityName, OriginWac LIMIT 10"}
{"sql":"SELECT \"Year\", Quarter, DestState, COUNT(ArrTimeBlk), MIN(DivReachedDest), SUM(DayOfWeek) FROM mytable WHERE TotalAddGTime NOT IN (94, 13, 27, 37) AND CRSDepTime >= 739 OR LongestAddGTime IN (148, 31, 4, -9999) GROUP BY \"Year\", Quarter, DestState LIMIT 20","hsqls":["SELECT Year, Quarter, DestState, COUNT(ArrTimeBlk), MIN(DivReachedDest), SUM(DayOfWeek) FROM mytable WHERE TotalAddGTime NOT IN (94, 13, 27, 37) AND CRSDepTime >= 739 OR LongestAddGTime IN (148, 31, 4, -9999) GROUP BY Year, Quarter, DestState LIMIT 20"]}
{"sql":"SELECT Distance, AirlineID FROM mytable WHERE Quarter BETWEEN 1 AND 1 ORDER BY DepartureDelayGroups, Flights, ArrTime LIMIT 2"}
{"sql":"SELECT ArrDelayMinutes, COUNT(*) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 25","hsqls":["SELECT ArrDelayMinutes, COUNT(*) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 25"]}
{"sql":"SELECT OriginStateFips, TaxiIn, OriginStateName FROM mytable WHERE ArrTime <= 818 AND DepartureDelayGroups NOT IN (1, -2, -1, 12) ORDER BY Origin LIMIT 24"}
{"sql":"SELECT DepDelayMinutes, SUM(\"Year\"), MIN(DepDelay), MIN(DivAirportLandings) FROM mytable GROUP BY DepDelayMinutes LIMIT 25","hsqls":["SELECT DepDelayMinutes, SUM(`Year`), MIN(DepDelay), MIN(DivAirportLandings) FROM mytable GROUP BY DepDelayMinutes LIMIT 25"]}
{"sql":"SELECT OriginStateFips, CRSArrTime, AirlineID, MIN(AirTime), AVG(CarrierDelay), SUM(Diverted) FROM mytable WHERE Cancelled NOT IN (1) GROUP BY OriginStateFips, CRSArrTime, AirlineID  ORDER BY OriginStateFips, CRSArrTime, AirlineID LIMIT 6","hsqls":["SELECT OriginStateFips, CRSArrTime, AirlineID, MIN(AirTime), AVG(CarrierDelay), SUM(Diverted) FROM mytable WHERE Cancelled NOT IN (1) GROUP BY OriginStateFips, CRSArrTime, AirlineID  ORDER BY OriginStateFips, CRSArrTime, AirlineID LIMIT 6"]}
{"sql":"SELECT WeatherDelay FROM mytable WHERE DepartureDelayGroups BETWEEN -2 AND -2 AND DivTotalGTimes BETWEEN 34 AND 23","hsqls":["SELECT WeatherDelay FROM mytable WHERE DepartureDelayGroups BETWEEN -2 AND -2 AND (DivTotalGTimes[1] BETWEEN 34 AND 23 OR DivTotalGTimes[2] BETWEEN 34 AND 23 OR DivTotalGTimes[3] BETWEEN 34 AND 23 OR DivTotalGTimes[4] BETWEEN 34 AND 23 OR DivTotalGTimes[5] BETWEEN 34 AND 23) LIMIT 10000"]}
{"sql":"SELECT Cancelled, DepDel15, AVG(DepDelay), AVG(DivArrDelay), AVG(DepartureDelayGroups) FROM mytable GROUP BY Cancelled, DepDel15  ORDER BY Cancelled, DepDel15 LIMIT 26","hsqls":["SELECT Cancelled, DepDel15, AVG(DepDelay), AVG(DivArrDelay), AVG(DepartureDelayGroups) FROM mytable GROUP BY Cancelled, DepDel15  ORDER BY Cancelled, DepDel15 LIMIT 26"]}
{"sql":"SELECT DivAirports, DayOfWeek FROM mytable WHERE DivWheelsOns IN (1747) AND ActualElapsedTime < 124 AND ArrDel15 NOT IN (1, -9999) ORDER BY Dest, DaysSinceEpoch LIMIT 24","hsqls":["SELECT DivAirports, DayOfWeek FROM mytable WHERE (DivWheelsOns[1] IN (1747) OR DivWheelsOns[2] IN (1747) OR DivWheelsOns[3] IN (1747) OR DivWheelsOns[4] IN (1747) OR DivWheelsOns[5] IN (1747)) AND ActualElapsedTime < 124 AND ArrDel15 NOT IN (1, -9999) ORDER BY Dest, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT DepTime, ArrTimeBlk, DivWheelsOffs FROM mytable ORDER BY Quarter, Distance LIMIT 13","hsqls":["SELECT DepTime, ArrTimeBlk, DivWheelsOffs FROM mytable ORDER BY Quarter, Distance LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, NASDelay FROM mytable ORDER BY Dest, DestCityMarketID LIMIT 17"}
{"sql":"SELECT TaxiOut FROM mytable WHERE TailNum NOT IN ('N592JB') AND Cancelled BETWEEN 0 AND 1 ORDER BY DestCityMarketID, DayOfWeek LIMIT 4"}
{"sql":"SELECT Quarter, DepDel15, DayOfWeek FROM mytable WHERE Cancelled >= 0 LIMIT 12"}
{"sql":"SELECT AirTime FROM mytable WHERE TotalAddGTime <= 21 ORDER BY OriginWac, CRSElapsedTime LIMIT 16"}
{"sql":"SELECT FirstDepTime, DepTime, COUNT(*) FROM mytable WHERE OriginStateFips IN (47, 55, 18, 25) AND DivAirportSeqIDs > 1106603 GROUP BY FirstDepTime, DepTime LIMIT 29","hsqls":["SELECT FirstDepTime, DepTime, COUNT(*) FROM mytable WHERE OriginStateFips IN (47, 55, 18, 25) AND (DivAirportSeqIDs[1] > 1106603 OR DivAirportSeqIDs[2] > 1106603 OR DivAirportSeqIDs[3] > 1106603 OR DivAirportSeqIDs[4] > 1106603 OR DivAirportSeqIDs[5] > 1106603) GROUP BY FirstDepTime, DepTime LIMIT 10000"]}
{"sql":"SELECT SUM(ArrDelayMinutes), COUNT(Distance) FROM mytable WHERE DayofMonth BETWEEN 28 AND 11 OR DepDel15 IN (1, -9999) AND WheelsOn BETWEEN 1941 AND 1539 LIMIT 6"}
{"sql":"SELECT DivDistance, \"Month\", CRSDepTime, AVG(Distance), MIN(\"Month\"), SUM(DestCityMarketID) FROM mytable WHERE OriginStateFips IN (19, 72, 25) OR DepDel15 > -9999 GROUP BY DivDistance, \"Month\", CRSDepTime LIMIT 14","hsqls":["SELECT DivDistance, Month, CRSDepTime, AVG(Distance), MIN(`Month`), SUM(DestCityMarketID) FROM mytable WHERE OriginStateFips IN (19, 72, 25) OR DepDel15 > -9999 GROUP BY DivDistance, Month, CRSDepTime LIMIT 14"]}
{"sql":"SELECT OriginCityMarketID, DepTime FROM mytable WHERE Carrier = 'UA' AND OriginStateName >= 'Connecticut' ORDER BY OriginCityName, ActualElapsedTime, ArrivalDelayGroups LIMIT 18"}
{"sql":"SELECT COUNT(DepDelay) FROM mytable WHERE DivArrDelay BETWEEN 81 AND 83 AND DivTailNums = 'N316JB' OR DivTailNums IN ('N934SW') LIMIT 7","hsqls":["SELECT COUNT(DepDelay) FROM mytable WHERE DivArrDelay BETWEEN 81 AND 83 AND (DivTailNums[1] = 'N316JB' OR DivTailNums[2] = 'N316JB' OR DivTailNums[3] = 'N316JB' OR DivTailNums[4] = 'N316JB' OR DivTailNums[5] = 'N316JB') OR (DivTailNums[1] IN ('N934SW') OR DivTailNums[2] IN ('N934SW') OR DivTailNums[3] IN ('N934SW') OR DivTailNums[4] IN ('N934SW') OR DivTailNums[5] IN ('N934SW')) LIMIT 10000"]}
{"sql":"SELECT Quarter, Distance, OriginStateName FROM mytable WHERE DestAirportSeqID BETWEEN 1200702 AND 1562401 OR DivReachedDest >= -9999 ORDER BY DivActualElapsedTime, ArrivalDelayGroups, DaysSinceEpoch LIMIT 17"}
{"sql":"SELECT Diverted, ActualElapsedTime FROM mytable WHERE DivAirports IN ('AEX', 'TUL') AND CancellationCode NOT IN ('A', 'B', 'C', 'noodles') AND TailNum NOT IN ('N297SW', 'N14542', 'N921AT', 'N16951') ORDER BY LateAircraftDelay, DivDistance, Dest LIMIT 10","hsqls":["SELECT Diverted, ActualElapsedTime FROM mytable WHERE (DivAirports[1] IN ('AEX', 'TUL') OR DivAirports[2] IN ('AEX', 'TUL') OR DivAirports[3] IN ('AEX', 'TUL') OR DivAirports[4] IN ('AEX', 'TUL') OR DivAirports[5] IN ('AEX', 'TUL')) AND CancellationCode NOT IN ('A', 'B', 'C', 'noodles') AND TailNum NOT IN ('N297SW', 'N14542', 'N921AT', 'N16951') ORDER BY LateAircraftDelay, DivDistance, Dest LIMIT 10000"]}
{"sql":"SELECT DepDelay, LateAircraftDelay, DepTimeBlk, SUM(\"Month\"), AVG(Flights) FROM mytable WHERE DivWheelsOns IN (1908, 943, 2200) AND WheelsOff > 1532 GROUP BY DepDelay, LateAircraftDelay, DepTimeBlk LIMIT 8","hsqls":["SELECT DepDelay, LateAircraftDelay, DepTimeBlk, SUM(`Month`), AVG(Flights) FROM mytable WHERE (DivWheelsOns[1] IN (1908, 943, 2200) OR DivWheelsOns[2] IN (1908, 943, 2200) OR DivWheelsOns[3] IN (1908, 943, 2200) OR DivWheelsOns[4] IN (1908, 943, 2200) OR DivWheelsOns[5] IN (1908, 943, 2200)) AND WheelsOff > 1532 GROUP BY DepDelay, LateAircraftDelay, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT \"Year\", DepDelayMinutes, FlightDate FROM mytable WHERE DepTime NOT IN (1851, 2100) AND NASDelay BETWEEN 49 AND 31 AND Diverted IN (1, 0) ORDER BY Cancelled, DestAirportID LIMIT 26","hsqls":["SELECT Year, DepDelayMinutes, FlightDate FROM mytable WHERE DepTime NOT IN (1851, 2100) AND NASDelay BETWEEN 49 AND 31 AND Diverted IN (1, 0) ORDER BY Cancelled, DestAirportID LIMIT 26"]}
{"sql":"SELECT AVG(NASDelay) FROM mytable LIMIT 18"}
{"sql":"SELECT DivLongestGTimes, OriginCityMarketID, DestCityMarketID FROM mytable ORDER BY ArrDel15, CRSDepTime LIMIT 12","hsqls":["SELECT DivLongestGTimes, OriginCityMarketID, DestCityMarketID FROM mytable ORDER BY ArrDel15, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT Cancelled, AVG(DestAirportSeqID), MAX(Quarter), SUM(DaysSinceEpoch) FROM mytable WHERE DivTotalGTimes BETWEEN 56 AND 196 AND DivWheelsOns IN (1856, 2244, 1222, 1114, 1229) AND DivReachedDest BETWEEN 0 AND 1 GROUP BY Cancelled LIMIT 24","hsqls":["SELECT Cancelled, AVG(DestAirportSeqID), MAX(Quarter), SUM(DaysSinceEpoch) FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 56 AND 196 OR DivTotalGTimes[2] BETWEEN 56 AND 196 OR DivTotalGTimes[3] BETWEEN 56 AND 196 OR DivTotalGTimes[4] BETWEEN 56 AND 196 OR DivTotalGTimes[5] BETWEEN 56 AND 196) AND (DivWheelsOns[1] IN (1856, 2244, 1222, 1114, 1229) OR DivWheelsOns[2] IN (1856, 2244, 1222, 1114, 1229) OR DivWheelsOns[3] IN (1856, 2244, 1222, 1114, 1229) OR DivWheelsOns[4] IN (1856, 2244, 1222, 1114, 1229) OR DivWheelsOns[5] IN (1856, 2244, 1222, 1114, 1229)) AND DivReachedDest BETWEEN 0 AND 1 GROUP BY Cancelled LIMIT 10000"]}
{"sql":"SELECT AVG(ArrivalDelayGroups), SUM(DistanceGroup), MAX(DayofMonth) FROM mytable WHERE DayofMonth >= 5 OR AirTime <= 368 OR Flights BETWEEN 1 AND 1 LIMIT 19"}
{"sql":"SELECT DivAirports, DestAirportSeqID, AirlineID FROM mytable WHERE OriginWac BETWEEN 12 AND 14 ORDER BY DepartureDelayGroups, DestAirportID LIMIT 18","hsqls":["SELECT DivAirports, DestAirportSeqID, AirlineID FROM mytable WHERE OriginWac BETWEEN 12 AND 14 ORDER BY DepartureDelayGroups, DestAirportID LIMIT 10000"]}
{"sql":"SELECT CRSDepTime, COUNT(*) FROM mytable WHERE DestAirportSeqID NOT IN (1040802, 1448902, 1161706, 1302902, 1334205) GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 21","hsqls":["SELECT CRSDepTime, COUNT(*) FROM mytable WHERE DestAirportSeqID NOT IN (1040802, 1448902, 1161706, 1302902, 1334205) GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 21"]}
{"sql":"SELECT ArrDelay, AVG(DepDel15), SUM(LongestAddGTime) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 5","hsqls":["SELECT ArrDelay, AVG(DepDel15), SUM(LongestAddGTime) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 5"]}
{"sql":"SELECT TaxiOut, DestWac, DestStateFips FROM mytable WHERE ArrDelay NOT IN (197.0, 116.0, 93.0, 308.0) ORDER BY DepartureDelayGroups, Flights LIMIT 18"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND DestCityName IN ('Chattanooga, TN', 'New York, NY') LIMIT 29","hsqls":["SELECT COUNT(*) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND DestCityName IN ('Chattanooga, TN', 'New York, NY') LIMIT 29"]}
{"sql":"SELECT Quarter, DivAirports, ArrDelay FROM mytable WHERE Quarter < 1 OR DivAirportIDs IN (12992, 13495) AND \"Month\" BETWEEN 1 AND 1 ORDER BY DepTimeBlk LIMIT 10","hsqls":["SELECT Quarter, DivAirports, ArrDelay FROM mytable WHERE Quarter < 1 OR (DivAirportIDs[1] IN (12992, 13495) OR DivAirportIDs[2] IN (12992, 13495) OR DivAirportIDs[3] IN (12992, 13495) OR DivAirportIDs[4] IN (12992, 13495) OR DivAirportIDs[5] IN (12992, 13495)) AND `Month` BETWEEN 1 AND 1 ORDER BY DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns, DivArrDelay FROM mytable WHERE DivLongestGTimes IN (3.0, 53.0, 79.0, 31.0) OR WeatherDelay <> 10 ORDER BY NASDelay, UniqueCarrier LIMIT 3","hsqls":["SELECT DivWheelsOns, DivArrDelay FROM mytable WHERE (DivLongestGTimes[1] IN (3.0, 53.0, 79.0, 31.0) OR DivLongestGTimes[2] IN (3.0, 53.0, 79.0, 31.0) OR DivLongestGTimes[3] IN (3.0, 53.0, 79.0, 31.0) OR DivLongestGTimes[4] IN (3.0, 53.0, 79.0, 31.0) OR DivLongestGTimes[5] IN (3.0, 53.0, 79.0, 31.0)) OR WeatherDelay <> 10 ORDER BY NASDelay, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DestStateName, ArrivalDelayGroups FROM mytable LIMIT 9"}
{"sql":"SELECT FirstDepTime, DepDelayMinutes, Origin, COUNT(OriginStateFips) FROM mytable WHERE DivWheelsOns BETWEEN 634 AND 2123 GROUP BY FirstDepTime, DepDelayMinutes, Origin LIMIT 26","hsqls":["SELECT FirstDepTime, DepDelayMinutes, Origin, COUNT(OriginStateFips) FROM mytable WHERE (DivWheelsOns[1] BETWEEN 634 AND 2123 OR DivWheelsOns[2] BETWEEN 634 AND 2123 OR DivWheelsOns[3] BETWEEN 634 AND 2123 OR DivWheelsOns[4] BETWEEN 634 AND 2123 OR DivWheelsOns[5] BETWEEN 634 AND 2123) GROUP BY FirstDepTime, DepDelayMinutes, Origin LIMIT 10000"]}
{"sql":"SELECT Origin FROM mytable WHERE OriginState NOT IN ('ME') AND UniqueCarrier IN ('US', 'VX') AND TaxiOut BETWEEN 3 AND 102 ORDER BY DivReachedDest, DivDistance, WeatherDelay LIMIT 8"}
{"sql":"SELECT COUNT(DestCityMarketID), AVG(DestWac) FROM mytable LIMIT 18"}
{"sql":"SELECT OriginAirportID FROM mytable WHERE Quarter >= 1 ORDER BY FirstDepTime LIMIT 19"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Origin <> 'RST' LIMIT 16"}
{"sql":"SELECT CRSArrTime, OriginCityName, UniqueCarrier, MAX(DestAirportID), COUNT(OriginStateName) FROM mytable WHERE DistanceGroup IN (6, 8, 11) AND OriginStateFips BETWEEN 15 AND 22 GROUP BY CRSArrTime, OriginCityName, UniqueCarrier  ORDER BY CRSArrTime, OriginCityName, UniqueCarrier LIMIT 18","hsqls":["SELECT CRSArrTime, OriginCityName, UniqueCarrier, MAX(DestAirportID), COUNT(OriginStateName) FROM mytable WHERE DistanceGroup IN (6, 8, 11) AND OriginStateFips BETWEEN 15 AND 22 GROUP BY CRSArrTime, OriginCityName, UniqueCarrier  ORDER BY CRSArrTime, OriginCityName, UniqueCarrier LIMIT 18"]}
{"sql":"SELECT OriginCityName, COUNT(*) FROM mytable WHERE SecurityDelay = 0 AND LateAircraftDelay > 103 OR ArrTime BETWEEN 2012 AND 838 GROUP BY OriginCityName","hsqls":["SELECT OriginCityName, COUNT(*) FROM mytable WHERE SecurityDelay = 0 AND LateAircraftDelay > 103 OR ArrTime BETWEEN 2012 AND 838 GROUP BY OriginCityName"]}
{"sql":"SELECT ArrDelay FROM mytable WHERE DepDelay = 179.0 AND SecurityDelay < -9999 LIMIT 20"}
{"sql":"SELECT DestStateFips FROM mytable WHERE Quarter IN (1) ORDER BY ArrTime, DepDel15 LIMIT 23"}
{"sql":"SELECT Diverted, SUM(OriginWac) FROM mytable GROUP BY Diverted  ORDER BY Diverted LIMIT 13","hsqls":["SELECT Diverted, SUM(OriginWac) FROM mytable GROUP BY Diverted  ORDER BY Diverted LIMIT 13"]}
{"sql":"SELECT WheelsOff, SUM(DistanceGroup) FROM mytable GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 13","hsqls":["SELECT WheelsOff, SUM(DistanceGroup) FROM mytable GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 13"]}
{"sql":"SELECT DistanceGroup, DepDelayMinutes FROM mytable WHERE DepDelay BETWEEN 455.0 AND 66.0 AND DivWheelsOns = 2141 OR CancellationCode BETWEEN 'B' AND 'noodles' LIMIT 13","hsqls":["SELECT DistanceGroup, DepDelayMinutes FROM mytable WHERE DepDelay BETWEEN 455.0 AND 66.0 AND (DivWheelsOns[1] = 2141 OR DivWheelsOns[2] = 2141 OR DivWheelsOns[3] = 2141 OR DivWheelsOns[4] = 2141 OR DivWheelsOns[5] = 2141) OR CancellationCode BETWEEN 'B' AND 'noodles' LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DepTime FROM mytable WHERE ArrDelayMinutes > 238.0 OR DivReachedDest >= 1 OR ArrDel15 BETWEEN -9999 AND 1 LIMIT 20"}
{"sql":"SELECT FlightDate, DaysSinceEpoch FROM mytable WHERE CarrierDelay IN (70, 414) OR LateAircraftDelay NOT IN (63) OR \"Month\" <= 1 LIMIT 23","hsqls":["SELECT FlightDate, DaysSinceEpoch FROM mytable WHERE CarrierDelay IN (70, 414) OR LateAircraftDelay NOT IN (63) OR `Month` <= 1 LIMIT 23"]}
{"sql":"SELECT Diverted, OriginAirportID FROM mytable WHERE SecurityDelay >= 14 OR TaxiOut NOT IN (13, 37, 75) AND DestStateName BETWEEN 'Arizona' AND 'Massachusetts' LIMIT 1"}
{"sql":"SELECT DistanceGroup FROM mytable WHERE DayofMonth < 21 OR LongestAddGTime >= 4 ORDER BY TaxiOut, ActualElapsedTime, DaysSinceEpoch LIMIT 5"}
{"sql":"SELECT FlightDate, OriginStateName, AVG(AirTime), AVG(DepartureDelayGroups) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DaysSinceEpoch IN (16071) AND LateAircraftDelay BETWEEN 7 AND 111 GROUP BY FlightDate, OriginStateName  ORDER BY FlightDate, OriginStateName LIMIT 19","hsqls":["SELECT FlightDate, OriginStateName, AVG(AirTime), AVG(DepartureDelayGroups) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DaysSinceEpoch IN (16071) AND LateAircraftDelay BETWEEN 7 AND 111 GROUP BY FlightDate, OriginStateName  ORDER BY FlightDate, OriginStateName LIMIT 19"]}
{"sql":"SELECT ArrTimeBlk, DivTailNums, ArrivalDelayGroups FROM mytable LIMIT 28","hsqls":["SELECT ArrTimeBlk, DivTailNums, ArrivalDelayGroups FROM mytable LIMIT 10000"]}
{"sql":"SELECT ArrTimeBlk, DayOfWeek, MIN(DivArrDelay), COUNT(DestCityMarketID) FROM mytable GROUP BY ArrTimeBlk, DayOfWeek  ORDER BY ArrTimeBlk, DayOfWeek LIMIT 2","hsqls":["SELECT ArrTimeBlk, DayOfWeek, MIN(DivArrDelay), COUNT(DestCityMarketID) FROM mytable GROUP BY ArrTimeBlk, DayOfWeek  ORDER BY ArrTimeBlk, DayOfWeek LIMIT 2"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 4"}
{"sql":"SELECT DestState, SUM(TotalAddGTime), MIN(DestCityMarketID) FROM mytable WHERE DivAirportSeqIDs BETWEEN 1106603 AND 1496002 AND TailNum < 'N135EV' AND DestAirportID IN (14570) GROUP BY DestState LIMIT 11","hsqls":["SELECT DestState, SUM(TotalAddGTime), MIN(DestCityMarketID) FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1106603 AND 1496002 OR DivAirportSeqIDs[2] BETWEEN 1106603 AND 1496002 OR DivAirportSeqIDs[3] BETWEEN 1106603 AND 1496002 OR DivAirportSeqIDs[4] BETWEEN 1106603 AND 1496002 OR DivAirportSeqIDs[5] BETWEEN 1106603 AND 1496002) AND TailNum < 'N135EV' AND DestAirportID IN (14570) GROUP BY DestState LIMIT 10000"]}
{"sql":"SELECT FirstDepTime FROM mytable WHERE WheelsOff <= 1806 OR OriginWac <> 13 AND SecurityDelay NOT IN (8, 27) ORDER BY OriginState, DepTime LIMIT 10"}
{"sql":"SELECT UniqueCarrier, SUM(ArrDelayMinutes), MAX(ArrDelayMinutes), MIN(DayofMonth) FROM mytable WHERE Distance = 220 GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 6","hsqls":["SELECT UniqueCarrier, SUM(ArrDelayMinutes), MAX(ArrDelayMinutes), MIN(DayofMonth) FROM mytable WHERE Distance = 220 GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 6"]}
{"sql":"SELECT DivLongestGTimes, FlightDate, DestAirportSeqID FROM mytable WHERE DestAirportSeqID IN (1349503) ORDER BY \"Year\", CRSArrTime LIMIT 1","hsqls":["SELECT DivLongestGTimes, FlightDate, DestAirportSeqID FROM mytable WHERE DestAirportSeqID IN (1349503) ORDER BY Year, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT MIN(DestWac), MAX(TotalAddGTime), AVG(FlightNum) FROM mytable WHERE OriginState BETWEEN 'SD' AND 'OR' LIMIT 27"}
{"sql":"SELECT AVG(DivDistance), MAX(DepartureDelayGroups) FROM mytable WHERE OriginAirportSeqID BETWEEN 1192102 AND 1238902 OR Dest BETWEEN 'MFE' AND 'EWR' LIMIT 10"}
{"sql":"SELECT ActualElapsedTime, OriginWac FROM mytable WHERE OriginAirportSeqID BETWEEN 1130802 AND 1217703 ORDER BY SecurityDelay, DepTimeBlk LIMIT 10"}
{"sql":"SELECT DivDistance, WheelsOn, OriginStateName FROM mytable WHERE DepTime BETWEEN 1636 AND 1611 AND WheelsOn <> 1045 ORDER BY DepDelay LIMIT 10"}
{"sql":"SELECT DepTime, TaxiIn, SUM(DestAirportID), AVG(Flights) FROM mytable WHERE DivActualElapsedTime BETWEEN 318 AND 410 GROUP BY DepTime, TaxiIn  ORDER BY DepTime, TaxiIn LIMIT 8","hsqls":["SELECT DepTime, TaxiIn, SUM(DestAirportID), AVG(Flights) FROM mytable WHERE DivActualElapsedTime BETWEEN 318 AND 410 GROUP BY DepTime, TaxiIn  ORDER BY DepTime, TaxiIn LIMIT 8"]}
{"sql":"SELECT ActualElapsedTime FROM mytable WHERE LateAircraftDelay > 98 AND DestWac BETWEEN 15 AND 66 AND TailNum BETWEEN 'N843MQ' AND 'N14916' ORDER BY WeatherDelay LIMIT 22"}
{"sql":"SELECT DepTimeBlk, DestAirportID, COUNT(CancellationCode) FROM mytable WHERE CRSDepTime NOT IN (1840, 1631) GROUP BY DepTimeBlk, DestAirportID  ORDER BY DepTimeBlk, DestAirportID LIMIT 2","hsqls":["SELECT DepTimeBlk, DestAirportID, COUNT(CancellationCode) FROM mytable WHERE CRSDepTime NOT IN (1840, 1631) GROUP BY DepTimeBlk, DestAirportID  ORDER BY DepTimeBlk, DestAirportID LIMIT 2"]}
{"sql":"SELECT OriginCityMarketID, CancellationCode, DivArrDelay, MAX(OriginCityMarketID), COUNT(DepTimeBlk), MAX(ArrivalDelayGroups) FROM mytable WHERE OriginStateName <> 'Vermont' AND DivAirportLandings <= 1 AND AirlineID <> 19393 GROUP BY OriginCityMarketID, CancellationCode, DivArrDelay  ORDER BY OriginCityMarketID, CancellationCode, DivArrDelay LIMIT 7","hsqls":["SELECT OriginCityMarketID, CancellationCode, DivArrDelay, MAX(OriginCityMarketID), COUNT(DepTimeBlk), MAX(ArrivalDelayGroups) FROM mytable WHERE OriginStateName <> 'Vermont' AND DivAirportLandings <= 1 AND AirlineID <> 19393 GROUP BY OriginCityMarketID, CancellationCode, DivArrDelay  ORDER BY OriginCityMarketID, CancellationCode, DivArrDelay LIMIT 7"]}
{"sql":"SELECT DepDelayMinutes, DestAirportID, DayofMonth, AVG(CRSDepTime), AVG(DestAirportID), AVG(DivArrDelay) FROM mytable WHERE LateAircraftDelay >= 58 OR FlightDate < '2014-01-19' GROUP BY DepDelayMinutes, DestAirportID, DayofMonth  ORDER BY DepDelayMinutes, DestAirportID, DayofMonth LIMIT 17","hsqls":["SELECT DepDelayMinutes, DestAirportID, DayofMonth, AVG(CRSDepTime), AVG(DestAirportID), AVG(DivArrDelay) FROM mytable WHERE LateAircraftDelay >= 58 OR FlightDate < '2014-01-19' GROUP BY DepDelayMinutes, DestAirportID, DayofMonth  ORDER BY DepDelayMinutes, DestAirportID, DayofMonth LIMIT 17"]}
{"sql":"SELECT DestWac FROM mytable WHERE ArrivalDelayGroups BETWEEN 0 AND 5 ORDER BY DestCityMarketID LIMIT 16"}
{"sql":"SELECT Origin, CancellationCode, OriginStateName FROM mytable WHERE FirstDepTime >= 1018 ORDER BY WeatherDelay LIMIT 9"}
{"sql":"SELECT OriginCityMarketID FROM mytable ORDER BY CRSElapsedTime LIMIT 5"}
{"sql":"SELECT DivLongestGTimes, ArrDel15, DivAirportLandings FROM mytable WHERE FirstDepTime BETWEEN 1030 AND 1639 AND OriginCityName = 'Cody, WY' ORDER BY DivArrDelay LIMIT 11","hsqls":["SELECT DivLongestGTimes, ArrDel15, DivAirportLandings FROM mytable WHERE FirstDepTime BETWEEN 1030 AND 1639 AND OriginCityName = 'Cody, WY' ORDER BY DivArrDelay LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, SecurityDelay, DestAirportSeqID, COUNT(*) FROM mytable WHERE \"Month\" <> 1 OR ArrDelayMinutes BETWEEN 46.0 AND 35.0 AND DaysSinceEpoch >= 16094 GROUP BY OriginCityMarketID, SecurityDelay, DestAirportSeqID LIMIT 16","hsqls":["SELECT OriginCityMarketID, SecurityDelay, DestAirportSeqID, COUNT(*) FROM mytable WHERE `Month` <> 1 OR ArrDelayMinutes BETWEEN 46.0 AND 35.0 AND DaysSinceEpoch >= 16094 GROUP BY OriginCityMarketID, SecurityDelay, DestAirportSeqID LIMIT 16"]}
{"sql":"SELECT LateAircraftDelay, AirTime FROM mytable WHERE Quarter IN (1) OR CRSElapsedTime NOT IN (132, 124, 231) AND TotalAddGTime BETWEEN 13 AND 20 ORDER BY OriginAirportSeqID LIMIT 17"}
{"sql":"SELECT LateAircraftDelay, DepTime, ArrTime, MIN(DayOfWeek) FROM mytable GROUP BY LateAircraftDelay, DepTime, ArrTime  ORDER BY LateAircraftDelay, DepTime, ArrTime LIMIT 17","hsqls":["SELECT LateAircraftDelay, DepTime, ArrTime, MIN(DayOfWeek) FROM mytable GROUP BY LateAircraftDelay, DepTime, ArrTime  ORDER BY LateAircraftDelay, DepTime, ArrTime LIMIT 17"]}
{"sql":"SELECT FlightDate FROM mytable WHERE \"Year\" IN (2014) OR DayOfWeek >= 2 ORDER BY DestState, UniqueCarrier LIMIT 4","hsqls":["SELECT FlightDate FROM mytable WHERE `Year` IN (2014) OR DayOfWeek >= 2 ORDER BY DestState, UniqueCarrier LIMIT 4"]}
{"sql":"SELECT AVG(\"Month\"), SUM(DepDelayMinutes) FROM mytable WHERE Quarter < 1 OR ArrTime BETWEEN 1850 AND 841 AND TaxiOut >= 79 LIMIT 21","hsqls":["SELECT AVG(`Month`), SUM(DepDelayMinutes) FROM mytable WHERE Quarter < 1 OR ArrTime BETWEEN 1850 AND 841 AND TaxiOut >= 79 LIMIT 21"]}
{"sql":"SELECT DestAirportSeqID, DayOfWeek FROM mytable WHERE WheelsOff BETWEEN 743 AND 1542 OR Cancelled > 1 OR TailNum BETWEEN 'N568JB' AND 'N968DL' ORDER BY DestStateFips, DestAirportSeqID LIMIT 10"}
{"sql":"SELECT OriginCityMarketID, TaxiIn, COUNT(Quarter), MIN(ArrDelayMinutes), SUM(ArrivalDelayGroups) FROM mytable WHERE DestAirportSeqID BETWEEN 1244805 AND 1052904 GROUP BY OriginCityMarketID, TaxiIn  ORDER BY OriginCityMarketID, TaxiIn LIMIT 2","hsqls":["SELECT OriginCityMarketID, TaxiIn, COUNT(Quarter), MIN(ArrDelayMinutes), SUM(ArrivalDelayGroups) FROM mytable WHERE DestAirportSeqID BETWEEN 1244805 AND 1052904 GROUP BY OriginCityMarketID, TaxiIn  ORDER BY OriginCityMarketID, TaxiIn LIMIT 2"]}
{"sql":"SELECT DestAirportSeqID, DaysSinceEpoch FROM mytable ORDER BY ArrTime, ArrDelay, \"Month\" LIMIT 13","hsqls":["SELECT DestAirportSeqID, DaysSinceEpoch FROM mytable ORDER BY ArrTime, ArrDelay, `Month` LIMIT 13"]}
{"sql":"SELECT DivReachedDest, DepDel15, MIN(LateAircraftDelay) FROM mytable WHERE LateAircraftDelay < 29 AND TailNum BETWEEN 'N3HEAA' AND 'N3LBAA' GROUP BY DivReachedDest, DepDel15  ORDER BY DivReachedDest, DepDel15 LIMIT 3","hsqls":["SELECT DivReachedDest, DepDel15, MIN(LateAircraftDelay) FROM mytable WHERE LateAircraftDelay < 29 AND TailNum BETWEEN 'N3HEAA' AND 'N3LBAA' GROUP BY DivReachedDest, DepDel15  ORDER BY DivReachedDest, DepDel15 LIMIT 3"]}
{"sql":"SELECT OriginAirportSeqID, Quarter, DivArrDelay FROM mytable LIMIT 7"}
{"sql":"SELECT ArrTime, AirTime FROM mytable WHERE DayOfWeek BETWEEN 1 AND 7 AND FirstDepTime IN (1032, 2145, 1940, -9999) LIMIT 23"}
{"sql":"SELECT CarrierDelay, DayofMonth, UniqueCarrier FROM mytable WHERE Dest BETWEEN 'MSN' AND 'OTH' AND CancellationCode NOT IN ('C', 'noodles') OR DepTimeBlk NOT IN ('1100-1159', '0600-0659', '1900-1959', '0001-0559', '1500-1559') LIMIT 4"}
{"sql":"SELECT DistanceGroup, Carrier, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE DivAirports BETWEEN 'BPT' AND 'TUL' OR OriginStateFips BETWEEN 10 AND 36 OR ArrDelay NOT IN (198.0, 16.0, 1.0, 48.0, 151.0) GROUP BY DistanceGroup, Carrier, ArrivalDelayGroups LIMIT 16","hsqls":["SELECT DistanceGroup, Carrier, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE (DivAirports[1] BETWEEN 'BPT' AND 'TUL' OR DivAirports[2] BETWEEN 'BPT' AND 'TUL' OR DivAirports[3] BETWEEN 'BPT' AND 'TUL' OR DivAirports[4] BETWEEN 'BPT' AND 'TUL' OR DivAirports[5] BETWEEN 'BPT' AND 'TUL') OR OriginStateFips BETWEEN 10 AND 36 OR ArrDelay NOT IN (198.0, 16.0, 1.0, 48.0, 151.0) GROUP BY DistanceGroup, Carrier, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT DepDelay, DestCityMarketID FROM mytable LIMIT 3"}
{"sql":"SELECT DepDelayMinutes, ArrTimeBlk, Dest FROM mytable WHERE DayofMonth NOT IN (3, 7, 8, 12) AND DivReachedDest = -9999 OR DivAirportIDs BETWEEN 11140 AND 14524 LIMIT 26","hsqls":["SELECT DepDelayMinutes, ArrTimeBlk, Dest FROM mytable WHERE DayofMonth NOT IN (3, 7, 8, 12) AND DivReachedDest = -9999 OR (DivAirportIDs[1] BETWEEN 11140 AND 14524 OR DivAirportIDs[2] BETWEEN 11140 AND 14524 OR DivAirportIDs[3] BETWEEN 11140 AND 14524 OR DivAirportIDs[4] BETWEEN 11140 AND 14524 OR DivAirportIDs[5] BETWEEN 11140 AND 14524) LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes, DivActualElapsedTime FROM mytable WHERE OriginCityName = 'Manchester, NH' AND ArrDelayMinutes BETWEEN 19.0 AND 43.0 ORDER BY WeatherDelay LIMIT 10","hsqls":["SELECT DivLongestGTimes, DivActualElapsedTime FROM mytable WHERE OriginCityName = 'Manchester, NH' AND ArrDelayMinutes BETWEEN 19.0 AND 43.0 ORDER BY WeatherDelay LIMIT 10000"]}
{"sql":"SELECT DestStateFips, SecurityDelay, Cancelled, COUNT(*) FROM mytable GROUP BY DestStateFips, SecurityDelay, Cancelled  ORDER BY DestStateFips, SecurityDelay, Cancelled LIMIT 2","hsqls":["SELECT DestStateFips, SecurityDelay, Cancelled, COUNT(*) FROM mytable GROUP BY DestStateFips, SecurityDelay, Cancelled  ORDER BY DestStateFips, SecurityDelay, Cancelled LIMIT 2"]}
{"sql":"SELECT WheelsOn FROM mytable WHERE DepartureDelayGroups IN (10, 7, 6, 5, 9) AND DayOfWeek BETWEEN 4 AND 7 AND ArrTime >= 1433 LIMIT 21"}
{"sql":"SELECT CarrierDelay, DestAirportSeqID, AVG(OriginAirportSeqID), MIN(DestStateFips) FROM mytable GROUP BY CarrierDelay, DestAirportSeqID  ORDER BY CarrierDelay, DestAirportSeqID LIMIT 25","hsqls":["SELECT CarrierDelay, DestAirportSeqID, AVG(OriginAirportSeqID), MIN(DestStateFips) FROM mytable GROUP BY CarrierDelay, DestAirportSeqID  ORDER BY CarrierDelay, DestAirportSeqID LIMIT 25"]}
{"sql":"SELECT \"Year\", WheelsOn, OriginAirportID FROM mytable WHERE Cancelled < 0 OR ArrDelayMinutes BETWEEN 184.0 AND 75.0 ORDER BY DistanceGroup, ArrDelay, CRSElapsedTime LIMIT 13","hsqls":["SELECT Year, WheelsOn, OriginAirportID FROM mytable WHERE Cancelled < 0 OR ArrDelayMinutes BETWEEN 184.0 AND 75.0 ORDER BY DistanceGroup, ArrDelay, CRSElapsedTime LIMIT 13"]}
{"sql":"SELECT FirstDepTime, ArrTimeBlk FROM mytable WHERE FlightNum IN (1661, 5872, 1477, 1270, 4617) OR DayofMonth NOT IN (21, 17, 13) ORDER BY DestCityMarketID, WheelsOn LIMIT 9"}
{"sql":"SELECT DistanceGroup, DayOfWeek FROM mytable WHERE \"Year\" NOT IN (2014) AND CancellationCode BETWEEN 'B' AND 'B' AND OriginAirportID = 10408 LIMIT 25","hsqls":["SELECT DistanceGroup, DayOfWeek FROM mytable WHERE `Year` NOT IN (2014) AND CancellationCode BETWEEN 'B' AND 'B' AND OriginAirportID = 10408 LIMIT 25"]}
{"sql":"SELECT ArrivalDelayGroups, COUNT(Flights), COUNT(DepTime) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 12","hsqls":["SELECT ArrivalDelayGroups, COUNT(Flights), COUNT(DepTime) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 12"]}
{"sql":"SELECT ArrTime FROM mytable WHERE \"Year\" IN (2014) OR ArrTime BETWEEN 244 AND 637 AND UniqueCarrier BETWEEN 'VX' AND 'US' ORDER BY Quarter","hsqls":["SELECT ArrTime FROM mytable WHERE `Year` IN (2014) OR ArrTime BETWEEN 244 AND 637 AND UniqueCarrier BETWEEN 'VX' AND 'US' ORDER BY Quarter"]}
{"sql":"SELECT AVG(OriginAirportSeqID), MIN(CarrierDelay), SUM(Quarter) FROM mytable WHERE DivAirportSeqIDs BETWEEN 1039705 AND 1315802 LIMIT 24","hsqls":["SELECT AVG(OriginAirportSeqID), MIN(CarrierDelay), SUM(Quarter)  FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1039705 AND 1315802 OR DivAirportSeqIDs[2] BETWEEN 1039705 AND 1315802 OR DivAirportSeqIDs[3] BETWEEN 1039705 AND 1315802 OR DivAirportSeqIDs[4] BETWEEN 1039705 AND 1315802 OR DivAirportSeqIDs[5] BETWEEN 1039705 AND 1315802) LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, DivTotalGTimes FROM mytable WHERE CRSArrTime BETWEEN 1913 AND 843 ORDER BY TaxiIn, AirTime LIMIT 2","hsqls":["SELECT CarrierDelay, DivTotalGTimes FROM mytable WHERE CRSArrTime BETWEEN 1913 AND 843 ORDER BY TaxiIn, AirTime LIMIT 10000"]}
{"sql":"SELECT DestStateFips FROM mytable WHERE DepartureDelayGroups NOT IN (0, 7, -1) LIMIT 15"}
{"sql":"SELECT FirstDepTime FROM mytable ORDER BY OriginStateFips LIMIT 28"}
{"sql":"SELECT DivAirportLandings, DivArrDelay, MAX(DepTime), COUNT(OriginCityName) FROM mytable WHERE DestCityName NOT IN ('Mosinee, WI') GROUP BY DivAirportLandings, DivArrDelay  ORDER BY DivAirportLandings, DivArrDelay LIMIT 20","hsqls":["SELECT DivAirportLandings, DivArrDelay, MAX(DepTime), COUNT(OriginCityName) FROM mytable WHERE DestCityName NOT IN ('Mosinee, WI') GROUP BY DivAirportLandings, DivArrDelay  ORDER BY DivAirportLandings, DivArrDelay LIMIT 20"]}
{"sql":"SELECT Origin FROM mytable WHERE DivActualElapsedTime NOT IN (151, 497) ORDER BY FlightNum LIMIT 7"}
{"sql":"SELECT DepartureDelayGroups, ArrTime, NASDelay FROM mytable WHERE Cancelled = 0 ORDER BY TaxiOut LIMIT 10"}
{"sql":"SELECT TaxiOut, CancellationCode FROM mytable WHERE DivArrDelay BETWEEN 281 AND 84 AND Cancelled BETWEEN 0 AND 0 ORDER BY DepTime LIMIT 6"}
{"sql":"SELECT LongestAddGTime, ArrDelay FROM mytable WHERE DivWheelsOffs BETWEEN 1253 AND 1910 LIMIT 22","hsqls":["SELECT LongestAddGTime, ArrDelay FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1253 AND 1910 OR DivWheelsOffs[2] BETWEEN 1253 AND 1910 OR DivWheelsOffs[3] BETWEEN 1253 AND 1910 OR DivWheelsOffs[4] BETWEEN 1253 AND 1910 OR DivWheelsOffs[5] BETWEEN 1253 AND 1910) LIMIT 10000"]}
{"sql":"SELECT WheelsOff, LongestAddGTime, COUNT(*) FROM mytable WHERE ActualElapsedTime >= 40 OR NASDelay <= 281 GROUP BY WheelsOff, LongestAddGTime  ORDER BY WheelsOff, LongestAddGTime LIMIT 16","hsqls":["SELECT WheelsOff, LongestAddGTime, COUNT(*) FROM mytable WHERE ActualElapsedTime >= 40 OR NASDelay <= 281 GROUP BY WheelsOff, LongestAddGTime  ORDER BY WheelsOff, LongestAddGTime LIMIT 16"]}
{"sql":"SELECT CancellationCode, AVG(ArrDelay), AVG(OriginAirportID) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND 0 AND OriginWac IN (45, 82, 72, 54, 61) AND Dest BETWEEN 'ISP' AND 'ROC' GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 26","hsqls":["SELECT CancellationCode, AVG(ArrDelay), AVG(OriginAirportID) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND 0 AND OriginWac IN (45, 82, 72, 54, 61) AND Dest BETWEEN 'ISP' AND 'ROC' GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 26"]}
{"sql":"SELECT DivLongestGTimes, DepDelay, OriginAirportID FROM mytable WHERE ArrivalDelayGroups > 10 OR NASDelay BETWEEN 226 AND 7 LIMIT 23","hsqls":["SELECT DivLongestGTimes, DepDelay, OriginAirportID FROM mytable WHERE ArrivalDelayGroups > 10 OR NASDelay BETWEEN 226 AND 7 LIMIT 10000"]}
{"sql":"SELECT DepDelay, CRSArrTime, TaxiIn FROM mytable WHERE Carrier BETWEEN 'EV' AND 'UA' OR OriginCityName >= 'Gillette, WY' AND Flights IN (1) LIMIT 29"}
{"sql":"SELECT DayofMonth, CancellationCode, \"Month\", SUM(TaxiOut), SUM(FlightNum) FROM mytable GROUP BY DayofMonth, CancellationCode, \"Month\" LIMIT 19","hsqls":["SELECT DayofMonth, CancellationCode, Month, SUM(TaxiOut), SUM(FlightNum) FROM mytable GROUP BY DayofMonth, CancellationCode, `Month` LIMIT 19"]}
{"sql":"SELECT TaxiOut, WeatherDelay FROM mytable WHERE LongestAddGTime NOT IN (78, 5, 63, 26, -9999) AND DivWheelsOffs BETWEEN 2105 AND 21 OR DestCityMarketID < 31986 ORDER BY FlightDate, WheelsOn, DivActualElapsedTime LIMIT 17","hsqls":["SELECT TaxiOut, WeatherDelay FROM mytable WHERE LongestAddGTime NOT IN (78, 5, 63, 26, -9999) AND (DivWheelsOffs[1] BETWEEN 2105 AND 21 OR DivWheelsOffs[2] BETWEEN 2105 AND 21 OR DivWheelsOffs[3] BETWEEN 2105 AND 21 OR DivWheelsOffs[4] BETWEEN 2105 AND 21 OR DivWheelsOffs[5] BETWEEN 2105 AND 21) OR DestCityMarketID < 31986 ORDER BY FlightDate, WheelsOn, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DepTimeBlk, OriginAirportID, COUNT(DestAirportSeqID), COUNT(Diverted) FROM mytable WHERE TaxiOut BETWEEN 37 AND 112 AND OriginStateFips <= 19 AND OriginStateName <> 'Oklahoma' GROUP BY WeatherDelay, DepTimeBlk, OriginAirportID  ORDER BY WeatherDelay, DepTimeBlk, OriginAirportID LIMIT 11","hsqls":["SELECT WeatherDelay, DepTimeBlk, OriginAirportID, COUNT(DestAirportSeqID), COUNT(Diverted) FROM mytable WHERE TaxiOut BETWEEN 37 AND 112 AND OriginStateFips <= 19 AND OriginStateName <> 'Oklahoma' GROUP BY WeatherDelay, DepTimeBlk, OriginAirportID  ORDER BY WeatherDelay, DepTimeBlk, OriginAirportID LIMIT 11"]}
{"sql":"SELECT DestStateName FROM mytable ORDER BY DestCityMarketID LIMIT 14"}
{"sql":"SELECT AVG(TotalAddGTime), MAX(CRSDepTime), AVG(DepDelayMinutes) FROM mytable LIMIT 19"}
{"sql":"SELECT DestWac, CancellationCode, DestAirportID FROM mytable ORDER BY FlightNum, ActualElapsedTime LIMIT 19"}
{"sql":"SELECT OriginCityName FROM mytable ORDER BY DestWac, ArrTime, Cancelled LIMIT 24"}
{"sql":"SELECT Cancelled, ArrDel15, DestStateName, COUNT(ArrDel15), COUNT(Distance) FROM mytable WHERE OriginCityMarketID <= 33502 GROUP BY Cancelled, ArrDel15, DestStateName  ORDER BY Cancelled, ArrDel15, DestStateName LIMIT 23","hsqls":["SELECT Cancelled, ArrDel15, DestStateName, COUNT(ArrDel15), COUNT(Distance) FROM mytable WHERE OriginCityMarketID <= 33502 GROUP BY Cancelled, ArrDel15, DestStateName  ORDER BY Cancelled, ArrDel15, DestStateName LIMIT 23"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 24"}
{"sql":"SELECT MIN(DivActualElapsedTime) FROM mytable WHERE ArrTime IN (1537, 2029) LIMIT 17"}
{"sql":"SELECT Diverted, MAX(DivReachedDest) FROM mytable WHERE WeatherDelay NOT IN (2, 39) OR FlightNum IN (1938, 5626, 3852) GROUP BY Diverted  ORDER BY Diverted LIMIT 11","hsqls":["SELECT Diverted, MAX(DivReachedDest) FROM mytable WHERE WeatherDelay NOT IN (2, 39) OR FlightNum IN (1938, 5626, 3852) GROUP BY Diverted  ORDER BY Diverted LIMIT 11"]}
{"sql":"SELECT Diverted, TotalAddGTime, ArrTime FROM mytable WHERE DivArrDelay = 155 AND Origin BETWEEN 'LFT' AND 'CIC' OR Origin BETWEEN 'ABI' AND 'CRP' ORDER BY ArrDelayMinutes, \"Month\", CRSElapsedTime LIMIT 23","hsqls":["SELECT Diverted, TotalAddGTime, ArrTime FROM mytable WHERE DivArrDelay = 155 AND Origin BETWEEN 'LFT' AND 'CIC' OR Origin BETWEEN 'ABI' AND 'CRP' ORDER BY ArrDelayMinutes, Month, CRSElapsedTime LIMIT 23"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE OriginStateFips BETWEEN 42 AND 19 OR DivReachedDest < 0 OR WheelsOff BETWEEN 1202 AND 1218 ORDER BY DivDistance LIMIT 29"}
{"sql":"SELECT ArrTimeBlk, MIN(DepTime), SUM(OriginAirportSeqID), MIN(FirstDepTime) FROM mytable WHERE DepDelayMinutes <> 66.0 AND OriginWac > 73 AND OriginAirportID NOT IN (12448, 11150, 14487, 11618, 11637) GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 6","hsqls":["SELECT ArrTimeBlk, MIN(DepTime), SUM(OriginAirportSeqID), MIN(FirstDepTime) FROM mytable WHERE DepDelayMinutes <> 66.0 AND OriginWac > 73 AND OriginAirportID NOT IN (12448, 11150, 14487, 11618, 11637) GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 6"]}
{"sql":"SELECT LongestAddGTime, OriginStateName, MAX(OriginAirportSeqID), COUNT(NASDelay), AVG(OriginStateFips) FROM mytable GROUP BY LongestAddGTime, OriginStateName  ORDER BY LongestAddGTime, OriginStateName LIMIT 28","hsqls":["SELECT LongestAddGTime, OriginStateName, MAX(OriginAirportSeqID), COUNT(NASDelay), AVG(OriginStateFips) FROM mytable GROUP BY LongestAddGTime, OriginStateName  ORDER BY LongestAddGTime, OriginStateName LIMIT 28"]}
{"sql":"SELECT OriginCityName, DivAirportSeqIDs FROM mytable WHERE DivWheelsOffs BETWEEN 2030 AND 44 OR ActualElapsedTime BETWEEN 126 AND 188 LIMIT 28","hsqls":["SELECT OriginCityName, DivAirportSeqIDs FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 2030 AND 44 OR DivWheelsOffs[2] BETWEEN 2030 AND 44 OR DivWheelsOffs[3] BETWEEN 2030 AND 44 OR DivWheelsOffs[4] BETWEEN 2030 AND 44 OR DivWheelsOffs[5] BETWEEN 2030 AND 44) OR ActualElapsedTime BETWEEN 126 AND 188 LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, SUM(Quarter) FROM mytable WHERE DivAirportSeqIDs IN (1163805, 1315802) AND Quarter <= 1 GROUP BY DistanceGroup LIMIT 29","hsqls":["SELECT DistanceGroup, SUM(Quarter) FROM mytable WHERE (DivAirportSeqIDs[1] IN (1163805, 1315802) OR DivAirportSeqIDs[2] IN (1163805, 1315802) OR DivAirportSeqIDs[3] IN (1163805, 1315802) OR DivAirportSeqIDs[4] IN (1163805, 1315802) OR DivAirportSeqIDs[5] IN (1163805, 1315802)) AND Quarter <= 1 GROUP BY DistanceGroup LIMIT 10000"]}
{"sql":"SELECT AirlineID, OriginStateName, MAX(TaxiIn), MAX(DivReachedDest), MIN(WheelsOff) FROM mytable WHERE OriginAirportID IN (14520, 12339, 12016, 13485, 11996) AND DivActualElapsedTime BETWEEN 567 AND 250 GROUP BY AirlineID, OriginStateName  ORDER BY AirlineID, OriginStateName LIMIT 5","hsqls":["SELECT AirlineID, OriginStateName, MAX(TaxiIn), MAX(DivReachedDest), MIN(WheelsOff) FROM mytable WHERE OriginAirportID IN (14520, 12339, 12016, 13485, 11996) AND DivActualElapsedTime BETWEEN 567 AND 250 GROUP BY AirlineID, OriginStateName  ORDER BY AirlineID, OriginStateName LIMIT 5"]}
{"sql":"SELECT DestState FROM mytable WHERE DivTailNums IN ('N297WN', 'N839AS', 'N940DN', 'N907DL', 'N4UCAA') LIMIT 16","hsqls":["SELECT DestState FROM mytable WHERE (DivTailNums[1] IN ('N297WN', 'N839AS', 'N940DN', 'N907DL', 'N4UCAA') OR DivTailNums[2] IN ('N297WN', 'N839AS', 'N940DN', 'N907DL', 'N4UCAA') OR DivTailNums[3] IN ('N297WN', 'N839AS', 'N940DN', 'N907DL', 'N4UCAA') OR DivTailNums[4] IN ('N297WN', 'N839AS', 'N940DN', 'N907DL', 'N4UCAA') OR DivTailNums[5] IN ('N297WN', 'N839AS', 'N940DN', 'N907DL', 'N4UCAA')) LIMIT 10000"]}
{"sql":"SELECT DestStateName FROM mytable WHERE CarrierDelay > 45 AND WheelsOn BETWEEN 1123 AND 158 AND OriginCityName BETWEEN 'Columbus, GA' AND 'Boston, MA' ORDER BY OriginCityMarketID LIMIT 7"}
{"sql":"SELECT FlightDate FROM mytable WHERE DepDelayMinutes < 182.0 ORDER BY DepDelay, DivDistance LIMIT 5"}
{"sql":"SELECT DestWac, LongestAddGTime, ArrTimeBlk, COUNT(*) FROM mytable GROUP BY DestWac, LongestAddGTime, ArrTimeBlk  ORDER BY DestWac, LongestAddGTime, ArrTimeBlk LIMIT 24","hsqls":["SELECT DestWac, LongestAddGTime, ArrTimeBlk, COUNT(*) FROM mytable GROUP BY DestWac, LongestAddGTime, ArrTimeBlk  ORDER BY DestWac, LongestAddGTime, ArrTimeBlk LIMIT 24"]}
{"sql":"SELECT DayOfWeek, MIN(OriginAirportSeqID), MAX(DepDelayMinutes), MIN(DistanceGroup) FROM mytable WHERE WeatherDelay < 92 AND DestStateName NOT IN ('Colorado', 'Arkansas', 'New Jersey') AND Dest NOT IN ('PHF', 'BTM', 'SEA', 'BMI') GROUP BY DayOfWeek  ORDER BY DayOfWeek LIMIT 7","hsqls":["SELECT DayOfWeek, MIN(OriginAirportSeqID), MAX(DepDelayMinutes), MIN(DistanceGroup) FROM mytable WHERE WeatherDelay < 92 AND DestStateName NOT IN ('Colorado', 'Arkansas', 'New Jersey') AND Dest NOT IN ('PHF', 'BTM', 'SEA', 'BMI') GROUP BY DayOfWeek  ORDER BY DayOfWeek LIMIT 7"]}
{"sql":"SELECT AirTime, \"Month\", CRSElapsedTime, SUM(WheelsOff), MAX(TaxiIn), SUM(DayOfWeek) FROM mytable WHERE DivArrDelay BETWEEN 1045 AND 200 OR DayOfWeek IN (3, 2, 1) GROUP BY AirTime, \"Month\", CRSElapsedTime LIMIT 18","hsqls":["SELECT AirTime, Month, CRSElapsedTime, SUM(WheelsOff), MAX(TaxiIn), SUM(DayOfWeek) FROM mytable WHERE DivArrDelay BETWEEN 1045 AND 200 OR DayOfWeek IN (3, 2, 1) GROUP BY AirTime, Month, CRSElapsedTime LIMIT 18"]}
{"sql":"SELECT Quarter, DivArrDelay, MAX(DepDel15), SUM(DestWac), SUM(DivActualElapsedTime) FROM mytable WHERE DivAirports = 'BNA' AND OriginStateName BETWEEN 'Maryland' AND 'Indiana' OR DivWheelsOffs BETWEEN 914 AND 1940 GROUP BY Quarter, DivArrDelay LIMIT 14","hsqls":["SELECT Quarter, DivArrDelay, MAX(DepDel15), SUM(DestWac), SUM(DivActualElapsedTime) FROM mytable WHERE (DivAirports[1] = 'BNA' OR DivAirports[2] = 'BNA' OR DivAirports[3] = 'BNA' OR DivAirports[4] = 'BNA' OR DivAirports[5] = 'BNA') AND OriginStateName BETWEEN 'Maryland' AND 'Indiana' OR (DivWheelsOffs[1] BETWEEN 914 AND 1940 OR DivWheelsOffs[2] BETWEEN 914 AND 1940 OR DivWheelsOffs[3] BETWEEN 914 AND 1940 OR DivWheelsOffs[4] BETWEEN 914 AND 1940 OR DivWheelsOffs[5] BETWEEN 914 AND 1940) GROUP BY Quarter, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, DestWac, DivActualElapsedTime, MAX(WheelsOff), MIN(NASDelay) FROM mytable WHERE Distance BETWEEN 1565 AND 163 OR FlightNum IN (4186, 6341, 5308, 1952, 2774) GROUP BY DivReachedDest, DestWac, DivActualElapsedTime  ORDER BY DivReachedDest, DestWac, DivActualElapsedTime LIMIT 27","hsqls":["SELECT DivReachedDest, DestWac, DivActualElapsedTime, MAX(WheelsOff), MIN(NASDelay) FROM mytable WHERE Distance BETWEEN 1565 AND 163 OR FlightNum IN (4186, 6341, 5308, 1952, 2774) GROUP BY DivReachedDest, DestWac, DivActualElapsedTime  ORDER BY DivReachedDest, DestWac, DivActualElapsedTime LIMIT 27"]}
{"sql":"SELECT \"Year\", FirstDepTime, ArrDel15 FROM mytable ORDER BY DestCityName, AirlineID, \"Month\" LIMIT 11","hsqls":["SELECT Year, FirstDepTime, ArrDel15 FROM mytable ORDER BY DestCityName, AirlineID, `Month` LIMIT 11"]}
{"sql":"SELECT OriginAirportSeqID FROM mytable WHERE DistanceGroup BETWEEN 7 AND 4 ORDER BY CarrierDelay, CRSArrTime LIMIT 9"}
{"sql":"SELECT MIN(OriginStateFips), AVG(OriginAirportSeqID), SUM(AirTime) FROM mytable WHERE DivWheelsOns IN (2041, 2350, 1553, 1546) LIMIT 10","hsqls":["SELECT MIN(OriginStateFips), AVG(OriginAirportSeqID), SUM(AirTime)  FROM mytable WHERE (DivWheelsOns[1] IN (2041, 2350, 1553, 1546) OR DivWheelsOns[2] IN (2041, 2350, 1553, 1546) OR DivWheelsOns[3] IN (2041, 2350, 1553, 1546) OR DivWheelsOns[4] IN (2041, 2350, 1553, 1546) OR DivWheelsOns[5] IN (2041, 2350, 1553, 1546)) LIMIT 10000"]}
{"sql":"SELECT ArrTime, CRSElapsedTime, SUM(DestAirportID) FROM mytable WHERE ArrTimeBlk > '1000-1059' AND DivLongestGTimes IN (107.0) GROUP BY ArrTime, CRSElapsedTime LIMIT 15","hsqls":["SELECT ArrTime, CRSElapsedTime, SUM(DestAirportID) FROM mytable WHERE ArrTimeBlk > '1000-1059' AND (DivLongestGTimes[1] IN (107.0) OR DivLongestGTimes[2] IN (107.0) OR DivLongestGTimes[3] IN (107.0) OR DivLongestGTimes[4] IN (107.0) OR DivLongestGTimes[5] IN (107.0)) GROUP BY ArrTime, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivAirportSeqIDs BETWEEN 1169703 AND 1320302 AND Quarter BETWEEN 1 AND 1 LIMIT 29","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1169703 AND 1320302 OR DivAirportSeqIDs[2] BETWEEN 1169703 AND 1320302 OR DivAirportSeqIDs[3] BETWEEN 1169703 AND 1320302 OR DivAirportSeqIDs[4] BETWEEN 1169703 AND 1320302 OR DivAirportSeqIDs[5] BETWEEN 1169703 AND 1320302) AND Quarter BETWEEN 1 AND 1 LIMIT 10000"]}
{"sql":"SELECT Dest, AirTime, DayOfWeek FROM mytable WHERE OriginStateFips < 18 OR SecurityDelay >= 8 ORDER BY TaxiIn, ArrTimeBlk, DaysSinceEpoch LIMIT 11"}
{"sql":"SELECT DivWheelsOns, Carrier FROM mytable WHERE DestStateName BETWEEN 'West Virginia' AND 'Massachusetts' AND DayOfWeek <> 1 ORDER BY Diverted, Cancelled, ArrivalDelayGroups LIMIT 11","hsqls":["SELECT DivWheelsOns, Carrier FROM mytable WHERE DestStateName BETWEEN 'West Virginia' AND 'Massachusetts' AND DayOfWeek <> 1 ORDER BY Diverted, Cancelled, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE FirstDepTime >= 1942 ORDER BY SecurityDelay, ArrTime, AirTime LIMIT 21"}
{"sql":"SELECT \"Year\", Distance, \"Month\", MIN(TotalAddGTime), MAX(DivArrDelay), MAX(ArrTime) FROM mytable GROUP BY \"Year\", Distance, \"Month\" LIMIT 15","hsqls":["SELECT Year, Distance, Month, MIN(TotalAddGTime), MAX(DivArrDelay), MAX(ArrTime) FROM mytable GROUP BY Year, Distance, `Month` LIMIT 15"]}
{"sql":"SELECT CarrierDelay, COUNT(Flights), MIN(CRSDepTime), MIN(DayOfWeek) FROM mytable WHERE DepartureDelayGroups NOT IN (2, 1, 0, -1, -9999) OR DestWac >= 23 AND ArrTime <= 2316 GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 3","hsqls":["SELECT CarrierDelay, COUNT(Flights), MIN(CRSDepTime), MIN(DayOfWeek) FROM mytable WHERE DepartureDelayGroups NOT IN (2, 1, 0, -1, -9999) OR DestWac >= 23 AND ArrTime <= 2316 GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 3"]}
{"sql":"SELECT MIN(DestStateFips), MIN(DayOfWeek) FROM mytable LIMIT 21"}
{"sql":"SELECT MIN(WeatherDelay), MIN(AirlineID) FROM mytable WHERE DestState BETWEEN 'HI' AND 'LA' AND Cancelled >= 0 LIMIT 5"}
{"sql":"SELECT DivWheelsOns, Carrier, Origin FROM mytable WHERE DestStateFips BETWEEN 78 AND 39 OR DivWheelsOns BETWEEN 1326 AND 1535 ORDER BY ArrivalDelayGroups","hsqls":["SELECT DivWheelsOns, Carrier, Origin FROM mytable WHERE DestStateFips BETWEEN 78 AND 39 OR (DivWheelsOns[1] BETWEEN 1326 AND 1535 OR DivWheelsOns[2] BETWEEN 1326 AND 1535 OR DivWheelsOns[3] BETWEEN 1326 AND 1535 OR DivWheelsOns[4] BETWEEN 1326 AND 1535 OR DivWheelsOns[5] BETWEEN 1326 AND 1535) ORDER BY ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime, COUNT(*) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR DepDelayMinutes IN (186.0, 144.0, 109.0, 125.0, 88.0) GROUP BY TotalAddGTime LIMIT 26","hsqls":["SELECT TotalAddGTime, COUNT(*) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR DepDelayMinutes IN (186.0, 144.0, 109.0, 125.0, 88.0) GROUP BY TotalAddGTime LIMIT 26"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE AirlineID IN (20437, 19805, 20409, 20355) ORDER BY DepDel15 LIMIT 27"}
{"sql":"SELECT TaxiOut, FlightDate, OriginCityName, COUNT(*) FROM mytable GROUP BY TaxiOut, FlightDate, OriginCityName  ORDER BY TaxiOut, FlightDate, OriginCityName LIMIT 23","hsqls":["SELECT TaxiOut, FlightDate, OriginCityName, COUNT(*) FROM mytable GROUP BY TaxiOut, FlightDate, OriginCityName  ORDER BY TaxiOut, FlightDate, OriginCityName LIMIT 23"]}
{"sql":"SELECT CarrierDelay, DestCityName, CancellationCode FROM mytable WHERE Flights NOT IN (1) AND TaxiIn BETWEEN 6 AND 44 ORDER BY DestWac, OriginCityMarketID, TotalAddGTime LIMIT 25"}
{"sql":"SELECT FlightNum, ArrDelayMinutes, ActualElapsedTime, COUNT(*) FROM mytable WHERE Carrier NOT IN ('OO', 'MQ') AND DivLongestGTimes IN (107.0, 79.0, 95.0, 90.0) OR ArrTimeBlk BETWEEN '1600-1659' AND '2000-2059' GROUP BY FlightNum, ArrDelayMinutes, ActualElapsedTime LIMIT 7","hsqls":["SELECT FlightNum, ArrDelayMinutes, ActualElapsedTime, COUNT(*) FROM mytable WHERE Carrier NOT IN ('OO', 'MQ') AND (DivLongestGTimes[1] IN (107.0, 79.0, 95.0, 90.0) OR DivLongestGTimes[2] IN (107.0, 79.0, 95.0, 90.0) OR DivLongestGTimes[3] IN (107.0, 79.0, 95.0, 90.0) OR DivLongestGTimes[4] IN (107.0, 79.0, 95.0, 90.0) OR DivLongestGTimes[5] IN (107.0, 79.0, 95.0, 90.0)) OR ArrTimeBlk BETWEEN '1600-1659' AND '2000-2059' GROUP BY FlightNum, ArrDelayMinutes, ActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT CRSDepTime, COUNT(DivActualElapsedTime) FROM mytable WHERE TaxiIn = 75 AND AirlineID BETWEEN 19930 AND 20437 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 17","hsqls":["SELECT CRSDepTime, COUNT(DivActualElapsedTime) FROM mytable WHERE TaxiIn = 75 AND AirlineID BETWEEN 19930 AND 20437 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 17"]}
{"sql":"SELECT DestAirportSeqID, DaysSinceEpoch FROM mytable WHERE DivLongestGTimes BETWEEN 6.0 AND 96.0 AND TaxiOut BETWEEN 33 AND 32 ORDER BY OriginAirportSeqID, OriginCityMarketID LIMIT 27","hsqls":["SELECT DestAirportSeqID, DaysSinceEpoch FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 6.0 AND 96.0 OR DivLongestGTimes[2] BETWEEN 6.0 AND 96.0 OR DivLongestGTimes[3] BETWEEN 6.0 AND 96.0 OR DivLongestGTimes[4] BETWEEN 6.0 AND 96.0 OR DivLongestGTimes[5] BETWEEN 6.0 AND 96.0) AND TaxiOut BETWEEN 33 AND 32 ORDER BY OriginAirportSeqID, OriginCityMarketID LIMIT 10000"]}
{"sql":"SELECT CRSArrTime, CarrierDelay, DaysSinceEpoch, COUNT(*) FROM mytable WHERE NASDelay BETWEEN 146 AND 202 GROUP BY CRSArrTime, CarrierDelay, DaysSinceEpoch  ORDER BY CRSArrTime, CarrierDelay, DaysSinceEpoch LIMIT 19","hsqls":["SELECT CRSArrTime, CarrierDelay, DaysSinceEpoch, COUNT(*) FROM mytable WHERE NASDelay BETWEEN 146 AND 202 GROUP BY CRSArrTime, CarrierDelay, DaysSinceEpoch  ORDER BY CRSArrTime, CarrierDelay, DaysSinceEpoch LIMIT 19"]}
{"sql":"SELECT OriginAirportSeqID, AirTime, DaysSinceEpoch, COUNT(*) FROM mytable WHERE SecurityDelay BETWEEN 18 AND 18 AND ArrivalDelayGroups NOT IN (3, 10, -2, 7, 6) AND ArrDelayMinutes IN (246.0, 49.0, 119.0, 455.0, 8.0) GROUP BY OriginAirportSeqID, AirTime, DaysSinceEpoch  ORDER BY OriginAirportSeqID, AirTime, DaysSinceEpoch LIMIT 27","hsqls":["SELECT OriginAirportSeqID, AirTime, DaysSinceEpoch, COUNT(*) FROM mytable WHERE SecurityDelay BETWEEN 18 AND 18 AND ArrivalDelayGroups NOT IN (3, 10, -2, 7, 6) AND ArrDelayMinutes IN (246.0, 49.0, 119.0, 455.0, 8.0) GROUP BY OriginAirportSeqID, AirTime, DaysSinceEpoch  ORDER BY OriginAirportSeqID, AirTime, DaysSinceEpoch LIMIT 27"]}
{"sql":"SELECT OriginState, DestCityMarketID, OriginStateName, COUNT(*) FROM mytable WHERE TaxiIn BETWEEN 101 AND 36 AND Diverted BETWEEN 0 AND 1 GROUP BY OriginState, DestCityMarketID, OriginStateName  ORDER BY OriginState, DestCityMarketID, OriginStateName LIMIT 15","hsqls":["SELECT OriginState, DestCityMarketID, OriginStateName, COUNT(*) FROM mytable WHERE TaxiIn BETWEEN 101 AND 36 AND Diverted BETWEEN 0 AND 1 GROUP BY OriginState, DestCityMarketID, OriginStateName  ORDER BY OriginState, DestCityMarketID, OriginStateName LIMIT 15"]}
{"sql":"SELECT DivAirportLandings, OriginWac, WheelsOn, COUNT(CRSDepTime) FROM mytable WHERE ArrivalDelayGroups NOT IN (2, 10, 1, 5) AND ActualElapsedTime BETWEEN 72 AND 285 AND OriginCityMarketID NOT IN (31721) GROUP BY DivAirportLandings, OriginWac, WheelsOn  ORDER BY DivAirportLandings, OriginWac, WheelsOn LIMIT 15","hsqls":["SELECT DivAirportLandings, OriginWac, WheelsOn, COUNT(CRSDepTime) FROM mytable WHERE ArrivalDelayGroups NOT IN (2, 10, 1, 5) AND ActualElapsedTime BETWEEN 72 AND 285 AND OriginCityMarketID NOT IN (31721) GROUP BY DivAirportLandings, OriginWac, WheelsOn  ORDER BY DivAirportLandings, OriginWac, WheelsOn LIMIT 15"]}
{"sql":"SELECT OriginStateFips, ActualElapsedTime, DivTotalGTimes FROM mytable WHERE OriginStateFips >= 2 LIMIT 16","hsqls":["SELECT OriginStateFips, ActualElapsedTime, DivTotalGTimes FROM mytable WHERE OriginStateFips >= 2 LIMIT 10000"]}
{"sql":"SELECT DestStateFips, OriginCityName FROM mytable WHERE DivAirportSeqIDs IN (1410702, 1468902, 1052103, 1086803) AND DestState BETWEEN 'CA' AND 'AL' ORDER BY DayofMonth LIMIT 28","hsqls":["SELECT DestStateFips, OriginCityName FROM mytable WHERE (DivAirportSeqIDs[1] IN (1410702, 1468902, 1052103, 1086803) OR DivAirportSeqIDs[2] IN (1410702, 1468902, 1052103, 1086803) OR DivAirportSeqIDs[3] IN (1410702, 1468902, 1052103, 1086803) OR DivAirportSeqIDs[4] IN (1410702, 1468902, 1052103, 1086803) OR DivAirportSeqIDs[5] IN (1410702, 1468902, 1052103, 1086803)) AND DestState BETWEEN 'CA' AND 'AL' ORDER BY DayofMonth LIMIT 10000"]}
{"sql":"SELECT Diverted, ArrDel15 FROM mytable WHERE DepDelayMinutes <= 260.0 ORDER BY DepartureDelayGroups, FirstDepTime, DepDel15 LIMIT 14"}
{"sql":"SELECT NASDelay, DepDel15, WheelsOn FROM mytable ORDER BY OriginStateFips, OriginCityName, ArrDel15 LIMIT 23"}
{"sql":"SELECT AVG(DepDel15), COUNT(Cancelled) FROM mytable WHERE Cancelled BETWEEN 0 AND 1 AND DivAirports IN ('GNV', 'MRY', 'PUB', 'PIA', 'MAF') LIMIT 29","hsqls":["SELECT AVG(DepDel15), COUNT(Cancelled)  FROM mytable WHERE Cancelled BETWEEN 0 AND 1 AND (DivAirports[1] IN ('GNV', 'MRY', 'PUB', 'PIA', 'MAF') OR DivAirports[2] IN ('GNV', 'MRY', 'PUB', 'PIA', 'MAF') OR DivAirports[3] IN ('GNV', 'MRY', 'PUB', 'PIA', 'MAF') OR DivAirports[4] IN ('GNV', 'MRY', 'PUB', 'PIA', 'MAF') OR DivAirports[5] IN ('GNV', 'MRY', 'PUB', 'PIA', 'MAF')) LIMIT 10000"]}
{"sql":"SELECT Cancelled, MAX(FirstDepTime), SUM(ArrTime) FROM mytable WHERE TaxiIn NOT IN (3, 116, 18) AND OriginStateFips >= 17 GROUP BY Cancelled  ORDER BY Cancelled LIMIT 23","hsqls":["SELECT Cancelled, MAX(FirstDepTime), SUM(ArrTime) FROM mytable WHERE TaxiIn NOT IN (3, 116, 18) AND OriginStateFips >= 17 GROUP BY Cancelled  ORDER BY Cancelled LIMIT 23"]}
{"sql":"SELECT DepTime FROM mytable WHERE DivReachedDest >= -9999 AND CancellationCode IN ('A', 'B', 'C', 'noodles') OR DestState BETWEEN 'MO' AND 'TX' ORDER BY FlightDate, OriginStateName LIMIT 8"}
{"sql":"SELECT MIN(OriginAirportSeqID), AVG(OriginAirportSeqID) FROM mytable WHERE DestCityName BETWEEN 'Worcester, MA' AND 'Minneapolis, MN' LIMIT 13"}
{"sql":"SELECT DestState, DepTime, TailNum, MIN(DepDelayMinutes), MIN(DestAirportID), AVG(OriginAirportID) FROM mytable WHERE DivAirportSeqIDs < 1110902 OR DestAirportID IN (13422, 10918) GROUP BY DestState, DepTime, TailNum LIMIT 26","hsqls":["SELECT DestState, DepTime, TailNum, MIN(DepDelayMinutes), MIN(DestAirportID), AVG(OriginAirportID) FROM mytable WHERE (DivAirportSeqIDs[1] < 1110902 OR DivAirportSeqIDs[2] < 1110902 OR DivAirportSeqIDs[3] < 1110902 OR DivAirportSeqIDs[4] < 1110902 OR DivAirportSeqIDs[5] < 1110902) OR DestAirportID IN (13422, 10918) GROUP BY DestState, DepTime, TailNum LIMIT 10000"]}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE DivActualElapsedTime BETWEEN 214 AND 461 OR DivDistance BETWEEN 1262 AND 449 AND CRSArrTime BETWEEN 2102 AND 2221 ORDER BY DepTime, DestCityName, AirlineID LIMIT 16","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE DivActualElapsedTime BETWEEN 214 AND 461 OR DivDistance BETWEEN 1262 AND 449 AND CRSArrTime BETWEEN 2102 AND 2221 ORDER BY DepTime, DestCityName, AirlineID LIMIT 10000"]}
{"sql":"SELECT ArrivalDelayGroups, COUNT(*) FROM mytable WHERE DestStateFips <> 1 OR FlightDate BETWEEN '2014-01-17' AND '2014-01-15' OR \"Year\" >= 2014 GROUP BY ArrivalDelayGroups","hsqls":["SELECT ArrivalDelayGroups, COUNT(*) FROM mytable WHERE DestStateFips <> 1 OR FlightDate BETWEEN '2014-01-17' AND '2014-01-15' OR `Year` >= 2014 GROUP BY ArrivalDelayGroups"]}
{"sql":"SELECT DestState, DepTime FROM mytable WHERE Origin BETWEEN 'SCC' AND 'OGG' AND OriginAirportID <> 15016 ORDER BY LateAircraftDelay LIMIT 23"}
{"sql":"SELECT DivActualElapsedTime, COUNT(*) FROM mytable WHERE DivTotalGTimes < 52 OR Diverted <= 0 GROUP BY DivActualElapsedTime LIMIT 17","hsqls":["SELECT DivActualElapsedTime, COUNT(*) FROM mytable WHERE (DivTotalGTimes[1] < 52 OR DivTotalGTimes[2] < 52 OR DivTotalGTimes[3] < 52 OR DivTotalGTimes[4] < 52 OR DivTotalGTimes[5] < 52) OR Diverted <= 0 GROUP BY DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT TaxiIn, \"Month\" FROM mytable WHERE DepDelay BETWEEN 379.0 AND 10.0 OR DepTimeBlk IN ('0800-0859') ORDER BY ActualElapsedTime, DivAirportLandings LIMIT 18","hsqls":["SELECT TaxiIn, `Month` FROM mytable WHERE DepDelay BETWEEN 379.0 AND 10.0 OR DepTimeBlk IN ('0800-0859') ORDER BY ActualElapsedTime, DivAirportLandings LIMIT 18"]}
{"sql":"SELECT WheelsOff, COUNT(OriginAirportSeqID), AVG(LongestAddGTime), MIN(CRSElapsedTime) FROM mytable GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 12","hsqls":["SELECT WheelsOff, COUNT(OriginAirportSeqID), AVG(LongestAddGTime), MIN(CRSElapsedTime) FROM mytable GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 12"]}
{"sql":"SELECT OriginCityName, DepTimeBlk, ArrDelay FROM mytable WHERE DayofMonth <= 1 ORDER BY Diverted, Cancelled, AirTime LIMIT 20"}
{"sql":"SELECT CarrierDelay, DivWheelsOffs FROM mytable WHERE DayOfWeek BETWEEN 5 AND 2 AND DepDelayMinutes NOT IN (114.0, 89.0, 91.0, 75.0) LIMIT 4","hsqls":["SELECT CarrierDelay, DivWheelsOffs FROM mytable WHERE DayOfWeek BETWEEN 5 AND 2 AND DepDelayMinutes NOT IN (114.0, 89.0, 91.0, 75.0) LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime, TailNum, MIN(Cancelled), AVG(DestWac) FROM mytable WHERE TaxiIn <= 67 GROUP BY TotalAddGTime, TailNum  ORDER BY TotalAddGTime, TailNum LIMIT 29","hsqls":["SELECT TotalAddGTime, TailNum, MIN(Cancelled), AVG(DestWac) FROM mytable WHERE TaxiIn <= 67 GROUP BY TotalAddGTime, TailNum  ORDER BY TotalAddGTime, TailNum LIMIT 29"]}
{"sql":"SELECT MAX(AirlineID), SUM(Diverted) FROM mytable WHERE OriginCityName <> 'St. George, UT' OR WheelsOn BETWEEN 1920 AND 1837 LIMIT 14"}
{"sql":"SELECT DestStateFips, DestCityName, DestAirportID, MIN(AirlineID) FROM mytable GROUP BY DestStateFips, DestCityName, DestAirportID  ORDER BY DestStateFips, DestCityName, DestAirportID LIMIT 25","hsqls":["SELECT DestStateFips, DestCityName, DestAirportID, MIN(AirlineID) FROM mytable GROUP BY DestStateFips, DestCityName, DestAirportID  ORDER BY DestStateFips, DestCityName, DestAirportID LIMIT 25"]}
{"sql":"SELECT TailNum, \"Month\", MAX(Quarter) FROM mytable WHERE DivAirports >= 'RFD' AND DivAirportSeqIDs IN (1199603) GROUP BY TailNum, \"Month\" LIMIT 5","hsqls":["SELECT TailNum, Month, MAX(Quarter) FROM mytable WHERE (DivAirports[1] >= 'RFD' OR DivAirports[2] >= 'RFD' OR DivAirports[3] >= 'RFD' OR DivAirports[4] >= 'RFD' OR DivAirports[5] >= 'RFD') AND (DivAirportSeqIDs[1] IN (1199603) OR DivAirportSeqIDs[2] IN (1199603) OR DivAirportSeqIDs[3] IN (1199603) OR DivAirportSeqIDs[4] IN (1199603) OR DivAirportSeqIDs[5] IN (1199603)) GROUP BY TailNum, `Month` LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, CRSDepTime, DivActualElapsedTime FROM mytable ORDER BY DestStateName, DepDel15 LIMIT 9"}
{"sql":"SELECT COUNT(WheelsOn) FROM mytable WHERE WheelsOff = 1526 OR DestAirportSeqID BETWEEN 1330303 AND 1104202 OR CancellationCode > 'A' LIMIT 12"}
{"sql":"SELECT Carrier, ActualElapsedTime, ArrDelay FROM mytable WHERE DivAirports = 'ABQ' OR LateAircraftDelay IN (98) OR WheelsOn BETWEEN 1024 AND 1257 ORDER BY DestWac, DivAirportLandings LIMIT 3","hsqls":["SELECT Carrier, ActualElapsedTime, ArrDelay FROM mytable WHERE (DivAirports[1] = 'ABQ' OR DivAirports[2] = 'ABQ' OR DivAirports[3] = 'ABQ' OR DivAirports[4] = 'ABQ' OR DivAirports[5] = 'ABQ') OR LateAircraftDelay IN (98) OR WheelsOn BETWEEN 1024 AND 1257 ORDER BY DestWac, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT OriginStateName FROM mytable WHERE DivAirportIDs IN (10980) LIMIT 7","hsqls":["SELECT OriginStateName FROM mytable WHERE (DivAirportIDs[1] IN (10980) OR DivAirportIDs[2] IN (10980) OR DivAirportIDs[3] IN (10980) OR DivAirportIDs[4] IN (10980) OR DivAirportIDs[5] IN (10980)) LIMIT 10000"]}
{"sql":"SELECT TaxiOut, CarrierDelay, OriginAirportID FROM mytable WHERE Diverted <> 1 AND WheelsOff BETWEEN 2026 AND 1651 ORDER BY DestState LIMIT 22"}
{"sql":"SELECT OriginAirportSeqID, DestCityMarketID, MAX(CRSArrTime), SUM(Diverted) FROM mytable WHERE \"Year\" < 2014 OR CancellationCode BETWEEN 'A' AND 'noodles' AND LateAircraftDelay BETWEEN 147 AND 26 GROUP BY OriginAirportSeqID, DestCityMarketID LIMIT 8","hsqls":["SELECT OriginAirportSeqID, DestCityMarketID, MAX(CRSArrTime), SUM(Diverted) FROM mytable WHERE `Year` < 2014 OR CancellationCode BETWEEN 'A' AND 'noodles' AND LateAircraftDelay BETWEEN 147 AND 26 GROUP BY OriginAirportSeqID, DestCityMarketID LIMIT 8"]}
{"sql":"SELECT COUNT(DistanceGroup), SUM(OriginWac) FROM mytable LIMIT 12"}
{"sql":"SELECT AVG(Diverted) FROM mytable LIMIT 28"}
{"sql":"SELECT TaxiOut, DivActualElapsedTime, COUNT(*) FROM mytable WHERE ArrTime >= 1534 GROUP BY TaxiOut, DivActualElapsedTime  ORDER BY TaxiOut, DivActualElapsedTime LIMIT 29","hsqls":["SELECT TaxiOut, DivActualElapsedTime, COUNT(*) FROM mytable WHERE ArrTime >= 1534 GROUP BY TaxiOut, DivActualElapsedTime  ORDER BY TaxiOut, DivActualElapsedTime LIMIT 29"]}
{"sql":"SELECT Dest, NASDelay, CRSElapsedTime FROM mytable WHERE DivDistance <= 17 LIMIT 26"}
{"sql":"SELECT DepTime, ArrivalDelayGroups, MAX(FirstDepTime), MIN(CRSDepTime) FROM mytable GROUP BY DepTime, ArrivalDelayGroups","hsqls":["SELECT DepTime, ArrivalDelayGroups, MAX(FirstDepTime), MIN(CRSDepTime) FROM mytable GROUP BY DepTime, ArrivalDelayGroups"]}
{"sql":"SELECT DestWac, DepTime, CancellationCode, MAX(DestCityMarketID), MAX(OriginAirportID), MAX(ActualElapsedTime) FROM mytable GROUP BY DestWac, DepTime, CancellationCode  ORDER BY DestWac, DepTime, CancellationCode LIMIT 18","hsqls":["SELECT DestWac, DepTime, CancellationCode, MAX(DestCityMarketID), MAX(OriginAirportID), MAX(ActualElapsedTime) FROM mytable GROUP BY DestWac, DepTime, CancellationCode  ORDER BY DestWac, DepTime, CancellationCode LIMIT 18"]}
{"sql":"SELECT DestCityName FROM mytable WHERE TaxiOut IN (29) OR DepDelay IN (306.0) OR DivTotalGTimes BETWEEN 135 AND 139 ORDER BY CarrierDelay, DivAirportLandings, OriginAirportID LIMIT 11","hsqls":["SELECT DestCityName FROM mytable WHERE TaxiOut IN (29) OR DepDelay IN (306.0) OR (DivTotalGTimes[1] BETWEEN 135 AND 139 OR DivTotalGTimes[2] BETWEEN 135 AND 139 OR DivTotalGTimes[3] BETWEEN 135 AND 139 OR DivTotalGTimes[4] BETWEEN 135 AND 139 OR DivTotalGTimes[5] BETWEEN 135 AND 139) ORDER BY CarrierDelay, DivAirportLandings, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT Quarter, FlightDate, DepTime FROM mytable WHERE DivWheelsOns > 1502 AND NASDelay BETWEEN 55 AND 224 AND OriginStateFips <> 26 ORDER BY DestAirportID LIMIT 6","hsqls":["SELECT Quarter, FlightDate, DepTime FROM mytable WHERE (DivWheelsOns[1] > 1502 OR DivWheelsOns[2] > 1502 OR DivWheelsOns[3] > 1502 OR DivWheelsOns[4] > 1502 OR DivWheelsOns[5] > 1502) AND NASDelay BETWEEN 55 AND 224 AND OriginStateFips <> 26 ORDER BY DestAirportID LIMIT 10000"]}
{"sql":"SELECT DestState, AirTime, AirlineID, MAX(WheelsOff), COUNT(DivActualElapsedTime), AVG(ArrivalDelayGroups) FROM mytable WHERE TaxiOut <> 35 AND DestStateFips IN (30, 42, 37) AND Carrier BETWEEN 'AA' AND 'VX' GROUP BY DestState, AirTime, AirlineID  ORDER BY DestState, AirTime, AirlineID LIMIT 8","hsqls":["SELECT DestState, AirTime, AirlineID, MAX(WheelsOff), COUNT(DivActualElapsedTime), AVG(ArrivalDelayGroups) FROM mytable WHERE TaxiOut <> 35 AND DestStateFips IN (30, 42, 37) AND Carrier BETWEEN 'AA' AND 'VX' GROUP BY DestState, AirTime, AirlineID  ORDER BY DestState, AirTime, AirlineID LIMIT 8"]}
{"sql":"SELECT Distance, TailNum, COUNT(DepTimeBlk), MIN(WheelsOff), SUM(DestStateFips) FROM mytable WHERE Diverted BETWEEN 0 AND 0 AND DayOfWeek BETWEEN 3 AND 3 GROUP BY Distance, TailNum  ORDER BY Distance, TailNum LIMIT 19","hsqls":["SELECT Distance, TailNum, COUNT(DepTimeBlk), MIN(WheelsOff), SUM(DestStateFips) FROM mytable WHERE Diverted BETWEEN 0 AND 0 AND DayOfWeek BETWEEN 3 AND 3 GROUP BY Distance, TailNum  ORDER BY Distance, TailNum LIMIT 19"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Cancelled BETWEEN 1 AND 0 OR DivLongestGTimes BETWEEN 47.0 AND 95.0 OR OriginCityMarketID <> 34524 LIMIT 6","hsqls":["SELECT COUNT(*) FROM mytable WHERE Cancelled BETWEEN 1 AND 0 OR (DivLongestGTimes[1] BETWEEN 47.0 AND 95.0 OR DivLongestGTimes[2] BETWEEN 47.0 AND 95.0 OR DivLongestGTimes[3] BETWEEN 47.0 AND 95.0 OR DivLongestGTimes[4] BETWEEN 47.0 AND 95.0 OR DivLongestGTimes[5] BETWEEN 47.0 AND 95.0) OR OriginCityMarketID <> 34524 LIMIT 10000"]}
{"sql":"SELECT AVG(OriginStateFips) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND DivActualElapsedTime BETWEEN 454 AND 645 OR DestWac BETWEEN 39 AND 66 LIMIT 3","hsqls":["SELECT AVG(OriginStateFips) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND DivActualElapsedTime BETWEEN 454 AND 645 OR DestWac BETWEEN 39 AND 66 LIMIT 3"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 1"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrDelayMinutes IN (155.0, 332.0, 43.0, 84.0, 209.0) OR DestStateName BETWEEN 'Delaware' AND 'South Dakota' OR ArrTimeBlk NOT IN ('2000-2059', '1100-1159', '0800-0859', '1900-1959', '1500-1559') LIMIT 8"}
{"sql":"SELECT CRSElapsedTime FROM mytable ORDER BY DestCityMarketID, DivAirportLandings LIMIT 4"}
{"sql":"SELECT DestState, ArrTime, COUNT(CancellationCode), AVG(DivAirportLandings) FROM mytable WHERE DestAirportID >= 13424 OR DestAirportSeqID BETWEEN 1062702 AND 1463502 AND CRSArrTime <> 2157 GROUP BY DestState, ArrTime  ORDER BY DestState, ArrTime LIMIT 2","hsqls":["SELECT DestState, ArrTime, COUNT(CancellationCode), AVG(DivAirportLandings) FROM mytable WHERE DestAirportID >= 13424 OR DestAirportSeqID BETWEEN 1062702 AND 1463502 AND CRSArrTime <> 2157 GROUP BY DestState, ArrTime  ORDER BY DestState, ArrTime LIMIT 2"]}
{"sql":"SELECT SecurityDelay, DepTime, DestAirportID, COUNT(DestState) FROM mytable WHERE Quarter <> 1 AND WheelsOn BETWEEN 1440 AND 1050 AND DayofMonth < 10 GROUP BY SecurityDelay, DepTime, DestAirportID  ORDER BY SecurityDelay, DepTime, DestAirportID LIMIT 23","hsqls":["SELECT SecurityDelay, DepTime, DestAirportID, COUNT(DestState) FROM mytable WHERE Quarter <> 1 AND WheelsOn BETWEEN 1440 AND 1050 AND DayofMonth < 10 GROUP BY SecurityDelay, DepTime, DestAirportID  ORDER BY SecurityDelay, DepTime, DestAirportID LIMIT 23"]}
{"sql":"SELECT TaxiIn, DivTailNums, DivWheelsOffs FROM mytable LIMIT 20","hsqls":["SELECT TaxiIn, DivTailNums, DivWheelsOffs FROM mytable LIMIT 10000"]}
{"sql":"SELECT Quarter, AVG(NASDelay) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 3","hsqls":["SELECT Quarter, AVG(NASDelay) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 3"]}
{"sql":"SELECT AirTime FROM mytable ORDER BY DestCityName LIMIT 2"}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE Carrier BETWEEN 'WN' AND 'DL' LIMIT 20"}
{"sql":"SELECT ActualElapsedTime, DestCityMarketID FROM mytable WHERE Distance > 911 AND DepDelay BETWEEN 247.0 AND 48.0 AND TaxiIn BETWEEN 49 AND 12 ORDER BY OriginAirportSeqID, OriginCityMarketID, Cancelled LIMIT 13"}
{"sql":"SELECT DestAirportSeqID, TaxiIn FROM mytable WHERE FlightDate < '2014-01-22' OR DestAirportSeqID NOT IN (1025702, 1348602, 1289203, 1027903, 1071302) LIMIT 19"}
{"sql":"SELECT DistanceGroup, MAX(\"Year\"), MIN(DestAirportID), MAX(OriginStateFips) FROM mytable WHERE Origin < 'FAR' GROUP BY DistanceGroup LIMIT 7","hsqls":["SELECT DistanceGroup, MAX(`Year`), MIN(DestAirportID), MAX(OriginStateFips) FROM mytable WHERE Origin < 'FAR' GROUP BY DistanceGroup LIMIT 7"]}
{"sql":"SELECT MIN(FirstDepTime) FROM mytable WHERE AirlineID >= 21171 AND CarrierDelay BETWEEN 37 AND 20 LIMIT 18"}
{"sql":"SELECT DestState, Carrier FROM mytable LIMIT 21"}
{"sql":"SELECT DivAirports FROM mytable LIMIT 23","hsqls":["SELECT DivAirports FROM mytable LIMIT 10000"]}
{"sql":"SELECT SUM(Quarter) FROM mytable WHERE DaysSinceEpoch BETWEEN 16094 AND 16093 OR OriginStateFips >= 41 LIMIT 8"}
{"sql":"SELECT DivWheelsOns, DivAirportSeqIDs, DestAirportSeqID FROM mytable WHERE TaxiOut >= 60 ORDER BY Origin LIMIT 15","hsqls":["SELECT DivWheelsOns, DivAirportSeqIDs, DestAirportSeqID FROM mytable WHERE TaxiOut >= 60 ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT Flights, COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 215 AND 271 AND Flights IN (1) AND LateAircraftDelay BETWEEN 26 AND 9 GROUP BY Flights  ORDER BY Flights LIMIT 11","hsqls":["SELECT Flights, COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 215 AND 271 AND Flights IN (1) AND LateAircraftDelay BETWEEN 26 AND 9 GROUP BY Flights  ORDER BY Flights LIMIT 11"]}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE Origin BETWEEN 'SLC' AND 'PBI' AND DestAirportSeqID BETWEEN 1111102 AND 1295302 AND CRSDepTime BETWEEN 2000 AND 1103","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE Origin BETWEEN 'SLC' AND 'PBI' AND DestAirportSeqID BETWEEN 1111102 AND 1295302 AND CRSDepTime BETWEEN 2000 AND 1103 LIMIT 10000"]}
{"sql":"SELECT TaxiOut, OriginCityName, CancellationCode, SUM(DaysSinceEpoch) FROM mytable GROUP BY TaxiOut, OriginCityName, CancellationCode  ORDER BY TaxiOut, OriginCityName, CancellationCode LIMIT 18","hsqls":["SELECT TaxiOut, OriginCityName, CancellationCode, SUM(DaysSinceEpoch) FROM mytable GROUP BY TaxiOut, OriginCityName, CancellationCode  ORDER BY TaxiOut, OriginCityName, CancellationCode LIMIT 18"]}
{"sql":"SELECT OriginStateFips, DivDistance, SecurityDelay FROM mytable WHERE Quarter IN (1) OR DestAirportSeqID > 1473003 AND FirstDepTime BETWEEN 710 AND 617 ORDER BY FirstDepTime, DepDel15, WheelsOn LIMIT 20"}
{"sql":"SELECT WheelsOff, DistanceGroup, Carrier, MAX(DepTime), MIN(CRSArrTime) FROM mytable WHERE DestCityMarketID <> 30255 OR DivActualElapsedTime > 846 AND DivDistance = 405 GROUP BY WheelsOff, DistanceGroup, Carrier  ORDER BY WheelsOff, DistanceGroup, Carrier LIMIT 16","hsqls":["SELECT WheelsOff, DistanceGroup, Carrier, MAX(DepTime), MIN(CRSArrTime) FROM mytable WHERE DestCityMarketID <> 30255 OR DivActualElapsedTime > 846 AND DivDistance = 405 GROUP BY WheelsOff, DistanceGroup, Carrier  ORDER BY WheelsOff, DistanceGroup, Carrier LIMIT 16"]}
{"sql":"SELECT DepTime FROM mytable WHERE Cancelled BETWEEN 1 AND 1 OR OriginCityMarketID = 32945 ORDER BY DestState, Flights, WeatherDelay LIMIT 12"}
{"sql":"SELECT DivWheelsOns, OriginWac FROM mytable WHERE OriginStateName BETWEEN 'Pennsylvania' AND 'U.S. Virgin Islands' OR LateAircraftDelay BETWEEN 112 AND 183 OR ArrDel15 NOT IN (0, -9999) ORDER BY DivDistance LIMIT 12","hsqls":["SELECT DivWheelsOns, OriginWac FROM mytable WHERE OriginStateName BETWEEN 'Pennsylvania' AND 'U.S. Virgin Islands' OR LateAircraftDelay BETWEEN 112 AND 183 OR ArrDel15 NOT IN (0, -9999) ORDER BY DivDistance LIMIT 10000"]}
{"sql":"SELECT OriginAirportID FROM mytable LIMIT 15"}
{"sql":"SELECT ArrDel15, AirTime, AVG(DepDelay), MIN(DestAirportSeqID) FROM mytable WHERE CRSDepTime BETWEEN 1041 AND 1616 AND LongestAddGTime NOT IN (20) GROUP BY ArrDel15, AirTime  ORDER BY ArrDel15, AirTime LIMIT 4","hsqls":["SELECT ArrDel15, AirTime, AVG(DepDelay), MIN(DestAirportSeqID) FROM mytable WHERE CRSDepTime BETWEEN 1041 AND 1616 AND LongestAddGTime NOT IN (20) GROUP BY ArrDel15, AirTime  ORDER BY ArrDel15, AirTime LIMIT 4"]}
{"sql":"SELECT DestWac, COUNT(*) FROM mytable WHERE DepDelayMinutes NOT IN (191.0, 107.0, 83.0, 304.0, 536.0) AND OriginAirportID BETWEEN 11150 AND 11471 GROUP BY DestWac  ORDER BY DestWac LIMIT 17","hsqls":["SELECT DestWac, COUNT(*) FROM mytable WHERE DepDelayMinutes NOT IN (191.0, 107.0, 83.0, 304.0, 536.0) AND OriginAirportID BETWEEN 11150 AND 11471 GROUP BY DestWac  ORDER BY DestWac LIMIT 17"]}
{"sql":"SELECT ArrivalDelayGroups, OriginStateName FROM mytable WHERE DepDelay NOT IN (-1.0, 224.0, 310.0, 536.0) AND DivArrDelay BETWEEN 47 AND 192 LIMIT 22"}
{"sql":"SELECT DestStateFips, DaysSinceEpoch, COUNT(DivDistance) FROM mytable WHERE OriginCityName BETWEEN 'Bemidji, MN' AND 'Newport News/Williamsburg, VA' OR DivAirportIDs IN (10874) GROUP BY DestStateFips, DaysSinceEpoch LIMIT 3","hsqls":["SELECT DestStateFips, DaysSinceEpoch, COUNT(DivDistance) FROM mytable WHERE OriginCityName BETWEEN 'Bemidji, MN' AND 'Newport News/Williamsburg, VA' OR (DivAirportIDs[1] IN (10874) OR DivAirportIDs[2] IN (10874) OR DivAirportIDs[3] IN (10874) OR DivAirportIDs[4] IN (10874) OR DivAirportIDs[5] IN (10874)) GROUP BY DestStateFips, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT TailNum, UniqueCarrier, OriginAirportID FROM mytable ORDER BY DivArrDelay LIMIT 8"}
{"sql":"SELECT WheelsOff, DepTimeBlk, CRSElapsedTime FROM mytable WHERE DestStateName <= 'New Mexico' OR TotalAddGTime BETWEEN 25 AND 15 ORDER BY TaxiOut LIMIT 25"}
{"sql":"SELECT SUM(WheelsOff), AVG(Diverted), SUM(Distance) FROM mytable WHERE DivTotalGTimes >= 53 LIMIT 18","hsqls":["SELECT SUM(WheelsOff), AVG(Diverted), SUM(Distance)  FROM mytable WHERE (DivTotalGTimes[1] >= 53 OR DivTotalGTimes[2] >= 53 OR DivTotalGTimes[3] >= 53 OR DivTotalGTimes[4] >= 53 OR DivTotalGTimes[5] >= 53) LIMIT 10000"]}
{"sql":"SELECT WheelsOn FROM mytable ORDER BY Carrier LIMIT 29"}
{"sql":"SELECT AirlineID, OriginStateName FROM mytable ORDER BY DepartureDelayGroups, DivDistance, WeatherDelay LIMIT 9"}
{"sql":"SELECT ArrDel15, SUM(DepDel15), MAX(WheelsOn), SUM(DepTime) FROM mytable WHERE DivAirportIDs IN (10785) GROUP BY ArrDel15 LIMIT 27","hsqls":["SELECT ArrDel15, SUM(DepDel15), MAX(WheelsOn), SUM(DepTime) FROM mytable WHERE (DivAirportIDs[1] IN (10785) OR DivAirportIDs[2] IN (10785) OR DivAirportIDs[3] IN (10785) OR DivAirportIDs[4] IN (10785) OR DivAirportIDs[5] IN (10785)) GROUP BY ArrDel15 LIMIT 10000"]}
{"sql":"SELECT TaxiOut, TotalAddGTime, MIN(Diverted), AVG(OriginStateFips) FROM mytable GROUP BY TaxiOut, TotalAddGTime  ORDER BY TaxiOut, TotalAddGTime LIMIT 26","hsqls":["SELECT TaxiOut, TotalAddGTime, MIN(Diverted), AVG(OriginStateFips) FROM mytable GROUP BY TaxiOut, TotalAddGTime  ORDER BY TaxiOut, TotalAddGTime LIMIT 26"]}
{"sql":"SELECT ActualElapsedTime FROM mytable WHERE LongestAddGTime BETWEEN 51 AND 97 AND DivAirportSeqIDs BETWEEN 1324402 AND 1161802 OR WeatherDelay <= -9999 LIMIT 8","hsqls":["SELECT ActualElapsedTime FROM mytable WHERE LongestAddGTime BETWEEN 51 AND 97 AND (DivAirportSeqIDs[1] BETWEEN 1324402 AND 1161802 OR DivAirportSeqIDs[2] BETWEEN 1324402 AND 1161802 OR DivAirportSeqIDs[3] BETWEEN 1324402 AND 1161802 OR DivAirportSeqIDs[4] BETWEEN 1324402 AND 1161802 OR DivAirportSeqIDs[5] BETWEEN 1324402 AND 1161802) OR WeatherDelay <= -9999 LIMIT 10000"]}
{"sql":"SELECT DepTime, DaysSinceEpoch, MAX(OriginWac), MAX(DivAirportLandings) FROM mytable WHERE OriginStateFips <> 55 GROUP BY DepTime, DaysSinceEpoch  ORDER BY DepTime, DaysSinceEpoch LIMIT 28","hsqls":["SELECT DepTime, DaysSinceEpoch, MAX(OriginWac), MAX(DivAirportLandings) FROM mytable WHERE OriginStateFips <> 55 GROUP BY DepTime, DaysSinceEpoch  ORDER BY DepTime, DaysSinceEpoch LIMIT 28"]}
{"sql":"SELECT WeatherDelay, UniqueCarrier, DivArrDelay FROM mytable WHERE SecurityDelay BETWEEN 1 AND 18 ORDER BY OriginStateFips, Cancelled, DaysSinceEpoch LIMIT 1"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrTimeBlk IN ('1600-1659') LIMIT 13"}
{"sql":"SELECT TaxiOut, Dest, DivArrDelay, SUM(LateAircraftDelay), COUNT(CancellationCode), AVG(WheelsOn) FROM mytable GROUP BY TaxiOut, Dest, DivArrDelay  ORDER BY TaxiOut, Dest, DivArrDelay LIMIT 14","hsqls":["SELECT TaxiOut, Dest, DivArrDelay, SUM(LateAircraftDelay), COUNT(CancellationCode), AVG(WheelsOn) FROM mytable GROUP BY TaxiOut, Dest, DivArrDelay  ORDER BY TaxiOut, Dest, DivArrDelay LIMIT 14"]}
{"sql":"SELECT COUNT(Origin), MIN(ArrDel15), MIN(ArrivalDelayGroups) FROM mytable LIMIT 10"}
{"sql":"SELECT AVG(DepDelay), COUNT(WheelsOff), SUM(DivDistance) FROM mytable WHERE DivLongestGTimes IN (53.0, 6.0, 65.0, 21.0, 8.0) AND OriginStateFips >= 30 AND OriginWac = 87 LIMIT 19","hsqls":["SELECT AVG(DepDelay), COUNT(WheelsOff), SUM(DivDistance)  FROM mytable WHERE (DivLongestGTimes[1] IN (53.0, 6.0, 65.0, 21.0, 8.0) OR DivLongestGTimes[2] IN (53.0, 6.0, 65.0, 21.0, 8.0) OR DivLongestGTimes[3] IN (53.0, 6.0, 65.0, 21.0, 8.0) OR DivLongestGTimes[4] IN (53.0, 6.0, 65.0, 21.0, 8.0) OR DivLongestGTimes[5] IN (53.0, 6.0, 65.0, 21.0, 8.0)) AND OriginStateFips >= 30 AND OriginWac = 87 LIMIT 10000"]}
{"sql":"SELECT ArrDelay, COUNT(*) FROM mytable WHERE LateAircraftDelay > 33 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 18","hsqls":["SELECT ArrDelay, COUNT(*) FROM mytable WHERE LateAircraftDelay > 33 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 18"]}
{"sql":"SELECT ArrTimeBlk, UniqueCarrier, DayOfWeek, COUNT(Dest) FROM mytable WHERE OriginAirportSeqID IN (1251102, 1330303, 1306104) OR Origin BETWEEN 'PIT' AND 'ADQ' AND CRSDepTime IN (534, 2005, 1037, 926, 1257) GROUP BY ArrTimeBlk, UniqueCarrier, DayOfWeek  ORDER BY ArrTimeBlk, UniqueCarrier, DayOfWeek LIMIT 8","hsqls":["SELECT ArrTimeBlk, UniqueCarrier, DayOfWeek, COUNT(Dest) FROM mytable WHERE OriginAirportSeqID IN (1251102, 1330303, 1306104) OR Origin BETWEEN 'PIT' AND 'ADQ' AND CRSDepTime IN (534, 2005, 1037, 926, 1257) GROUP BY ArrTimeBlk, UniqueCarrier, DayOfWeek  ORDER BY ArrTimeBlk, UniqueCarrier, DayOfWeek LIMIT 8"]}
{"sql":"SELECT FlightNum, DestAirportID FROM mytable WHERE ArrTime IN (454, 1835) OR DayofMonth BETWEEN 30 AND 16 OR FirstDepTime BETWEEN 1039 AND 908 LIMIT 22"}
{"sql":"SELECT DivWheelsOns, DivLongestGTimes, Quarter FROM mytable WHERE TaxiOut NOT IN (44, 42, 35, 8, 60) OR DestAirportID BETWEEN 12892 AND 14960 LIMIT 20","hsqls":["SELECT DivWheelsOns, DivLongestGTimes, Quarter FROM mytable WHERE TaxiOut NOT IN (44, 42, 35, 8, 60) OR DestAirportID BETWEEN 12892 AND 14960 LIMIT 10000"]}
{"sql":"SELECT NASDelay, ArrivalDelayGroups, SUM(DivDistance) FROM mytable WHERE TaxiIn IN (45, 41, 15, 102) GROUP BY NASDelay, ArrivalDelayGroups  ORDER BY NASDelay, ArrivalDelayGroups LIMIT 29","hsqls":["SELECT NASDelay, ArrivalDelayGroups, SUM(DivDistance) FROM mytable WHERE TaxiIn IN (45, 41, 15, 102) GROUP BY NASDelay, ArrivalDelayGroups  ORDER BY NASDelay, ArrivalDelayGroups LIMIT 29"]}
{"sql":"SELECT DepTimeBlk, DayofMonth, DaysSinceEpoch FROM mytable WHERE SecurityDelay NOT IN (0, 4, 18, -9999) OR DivReachedDest >= 1 AND ArrDelayMinutes IN (203.0, 34.0, 223.0, 169.0, 47.0) ORDER BY OriginState, LongestAddGTime, DaysSinceEpoch LIMIT 18"}
{"sql":"SELECT FlightDate, Origin FROM mytable WHERE DestAirportSeqID IN (1323202) OR OriginCityName BETWEEN 'Klamath Falls, OR' AND 'Lake Charles, LA' ORDER BY CRSDepTime LIMIT 20"}
{"sql":"SELECT SecurityDelay, COUNT(DivDistance) FROM mytable WHERE DepDelay <= 247.0 AND OriginCityName BETWEEN 'Gulfport/Biloxi, MS' AND 'Butte, MT' OR DivActualElapsedTime BETWEEN 313 AND 145 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 25","hsqls":["SELECT SecurityDelay, COUNT(DivDistance) FROM mytable WHERE DepDelay <= 247.0 AND OriginCityName BETWEEN 'Gulfport/Biloxi, MS' AND 'Butte, MT' OR DivActualElapsedTime BETWEEN 313 AND 145 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 25"]}
{"sql":"SELECT DivAirports, FirstDepTime, LongestAddGTime FROM mytable WHERE AirTime < 247 AND Cancelled BETWEEN 1 AND 1 ORDER BY FlightDate, DayofMonth LIMIT 18","hsqls":["SELECT DivAirports, FirstDepTime, LongestAddGTime FROM mytable WHERE AirTime < 247 AND Cancelled BETWEEN 1 AND 1 ORDER BY FlightDate, DayofMonth LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, DestCityName, AirlineID, MIN(DestWac), MIN(ActualElapsedTime) FROM mytable WHERE Distance BETWEEN 2465 AND 712 AND OriginAirportSeqID BETWEEN 1410803 AND 1478302 GROUP BY CarrierDelay, DestCityName, AirlineID  ORDER BY CarrierDelay, DestCityName, AirlineID LIMIT 9","hsqls":["SELECT CarrierDelay, DestCityName, AirlineID, MIN(DestWac), MIN(ActualElapsedTime) FROM mytable WHERE Distance BETWEEN 2465 AND 712 AND OriginAirportSeqID BETWEEN 1410803 AND 1478302 GROUP BY CarrierDelay, DestCityName, AirlineID  ORDER BY CarrierDelay, DestCityName, AirlineID LIMIT 9"]}
{"sql":"SELECT SUM(Diverted), SUM(DepartureDelayGroups) FROM mytable WHERE DepDelayMinutes BETWEEN 143.0 AND 13.0 LIMIT 24"}
{"sql":"SELECT DivLongestGTimes, DestCityName FROM mytable ORDER BY WheelsOff, WeatherDelay LIMIT 5","hsqls":["SELECT DivLongestGTimes, DestCityName FROM mytable ORDER BY WheelsOff, WeatherDelay LIMIT 10000"]}
{"sql":"SELECT \"Year\", OriginCityMarketID, DivAirportLandings FROM mytable ORDER BY UniqueCarrier LIMIT 14","hsqls":["SELECT Year, OriginCityMarketID, DivAirportLandings FROM mytable ORDER BY UniqueCarrier LIMIT 14"]}
{"sql":"SELECT DestState, DivAirports, WheelsOn FROM mytable WHERE DivWheelsOns >= 1217 OR UniqueCarrier >= 'EV' ORDER BY CarrierDelay, AirTime LIMIT 18","hsqls":["SELECT DestState, DivAirports, WheelsOn FROM mytable WHERE (DivWheelsOns[1] >= 1217 OR DivWheelsOns[2] >= 1217 OR DivWheelsOns[3] >= 1217 OR DivWheelsOns[4] >= 1217 OR DivWheelsOns[5] >= 1217) OR UniqueCarrier >= 'EV' ORDER BY CarrierDelay, AirTime LIMIT 10000"]}
{"sql":"SELECT Dest, AirlineID, COUNT(OriginCityMarketID) FROM mytable GROUP BY Dest, AirlineID  ORDER BY Dest, AirlineID LIMIT 6","hsqls":["SELECT Dest, AirlineID, COUNT(OriginCityMarketID) FROM mytable GROUP BY Dest, AirlineID  ORDER BY Dest, AirlineID LIMIT 6"]}
{"sql":"SELECT DivDistance, Distance, OriginWac FROM mytable WHERE Dest IN ('FCA', 'HOU') LIMIT 25"}
{"sql":"SELECT Carrier, DestStateFips, COUNT(DepDel15), SUM(DepDel15), MAX(DivReachedDest) FROM mytable WHERE UniqueCarrier NOT IN ('WN', 'B6') OR \"Year\" NOT IN (2014) AND CarrierDelay BETWEEN 328 AND 132 GROUP BY Carrier, DestStateFips LIMIT 21","hsqls":["SELECT Carrier, DestStateFips, COUNT(DepDel15), SUM(DepDel15), MAX(DivReachedDest) FROM mytable WHERE UniqueCarrier NOT IN ('WN', 'B6') OR `Year` NOT IN (2014) AND CarrierDelay BETWEEN 328 AND 132 GROUP BY Carrier, DestStateFips LIMIT 21"]}
{"sql":"SELECT AirlineID, MAX(ArrDelay), SUM(ArrDel15) FROM mytable WHERE ActualElapsedTime BETWEEN 163 AND 90 OR DaysSinceEpoch BETWEEN 16075 AND 16078 AND DepDelayMinutes <> 310.0 GROUP BY AirlineID  ORDER BY AirlineID LIMIT 28","hsqls":["SELECT AirlineID, MAX(ArrDelay), SUM(ArrDel15) FROM mytable WHERE ActualElapsedTime BETWEEN 163 AND 90 OR DaysSinceEpoch BETWEEN 16075 AND 16078 AND DepDelayMinutes <> 310.0 GROUP BY AirlineID  ORDER BY AirlineID LIMIT 28"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE AirTime >= 404 AND OriginState BETWEEN 'NV' AND 'AK' OR FirstDepTime BETWEEN 710 AND 907 ORDER BY AirTime, DivAirportLandings LIMIT 23"}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE DestWac IN (33, 54, 11, 88) ORDER BY DepTime, DivAirportLandings LIMIT 21"}
{"sql":"SELECT Carrier FROM mytable WHERE DepartureDelayGroups IN (0, 7, 9) ORDER BY DestAirportID, WheelsOn LIMIT 9"}
{"sql":"SELECT TaxiOut, Dest FROM mytable WHERE ArrTime BETWEEN 807 AND 2154 AND ActualElapsedTime BETWEEN 172 AND 307 ORDER BY DestCityName LIMIT 5"}
{"sql":"SELECT Diverted, OriginCityMarketID, AVG(CRSDepTime), COUNT(DestAirportSeqID), MAX(OriginWac) FROM mytable WHERE DivArrDelay <> 78 GROUP BY Diverted, OriginCityMarketID  ORDER BY Diverted, OriginCityMarketID LIMIT 23","hsqls":["SELECT Diverted, OriginCityMarketID, AVG(CRSDepTime), COUNT(DestAirportSeqID), MAX(OriginWac) FROM mytable WHERE DivArrDelay <> 78 GROUP BY Diverted, OriginCityMarketID  ORDER BY Diverted, OriginCityMarketID LIMIT 23"]}
{"sql":"SELECT WeatherDelay, SecurityDelay, Origin FROM mytable WHERE ArrTimeBlk = '1100-1159' AND OriginStateName >= 'Kansas' OR ArrDel15 >= 0 ORDER BY CRSArrTime LIMIT 24"}
{"sql":"SELECT DestWac FROM mytable ORDER BY DivReachedDest LIMIT 29"}
{"sql":"SELECT DestState, DestAirportID, COUNT(DayOfWeek), MAX(ArrivalDelayGroups) FROM mytable GROUP BY DestState, DestAirportID  ORDER BY DestState, DestAirportID LIMIT 15","hsqls":["SELECT DestState, DestAirportID, COUNT(DayOfWeek), MAX(ArrivalDelayGroups) FROM mytable GROUP BY DestState, DestAirportID  ORDER BY DestState, DestAirportID LIMIT 15"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE Origin = 'RDD' OR Distance BETWEEN 406 AND 711 ORDER BY DepDelay, ArrDelayMinutes, DayofMonth LIMIT 8"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 3"}
{"sql":"SELECT Cancelled FROM mytable WHERE Flights BETWEEN 1 AND 1 AND DepTime IN (1155, 455, 1018) OR DivAirportLandings IN (2, 1, 0, 9) ORDER BY DepDelay, CarrierDelay, NASDelay LIMIT 13"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DepDel15 NOT IN (0) OR DayofMonth BETWEEN 13 AND 19 LIMIT 4"}
{"sql":"SELECT OriginWac FROM mytable WHERE LongestAddGTime >= 4 OR TailNum <= 'N345SA' AND DivActualElapsedTime < 332 ORDER BY TailNum LIMIT 27"}
{"sql":"SELECT Carrier FROM mytable WHERE CRSDepTime >= 2156 OR DivAirportLandings BETWEEN 2 AND 2 ORDER BY WeatherDelay, ArrTime"}
{"sql":"SELECT AirlineID FROM mytable ORDER BY DestStateName, ArrivalDelayGroups LIMIT 10"}
{"sql":"SELECT CarrierDelay FROM mytable WHERE OriginCityMarketID NOT IN (33502, 32600) OR SecurityDelay IN (10, 0, 18, 14, 27) AND Cancelled > 1 ORDER BY TotalAddGTime, DepDel15 LIMIT 22"}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE DayOfWeek IN (6) AND DestStateFips BETWEEN 2 AND 18 AND Carrier BETWEEN 'UA' AND 'UA' ORDER BY Carrier, DestState LIMIT 8"}
{"sql":"SELECT OriginCityMarketID, SUM(\"Year\") FROM mytable WHERE DivTotalGTimes IN (6, 36) GROUP BY OriginCityMarketID LIMIT 2","hsqls":["SELECT OriginCityMarketID, SUM(`Year`) FROM mytable WHERE (DivTotalGTimes[1] IN (6, 36) OR DivTotalGTimes[2] IN (6, 36) OR DivTotalGTimes[3] IN (6, 36) OR DivTotalGTimes[4] IN (6, 36) OR DivTotalGTimes[5] IN (6, 36)) GROUP BY OriginCityMarketID LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, DaysSinceEpoch FROM mytable WHERE NASDelay = 150 LIMIT 29"}
{"sql":"SELECT DestStateFips FROM mytable WHERE DistanceGroup NOT IN (1, 10, 5, 8, 11) OR DivDistance IN (804, 107, 83, 50) ORDER BY ArrDelayMinutes, TailNum LIMIT 25"}
{"sql":"SELECT Diverted, WheelsOn FROM mytable ORDER BY WeatherDelay LIMIT 28"}
{"sql":"SELECT \"Year\" FROM mytable WHERE WheelsOn IN (444, 1741, 1153, 2334, 2253) LIMIT 23","hsqls":["SELECT `Year` FROM mytable WHERE WheelsOn IN (444, 1741, 1153, 2334, 2253) LIMIT 23"]}
{"sql":"SELECT OriginCityMarketID, WheelsOn FROM mytable WHERE NASDelay NOT IN (98, 66, 92, 32) ORDER BY DistanceGroup, OriginStateName LIMIT 27"}
{"sql":"SELECT AirlineID, UniqueCarrier, OriginAirportID FROM mytable WHERE DivDistance NOT IN (462, 761, 257) AND DistanceGroup NOT IN (3, 1, 9, 8, 11) LIMIT 4"}
{"sql":"SELECT DistanceGroup, DivWheelsOns FROM mytable WHERE DestStateFips BETWEEN 40 AND 10 LIMIT 29","hsqls":["SELECT DistanceGroup, DivWheelsOns FROM mytable WHERE DestStateFips BETWEEN 40 AND 10 LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, DestStateFips, COUNT(DepartureDelayGroups) FROM mytable WHERE DestStateName < 'Maine' GROUP BY DepDelayMinutes, DestStateFips  ORDER BY DepDelayMinutes, DestStateFips LIMIT 17","hsqls":["SELECT DepDelayMinutes, DestStateFips, COUNT(DepartureDelayGroups) FROM mytable WHERE DestStateName < 'Maine' GROUP BY DepDelayMinutes, DestStateFips  ORDER BY DepDelayMinutes, DestStateFips LIMIT 17"]}
{"sql":"SELECT DepTimeBlk FROM mytable WHERE ArrDelayMinutes < 340.0 ORDER BY \"Month\" LIMIT 10","hsqls":["SELECT DepTimeBlk FROM mytable WHERE ArrDelayMinutes < 340.0 ORDER BY `Month` LIMIT 10"]}
{"sql":"SELECT Cancelled, AVG(ActualElapsedTime), SUM(\"Year\"), SUM(DestAirportID) FROM mytable WHERE DestStateFips BETWEEN 29 AND 78 AND WeatherDelay IN (68, 111, 54, 37, 50) GROUP BY Cancelled LIMIT 16","hsqls":["SELECT Cancelled, AVG(ActualElapsedTime), SUM(`Year`), SUM(DestAirportID) FROM mytable WHERE DestStateFips BETWEEN 29 AND 78 AND WeatherDelay IN (68, 111, 54, 37, 50) GROUP BY Cancelled LIMIT 16"]}
{"sql":"SELECT OriginAirportSeqID FROM mytable WHERE Distance IN (794, 156, 2569) AND DivReachedDest >= -9999 ORDER BY Flights LIMIT 4"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE SecurityDelay BETWEEN 10 AND 1 OR CRSDepTime <= 952 LIMIT 11"}
{"sql":"SELECT Cancelled, ArrTimeBlk, DivActualElapsedTime FROM mytable WHERE DepTimeBlk = '0900-0959' OR DivActualElapsedTime IN (854, 358) AND DestStateName BETWEEN 'Delaware' AND 'Colorado' ORDER BY TailNum LIMIT 11"}
{"sql":"SELECT FirstDepTime, FlightDate, DepTimeBlk FROM mytable WHERE TaxiIn NOT IN (113) AND ArrDelay > 996.0 ORDER BY DivDistance, DestStateName LIMIT 2"}
{"sql":"SELECT DivDistance, ArrDelayMinutes FROM mytable WHERE CarrierDelay NOT IN (171) LIMIT 14"}
{"sql":"SELECT Distance FROM mytable WHERE WeatherDelay BETWEEN 237 AND 13 ORDER BY OriginAirportSeqID, DepartureDelayGroups, TaxiIn LIMIT 20"}
{"sql":"SELECT OriginCityMarketID, CRSArrTime, CancellationCode FROM mytable LIMIT 2"}
{"sql":"SELECT CarrierDelay FROM mytable WHERE Distance IN (362, 2300) ORDER BY DistanceGroup LIMIT 13"}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE FlightDate >= '2014-01-08' ORDER BY SecurityDelay, DepTime, DaysSinceEpoch LIMIT 3"}
{"sql":"SELECT Distance, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE DivAirportIDs IN (14828, 14843, 13495, 10754) GROUP BY Distance, ArrivalDelayGroups LIMIT 2","hsqls":["SELECT Distance, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] IN (14828, 14843, 13495, 10754) OR DivAirportIDs[2] IN (14828, 14843, 13495, 10754) OR DivAirportIDs[3] IN (14828, 14843, 13495, 10754) OR DivAirportIDs[4] IN (14828, 14843, 13495, 10754) OR DivAirportIDs[5] IN (14828, 14843, 13495, 10754)) GROUP BY Distance, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT OriginCityName, ArrDelayMinutes FROM mytable LIMIT 15"}
{"sql":"SELECT DestState, MAX(WeatherDelay) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 3","hsqls":["SELECT DestState, MAX(WeatherDelay) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 3"]}
{"sql":"SELECT DivReachedDest, SecurityDelay, \"Month\" FROM mytable WHERE OriginState BETWEEN 'TN' AND 'WY' AND DivWheelsOns BETWEEN 45 AND 1704 AND SecurityDelay < -9999 ORDER BY DivActualElapsedTime LIMIT 1","hsqls":["SELECT DivReachedDest, SecurityDelay, `Month` FROM mytable WHERE OriginState BETWEEN 'TN' AND 'WY' AND (DivWheelsOns[1] BETWEEN 45 AND 1704 OR DivWheelsOns[2] BETWEEN 45 AND 1704 OR DivWheelsOns[3] BETWEEN 45 AND 1704 OR DivWheelsOns[4] BETWEEN 45 AND 1704 OR DivWheelsOns[5] BETWEEN 45 AND 1704) AND SecurityDelay < -9999 ORDER BY DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT OriginAirportID, SUM(DivArrDelay) FROM mytable WHERE OriginAirportSeqID BETWEEN 1524903 AND 1240203 GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 26","hsqls":["SELECT OriginAirportID, SUM(DivArrDelay) FROM mytable WHERE OriginAirportSeqID BETWEEN 1524903 AND 1240203 GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 26"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND Flights > 1 LIMIT 24"}
{"sql":"SELECT OriginCityName, CancellationCode, COUNT(*) FROM mytable WHERE DaysSinceEpoch NOT IN (16073, 16075, 16093) AND Distance IN (1460, 315, 519, 253) OR DepTimeBlk > '1300-1359' GROUP BY OriginCityName, CancellationCode  ORDER BY OriginCityName, CancellationCode LIMIT 22","hsqls":["SELECT OriginCityName, CancellationCode, COUNT(*) FROM mytable WHERE DaysSinceEpoch NOT IN (16073, 16075, 16093) AND Distance IN (1460, 315, 519, 253) OR DepTimeBlk > '1300-1359' GROUP BY OriginCityName, CancellationCode  ORDER BY OriginCityName, CancellationCode LIMIT 22"]}
{"sql":"SELECT Distance, ArrDel15, DestAirportID, COUNT(*) FROM mytable WHERE DestCityName NOT IN ('Colorado Springs, CO', 'Billings, MT', 'Augusta, GA') AND FirstDepTime IN (1859, 1957, 903, 2153) GROUP BY Distance, ArrDel15, DestAirportID  ORDER BY Distance, ArrDel15, DestAirportID LIMIT 27","hsqls":["SELECT Distance, ArrDel15, DestAirportID, COUNT(*) FROM mytable WHERE DestCityName NOT IN ('Colorado Springs, CO', 'Billings, MT', 'Augusta, GA') AND FirstDepTime IN (1859, 1957, 903, 2153) GROUP BY Distance, ArrDel15, DestAirportID  ORDER BY Distance, ArrDel15, DestAirportID LIMIT 27"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable ORDER BY DivReachedDest, Cancelled, DepTimeBlk LIMIT 17"}
{"sql":"SELECT CRSArrTime, FlightDate, DivArrDelay, MAX(ArrDel15) FROM mytable WHERE CarrierDelay <= 108 GROUP BY CRSArrTime, FlightDate, DivArrDelay  ORDER BY CRSArrTime, FlightDate, DivArrDelay LIMIT 21","hsqls":["SELECT CRSArrTime, FlightDate, DivArrDelay, MAX(ArrDel15) FROM mytable WHERE CarrierDelay <= 108 GROUP BY CRSArrTime, FlightDate, DivArrDelay  ORDER BY CRSArrTime, FlightDate, DivArrDelay LIMIT 21"]}
{"sql":"SELECT DivWheelsOffs, OriginAirportID FROM mytable WHERE TailNum = 'N3AUAA' AND DivDistance BETWEEN 577 AND 156 ORDER BY OriginState, DestCityName LIMIT 10","hsqls":["SELECT DivWheelsOffs, OriginAirportID FROM mytable WHERE TailNum = 'N3AUAA' AND DivDistance BETWEEN 577 AND 156 ORDER BY OriginState, DestCityName LIMIT 10000"]}
{"sql":"SELECT DestCityMarketID, AirlineID, ArrivalDelayGroups, AVG(DepTime) FROM mytable WHERE DivLongestGTimes IN (13.0, 20.0, 116.0, 15.0, 14.0) OR DivAirportSeqIDs BETWEEN 1069302 AND 1320402 AND Flights < 1 GROUP BY DestCityMarketID, AirlineID, ArrivalDelayGroups LIMIT 29","hsqls":["SELECT DestCityMarketID, AirlineID, ArrivalDelayGroups, AVG(CAST(DepTime AS DOUBLE)) FROM mytable WHERE (DivLongestGTimes[1] IN (13.0, 20.0, 116.0, 15.0, 14.0) OR DivLongestGTimes[2] IN (13.0, 20.0, 116.0, 15.0, 14.0) OR DivLongestGTimes[3] IN (13.0, 20.0, 116.0, 15.0, 14.0) OR DivLongestGTimes[4] IN (13.0, 20.0, 116.0, 15.0, 14.0) OR DivLongestGTimes[5] IN (13.0, 20.0, 116.0, 15.0, 14.0)) OR (DivAirportSeqIDs[1] BETWEEN 1069302 AND 1320402 OR DivAirportSeqIDs[2] BETWEEN 1069302 AND 1320402 OR DivAirportSeqIDs[3] BETWEEN 1069302 AND 1320402 OR DivAirportSeqIDs[4] BETWEEN 1069302 AND 1320402 OR DivAirportSeqIDs[5] BETWEEN 1069302 AND 1320402) AND Flights < 1 GROUP BY DestCityMarketID, AirlineID, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, Origin, ArrDelay, AVG(OriginCityMarketID) FROM mytable GROUP BY DepartureDelayGroups, Origin, ArrDelay  ORDER BY DepartureDelayGroups, Origin, ArrDelay LIMIT 11","hsqls":["SELECT DepartureDelayGroups, Origin, ArrDelay, AVG(OriginCityMarketID) FROM mytable GROUP BY DepartureDelayGroups, Origin, ArrDelay  ORDER BY DepartureDelayGroups, Origin, ArrDelay LIMIT 11"]}
{"sql":"SELECT AirlineID FROM mytable WHERE DivDistance >= 24 AND AirTime BETWEEN 303 AND 119 ORDER BY DivArrDelay LIMIT 27"}
{"sql":"SELECT DaysSinceEpoch, AVG(CRSElapsedTime), MAX(ArrDelayMinutes) FROM mytable WHERE DepDel15 IN (1, 0, -9999) GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 12","hsqls":["SELECT DaysSinceEpoch, AVG(CRSElapsedTime), MAX(ArrDelayMinutes) FROM mytable WHERE DepDel15 IN (1, 0, -9999) GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 12"]}
{"sql":"SELECT FlightNum, SUM(WheelsOn), AVG(ArrDelay) FROM mytable WHERE DivDistance BETWEEN 581 AND 483 AND Carrier NOT IN ('WN', 'B6', 'FL', 'UA', 'MQ') GROUP BY FlightNum","hsqls":["SELECT FlightNum, SUM(WheelsOn), AVG(ArrDelay) FROM mytable WHERE DivDistance BETWEEN 581 AND 483 AND Carrier NOT IN ('WN', 'B6', 'FL', 'UA', 'MQ') GROUP BY FlightNum"]}
{"sql":"SELECT Carrier, LongestAddGTime FROM mytable ORDER BY DestCityName, DestStateName, DaysSinceEpoch LIMIT 26"}
{"sql":"SELECT WheelsOff, SecurityDelay, ArrDelayMinutes, COUNT(*) FROM mytable WHERE OriginState NOT IN ('UT', 'MA') AND WheelsOn IN (447, 1538, 1201, 916, 2117) AND ActualElapsedTime < 177 GROUP BY WheelsOff, SecurityDelay, ArrDelayMinutes  ORDER BY WheelsOff, SecurityDelay, ArrDelayMinutes LIMIT 15","hsqls":["SELECT WheelsOff, SecurityDelay, ArrDelayMinutes, COUNT(*) FROM mytable WHERE OriginState NOT IN ('UT', 'MA') AND WheelsOn IN (447, 1538, 1201, 916, 2117) AND ActualElapsedTime < 177 GROUP BY WheelsOff, SecurityDelay, ArrDelayMinutes  ORDER BY WheelsOff, SecurityDelay, ArrDelayMinutes LIMIT 15"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE FirstDepTime > 908 LIMIT 2","hsqls":["SELECT DivWheelsOns FROM mytable WHERE FirstDepTime > 908 LIMIT 10000"]}
{"sql":"SELECT CRSArrTime, Origin, COUNT(*) FROM mytable GROUP BY CRSArrTime, Origin  ORDER BY CRSArrTime, Origin LIMIT 5","hsqls":["SELECT CRSArrTime, Origin, COUNT(*) FROM mytable GROUP BY CRSArrTime, Origin  ORDER BY CRSArrTime, Origin LIMIT 5"]}
{"sql":"SELECT DepTimeBlk, CRSElapsedTime FROM mytable WHERE CarrierDelay IN (21, 153, 150) AND ArrDel15 BETWEEN 1 AND -9999 OR AirlineID <> 20355 ORDER BY Cancelled LIMIT 21"}
{"sql":"SELECT Diverted FROM mytable ORDER BY DepDelayMinutes LIMIT 10"}
{"sql":"SELECT NASDelay, OriginWac FROM mytable WHERE Distance IN (1340, 351) AND DivAirports IN ('DFW', 'BPT', 'IMT', 'BWI') ORDER BY ArrTime, ArrDelayMinutes, ArrivalDelayGroups LIMIT 28","hsqls":["SELECT NASDelay, OriginWac FROM mytable WHERE Distance IN (1340, 351) AND (DivAirports[1] IN ('DFW', 'BPT', 'IMT', 'BWI') OR DivAirports[2] IN ('DFW', 'BPT', 'IMT', 'BWI') OR DivAirports[3] IN ('DFW', 'BPT', 'IMT', 'BWI') OR DivAirports[4] IN ('DFW', 'BPT', 'IMT', 'BWI') OR DivAirports[5] IN ('DFW', 'BPT', 'IMT', 'BWI')) ORDER BY ArrTime, ArrDelayMinutes, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay FROM mytable WHERE DaysSinceEpoch IN (16084, 16072, 16095, 16091) AND OriginWac IN (45, 93, 92, 37, 11) AND DistanceGroup NOT IN (4) ORDER BY Carrier, TotalAddGTime, ArrivalDelayGroups LIMIT 10"}
{"sql":"SELECT DepDelay, CRSArrTime, SecurityDelay, MIN(OriginStateFips), SUM(CRSElapsedTime), MIN(DivArrDelay) FROM mytable WHERE WeatherDelay > 115 GROUP BY DepDelay, CRSArrTime, SecurityDelay  ORDER BY DepDelay, CRSArrTime, SecurityDelay LIMIT 29","hsqls":["SELECT DepDelay, CRSArrTime, SecurityDelay, MIN(OriginStateFips), SUM(CRSElapsedTime), MIN(DivArrDelay) FROM mytable WHERE WeatherDelay > 115 GROUP BY DepDelay, CRSArrTime, SecurityDelay  ORDER BY DepDelay, CRSArrTime, SecurityDelay LIMIT 29"]}
{"sql":"SELECT CarrierDelay, MAX(DepDelayMinutes), AVG(SecurityDelay), COUNT(DestState) FROM mytable WHERE Distance <> 1826 OR OriginCityMarketID NOT IN (31057) GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 18","hsqls":["SELECT CarrierDelay, MAX(DepDelayMinutes), AVG(SecurityDelay), COUNT(DestState) FROM mytable WHERE Distance <> 1826 OR OriginCityMarketID NOT IN (31057) GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 18"]}
{"sql":"SELECT SUM(CarrierDelay), AVG(LateAircraftDelay) FROM mytable WHERE AirTime BETWEEN 317 AND 87 AND DestStateName BETWEEN 'Alaska' AND 'Illinois' LIMIT 16"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestState BETWEEN 'MS' AND 'AK' OR \"Year\" BETWEEN 2014 AND 2014 LIMIT 8","hsqls":["SELECT COUNT(*) FROM mytable WHERE DestState BETWEEN 'MS' AND 'AK' OR `Year` BETWEEN 2014 AND 2014 LIMIT 8"]}
{"sql":"SELECT DayofMonth, DivAirportLandings, COUNT(Quarter), MAX(Quarter), SUM(ActualElapsedTime) FROM mytable WHERE DivArrDelay <> 880 OR Flights BETWEEN 1 AND 1 GROUP BY DayofMonth, DivAirportLandings  ORDER BY DayofMonth, DivAirportLandings LIMIT 11","hsqls":["SELECT DayofMonth, DivAirportLandings, COUNT(Quarter), MAX(Quarter), SUM(ActualElapsedTime) FROM mytable WHERE DivArrDelay <> 880 OR Flights BETWEEN 1 AND 1 GROUP BY DayofMonth, DivAirportLandings  ORDER BY DayofMonth, DivAirportLandings LIMIT 11"]}
{"sql":"SELECT SecurityDelay, CancellationCode, OriginAirportID, COUNT(*) FROM mytable WHERE ArrTime = 1134 OR FlightNum < 2858 OR DivArrDelay BETWEEN 187 AND 346 GROUP BY SecurityDelay, CancellationCode, OriginAirportID  ORDER BY SecurityDelay, CancellationCode, OriginAirportID LIMIT 28","hsqls":["SELECT SecurityDelay, CancellationCode, OriginAirportID, COUNT(*) FROM mytable WHERE ArrTime = 1134 OR FlightNum < 2858 OR DivArrDelay BETWEEN 187 AND 346 GROUP BY SecurityDelay, CancellationCode, OriginAirportID  ORDER BY SecurityDelay, CancellationCode, OriginAirportID LIMIT 28"]}
{"sql":"SELECT AirTime FROM mytable WHERE Diverted <= 0 ORDER BY Origin, DivAirportLandings LIMIT 10"}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE TaxiIn IN (49, 30) AND Diverted NOT IN (1, 0) AND Quarter BETWEEN 1 AND 1 ORDER BY DepTime, DestAirportID, DivActualElapsedTime LIMIT 16","hsqls":["SELECT DivAirportIDs FROM mytable WHERE TaxiIn IN (49, 30) AND Diverted NOT IN (1, 0) AND Quarter BETWEEN 1 AND 1 ORDER BY DepTime, DestAirportID, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT \"Year\", DestState, WheelsOn FROM mytable WHERE DivActualElapsedTime NOT IN (738) AND OriginCityMarketID NOT IN (33667, 31003, 31146) OR DivLongestGTimes BETWEEN 110.0 AND 80.0 ORDER BY DestWac, ArrTime, TailNum LIMIT 24","hsqls":["SELECT Year, DestState, WheelsOn FROM mytable WHERE DivActualElapsedTime NOT IN (738) AND OriginCityMarketID NOT IN (33667, 31003, 31146) OR (DivLongestGTimes[1] BETWEEN 110.0 AND 80.0 OR DivLongestGTimes[2] BETWEEN 110.0 AND 80.0 OR DivLongestGTimes[3] BETWEEN 110.0 AND 80.0 OR DivLongestGTimes[4] BETWEEN 110.0 AND 80.0 OR DivLongestGTimes[5] BETWEEN 110.0 AND 80.0) ORDER BY DestWac, ArrTime, TailNum LIMIT 10000"]}
{"sql":"SELECT OriginStateName, COUNT(*) FROM mytable WHERE CRSDepTime BETWEEN 832 AND 1412 OR OriginCityName >= 'Sioux Falls, SD' GROUP BY OriginStateName  ORDER BY OriginStateName LIMIT 11","hsqls":["SELECT OriginStateName, COUNT(*) FROM mytable WHERE CRSDepTime BETWEEN 832 AND 1412 OR OriginCityName >= 'Sioux Falls, SD' GROUP BY OriginStateName  ORDER BY OriginStateName LIMIT 11"]}
{"sql":"SELECT FirstDepTime, OriginWac, CRSDepTime, MAX(OriginCityMarketID), SUM(DistanceGroup), SUM(OriginAirportSeqID) FROM mytable WHERE Flights IN (1) AND ArrTimeBlk BETWEEN '1600-1659' AND '2300-2359' AND FlightDate <= '2014-01-07' GROUP BY FirstDepTime, OriginWac, CRSDepTime  ORDER BY FirstDepTime, OriginWac, CRSDepTime LIMIT 22","hsqls":["SELECT FirstDepTime, OriginWac, CRSDepTime, MAX(OriginCityMarketID), SUM(DistanceGroup), SUM(OriginAirportSeqID) FROM mytable WHERE Flights IN (1) AND ArrTimeBlk BETWEEN '1600-1659' AND '2300-2359' AND FlightDate <= '2014-01-07' GROUP BY FirstDepTime, OriginWac, CRSDepTime  ORDER BY FirstDepTime, OriginWac, CRSDepTime LIMIT 22"]}
{"sql":"SELECT Quarter, TotalAddGTime, CRSElapsedTime, COUNT(*) FROM mytable GROUP BY Quarter, TotalAddGTime, CRSElapsedTime  ORDER BY Quarter, TotalAddGTime, CRSElapsedTime LIMIT 9","hsqls":["SELECT Quarter, TotalAddGTime, CRSElapsedTime, COUNT(*) FROM mytable GROUP BY Quarter, TotalAddGTime, CRSElapsedTime  ORDER BY Quarter, TotalAddGTime, CRSElapsedTime LIMIT 9"]}
{"sql":"SELECT SecurityDelay, AVG(DestStateFips), SUM(WheelsOff), SUM(AirTime) FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) OR Distance BETWEEN 1721 AND 1585 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 14","hsqls":["SELECT SecurityDelay, AVG(DestStateFips), SUM(WheelsOff), SUM(AirTime) FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) OR Distance BETWEEN 1721 AND 1585 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 14"]}
{"sql":"SELECT WeatherDelay, ArrDelayMinutes, MIN(DayOfWeek), MAX(DepDelay) FROM mytable WHERE OriginAirportID IN (10333, 14520, 13061, 10431, 14783) AND DaysSinceEpoch BETWEEN 16090 AND 16079 GROUP BY WeatherDelay, ArrDelayMinutes  ORDER BY WeatherDelay, ArrDelayMinutes LIMIT 9","hsqls":["SELECT WeatherDelay, ArrDelayMinutes, MIN(DayOfWeek), MAX(DepDelay) FROM mytable WHERE OriginAirportID IN (10333, 14520, 13061, 10431, 14783) AND DaysSinceEpoch BETWEEN 16090 AND 16079 GROUP BY WeatherDelay, ArrDelayMinutes  ORDER BY WeatherDelay, ArrDelayMinutes LIMIT 9"]}
{"sql":"SELECT DivLongestGTimes, Distance, CancellationCode FROM mytable WHERE OriginAirportSeqID BETWEEN 1445702 AND 1484304 OR TaxiIn BETWEEN 8 AND 30 AND Cancelled IN (1, 0) ORDER BY DistanceGroup, LateAircraftDelay, NASDelay LIMIT 2","hsqls":["SELECT DivLongestGTimes, Distance, CancellationCode FROM mytable WHERE OriginAirportSeqID BETWEEN 1445702 AND 1484304 OR TaxiIn BETWEEN 8 AND 30 AND Cancelled IN (1, 0) ORDER BY DistanceGroup, LateAircraftDelay, NASDelay LIMIT 10000"]}
{"sql":"SELECT TaxiIn, WheelsOn FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'A' AND DivReachedDest < 1 OR DivTailNums BETWEEN 'N224WN' AND 'N248WN' ORDER BY OriginState, DestState, DayofMonth LIMIT 10","hsqls":["SELECT TaxiIn, WheelsOn FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'A' AND DivReachedDest < 1 OR (DivTailNums[1] BETWEEN 'N224WN' AND 'N248WN' OR DivTailNums[2] BETWEEN 'N224WN' AND 'N248WN' OR DivTailNums[3] BETWEEN 'N224WN' AND 'N248WN' OR DivTailNums[4] BETWEEN 'N224WN' AND 'N248WN' OR DivTailNums[5] BETWEEN 'N224WN' AND 'N248WN') ORDER BY OriginState, DestState, DayofMonth LIMIT 10000"]}
{"sql":"SELECT DayofMonth, MIN(OriginStateFips), MIN(DivReachedDest), SUM(DivActualElapsedTime) FROM mytable WHERE TaxiOut BETWEEN 26 AND 12 AND CarrierDelay < 175 OR DepTime BETWEEN 1514 AND 1940 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 24","hsqls":["SELECT DayofMonth, MIN(OriginStateFips), MIN(DivReachedDest), SUM(DivActualElapsedTime) FROM mytable WHERE TaxiOut BETWEEN 26 AND 12 AND CarrierDelay < 175 OR DepTime BETWEEN 1514 AND 1940 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 24"]}
{"sql":"SELECT DepTimeBlk, MAX(DivDistance), AVG(LateAircraftDelay) FROM mytable GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 13","hsqls":["SELECT DepTimeBlk, MAX(DivDistance), AVG(LateAircraftDelay) FROM mytable GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 13"]}
{"sql":"SELECT DepTime, TaxiIn, Cancelled, COUNT(AirlineID), MAX(DestWac) FROM mytable WHERE WheelsOff IN (1602, 1528) AND TaxiIn BETWEEN 116 AND 71 GROUP BY DepTime, TaxiIn, Cancelled  ORDER BY DepTime, TaxiIn, Cancelled LIMIT 10","hsqls":["SELECT DepTime, TaxiIn, Cancelled, COUNT(AirlineID), MAX(DestWac) FROM mytable WHERE WheelsOff IN (1602, 1528) AND TaxiIn BETWEEN 116 AND 71 GROUP BY DepTime, TaxiIn, Cancelled  ORDER BY DepTime, TaxiIn, Cancelled LIMIT 10"]}
{"sql":"SELECT Flights FROM mytable WHERE FirstDepTime NOT IN (1859, 1309, 1540, 1018) AND FirstDepTime NOT IN (1957, 640) AND DestAirportSeqID BETWEEN 1471102 AND 1098002 LIMIT 24"}
{"sql":"SELECT SecurityDelay, DestAirportID FROM mytable WHERE CRSDepTime NOT IN (1910, 713, 2332, 1911) OR DepDelayMinutes NOT IN (192.0, 245.0, 140.0, 250.0) OR DivWheelsOns BETWEEN 1459 AND 1856 ORDER BY \"Month\" LIMIT 7","hsqls":["SELECT SecurityDelay, DestAirportID FROM mytable WHERE CRSDepTime NOT IN (1910, 713, 2332, 1911) OR DepDelayMinutes NOT IN (192.0, 245.0, 140.0, 250.0) OR (DivWheelsOns[1] BETWEEN 1459 AND 1856 OR DivWheelsOns[2] BETWEEN 1459 AND 1856 OR DivWheelsOns[3] BETWEEN 1459 AND 1856 OR DivWheelsOns[4] BETWEEN 1459 AND 1856 OR DivWheelsOns[5] BETWEEN 1459 AND 1856) ORDER BY `Month` LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DepTimeBlk BETWEEN '2100-2159' AND '1500-1559' LIMIT 1"}
{"sql":"SELECT DivReachedDest, ArrDelay FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR FlightDate <> '2014-01-05' OR ArrDelay NOT IN (241.0, -48.0, 105.0, 138.0) ORDER BY CRSDepTime LIMIT 10"}
{"sql":"SELECT CRSElapsedTime, OriginStateName, DayOfWeek FROM mytable ORDER BY Diverted, DepDelay, DepDel15 LIMIT 15"}
{"sql":"SELECT DestWac, Quarter, OriginWac FROM mytable WHERE DivLongestGTimes IN (56.0, 36.0, 37.0, 69.0, 29.0) ORDER BY DestStateFips, OriginCityName, ArrDelayMinutes LIMIT 7","hsqls":["SELECT DestWac, Quarter, OriginWac FROM mytable WHERE (DivLongestGTimes[1] IN (56.0, 36.0, 37.0, 69.0, 29.0) OR DivLongestGTimes[2] IN (56.0, 36.0, 37.0, 69.0, 29.0) OR DivLongestGTimes[3] IN (56.0, 36.0, 37.0, 69.0, 29.0) OR DivLongestGTimes[4] IN (56.0, 36.0, 37.0, 69.0, 29.0) OR DivLongestGTimes[5] IN (56.0, 36.0, 37.0, 69.0, 29.0)) ORDER BY DestStateFips, OriginCityName, ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DestStateName, CRSElapsedTime FROM mytable WHERE DepartureDelayGroups <= 6 OR DepDel15 <> 1 OR OriginState NOT IN ('IL', 'WI', 'VA', 'WV', 'NJ') ORDER BY FirstDepTime, CancellationCode, DivArrDelay LIMIT 10"}
{"sql":"SELECT DivReachedDest, Carrier FROM mytable LIMIT 6"}
{"sql":"SELECT SUM(\"Month\"), MAX(Quarter) FROM mytable WHERE WheelsOff < 1848 OR OriginCityName NOT IN ('Albany, NY', 'Cincinnati, OH', 'Lewiston, ID', 'Reno, NV', 'Fort Lauderdale, FL') LIMIT 18","hsqls":["SELECT SUM(`Month`), MAX(Quarter) FROM mytable WHERE WheelsOff < 1848 OR OriginCityName NOT IN ('Albany, NY', 'Cincinnati, OH', 'Lewiston, ID', 'Reno, NV', 'Fort Lauderdale, FL') LIMIT 18"]}
{"sql":"SELECT TaxiOut, CancellationCode FROM mytable WHERE DivTailNums BETWEEN 'N612JB' AND 'N443SW' OR DestCityMarketID IN (30781, 32511, 34905) AND LongestAddGTime < 15 ORDER BY SecurityDelay, ArrDelay LIMIT 8","hsqls":["SELECT TaxiOut, CancellationCode FROM mytable WHERE (DivTailNums[1] BETWEEN 'N612JB' AND 'N443SW' OR DivTailNums[2] BETWEEN 'N612JB' AND 'N443SW' OR DivTailNums[3] BETWEEN 'N612JB' AND 'N443SW' OR DivTailNums[4] BETWEEN 'N612JB' AND 'N443SW' OR DivTailNums[5] BETWEEN 'N612JB' AND 'N443SW') OR DestCityMarketID IN (30781, 32511, 34905) AND LongestAddGTime < 15 ORDER BY SecurityDelay, ArrDelay LIMIT 10000"]}
{"sql":"SELECT NASDelay, DivWheelsOffs, ArrivalDelayGroups FROM mytable ORDER BY CRSArrTime, DepDelayMinutes, FlightDate LIMIT 11","hsqls":["SELECT NASDelay, DivWheelsOffs, ArrivalDelayGroups FROM mytable ORDER BY CRSArrTime, DepDelayMinutes, FlightDate LIMIT 10000"]}
{"sql":"SELECT NASDelay, DayofMonth, COUNT(Flights) FROM mytable WHERE OriginAirportID BETWEEN 11308 AND 14674 AND Quarter BETWEEN 1 AND 1 AND DayofMonth > 16 GROUP BY NASDelay, DayofMonth  ORDER BY NASDelay, DayofMonth LIMIT 29","hsqls":["SELECT NASDelay, DayofMonth, COUNT(Flights) FROM mytable WHERE OriginAirportID BETWEEN 11308 AND 14674 AND Quarter BETWEEN 1 AND 1 AND DayofMonth > 16 GROUP BY NASDelay, DayofMonth  ORDER BY NASDelay, DayofMonth LIMIT 29"]}
{"sql":"SELECT TaxiOut, Distance, DestAirportSeqID, SUM(ArrivalDelayGroups), MAX(ActualElapsedTime), MIN(OriginCityMarketID) FROM mytable WHERE Origin BETWEEN 'ECP' AND 'HDN' OR CRSDepTime IN (1808, 2149, 818, 744, 630) OR DestStateFips < 25 GROUP BY TaxiOut, Distance, DestAirportSeqID  ORDER BY TaxiOut, Distance, DestAirportSeqID LIMIT 21","hsqls":["SELECT TaxiOut, Distance, DestAirportSeqID, SUM(ArrivalDelayGroups), MAX(ActualElapsedTime), MIN(OriginCityMarketID) FROM mytable WHERE Origin BETWEEN 'ECP' AND 'HDN' OR CRSDepTime IN (1808, 2149, 818, 744, 630) OR DestStateFips < 25 GROUP BY TaxiOut, Distance, DestAirportSeqID  ORDER BY TaxiOut, Distance, DestAirportSeqID LIMIT 21"]}
{"sql":"SELECT DistanceGroup, LateAircraftDelay, \"Month\", COUNT(*) FROM mytable WHERE ArrDelayMinutes > 28.0 GROUP BY DistanceGroup, LateAircraftDelay, \"Month\" LIMIT 19","hsqls":["SELECT DistanceGroup, LateAircraftDelay, Month, COUNT(*) FROM mytable WHERE ArrDelayMinutes > 28.0 GROUP BY DistanceGroup, LateAircraftDelay, `Month` LIMIT 19"]}
{"sql":"SELECT MAX(CarrierDelay), AVG(DayofMonth), MAX(DestCityMarketID) FROM mytable WHERE DivTailNums BETWEEN 'N248WN' AND 'N493AA' OR DepDelay >= -8.0 OR WheelsOn IN (959, 1042, 2105) LIMIT 27","hsqls":["SELECT MAX(CarrierDelay), AVG(DayofMonth), MAX(DestCityMarketID)  FROM mytable WHERE (DivTailNums[1] BETWEEN 'N248WN' AND 'N493AA' OR DivTailNums[2] BETWEEN 'N248WN' AND 'N493AA' OR DivTailNums[3] BETWEEN 'N248WN' AND 'N493AA' OR DivTailNums[4] BETWEEN 'N248WN' AND 'N493AA' OR DivTailNums[5] BETWEEN 'N248WN' AND 'N493AA') OR DepDelay >= -8.0 OR WheelsOn IN (959, 1042, 2105) LIMIT 10000"]}
{"sql":"SELECT ArrTime, DayOfWeek, AVG(DaysSinceEpoch), COUNT(DepDelayMinutes), MIN(CRSArrTime) FROM mytable WHERE DestWac BETWEEN 84 AND 54 GROUP BY ArrTime, DayOfWeek  ORDER BY ArrTime, DayOfWeek LIMIT 28","hsqls":["SELECT ArrTime, DayOfWeek, AVG(DaysSinceEpoch), COUNT(DepDelayMinutes), MIN(CRSArrTime) FROM mytable WHERE DestWac BETWEEN 84 AND 54 GROUP BY ArrTime, DayOfWeek  ORDER BY ArrTime, DayOfWeek LIMIT 28"]}
{"sql":"SELECT CancellationCode, MAX(DivActualElapsedTime), COUNT(DepTime), MAX(ArrTime) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 19","hsqls":["SELECT CancellationCode, MAX(DivActualElapsedTime), COUNT(DepTime), MAX(ArrTime) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 19"]}
{"sql":"SELECT DepTime, DestCityMarketID FROM mytable WHERE CRSArrTime IN (1834) OR DivDistance < 156 OR UniqueCarrier NOT IN ('MQ', 'UA') ORDER BY DivReachedDest, Cancelled LIMIT 13"}
{"sql":"SELECT WheelsOn, COUNT(*) FROM mytable WHERE DivAirportLandings <= 2 GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 4","hsqls":["SELECT WheelsOn, COUNT(*) FROM mytable WHERE DivAirportLandings <= 2 GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 4"]}
{"sql":"SELECT Origin, AirTime FROM mytable WHERE DivAirportLandings = 1 OR OriginState BETWEEN 'NY' AND 'ID' OR DepartureDelayGroups BETWEEN 1 AND 5 LIMIT 19"}
{"sql":"SELECT ArrTime, Cancelled FROM mytable WHERE OriginAirportID = 14893 ORDER BY FirstDepTime, CRSDepTime LIMIT 29"}
{"sql":"SELECT DestStateFips, DestAirportID FROM mytable WHERE Diverted < 0 AND Diverted BETWEEN 1 AND 1 AND DestStateFips > 23 ORDER BY Diverted, AirTime, DivAirportLandings LIMIT 19"}
{"sql":"SELECT DepartureDelayGroups, FlightNum, Dest, AVG(\"Year\"), MAX(TotalAddGTime) FROM mytable WHERE CRSDepTime BETWEEN 834 AND 1741 AND CancellationCode BETWEEN 'noodles' AND 'noodles' GROUP BY DepartureDelayGroups, FlightNum, Dest LIMIT 23","hsqls":["SELECT DepartureDelayGroups, FlightNum, Dest, AVG(`Year`), MAX(TotalAddGTime) FROM mytable WHERE CRSDepTime BETWEEN 834 AND 1741 AND CancellationCode BETWEEN 'noodles' AND 'noodles' GROUP BY DepartureDelayGroups, FlightNum, Dest LIMIT 23"]}
{"sql":"SELECT SecurityDelay, MAX(TotalAddGTime), AVG(ArrDelayMinutes) FROM mytable WHERE DivLongestGTimes >= 128.0 OR FlightDate <= '2014-01-17' GROUP BY SecurityDelay LIMIT 21","hsqls":["SELECT SecurityDelay, MAX(TotalAddGTime), AVG(ArrDelayMinutes) FROM mytable WHERE (DivLongestGTimes[1] >= 128.0 OR DivLongestGTimes[2] >= 128.0 OR DivLongestGTimes[3] >= 128.0 OR DivLongestGTimes[4] >= 128.0 OR DivLongestGTimes[5] >= 128.0) OR FlightDate <= '2014-01-17' GROUP BY SecurityDelay LIMIT 10000"]}
{"sql":"SELECT WheelsOn, MAX(WheelsOn), COUNT(OriginAirportID), SUM(OriginStateFips) FROM mytable WHERE OriginWac BETWEEN 66 AND 4 AND CancellationCode = 'C' GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 2","hsqls":["SELECT WheelsOn, MAX(WheelsOn), COUNT(OriginAirportID), SUM(OriginStateFips) FROM mytable WHERE OriginWac BETWEEN 66 AND 4 AND CancellationCode = 'C' GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 2"]}
{"sql":"SELECT SUM(DestWac) FROM mytable WHERE Diverted > 1 AND DepDel15 BETWEEN -9999 AND 1 LIMIT 25"}
{"sql":"SELECT TotalAddGTime, DestCityName, CRSDepTime FROM mytable WHERE OriginStateName IN ('Utah', 'North Dakota', 'Michigan', 'Delaware', 'Arkansas') ORDER BY DestCityName LIMIT 24"}
{"sql":"SELECT OriginStateFips, LateAircraftDelay, NASDelay, SUM(DivArrDelay), MIN(CRSElapsedTime) FROM mytable GROUP BY OriginStateFips, LateAircraftDelay, NASDelay  ORDER BY OriginStateFips, LateAircraftDelay, NASDelay LIMIT 29","hsqls":["SELECT OriginStateFips, LateAircraftDelay, NASDelay, SUM(DivArrDelay), MIN(CRSElapsedTime) FROM mytable GROUP BY OriginStateFips, LateAircraftDelay, NASDelay  ORDER BY OriginStateFips, LateAircraftDelay, NASDelay LIMIT 29"]}
{"sql":"SELECT FlightNum, DepDelayMinutes, COUNT(OriginCityName) FROM mytable WHERE DayofMonth IN (30, 7, 23, 15) GROUP BY FlightNum, DepDelayMinutes  ORDER BY FlightNum, DepDelayMinutes LIMIT 23","hsqls":["SELECT FlightNum, DepDelayMinutes, COUNT(OriginCityName) FROM mytable WHERE DayofMonth IN (30, 7, 23, 15) GROUP BY FlightNum, DepDelayMinutes  ORDER BY FlightNum, DepDelayMinutes LIMIT 23"]}
{"sql":"SELECT COUNT(DestWac), SUM(DestStateFips), SUM(OriginStateFips) FROM mytable LIMIT 3"}
{"sql":"SELECT ArrDel15 FROM mytable LIMIT 20"}
{"sql":"SELECT TotalAddGTime, ArrivalDelayGroups FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259', '0700-0759') OR CancellationCode BETWEEN 'B' AND 'A' ORDER BY DepDelayMinutes, NASDelay LIMIT 21"}
{"sql":"SELECT DivDistance, Cancelled, CancellationCode FROM mytable LIMIT 16"}
{"sql":"SELECT COUNT(Cancelled), AVG(LateAircraftDelay) FROM mytable LIMIT 29"}
{"sql":"SELECT DivLongestGTimes FROM mytable WHERE WeatherDelay NOT IN (2, 319, 15) AND DivArrDelay BETWEEN 75 AND 161 AND AirlineID <= 19930 ORDER BY DistanceGroup, DestAirportSeqID, ArrDel15 LIMIT 21","hsqls":["SELECT DivLongestGTimes FROM mytable WHERE WeatherDelay NOT IN (2, 319, 15) AND DivArrDelay BETWEEN 75 AND 161 AND AirlineID <= 19930 ORDER BY DistanceGroup, DestAirportSeqID, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, Cancelled, CancellationCode FROM mytable WHERE DepTime BETWEEN 735 AND 1933 LIMIT 15"}
{"sql":"SELECT MAX(Quarter), MAX(FlightNum) FROM mytable LIMIT 8"}
{"sql":"SELECT ArrDel15, OriginStateName, MIN(ArrivalDelayGroups) FROM mytable WHERE WheelsOff <= 1542 AND CRSElapsedTime BETWEEN 198 AND 277 AND DayOfWeek >= 7 GROUP BY ArrDel15, OriginStateName","hsqls":["SELECT ArrDel15, OriginStateName, MIN(ArrivalDelayGroups) FROM mytable WHERE WheelsOff <= 1542 AND CRSElapsedTime BETWEEN 198 AND 277 AND DayOfWeek >= 7 GROUP BY ArrDel15, OriginStateName"]}
{"sql":"SELECT DivReachedDest, COUNT(OriginWac) FROM mytable WHERE Flights NOT IN (1) OR DepTimeBlk IN ('0700-0759') GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 29","hsqls":["SELECT DivReachedDest, COUNT(OriginWac) FROM mytable WHERE Flights NOT IN (1) OR DepTimeBlk IN ('0700-0759') GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 29"]}
{"sql":"SELECT AVG(\"Month\"), MIN(DepartureDelayGroups) FROM mytable LIMIT 16","hsqls":["SELECT AVG(`Month`), MIN(DepartureDelayGroups) FROM mytable LIMIT 16"]}
{"sql":"SELECT DivDistance, Quarter, Dest, COUNT(*) FROM mytable WHERE Diverted IN (1, 0) GROUP BY DivDistance, Quarter, Dest  ORDER BY DivDistance, Quarter, Dest LIMIT 25","hsqls":["SELECT DivDistance, Quarter, Dest, COUNT(*) FROM mytable WHERE Diverted IN (1, 0) GROUP BY DivDistance, Quarter, Dest  ORDER BY DivDistance, Quarter, Dest LIMIT 25"]}
{"sql":"SELECT Flights, OriginStateName, COUNT(OriginAirportSeqID), MAX(DistanceGroup), SUM(CRSElapsedTime) FROM mytable GROUP BY Flights, OriginStateName  ORDER BY Flights, OriginStateName LIMIT 29","hsqls":["SELECT Flights, OriginStateName, COUNT(OriginAirportSeqID), MAX(DistanceGroup), SUM(CRSElapsedTime) FROM mytable GROUP BY Flights, OriginStateName  ORDER BY Flights, OriginStateName LIMIT 29"]}
{"sql":"SELECT FirstDepTime, DivWheelsOffs FROM mytable WHERE DestState <> 'OR' OR DivActualElapsedTime >= 779 AND Carrier <= 'B6' ORDER BY WheelsOff, TailNum LIMIT 3","hsqls":["SELECT FirstDepTime, DivWheelsOffs FROM mytable WHERE DestState <> 'OR' OR DivActualElapsedTime >= 779 AND Carrier <= 'B6' ORDER BY WheelsOff, TailNum LIMIT 10000"]}
{"sql":"SELECT Diverted, OriginCityName FROM mytable WHERE DepDel15 <= 1 ORDER BY Diverted, FirstDepTime LIMIT 3"}
{"sql":"SELECT OriginWac, DivAirportLandings, COUNT(DepTime) FROM mytable WHERE ArrDel15 BETWEEN -9999 AND 1 OR DivWheelsOffs < 1734 GROUP BY OriginWac, DivAirportLandings LIMIT 29","hsqls":["SELECT OriginWac, DivAirportLandings, COUNT(DepTime) FROM mytable WHERE ArrDel15 BETWEEN -9999 AND 1 OR (DivWheelsOffs[1] < 1734 OR DivWheelsOffs[2] < 1734 OR DivWheelsOffs[3] < 1734 OR DivWheelsOffs[4] < 1734 OR DivWheelsOffs[5] < 1734) GROUP BY OriginWac, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT DestState, SUM(AirTime), MIN(NASDelay), MAX(ArrDelayMinutes) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 19","hsqls":["SELECT DestState, SUM(AirTime), MIN(NASDelay), MAX(ArrDelayMinutes) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 19"]}
{"sql":"SELECT Distance, Cancelled, AVG(DayOfWeek), AVG(DayofMonth), MAX(DestCityMarketID) FROM mytable WHERE DepTime BETWEEN 2133 AND 1603 GROUP BY Distance, Cancelled  ORDER BY Distance, Cancelled LIMIT 5","hsqls":["SELECT Distance, Cancelled, AVG(DayOfWeek), AVG(DayofMonth), MAX(DestCityMarketID) FROM mytable WHERE DepTime BETWEEN 2133 AND 1603 GROUP BY Distance, Cancelled  ORDER BY Distance, Cancelled LIMIT 5"]}
{"sql":"SELECT OriginState, LongestAddGTime, FlightNum FROM mytable WHERE DivTotalGTimes BETWEEN 57 AND 107 AND DivWheelsOffs BETWEEN 1127 AND 1907 ORDER BY OriginCityMarketID, ArrDel15 LIMIT 1","hsqls":["SELECT OriginState, LongestAddGTime, FlightNum FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 57 AND 107 OR DivTotalGTimes[2] BETWEEN 57 AND 107 OR DivTotalGTimes[3] BETWEEN 57 AND 107 OR DivTotalGTimes[4] BETWEEN 57 AND 107 OR DivTotalGTimes[5] BETWEEN 57 AND 107) AND (DivWheelsOffs[1] BETWEEN 1127 AND 1907 OR DivWheelsOffs[2] BETWEEN 1127 AND 1907 OR DivWheelsOffs[3] BETWEEN 1127 AND 1907 OR DivWheelsOffs[4] BETWEEN 1127 AND 1907 OR DivWheelsOffs[5] BETWEEN 1127 AND 1907) ORDER BY OriginCityMarketID, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT DayofMonth, MAX(CarrierDelay), SUM(DivActualElapsedTime), MIN(ArrivalDelayGroups) FROM mytable WHERE CRSDepTime IN (702, 2250) GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 16","hsqls":["SELECT DayofMonth, MAX(CarrierDelay), SUM(DivActualElapsedTime), MIN(ArrivalDelayGroups) FROM mytable WHERE CRSDepTime IN (702, 2250) GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 16"]}
{"sql":"SELECT DivReachedDest, FlightNum, Origin, AVG(LongestAddGTime), MAX(TotalAddGTime), COUNT(DestStateName) FROM mytable WHERE DistanceGroup BETWEEN 8 AND 1 OR Distance BETWEEN 458 AND 551 AND CRSElapsedTime BETWEEN 318 AND 98 GROUP BY DivReachedDest, FlightNum, Origin  ORDER BY DivReachedDest, FlightNum, Origin LIMIT 3","hsqls":["SELECT DivReachedDest, FlightNum, Origin, AVG(LongestAddGTime), MAX(TotalAddGTime), COUNT(DestStateName) FROM mytable WHERE DistanceGroup BETWEEN 8 AND 1 OR Distance BETWEEN 458 AND 551 AND CRSElapsedTime BETWEEN 318 AND 98 GROUP BY DivReachedDest, FlightNum, Origin  ORDER BY DivReachedDest, FlightNum, Origin LIMIT 3"]}
{"sql":"SELECT Distance, Dest, SUM(DepDelay) FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 2 OR Carrier IN ('EV', 'WN', 'OO') OR DepTime IN (935, 1853, 619, 1438) GROUP BY Distance, Dest  ORDER BY Distance, Dest LIMIT 15","hsqls":["SELECT Distance, Dest, SUM(DepDelay) FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 2 OR Carrier IN ('EV', 'WN', 'OO') OR DepTime IN (935, 1853, 619, 1438) GROUP BY Distance, Dest  ORDER BY Distance, Dest LIMIT 15"]}
{"sql":"SELECT DivWheelsOns, FlightNum FROM mytable WHERE LateAircraftDelay NOT IN (135, 20, 74) LIMIT 6","hsqls":["SELECT DivWheelsOns, FlightNum FROM mytable WHERE LateAircraftDelay NOT IN (135, 20, 74) LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE FirstDepTime BETWEEN 903 AND 639 OR DestState BETWEEN 'VA' AND 'MI' OR OriginCityName IN ('Dothan, AL') LIMIT 19"}
{"sql":"SELECT Carrier, DivActualElapsedTime, AVG(DivReachedDest), SUM(ArrivalDelayGroups) FROM mytable GROUP BY Carrier, DivActualElapsedTime  ORDER BY Carrier, DivActualElapsedTime LIMIT 12","hsqls":["SELECT Carrier, DivActualElapsedTime, AVG(DivReachedDest), SUM(ArrivalDelayGroups) FROM mytable GROUP BY Carrier, DivActualElapsedTime  ORDER BY Carrier, DivActualElapsedTime LIMIT 12"]}
{"sql":"SELECT TailNum FROM mytable WHERE WheelsOff >= 704 ORDER BY TaxiOut LIMIT 16"}
{"sql":"SELECT Quarter, DestStateFips, DayOfWeek FROM mytable WHERE Origin BETWEEN 'CID' AND 'CPR' ORDER BY TailNum, DaysSinceEpoch LIMIT 2"}
{"sql":"SELECT \"Year\", Diverted, COUNT(FirstDepTime), MIN(DestAirportSeqID), COUNT(FlightDate) FROM mytable WHERE CancellationCode NOT IN ('A', 'noodles') GROUP BY \"Year\", Diverted LIMIT 10","hsqls":["SELECT Year, Diverted, COUNT(FirstDepTime), MIN(DestAirportSeqID), COUNT(FlightDate) FROM mytable WHERE CancellationCode NOT IN ('A', 'noodles') GROUP BY Year, Diverted LIMIT 10"]}
{"sql":"SELECT DivLongestGTimes FROM mytable WHERE Diverted = 0 AND SecurityDelay NOT IN (1, 18) OR OriginStateName <= 'Nevada' ORDER BY DestState, Flights LIMIT 2","hsqls":["SELECT DivLongestGTimes FROM mytable WHERE Diverted = 0 AND SecurityDelay NOT IN (1, 18) OR OriginStateName <= 'Nevada' ORDER BY DestState, Flights LIMIT 10000"]}
{"sql":"SELECT \"Year\", MIN(DestAirportID), MIN(DepTime), MAX(FlightNum) FROM mytable WHERE TaxiIn NOT IN (127) GROUP BY \"Year\"","hsqls":["SELECT Year, MIN(DestAirportID), MIN(DepTime), MAX(FlightNum) FROM mytable WHERE TaxiIn NOT IN (127) GROUP BY Year"]}
{"sql":"SELECT DivReachedDest, DestWac, DivActualElapsedTime FROM mytable WHERE DepTimeBlk IN ('2200-2259', '0700-0759', '0800-0859', '1400-1459', '1800-1859') OR CRSElapsedTime >= 196 OR AirTime BETWEEN 163 AND 251 ORDER BY WheelsOn, ArrivalDelayGroups LIMIT 7"}
{"sql":"SELECT DivWheelsOns, WeatherDelay, DestCityName FROM mytable ORDER BY ArrivalDelayGroups LIMIT 18","hsqls":["SELECT DivWheelsOns, WeatherDelay, DestCityName FROM mytable ORDER BY ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT DestWac, DivWheelsOffs, OriginWac FROM mytable WHERE DivLongestGTimes IN (102.0, 21.0, 42.0, 62.0) ORDER BY Flights, DepTimeBlk, AirlineID LIMIT 13","hsqls":["SELECT DestWac, DivWheelsOffs, OriginWac FROM mytable WHERE (DivLongestGTimes[1] IN (102.0, 21.0, 42.0, 62.0) OR DivLongestGTimes[2] IN (102.0, 21.0, 42.0, 62.0) OR DivLongestGTimes[3] IN (102.0, 21.0, 42.0, 62.0) OR DivLongestGTimes[4] IN (102.0, 21.0, 42.0, 62.0) OR DivLongestGTimes[5] IN (102.0, 21.0, 42.0, 62.0)) ORDER BY Flights, DepTimeBlk, AirlineID LIMIT 10000"]}
{"sql":"SELECT ArrTimeBlk, UniqueCarrier FROM mytable WHERE CarrierDelay < 170 ORDER BY FirstDepTime, CarrierDelay, DepTime LIMIT 5"}
{"sql":"SELECT DepDelay FROM mytable WHERE DestAirportID IN (12982, 12339, 14698, 10620) ORDER BY DivAirportLandings LIMIT 11"}
{"sql":"SELECT SUM(AirlineID), MIN(OriginCityMarketID) FROM mytable LIMIT 1"}
{"sql":"SELECT AirlineID FROM mytable WHERE OriginAirportSeqID IN (1281902, 1071302) OR DivReachedDest BETWEEN 0 AND 1 OR DepartureDelayGroups IN (-2, 4, 9) LIMIT 16"}
{"sql":"SELECT FirstDepTime, FlightNum, SecurityDelay FROM mytable WHERE DivArrDelay <> 328 AND OriginStateName >= 'U.S. Pacific Trust Territories and Possessions' OR Diverted BETWEEN 0 AND 0 LIMIT 24"}
{"sql":"SELECT DistanceGroup, Flights, DivTailNums FROM mytable WHERE Origin NOT IN ('GRR', 'GEG', 'MHT', 'EKO') AND Cancelled BETWEEN 0 AND 0 AND ArrTime IN (1002, 22, 1723, 1449) ORDER BY DivReachedDest LIMIT 13","hsqls":["SELECT DistanceGroup, Flights, DivTailNums FROM mytable WHERE Origin NOT IN ('GRR', 'GEG', 'MHT', 'EKO') AND Cancelled BETWEEN 0 AND 0 AND ArrTime IN (1002, 22, 1723, 1449) ORDER BY DivReachedDest LIMIT 10000"]}
{"sql":"SELECT WheelsOff, OriginStateName FROM mytable ORDER BY FlightDate LIMIT 9"}
{"sql":"SELECT DestWac, ArrTime, DaysSinceEpoch FROM mytable WHERE TailNum BETWEEN 'N708EV' AND 'N3CEAA' OR DivAirportSeqIDs IN (1014002, 1142303, 1013603, 1383002) ORDER BY OriginStateName LIMIT 4","hsqls":["SELECT DestWac, ArrTime, DaysSinceEpoch FROM mytable WHERE TailNum BETWEEN 'N708EV' AND 'N3CEAA' OR (DivAirportSeqIDs[1] IN (1014002, 1142303, 1013603, 1383002) OR DivAirportSeqIDs[2] IN (1014002, 1142303, 1013603, 1383002) OR DivAirportSeqIDs[3] IN (1014002, 1142303, 1013603, 1383002) OR DivAirportSeqIDs[4] IN (1014002, 1142303, 1013603, 1383002) OR DivAirportSeqIDs[5] IN (1014002, 1142303, 1013603, 1383002)) ORDER BY OriginStateName LIMIT 10000"]}
{"sql":"SELECT OriginState, NASDelay, DestCityMarketID, COUNT(*) FROM mytable WHERE DivAirportLandings > 9 OR TaxiIn IN (95, 73, 38) AND DayofMonth <> 19 GROUP BY OriginState, NASDelay, DestCityMarketID","hsqls":["SELECT OriginState, NASDelay, DestCityMarketID, COUNT(*) FROM mytable WHERE DivAirportLandings > 9 OR TaxiIn IN (95, 73, 38) AND DayofMonth <> 19 GROUP BY OriginState, NASDelay, DestCityMarketID"]}
{"sql":"SELECT Carrier, DepTime, TaxiIn, COUNT(*) FROM mytable WHERE ArrTimeBlk BETWEEN '1400-1459' AND '1900-1959' OR DayofMonth >= 12 GROUP BY Carrier, DepTime, TaxiIn  ORDER BY Carrier, DepTime, TaxiIn LIMIT 7","hsqls":["SELECT Carrier, DepTime, TaxiIn, COUNT(*) FROM mytable WHERE ArrTimeBlk BETWEEN '1400-1459' AND '1900-1959' OR DayofMonth >= 12 GROUP BY Carrier, DepTime, TaxiIn  ORDER BY Carrier, DepTime, TaxiIn LIMIT 7"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE TaxiOut NOT IN (48, 122, 16) LIMIT 17"}
{"sql":"SELECT Diverted, DayofMonth, AVG(ArrDelay), COUNT(DepTime) FROM mytable WHERE WeatherDelay IN (46) GROUP BY Diverted, DayofMonth","hsqls":["SELECT Diverted, DayofMonth, AVG(ArrDelay), COUNT(DepTime) FROM mytable WHERE WeatherDelay IN (46) GROUP BY Diverted, DayofMonth"]}
{"sql":"SELECT DepDelayMinutes, FlightNum, ArrDel15 FROM mytable WHERE OriginState NOT IN ('MO', 'NV', 'WV') OR DivArrDelay <> 222 OR WheelsOff BETWEEN 603 AND 1913 ORDER BY WheelsOff, FirstDepTime, ArrDelay LIMIT 10"}
{"sql":"SELECT DivLongestGTimes, AirlineID, DivTotalGTimes FROM mytable WHERE WheelsOff IN (1859, 2032, 621, 2338) AND CancellationCode NOT IN ('A', 'B', 'C', 'noodles') LIMIT 11","hsqls":["SELECT DivLongestGTimes, AirlineID, DivTotalGTimes FROM mytable WHERE WheelsOff IN (1859, 2032, 621, 2338) AND CancellationCode NOT IN ('A', 'B', 'C', 'noodles') LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, TailNum FROM mytable WHERE Cancelled <= 0 OR CRSElapsedTime BETWEEN 185 AND 280 ORDER BY Diverted, SecurityDelay, DestCityName LIMIT 9"}
{"sql":"SELECT DepTimeBlk, MAX(ArrDelay), MIN(FlightNum), MAX(CRSDepTime) FROM mytable WHERE ArrTime BETWEEN 1348 AND 2344 OR ArrivalDelayGroups <= 9 OR DestAirportID NOT IN (14698, 10397) GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 26","hsqls":["SELECT DepTimeBlk, MAX(ArrDelay), MIN(FlightNum), MAX(CRSDepTime) FROM mytable WHERE ArrTime BETWEEN 1348 AND 2344 OR ArrivalDelayGroups <= 9 OR DestAirportID NOT IN (14698, 10397) GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 26"]}
{"sql":"SELECT DistanceGroup, AirlineID FROM mytable ORDER BY TaxiOut, \"Year\", DivAirportLandings LIMIT 11","hsqls":["SELECT DistanceGroup, AirlineID FROM mytable ORDER BY TaxiOut, Year, DivAirportLandings LIMIT 11"]}
{"sql":"SELECT LongestAddGTime, Distance FROM mytable WHERE FlightNum NOT IN (1050, 6491, 1672, 2565) OR Dest BETWEEN 'RIC' AND 'KTN' ORDER BY ArrDelayMinutes LIMIT 5"}
{"sql":"SELECT Diverted, DestAirportID, COUNT(*) FROM mytable GROUP BY Diverted, DestAirportID  ORDER BY Diverted, DestAirportID LIMIT 24","hsqls":["SELECT Diverted, DestAirportID, COUNT(*) FROM mytable GROUP BY Diverted, DestAirportID  ORDER BY Diverted, DestAirportID LIMIT 24"]}
{"sql":"SELECT DepartureDelayGroups, LongestAddGTime FROM mytable ORDER BY Diverted, Dest"}
{"sql":"SELECT ArrDelayMinutes, SUM(Cancelled), COUNT(DestAirportSeqID), SUM(DestAirportSeqID) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 20","hsqls":["SELECT ArrDelayMinutes, SUM(Cancelled), COUNT(DestAirportSeqID), SUM(DestAirportSeqID) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 20"]}
{"sql":"SELECT SUM(DivReachedDest) FROM mytable WHERE Flights BETWEEN 1 AND 1 AND CarrierDelay NOT IN (46) AND DivAirportLandings BETWEEN 9 AND 1 LIMIT 28"}
{"sql":"SELECT LateAircraftDelay, TaxiIn, ArrDel15, MAX(WheelsOn), MAX(ArrivalDelayGroups), SUM(FlightNum) FROM mytable WHERE DistanceGroup BETWEEN 10 AND 8 GROUP BY LateAircraftDelay, TaxiIn, ArrDel15  ORDER BY LateAircraftDelay, TaxiIn, ArrDel15 LIMIT 2","hsqls":["SELECT LateAircraftDelay, TaxiIn, ArrDel15, MAX(WheelsOn), MAX(ArrivalDelayGroups), SUM(FlightNum) FROM mytable WHERE DistanceGroup BETWEEN 10 AND 8 GROUP BY LateAircraftDelay, TaxiIn, ArrDel15  ORDER BY LateAircraftDelay, TaxiIn, ArrDel15 LIMIT 2"]}
{"sql":"SELECT UniqueCarrier, MAX(WheelsOn), SUM(DestAirportSeqID) FROM mytable GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 19","hsqls":["SELECT UniqueCarrier, MAX(WheelsOn), SUM(DestAirportSeqID) FROM mytable GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 19"]}
{"sql":"SELECT DepDelayMinutes, \"Month\" FROM mytable WHERE DepDel15 IN (-9999) AND TaxiIn < 21 ORDER BY DepDelay, ArrTime LIMIT 16","hsqls":["SELECT DepDelayMinutes, `Month` FROM mytable WHERE DepDel15 IN (-9999) AND TaxiIn < 21 ORDER BY DepDelay, ArrTime LIMIT 16"]}
{"sql":"SELECT Distance, DivArrDelay, AVG(Quarter), MAX(CRSElapsedTime) FROM mytable GROUP BY Distance, DivArrDelay  ORDER BY Distance, DivArrDelay LIMIT 13","hsqls":["SELECT Distance, DivArrDelay, AVG(Quarter), MAX(CRSElapsedTime) FROM mytable GROUP BY Distance, DivArrDelay  ORDER BY Distance, DivArrDelay LIMIT 13"]}
{"sql":"SELECT Flights, ArrDelayMinutes, AVG(WeatherDelay), COUNT(Quarter) FROM mytable WHERE Dest BETWEEN 'DBQ' AND 'LAR' AND NASDelay BETWEEN 34 AND 56 AND TaxiOut IN (80) GROUP BY Flights, ArrDelayMinutes  ORDER BY Flights, ArrDelayMinutes LIMIT 24","hsqls":["SELECT Flights, ArrDelayMinutes, AVG(WeatherDelay), COUNT(Quarter) FROM mytable WHERE Dest BETWEEN 'DBQ' AND 'LAR' AND NASDelay BETWEEN 34 AND 56 AND TaxiOut IN (80) GROUP BY Flights, ArrDelayMinutes  ORDER BY Flights, ArrDelayMinutes LIMIT 24"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrDelay > 9.0 AND DepDelay BETWEEN 17.0 AND 146.0 LIMIT 10"}
{"sql":"SELECT DepTimeBlk, AVG(OriginWac), MAX(LateAircraftDelay), MIN(AirlineID) FROM mytable WHERE OriginAirportID NOT IN (11648, 12217) GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 17","hsqls":["SELECT DepTimeBlk, AVG(OriginWac), MAX(LateAircraftDelay), MIN(AirlineID) FROM mytable WHERE OriginAirportID NOT IN (11648, 12217) GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 17"]}
{"sql":"SELECT DestCityName, DivActualElapsedTime FROM mytable LIMIT 27"}
{"sql":"SELECT DestState, SecurityDelay, DivTailNums FROM mytable ORDER BY FlightNum LIMIT 22","hsqls":["SELECT DestState, SecurityDelay, DivTailNums FROM mytable ORDER BY FlightNum LIMIT 10000"]}
{"sql":"SELECT DepTime, OriginWac, WheelsOn FROM mytable LIMIT 1"}
{"sql":"SELECT MIN(LateAircraftDelay) FROM mytable WHERE DestState BETWEEN 'NJ' AND 'TN' OR DepDel15 > -9999 OR OriginCityName BETWEEN 'Gulfport/Biloxi, MS' AND 'West Palm Beach/Palm Beach, FL' LIMIT 9"}
{"sql":"SELECT LateAircraftDelay, DepTime, TailNum, MIN(ActualElapsedTime), MIN(Cancelled), COUNT(CRSArrTime) FROM mytable WHERE NASDelay BETWEEN 53 AND 99 OR UniqueCarrier BETWEEN 'F9' AND 'HA' GROUP BY LateAircraftDelay, DepTime, TailNum  ORDER BY LateAircraftDelay, DepTime, TailNum LIMIT 6","hsqls":["SELECT LateAircraftDelay, DepTime, TailNum, MIN(ActualElapsedTime), MIN(Cancelled), COUNT(CRSArrTime) FROM mytable WHERE NASDelay BETWEEN 53 AND 99 OR UniqueCarrier BETWEEN 'F9' AND 'HA' GROUP BY LateAircraftDelay, DepTime, TailNum  ORDER BY LateAircraftDelay, DepTime, TailNum LIMIT 6"]}
{"sql":"SELECT FirstDepTime, OriginCityName FROM mytable WHERE TotalAddGTime NOT IN (21) OR ActualElapsedTime IN (281) OR DestCityName IN ('Modesto, CA', 'Carlsbad, CA', 'Topeka, KS', 'Los Angeles, CA') ORDER BY Diverted, ArrDelayMinutes LIMIT 1"}
{"sql":"SELECT ActualElapsedTime, TaxiIn, OriginAirportID, MAX(DivActualElapsedTime), SUM(CRSElapsedTime) FROM mytable WHERE DepTimeBlk NOT IN ('2000-2059', '1300-1359', '1800-1859', '1500-1559') GROUP BY ActualElapsedTime, TaxiIn, OriginAirportID  ORDER BY ActualElapsedTime, TaxiIn, OriginAirportID LIMIT 6","hsqls":["SELECT ActualElapsedTime, TaxiIn, OriginAirportID, MAX(DivActualElapsedTime), SUM(CRSElapsedTime) FROM mytable WHERE DepTimeBlk NOT IN ('2000-2059', '1300-1359', '1800-1859', '1500-1559') GROUP BY ActualElapsedTime, TaxiIn, OriginAirportID  ORDER BY ActualElapsedTime, TaxiIn, OriginAirportID LIMIT 6"]}
{"sql":"SELECT DestStateFips, OriginStateName FROM mytable ORDER BY DestWac, DestStateFips, CRSElapsedTime LIMIT 4"}
{"sql":"SELECT Distance FROM mytable WHERE DestWac BETWEEN 22 AND 5 LIMIT 19"}
{"sql":"SELECT MIN(Diverted), MAX(DistanceGroup), AVG(Diverted) FROM mytable WHERE DivDistance IN (850, 54) LIMIT 19"}
{"sql":"SELECT COUNT(\"Month\"), SUM(OriginAirportSeqID), MIN(AirlineID) FROM mytable WHERE DivTailNums <= 'N530MQ' AND AirTime NOT IN (122, 158, 73, 142) OR DestAirportID NOT IN (10423, 13303, 10581, 10747) LIMIT 2","hsqls":["SELECT COUNT(`Month`), SUM(OriginAirportSeqID), MIN(AirlineID)  FROM mytable WHERE (DivTailNums[1] <= 'N530MQ' OR DivTailNums[2] <= 'N530MQ' OR DivTailNums[3] <= 'N530MQ' OR DivTailNums[4] <= 'N530MQ' OR DivTailNums[5] <= 'N530MQ') AND AirTime NOT IN (122, 158, 73, 142) OR DestAirportID NOT IN (10423, 13303, 10581, 10747) LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, COUNT(*) FROM mytable GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 27","hsqls":["SELECT DepDelayMinutes, COUNT(*) FROM mytable GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 27"]}
{"sql":"SELECT DivActualElapsedTime, OriginStateName FROM mytable WHERE DepTime NOT IN (1814, 847, 1930, 810) OR OriginStateName <> 'U.S. Virgin Islands' AND DestState BETWEEN 'KY' AND 'OH' ORDER BY DistanceGroup, ActualElapsedTime, DepTimeBlk LIMIT 27"}
{"sql":"SELECT Flights, FlightDate, DestStateFips FROM mytable WHERE DestState NOT IN ('TN', 'WA', 'VA', 'PR', 'AR') OR DivReachedDest = -9999 ORDER BY Distance, DepTimeBlk, \"Month\" LIMIT 27","hsqls":["SELECT Flights, FlightDate, DestStateFips FROM mytable WHERE DestState NOT IN ('TN', 'WA', 'VA', 'PR', 'AR') OR DivReachedDest = -9999 ORDER BY Distance, DepTimeBlk, `Month` LIMIT 27"]}
{"sql":"SELECT CRSArrTime, MAX(OriginStateFips) FROM mytable GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 4","hsqls":["SELECT CRSArrTime, MAX(OriginStateFips) FROM mytable GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 4"]}
{"sql":"SELECT CarrierDelay, Origin, OriginWac FROM mytable WHERE CancellationCode IN ('B') ORDER BY DepDelay, TotalAddGTime, DivAirportLandings LIMIT 16"}
{"sql":"SELECT ArrDel15 FROM mytable WHERE TailNum > 'N3KCAA' OR Diverted NOT IN (1, 0) ORDER BY DistanceGroup, DestCityName LIMIT 4"}
{"sql":"SELECT UniqueCarrier FROM mytable WHERE Flights < 1 LIMIT 8"}
{"sql":"SELECT WeatherDelay FROM mytable WHERE DivWheelsOffs IN (2144) AND ArrDel15 >= 0 OR CarrierDelay BETWEEN 61 AND 68 ORDER BY OriginState LIMIT 4","hsqls":["SELECT WeatherDelay FROM mytable WHERE (DivWheelsOffs[1] IN (2144) OR DivWheelsOffs[2] IN (2144) OR DivWheelsOffs[3] IN (2144) OR DivWheelsOffs[4] IN (2144) OR DivWheelsOffs[5] IN (2144)) AND ArrDel15 >= 0 OR CarrierDelay BETWEEN 61 AND 68 ORDER BY OriginState LIMIT 10000"]}
{"sql":"SELECT MAX(DepTime) FROM mytable WHERE ActualElapsedTime BETWEEN 85 AND 113 LIMIT 9"}
{"sql":"SELECT DivAirportLandings, SUM(Flights), COUNT(LateAircraftDelay) FROM mytable WHERE Distance IN (1389) GROUP BY DivAirportLandings  ORDER BY DivAirportLandings LIMIT 15","hsqls":["SELECT DivAirportLandings, SUM(Flights), COUNT(LateAircraftDelay) FROM mytable WHERE Distance IN (1389) GROUP BY DivAirportLandings  ORDER BY DivAirportLandings LIMIT 15"]}
{"sql":"SELECT FlightNum FROM mytable WHERE Flights NOT IN (1) AND DivWheelsOffs >= 123 OR \"Month\" IN (1) LIMIT 24","hsqls":["SELECT FlightNum FROM mytable WHERE Flights NOT IN (1) AND (DivWheelsOffs[1] >= 123 OR DivWheelsOffs[2] >= 123 OR DivWheelsOffs[3] >= 123 OR DivWheelsOffs[4] >= 123 OR DivWheelsOffs[5] >= 123) OR `Month` IN (1) LIMIT 10000"]}
{"sql":"SELECT OriginState, DestAirportSeqID, TaxiIn, COUNT(*) FROM mytable WHERE DivTotalGTimes IN (3, 79, 128, 123, 34) OR CRSDepTime < 2142 GROUP BY OriginState, DestAirportSeqID, TaxiIn","hsqls":["SELECT OriginState, DestAirportSeqID, TaxiIn, COUNT(*) FROM mytable WHERE (DivTotalGTimes[1] IN (3, 79, 128, 123, 34) OR DivTotalGTimes[2] IN (3, 79, 128, 123, 34) OR DivTotalGTimes[3] IN (3, 79, 128, 123, 34) OR DivTotalGTimes[4] IN (3, 79, 128, 123, 34) OR DivTotalGTimes[5] IN (3, 79, 128, 123, 34)) OR CRSDepTime < 2142 GROUP BY OriginState, DestAirportSeqID, TaxiIn LIMIT 10000"]}
{"sql":"SELECT SUM(WeatherDelay) FROM mytable WHERE DepDelay BETWEEN 334.0 AND 259.0 AND FlightNum IN (5575, 6268, 5441) OR DayOfWeek BETWEEN 6 AND 3 LIMIT 6"}
{"sql":"SELECT DepDelayMinutes, COUNT(DivDistance), AVG(DivArrDelay) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR DivReachedDest BETWEEN 1 AND 0 GROUP BY DepDelayMinutes LIMIT 14","hsqls":["SELECT DepDelayMinutes, COUNT(DivDistance), AVG(DivArrDelay) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR DivReachedDest BETWEEN 1 AND 0 GROUP BY DepDelayMinutes LIMIT 14"]}
{"sql":"SELECT Carrier, Origin, CRSElapsedTime, COUNT(*) FROM mytable GROUP BY Carrier, Origin, CRSElapsedTime  ORDER BY Carrier, Origin, CRSElapsedTime LIMIT 3","hsqls":["SELECT Carrier, Origin, CRSElapsedTime, COUNT(*) FROM mytable GROUP BY Carrier, Origin, CRSElapsedTime  ORDER BY Carrier, Origin, CRSElapsedTime LIMIT 3"]}
{"sql":"SELECT DepTimeBlk FROM mytable LIMIT 26"}
{"sql":"SELECT DepDelay, TotalAddGTime, Cancelled FROM mytable ORDER BY OriginState, OriginCityMarketID, TaxiIn LIMIT 11"}
{"sql":"SELECT DestState, CRSArrTime, CarrierDelay FROM mytable WHERE LateAircraftDelay BETWEEN 194 AND 327 ORDER BY OriginAirportID LIMIT 25"}
{"sql":"SELECT DepartureDelayGroups, COUNT(OriginWac), MIN(Cancelled), COUNT(ArrDelay) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) AND Origin BETWEEN 'BTR' AND 'SLC' OR DivTotalGTimes < 57 GROUP BY DepartureDelayGroups LIMIT 6","hsqls":["SELECT DepartureDelayGroups, COUNT(OriginWac), MIN(Cancelled), COUNT(ArrDelay) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) AND Origin BETWEEN 'BTR' AND 'SLC' OR (DivTotalGTimes[1] < 57 OR DivTotalGTimes[2] < 57 OR DivTotalGTimes[3] < 57 OR DivTotalGTimes[4] < 57 OR DivTotalGTimes[5] < 57) GROUP BY DepartureDelayGroups LIMIT 10000"]}
{"sql":"SELECT FlightNum, SUM(DivAirportLandings) FROM mytable WHERE OriginAirportSeqID <= 1084903 AND DestAirportSeqID BETWEEN 1013603 AND 1425603 GROUP BY FlightNum  ORDER BY FlightNum LIMIT 7","hsqls":["SELECT FlightNum, SUM(DivAirportLandings) FROM mytable WHERE OriginAirportSeqID <= 1084903 AND DestAirportSeqID BETWEEN 1013603 AND 1425603 GROUP BY FlightNum  ORDER BY FlightNum LIMIT 7"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivLongestGTimes < 139.0 LIMIT 8","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivLongestGTimes[1] < 139.0 OR DivLongestGTimes[2] < 139.0 OR DivLongestGTimes[3] < 139.0 OR DivLongestGTimes[4] < 139.0 OR DivLongestGTimes[5] < 139.0) LIMIT 10000"]}
{"sql":"SELECT DestAirportID, ArrivalDelayGroups, DayOfWeek FROM mytable WHERE OriginAirportID BETWEEN 10994 AND 12402 AND WheelsOff BETWEEN 1351 AND 1022 AND Flights NOT IN (1) LIMIT 7"}
{"sql":"SELECT \"Year\", DivDistance, SecurityDelay, COUNT(SecurityDelay), COUNT(DayofMonth), SUM(DepTime) FROM mytable WHERE DepDel15 BETWEEN 1 AND -9999 GROUP BY \"Year\", DivDistance, SecurityDelay LIMIT 11","hsqls":["SELECT Year, DivDistance, SecurityDelay, COUNT(SecurityDelay), COUNT(DayofMonth), SUM(DepTime) FROM mytable WHERE DepDel15 BETWEEN 1 AND -9999 GROUP BY Year, DivDistance, SecurityDelay LIMIT 11"]}
{"sql":"SELECT Diverted, OriginStateFips, FirstDepTime, SUM(DivDistance) FROM mytable WHERE DestStateName BETWEEN 'South Dakota' AND 'South Carolina' AND DepDelayMinutes IN (101.0, 205.0, 188.0, 62.0) AND TotalAddGTime IN (148, 28) GROUP BY Diverted, OriginStateFips, FirstDepTime  ORDER BY Diverted, OriginStateFips, FirstDepTime LIMIT 29","hsqls":["SELECT Diverted, OriginStateFips, FirstDepTime, SUM(DivDistance) FROM mytable WHERE DestStateName BETWEEN 'South Dakota' AND 'South Carolina' AND DepDelayMinutes IN (101.0, 205.0, 188.0, 62.0) AND TotalAddGTime IN (148, 28) GROUP BY Diverted, OriginStateFips, FirstDepTime  ORDER BY Diverted, OriginStateFips, FirstDepTime LIMIT 29"]}
{"sql":"SELECT TailNum, DivTailNums FROM mytable WHERE DivWheelsOns <= 1937 OR DepartureDelayGroups < 7 LIMIT 27","hsqls":["SELECT TailNum, DivTailNums FROM mytable WHERE (DivWheelsOns[1] <= 1937 OR DivWheelsOns[2] <= 1937 OR DivWheelsOns[3] <= 1937 OR DivWheelsOns[4] <= 1937 OR DivWheelsOns[5] <= 1937) OR DepartureDelayGroups < 7 LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE OriginState >= 'NM' LIMIT 27"}
{"sql":"SELECT DestCityName, MAX(TaxiOut) FROM mytable GROUP BY DestCityName  ORDER BY DestCityName LIMIT 12","hsqls":["SELECT DestCityName, MAX(TaxiOut) FROM mytable GROUP BY DestCityName  ORDER BY DestCityName LIMIT 12"]}
{"sql":"SELECT Dest FROM mytable WHERE Dest >= 'CRW' AND OriginStateFips NOT IN (35, 28, 38) ORDER BY DestState LIMIT 14"}
{"sql":"SELECT OriginStateFips, COUNT(*) FROM mytable WHERE DivAirportIDs IN (10666, 13871, 14843, 11122, 14027) AND Diverted NOT IN (1, 0) GROUP BY OriginStateFips LIMIT 21","hsqls":["SELECT OriginStateFips, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] IN (10666, 13871, 14843, 11122, 14027) OR DivAirportIDs[2] IN (10666, 13871, 14843, 11122, 14027) OR DivAirportIDs[3] IN (10666, 13871, 14843, 11122, 14027) OR DivAirportIDs[4] IN (10666, 13871, 14843, 11122, 14027) OR DivAirportIDs[5] IN (10666, 13871, 14843, 11122, 14027)) AND Diverted NOT IN (1, 0) GROUP BY OriginStateFips LIMIT 10000"]}
{"sql":"SELECT DestCityMarketID FROM mytable WHERE DestWac BETWEEN 84 AND 45 AND ArrTime > 840 ORDER BY Distance, NASDelay, ArrivalDelayGroups LIMIT 23"}
{"sql":"SELECT LateAircraftDelay, Quarter, DivWheelsOffs FROM mytable ORDER BY DepDelayMinutes, SecurityDelay, AirTime LIMIT 25","hsqls":["SELECT LateAircraftDelay, Quarter, DivWheelsOffs FROM mytable ORDER BY DepDelayMinutes, SecurityDelay, AirTime LIMIT 10000"]}
{"sql":"SELECT Flights, CRSDepTime, MAX(Flights), SUM(LateAircraftDelay), MAX(SecurityDelay) FROM mytable GROUP BY Flights, CRSDepTime  ORDER BY Flights, CRSDepTime LIMIT 8","hsqls":["SELECT Flights, CRSDepTime, MAX(Flights), SUM(LateAircraftDelay), MAX(SecurityDelay) FROM mytable GROUP BY Flights, CRSDepTime  ORDER BY Flights, CRSDepTime LIMIT 8"]}
{"sql":"SELECT TaxiOut, DestCityName FROM mytable WHERE DepDelay <> 45.0 AND ArrDelay BETWEEN 145.0 AND 104.0 ORDER BY FlightDate, TaxiIn, Dest LIMIT 11"}
{"sql":"SELECT COUNT(ArrivalDelayGroups) FROM mytable WHERE ArrDelayMinutes <= 238.0 LIMIT 17"}
{"sql":"SELECT DepDel15, COUNT(*) FROM mytable WHERE NASDelay < 41 GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 17","hsqls":["SELECT DepDel15, COUNT(*) FROM mytable WHERE NASDelay < 41 GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 17"]}
{"sql":"SELECT OriginAirportSeqID, DepartureDelayGroups, AVG(DepDelayMinutes) FROM mytable WHERE DepartureDelayGroups BETWEEN -9999 AND 4 OR ActualElapsedTime < 322 GROUP BY OriginAirportSeqID, DepartureDelayGroups  ORDER BY OriginAirportSeqID, DepartureDelayGroups LIMIT 11","hsqls":["SELECT OriginAirportSeqID, DepartureDelayGroups, AVG(DepDelayMinutes) FROM mytable WHERE DepartureDelayGroups BETWEEN -9999 AND 4 OR ActualElapsedTime < 322 GROUP BY OriginAirportSeqID, DepartureDelayGroups  ORDER BY OriginAirportSeqID, DepartureDelayGroups LIMIT 11"]}
{"sql":"SELECT DivReachedDest, COUNT(*) FROM mytable GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 18","hsqls":["SELECT DivReachedDest, COUNT(*) FROM mytable GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 18"]}
{"sql":"SELECT FirstDepTime FROM mytable WHERE DepDel15 NOT IN (1, 0, -9999) OR ArrTimeBlk <= '1400-1459' ORDER BY OriginAirportSeqID, SecurityDelay, CRSElapsedTime LIMIT 26"}
{"sql":"SELECT DepDelay, DestAirportSeqID, OriginStateName, COUNT(*) FROM mytable GROUP BY DepDelay, DestAirportSeqID, OriginStateName  ORDER BY DepDelay, DestAirportSeqID, OriginStateName LIMIT 6","hsqls":["SELECT DepDelay, DestAirportSeqID, OriginStateName, COUNT(*) FROM mytable GROUP BY DepDelay, DestAirportSeqID, OriginStateName  ORDER BY DepDelay, DestAirportSeqID, OriginStateName LIMIT 6"]}
{"sql":"SELECT OriginState FROM mytable WHERE OriginState IN ('VI', 'NE', 'HI', 'WV', 'PR') ORDER BY Dest, OriginStateName LIMIT 22"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 LIMIT 2","hsqls":["SELECT COUNT(*) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 LIMIT 2"]}
{"sql":"SELECT ArrivalDelayGroups FROM mytable WHERE FirstDepTime BETWEEN 1859 AND 1540 ORDER BY TaxiIn, Dest, DestAirportID LIMIT 10"}
{"sql":"SELECT TaxiOut, ActualElapsedTime, TaxiIn, COUNT(Dest), COUNT(NASDelay), SUM(WeatherDelay) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) GROUP BY TaxiOut, ActualElapsedTime, TaxiIn  ORDER BY TaxiOut, ActualElapsedTime, TaxiIn LIMIT 20","hsqls":["SELECT TaxiOut, ActualElapsedTime, TaxiIn, COUNT(Dest), COUNT(NASDelay), SUM(WeatherDelay) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) GROUP BY TaxiOut, ActualElapsedTime, TaxiIn  ORDER BY TaxiOut, ActualElapsedTime, TaxiIn LIMIT 20"]}
{"sql":"SELECT DivDistance, Cancelled, DaysSinceEpoch, COUNT(Quarter), MAX(DestStateFips), COUNT(TaxiOut) FROM mytable GROUP BY DivDistance, Cancelled, DaysSinceEpoch  ORDER BY DivDistance, Cancelled, DaysSinceEpoch LIMIT 22","hsqls":["SELECT DivDistance, Cancelled, DaysSinceEpoch, COUNT(Quarter), MAX(DestStateFips), COUNT(TaxiOut) FROM mytable GROUP BY DivDistance, Cancelled, DaysSinceEpoch  ORDER BY DivDistance, Cancelled, DaysSinceEpoch LIMIT 22"]}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE LongestAddGTime = 74 OR DestCityMarketID <= 33486 AND Carrier BETWEEN 'VX' AND 'VX' ORDER BY SecurityDelay, ArrDel15 LIMIT 19"}
{"sql":"SELECT DepTime, COUNT(*) FROM mytable WHERE DivDistance BETWEEN 128 AND 967 OR CRSArrTime BETWEEN 1723 AND 1821 GROUP BY DepTime  ORDER BY DepTime LIMIT 23","hsqls":["SELECT DepTime, COUNT(*) FROM mytable WHERE DivDistance BETWEEN 128 AND 967 OR CRSArrTime BETWEEN 1723 AND 1821 GROUP BY DepTime  ORDER BY DepTime LIMIT 23"]}
{"sql":"SELECT DestStateFips, MAX(TaxiIn), COUNT(CarrierDelay) FROM mytable WHERE CarrierDelay BETWEEN 70 AND 200 AND TailNum BETWEEN 'N11181' AND 'N285WN' AND DivLongestGTimes = 97.0 GROUP BY DestStateFips LIMIT 26","hsqls":["SELECT DestStateFips, MAX(TaxiIn), COUNT(CarrierDelay) FROM mytable WHERE CarrierDelay BETWEEN 70 AND 200 AND TailNum BETWEEN 'N11181' AND 'N285WN' AND (DivLongestGTimes[1] = 97.0 OR DivLongestGTimes[2] = 97.0 OR DivLongestGTimes[3] = 97.0 OR DivLongestGTimes[4] = 97.0 OR DivLongestGTimes[5] = 97.0) GROUP BY DestStateFips LIMIT 10000"]}
{"sql":"SELECT DestState FROM mytable WHERE DayofMonth BETWEEN 16 AND 15 AND DestWac IN (4, 52) LIMIT 23"}
{"sql":"SELECT AirlineID FROM mytable WHERE Flights NOT IN (1) OR ArrDelay NOT IN (122.0) LIMIT 7"}
{"sql":"SELECT TailNum, CancellationCode FROM mytable WHERE OriginStateName NOT IN ('Utah', 'Missouri', 'Arizona', 'Oklahoma') AND ArrivalDelayGroups IN (10, -2, 11, 12) ORDER BY OriginState, DestWac, DaysSinceEpoch LIMIT 5"}
{"sql":"SELECT AVG(CarrierDelay), AVG(OriginCityMarketID), MAX(ArrTime) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR AirlineID <= 20398 LIMIT 14","hsqls":["SELECT AVG(CarrierDelay), AVG(OriginCityMarketID), MAX(ArrTime) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR AirlineID <= 20398 LIMIT 14"]}
{"sql":"SELECT SecurityDelay, ArrDelayMinutes, COUNT(*) FROM mytable WHERE LateAircraftDelay = 61 OR Origin IN ('FSD', 'TUS', 'HIB') OR WheelsOff BETWEEN 1512 AND 1822 GROUP BY SecurityDelay, ArrDelayMinutes  ORDER BY SecurityDelay, ArrDelayMinutes LIMIT 7","hsqls":["SELECT SecurityDelay, ArrDelayMinutes, COUNT(*) FROM mytable WHERE LateAircraftDelay = 61 OR Origin IN ('FSD', 'TUS', 'HIB') OR WheelsOff BETWEEN 1512 AND 1822 GROUP BY SecurityDelay, ArrDelayMinutes  ORDER BY SecurityDelay, ArrDelayMinutes LIMIT 7"]}
{"sql":"SELECT CRSElapsedTime, OriginAirportID, COUNT(Origin), MIN(TotalAddGTime) FROM mytable WHERE DivArrDelay NOT IN (746, 224, 185, 62) GROUP BY CRSElapsedTime, OriginAirportID  ORDER BY CRSElapsedTime, OriginAirportID LIMIT 17","hsqls":["SELECT CRSElapsedTime, OriginAirportID, COUNT(Origin), MIN(TotalAddGTime) FROM mytable WHERE DivArrDelay NOT IN (746, 224, 185, 62) GROUP BY CRSElapsedTime, OriginAirportID  ORDER BY CRSElapsedTime, OriginAirportID LIMIT 17"]}
{"sql":"SELECT DepDelayMinutes FROM mytable WHERE Origin = 'MHT' ORDER BY OriginCityName, NASDelay LIMIT 6"}
{"sql":"SELECT OriginStateFips, DivAirportSeqIDs FROM mytable WHERE DistanceGroup BETWEEN 2 AND 11 ORDER BY TailNum LIMIT 20","hsqls":["SELECT OriginStateFips, DivAirportSeqIDs FROM mytable WHERE DistanceGroup BETWEEN 2 AND 11 ORDER BY TailNum LIMIT 10000"]}
{"sql":"SELECT TaxiOut, TaxiIn, TailNum, COUNT(*) FROM mytable WHERE DepartureDelayGroups BETWEEN 0 AND -1 AND DestStateName BETWEEN 'Pennsylvania' AND 'North Carolina' OR DepDel15 IN (1, 0, -9999) GROUP BY TaxiOut, TaxiIn, TailNum  ORDER BY TaxiOut, TaxiIn, TailNum LIMIT 15","hsqls":["SELECT TaxiOut, TaxiIn, TailNum, COUNT(*) FROM mytable WHERE DepartureDelayGroups BETWEEN 0 AND -1 AND DestStateName BETWEEN 'Pennsylvania' AND 'North Carolina' OR DepDel15 IN (1, 0, -9999) GROUP BY TaxiOut, TaxiIn, TailNum  ORDER BY TaxiOut, TaxiIn, TailNum LIMIT 15"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE DivActualElapsedTime BETWEEN 343 AND 344 AND AirlineID <= 20437 ORDER BY OriginCityMarketID, FlightDate LIMIT 25"}
{"sql":"SELECT DivTailNums FROM mytable WHERE \"Month\" NOT IN (1) AND ArrTime BETWEEN 825 AND 1236 AND TotalAddGTime IN (78, 25, 13) ORDER BY \"Year\", DivDistance, OriginWac LIMIT 12","hsqls":["SELECT DivTailNums FROM mytable WHERE `Month` NOT IN (1) AND ArrTime BETWEEN 825 AND 1236 AND TotalAddGTime IN (78, 25, 13) ORDER BY Year, DivDistance, OriginWac LIMIT 10000"]}
{"sql":"SELECT WheelsOn, CRSDepTime, MAX(CarrierDelay), COUNT(DestWac) FROM mytable WHERE OriginStateFips BETWEEN 47 AND 33 AND DivWheelsOns IN (1022, 1251) GROUP BY WheelsOn, CRSDepTime LIMIT 29","hsqls":["SELECT WheelsOn, CRSDepTime, MAX(CarrierDelay), COUNT(DestWac) FROM mytable WHERE OriginStateFips BETWEEN 47 AND 33 AND (DivWheelsOns[1] IN (1022, 1251) OR DivWheelsOns[2] IN (1022, 1251) OR DivWheelsOns[3] IN (1022, 1251) OR DivWheelsOns[4] IN (1022, 1251) OR DivWheelsOns[5] IN (1022, 1251)) GROUP BY WheelsOn, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT MIN(TaxiIn) FROM mytable WHERE OriginCityMarketID <> 30140 AND CRSElapsedTime >= 181 LIMIT 29"}
{"sql":"SELECT TotalAddGTime, CRSDepTime FROM mytable WHERE TailNum NOT IN ('N78509', 'N961DL', 'N667DN', 'N760EV', 'N23721') OR ArrTimeBlk NOT IN ('1100-1159', '2300-2359', '1400-1459') ORDER BY WheelsOff, DivDistance LIMIT 28"}
{"sql":"SELECT TaxiOut FROM mytable ORDER BY NASDelay LIMIT 20"}
{"sql":"SELECT TailNum, DepDel15 FROM mytable WHERE DistanceGroup < 1 ORDER BY OriginState, ArrDelayMinutes, AirlineID LIMIT 11"}
{"sql":"SELECT ArrTime FROM mytable WHERE NASDelay = 21 AND ArrTime IN (600, 1328) AND TaxiIn IN (7, 93, 44) ORDER BY Carrier, DepTimeBlk LIMIT 15"}
{"sql":"SELECT TotalAddGTime, DepDel15, MAX(\"Year\"), AVG(CRSElapsedTime) FROM mytable WHERE WeatherDelay < 3 AND DestCityName < 'Newark, NJ' GROUP BY TotalAddGTime, DepDel15 LIMIT 10","hsqls":["SELECT TotalAddGTime, DepDel15, MAX(`Year`), AVG(CRSElapsedTime) FROM mytable WHERE WeatherDelay < 3 AND DestCityName < 'Newark, NJ' GROUP BY TotalAddGTime, DepDel15 LIMIT 10"]}
{"sql":"SELECT LateAircraftDelay, Dest FROM mytable WHERE DaysSinceEpoch BETWEEN 16093 AND 16095 OR DivTotalGTimes IN (12, 76) AND Quarter <= 1 ORDER BY DepTime, DayofMonth LIMIT 9","hsqls":["SELECT LateAircraftDelay, Dest FROM mytable WHERE DaysSinceEpoch BETWEEN 16093 AND 16095 OR (DivTotalGTimes[1] IN (12, 76) OR DivTotalGTimes[2] IN (12, 76) OR DivTotalGTimes[3] IN (12, 76) OR DivTotalGTimes[4] IN (12, 76) OR DivTotalGTimes[5] IN (12, 76)) AND Quarter <= 1 ORDER BY DepTime, DayofMonth LIMIT 10000"]}
{"sql":"SELECT TaxiOut, DepTime, MAX(DepTime) FROM mytable GROUP BY TaxiOut, DepTime  ORDER BY TaxiOut, DepTime LIMIT 26","hsqls":["SELECT TaxiOut, DepTime, MAX(DepTime) FROM mytable GROUP BY TaxiOut, DepTime  ORDER BY TaxiOut, DepTime LIMIT 26"]}
{"sql":"SELECT WeatherDelay, Distance, AVG(\"Year\"), COUNT(ArrTimeBlk), AVG(Flights) FROM mytable WHERE Carrier = 'OO' OR OriginStateName NOT IN ('Utah', 'Puerto Rico', 'Kentucky', 'U.S. Pacific Trust Territories and Possessions', 'Illinois') GROUP BY WeatherDelay, Distance LIMIT 25","hsqls":["SELECT WeatherDelay, Distance, AVG(`Year`), COUNT(ArrTimeBlk), AVG(Flights) FROM mytable WHERE Carrier = 'OO' OR OriginStateName NOT IN ('Utah', 'Puerto Rico', 'Kentucky', 'U.S. Pacific Trust Territories and Possessions', 'Illinois') GROUP BY WeatherDelay, Distance LIMIT 25"]}
{"sql":"SELECT DestState FROM mytable WHERE ArrTime > 2242 OR Carrier NOT IN ('F9') LIMIT 4"}
{"sql":"SELECT DistanceGroup FROM mytable WHERE WeatherDelay <= 101 OR \"Month\" >= 1 AND AirTime BETWEEN 85 AND 442 ORDER BY DepDelayMinutes, ArrTime, Dest LIMIT 13","hsqls":["SELECT DistanceGroup FROM mytable WHERE WeatherDelay <= 101 OR `Month` >= 1 AND AirTime BETWEEN 85 AND 442 ORDER BY DepDelayMinutes, ArrTime, Dest LIMIT 13"]}
{"sql":"SELECT MIN(Flights) FROM mytable WHERE OriginAirportID BETWEEN 11413 AND 13495 AND OriginCityMarketID NOT IN (30739) AND DivActualElapsedTime BETWEEN 383 AND 289 LIMIT 12"}
{"sql":"SELECT DestAirportSeqID, DivTotalGTimes FROM mytable ORDER BY Dest LIMIT 6","hsqls":["SELECT DestAirportSeqID, DivTotalGTimes FROM mytable ORDER BY Dest LIMIT 10000"]}
{"sql":"SELECT WheelsOn FROM mytable WHERE Cancelled = 1 AND DestState < 'ND' LIMIT 20"}
{"sql":"SELECT AVG(OriginStateFips) FROM mytable LIMIT 28"}
{"sql":"SELECT WheelsOff FROM mytable WHERE ArrivalDelayGroups NOT IN (10, 0, 7, -1) LIMIT 20"}
{"sql":"SELECT DivWheelsOns, OriginCityName, DivAirportIDs FROM mytable ORDER BY TailNum LIMIT 11","hsqls":["SELECT DivWheelsOns, OriginCityName, DivAirportIDs FROM mytable ORDER BY TailNum LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, TaxiIn, DestAirportID, COUNT(*) FROM mytable WHERE TailNum <= 'N56859' OR DestCityName NOT IN ('Savannah, GA', 'Anchorage, AK', 'Yuma, AZ', 'Newport News/Williamsburg, VA') AND Cancelled = 1 GROUP BY WeatherDelay, TaxiIn, DestAirportID  ORDER BY WeatherDelay, TaxiIn, DestAirportID LIMIT 15","hsqls":["SELECT WeatherDelay, TaxiIn, DestAirportID, COUNT(*) FROM mytable WHERE TailNum <= 'N56859' OR DestCityName NOT IN ('Savannah, GA', 'Anchorage, AK', 'Yuma, AZ', 'Newport News/Williamsburg, VA') AND Cancelled = 1 GROUP BY WeatherDelay, TaxiIn, DestAirportID  ORDER BY WeatherDelay, TaxiIn, DestAirportID LIMIT 15"]}
{"sql":"SELECT DepartureDelayGroups, DayofMonth FROM mytable WHERE DestCityName NOT IN ('Manchester, NH', 'Tallahassee, FL', 'Asheville, NC') OR DivWheelsOffs < 2002 ORDER BY DayofMonth LIMIT 23","hsqls":["SELECT DepartureDelayGroups, DayofMonth FROM mytable WHERE DestCityName NOT IN ('Manchester, NH', 'Tallahassee, FL', 'Asheville, NC') OR (DivWheelsOffs[1] < 2002 OR DivWheelsOffs[2] < 2002 OR DivWheelsOffs[3] < 2002 OR DivWheelsOffs[4] < 2002 OR DivWheelsOffs[5] < 2002) ORDER BY DayofMonth LIMIT 10000"]}
{"sql":"SELECT DepDel15, MAX(DepDelayMinutes), SUM(DivArrDelay), SUM(Quarter) FROM mytable GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 23","hsqls":["SELECT DepDel15, MAX(DepDelayMinutes), SUM(DivArrDelay), SUM(Quarter) FROM mytable GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 23"]}
{"sql":"SELECT DestStateName, COUNT(*) FROM mytable WHERE DivLongestGTimes IN (77.0, 30.0) AND Carrier BETWEEN 'B6' AND 'UA' OR DivActualElapsedTime BETWEEN 262 AND 171 GROUP BY DestStateName LIMIT 8","hsqls":["SELECT DestStateName, COUNT(*) FROM mytable WHERE (DivLongestGTimes[1] IN (77.0, 30.0) OR DivLongestGTimes[2] IN (77.0, 30.0) OR DivLongestGTimes[3] IN (77.0, 30.0) OR DivLongestGTimes[4] IN (77.0, 30.0) OR DivLongestGTimes[5] IN (77.0, 30.0)) AND Carrier BETWEEN 'B6' AND 'UA' OR DivActualElapsedTime BETWEEN 262 AND 171 GROUP BY DestStateName LIMIT 10000"]}
{"sql":"SELECT DestStateFips, DestCityName, SUM(DepDelayMinutes), SUM(OriginAirportSeqID) FROM mytable WHERE WeatherDelay BETWEEN 18 AND 88 GROUP BY DestStateFips, DestCityName  ORDER BY DestStateFips, DestCityName LIMIT 22","hsqls":["SELECT DestStateFips, DestCityName, SUM(DepDelayMinutes), SUM(OriginAirportSeqID) FROM mytable WHERE WeatherDelay BETWEEN 18 AND 88 GROUP BY DestStateFips, DestCityName  ORDER BY DestStateFips, DestCityName LIMIT 22"]}
{"sql":"SELECT ArrTime, DestAirportSeqID FROM mytable WHERE FlightNum NOT IN (3798, 618) LIMIT 16"}
{"sql":"SELECT ArrDelay FROM mytable WHERE ActualElapsedTime BETWEEN 60 AND 259 AND CRSArrTime IN (752, 1150) AND DestCityMarketID > 33933 ORDER BY DaysSinceEpoch LIMIT 10"}
{"sql":"SELECT FlightDate, MAX(DivDistance), MIN(FlightNum), SUM(CRSElapsedTime) FROM mytable WHERE DepartureDelayGroups BETWEEN -1 AND 11 GROUP BY FlightDate  ORDER BY FlightDate LIMIT 9","hsqls":["SELECT FlightDate, MAX(DivDistance), MIN(FlightNum), SUM(CRSElapsedTime) FROM mytable WHERE DepartureDelayGroups BETWEEN -1 AND 11 GROUP BY FlightDate  ORDER BY FlightDate LIMIT 9"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE OriginWac NOT IN (82, 83, 13, 84) ORDER BY Diverted, DivArrDelay LIMIT 22"}
{"sql":"SELECT DepDel15, DivAirportLandings FROM mytable WHERE ActualElapsedTime BETWEEN 54 AND 263 AND DivAirportIDs = 11278 ORDER BY TotalAddGTime LIMIT 19","hsqls":["SELECT DepDel15, DivAirportLandings FROM mytable WHERE ActualElapsedTime BETWEEN 54 AND 263 AND (DivAirportIDs[1] = 11278 OR DivAirportIDs[2] = 11278 OR DivAirportIDs[3] = 11278 OR DivAirportIDs[4] = 11278 OR DivAirportIDs[5] = 11278) ORDER BY TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, ArrDelay FROM mytable WHERE OriginWac < 53 ORDER BY DivAirportLandings, CRSElapsedTime LIMIT 17"}
{"sql":"SELECT OriginCityName, OriginStateName FROM mytable LIMIT 25"}
{"sql":"SELECT LateAircraftDelay, LongestAddGTime, ActualElapsedTime FROM mytable WHERE DepartureDelayGroups IN (3, 10, -1, 4, -9999) OR TaxiIn = 175 AND DestStateFips > 42 ORDER BY Distance LIMIT 5"}
{"sql":"SELECT FlightDate, UniqueCarrier, AVG(DepDel15) FROM mytable WHERE DepDel15 IN (1, 0, -9999) OR LateAircraftDelay <= 224 GROUP BY FlightDate, UniqueCarrier  ORDER BY FlightDate, UniqueCarrier LIMIT 27","hsqls":["SELECT FlightDate, UniqueCarrier, AVG(DepDel15) FROM mytable WHERE DepDel15 IN (1, 0, -9999) OR LateAircraftDelay <= 224 GROUP BY FlightDate, UniqueCarrier  ORDER BY FlightDate, UniqueCarrier LIMIT 27"]}
{"sql":"SELECT TaxiIn FROM mytable WHERE DestStateName IN ('Minnesota', 'Illinois', 'New York', 'South Dakota', 'Oklahoma') OR AirTime BETWEEN 306 AND 159 ORDER BY UniqueCarrier LIMIT 12"}
{"sql":"SELECT AirTime, DivArrDelay FROM mytable WHERE Flights BETWEEN 1 AND 1 OR DivWheelsOffs <= 130 OR TaxiOut = 71 ORDER BY ArrDelayMinutes, TailNum, DepDel15 LIMIT 15","hsqls":["SELECT AirTime, DivArrDelay FROM mytable WHERE Flights BETWEEN 1 AND 1 OR (DivWheelsOffs[1] <= 130 OR DivWheelsOffs[2] <= 130 OR DivWheelsOffs[3] <= 130 OR DivWheelsOffs[4] <= 130 OR DivWheelsOffs[5] <= 130) OR TaxiOut = 71 ORDER BY ArrDelayMinutes, TailNum, DepDel15 LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, COUNT(*) FROM mytable WHERE OriginWac BETWEEN 93 AND 72 GROUP BY WeatherDelay  ORDER BY WeatherDelay LIMIT 10","hsqls":["SELECT WeatherDelay, COUNT(*) FROM mytable WHERE OriginWac BETWEEN 93 AND 72 GROUP BY WeatherDelay  ORDER BY WeatherDelay LIMIT 10"]}
{"sql":"SELECT OriginAirportID, AVG(FlightNum), SUM(DepTime), MAX(DestCityMarketID) FROM mytable WHERE FlightDate < '2014-01-17' OR DestStateName BETWEEN 'Rhode Island' AND 'Indiana' OR DivDistance <> 236 GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 29","hsqls":["SELECT OriginAirportID, AVG(FlightNum), SUM(DepTime), MAX(DestCityMarketID) FROM mytable WHERE FlightDate < '2014-01-17' OR DestStateName BETWEEN 'Rhode Island' AND 'Indiana' OR DivDistance <> 236 GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 29"]}
{"sql":"SELECT MIN(DestWac), AVG(DaysSinceEpoch), COUNT(FlightDate) FROM mytable LIMIT 9"}
{"sql":"SELECT TailNum, OriginAirportID FROM mytable WHERE DestCityName IN ('Brainerd, MN', 'Kotzebue, AK', 'Muskegon, MI') AND DestAirportSeqID <> 1037203 AND CRSDepTime BETWEEN 757 AND 1804 LIMIT 27"}
{"sql":"SELECT WheelsOn, DaysSinceEpoch FROM mytable ORDER BY ArrTime, CancellationCode LIMIT 24"}
{"sql":"SELECT OriginAirportSeqID, LateAircraftDelay, Cancelled FROM mytable WHERE Flights IN (1) ORDER BY OriginAirportSeqID, ActualElapsedTime LIMIT 8"}
{"sql":"SELECT DepDelay, TotalAddGTime, Origin FROM mytable WHERE Distance = 1180 AND OriginStateName = 'Wyoming' ORDER BY SecurityDelay, DestAirportSeqID, NASDelay LIMIT 11"}
{"sql":"SELECT OriginCityMarketID, Dest, OriginAirportID, COUNT(*) FROM mytable WHERE OriginState >= 'VT' OR \"Month\" BETWEEN 1 AND 1 GROUP BY OriginCityMarketID, Dest, OriginAirportID LIMIT 10","hsqls":["SELECT OriginCityMarketID, Dest, OriginAirportID, COUNT(*) FROM mytable WHERE OriginState >= 'VT' OR `Month` BETWEEN 1 AND 1 GROUP BY OriginCityMarketID, Dest, OriginAirportID LIMIT 10"]}
{"sql":"SELECT \"Year\" FROM mytable WHERE NASDelay < 42 AND Cancelled BETWEEN 0 AND 0 AND DestCityName IN ('Las Vegas, NV', 'Laramie, WY', 'Brownsville, TX', 'Klamath Falls, OR', 'Palm Springs, CA') ORDER BY DepDelay, DestStateFips, OriginStateName LIMIT 19","hsqls":["SELECT `Year` FROM mytable WHERE NASDelay < 42 AND Cancelled BETWEEN 0 AND 0 AND DestCityName IN ('Las Vegas, NV', 'Laramie, WY', 'Brownsville, TX', 'Klamath Falls, OR', 'Palm Springs, CA') ORDER BY DepDelay, DestStateFips, OriginStateName LIMIT 19"]}
{"sql":"SELECT TotalAddGTime, ArrivalDelayGroups FROM mytable ORDER BY DivDistance LIMIT 23"}
{"sql":"SELECT TaxiOut, MAX(DestStateFips), AVG(DestCityMarketID) FROM mytable GROUP BY TaxiOut  ORDER BY TaxiOut LIMIT 4","hsqls":["SELECT TaxiOut, MAX(DestStateFips), AVG(DestCityMarketID) FROM mytable GROUP BY TaxiOut  ORDER BY TaxiOut LIMIT 4"]}
{"sql":"SELECT FlightNum, DivAirportIDs, AirTime FROM mytable ORDER BY DivArrDelay LIMIT 22","hsqls":["SELECT FlightNum, DivAirportIDs, AirTime FROM mytable ORDER BY DivArrDelay LIMIT 10000"]}
{"sql":"SELECT Dest, SUM(ArrDel15), AVG(TaxiOut), COUNT(AirTime) FROM mytable GROUP BY Dest  ORDER BY Dest LIMIT 21","hsqls":["SELECT Dest, SUM(ArrDel15), AVG(TaxiOut), COUNT(AirTime) FROM mytable GROUP BY Dest  ORDER BY Dest LIMIT 21"]}
{"sql":"SELECT \"Month\" FROM mytable WHERE Diverted <= 0 AND Carrier BETWEEN 'AS' AND 'WN' ORDER BY DivActualElapsedTime LIMIT 3","hsqls":["SELECT `Month` FROM mytable WHERE Diverted <= 0 AND Carrier BETWEEN 'AS' AND 'WN' ORDER BY DivActualElapsedTime LIMIT 3"]}
{"sql":"SELECT COUNT(DestCityMarketID) FROM mytable WHERE AirTime BETWEEN 109 AND 70 LIMIT 16"}
{"sql":"SELECT CarrierDelay, MIN(OriginStateFips), AVG(DivArrDelay) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 7","hsqls":["SELECT CarrierDelay, MIN(OriginStateFips), AVG(DivArrDelay) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 7"]}
{"sql":"SELECT Carrier, NASDelay FROM mytable WHERE SecurityDelay <= -9999 AND CarrierDelay >= 67 AND WheelsOff BETWEEN 549 AND 1100 ORDER BY TotalAddGTime LIMIT 12"}
{"sql":"SELECT DestStateFips, DivAirportSeqIDs FROM mytable WHERE ArrDelay IN (184.0) OR Carrier NOT IN ('US', 'VX') AND AirTime <= 161 ORDER BY DivDistance LIMIT 10","hsqls":["SELECT DestStateFips, DivAirportSeqIDs FROM mytable WHERE ArrDelay IN (184.0) OR Carrier NOT IN ('US', 'VX') AND AirTime <= 161 ORDER BY DivDistance LIMIT 10000"]}
{"sql":"SELECT CRSArrTime, DepDel15 FROM mytable WHERE DistanceGroup IN (1, 6, 5) AND FlightNum <= 4814 AND CRSArrTime < 1315 ORDER BY TaxiOut LIMIT 28"}
{"sql":"SELECT OriginAirportID, COUNT(*) FROM mytable WHERE DayOfWeek <= 3 AND DivAirportIDs <= 10397 OR DepTime BETWEEN 1851 AND 2230 GROUP BY OriginAirportID LIMIT 17","hsqls":["SELECT OriginAirportID, COUNT(*) FROM mytable WHERE DayOfWeek <= 3 AND (DivAirportIDs[1] <= 10397 OR DivAirportIDs[2] <= 10397 OR DivAirportIDs[3] <= 10397 OR DivAirportIDs[4] <= 10397 OR DivAirportIDs[5] <= 10397) OR DepTime BETWEEN 1851 AND 2230 GROUP BY OriginAirportID LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DivReachedDest, MAX(Flights), MAX(NASDelay), MIN(DistanceGroup) FROM mytable WHERE UniqueCarrier <> 'B6' GROUP BY WheelsOff, DivReachedDest  ORDER BY WheelsOff, DivReachedDest LIMIT 26","hsqls":["SELECT WheelsOff, DivReachedDest, MAX(Flights), MAX(NASDelay), MIN(DistanceGroup) FROM mytable WHERE UniqueCarrier <> 'B6' GROUP BY WheelsOff, DivReachedDest  ORDER BY WheelsOff, DivReachedDest LIMIT 26"]}
{"sql":"SELECT DestWac, DestAirportID FROM mytable ORDER BY Origin LIMIT 10"}
{"sql":"SELECT OriginStateFips, DivDistance, DayofMonth FROM mytable WHERE CRSArrTime <= 1937 LIMIT 1"}
{"sql":"SELECT DivDistance, FlightDate FROM mytable WHERE DepTimeBlk < '0900-0959' OR FirstDepTime BETWEEN 1200 AND 921 LIMIT 3"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DaysSinceEpoch NOT IN (16101, 16100, 16083, 16072, 16079) OR DivAirportLandings NOT IN (2, 1, 0, 9) OR DestWac BETWEEN 14 AND 74 LIMIT 25"}
{"sql":"SELECT OriginAirportID, COUNT(DestStateFips) FROM mytable WHERE DestAirportID NOT IN (14098, 13486) GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 17","hsqls":["SELECT OriginAirportID, COUNT(DestStateFips) FROM mytable WHERE DestAirportID NOT IN (14098, 13486) GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 17"]}
{"sql":"SELECT OriginStateFips, DepTimeBlk, DayOfWeek FROM mytable WHERE Distance > 288 ORDER BY OriginCityMarketID LIMIT 16"}
{"sql":"SELECT WheelsOff, DepDel15, CRSElapsedTime, MAX(AirlineID), MAX(FlightNum) FROM mytable WHERE ArrTime NOT IN (138) OR DepDelayMinutes BETWEEN 72.0 AND 333.0 AND DistanceGroup IN (3, 1, 10, 4, 9) GROUP BY WheelsOff, DepDel15, CRSElapsedTime  ORDER BY WheelsOff, DepDel15, CRSElapsedTime LIMIT 13","hsqls":["SELECT WheelsOff, DepDel15, CRSElapsedTime, MAX(AirlineID), MAX(FlightNum) FROM mytable WHERE ArrTime NOT IN (138) OR DepDelayMinutes BETWEEN 72.0 AND 333.0 AND DistanceGroup IN (3, 1, 10, 4, 9) GROUP BY WheelsOff, DepDel15, CRSElapsedTime  ORDER BY WheelsOff, DepDel15, CRSElapsedTime LIMIT 13"]}
{"sql":"SELECT DestState FROM mytable WHERE Carrier BETWEEN 'WN' AND 'EV' OR DivAirportLandings BETWEEN 9 AND 0 ORDER BY Diverted, DivDistance LIMIT 10"}
{"sql":"SELECT WeatherDelay, ActualElapsedTime, DestCityName, COUNT(SecurityDelay), MAX(Quarter), AVG(ArrDelay) FROM mytable WHERE UniqueCarrier IN ('OO', 'UA') OR DivArrDelay NOT IN (864, 72) GROUP BY WeatherDelay, ActualElapsedTime, DestCityName  ORDER BY WeatherDelay, ActualElapsedTime, DestCityName LIMIT 28","hsqls":["SELECT WeatherDelay, ActualElapsedTime, DestCityName, COUNT(SecurityDelay), MAX(Quarter), AVG(ArrDelay) FROM mytable WHERE UniqueCarrier IN ('OO', 'UA') OR DivArrDelay NOT IN (864, 72) GROUP BY WeatherDelay, ActualElapsedTime, DestCityName  ORDER BY WeatherDelay, ActualElapsedTime, DestCityName LIMIT 28"]}
{"sql":"SELECT MAX(\"Year\"), MIN(DepartureDelayGroups), COUNT(CancellationCode) FROM mytable WHERE ArrivalDelayGroups IN (10, 0, -2, 9, 11) LIMIT 8","hsqls":["SELECT MAX(`Year`), MIN(DepartureDelayGroups), COUNT(CancellationCode) FROM mytable WHERE ArrivalDelayGroups IN (10, 0, -2, 9, 11) LIMIT 8"]}
{"sql":"SELECT TotalAddGTime, ArrDelayMinutes, AirlineID FROM mytable WHERE DestAirportID NOT IN (10731, 14689, 12758) AND DivTotalGTimes BETWEEN 7 AND 87 ORDER BY DepartureDelayGroups LIMIT 19","hsqls":["SELECT TotalAddGTime, ArrDelayMinutes, AirlineID FROM mytable WHERE DestAirportID NOT IN (10731, 14689, 12758) AND (DivTotalGTimes[1] BETWEEN 7 AND 87 OR DivTotalGTimes[2] BETWEEN 7 AND 87 OR DivTotalGTimes[3] BETWEEN 7 AND 87 OR DivTotalGTimes[4] BETWEEN 7 AND 87 OR DivTotalGTimes[5] BETWEEN 7 AND 87) ORDER BY DepartureDelayGroups LIMIT 10000"]}
{"sql":"SELECT Diverted FROM mytable WHERE DepartureDelayGroups >= 2 ORDER BY LateAircraftDelay, OriginStateFips, ActualElapsedTime LIMIT 22"}
{"sql":"SELECT Distance FROM mytable WHERE Diverted >= 1 AND ArrTime <= 1554 ORDER BY DepDelay, DestState"}
{"sql":"SELECT DestStateFips, DivTailNums, DayofMonth FROM mytable WHERE CRSArrTime BETWEEN 809 AND 1655 AND LateAircraftDelay <= 154 ORDER BY DestAirportID, DestCityMarketID LIMIT 12","hsqls":["SELECT DestStateFips, DivTailNums, DayofMonth FROM mytable WHERE CRSArrTime BETWEEN 809 AND 1655 AND LateAircraftDelay <= 154 ORDER BY DestAirportID, DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivTailNums BETWEEN 'N821SK' AND 'N699BR'","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivTailNums[1] BETWEEN 'N821SK' AND 'N699BR' OR DivTailNums[2] BETWEEN 'N821SK' AND 'N699BR' OR DivTailNums[3] BETWEEN 'N821SK' AND 'N699BR' OR DivTailNums[4] BETWEEN 'N821SK' AND 'N699BR' OR DivTailNums[5] BETWEEN 'N821SK' AND 'N699BR') LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, Cancelled FROM mytable WHERE DivAirportSeqIDs IN (1342202, 1334205) ORDER BY ArrDelay LIMIT 16","hsqls":["SELECT LateAircraftDelay, Cancelled FROM mytable WHERE (DivAirportSeqIDs[1] IN (1342202, 1334205) OR DivAirportSeqIDs[2] IN (1342202, 1334205) OR DivAirportSeqIDs[3] IN (1342202, 1334205) OR DivAirportSeqIDs[4] IN (1342202, 1334205) OR DivAirportSeqIDs[5] IN (1342202, 1334205)) ORDER BY ArrDelay LIMIT 10000"]}
{"sql":"SELECT SUM(CarrierDelay), AVG(ArrDelay) FROM mytable WHERE DepDel15 BETWEEN -9999 AND 0 LIMIT 10"}
{"sql":"SELECT SUM(OriginAirportID), SUM(DistanceGroup), MIN(Distance) FROM mytable WHERE DepDelay IN (164.0, 84.0, 250.0, 217.0) LIMIT 8"}
{"sql":"SELECT OriginAirportSeqID, Dest FROM mytable WHERE ArrDelayMinutes NOT IN (226.0, 33.0, 166.0, 54.0) OR DaysSinceEpoch BETWEEN 16093 AND 16080 AND ActualElapsedTime NOT IN (22, 312, 344, 156) ORDER BY DestStateName LIMIT 13"}
{"sql":"SELECT OriginAirportSeqID, \"Year\", Origin, COUNT(DayofMonth), SUM(AirlineID), MAX(OriginAirportID) FROM mytable GROUP BY OriginAirportSeqID, \"Year\", Origin LIMIT 6","hsqls":["SELECT OriginAirportSeqID, Year, Origin, COUNT(DayofMonth), SUM(AirlineID), MAX(OriginAirportID) FROM mytable GROUP BY OriginAirportSeqID, Year, Origin LIMIT 6"]}
{"sql":"SELECT SUM(DivAirportLandings), MIN(TotalAddGTime), MIN(WheelsOff) FROM mytable"}
{"sql":"SELECT FirstDepTime, FlightDate, DestStateName, MAX(LongestAddGTime), MIN(OriginWac) FROM mytable GROUP BY FirstDepTime, FlightDate, DestStateName  ORDER BY FirstDepTime, FlightDate, DestStateName LIMIT 23","hsqls":["SELECT FirstDepTime, FlightDate, DestStateName, MAX(LongestAddGTime), MIN(OriginWac) FROM mytable GROUP BY FirstDepTime, FlightDate, DestStateName  ORDER BY FirstDepTime, FlightDate, DestStateName LIMIT 23"]}
{"sql":"SELECT DivReachedDest, FirstDepTime, OriginWac, COUNT(*) FROM mytable WHERE DivWheelsOns = 551 GROUP BY DivReachedDest, FirstDepTime, OriginWac LIMIT 15","hsqls":["SELECT DivReachedDest, FirstDepTime, OriginWac, COUNT(*) FROM mytable WHERE (DivWheelsOns[1] = 551 OR DivWheelsOns[2] = 551 OR DivWheelsOns[3] = 551 OR DivWheelsOns[4] = 551 OR DivWheelsOns[5] = 551) GROUP BY DivReachedDest, FirstDepTime, OriginWac LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID FROM mytable WHERE DestState BETWEEN 'NJ' AND 'TX' OR OriginAirportID IN (13873, 11977, 11905, 13342, 15991) ORDER BY DepDelayMinutes, CRSDepTime LIMIT 20"}
{"sql":"SELECT LateAircraftDelay, SecurityDelay, DestAirportID, SUM(CarrierDelay), AVG(NASDelay), SUM(DepDelayMinutes) FROM mytable GROUP BY LateAircraftDelay, SecurityDelay, DestAirportID  ORDER BY LateAircraftDelay, SecurityDelay, DestAirportID LIMIT 21","hsqls":["SELECT LateAircraftDelay, SecurityDelay, DestAirportID, SUM(CarrierDelay), AVG(NASDelay), SUM(DepDelayMinutes) FROM mytable GROUP BY LateAircraftDelay, SecurityDelay, DestAirportID  ORDER BY LateAircraftDelay, SecurityDelay, DestAirportID LIMIT 21"]}
{"sql":"SELECT CRSArrTime, ArrTimeBlk, COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 302 AND 382 OR DaysSinceEpoch < 16072 AND DivTotalGTimes BETWEEN 159 AND 54 GROUP BY CRSArrTime, ArrTimeBlk LIMIT 10","hsqls":["SELECT CRSArrTime, ArrTimeBlk, COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 302 AND 382 OR DaysSinceEpoch < 16072 AND (DivTotalGTimes[1] BETWEEN 159 AND 54 OR DivTotalGTimes[2] BETWEEN 159 AND 54 OR DivTotalGTimes[3] BETWEEN 159 AND 54 OR DivTotalGTimes[4] BETWEEN 159 AND 54 OR DivTotalGTimes[5] BETWEEN 159 AND 54) GROUP BY CRSArrTime, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT DivAirportSeqIDs, DivArrDelay FROM mytable WHERE Carrier > 'AS' AND DepDelay IN (-14.0, 93.0, 47.0) OR OriginWac BETWEEN 39 AND 45 LIMIT 21","hsqls":["SELECT DivAirportSeqIDs, DivArrDelay FROM mytable WHERE Carrier > 'AS' AND DepDelay IN (-14.0, 93.0, 47.0) OR OriginWac BETWEEN 39 AND 45 LIMIT 10000"]}
{"sql":"SELECT MIN(ArrDelayMinutes), MIN(LongestAddGTime) FROM mytable LIMIT 19"}
{"sql":"SELECT Distance, Dest, UniqueCarrier, MIN(ActualElapsedTime) FROM mytable WHERE DivWheelsOffs = 1605 OR DayOfWeek >= 3 GROUP BY Distance, Dest, UniqueCarrier LIMIT 15","hsqls":["SELECT Distance, Dest, UniqueCarrier, MIN(ActualElapsedTime) FROM mytable WHERE (DivWheelsOffs[1] = 1605 OR DivWheelsOffs[2] = 1605 OR DivWheelsOffs[3] = 1605 OR DivWheelsOffs[4] = 1605 OR DivWheelsOffs[5] = 1605) OR DayOfWeek >= 3 GROUP BY Distance, Dest, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes, DivDistance, AirlineID FROM mytable WHERE OriginAirportID NOT IN (12448, 15991, 14122, 13232, 10781) ORDER BY DepTimeBlk, ArrivalDelayGroups LIMIT 14","hsqls":["SELECT DivLongestGTimes, DivDistance, AirlineID FROM mytable WHERE OriginAirportID NOT IN (12448, 15991, 14122, 13232, 10781) ORDER BY DepTimeBlk, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT OriginState, DestCityMarketID, \"Month\", MAX(ActualElapsedTime) FROM mytable WHERE OriginCityName IN ('Madison, WI', 'Manhattan/Ft. Riley, KS', 'Lexington, KY', 'Sioux Falls, SD', 'Fort Lauderdale, FL') OR ArrTime BETWEEN 1722 AND 235 GROUP BY OriginState, DestCityMarketID, \"Month\" LIMIT 28","hsqls":["SELECT OriginState, DestCityMarketID, Month, MAX(ActualElapsedTime) FROM mytable WHERE OriginCityName IN ('Madison, WI', 'Manhattan/Ft. Riley, KS', 'Lexington, KY', 'Sioux Falls, SD', 'Fort Lauderdale, FL') OR ArrTime BETWEEN 1722 AND 235 GROUP BY OriginState, DestCityMarketID, `Month` LIMIT 28"]}
{"sql":"SELECT TotalAddGTime, DepTimeBlk, DivActualElapsedTime FROM mytable WHERE DivTailNums IN ('N953WN', 'N3750D', 'N827JB', 'N948WN', 'N8619F') OR SecurityDelay NOT IN (1, -9999) OR TaxiOut BETWEEN 12 AND 47 LIMIT 27","hsqls":["SELECT TotalAddGTime, DepTimeBlk, DivActualElapsedTime FROM mytable WHERE (DivTailNums[1] IN ('N953WN', 'N3750D', 'N827JB', 'N948WN', 'N8619F') OR DivTailNums[2] IN ('N953WN', 'N3750D', 'N827JB', 'N948WN', 'N8619F') OR DivTailNums[3] IN ('N953WN', 'N3750D', 'N827JB', 'N948WN', 'N8619F') OR DivTailNums[4] IN ('N953WN', 'N3750D', 'N827JB', 'N948WN', 'N8619F') OR DivTailNums[5] IN ('N953WN', 'N3750D', 'N827JB', 'N948WN', 'N8619F')) OR SecurityDelay NOT IN (1, -9999) OR TaxiOut BETWEEN 12 AND 47 LIMIT 10000"]}
{"sql":"SELECT AirTime FROM mytable WHERE WeatherDelay BETWEEN 177 AND 50 AND DayOfWeek BETWEEN 3 AND 4 ORDER BY Cancelled, DaysSinceEpoch LIMIT 19"}
{"sql":"SELECT TailNum, OriginStateName, SUM(DivReachedDest), MIN(CRSElapsedTime), MAX(Distance) FROM mytable WHERE OriginWac BETWEEN 14 AND 42 GROUP BY TailNum, OriginStateName  ORDER BY TailNum, OriginStateName LIMIT 13","hsqls":["SELECT TailNum, OriginStateName, SUM(DivReachedDest), MIN(CRSElapsedTime), MAX(Distance) FROM mytable WHERE OriginWac BETWEEN 14 AND 42 GROUP BY TailNum, OriginStateName  ORDER BY TailNum, OriginStateName LIMIT 13"]}
{"sql":"SELECT CRSDepTime, DivTotalGTimes, OriginStateName FROM mytable WHERE DepDel15 > 0 AND \"Year\" <> 2014 OR DaysSinceEpoch BETWEEN 16082 AND 16086 ORDER BY Cancelled, DestAirportID LIMIT 24","hsqls":["SELECT CRSDepTime, DivTotalGTimes, OriginStateName FROM mytable WHERE DepDel15 > 0 AND `Year` <> 2014 OR DaysSinceEpoch BETWEEN 16082 AND 16086 ORDER BY Cancelled, DestAirportID LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 15"}
{"sql":"SELECT DivDistance, DivArrDelay, CRSElapsedTime FROM mytable WHERE DivLongestGTimes >= 75.0 AND DaysSinceEpoch <> 16096 ORDER BY Distance, SecurityDelay LIMIT 10","hsqls":["SELECT DivDistance, DivArrDelay, CRSElapsedTime FROM mytable WHERE (DivLongestGTimes[1] >= 75.0 OR DivLongestGTimes[2] >= 75.0 OR DivLongestGTimes[3] >= 75.0 OR DivLongestGTimes[4] >= 75.0 OR DivLongestGTimes[5] >= 75.0) AND DaysSinceEpoch <> 16096 ORDER BY Distance, SecurityDelay LIMIT 10000"]}
{"sql":"SELECT DepDel15, MAX(DivActualElapsedTime) FROM mytable WHERE DestCityMarketID <> 30561 GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 23","hsqls":["SELECT DepDel15, MAX(DivActualElapsedTime) FROM mytable WHERE DestCityMarketID <> 30561 GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 23"]}
{"sql":"SELECT WeatherDelay, \"Month\" FROM mytable WHERE DayOfWeek IN (3, 7, 6, 4) AND DestCityMarketID BETWEEN 31537 AND 31953 AND AirTime IN (21, 80) ORDER BY OriginCityName, TailNum, Dest LIMIT 26","hsqls":["SELECT WeatherDelay, `Month` FROM mytable WHERE DayOfWeek IN (3, 7, 6, 4) AND DestCityMarketID BETWEEN 31537 AND 31953 AND AirTime IN (21, 80) ORDER BY OriginCityName, TailNum, Dest LIMIT 26"]}
{"sql":"SELECT DepTime FROM mytable WHERE TailNum BETWEEN 'N643SW' AND 'N33294' AND Cancelled <> 0 ORDER BY DestAirportSeqID LIMIT 23"}
{"sql":"SELECT TaxiIn, DestAirportSeqID, COUNT(FirstDepTime) FROM mytable WHERE ActualElapsedTime BETWEEN 181 AND 374 AND CarrierDelay BETWEEN 0 AND 150 AND WheelsOn BETWEEN 1133 AND 2230 GROUP BY TaxiIn, DestAirportSeqID  ORDER BY TaxiIn, DestAirportSeqID LIMIT 17","hsqls":["SELECT TaxiIn, DestAirportSeqID, COUNT(FirstDepTime) FROM mytable WHERE ActualElapsedTime BETWEEN 181 AND 374 AND CarrierDelay BETWEEN 0 AND 150 AND WheelsOn BETWEEN 1133 AND 2230 GROUP BY TaxiIn, DestAirportSeqID  ORDER BY TaxiIn, DestAirportSeqID LIMIT 17"]}
{"sql":"SELECT ArrTime FROM mytable WHERE FlightDate NOT IN ('2014-01-02') OR OriginStateFips BETWEEN 23 AND 25 ORDER BY CRSArrTime LIMIT 6"}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DaysSinceEpoch IN (16098, 16071, 16073) LIMIT 6"}
{"sql":"SELECT Cancelled FROM mytable ORDER BY DivDistance, TailNum, CancellationCode LIMIT 3"}
{"sql":"SELECT MIN(LateAircraftDelay) FROM mytable WHERE OriginCityName NOT IN ('Fargo, ND', 'Phoenix, AZ', 'Saginaw/Bay City/Midland, MI', 'West Palm Beach/Palm Beach, FL') LIMIT 29"}
{"sql":"SELECT WeatherDelay, SUM(Diverted) FROM mytable WHERE DivTailNums >= 'N462WN' GROUP BY WeatherDelay LIMIT 25","hsqls":["SELECT WeatherDelay, SUM(Diverted) FROM mytable WHERE (DivTailNums[1] >= 'N462WN' OR DivTailNums[2] >= 'N462WN' OR DivTailNums[3] >= 'N462WN' OR DivTailNums[4] >= 'N462WN' OR DivTailNums[5] >= 'N462WN') GROUP BY WeatherDelay LIMIT 10000"]}
{"sql":"SELECT DestWac, DivWheelsOffs FROM mytable WHERE TaxiIn IN (36) OR DepDelay BETWEEN 32.0 AND 211.0 OR AirTime BETWEEN 123 AND 196 LIMIT 28","hsqls":["SELECT DestWac, DivWheelsOffs FROM mytable WHERE TaxiIn IN (36) OR DepDelay BETWEEN 32.0 AND 211.0 OR AirTime BETWEEN 123 AND 196 LIMIT 10000"]}
{"sql":"SELECT SUM(CRSDepTime), MAX(OriginWac), MAX(ArrTime) FROM mytable LIMIT 18"}
{"sql":"SELECT DestState FROM mytable WHERE DepDelay BETWEEN 319.0 AND 340.0 LIMIT 21"}
{"sql":"SELECT FirstDepTime, DivActualElapsedTime FROM mytable WHERE DayofMonth IN (18, 11) OR TaxiOut >= 56 LIMIT 19"}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE CancellationCode IN ('A', 'B', 'C', 'noodles') ORDER BY DestCityMarketID LIMIT 20","hsqls":["SELECT DivWheelsOns FROM mytable WHERE CancellationCode IN ('A', 'B', 'C', 'noodles') ORDER BY DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, CRSArrTime, DivActualElapsedTime FROM mytable WHERE ArrivalDelayGroups IN (5, 12) OR DivArrDelay BETWEEN 73 AND 205 LIMIT 3"}
{"sql":"SELECT OriginAirportSeqID, ArrDel15, UniqueCarrier FROM mytable WHERE DayOfWeek >= 3 OR DayofMonth <= 30 LIMIT 12"}
{"sql":"SELECT DayOfWeek FROM mytable WHERE Diverted NOT IN (1, 0) ORDER BY FlightDate LIMIT 9"}
{"sql":"SELECT OriginState FROM mytable LIMIT 15"}
{"sql":"SELECT Quarter, OriginCityName, ArrDelayMinutes FROM mytable ORDER BY NASDelay LIMIT 14"}
{"sql":"SELECT MAX(\"Year\"), MIN(Distance) FROM mytable","hsqls":["SELECT MAX(`Year`), MIN(Distance) FROM mytable"]}
{"sql":"SELECT TaxiIn, Origin, CRSDepTime FROM mytable ORDER BY UniqueCarrier LIMIT 19"}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE CancellationCode < 'A' ORDER BY DepDel15, ArrivalDelayGroups LIMIT 22","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE CancellationCode < 'A' ORDER BY DepDel15, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT OriginState, MIN(DestCityMarketID), MAX(DestCityMarketID), COUNT(ArrDel15) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 6","hsqls":["SELECT OriginState, MIN(DestCityMarketID), MAX(DestCityMarketID), COUNT(ArrDel15) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 6"]}
{"sql":"SELECT Diverted, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DestWac NOT IN (82, 37) AND DepDel15 IN (1, 0, -9999) OR ArrTime BETWEEN 1244 AND 4 GROUP BY Diverted, DivActualElapsedTime  ORDER BY Diverted, DivActualElapsedTime LIMIT 10","hsqls":["SELECT Diverted, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DestWac NOT IN (82, 37) AND DepDel15 IN (1, 0, -9999) OR ArrTime BETWEEN 1244 AND 4 GROUP BY Diverted, DivActualElapsedTime  ORDER BY Diverted, DivActualElapsedTime LIMIT 10"]}
{"sql":"SELECT DaysSinceEpoch, MIN(TaxiIn), COUNT(DivAirportLandings) FROM mytable WHERE UniqueCarrier BETWEEN 'VX' AND 'OO' GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 22","hsqls":["SELECT DaysSinceEpoch, MIN(TaxiIn), COUNT(DivAirportLandings) FROM mytable WHERE UniqueCarrier BETWEEN 'VX' AND 'OO' GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 22"]}
{"sql":"SELECT COUNT(DepDelay), SUM(LongestAddGTime), MIN(DivAirportLandings) FROM mytable WHERE DivTailNums IN ('N365NB', 'N299SW', 'N797MX', 'N214WN') AND Origin IN ('ITO', 'SNA', 'FSD', 'OAJ', 'ILM') LIMIT 12","hsqls":["SELECT COUNT(DepDelay), SUM(LongestAddGTime), MIN(DivAirportLandings)  FROM mytable WHERE (DivTailNums[1] IN ('N365NB', 'N299SW', 'N797MX', 'N214WN') OR DivTailNums[2] IN ('N365NB', 'N299SW', 'N797MX', 'N214WN') OR DivTailNums[3] IN ('N365NB', 'N299SW', 'N797MX', 'N214WN') OR DivTailNums[4] IN ('N365NB', 'N299SW', 'N797MX', 'N214WN') OR DivTailNums[5] IN ('N365NB', 'N299SW', 'N797MX', 'N214WN')) AND Origin IN ('ITO', 'SNA', 'FSD', 'OAJ', 'ILM') LIMIT 10000"]}
{"sql":"SELECT FlightNum, OriginWac FROM mytable LIMIT 14"}
{"sql":"SELECT TailNum, MAX(ArrDelay), COUNT(Carrier), MAX(ArrDel15) FROM mytable WHERE DayofMonth BETWEEN 28 AND 8 GROUP BY TailNum  ORDER BY TailNum LIMIT 8","hsqls":["SELECT TailNum, MAX(ArrDelay), COUNT(Carrier), MAX(ArrDel15) FROM mytable WHERE DayofMonth BETWEEN 28 AND 8 GROUP BY TailNum  ORDER BY TailNum LIMIT 8"]}
{"sql":"SELECT SUM(DaysSinceEpoch), AVG(DepartureDelayGroups) FROM mytable WHERE DivAirports BETWEEN 'MSP' AND 'SAT' AND OriginWac < 66 OR DivDistance <= 328 LIMIT 20","hsqls":["SELECT SUM(DaysSinceEpoch), AVG(DepartureDelayGroups)  FROM mytable WHERE (DivAirports[1] BETWEEN 'MSP' AND 'SAT' OR DivAirports[2] BETWEEN 'MSP' AND 'SAT' OR DivAirports[3] BETWEEN 'MSP' AND 'SAT' OR DivAirports[4] BETWEEN 'MSP' AND 'SAT' OR DivAirports[5] BETWEEN 'MSP' AND 'SAT') AND OriginWac < 66 OR DivDistance <= 328 LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, MAX(DivActualElapsedTime) FROM mytable GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 18","hsqls":["SELECT FirstDepTime, MAX(DivActualElapsedTime) FROM mytable GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 18"]}
{"sql":"SELECT WeatherDelay, CRSArrTime, DayOfWeek FROM mytable WHERE WeatherDelay >= 98 OR ArrDelayMinutes IN (269.0) ORDER BY DestState, Quarter, AirlineID LIMIT 15"}
{"sql":"SELECT OriginWac FROM mytable WHERE CRSElapsedTime < 186 OR DestAirportID BETWEEN 12478 AND 13577 LIMIT 13"}
{"sql":"SELECT OriginStateFips, Flights, ArrDel15 FROM mytable WHERE DivDistance NOT IN (306) AND DestCityName >= 'Harlingen/San Benito, TX' LIMIT 10"}
{"sql":"SELECT DivLongestGTimes, DestCityMarketID FROM mytable WHERE Quarter <= 1 OR DestAirportID > 15841 ORDER BY ArrDelayMinutes, DestCityName LIMIT 9","hsqls":["SELECT DivLongestGTimes, DestCityMarketID FROM mytable WHERE Quarter <= 1 OR DestAirportID > 15841 ORDER BY ArrDelayMinutes, DestCityName LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DivAirportSeqIDs, ArrivalDelayGroups FROM mytable ORDER BY OriginAirportSeqID, ArrDelayMinutes LIMIT 23","hsqls":["SELECT WheelsOff, DivAirportSeqIDs, ArrivalDelayGroups FROM mytable ORDER BY OriginAirportSeqID, ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT DestAirportID, DivActualElapsedTime, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE OriginAirportID BETWEEN 13871 AND 14730 AND Quarter IN (1) GROUP BY DestAirportID, DivActualElapsedTime, ArrivalDelayGroups","hsqls":["SELECT DestAirportID, DivActualElapsedTime, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE OriginAirportID BETWEEN 13871 AND 14730 AND Quarter IN (1) GROUP BY DestAirportID, DivActualElapsedTime, ArrivalDelayGroups"]}
{"sql":"SELECT ArrDelay, DayofMonth, COUNT(*) FROM mytable WHERE AirlineID NOT IN (19977) OR Cancelled BETWEEN 0 AND 0 GROUP BY ArrDelay, DayofMonth  ORDER BY ArrDelay, DayofMonth LIMIT 10","hsqls":["SELECT ArrDelay, DayofMonth, COUNT(*) FROM mytable WHERE AirlineID NOT IN (19977) OR Cancelled BETWEEN 0 AND 0 GROUP BY ArrDelay, DayofMonth  ORDER BY ArrDelay, DayofMonth LIMIT 10"]}
{"sql":"SELECT TaxiOut, SecurityDelay, DestAirportSeqID, COUNT(*) FROM mytable WHERE \"Year\" <= 2014 GROUP BY TaxiOut, SecurityDelay, DestAirportSeqID LIMIT 7","hsqls":["SELECT TaxiOut, SecurityDelay, DestAirportSeqID, COUNT(*) FROM mytable WHERE `Year` <= 2014 GROUP BY TaxiOut, SecurityDelay, DestAirportSeqID LIMIT 7"]}
{"sql":"SELECT TaxiIn, DepDel15, OriginWac FROM mytable ORDER BY DistanceGroup, Quarter, DestAirportID LIMIT 15"}
{"sql":"SELECT DestCityName FROM mytable WHERE DivDistance > 368 AND OriginStateFips BETWEEN 47 AND 24 ORDER BY DestState, DestAirportSeqID, DivAirportLandings"}
{"sql":"SELECT \"Month\" FROM mytable WHERE Cancelled >= 1 AND OriginAirportSeqID BETWEEN 1445702 AND 1114603 LIMIT 17","hsqls":["SELECT `Month` FROM mytable WHERE Cancelled >= 1 AND OriginAirportSeqID BETWEEN 1445702 AND 1114603 LIMIT 17"]}
{"sql":"SELECT MAX(CRSDepTime), COUNT(CancellationCode), MAX(WeatherDelay) FROM mytable WHERE \"Year\" IN (2014) LIMIT 3","hsqls":["SELECT MAX(CRSDepTime), COUNT(CancellationCode), MAX(WeatherDelay) FROM mytable WHERE `Year` IN (2014) LIMIT 3"]}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 ORDER BY DivAirportLandings, DayOfWeek LIMIT 9","hsqls":["SELECT DivAirportIDs FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 ORDER BY DivAirportLandings, DayOfWeek LIMIT 10000"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE DivAirportSeqIDs BETWEEN 1415305 AND 1093002 AND DivAirportIDs <= 11292 OR CRSDepTime > 919 ORDER BY TaxiOut, DepTimeBlk, OriginWac LIMIT 16","hsqls":["SELECT CRSDepTime FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1415305 AND 1093002 OR DivAirportSeqIDs[2] BETWEEN 1415305 AND 1093002 OR DivAirportSeqIDs[3] BETWEEN 1415305 AND 1093002 OR DivAirportSeqIDs[4] BETWEEN 1415305 AND 1093002 OR DivAirportSeqIDs[5] BETWEEN 1415305 AND 1093002) AND (DivAirportIDs[1] <= 11292 OR DivAirportIDs[2] <= 11292 OR DivAirportIDs[3] <= 11292 OR DivAirportIDs[4] <= 11292 OR DivAirportIDs[5] <= 11292) OR CRSDepTime > 919 ORDER BY TaxiOut, DepTimeBlk, OriginWac LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestAirportSeqID IN (1153703) OR \"Year\" NOT IN (2014) OR CRSArrTime IN (1655, 740, 18, 248) LIMIT 5","hsqls":["SELECT COUNT(*) FROM mytable WHERE DestAirportSeqID IN (1153703) OR `Year` NOT IN (2014) OR CRSArrTime IN (1655, 740, 18, 248) LIMIT 5"]}
{"sql":"SELECT WheelsOff, \"Year\" FROM mytable WHERE Flights NOT IN (1) AND DivTailNums IN ('N936DN', 'N743SW', 'N314NB', 'N627MQ') LIMIT 2","hsqls":["SELECT WheelsOff, `Year` FROM mytable WHERE Flights NOT IN (1) AND (DivTailNums[1] IN ('N936DN', 'N743SW', 'N314NB', 'N627MQ') OR DivTailNums[2] IN ('N936DN', 'N743SW', 'N314NB', 'N627MQ') OR DivTailNums[3] IN ('N936DN', 'N743SW', 'N314NB', 'N627MQ') OR DivTailNums[4] IN ('N936DN', 'N743SW', 'N314NB', 'N627MQ') OR DivTailNums[5] IN ('N936DN', 'N743SW', 'N314NB', 'N627MQ')) LIMIT 10000"]}
{"sql":"SELECT MAX(AirlineID), MIN(OriginAirportSeqID), SUM(ArrivalDelayGroups) FROM mytable WHERE \"Year\" = 2014 AND DestStateFips IN (15) LIMIT 6","hsqls":["SELECT MAX(AirlineID), MIN(OriginAirportSeqID), SUM(ArrivalDelayGroups) FROM mytable WHERE `Year` = 2014 AND DestStateFips IN (15) LIMIT 6"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE WeatherDelay < 30 LIMIT 28"}
{"sql":"SELECT DivAirportLandings, CRSElapsedTime, COUNT(ArrivalDelayGroups), AVG(OriginStateFips), AVG(DivActualElapsedTime) FROM mytable WHERE AirlineID BETWEEN 20437 AND 20436 AND CRSArrTime NOT IN (2227, 1900, 1106, 2036, 2116) GROUP BY DivAirportLandings, CRSElapsedTime  ORDER BY DivAirportLandings, CRSElapsedTime LIMIT 28","hsqls":["SELECT DivAirportLandings, CRSElapsedTime, COUNT(ArrivalDelayGroups), AVG(OriginStateFips), AVG(DivActualElapsedTime) FROM mytable WHERE AirlineID BETWEEN 20437 AND 20436 AND CRSArrTime NOT IN (2227, 1900, 1106, 2036, 2116) GROUP BY DivAirportLandings, CRSElapsedTime  ORDER BY DivAirportLandings, CRSElapsedTime LIMIT 28"]}
{"sql":"SELECT Quarter, \"Month\", DaysSinceEpoch, AVG(DepDelay) FROM mytable GROUP BY Quarter, \"Month\", DaysSinceEpoch LIMIT 22","hsqls":["SELECT Quarter, Month, DaysSinceEpoch, AVG(DepDelay) FROM mytable GROUP BY Quarter, Month, DaysSinceEpoch LIMIT 22"]}
{"sql":"SELECT OriginStateFips, CRSArrTime FROM mytable ORDER BY ArrDel15, DayOfWeek LIMIT 10"}
{"sql":"SELECT TotalAddGTime, COUNT(DestStateFips), MIN(DivArrDelay), AVG(AirlineID) FROM mytable GROUP BY TotalAddGTime","hsqls":["SELECT TotalAddGTime, COUNT(DestStateFips), MIN(DivArrDelay), AVG(AirlineID) FROM mytable GROUP BY TotalAddGTime"]}
{"sql":"SELECT OriginCityName, TotalAddGTime, ArrDelay, MIN(DestAirportID), COUNT(AirlineID), SUM(SecurityDelay) FROM mytable WHERE DepDel15 BETWEEN 0 AND -9999 GROUP BY OriginCityName, TotalAddGTime, ArrDelay  ORDER BY OriginCityName, TotalAddGTime, ArrDelay LIMIT 10","hsqls":["SELECT OriginCityName, TotalAddGTime, ArrDelay, MIN(DestAirportID), COUNT(AirlineID), SUM(SecurityDelay) FROM mytable WHERE DepDel15 BETWEEN 0 AND -9999 GROUP BY OriginCityName, TotalAddGTime, ArrDelay  ORDER BY OriginCityName, TotalAddGTime, ArrDelay LIMIT 10"]}
{"sql":"SELECT WeatherDelay, DivActualElapsedTime, MIN(TaxiOut) FROM mytable WHERE CRSElapsedTime NOT IN (374, 268, 259) OR CRSElapsedTime <= 406 GROUP BY WeatherDelay, DivActualElapsedTime  ORDER BY WeatherDelay, DivActualElapsedTime LIMIT 23","hsqls":["SELECT WeatherDelay, DivActualElapsedTime, MIN(TaxiOut) FROM mytable WHERE CRSElapsedTime NOT IN (374, 268, 259) OR CRSElapsedTime <= 406 GROUP BY WeatherDelay, DivActualElapsedTime  ORDER BY WeatherDelay, DivActualElapsedTime LIMIT 23"]}
{"sql":"SELECT DepTime, OriginCityName, DepTimeBlk FROM mytable WHERE LateAircraftDelay IN (115, 7, 64, 76, 209) ORDER BY FirstDepTime LIMIT 26"}
{"sql":"SELECT DestAirportSeqID, CRSElapsedTime FROM mytable WHERE DayofMonth BETWEEN 2 AND 9 ORDER BY WeatherDelay, DestStateFips, DestStateName LIMIT 12"}
{"sql":"SELECT DepartureDelayGroups, DestWac, DestAirportSeqID FROM mytable WHERE ArrDelayMinutes IN (53.0, 220.0, 74.0) ORDER BY OriginCityName, NASDelay LIMIT 6"}
{"sql":"SELECT LateAircraftDelay, DepDelayMinutes, CarrierDelay, MAX(ArrDel15), MIN(DivArrDelay), SUM(OriginAirportID) FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'C' OR OriginState NOT IN ('ND', 'KS', 'NJ') GROUP BY LateAircraftDelay, DepDelayMinutes, CarrierDelay  ORDER BY LateAircraftDelay, DepDelayMinutes, CarrierDelay LIMIT 28","hsqls":["SELECT LateAircraftDelay, DepDelayMinutes, CarrierDelay, MAX(ArrDel15), MIN(DivArrDelay), SUM(OriginAirportID) FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'C' OR OriginState NOT IN ('ND', 'KS', 'NJ') GROUP BY LateAircraftDelay, DepDelayMinutes, CarrierDelay  ORDER BY LateAircraftDelay, DepDelayMinutes, CarrierDelay LIMIT 28"]}
{"sql":"SELECT Distance, CRSElapsedTime, MAX(DestAirportSeqID), MAX(OriginAirportID), MAX(WeatherDelay) FROM mytable GROUP BY Distance, CRSElapsedTime  ORDER BY Distance, CRSElapsedTime LIMIT 13","hsqls":["SELECT Distance, CRSElapsedTime, MAX(DestAirportSeqID), MAX(OriginAirportID), MAX(WeatherDelay) FROM mytable GROUP BY Distance, CRSElapsedTime  ORDER BY Distance, CRSElapsedTime LIMIT 13"]}
{"sql":"SELECT DivTailNums FROM mytable ORDER BY DivDistance LIMIT 17","hsqls":["SELECT DivTailNums FROM mytable ORDER BY DivDistance LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, Dest, DestAirportID, COUNT(*) FROM mytable GROUP BY OriginCityMarketID, Dest, DestAirportID  ORDER BY OriginCityMarketID, Dest, DestAirportID LIMIT 24","hsqls":["SELECT OriginCityMarketID, Dest, DestAirportID, COUNT(*) FROM mytable GROUP BY OriginCityMarketID, Dest, DestAirportID  ORDER BY OriginCityMarketID, Dest, DestAirportID LIMIT 24"]}
{"sql":"SELECT AVG(CRSDepTime) FROM mytable WHERE Dest = 'EYW' AND CRSArrTime = 1336 OR DayofMonth >= 1 LIMIT 10"}
{"sql":"SELECT DivDistance, COUNT(*) FROM mytable WHERE ArrDelay = 152.0 OR DepDelay <= 73.0 AND DivWheelsOffs >= 1159 GROUP BY DivDistance LIMIT 8","hsqls":["SELECT DivDistance, COUNT(*) FROM mytable WHERE ArrDelay = 152.0 OR DepDelay <= 73.0 AND (DivWheelsOffs[1] >= 1159 OR DivWheelsOffs[2] >= 1159 OR DivWheelsOffs[3] >= 1159 OR DivWheelsOffs[4] >= 1159 OR DivWheelsOffs[5] >= 1159) GROUP BY DivDistance LIMIT 10000"]}
{"sql":"SELECT DepDel15 FROM mytable WHERE DivAirportSeqIDs BETWEEN 1066602 AND 1291503 ORDER BY DepDel15, \"Month\" LIMIT 7","hsqls":["SELECT DepDel15 FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1066602 AND 1291503 OR DivAirportSeqIDs[2] BETWEEN 1066602 AND 1291503 OR DivAirportSeqIDs[3] BETWEEN 1066602 AND 1291503 OR DivAirportSeqIDs[4] BETWEEN 1066602 AND 1291503 OR DivAirportSeqIDs[5] BETWEEN 1066602 AND 1291503) ORDER BY DepDel15, `Month` LIMIT 10000"]}
{"sql":"SELECT FirstDepTime FROM mytable WHERE DestAirportID >= 15249 AND DayOfWeek NOT IN (6) OR WheelsOff <= 1920 ORDER BY Quarter, FirstDepTime, DestStateName LIMIT 25"}
{"sql":"SELECT DivWheelsOns FROM mytable ORDER BY SecurityDelay LIMIT 1","hsqls":["SELECT DivWheelsOns FROM mytable ORDER BY SecurityDelay LIMIT 10000"]}
{"sql":"SELECT TaxiOut, Carrier, DestCityMarketID FROM mytable WHERE DepDelayMinutes NOT IN (81.0, 271.0) AND DestAirportSeqID = 1114603 AND TaxiIn BETWEEN 80 AND 116 ORDER BY FlightNum, DepDelayMinutes LIMIT 6"}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE NASDelay > 53 OR \"Year\" NOT IN (2014) OR TailNum BETWEEN 'N407WN' AND 'N576SW' ORDER BY DivReachedDest, DepDelayMinutes, OriginWac LIMIT 18","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE NASDelay > 53 OR `Year` NOT IN (2014) OR TailNum BETWEEN 'N407WN' AND 'N576SW' ORDER BY DivReachedDest, DepDelayMinutes, OriginWac LIMIT 10000"]}
{"sql":"SELECT DestStateName, DayofMonth, DivActualElapsedTime FROM mytable WHERE OriginState IN ('TX', 'CO', 'NH', 'WV', 'SC') AND DivTailNums IN ('N13903', 'N925AT', 'N560UW') OR CancellationCode IN ('A', 'B') ORDER BY OriginStateFips, DivDistance LIMIT 20","hsqls":["SELECT DestStateName, DayofMonth, DivActualElapsedTime FROM mytable WHERE OriginState IN ('TX', 'CO', 'NH', 'WV', 'SC') AND (DivTailNums[1] IN ('N13903', 'N925AT', 'N560UW') OR DivTailNums[2] IN ('N13903', 'N925AT', 'N560UW') OR DivTailNums[3] IN ('N13903', 'N925AT', 'N560UW') OR DivTailNums[4] IN ('N13903', 'N925AT', 'N560UW') OR DivTailNums[5] IN ('N13903', 'N925AT', 'N560UW')) OR CancellationCode IN ('A', 'B') ORDER BY OriginStateFips, DivDistance LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, ArrivalDelayGroups FROM mytable WHERE Distance = 31 OR OriginCityMarketID BETWEEN 31337 AND 32337 ORDER BY TailNum LIMIT 16"}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DivWheelsOns >= 2237 LIMIT 16","hsqls":["SELECT CRSArrTime FROM mytable WHERE (DivWheelsOns[1] >= 2237 OR DivWheelsOns[2] >= 2237 OR DivWheelsOns[3] >= 2237 OR DivWheelsOns[4] >= 2237 OR DivWheelsOns[5] >= 2237) LIMIT 10000"]}
{"sql":"SELECT TaxiIn, Cancelled, DivArrDelay, MAX(DivDistance), MIN(DepDelay), AVG(DepDelayMinutes) FROM mytable WHERE DepTime <= 2139 AND DestAirportSeqID BETWEEN 1018502 AND 1042302 GROUP BY TaxiIn, Cancelled, DivArrDelay  ORDER BY TaxiIn, Cancelled, DivArrDelay LIMIT 21","hsqls":["SELECT TaxiIn, Cancelled, DivArrDelay, MAX(DivDistance), MIN(DepDelay), AVG(DepDelayMinutes) FROM mytable WHERE DepTime <= 2139 AND DestAirportSeqID BETWEEN 1018502 AND 1042302 GROUP BY TaxiIn, Cancelled, DivArrDelay  ORDER BY TaxiIn, Cancelled, DivArrDelay LIMIT 21"]}
{"sql":"SELECT OriginState, ArrTime, COUNT(DestState) FROM mytable WHERE DayofMonth NOT IN (10, 30, 9, 8) OR CRSElapsedTime = 279 AND UniqueCarrier < 'DL' GROUP BY OriginState, ArrTime","hsqls":["SELECT OriginState, ArrTime, COUNT(DestState) FROM mytable WHERE DayofMonth NOT IN (10, 30, 9, 8) OR CRSElapsedTime = 279 AND UniqueCarrier < 'DL' GROUP BY OriginState, ArrTime"]}
{"sql":"SELECT ArrDelayMinutes, UniqueCarrier FROM mytable ORDER BY LateAircraftDelay, CarrierDelay, ArrDel15 LIMIT 25"}
{"sql":"SELECT Carrier FROM mytable WHERE DivTotalGTimes IN (1, 92, 36, 70, 60) AND DestStateName NOT IN ('Louisiana', 'West Virginia', 'Iowa') ORDER BY TaxiOut, NASDelay, ArrDel15 LIMIT 22","hsqls":["SELECT Carrier FROM mytable WHERE (DivTotalGTimes[1] IN (1, 92, 36, 70, 60) OR DivTotalGTimes[2] IN (1, 92, 36, 70, 60) OR DivTotalGTimes[3] IN (1, 92, 36, 70, 60) OR DivTotalGTimes[4] IN (1, 92, 36, 70, 60) OR DivTotalGTimes[5] IN (1, 92, 36, 70, 60)) AND DestStateName NOT IN ('Louisiana', 'West Virginia', 'Iowa') ORDER BY TaxiOut, NASDelay, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, Origin, CRSDepTime, COUNT(*) FROM mytable WHERE NASDelay BETWEEN 4 AND 96 AND OriginStateName IN ('Massachusetts', 'Iowa') GROUP BY DivReachedDest, Origin, CRSDepTime  ORDER BY DivReachedDest, Origin, CRSDepTime LIMIT 29","hsqls":["SELECT DivReachedDest, Origin, CRSDepTime, COUNT(*) FROM mytable WHERE NASDelay BETWEEN 4 AND 96 AND OriginStateName IN ('Massachusetts', 'Iowa') GROUP BY DivReachedDest, Origin, CRSDepTime  ORDER BY DivReachedDest, Origin, CRSDepTime LIMIT 29"]}
{"sql":"SELECT Distance, ArrTimeBlk, CRSElapsedTime, AVG(CRSElapsedTime) FROM mytable GROUP BY Distance, ArrTimeBlk, CRSElapsedTime  ORDER BY Distance, ArrTimeBlk, CRSElapsedTime LIMIT 8","hsqls":["SELECT Distance, ArrTimeBlk, CRSElapsedTime, AVG(CRSElapsedTime) FROM mytable GROUP BY Distance, ArrTimeBlk, CRSElapsedTime  ORDER BY Distance, ArrTimeBlk, CRSElapsedTime LIMIT 8"]}
{"sql":"SELECT DivReachedDest, DepDelay, Dest FROM mytable WHERE ArrDelay <> 363.0 OR WheelsOff BETWEEN 1836 AND 905 OR DivReachedDest BETWEEN 1 AND 1 ORDER BY DayofMonth LIMIT 11"}
{"sql":"SELECT WheelsOff, SecurityDelay, DestStateFips, SUM(DepTime), SUM(OriginAirportSeqID) FROM mytable WHERE SecurityDelay BETWEEN 0 AND 10 GROUP BY WheelsOff, SecurityDelay, DestStateFips  ORDER BY WheelsOff, SecurityDelay, DestStateFips LIMIT 12","hsqls":["SELECT WheelsOff, SecurityDelay, DestStateFips, SUM(DepTime), SUM(OriginAirportSeqID) FROM mytable WHERE SecurityDelay BETWEEN 0 AND 10 GROUP BY WheelsOff, SecurityDelay, DestStateFips  ORDER BY WheelsOff, SecurityDelay, DestStateFips LIMIT 12"]}
{"sql":"SELECT TaxiOut, DepartureDelayGroups, \"Year\", MAX(OriginStateFips), MAX(Cancelled) FROM mytable WHERE DestStateFips < 6 GROUP BY TaxiOut, DepartureDelayGroups, \"Year\" LIMIT 16","hsqls":["SELECT TaxiOut, DepartureDelayGroups, Year, MAX(OriginStateFips), MAX(Cancelled) FROM mytable WHERE DestStateFips < 6 GROUP BY TaxiOut, DepartureDelayGroups, `Year` LIMIT 16"]}
{"sql":"SELECT NASDelay, AirTime, WheelsOn, SUM(TaxiOut), MIN(CRSElapsedTime), MAX(DayofMonth) FROM mytable GROUP BY NASDelay, AirTime, WheelsOn  ORDER BY NASDelay, AirTime, WheelsOn LIMIT 4","hsqls":["SELECT NASDelay, AirTime, WheelsOn, SUM(TaxiOut), MIN(CRSElapsedTime), MAX(DayofMonth) FROM mytable GROUP BY NASDelay, AirTime, WheelsOn  ORDER BY NASDelay, AirTime, WheelsOn LIMIT 4"]}
{"sql":"SELECT DivReachedDest, OriginStateFips, DivWheelsOffs FROM mytable WHERE DestCityMarketID IN (30562) ORDER BY DivDistance, AirlineID LIMIT 5","hsqls":["SELECT DivReachedDest, OriginStateFips, DivWheelsOffs FROM mytable WHERE DestCityMarketID IN (30562) ORDER BY DivDistance, AirlineID LIMIT 10000"]}
{"sql":"SELECT Quarter, SecurityDelay, DepTimeBlk, COUNT(Carrier), MIN(OriginAirportID), COUNT(ArrTime) FROM mytable GROUP BY Quarter, SecurityDelay, DepTimeBlk  ORDER BY Quarter, SecurityDelay, DepTimeBlk LIMIT 13","hsqls":["SELECT Quarter, SecurityDelay, DepTimeBlk, COUNT(Carrier), MIN(OriginAirportID), COUNT(ArrTime) FROM mytable GROUP BY Quarter, SecurityDelay, DepTimeBlk  ORDER BY Quarter, SecurityDelay, DepTimeBlk LIMIT 13"]}
{"sql":"SELECT DivReachedDest, FlightDate FROM mytable WHERE OriginState = 'MT' OR TailNum BETWEEN 'N4YFAA' AND 'N297WN' ORDER BY \"Month\" LIMIT 25","hsqls":["SELECT DivReachedDest, FlightDate FROM mytable WHERE OriginState = 'MT' OR TailNum BETWEEN 'N4YFAA' AND 'N297WN' ORDER BY `Month` LIMIT 25"]}
{"sql":"SELECT OriginAirportSeqID, LateAircraftDelay, DivTailNums FROM mytable ORDER BY OriginCityMarketID, DestStateFips, CRSDepTime LIMIT 11","hsqls":["SELECT OriginAirportSeqID, LateAircraftDelay, DivTailNums FROM mytable ORDER BY OriginCityMarketID, DestStateFips, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DestWac, CRSArrTime FROM mytable WHERE DivReachedDest > -9999 LIMIT 17"}
{"sql":"SELECT DivActualElapsedTime FROM mytable WHERE ArrivalDelayGroups <> 2 AND DestCityMarketID > 31041 AND OriginAirportID NOT IN (10980, 13344) ORDER BY DaysSinceEpoch LIMIT 2"}
{"sql":"SELECT Diverted, Flights, COUNT(DayofMonth), COUNT(FlightDate) FROM mytable WHERE DaysSinceEpoch IN (16097, 16077) GROUP BY Diverted, Flights  ORDER BY Diverted, Flights LIMIT 12","hsqls":["SELECT Diverted, Flights, COUNT(DayofMonth), COUNT(FlightDate) FROM mytable WHERE DaysSinceEpoch IN (16097, 16077) GROUP BY Diverted, Flights  ORDER BY Diverted, Flights LIMIT 12"]}
{"sql":"SELECT DaysSinceEpoch FROM mytable ORDER BY DestCityName, Origin LIMIT 17"}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE TaxiOut BETWEEN 53 AND 48 ORDER BY \"Month\", CRSDepTime LIMIT 14","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE TaxiOut BETWEEN 53 AND 48 ORDER BY Month, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, ArrivalDelayGroups FROM mytable WHERE OriginStateFips < 45 ORDER BY FirstDepTime, OriginStateName LIMIT 23"}
{"sql":"SELECT MIN(DestWac) FROM mytable WHERE TaxiIn NOT IN (35, 16, 101) AND TaxiIn IN (37) AND DayOfWeek >= 2 LIMIT 17"}
{"sql":"SELECT Distance, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DayofMonth BETWEEN 28 AND 5 GROUP BY Distance, DivActualElapsedTime  ORDER BY Distance, DivActualElapsedTime LIMIT 4","hsqls":["SELECT Distance, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DayofMonth BETWEEN 28 AND 5 GROUP BY Distance, DivActualElapsedTime  ORDER BY Distance, DivActualElapsedTime LIMIT 4"]}
{"sql":"SELECT SUM(\"Year\"), MIN(OriginCityMarketID) FROM mytable LIMIT 11","hsqls":["SELECT SUM(`Year`), MIN(OriginCityMarketID) FROM mytable LIMIT 11"]}
{"sql":"SELECT CarrierDelay, NASDelay, WheelsOn, AVG(FlightNum) FROM mytable GROUP BY CarrierDelay, NASDelay, WheelsOn  ORDER BY CarrierDelay, NASDelay, WheelsOn LIMIT 4","hsqls":["SELECT CarrierDelay, NASDelay, WheelsOn, AVG(FlightNum) FROM mytable GROUP BY CarrierDelay, NASDelay, WheelsOn  ORDER BY CarrierDelay, NASDelay, WheelsOn LIMIT 4"]}
{"sql":"SELECT WheelsOn, COUNT(*) FROM mytable WHERE OriginWac BETWEEN 66 AND 36 OR DivWheelsOns > 53 GROUP BY WheelsOn LIMIT 10","hsqls":["SELECT WheelsOn, COUNT(*) FROM mytable WHERE OriginWac BETWEEN 66 AND 36 OR (DivWheelsOns[1] > 53 OR DivWheelsOns[2] > 53 OR DivWheelsOns[3] > 53 OR DivWheelsOns[4] > 53 OR DivWheelsOns[5] > 53) GROUP BY WheelsOn LIMIT 10000"]}
{"sql":"SELECT OriginState, DivDistance, NASDelay FROM mytable WHERE Cancelled BETWEEN 1 AND 0 LIMIT 4"}
{"sql":"SELECT \"Year\", Flights, COUNT(*) FROM mytable GROUP BY \"Year\", Flights LIMIT 9","hsqls":["SELECT Year, Flights, COUNT(*) FROM mytable GROUP BY Year, Flights LIMIT 9"]}
{"sql":"SELECT CarrierDelay FROM mytable WHERE OriginWac <> 84 AND Carrier IN ('DL', 'HA', 'B6', 'OO', 'AS') OR \"Month\" NOT IN (1) LIMIT 5","hsqls":["SELECT CarrierDelay FROM mytable WHERE OriginWac <> 84 AND Carrier IN ('DL', 'HA', 'B6', 'OO', 'AS') OR `Month` NOT IN (1) LIMIT 5"]}
{"sql":"SELECT ArrTimeBlk, Dest FROM mytable WHERE DaysSinceEpoch NOT IN (16101, 16100) AND DepTime > 1209 OR DistanceGroup = 10 LIMIT 28"}
{"sql":"SELECT Quarter, LateAircraftDelay, LongestAddGTime FROM mytable LIMIT 4"}
{"sql":"SELECT AVG(Distance) FROM mytable WHERE Distance NOT IN (1447, 296, 1076, 1300, 1587) AND DestCityMarketID > 30333 LIMIT 3"}
{"sql":"SELECT DepTimeBlk FROM mytable WHERE DivActualElapsedTime > 251 ORDER BY LongestAddGTime LIMIT 9"}
{"sql":"SELECT COUNT(OriginStateFips), COUNT(DayofMonth) FROM mytable LIMIT 19"}
{"sql":"SELECT MIN(WeatherDelay), AVG(DivAirportLandings) FROM mytable WHERE ArrivalDelayGroups BETWEEN 7 AND 8 OR TailNum BETWEEN 'N790SK' AND 'N769SW' LIMIT 17"}
{"sql":"SELECT DepDelay, FlightNum, SecurityDelay, AVG(DistanceGroup) FROM mytable WHERE ArrDelayMinutes <= 39.0 GROUP BY DepDelay, FlightNum, SecurityDelay  ORDER BY DepDelay, FlightNum, SecurityDelay LIMIT 7","hsqls":["SELECT DepDelay, FlightNum, SecurityDelay, AVG(DistanceGroup) FROM mytable WHERE ArrDelayMinutes <= 39.0 GROUP BY DepDelay, FlightNum, SecurityDelay  ORDER BY DepDelay, FlightNum, SecurityDelay LIMIT 7"]}
{"sql":"SELECT WheelsOff, OriginStateName, DayOfWeek, MIN(Distance) FROM mytable WHERE Origin BETWEEN 'FAY' AND 'LAN' AND Carrier >= 'MQ' OR FlightDate BETWEEN '2014-01-10' AND '2014-01-21' GROUP BY WheelsOff, OriginStateName, DayOfWeek  ORDER BY WheelsOff, OriginStateName, DayOfWeek LIMIT 28","hsqls":["SELECT WheelsOff, OriginStateName, DayOfWeek, MIN(Distance) FROM mytable WHERE Origin BETWEEN 'FAY' AND 'LAN' AND Carrier >= 'MQ' OR FlightDate BETWEEN '2014-01-10' AND '2014-01-21' GROUP BY WheelsOff, OriginStateName, DayOfWeek  ORDER BY WheelsOff, OriginStateName, DayOfWeek LIMIT 28"]}
{"sql":"SELECT DestStateFips FROM mytable ORDER BY DistanceGroup, DivArrDelay, CRSElapsedTime LIMIT 5"}
{"sql":"SELECT TotalAddGTime FROM mytable WHERE ArrTimeBlk NOT IN ('2000-2059', '1400-1459') LIMIT 10"}
{"sql":"SELECT Flights, DestCityName, Dest, COUNT(SecurityDelay), MAX(CarrierDelay) FROM mytable WHERE ArrDel15 = 1 AND CarrierDelay NOT IN (98, 171, 13, 450, 28) OR Quarter BETWEEN 1 AND 1 GROUP BY Flights, DestCityName, Dest","hsqls":["SELECT Flights, DestCityName, Dest, COUNT(SecurityDelay), MAX(CarrierDelay) FROM mytable WHERE ArrDel15 = 1 AND CarrierDelay NOT IN (98, 171, 13, 450, 28) OR Quarter BETWEEN 1 AND 1 GROUP BY Flights, DestCityName, Dest"]}
{"sql":"SELECT DivAirportIDs, DestAirportID FROM mytable LIMIT 1","hsqls":["SELECT DivAirportIDs, DestAirportID FROM mytable LIMIT 10000"]}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE DivReachedDest <= -9999 ORDER BY DepDel15 LIMIT 6","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE DivReachedDest <= -9999 ORDER BY DepDel15 LIMIT 10000"]}
{"sql":"SELECT MIN(OriginStateFips), AVG(OriginWac), MAX(DepDel15) FROM mytable WHERE DepDel15 BETWEEN -9999 AND 0 LIMIT 22"}
{"sql":"SELECT ArrDelayMinutes, MIN(DaysSinceEpoch), SUM(Diverted) FROM mytable WHERE DivDistance <> 500 GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 21","hsqls":["SELECT ArrDelayMinutes, MIN(DaysSinceEpoch), SUM(Diverted) FROM mytable WHERE DivDistance <> 500 GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 21"]}
{"sql":"SELECT SUM(OriginAirportSeqID) FROM mytable WHERE Dest BETWEEN 'SLC' AND 'GPT' LIMIT 7"}
{"sql":"SELECT UniqueCarrier FROM mytable ORDER BY DestState LIMIT 13"}
{"sql":"SELECT DepDelay, OriginStateFips, DestCityName FROM mytable WHERE DivAirportLandings >= 0 LIMIT 10"}
{"sql":"SELECT DayofMonth FROM mytable ORDER BY WheelsOff, WheelsOn LIMIT 21"}
{"sql":"SELECT DivDistance, Distance, ArrDelayMinutes FROM mytable WHERE \"Year\" <> 2014 OR DepDelay NOT IN (68.0, 257.0, 55.0, 115.0, 218.0) AND DepDelay NOT IN (157.0, 254.0, 38.0) ORDER BY OriginCityName, Dest LIMIT 1","hsqls":["SELECT DivDistance, Distance, ArrDelayMinutes FROM mytable WHERE `Year` <> 2014 OR DepDelay NOT IN (68.0, 257.0, 55.0, 115.0, 218.0) AND DepDelay NOT IN (157.0, 254.0, 38.0) ORDER BY OriginCityName, Dest LIMIT 1"]}
{"sql":"SELECT DestState, LongestAddGTime, DivActualElapsedTime FROM mytable WHERE DepTime IN (1033, 750, 1850) AND DestStateFips BETWEEN 15 AND 9 OR WheelsOn <= 1409 ORDER BY TailNum, DepTimeBlk, DaysSinceEpoch LIMIT 22"}
{"sql":"SELECT DivWheelsOns, DivAirports, DestStateFips FROM mytable ORDER BY DepDel15, AirTime LIMIT 21","hsqls":["SELECT DivWheelsOns, DivAirports, DestStateFips FROM mytable ORDER BY DepDel15, AirTime LIMIT 10000"]}
{"sql":"SELECT OriginStateName, COUNT(*) FROM mytable WHERE OriginWac IN (92, 35, 34, 39) OR DivWheelsOffs IN (1857, 1521, 2226) AND LongestAddGTime < 54 GROUP BY OriginStateName LIMIT 28","hsqls":["SELECT OriginStateName, COUNT(*) FROM mytable WHERE OriginWac IN (92, 35, 34, 39) OR (DivWheelsOffs[1] IN (1857, 1521, 2226) OR DivWheelsOffs[2] IN (1857, 1521, 2226) OR DivWheelsOffs[3] IN (1857, 1521, 2226) OR DivWheelsOffs[4] IN (1857, 1521, 2226) OR DivWheelsOffs[5] IN (1857, 1521, 2226)) AND LongestAddGTime < 54 GROUP BY OriginStateName LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 205.0 AND 73.0 LIMIT 1"}
{"sql":"SELECT DivTotalGTimes FROM mytable ORDER BY Cancelled, DepTimeBlk LIMIT 20","hsqls":["SELECT DivTotalGTimes FROM mytable ORDER BY Cancelled, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, OriginWac FROM mytable WHERE WheelsOn BETWEEN 32 AND 2138 OR TotalAddGTime NOT IN (24, 11) LIMIT 28"}
{"sql":"SELECT Dest, MIN(DestWac), MIN(Flights) FROM mytable WHERE LateAircraftDelay <= 63 GROUP BY Dest  ORDER BY Dest LIMIT 18","hsqls":["SELECT Dest, MIN(DestWac), MIN(Flights) FROM mytable WHERE LateAircraftDelay <= 63 GROUP BY Dest  ORDER BY Dest LIMIT 18"]}
{"sql":"SELECT ActualElapsedTime, ArrTime, Cancelled, AVG(DestStateFips), AVG(ArrDelay) FROM mytable WHERE OriginStateName BETWEEN 'U.S. Pacific Trust Territories and Possessions' AND 'Delaware' AND FlightNum BETWEEN 1661 AND 44 GROUP BY ActualElapsedTime, ArrTime, Cancelled  ORDER BY ActualElapsedTime, ArrTime, Cancelled LIMIT 10","hsqls":["SELECT ActualElapsedTime, ArrTime, Cancelled, AVG(DestStateFips), AVG(ArrDelay) FROM mytable WHERE OriginStateName BETWEEN 'U.S. Pacific Trust Territories and Possessions' AND 'Delaware' AND FlightNum BETWEEN 1661 AND 44 GROUP BY ActualElapsedTime, ArrTime, Cancelled  ORDER BY ActualElapsedTime, ArrTime, Cancelled LIMIT 10"]}
{"sql":"SELECT DepDelay FROM mytable WHERE DivWheelsOffs BETWEEN 2315 AND 1208 OR DestAirportID BETWEEN 14674 AND 14006 LIMIT 23","hsqls":["SELECT DepDelay FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 2315 AND 1208 OR DivWheelsOffs[2] BETWEEN 2315 AND 1208 OR DivWheelsOffs[3] BETWEEN 2315 AND 1208 OR DivWheelsOffs[4] BETWEEN 2315 AND 1208 OR DivWheelsOffs[5] BETWEEN 2315 AND 1208) OR DestAirportID BETWEEN 14674 AND 14006 LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime, ArrTimeBlk, MIN(DivActualElapsedTime) FROM mytable WHERE CRSArrTime NOT IN (2058, 1604, 2057) GROUP BY TotalAddGTime, ArrTimeBlk  ORDER BY TotalAddGTime, ArrTimeBlk LIMIT 2","hsqls":["SELECT TotalAddGTime, ArrTimeBlk, MIN(DivActualElapsedTime) FROM mytable WHERE CRSArrTime NOT IN (2058, 1604, 2057) GROUP BY TotalAddGTime, ArrTimeBlk  ORDER BY TotalAddGTime, ArrTimeBlk LIMIT 2"]}
{"sql":"SELECT DestWac, TotalAddGTime, DivAirportSeqIDs FROM mytable WHERE ArrTime IN (1929) OR OriginCityMarketID NOT IN (35380, 35411, 31834) ORDER BY NASDelay LIMIT 27","hsqls":["SELECT DestWac, TotalAddGTime, DivAirportSeqIDs FROM mytable WHERE ArrTime IN (1929) OR OriginCityMarketID NOT IN (35380, 35411, 31834) ORDER BY NASDelay LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, AVG(OriginWac), COUNT(OriginStateName), AVG(OriginCityMarketID) FROM mytable GROUP BY SecurityDelay","hsqls":["SELECT SecurityDelay, AVG(OriginWac), COUNT(OriginStateName), AVG(OriginCityMarketID) FROM mytable GROUP BY SecurityDelay"]}
{"sql":"SELECT CarrierDelay, AirlineID, MIN(Flights), SUM(DepDelayMinutes), COUNT(DivAirportLandings) FROM mytable WHERE DestAirportSeqID BETWEEN 1484304 AND 1396403 AND \"Year\" BETWEEN 2014 AND 2014 OR DayOfWeek <= 6 GROUP BY CarrierDelay, AirlineID LIMIT 21","hsqls":["SELECT CarrierDelay, AirlineID, MIN(Flights), SUM(DepDelayMinutes), COUNT(DivAirportLandings) FROM mytable WHERE DestAirportSeqID BETWEEN 1484304 AND 1396403 AND `Year` BETWEEN 2014 AND 2014 OR DayOfWeek <= 6 GROUP BY CarrierDelay, AirlineID LIMIT 21"]}
{"sql":"SELECT TaxiOut, \"Month\" FROM mytable WHERE CarrierDelay BETWEEN 1 AND 64 ORDER BY DepDelay LIMIT 18","hsqls":["SELECT TaxiOut, `Month` FROM mytable WHERE CarrierDelay BETWEEN 1 AND 64 ORDER BY DepDelay LIMIT 18"]}
{"sql":"SELECT AirlineID FROM mytable WHERE DivAirportSeqIDs <= 1013503 AND OriginCityName >= 'Yakutat, AK' LIMIT 16","hsqls":["SELECT AirlineID FROM mytable WHERE (DivAirportSeqIDs[1] <= 1013503 OR DivAirportSeqIDs[2] <= 1013503 OR DivAirportSeqIDs[3] <= 1013503 OR DivAirportSeqIDs[4] <= 1013503 OR DivAirportSeqIDs[5] <= 1013503) AND OriginCityName >= 'Yakutat, AK' LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, DivAirportSeqIDs FROM mytable WHERE DivTotalGTimes > 77 AND DivWheelsOffs IN (1407, 1451, 921) ORDER BY DivActualElapsedTime LIMIT 3","hsqls":["SELECT DistanceGroup, DivAirportSeqIDs FROM mytable WHERE (DivTotalGTimes[1] > 77 OR DivTotalGTimes[2] > 77 OR DivTotalGTimes[3] > 77 OR DivTotalGTimes[4] > 77 OR DivTotalGTimes[5] > 77) AND (DivWheelsOffs[1] IN (1407, 1451, 921) OR DivWheelsOffs[2] IN (1407, 1451, 921) OR DivWheelsOffs[3] IN (1407, 1451, 921) OR DivWheelsOffs[4] IN (1407, 1451, 921) OR DivWheelsOffs[5] IN (1407, 1451, 921)) ORDER BY DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, Dest FROM mytable WHERE \"Year\" IN (2014) OR FirstDepTime BETWEEN 736 AND 1742 OR DivTotalGTimes BETWEEN 24 AND 109 LIMIT 1","hsqls":["SELECT DestAirportSeqID, Dest FROM mytable WHERE `Year` IN (2014) OR FirstDepTime BETWEEN 736 AND 1742 OR (DivTotalGTimes[1] BETWEEN 24 AND 109 OR DivTotalGTimes[2] BETWEEN 24 AND 109 OR DivTotalGTimes[3] BETWEEN 24 AND 109 OR DivTotalGTimes[4] BETWEEN 24 AND 109 OR DivTotalGTimes[5] BETWEEN 24 AND 109) LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, DepTimeBlk, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, DepTimeBlk  ORDER BY DestAirportSeqID, DepTimeBlk LIMIT 25","hsqls":["SELECT DestAirportSeqID, DepTimeBlk, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, DepTimeBlk  ORDER BY DestAirportSeqID, DepTimeBlk LIMIT 25"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable LIMIT 15"}
{"sql":"SELECT MAX(OriginStateFips) FROM mytable WHERE OriginWac BETWEEN 51 AND 65 AND Distance NOT IN (1995, 776, 4983, 1979, 2338) OR DepDelay IN (198.0, 388.0, 213.0, 151.0, 103.0) LIMIT 22"}
{"sql":"SELECT DestWac, Carrier, DestCityName, COUNT(*) FROM mytable WHERE ArrTime BETWEEN 51 AND 1327 AND CRSElapsedTime IN (277, 392, 157, 192, 141) AND DestAirportID IN (14113, 15249, 10721, 13264, 10713) GROUP BY DestWac, Carrier, DestCityName  ORDER BY DestWac, Carrier, DestCityName LIMIT 28","hsqls":["SELECT DestWac, Carrier, DestCityName, COUNT(*) FROM mytable WHERE ArrTime BETWEEN 51 AND 1327 AND CRSElapsedTime IN (277, 392, 157, 192, 141) AND DestAirportID IN (14113, 15249, 10721, 13264, 10713) GROUP BY DestWac, Carrier, DestCityName  ORDER BY DestWac, Carrier, DestCityName LIMIT 28"]}
{"sql":"SELECT CRSDepTime, COUNT(DepDelay), AVG(FirstDepTime), COUNT(ArrTime) FROM mytable WHERE OriginStateName > 'Louisiana' AND ArrDelay BETWEEN 43.0 AND 16.0 OR DivLongestGTimes BETWEEN 68.0 AND 66.0 GROUP BY CRSDepTime LIMIT 6","hsqls":["SELECT CRSDepTime, COUNT(DepDelay), AVG(FirstDepTime), COUNT(ArrTime) FROM mytable WHERE OriginStateName > 'Louisiana' AND ArrDelay BETWEEN 43.0 AND 16.0 OR (DivLongestGTimes[1] BETWEEN 68.0 AND 66.0 OR DivLongestGTimes[2] BETWEEN 68.0 AND 66.0 OR DivLongestGTimes[3] BETWEEN 68.0 AND 66.0 OR DivLongestGTimes[4] BETWEEN 68.0 AND 66.0 OR DivLongestGTimes[5] BETWEEN 68.0 AND 66.0) GROUP BY CRSDepTime LIMIT 10000"]}
{"sql":"SELECT DivDistance FROM mytable WHERE ArrTimeBlk BETWEEN '1200-1259' AND '0700-0759' OR Diverted BETWEEN 0 AND 0 ORDER BY TaxiIn, AirTime, DestCityMarketID LIMIT 13"}
{"sql":"SELECT DestWac, DepDelay, DepDel15, AVG(NASDelay), SUM(ArrivalDelayGroups) FROM mytable GROUP BY DestWac, DepDelay, DepDel15  ORDER BY DestWac, DepDelay, DepDel15 LIMIT 7","hsqls":["SELECT DestWac, DepDelay, DepDel15, AVG(NASDelay), SUM(ArrivalDelayGroups) FROM mytable GROUP BY DestWac, DepDelay, DepDel15  ORDER BY DestWac, DepDelay, DepDel15 LIMIT 7"]}
{"sql":"SELECT Origin FROM mytable WHERE ArrivalDelayGroups <> 2 OR DivAirportIDs IN (11953, 10208, 15389, -9999) AND DestStateFips NOT IN (49, 20, 5, 26, 28) ORDER BY LateAircraftDelay, WheelsOn, CRSElapsedTime LIMIT 12","hsqls":["SELECT Origin FROM mytable WHERE ArrivalDelayGroups <> 2 OR (DivAirportIDs[1] IN (11953, 10208, 15389, -9999) OR DivAirportIDs[2] IN (11953, 10208, 15389, -9999) OR DivAirportIDs[3] IN (11953, 10208, 15389, -9999) OR DivAirportIDs[4] IN (11953, 10208, 15389, -9999) OR DivAirportIDs[5] IN (11953, 10208, 15389, -9999)) AND DestStateFips NOT IN (49, 20, 5, 26, 28) ORDER BY LateAircraftDelay, WheelsOn, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Dest BETWEEN 'LIH' AND 'RHI' OR DivAirportIDs BETWEEN 13277 AND 14252 LIMIT 3","hsqls":["SELECT COUNT(*) FROM mytable WHERE Dest BETWEEN 'LIH' AND 'RHI' OR (DivAirportIDs[1] BETWEEN 13277 AND 14252 OR DivAirportIDs[2] BETWEEN 13277 AND 14252 OR DivAirportIDs[3] BETWEEN 13277 AND 14252 OR DivAirportIDs[4] BETWEEN 13277 AND 14252 OR DivAirportIDs[5] BETWEEN 13277 AND 14252) LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, Dest, MAX(AirlineID), MIN(CRSDepTime), AVG(FirstDepTime) FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 AND SecurityDelay BETWEEN 0 AND -9999 GROUP BY OriginStateFips, Dest LIMIT 28","hsqls":["SELECT OriginStateFips, Dest, MAX(AirlineID), MIN(CRSDepTime), AVG(FirstDepTime) FROM mytable WHERE `Month` BETWEEN 1 AND 1 AND SecurityDelay BETWEEN 0 AND -9999 GROUP BY OriginStateFips, Dest LIMIT 28"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE ArrDel15 BETWEEN 1 AND -9999 AND Quarter BETWEEN 1 AND 1 ORDER BY \"Year\" LIMIT 5","hsqls":["SELECT ArrDelayMinutes FROM mytable WHERE ArrDel15 BETWEEN 1 AND -9999 AND Quarter BETWEEN 1 AND 1 ORDER BY `Year` LIMIT 5"]}
{"sql":"SELECT SUM(DivReachedDest), MIN(TaxiOut), SUM(SecurityDelay) FROM mytable WHERE DepartureDelayGroups < 6 LIMIT 16"}
{"sql":"SELECT TaxiOut, DivLongestGTimes, DivAirportIDs FROM mytable LIMIT 28","hsqls":["SELECT TaxiOut, DivLongestGTimes, DivAirportIDs FROM mytable LIMIT 10000"]}
{"sql":"SELECT SUM(DivAirportLandings), COUNT(DestCityName), SUM(OriginStateFips) FROM mytable WHERE TailNum IN ('N562UA', 'N559JB', 'N340LV') AND DepDelayMinutes BETWEEN 203.0 AND 388.0 LIMIT 5"}
{"sql":"SELECT OriginStateFips, OriginCityName, AVG(DivDistance), COUNT(ActualElapsedTime) FROM mytable GROUP BY OriginStateFips, OriginCityName  ORDER BY OriginStateFips, OriginCityName LIMIT 28","hsqls":["SELECT OriginStateFips, OriginCityName, AVG(DivDistance), COUNT(ActualElapsedTime) FROM mytable GROUP BY OriginStateFips, OriginCityName  ORDER BY OriginStateFips, OriginCityName LIMIT 28"]}
{"sql":"SELECT DivActualElapsedTime FROM mytable WHERE ArrTimeBlk IN ('0700-0759', '2100-2159', '1200-1259', '1400-1459') ORDER BY OriginAirportSeqID, ArrDel15, Dest LIMIT 21"}
{"sql":"SELECT \"Year\", ActualElapsedTime, Cancelled FROM mytable ORDER BY Carrier, OriginCityMarketID, FlightDate LIMIT 14","hsqls":["SELECT Year, ActualElapsedTime, Cancelled FROM mytable ORDER BY Carrier, OriginCityMarketID, FlightDate LIMIT 14"]}
{"sql":"SELECT OriginState FROM mytable WHERE TailNum = 'N732US' AND DivTotalGTimes BETWEEN 102 AND 52 OR ArrTimeBlk <= '0800-0859' ORDER BY SecurityDelay, DivActualElapsedTime LIMIT 10","hsqls":["SELECT OriginState FROM mytable WHERE TailNum = 'N732US' AND (DivTotalGTimes[1] BETWEEN 102 AND 52 OR DivTotalGTimes[2] BETWEEN 102 AND 52 OR DivTotalGTimes[3] BETWEEN 102 AND 52 OR DivTotalGTimes[4] BETWEEN 102 AND 52 OR DivTotalGTimes[5] BETWEEN 102 AND 52) OR ArrTimeBlk <= '0800-0859' ORDER BY SecurityDelay, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE Flights IN (1) ORDER BY DivReachedDest, WeatherDelay, DestStateName LIMIT 22","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE Flights IN (1) ORDER BY DivReachedDest, WeatherDelay, DestStateName LIMIT 10000"]}
{"sql":"SELECT OriginCityName, OriginWac FROM mytable WHERE LongestAddGTime IN (21) ORDER BY Cancelled LIMIT 15"}
{"sql":"SELECT DestState, CancellationCode FROM mytable ORDER BY DayOfWeek LIMIT 1"}
{"sql":"SELECT DepartureDelayGroups FROM mytable ORDER BY OriginState, ArrDel15 LIMIT 20"}
{"sql":"SELECT DistanceGroup, CarrierDelay, AirTime, SUM(LateAircraftDelay), AVG(FirstDepTime) FROM mytable WHERE Dest BETWEEN 'MBS' AND 'LCH' OR DivAirportSeqIDs >= 1489302 GROUP BY DistanceGroup, CarrierDelay, AirTime LIMIT 7","hsqls":["SELECT DistanceGroup, CarrierDelay, AirTime, SUM(LateAircraftDelay), AVG(FirstDepTime) FROM mytable WHERE Dest BETWEEN 'MBS' AND 'LCH' OR (DivAirportSeqIDs[1] >= 1489302 OR DivAirportSeqIDs[2] >= 1489302 OR DivAirportSeqIDs[3] >= 1489302 OR DivAirportSeqIDs[4] >= 1489302 OR DivAirportSeqIDs[5] >= 1489302) GROUP BY DistanceGroup, CarrierDelay, AirTime LIMIT 10000"]}
{"sql":"SELECT CancellationCode, SUM(DivAirportLandings), MAX(DestStateFips), AVG(FlightNum) FROM mytable WHERE ArrDel15 <= -9999 GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 20","hsqls":["SELECT CancellationCode, SUM(DivAirportLandings), MAX(DestStateFips), AVG(FlightNum) FROM mytable WHERE ArrDel15 <= -9999 GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 20"]}
{"sql":"SELECT DepartureDelayGroups, CRSArrTime, ArrTime FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR CRSDepTime >= 2245 OR DivAirports BETWEEN 'FSD' AND 'BUF' LIMIT 18","hsqls":["SELECT DepartureDelayGroups, CRSArrTime, ArrTime FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR CRSDepTime >= 2245 OR (DivAirports[1] BETWEEN 'FSD' AND 'BUF' OR DivAirports[2] BETWEEN 'FSD' AND 'BUF' OR DivAirports[3] BETWEEN 'FSD' AND 'BUF' OR DivAirports[4] BETWEEN 'FSD' AND 'BUF' OR DivAirports[5] BETWEEN 'FSD' AND 'BUF') LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, DestState, Carrier, COUNT(\"Month\"), MIN(WeatherDelay), AVG(DepDel15) FROM mytable WHERE TaxiIn BETWEEN 8 AND 28 AND DestStateName BETWEEN 'Arizona' AND 'North Dakota' GROUP BY OriginStateFips, DestState, Carrier LIMIT 10","hsqls":["SELECT OriginStateFips, DestState, Carrier, COUNT(`Month`), MIN(WeatherDelay), AVG(DepDel15) FROM mytable WHERE TaxiIn BETWEEN 8 AND 28 AND DestStateName BETWEEN 'Arizona' AND 'North Dakota' GROUP BY OriginStateFips, DestState, Carrier LIMIT 10"]}
{"sql":"SELECT DepDelay, DestCityName, COUNT(OriginState) FROM mytable WHERE WheelsOff BETWEEN 853 AND 1126 GROUP BY DepDelay, DestCityName  ORDER BY DepDelay, DestCityName LIMIT 28","hsqls":["SELECT DepDelay, DestCityName, COUNT(OriginState) FROM mytable WHERE WheelsOff BETWEEN 853 AND 1126 GROUP BY DepDelay, DestCityName  ORDER BY DepDelay, DestCityName LIMIT 28"]}
{"sql":"SELECT ArrDel15, COUNT(CRSArrTime), AVG(DivArrDelay), COUNT(FlightDate) FROM mytable WHERE CancellationCode <> 'B' AND OriginCityName BETWEEN 'Santa Maria, CA' AND 'Tucson, AZ' OR Cancelled <= 0 GROUP BY ArrDel15","hsqls":["SELECT ArrDel15, COUNT(CRSArrTime), AVG(DivArrDelay), COUNT(FlightDate) FROM mytable WHERE CancellationCode <> 'B' AND OriginCityName BETWEEN 'Santa Maria, CA' AND 'Tucson, AZ' OR Cancelled <= 0 GROUP BY ArrDel15"]}
{"sql":"SELECT DistanceGroup, Diverted, COUNT(*) FROM mytable WHERE Diverted IN (1, 0) OR LateAircraftDelay BETWEEN 51 AND 128 GROUP BY DistanceGroup, Diverted  ORDER BY DistanceGroup, Diverted LIMIT 5","hsqls":["SELECT DistanceGroup, Diverted, COUNT(*) FROM mytable WHERE Diverted IN (1, 0) OR LateAircraftDelay BETWEEN 51 AND 128 GROUP BY DistanceGroup, Diverted  ORDER BY DistanceGroup, Diverted LIMIT 5"]}
{"sql":"SELECT Carrier, LateAircraftDelay, COUNT(*) FROM mytable GROUP BY Carrier, LateAircraftDelay  ORDER BY Carrier, LateAircraftDelay LIMIT 7","hsqls":["SELECT Carrier, LateAircraftDelay, COUNT(*) FROM mytable GROUP BY Carrier, LateAircraftDelay  ORDER BY Carrier, LateAircraftDelay LIMIT 7"]}
{"sql":"SELECT WheelsOn, COUNT(DepDel15), SUM(WheelsOff), SUM(OriginAirportID) FROM mytable WHERE DayofMonth IN (9) AND ArrTimeBlk > '1700-1759' AND DivLongestGTimes BETWEEN 18.0 AND 39.0 GROUP BY WheelsOn LIMIT 27","hsqls":["SELECT WheelsOn, COUNT(DepDel15), SUM(WheelsOff), SUM(OriginAirportID) FROM mytable WHERE DayofMonth IN (9) AND ArrTimeBlk > '1700-1759' AND (DivLongestGTimes[1] BETWEEN 18.0 AND 39.0 OR DivLongestGTimes[2] BETWEEN 18.0 AND 39.0 OR DivLongestGTimes[3] BETWEEN 18.0 AND 39.0 OR DivLongestGTimes[4] BETWEEN 18.0 AND 39.0 OR DivLongestGTimes[5] BETWEEN 18.0 AND 39.0) GROUP BY WheelsOn LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes, ArrDel15, COUNT(*) FROM mytable GROUP BY ArrDelayMinutes, ArrDel15  ORDER BY ArrDelayMinutes, ArrDel15 LIMIT 3","hsqls":["SELECT ArrDelayMinutes, ArrDel15, COUNT(*) FROM mytable GROUP BY ArrDelayMinutes, ArrDel15  ORDER BY ArrDelayMinutes, ArrDel15 LIMIT 3"]}
{"sql":"SELECT ArrDelay, \"Month\" FROM mytable WHERE CancellationCode IN ('A', 'C', 'noodles') AND OriginStateName NOT IN ('New Hampshire', 'Colorado', 'Arkansas', 'Alaska') OR DepTime < 1458 ORDER BY ArrTimeBlk, OriginStateName LIMIT 25","hsqls":["SELECT ArrDelay, `Month` FROM mytable WHERE CancellationCode IN ('A', 'C', 'noodles') AND OriginStateName NOT IN ('New Hampshire', 'Colorado', 'Arkansas', 'Alaska') OR DepTime < 1458 ORDER BY ArrTimeBlk, OriginStateName LIMIT 25"]}
{"sql":"SELECT DepDelayMinutes, AVG(Cancelled), MIN(ActualElapsedTime) FROM mytable GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 17","hsqls":["SELECT DepDelayMinutes, AVG(Cancelled), MIN(ActualElapsedTime) FROM mytable GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 17"]}
{"sql":"SELECT OriginAirportSeqID, \"Year\", ArrDel15 FROM mytable WHERE Distance BETWEEN 309 AND 1182 OR LongestAddGTime NOT IN (20, 40, 111) AND OriginAirportSeqID > 1058102 LIMIT 3","hsqls":["SELECT OriginAirportSeqID, Year, ArrDel15 FROM mytable WHERE Distance BETWEEN 309 AND 1182 OR LongestAddGTime NOT IN (20, 40, 111) AND OriginAirportSeqID > 1058102 LIMIT 3"]}
{"sql":"SELECT DistanceGroup, DestState, DivAirportIDs FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND DestAirportID NOT IN (15411) AND DivAirports IN ('JFK') LIMIT 19","hsqls":["SELECT DistanceGroup, DestState, DivAirportIDs FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND DestAirportID NOT IN (15411) AND (DivAirports[1] IN ('JFK') OR DivAirports[2] IN ('JFK') OR DivAirports[3] IN ('JFK') OR DivAirports[4] IN ('JFK') OR DivAirports[5] IN ('JFK')) LIMIT 10000"]}
{"sql":"SELECT Diverted, DestWac FROM mytable LIMIT 26"}
{"sql":"SELECT Flights FROM mytable WHERE DepDel15 <> -9999 AND DestAirportID BETWEEN 13502 AND 13830 OR DivAirports IN ('RIC', 'SRQ', 'BOS') ORDER BY Flights, TaxiIn, CRSDepTime LIMIT 3","hsqls":["SELECT Flights FROM mytable WHERE DepDel15 <> -9999 AND DestAirportID BETWEEN 13502 AND 13830 OR (DivAirports[1] IN ('RIC', 'SRQ', 'BOS') OR DivAirports[2] IN ('RIC', 'SRQ', 'BOS') OR DivAirports[3] IN ('RIC', 'SRQ', 'BOS') OR DivAirports[4] IN ('RIC', 'SRQ', 'BOS') OR DivAirports[5] IN ('RIC', 'SRQ', 'BOS')) ORDER BY Flights, TaxiIn, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, ArrDel15, DestAirportID FROM mytable WHERE FlightNum BETWEEN 1699 AND 4696 OR OriginCityName BETWEEN 'Kahului, HI' AND 'Mosinee, WI' LIMIT 17"}
{"sql":"SELECT OriginState, FlightDate, DivArrDelay FROM mytable WHERE DestStateFips > 75 OR DivActualElapsedTime IN (389, 198, 307) AND Distance > 3801 ORDER BY DepDelayMinutes LIMIT 10"}
{"sql":"SELECT MIN(OriginAirportSeqID), SUM(FirstDepTime), AVG(DivActualElapsedTime) FROM mytable WHERE AirTime BETWEEN 474 AND 295 LIMIT 9"}
{"sql":"SELECT SUM(TaxiOut), MIN(\"Month\"), SUM(SecurityDelay) FROM mytable WHERE DestWac BETWEEN 88 AND 85 AND DepDelay <> 158.0 OR DivAirportIDs BETWEEN 10136 AND 10713 LIMIT 4","hsqls":["SELECT SUM(TaxiOut), MIN(`Month`), SUM(SecurityDelay)  FROM mytable WHERE DestWac BETWEEN 88 AND 85 AND DepDelay <> 158.0 OR (DivAirportIDs[1] BETWEEN 10136 AND 10713 OR DivAirportIDs[2] BETWEEN 10136 AND 10713 OR DivAirportIDs[3] BETWEEN 10136 AND 10713 OR DivAirportIDs[4] BETWEEN 10136 AND 10713 OR DivAirportIDs[5] BETWEEN 10136 AND 10713) LIMIT 10000"]}
{"sql":"SELECT OriginState FROM mytable WHERE DivLongestGTimes IN (43.0, 42.0) ORDER BY DivReachedDest, Distance LIMIT 24","hsqls":["SELECT OriginState FROM mytable WHERE (DivLongestGTimes[1] IN (43.0, 42.0) OR DivLongestGTimes[2] IN (43.0, 42.0) OR DivLongestGTimes[3] IN (43.0, 42.0) OR DivLongestGTimes[4] IN (43.0, 42.0) OR DivLongestGTimes[5] IN (43.0, 42.0)) ORDER BY DivReachedDest, Distance LIMIT 10000"]}
{"sql":"SELECT AirTime, \"Month\", ArrivalDelayGroups FROM mytable WHERE ActualElapsedTime > 350 ORDER BY DepDelayMinutes, TotalAddGTime, TailNum LIMIT 21","hsqls":["SELECT AirTime, Month, ArrivalDelayGroups FROM mytable WHERE ActualElapsedTime > 350 ORDER BY DepDelayMinutes, TotalAddGTime, TailNum LIMIT 21"]}
{"sql":"SELECT Carrier, FlightDate, DivArrDelay, MAX(ArrDelay), AVG(DestCityMarketID), MIN(LongestAddGTime) FROM mytable WHERE FlightDate <> '2014-01-15' AND DivDistance <> 70 GROUP BY Carrier, FlightDate, DivArrDelay  ORDER BY Carrier, FlightDate, DivArrDelay LIMIT 5","hsqls":["SELECT Carrier, FlightDate, DivArrDelay, MAX(ArrDelay), AVG(DestCityMarketID), MIN(LongestAddGTime) FROM mytable WHERE FlightDate <> '2014-01-15' AND DivDistance <> 70 GROUP BY Carrier, FlightDate, DivArrDelay  ORDER BY Carrier, FlightDate, DivArrDelay LIMIT 5"]}
{"sql":"SELECT DestWac, WeatherDelay, DayOfWeek, SUM(Quarter) FROM mytable WHERE Quarter BETWEEN 1 AND 1 GROUP BY DestWac, WeatherDelay, DayOfWeek  ORDER BY DestWac, WeatherDelay, DayOfWeek LIMIT 27","hsqls":["SELECT DestWac, WeatherDelay, DayOfWeek, SUM(Quarter) FROM mytable WHERE Quarter BETWEEN 1 AND 1 GROUP BY DestWac, WeatherDelay, DayOfWeek  ORDER BY DestWac, WeatherDelay, DayOfWeek LIMIT 27"]}
{"sql":"SELECT DepDelayMinutes, DestCityName, DivWheelsOffs FROM mytable WHERE FirstDepTime >= 921 LIMIT 9","hsqls":["SELECT DepDelayMinutes, DestCityName, DivWheelsOffs FROM mytable WHERE FirstDepTime >= 921 LIMIT 10000"]}
{"sql":"SELECT AirTime FROM mytable ORDER BY DepDelayMinutes LIMIT 9"}
{"sql":"SELECT TotalAddGTime, AVG(DestStateFips), MAX(CRSDepTime), COUNT(TailNum) FROM mytable GROUP BY TotalAddGTime  ORDER BY TotalAddGTime LIMIT 3","hsqls":["SELECT TotalAddGTime, AVG(DestStateFips), MAX(CRSDepTime), COUNT(TailNum) FROM mytable GROUP BY TotalAddGTime  ORDER BY TotalAddGTime LIMIT 3"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE OriginAirportID IN (11003, 15027) LIMIT 25"}
{"sql":"SELECT DepartureDelayGroups, DestStateFips, ArrivalDelayGroups FROM mytable WHERE DivTailNums >= 'N507JB' OR LateAircraftDelay NOT IN (221, 232, 89) ORDER BY TaxiIn, DivActualElapsedTime LIMIT 17","hsqls":["SELECT DepartureDelayGroups, DestStateFips, ArrivalDelayGroups FROM mytable WHERE (DivTailNums[1] >= 'N507JB' OR DivTailNums[2] >= 'N507JB' OR DivTailNums[3] >= 'N507JB' OR DivTailNums[4] >= 'N507JB' OR DivTailNums[5] >= 'N507JB') OR LateAircraftDelay NOT IN (221, 232, 89) ORDER BY TaxiIn, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DepDelay FROM mytable WHERE \"Month\" <> 1 ORDER BY DestWac, Flights, DaysSinceEpoch LIMIT 27","hsqls":["SELECT DepDelay FROM mytable WHERE `Month` <> 1 ORDER BY DestWac, Flights, DaysSinceEpoch LIMIT 27"]}
{"sql":"SELECT OriginState FROM mytable ORDER BY DepDelay, OriginStateFips, CRSDepTime LIMIT 4"}
{"sql":"SELECT ArrTimeBlk, MAX(OriginStateFips) FROM mytable WHERE DepTimeBlk NOT IN ('1600-1659', '2200-2259', '1200-1259', '0900-0959') GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 20","hsqls":["SELECT ArrTimeBlk, MAX(OriginStateFips) FROM mytable WHERE DepTimeBlk NOT IN ('1600-1659', '2200-2259', '1200-1259', '0900-0959') GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 20"]}
{"sql":"SELECT NASDelay, DepTimeBlk, COUNT(DestCityName) FROM mytable GROUP BY NASDelay, DepTimeBlk  ORDER BY NASDelay, DepTimeBlk LIMIT 2","hsqls":["SELECT NASDelay, DepTimeBlk, COUNT(DestCityName) FROM mytable GROUP BY NASDelay, DepTimeBlk  ORDER BY NASDelay, DepTimeBlk LIMIT 2"]}
{"sql":"SELECT DepTime, CRSDepTime, WheelsOn, COUNT(SecurityDelay) FROM mytable WHERE Cancelled <= 1 OR DivReachedDest < 0 AND OriginStateFips < 27 GROUP BY DepTime, CRSDepTime, WheelsOn  ORDER BY DepTime, CRSDepTime, WheelsOn LIMIT 2","hsqls":["SELECT DepTime, CRSDepTime, WheelsOn, COUNT(SecurityDelay) FROM mytable WHERE Cancelled <= 1 OR DivReachedDest < 0 AND OriginStateFips < 27 GROUP BY DepTime, CRSDepTime, WheelsOn  ORDER BY DepTime, CRSDepTime, WheelsOn LIMIT 2"]}
{"sql":"SELECT DayOfWeek FROM mytable WHERE OriginStateName BETWEEN 'Ohio' AND 'Virginia' OR OriginCityMarketID BETWEEN 34057 AND 32016 OR CRSDepTime < 947 ORDER BY DivDistance, DepDelayMinutes, DayofMonth LIMIT 19"}
{"sql":"SELECT FirstDepTime, CRSArrTime, COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'MQ' AND 'B6' OR DestWac <= 4 OR DayOfWeek NOT IN (3, 2, 1, 7, 6) GROUP BY FirstDepTime, CRSArrTime  ORDER BY FirstDepTime, CRSArrTime LIMIT 7","hsqls":["SELECT FirstDepTime, CRSArrTime, COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'MQ' AND 'B6' OR DestWac <= 4 OR DayOfWeek NOT IN (3, 2, 1, 7, 6) GROUP BY FirstDepTime, CRSArrTime  ORDER BY FirstDepTime, CRSArrTime LIMIT 7"]}
{"sql":"SELECT WheelsOn FROM mytable ORDER BY CRSArrTime, NASDelay, OriginWac LIMIT 19"}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE TaxiIn BETWEEN 10 AND 4 OR Distance BETWEEN 378 AND 2116 LIMIT 27","hsqls":["SELECT DivWheelsOns FROM mytable WHERE TaxiIn BETWEEN 10 AND 4 OR Distance BETWEEN 378 AND 2116 LIMIT 10000"]}
{"sql":"SELECT OriginCityName, COUNT(Quarter), MIN(AirlineID), AVG(CRSArrTime) FROM mytable WHERE SecurityDelay >= 0 OR TotalAddGTime BETWEEN 128 AND 30 AND FirstDepTime IN (2009, 727, 1540, 1800) GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 16","hsqls":["SELECT OriginCityName, COUNT(Quarter), MIN(AirlineID), AVG(CRSArrTime) FROM mytable WHERE SecurityDelay >= 0 OR TotalAddGTime BETWEEN 128 AND 30 AND FirstDepTime IN (2009, 727, 1540, 1800) GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 16"]}
{"sql":"SELECT CRSArrTime, DivArrDelay FROM mytable ORDER BY AirTime, CancellationCode LIMIT 10"}
{"sql":"SELECT OriginStateFips, TotalAddGTime, AirTime FROM mytable ORDER BY Flights LIMIT 12"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Quarter > 1 LIMIT 17"}
{"sql":"SELECT Quarter, ArrTime, DivArrDelay FROM mytable ORDER BY ArrTime, DivAirportLandings LIMIT 14"}
{"sql":"SELECT DepDel15, DestStateName, CRSDepTime, SUM(DayOfWeek), MAX(OriginWac) FROM mytable WHERE LongestAddGTime >= 47 OR DivWheelsOffs <= 1605 GROUP BY DepDel15, DestStateName, CRSDepTime","hsqls":["SELECT DepDel15, DestStateName, CRSDepTime, SUM(DayOfWeek), MAX(OriginWac) FROM mytable WHERE LongestAddGTime >= 47 OR (DivWheelsOffs[1] <= 1605 OR DivWheelsOffs[2] <= 1605 OR DivWheelsOffs[3] <= 1605 OR DivWheelsOffs[4] <= 1605 OR DivWheelsOffs[5] <= 1605) GROUP BY DepDel15, DestStateName, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime, ActualElapsedTime, CRSElapsedTime FROM mytable LIMIT 24"}
{"sql":"SELECT \"Year\" FROM mytable WHERE DivLongestGTimes >= 4.0 AND DepartureDelayGroups = 2 AND TotalAddGTime < 8 ORDER BY OriginAirportSeqID, Dest, DivActualElapsedTime LIMIT 18","hsqls":["SELECT `Year` FROM mytable WHERE (DivLongestGTimes[1] >= 4.0 OR DivLongestGTimes[2] >= 4.0 OR DivLongestGTimes[3] >= 4.0 OR DivLongestGTimes[4] >= 4.0 OR DivLongestGTimes[5] >= 4.0) AND DepartureDelayGroups = 2 AND TotalAddGTime < 8 ORDER BY OriginAirportSeqID, Dest, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE CancellationCode = 'C' LIMIT 3"}
{"sql":"SELECT COUNT(OriginWac), MAX(DivAirportLandings) FROM mytable LIMIT 8"}
{"sql":"SELECT DepartureDelayGroups, DivAirports, ArrTimeBlk FROM mytable WHERE FlightNum BETWEEN 468 AND 4192 AND ArrTimeBlk NOT IN ('0800-0859', '1200-1259', '0001-0559', '1800-1859') OR DestAirportID <= 11203 ORDER BY DestState, CRSArrTime LIMIT 23","hsqls":["SELECT DepartureDelayGroups, DivAirports, ArrTimeBlk FROM mytable WHERE FlightNum BETWEEN 468 AND 4192 AND ArrTimeBlk NOT IN ('0800-0859', '1200-1259', '0001-0559', '1800-1859') OR DestAirportID <= 11203 ORDER BY DestState, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT DestState, OriginCityName, DayOfWeek, MAX(SecurityDelay) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR DepartureDelayGroups BETWEEN 6 AND 10 GROUP BY DestState, OriginCityName, DayOfWeek LIMIT 25","hsqls":["SELECT DestState, OriginCityName, DayOfWeek, MAX(SecurityDelay) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR DepartureDelayGroups BETWEEN 6 AND 10 GROUP BY DestState, OriginCityName, DayOfWeek LIMIT 25"]}
{"sql":"SELECT DestState, OriginStateFips, NASDelay, MIN(OriginAirportID), COUNT(DestWac), MIN(CRSArrTime) FROM mytable WHERE DepDel15 IN (1, 0) OR Diverted <= 0 GROUP BY DestState, OriginStateFips, NASDelay  ORDER BY DestState, OriginStateFips, NASDelay LIMIT 9","hsqls":["SELECT DestState, OriginStateFips, NASDelay, MIN(OriginAirportID), COUNT(DestWac), MIN(CRSArrTime) FROM mytable WHERE DepDel15 IN (1, 0) OR Diverted <= 0 GROUP BY DestState, OriginStateFips, NASDelay  ORDER BY DestState, OriginStateFips, NASDelay LIMIT 9"]}
{"sql":"SELECT SecurityDelay FROM mytable WHERE DaysSinceEpoch >= 16089 OR \"Month\" <> 1 ORDER BY OriginAirportSeqID, DestStateName, DepTimeBlk LIMIT 24","hsqls":["SELECT SecurityDelay FROM mytable WHERE DaysSinceEpoch >= 16089 OR `Month` <> 1 ORDER BY OriginAirportSeqID, DestStateName, DepTimeBlk LIMIT 24"]}
{"sql":"SELECT DivArrDelay, COUNT(\"Month\"), AVG(WeatherDelay) FROM mytable GROUP BY DivArrDelay LIMIT 10","hsqls":["SELECT DivArrDelay, COUNT(`Month`), AVG(WeatherDelay) FROM mytable GROUP BY DivArrDelay LIMIT 10"]}
{"sql":"SELECT WeatherDelay FROM mytable WHERE CRSDepTime BETWEEN 840 AND 945 OR CRSElapsedTime BETWEEN 570 AND 413 LIMIT 25"}
{"sql":"SELECT Cancelled, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DepDelayMinutes BETWEEN 41.0 AND 379.0 OR DestCityMarketID BETWEEN 30980 AND 31884 AND DivAirportIDs BETWEEN 11775 AND 14314 GROUP BY Cancelled, DivActualElapsedTime LIMIT 17","hsqls":["SELECT Cancelled, DivActualElapsedTime, COUNT(*) FROM mytable WHERE DepDelayMinutes BETWEEN 41.0 AND 379.0 OR DestCityMarketID BETWEEN 30980 AND 31884 AND (DivAirportIDs[1] BETWEEN 11775 AND 14314 OR DivAirportIDs[2] BETWEEN 11775 AND 14314 OR DivAirportIDs[3] BETWEEN 11775 AND 14314 OR DivAirportIDs[4] BETWEEN 11775 AND 14314 OR DivAirportIDs[5] BETWEEN 11775 AND 14314) GROUP BY Cancelled, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestStateName BETWEEN 'North Carolina' AND 'Texas' LIMIT 21"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Quarter IN (1) OR OriginAirportSeqID = 1228002 OR ArrivalDelayGroups BETWEEN 2 AND 0 LIMIT 14"}
{"sql":"SELECT DepDelayMinutes FROM mytable WHERE ArrivalDelayGroups <> 11 ORDER BY DepTime, DestStateName LIMIT 10"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 24"}
{"sql":"SELECT AirTime, ArrDelay FROM mytable WHERE TaxiOut > 79 AND Distance IN (669, 725, 312, 311) ORDER BY DistanceGroup, Quarter, ArrTime LIMIT 18"}
{"sql":"SELECT Origin FROM mytable ORDER BY ActualElapsedTime LIMIT 14"}
{"sql":"SELECT MIN(CRSDepTime), MIN(NASDelay), SUM(OriginStateFips) FROM mytable WHERE LongestAddGTime BETWEEN 30 AND 86 LIMIT 28"}
{"sql":"SELECT DestAirportID, CRSDepTime, DaysSinceEpoch, COUNT(*) FROM mytable GROUP BY DestAirportID, CRSDepTime, DaysSinceEpoch  ORDER BY DestAirportID, CRSDepTime, DaysSinceEpoch LIMIT 4","hsqls":["SELECT DestAirportID, CRSDepTime, DaysSinceEpoch, COUNT(*) FROM mytable GROUP BY DestAirportID, CRSDepTime, DaysSinceEpoch  ORDER BY DestAirportID, CRSDepTime, DaysSinceEpoch LIMIT 4"]}
{"sql":"SELECT ArrTime FROM mytable WHERE TaxiIn IN (2, 1, 9, 11) AND Origin IN ('FNT', 'CSG', 'OKC', 'CWA') ORDER BY DepDelayMinutes, DayofMonth LIMIT 14"}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DayofMonth > 19 AND DestStateName BETWEEN 'Hawaii' AND 'New York' LIMIT 29"}
{"sql":"SELECT Distance, MAX(OriginAirportSeqID), AVG(WheelsOn) FROM mytable WHERE Cancelled BETWEEN 1 AND 0 AND Carrier = 'B6' OR Quarter > 1 GROUP BY Distance  ORDER BY Distance LIMIT 24","hsqls":["SELECT Distance, MAX(OriginAirportSeqID), AVG(WheelsOn) FROM mytable WHERE Cancelled BETWEEN 1 AND 0 AND Carrier = 'B6' OR Quarter > 1 GROUP BY Distance  ORDER BY Distance LIMIT 24"]}
{"sql":"SELECT DivTotalGTimes FROM mytable LIMIT 5","hsqls":["SELECT DivTotalGTimes FROM mytable LIMIT 10000"]}
{"sql":"SELECT DestCityName FROM mytable WHERE DestStateName BETWEEN 'Maryland' AND 'Delaware' ORDER BY Carrier, DepDel15 LIMIT 10"}
{"sql":"SELECT DestCityMarketID FROM mytable ORDER BY DivReachedDest, TotalAddGTime, DestStateName LIMIT 2"}
{"sql":"SELECT TailNum, OriginWac, MAX(ArrDel15), MAX(WheelsOn) FROM mytable GROUP BY TailNum, OriginWac  ORDER BY TailNum, OriginWac LIMIT 6","hsqls":["SELECT TailNum, OriginWac, MAX(ArrDel15), MAX(WheelsOn) FROM mytable GROUP BY TailNum, OriginWac  ORDER BY TailNum, OriginWac LIMIT 6"]}
{"sql":"SELECT Origin, MAX(Quarter), SUM(DestAirportSeqID), COUNT(DepDelayMinutes) FROM mytable WHERE UniqueCarrier BETWEEN 'HA' AND 'MQ' GROUP BY Origin  ORDER BY Origin LIMIT 29","hsqls":["SELECT Origin, MAX(Quarter), SUM(DestAirportSeqID), COUNT(DepDelayMinutes) FROM mytable WHERE UniqueCarrier BETWEEN 'HA' AND 'MQ' GROUP BY Origin  ORDER BY Origin LIMIT 29"]}
{"sql":"SELECT MIN(Diverted) FROM mytable WHERE ArrDel15 <> 0 LIMIT 15"}
{"sql":"SELECT Quarter FROM mytable WHERE DepTime IN (1808, 1735) OR LateAircraftDelay <> 157 AND DivAirports = 'INL' LIMIT 2","hsqls":["SELECT Quarter FROM mytable WHERE DepTime IN (1808, 1735) OR LateAircraftDelay <> 157 AND (DivAirports[1] = 'INL' OR DivAirports[2] = 'INL' OR DivAirports[3] = 'INL' OR DivAirports[4] = 'INL' OR DivAirports[5] = 'INL') LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime FROM mytable WHERE DivAirportLandings BETWEEN 9 AND 9 ORDER BY OriginAirportSeqID, LongestAddGTime, DestAirportID LIMIT 16"}
{"sql":"SELECT MAX(NASDelay), SUM(Flights), MAX(Cancelled) FROM mytable WHERE CRSArrTime < 2352 OR ArrDel15 BETWEEN -9999 AND -9999 OR OriginAirportID BETWEEN 10785 AND 10930 LIMIT 25"}
{"sql":"SELECT DepartureDelayGroups, DayofMonth FROM mytable WHERE DepTimeBlk NOT IN ('1700-1759', '1300-1359', '2300-2359', '0900-0959', '0001-0559') OR DepartureDelayGroups BETWEEN 8 AND 10 OR LateAircraftDelay BETWEEN 75 AND 174 LIMIT 6"}
{"sql":"SELECT Distance, COUNT(*) FROM mytable WHERE DivDistance BETWEEN 1488 AND 104 GROUP BY Distance  ORDER BY Distance LIMIT 26","hsqls":["SELECT Distance, COUNT(*) FROM mytable WHERE DivDistance BETWEEN 1488 AND 104 GROUP BY Distance  ORDER BY Distance LIMIT 26"]}
{"sql":"SELECT OriginAirportSeqID, DivWheelsOns FROM mytable WHERE ArrDel15 = 1 AND AirlineID <> 20304 ORDER BY FirstDepTime, ArrTime, UniqueCarrier LIMIT 2","hsqls":["SELECT OriginAirportSeqID, DivWheelsOns FROM mytable WHERE ArrDel15 = 1 AND AirlineID <> 20304 ORDER BY FirstDepTime, ArrTime, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT Flights, TailNum FROM mytable LIMIT 24"}
{"sql":"SELECT \"Year\", SecurityDelay, AirlineID, MIN(OriginCityMarketID) FROM mytable WHERE OriginStateFips BETWEEN 33 AND 55 GROUP BY \"Year\", SecurityDelay, AirlineID LIMIT 24","hsqls":["SELECT Year, SecurityDelay, AirlineID, MIN(OriginCityMarketID) FROM mytable WHERE OriginStateFips BETWEEN 33 AND 55 GROUP BY Year, SecurityDelay, AirlineID LIMIT 24"]}
{"sql":"SELECT CRSArrTime, DaysSinceEpoch FROM mytable ORDER BY Diverted, AirlineID, DivAirportLandings LIMIT 6"}
{"sql":"SELECT DepTime, DivArrDelay FROM mytable WHERE CarrierDelay <= 243 ORDER BY TaxiOut, \"Year\", FirstDepTime LIMIT 7","hsqls":["SELECT DepTime, DivArrDelay FROM mytable WHERE CarrierDelay <= 243 ORDER BY TaxiOut, Year, FirstDepTime LIMIT 7"]}
{"sql":"SELECT DepDel15, MIN(ArrDelayMinutes), SUM(ArrDel15), AVG(FlightNum) FROM mytable WHERE DivAirportIDs IN (16101, 14492, 13487, 11603) AND DestState <> 'ND' GROUP BY DepDel15 LIMIT 8","hsqls":["SELECT DepDel15, MIN(ArrDelayMinutes), SUM(ArrDel15), AVG(FlightNum) FROM mytable WHERE (DivAirportIDs[1] IN (16101, 14492, 13487, 11603) OR DivAirportIDs[2] IN (16101, 14492, 13487, 11603) OR DivAirportIDs[3] IN (16101, 14492, 13487, 11603) OR DivAirportIDs[4] IN (16101, 14492, 13487, 11603) OR DivAirportIDs[5] IN (16101, 14492, 13487, 11603)) AND DestState <> 'ND' GROUP BY DepDel15 LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, CancellationCode FROM mytable WHERE DistanceGroup BETWEEN 10 AND 9 AND DayofMonth BETWEEN 5 AND 8 ORDER BY DivReachedDest, FlightNum LIMIT 18"}
{"sql":"SELECT OriginState, COUNT(*) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 13","hsqls":["SELECT OriginState, COUNT(*) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 13"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE OriginState <> 'SD' AND Carrier BETWEEN 'WN' AND 'UA' LIMIT 13"}
{"sql":"SELECT DivAirports, OriginCityMarketID, OriginStateName FROM mytable WHERE DestCityName > 'Akron, OH' ORDER BY DepartureDelayGroups, CRSElapsedTime LIMIT 3","hsqls":["SELECT DivAirports, OriginCityMarketID, OriginStateName FROM mytable WHERE DestCityName > 'Akron, OH' ORDER BY DepartureDelayGroups, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, TaxiIn, DivActualElapsedTime FROM mytable WHERE CRSArrTime BETWEEN 721 AND 605 ORDER BY OriginCityName LIMIT 11"}
{"sql":"SELECT ArrTimeBlk FROM mytable WHERE DivAirportSeqIDs BETWEEN 1496002 AND 1540103 AND OriginCityName IN ('Santa Barbara, CA', 'Rock Springs, WY', 'Charlottesville, VA', 'Pasco/Kennewick/Richland, WA') ORDER BY DistanceGroup, LongestAddGTime LIMIT 26","hsqls":["SELECT ArrTimeBlk FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1496002 AND 1540103 OR DivAirportSeqIDs[2] BETWEEN 1496002 AND 1540103 OR DivAirportSeqIDs[3] BETWEEN 1496002 AND 1540103 OR DivAirportSeqIDs[4] BETWEEN 1496002 AND 1540103 OR DivAirportSeqIDs[5] BETWEEN 1496002 AND 1540103) AND OriginCityName IN ('Santa Barbara, CA', 'Rock Springs, WY', 'Charlottesville, VA', 'Pasco/Kennewick/Richland, WA') ORDER BY DistanceGroup, LongestAddGTime LIMIT 10000"]}
{"sql":"SELECT OriginStateName FROM mytable LIMIT 10"}
{"sql":"SELECT OriginAirportID, MAX(TaxiIn), COUNT(DaysSinceEpoch) FROM mytable GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 8","hsqls":["SELECT OriginAirportID, MAX(TaxiIn), COUNT(DaysSinceEpoch) FROM mytable GROUP BY OriginAirportID  ORDER BY OriginAirportID LIMIT 8"]}
{"sql":"SELECT AVG(CRSDepTime), AVG(ArrDel15), MAX(DepartureDelayGroups) FROM mytable LIMIT 20"}
{"sql":"SELECT TaxiOut, OriginState, OriginStateFips FROM mytable WHERE DestState BETWEEN 'OK' AND 'OR' OR OriginAirportID NOT IN (10257, 14113, 11278, 14321, 10408) AND CancellationCode > 'B' ORDER BY FlightDate, DepTimeBlk, CRSDepTime LIMIT 11"}
{"sql":"SELECT DivReachedDest, LongestAddGTime, DepTime, AVG(DestStateFips), COUNT(OriginStateName) FROM mytable GROUP BY DivReachedDest, LongestAddGTime, DepTime  ORDER BY DivReachedDest, LongestAddGTime, DepTime LIMIT 15","hsqls":["SELECT DivReachedDest, LongestAddGTime, DepTime, AVG(DestStateFips), COUNT(OriginStateName) FROM mytable GROUP BY DivReachedDest, LongestAddGTime, DepTime  ORDER BY DivReachedDest, LongestAddGTime, DepTime LIMIT 15"]}
{"sql":"SELECT COUNT(Flights), SUM(OriginAirportID) FROM mytable WHERE DestCityMarketID < 31423 LIMIT 5"}
{"sql":"SELECT OriginStateFips, DestAirportSeqID, MAX(DepartureDelayGroups), MIN(ActualElapsedTime), COUNT(LongestAddGTime) FROM mytable WHERE CRSDepTime BETWEEN 1657 AND 1148 GROUP BY OriginStateFips, DestAirportSeqID  ORDER BY OriginStateFips, DestAirportSeqID LIMIT 15","hsqls":["SELECT OriginStateFips, DestAirportSeqID, MAX(DepartureDelayGroups), MIN(ActualElapsedTime), COUNT(LongestAddGTime) FROM mytable WHERE CRSDepTime BETWEEN 1657 AND 1148 GROUP BY OriginStateFips, DestAirportSeqID  ORDER BY OriginStateFips, DestAirportSeqID LIMIT 15"]}
{"sql":"SELECT CRSDepTime, MAX(\"Year\"), COUNT(ArrDelay) FROM mytable WHERE LongestAddGTime IN (20, 96, 58, 40, 8) GROUP BY CRSDepTime LIMIT 17","hsqls":["SELECT CRSDepTime, MAX(`Year`), COUNT(ArrDelay) FROM mytable WHERE LongestAddGTime IN (20, 96, 58, 40, 8) GROUP BY CRSDepTime LIMIT 17"]}
{"sql":"SELECT DayofMonth FROM mytable WHERE DayofMonth <> 10 AND DestAirportID BETWEEN 11617 AND 13367 AND DestCityMarketID = 32523 ORDER BY ActualElapsedTime, OriginWac LIMIT 25"}
{"sql":"SELECT TaxiOut, DivDistance, CRSArrTime FROM mytable WHERE DivAirportSeqIDs IN (1342202) OR DestCityMarketID >= 30155 LIMIT 2","hsqls":["SELECT TaxiOut, DivDistance, CRSArrTime FROM mytable WHERE (DivAirportSeqIDs[1] IN (1342202) OR DivAirportSeqIDs[2] IN (1342202) OR DivAirportSeqIDs[3] IN (1342202) OR DivAirportSeqIDs[4] IN (1342202) OR DivAirportSeqIDs[5] IN (1342202)) OR DestCityMarketID >= 30155 LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, FlightNum FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 LIMIT 8","hsqls":["SELECT LongestAddGTime, FlightNum FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 LIMIT 8"]}
{"sql":"SELECT CRSDepTime FROM mytable WHERE ArrTimeBlk <> '1000-1059' OR Carrier NOT IN ('HA', 'US', 'AS') OR ActualElapsedTime NOT IN (349, 435, 224) LIMIT 15"}
{"sql":"SELECT DivDistance, Dest FROM mytable WHERE DestCityName IN ('Wichita, KS') OR LateAircraftDelay NOT IN (159) AND DestAirportSeqID NOT IN (1468902) ORDER BY WheelsOff, Distance LIMIT 14"}
{"sql":"SELECT AVG(DestAirportSeqID), MIN(Flights), AVG(Flights) FROM mytable WHERE AirTime IN (67, 64, 281) LIMIT 3"}
{"sql":"SELECT OriginState, ArrDel15 FROM mytable ORDER BY DestCityName, DivArrDelay LIMIT 13"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 11"}
{"sql":"SELECT DistanceGroup, OriginCityMarketID, Cancelled FROM mytable WHERE Flights IN (1) OR DepDel15 <> 1 ORDER BY DistanceGroup, DivReachedDest, DepDel15 LIMIT 28"}
{"sql":"SELECT DestAirportSeqID, TailNum, OriginStateName, AVG(DestAirportSeqID), AVG(CarrierDelay) FROM mytable GROUP BY DestAirportSeqID, TailNum, OriginStateName  ORDER BY DestAirportSeqID, TailNum, OriginStateName LIMIT 13","hsqls":["SELECT DestAirportSeqID, TailNum, OriginStateName, AVG(DestAirportSeqID), AVG(CarrierDelay) FROM mytable GROUP BY DestAirportSeqID, TailNum, OriginStateName  ORDER BY DestAirportSeqID, TailNum, OriginStateName LIMIT 13"]}
{"sql":"SELECT Flights, Origin, MAX(AirTime) FROM mytable WHERE DivTotalGTimes IN (65) OR Diverted BETWEEN 0 AND 1 AND CRSDepTime NOT IN (843, 1726, 1821, 2120) GROUP BY Flights, Origin LIMIT 14","hsqls":["SELECT Flights, Origin, MAX(AirTime) FROM mytable WHERE (DivTotalGTimes[1] IN (65) OR DivTotalGTimes[2] IN (65) OR DivTotalGTimes[3] IN (65) OR DivTotalGTimes[4] IN (65) OR DivTotalGTimes[5] IN (65)) OR Diverted BETWEEN 0 AND 1 AND CRSDepTime NOT IN (843, 1726, 1821, 2120) GROUP BY Flights, Origin LIMIT 10000"]}
{"sql":"SELECT Diverted, DivAirportIDs, DivActualElapsedTime FROM mytable ORDER BY FlightDate, DepTime, ArrTimeBlk LIMIT 5","hsqls":["SELECT Diverted, DivAirportIDs, DivActualElapsedTime FROM mytable ORDER BY FlightDate, DepTime, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT FlightNum, OriginCityName, ActualElapsedTime FROM mytable WHERE OriginStateFips <= 8 OR \"Month\" BETWEEN 1 AND 1 LIMIT 18","hsqls":["SELECT FlightNum, OriginCityName, ActualElapsedTime FROM mytable WHERE OriginStateFips <= 8 OR `Month` BETWEEN 1 AND 1 LIMIT 18"]}
{"sql":"SELECT Flights, ArrDelayMinutes, ArrDel15 FROM mytable WHERE TailNum IN ('N729SW', 'N39475') OR DayOfWeek BETWEEN 7 AND 2 AND DivLongestGTimes IN (42.0, 7.0) ORDER BY UniqueCarrier LIMIT 14","hsqls":["SELECT Flights, ArrDelayMinutes, ArrDel15 FROM mytable WHERE TailNum IN ('N729SW', 'N39475') OR DayOfWeek BETWEEN 7 AND 2 AND (DivLongestGTimes[1] IN (42.0, 7.0) OR DivLongestGTimes[2] IN (42.0, 7.0) OR DivLongestGTimes[3] IN (42.0, 7.0) OR DivLongestGTimes[4] IN (42.0, 7.0) OR DivLongestGTimes[5] IN (42.0, 7.0)) ORDER BY UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, AVG(LateAircraftDelay), AVG(DivArrDelay), MIN(ArrTime) FROM mytable WHERE ArrTime NOT IN (239, 2119) GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 2","hsqls":["SELECT LongestAddGTime, AVG(LateAircraftDelay), AVG(DivArrDelay), MIN(ArrTime) FROM mytable WHERE ArrTime NOT IN (239, 2119) GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 2"]}
{"sql":"SELECT CancellationCode, ArrivalDelayGroups, MIN(Cancelled), SUM(OriginAirportSeqID) FROM mytable GROUP BY CancellationCode, ArrivalDelayGroups  ORDER BY CancellationCode, ArrivalDelayGroups LIMIT 25","hsqls":["SELECT CancellationCode, ArrivalDelayGroups, MIN(Cancelled), SUM(OriginAirportSeqID) FROM mytable GROUP BY CancellationCode, ArrivalDelayGroups  ORDER BY CancellationCode, ArrivalDelayGroups LIMIT 25"]}
{"sql":"SELECT OriginAirportSeqID, Carrier, TotalAddGTime, MAX(OriginWac), MIN(LongestAddGTime), SUM(SecurityDelay) FROM mytable WHERE Origin BETWEEN 'ROW' AND 'SAT' AND OriginState <= 'MS' GROUP BY OriginAirportSeqID, Carrier, TotalAddGTime  ORDER BY OriginAirportSeqID, Carrier, TotalAddGTime LIMIT 14","hsqls":["SELECT OriginAirportSeqID, Carrier, TotalAddGTime, MAX(OriginWac), MIN(LongestAddGTime), SUM(SecurityDelay) FROM mytable WHERE Origin BETWEEN 'ROW' AND 'SAT' AND OriginState <= 'MS' GROUP BY OriginAirportSeqID, Carrier, TotalAddGTime  ORDER BY OriginAirportSeqID, Carrier, TotalAddGTime LIMIT 14"]}
{"sql":"SELECT DivDistance FROM mytable WHERE OriginStateFips >= 38 OR \"Month\" NOT IN (1) AND WeatherDelay BETWEEN 35 AND 27 ORDER BY OriginCityMarketID LIMIT 27","hsqls":["SELECT DivDistance FROM mytable WHERE OriginStateFips >= 38 OR `Month` NOT IN (1) AND WeatherDelay BETWEEN 35 AND 27 ORDER BY OriginCityMarketID LIMIT 27"]}
{"sql":"SELECT ArrDel15, CancellationCode, CRSElapsedTime, COUNT(*) FROM mytable WHERE AirTime BETWEEN 239 AND 480 AND DepDel15 > 0 AND ArrivalDelayGroups <= 9 GROUP BY ArrDel15, CancellationCode, CRSElapsedTime  ORDER BY ArrDel15, CancellationCode, CRSElapsedTime LIMIT 11","hsqls":["SELECT ArrDel15, CancellationCode, CRSElapsedTime, COUNT(*) FROM mytable WHERE AirTime BETWEEN 239 AND 480 AND DepDel15 > 0 AND ArrivalDelayGroups <= 9 GROUP BY ArrDel15, CancellationCode, CRSElapsedTime  ORDER BY ArrDel15, CancellationCode, CRSElapsedTime LIMIT 11"]}
{"sql":"SELECT Distance, UniqueCarrier FROM mytable ORDER BY CRSDepTime, OriginAirportID LIMIT 26"}
{"sql":"SELECT ArrTimeBlk, Dest, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE Distance BETWEEN 448 AND 4502 OR OriginWac BETWEEN 43 AND 63 OR FlightNum NOT IN (1601, 2918, 1415, 2179, 110) GROUP BY ArrTimeBlk, Dest, ArrivalDelayGroups  ORDER BY ArrTimeBlk, Dest, ArrivalDelayGroups LIMIT 14","hsqls":["SELECT ArrTimeBlk, Dest, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE Distance BETWEEN 448 AND 4502 OR OriginWac BETWEEN 43 AND 63 OR FlightNum NOT IN (1601, 2918, 1415, 2179, 110) GROUP BY ArrTimeBlk, Dest, ArrivalDelayGroups  ORDER BY ArrTimeBlk, Dest, ArrivalDelayGroups LIMIT 14"]}
{"sql":"SELECT SUM(DivAirportLandings), MIN(WeatherDelay) FROM mytable WHERE Cancelled = 1 AND DestAirportID IN (12888, 12884, 14193) OR \"Year\" IN (2014) LIMIT 11","hsqls":["SELECT SUM(DivAirportLandings), MIN(WeatherDelay) FROM mytable WHERE Cancelled = 1 AND DestAirportID IN (12888, 12884, 14193) OR `Year` IN (2014) LIMIT 11"]}
{"sql":"SELECT Carrier, Dest FROM mytable LIMIT 23"}
{"sql":"SELECT Quarter, FlightNum FROM mytable WHERE DivLongestGTimes IN (30.0, 17.0) OR Diverted >= 1 AND DestAirportID >= 13502 ORDER BY DepartureDelayGroups, Dest, UniqueCarrier LIMIT 21","hsqls":["SELECT Quarter, FlightNum FROM mytable WHERE (DivLongestGTimes[1] IN (30.0, 17.0) OR DivLongestGTimes[2] IN (30.0, 17.0) OR DivLongestGTimes[3] IN (30.0, 17.0) OR DivLongestGTimes[4] IN (30.0, 17.0) OR DivLongestGTimes[5] IN (30.0, 17.0)) OR Diverted >= 1 AND DestAirportID >= 13502 ORDER BY DepartureDelayGroups, Dest, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, COUNT(FlightNum), AVG(DistanceGroup) FROM mytable WHERE AirlineID IN (20436, 20437, 19930) GROUP BY OriginAirportSeqID  ORDER BY OriginAirportSeqID LIMIT 18","hsqls":["SELECT OriginAirportSeqID, COUNT(FlightNum), AVG(DistanceGroup) FROM mytable WHERE AirlineID IN (20436, 20437, 19930) GROUP BY OriginAirportSeqID  ORDER BY OriginAirportSeqID LIMIT 18"]}
{"sql":"SELECT DivAirportLandings, SUM(DivArrDelay), MAX(ActualElapsedTime) FROM mytable WHERE LateAircraftDelay = 53 OR OriginAirportSeqID BETWEEN 1104202 AND 1160302 AND DivAirportLandings IN (1) GROUP BY DivAirportLandings  ORDER BY DivAirportLandings LIMIT 20","hsqls":["SELECT DivAirportLandings, SUM(DivArrDelay), MAX(ActualElapsedTime) FROM mytable WHERE LateAircraftDelay = 53 OR OriginAirportSeqID BETWEEN 1104202 AND 1160302 AND DivAirportLandings IN (1) GROUP BY DivAirportLandings  ORDER BY DivAirportLandings LIMIT 20"]}
{"sql":"SELECT AirlineID FROM mytable WHERE AirlineID <= 19977 OR DepTime >= 515 OR OriginAirportSeqID BETWEEN 1288403 AND 1221702 ORDER BY OriginStateFips, OriginStateName LIMIT 14"}
{"sql":"SELECT DestStateFips, TotalAddGTime, OriginAirportID, COUNT(*) FROM mytable WHERE ArrDelayMinutes < 244.0 OR \"Month\" BETWEEN 1 AND 1 GROUP BY DestStateFips, TotalAddGTime, OriginAirportID LIMIT 26","hsqls":["SELECT DestStateFips, TotalAddGTime, OriginAirportID, COUNT(*) FROM mytable WHERE ArrDelayMinutes < 244.0 OR `Month` BETWEEN 1 AND 1 GROUP BY DestStateFips, TotalAddGTime, OriginAirportID LIMIT 26"]}
{"sql":"SELECT DepDelay, TotalAddGTime, WheelsOn, MIN(DivActualElapsedTime), COUNT(CarrierDelay), MAX(DestCityMarketID) FROM mytable WHERE OriginStateName BETWEEN 'New Hampshire' AND 'Indiana' GROUP BY DepDelay, TotalAddGTime, WheelsOn  ORDER BY DepDelay, TotalAddGTime, WheelsOn LIMIT 26","hsqls":["SELECT DepDelay, TotalAddGTime, WheelsOn, MIN(DivActualElapsedTime), COUNT(CarrierDelay), MAX(DestCityMarketID) FROM mytable WHERE OriginStateName BETWEEN 'New Hampshire' AND 'Indiana' GROUP BY DepDelay, TotalAddGTime, WheelsOn  ORDER BY DepDelay, TotalAddGTime, WheelsOn LIMIT 26"]}
{"sql":"SELECT CarrierDelay FROM mytable WHERE AirTime IN (29) ORDER BY DestState, ArrDelay LIMIT 12"}
{"sql":"SELECT DivAirports FROM mytable WHERE DaysSinceEpoch BETWEEN 16093 AND 16099 ORDER BY DestState, WeatherDelay, DestCityMarketID LIMIT 11","hsqls":["SELECT DivAirports FROM mytable WHERE DaysSinceEpoch BETWEEN 16093 AND 16099 ORDER BY DestState, WeatherDelay, DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns, WheelsOn FROM mytable LIMIT 25","hsqls":["SELECT DivWheelsOns, WheelsOn FROM mytable LIMIT 10000"]}
{"sql":"SELECT DepTimeBlk, OriginStateName, COUNT(TaxiIn), COUNT(DestState) FROM mytable WHERE SecurityDelay BETWEEN 0 AND 27 GROUP BY DepTimeBlk, OriginStateName  ORDER BY DepTimeBlk, OriginStateName LIMIT 14","hsqls":["SELECT DepTimeBlk, OriginStateName, COUNT(TaxiIn), COUNT(DestState) FROM mytable WHERE SecurityDelay BETWEEN 0 AND 27 GROUP BY DepTimeBlk, OriginStateName  ORDER BY DepTimeBlk, OriginStateName LIMIT 14"]}
{"sql":"SELECT WheelsOff, DayOfWeek FROM mytable ORDER BY DestWac, ArrDelay, OriginAirportID LIMIT 8"}
{"sql":"SELECT FlightNum, Distance, DivArrDelay, MAX(Quarter), AVG(ActualElapsedTime), MAX(ActualElapsedTime) FROM mytable WHERE ArrTime NOT IN (743) GROUP BY FlightNum, Distance, DivArrDelay  ORDER BY FlightNum, Distance, DivArrDelay LIMIT 18","hsqls":["SELECT FlightNum, Distance, DivArrDelay, MAX(Quarter), AVG(ActualElapsedTime), MAX(ActualElapsedTime) FROM mytable WHERE ArrTime NOT IN (743) GROUP BY FlightNum, Distance, DivArrDelay  ORDER BY FlightNum, Distance, DivArrDelay LIMIT 18"]}
{"sql":"SELECT DivLongestGTimes, Flights FROM mytable WHERE DestCityMarketID BETWEEN 34524 AND 30155 ORDER BY DivActualElapsedTime LIMIT 27","hsqls":["SELECT DivLongestGTimes, Flights FROM mytable WHERE DestCityMarketID BETWEEN 34524 AND 30155 ORDER BY DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DestWac, DivAirportSeqIDs, CRSDepTime FROM mytable WHERE DepDelayMinutes IN (248.0, 138.0, 52.0, 39.0) ORDER BY Distance LIMIT 27","hsqls":["SELECT DestWac, DivAirportSeqIDs, CRSDepTime FROM mytable WHERE DepDelayMinutes IN (248.0, 138.0, 52.0, 39.0) ORDER BY Distance LIMIT 10000"]}
{"sql":"SELECT TaxiOut, DivAirportSeqIDs, DestCityMarketID FROM mytable WHERE DivTotalGTimes BETWEEN 50 AND 96 AND SecurityDelay = 18 ORDER BY ArrTimeBlk LIMIT 15","hsqls":["SELECT TaxiOut, DivAirportSeqIDs, DestCityMarketID FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 50 AND 96 OR DivTotalGTimes[2] BETWEEN 50 AND 96 OR DivTotalGTimes[3] BETWEEN 50 AND 96 OR DivTotalGTimes[4] BETWEEN 50 AND 96 OR DivTotalGTimes[5] BETWEEN 50 AND 96) AND SecurityDelay = 18 ORDER BY ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, Origin, DayofMonth, COUNT(Cancelled) FROM mytable GROUP BY SecurityDelay, Origin, DayofMonth  ORDER BY SecurityDelay, Origin, DayofMonth LIMIT 18","hsqls":["SELECT SecurityDelay, Origin, DayofMonth, COUNT(Cancelled) FROM mytable GROUP BY SecurityDelay, Origin, DayofMonth  ORDER BY SecurityDelay, Origin, DayofMonth LIMIT 18"]}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE NASDelay BETWEEN 133 AND 15 LIMIT 9"}
{"sql":"SELECT FlightNum, Cancelled, COUNT(*) FROM mytable GROUP BY FlightNum, Cancelled  ORDER BY FlightNum, Cancelled LIMIT 4","hsqls":["SELECT FlightNum, Cancelled, COUNT(*) FROM mytable GROUP BY FlightNum, Cancelled  ORDER BY FlightNum, Cancelled LIMIT 4"]}
{"sql":"SELECT DestState, DepDelayMinutes, ArrTimeBlk FROM mytable ORDER BY SecurityDelay, AirlineID LIMIT 10"}
{"sql":"SELECT FlightDate, ArrTimeBlk, DestCityName, MIN(CRSDepTime), MAX(FlightNum) FROM mytable WHERE CRSElapsedTime < 294 AND DestAirportSeqID NOT IN (1385103, 1334205) GROUP BY FlightDate, ArrTimeBlk, DestCityName  ORDER BY FlightDate, ArrTimeBlk, DestCityName LIMIT 5","hsqls":["SELECT FlightDate, ArrTimeBlk, DestCityName, MIN(CRSDepTime), MAX(FlightNum) FROM mytable WHERE CRSElapsedTime < 294 AND DestAirportSeqID NOT IN (1385103, 1334205) GROUP BY FlightDate, ArrTimeBlk, DestCityName  ORDER BY FlightDate, ArrTimeBlk, DestCityName LIMIT 5"]}
{"sql":"SELECT Quarter, COUNT(*) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 1","hsqls":["SELECT Quarter, COUNT(*) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 1"]}
{"sql":"SELECT \"Year\", OriginCityName FROM mytable WHERE TailNum <> 'N551AS' AND OriginWac BETWEEN 33 AND 14 OR TotalAddGTime < 21 ORDER BY DestStateFips, DayOfWeek LIMIT 14","hsqls":["SELECT Year, OriginCityName FROM mytable WHERE TailNum <> 'N551AS' AND OriginWac BETWEEN 33 AND 14 OR TotalAddGTime < 21 ORDER BY DestStateFips, DayOfWeek LIMIT 14"]}
{"sql":"SELECT \"Year\", FirstDepTime, DestAirportSeqID FROM mytable ORDER BY OriginStateFips, OriginStateName LIMIT 14","hsqls":["SELECT Year, FirstDepTime, DestAirportSeqID FROM mytable ORDER BY OriginStateFips, OriginStateName LIMIT 14"]}
{"sql":"SELECT MIN(Quarter) FROM mytable WHERE OriginCityName BETWEEN 'Sacramento, CA' AND 'Laramie, WY' OR DepDelay IN (20.0, 25.0) OR LongestAddGTime BETWEEN 128 AND 51"}
{"sql":"SELECT NASDelay, MAX(WheelsOff), COUNT(DepTimeBlk) FROM mytable WHERE TaxiIn <= 39 AND ArrDel15 = 0 OR TaxiOut NOT IN (21, 15, 39) GROUP BY NASDelay  ORDER BY NASDelay LIMIT 15","hsqls":["SELECT NASDelay, MAX(WheelsOff), COUNT(DepTimeBlk) FROM mytable WHERE TaxiIn <= 39 AND ArrDel15 = 0 OR TaxiOut NOT IN (21, 15, 39) GROUP BY NASDelay  ORDER BY NASDelay LIMIT 15"]}
{"sql":"SELECT WeatherDelay, FlightDate FROM mytable WHERE DayofMonth <= 11 LIMIT 10"}
{"sql":"SELECT WheelsOff, DivTailNums FROM mytable WHERE CarrierDelay NOT IN (89) AND Dest NOT IN ('HDN', 'SBA', 'ELP') LIMIT 26","hsqls":["SELECT WheelsOff, DivTailNums FROM mytable WHERE CarrierDelay NOT IN (89) AND Dest NOT IN ('HDN', 'SBA', 'ELP') LIMIT 10000"]}
{"sql":"SELECT DestWac, CRSArrTime, OriginAirportID, COUNT(DepTimeBlk), AVG(TaxiIn) FROM mytable WHERE DestCityName < 'Peoria, IL' AND DepDelayMinutes NOT IN (129.0, 293.0, 162.0, 163.0) GROUP BY DestWac, CRSArrTime, OriginAirportID  ORDER BY DestWac, CRSArrTime, OriginAirportID LIMIT 1","hsqls":["SELECT DestWac, CRSArrTime, OriginAirportID, COUNT(DepTimeBlk), AVG(TaxiIn) FROM mytable WHERE DestCityName < 'Peoria, IL' AND DepDelayMinutes NOT IN (129.0, 293.0, 162.0, 163.0) GROUP BY DestWac, CRSArrTime, OriginAirportID  ORDER BY DestWac, CRSArrTime, OriginAirportID LIMIT 1"]}
{"sql":"SELECT ArrDel15, MIN(DestAirportSeqID), COUNT(Distance) FROM mytable GROUP BY ArrDel15  ORDER BY ArrDel15 LIMIT 7","hsqls":["SELECT ArrDel15, MIN(DestAirportSeqID), COUNT(Distance) FROM mytable GROUP BY ArrDel15  ORDER BY ArrDel15 LIMIT 7"]}
{"sql":"SELECT DestCityMarketID, CRSElapsedTime, AVG(WheelsOn) FROM mytable WHERE DivWheelsOns BETWEEN 634 AND 1310 OR Cancelled NOT IN (1, 0) AND OriginAirportSeqID >= 1163703 GROUP BY DestCityMarketID, CRSElapsedTime LIMIT 28","hsqls":["SELECT DestCityMarketID, CRSElapsedTime, AVG(CAST(WheelsOn AS DOUBLE)) FROM mytable WHERE (DivWheelsOns[1] BETWEEN 634 AND 1310 OR DivWheelsOns[2] BETWEEN 634 AND 1310 OR DivWheelsOns[3] BETWEEN 634 AND 1310 OR DivWheelsOns[4] BETWEEN 634 AND 1310 OR DivWheelsOns[5] BETWEEN 634 AND 1310) OR Cancelled NOT IN (1, 0) AND OriginAirportSeqID >= 1163703 GROUP BY DestCityMarketID, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT SUM(DivArrDelay), SUM(DestStateFips) FROM mytable WHERE DivTailNums IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA') AND DestAirportID < 11867 OR Carrier NOT IN ('DL', 'WN') LIMIT 20","hsqls":["SELECT SUM(DivArrDelay), SUM(DestStateFips)  FROM mytable WHERE (DivTailNums[1] IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA') OR DivTailNums[2] IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA') OR DivTailNums[3] IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA') OR DivTailNums[4] IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA') OR DivTailNums[5] IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA')) AND DestAirportID < 11867 OR Carrier NOT IN ('DL', 'WN') LIMIT 10000"]}
{"sql":"SELECT OriginWac, DayOfWeek, MAX(DestAirportID), MAX(CarrierDelay) FROM mytable GROUP BY OriginWac, DayOfWeek  ORDER BY OriginWac, DayOfWeek LIMIT 16","hsqls":["SELECT OriginWac, DayOfWeek, MAX(DestAirportID), MAX(CarrierDelay) FROM mytable GROUP BY OriginWac, DayOfWeek  ORDER BY OriginWac, DayOfWeek LIMIT 16"]}
{"sql":"SELECT FlightDate, ArrTime, CRSElapsedTime, MAX(WheelsOn), AVG(TaxiOut), COUNT(WeatherDelay) FROM mytable GROUP BY FlightDate, ArrTime, CRSElapsedTime  ORDER BY FlightDate, ArrTime, CRSElapsedTime LIMIT 16","hsqls":["SELECT FlightDate, ArrTime, CRSElapsedTime, MAX(WheelsOn), AVG(TaxiOut), COUNT(WeatherDelay) FROM mytable GROUP BY FlightDate, ArrTime, CRSElapsedTime  ORDER BY FlightDate, ArrTime, CRSElapsedTime LIMIT 16"]}
{"sql":"SELECT Quarter, FlightDate, DivAirportLandings FROM mytable WHERE ArrTimeBlk >= '1900-1959' LIMIT 17"}
{"sql":"SELECT CRSArrTime FROM mytable ORDER BY DestWac, Flights, AirTime LIMIT 13"}
{"sql":"SELECT DestState, OriginStateFips, CarrierDelay, MAX(DistanceGroup) FROM mytable WHERE DivWheelsOns BETWEEN 1825 AND 858 AND OriginStateFips IN (42, 51, 8) GROUP BY DestState, OriginStateFips, CarrierDelay LIMIT 3","hsqls":["SELECT DestState, OriginStateFips, CarrierDelay, MAX(DistanceGroup) FROM mytable WHERE (DivWheelsOns[1] BETWEEN 1825 AND 858 OR DivWheelsOns[2] BETWEEN 1825 AND 858 OR DivWheelsOns[3] BETWEEN 1825 AND 858 OR DivWheelsOns[4] BETWEEN 1825 AND 858 OR DivWheelsOns[5] BETWEEN 1825 AND 858) AND OriginStateFips IN (42, 51, 8) GROUP BY DestState, OriginStateFips, CarrierDelay LIMIT 10000"]}
{"sql":"SELECT DivAirportSeqIDs FROM mytable WHERE DivLongestGTimes BETWEEN 17.0 AND 112.0 OR OriginState IN ('OH') ORDER BY Quarter LIMIT 25","hsqls":["SELECT DivAirportSeqIDs FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 17.0 AND 112.0 OR DivLongestGTimes[2] BETWEEN 17.0 AND 112.0 OR DivLongestGTimes[3] BETWEEN 17.0 AND 112.0 OR DivLongestGTimes[4] BETWEEN 17.0 AND 112.0 OR DivLongestGTimes[5] BETWEEN 17.0 AND 112.0) OR OriginState IN ('OH') ORDER BY Quarter LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, TotalAddGTime, DaysSinceEpoch, COUNT(*) FROM mytable WHERE CRSArrTime BETWEEN 1252 AND 706 OR Diverted IN (1, 0) GROUP BY CarrierDelay, TotalAddGTime, DaysSinceEpoch  ORDER BY CarrierDelay, TotalAddGTime, DaysSinceEpoch LIMIT 21","hsqls":["SELECT CarrierDelay, TotalAddGTime, DaysSinceEpoch, COUNT(*) FROM mytable WHERE CRSArrTime BETWEEN 1252 AND 706 OR Diverted IN (1, 0) GROUP BY CarrierDelay, TotalAddGTime, DaysSinceEpoch  ORDER BY CarrierDelay, TotalAddGTime, DaysSinceEpoch LIMIT 21"]}
{"sql":"SELECT TaxiIn, ArrivalDelayGroups, CRSElapsedTime FROM mytable ORDER BY DestAirportSeqID, CancellationCode LIMIT 13"}
{"sql":"SELECT FlightDate, DayofMonth, COUNT(*) FROM mytable WHERE DayOfWeek BETWEEN 4 AND 7 OR DepTimeBlk >= '2300-2359' AND OriginStateFips BETWEEN 26 AND 47 GROUP BY FlightDate, DayofMonth  ORDER BY FlightDate, DayofMonth LIMIT 10","hsqls":["SELECT FlightDate, DayofMonth, COUNT(*) FROM mytable WHERE DayOfWeek BETWEEN 4 AND 7 OR DepTimeBlk >= '2300-2359' AND OriginStateFips BETWEEN 26 AND 47 GROUP BY FlightDate, DayofMonth  ORDER BY FlightDate, DayofMonth LIMIT 10"]}
{"sql":"SELECT ArrDelay, SUM(DivDistance) FROM mytable WHERE Quarter IN (1) AND CRSArrTime BETWEEN 2251 AND 1500 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 8","hsqls":["SELECT ArrDelay, SUM(DivDistance) FROM mytable WHERE Quarter IN (1) AND CRSArrTime BETWEEN 2251 AND 1500 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 8"]}
{"sql":"SELECT DepDel15, COUNT(DestWac) FROM mytable WHERE \"Month\" <= 1 OR DivLongestGTimes IN (23.0, 49.0, 36.0) AND CRSDepTime NOT IN (1422) GROUP BY DepDel15 LIMIT 10","hsqls":["SELECT DepDel15, COUNT(DestWac) FROM mytable WHERE `Month` <= 1 OR (DivLongestGTimes[1] IN (23.0, 49.0, 36.0) OR DivLongestGTimes[2] IN (23.0, 49.0, 36.0) OR DivLongestGTimes[3] IN (23.0, 49.0, 36.0) OR DivLongestGTimes[4] IN (23.0, 49.0, 36.0) OR DivLongestGTimes[5] IN (23.0, 49.0, 36.0)) AND CRSDepTime NOT IN (1422) GROUP BY DepDel15 LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE OriginStateFips >= 75 AND FlightDate NOT IN ('2014-01-22') OR DestState BETWEEN 'SC' AND 'AR' ORDER BY DestState, ArrDelay, CRSDepTime LIMIT 19"}
{"sql":"SELECT DivTailNums FROM mytable WHERE CancellationCode NOT IN ('B', 'noodles') ORDER BY DepartureDelayGroups, DepDel15, CRSDepTime LIMIT 1","hsqls":["SELECT DivTailNums FROM mytable WHERE CancellationCode NOT IN ('B', 'noodles') ORDER BY DepartureDelayGroups, DepDel15, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT DivReachedDest FROM mytable WHERE CarrierDelay BETWEEN 280 AND 201 AND UniqueCarrier NOT IN ('DL', 'EV', 'FL', 'UA', 'AA') AND DivDistance >= 1138 ORDER BY WheelsOff, AirlineID LIMIT 15"}
{"sql":"SELECT OriginCityMarketID FROM mytable ORDER BY TotalAddGTime LIMIT 14"}
{"sql":"SELECT \"Year\", COUNT(OriginAirportID), MAX(ArrDelayMinutes) FROM mytable WHERE LateAircraftDelay NOT IN (174, 167) OR Quarter >= 1 GROUP BY \"Year\" LIMIT 18","hsqls":["SELECT Year, COUNT(OriginAirportID), MAX(ArrDelayMinutes) FROM mytable WHERE LateAircraftDelay NOT IN (174, 167) OR Quarter >= 1 GROUP BY `Year` LIMIT 18"]}
{"sql":"SELECT MAX(DayOfWeek) FROM mytable WHERE DivAirportLandings > 2 OR OriginWac NOT IN (2, 5, 82, 73, 84) LIMIT 27"}
{"sql":"SELECT SUM(ArrDel15), COUNT(ActualElapsedTime), AVG(ArrDelay) FROM mytable WHERE DivAirportLandings <= 1 AND OriginWac <> 1 LIMIT 24"}
{"sql":"SELECT Origin, DivActualElapsedTime, COUNT(Flights), MIN(DivReachedDest), MIN(LongestAddGTime) FROM mytable WHERE DivTailNums > 'N530US' GROUP BY Origin, DivActualElapsedTime LIMIT 12","hsqls":["SELECT Origin, DivActualElapsedTime, COUNT(Flights), MIN(DivReachedDest), MIN(LongestAddGTime) FROM mytable WHERE (DivTailNums[1] > 'N530US' OR DivTailNums[2] > 'N530US' OR DivTailNums[3] > 'N530US' OR DivTailNums[4] > 'N530US' OR DivTailNums[5] > 'N530US') GROUP BY Origin, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT DivAirportSeqIDs, DivActualElapsedTime FROM mytable WHERE TaxiIn BETWEEN 83 AND 40 OR LongestAddGTime BETWEEN 24 AND 63 ORDER BY FirstDepTime, Flights, DepTimeBlk LIMIT 1","hsqls":["SELECT DivAirportSeqIDs, DivActualElapsedTime FROM mytable WHERE TaxiIn BETWEEN 83 AND 40 OR LongestAddGTime BETWEEN 24 AND 63 ORDER BY FirstDepTime, Flights, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT DestState, DepTime, DivActualElapsedTime FROM mytable WHERE DivTailNums IN ('N228PQ', 'N882AS', 'N873AS', 'N4YGAA', 'N8307K') AND CRSDepTime BETWEEN 1754 AND 755 AND Dest BETWEEN 'MTJ' AND 'SGU' ORDER BY DestState, FlightDate, DepTime LIMIT 26","hsqls":["SELECT DestState, DepTime, DivActualElapsedTime FROM mytable WHERE (DivTailNums[1] IN ('N228PQ', 'N882AS', 'N873AS', 'N4YGAA', 'N8307K') OR DivTailNums[2] IN ('N228PQ', 'N882AS', 'N873AS', 'N4YGAA', 'N8307K') OR DivTailNums[3] IN ('N228PQ', 'N882AS', 'N873AS', 'N4YGAA', 'N8307K') OR DivTailNums[4] IN ('N228PQ', 'N882AS', 'N873AS', 'N4YGAA', 'N8307K') OR DivTailNums[5] IN ('N228PQ', 'N882AS', 'N873AS', 'N4YGAA', 'N8307K')) AND CRSDepTime BETWEEN 1754 AND 755 AND Dest BETWEEN 'MTJ' AND 'SGU' ORDER BY DestState, FlightDate, DepTime LIMIT 10000"]}
{"sql":"SELECT AVG(DaysSinceEpoch) FROM mytable WHERE DivAirportIDs > 14027 AND DivLongestGTimes >= 61.0 AND Cancelled BETWEEN 0 AND 1 LIMIT 3","hsqls":["SELECT AVG(CAST(DaysSinceEpoch AS DOUBLE)) FROM mytable WHERE (DivAirportIDs[1] > 14027 OR DivAirportIDs[2] > 14027 OR DivAirportIDs[3] > 14027 OR DivAirportIDs[4] > 14027 OR DivAirportIDs[5] > 14027) AND (DivLongestGTimes[1] >= 61.0 OR DivLongestGTimes[2] >= 61.0 OR DivLongestGTimes[3] >= 61.0 OR DivLongestGTimes[4] >= 61.0 OR DivLongestGTimes[5] >= 61.0) AND Cancelled BETWEEN 0 AND 1 LIMIT 10000"]}
{"sql":"SELECT MAX(DaysSinceEpoch) FROM mytable WHERE NASDelay IN (79, 50) LIMIT 26"}
{"sql":"SELECT Distance, SecurityDelay, OriginCityName FROM mytable WHERE OriginCityName BETWEEN 'Long Beach, CA' AND 'Cody, WY' AND DestCityMarketID > 30113 LIMIT 26"}
{"sql":"SELECT ActualElapsedTime, DivTailNums, DestStateName FROM mytable WHERE DivActualElapsedTime <= 1331 AND DivArrDelay BETWEEN 164 AND 257 AND DivWheelsOns = 1841 LIMIT 26","hsqls":["SELECT ActualElapsedTime, DivTailNums, DestStateName FROM mytable WHERE DivActualElapsedTime <= 1331 AND DivArrDelay BETWEEN 164 AND 257 AND (DivWheelsOns[1] = 1841 OR DivWheelsOns[2] = 1841 OR DivWheelsOns[3] = 1841 OR DivWheelsOns[4] = 1841 OR DivWheelsOns[5] = 1841) LIMIT 10000"]}
{"sql":"SELECT \"Year\", DepDelayMinutes, ActualElapsedTime FROM mytable WHERE DivArrDelay IN (531, 153, 332, 65, 29) AND DivAirportIDs < 11630 AND DivTotalGTimes IN (96, 33, 27) ORDER BY FirstDepTime LIMIT 27","hsqls":["SELECT Year, DepDelayMinutes, ActualElapsedTime FROM mytable WHERE DivArrDelay IN (531, 153, 332, 65, 29) AND (DivAirportIDs[1] < 11630 OR DivAirportIDs[2] < 11630 OR DivAirportIDs[3] < 11630 OR DivAirportIDs[4] < 11630 OR DivAirportIDs[5] < 11630) AND (DivTotalGTimes[1] IN (96, 33, 27) OR DivTotalGTimes[2] IN (96, 33, 27) OR DivTotalGTimes[3] IN (96, 33, 27) OR DivTotalGTimes[4] IN (96, 33, 27) OR DivTotalGTimes[5] IN (96, 33, 27)) ORDER BY FirstDepTime LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, DivArrDelay, SUM(DivAirportLandings), AVG(FlightNum), COUNT(DestCityMarketID) FROM mytable WHERE DestState < 'CA' AND FlightDate IN ('2014-01-12', '2014-01-22', '2014-01-18', '2014-01-11', '2014-01-25') AND LateAircraftDelay < 78 GROUP BY SecurityDelay, DivArrDelay  ORDER BY SecurityDelay, DivArrDelay LIMIT 22","hsqls":["SELECT SecurityDelay, DivArrDelay, SUM(DivAirportLandings), AVG(FlightNum), COUNT(DestCityMarketID) FROM mytable WHERE DestState < 'CA' AND FlightDate IN ('2014-01-12', '2014-01-22', '2014-01-18', '2014-01-11', '2014-01-25') AND LateAircraftDelay < 78 GROUP BY SecurityDelay, DivArrDelay  ORDER BY SecurityDelay, DivArrDelay LIMIT 22"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable WHERE DivAirportSeqIDs = 1319801 ORDER BY FlightNum, OriginCityName LIMIT 28","hsqls":["SELECT DepartureDelayGroups FROM mytable WHERE (DivAirportSeqIDs[1] = 1319801 OR DivAirportSeqIDs[2] = 1319801 OR DivAirportSeqIDs[3] = 1319801 OR DivAirportSeqIDs[4] = 1319801 OR DivAirportSeqIDs[5] = 1319801) ORDER BY FlightNum, OriginCityName LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes, ActualElapsedTime, DayOfWeek, AVG(ArrDelay) FROM mytable WHERE DistanceGroup BETWEEN 6 AND 6 OR DestWac BETWEEN 73 AND 72 OR DivDistance BETWEEN 862 AND 270 GROUP BY ArrDelayMinutes, ActualElapsedTime, DayOfWeek  ORDER BY ArrDelayMinutes, ActualElapsedTime, DayOfWeek LIMIT 9","hsqls":["SELECT ArrDelayMinutes, ActualElapsedTime, DayOfWeek, AVG(ArrDelay) FROM mytable WHERE DistanceGroup BETWEEN 6 AND 6 OR DestWac BETWEEN 73 AND 72 OR DivDistance BETWEEN 862 AND 270 GROUP BY ArrDelayMinutes, ActualElapsedTime, DayOfWeek  ORDER BY ArrDelayMinutes, ActualElapsedTime, DayOfWeek LIMIT 9"]}
{"sql":"SELECT DistanceGroup, ActualElapsedTime FROM mytable WHERE OriginCityMarketID = 31337 AND ActualElapsedTime NOT IN (98, 388, 52) ORDER BY OriginCityMarketID, DestStateFips LIMIT 4"}
{"sql":"SELECT OriginStateName FROM mytable ORDER BY TaxiIn LIMIT 7"}
{"sql":"SELECT DayofMonth FROM mytable WHERE FlightNum BETWEEN 139 AND 860 AND OriginAirportSeqID IN (1018502, 1014002, 1127802)"}
{"sql":"SELECT DivReachedDest, SecurityDelay, ActualElapsedTime, SUM(NASDelay), MAX(DestAirportID), MAX(WheelsOn) FROM mytable WHERE DestAirportID BETWEEN 10170 AND 14256 AND Cancelled = 1 GROUP BY DivReachedDest, SecurityDelay, ActualElapsedTime  ORDER BY DivReachedDest, SecurityDelay, ActualElapsedTime LIMIT 3","hsqls":["SELECT DivReachedDest, SecurityDelay, ActualElapsedTime, SUM(NASDelay), MAX(DestAirportID), MAX(WheelsOn) FROM mytable WHERE DestAirportID BETWEEN 10170 AND 14256 AND Cancelled = 1 GROUP BY DivReachedDest, SecurityDelay, ActualElapsedTime  ORDER BY DivReachedDest, SecurityDelay, ActualElapsedTime LIMIT 3"]}
{"sql":"SELECT ArrDelayMinutes, \"Month\", MAX(DepDelayMinutes) FROM mytable WHERE DayOfWeek BETWEEN 4 AND 6 OR DivWheelsOffs >= 1115 AND Origin > 'SAT' GROUP BY ArrDelayMinutes, \"Month\" LIMIT 19","hsqls":["SELECT ArrDelayMinutes, Month, MAX(DepDelayMinutes) FROM mytable WHERE DayOfWeek BETWEEN 4 AND 6 OR (DivWheelsOffs[1] >= 1115 OR DivWheelsOffs[2] >= 1115 OR DivWheelsOffs[3] >= 1115 OR DivWheelsOffs[4] >= 1115 OR DivWheelsOffs[5] >= 1115) AND Origin > 'SAT' GROUP BY ArrDelayMinutes, `Month` LIMIT 10000"]}
{"sql":"SELECT FlightNum, DepDel15, COUNT(*) FROM mytable WHERE CRSArrTime BETWEEN 1516 AND 1701 AND DepDelayMinutes <> 235.0 GROUP BY FlightNum, DepDel15  ORDER BY FlightNum, DepDel15 LIMIT 23","hsqls":["SELECT FlightNum, DepDel15, COUNT(*) FROM mytable WHERE CRSArrTime BETWEEN 1516 AND 1701 AND DepDelayMinutes <> 235.0 GROUP BY FlightNum, DepDel15  ORDER BY FlightNum, DepDel15 LIMIT 23"]}
{"sql":"SELECT OriginCityMarketID, DivTailNums, DestCityMarketID FROM mytable WHERE DestCityMarketID BETWEEN 30894 AND 34489 OR DaysSinceEpoch = 16079 OR DivArrDelay BETWEEN 135 AND 110 LIMIT 9","hsqls":["SELECT OriginCityMarketID, DivTailNums, DestCityMarketID FROM mytable WHERE DestCityMarketID BETWEEN 30894 AND 34489 OR DaysSinceEpoch = 16079 OR DivArrDelay BETWEEN 135 AND 110 LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, LongestAddGTime, SUM(DistanceGroup) FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 OR DepTime >= 1205 GROUP BY DepartureDelayGroups, LongestAddGTime LIMIT 21","hsqls":["SELECT DepartureDelayGroups, LongestAddGTime, SUM(DistanceGroup) FROM mytable WHERE `Month` BETWEEN 1 AND 1 OR DepTime >= 1205 GROUP BY DepartureDelayGroups, LongestAddGTime LIMIT 21"]}
{"sql":"SELECT MIN(\"Year\"), MAX(ArrivalDelayGroups) FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259', '1200-1259', '0001-0559', '1400-1459', '1800-1859') LIMIT 1","hsqls":["SELECT MIN(`Year`), MAX(ArrivalDelayGroups) FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259', '1200-1259', '0001-0559', '1400-1459', '1800-1859') LIMIT 1"]}
{"sql":"SELECT DepTime, ArrDelayMinutes, COUNT(*) FROM mytable WHERE OriginStateName BETWEEN 'Rhode Island' AND 'Massachusetts' AND DivWheelsOffs IN (2354, 1403, 1543, 2313, 921) GROUP BY DepTime, ArrDelayMinutes LIMIT 4","hsqls":["SELECT DepTime, ArrDelayMinutes, COUNT(*) FROM mytable WHERE OriginStateName BETWEEN 'Rhode Island' AND 'Massachusetts' AND (DivWheelsOffs[1] IN (2354, 1403, 1543, 2313, 921) OR DivWheelsOffs[2] IN (2354, 1403, 1543, 2313, 921) OR DivWheelsOffs[3] IN (2354, 1403, 1543, 2313, 921) OR DivWheelsOffs[4] IN (2354, 1403, 1543, 2313, 921) OR DivWheelsOffs[5] IN (2354, 1403, 1543, 2313, 921)) GROUP BY DepTime, ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime FROM mytable WHERE OriginCityMarketID NOT IN (31637) AND CRSDepTime IN (2351, 1038) AND AirTime >= 380 LIMIT 26"}
{"sql":"SELECT WeatherDelay, CancellationCode, DivArrDelay, SUM(ArrDel15), MIN(DepDelay) FROM mytable GROUP BY WeatherDelay, CancellationCode, DivArrDelay  ORDER BY WeatherDelay, CancellationCode, DivArrDelay LIMIT 23","hsqls":["SELECT WeatherDelay, CancellationCode, DivArrDelay, SUM(ArrDel15), MIN(DepDelay) FROM mytable GROUP BY WeatherDelay, CancellationCode, DivArrDelay  ORDER BY WeatherDelay, CancellationCode, DivArrDelay LIMIT 23"]}
{"sql":"SELECT CRSArrTime, WeatherDelay, AirlineID FROM mytable LIMIT 6"}
{"sql":"SELECT DepTimeBlk, \"Month\" FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 ORDER BY DestStateName LIMIT 20","hsqls":["SELECT DepTimeBlk, `Month` FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 ORDER BY DestStateName LIMIT 20"]}
{"sql":"SELECT FirstDepTime, ArrDelayMinutes FROM mytable ORDER BY DestAirportSeqID, TailNum LIMIT 3"}
{"sql":"SELECT DivDistance, DestCityMarketID, UniqueCarrier FROM mytable WHERE DivAirports IN ('OGD', 'LMT', 'LGA') AND DepDelayMinutes BETWEEN 51.0 AND 356.0 LIMIT 24","hsqls":["SELECT DivDistance, DestCityMarketID, UniqueCarrier FROM mytable WHERE (DivAirports[1] IN ('OGD', 'LMT', 'LGA') OR DivAirports[2] IN ('OGD', 'LMT', 'LGA') OR DivAirports[3] IN ('OGD', 'LMT', 'LGA') OR DivAirports[4] IN ('OGD', 'LMT', 'LGA') OR DivAirports[5] IN ('OGD', 'LMT', 'LGA')) AND DepDelayMinutes BETWEEN 51.0 AND 356.0 LIMIT 10000"]}
{"sql":"SELECT DestStateFips FROM mytable WHERE Dest = 'FSM' LIMIT 9"}
{"sql":"SELECT FlightDate, DestStateName, DayofMonth FROM mytable LIMIT 21"}
{"sql":"SELECT ArrivalDelayGroups, COUNT(ActualElapsedTime), AVG(WheelsOn) FROM mytable WHERE SecurityDelay IN (8) OR DivTotalGTimes IN (20, 107) AND DestAirportSeqID BETWEEN 1312702 AND 1200302 GROUP BY ArrivalDelayGroups LIMIT 26","hsqls":["SELECT ArrivalDelayGroups, COUNT(ActualElapsedTime), AVG(WheelsOn) FROM mytable WHERE SecurityDelay IN (8) OR (DivTotalGTimes[1] IN (20, 107) OR DivTotalGTimes[2] IN (20, 107) OR DivTotalGTimes[3] IN (20, 107) OR DivTotalGTimes[4] IN (20, 107) OR DivTotalGTimes[5] IN (20, 107)) AND DestAirportSeqID BETWEEN 1312702 AND 1200302 GROUP BY ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT MIN(DivReachedDest), COUNT(UniqueCarrier), MAX(Cancelled) FROM mytable WHERE DivLongestGTimes IN (7.0) LIMIT 25","hsqls":["SELECT MIN(DivReachedDest), COUNT(UniqueCarrier), MAX(Cancelled)  FROM mytable WHERE (DivLongestGTimes[1] IN (7.0) OR DivLongestGTimes[2] IN (7.0) OR DivLongestGTimes[3] IN (7.0) OR DivLongestGTimes[4] IN (7.0) OR DivLongestGTimes[5] IN (7.0)) LIMIT 10000"]}
{"sql":"SELECT FirstDepTime FROM mytable WHERE DestAirportID > 14107 ORDER BY DivDistance, TailNum, AirlineID LIMIT 21"}
{"sql":"SELECT MIN(OriginAirportSeqID), MAX(DistanceGroup), MAX(TaxiIn) FROM mytable WHERE FlightDate IN ('2014-01-28', '2014-01-20', '2014-01-16') OR CRSArrTime NOT IN (746) AND ArrTimeBlk BETWEEN '1800-1859' AND '1800-1859' LIMIT 24"}
{"sql":"SELECT OriginCityMarketID, NASDelay, COUNT(*) FROM mytable WHERE OriginStateName BETWEEN 'New Mexico' AND 'New York' AND DivActualElapsedTime NOT IN (267, 191, 141) GROUP BY OriginCityMarketID, NASDelay  ORDER BY OriginCityMarketID, NASDelay LIMIT 11","hsqls":["SELECT OriginCityMarketID, NASDelay, COUNT(*) FROM mytable WHERE OriginStateName BETWEEN 'New Mexico' AND 'New York' AND DivActualElapsedTime NOT IN (267, 191, 141) GROUP BY OriginCityMarketID, NASDelay  ORDER BY OriginCityMarketID, NASDelay LIMIT 11"]}
{"sql":"SELECT AirTime FROM mytable WHERE TaxiOut <= 92 AND TaxiIn <> 51 OR DepTimeBlk NOT IN ('2000-2059', '1000-1059', '2300-2359', '0600-0659', '1900-1959') ORDER BY DivDistance, ArrDel15, DayofMonth LIMIT 25"}
{"sql":"SELECT Quarter, CarrierDelay, ActualElapsedTime FROM mytable ORDER BY DestCityName, CRSElapsedTime LIMIT 24"}
{"sql":"SELECT ActualElapsedTime, DayofMonth, DaysSinceEpoch, MAX(Flights) FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 OR Origin <> 'MKE' GROUP BY ActualElapsedTime, DayofMonth, DaysSinceEpoch LIMIT 11","hsqls":["SELECT ActualElapsedTime, DayofMonth, DaysSinceEpoch, MAX(Flights) FROM mytable WHERE `Month` BETWEEN 1 AND 1 OR Origin <> 'MKE' GROUP BY ActualElapsedTime, DayofMonth, DaysSinceEpoch LIMIT 11"]}
{"sql":"SELECT DaysSinceEpoch, AVG(Distance), MIN(AirlineID) FROM mytable GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 14","hsqls":["SELECT DaysSinceEpoch, AVG(Distance), MIN(AirlineID) FROM mytable GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 14"]}
{"sql":"SELECT FirstDepTime FROM mytable ORDER BY DestStateName, CancellationCode LIMIT 17"}
{"sql":"SELECT \"Year\", DivDistance, DivActualElapsedTime FROM mytable WHERE LateAircraftDelay BETWEEN 21 AND 110 LIMIT 12","hsqls":["SELECT Year, DivDistance, DivActualElapsedTime FROM mytable WHERE LateAircraftDelay BETWEEN 21 AND 110 LIMIT 12"]}
{"sql":"SELECT SecurityDelay FROM mytable WHERE OriginState >= 'FL' OR OriginAirportSeqID IN (1412202, 1209402, 1078502, 1348502, 1109702) AND Flights > 1 ORDER BY \"Year\", Dest, DayofMonth LIMIT 23","hsqls":["SELECT SecurityDelay FROM mytable WHERE OriginState >= 'FL' OR OriginAirportSeqID IN (1412202, 1209402, 1078502, 1348502, 1109702) AND Flights > 1 ORDER BY Year, Dest, DayofMonth LIMIT 23"]}
{"sql":"SELECT DestWac, NASDelay, COUNT(Carrier), AVG(DayofMonth) FROM mytable GROUP BY DestWac, NASDelay  ORDER BY DestWac, NASDelay LIMIT 12","hsqls":["SELECT DestWac, NASDelay, COUNT(Carrier), AVG(DayofMonth) FROM mytable GROUP BY DestWac, NASDelay  ORDER BY DestWac, NASDelay LIMIT 12"]}
{"sql":"SELECT DestWac, TailNum, ArrDelay FROM mytable LIMIT 28"}
{"sql":"SELECT COUNT(NASDelay), MIN(DestAirportSeqID) FROM mytable WHERE ArrDelay IN (996.0, 261.0, 56.0) LIMIT 21"}
{"sql":"SELECT DistanceGroup, TotalAddGTime FROM mytable WHERE OriginStateName IN ('Mississippi', 'Georgia') OR DivWheelsOffs <= 1906 LIMIT 15","hsqls":["SELECT DistanceGroup, TotalAddGTime FROM mytable WHERE OriginStateName IN ('Mississippi', 'Georgia') OR (DivWheelsOffs[1] <= 1906 OR DivWheelsOffs[2] <= 1906 OR DivWheelsOffs[3] <= 1906 OR DivWheelsOffs[4] <= 1906 OR DivWheelsOffs[5] <= 1906) LIMIT 10000"]}
{"sql":"SELECT SUM(Cancelled), MIN(OriginWac) FROM mytable WHERE DivReachedDest < 1 OR TaxiIn >= 4 AND LateAircraftDelay BETWEEN 327 AND 10 LIMIT 16"}
{"sql":"SELECT DistanceGroup, AVG(DestAirportID), COUNT(DaysSinceEpoch) FROM mytable WHERE DepartureDelayGroups BETWEEN 12 AND 8 OR DivActualElapsedTime IN (1043, 165, 334, 208, 273) GROUP BY DistanceGroup  ORDER BY DistanceGroup LIMIT 14","hsqls":["SELECT DistanceGroup, AVG(DestAirportID), COUNT(DaysSinceEpoch) FROM mytable WHERE DepartureDelayGroups BETWEEN 12 AND 8 OR DivActualElapsedTime IN (1043, 165, 334, 208, 273) GROUP BY DistanceGroup  ORDER BY DistanceGroup LIMIT 14"]}
{"sql":"SELECT Dest, DestCityMarketID, COUNT(*) FROM mytable WHERE ArrivalDelayGroups BETWEEN 4 AND 2 AND UniqueCarrier BETWEEN 'B6' AND 'AS' GROUP BY Dest, DestCityMarketID  ORDER BY Dest, DestCityMarketID LIMIT 9","hsqls":["SELECT Dest, DestCityMarketID, COUNT(*) FROM mytable WHERE ArrivalDelayGroups BETWEEN 4 AND 2 AND UniqueCarrier BETWEEN 'B6' AND 'AS' GROUP BY Dest, DestCityMarketID  ORDER BY Dest, DestCityMarketID LIMIT 9"]}
{"sql":"SELECT DestWac, DivAirportLandings FROM mytable ORDER BY DivReachedDest LIMIT 28"}
{"sql":"SELECT CancellationCode, OriginStateName, SUM(ArrDelayMinutes), COUNT(ArrTimeBlk), AVG(DistanceGroup) FROM mytable WHERE \"Year\" > 2014 AND DepDelay <= 456.0 OR DivWheelsOffs BETWEEN 2030 AND 2138 GROUP BY CancellationCode, OriginStateName LIMIT 12","hsqls":["SELECT CancellationCode, OriginStateName, SUM(ArrDelayMinutes), COUNT(ArrTimeBlk), AVG(DistanceGroup) FROM mytable WHERE `Year` > 2014 AND DepDelay <= 456.0 OR (DivWheelsOffs[1] BETWEEN 2030 AND 2138 OR DivWheelsOffs[2] BETWEEN 2030 AND 2138 OR DivWheelsOffs[3] BETWEEN 2030 AND 2138 OR DivWheelsOffs[4] BETWEEN 2030 AND 2138 OR DivWheelsOffs[5] BETWEEN 2030 AND 2138) GROUP BY CancellationCode, OriginStateName LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, Quarter FROM mytable WHERE DestAirportID BETWEEN 10990 AND 15048 OR DivWheelsOns IN (1625, 1427, 2304, 733) LIMIT 23","hsqls":["SELECT DepartureDelayGroups, Quarter FROM mytable WHERE DestAirportID BETWEEN 10990 AND 15048 OR (DivWheelsOns[1] IN (1625, 1427, 2304, 733) OR DivWheelsOns[2] IN (1625, 1427, 2304, 733) OR DivWheelsOns[3] IN (1625, 1427, 2304, 733) OR DivWheelsOns[4] IN (1625, 1427, 2304, 733) OR DivWheelsOns[5] IN (1625, 1427, 2304, 733)) LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, CarrierDelay, SecurityDelay FROM mytable WHERE LateAircraftDelay IN (373, 37) ORDER BY OriginState LIMIT 28"}
{"sql":"SELECT TotalAddGTime, CRSDepTime, DivArrDelay FROM mytable WHERE DivAirportLandings BETWEEN 9 AND 0 LIMIT 16"}
{"sql":"SELECT DivArrDelay, ArrivalDelayGroups, MIN(TaxiIn) FROM mytable WHERE ActualElapsedTime = 332 GROUP BY DivArrDelay, ArrivalDelayGroups  ORDER BY DivArrDelay, ArrivalDelayGroups LIMIT 26","hsqls":["SELECT DivArrDelay, ArrivalDelayGroups, MIN(TaxiIn) FROM mytable WHERE ActualElapsedTime = 332 GROUP BY DivArrDelay, ArrivalDelayGroups  ORDER BY DivArrDelay, ArrivalDelayGroups LIMIT 26"]}
{"sql":"SELECT DepDel15, COUNT(*) FROM mytable WHERE DivAirportIDs IN (15249, 11775, 13424) AND Distance NOT IN (1616, 1294, 998, 666) GROUP BY DepDel15 LIMIT 27","hsqls":["SELECT DepDel15, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] IN (15249, 11775, 13424) OR DivAirportIDs[2] IN (15249, 11775, 13424) OR DivAirportIDs[3] IN (15249, 11775, 13424) OR DivAirportIDs[4] IN (15249, 11775, 13424) OR DivAirportIDs[5] IN (15249, 11775, 13424)) AND Distance NOT IN (1616, 1294, 998, 666) GROUP BY DepDel15 LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, OriginState, Quarter FROM mytable WHERE DivLongestGTimes IN (108.0, 145.0, 21.0, 104.0) AND DestWac BETWEEN 91 AND 42 OR DestCityName BETWEEN 'Grand Junction, CO' AND 'Gunnison, CO' ORDER BY DivDistance LIMIT 2","hsqls":["SELECT DivReachedDest, OriginState, Quarter FROM mytable WHERE (DivLongestGTimes[1] IN (108.0, 145.0, 21.0, 104.0) OR DivLongestGTimes[2] IN (108.0, 145.0, 21.0, 104.0) OR DivLongestGTimes[3] IN (108.0, 145.0, 21.0, 104.0) OR DivLongestGTimes[4] IN (108.0, 145.0, 21.0, 104.0) OR DivLongestGTimes[5] IN (108.0, 145.0, 21.0, 104.0)) AND DestWac BETWEEN 91 AND 42 OR DestCityName BETWEEN 'Grand Junction, CO' AND 'Gunnison, CO' ORDER BY DivDistance LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID FROM mytable ORDER BY Diverted, Distance, CRSDepTime LIMIT 9"}
{"sql":"SELECT DestState, SecurityDelay, DaysSinceEpoch, SUM(AirlineID), MIN(ArrivalDelayGroups) FROM mytable GROUP BY DestState, SecurityDelay, DaysSinceEpoch  ORDER BY DestState, SecurityDelay, DaysSinceEpoch LIMIT 1","hsqls":["SELECT DestState, SecurityDelay, DaysSinceEpoch, SUM(AirlineID), MIN(ArrivalDelayGroups) FROM mytable GROUP BY DestState, SecurityDelay, DaysSinceEpoch  ORDER BY DestState, SecurityDelay, DaysSinceEpoch LIMIT 1"]}
{"sql":"SELECT DepartureDelayGroups FROM mytable ORDER BY ArrivalDelayGroups LIMIT 9"}
{"sql":"SELECT WheelsOff, OriginCityName, DestStateName FROM mytable WHERE FirstDepTime < 1016 AND LateAircraftDelay > 138 ORDER BY FirstDepTime LIMIT 18"}
{"sql":"SELECT WheelsOff, \"Year\", Carrier FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND DayofMonth NOT IN (1, 31, 28) OR DestAirportID IN (10299, 11996, 13424, 11982) ORDER BY DestWac LIMIT 9","hsqls":["SELECT WheelsOff, Year, Carrier FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND DayofMonth NOT IN (1, 31, 28) OR DestAirportID IN (10299, 11996, 13424, 11982) ORDER BY DestWac LIMIT 9"]}
{"sql":"SELECT AirlineID, OriginAirportID, COUNT(*) FROM mytable WHERE WeatherDelay BETWEEN 16 AND 17 OR DivLongestGTimes = 102.0 GROUP BY AirlineID, OriginAirportID LIMIT 11","hsqls":["SELECT AirlineID, OriginAirportID, COUNT(*) FROM mytable WHERE WeatherDelay BETWEEN 16 AND 17 OR (DivLongestGTimes[1] = 102.0 OR DivLongestGTimes[2] = 102.0 OR DivLongestGTimes[3] = 102.0 OR DivLongestGTimes[4] = 102.0 OR DivLongestGTimes[5] = 102.0) GROUP BY AirlineID, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT DivDistance, DepTimeBlk, OriginAirportID, COUNT(*) FROM mytable WHERE OriginStateName IN ('New Mexico', 'South Carolina', 'Hawaii', 'Montana', 'Indiana') OR Flights = 1 AND LateAircraftDelay IN (175, 194, 80, 60) GROUP BY DivDistance, DepTimeBlk, OriginAirportID  ORDER BY DivDistance, DepTimeBlk, OriginAirportID LIMIT 2","hsqls":["SELECT DivDistance, DepTimeBlk, OriginAirportID, COUNT(*) FROM mytable WHERE OriginStateName IN ('New Mexico', 'South Carolina', 'Hawaii', 'Montana', 'Indiana') OR Flights = 1 AND LateAircraftDelay IN (175, 194, 80, 60) GROUP BY DivDistance, DepTimeBlk, OriginAirportID  ORDER BY DivDistance, DepTimeBlk, OriginAirportID LIMIT 2"]}
{"sql":"SELECT DepartureDelayGroups, WeatherDelay, ArrDelay, COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR UniqueCarrier > 'DL' GROUP BY DepartureDelayGroups, WeatherDelay, ArrDelay  ORDER BY DepartureDelayGroups, WeatherDelay, ArrDelay LIMIT 11","hsqls":["SELECT DepartureDelayGroups, WeatherDelay, ArrDelay, COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR UniqueCarrier > 'DL' GROUP BY DepartureDelayGroups, WeatherDelay, ArrDelay  ORDER BY DepartureDelayGroups, WeatherDelay, ArrDelay LIMIT 11"]}
{"sql":"SELECT WeatherDelay, DivTotalGTimes FROM mytable WHERE DepartureDelayGroups BETWEEN 12 AND 4 OR FlightDate IN ('2014-01-13', '2014-01-23', '2014-01-10') OR Quarter <= 1 LIMIT 10","hsqls":["SELECT WeatherDelay, DivTotalGTimes FROM mytable WHERE DepartureDelayGroups BETWEEN 12 AND 4 OR FlightDate IN ('2014-01-13', '2014-01-23', '2014-01-10') OR Quarter <= 1 LIMIT 10000"]}
{"sql":"SELECT OriginState, CRSDepTime FROM mytable WHERE DepTimeBlk BETWEEN '0600-0659' AND '1200-1259' OR FlightNum IN (5601, 3039, 2412, 630, 985) LIMIT 11"}
{"sql":"SELECT ArrDelay, COUNT(*) FROM mytable WHERE DaysSinceEpoch BETWEEN 16082 AND 16088 OR OriginStateFips NOT IN (32, 18, 36, 33, 39) AND ActualElapsedTime NOT IN (383, 178, 244, 271, 167) GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 2","hsqls":["SELECT ArrDelay, COUNT(*) FROM mytable WHERE DaysSinceEpoch BETWEEN 16082 AND 16088 OR OriginStateFips NOT IN (32, 18, 36, 33, 39) AND ActualElapsedTime NOT IN (383, 178, 244, 271, 167) GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 2"]}
{"sql":"SELECT DestState, DepTimeBlk, DivActualElapsedTime FROM mytable WHERE Quarter IN (1) LIMIT 26"}
{"sql":"SELECT Quarter, Carrier, AirlineID, MIN(DepDelayMinutes), MAX(WheelsOn) FROM mytable WHERE OriginCityName > 'College Station/Bryan, TX' GROUP BY Quarter, Carrier, AirlineID  ORDER BY Quarter, Carrier, AirlineID LIMIT 5","hsqls":["SELECT Quarter, Carrier, AirlineID, MIN(DepDelayMinutes), MAX(WheelsOn) FROM mytable WHERE OriginCityName > 'College Station/Bryan, TX' GROUP BY Quarter, Carrier, AirlineID  ORDER BY Quarter, Carrier, AirlineID LIMIT 5"]}
{"sql":"SELECT DestState, OriginStateName, MIN(DivActualElapsedTime), SUM(DivArrDelay) FROM mytable WHERE DestCityMarketID = 32888 OR Cancelled IN (1, 0) GROUP BY DestState, OriginStateName  ORDER BY DestState, OriginStateName LIMIT 2","hsqls":["SELECT DestState, OriginStateName, MIN(DivActualElapsedTime), SUM(DivArrDelay) FROM mytable WHERE DestCityMarketID = 32888 OR Cancelled IN (1, 0) GROUP BY DestState, OriginStateName  ORDER BY DestState, OriginStateName LIMIT 2"]}
{"sql":"SELECT Dest, MIN(DivDistance) FROM mytable WHERE OriginWac NOT IN (1, 91, 39, 11, 37) OR CRSDepTime IN (717, 1507) AND DayOfWeek NOT IN (5) GROUP BY Dest  ORDER BY Dest LIMIT 7","hsqls":["SELECT Dest, MIN(DivDistance) FROM mytable WHERE OriginWac NOT IN (1, 91, 39, 11, 37) OR CRSDepTime IN (717, 1507) AND DayOfWeek NOT IN (5) GROUP BY Dest  ORDER BY Dest LIMIT 7"]}
{"sql":"SELECT TaxiOut, DestState, DivActualElapsedTime FROM mytable WHERE CRSDepTime = 1256 AND FirstDepTime > 1940 AND DestWac IN (43, 5, 4, 52, 72) ORDER BY DaysSinceEpoch LIMIT 20"}
{"sql":"SELECT TaxiOut, DestCityMarketID FROM mytable ORDER BY FlightNum, \"Month\" LIMIT 25","hsqls":["SELECT TaxiOut, DestCityMarketID FROM mytable ORDER BY FlightNum, `Month` LIMIT 25"]}
{"sql":"SELECT DistanceGroup, ActualElapsedTime, AirlineID, MIN(FlightNum), MIN(ArrDelay), MIN(DaysSinceEpoch) FROM mytable WHERE OriginAirportSeqID < 1504102 OR NASDelay NOT IN (80, 12) OR DayOfWeek BETWEEN 3 AND 1 GROUP BY DistanceGroup, ActualElapsedTime, AirlineID  ORDER BY DistanceGroup, ActualElapsedTime, AirlineID LIMIT 9","hsqls":["SELECT DistanceGroup, ActualElapsedTime, AirlineID, MIN(FlightNum), MIN(ArrDelay), MIN(DaysSinceEpoch) FROM mytable WHERE OriginAirportSeqID < 1504102 OR NASDelay NOT IN (80, 12) OR DayOfWeek BETWEEN 3 AND 1 GROUP BY DistanceGroup, ActualElapsedTime, AirlineID  ORDER BY DistanceGroup, ActualElapsedTime, AirlineID LIMIT 9"]}
{"sql":"SELECT DepartureDelayGroups, ActualElapsedTime, DepTimeBlk, COUNT(*) FROM mytable WHERE Quarter <> 1 AND ArrTimeBlk NOT IN ('1000-1059', '2300-2359') OR ArrDelay NOT IN (75.0) GROUP BY DepartureDelayGroups, ActualElapsedTime, DepTimeBlk  ORDER BY DepartureDelayGroups, ActualElapsedTime, DepTimeBlk LIMIT 12","hsqls":["SELECT DepartureDelayGroups, ActualElapsedTime, DepTimeBlk, COUNT(*) FROM mytable WHERE Quarter <> 1 AND ArrTimeBlk NOT IN ('1000-1059', '2300-2359') OR ArrDelay NOT IN (75.0) GROUP BY DepartureDelayGroups, ActualElapsedTime, DepTimeBlk  ORDER BY DepartureDelayGroups, ActualElapsedTime, DepTimeBlk LIMIT 12"]}
{"sql":"SELECT SecurityDelay, DivWheelsOffs, ArrivalDelayGroups FROM mytable ORDER BY OriginCityName, DivArrDelay LIMIT 15","hsqls":["SELECT SecurityDelay, DivWheelsOffs, ArrivalDelayGroups FROM mytable ORDER BY OriginCityName, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT OriginState, CancellationCode FROM mytable WHERE SecurityDelay >= 18 AND DivAirportLandings <= 1 AND DivActualElapsedTime IN (272) ORDER BY Origin LIMIT 18"}
{"sql":"SELECT Origin, DayofMonth, COUNT(*) FROM mytable WHERE AirlineID BETWEEN 20355 AND 20436 OR ArrDel15 BETWEEN 0 AND 1 GROUP BY Origin, DayofMonth  ORDER BY Origin, DayofMonth LIMIT 6","hsqls":["SELECT Origin, DayofMonth, COUNT(*) FROM mytable WHERE AirlineID BETWEEN 20355 AND 20436 OR ArrDel15 BETWEEN 0 AND 1 GROUP BY Origin, DayofMonth  ORDER BY Origin, DayofMonth LIMIT 6"]}
{"sql":"SELECT DistanceGroup, ArrDelayMinutes, MAX(OriginAirportSeqID), MIN(CarrierDelay) FROM mytable WHERE OriginState < 'CO' OR DestAirportID IN (14869, 12197, 14108, 10781) GROUP BY DistanceGroup, ArrDelayMinutes  ORDER BY DistanceGroup, ArrDelayMinutes LIMIT 12","hsqls":["SELECT DistanceGroup, ArrDelayMinutes, MAX(OriginAirportSeqID), MIN(CarrierDelay) FROM mytable WHERE OriginState < 'CO' OR DestAirportID IN (14869, 12197, 14108, 10781) GROUP BY DistanceGroup, ArrDelayMinutes  ORDER BY DistanceGroup, ArrDelayMinutes LIMIT 12"]}
{"sql":"SELECT FlightDate, AVG(CarrierDelay), MAX(DepDelayMinutes), MIN(Distance) FROM mytable WHERE TaxiIn < 10 OR Distance IN (505, 930) AND ArrDel15 BETWEEN -9999 AND -9999 GROUP BY FlightDate  ORDER BY FlightDate LIMIT 21","hsqls":["SELECT FlightDate, AVG(CarrierDelay), MAX(DepDelayMinutes), MIN(Distance) FROM mytable WHERE TaxiIn < 10 OR Distance IN (505, 930) AND ArrDel15 BETWEEN -9999 AND -9999 GROUP BY FlightDate  ORDER BY FlightDate LIMIT 21"]}
{"sql":"SELECT DepartureDelayGroups, TotalAddGTime, ActualElapsedTime, MIN(DepDelayMinutes), COUNT(Origin), MIN(AirTime) FROM mytable WHERE DepTime NOT IN (1355) OR WeatherDelay BETWEEN 100 AND 59 OR Quarter NOT IN (1) GROUP BY DepartureDelayGroups, TotalAddGTime, ActualElapsedTime  ORDER BY DepartureDelayGroups, TotalAddGTime, ActualElapsedTime LIMIT 20","hsqls":["SELECT DepartureDelayGroups, TotalAddGTime, ActualElapsedTime, MIN(DepDelayMinutes), COUNT(Origin), MIN(AirTime) FROM mytable WHERE DepTime NOT IN (1355) OR WeatherDelay BETWEEN 100 AND 59 OR Quarter NOT IN (1) GROUP BY DepartureDelayGroups, TotalAddGTime, ActualElapsedTime  ORDER BY DepartureDelayGroups, TotalAddGTime, ActualElapsedTime LIMIT 20"]}
{"sql":"SELECT Carrier, SecurityDelay, MAX(OriginAirportSeqID), COUNT(TotalAddGTime), MIN(AirlineID) FROM mytable WHERE DivReachedDest <= 0 OR DayOfWeek < 6 GROUP BY Carrier, SecurityDelay","hsqls":["SELECT Carrier, SecurityDelay, MAX(OriginAirportSeqID), COUNT(TotalAddGTime), MIN(AirlineID) FROM mytable WHERE DivReachedDest <= 0 OR DayOfWeek < 6 GROUP BY Carrier, SecurityDelay"]}
{"sql":"SELECT DestAirportSeqID, DivAirportLandings FROM mytable WHERE ArrTime = 1431 OR DivAirports <= 'FSD' ORDER BY DistanceGroup, DivReachedDest, DepTime LIMIT 9","hsqls":["SELECT DestAirportSeqID, DivAirportLandings FROM mytable WHERE ArrTime = 1431 OR (DivAirports[1] <= 'FSD' OR DivAirports[2] <= 'FSD' OR DivAirports[3] <= 'FSD' OR DivAirports[4] <= 'FSD' OR DivAirports[5] <= 'FSD') ORDER BY DistanceGroup, DivReachedDest, DepTime LIMIT 10000"]}
{"sql":"SELECT FlightDate, DepDel15, CRSElapsedTime FROM mytable WHERE OriginCityMarketID >= 33244 AND OriginCityName IN ('Seattle, WA', 'Eagle, CO') AND DestCityName <= 'San Luis Obispo, CA' ORDER BY DivDistance, CRSArrTime LIMIT 20"}
{"sql":"SELECT Diverted, TaxiIn, DivAirportIDs FROM mytable WHERE AirTime BETWEEN 224 AND 95 AND LateAircraftDelay NOT IN (112, 113, 39, 13, 255) AND DestAirportID BETWEEN 13931 AND 14730 ORDER BY TaxiIn LIMIT 27","hsqls":["SELECT Diverted, TaxiIn, DivAirportIDs FROM mytable WHERE AirTime BETWEEN 224 AND 95 AND LateAircraftDelay NOT IN (112, 113, 39, 13, 255) AND DestAirportID BETWEEN 13931 AND 14730 ORDER BY TaxiIn LIMIT 10000"]}
{"sql":"SELECT DivWheelsOffs, OriginAirportID FROM mytable WHERE TotalAddGTime <= 24 ORDER BY DestCityMarketID LIMIT 21","hsqls":["SELECT DivWheelsOffs, OriginAirportID FROM mytable WHERE TotalAddGTime <= 24 ORDER BY DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT CarrierDelay FROM mytable WHERE NASDelay NOT IN (57, 15, 28, 76) AND \"Month\" BETWEEN 1 AND 1 ORDER BY DepDel15 LIMIT 27","hsqls":["SELECT CarrierDelay FROM mytable WHERE NASDelay NOT IN (57, 15, 28, 76) AND `Month` BETWEEN 1 AND 1 ORDER BY DepDel15 LIMIT 27"]}
{"sql":"SELECT DepartureDelayGroups, OriginCityName, DayofMonth FROM mytable WHERE TotalAddGTime BETWEEN 111 AND 111 OR DayOfWeek NOT IN (3, 1, 7, 5, 4) AND DestAirportSeqID >= 1457604 ORDER BY FlightNum, CarrierDelay, DestAirportID LIMIT 2"}
{"sql":"SELECT Flights FROM mytable WHERE DayOfWeek BETWEEN 6 AND 4 AND CancellationCode <> 'B' OR DivTailNums IN ('N611SK', 'N373JB', 'N368NW') ORDER BY Carrier, CRSArrTime LIMIT 3","hsqls":["SELECT Flights FROM mytable WHERE DayOfWeek BETWEEN 6 AND 4 AND CancellationCode <> 'B' OR (DivTailNums[1] IN ('N611SK', 'N373JB', 'N368NW') OR DivTailNums[2] IN ('N611SK', 'N373JB', 'N368NW') OR DivTailNums[3] IN ('N611SK', 'N373JB', 'N368NW') OR DivTailNums[4] IN ('N611SK', 'N373JB', 'N368NW') OR DivTailNums[5] IN ('N611SK', 'N373JB', 'N368NW')) ORDER BY Carrier, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT COUNT(\"Month\"), MIN(DivReachedDest) FROM mytable WHERE DivArrDelay BETWEEN 258 AND 1153 AND DestState NOT IN ('MO') LIMIT 14","hsqls":["SELECT COUNT(`Month`), MIN(DivReachedDest) FROM mytable WHERE DivArrDelay BETWEEN 258 AND 1153 AND DestState NOT IN ('MO') LIMIT 14"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE CRSDepTime >= 1547 AND WeatherDelay NOT IN (19, 26, 100) AND OriginAirportSeqID BETWEEN 1018502 AND 1018502 LIMIT 1"}
{"sql":"SELECT OriginCityName, NASDelay, ArrDelay FROM mytable WHERE TailNum BETWEEN 'N77871' AND 'N711HK' ORDER BY DivDistance, FlightDate, AirlineID LIMIT 21"}
{"sql":"SELECT DayofMonth, DayOfWeek FROM mytable LIMIT 6"}
{"sql":"SELECT DistanceGroup, ArrDelay, CRSDepTime, MAX(WheelsOn), SUM(OriginAirportID) FROM mytable GROUP BY DistanceGroup, ArrDelay, CRSDepTime  ORDER BY DistanceGroup, ArrDelay, CRSDepTime LIMIT 3","hsqls":["SELECT DistanceGroup, ArrDelay, CRSDepTime, MAX(WheelsOn), SUM(OriginAirportID) FROM mytable GROUP BY DistanceGroup, ArrDelay, CRSDepTime  ORDER BY DistanceGroup, ArrDelay, CRSDepTime LIMIT 3"]}
{"sql":"SELECT OriginState, MAX(LateAircraftDelay), MAX(DayOfWeek) FROM mytable WHERE CarrierDelay BETWEEN 0 AND 243 GROUP BY OriginState  ORDER BY OriginState LIMIT 8","hsqls":["SELECT OriginState, MAX(LateAircraftDelay), MAX(DayOfWeek) FROM mytable WHERE CarrierDelay BETWEEN 0 AND 243 GROUP BY OriginState  ORDER BY OriginState LIMIT 8"]}
{"sql":"SELECT ArrTimeBlk, DivAirportLandings, SUM(WheelsOn), SUM(CRSDepTime), SUM(OriginAirportID) FROM mytable WHERE ArrDelay BETWEEN 92.0 AND -15.0 AND WheelsOff BETWEEN 1513 AND 910 OR TaxiIn >= 16 GROUP BY ArrTimeBlk, DivAirportLandings  ORDER BY ArrTimeBlk, DivAirportLandings LIMIT 28","hsqls":["SELECT ArrTimeBlk, DivAirportLandings, SUM(WheelsOn), SUM(CRSDepTime), SUM(OriginAirportID) FROM mytable WHERE ArrDelay BETWEEN 92.0 AND -15.0 AND WheelsOff BETWEEN 1513 AND 910 OR TaxiIn >= 16 GROUP BY ArrTimeBlk, DivAirportLandings  ORDER BY ArrTimeBlk, DivAirportLandings LIMIT 28"]}
{"sql":"SELECT SUM(Quarter), MAX(DestWac) FROM mytable WHERE \"Year\" NOT IN (2014) LIMIT 13","hsqls":["SELECT SUM(Quarter), MAX(DestWac) FROM mytable WHERE `Year` NOT IN (2014) LIMIT 13"]}
{"sql":"SELECT NASDelay, AirlineID, AVG(ArrTime), MIN(ArrTime), MIN(FirstDepTime) FROM mytable WHERE DepDelayMinutes >= 81.0 OR DepDelayMinutes NOT IN (108.0, 536.0) GROUP BY NASDelay, AirlineID  ORDER BY NASDelay, AirlineID LIMIT 11","hsqls":["SELECT NASDelay, AirlineID, AVG(ArrTime), MIN(ArrTime), MIN(FirstDepTime) FROM mytable WHERE DepDelayMinutes >= 81.0 OR DepDelayMinutes NOT IN (108.0, 536.0) GROUP BY NASDelay, AirlineID  ORDER BY NASDelay, AirlineID LIMIT 11"]}
{"sql":"SELECT DivDistance, UniqueCarrier FROM mytable WHERE WheelsOff BETWEEN 1851 AND 835 AND FlightNum BETWEEN 2053 AND 4720 LIMIT 16"}
{"sql":"SELECT DepDelay, Carrier, ArrDel15 FROM mytable WHERE DivAirports > 'MLI' OR DestStateName <= 'Oklahoma' LIMIT 16","hsqls":["SELECT DepDelay, Carrier, ArrDel15 FROM mytable WHERE (DivAirports[1] > 'MLI' OR DivAirports[2] > 'MLI' OR DivAirports[3] > 'MLI' OR DivAirports[4] > 'MLI' OR DivAirports[5] > 'MLI') OR DestStateName <= 'Oklahoma' LIMIT 10000"]}
{"sql":"SELECT DivTailNums, DivWheelsOffs FROM mytable WHERE DivLongestGTimes BETWEEN 116.0 AND 27.0 ORDER BY LongestAddGTime, TotalAddGTime LIMIT 26","hsqls":["SELECT DivTailNums, DivWheelsOffs FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 116.0 AND 27.0 OR DivLongestGTimes[2] BETWEEN 116.0 AND 27.0 OR DivLongestGTimes[3] BETWEEN 116.0 AND 27.0 OR DivLongestGTimes[4] BETWEEN 116.0 AND 27.0 OR DivLongestGTimes[5] BETWEEN 116.0 AND 27.0) ORDER BY LongestAddGTime, TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT MIN(DepDelayMinutes), MAX(LongestAddGTime), SUM(TaxiIn) FROM mytable WHERE DivTotalGTimes > 3 AND CancellationCode BETWEEN 'noodles' AND 'A' OR DivWheelsOffs > 1614 LIMIT 24","hsqls":["SELECT MIN(DepDelayMinutes), MAX(LongestAddGTime), SUM(TaxiIn)  FROM mytable WHERE (DivTotalGTimes[1] > 3 OR DivTotalGTimes[2] > 3 OR DivTotalGTimes[3] > 3 OR DivTotalGTimes[4] > 3 OR DivTotalGTimes[5] > 3) AND CancellationCode BETWEEN 'noodles' AND 'A' OR (DivWheelsOffs[1] > 1614 OR DivWheelsOffs[2] > 1614 OR DivWheelsOffs[3] > 1614 OR DivWheelsOffs[4] > 1614 OR DivWheelsOffs[5] > 1614) LIMIT 10000"]}
{"sql":"SELECT DayofMonth FROM mytable WHERE TaxiOut BETWEEN 97 AND 65 LIMIT 5"}
{"sql":"SELECT ArrDel15, TailNum, DestCityMarketID, COUNT(*) FROM mytable WHERE CarrierDelay >= 31 OR DestCityName > 'Flint, MI' GROUP BY ArrDel15, TailNum, DestCityMarketID  ORDER BY ArrDel15, TailNum, DestCityMarketID LIMIT 19","hsqls":["SELECT ArrDel15, TailNum, DestCityMarketID, COUNT(*) FROM mytable WHERE CarrierDelay >= 31 OR DestCityName > 'Flint, MI' GROUP BY ArrDel15, TailNum, DestCityMarketID  ORDER BY ArrDel15, TailNum, DestCityMarketID LIMIT 19"]}
{"sql":"SELECT DistanceGroup, DestStateFips FROM mytable WHERE AirlineID BETWEEN 20355 AND 20436 AND DivTotalGTimes < 64 ORDER BY WeatherDelay LIMIT 4","hsqls":["SELECT DistanceGroup, DestStateFips FROM mytable WHERE AirlineID BETWEEN 20355 AND 20436 AND (DivTotalGTimes[1] < 64 OR DivTotalGTimes[2] < 64 OR DivTotalGTimes[3] < 64 OR DivTotalGTimes[4] < 64 OR DivTotalGTimes[5] < 64) ORDER BY WeatherDelay LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, AirlineID, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, AirlineID","hsqls":["SELECT DestAirportSeqID, AirlineID, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, AirlineID"]}
{"sql":"SELECT DivLongestGTimes, DivAirportSeqIDs FROM mytable WHERE DayofMonth NOT IN (19, 23, 15, 8, 11) OR DivDistance BETWEEN 91 AND 115 ORDER BY ArrivalDelayGroups LIMIT 14","hsqls":["SELECT DivLongestGTimes, DivAirportSeqIDs FROM mytable WHERE DayofMonth NOT IN (19, 23, 15, 8, 11) OR DivDistance BETWEEN 91 AND 115 ORDER BY ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT CancellationCode, OriginAirportID FROM mytable WHERE ArrTime < 1235 OR DestStateFips BETWEEN 15 AND 72 ORDER BY WheelsOff, OriginWac, CRSElapsedTime LIMIT 3"}
{"sql":"SELECT DestStateName, DestCityMarketID FROM mytable LIMIT 26"}
{"sql":"SELECT OriginWac, COUNT(*) FROM mytable WHERE SecurityDelay IN (10, 1, 4, 8, -9999) GROUP BY OriginWac  ORDER BY OriginWac LIMIT 18","hsqls":["SELECT OriginWac, COUNT(*) FROM mytable WHERE SecurityDelay IN (10, 1, 4, 8, -9999) GROUP BY OriginWac  ORDER BY OriginWac LIMIT 18"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 2"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivAirports IN ('ROA', 'PLS', 'SYR') OR OriginCityName > 'Bozeman, MT' LIMIT 25","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivAirports[1] IN ('ROA', 'PLS', 'SYR') OR DivAirports[2] IN ('ROA', 'PLS', 'SYR') OR DivAirports[3] IN ('ROA', 'PLS', 'SYR') OR DivAirports[4] IN ('ROA', 'PLS', 'SYR') OR DivAirports[5] IN ('ROA', 'PLS', 'SYR')) OR OriginCityName > 'Bozeman, MT' LIMIT 10000"]}
{"sql":"SELECT ArrivalDelayGroups, MIN(\"Month\") FROM mytable WHERE DepTime BETWEEN 1150 AND 2315 AND DepTimeBlk IN ('2000-2059', '1700-1759', '0700-0759', '0600-0659', '1900-1959') AND OriginCityName NOT IN ('Islip, NY') GROUP BY ArrivalDelayGroups LIMIT 11","hsqls":["SELECT ArrivalDelayGroups, MIN(`Month`) FROM mytable WHERE DepTime BETWEEN 1150 AND 2315 AND DepTimeBlk IN ('2000-2059', '1700-1759', '0700-0759', '0600-0659', '1900-1959') AND OriginCityName NOT IN ('Islip, NY') GROUP BY ArrivalDelayGroups LIMIT 11"]}
{"sql":"SELECT CRSArrTime, WheelsOn FROM mytable WHERE DivLongestGTimes BETWEEN 112.0 AND 39.0 LIMIT 8","hsqls":["SELECT CRSArrTime, WheelsOn FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 112.0 AND 39.0 OR DivLongestGTimes[2] BETWEEN 112.0 AND 39.0 OR DivLongestGTimes[3] BETWEEN 112.0 AND 39.0 OR DivLongestGTimes[4] BETWEEN 112.0 AND 39.0 OR DivLongestGTimes[5] BETWEEN 112.0 AND 39.0) LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, Dest, \"Month\", MAX(CarrierDelay) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR WheelsOff NOT IN (1009, 924) OR DestStateFips BETWEEN 44 AND 41 GROUP BY OriginAirportSeqID, Dest, \"Month\" LIMIT 3","hsqls":["SELECT OriginAirportSeqID, Dest, Month, MAX(CarrierDelay) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR WheelsOff NOT IN (1009, 924) OR DestStateFips BETWEEN 44 AND 41 GROUP BY OriginAirportSeqID, Dest, `Month` LIMIT 3"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivActualElapsedTime BETWEEN 381 AND 224 LIMIT 1"}
{"sql":"SELECT OriginStateFips FROM mytable WHERE DestAirportSeqID IN (1320402, 1106702, 1099402, 1396403) AND Origin NOT IN ('GCC', 'TUS', 'MOT', 'DAY') OR FirstDepTime BETWEEN 1639 AND 1940 LIMIT 27"}
{"sql":"SELECT MAX(\"Year\"), SUM(OriginAirportSeqID) FROM mytable LIMIT 25","hsqls":["SELECT MAX(`Year`), SUM(OriginAirportSeqID) FROM mytable LIMIT 25"]}
{"sql":"SELECT ArrivalDelayGroups, MIN(DepDel15), MAX(DestCityMarketID), COUNT(TailNum) FROM mytable WHERE DestAirportSeqID NOT IN (1114603, 1114002) GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 24","hsqls":["SELECT ArrivalDelayGroups, MIN(DepDel15), MAX(DestCityMarketID), COUNT(TailNum) FROM mytable WHERE DestAirportSeqID NOT IN (1114603, 1114002) GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 24"]}
{"sql":"SELECT TaxiOut, DepDel15 FROM mytable ORDER BY DivReachedDest, DestStateFips, WheelsOn LIMIT 26"}
{"sql":"SELECT DepDelay, OriginStateFips, CRSElapsedTime FROM mytable WHERE ArrivalDelayGroups = 5 OR DivLongestGTimes < 9.0 LIMIT 14","hsqls":["SELECT DepDelay, OriginStateFips, CRSElapsedTime FROM mytable WHERE ArrivalDelayGroups = 5 OR (DivLongestGTimes[1] < 9.0 OR DivLongestGTimes[2] < 9.0 OR DivLongestGTimes[3] < 9.0 OR DivLongestGTimes[4] < 9.0 OR DivLongestGTimes[5] < 9.0) LIMIT 10000"]}
{"sql":"SELECT DivActualElapsedTime, DayOfWeek, MIN(DestAirportID), COUNT(DivActualElapsedTime), COUNT(DivDistance) FROM mytable WHERE FlightDate IN ('2014-01-20', '2014-01-11', '2014-01-01', '2014-01-08') AND ActualElapsedTime BETWEEN 70 AND 245 AND Carrier <> 'DL' GROUP BY DivActualElapsedTime, DayOfWeek  ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 19","hsqls":["SELECT DivActualElapsedTime, DayOfWeek, MIN(DestAirportID), COUNT(DivActualElapsedTime), COUNT(DivDistance) FROM mytable WHERE FlightDate IN ('2014-01-20', '2014-01-11', '2014-01-01', '2014-01-08') AND ActualElapsedTime BETWEEN 70 AND 245 AND Carrier <> 'DL' GROUP BY DivActualElapsedTime, DayOfWeek  ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 19"]}
{"sql":"SELECT AirlineID FROM mytable WHERE DivAirportLandings IN (1) ORDER BY Flights, NASDelay LIMIT 19"}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE LateAircraftDelay > 25 AND ArrivalDelayGroups > 0 ORDER BY DivArrDelay LIMIT 4"}
{"sql":"SELECT SUM(TotalAddGTime) FROM mytable WHERE \"Year\" <> 2014 AND OriginCityName NOT IN ('Chico, CA', 'San Jose, CA', 'Bangor, ME') LIMIT 28","hsqls":["SELECT SUM(TotalAddGTime) FROM mytable WHERE `Year` <> 2014 AND OriginCityName NOT IN ('Chico, CA', 'San Jose, CA', 'Bangor, ME') LIMIT 28"]}
{"sql":"SELECT SUM(TotalAddGTime), COUNT(DistanceGroup) FROM mytable WHERE DivAirportIDs BETWEEN 13851 AND 11278 LIMIT 22","hsqls":["SELECT SUM(TotalAddGTime), COUNT(DistanceGroup)  FROM mytable WHERE (DivAirportIDs[1] BETWEEN 13851 AND 11278 OR DivAirportIDs[2] BETWEEN 13851 AND 11278 OR DivAirportIDs[3] BETWEEN 13851 AND 11278 OR DivAirportIDs[4] BETWEEN 13851 AND 11278 OR DivAirportIDs[5] BETWEEN 13851 AND 11278) LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE OriginAirportID NOT IN (11042, 13871, 14262, 13487, 11525) LIMIT 12"}
{"sql":"SELECT WheelsOff, DivLongestGTimes FROM mytable WHERE DestStateFips < 48 AND TailNum NOT IN ('N901DA', 'N16149', 'N64809', 'N603MQ', 'N37298') OR DepartureDelayGroups < -2 ORDER BY Distance, DayofMonth LIMIT 29","hsqls":["SELECT WheelsOff, DivLongestGTimes FROM mytable WHERE DestStateFips < 48 AND TailNum NOT IN ('N901DA', 'N16149', 'N64809', 'N603MQ', 'N37298') OR DepartureDelayGroups < -2 ORDER BY Distance, DayofMonth LIMIT 10000"]}
{"sql":"SELECT Distance, DestStateFips, OriginCityName, MIN(OriginWac), AVG(LateAircraftDelay), AVG(AirlineID) FROM mytable WHERE OriginStateName BETWEEN 'Oklahoma' AND 'Kansas' AND DivWheelsOns BETWEEN 1213 AND 811 GROUP BY Distance, DestStateFips, OriginCityName LIMIT 28","hsqls":["SELECT Distance, DestStateFips, OriginCityName, MIN(OriginWac), AVG(LateAircraftDelay), AVG(AirlineID) FROM mytable WHERE OriginStateName BETWEEN 'Oklahoma' AND 'Kansas' AND (DivWheelsOns[1] BETWEEN 1213 AND 811 OR DivWheelsOns[2] BETWEEN 1213 AND 811 OR DivWheelsOns[3] BETWEEN 1213 AND 811 OR DivWheelsOns[4] BETWEEN 1213 AND 811 OR DivWheelsOns[5] BETWEEN 1213 AND 811) GROUP BY Distance, DestStateFips, OriginCityName LIMIT 10000"]}
{"sql":"SELECT DivDistance, WeatherDelay FROM mytable WHERE TailNum IN ('N923EV', 'N326NB', 'N709UW', 'N5EVAA', 'N467UA') OR Diverted BETWEEN 0 AND 0 AND DayofMonth NOT IN (2, 22, 12) LIMIT 26"}
{"sql":"SELECT MAX(ArrivalDelayGroups), MIN(ArrTime) FROM mytable WHERE DepDel15 BETWEEN -9999 AND 1 OR AirlineID <= 19805 LIMIT 28"}
{"sql":"SELECT DestWac, NASDelay FROM mytable WHERE DivTotalGTimes IN (30, 61, 29) OR DivAirports BETWEEN 'CLE' AND 'DFW' AND DivActualElapsedTime NOT IN (375, 362) ORDER BY Diverted, AirTime LIMIT 3","hsqls":["SELECT DestWac, NASDelay FROM mytable WHERE (DivTotalGTimes[1] IN (30, 61, 29) OR DivTotalGTimes[2] IN (30, 61, 29) OR DivTotalGTimes[3] IN (30, 61, 29) OR DivTotalGTimes[4] IN (30, 61, 29) OR DivTotalGTimes[5] IN (30, 61, 29)) OR (DivAirports[1] BETWEEN 'CLE' AND 'DFW' OR DivAirports[2] BETWEEN 'CLE' AND 'DFW' OR DivAirports[3] BETWEEN 'CLE' AND 'DFW' OR DivAirports[4] BETWEEN 'CLE' AND 'DFW' OR DivAirports[5] BETWEEN 'CLE' AND 'DFW') AND DivActualElapsedTime NOT IN (375, 362) ORDER BY Diverted, AirTime LIMIT 10000"]}
{"sql":"SELECT COUNT(DestAirportID) FROM mytable WHERE CRSArrTime IN (1717, 1754, 1135, 938, 1023) OR DepartureDelayGroups BETWEEN 10 AND 4 LIMIT 13"}
{"sql":"SELECT OriginAirportSeqID, DistanceGroup, DivAirportLandings, SUM(ArrivalDelayGroups) FROM mytable WHERE DestStateFips BETWEEN 36 AND 27 AND Origin IN ('SBA', 'MSN', 'DRO') AND DivAirportIDs IN (10140, 13476, 11471, 13891, 10728) GROUP BY OriginAirportSeqID, DistanceGroup, DivAirportLandings LIMIT 29","hsqls":["SELECT OriginAirportSeqID, DistanceGroup, DivAirportLandings, SUM(ArrivalDelayGroups) FROM mytable WHERE DestStateFips BETWEEN 36 AND 27 AND Origin IN ('SBA', 'MSN', 'DRO') AND (DivAirportIDs[1] IN (10140, 13476, 11471, 13891, 10728) OR DivAirportIDs[2] IN (10140, 13476, 11471, 13891, 10728) OR DivAirportIDs[3] IN (10140, 13476, 11471, 13891, 10728) OR DivAirportIDs[4] IN (10140, 13476, 11471, 13891, 10728) OR DivAirportIDs[5] IN (10140, 13476, 11471, 13891, 10728)) GROUP BY OriginAirportSeqID, DistanceGroup, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT TaxiOut, Distance, AVG(DaysSinceEpoch), SUM(ArrTime) FROM mytable GROUP BY TaxiOut, Distance  ORDER BY TaxiOut, Distance LIMIT 26","hsqls":["SELECT TaxiOut, Distance, AVG(DaysSinceEpoch), SUM(ArrTime) FROM mytable GROUP BY TaxiOut, Distance  ORDER BY TaxiOut, Distance LIMIT 26"]}
{"sql":"SELECT OriginWac, CRSDepTime, COUNT(*) FROM mytable WHERE SecurityDelay > 10 AND DestStateFips NOT IN (10, 32, 31, 13, 12) GROUP BY OriginWac, CRSDepTime  ORDER BY OriginWac, CRSDepTime LIMIT 20","hsqls":["SELECT OriginWac, CRSDepTime, COUNT(*) FROM mytable WHERE SecurityDelay > 10 AND DestStateFips NOT IN (10, 32, 31, 13, 12) GROUP BY OriginWac, CRSDepTime  ORDER BY OriginWac, CRSDepTime LIMIT 20"]}
{"sql":"SELECT DepTimeBlk, ArrDelay FROM mytable WHERE DestCityMarketID NOT IN (30325, 33256, 33024, 31049) ORDER BY DivActualElapsedTime LIMIT 19"}
{"sql":"SELECT DivReachedDest, DivArrDelay FROM mytable WHERE TaxiOut > 66 ORDER BY TailNum, UniqueCarrier LIMIT 13"}
{"sql":"SELECT DestState, COUNT(Quarter), AVG(DayofMonth) FROM mytable WHERE DestCityName BETWEEN 'Salt Lake City, UT' AND 'Sitka, AK' GROUP BY DestState  ORDER BY DestState LIMIT 9","hsqls":["SELECT DestState, COUNT(Quarter), AVG(DayofMonth) FROM mytable WHERE DestCityName BETWEEN 'Salt Lake City, UT' AND 'Sitka, AK' GROUP BY DestState  ORDER BY DestState LIMIT 9"]}
{"sql":"SELECT OriginCityMarketID, OriginCityName, DepDel15, COUNT(ArrDel15) FROM mytable WHERE CRSDepTime <> 2034 AND ArrDelay NOT IN (-40.0, 132.0) GROUP BY OriginCityMarketID, OriginCityName, DepDel15  ORDER BY OriginCityMarketID, OriginCityName, DepDel15 LIMIT 6","hsqls":["SELECT OriginCityMarketID, OriginCityName, DepDel15, COUNT(ArrDel15) FROM mytable WHERE CRSDepTime <> 2034 AND ArrDelay NOT IN (-40.0, 132.0) GROUP BY OriginCityMarketID, OriginCityName, DepDel15  ORDER BY OriginCityMarketID, OriginCityName, DepDel15 LIMIT 6"]}
{"sql":"SELECT COUNT(DivArrDelay) FROM mytable LIMIT 29"}
{"sql":"SELECT ActualElapsedTime, CancellationCode FROM mytable WHERE TotalAddGTime BETWEEN 27 AND 37 ORDER BY Diverted, OriginState, DaysSinceEpoch LIMIT 6"}
{"sql":"SELECT LongestAddGTime, DestAirportSeqID FROM mytable WHERE DivArrDelay BETWEEN 195 AND 226 OR CRSDepTime NOT IN (1139, 726, 1849) ORDER BY DepartureDelayGroups LIMIT 23"}
{"sql":"SELECT Carrier, COUNT(DestStateName) FROM mytable GROUP BY Carrier  ORDER BY Carrier LIMIT 21","hsqls":["SELECT Carrier, COUNT(DestStateName) FROM mytable GROUP BY Carrier  ORDER BY Carrier LIMIT 21"]}
{"sql":"SELECT TaxiOut, OriginAirportID, MIN(DivAirportLandings) FROM mytable WHERE DestAirportSeqID > 1334205 GROUP BY TaxiOut, OriginAirportID  ORDER BY TaxiOut, OriginAirportID LIMIT 10","hsqls":["SELECT TaxiOut, OriginAirportID, MIN(DivAirportLandings) FROM mytable WHERE DestAirportSeqID > 1334205 GROUP BY TaxiOut, OriginAirportID  ORDER BY TaxiOut, OriginAirportID LIMIT 10"]}
{"sql":"SELECT DestState, COUNT(*) FROM mytable WHERE DepDelayMinutes IN (108.0, 58.0, 21.0, 375.0, 153.0) OR OriginStateName NOT IN ('Massachusetts', 'South Dakota') AND CRSElapsedTime = 352 GROUP BY DestState  ORDER BY DestState LIMIT 17","hsqls":["SELECT DestState, COUNT(*) FROM mytable WHERE DepDelayMinutes IN (108.0, 58.0, 21.0, 375.0, 153.0) OR OriginStateName NOT IN ('Massachusetts', 'South Dakota') AND CRSElapsedTime = 352 GROUP BY DestState  ORDER BY DestState LIMIT 17"]}
{"sql":"SELECT OriginStateName FROM mytable WHERE DaysSinceEpoch NOT IN (16099, 16077, 16079) OR DestCityMarketID >= 32016 OR WeatherDelay BETWEEN 98 AND 237 ORDER BY DepTimeBlk LIMIT 11"}
{"sql":"SELECT AVG(DayOfWeek), MAX(Diverted) FROM mytable WHERE DivAirportSeqIDs >= 1281902 OR DestAirportSeqID NOT IN (1463502, 1530402, 1068502) AND DepDelayMinutes BETWEEN 48.0 AND 94.0 LIMIT 18","hsqls":["SELECT AVG(DayOfWeek), MAX(Diverted)  FROM mytable WHERE (DivAirportSeqIDs[1] >= 1281902 OR DivAirportSeqIDs[2] >= 1281902 OR DivAirportSeqIDs[3] >= 1281902 OR DivAirportSeqIDs[4] >= 1281902 OR DivAirportSeqIDs[5] >= 1281902) OR DestAirportSeqID NOT IN (1463502, 1530402, 1068502) AND DepDelayMinutes BETWEEN 48.0 AND 94.0 LIMIT 10000"]}
{"sql":"SELECT OriginState, DivAirportIDs FROM mytable WHERE ArrDelayMinutes BETWEEN 190.0 AND 320.0 AND Dest <= 'CMH' ORDER BY Diverted, DayOfWeek LIMIT 10","hsqls":["SELECT OriginState, DivAirportIDs FROM mytable WHERE ArrDelayMinutes BETWEEN 190.0 AND 320.0 AND Dest <= 'CMH' ORDER BY Diverted, DayOfWeek LIMIT 10000"]}
{"sql":"SELECT TaxiOut, FirstDepTime, ArrDelay, COUNT(*) FROM mytable WHERE DivAirportIDs >= 13158 GROUP BY TaxiOut, FirstDepTime, ArrDelay LIMIT 29","hsqls":["SELECT TaxiOut, FirstDepTime, ArrDelay, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] >= 13158 OR DivAirportIDs[2] >= 13158 OR DivAirportIDs[3] >= 13158 OR DivAirportIDs[4] >= 13158 OR DivAirportIDs[5] >= 13158) GROUP BY TaxiOut, FirstDepTime, ArrDelay LIMIT 10000"]}
{"sql":"SELECT OriginState, AVG(DestAirportSeqID), MIN(FlightNum) FROM mytable WHERE ArrDelay <> 165.0 AND DayOfWeek >= 4 GROUP BY OriginState  ORDER BY OriginState LIMIT 1","hsqls":["SELECT OriginState, AVG(DestAirportSeqID), MIN(FlightNum) FROM mytable WHERE ArrDelay <> 165.0 AND DayOfWeek >= 4 GROUP BY OriginState  ORDER BY OriginState LIMIT 1"]}
{"sql":"SELECT CRSElapsedTime, COUNT(Diverted), AVG(WheelsOn), MAX(OriginStateFips) FROM mytable WHERE NASDelay BETWEEN 146 AND 150 AND DivWheelsOns = 1558 OR NASDelay < 29 GROUP BY CRSElapsedTime LIMIT 21","hsqls":["SELECT CRSElapsedTime, COUNT(Diverted), AVG(WheelsOn), MAX(OriginStateFips) FROM mytable WHERE NASDelay BETWEEN 146 AND 150 AND (DivWheelsOns[1] = 1558 OR DivWheelsOns[2] = 1558 OR DivWheelsOns[3] = 1558 OR DivWheelsOns[4] = 1558 OR DivWheelsOns[5] = 1558) OR NASDelay < 29 GROUP BY CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DestStateFips, DayOfWeek FROM mytable WHERE DivActualElapsedTime BETWEEN 231 AND 989 ORDER BY DepDelay LIMIT 24"}
{"sql":"SELECT DivTailNums, ArrDel15 FROM mytable WHERE OriginCityMarketID IN (34986, 34113, 30141, 31517, 30476) AND DivAirports BETWEEN 'SGF' AND 'SPS' ORDER BY TotalAddGTime, DestStateName LIMIT 9","hsqls":["SELECT DivTailNums, ArrDel15 FROM mytable WHERE OriginCityMarketID IN (34986, 34113, 30141, 31517, 30476) AND (DivAirports[1] BETWEEN 'SGF' AND 'SPS' OR DivAirports[2] BETWEEN 'SGF' AND 'SPS' OR DivAirports[3] BETWEEN 'SGF' AND 'SPS' OR DivAirports[4] BETWEEN 'SGF' AND 'SPS' OR DivAirports[5] BETWEEN 'SGF' AND 'SPS') ORDER BY TotalAddGTime, DestStateName LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns, NASDelay FROM mytable WHERE WheelsOff > 1554 LIMIT 20","hsqls":["SELECT DivWheelsOns, NASDelay FROM mytable WHERE WheelsOff > 1554 LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, ArrDel15, AVG(DestStateFips), MAX(DayofMonth) FROM mytable WHERE ArrivalDelayGroups IN (10, -9999) OR WheelsOn NOT IN (1133, 1903, 1855) GROUP BY LateAircraftDelay, ArrDel15  ORDER BY LateAircraftDelay, ArrDel15 LIMIT 2","hsqls":["SELECT LateAircraftDelay, ArrDel15, AVG(DestStateFips), MAX(DayofMonth) FROM mytable WHERE ArrivalDelayGroups IN (10, -9999) OR WheelsOn NOT IN (1133, 1903, 1855) GROUP BY LateAircraftDelay, ArrDel15  ORDER BY LateAircraftDelay, ArrDel15 LIMIT 2"]}
{"sql":"SELECT OriginAirportSeqID, TaxiIn, ArrivalDelayGroups FROM mytable WHERE OriginStateName BETWEEN 'Kansas' AND 'Louisiana' ORDER BY TailNum, AirlineID LIMIT 26"}
{"sql":"SELECT ArrDel15, OriginWac, ArrivalDelayGroups FROM mytable ORDER BY DestState, TailNum, OriginAirportID LIMIT 5"}
{"sql":"SELECT OriginCityName, CancellationCode FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 AND DestState <= 'KY' AND OriginAirportID BETWEEN 10185 AND 12819 LIMIT 5","hsqls":["SELECT OriginCityName, CancellationCode FROM mytable WHERE `Month` BETWEEN 1 AND 1 AND DestState <= 'KY' AND OriginAirportID BETWEEN 10185 AND 12819 LIMIT 5"]}
{"sql":"SELECT Carrier FROM mytable ORDER BY DestStateName, TailNum LIMIT 23"}
{"sql":"SELECT DepDelay FROM mytable WHERE DepDelayMinutes NOT IN (104.0) AND TaxiOut BETWEEN 70 AND 47 AND DivLongestGTimes IN (36.0, 112.0, 29.0, 139.0) ORDER BY DestAirportSeqID, CancellationCode, AirTime LIMIT 11","hsqls":["SELECT DepDelay FROM mytable WHERE DepDelayMinutes NOT IN (104.0) AND TaxiOut BETWEEN 70 AND 47 AND (DivLongestGTimes[1] IN (36.0, 112.0, 29.0, 139.0) OR DivLongestGTimes[2] IN (36.0, 112.0, 29.0, 139.0) OR DivLongestGTimes[3] IN (36.0, 112.0, 29.0, 139.0) OR DivLongestGTimes[4] IN (36.0, 112.0, 29.0, 139.0) OR DivLongestGTimes[5] IN (36.0, 112.0, 29.0, 139.0)) ORDER BY DestAirportSeqID, CancellationCode, AirTime LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DivAirportLandings, DivTotalGTimes FROM mytable WHERE CancellationCode = 'noodles' OR TaxiOut IN (78, 25, 37, 12) ORDER BY ArrDelayMinutes, ArrDel15, OriginStateName LIMIT 5","hsqls":["SELECT WheelsOff, DivAirportLandings, DivTotalGTimes FROM mytable WHERE CancellationCode = 'noodles' OR TaxiOut IN (78, 25, 37, 12) ORDER BY ArrDelayMinutes, ArrDel15, OriginStateName LIMIT 10000"]}
{"sql":"SELECT Diverted, LateAircraftDelay, DestStateFips, AVG(DistanceGroup), MIN(TaxiOut) FROM mytable WHERE DivArrDelay BETWEEN 277 AND 93 AND \"Month\" = 1 OR Flights BETWEEN 1 AND 1 GROUP BY Diverted, LateAircraftDelay, DestStateFips LIMIT 10","hsqls":["SELECT Diverted, LateAircraftDelay, DestStateFips, AVG(DistanceGroup), MIN(TaxiOut) FROM mytable WHERE DivArrDelay BETWEEN 277 AND 93 AND `Month` = 1 OR Flights BETWEEN 1 AND 1 GROUP BY Diverted, LateAircraftDelay, DestStateFips LIMIT 10"]}
{"sql":"SELECT OriginCityMarketID, DayofMonth FROM mytable WHERE Dest BETWEEN 'MOD' AND 'RNO' AND DepartureDelayGroups BETWEEN 10 AND 12 LIMIT 14"}
{"sql":"SELECT ArrTime, DivAirportLandings, COUNT(CRSArrTime) FROM mytable GROUP BY ArrTime, DivAirportLandings","hsqls":["SELECT ArrTime, DivAirportLandings, COUNT(CRSArrTime) FROM mytable GROUP BY ArrTime, DivAirportLandings"]}
{"sql":"SELECT Flights FROM mytable WHERE NASDelay IN (30, 107) AND DestWac BETWEEN 81 AND 64 AND DepartureDelayGroups >= -9999 ORDER BY DestCityMarketID, CRSDepTime, DayOfWeek LIMIT 10"}
{"sql":"SELECT LateAircraftDelay, Dest FROM mytable WHERE OriginStateFips BETWEEN 20 AND 47 AND Flights IN (1) ORDER BY TaxiOut, \"Year\", Diverted LIMIT 5","hsqls":["SELECT LateAircraftDelay, Dest FROM mytable WHERE OriginStateFips BETWEEN 20 AND 47 AND Flights IN (1) ORDER BY TaxiOut, Year, Diverted LIMIT 5"]}
{"sql":"SELECT DestCityName, AirTime, MIN(Flights), SUM(TaxiIn) FROM mytable WHERE TailNum BETWEEN 'N3757D' AND 'N551UA' OR DivWheelsOffs IN (1110, 2350, 1151) GROUP BY DestCityName, AirTime LIMIT 13","hsqls":["SELECT DestCityName, AirTime, MIN(Flights), SUM(TaxiIn) FROM mytable WHERE TailNum BETWEEN 'N3757D' AND 'N551UA' OR (DivWheelsOffs[1] IN (1110, 2350, 1151) OR DivWheelsOffs[2] IN (1110, 2350, 1151) OR DivWheelsOffs[3] IN (1110, 2350, 1151) OR DivWheelsOffs[4] IN (1110, 2350, 1151) OR DivWheelsOffs[5] IN (1110, 2350, 1151)) GROUP BY DestCityName, AirTime LIMIT 10000"]}
{"sql":"SELECT ArrDelay, MIN(CRSElapsedTime) FROM mytable WHERE Diverted = 0 OR DivArrDelay NOT IN (183, 472, 119) GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 1","hsqls":["SELECT ArrDelay, MIN(CRSElapsedTime) FROM mytable WHERE Diverted = 0 OR DivArrDelay NOT IN (183, 472, 119) GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 1"]}
{"sql":"SELECT DestCityName, ArrDel15, DivArrDelay FROM mytable WHERE AirlineID NOT IN (20304, 19790, 19805) AND FlightDate = '2014-01-09' ORDER BY ArrTime, NASDelay, AirlineID LIMIT 10"}
{"sql":"SELECT DistanceGroup, WeatherDelay, DepTime, SUM(ArrDelay), AVG(Distance), AVG(DivArrDelay) FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) GROUP BY DistanceGroup, WeatherDelay, DepTime  ORDER BY DistanceGroup, WeatherDelay, DepTime LIMIT 22","hsqls":["SELECT DistanceGroup, WeatherDelay, DepTime, SUM(ArrDelay), AVG(Distance), AVG(DivArrDelay) FROM mytable WHERE DivReachedDest NOT IN (1, 0, -9999) GROUP BY DistanceGroup, WeatherDelay, DepTime  ORDER BY DistanceGroup, WeatherDelay, DepTime LIMIT 22"]}
{"sql":"SELECT FlightDate, COUNT(FirstDepTime), MIN(DaysSinceEpoch), COUNT(OriginState) FROM mytable GROUP BY FlightDate  ORDER BY FlightDate LIMIT 23","hsqls":["SELECT FlightDate, COUNT(FirstDepTime), MIN(DaysSinceEpoch), COUNT(OriginState) FROM mytable GROUP BY FlightDate  ORDER BY FlightDate LIMIT 23"]}
{"sql":"SELECT DivWheelsOffs, OriginWac FROM mytable WHERE Distance NOT IN (1149, 700, 313, 552) OR DaysSinceEpoch = 16078 OR ArrTime BETWEEN 1146 AND 1932 ORDER BY DepTime, Dest, DestStateName LIMIT 8","hsqls":["SELECT DivWheelsOffs, OriginWac FROM mytable WHERE Distance NOT IN (1149, 700, 313, 552) OR DaysSinceEpoch = 16078 OR ArrTime BETWEEN 1146 AND 1932 ORDER BY DepTime, Dest, DestStateName LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrTime > 818 LIMIT 13"}
{"sql":"SELECT OriginState, ActualElapsedTime, DestAirportID FROM mytable ORDER BY DepDelayMinutes, TotalAddGTime, CancellationCode LIMIT 10"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivAirportLandings = 1 AND DivActualElapsedTime BETWEEN 284 AND 234 LIMIT 11"}
{"sql":"SELECT Distance FROM mytable WHERE DestState IN ('OH', 'PA', 'OR', 'KS') AND ArrTimeBlk BETWEEN '1900-1959' AND '0001-0559' LIMIT 16"}
{"sql":"SELECT CancellationCode, COUNT(FlightNum), SUM(Distance) FROM mytable WHERE FlightNum BETWEEN 326 AND 4697 OR DistanceGroup > 9 GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 6","hsqls":["SELECT CancellationCode, COUNT(FlightNum), SUM(Distance) FROM mytable WHERE FlightNum BETWEEN 326 AND 4697 OR DistanceGroup > 9 GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 6"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Distance = 423 OR OriginStateFips NOT IN (16) OR Diverted NOT IN (1, 0) LIMIT 27"}
{"sql":"SELECT ArrTime, DestCityMarketID FROM mytable"}
{"sql":"SELECT DepTime, DepDel15 FROM mytable WHERE DivArrDelay BETWEEN 378 AND 289 AND DestStateFips NOT IN (31, 33) ORDER BY DestAirportSeqID LIMIT 19"}
{"sql":"SELECT DivDistance, OriginCityMarketID, DivAirportLandings, SUM(CRSDepTime) FROM mytable WHERE FlightDate >= '2014-01-25' OR Diverted <= 1 GROUP BY DivDistance, OriginCityMarketID, DivAirportLandings  ORDER BY DivDistance, OriginCityMarketID, DivAirportLandings LIMIT 23","hsqls":["SELECT DivDistance, OriginCityMarketID, DivAirportLandings, SUM(CRSDepTime) FROM mytable WHERE FlightDate >= '2014-01-25' OR Diverted <= 1 GROUP BY DivDistance, OriginCityMarketID, DivAirportLandings  ORDER BY DivDistance, OriginCityMarketID, DivAirportLandings LIMIT 23"]}
{"sql":"SELECT DestAirportSeqID, ArrDelayMinutes, DestStateName FROM mytable ORDER BY CarrierDelay, Origin, DivAirportLandings LIMIT 5"}
{"sql":"SELECT AVG(TaxiIn), SUM(DestWac), AVG(DivAirportLandings) FROM mytable WHERE DivWheelsOffs BETWEEN 1217 AND 1849 OR DivActualElapsedTime BETWEEN 350 AND 399 OR DestAirportID BETWEEN 12992 AND 10666 LIMIT 28","hsqls":["SELECT AVG(TaxiIn), SUM(DestWac), AVG(DivAirportLandings)  FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1217 AND 1849 OR DivWheelsOffs[2] BETWEEN 1217 AND 1849 OR DivWheelsOffs[3] BETWEEN 1217 AND 1849 OR DivWheelsOffs[4] BETWEEN 1217 AND 1849 OR DivWheelsOffs[5] BETWEEN 1217 AND 1849) OR DivActualElapsedTime BETWEEN 350 AND 399 OR DestAirportID BETWEEN 12992 AND 10666 LIMIT 10000"]}
{"sql":"SELECT CRSArrTime FROM mytable WHERE ActualElapsedTime = 341"}
{"sql":"SELECT TaxiOut FROM mytable WHERE ArrTime BETWEEN 1921 AND 2327 LIMIT 23"}
{"sql":"SELECT OriginCityMarketID, ArrTimeBlk, AirlineID, MAX(DestCityMarketID), MAX(AirTime) FROM mytable GROUP BY OriginCityMarketID, ArrTimeBlk, AirlineID  ORDER BY OriginCityMarketID, ArrTimeBlk, AirlineID LIMIT 15","hsqls":["SELECT OriginCityMarketID, ArrTimeBlk, AirlineID, MAX(DestCityMarketID), MAX(AirTime) FROM mytable GROUP BY OriginCityMarketID, ArrTimeBlk, AirlineID  ORDER BY OriginCityMarketID, ArrTimeBlk, AirlineID LIMIT 15"]}
{"sql":"SELECT CancellationCode, UniqueCarrier, DivArrDelay FROM mytable WHERE FlightNum IN (5527, 2418, 1305) OR LateAircraftDelay <= 8 ORDER BY Distance, AirlineID LIMIT 10"}
{"sql":"SELECT DestWac, TailNum, DepDel15 FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 9 LIMIT 20"}
{"sql":"SELECT DivAirports, LongestAddGTime, DestCityMarketID FROM mytable WHERE DestCityMarketID BETWEEN 31638 AND 35841 ORDER BY \"Year\", OriginStateFips, Origin LIMIT 10","hsqls":["SELECT DivAirports, LongestAddGTime, DestCityMarketID FROM mytable WHERE DestCityMarketID BETWEEN 31638 AND 35841 ORDER BY Year, OriginStateFips, Origin LIMIT 10000"]}
{"sql":"SELECT Carrier FROM mytable WHERE ArrDelayMinutes IN (147.0, 88.0, 94.0) AND OriginAirportID IN (14831) OR AirlineID = 19690 ORDER BY ActualElapsedTime LIMIT 13"}
{"sql":"SELECT ActualElapsedTime, DayofMonth, MIN(CRSElapsedTime) FROM mytable WHERE DestStateName NOT IN ('Colorado') AND DepTimeBlk < '1300-1359' AND DestStateName BETWEEN 'U.S. Virgin Islands' AND 'New Mexico' GROUP BY ActualElapsedTime, DayofMonth  ORDER BY ActualElapsedTime, DayofMonth LIMIT 21","hsqls":["SELECT ActualElapsedTime, DayofMonth, MIN(CRSElapsedTime) FROM mytable WHERE DestStateName NOT IN ('Colorado') AND DepTimeBlk < '1300-1359' AND DestStateName BETWEEN 'U.S. Virgin Islands' AND 'New Mexico' GROUP BY ActualElapsedTime, DayofMonth  ORDER BY ActualElapsedTime, DayofMonth LIMIT 21"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivTailNums <= 'N336AA' AND DivAirports IN ('PHL', 'ROA', 'MSY', 'ONT', 'CWA') LIMIT 19","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivTailNums[1] <= 'N336AA' OR DivTailNums[2] <= 'N336AA' OR DivTailNums[3] <= 'N336AA' OR DivTailNums[4] <= 'N336AA' OR DivTailNums[5] <= 'N336AA') AND (DivAirports[1] IN ('PHL', 'ROA', 'MSY', 'ONT', 'CWA') OR DivAirports[2] IN ('PHL', 'ROA', 'MSY', 'ONT', 'CWA') OR DivAirports[3] IN ('PHL', 'ROA', 'MSY', 'ONT', 'CWA') OR DivAirports[4] IN ('PHL', 'ROA', 'MSY', 'ONT', 'CWA') OR DivAirports[5] IN ('PHL', 'ROA', 'MSY', 'ONT', 'CWA')) LIMIT 10000"]}
{"sql":"SELECT DivDistance, DepTime, Origin, SUM(DayofMonth) FROM mytable WHERE DivWheelsOns IN (2130) GROUP BY DivDistance, DepTime, Origin LIMIT 7","hsqls":["SELECT DivDistance, DepTime, Origin, SUM(DayofMonth) FROM mytable WHERE (DivWheelsOns[1] IN (2130) OR DivWheelsOns[2] IN (2130) OR DivWheelsOns[3] IN (2130) OR DivWheelsOns[4] IN (2130) OR DivWheelsOns[5] IN (2130)) GROUP BY DivDistance, DepTime, Origin LIMIT 10000"]}
{"sql":"SELECT DivAirportIDs, DivTotalGTimes FROM mytable WHERE TaxiOut IN (42, 19, 83) OR TotalAddGTime < -9999 AND Flights NOT IN (1) ORDER BY NASDelay LIMIT 7","hsqls":["SELECT DivAirportIDs, DivTotalGTimes FROM mytable WHERE TaxiOut IN (42, 19, 83) OR TotalAddGTime < -9999 AND Flights NOT IN (1) ORDER BY NASDelay LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE SecurityDelay NOT IN (10, 0, 18, 14, -9999) OR ArrTime BETWEEN 1051 AND 604 OR DestWac IN (81) LIMIT 2"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 20"}
{"sql":"SELECT TailNum, CRSElapsedTime, DayOfWeek FROM mytable ORDER BY LateAircraftDelay, ArrDelay, CRSDepTime LIMIT 27"}
{"sql":"SELECT ArrTimeBlk FROM mytable ORDER BY NASDelay, DayofMonth, OriginWac LIMIT 27"}
{"sql":"SELECT DivWheelsOns, CancellationCode, DivTotalGTimes FROM mytable WHERE OriginWac BETWEEN 82 AND 73 ORDER BY OriginCityMarketID, OriginCityName LIMIT 1","hsqls":["SELECT DivWheelsOns, CancellationCode, DivTotalGTimes FROM mytable WHERE OriginWac BETWEEN 82 AND 73 ORDER BY OriginCityMarketID, OriginCityName LIMIT 10000"]}
{"sql":"SELECT OriginState, ArrDel15 FROM mytable WHERE OriginCityMarketID IN (33851, 32457, 31871, 31721) LIMIT 5"}
{"sql":"SELECT CRSElapsedTime, MAX(CarrierDelay), SUM(DaysSinceEpoch), SUM(OriginCityMarketID) FROM mytable WHERE TaxiIn IN (21, 175, 33, 39) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 29","hsqls":["SELECT CRSElapsedTime, MAX(CarrierDelay), SUM(DaysSinceEpoch), SUM(OriginCityMarketID) FROM mytable WHERE TaxiIn IN (21, 175, 33, 39) GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 29"]}
{"sql":"SELECT \"Year\", LateAircraftDelay, CRSDepTime, COUNT(*) FROM mytable GROUP BY \"Year\", LateAircraftDelay, CRSDepTime LIMIT 26","hsqls":["SELECT Year, LateAircraftDelay, CRSDepTime, COUNT(*) FROM mytable GROUP BY Year, LateAircraftDelay, CRSDepTime LIMIT 26"]}
{"sql":"SELECT WheelsOff, LateAircraftDelay, DepDel15 FROM mytable ORDER BY AirTime LIMIT 10"}
{"sql":"SELECT DivLongestGTimes, DivAirportSeqIDs, ArrivalDelayGroups FROM mytable WHERE TotalAddGTime BETWEEN 42 AND 38 ORDER BY DestWac, TotalAddGTime, ArrTimeBlk LIMIT 8","hsqls":["SELECT DivLongestGTimes, DivAirportSeqIDs, ArrivalDelayGroups FROM mytable WHERE TotalAddGTime BETWEEN 42 AND 38 ORDER BY DestWac, TotalAddGTime, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT TaxiOut, Carrier, Dest, COUNT(DayOfWeek), SUM(ArrDelay) FROM mytable GROUP BY TaxiOut, Carrier, Dest  ORDER BY TaxiOut, Carrier, Dest LIMIT 29","hsqls":["SELECT TaxiOut, Carrier, Dest, COUNT(DayOfWeek), SUM(ArrDelay) FROM mytable GROUP BY TaxiOut, Carrier, Dest  ORDER BY TaxiOut, Carrier, Dest LIMIT 29"]}
{"sql":"SELECT DayOfWeek, AVG(Cancelled) FROM mytable WHERE DestStateName NOT IN ('Nevada') GROUP BY DayOfWeek  ORDER BY DayOfWeek LIMIT 18","hsqls":["SELECT DayOfWeek, AVG(Cancelled) FROM mytable WHERE DestStateName NOT IN ('Nevada') GROUP BY DayOfWeek  ORDER BY DayOfWeek LIMIT 18"]}
{"sql":"SELECT SUM(DivAirportLandings) FROM mytable WHERE OriginStateName <= 'Arkansas' LIMIT 22"}
{"sql":"SELECT DepDelayMinutes, AirlineID, \"Month\", AVG(DestAirportSeqID), MIN(ArrDel15) FROM mytable WHERE ArrTime <= 16 GROUP BY DepDelayMinutes, AirlineID, \"Month\" LIMIT 10","hsqls":["SELECT DepDelayMinutes, AirlineID, Month, AVG(DestAirportSeqID), MIN(ArrDel15) FROM mytable WHERE ArrTime <= 16 GROUP BY DepDelayMinutes, AirlineID, `Month` LIMIT 10"]}
{"sql":"SELECT Distance, OriginStateName FROM mytable ORDER BY DestWac, Quarter LIMIT 22"}
{"sql":"SELECT AVG(\"Year\"), MIN(AirTime) FROM mytable WHERE Diverted BETWEEN 0 AND 1 AND CarrierDelay IN (149, 72, 86) AND ArrivalDelayGroups IN (1, 7, 4, 11) LIMIT 12","hsqls":["SELECT AVG(`Year`), MIN(AirTime) FROM mytable WHERE Diverted BETWEEN 0 AND 1 AND CarrierDelay IN (149, 72, 86) AND ArrivalDelayGroups IN (1, 7, 4, 11) LIMIT 12"]}
{"sql":"SELECT Cancelled, DestAirportID, AVG(DestStateFips), MAX(FirstDepTime) FROM mytable WHERE ArrivalDelayGroups BETWEEN 6 AND 3 GROUP BY Cancelled, DestAirportID  ORDER BY Cancelled, DestAirportID LIMIT 8","hsqls":["SELECT Cancelled, DestAirportID, AVG(DestStateFips), MAX(FirstDepTime) FROM mytable WHERE ArrivalDelayGroups BETWEEN 6 AND 3 GROUP BY Cancelled, DestAirportID  ORDER BY Cancelled, DestAirportID LIMIT 8"]}
{"sql":"SELECT LongestAddGTime, FlightDate, DepTime, MIN(LateAircraftDelay), MAX(OriginAirportID), SUM(DestCityMarketID) FROM mytable WHERE TaxiIn BETWEEN 56 AND 93 GROUP BY LongestAddGTime, FlightDate, DepTime  ORDER BY LongestAddGTime, FlightDate, DepTime LIMIT 19","hsqls":["SELECT LongestAddGTime, FlightDate, DepTime, MIN(LateAircraftDelay), MAX(OriginAirportID), SUM(DestCityMarketID) FROM mytable WHERE TaxiIn BETWEEN 56 AND 93 GROUP BY LongestAddGTime, FlightDate, DepTime  ORDER BY LongestAddGTime, FlightDate, DepTime LIMIT 19"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 4"}
{"sql":"SELECT DepDelay FROM mytable ORDER BY DepartureDelayGroups, OriginAirportSeqID LIMIT 11"}
{"sql":"SELECT TailNum FROM mytable WHERE OriginAirportID BETWEEN 10257 AND 10561 OR AirTime IN (349, 289, 121, 356, 139) ORDER BY DestWac, DayofMonth, OriginStateName LIMIT 9"}
{"sql":"SELECT FlightDate, TotalAddGTime, COUNT(*) FROM mytable WHERE ArrDelayMinutes IN (3.0, 59.0, 100.0, 124.0, 173.0) AND LateAircraftDelay <= 109 OR DivAirports IN ('IAD', 'GGG', 'LGA') GROUP BY FlightDate, TotalAddGTime LIMIT 19","hsqls":["SELECT FlightDate, TotalAddGTime, COUNT(*) FROM mytable WHERE ArrDelayMinutes IN (3.0, 59.0, 100.0, 124.0, 173.0) AND LateAircraftDelay <= 109 OR (DivAirports[1] IN ('IAD', 'GGG', 'LGA') OR DivAirports[2] IN ('IAD', 'GGG', 'LGA') OR DivAirports[3] IN ('IAD', 'GGG', 'LGA') OR DivAirports[4] IN ('IAD', 'GGG', 'LGA') OR DivAirports[5] IN ('IAD', 'GGG', 'LGA')) GROUP BY FlightDate, TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT Flights, CarrierDelay FROM mytable WHERE DepDel15 <= 1 ORDER BY DepDelayMinutes, WheelsOn LIMIT 1"}
{"sql":"SELECT AVG(DepDel15), SUM(OriginStateFips) FROM mytable WHERE DepDelayMinutes IN (126.0, 334.0) OR ArrTime NOT IN (1510, 2254) OR CancellationCode NOT IN ('A', 'B', 'C', 'noodles') LIMIT 10"}
{"sql":"SELECT ArrTime, CancellationCode, MIN(OriginAirportSeqID), COUNT(AirlineID) FROM mytable WHERE TaxiIn = 44 AND DivAirportIDs IN (12323) GROUP BY ArrTime, CancellationCode LIMIT 4","hsqls":["SELECT ArrTime, CancellationCode, MIN(OriginAirportSeqID), COUNT(AirlineID) FROM mytable WHERE TaxiIn = 44 AND (DivAirportIDs[1] IN (12323) OR DivAirportIDs[2] IN (12323) OR DivAirportIDs[3] IN (12323) OR DivAirportIDs[4] IN (12323) OR DivAirportIDs[5] IN (12323)) GROUP BY ArrTime, CancellationCode LIMIT 10000"]}
{"sql":"SELECT Diverted, NASDelay, OriginStateName FROM mytable ORDER BY OriginAirportID LIMIT 9"}
{"sql":"SELECT DepDelay, CarrierDelay, DestCityName, COUNT(*) FROM mytable WHERE DayOfWeek <> 4 AND \"Year\" BETWEEN 2014 AND 2014 AND CRSArrTime <> 1834 GROUP BY DepDelay, CarrierDelay, DestCityName LIMIT 26","hsqls":["SELECT DepDelay, CarrierDelay, DestCityName, COUNT(*) FROM mytable WHERE DayOfWeek <> 4 AND `Year` BETWEEN 2014 AND 2014 AND CRSArrTime <> 1834 GROUP BY DepDelay, CarrierDelay, DestCityName LIMIT 26"]}
{"sql":"SELECT DepTime FROM mytable LIMIT 22"}
{"sql":"SELECT Cancelled FROM mytable WHERE ArrDelay < 192.0 ORDER BY ArrDelayMinutes, Cancelled, DestCityMarketID LIMIT 14"}
{"sql":"SELECT DivDistance, Origin FROM mytable WHERE DayOfWeek < 2 AND TaxiIn <> 96 AND DivWheelsOffs = 1831 ORDER BY Quarter, CRSArrTime LIMIT 28","hsqls":["SELECT DivDistance, Origin FROM mytable WHERE DayOfWeek < 2 AND TaxiIn <> 96 AND (DivWheelsOffs[1] = 1831 OR DivWheelsOffs[2] = 1831 OR DivWheelsOffs[3] = 1831 OR DivWheelsOffs[4] = 1831 OR DivWheelsOffs[5] = 1831) ORDER BY Quarter, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT MIN(DepDelayMinutes), MIN(DaysSinceEpoch), MAX(DivReachedDest) FROM mytable LIMIT 12"}
{"sql":"SELECT DestState FROM mytable ORDER BY ArrTimeBlk, DestStateName, AirlineID LIMIT 23"}
{"sql":"SELECT DepartureDelayGroups, Cancelled, \"Month\" FROM mytable ORDER BY FirstDepTime, DestAirportSeqID, DestAirportID LIMIT 24","hsqls":["SELECT DepartureDelayGroups, Cancelled, `Month` FROM mytable ORDER BY FirstDepTime, DestAirportSeqID, DestAirportID LIMIT 24"]}
{"sql":"SELECT FlightDate, \"Month\", COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'F9' AND 'WN' AND ArrTimeBlk <> '2000-2059' GROUP BY FlightDate, \"Month\" LIMIT 10","hsqls":["SELECT FlightDate, Month, COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'F9' AND 'WN' AND ArrTimeBlk <> '2000-2059' GROUP BY FlightDate, `Month` LIMIT 10"]}
{"sql":"SELECT DestState, DestStateFips, ArrTime, COUNT(ArrTimeBlk), MAX(DivReachedDest) FROM mytable WHERE AirlineID BETWEEN 19790 AND 19805 AND DivDistance BETWEEN 814 AND 1029 AND DivDistance <= 842 GROUP BY DestState, DestStateFips, ArrTime  ORDER BY DestState, DestStateFips, ArrTime LIMIT 25","hsqls":["SELECT DestState, DestStateFips, ArrTime, COUNT(ArrTimeBlk), MAX(DivReachedDest) FROM mytable WHERE AirlineID BETWEEN 19790 AND 19805 AND DivDistance BETWEEN 814 AND 1029 AND DivDistance <= 842 GROUP BY DestState, DestStateFips, ArrTime  ORDER BY DestState, DestStateFips, ArrTime LIMIT 25"]}
{"sql":"SELECT DivReachedDest FROM mytable WHERE Distance IN (384, 645) LIMIT 17"}
{"sql":"SELECT DivLongestGTimes, CRSArrTime, DayOfWeek FROM mytable WHERE ArrTimeBlk IN ('1200-1259', '0001-0559') ORDER BY DestStateName LIMIT 12","hsqls":["SELECT DivLongestGTimes, CRSArrTime, DayOfWeek FROM mytable WHERE ArrTimeBlk IN ('1200-1259', '0001-0559') ORDER BY DestStateName LIMIT 10000"]}
{"sql":"SELECT DestState, Distance, OriginWac, AVG(LateAircraftDelay), AVG(Flights) FROM mytable WHERE DivWheelsOffs BETWEEN 1045 AND 1348 GROUP BY DestState, Distance, OriginWac LIMIT 24","hsqls":["SELECT DestState, Distance, OriginWac, AVG(LateAircraftDelay), AVG(Flights) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1045 AND 1348 OR DivWheelsOffs[2] BETWEEN 1045 AND 1348 OR DivWheelsOffs[3] BETWEEN 1045 AND 1348 OR DivWheelsOffs[4] BETWEEN 1045 AND 1348 OR DivWheelsOffs[5] BETWEEN 1045 AND 1348) GROUP BY DestState, Distance, OriginWac LIMIT 10000"]}
{"sql":"SELECT OriginState, TailNum, AirlineID, COUNT(SecurityDelay) FROM mytable WHERE DivAirports >= 'FWA' OR ArrivalDelayGroups > 2 OR OriginAirportSeqID NOT IN (1288903, 1323202, 1348602, 1389101, 1469802) GROUP BY OriginState, TailNum, AirlineID LIMIT 21","hsqls":["SELECT OriginState, TailNum, AirlineID, COUNT(SecurityDelay) FROM mytable WHERE (DivAirports[1] >= 'FWA' OR DivAirports[2] >= 'FWA' OR DivAirports[3] >= 'FWA' OR DivAirports[4] >= 'FWA' OR DivAirports[5] >= 'FWA') OR ArrivalDelayGroups > 2 OR OriginAirportSeqID NOT IN (1288903, 1323202, 1348602, 1389101, 1469802) GROUP BY OriginState, TailNum, AirlineID LIMIT 10000"]}
{"sql":"SELECT FlightDate, ArrTimeBlk, ArrivalDelayGroups FROM mytable LIMIT 18"}
{"sql":"SELECT AirlineID, WheelsOn, DivActualElapsedTime FROM mytable WHERE ArrDel15 BETWEEN -9999 AND -9999 LIMIT 14"}
{"sql":"SELECT MAX(WeatherDelay) FROM mytable WHERE DestAirportID BETWEEN 10431 AND 12441 AND DayOfWeek IN (2, 1, 6) LIMIT 18"}
{"sql":"SELECT DivReachedDest, ArrTimeBlk, DayofMonth, COUNT(*) FROM mytable GROUP BY DivReachedDest, ArrTimeBlk, DayofMonth  ORDER BY DivReachedDest, ArrTimeBlk, DayofMonth LIMIT 2","hsqls":["SELECT DivReachedDest, ArrTimeBlk, DayofMonth, COUNT(*) FROM mytable GROUP BY DivReachedDest, ArrTimeBlk, DayofMonth  ORDER BY DivReachedDest, ArrTimeBlk, DayofMonth LIMIT 2"]}
{"sql":"SELECT Diverted, COUNT(CRSDepTime), SUM(DestWac) FROM mytable WHERE FlightDate NOT IN ('2014-01-12', '2014-01-28', '2014-01-20', '2014-01-31', '2014-01-30') OR CancellationCode IN ('A') GROUP BY Diverted  ORDER BY Diverted LIMIT 7","hsqls":["SELECT Diverted, COUNT(CRSDepTime), SUM(DestWac) FROM mytable WHERE FlightDate NOT IN ('2014-01-12', '2014-01-28', '2014-01-20', '2014-01-31', '2014-01-30') OR CancellationCode IN ('A') GROUP BY Diverted  ORDER BY Diverted LIMIT 7"]}
{"sql":"SELECT SUM(DivAirportLandings), AVG(CRSArrTime) FROM mytable WHERE DestAirportSeqID >= 1469802 OR CancellationCode BETWEEN 'B' AND 'C' AND Dest BETWEEN 'PIT' AND 'OAJ' LIMIT 24"}
{"sql":"SELECT CRSArrTime, ArrDelay FROM mytable WHERE UniqueCarrier < 'AA' LIMIT 23"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 374 AND 160 AND FlightDate IN ('2014-01-07') LIMIT 4"}
{"sql":"SELECT Diverted, CarrierDelay, ArrDel15, COUNT(*) FROM mytable GROUP BY Diverted, CarrierDelay, ArrDel15  ORDER BY Diverted, CarrierDelay, ArrDel15 LIMIT 9","hsqls":["SELECT Diverted, CarrierDelay, ArrDel15, COUNT(*) FROM mytable GROUP BY Diverted, CarrierDelay, ArrDel15  ORDER BY Diverted, CarrierDelay, ArrDel15 LIMIT 9"]}
{"sql":"SELECT DivAirportSeqIDs FROM mytable WHERE DivAirports IN ('JNU', 'JAX', 'TWF') OR TaxiOut IN (20, 54, 13, 102) LIMIT 4","hsqls":["SELECT DivAirportSeqIDs FROM mytable WHERE (DivAirports[1] IN ('JNU', 'JAX', 'TWF') OR DivAirports[2] IN ('JNU', 'JAX', 'TWF') OR DivAirports[3] IN ('JNU', 'JAX', 'TWF') OR DivAirports[4] IN ('JNU', 'JAX', 'TWF') OR DivAirports[5] IN ('JNU', 'JAX', 'TWF')) OR TaxiOut IN (20, 54, 13, 102) LIMIT 10000"]}
{"sql":"SELECT Quarter, DayOfWeek, SUM(TaxiIn), MAX(ActualElapsedTime), SUM(DivDistance) FROM mytable GROUP BY Quarter, DayOfWeek  ORDER BY Quarter, DayOfWeek LIMIT 6","hsqls":["SELECT Quarter, DayOfWeek, SUM(TaxiIn), MAX(ActualElapsedTime), SUM(DivDistance) FROM mytable GROUP BY Quarter, DayOfWeek  ORDER BY Quarter, DayOfWeek LIMIT 6"]}
{"sql":"SELECT Dest, DayofMonth, MAX(Diverted), AVG(OriginAirportID) FROM mytable GROUP BY Dest, DayofMonth  ORDER BY Dest, DayofMonth LIMIT 10","hsqls":["SELECT Dest, DayofMonth, MAX(Diverted), AVG(OriginAirportID) FROM mytable GROUP BY Dest, DayofMonth  ORDER BY Dest, DayofMonth LIMIT 10"]}
{"sql":"SELECT DestStateName, SUM(LateAircraftDelay), AVG(TaxiIn) FROM mytable WHERE Distance IN (352, 805, 711, 325, 2105) OR ArrDelay BETWEEN 76.0 AND 46.0 GROUP BY DestStateName  ORDER BY DestStateName LIMIT 5","hsqls":["SELECT DestStateName, SUM(LateAircraftDelay), AVG(TaxiIn) FROM mytable WHERE Distance IN (352, 805, 711, 325, 2105) OR ArrDelay BETWEEN 76.0 AND 46.0 GROUP BY DestStateName  ORDER BY DestStateName LIMIT 5"]}
{"sql":"SELECT DivDistance, DivAirportSeqIDs, Dest FROM mytable LIMIT 26","hsqls":["SELECT DivDistance, DivAirportSeqIDs, Dest FROM mytable LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, OriginWac, ArrDelay FROM mytable WHERE DestAirportID >= 14576 OR DestState BETWEEN 'MO' AND 'OR' LIMIT 10"}
{"sql":"SELECT ArrDelayMinutes FROM mytable LIMIT 6"}
{"sql":"SELECT OriginAirportSeqID FROM mytable WHERE TailNum IN ('N784NC', 'N154UW') AND DivAirportSeqIDs BETWEEN 1537002 AND 1289605 ORDER BY DestState, LongestAddGTime","hsqls":["SELECT OriginAirportSeqID FROM mytable WHERE TailNum IN ('N784NC', 'N154UW') AND (DivAirportSeqIDs[1] BETWEEN 1537002 AND 1289605 OR DivAirportSeqIDs[2] BETWEEN 1537002 AND 1289605 OR DivAirportSeqIDs[3] BETWEEN 1537002 AND 1289605 OR DivAirportSeqIDs[4] BETWEEN 1537002 AND 1289605 OR DivAirportSeqIDs[5] BETWEEN 1537002 AND 1289605) ORDER BY DestState, LongestAddGTime LIMIT 10000"]}
{"sql":"SELECT AirlineID, MIN(ArrDelayMinutes), AVG(ActualElapsedTime) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 10","hsqls":["SELECT AirlineID, MIN(ArrDelayMinutes), AVG(ActualElapsedTime) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 10"]}
{"sql":"SELECT WeatherDelay, ArrivalDelayGroups, DivActualElapsedTime, COUNT(*) FROM mytable GROUP BY WeatherDelay, ArrivalDelayGroups, DivActualElapsedTime  ORDER BY WeatherDelay, ArrivalDelayGroups, DivActualElapsedTime LIMIT 10","hsqls":["SELECT WeatherDelay, ArrivalDelayGroups, DivActualElapsedTime, COUNT(*) FROM mytable GROUP BY WeatherDelay, ArrivalDelayGroups, DivActualElapsedTime  ORDER BY WeatherDelay, ArrivalDelayGroups, DivActualElapsedTime LIMIT 10"]}
{"sql":"SELECT OriginState, COUNT(*) FROM mytable WHERE WheelsOn BETWEEN 2243 AND 1132 OR OriginAirportSeqID NOT IN (1161203) AND DivTailNums IN ('N699BR', 'N986CA', 'N345NW', 'N836MQ', 'N389HA') GROUP BY OriginState LIMIT 5","hsqls":["SELECT OriginState, COUNT(*) FROM mytable WHERE WheelsOn BETWEEN 2243 AND 1132 OR OriginAirportSeqID NOT IN (1161203) AND (DivTailNums[1] IN ('N699BR', 'N986CA', 'N345NW', 'N836MQ', 'N389HA') OR DivTailNums[2] IN ('N699BR', 'N986CA', 'N345NW', 'N836MQ', 'N389HA') OR DivTailNums[3] IN ('N699BR', 'N986CA', 'N345NW', 'N836MQ', 'N389HA') OR DivTailNums[4] IN ('N699BR', 'N986CA', 'N345NW', 'N836MQ', 'N389HA') OR DivTailNums[5] IN ('N699BR', 'N986CA', 'N345NW', 'N836MQ', 'N389HA')) GROUP BY OriginState LIMIT 10000"]}
{"sql":"SELECT DepDelay, Cancelled, DestCityMarketID FROM mytable WHERE AirlineID <= 20366 OR DivAirports <= 'FSD' AND DivLongestGTimes IN (-9999.0, 49.0, 79.0, 66.0) LIMIT 3","hsqls":["SELECT DepDelay, Cancelled, DestCityMarketID FROM mytable WHERE AirlineID <= 20366 OR (DivAirports[1] <= 'FSD' OR DivAirports[2] <= 'FSD' OR DivAirports[3] <= 'FSD' OR DivAirports[4] <= 'FSD' OR DivAirports[5] <= 'FSD') AND (DivLongestGTimes[1] IN (-9999.0, 49.0, 79.0, 66.0) OR DivLongestGTimes[2] IN (-9999.0, 49.0, 79.0, 66.0) OR DivLongestGTimes[3] IN (-9999.0, 49.0, 79.0, 66.0) OR DivLongestGTimes[4] IN (-9999.0, 49.0, 79.0, 66.0) OR DivLongestGTimes[5] IN (-9999.0, 49.0, 79.0, 66.0)) LIMIT 10000"]}
{"sql":"SELECT MAX(FirstDepTime), SUM(DestStateFips) FROM mytable WHERE DepTimeBlk BETWEEN '1900-1959' AND '1600-1659' OR TailNum NOT IN ('N584NW') LIMIT 15"}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE DivTailNums <= 'N547UA' OR OriginAirportSeqID BETWEEN 1538003 AND 1163703 ORDER BY DistanceGroup, CRSArrTime LIMIT 25","hsqls":["SELECT DaysSinceEpoch FROM mytable WHERE (DivTailNums[1] <= 'N547UA' OR DivTailNums[2] <= 'N547UA' OR DivTailNums[3] <= 'N547UA' OR DivTailNums[4] <= 'N547UA' OR DivTailNums[5] <= 'N547UA') OR OriginAirportSeqID BETWEEN 1538003 AND 1163703 ORDER BY DistanceGroup, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, DestStateName, MAX(DepDelayMinutes), MIN(DayOfWeek) FROM mytable GROUP BY FirstDepTime, DestStateName  ORDER BY FirstDepTime, DestStateName LIMIT 1","hsqls":["SELECT FirstDepTime, DestStateName, MAX(DepDelayMinutes), MIN(DayOfWeek) FROM mytable GROUP BY FirstDepTime, DestStateName  ORDER BY FirstDepTime, DestStateName LIMIT 1"]}
{"sql":"SELECT AirTime, COUNT(*) FROM mytable WHERE DepDel15 BETWEEN 1 AND 1 AND FlightDate BETWEEN '2014-01-08' AND '2014-01-12' GROUP BY AirTime  ORDER BY AirTime LIMIT 18","hsqls":["SELECT AirTime, COUNT(*) FROM mytable WHERE DepDel15 BETWEEN 1 AND 1 AND FlightDate BETWEEN '2014-01-08' AND '2014-01-12' GROUP BY AirTime  ORDER BY AirTime LIMIT 18"]}
{"sql":"SELECT \"Year\", FlightNum, LongestAddGTime FROM mytable WHERE DivAirportIDs IN (14307, 14689, 10397) OR CarrierDelay >= 21 OR OriginCityMarketID BETWEEN 32467 AND 30631 ORDER BY WheelsOff, Quarter, DepTime LIMIT 29","hsqls":["SELECT Year, FlightNum, LongestAddGTime FROM mytable WHERE (DivAirportIDs[1] IN (14307, 14689, 10397) OR DivAirportIDs[2] IN (14307, 14689, 10397) OR DivAirportIDs[3] IN (14307, 14689, 10397) OR DivAirportIDs[4] IN (14307, 14689, 10397) OR DivAirportIDs[5] IN (14307, 14689, 10397)) OR CarrierDelay >= 21 OR OriginCityMarketID BETWEEN 32467 AND 30631 ORDER BY WheelsOff, Quarter, DepTime LIMIT 10000"]}
{"sql":"SELECT DestState FROM mytable ORDER BY Flights, DepTime, UniqueCarrier LIMIT 21"}
{"sql":"SELECT DestStateFips, ArrDelayMinutes, MAX(ArrivalDelayGroups), COUNT(DayOfWeek), COUNT(ArrDelay) FROM mytable WHERE OriginStateFips <= 5 OR Diverted NOT IN (1, 0) GROUP BY DestStateFips, ArrDelayMinutes  ORDER BY DestStateFips, ArrDelayMinutes LIMIT 17","hsqls":["SELECT DestStateFips, ArrDelayMinutes, MAX(ArrivalDelayGroups), COUNT(DayOfWeek), COUNT(ArrDelay) FROM mytable WHERE OriginStateFips <= 5 OR Diverted NOT IN (1, 0) GROUP BY DestStateFips, ArrDelayMinutes  ORDER BY DestStateFips, ArrDelayMinutes LIMIT 17"]}
{"sql":"SELECT DivArrDelay FROM mytable ORDER BY DepDel15, Dest LIMIT 9"}
{"sql":"SELECT MIN(FlightNum), AVG(DestAirportID), SUM(FlightNum) FROM mytable WHERE FlightNum BETWEEN 2345 AND 4441 AND FlightNum = 3747 LIMIT 15"}
{"sql":"SELECT Diverted, Distance, SUM(ArrDelay) FROM mytable GROUP BY Diverted, Distance  ORDER BY Diverted, Distance LIMIT 21","hsqls":["SELECT Diverted, Distance, SUM(ArrDelay) FROM mytable GROUP BY Diverted, Distance  ORDER BY Diverted, Distance LIMIT 21"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE OriginAirportSeqID IN (1379502, 1426202, 1343302) OR \"Month\" BETWEEN 1 AND 1 AND DivTotalGTimes BETWEEN 1 AND 66 ORDER BY ArrTimeBlk LIMIT 10","hsqls":["SELECT ArrDel15 FROM mytable WHERE OriginAirportSeqID IN (1379502, 1426202, 1343302) OR `Month` BETWEEN 1 AND 1 AND (DivTotalGTimes[1] BETWEEN 1 AND 66 OR DivTotalGTimes[2] BETWEEN 1 AND 66 OR DivTotalGTimes[3] BETWEEN 1 AND 66 OR DivTotalGTimes[4] BETWEEN 1 AND 66 OR DivTotalGTimes[5] BETWEEN 1 AND 66) ORDER BY ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT AVG(OriginAirportID) FROM mytable WHERE DestCityName >= 'Syracuse, NY' LIMIT 15"}
{"sql":"SELECT OriginState, DivArrDelay, COUNT(*) FROM mytable WHERE DivTotalGTimes BETWEEN 182 AND 33 GROUP BY OriginState, DivArrDelay LIMIT 27","hsqls":["SELECT OriginState, DivArrDelay, COUNT(*) FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 182 AND 33 OR DivTotalGTimes[2] BETWEEN 182 AND 33 OR DivTotalGTimes[3] BETWEEN 182 AND 33 OR DivTotalGTimes[4] BETWEEN 182 AND 33 OR DivTotalGTimes[5] BETWEEN 182 AND 33) GROUP BY OriginState, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT Carrier FROM mytable WHERE OriginAirportID NOT IN (11193, 12954, 14122, 14027) ORDER BY WeatherDelay LIMIT 19"}
{"sql":"SELECT MIN(OriginStateFips), SUM(FirstDepTime) FROM mytable WHERE DivAirports > 'PSG' LIMIT 17","hsqls":["SELECT MIN(OriginStateFips), SUM(FirstDepTime) FROM mytable WHERE (DivAirports[1] > 'PSG' OR DivAirports[2] > 'PSG' OR DivAirports[3] > 'PSG' OR DivAirports[4] > 'PSG' OR DivAirports[5] > 'PSG') LIMIT 10000"]}
{"sql":"SELECT DepDelay, WeatherDelay, DestStateFips, AVG(CRSArrTime), MAX(WeatherDelay) FROM mytable WHERE OriginStateName IN ('Pennsylvania') GROUP BY DepDelay, WeatherDelay, DestStateFips  ORDER BY DepDelay, WeatherDelay, DestStateFips LIMIT 27","hsqls":["SELECT DepDelay, WeatherDelay, DestStateFips, AVG(CRSArrTime), MAX(WeatherDelay) FROM mytable WHERE OriginStateName IN ('Pennsylvania') GROUP BY DepDelay, WeatherDelay, DestStateFips  ORDER BY DepDelay, WeatherDelay, DestStateFips LIMIT 27"]}
{"sql":"SELECT SUM(Quarter), COUNT(DepTime) FROM mytable LIMIT 25"}
{"sql":"SELECT OriginCityName FROM mytable WHERE ArrDelayMinutes <= 148.0 OR TotalAddGTime BETWEEN 30 AND 21 ORDER BY DepDelay, Quarter, DestCityMarketID LIMIT 10"}
{"sql":"SELECT OriginCityName, COUNT(TaxiOut), MAX(ArrDelayMinutes) FROM mytable WHERE DepTimeBlk IN ('2000-2059') GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 16","hsqls":["SELECT OriginCityName, COUNT(TaxiOut), MAX(ArrDelayMinutes) FROM mytable WHERE DepTimeBlk IN ('2000-2059') GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 16"]}
{"sql":"SELECT LateAircraftDelay, OriginCityName FROM mytable ORDER BY FirstDepTime LIMIT 3"}
{"sql":"SELECT DestCityMarketID FROM mytable ORDER BY DestStateFips, Cancelled LIMIT 24"}
{"sql":"SELECT COUNT(OriginWac), AVG(CRSElapsedTime), SUM(CRSArrTime) FROM mytable LIMIT 22"}
{"sql":"SELECT DivDistance, Carrier, COUNT(FirstDepTime), AVG(FlightNum), COUNT(DepTime) FROM mytable WHERE DivReachedDest < 1 OR DestStateName BETWEEN 'Connecticut' AND 'North Carolina' GROUP BY DivDistance, Carrier  ORDER BY DivDistance, Carrier LIMIT 17","hsqls":["SELECT DivDistance, Carrier, COUNT(FirstDepTime), AVG(FlightNum), COUNT(DepTime) FROM mytable WHERE DivReachedDest < 1 OR DestStateName BETWEEN 'Connecticut' AND 'North Carolina' GROUP BY DivDistance, Carrier  ORDER BY DivDistance, Carrier LIMIT 17"]}
{"sql":"SELECT WeatherDelay, Dest, OriginStateName FROM mytable WHERE OriginStateFips <= 51 ORDER BY Diverted, FirstDepTime, AirTime"}
{"sql":"SELECT DivLongestGTimes, OriginState, OriginStateName FROM mytable WHERE OriginStateName = 'Missouri' ORDER BY OriginState, Carrier, FlightDate LIMIT 3","hsqls":["SELECT DivLongestGTimes, OriginState, OriginStateName FROM mytable WHERE OriginStateName = 'Missouri' ORDER BY OriginState, Carrier, FlightDate LIMIT 10000"]}
{"sql":"SELECT DestStateName, DayofMonth, AVG(DestStateFips), SUM(WheelsOn), COUNT(LongestAddGTime) FROM mytable WHERE DepTime BETWEEN 1304 AND 912 OR TotalAddGTime IN (128, 41, 15, 73, 38) GROUP BY DestStateName, DayofMonth  ORDER BY DestStateName, DayofMonth LIMIT 11","hsqls":["SELECT DestStateName, DayofMonth, AVG(DestStateFips), SUM(WheelsOn), COUNT(LongestAddGTime) FROM mytable WHERE DepTime BETWEEN 1304 AND 912 OR TotalAddGTime IN (128, 41, 15, 73, 38) GROUP BY DestStateName, DayofMonth  ORDER BY DestStateName, DayofMonth LIMIT 11"]}
{"sql":"SELECT OriginAirportSeqID, DestStateFips FROM mytable WHERE TaxiOut < 75 LIMIT 5"}
{"sql":"SELECT TaxiOut, DivReachedDest, DivArrDelay, COUNT(DestStateFips), MAX(DivReachedDest), MIN(OriginCityMarketID) FROM mytable WHERE DivReachedDest >= 1 GROUP BY TaxiOut, DivReachedDest, DivArrDelay  ORDER BY TaxiOut, DivReachedDest, DivArrDelay LIMIT 25","hsqls":["SELECT TaxiOut, DivReachedDest, DivArrDelay, COUNT(DestStateFips), MAX(DivReachedDest), MIN(OriginCityMarketID) FROM mytable WHERE DivReachedDest >= 1 GROUP BY TaxiOut, DivReachedDest, DivArrDelay  ORDER BY TaxiOut, DivReachedDest, DivArrDelay LIMIT 25"]}
{"sql":"SELECT MIN(Quarter) FROM mytable LIMIT 17"}
{"sql":"SELECT TaxiIn FROM mytable WHERE FlightNum BETWEEN 2241 AND 2744 AND CRSElapsedTime BETWEEN 332 AND 156 OR DepDel15 <= -9999 ORDER BY OriginCityMarketID LIMIT 19"}
{"sql":"SELECT Flights FROM mytable WHERE DivTotalGTimes >= 36 OR CarrierDelay <= 32 ORDER BY DepTime, DestCityMarketID, DivArrDelay LIMIT 29","hsqls":["SELECT Flights FROM mytable WHERE (DivTotalGTimes[1] >= 36 OR DivTotalGTimes[2] >= 36 OR DivTotalGTimes[3] >= 36 OR DivTotalGTimes[4] >= 36 OR DivTotalGTimes[5] >= 36) OR CarrierDelay <= 32 ORDER BY DepTime, DestCityMarketID, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime, ArrTime, \"Month\" FROM mytable LIMIT 28","hsqls":["SELECT TotalAddGTime, ArrTime, `Month` FROM mytable LIMIT 28"]}
{"sql":"SELECT DivWheelsOns, DivAirports, TotalAddGTime FROM mytable ORDER BY DestCityName LIMIT 13","hsqls":["SELECT DivWheelsOns, DivAirports, TotalAddGTime FROM mytable ORDER BY DestCityName LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, FirstDepTime, COUNT(*) FROM mytable GROUP BY OriginStateFips, FirstDepTime  ORDER BY OriginStateFips, FirstDepTime LIMIT 5","hsqls":["SELECT OriginStateFips, FirstDepTime, COUNT(*) FROM mytable GROUP BY OriginStateFips, FirstDepTime  ORDER BY OriginStateFips, FirstDepTime LIMIT 5"]}
{"sql":"SELECT DestAirportSeqID, NASDelay, CRSDepTime, MIN(ArrDelay) FROM mytable WHERE AirlineID <> 19393 AND OriginAirportSeqID >= 1020803 OR Cancelled > 1 GROUP BY DestAirportSeqID, NASDelay, CRSDepTime  ORDER BY DestAirportSeqID, NASDelay, CRSDepTime LIMIT 20","hsqls":["SELECT DestAirportSeqID, NASDelay, CRSDepTime, MIN(ArrDelay) FROM mytable WHERE AirlineID <> 19393 AND OriginAirportSeqID >= 1020803 OR Cancelled > 1 GROUP BY DestAirportSeqID, NASDelay, CRSDepTime  ORDER BY DestAirportSeqID, NASDelay, CRSDepTime LIMIT 20"]}
{"sql":"SELECT LongestAddGTime, MIN(OriginCityMarketID) FROM mytable WHERE DepDel15 NOT IN (1, 0, -9999) AND DivAirports BETWEEN 'COS' AND 'TWF' GROUP BY LongestAddGTime LIMIT 10","hsqls":["SELECT LongestAddGTime, MIN(OriginCityMarketID) FROM mytable WHERE DepDel15 NOT IN (1, 0, -9999) AND (DivAirports[1] BETWEEN 'COS' AND 'TWF' OR DivAirports[2] BETWEEN 'COS' AND 'TWF' OR DivAirports[3] BETWEEN 'COS' AND 'TWF' OR DivAirports[4] BETWEEN 'COS' AND 'TWF' OR DivAirports[5] BETWEEN 'COS' AND 'TWF') GROUP BY LongestAddGTime LIMIT 10000"]}
{"sql":"SELECT DayofMonth, AVG(TaxiOut) FROM mytable WHERE Diverted = 1 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 10","hsqls":["SELECT DayofMonth, AVG(TaxiOut) FROM mytable WHERE Diverted = 1 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 10"]}
{"sql":"SELECT MIN(ArrDelay) FROM mytable WHERE OriginCityName BETWEEN 'Wilmington, DE' AND 'Moline, IL' OR DepTime BETWEEN 1333 AND 1223 AND DepDel15 IN (1) LIMIT 17"}
{"sql":"SELECT DestAirportSeqID FROM mytable WHERE DivWheelsOffs BETWEEN 1840 AND 2318 ORDER BY DivDistance, DepTime, DivAirportLandings LIMIT 27","hsqls":["SELECT DestAirportSeqID FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1840 AND 2318 OR DivWheelsOffs[2] BETWEEN 1840 AND 2318 OR DivWheelsOffs[3] BETWEEN 1840 AND 2318 OR DivWheelsOffs[4] BETWEEN 1840 AND 2318 OR DivWheelsOffs[5] BETWEEN 1840 AND 2318) ORDER BY DivDistance, DepTime, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, OriginCityMarketID, ArrTimeBlk, AVG(WeatherDelay), MAX(DestWac) FROM mytable WHERE ActualElapsedTime NOT IN (181, 147, 293) AND DivAirportIDs BETWEEN 11618 AND 13204 GROUP BY LateAircraftDelay, OriginCityMarketID, ArrTimeBlk LIMIT 16","hsqls":["SELECT LateAircraftDelay, OriginCityMarketID, ArrTimeBlk, AVG(WeatherDelay), MAX(DestWac) FROM mytable WHERE ActualElapsedTime NOT IN (181, 147, 293) AND (DivAirportIDs[1] BETWEEN 11618 AND 13204 OR DivAirportIDs[2] BETWEEN 11618 AND 13204 OR DivAirportIDs[3] BETWEEN 11618 AND 13204 OR DivAirportIDs[4] BETWEEN 11618 AND 13204 OR DivAirportIDs[5] BETWEEN 11618 AND 13204) GROUP BY LateAircraftDelay, OriginCityMarketID, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT FlightNum, SecurityDelay FROM mytable LIMIT 24"}
{"sql":"SELECT TaxiIn, Dest, MAX(OriginAirportSeqID), AVG(CRSElapsedTime), AVG(DepDelay) FROM mytable WHERE DivDistance BETWEEN 368 AND 251 GROUP BY TaxiIn, Dest  ORDER BY TaxiIn, Dest LIMIT 21","hsqls":["SELECT TaxiIn, Dest, MAX(OriginAirportSeqID), AVG(CRSElapsedTime), AVG(DepDelay) FROM mytable WHERE DivDistance BETWEEN 368 AND 251 GROUP BY TaxiIn, Dest  ORDER BY TaxiIn, Dest LIMIT 21"]}
{"sql":"SELECT LongestAddGTime, DestCityName FROM mytable WHERE DepTime BETWEEN 548 AND 2210 ORDER BY Flights LIMIT 7"}
{"sql":"SELECT AVG(ArrivalDelayGroups), MIN(Distance) FROM mytable WHERE DestCityMarketID BETWEEN 31337 AND 35389 OR DivDistance BETWEEN 575 AND 971 AND DivWheelsOns IN (1228, 1007) LIMIT 6","hsqls":["SELECT AVG(ArrivalDelayGroups), MIN(Distance)  FROM mytable WHERE DestCityMarketID BETWEEN 31337 AND 35389 OR DivDistance BETWEEN 575 AND 971 AND (DivWheelsOns[1] IN (1228, 1007) OR DivWheelsOns[2] IN (1228, 1007) OR DivWheelsOns[3] IN (1228, 1007) OR DivWheelsOns[4] IN (1228, 1007) OR DivWheelsOns[5] IN (1228, 1007)) LIMIT 10000"]}
{"sql":"SELECT TailNum, DestAirportID, MIN(TaxiOut), COUNT(AirlineID) FROM mytable WHERE DepDelay BETWEEN 187.0 AND 334.0 AND WheelsOn = 1534 GROUP BY TailNum, DestAirportID  ORDER BY TailNum, DestAirportID LIMIT 22","hsqls":["SELECT TailNum, DestAirportID, MIN(TaxiOut), COUNT(AirlineID) FROM mytable WHERE DepDelay BETWEEN 187.0 AND 334.0 AND WheelsOn = 1534 GROUP BY TailNum, DestAirportID  ORDER BY TailNum, DestAirportID LIMIT 22"]}
{"sql":"SELECT LateAircraftDelay, COUNT(*) FROM mytable GROUP BY LateAircraftDelay  ORDER BY LateAircraftDelay LIMIT 29","hsqls":["SELECT LateAircraftDelay, COUNT(*) FROM mytable GROUP BY LateAircraftDelay  ORDER BY LateAircraftDelay LIMIT 29"]}
{"sql":"SELECT AVG(CRSElapsedTime), MIN(TaxiIn), COUNT(DivArrDelay) FROM mytable WHERE ActualElapsedTime BETWEEN 379 AND 259 OR OriginState NOT IN ('MT', 'SD', 'NC', 'IN') OR DestState BETWEEN 'MT' AND 'MN' LIMIT 10"}
{"sql":"SELECT \"Year\" FROM mytable ORDER BY OriginAirportSeqID, OriginState LIMIT 21","hsqls":["SELECT `Year` FROM mytable ORDER BY OriginAirportSeqID, OriginState LIMIT 21"]}
{"sql":"SELECT DepDelay, DestAirportSeqID, SUM(ArrDelayMinutes), MIN(DepDel15), COUNT(UniqueCarrier) FROM mytable WHERE CarrierDelay IN (59, 43, 7, 118, 85) OR DestAirportSeqID <= 1495203 GROUP BY DepDelay, DestAirportSeqID  ORDER BY DepDelay, DestAirportSeqID LIMIT 4","hsqls":["SELECT DepDelay, DestAirportSeqID, SUM(ArrDelayMinutes), MIN(DepDel15), COUNT(UniqueCarrier) FROM mytable WHERE CarrierDelay IN (59, 43, 7, 118, 85) OR DestAirportSeqID <= 1495203 GROUP BY DepDelay, DestAirportSeqID  ORDER BY DepDelay, DestAirportSeqID LIMIT 4"]}
{"sql":"SELECT TaxiOut, DistanceGroup, OriginAirportID, COUNT(*) FROM mytable WHERE DepDel15 < -9999 AND ArrDelay BETWEEN -21.0 AND 82.0 AND DepDel15 NOT IN (1, 0, -9999) GROUP BY TaxiOut, DistanceGroup, OriginAirportID  ORDER BY TaxiOut, DistanceGroup, OriginAirportID LIMIT 16","hsqls":["SELECT TaxiOut, DistanceGroup, OriginAirportID, COUNT(*) FROM mytable WHERE DepDel15 < -9999 AND ArrDelay BETWEEN -21.0 AND 82.0 AND DepDel15 NOT IN (1, 0, -9999) GROUP BY TaxiOut, DistanceGroup, OriginAirportID  ORDER BY TaxiOut, DistanceGroup, OriginAirportID LIMIT 16"]}
{"sql":"SELECT UniqueCarrier FROM mytable ORDER BY CarrierDelay LIMIT 27"}
{"sql":"SELECT TailNum FROM mytable WHERE Distance = 309 OR WheelsOff BETWEEN 2001 AND 909 OR DayOfWeek > 7 ORDER BY TotalAddGTime, ArrTimeBlk, DestCityName LIMIT 17"}
{"sql":"SELECT DepTimeBlk, DestCityMarketID FROM mytable WHERE ArrTime BETWEEN 906 AND 1704 OR DestWac NOT IN (1, 22, 23, 53, 61) ORDER BY ArrTime, ArrDelay LIMIT 6"}
{"sql":"SELECT OriginWac, MAX(NASDelay), AVG(WheelsOn) FROM mytable WHERE OriginStateFips NOT IN (48, 41, 40, 33, 72) AND UniqueCarrier NOT IN ('F9', 'OO', 'MQ') OR DivReachedDest <> -9999 GROUP BY OriginWac  ORDER BY OriginWac LIMIT 10","hsqls":["SELECT OriginWac, MAX(NASDelay), AVG(WheelsOn) FROM mytable WHERE OriginStateFips NOT IN (48, 41, 40, 33, 72) AND UniqueCarrier NOT IN ('F9', 'OO', 'MQ') OR DivReachedDest <> -9999 GROUP BY OriginWac  ORDER BY OriginWac LIMIT 10"]}
{"sql":"SELECT DestAirportSeqID, Cancelled, CRSElapsedTime FROM mytable WHERE DayOfWeek NOT IN (2, 6, 5, 4) ORDER BY ArrDel15"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE NASDelay >= 113 AND ArrDelay <= -41.0 AND ArrTime >= 854 LIMIT 28"}
{"sql":"SELECT DepartureDelayGroups, \"Month\" FROM mytable WHERE CRSArrTime < 1918 OR DivTotalGTimes BETWEEN 56 AND 85 ORDER BY DistanceGroup, \"Year\", TotalAddGTime LIMIT 17","hsqls":["SELECT DepartureDelayGroups, `Month` FROM mytable WHERE CRSArrTime < 1918 OR (DivTotalGTimes[1] BETWEEN 56 AND 85 OR DivTotalGTimes[2] BETWEEN 56 AND 85 OR DivTotalGTimes[3] BETWEEN 56 AND 85 OR DivTotalGTimes[4] BETWEEN 56 AND 85 OR DivTotalGTimes[5] BETWEEN 56 AND 85) ORDER BY DistanceGroup, Year, TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT COUNT(ArrDel15) FROM mytable WHERE OriginStateName BETWEEN 'Wyoming' AND 'Alaska' AND OriginStateName BETWEEN 'Delaware' AND 'Puerto Rico' LIMIT 12"}
{"sql":"SELECT MAX(DestAirportID), MAX(DestStateFips), MIN(DestAirportID) FROM mytable LIMIT 16"}
{"sql":"SELECT DestState, FirstDepTime, DayofMonth FROM mytable WHERE CRSDepTime < 1223 AND DivWheelsOffs BETWEEN 1609 AND 1711 AND DivAirportIDs BETWEEN 13029 AND 11638 ORDER BY OriginCityMarketID, ArrTime, OriginAirportID LIMIT 27","hsqls":["SELECT DestState, FirstDepTime, DayofMonth FROM mytable WHERE CRSDepTime < 1223 AND (DivWheelsOffs[1] BETWEEN 1609 AND 1711 OR DivWheelsOffs[2] BETWEEN 1609 AND 1711 OR DivWheelsOffs[3] BETWEEN 1609 AND 1711 OR DivWheelsOffs[4] BETWEEN 1609 AND 1711 OR DivWheelsOffs[5] BETWEEN 1609 AND 1711) AND (DivAirportIDs[1] BETWEEN 13029 AND 11638 OR DivAirportIDs[2] BETWEEN 13029 AND 11638 OR DivAirportIDs[3] BETWEEN 13029 AND 11638 OR DivAirportIDs[4] BETWEEN 13029 AND 11638 OR DivAirportIDs[5] BETWEEN 13029 AND 11638) ORDER BY OriginCityMarketID, ArrTime, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT DestAirportID, AVG(CRSDepTime), AVG(OriginStateFips) FROM mytable WHERE LateAircraftDelay IN (128, 93, 87) OR DestAirportID IN (14711, 10423, 11471, 12343) AND LateAircraftDelay BETWEEN 51 AND 250 GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 16","hsqls":["SELECT DestAirportID, AVG(CRSDepTime), AVG(OriginStateFips) FROM mytable WHERE LateAircraftDelay IN (128, 93, 87) OR DestAirportID IN (14711, 10423, 11471, 12343) AND LateAircraftDelay BETWEEN 51 AND 250 GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 16"]}
{"sql":"SELECT FirstDepTime, DivAirportLandings, CRSElapsedTime FROM mytable WHERE OriginState BETWEEN 'VI' AND 'KS' OR DestStateFips BETWEEN 23 AND 42 ORDER BY DepDelay, ArrTime, DestCityName LIMIT 16"}
{"sql":"SELECT OriginAirportSeqID, TailNum, COUNT(*) FROM mytable WHERE Quarter >= 1 OR LongestAddGTime IN (78) GROUP BY OriginAirportSeqID, TailNum  ORDER BY OriginAirportSeqID, TailNum LIMIT 1","hsqls":["SELECT OriginAirportSeqID, TailNum, COUNT(*) FROM mytable WHERE Quarter >= 1 OR LongestAddGTime IN (78) GROUP BY OriginAirportSeqID, TailNum  ORDER BY OriginAirportSeqID, TailNum LIMIT 1"]}
{"sql":"SELECT DestStateFips FROM mytable WHERE UniqueCarrier > 'MQ' OR DepartureDelayGroups BETWEEN -2 AND -2 ORDER BY DestStateFips, TaxiIn LIMIT 24"}
{"sql":"SELECT Diverted FROM mytable WHERE OriginCityMarketID >= 30436 OR DepTime < 753 OR DepTimeBlk < '1800-1859' ORDER BY FirstDepTime, CarrierDelay, Distance LIMIT 15"}
{"sql":"SELECT TaxiIn, COUNT(*) FROM mytable GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 23","hsqls":["SELECT TaxiIn, COUNT(*) FROM mytable GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 23"]}
{"sql":"SELECT DepartureDelayGroups, DistanceGroup, SecurityDelay FROM mytable WHERE DepDelayMinutes <> 10.0 AND DivTotalGTimes IN (97, 56) ORDER BY TaxiOut, OriginAirportID LIMIT 23","hsqls":["SELECT DepartureDelayGroups, DistanceGroup, SecurityDelay FROM mytable WHERE DepDelayMinutes <> 10.0 AND (DivTotalGTimes[1] IN (97, 56) OR DivTotalGTimes[2] IN (97, 56) OR DivTotalGTimes[3] IN (97, 56) OR DivTotalGTimes[4] IN (97, 56) OR DivTotalGTimes[5] IN (97, 56)) ORDER BY TaxiOut, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT DivDistance, DestStateName, COUNT(FirstDepTime), MIN(Flights), SUM(WeatherDelay) FROM mytable WHERE Distance BETWEEN 369 AND 1144 AND FlightDate BETWEEN '2014-01-17' AND '2014-01-10' GROUP BY DivDistance, DestStateName  ORDER BY DivDistance, DestStateName LIMIT 9","hsqls":["SELECT DivDistance, DestStateName, COUNT(FirstDepTime), MIN(Flights), SUM(WeatherDelay) FROM mytable WHERE Distance BETWEEN 369 AND 1144 AND FlightDate BETWEEN '2014-01-17' AND '2014-01-10' GROUP BY DivDistance, DestStateName  ORDER BY DivDistance, DestStateName LIMIT 9"]}
{"sql":"SELECT MIN(DivAirportLandings) FROM mytable WHERE OriginAirportSeqID > 1425603 LIMIT 20"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivAirportSeqIDs IN (1040802, 1160302) LIMIT 10","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivAirportSeqIDs[1] IN (1040802, 1160302) OR DivAirportSeqIDs[2] IN (1040802, 1160302) OR DivAirportSeqIDs[3] IN (1040802, 1160302) OR DivAirportSeqIDs[4] IN (1040802, 1160302) OR DivAirportSeqIDs[5] IN (1040802, 1160302)) LIMIT 10000"]}
{"sql":"SELECT TailNum, SUM(AirTime), MAX(Diverted), MIN(DayofMonth) FROM mytable GROUP BY TailNum  ORDER BY TailNum LIMIT 12","hsqls":["SELECT TailNum, SUM(AirTime), MAX(Diverted), MIN(DayofMonth) FROM mytable GROUP BY TailNum  ORDER BY TailNum LIMIT 12"]}
{"sql":"SELECT DivLongestGTimes, ArrTimeBlk, DestCityName FROM mytable WHERE DivAirportIDs <= 13024 OR Quarter BETWEEN 1 AND 1 AND DestAirportSeqID NOT IN (1393303, 1164802) ORDER BY OriginState, TaxiIn, \"Month\" LIMIT 10","hsqls":["SELECT DivLongestGTimes, ArrTimeBlk, DestCityName FROM mytable WHERE (DivAirportIDs[1] <= 13024 OR DivAirportIDs[2] <= 13024 OR DivAirportIDs[3] <= 13024 OR DivAirportIDs[4] <= 13024 OR DivAirportIDs[5] <= 13024) OR Quarter BETWEEN 1 AND 1 AND DestAirportSeqID NOT IN (1393303, 1164802) ORDER BY OriginState, TaxiIn, `Month` LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, ArrivalDelayGroups, COUNT(*) FROM mytable GROUP BY OriginStateFips, ArrivalDelayGroups  ORDER BY OriginStateFips, ArrivalDelayGroups LIMIT 10","hsqls":["SELECT OriginStateFips, ArrivalDelayGroups, COUNT(*) FROM mytable GROUP BY OriginStateFips, ArrivalDelayGroups  ORDER BY OriginStateFips, ArrivalDelayGroups LIMIT 10"]}
{"sql":"SELECT WheelsOff, OriginStateFips, OriginCityName, MAX(OriginWac) FROM mytable WHERE Distance <> 1488 AND DestCityMarketID BETWEEN 31624 AND 30990 OR TotalAddGTime NOT IN (55) GROUP BY WheelsOff, OriginStateFips, OriginCityName  ORDER BY WheelsOff, OriginStateFips, OriginCityName LIMIT 18","hsqls":["SELECT WheelsOff, OriginStateFips, OriginCityName, MAX(OriginWac) FROM mytable WHERE Distance <> 1488 AND DestCityMarketID BETWEEN 31624 AND 30990 OR TotalAddGTime NOT IN (55) GROUP BY WheelsOff, OriginStateFips, OriginCityName  ORDER BY WheelsOff, OriginStateFips, OriginCityName LIMIT 18"]}
{"sql":"SELECT DivLongestGTimes, OriginCityName, DestCityMarketID FROM mytable WHERE Dest IN ('CEC', 'ELM', 'FAI', 'ABI', 'SCC') AND SecurityDelay BETWEEN 8 AND 4 AND OriginWac BETWEEN 42 AND 88 ORDER BY DepartureDelayGroups LIMIT 19","hsqls":["SELECT DivLongestGTimes, OriginCityName, DestCityMarketID FROM mytable WHERE Dest IN ('CEC', 'ELM', 'FAI', 'ABI', 'SCC') AND SecurityDelay BETWEEN 8 AND 4 AND OriginWac BETWEEN 42 AND 88 ORDER BY DepartureDelayGroups LIMIT 10000"]}
{"sql":"SELECT DivAirportIDs, CRSElapsedTime FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 AND TaxiIn BETWEEN 9 AND 46 LIMIT 29","hsqls":["SELECT DivAirportIDs, CRSElapsedTime FROM mytable WHERE `Month` BETWEEN 1 AND 1 AND TaxiIn BETWEEN 9 AND 46 LIMIT 10000"]}
{"sql":"SELECT TaxiOut, Dest, CRSDepTime FROM mytable WHERE ActualElapsedTime NOT IN (140, 264, 273) AND Flights IN (1) ORDER BY ArrTime, DivAirportLandings, OriginAirportID LIMIT 10"}
{"sql":"SELECT WheelsOff, DepDelay, DestState, COUNT(*) FROM mytable WHERE ArrivalDelayGroups NOT IN (2, 1, -2, 11) OR DivWheelsOns >= 1925 AND TailNum BETWEEN 'N38424' AND 'N495UA' GROUP BY WheelsOff, DepDelay, DestState LIMIT 21","hsqls":["SELECT WheelsOff, DepDelay, DestState, COUNT(*) FROM mytable WHERE ArrivalDelayGroups NOT IN (2, 1, -2, 11) OR (DivWheelsOns[1] >= 1925 OR DivWheelsOns[2] >= 1925 OR DivWheelsOns[3] >= 1925 OR DivWheelsOns[4] >= 1925 OR DivWheelsOns[5] >= 1925) AND TailNum BETWEEN 'N38424' AND 'N495UA' GROUP BY WheelsOff, DepDelay, DestState LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, NASDelay FROM mytable WHERE ArrTimeBlk NOT IN ('2000-2059', '1000-1059', '0700-0759', '2100-2159', '1200-1259') AND SecurityDelay > -9999 ORDER BY DepartureDelayGroups LIMIT 29"}
{"sql":"SELECT WheelsOff, DayofMonth, WheelsOn FROM mytable WHERE OriginCityName BETWEEN 'Arcata/Eureka, CA' AND 'Akron, OH' OR DestState BETWEEN 'ME' AND 'ID' ORDER BY TaxiOut LIMIT 11"}
{"sql":"SELECT OriginCityName, AVG(TotalAddGTime), MAX(OriginCityMarketID), COUNT(NASDelay) FROM mytable WHERE DayOfWeek = 2 OR DivActualElapsedTime NOT IN (471, 359) AND DestCityMarketID BETWEEN 34492 AND 35411 GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 16","hsqls":["SELECT OriginCityName, AVG(TotalAddGTime), MAX(OriginCityMarketID), COUNT(NASDelay) FROM mytable WHERE DayOfWeek = 2 OR DivActualElapsedTime NOT IN (471, 359) AND DestCityMarketID BETWEEN 34492 AND 35411 GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 16"]}
{"sql":"SELECT DivReachedDest, CancellationCode, COUNT(*) FROM mytable WHERE FlightDate NOT IN ('2014-01-14', '2014-01-27', '2014-01-19', '2014-01-31') GROUP BY DivReachedDest, CancellationCode  ORDER BY DivReachedDest, CancellationCode LIMIT 14","hsqls":["SELECT DivReachedDest, CancellationCode, COUNT(*) FROM mytable WHERE FlightDate NOT IN ('2014-01-14', '2014-01-27', '2014-01-19', '2014-01-31') GROUP BY DivReachedDest, CancellationCode  ORDER BY DivReachedDest, CancellationCode LIMIT 14"]}
{"sql":"SELECT TaxiOut FROM mytable WHERE DestState = 'NJ' ORDER BY DivReachedDest, CarrierDelay LIMIT 18"}
{"sql":"SELECT OriginAirportSeqID, AirlineID FROM mytable LIMIT 9"}
{"sql":"SELECT DayofMonth, DaysSinceEpoch, MIN(ArrDelayMinutes), SUM(ArrivalDelayGroups), COUNT(OriginWac) FROM mytable WHERE ArrDelayMinutes BETWEEN 23.0 AND 245.0 OR ArrTimeBlk BETWEEN '0600-0659' AND '1200-1259' GROUP BY DayofMonth, DaysSinceEpoch  ORDER BY DayofMonth, DaysSinceEpoch LIMIT 6","hsqls":["SELECT DayofMonth, DaysSinceEpoch, MIN(ArrDelayMinutes), SUM(ArrivalDelayGroups), COUNT(OriginWac) FROM mytable WHERE ArrDelayMinutes BETWEEN 23.0 AND 245.0 OR ArrTimeBlk BETWEEN '0600-0659' AND '1200-1259' GROUP BY DayofMonth, DaysSinceEpoch  ORDER BY DayofMonth, DaysSinceEpoch LIMIT 6"]}
{"sql":"SELECT DestStateFips, DepDel15, AVG(DayofMonth), SUM(ArrDelay), MAX(DestWac) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 GROUP BY DestStateFips, DepDel15 LIMIT 20","hsqls":["SELECT DestStateFips, DepDel15, AVG(DayofMonth), SUM(ArrDelay), MAX(DestWac) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 GROUP BY DestStateFips, DepDel15 LIMIT 20"]}
{"sql":"SELECT DivDistance, COUNT(Quarter), COUNT(TaxiIn), COUNT(DepTimeBlk) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 13","hsqls":["SELECT DivDistance, COUNT(Quarter), COUNT(TaxiIn), COUNT(DepTimeBlk) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 13"]}
{"sql":"SELECT ArrivalDelayGroups FROM mytable WHERE TaxiOut BETWEEN 7 AND 44 ORDER BY LateAircraftDelay, DepTime LIMIT 5"}
{"sql":"SELECT TailNum FROM mytable WHERE OriginAirportSeqID BETWEEN 1112202 AND 1080003 ORDER BY FirstDepTime LIMIT 19"}
{"sql":"SELECT ActualElapsedTime, ArrTime, DivAirportLandings, MAX(ActualElapsedTime) FROM mytable WHERE OriginState <> 'NE' GROUP BY ActualElapsedTime, ArrTime, DivAirportLandings  ORDER BY ActualElapsedTime, ArrTime, DivAirportLandings LIMIT 25","hsqls":["SELECT ActualElapsedTime, ArrTime, DivAirportLandings, MAX(ActualElapsedTime) FROM mytable WHERE OriginState <> 'NE' GROUP BY ActualElapsedTime, ArrTime, DivAirportLandings  ORDER BY ActualElapsedTime, ArrTime, DivAirportLandings LIMIT 25"]}
{"sql":"SELECT SUM(LongestAddGTime), COUNT(ActualElapsedTime), SUM(Quarter) FROM mytable WHERE Cancelled IN (1, 0) OR CRSArrTime BETWEEN 1043 AND 1357"}
{"sql":"SELECT DistanceGroup, DestWac, AVG(ArrivalDelayGroups), MIN(\"Month\") FROM mytable WHERE \"Year\" IN (2014) GROUP BY DistanceGroup, DestWac LIMIT 5","hsqls":["SELECT DistanceGroup, DestWac, AVG(ArrivalDelayGroups), MIN(`Month`) FROM mytable WHERE `Year` IN (2014) GROUP BY DistanceGroup, DestWac LIMIT 5"]}
{"sql":"SELECT MAX(CRSArrTime) FROM mytable WHERE DivTailNums BETWEEN 'N957DN' AND 'N416WN' OR ArrivalDelayGroups <> 3 AND OriginAirportSeqID BETWEEN 1489302 AND 1059904 LIMIT 13","hsqls":["SELECT MAX(CRSArrTime) FROM mytable WHERE (DivTailNums[1] BETWEEN 'N957DN' AND 'N416WN' OR DivTailNums[2] BETWEEN 'N957DN' AND 'N416WN' OR DivTailNums[3] BETWEEN 'N957DN' AND 'N416WN' OR DivTailNums[4] BETWEEN 'N957DN' AND 'N416WN' OR DivTailNums[5] BETWEEN 'N957DN' AND 'N416WN') OR ArrivalDelayGroups <> 3 AND OriginAirportSeqID BETWEEN 1489302 AND 1059904 LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, COUNT(ArrDelayMinutes) FROM mytable GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 9","hsqls":["SELECT DepartureDelayGroups, COUNT(ArrDelayMinutes) FROM mytable GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 9"]}
{"sql":"SELECT OriginState, LongestAddGTime, DivArrDelay FROM mytable WHERE DepDelayMinutes >= 106.0 OR FirstDepTime IN (814, 1939) OR NASDelay NOT IN (211, 56, 16, 63) ORDER BY NASDelay, DestAirportID LIMIT 10"}
{"sql":"SELECT Distance, DivArrDelay, OriginAirportID FROM mytable WHERE DaysSinceEpoch NOT IN (16085) LIMIT 24"}
{"sql":"SELECT DivReachedDest, TaxiIn, WheelsOn FROM mytable WHERE ActualElapsedTime <= 103 OR DivWheelsOffs BETWEEN 1711 AND 1952 AND DivAirports BETWEEN 'MLI' AND 'ORD' ORDER BY FlightNum, DestAirportID LIMIT 13","hsqls":["SELECT DivReachedDest, TaxiIn, WheelsOn FROM mytable WHERE ActualElapsedTime <= 103 OR (DivWheelsOffs[1] BETWEEN 1711 AND 1952 OR DivWheelsOffs[2] BETWEEN 1711 AND 1952 OR DivWheelsOffs[3] BETWEEN 1711 AND 1952 OR DivWheelsOffs[4] BETWEEN 1711 AND 1952 OR DivWheelsOffs[5] BETWEEN 1711 AND 1952) AND (DivAirports[1] BETWEEN 'MLI' AND 'ORD' OR DivAirports[2] BETWEEN 'MLI' AND 'ORD' OR DivAirports[3] BETWEEN 'MLI' AND 'ORD' OR DivAirports[4] BETWEEN 'MLI' AND 'ORD' OR DivAirports[5] BETWEEN 'MLI' AND 'ORD') ORDER BY FlightNum, DestAirportID LIMIT 10000"]}
{"sql":"SELECT DestWac, DivAirportIDs, DestAirportID FROM mytable LIMIT 17","hsqls":["SELECT DestWac, DivAirportIDs, DestAirportID FROM mytable LIMIT 10000"]}
{"sql":"SELECT Flights, DestStateName FROM mytable WHERE DestWac NOT IN (11) AND DivWheelsOffs IN (1524, 1901, 1621) AND DayOfWeek NOT IN (2, 7, 5) ORDER BY OriginAirportSeqID, ArrivalDelayGroups LIMIT 21","hsqls":["SELECT Flights, DestStateName FROM mytable WHERE DestWac NOT IN (11) AND (DivWheelsOffs[1] IN (1524, 1901, 1621) OR DivWheelsOffs[2] IN (1524, 1901, 1621) OR DivWheelsOffs[3] IN (1524, 1901, 1621) OR DivWheelsOffs[4] IN (1524, 1901, 1621) OR DivWheelsOffs[5] IN (1524, 1901, 1621)) AND DayOfWeek NOT IN (2, 7, 5) ORDER BY OriginAirportSeqID, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT DivAirportSeqIDs, DestCityMarketID FROM mytable WHERE DestStateName BETWEEN 'California' AND 'Maine' AND DivTotalGTimes BETWEEN 1 AND 159 AND DepartureDelayGroups NOT IN (2, -1, 12) LIMIT 24","hsqls":["SELECT DivAirportSeqIDs, DestCityMarketID FROM mytable WHERE DestStateName BETWEEN 'California' AND 'Maine' AND (DivTotalGTimes[1] BETWEEN 1 AND 159 OR DivTotalGTimes[2] BETWEEN 1 AND 159 OR DivTotalGTimes[3] BETWEEN 1 AND 159 OR DivTotalGTimes[4] BETWEEN 1 AND 159 OR DivTotalGTimes[5] BETWEEN 1 AND 159) AND DepartureDelayGroups NOT IN (2, -1, 12) LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DayOfWeek, COUNT(OriginCityName) FROM mytable WHERE DestWac > 74 GROUP BY WeatherDelay, DayOfWeek  ORDER BY WeatherDelay, DayOfWeek LIMIT 8","hsqls":["SELECT WeatherDelay, DayOfWeek, COUNT(OriginCityName) FROM mytable WHERE DestWac > 74 GROUP BY WeatherDelay, DayOfWeek  ORDER BY WeatherDelay, DayOfWeek LIMIT 8"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DepDel15 = -9999 OR DestStateName < 'Idaho' LIMIT 3"}
{"sql":"SELECT DepDelay, Carrier, DivDistance FROM mytable WHERE ArrDel15 NOT IN (1, 0, -9999) OR OriginWac BETWEEN 1 AND 3 OR OriginAirportSeqID BETWEEN 1177801 AND 1087402 ORDER BY DaysSinceEpoch LIMIT 1"}
{"sql":"SELECT OriginCityMarketID, COUNT(*) FROM mytable WHERE DivReachedDest BETWEEN 1 AND 1 OR DepDelayMinutes BETWEEN 121.0 AND 306.0 AND DivReachedDest = 1 GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 9","hsqls":["SELECT OriginCityMarketID, COUNT(*) FROM mytable WHERE DivReachedDest BETWEEN 1 AND 1 OR DepDelayMinutes BETWEEN 121.0 AND 306.0 AND DivReachedDest = 1 GROUP BY OriginCityMarketID  ORDER BY OriginCityMarketID LIMIT 9"]}
{"sql":"SELECT SecurityDelay, MAX(DivReachedDest), MIN(DivAirportLandings), COUNT(AirlineID) FROM mytable WHERE DestAirportID <= 15624 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 3","hsqls":["SELECT SecurityDelay, MAX(DivReachedDest), MIN(DivAirportLandings), COUNT(AirlineID) FROM mytable WHERE DestAirportID <= 15624 GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 3"]}
{"sql":"SELECT DivDistance, SecurityDelay, OriginStateName FROM mytable WHERE ActualElapsedTime BETWEEN 376 AND 427 AND TaxiOut NOT IN (66, 96, 62, 11) OR DestWac IN (43, 22, 33, 54, 12) ORDER BY DepTimeBlk, DayofMonth LIMIT 25"}
{"sql":"SELECT OriginState, MAX(DivDistance), MAX(DepDelayMinutes), COUNT(DepTimeBlk) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 13","hsqls":["SELECT OriginState, MAX(DivDistance), MAX(DepDelayMinutes), COUNT(DepTimeBlk) FROM mytable GROUP BY OriginState  ORDER BY OriginState LIMIT 13"]}
{"sql":"SELECT DivActualElapsedTime, OriginAirportID, MIN(ArrTime) FROM mytable WHERE OriginAirportSeqID NOT IN (1104902) GROUP BY DivActualElapsedTime, OriginAirportID  ORDER BY DivActualElapsedTime, OriginAirportID LIMIT 2","hsqls":["SELECT DivActualElapsedTime, OriginAirportID, MIN(ArrTime) FROM mytable WHERE OriginAirportSeqID NOT IN (1104902) GROUP BY DivActualElapsedTime, OriginAirportID  ORDER BY DivActualElapsedTime, OriginAirportID LIMIT 2"]}
{"sql":"SELECT Carrier, SecurityDelay, DivArrDelay FROM mytable WHERE Dest NOT IN ('OAK') OR DepDelay <> 34.0 AND DayofMonth IN (18) LIMIT 10"}
{"sql":"SELECT SecurityDelay, DayOfWeek, SUM(ArrivalDelayGroups), SUM(LateAircraftDelay) FROM mytable WHERE DivArrDelay BETWEEN 449 AND 141 GROUP BY SecurityDelay, DayOfWeek  ORDER BY SecurityDelay, DayOfWeek LIMIT 11","hsqls":["SELECT SecurityDelay, DayOfWeek, SUM(ArrivalDelayGroups), SUM(LateAircraftDelay) FROM mytable WHERE DivArrDelay BETWEEN 449 AND 141 GROUP BY SecurityDelay, DayOfWeek  ORDER BY SecurityDelay, DayOfWeek LIMIT 11"]}
{"sql":"SELECT NASDelay FROM mytable WHERE DestStateName <= 'Wyoming' ORDER BY DivActualElapsedTime LIMIT 7"}
{"sql":"SELECT DestWac, OriginCityMarketID, DestCityName FROM mytable WHERE ArrDel15 NOT IN (1, 0, -9999) ORDER BY FlightNum, WeatherDelay, DestStateName LIMIT 7"}
{"sql":"SELECT FlightDate, TotalAddGTime FROM mytable WHERE DivAirports < 'SIT' OR DepDelay NOT IN (329.0, 39.0) ORDER BY FlightNum LIMIT 10","hsqls":["SELECT FlightDate, TotalAddGTime FROM mytable WHERE (DivAirports[1] < 'SIT' OR DivAirports[2] < 'SIT' OR DivAirports[3] < 'SIT' OR DivAirports[4] < 'SIT' OR DivAirports[5] < 'SIT') OR DepDelay NOT IN (329.0, 39.0) ORDER BY FlightNum LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime FROM mytable WHERE DivReachedDest < 1 ORDER BY ArrDel15, DivArrDelay LIMIT 18"}
{"sql":"SELECT DistanceGroup, DivDistance, Flights FROM mytable WHERE TailNum IN ('N223SW') OR DivTailNums BETWEEN 'N904FR' AND 'N27213' AND FirstDepTime >= 736 ORDER BY DepartureDelayGroups LIMIT 18","hsqls":["SELECT DistanceGroup, DivDistance, Flights FROM mytable WHERE TailNum IN ('N223SW') OR (DivTailNums[1] BETWEEN 'N904FR' AND 'N27213' OR DivTailNums[2] BETWEEN 'N904FR' AND 'N27213' OR DivTailNums[3] BETWEEN 'N904FR' AND 'N27213' OR DivTailNums[4] BETWEEN 'N904FR' AND 'N27213' OR DivTailNums[5] BETWEEN 'N904FR' AND 'N27213') AND FirstDepTime >= 736 ORDER BY DepartureDelayGroups LIMIT 10000"]}
{"sql":"SELECT AVG(NASDelay), MAX(LongestAddGTime), AVG(FirstDepTime) FROM mytable WHERE Origin BETWEEN 'SEA' AND 'SMF' LIMIT 24"}
{"sql":"SELECT DepDelay FROM mytable WHERE CarrierDelay BETWEEN 16 AND 86 LIMIT 1"}
{"sql":"SELECT DivAirports, Distance, ArrTime FROM mytable WHERE TotalAddGTime BETWEEN 30 AND 32 AND AirTime IN (238) ORDER BY DivDistance, Origin, CancellationCode LIMIT 7","hsqls":["SELECT DivAirports, Distance, ArrTime FROM mytable WHERE TotalAddGTime BETWEEN 30 AND 32 AND AirTime IN (238) ORDER BY DivDistance, Origin, CancellationCode LIMIT 10000"]}
{"sql":"SELECT MIN(\"Year\"), COUNT(DestWac), MAX(DestCityMarketID) FROM mytable WHERE DivWheelsOns IN (1724, 1120, 723, 1613) OR FlightNum < 2412 LIMIT 2","hsqls":["SELECT MIN(`Year`), COUNT(DestWac), MAX(DestCityMarketID)  FROM mytable WHERE (DivWheelsOns[1] IN (1724, 1120, 723, 1613) OR DivWheelsOns[2] IN (1724, 1120, 723, 1613) OR DivWheelsOns[3] IN (1724, 1120, 723, 1613) OR DivWheelsOns[4] IN (1724, 1120, 723, 1613) OR DivWheelsOns[5] IN (1724, 1120, 723, 1613)) OR FlightNum < 2412 LIMIT 10000"]}
{"sql":"SELECT MAX(OriginAirportSeqID), MIN(DestAirportID) FROM mytable LIMIT 8"}
{"sql":"SELECT AVG(ArrTime), AVG(DivDistance), MIN(NASDelay) FROM mytable LIMIT 22"}
{"sql":"SELECT DayOfWeek, MIN(ArrDel15), MIN(DepDelay), MAX(WeatherDelay) FROM mytable WHERE TaxiIn <> 94 OR Quarter BETWEEN 1 AND 1 AND AirlineID NOT IN (19690) GROUP BY DayOfWeek  ORDER BY DayOfWeek LIMIT 25","hsqls":["SELECT DayOfWeek, MIN(ArrDel15), MIN(DepDelay), MAX(WeatherDelay) FROM mytable WHERE TaxiIn <> 94 OR Quarter BETWEEN 1 AND 1 AND AirlineID NOT IN (19690) GROUP BY DayOfWeek  ORDER BY DayOfWeek LIMIT 25"]}
{"sql":"SELECT DivReachedDest, AVG(TotalAddGTime), COUNT(OriginStateFips), AVG(DestCityMarketID) FROM mytable WHERE DepTimeBlk NOT IN ('1100-1159', '2300-2359', '0600-0659', '0800-0859', '1900-1959') OR DepDelayMinutes IN (260.0, 111.0, 206.0) GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 9","hsqls":["SELECT DivReachedDest, AVG(TotalAddGTime), COUNT(OriginStateFips), AVG(DestCityMarketID) FROM mytable WHERE DepTimeBlk NOT IN ('1100-1159', '2300-2359', '0600-0659', '0800-0859', '1900-1959') OR DepDelayMinutes IN (260.0, 111.0, 206.0) GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 9"]}
{"sql":"SELECT OriginCityMarketID, ArrTime, ArrivalDelayGroups, MAX(ArrDelay), AVG(DestAirportID) FROM mytable GROUP BY OriginCityMarketID, ArrTime, ArrivalDelayGroups  ORDER BY OriginCityMarketID, ArrTime, ArrivalDelayGroups LIMIT 6","hsqls":["SELECT OriginCityMarketID, ArrTime, ArrivalDelayGroups, MAX(ArrDelay), AVG(DestAirportID) FROM mytable GROUP BY OriginCityMarketID, ArrTime, ArrivalDelayGroups  ORDER BY OriginCityMarketID, ArrTime, ArrivalDelayGroups LIMIT 6"]}
{"sql":"SELECT DestAirportSeqID, OriginAirportID, AVG(DepDelayMinutes) FROM mytable WHERE DestWac <= 22 OR ActualElapsedTime BETWEEN 207 AND 160 GROUP BY DestAirportSeqID, OriginAirportID  ORDER BY DestAirportSeqID, OriginAirportID LIMIT 25","hsqls":["SELECT DestAirportSeqID, OriginAirportID, AVG(DepDelayMinutes) FROM mytable WHERE DestWac <= 22 OR ActualElapsedTime BETWEEN 207 AND 160 GROUP BY DestAirportSeqID, OriginAirportID  ORDER BY DestAirportSeqID, OriginAirportID LIMIT 25"]}
{"sql":"SELECT DestStateFips, DayofMonth, DivArrDelay, SUM(ArrDelay), MIN(\"Month\"), MAX(ArrTime) FROM mytable GROUP BY DestStateFips, DayofMonth, DivArrDelay LIMIT 24","hsqls":["SELECT DestStateFips, DayofMonth, DivArrDelay, SUM(ArrDelay), MIN(`Month`), MAX(ArrTime) FROM mytable GROUP BY DestStateFips, DayofMonth, DivArrDelay LIMIT 24"]}
{"sql":"SELECT MIN(ArrTime), MAX(DestWac) FROM mytable LIMIT 7"}
{"sql":"SELECT CarrierDelay, TotalAddGTime, ArrivalDelayGroups FROM mytable WHERE TotalAddGTime >= 25 AND Origin IN ('LAR', 'ALB', 'CAK', 'MSO', 'FAR') AND DistanceGroup BETWEEN 3 AND 5 LIMIT 20"}
{"sql":"SELECT AirTime, AirlineID, \"Month\", COUNT(ActualElapsedTime) FROM mytable WHERE Flights > 1 OR DepDelay NOT IN (207.0, 49.0) GROUP BY AirTime, AirlineID, \"Month\" LIMIT 22","hsqls":["SELECT AirTime, AirlineID, Month, COUNT(ActualElapsedTime) FROM mytable WHERE Flights > 1 OR DepDelay NOT IN (207.0, 49.0) GROUP BY AirTime, AirlineID, `Month` LIMIT 22"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE TaxiOut BETWEEN 27 AND 68 ORDER BY SecurityDelay, DestAirportID LIMIT 13"}
{"sql":"SELECT ArrDelayMinutes, DivAirportLandings, DayOfWeek FROM mytable WHERE OriginAirportID NOT IN (15295, 11423) ORDER BY OriginStateFips, DayofMonth LIMIT 23"}
{"sql":"SELECT ArrTime, CancellationCode, OriginStateName FROM mytable WHERE DivAirports BETWEEN 'PIT' AND 'GTF' AND DivWheelsOffs IN (1733, 1222, 1906) OR ArrDel15 <= 1 ORDER BY ActualElapsedTime, DestStateName, NASDelay LIMIT 6","hsqls":["SELECT ArrTime, CancellationCode, OriginStateName FROM mytable WHERE (DivAirports[1] BETWEEN 'PIT' AND 'GTF' OR DivAirports[2] BETWEEN 'PIT' AND 'GTF' OR DivAirports[3] BETWEEN 'PIT' AND 'GTF' OR DivAirports[4] BETWEEN 'PIT' AND 'GTF' OR DivAirports[5] BETWEEN 'PIT' AND 'GTF') AND (DivWheelsOffs[1] IN (1733, 1222, 1906) OR DivWheelsOffs[2] IN (1733, 1222, 1906) OR DivWheelsOffs[3] IN (1733, 1222, 1906) OR DivWheelsOffs[4] IN (1733, 1222, 1906) OR DivWheelsOffs[5] IN (1733, 1222, 1906)) OR ArrDel15 <= 1 ORDER BY ActualElapsedTime, DestStateName, NASDelay LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, WheelsOn, COUNT(*) FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 9 GROUP BY DivReachedDest, WheelsOn  ORDER BY DivReachedDest, WheelsOn LIMIT 5","hsqls":["SELECT DivReachedDest, WheelsOn, COUNT(*) FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 9 GROUP BY DivReachedDest, WheelsOn  ORDER BY DivReachedDest, WheelsOn LIMIT 5"]}
{"sql":"SELECT TaxiIn, Cancelled FROM mytable WHERE DepDelay IN (145.0, 28.0, 9.0, 142.0) ORDER BY OriginStateFips, ArrTime, ArrDelayMinutes LIMIT 23"}
{"sql":"SELECT ArrDel15, DepTimeBlk, DaysSinceEpoch, COUNT(*) FROM mytable WHERE ArrTimeBlk BETWEEN '1800-1859' AND '1300-1359' AND NASDelay BETWEEN 63 AND 14 GROUP BY ArrDel15, DepTimeBlk, DaysSinceEpoch  ORDER BY ArrDel15, DepTimeBlk, DaysSinceEpoch LIMIT 3","hsqls":["SELECT ArrDel15, DepTimeBlk, DaysSinceEpoch, COUNT(*) FROM mytable WHERE ArrTimeBlk BETWEEN '1800-1859' AND '1300-1359' AND NASDelay BETWEEN 63 AND 14 GROUP BY ArrDel15, DepTimeBlk, DaysSinceEpoch  ORDER BY ArrDel15, DepTimeBlk, DaysSinceEpoch LIMIT 3"]}
{"sql":"SELECT DepTime, DestCityName, Origin FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 AND DistanceGroup IN (2) ORDER BY DepartureDelayGroups, AirTime, CRSElapsedTime LIMIT 4","hsqls":["SELECT DepTime, DestCityName, Origin FROM mytable WHERE `Month` BETWEEN 1 AND 1 AND DistanceGroup IN (2) ORDER BY DepartureDelayGroups, AirTime, CRSElapsedTime LIMIT 4"]}
{"sql":"SELECT Quarter, DivAirportSeqIDs, DaysSinceEpoch FROM mytable WHERE DivDistance <= 183 OR OriginWac <= 37 AND DivAirports IN ('ILM') LIMIT 18","hsqls":["SELECT Quarter, DivAirportSeqIDs, DaysSinceEpoch FROM mytable WHERE DivDistance <= 183 OR OriginWac <= 37 AND (DivAirports[1] IN ('ILM') OR DivAirports[2] IN ('ILM') OR DivAirports[3] IN ('ILM') OR DivAirports[4] IN ('ILM') OR DivAirports[5] IN ('ILM')) LIMIT 10000"]}
{"sql":"SELECT Distance FROM mytable WHERE DivAirportLandings < 9 LIMIT 27"}
{"sql":"SELECT Carrier, WeatherDelay, DaysSinceEpoch FROM mytable WHERE DivTailNums < 'N3732J' ORDER BY DepDel15 LIMIT 21","hsqls":["SELECT Carrier, WeatherDelay, DaysSinceEpoch FROM mytable WHERE (DivTailNums[1] < 'N3732J' OR DivTailNums[2] < 'N3732J' OR DivTailNums[3] < 'N3732J' OR DivTailNums[4] < 'N3732J' OR DivTailNums[5] < 'N3732J') ORDER BY DepDel15 LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, DivDistance FROM mytable WHERE DistanceGroup NOT IN (2, 11) LIMIT 29"}
{"sql":"SELECT DepDelay, ArrTimeBlk FROM mytable WHERE DepDel15 BETWEEN -9999 AND 0 AND DivTotalGTimes BETWEEN 47 AND 52 ORDER BY WheelsOff, TaxiIn, ArrDelay LIMIT 6","hsqls":["SELECT DepDelay, ArrTimeBlk FROM mytable WHERE DepDel15 BETWEEN -9999 AND 0 AND (DivTotalGTimes[1] BETWEEN 47 AND 52 OR DivTotalGTimes[2] BETWEEN 47 AND 52 OR DivTotalGTimes[3] BETWEEN 47 AND 52 OR DivTotalGTimes[4] BETWEEN 47 AND 52 OR DivTotalGTimes[5] BETWEEN 47 AND 52) ORDER BY WheelsOff, TaxiIn, ArrDelay LIMIT 10000"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE FlightDate < '2014-01-11' OR CarrierDelay IN (4, 343, 14, 119) ORDER BY DepDelay, DestState, DepDelayMinutes LIMIT 5"}
{"sql":"SELECT DivReachedDest FROM mytable WHERE DivLongestGTimes IN (58.0, 27.0) AND ArrTimeBlk NOT IN ('0700-0759', '1100-1159', '1000-1059', '0600-0659', '1800-1859') ORDER BY FlightDate, DepTime, CRSElapsedTime LIMIT 24","hsqls":["SELECT DivReachedDest FROM mytable WHERE (DivLongestGTimes[1] IN (58.0, 27.0) OR DivLongestGTimes[2] IN (58.0, 27.0) OR DivLongestGTimes[3] IN (58.0, 27.0) OR DivLongestGTimes[4] IN (58.0, 27.0) OR DivLongestGTimes[5] IN (58.0, 27.0)) AND ArrTimeBlk NOT IN ('0700-0759', '1100-1159', '1000-1059', '0600-0659', '1800-1859') ORDER BY FlightDate, DepTime, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT OriginCityName, DepTimeBlk FROM mytable WHERE ArrDel15 <= -9999 OR DivAirportLandings NOT IN (2, 1, 9) AND TaxiOut NOT IN (7, 112, 70, 16, 13) ORDER BY LateAircraftDelay, TailNum, DayofMonth LIMIT 29"}
{"sql":"SELECT AVG(ActualElapsedTime) FROM mytable WHERE FlightNum >= 5020 LIMIT 23"}
{"sql":"SELECT DivLongestGTimes, Flights, TaxiIn FROM mytable WHERE CarrierDelay < 243 LIMIT 1","hsqls":["SELECT DivLongestGTimes, Flights, TaxiIn FROM mytable WHERE CarrierDelay < 243 LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DivWheelsOns, Diverted FROM mytable WHERE CRSElapsedTime BETWEEN 201 AND 137 AND DestCityName BETWEEN 'Newport News/Williamsburg, VA' AND 'Mammoth Lakes, CA' AND DepDelayMinutes NOT IN (75.0) LIMIT 14","hsqls":["SELECT WheelsOff, DivWheelsOns, Diverted FROM mytable WHERE CRSElapsedTime BETWEEN 201 AND 137 AND DestCityName BETWEEN 'Newport News/Williamsburg, VA' AND 'Mammoth Lakes, CA' AND DepDelayMinutes NOT IN (75.0) LIMIT 10000"]}
{"sql":"SELECT WheelsOff, \"Year\", DivArrDelay, SUM(AirlineID) FROM mytable WHERE DestAirportID = 14730 AND FlightDate <> '2014-01-08' AND TailNum <> 'N965WN' GROUP BY WheelsOff, \"Year\", DivArrDelay LIMIT 11","hsqls":["SELECT WheelsOff, Year, DivArrDelay, SUM(AirlineID) FROM mytable WHERE DestAirportID = 14730 AND FlightDate <> '2014-01-08' AND TailNum <> 'N965WN' GROUP BY WheelsOff, Year, DivArrDelay LIMIT 11"]}
{"sql":"SELECT COUNT(DestStateFips) FROM mytable WHERE LongestAddGTime NOT IN (58, 54, 28) LIMIT 17"}
{"sql":"SELECT TotalAddGTime, DestCityName, DayofMonth FROM mytable WHERE DepDelay >= 3.0 AND DivAirportIDs > 13424 OR DivLongestGTimes <= 20.0 ORDER BY CarrierDelay LIMIT 16","hsqls":["SELECT TotalAddGTime, DestCityName, DayofMonth FROM mytable WHERE DepDelay >= 3.0 AND (DivAirportIDs[1] > 13424 OR DivAirportIDs[2] > 13424 OR DivAirportIDs[3] > 13424 OR DivAirportIDs[4] > 13424 OR DivAirportIDs[5] > 13424) OR (DivLongestGTimes[1] <= 20.0 OR DivLongestGTimes[2] <= 20.0 OR DivLongestGTimes[3] <= 20.0 OR DivLongestGTimes[4] <= 20.0 OR DivLongestGTimes[5] <= 20.0) ORDER BY CarrierDelay LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, OriginCityMarketID, OriginAirportID FROM mytable WHERE Origin BETWEEN 'LAR' AND 'MOB' AND WeatherDelay IN (43, 22) ORDER BY OriginState, TailNum LIMIT 11"}
{"sql":"SELECT Cancelled, \"Month\", MIN(DepDel15) FROM mytable WHERE WheelsOff NOT IN (1411, 1239) OR WheelsOff NOT IN (1051, 1448, 1223) GROUP BY Cancelled, \"Month\" LIMIT 19","hsqls":["SELECT Cancelled, Month, MIN(DepDel15) FROM mytable WHERE WheelsOff NOT IN (1411, 1239) OR WheelsOff NOT IN (1051, 1448, 1223) GROUP BY Cancelled, `Month` LIMIT 19"]}
{"sql":"SELECT TailNum FROM mytable ORDER BY OriginCityMarketID, Cancelled, OriginWac"}
{"sql":"SELECT DestState FROM mytable WHERE CRSElapsedTime BETWEEN 145 AND 249 OR Distance BETWEEN 1797 AND 984 AND ArrTimeBlk >= '1500-1559' ORDER BY AirlineID LIMIT 10"}
{"sql":"SELECT DivDistance, FlightDate, DestCityMarketID FROM mytable WHERE DestWac BETWEEN 65 AND 38 ORDER BY OriginCityName, ActualElapsedTime, CRSElapsedTime LIMIT 2"}
{"sql":"SELECT ActualElapsedTime, SUM(DivReachedDest), MAX(DepDelay) FROM mytable WHERE DestAirportID BETWEEN 10551 AND 10792 GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 15","hsqls":["SELECT ActualElapsedTime, SUM(DivReachedDest), MAX(DepDelay) FROM mytable WHERE DestAirportID BETWEEN 10551 AND 10792 GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 15"]}
{"sql":"SELECT DivAirportSeqIDs FROM mytable ORDER BY LateAircraftDelay, TaxiIn LIMIT 3","hsqls":["SELECT DivAirportSeqIDs FROM mytable ORDER BY LateAircraftDelay, TaxiIn LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, DivWheelsOffs FROM mytable WHERE DestState <> 'MN' ORDER BY Cancelled LIMIT 12","hsqls":["SELECT OriginCityMarketID, DivWheelsOffs FROM mytable WHERE DestState <> 'MN' ORDER BY Cancelled LIMIT 10000"]}
{"sql":"SELECT CarrierDelay FROM mytable WHERE OriginCityName <> 'Palm Springs, CA' ORDER BY DepDelayMinutes LIMIT 13"}
{"sql":"SELECT DivReachedDest, COUNT(*) FROM mytable WHERE DestCityMarketID IN (33728, 31205, 30408, 32206) AND OriginStateFips NOT IN (18, 25, 8, 27) GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 8","hsqls":["SELECT DivReachedDest, COUNT(*) FROM mytable WHERE DestCityMarketID IN (33728, 31205, 30408, 32206) AND OriginStateFips NOT IN (18, 25, 8, 27) GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 8"]}
{"sql":"SELECT Diverted, Quarter, ArrDelay FROM mytable WHERE TailNum IN ('N584SW', 'N12957') AND DestCityName BETWEEN 'Dothan, AL' AND 'Aspen, CO' ORDER BY DestAirportID LIMIT 21"}
{"sql":"SELECT COUNT(WeatherDelay) FROM mytable LIMIT 19"}
{"sql":"SELECT CRSArrTime, Cancelled, DestStateName, MIN(WeatherDelay), MIN(DivDistance) FROM mytable WHERE TaxiIn < 127 AND ArrTime = 1649 OR Diverted IN (1, 0) GROUP BY CRSArrTime, Cancelled, DestStateName  ORDER BY CRSArrTime, Cancelled, DestStateName LIMIT 8","hsqls":["SELECT CRSArrTime, Cancelled, DestStateName, MIN(WeatherDelay), MIN(DivDistance) FROM mytable WHERE TaxiIn < 127 AND ArrTime = 1649 OR Diverted IN (1, 0) GROUP BY CRSArrTime, Cancelled, DestStateName  ORDER BY CRSArrTime, Cancelled, DestStateName LIMIT 8"]}
{"sql":"SELECT DepTime, AirlineID, MIN(LateAircraftDelay), SUM(SecurityDelay) FROM mytable WHERE ArrivalDelayGroups < 3 AND AirTime IN (522, 58, 175, 123, 313) OR LongestAddGTime NOT IN (47, 55, 24, 8) GROUP BY DepTime, AirlineID  ORDER BY DepTime, AirlineID LIMIT 27","hsqls":["SELECT DepTime, AirlineID, MIN(LateAircraftDelay), SUM(SecurityDelay) FROM mytable WHERE ArrivalDelayGroups < 3 AND AirTime IN (522, 58, 175, 123, 313) OR LongestAddGTime NOT IN (47, 55, 24, 8) GROUP BY DepTime, AirlineID  ORDER BY DepTime, AirlineID LIMIT 27"]}
{"sql":"SELECT MIN(OriginWac), AVG(DivActualElapsedTime) FROM mytable WHERE CRSElapsedTime NOT IN (239, 354, 358, 53) OR CRSArrTime <> 1741 LIMIT 29"}
{"sql":"SELECT DestCityMarketID, COUNT(ArrTime) FROM mytable WHERE AirlineID BETWEEN 19977 AND 21171 GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 10","hsqls":["SELECT DestCityMarketID, COUNT(ArrTime) FROM mytable WHERE AirlineID BETWEEN 19977 AND 21171 GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 10"]}
{"sql":"SELECT DepDelayMinutes, TailNum, DepTimeBlk, COUNT(*) FROM mytable WHERE Distance <= 517 AND ArrTime NOT IN (955) OR DestState BETWEEN 'MS' AND 'AL' GROUP BY DepDelayMinutes, TailNum, DepTimeBlk  ORDER BY DepDelayMinutes, TailNum, DepTimeBlk LIMIT 26","hsqls":["SELECT DepDelayMinutes, TailNum, DepTimeBlk, COUNT(*) FROM mytable WHERE Distance <= 517 AND ArrTime NOT IN (955) OR DestState BETWEEN 'MS' AND 'AL' GROUP BY DepDelayMinutes, TailNum, DepTimeBlk  ORDER BY DepDelayMinutes, TailNum, DepTimeBlk LIMIT 26"]}
{"sql":"SELECT OriginAirportSeqID, DayofMonth, DivActualElapsedTime, SUM(CarrierDelay), MAX(DestStateFips) FROM mytable GROUP BY OriginAirportSeqID, DayofMonth, DivActualElapsedTime  ORDER BY OriginAirportSeqID, DayofMonth, DivActualElapsedTime LIMIT 26","hsqls":["SELECT OriginAirportSeqID, DayofMonth, DivActualElapsedTime, SUM(CarrierDelay), MAX(DestStateFips) FROM mytable GROUP BY OriginAirportSeqID, DayofMonth, DivActualElapsedTime  ORDER BY OriginAirportSeqID, DayofMonth, DivActualElapsedTime LIMIT 26"]}
{"sql":"SELECT WheelsOff, COUNT(*) FROM mytable WHERE FlightDate IN ('2014-01-04', '2014-01-18', '2014-01-10') AND LongestAddGTime BETWEEN 28 AND 54 GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 2","hsqls":["SELECT WheelsOff, COUNT(*) FROM mytable WHERE FlightDate IN ('2014-01-04', '2014-01-18', '2014-01-10') AND LongestAddGTime BETWEEN 28 AND 54 GROUP BY WheelsOff  ORDER BY WheelsOff LIMIT 2"]}
{"sql":"SELECT OriginAirportSeqID, DivDistance FROM mytable WHERE OriginAirportSeqID NOT IN (1541202, 1591902) OR AirlineID NOT IN (20304, 20436, 19930, 19977) ORDER BY Diverted, FlightNum, DestAirportID LIMIT 17"}
{"sql":"SELECT CRSArrTime, AirTime FROM mytable WHERE DivAirports BETWEEN 'TWF' AND 'RFD' OR ArrDelay BETWEEN 363.0 AND 159.0 OR OriginStateName BETWEEN 'Alabama' AND 'Oregon' ORDER BY \"Year\", \"Month\" LIMIT 16","hsqls":["SELECT CRSArrTime, AirTime FROM mytable WHERE (DivAirports[1] BETWEEN 'TWF' AND 'RFD' OR DivAirports[2] BETWEEN 'TWF' AND 'RFD' OR DivAirports[3] BETWEEN 'TWF' AND 'RFD' OR DivAirports[4] BETWEEN 'TWF' AND 'RFD' OR DivAirports[5] BETWEEN 'TWF' AND 'RFD') OR ArrDelay BETWEEN 363.0 AND 159.0 OR OriginStateName BETWEEN 'Alabama' AND 'Oregon' ORDER BY Year, `Month` LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, TotalAddGTime, DestStateName, MIN(DivActualElapsedTime), MIN(DepartureDelayGroups), AVG(Cancelled) FROM mytable WHERE DivAirportIDs > 16257 OR CRSDepTime BETWEEN 1243 AND 643 OR ArrTimeBlk BETWEEN '2000-2059' AND '2200-2259' GROUP BY WeatherDelay, TotalAddGTime, DestStateName LIMIT 13","hsqls":["SELECT WeatherDelay, TotalAddGTime, DestStateName, MIN(DivActualElapsedTime), MIN(DepartureDelayGroups), AVG(Cancelled) FROM mytable WHERE (DivAirportIDs[1] > 16257 OR DivAirportIDs[2] > 16257 OR DivAirportIDs[3] > 16257 OR DivAirportIDs[4] > 16257 OR DivAirportIDs[5] > 16257) OR CRSDepTime BETWEEN 1243 AND 643 OR ArrTimeBlk BETWEEN '2000-2059' AND '2200-2259' GROUP BY WeatherDelay, TotalAddGTime, DestStateName LIMIT 10000"]}
{"sql":"SELECT Cancelled, DestStateName, MIN(DepDel15), MIN(ArrTime), SUM(TaxiIn) FROM mytable GROUP BY Cancelled, DestStateName  ORDER BY Cancelled, DestStateName LIMIT 29","hsqls":["SELECT Cancelled, DestStateName, MIN(DepDel15), MIN(ArrTime), SUM(TaxiIn) FROM mytable GROUP BY Cancelled, DestStateName  ORDER BY Cancelled, DestStateName LIMIT 29"]}
{"sql":"SELECT DivWheelsOffs, DepTimeBlk FROM mytable WHERE TotalAddGTime BETWEEN 39 AND 37 LIMIT 27","hsqls":["SELECT DivWheelsOffs, DepTimeBlk FROM mytable WHERE TotalAddGTime BETWEEN 39 AND 37 LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay FROM mytable LIMIT 1"}
{"sql":"SELECT COUNT(WeatherDelay) FROM mytable WHERE DestStateFips BETWEEN 51 AND 17 AND Carrier <> 'DL' OR DestStateFips > 28 LIMIT 13"}
{"sql":"SELECT TaxiIn, DestAirportSeqID FROM mytable WHERE DivWheelsOns BETWEEN 1744 AND 1334 OR DestCityName IN ('Santa Barbara, CA', 'San Jose, CA', 'Joplin, MO', 'Panama City, FL') OR DepDelay BETWEEN 225.0 AND 17.0 ORDER BY UniqueCarrier LIMIT 27","hsqls":["SELECT TaxiIn, DestAirportSeqID FROM mytable WHERE (DivWheelsOns[1] BETWEEN 1744 AND 1334 OR DivWheelsOns[2] BETWEEN 1744 AND 1334 OR DivWheelsOns[3] BETWEEN 1744 AND 1334 OR DivWheelsOns[4] BETWEEN 1744 AND 1334 OR DivWheelsOns[5] BETWEEN 1744 AND 1334) OR DestCityName IN ('Santa Barbara, CA', 'San Jose, CA', 'Joplin, MO', 'Panama City, FL') OR DepDelay BETWEEN 225.0 AND 17.0 ORDER BY UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT FlightDate, DepDel15, DayOfWeek FROM mytable WHERE OriginAirportID IN (15411, 14113, 10372, 15841) AND CRSElapsedTime BETWEEN 83 AND 147 ORDER BY DistanceGroup, TailNum LIMIT 5"}
{"sql":"SELECT COUNT(OriginWac) FROM mytable WHERE ActualElapsedTime BETWEEN 122 AND 133 LIMIT 15"}
{"sql":"SELECT ArrTimeBlk, DestAirportID FROM mytable WHERE Carrier NOT IN ('B6') OR DepDelay IN (100.0) LIMIT 28"}
{"sql":"SELECT Cancelled, SUM(DestAirportSeqID), SUM(OriginAirportID), MAX(\"Month\") FROM mytable WHERE DivLongestGTimes IN (46.0, 152.0, 56.0, 1.0) OR ArrivalDelayGroups = 2 GROUP BY Cancelled","hsqls":["SELECT Cancelled, SUM(DestAirportSeqID), SUM(OriginAirportID), MAX(`Month`) FROM mytable WHERE (DivLongestGTimes[1] IN (46.0, 152.0, 56.0, 1.0) OR DivLongestGTimes[2] IN (46.0, 152.0, 56.0, 1.0) OR DivLongestGTimes[3] IN (46.0, 152.0, 56.0, 1.0) OR DivLongestGTimes[4] IN (46.0, 152.0, 56.0, 1.0) OR DivLongestGTimes[5] IN (46.0, 152.0, 56.0, 1.0)) OR ArrivalDelayGroups = 2 GROUP BY Cancelled LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, FlightNum, Cancelled, COUNT(OriginStateFips), MAX(LateAircraftDelay) FROM mytable WHERE OriginCityMarketID NOT IN (31308, 30146, 31503, 33485) AND OriginAirportID NOT IN (14674, 14122, 10685) OR DestCityName = 'State College, PA' GROUP BY FirstDepTime, FlightNum, Cancelled  ORDER BY FirstDepTime, FlightNum, Cancelled LIMIT 23","hsqls":["SELECT FirstDepTime, FlightNum, Cancelled, COUNT(OriginStateFips), MAX(LateAircraftDelay) FROM mytable WHERE OriginCityMarketID NOT IN (31308, 30146, 31503, 33485) AND OriginAirportID NOT IN (14674, 14122, 10685) OR DestCityName = 'State College, PA' GROUP BY FirstDepTime, FlightNum, Cancelled  ORDER BY FirstDepTime, FlightNum, Cancelled LIMIT 23"]}
{"sql":"SELECT OriginState, \"Month\", MAX(ArrDel15), AVG(DepDel15), MAX(\"Month\") FROM mytable WHERE DivWheelsOffs > 1616 AND OriginCityName <= 'Bakersfield, CA' GROUP BY OriginState, \"Month\" LIMIT 29","hsqls":["SELECT OriginState, Month, MAX(ArrDel15), AVG(DepDel15), MAX(`Month`) FROM mytable WHERE (DivWheelsOffs[1] > 1616 OR DivWheelsOffs[2] > 1616 OR DivWheelsOffs[3] > 1616 OR DivWheelsOffs[4] > 1616 OR DivWheelsOffs[5] > 1616) AND OriginCityName <= 'Bakersfield, CA' GROUP BY OriginState, `Month` LIMIT 10000"]}
{"sql":"SELECT FirstDepTime FROM mytable WHERE AirlineID IN (19805, 19930, 19977) AND DivWheelsOns IN (1859, 1134, 1107, 2126) ORDER BY \"Year\", FlightDate, DestCityName LIMIT 26","hsqls":["SELECT FirstDepTime FROM mytable WHERE AirlineID IN (19805, 19930, 19977) AND (DivWheelsOns[1] IN (1859, 1134, 1107, 2126) OR DivWheelsOns[2] IN (1859, 1134, 1107, 2126) OR DivWheelsOns[3] IN (1859, 1134, 1107, 2126) OR DivWheelsOns[4] IN (1859, 1134, 1107, 2126) OR DivWheelsOns[5] IN (1859, 1134, 1107, 2126)) ORDER BY Year, FlightDate, DestCityName LIMIT 10000"]}
{"sql":"SELECT ArrDel15, SUM(DivDistance) FROM mytable WHERE DestState IN ('NC', 'MS', 'MD', 'SC') AND DestState NOT IN ('DE', 'CT', 'CO', 'FL', 'AL') GROUP BY ArrDel15  ORDER BY ArrDel15 LIMIT 24","hsqls":["SELECT ArrDel15, SUM(DivDistance) FROM mytable WHERE DestState IN ('NC', 'MS', 'MD', 'SC') AND DestState NOT IN ('DE', 'CT', 'CO', 'FL', 'AL') GROUP BY ArrDel15  ORDER BY ArrDel15 LIMIT 24"]}
{"sql":"SELECT ArrDelayMinutes, DivArrDelay, COUNT(*) FROM mytable WHERE DivAirportIDs = 12217 OR DestCityName <> 'Phoenix, AZ' OR DepartureDelayGroups < 2 GROUP BY ArrDelayMinutes, DivArrDelay LIMIT 17","hsqls":["SELECT ArrDelayMinutes, DivArrDelay, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] = 12217 OR DivAirportIDs[2] = 12217 OR DivAirportIDs[3] = 12217 OR DivAirportIDs[4] = 12217 OR DivAirportIDs[5] = 12217) OR DestCityName <> 'Phoenix, AZ' OR DepartureDelayGroups < 2 GROUP BY ArrDelayMinutes, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT OriginStateFips FROM mytable WHERE ArrDel15 NOT IN (1, 0) LIMIT 29"}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DepTime BETWEEN 1447 AND 2349 AND AirlineID BETWEEN 19393 AND 19805 ORDER BY SecurityDelay, DivAirportLandings LIMIT 29"}
{"sql":"SELECT OriginAirportSeqID FROM mytable WHERE DistanceGroup NOT IN (3) OR TaxiOut BETWEEN 4 AND 121 ORDER BY TotalAddGTime LIMIT 22"}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE DepTimeBlk NOT IN ('2200-2259', '0700-0759', '1000-1059', '1900-1959') AND WeatherDelay BETWEEN 105 AND 237 ORDER BY SecurityDelay, CancellationCode","hsqls":["SELECT DivWheelsOns FROM mytable WHERE DepTimeBlk NOT IN ('2200-2259', '0700-0759', '1000-1059', '1900-1959') AND WeatherDelay BETWEEN 105 AND 237 ORDER BY SecurityDelay, CancellationCode LIMIT 10000"]}
{"sql":"SELECT TaxiIn, COUNT(*) FROM mytable GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 19","hsqls":["SELECT TaxiIn, COUNT(*) FROM mytable GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 19"]}
{"sql":"SELECT TaxiOut, DivActualElapsedTime FROM mytable WHERE DaysSinceEpoch <= 16082 ORDER BY DepDelay, ArrDelayMinutes, DestAirportID"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DepTimeBlk >= '1600-1659' LIMIT 13"}
{"sql":"SELECT DestStateFips, TailNum, CRSElapsedTime, COUNT(*) FROM mytable WHERE DepTime BETWEEN 1026 AND 1639 GROUP BY DestStateFips, TailNum, CRSElapsedTime  ORDER BY DestStateFips, TailNum, CRSElapsedTime LIMIT 25","hsqls":["SELECT DestStateFips, TailNum, CRSElapsedTime, COUNT(*) FROM mytable WHERE DepTime BETWEEN 1026 AND 1639 GROUP BY DestStateFips, TailNum, CRSElapsedTime  ORDER BY DestStateFips, TailNum, CRSElapsedTime LIMIT 25"]}
{"sql":"SELECT DepDelay, SecurityDelay, NASDelay, COUNT(*) FROM mytable WHERE DivAirportSeqIDs < 1348502 AND DestAirportID = 14262 GROUP BY DepDelay, SecurityDelay, NASDelay LIMIT 3","hsqls":["SELECT DepDelay, SecurityDelay, NASDelay, COUNT(*) FROM mytable WHERE (DivAirportSeqIDs[1] < 1348502 OR DivAirportSeqIDs[2] < 1348502 OR DivAirportSeqIDs[3] < 1348502 OR DivAirportSeqIDs[4] < 1348502 OR DivAirportSeqIDs[5] < 1348502) AND DestAirportID = 14262 GROUP BY DepDelay, SecurityDelay, NASDelay LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, NASDelay, AirlineID FROM mytable WHERE DestAirportSeqID NOT IN (1324402) ORDER BY ArrDelayMinutes, Dest LIMIT 3"}
{"sql":"SELECT Flights FROM mytable ORDER BY DestCityMarketID, DayOfWeek LIMIT 6"}
{"sql":"SELECT DepDelay, COUNT(*) FROM mytable WHERE TaxiIn IN (59, 17, 38) GROUP BY DepDelay  ORDER BY DepDelay LIMIT 11","hsqls":["SELECT DepDelay, COUNT(*) FROM mytable WHERE TaxiIn IN (59, 17, 38) GROUP BY DepDelay  ORDER BY DepDelay LIMIT 11"]}
{"sql":"SELECT WeatherDelay, ArrDelayMinutes, UniqueCarrier, COUNT(Dest) FROM mytable WHERE AirTime NOT IN (212, 155, 274, 238) AND DestStateName NOT IN ('Delaware', 'Washington', 'Oklahoma') GROUP BY WeatherDelay, ArrDelayMinutes, UniqueCarrier  ORDER BY WeatherDelay, ArrDelayMinutes, UniqueCarrier LIMIT 11","hsqls":["SELECT WeatherDelay, ArrDelayMinutes, UniqueCarrier, COUNT(Dest) FROM mytable WHERE AirTime NOT IN (212, 155, 274, 238) AND DestStateName NOT IN ('Delaware', 'Washington', 'Oklahoma') GROUP BY WeatherDelay, ArrDelayMinutes, UniqueCarrier  ORDER BY WeatherDelay, ArrDelayMinutes, UniqueCarrier LIMIT 11"]}
{"sql":"SELECT AirTime, DestCityMarketID FROM mytable WHERE DestWac NOT IN (67, 51, 82, 73, 14) ORDER BY SecurityDelay LIMIT 13"}
{"sql":"SELECT DivWheelsOffs, DestCityMarketID FROM mytable WHERE DestStateName BETWEEN 'Virginia' AND 'Alabama' AND CRSArrTime >= 2204 AND DepartureDelayGroups BETWEEN 2 AND 11 LIMIT 6","hsqls":["SELECT DivWheelsOffs, DestCityMarketID FROM mytable WHERE DestStateName BETWEEN 'Virginia' AND 'Alabama' AND CRSArrTime >= 2204 AND DepartureDelayGroups BETWEEN 2 AND 11 LIMIT 10000"]}
{"sql":"SELECT ArrDel15 FROM mytable ORDER BY DestStateFips, DepTime, UniqueCarrier LIMIT 13"}
{"sql":"SELECT WeatherDelay, DestCityName, DepTimeBlk FROM mytable WHERE ArrTimeBlk <= '1400-1459' AND DestAirportID = 10754 LIMIT 21"}
{"sql":"SELECT OriginStateFips, SUM(Cancelled), AVG(DepDel15), MAX(ActualElapsedTime) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND ArrivalDelayGroups IN (-1, 5, 8, 11) AND DestStateName BETWEEN 'Vermont' AND 'North Dakota' GROUP BY OriginStateFips LIMIT 23","hsqls":["SELECT OriginStateFips, SUM(Cancelled), AVG(DepDel15), MAX(ActualElapsedTime) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND ArrivalDelayGroups IN (-1, 5, 8, 11) AND DestStateName BETWEEN 'Vermont' AND 'North Dakota' GROUP BY OriginStateFips LIMIT 23"]}
{"sql":"SELECT DivWheelsOns FROM mytable ORDER BY OriginStateFips, DivAirportLandings, CRSElapsedTime LIMIT 27","hsqls":["SELECT DivWheelsOns FROM mytable ORDER BY OriginStateFips, DivAirportLandings, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, Quarter, TailNum, SUM(TaxiOut) FROM mytable GROUP BY FirstDepTime, Quarter, TailNum  ORDER BY FirstDepTime, Quarter, TailNum LIMIT 18","hsqls":["SELECT FirstDepTime, Quarter, TailNum, SUM(TaxiOut) FROM mytable GROUP BY FirstDepTime, Quarter, TailNum  ORDER BY FirstDepTime, Quarter, TailNum LIMIT 18"]}
{"sql":"SELECT DayofMonth, DivTotalGTimes FROM mytable WHERE ActualElapsedTime BETWEEN 535 AND 502 AND Distance BETWEEN 329 AND 1725 AND \"Year\" IN (2014) LIMIT 8","hsqls":["SELECT DayofMonth, DivTotalGTimes FROM mytable WHERE ActualElapsedTime BETWEEN 535 AND 502 AND Distance BETWEEN 329 AND 1725 AND `Year` IN (2014) LIMIT 10000"]}
{"sql":"SELECT WheelsOn FROM mytable ORDER BY DepartureDelayGroups, SecurityDelay, DivActualElapsedTime LIMIT 6"}
{"sql":"SELECT DivReachedDest, Diverted FROM mytable WHERE DayofMonth <= 19 ORDER BY \"Year\" LIMIT 27","hsqls":["SELECT DivReachedDest, Diverted FROM mytable WHERE DayofMonth <= 19 ORDER BY `Year` LIMIT 27"]}
{"sql":"SELECT UniqueCarrier, MIN(DepDelayMinutes), AVG(DestWac) FROM mytable WHERE UniqueCarrier BETWEEN 'OO' AND 'FL' OR SecurityDelay IN (0, 18) GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 17","hsqls":["SELECT UniqueCarrier, MIN(DepDelayMinutes), AVG(DestWac) FROM mytable WHERE UniqueCarrier BETWEEN 'OO' AND 'FL' OR SecurityDelay IN (0, 18) GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 17"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE FlightDate <= '2014-01-13' OR AirTime NOT IN (141) LIMIT 5"}
{"sql":"SELECT OriginState, OriginStateName FROM mytable WHERE DestCityMarketID BETWEEN 33792 AND 31641 OR DayOfWeek BETWEEN 6 AND 3 AND DestState BETWEEN 'AL' AND 'RI' ORDER BY DivAirportLandings LIMIT 7"}
{"sql":"SELECT ActualElapsedTime, CRSDepTime FROM mytable WHERE DivAirportIDs BETWEEN 14574 AND 11252 LIMIT 18","hsqls":["SELECT ActualElapsedTime, CRSDepTime FROM mytable WHERE (DivAirportIDs[1] BETWEEN 14574 AND 11252 OR DivAirportIDs[2] BETWEEN 14574 AND 11252 OR DivAirportIDs[3] BETWEEN 14574 AND 11252 OR DivAirportIDs[4] BETWEEN 14574 AND 11252 OR DivAirportIDs[5] BETWEEN 14574 AND 11252) LIMIT 10000"]}
{"sql":"SELECT OriginCityName, OriginStateName, COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND DivAirportLandings BETWEEN 9 AND 2 GROUP BY OriginCityName, OriginStateName  ORDER BY OriginCityName, OriginStateName LIMIT 29","hsqls":["SELECT OriginCityName, OriginStateName, COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND DivAirportLandings BETWEEN 9 AND 2 GROUP BY OriginCityName, OriginStateName  ORDER BY OriginCityName, OriginStateName LIMIT 29"]}
{"sql":"SELECT MIN(DepTime) FROM mytable WHERE WeatherDelay BETWEEN 68 AND 54 LIMIT 27"}
{"sql":"SELECT ArrDelay, COUNT(FlightNum), COUNT(DistanceGroup) FROM mytable WHERE DivActualElapsedTime BETWEEN 333 AND 255 AND DayofMonth >= 2 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 18","hsqls":["SELECT ArrDelay, COUNT(FlightNum), COUNT(DistanceGroup) FROM mytable WHERE DivActualElapsedTime BETWEEN 333 AND 255 AND DayofMonth >= 2 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 18"]}
{"sql":"SELECT OriginAirportSeqID, DivActualElapsedTime FROM mytable ORDER BY OriginAirportSeqID, CRSElapsedTime LIMIT 29"}
{"sql":"SELECT OriginState, \"Month\" FROM mytable LIMIT 5","hsqls":["SELECT OriginState, `Month` FROM mytable LIMIT 5"]}
{"sql":"SELECT DepDelay FROM mytable WHERE DayofMonth NOT IN (14) ORDER BY Dest LIMIT 10"}
{"sql":"SELECT OriginCityMarketID, CRSArrTime, ArrTimeBlk, SUM(ActualElapsedTime) FROM mytable WHERE SecurityDelay < 18 OR DepTimeBlk BETWEEN '1900-1959' AND '2300-2359' GROUP BY OriginCityMarketID, CRSArrTime, ArrTimeBlk  ORDER BY OriginCityMarketID, CRSArrTime, ArrTimeBlk LIMIT 6","hsqls":["SELECT OriginCityMarketID, CRSArrTime, ArrTimeBlk, SUM(ActualElapsedTime) FROM mytable WHERE SecurityDelay < 18 OR DepTimeBlk BETWEEN '1900-1959' AND '2300-2359' GROUP BY OriginCityMarketID, CRSArrTime, ArrTimeBlk  ORDER BY OriginCityMarketID, CRSArrTime, ArrTimeBlk LIMIT 6"]}
{"sql":"SELECT OriginCityMarketID, DestStateName, DivTailNums FROM mytable WHERE TaxiIn <= 48 ORDER BY DepDel15, DayofMonth LIMIT 6","hsqls":["SELECT OriginCityMarketID, DestStateName, DivTailNums FROM mytable WHERE TaxiIn <= 48 ORDER BY DepDel15, DayofMonth LIMIT 10000"]}
{"sql":"SELECT DestState, ActualElapsedTime, ArrDelay, SUM(DepDel15), COUNT(DestStateName), COUNT(DivArrDelay) FROM mytable WHERE DestAirportSeqID > 1538902 AND DayOfWeek NOT IN (6) GROUP BY DestState, ActualElapsedTime, ArrDelay  ORDER BY DestState, ActualElapsedTime, ArrDelay LIMIT 23","hsqls":["SELECT DestState, ActualElapsedTime, ArrDelay, SUM(DepDel15), COUNT(DestStateName), COUNT(DivArrDelay) FROM mytable WHERE DestAirportSeqID > 1538902 AND DayOfWeek NOT IN (6) GROUP BY DestState, ActualElapsedTime, ArrDelay  ORDER BY DestState, ActualElapsedTime, ArrDelay LIMIT 23"]}
{"sql":"SELECT ArrDelayMinutes, MAX(DistanceGroup), MIN(CarrierDelay) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 15","hsqls":["SELECT ArrDelayMinutes, MAX(DistanceGroup), MIN(CarrierDelay) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 15"]}
{"sql":"SELECT DistanceGroup FROM mytable WHERE CarrierDelay >= 82 OR ActualElapsedTime >= 349 ORDER BY DistanceGroup, DepTime LIMIT 2"}
{"sql":"SELECT TaxiIn, DepDel15, CancellationCode FROM mytable WHERE DivTotalGTimes = 25 LIMIT 2","hsqls":["SELECT TaxiIn, DepDel15, CancellationCode FROM mytable WHERE (DivTotalGTimes[1] = 25 OR DivTotalGTimes[2] = 25 OR DivTotalGTimes[3] = 25 OR DivTotalGTimes[4] = 25 OR DivTotalGTimes[5] = 25) LIMIT 10000"]}
{"sql":"SELECT WheelsOff, DivAirportSeqIDs, DestAirportID FROM mytable WHERE ArrDelay IN (87.0) OR WheelsOn BETWEEN 757 AND 1742 OR DivAirportLandings <= 9 LIMIT 16","hsqls":["SELECT WheelsOff, DivAirportSeqIDs, DestAirportID FROM mytable WHERE ArrDelay IN (87.0) OR WheelsOn BETWEEN 757 AND 1742 OR DivAirportLandings <= 9 LIMIT 10000"]}
{"sql":"SELECT DivAirports, ActualElapsedTime FROM mytable WHERE LongestAddGTime IN (148, 34, 29) OR OriginAirportSeqID IN (1400602, 1106603, 1490503) LIMIT 10","hsqls":["SELECT DivAirports, ActualElapsedTime FROM mytable WHERE LongestAddGTime IN (148, 34, 29) OR OriginAirportSeqID IN (1400602, 1106603, 1490503) LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, DivWheelsOffs FROM mytable ORDER BY OriginStateFips LIMIT 3","hsqls":["SELECT LongestAddGTime, DivWheelsOffs FROM mytable ORDER BY OriginStateFips LIMIT 10000"]}
{"sql":"SELECT MIN(DepDel15), AVG(ArrivalDelayGroups), SUM(FlightNum) FROM mytable WHERE WheelsOn > 1425 LIMIT 4"}
{"sql":"SELECT ArrDelayMinutes, DestStateName, DivActualElapsedTime FROM mytable WHERE DivTailNums IN ('N953SW', 'N521US', 'N807MQ', 'N163US', 'N549AA') OR DistanceGroup IN (1, 8, 11) OR OriginCityName IN ('Laramie, WY', 'Fairbanks, AK', 'Burbank, CA') LIMIT 17","hsqls":["SELECT ArrDelayMinutes, DestStateName, DivActualElapsedTime FROM mytable WHERE (DivTailNums[1] IN ('N953SW', 'N521US', 'N807MQ', 'N163US', 'N549AA') OR DivTailNums[2] IN ('N953SW', 'N521US', 'N807MQ', 'N163US', 'N549AA') OR DivTailNums[3] IN ('N953SW', 'N521US', 'N807MQ', 'N163US', 'N549AA') OR DivTailNums[4] IN ('N953SW', 'N521US', 'N807MQ', 'N163US', 'N549AA') OR DivTailNums[5] IN ('N953SW', 'N521US', 'N807MQ', 'N163US', 'N549AA')) OR DistanceGroup IN (1, 8, 11) OR OriginCityName IN ('Laramie, WY', 'Fairbanks, AK', 'Burbank, CA') LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, DivAirportIDs, UniqueCarrier FROM mytable LIMIT 3","hsqls":["SELECT DepDelayMinutes, DivAirportIDs, UniqueCarrier FROM mytable LIMIT 10000"]}
{"sql":"SELECT FlightDate, AirTime FROM mytable WHERE OriginStateFips NOT IN (6, 47, 18, 28, 37) AND DivDistance NOT IN (687, 69, 257, 158, 130) AND ArrTime <> 49 ORDER BY Quarter, ArrTimeBlk, OriginWac LIMIT 26"}
{"sql":"SELECT DestAirportSeqID, DestCityName, DaysSinceEpoch FROM mytable WHERE ArrDelayMinutes BETWEEN 10.0 AND 166.0 ORDER BY DepTime, DayofMonth, \"Month\" LIMIT 24","hsqls":["SELECT DestAirportSeqID, DestCityName, DaysSinceEpoch FROM mytable WHERE ArrDelayMinutes BETWEEN 10.0 AND 166.0 ORDER BY DepTime, DayofMonth, `Month` LIMIT 24"]}
{"sql":"SELECT WheelsOff, DistanceGroup, CRSArrTime, SUM(ArrDelayMinutes), SUM(WheelsOff), MAX(NASDelay) FROM mytable GROUP BY WheelsOff, DistanceGroup, CRSArrTime  ORDER BY WheelsOff, DistanceGroup, CRSArrTime LIMIT 2","hsqls":["SELECT WheelsOff, DistanceGroup, CRSArrTime, SUM(ArrDelayMinutes), SUM(WheelsOff), MAX(NASDelay) FROM mytable GROUP BY WheelsOff, DistanceGroup, CRSArrTime  ORDER BY WheelsOff, DistanceGroup, CRSArrTime LIMIT 2"]}
{"sql":"SELECT OriginAirportSeqID, OriginStateName FROM mytable WHERE ArrivalDelayGroups IN (-9999) AND Flights < 1 LIMIT 16"}
{"sql":"SELECT WheelsOff, Origin, DestCityMarketID, MAX(ArrDel15), MAX(OriginWac), AVG(DivActualElapsedTime) FROM mytable WHERE DepDelay NOT IN (-34.0, 146.0, 24.0, 168.0, 316.0) AND OriginAirportSeqID <> 1410803 GROUP BY WheelsOff, Origin, DestCityMarketID  ORDER BY WheelsOff, Origin, DestCityMarketID LIMIT 25","hsqls":["SELECT WheelsOff, Origin, DestCityMarketID, MAX(ArrDel15), MAX(OriginWac), AVG(DivActualElapsedTime) FROM mytable WHERE DepDelay NOT IN (-34.0, 146.0, 24.0, 168.0, 316.0) AND OriginAirportSeqID <> 1410803 GROUP BY WheelsOff, Origin, DestCityMarketID  ORDER BY WheelsOff, Origin, DestCityMarketID LIMIT 25"]}
{"sql":"SELECT AVG(TotalAddGTime), MIN(FirstDepTime) FROM mytable WHERE CancellationCode BETWEEN 'noodles' AND 'noodles' OR DivReachedDest >= 1 OR FlightNum < 2971 LIMIT 28"}
{"sql":"SELECT MAX(DepDel15) FROM mytable WHERE DivTailNums IN ('N922MQ', 'N980SW') OR Cancelled NOT IN (1, 0) LIMIT 21","hsqls":["SELECT MAX(DepDel15) FROM mytable WHERE (DivTailNums[1] IN ('N922MQ', 'N980SW') OR DivTailNums[2] IN ('N922MQ', 'N980SW') OR DivTailNums[3] IN ('N922MQ', 'N980SW') OR DivTailNums[4] IN ('N922MQ', 'N980SW') OR DivTailNums[5] IN ('N922MQ', 'N980SW')) OR Cancelled NOT IN (1, 0) LIMIT 10000"]}
{"sql":"SELECT CRSArrTime, COUNT(OriginWac) FROM mytable WHERE OriginCityMarketID >= 31953 AND DestCityMarketID = 33158 OR DestStateName <= 'Illinois' GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 4","hsqls":["SELECT CRSArrTime, COUNT(OriginWac) FROM mytable WHERE OriginCityMarketID >= 31953 AND DestCityMarketID = 33158 OR DestStateName <= 'Illinois' GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 4"]}
{"sql":"SELECT LateAircraftDelay, MAX(ArrivalDelayGroups), SUM(DayOfWeek), COUNT(ArrTime) FROM mytable WHERE DivActualElapsedTime <= 279 AND DestCityName BETWEEN 'Allentown/Bethlehem/Easton, PA' AND 'Manchester, NH' OR DestAirportID BETWEEN 13933 AND 10930 GROUP BY LateAircraftDelay  ORDER BY LateAircraftDelay LIMIT 9","hsqls":["SELECT LateAircraftDelay, MAX(ArrivalDelayGroups), SUM(DayOfWeek), COUNT(ArrTime) FROM mytable WHERE DivActualElapsedTime <= 279 AND DestCityName BETWEEN 'Allentown/Bethlehem/Easton, PA' AND 'Manchester, NH' OR DestAirportID BETWEEN 13933 AND 10930 GROUP BY LateAircraftDelay  ORDER BY LateAircraftDelay LIMIT 9"]}
{"sql":"SELECT \"Month\", SUM(DepDelay) FROM mytable WHERE ActualElapsedTime IN (117, 224, 267, 142) AND TailNum IN ('N508AY', 'N902MQ') OR DestState BETWEEN 'ND' AND 'OK' GROUP BY \"Month\" LIMIT 12","hsqls":["SELECT Month, SUM(DepDelay) FROM mytable WHERE ActualElapsedTime IN (117, 224, 267, 142) AND TailNum IN ('N508AY', 'N902MQ') OR DestState BETWEEN 'ND' AND 'OK' GROUP BY `Month` LIMIT 12"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrDelayMinutes IN (180.0, 321.0, 271.0, 188.0) OR WheelsOff = 741 AND CRSDepTime BETWEEN 1745 AND 2029"}
{"sql":"SELECT \"Year\", DestStateFips, ArrDelayMinutes FROM mytable WHERE FlightDate BETWEEN '2014-01-20' AND '2014-01-31' AND DivTailNums <= 'N564JB' OR WheelsOn = 1308 LIMIT 18","hsqls":["SELECT Year, DestStateFips, ArrDelayMinutes FROM mytable WHERE FlightDate BETWEEN '2014-01-20' AND '2014-01-31' AND (DivTailNums[1] <= 'N564JB' OR DivTailNums[2] <= 'N564JB' OR DivTailNums[3] <= 'N564JB' OR DivTailNums[4] <= 'N564JB' OR DivTailNums[5] <= 'N564JB') OR WheelsOn = 1308 LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes FROM mytable WHERE DepTime <= 946 OR DivReachedDest BETWEEN -9999 AND -9999 ORDER BY DepDelay LIMIT 12"}
{"sql":"SELECT AirlineID, WheelsOn, OriginStateName, AVG(DestCityMarketID), COUNT(DivArrDelay) FROM mytable WHERE Diverted NOT IN (1, 0) AND OriginStateName IN ('Minnesota', 'Massachusetts') OR ArrDelayMinutes > 77.0 GROUP BY AirlineID, WheelsOn, OriginStateName  ORDER BY AirlineID, WheelsOn, OriginStateName LIMIT 1","hsqls":["SELECT AirlineID, WheelsOn, OriginStateName, AVG(DestCityMarketID), COUNT(DivArrDelay) FROM mytable WHERE Diverted NOT IN (1, 0) AND OriginStateName IN ('Minnesota', 'Massachusetts') OR ArrDelayMinutes > 77.0 GROUP BY AirlineID, WheelsOn, OriginStateName  ORDER BY AirlineID, WheelsOn, OriginStateName LIMIT 1"]}
{"sql":"SELECT Carrier, CRSArrTime, ArrDelay, COUNT(*) FROM mytable WHERE TailNum NOT IN ('N12201', 'N190JB', 'N211FR', 'N600MQ', 'N947DN') GROUP BY Carrier, CRSArrTime, ArrDelay  ORDER BY Carrier, CRSArrTime, ArrDelay LIMIT 13","hsqls":["SELECT Carrier, CRSArrTime, ArrDelay, COUNT(*) FROM mytable WHERE TailNum NOT IN ('N12201', 'N190JB', 'N211FR', 'N600MQ', 'N947DN') GROUP BY Carrier, CRSArrTime, ArrDelay  ORDER BY Carrier, CRSArrTime, ArrDelay LIMIT 13"]}
{"sql":"SELECT ArrTimeBlk, DepTimeBlk, DestAirportID, MIN(DivActualElapsedTime), COUNT(DayofMonth), SUM(DivArrDelay) FROM mytable WHERE TailNum <= 'N913DE' GROUP BY ArrTimeBlk, DepTimeBlk, DestAirportID  ORDER BY ArrTimeBlk, DepTimeBlk, DestAirportID LIMIT 19","hsqls":["SELECT ArrTimeBlk, DepTimeBlk, DestAirportID, MIN(DivActualElapsedTime), COUNT(DayofMonth), SUM(DivArrDelay) FROM mytable WHERE TailNum <= 'N913DE' GROUP BY ArrTimeBlk, DepTimeBlk, DestAirportID  ORDER BY ArrTimeBlk, DepTimeBlk, DestAirportID LIMIT 19"]}
{"sql":"SELECT MAX(\"Year\"), SUM(FlightNum), MAX(ArrTime) FROM mytable WHERE Carrier <> 'AS' LIMIT 1","hsqls":["SELECT MAX(`Year`), SUM(FlightNum), MAX(ArrTime) FROM mytable WHERE Carrier <> 'AS' LIMIT 1"]}
{"sql":"SELECT MIN(DivActualElapsedTime), AVG(OriginCityMarketID) FROM mytable LIMIT 15"}
{"sql":"SELECT DivAirportLandings, \"Month\" FROM mytable WHERE OriginWac IN (93, 53, 74) AND DayofMonth IN (31, 23, 8, 11, 12) AND DepartureDelayGroups BETWEEN -2 AND 8 ORDER BY DepDelay, CRSArrTime, DaysSinceEpoch LIMIT 12","hsqls":["SELECT DivAirportLandings, `Month` FROM mytable WHERE OriginWac IN (93, 53, 74) AND DayofMonth IN (31, 23, 8, 11, 12) AND DepartureDelayGroups BETWEEN -2 AND 8 ORDER BY DepDelay, CRSArrTime, DaysSinceEpoch LIMIT 12"]}
{"sql":"SELECT OriginState, DivWheelsOffs FROM mytable WHERE \"Month\" <> 1 OR ArrDelay >= 176.0 AND DivWheelsOffs IN (1339, 1504, 1620) ORDER BY DivReachedDest, ArrDelayMinutes, Origin LIMIT 7","hsqls":["SELECT OriginState, DivWheelsOffs FROM mytable WHERE `Month` <> 1 OR ArrDelay >= 176.0 AND (DivWheelsOffs[1] IN (1339, 1504, 1620) OR DivWheelsOffs[2] IN (1339, 1504, 1620) OR DivWheelsOffs[3] IN (1339, 1504, 1620) OR DivWheelsOffs[4] IN (1339, 1504, 1620) OR DivWheelsOffs[5] IN (1339, 1504, 1620)) ORDER BY DivReachedDest, ArrDelayMinutes, Origin LIMIT 10000"]}
{"sql":"SELECT DivDistance, CarrierDelay FROM mytable WHERE DestStateFips <= 31 AND DivTailNums BETWEEN 'N8315C' AND 'N4XLAA' ORDER BY SecurityDelay, DivAirportLandings LIMIT 2","hsqls":["SELECT DivDistance, CarrierDelay FROM mytable WHERE DestStateFips <= 31 AND (DivTailNums[1] BETWEEN 'N8315C' AND 'N4XLAA' OR DivTailNums[2] BETWEEN 'N8315C' AND 'N4XLAA' OR DivTailNums[3] BETWEEN 'N8315C' AND 'N4XLAA' OR DivTailNums[4] BETWEEN 'N8315C' AND 'N4XLAA' OR DivTailNums[5] BETWEEN 'N8315C' AND 'N4XLAA') ORDER BY SecurityDelay, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT SUM(Cancelled), SUM(Distance), MAX(Cancelled) FROM mytable WHERE Origin BETWEEN 'TRI' AND 'SMF' AND OriginStateName > 'Illinois' LIMIT 13"}
{"sql":"SELECT WheelsOff, AirTime, DayofMonth, COUNT(*) FROM mytable WHERE DestAirportSeqID NOT IN (1074702, 1329604, 1327702, 1323002) OR Dest BETWEEN 'MCO' AND 'PIH' GROUP BY WheelsOff, AirTime, DayofMonth  ORDER BY WheelsOff, AirTime, DayofMonth LIMIT 19","hsqls":["SELECT WheelsOff, AirTime, DayofMonth, COUNT(*) FROM mytable WHERE DestAirportSeqID NOT IN (1074702, 1329604, 1327702, 1323002) OR Dest BETWEEN 'MCO' AND 'PIH' GROUP BY WheelsOff, AirTime, DayofMonth  ORDER BY WheelsOff, AirTime, DayofMonth LIMIT 19"]}
{"sql":"SELECT MIN(DestCityMarketID) FROM mytable WHERE DivArrDelay >= 159 LIMIT 26"}
{"sql":"SELECT OriginCityMarketID FROM mytable WHERE WheelsOff = 754 ORDER BY SecurityDelay, \"Month\", ArrivalDelayGroups LIMIT 6","hsqls":["SELECT OriginCityMarketID FROM mytable WHERE WheelsOff = 754 ORDER BY SecurityDelay, Month, ArrivalDelayGroups LIMIT 6"]}
{"sql":"SELECT COUNT(LongestAddGTime), SUM(OriginCityMarketID) FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 OR CRSArrTime NOT IN (1723) LIMIT 18","hsqls":["SELECT COUNT(LongestAddGTime), SUM(OriginCityMarketID) FROM mytable WHERE `Month` BETWEEN 1 AND 1 OR CRSArrTime NOT IN (1723) LIMIT 18"]}
{"sql":"SELECT ArrDelay, DivTotalGTimes, DaysSinceEpoch FROM mytable ORDER BY DivReachedDest, DestAirportSeqID LIMIT 7","hsqls":["SELECT ArrDelay, DivTotalGTimes, DaysSinceEpoch FROM mytable ORDER BY DivReachedDest, DestAirportSeqID LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, DivReachedDest, TotalAddGTime FROM mytable WHERE Cancelled IN (1) AND FlightDate IN ('2014-01-04', '2014-01-06', '2014-01-21', '2014-01-11')"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DestCityName <= 'Barrow, AK' OR Flights >= 1 LIMIT 5"}
{"sql":"SELECT Origin FROM mytable WHERE WeatherDelay BETWEEN 10 AND 198 ORDER BY Carrier, Cancelled, AirlineID LIMIT 12"}
{"sql":"SELECT ArrDelayMinutes, OriginStateName, SUM(DestWac) FROM mytable WHERE OriginAirportSeqID >= 1217703 GROUP BY ArrDelayMinutes, OriginStateName  ORDER BY ArrDelayMinutes, OriginStateName LIMIT 4","hsqls":["SELECT ArrDelayMinutes, OriginStateName, SUM(DestWac) FROM mytable WHERE OriginAirportSeqID >= 1217703 GROUP BY ArrDelayMinutes, OriginStateName  ORDER BY ArrDelayMinutes, OriginStateName LIMIT 4"]}
{"sql":"SELECT CarrierDelay, Origin, DayOfWeek FROM mytable WHERE ActualElapsedTime BETWEEN 163 AND 322 OR CarrierDelay IN (17, 266) OR AirlineID IN (19690, 20366) ORDER BY TaxiIn, TailNum LIMIT 1"}
{"sql":"SELECT OriginState, DivAirports, OriginCityName FROM mytable ORDER BY Carrier LIMIT 10","hsqls":["SELECT OriginState, DivAirports, OriginCityName FROM mytable ORDER BY Carrier LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, DivAirportSeqIDs FROM mytable WHERE Distance BETWEEN 955 AND 2486 OR DestState NOT IN ('TN', 'SD', 'IL', 'SC') OR WheelsOff NOT IN (1730, 2018) ORDER BY Diverted, FlightDate LIMIT 26","hsqls":["SELECT DepDelayMinutes, DivAirportSeqIDs FROM mytable WHERE Distance BETWEEN 955 AND 2486 OR DestState NOT IN ('TN', 'SD', 'IL', 'SC') OR WheelsOff NOT IN (1730, 2018) ORDER BY Diverted, FlightDate LIMIT 10000"]}
{"sql":"SELECT DepTimeBlk FROM mytable WHERE DestStateFips BETWEEN 45 AND 75 OR DepDel15 BETWEEN -9999 AND -9999 OR OriginCityMarketID < 30713 ORDER BY DepartureDelayGroups, AirlineID, CRSDepTime LIMIT 21"}
{"sql":"SELECT DestStateName, DivAirportIDs FROM mytable WHERE TaxiOut >= 141 OR DistanceGroup NOT IN (1) OR ArrivalDelayGroups IN (3, 2, 6) ORDER BY Origin LIMIT 6","hsqls":["SELECT DestStateName, DivAirportIDs FROM mytable WHERE TaxiOut >= 141 OR DistanceGroup NOT IN (1) OR ArrivalDelayGroups IN (3, 2, 6) ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, DivTailNums, WheelsOn FROM mytable WHERE CRSArrTime <= 1346 ORDER BY Distance, DestCityMarketID LIMIT 10","hsqls":["SELECT DestAirportSeqID, DivTailNums, WheelsOn FROM mytable WHERE CRSArrTime <= 1346 ORDER BY Distance, DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT FlightDate, ArrTimeBlk FROM mytable WHERE OriginStateFips BETWEEN 38 AND 27 ORDER BY ArrivalDelayGroups LIMIT 25"}
{"sql":"SELECT OriginState, DivAirportIDs FROM mytable WHERE DepDelayMinutes BETWEEN 84.0 AND 49.0 OR DistanceGroup IN (5) ORDER BY DivDistance, DivAirportLandings LIMIT 7","hsqls":["SELECT OriginState, DivAirportIDs FROM mytable WHERE DepDelayMinutes BETWEEN 84.0 AND 49.0 OR DistanceGroup IN (5) ORDER BY DivDistance, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT Origin, COUNT(FirstDepTime) FROM mytable WHERE DepTime NOT IN (1119, 856, 607, 645) AND DepDel15 IN (0, -9999) GROUP BY Origin","hsqls":["SELECT Origin, COUNT(FirstDepTime) FROM mytable WHERE DepTime NOT IN (1119, 856, 607, 645) AND DepDel15 IN (0, -9999) GROUP BY Origin"]}
{"sql":"SELECT Origin, ArrivalDelayGroups FROM mytable WHERE DepDelayMinutes BETWEEN 235.0 AND 210.0 OR CRSElapsedTime <= 79 ORDER BY ArrDelay LIMIT 10"}
{"sql":"SELECT ArrDelayMinutes, AVG(ArrDel15) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 2","hsqls":["SELECT ArrDelayMinutes, AVG(ArrDel15) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 2"]}
{"sql":"SELECT DestState, TaxiIn, AVG(DepDelayMinutes) FROM mytable WHERE DestStateName BETWEEN 'Indiana' AND 'Washington' OR ActualElapsedTime BETWEEN 243 AND 387 OR DestStateFips IN (42, 44, 41, 19, 26) GROUP BY DestState, TaxiIn  ORDER BY DestState, TaxiIn LIMIT 29","hsqls":["SELECT DestState, TaxiIn, AVG(DepDelayMinutes) FROM mytable WHERE DestStateName BETWEEN 'Indiana' AND 'Washington' OR ActualElapsedTime BETWEEN 243 AND 387 OR DestStateFips IN (42, 44, 41, 19, 26) GROUP BY DestState, TaxiIn  ORDER BY DestState, TaxiIn LIMIT 29"]}
{"sql":"SELECT DestWac, Origin, CRSElapsedTime, COUNT(DestStateName) FROM mytable WHERE TaxiIn IN (20, 127, 175, 5, 55) GROUP BY DestWac, Origin, CRSElapsedTime  ORDER BY DestWac, Origin, CRSElapsedTime LIMIT 8","hsqls":["SELECT DestWac, Origin, CRSElapsedTime, COUNT(DestStateName) FROM mytable WHERE TaxiIn IN (20, 127, 175, 5, 55) GROUP BY DestWac, Origin, CRSElapsedTime  ORDER BY DestWac, Origin, CRSElapsedTime LIMIT 8"]}
{"sql":"SELECT DivAirportIDs, ArrDelay FROM mytable ORDER BY Quarter, CRSArrTime, ArrDelayMinutes LIMIT 18","hsqls":["SELECT DivAirportIDs, ArrDelay FROM mytable ORDER BY Quarter, CRSArrTime, ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT Diverted, DestStateFips, DayOfWeek, MIN(NASDelay), MIN(Distance) FROM mytable WHERE DestStateFips = 78 AND CarrierDelay NOT IN (170, 20, 164) GROUP BY Diverted, DestStateFips, DayOfWeek  ORDER BY Diverted, DestStateFips, DayOfWeek LIMIT 22","hsqls":["SELECT Diverted, DestStateFips, DayOfWeek, MIN(NASDelay), MIN(Distance) FROM mytable WHERE DestStateFips = 78 AND CarrierDelay NOT IN (170, 20, 164) GROUP BY Diverted, DestStateFips, DayOfWeek  ORDER BY Diverted, DestStateFips, DayOfWeek LIMIT 22"]}
{"sql":"SELECT DivDistance, FlightDate, DivWheelsOffs FROM mytable WHERE DepDelayMinutes IN (210.0) OR WheelsOff >= 1014 AND ArrivalDelayGroups BETWEEN 12 AND -1 LIMIT 24","hsqls":["SELECT DivDistance, FlightDate, DivWheelsOffs FROM mytable WHERE DepDelayMinutes IN (210.0) OR WheelsOff >= 1014 AND ArrivalDelayGroups BETWEEN 12 AND -1 LIMIT 10000"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(TaxiIn) FROM mytable WHERE DepartureDelayGroups BETWEEN 8 AND 0 GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 11","hsqls":["SELECT DaysSinceEpoch, COUNT(TaxiIn) FROM mytable WHERE DepartureDelayGroups BETWEEN 8 AND 0 GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 11"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(\"Month\"), COUNT(OriginWac) FROM mytable WHERE OriginAirportSeqID BETWEEN 1312702 AND 1484304 GROUP BY DaysSinceEpoch LIMIT 24","hsqls":["SELECT DaysSinceEpoch, COUNT(`Month`), COUNT(OriginWac) FROM mytable WHERE OriginAirportSeqID BETWEEN 1312702 AND 1484304 GROUP BY DaysSinceEpoch LIMIT 24"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR DepTimeBlk BETWEEN '1400-1459' AND '1300-1359' LIMIT 8","hsqls":["SELECT COUNT(*) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR DepTimeBlk BETWEEN '1400-1459' AND '1300-1359' LIMIT 8"]}
{"sql":"SELECT TailNum FROM mytable ORDER BY Flights, DepDelayMinutes, DestAirportID LIMIT 12"}
{"sql":"SELECT ArrTimeBlk FROM mytable ORDER BY DestWac LIMIT 7"}
{"sql":"SELECT DivReachedDest FROM mytable WHERE ArrivalDelayGroups > 5 ORDER BY Carrier LIMIT 29"}
{"sql":"SELECT OriginStateFips, COUNT(*) FROM mytable GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 12","hsqls":["SELECT OriginStateFips, COUNT(*) FROM mytable GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 12"]}
{"sql":"SELECT OriginWac, WheelsOn FROM mytable ORDER BY DestCityName, DivActualElapsedTime, OriginStateName LIMIT 5"}
{"sql":"SELECT COUNT(OriginCityName), SUM(DistanceGroup) FROM mytable WHERE ActualElapsedTime NOT IN (113, 271) LIMIT 3"}
{"sql":"SELECT ArrTime FROM mytable LIMIT 28"}
{"sql":"SELECT Distance, OriginCityName, COUNT(*) FROM mytable WHERE Carrier IN ('US', 'VX', 'AS') AND LongestAddGTime NOT IN (40, 60) AND DestWac IN (23, 62, 33) GROUP BY Distance, OriginCityName  ORDER BY Distance, OriginCityName LIMIT 11","hsqls":["SELECT Distance, OriginCityName, COUNT(*) FROM mytable WHERE Carrier IN ('US', 'VX', 'AS') AND LongestAddGTime NOT IN (40, 60) AND DestWac IN (23, 62, 33) GROUP BY Distance, OriginCityName  ORDER BY Distance, OriginCityName LIMIT 11"]}
{"sql":"SELECT FlightNum, OriginWac, MAX(DivReachedDest), MIN(TaxiOut) FROM mytable GROUP BY FlightNum, OriginWac  ORDER BY FlightNum, OriginWac LIMIT 13","hsqls":["SELECT FlightNum, OriginWac, MAX(DivReachedDest), MIN(TaxiOut) FROM mytable GROUP BY FlightNum, OriginWac  ORDER BY FlightNum, OriginWac LIMIT 13"]}
{"sql":"SELECT DestAirportSeqID, DepDel15, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, DepDel15  ORDER BY DestAirportSeqID, DepDel15 LIMIT 4","hsqls":["SELECT DestAirportSeqID, DepDel15, COUNT(*) FROM mytable GROUP BY DestAirportSeqID, DepDel15  ORDER BY DestAirportSeqID, DepDel15 LIMIT 4"]}
{"sql":"SELECT TaxiOut, DistanceGroup, FirstDepTime FROM mytable WHERE DayofMonth > 8 OR DivTailNums IN ('N1EAMQ', 'N807MQ', 'N657AW') OR DestAirportSeqID NOT IN (1532302, 1430702, 1348502, 1127802, 1329002) ORDER BY FlightDate, CRSDepTime LIMIT 21","hsqls":["SELECT TaxiOut, DistanceGroup, FirstDepTime FROM mytable WHERE DayofMonth > 8 OR (DivTailNums[1] IN ('N1EAMQ', 'N807MQ', 'N657AW') OR DivTailNums[2] IN ('N1EAMQ', 'N807MQ', 'N657AW') OR DivTailNums[3] IN ('N1EAMQ', 'N807MQ', 'N657AW') OR DivTailNums[4] IN ('N1EAMQ', 'N807MQ', 'N657AW') OR DivTailNums[5] IN ('N1EAMQ', 'N807MQ', 'N657AW')) OR DestAirportSeqID NOT IN (1532302, 1430702, 1348502, 1127802, 1329002) ORDER BY FlightDate, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT MIN(TaxiIn), AVG(Quarter) FROM mytable WHERE LateAircraftDelay > 68 AND DestState IN ('MO', 'PR', 'NY') LIMIT 23"}
{"sql":"SELECT OriginState FROM mytable WHERE AirlineID BETWEEN 19790 AND 19790 ORDER BY DepartureDelayGroups, FlightNum, DivActualElapsedTime LIMIT 29"}
{"sql":"SELECT \"Month\" FROM mytable WHERE DestWac < 85 ORDER BY OriginCityName LIMIT 3","hsqls":["SELECT `Month` FROM mytable WHERE DestWac < 85 ORDER BY OriginCityName LIMIT 3"]}
{"sql":"SELECT OriginAirportSeqID, TaxiOut FROM mytable WHERE WeatherDelay NOT IN (97, 101) OR OriginAirportSeqID BETWEEN 1621801 AND 1385103 ORDER BY OriginCityMarketID, TaxiIn LIMIT 6"}
{"sql":"SELECT FlightDate, DivAirportIDs, ArrDelay FROM mytable WHERE LongestAddGTime NOT IN (2, 5) OR ArrivalDelayGroups IN (1, 9) AND CarrierDelay BETWEEN 328 AND 62 ORDER BY TaxiOut, OriginStateFips LIMIT 19","hsqls":["SELECT FlightDate, DivAirportIDs, ArrDelay FROM mytable WHERE LongestAddGTime NOT IN (2, 5) OR ArrivalDelayGroups IN (1, 9) AND CarrierDelay BETWEEN 328 AND 62 ORDER BY TaxiOut, OriginStateFips LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes, DestAirportID, COUNT(*) FROM mytable WHERE DestAirportID BETWEEN 10792 AND 14696 AND DestCityMarketID < 30599 AND Carrier BETWEEN 'WN' AND 'F9' GROUP BY ArrDelayMinutes, DestAirportID  ORDER BY ArrDelayMinutes, DestAirportID LIMIT 4","hsqls":["SELECT ArrDelayMinutes, DestAirportID, COUNT(*) FROM mytable WHERE DestAirportID BETWEEN 10792 AND 14696 AND DestCityMarketID < 30599 AND Carrier BETWEEN 'WN' AND 'F9' GROUP BY ArrDelayMinutes, DestAirportID  ORDER BY ArrDelayMinutes, DestAirportID LIMIT 4"]}
{"sql":"SELECT DivAirportIDs FROM mytable WHERE ActualElapsedTime BETWEEN 36 AND 30 AND WheelsOn IN (1501, 740) LIMIT 28","hsqls":["SELECT DivAirportIDs FROM mytable WHERE ActualElapsedTime BETWEEN 36 AND 30 AND WheelsOn IN (1501, 740) LIMIT 10000"]}
{"sql":"SELECT OriginState, Origin, AirTime FROM mytable WHERE AirlineID IN (19690, 20437, 19930, 20355) ORDER BY LateAircraftDelay, FlightNum, DayofMonth LIMIT 5"}
{"sql":"SELECT Carrier, DestStateFips, DestCityMarketID, SUM(LateAircraftDelay), MIN(TaxiIn) FROM mytable WHERE TaxiOut IN (48, 92, 91, 34, 85) AND DepartureDelayGroups <= -2 AND AirTime BETWEEN 216 AND 156 GROUP BY Carrier, DestStateFips, DestCityMarketID  ORDER BY Carrier, DestStateFips, DestCityMarketID LIMIT 5","hsqls":["SELECT Carrier, DestStateFips, DestCityMarketID, SUM(LateAircraftDelay), MIN(TaxiIn) FROM mytable WHERE TaxiOut IN (48, 92, 91, 34, 85) AND DepartureDelayGroups <= -2 AND AirTime BETWEEN 216 AND 156 GROUP BY Carrier, DestStateFips, DestCityMarketID  ORDER BY Carrier, DestStateFips, DestCityMarketID LIMIT 5"]}
{"sql":"SELECT DestAirportSeqID, DestCityMarketID, COUNT(*) FROM mytable WHERE DivTotalGTimes IN (97, 92, 33, 25, 11) AND DivAirportSeqIDs BETWEEN 1409803 AND 1329604 AND ArrDel15 BETWEEN 0 AND 0 GROUP BY DestAirportSeqID, DestCityMarketID LIMIT 24","hsqls":["SELECT DestAirportSeqID, DestCityMarketID, COUNT(*) FROM mytable WHERE (DivTotalGTimes[1] IN (97, 92, 33, 25, 11) OR DivTotalGTimes[2] IN (97, 92, 33, 25, 11) OR DivTotalGTimes[3] IN (97, 92, 33, 25, 11) OR DivTotalGTimes[4] IN (97, 92, 33, 25, 11) OR DivTotalGTimes[5] IN (97, 92, 33, 25, 11)) AND (DivAirportSeqIDs[1] BETWEEN 1409803 AND 1329604 OR DivAirportSeqIDs[2] BETWEEN 1409803 AND 1329604 OR DivAirportSeqIDs[3] BETWEEN 1409803 AND 1329604 OR DivAirportSeqIDs[4] BETWEEN 1409803 AND 1329604 OR DivAirportSeqIDs[5] BETWEEN 1409803 AND 1329604) AND ArrDel15 BETWEEN 0 AND 0 GROUP BY DestAirportSeqID, DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT DepDelay, DivActualElapsedTime, AVG(FirstDepTime), MAX(CRSDepTime), COUNT(DivAirportLandings) FROM mytable GROUP BY DepDelay, DivActualElapsedTime  ORDER BY DepDelay, DivActualElapsedTime LIMIT 27","hsqls":["SELECT DepDelay, DivActualElapsedTime, AVG(FirstDepTime), MAX(CRSDepTime), COUNT(DivAirportLandings) FROM mytable GROUP BY DepDelay, DivActualElapsedTime  ORDER BY DepDelay, DivActualElapsedTime LIMIT 27"]}
{"sql":"SELECT OriginState, Carrier, OriginCityName, MIN(TotalAddGTime), COUNT(DestAirportID), MAX(\"Month\") FROM mytable WHERE SecurityDelay IN (1, 4, 8, 14) GROUP BY OriginState, Carrier, OriginCityName LIMIT 29","hsqls":["SELECT OriginState, Carrier, OriginCityName, MIN(TotalAddGTime), COUNT(DestAirportID), MAX(`Month`) FROM mytable WHERE SecurityDelay IN (1, 4, 8, 14) GROUP BY OriginState, Carrier, OriginCityName LIMIT 29"]}
{"sql":"SELECT LateAircraftDelay, NASDelay, DaysSinceEpoch FROM mytable WHERE CarrierDelay IN (343, 129, 157, 27) AND DaysSinceEpoch IN (16101, 16094, 16086) OR CRSArrTime >= 1434 ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 15"}
{"sql":"SELECT CarrierDelay, DayofMonth, CRSElapsedTime FROM mytable WHERE OriginCityName <> 'Flint, MI' AND DistanceGroup < 2 ORDER BY Diverted, DepDelay LIMIT 23"}
{"sql":"SELECT MIN(LateAircraftDelay) FROM mytable LIMIT 2"}
{"sql":"SELECT AirlineID, DivTotalGTimes FROM mytable ORDER BY FlightDate LIMIT 19","hsqls":["SELECT AirlineID, DivTotalGTimes FROM mytable ORDER BY FlightDate LIMIT 10000"]}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE DivTotalGTimes <= 196 AND TaxiIn IN (44) OR TotalAddGTime BETWEEN 23 AND 5 ORDER BY OriginStateName","hsqls":["SELECT ArrDelayMinutes FROM mytable WHERE (DivTotalGTimes[1] <= 196 OR DivTotalGTimes[2] <= 196 OR DivTotalGTimes[3] <= 196 OR DivTotalGTimes[4] <= 196 OR DivTotalGTimes[5] <= 196) AND TaxiIn IN (44) OR TotalAddGTime BETWEEN 23 AND 5 ORDER BY OriginStateName LIMIT 10000"]}
{"sql":"SELECT DestWac, DivArrDelay FROM mytable WHERE Distance >= 157 OR DestCityMarketID <= 32335 AND \"Year\" = 2014 ORDER BY SecurityDelay, CRSDepTime LIMIT 17","hsqls":["SELECT DestWac, DivArrDelay FROM mytable WHERE Distance >= 157 OR DestCityMarketID <= 32335 AND `Year` = 2014 ORDER BY SecurityDelay, CRSDepTime LIMIT 17"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrTimeBlk NOT IN ('0700-0759', '0800-0859', '1200-1259') AND OriginAirportSeqID IN (1182304, 1419303) OR OriginStateFips NOT IN (2, 30, 55, 50) LIMIT 7"}
{"sql":"SELECT FlightDate FROM mytable WHERE DepTime >= 954 LIMIT 5"}
{"sql":"SELECT OriginCityMarketID FROM mytable WHERE TaxiIn NOT IN (19, 56, 102, 101) ORDER BY LongestAddGTime, ArrDel15, OriginWac LIMIT 15"}
{"sql":"SELECT Dest, CRSDepTime, DivActualElapsedTime FROM mytable WHERE DestCityName BETWEEN 'Evansville, IN' AND 'Saginaw/Bay City/Midland, MI' AND Carrier < 'DL' ORDER BY Diverted, Distance, DestAirportSeqID LIMIT 28"}
{"sql":"SELECT OriginStateFips, OriginStateName, COUNT(ArrDelayMinutes) FROM mytable WHERE CRSDepTime BETWEEN 1951 AND 1845 OR Origin BETWEEN 'AGS' AND 'GTF' OR ArrivalDelayGroups IN (1, 0, 6, 4) GROUP BY OriginStateFips, OriginStateName","hsqls":["SELECT OriginStateFips, OriginStateName, COUNT(ArrDelayMinutes) FROM mytable WHERE CRSDepTime BETWEEN 1951 AND 1845 OR Origin BETWEEN 'AGS' AND 'GTF' OR ArrivalDelayGroups IN (1, 0, 6, 4) GROUP BY OriginStateFips, OriginStateName"]}
{"sql":"SELECT OriginStateName FROM mytable ORDER BY DepDelayMinutes, CRSArrTime LIMIT 9"}
{"sql":"SELECT FlightNum FROM mytable WHERE FirstDepTime >= 1449 OR Dest >= 'PAH' OR ArrivalDelayGroups BETWEEN 9 AND 12 ORDER BY SecurityDelay, DestCityName, UniqueCarrier LIMIT 2"}
{"sql":"SELECT OriginState, Cancelled, COUNT(ArrDelayMinutes), MAX(SecurityDelay), MIN(DivDistance) FROM mytable WHERE FlightNum BETWEEN 244 AND 2549 AND OriginStateFips <= 45 GROUP BY OriginState, Cancelled  ORDER BY OriginState, Cancelled LIMIT 1","hsqls":["SELECT OriginState, Cancelled, COUNT(ArrDelayMinutes), MAX(SecurityDelay), MIN(DivDistance) FROM mytable WHERE FlightNum BETWEEN 244 AND 2549 AND OriginStateFips <= 45 GROUP BY OriginState, Cancelled  ORDER BY OriginState, Cancelled LIMIT 1"]}
{"sql":"SELECT DestCityName FROM mytable WHERE Cancelled NOT IN (1, 0) ORDER BY Cancelled, ArrDel15, AirlineID"}
{"sql":"SELECT Cancelled, COUNT(*) FROM mytable WHERE DivReachedDest BETWEEN 0 AND 0 GROUP BY Cancelled  ORDER BY Cancelled LIMIT 19","hsqls":["SELECT Cancelled, COUNT(*) FROM mytable WHERE DivReachedDest BETWEEN 0 AND 0 GROUP BY Cancelled  ORDER BY Cancelled LIMIT 19"]}
{"sql":"SELECT \"Year\", Diverted, AVG(TaxiIn), SUM(DivArrDelay) FROM mytable GROUP BY \"Year\", Diverted","hsqls":["SELECT Year, Diverted, AVG(TaxiIn), SUM(DivArrDelay) FROM mytable GROUP BY Year, Diverted"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 18"}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE Distance BETWEEN 919 AND 1623 OR OriginCityMarketID NOT IN (33851, 30713, 32511) OR CRSArrTime = 1000 ORDER BY Quarter LIMIT 7"}
{"sql":"SELECT TaxiOut, FirstDepTime, NASDelay, AVG(DivDistance), COUNT(Cancelled), SUM(DivDistance) FROM mytable WHERE ArrTime NOT IN (850, 1726, 836) GROUP BY TaxiOut, FirstDepTime, NASDelay  ORDER BY TaxiOut, FirstDepTime, NASDelay LIMIT 18","hsqls":["SELECT TaxiOut, FirstDepTime, NASDelay, AVG(DivDistance), COUNT(Cancelled), SUM(DivDistance) FROM mytable WHERE ArrTime NOT IN (850, 1726, 836) GROUP BY TaxiOut, FirstDepTime, NASDelay  ORDER BY TaxiOut, FirstDepTime, NASDelay LIMIT 18"]}
{"sql":"SELECT Origin, OriginWac, COUNT(*) FROM mytable WHERE TaxiOut IN (66, 42, 51, 52, 9) OR DestCityMarketID BETWEEN 30666 AND 30189 OR ArrDelayMinutes BETWEEN 211.0 AND 49.0 GROUP BY Origin, OriginWac  ORDER BY Origin, OriginWac LIMIT 11","hsqls":["SELECT Origin, OriginWac, COUNT(*) FROM mytable WHERE TaxiOut IN (66, 42, 51, 52, 9) OR DestCityMarketID BETWEEN 30666 AND 30189 OR ArrDelayMinutes BETWEEN 211.0 AND 49.0 GROUP BY Origin, OriginWac  ORDER BY Origin, OriginWac LIMIT 11"]}
{"sql":"SELECT FlightDate FROM mytable WHERE DivTotalGTimes BETWEEN 38 AND 4 AND OriginCityMarketID IN (34696) OR Dest > 'TWF' ORDER BY ArrTime, Cancelled, DestAirportID LIMIT 24","hsqls":["SELECT FlightDate FROM mytable WHERE (DivTotalGTimes[1] BETWEEN 38 AND 4 OR DivTotalGTimes[2] BETWEEN 38 AND 4 OR DivTotalGTimes[3] BETWEEN 38 AND 4 OR DivTotalGTimes[4] BETWEEN 38 AND 4 OR DivTotalGTimes[5] BETWEEN 38 AND 4) AND OriginCityMarketID IN (34696) OR Dest > 'TWF' ORDER BY ArrTime, Cancelled, DestAirportID LIMIT 10000"]}
{"sql":"SELECT LateAircraftDelay, CRSDepTime FROM mytable WHERE DepTime BETWEEN 654 AND 1214 AND \"Year\" NOT IN (2014) AND DistanceGroup BETWEEN 5 AND 3 ORDER BY DivDistance, LongestAddGTime LIMIT 10","hsqls":["SELECT LateAircraftDelay, CRSDepTime FROM mytable WHERE DepTime BETWEEN 654 AND 1214 AND `Year` NOT IN (2014) AND DistanceGroup BETWEEN 5 AND 3 ORDER BY DivDistance, LongestAddGTime LIMIT 10"]}
{"sql":"SELECT Diverted, DepDelay, DivTotalGTimes FROM mytable WHERE DivWheelsOns IN (950) AND CRSArrTime IN (1209, 757, 1014) ORDER BY OriginStateFips, Flights LIMIT 7","hsqls":["SELECT Diverted, DepDelay, DivTotalGTimes FROM mytable WHERE (DivWheelsOns[1] IN (950) OR DivWheelsOns[2] IN (950) OR DivWheelsOns[3] IN (950) OR DivWheelsOns[4] IN (950) OR DivWheelsOns[5] IN (950)) AND CRSArrTime IN (1209, 757, 1014) ORDER BY OriginStateFips, Flights LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, NASDelay FROM mytable WHERE CRSElapsedTime = 255 LIMIT 29"}
{"sql":"SELECT TaxiOut, Quarter FROM mytable WHERE DestCityMarketID IN (31884, 31867, 34492, 33377, 33038) OR DivAirportLandings BETWEEN 9 AND 2 OR ArrDelayMinutes = 110.0 LIMIT 8"}
{"sql":"SELECT CarrierDelay, AVG(DayofMonth), MIN(DepDel15), SUM(Quarter) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 26","hsqls":["SELECT CarrierDelay, AVG(DayofMonth), MIN(DepDel15), SUM(Quarter) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 26"]}
{"sql":"SELECT FlightDate FROM mytable ORDER BY DestAirportID, OriginStateName LIMIT 22"}
{"sql":"SELECT DepDelay, Carrier FROM mytable WHERE DestStateName IN ('Louisiana', 'Colorado', 'Massachusetts', 'Kansas') OR DayofMonth BETWEEN 15 AND 8 AND CRSArrTime > 1108 LIMIT 14"}
{"sql":"SELECT DistanceGroup, DestWac, NASDelay, AVG(DestAirportSeqID), MAX(FirstDepTime), AVG(ArrivalDelayGroups) FROM mytable GROUP BY DistanceGroup, DestWac, NASDelay  ORDER BY DistanceGroup, DestWac, NASDelay LIMIT 21","hsqls":["SELECT DistanceGroup, DestWac, NASDelay, AVG(DestAirportSeqID), MAX(FirstDepTime), AVG(ArrivalDelayGroups) FROM mytable GROUP BY DistanceGroup, DestWac, NASDelay  ORDER BY DistanceGroup, DestWac, NASDelay LIMIT 21"]}
{"sql":"SELECT MIN(DivActualElapsedTime), MAX(DivAirportLandings) FROM mytable WHERE DivTotalGTimes IN (3, 4, 15, 99, 14) OR TotalAddGTime NOT IN (41, 40, 63, 14, 38) OR DivDistance IN (1590, 369, 490, 177, 191) LIMIT 7","hsqls":["SELECT MIN(DivActualElapsedTime), MAX(DivAirportLandings)  FROM mytable WHERE (DivTotalGTimes[1] IN (3, 4, 15, 99, 14) OR DivTotalGTimes[2] IN (3, 4, 15, 99, 14) OR DivTotalGTimes[3] IN (3, 4, 15, 99, 14) OR DivTotalGTimes[4] IN (3, 4, 15, 99, 14) OR DivTotalGTimes[5] IN (3, 4, 15, 99, 14)) OR TotalAddGTime NOT IN (41, 40, 63, 14, 38) OR DivDistance IN (1590, 369, 490, 177, 191) LIMIT 10000"]}
{"sql":"SELECT AirTime FROM mytable ORDER BY WeatherDelay, DepDel15, DestCityName LIMIT 8"}
{"sql":"SELECT DistanceGroup, OriginAirportID FROM mytable WHERE CancellationCode IN ('B') ORDER BY ArrTime, ArrDel15, CRSDepTime LIMIT 8"}
{"sql":"SELECT DivLongestGTimes, CancellationCode, OriginAirportID FROM mytable WHERE DestStateName > 'Pennsylvania' AND DivArrDelay >= 161 OR WeatherDelay >= 61 ORDER BY CarrierDelay LIMIT 7","hsqls":["SELECT DivLongestGTimes, CancellationCode, OriginAirportID FROM mytable WHERE DestStateName > 'Pennsylvania' AND DivArrDelay >= 161 OR WeatherDelay >= 61 ORDER BY CarrierDelay LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, MAX(DestAirportSeqID), MIN(AirlineID) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 19","hsqls":["SELECT CarrierDelay, MAX(DestAirportSeqID), MIN(AirlineID) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 19"]}
{"sql":"SELECT OriginCityName FROM mytable WHERE AirlineID <> 21171 ORDER BY WeatherDelay LIMIT 13"}
{"sql":"SELECT DistanceGroup, OriginStateFips, SecurityDelay FROM mytable ORDER BY OriginAirportSeqID, DivDistance, Dest LIMIT 4"}
{"sql":"SELECT WheelsOff, DivAirportIDs FROM mytable WHERE DivWheelsOffs = 1212 AND Distance BETWEEN 212 AND 1709 ORDER BY ArrDelay LIMIT 10","hsqls":["SELECT WheelsOff, DivAirportIDs FROM mytable WHERE (DivWheelsOffs[1] = 1212 OR DivWheelsOffs[2] = 1212 OR DivWheelsOffs[3] = 1212 OR DivWheelsOffs[4] = 1212 OR DivWheelsOffs[5] = 1212) AND Distance BETWEEN 212 AND 1709 ORDER BY ArrDelay LIMIT 10000"]}
{"sql":"SELECT ArrTime, AirTime FROM mytable WHERE DivDistance IN (69, 342) AND OriginState IN ('MT', 'NC', 'CA', 'NV', 'CO') LIMIT 21"}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DestWac < 66 ORDER BY FirstDepTime, FlightNum, Cancelled LIMIT 19"}
{"sql":"SELECT DepDel15, AVG(TotalAddGTime), MAX(CRSDepTime) FROM mytable WHERE DestAirportSeqID BETWEEN 1226402 AND 1209402 OR CRSDepTime = 1106 GROUP BY DepDel15","hsqls":["SELECT DepDel15, AVG(TotalAddGTime), MAX(CRSDepTime) FROM mytable WHERE DestAirportSeqID BETWEEN 1226402 AND 1209402 OR CRSDepTime = 1106 GROUP BY DepDel15"]}
{"sql":"SELECT DepTime FROM mytable WHERE DivActualElapsedTime = 193 OR DepartureDelayGroups IN (-1, 4, 9) OR OriginCityMarketID BETWEEN 30779 AND 34905 ORDER BY FlightDate, DepDel15, DivActualElapsedTime LIMIT 17"}
{"sql":"SELECT DivAirportSeqIDs FROM mytable WHERE ActualElapsedTime = 124 ORDER BY \"Month\" LIMIT 15","hsqls":["SELECT DivAirportSeqIDs FROM mytable WHERE ActualElapsedTime = 124 ORDER BY `Month` LIMIT 10000"]}
{"sql":"SELECT Flights FROM mytable WHERE SecurityDelay >= 8 OR CRSArrTime < 1625 OR Origin >= 'MHK' LIMIT 24"}
{"sql":"SELECT AirlineID, SUM(DestCityMarketID) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 1","hsqls":["SELECT AirlineID, SUM(DestCityMarketID) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 1"]}
{"sql":"SELECT Flights, FlightDate FROM mytable ORDER BY DepartureDelayGroups, SecurityDelay LIMIT 4"}
{"sql":"SELECT DepartureDelayGroups, SecurityDelay FROM mytable WHERE CRSDepTime NOT IN (1035, 1305) OR DestAirportID BETWEEN 14869 AND 12884 LIMIT 18"}
{"sql":"SELECT SUM(TotalAddGTime) FROM mytable WHERE AirlineID <> 20304 AND \"Year\" BETWEEN 2014 AND 2014 AND Quarter IN (1) LIMIT 16","hsqls":["SELECT SUM(TotalAddGTime) FROM mytable WHERE AirlineID <> 20304 AND `Year` BETWEEN 2014 AND 2014 AND Quarter IN (1) LIMIT 16"]}
{"sql":"SELECT LateAircraftDelay, ArrTime, AVG(DestAirportSeqID), SUM(Distance) FROM mytable GROUP BY LateAircraftDelay, ArrTime  ORDER BY LateAircraftDelay, ArrTime LIMIT 14","hsqls":["SELECT LateAircraftDelay, ArrTime, AVG(DestAirportSeqID), SUM(Distance) FROM mytable GROUP BY LateAircraftDelay, ArrTime  ORDER BY LateAircraftDelay, ArrTime LIMIT 14"]}
{"sql":"SELECT WeatherDelay, DaysSinceEpoch, COUNT(LongestAddGTime) FROM mytable GROUP BY WeatherDelay, DaysSinceEpoch  ORDER BY WeatherDelay, DaysSinceEpoch LIMIT 18","hsqls":["SELECT WeatherDelay, DaysSinceEpoch, COUNT(LongestAddGTime) FROM mytable GROUP BY WeatherDelay, DaysSinceEpoch  ORDER BY WeatherDelay, DaysSinceEpoch LIMIT 18"]}
{"sql":"SELECT DepDelay, WeatherDelay, Origin, COUNT(*) FROM mytable WHERE DivAirportSeqIDs BETWEEN 1342202 AND 1163805 OR DestCityMarketID NOT IN (32402, 31921, 35323, 34520, 30185) OR ArrTimeBlk < '0600-0659' GROUP BY DepDelay, WeatherDelay, Origin LIMIT 16","hsqls":["SELECT DepDelay, WeatherDelay, Origin, COUNT(*) FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1342202 AND 1163805 OR DivAirportSeqIDs[2] BETWEEN 1342202 AND 1163805 OR DivAirportSeqIDs[3] BETWEEN 1342202 AND 1163805 OR DivAirportSeqIDs[4] BETWEEN 1342202 AND 1163805 OR DivAirportSeqIDs[5] BETWEEN 1342202 AND 1163805) OR DestCityMarketID NOT IN (32402, 31921, 35323, 34520, 30185) OR ArrTimeBlk < '0600-0659' GROUP BY DepDelay, WeatherDelay, Origin LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, CRSElapsedTime FROM mytable WHERE ArrDelay <> 68.0 AND DestStateName BETWEEN 'Wisconsin' AND 'New Hampshire' ORDER BY CancellationCode LIMIT 19"}
{"sql":"SELECT TotalAddGTime, ArrDelay, CRSElapsedTime FROM mytable WHERE OriginCityName BETWEEN 'Kona, HI' AND 'Baton Rouge, LA' AND CRSDepTime BETWEEN 1356 AND 2233 OR OriginWac IN (21, 44, 36, 74, 14) ORDER BY TotalAddGTime, DepTimeBlk LIMIT 6"}
{"sql":"SELECT SUM(CRSArrTime) FROM mytable WHERE FlightNum IN (5252, 6076, 4373, 2243, 603) AND ArrTime = 842 AND DayOfWeek IN (3, 2, 1, 4) LIMIT 24"}
{"sql":"SELECT OriginAirportID FROM mytable WHERE DayOfWeek BETWEEN 6 AND 7 OR DestWac BETWEEN 84 AND 83 ORDER BY CancellationCode LIMIT 27"}
{"sql":"SELECT CarrierDelay, CRSDepTime, UniqueCarrier, COUNT(DepTimeBlk) FROM mytable WHERE OriginStateFips IN (6, 42, 8, 34, 37) GROUP BY CarrierDelay, CRSDepTime, UniqueCarrier  ORDER BY CarrierDelay, CRSDepTime, UniqueCarrier LIMIT 18","hsqls":["SELECT CarrierDelay, CRSDepTime, UniqueCarrier, COUNT(DepTimeBlk) FROM mytable WHERE OriginStateFips IN (6, 42, 8, 34, 37) GROUP BY CarrierDelay, CRSDepTime, UniqueCarrier  ORDER BY CarrierDelay, CRSDepTime, UniqueCarrier LIMIT 18"]}
{"sql":"SELECT TailNum, DestCityMarketID, SUM(TaxiIn), AVG(OriginCityMarketID) FROM mytable WHERE CRSDepTime >= 1527 GROUP BY TailNum, DestCityMarketID  ORDER BY TailNum, DestCityMarketID LIMIT 2","hsqls":["SELECT TailNum, DestCityMarketID, SUM(TaxiIn), AVG(OriginCityMarketID) FROM mytable WHERE CRSDepTime >= 1527 GROUP BY TailNum, DestCityMarketID  ORDER BY TailNum, DestCityMarketID LIMIT 2"]}
{"sql":"SELECT DestStateFips, ArrTimeBlk, TailNum FROM mytable WHERE LateAircraftDelay = 99 AND DayOfWeek BETWEEN 3 AND 2 ORDER BY ActualElapsedTime LIMIT 9"}
{"sql":"SELECT WheelsOff, DestState, Origin, COUNT(LongestAddGTime), MIN(\"Month\"), MIN(OriginCityMarketID) FROM mytable WHERE WeatherDelay <= 23 GROUP BY WheelsOff, DestState, Origin LIMIT 25","hsqls":["SELECT WheelsOff, DestState, Origin, COUNT(LongestAddGTime), MIN(`Month`), MIN(OriginCityMarketID) FROM mytable WHERE WeatherDelay <= 23 GROUP BY WheelsOff, DestState, Origin LIMIT 25"]}
{"sql":"SELECT \"Year\", CRSArrTime, AVG(Diverted) FROM mytable WHERE FlightNum NOT IN (2244, 307, 7369) AND DivAirportSeqIDs BETWEEN 1540103 AND 1072804 AND CarrierDelay IN (280, 71) GROUP BY \"Year\", CRSArrTime LIMIT 21","hsqls":["SELECT Year, CRSArrTime, AVG(CAST(Diverted AS DOUBLE)) FROM mytable WHERE FlightNum NOT IN (2244, 307, 7369) AND (DivAirportSeqIDs[1] BETWEEN 1540103 AND 1072804 OR DivAirportSeqIDs[2] BETWEEN 1540103 AND 1072804 OR DivAirportSeqIDs[3] BETWEEN 1540103 AND 1072804 OR DivAirportSeqIDs[4] BETWEEN 1540103 AND 1072804 OR DivAirportSeqIDs[5] BETWEEN 1540103 AND 1072804) AND CarrierDelay IN (280, 71) GROUP BY Year, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT DepDelay, DestState, OriginAirportID FROM mytable WHERE DaysSinceEpoch IN (16093, 16090) AND DivWheelsOns >= 1821 AND DaysSinceEpoch <= 16099 LIMIT 5","hsqls":["SELECT DepDelay, DestState, OriginAirportID FROM mytable WHERE DaysSinceEpoch IN (16093, 16090) AND (DivWheelsOns[1] >= 1821 OR DivWheelsOns[2] >= 1821 OR DivWheelsOns[3] >= 1821 OR DivWheelsOns[4] >= 1821 OR DivWheelsOns[5] >= 1821) AND DaysSinceEpoch <= 16099 LIMIT 10000"]}
{"sql":"SELECT COUNT(DivReachedDest) FROM mytable WHERE Diverted = 0 AND FirstDepTime <= 1040 LIMIT 28"}
{"sql":"SELECT MAX(Quarter), SUM(OriginAirportID), SUM(DestAirportID) FROM mytable WHERE ArrDelayMinutes > 321.0 OR ArrDel15 = 1 LIMIT 14"}
{"sql":"SELECT AVG(\"Year\"), COUNT(Dest) FROM mytable WHERE OriginState > 'GA' LIMIT 13","hsqls":["SELECT AVG(`Year`), COUNT(Dest) FROM mytable WHERE OriginState > 'GA' LIMIT 13"]}
{"sql":"SELECT CRSArrTime FROM mytable WHERE ArrDel15 BETWEEN 0 AND 0 OR DivActualElapsedTime IN (989, 387, 847) AND Quarter < 1 ORDER BY DepTimeBlk LIMIT 12"}
{"sql":"SELECT DivDistance, DivAirportLandings, OriginAirportID FROM mytable WHERE FlightNum > 712 AND ActualElapsedTime BETWEEN 152 AND 382 ORDER BY \"Month\" LIMIT 20","hsqls":["SELECT DivDistance, DivAirportLandings, OriginAirportID FROM mytable WHERE FlightNum > 712 AND ActualElapsedTime BETWEEN 152 AND 382 ORDER BY `Month` LIMIT 20"]}
{"sql":"SELECT COUNT(FirstDepTime), COUNT(ArrDelay) FROM mytable WHERE DestCityName <= 'Dubuque, IA' LIMIT 17"}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR FirstDepTime = 903 OR DepDel15 IN (1, 0, -9999) ORDER BY DestWac, CRSDepTime, DivArrDelay LIMIT 23","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR FirstDepTime = 903 OR DepDel15 IN (1, 0, -9999) ORDER BY DestWac, CRSDepTime, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT MIN(OriginAirportID), AVG(ArrDelayMinutes), MAX(DivArrDelay) FROM mytable WHERE OriginCityName IN ('Cleveland, OH', 'Carlsbad, CA', 'Petersburg, AK', 'Midland/Odessa, TX', 'Roanoke, VA') OR TailNum BETWEEN 'N617DL' AND 'N923FR' LIMIT 10"}
{"sql":"SELECT Flights FROM mytable WHERE DepTime BETWEEN 456 AND 2038 ORDER BY OriginWac, CancellationCode LIMIT 29"}
{"sql":"SELECT DepartureDelayGroups, ArrDelayMinutes, SUM(CarrierDelay), AVG(WeatherDelay), AVG(ActualElapsedTime) FROM mytable WHERE ArrTimeBlk <= '1500-1559' GROUP BY DepartureDelayGroups, ArrDelayMinutes  ORDER BY DepartureDelayGroups, ArrDelayMinutes LIMIT 18","hsqls":["SELECT DepartureDelayGroups, ArrDelayMinutes, SUM(CarrierDelay), AVG(WeatherDelay), AVG(ActualElapsedTime) FROM mytable WHERE ArrTimeBlk <= '1500-1559' GROUP BY DepartureDelayGroups, ArrDelayMinutes  ORDER BY DepartureDelayGroups, ArrDelayMinutes LIMIT 18"]}
{"sql":"SELECT CarrierDelay, DestStateName, Origin, MAX(Distance) FROM mytable WHERE Distance BETWEEN 311 AND 119 AND DivDistance BETWEEN 636 AND 21 GROUP BY CarrierDelay, DestStateName, Origin  ORDER BY CarrierDelay, DestStateName, Origin LIMIT 22","hsqls":["SELECT CarrierDelay, DestStateName, Origin, MAX(Distance) FROM mytable WHERE Distance BETWEEN 311 AND 119 AND DivDistance BETWEEN 636 AND 21 GROUP BY CarrierDelay, DestStateName, Origin  ORDER BY CarrierDelay, DestStateName, Origin LIMIT 22"]}
{"sql":"SELECT NASDelay, \"Month\", CRSDepTime, COUNT(*) FROM mytable WHERE Dest IN ('DAB') OR DaysSinceEpoch = 16101 GROUP BY NASDelay, \"Month\", CRSDepTime LIMIT 25","hsqls":["SELECT NASDelay, Month, CRSDepTime, COUNT(*) FROM mytable WHERE Dest IN ('DAB') OR DaysSinceEpoch = 16101 GROUP BY NASDelay, Month, CRSDepTime LIMIT 25"]}
{"sql":"SELECT AVG(DestAirportSeqID), MAX(DepTime), AVG(DayofMonth) FROM mytable LIMIT 25"}
{"sql":"SELECT TotalAddGTime FROM mytable WHERE TaxiIn BETWEEN 11 AND 2 AND Cancelled BETWEEN 1 AND 1 ORDER BY FirstDepTime, NASDelay, DaysSinceEpoch LIMIT 5"}
{"sql":"SELECT \"Year\", CRSElapsedTime, COUNT(*) FROM mytable WHERE DivWheelsOffs IN (2320) GROUP BY \"Year\", CRSElapsedTime LIMIT 4","hsqls":["SELECT Year, CRSElapsedTime, COUNT(*) FROM mytable WHERE (DivWheelsOffs[1] IN (2320) OR DivWheelsOffs[2] IN (2320) OR DivWheelsOffs[3] IN (2320) OR DivWheelsOffs[4] IN (2320) OR DivWheelsOffs[5] IN (2320)) GROUP BY Year, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes, ArrTimeBlk, DayofMonth FROM mytable WHERE AirTime IN (189) AND DepDelay IN (120.0, 252.0) LIMIT 4","hsqls":["SELECT DivLongestGTimes, ArrTimeBlk, DayofMonth FROM mytable WHERE AirTime IN (189) AND DepDelay IN (120.0, 252.0) LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes, OriginState FROM mytable WHERE Distance IN (850) OR DivWheelsOns BETWEEN 1747 AND 1229 ORDER BY ArrDel15 LIMIT 19","hsqls":["SELECT DivLongestGTimes, OriginState FROM mytable WHERE Distance IN (850) OR (DivWheelsOns[1] BETWEEN 1747 AND 1229 OR DivWheelsOns[2] BETWEEN 1747 AND 1229 OR DivWheelsOns[3] BETWEEN 1747 AND 1229 OR DivWheelsOns[4] BETWEEN 1747 AND 1229 OR DivWheelsOns[5] BETWEEN 1747 AND 1229) ORDER BY ArrDel15 LIMIT 10000"]}
{"sql":"SELECT FlightNum, CRSDepTime, ArrivalDelayGroups FROM mytable WHERE DepTime IN (521, 930, 744, 1342) OR \"Month\" < 1 AND DestCityName > 'Columbus, OH' ORDER BY WeatherDelay, DestCityMarketID, WheelsOn LIMIT 1","hsqls":["SELECT FlightNum, CRSDepTime, ArrivalDelayGroups FROM mytable WHERE DepTime IN (521, 930, 744, 1342) OR `Month` < 1 AND DestCityName > 'Columbus, OH' ORDER BY WeatherDelay, DestCityMarketID, WheelsOn LIMIT 1"]}
{"sql":"SELECT SecurityDelay, ArrDelayMinutes, DivActualElapsedTime FROM mytable WHERE AirTime IN (313) AND OriginStateName <= 'U.S. Virgin Islands' OR OriginState IN ('VI') LIMIT 12"}
{"sql":"SELECT ArrDelay FROM mytable WHERE OriginStateName BETWEEN 'Idaho' AND 'Illinois' ORDER BY OriginAirportSeqID, OriginStateFips, DestCityName LIMIT 25"}
{"sql":"SELECT MAX(LateAircraftDelay), COUNT(AirlineID) FROM mytable LIMIT 3"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DistanceGroup NOT IN (2, 7, 5, 4, 11) OR WheelsOn > 2221 OR CarrierDelay BETWEEN 0 AND 58 LIMIT 9"}
{"sql":"SELECT OriginCityMarketID, FlightNum, DivActualElapsedTime, AVG(OriginAirportID) FROM mytable GROUP BY OriginCityMarketID, FlightNum, DivActualElapsedTime  ORDER BY OriginCityMarketID, FlightNum, DivActualElapsedTime LIMIT 2","hsqls":["SELECT OriginCityMarketID, FlightNum, DivActualElapsedTime, AVG(OriginAirportID) FROM mytable GROUP BY OriginCityMarketID, FlightNum, DivActualElapsedTime  ORDER BY OriginCityMarketID, FlightNum, DivActualElapsedTime LIMIT 2"]}
{"sql":"SELECT OriginAirportSeqID, Cancelled FROM mytable WHERE DivLongestGTimes BETWEEN 50.0 AND 94.0 AND Flights < 1 AND ArrTimeBlk NOT IN ('1700-1759', '2200-2259') LIMIT 12","hsqls":["SELECT OriginAirportSeqID, Cancelled FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 50.0 AND 94.0 OR DivLongestGTimes[2] BETWEEN 50.0 AND 94.0 OR DivLongestGTimes[3] BETWEEN 50.0 AND 94.0 OR DivLongestGTimes[4] BETWEEN 50.0 AND 94.0 OR DivLongestGTimes[5] BETWEEN 50.0 AND 94.0) AND Flights < 1 AND ArrTimeBlk NOT IN ('1700-1759', '2200-2259') LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, DepDelayMinutes, OriginCityName, COUNT(*) FROM mytable WHERE DistanceGroup > 10 GROUP BY CarrierDelay, DepDelayMinutes, OriginCityName  ORDER BY CarrierDelay, DepDelayMinutes, OriginCityName LIMIT 3","hsqls":["SELECT CarrierDelay, DepDelayMinutes, OriginCityName, COUNT(*) FROM mytable WHERE DistanceGroup > 10 GROUP BY CarrierDelay, DepDelayMinutes, OriginCityName  ORDER BY CarrierDelay, DepDelayMinutes, OriginCityName LIMIT 3"]}
{"sql":"SELECT OriginWac, ArrDelay, OriginStateName FROM mytable WHERE TaxiIn BETWEEN 65 AND 35 LIMIT 27"}
{"sql":"SELECT DestWac FROM mytable WHERE DivReachedDest IN (0, -9999) OR Dest <= 'MDW' OR DistanceGroup IN (1, 6, 5) ORDER BY CRSArrTime LIMIT 20"}
{"sql":"SELECT COUNT(DestStateName), AVG(CRSElapsedTime), AVG(OriginStateFips) FROM mytable WHERE ArrDelay IN (19.0, -47.0, 1.0) OR DestState BETWEEN 'CA' AND 'MT' OR Diverted <> 1 LIMIT 26"}
{"sql":"SELECT ArrDel15, NASDelay FROM mytable ORDER BY DepDelay, WheelsOn LIMIT 24"}
{"sql":"SELECT FirstDepTime, LongestAddGTime, UniqueCarrier FROM mytable WHERE DepTime BETWEEN 2117 AND 539 OR DivArrDelay > 277 OR ArrTime BETWEEN 1310 AND 2019 ORDER BY LongestAddGTime, TailNum, AirlineID LIMIT 28"}
{"sql":"SELECT FirstDepTime, Carrier, WeatherDelay, COUNT(*) FROM mytable WHERE OriginStateName = 'Kentucky' GROUP BY FirstDepTime, Carrier, WeatherDelay","hsqls":["SELECT FirstDepTime, Carrier, WeatherDelay, COUNT(*) FROM mytable WHERE OriginStateName = 'Kentucky' GROUP BY FirstDepTime, Carrier, WeatherDelay"]}
{"sql":"SELECT LateAircraftDelay, DestAirportSeqID, DepDel15, COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 GROUP BY LateAircraftDelay, DestAirportSeqID, DepDel15  ORDER BY LateAircraftDelay, DestAirportSeqID, DepDel15 LIMIT 10","hsqls":["SELECT LateAircraftDelay, DestAirportSeqID, DepDel15, COUNT(*) FROM mytable WHERE Quarter BETWEEN 1 AND 1 GROUP BY LateAircraftDelay, DestAirportSeqID, DepDel15  ORDER BY LateAircraftDelay, DestAirportSeqID, DepDel15 LIMIT 10"]}
{"sql":"SELECT OriginState, \"Month\", OriginAirportID FROM mytable WHERE WeatherDelay BETWEEN 316 AND 319 OR OriginAirportID > 11697 ORDER BY TotalAddGTime LIMIT 22","hsqls":["SELECT OriginState, Month, OriginAirportID FROM mytable WHERE WeatherDelay BETWEEN 316 AND 319 OR OriginAirportID > 11697 ORDER BY TotalAddGTime LIMIT 22"]}
{"sql":"SELECT DestStateName, AirlineID, DivActualElapsedTime FROM mytable LIMIT 15"}
{"sql":"SELECT DivDistance, TotalAddGTime, DestAirportID FROM mytable WHERE DepTimeBlk > '2200-2259' ORDER BY DepDelay, Quarter LIMIT 7"}
{"sql":"SELECT DayofMonth FROM mytable WHERE DivAirportIDs IN (14524, 11109, 11630, 14783, 10397) LIMIT 20","hsqls":["SELECT DayofMonth FROM mytable WHERE (DivAirportIDs[1] IN (14524, 11109, 11630, 14783, 10397) OR DivAirportIDs[2] IN (14524, 11109, 11630, 14783, 10397) OR DivAirportIDs[3] IN (14524, 11109, 11630, 14783, 10397) OR DivAirportIDs[4] IN (14524, 11109, 11630, 14783, 10397) OR DivAirportIDs[5] IN (14524, 11109, 11630, 14783, 10397)) LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE ArrDelayMinutes < 250.0 LIMIT 26","hsqls":["SELECT DivWheelsOns FROM mytable WHERE ArrDelayMinutes < 250.0 LIMIT 10000"]}
{"sql":"SELECT WheelsOff, OriginCityName, Cancelled FROM mytable WHERE DestState BETWEEN 'PR' AND 'MI' ORDER BY DestState, CRSDepTime LIMIT 17"}
{"sql":"SELECT Quarter, DepDel15, DayofMonth FROM mytable WHERE CRSDepTime IN (1129) AND Cancelled IN (1, 0) ORDER BY Origin, DivAirportLandings LIMIT 19"}
{"sql":"SELECT Carrier, DestStateFips, DayOfWeek FROM mytable WHERE LongestAddGTime = 34 AND FlightDate IN ('2014-01-23', '2014-01-30') ORDER BY Carrier LIMIT 7"}
{"sql":"SELECT SUM(DepTime), COUNT(CRSElapsedTime), MIN(OriginCityMarketID) FROM mytable WHERE ArrTimeBlk <> '1700-1759' AND DestAirportSeqID BETWEEN 1015502 AND 1104103 OR DestStateFips IN (49, 2, 4, 36, 12) LIMIT 4"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 18"}
{"sql":"SELECT DestState, AVG(LateAircraftDelay), MIN(\"Month\"), MIN(ArrivalDelayGroups) FROM mytable WHERE SecurityDelay IN (27) AND DepTimeBlk NOT IN ('1100-1159', '1300-1359') OR DivWheelsOffs IN (1856, 1006, 1152, 1326, 1631) GROUP BY DestState LIMIT 12","hsqls":["SELECT DestState, AVG(LateAircraftDelay), MIN(`Month`), MIN(ArrivalDelayGroups) FROM mytable WHERE SecurityDelay IN (27) AND DepTimeBlk NOT IN ('1100-1159', '1300-1359') OR (DivWheelsOffs[1] IN (1856, 1006, 1152, 1326, 1631) OR DivWheelsOffs[2] IN (1856, 1006, 1152, 1326, 1631) OR DivWheelsOffs[3] IN (1856, 1006, 1152, 1326, 1631) OR DivWheelsOffs[4] IN (1856, 1006, 1152, 1326, 1631) OR DivWheelsOffs[5] IN (1856, 1006, 1152, 1326, 1631)) GROUP BY DestState LIMIT 10000"]}
{"sql":"SELECT DivDistance, FirstDepTime FROM mytable WHERE Distance BETWEEN 2342 AND 1039 ORDER BY OriginStateFips, TailNum LIMIT 11"}
{"sql":"SELECT OriginStateFips, OriginCityMarketID, CRSDepTime FROM mytable ORDER BY Origin, CRSElapsedTime LIMIT 8"}
{"sql":"SELECT TailNum, AVG(Distance) FROM mytable WHERE WeatherDelay >= 74 OR DepTimeBlk >= '1500-1559' GROUP BY TailNum  ORDER BY TailNum LIMIT 10","hsqls":["SELECT TailNum, AVG(Distance) FROM mytable WHERE WeatherDelay >= 74 OR DepTimeBlk >= '1500-1559' GROUP BY TailNum  ORDER BY TailNum LIMIT 10"]}
{"sql":"SELECT DestStateFips FROM mytable WHERE ArrDelay < -19.0 LIMIT 21"}
{"sql":"SELECT Diverted, Flights, AVG(Flights), SUM(OriginStateFips) FROM mytable GROUP BY Diverted, Flights  ORDER BY Diverted, Flights LIMIT 12","hsqls":["SELECT Diverted, Flights, AVG(Flights), SUM(OriginStateFips) FROM mytable GROUP BY Diverted, Flights  ORDER BY Diverted, Flights LIMIT 12"]}
{"sql":"SELECT OriginCityMarketID, DestStateFips FROM mytable ORDER BY DivDistance, DaysSinceEpoch LIMIT 6"}
{"sql":"SELECT LateAircraftDelay, SecurityDelay, DestAirportSeqID, MIN(ActualElapsedTime), SUM(CRSArrTime), MIN(DestStateFips) FROM mytable WHERE ArrDel15 <> -9999 OR DepTime >= 1156 GROUP BY LateAircraftDelay, SecurityDelay, DestAirportSeqID  ORDER BY LateAircraftDelay, SecurityDelay, DestAirportSeqID LIMIT 15","hsqls":["SELECT LateAircraftDelay, SecurityDelay, DestAirportSeqID, MIN(ActualElapsedTime), SUM(CRSArrTime), MIN(DestStateFips) FROM mytable WHERE ArrDel15 <> -9999 OR DepTime >= 1156 GROUP BY LateAircraftDelay, SecurityDelay, DestAirportSeqID  ORDER BY LateAircraftDelay, SecurityDelay, DestAirportSeqID LIMIT 15"]}
{"sql":"SELECT LongestAddGTime, DivAirportIDs FROM mytable WHERE DestWac NOT IN (1, 51, 87, 11) AND DivLongestGTimes = 97.0 OR ArrTime BETWEEN 1356 AND 1758 ORDER BY OriginAirportSeqID, FirstDepTime LIMIT 15","hsqls":["SELECT LongestAddGTime, DivAirportIDs FROM mytable WHERE DestWac NOT IN (1, 51, 87, 11) AND (DivLongestGTimes[1] = 97.0 OR DivLongestGTimes[2] = 97.0 OR DivLongestGTimes[3] = 97.0 OR DivLongestGTimes[4] = 97.0 OR DivLongestGTimes[5] = 97.0) OR ArrTime BETWEEN 1356 AND 1758 ORDER BY OriginAirportSeqID, FirstDepTime LIMIT 10000"]}
{"sql":"SELECT FlightNum, DestAirportID, OriginAirportID FROM mytable ORDER BY Quarter, FirstDepTime, DivAirportLandings LIMIT 14"}
{"sql":"SELECT DepTime, DestStateName, CancellationCode, MIN(DepartureDelayGroups), SUM(DivReachedDest) FROM mytable WHERE CRSDepTime BETWEEN 536 AND 838 AND \"Year\" BETWEEN 2014 AND 2014 AND OriginCityName BETWEEN 'Tucson, AZ' AND 'Akron, OH' GROUP BY DepTime, DestStateName, CancellationCode LIMIT 4","hsqls":["SELECT DepTime, DestStateName, CancellationCode, MIN(DepartureDelayGroups), SUM(DivReachedDest) FROM mytable WHERE CRSDepTime BETWEEN 536 AND 838 AND `Year` BETWEEN 2014 AND 2014 AND OriginCityName BETWEEN 'Tucson, AZ' AND 'Akron, OH' GROUP BY DepTime, DestStateName, CancellationCode LIMIT 4"]}
{"sql":"SELECT CancellationCode, CRSDepTime, SUM(DepTime) FROM mytable WHERE ArrivalDelayGroups NOT IN (3, 10, 7, 11) AND ArrDelayMinutes NOT IN (340.0) OR ArrTimeBlk IN ('1200-1259') GROUP BY CancellationCode, CRSDepTime  ORDER BY CancellationCode, CRSDepTime LIMIT 11","hsqls":["SELECT CancellationCode, CRSDepTime, SUM(DepTime) FROM mytable WHERE ArrivalDelayGroups NOT IN (3, 10, 7, 11) AND ArrDelayMinutes NOT IN (340.0) OR ArrTimeBlk IN ('1200-1259') GROUP BY CancellationCode, CRSDepTime  ORDER BY CancellationCode, CRSDepTime LIMIT 11"]}
{"sql":"SELECT Flights, ArrTimeBlk, Dest, MAX(ArrDelayMinutes) FROM mytable WHERE DivTotalGTimes IN (77, 80, 100, 76) GROUP BY Flights, ArrTimeBlk, Dest LIMIT 20","hsqls":["SELECT Flights, ArrTimeBlk, Dest, MAX(ArrDelayMinutes) FROM mytable WHERE (DivTotalGTimes[1] IN (77, 80, 100, 76) OR DivTotalGTimes[2] IN (77, 80, 100, 76) OR DivTotalGTimes[3] IN (77, 80, 100, 76) OR DivTotalGTimes[4] IN (77, 80, 100, 76) OR DivTotalGTimes[5] IN (77, 80, 100, 76)) GROUP BY Flights, ArrTimeBlk, Dest LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE ArrTime BETWEEN 818 AND 1049 ORDER BY TaxiOut, DestStateName, DivArrDelay LIMIT 29","hsqls":["SELECT DivWheelsOns FROM mytable WHERE ArrTime BETWEEN 818 AND 1049 ORDER BY TaxiOut, DestStateName, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, DivArrDelay, SUM(DepDelayMinutes), SUM(\"Year\") FROM mytable WHERE DayofMonth NOT IN (24, 25, 27) GROUP BY DestAirportSeqID, DivArrDelay LIMIT 8","hsqls":["SELECT DestAirportSeqID, DivArrDelay, SUM(DepDelayMinutes), SUM(`Year`) FROM mytable WHERE DayofMonth NOT IN (24, 25, 27) GROUP BY DestAirportSeqID, DivArrDelay LIMIT 8"]}
{"sql":"SELECT AVG(CarrierDelay), MIN(DivReachedDest), MIN(FirstDepTime) FROM mytable"}
{"sql":"SELECT ActualElapsedTime, WheelsOn, AVG(\"Year\"), MIN(CarrierDelay), MAX(DestWac) FROM mytable WHERE Origin BETWEEN 'PWM' AND 'LGB' OR DivAirports BETWEEN 'PHL' AND 'SBN' GROUP BY ActualElapsedTime, WheelsOn LIMIT 10","hsqls":["SELECT ActualElapsedTime, WheelsOn, AVG(`Year`), MIN(CarrierDelay), MAX(DestWac) FROM mytable WHERE Origin BETWEEN 'PWM' AND 'LGB' OR (DivAirports[1] BETWEEN 'PHL' AND 'SBN' OR DivAirports[2] BETWEEN 'PHL' AND 'SBN' OR DivAirports[3] BETWEEN 'PHL' AND 'SBN' OR DivAirports[4] BETWEEN 'PHL' AND 'SBN' OR DivAirports[5] BETWEEN 'PHL' AND 'SBN') GROUP BY ActualElapsedTime, WheelsOn LIMIT 10000"]}
{"sql":"SELECT DivReachedDest FROM mytable WHERE ArrTimeBlk IN ('0800-0859') OR DestStateFips NOT IN (42, 6) LIMIT 1"}
{"sql":"SELECT TaxiOut, LongestAddGTime, Distance, MAX(DepartureDelayGroups), SUM(DivActualElapsedTime) FROM mytable WHERE OriginAirportSeqID > 1343302 AND OriginState <= 'TT' OR Carrier NOT IN ('DL', 'B6', 'OO', 'UA', 'VX') GROUP BY TaxiOut, LongestAddGTime, Distance  ORDER BY TaxiOut, LongestAddGTime, Distance LIMIT 13","hsqls":["SELECT TaxiOut, LongestAddGTime, Distance, MAX(DepartureDelayGroups), SUM(DivActualElapsedTime) FROM mytable WHERE OriginAirportSeqID > 1343302 AND OriginState <= 'TT' OR Carrier NOT IN ('DL', 'B6', 'OO', 'UA', 'VX') GROUP BY TaxiOut, LongestAddGTime, Distance  ORDER BY TaxiOut, LongestAddGTime, Distance LIMIT 13"]}
{"sql":"SELECT DayofMonth, AVG(Quarter), COUNT(WeatherDelay) FROM mytable WHERE LateAircraftDelay <= 40 OR WheelsOff IN (822, 1703, 1318, 1846) GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 12","hsqls":["SELECT DayofMonth, AVG(Quarter), COUNT(WeatherDelay) FROM mytable WHERE LateAircraftDelay <= 40 OR WheelsOff IN (822, 1703, 1318, 1846) GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 12"]}
{"sql":"SELECT ActualElapsedTime, NASDelay, DestAirportID, MAX(FirstDepTime), MIN(DayofMonth) FROM mytable WHERE DepTimeBlk BETWEEN '1300-1359' AND '1500-1559' OR ArrivalDelayGroups NOT IN (3, 6, 5, 12) GROUP BY ActualElapsedTime, NASDelay, DestAirportID  ORDER BY ActualElapsedTime, NASDelay, DestAirportID LIMIT 29","hsqls":["SELECT ActualElapsedTime, NASDelay, DestAirportID, MAX(FirstDepTime), MIN(DayofMonth) FROM mytable WHERE DepTimeBlk BETWEEN '1300-1359' AND '1500-1559' OR ArrivalDelayGroups NOT IN (3, 6, 5, 12) GROUP BY ActualElapsedTime, NASDelay, DestAirportID  ORDER BY ActualElapsedTime, NASDelay, DestAirportID LIMIT 29"]}
{"sql":"SELECT OriginStateFips, FlightDate, NASDelay FROM mytable WHERE OriginStateName > 'Georgia' ORDER BY DivDistance LIMIT 26"}
{"sql":"SELECT CRSDepTime, MAX(DivArrDelay) FROM mytable WHERE DaysSinceEpoch BETWEEN 16081 AND 16083 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 29","hsqls":["SELECT CRSDepTime, MAX(DivArrDelay) FROM mytable WHERE DaysSinceEpoch BETWEEN 16081 AND 16083 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 29"]}
{"sql":"SELECT WeatherDelay, DestCityName, AirlineID FROM mytable WHERE DestCityName IN ('Guam, TT', 'Kodiak, AK', 'Medford, OR', 'Nome, AK', 'International Falls, MN') LIMIT 23"}
{"sql":"SELECT DistanceGroup, CRSElapsedTime, MAX(OriginAirportSeqID), MIN(ArrivalDelayGroups) FROM mytable WHERE OriginStateFips > 30 OR Flights IN (1) OR Dest IN ('FSD') GROUP BY DistanceGroup, CRSElapsedTime  ORDER BY DistanceGroup, CRSElapsedTime LIMIT 5","hsqls":["SELECT DistanceGroup, CRSElapsedTime, MAX(OriginAirportSeqID), MIN(ArrivalDelayGroups) FROM mytable WHERE OriginStateFips > 30 OR Flights IN (1) OR Dest IN ('FSD') GROUP BY DistanceGroup, CRSElapsedTime  ORDER BY DistanceGroup, CRSElapsedTime LIMIT 5"]}
{"sql":"SELECT UniqueCarrier, COUNT(Flights), AVG(LateAircraftDelay) FROM mytable WHERE OriginStateName BETWEEN 'Michigan' AND 'Montana' GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 5","hsqls":["SELECT UniqueCarrier, COUNT(Flights), AVG(LateAircraftDelay) FROM mytable WHERE OriginStateName BETWEEN 'Michigan' AND 'Montana' GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 5"]}
{"sql":"SELECT UniqueCarrier FROM mytable WHERE DaysSinceEpoch <= 16101 AND WheelsOn NOT IN (1802, 1559, 1425) LIMIT 3"}
{"sql":"SELECT DayofMonth, OriginWac, DivArrDelay FROM mytable WHERE CRSArrTime BETWEEN 1743 AND 2103 ORDER BY \"Year\", Quarter, ArrivalDelayGroups LIMIT 17","hsqls":["SELECT DayofMonth, OriginWac, DivArrDelay FROM mytable WHERE CRSArrTime BETWEEN 1743 AND 2103 ORDER BY Year, Quarter, ArrivalDelayGroups LIMIT 17"]}
{"sql":"SELECT DepDelay, ArrDelay FROM mytable LIMIT 19"}
{"sql":"SELECT ArrivalDelayGroups, AVG(DaysSinceEpoch), MAX(CRSDepTime), MIN(Distance) FROM mytable WHERE Distance = 486 GROUP BY ArrivalDelayGroups","hsqls":["SELECT ArrivalDelayGroups, AVG(DaysSinceEpoch), MAX(CRSDepTime), MIN(Distance) FROM mytable WHERE Distance = 486 GROUP BY ArrivalDelayGroups"]}
{"sql":"SELECT CRSArrTime, SecurityDelay FROM mytable WHERE DepDelay IN (92.0, 194.0, 82.0) OR CarrierDelay BETWEEN 144 AND 49 ORDER BY DestWac, ArrDelay LIMIT 28"}
{"sql":"SELECT OriginCityMarketID, DepTime FROM mytable WHERE DaysSinceEpoch BETWEEN 16083 AND 16081 AND CRSElapsedTime NOT IN (163) OR DepDelayMinutes BETWEEN 10.0 AND 161.0 ORDER BY Cancelled"}
{"sql":"SELECT Diverted, OriginState FROM mytable WHERE UniqueCarrier BETWEEN 'VX' AND 'MQ' LIMIT 5"}
{"sql":"SELECT SUM(AirlineID) FROM mytable LIMIT 7"}
{"sql":"SELECT DepDelayMinutes, NASDelay, OriginStateName, MIN(ArrDelayMinutes), COUNT(Distance) FROM mytable WHERE CancellationCode IN ('A', 'B', 'C', 'noodles') GROUP BY DepDelayMinutes, NASDelay, OriginStateName  ORDER BY DepDelayMinutes, NASDelay, OriginStateName LIMIT 4","hsqls":["SELECT DepDelayMinutes, NASDelay, OriginStateName, MIN(ArrDelayMinutes), COUNT(Distance) FROM mytable WHERE CancellationCode IN ('A', 'B', 'C', 'noodles') GROUP BY DepDelayMinutes, NASDelay, OriginStateName  ORDER BY DepDelayMinutes, NASDelay, OriginStateName LIMIT 4"]}
{"sql":"SELECT ArrTimeBlk, COUNT(Flights) FROM mytable GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 5","hsqls":["SELECT ArrTimeBlk, COUNT(Flights) FROM mytable GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 5"]}
{"sql":"SELECT OriginCityName, TaxiIn FROM mytable WHERE ArrDelay BETWEEN 228.0 AND -6.0 OR ArrDelay IN (91.0) ORDER BY OriginCityMarketID LIMIT 29"}
{"sql":"SELECT MAX(NASDelay) FROM mytable LIMIT 10"}
{"sql":"SELECT LongestAddGTime, NASDelay FROM mytable LIMIT 26"}
{"sql":"SELECT SecurityDelay, ArrDelay FROM mytable WHERE DistanceGroup BETWEEN 3 AND 8 AND Dest NOT IN ('HOU', 'GSP') ORDER BY ActualElapsedTime, ArrDelay LIMIT 7"}
{"sql":"SELECT ArrTime, WheelsOn, OriginStateName, MAX(ArrivalDelayGroups), MIN(FirstDepTime) FROM mytable WHERE DivAirports IN ('HOU', 'BPT', 'MLI', 'LAS', 'CRP') GROUP BY ArrTime, WheelsOn, OriginStateName LIMIT 27","hsqls":["SELECT ArrTime, WheelsOn, OriginStateName, MAX(ArrivalDelayGroups), MIN(FirstDepTime) FROM mytable WHERE (DivAirports[1] IN ('HOU', 'BPT', 'MLI', 'LAS', 'CRP') OR DivAirports[2] IN ('HOU', 'BPT', 'MLI', 'LAS', 'CRP') OR DivAirports[3] IN ('HOU', 'BPT', 'MLI', 'LAS', 'CRP') OR DivAirports[4] IN ('HOU', 'BPT', 'MLI', 'LAS', 'CRP') OR DivAirports[5] IN ('HOU', 'BPT', 'MLI', 'LAS', 'CRP')) GROUP BY ArrTime, WheelsOn, OriginStateName LIMIT 10000"]}
{"sql":"SELECT DestState, DivTailNums, OriginWac FROM mytable WHERE TailNum NOT IN ('N839AS') ORDER BY FlightDate LIMIT 16","hsqls":["SELECT DestState, DivTailNums, OriginWac FROM mytable WHERE TailNum NOT IN ('N839AS') ORDER BY FlightDate LIMIT 10000"]}
{"sql":"SELECT DepDelay, CRSArrTime, DestAirportID FROM mytable WHERE Dest BETWEEN 'JAN' AND 'AUS' ORDER BY WeatherDelay LIMIT 7"}
{"sql":"SELECT OriginCityMarketID, DepDel15, OriginWac FROM mytable WHERE AirTime < 31 OR WeatherDelay BETWEEN 29 AND 92 ORDER BY FirstDepTime LIMIT 17"}
{"sql":"SELECT DivDistance, MIN(NASDelay) FROM mytable WHERE DivDistance NOT IN (717, 268) GROUP BY DivDistance  ORDER BY DivDistance LIMIT 20","hsqls":["SELECT DivDistance, MIN(NASDelay) FROM mytable WHERE DivDistance NOT IN (717, 268) GROUP BY DivDistance  ORDER BY DivDistance LIMIT 20"]}
{"sql":"SELECT DivReachedDest, OriginCityName, DepDel15 FROM mytable WHERE CRSArrTime IN (915, 1536) ORDER BY NASDelay LIMIT 8"}
{"sql":"SELECT ArrDel15, DestCityMarketID, AVG(OriginWac), SUM(WeatherDelay) FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 9 AND FlightDate BETWEEN '2014-01-05' AND '2014-01-04' GROUP BY ArrDel15, DestCityMarketID  ORDER BY ArrDel15, DestCityMarketID LIMIT 24","hsqls":["SELECT ArrDel15, DestCityMarketID, AVG(OriginWac), SUM(WeatherDelay) FROM mytable WHERE DivAirportLandings BETWEEN 2 AND 9 AND FlightDate BETWEEN '2014-01-05' AND '2014-01-04' GROUP BY ArrDel15, DestCityMarketID  ORDER BY ArrDel15, DestCityMarketID LIMIT 24"]}
{"sql":"SELECT \"Month\" FROM mytable WHERE OriginStateFips BETWEEN 72 AND 9 LIMIT 11","hsqls":["SELECT `Month` FROM mytable WHERE OriginStateFips BETWEEN 72 AND 9 LIMIT 11"]}
{"sql":"SELECT DivAirportSeqIDs, ArrDelayMinutes FROM mytable WHERE OriginStateName IN ('Colorado', 'Alaska', 'South Dakota') ORDER BY WeatherDelay LIMIT 5","hsqls":["SELECT DivAirportSeqIDs, ArrDelayMinutes FROM mytable WHERE OriginStateName IN ('Colorado', 'Alaska', 'South Dakota') ORDER BY WeatherDelay LIMIT 10000"]}
{"sql":"SELECT Cancelled FROM mytable WHERE UniqueCarrier NOT IN ('WN', 'OO', 'UA') AND DestCityMarketID BETWEEN 31637 AND 32600 AND DayofMonth IN (17, 29) LIMIT 9"}
{"sql":"SELECT DivDistance, WeatherDelay, CRSArrTime FROM mytable ORDER BY OriginCityName LIMIT 6"}
{"sql":"SELECT Diverted, Distance FROM mytable ORDER BY DivDistance, Origin LIMIT 9"}
{"sql":"SELECT TaxiIn, SUM(ArrivalDelayGroups), MAX(\"Year\"), COUNT(OriginStateName) FROM mytable WHERE Quarter NOT IN (1) GROUP BY TaxiIn LIMIT 14","hsqls":["SELECT TaxiIn, SUM(ArrivalDelayGroups), MAX(`Year`), COUNT(OriginStateName) FROM mytable WHERE Quarter NOT IN (1) GROUP BY TaxiIn LIMIT 14"]}
{"sql":"SELECT FirstDepTime, TotalAddGTime, TailNum, AVG(DepDel15), SUM(CRSArrTime) FROM mytable WHERE ArrDel15 BETWEEN 1 AND 1 AND Carrier < 'MQ' OR DivReachedDest BETWEEN 0 AND 1 GROUP BY FirstDepTime, TotalAddGTime, TailNum  ORDER BY FirstDepTime, TotalAddGTime, TailNum LIMIT 18","hsqls":["SELECT FirstDepTime, TotalAddGTime, TailNum, AVG(DepDel15), SUM(CRSArrTime) FROM mytable WHERE ArrDel15 BETWEEN 1 AND 1 AND Carrier < 'MQ' OR DivReachedDest BETWEEN 0 AND 1 GROUP BY FirstDepTime, TotalAddGTime, TailNum  ORDER BY FirstDepTime, TotalAddGTime, TailNum LIMIT 18"]}
{"sql":"SELECT Flights, ArrivalDelayGroups, MIN(OriginWac), SUM(DepTime), AVG(DivArrDelay) FROM mytable WHERE DivAirportIDs IN (13296, 14771, 14783, 14288, 12819) GROUP BY Flights, ArrivalDelayGroups","hsqls":["SELECT Flights, ArrivalDelayGroups, MIN(OriginWac), SUM(DepTime), AVG(DivArrDelay) FROM mytable WHERE (DivAirportIDs[1] IN (13296, 14771, 14783, 14288, 12819) OR DivAirportIDs[2] IN (13296, 14771, 14783, 14288, 12819) OR DivAirportIDs[3] IN (13296, 14771, 14783, 14288, 12819) OR DivAirportIDs[4] IN (13296, 14771, 14783, 14288, 12819) OR DivAirportIDs[5] IN (13296, 14771, 14783, 14288, 12819)) GROUP BY Flights, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, AirlineID, OriginWac, COUNT(*) FROM mytable WHERE \"Year\" <= 2014 AND DivDistance > 157 AND Flights <> 1 GROUP BY SecurityDelay, AirlineID, OriginWac LIMIT 4","hsqls":["SELECT SecurityDelay, AirlineID, OriginWac, COUNT(*) FROM mytable WHERE `Year` <= 2014 AND DivDistance > 157 AND Flights <> 1 GROUP BY SecurityDelay, AirlineID, OriginWac LIMIT 4"]}
{"sql":"SELECT TotalAddGTime, Dest, CRSElapsedTime FROM mytable WHERE DepDelay IN (241.0, 470.0, 39.0) AND CRSElapsedTime NOT IN (230, 305, 190, 255) OR CRSArrTime NOT IN (2233, 1233, 905, 1951, 836) ORDER BY SecurityDelay LIMIT 21"}
{"sql":"SELECT FlightNum, AirlineID FROM mytable WHERE DivWheelsOns BETWEEN 2003 AND 1324 OR DestAirportID IN (14113, 11433, 12758) ORDER BY DestCityName, Origin, CRSDepTime LIMIT 10","hsqls":["SELECT FlightNum, AirlineID FROM mytable WHERE (DivWheelsOns[1] BETWEEN 2003 AND 1324 OR DivWheelsOns[2] BETWEEN 2003 AND 1324 OR DivWheelsOns[3] BETWEEN 2003 AND 1324 OR DivWheelsOns[4] BETWEEN 2003 AND 1324 OR DivWheelsOns[5] BETWEEN 2003 AND 1324) OR DestAirportID IN (14113, 11433, 12758) ORDER BY DestCityName, Origin, CRSDepTime LIMIT 10000"]}
{"sql":"SELECT ArrDelay, DayOfWeek FROM mytable WHERE DivTotalGTimes IN (117, 90, 9, 16, 73) AND DivArrDelay BETWEEN 258 AND 481 ORDER BY DestState LIMIT 23","hsqls":["SELECT ArrDelay, DayOfWeek FROM mytable WHERE (DivTotalGTimes[1] IN (117, 90, 9, 16, 73) OR DivTotalGTimes[2] IN (117, 90, 9, 16, 73) OR DivTotalGTimes[3] IN (117, 90, 9, 16, 73) OR DivTotalGTimes[4] IN (117, 90, 9, 16, 73) OR DivTotalGTimes[5] IN (117, 90, 9, 16, 73)) AND DivArrDelay BETWEEN 258 AND 481 ORDER BY DestState LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, DestStateName FROM mytable WHERE \"Year\" >= 2014 AND FlightDate IN ('2014-01-14', '2014-01-17') LIMIT 13","hsqls":["SELECT DepDelayMinutes, DestStateName FROM mytable WHERE `Year` >= 2014 AND FlightDate IN ('2014-01-14', '2014-01-17') LIMIT 13"]}
{"sql":"SELECT Carrier, DestStateFips, OriginStateName, MAX(DepDelayMinutes) FROM mytable WHERE DivArrDelay IN (252, 226, 70) OR DivLongestGTimes IN (28.0, 62.0, 87.0) OR TaxiOut > 56 GROUP BY Carrier, DestStateFips, OriginStateName LIMIT 7","hsqls":["SELECT Carrier, DestStateFips, OriginStateName, MAX(DepDelayMinutes) FROM mytable WHERE DivArrDelay IN (252, 226, 70) OR (DivLongestGTimes[1] IN (28.0, 62.0, 87.0) OR DivLongestGTimes[2] IN (28.0, 62.0, 87.0) OR DivLongestGTimes[3] IN (28.0, 62.0, 87.0) OR DivLongestGTimes[4] IN (28.0, 62.0, 87.0) OR DivLongestGTimes[5] IN (28.0, 62.0, 87.0)) OR TaxiOut > 56 GROUP BY Carrier, DestStateFips, OriginStateName LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DayofMonth BETWEEN 30 AND 25 OR DepTimeBlk = '0800-0859' OR AirlineID IN (20304, 19930, 21171, 19977) LIMIT 6"}
{"sql":"SELECT DepTime, DivArrDelay FROM mytable WHERE LateAircraftDelay BETWEEN 41 AND 11 ORDER BY Origin, DepTimeBlk, DestCityMarketID LIMIT 3"}
{"sql":"SELECT WheelsOff, LateAircraftDelay, UniqueCarrier FROM mytable ORDER BY FlightNum, AirTime, CRSElapsedTime LIMIT 24"}
{"sql":"SELECT OriginStateFips FROM mytable WHERE DestWac IN (43, 5, 35, 51, 85) OR Dest <= 'PIA' AND Diverted BETWEEN 0 AND 1 ORDER BY DestWac, DepDel15 LIMIT 22"}
{"sql":"SELECT TaxiOut, LateAircraftDelay FROM mytable ORDER BY ArrDelayMinutes, DestStateName, OriginWac LIMIT 17"}
{"sql":"SELECT MAX(WheelsOff), MIN(LateAircraftDelay), COUNT(FlightDate) FROM mytable LIMIT 13"}
{"sql":"SELECT MIN(DivReachedDest), AVG(AirTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 AND \"Year\" < 2014 OR CRSElapsedTime >= 337 LIMIT 29","hsqls":["SELECT MIN(DivReachedDest), AVG(AirTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 AND `Year` < 2014 OR CRSElapsedTime >= 337 LIMIT 29"]}
{"sql":"SELECT TaxiIn, DivAirportSeqIDs, ActualElapsedTime FROM mytable ORDER BY OriginAirportSeqID LIMIT 14","hsqls":["SELECT TaxiIn, DivAirportSeqIDs, ActualElapsedTime FROM mytable ORDER BY OriginAirportSeqID LIMIT 10000"]}
{"sql":"SELECT LongestAddGTime, SecurityDelay, TotalAddGTime FROM mytable WHERE AirTime NOT IN (30, 201, 333, 235) AND DistanceGroup BETWEEN 8 AND 5 ORDER BY DestStateName LIMIT 2"}
{"sql":"SELECT FlightNum, ActualElapsedTime, MIN(Quarter), SUM(OriginAirportID) FROM mytable WHERE OriginAirportSeqID IN (1040802, 1232002, 1509602, 1490503) GROUP BY FlightNum, ActualElapsedTime  ORDER BY FlightNum, ActualElapsedTime LIMIT 28","hsqls":["SELECT FlightNum, ActualElapsedTime, MIN(Quarter), SUM(OriginAirportID) FROM mytable WHERE OriginAirportSeqID IN (1040802, 1232002, 1509602, 1490503) GROUP BY FlightNum, ActualElapsedTime  ORDER BY FlightNum, ActualElapsedTime LIMIT 28"]}
{"sql":"SELECT DivTotalGTimes, DayOfWeek FROM mytable WHERE Quarter NOT IN (1) AND Distance BETWEEN 624 AND 1709 ORDER BY DestStateName","hsqls":["SELECT DivTotalGTimes, DayOfWeek FROM mytable WHERE Quarter NOT IN (1) AND Distance BETWEEN 624 AND 1709 ORDER BY DestStateName LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, ArrTimeBlk, MIN(SecurityDelay), COUNT(DayOfWeek) FROM mytable WHERE DayofMonth NOT IN (7, 11) GROUP BY DepDelayMinutes, ArrTimeBlk  ORDER BY DepDelayMinutes, ArrTimeBlk LIMIT 19","hsqls":["SELECT DepDelayMinutes, ArrTimeBlk, MIN(SecurityDelay), COUNT(DayOfWeek) FROM mytable WHERE DayofMonth NOT IN (7, 11) GROUP BY DepDelayMinutes, ArrTimeBlk  ORDER BY DepDelayMinutes, ArrTimeBlk LIMIT 19"]}
{"sql":"SELECT OriginAirportSeqID, DestState, DepTimeBlk FROM mytable WHERE OriginStateName BETWEEN 'North Dakota' AND 'Idaho' OR DepDelayMinutes BETWEEN 4.0 AND 200.0 OR Dest BETWEEN 'MGM' AND 'CMX' ORDER BY DestState, DestStateName LIMIT 15"}
{"sql":"SELECT OriginStateFips, COUNT(*) FROM mytable WHERE DivAirportLandings <> 9 AND DepDel15 IN (0) GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 20","hsqls":["SELECT OriginStateFips, COUNT(*) FROM mytable WHERE DivAirportLandings <> 9 AND DepDel15 IN (0) GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 20"]}
{"sql":"SELECT DestStateFips, SUM(DaysSinceEpoch) FROM mytable WHERE ActualElapsedTime NOT IN (326, 37, 273) AND DivAirportLandings NOT IN (2, 1, 0, 9) OR DivWheelsOffs BETWEEN 1659 AND 809 GROUP BY DestStateFips LIMIT 28","hsqls":["SELECT DestStateFips, SUM(DaysSinceEpoch) FROM mytable WHERE ActualElapsedTime NOT IN (326, 37, 273) AND DivAirportLandings NOT IN (2, 1, 0, 9) OR (DivWheelsOffs[1] BETWEEN 1659 AND 809 OR DivWheelsOffs[2] BETWEEN 1659 AND 809 OR DivWheelsOffs[3] BETWEEN 1659 AND 809 OR DivWheelsOffs[4] BETWEEN 1659 AND 809 OR DivWheelsOffs[5] BETWEEN 1659 AND 809) GROUP BY DestStateFips LIMIT 10000"]}
{"sql":"SELECT \"Year\", ArrTime, DayofMonth FROM mytable ORDER BY WheelsOff, CRSDepTime, CRSElapsedTime","hsqls":["SELECT Year, ArrTime, DayofMonth FROM mytable ORDER BY WheelsOff, CRSDepTime, CRSElapsedTime"]}
{"sql":"SELECT DivReachedDest, MIN(SecurityDelay), MAX(OriginAirportID), AVG(DepTime) FROM mytable GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 6","hsqls":["SELECT DivReachedDest, MIN(SecurityDelay), MAX(OriginAirportID), AVG(DepTime) FROM mytable GROUP BY DivReachedDest  ORDER BY DivReachedDest LIMIT 6"]}
{"sql":"SELECT CancellationCode FROM mytable WHERE OriginAirportSeqID BETWEEN 1387302 AND 1336003 AND DestState = 'MI' ORDER BY OriginAirportSeqID LIMIT 22"}
{"sql":"SELECT DivActualElapsedTime, MIN(ActualElapsedTime), COUNT(Cancelled) FROM mytable WHERE DepDelayMinutes > 225.0 AND LateAircraftDelay NOT IN (197, 76) GROUP BY DivActualElapsedTime  ORDER BY DivActualElapsedTime LIMIT 6","hsqls":["SELECT DivActualElapsedTime, MIN(ActualElapsedTime), COUNT(Cancelled) FROM mytable WHERE DepDelayMinutes > 225.0 AND LateAircraftDelay NOT IN (197, 76) GROUP BY DivActualElapsedTime  ORDER BY DivActualElapsedTime LIMIT 6"]}
{"sql":"SELECT Origin FROM mytable WHERE AirlineID BETWEEN 20409 AND 19393 OR DivTotalGTimes BETWEEN 48 AND 111 OR TaxiIn BETWEEN -9999 AND 37 ORDER BY DepDelayMinutes, ArrDelayMinutes LIMIT 12","hsqls":["SELECT Origin FROM mytable WHERE AirlineID BETWEEN 20409 AND 19393 OR (DivTotalGTimes[1] BETWEEN 48 AND 111 OR DivTotalGTimes[2] BETWEEN 48 AND 111 OR DivTotalGTimes[3] BETWEEN 48 AND 111 OR DivTotalGTimes[4] BETWEEN 48 AND 111 OR DivTotalGTimes[5] BETWEEN 48 AND 111) OR TaxiIn BETWEEN -9999 AND 37 ORDER BY DepDelayMinutes, ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT Cancelled, CancellationCode FROM mytable WHERE DestStateFips BETWEEN 24 AND 34 AND AirTime IN (202, 357, 172, 192) AND DestCityMarketID <> 31308 ORDER BY DepDelay, Carrier LIMIT 23"}
{"sql":"SELECT OriginState, Distance, TaxiIn, COUNT(*) FROM mytable WHERE CRSArrTime NOT IN (1631) GROUP BY OriginState, Distance, TaxiIn  ORDER BY OriginState, Distance, TaxiIn LIMIT 21","hsqls":["SELECT OriginState, Distance, TaxiIn, COUNT(*) FROM mytable WHERE CRSArrTime NOT IN (1631) GROUP BY OriginState, Distance, TaxiIn  ORDER BY OriginState, Distance, TaxiIn LIMIT 21"]}
{"sql":"SELECT WheelsOff, Diverted, DestAirportSeqID FROM mytable WHERE DestCityName < 'Washington, DC' LIMIT 16"}
{"sql":"SELECT FlightNum, Origin, \"Month\" FROM mytable ORDER BY ArrDel15, CancellationCode LIMIT 10","hsqls":["SELECT FlightNum, Origin, `Month` FROM mytable ORDER BY ArrDel15, CancellationCode LIMIT 10"]}
{"sql":"SELECT DivAirportSeqIDs, Cancelled, DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups < 0 AND DepTimeBlk NOT IN ('1600-1659', '1700-1759', '1100-1159', '1900-1959') AND DaysSinceEpoch >= 16087 ORDER BY WheelsOff, DestState, ActualElapsedTime LIMIT 17","hsqls":["SELECT DivAirportSeqIDs, Cancelled, DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups < 0 AND DepTimeBlk NOT IN ('1600-1659', '1700-1759', '1100-1159', '1900-1959') AND DaysSinceEpoch >= 16087 ORDER BY WheelsOff, DestState, ActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT Origin, DestCityMarketID, MAX(ArrDelay) FROM mytable WHERE DepDelay BETWEEN 39.0 AND 51.0 AND ArrivalDelayGroups NOT IN (2, -9999) GROUP BY Origin, DestCityMarketID  ORDER BY Origin, DestCityMarketID LIMIT 16","hsqls":["SELECT Origin, DestCityMarketID, MAX(ArrDelay) FROM mytable WHERE DepDelay BETWEEN 39.0 AND 51.0 AND ArrivalDelayGroups NOT IN (2, -9999) GROUP BY Origin, DestCityMarketID  ORDER BY Origin, DestCityMarketID LIMIT 16"]}
{"sql":"SELECT CRSDepTime, MAX(DistanceGroup), AVG(FlightNum), SUM(ArrTime) FROM mytable WHERE CRSArrTime NOT IN (1251, 1323) OR AirlineID BETWEEN 20398 AND 19393 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 25","hsqls":["SELECT CRSDepTime, MAX(DistanceGroup), AVG(FlightNum), SUM(ArrTime) FROM mytable WHERE CRSArrTime NOT IN (1251, 1323) OR AirlineID BETWEEN 20398 AND 19393 GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 25"]}
{"sql":"SELECT CancellationCode FROM mytable WHERE Cancelled < 0 ORDER BY CRSArrTime, ActualElapsedTime, OriginAirportID LIMIT 13"}
{"sql":"SELECT DestStateFips, TotalAddGTime, \"Month\", COUNT(TaxiOut), COUNT(DestStateName), MIN(FirstDepTime) FROM mytable GROUP BY DestStateFips, TotalAddGTime, \"Month\" LIMIT 9","hsqls":["SELECT DestStateFips, TotalAddGTime, Month, COUNT(TaxiOut), COUNT(DestStateName), MIN(FirstDepTime) FROM mytable GROUP BY DestStateFips, TotalAddGTime, `Month` LIMIT 9"]}
{"sql":"SELECT DestState, COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 237 AND 265 GROUP BY DestState  ORDER BY DestState LIMIT 23","hsqls":["SELECT DestState, COUNT(*) FROM mytable WHERE ActualElapsedTime BETWEEN 237 AND 265 GROUP BY DestState  ORDER BY DestState LIMIT 23"]}
{"sql":"SELECT DepTimeBlk, AVG(DivDistance), COUNT(AirTime) FROM mytable GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 18","hsqls":["SELECT DepTimeBlk, AVG(DivDistance), COUNT(AirTime) FROM mytable GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 18"]}
{"sql":"SELECT Dest, UniqueCarrier, DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups IN (10, 12) AND DivAirportLandings BETWEEN 9 AND 1 AND TaxiOut <> 83 ORDER BY \"Month\" LIMIT 16","hsqls":["SELECT Dest, UniqueCarrier, DaysSinceEpoch FROM mytable WHERE DepartureDelayGroups IN (10, 12) AND DivAirportLandings BETWEEN 9 AND 1 AND TaxiOut <> 83 ORDER BY `Month` LIMIT 16"]}
{"sql":"SELECT AirTime, MIN(DepartureDelayGroups), SUM(OriginCityMarketID), AVG(OriginStateFips) FROM mytable WHERE CancellationCode <> 'C' AND DestState < 'IN' OR ArrTimeBlk <> '1300-1359' GROUP BY AirTime  ORDER BY AirTime LIMIT 23","hsqls":["SELECT AirTime, MIN(DepartureDelayGroups), SUM(OriginCityMarketID), AVG(OriginStateFips) FROM mytable WHERE CancellationCode <> 'C' AND DestState < 'IN' OR ArrTimeBlk <> '1300-1359' GROUP BY AirTime  ORDER BY AirTime LIMIT 23"]}
{"sql":"SELECT \"Year\", OriginCityMarketID, Dest FROM mytable ORDER BY FirstDepTime, OriginWac, AirTime LIMIT 24","hsqls":["SELECT Year, OriginCityMarketID, Dest FROM mytable ORDER BY FirstDepTime, OriginWac, AirTime LIMIT 24"]}
{"sql":"SELECT DivReachedDest, Carrier, OriginStateName, COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 45.0 AND 110.0 OR CRSArrTime IN (1235, 2149, 2201) AND DivAirports IN ('IAH', 'SMF') GROUP BY DivReachedDest, Carrier, OriginStateName","hsqls":["SELECT DivReachedDest, Carrier, OriginStateName, COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 45.0 AND 110.0 OR CRSArrTime IN (1235, 2149, 2201) AND (DivAirports[1] IN ('IAH', 'SMF') OR DivAirports[2] IN ('IAH', 'SMF') OR DivAirports[3] IN ('IAH', 'SMF') OR DivAirports[4] IN ('IAH', 'SMF') OR DivAirports[5] IN ('IAH', 'SMF')) GROUP BY DivReachedDest, Carrier, OriginStateName LIMIT 10000"]}
{"sql":"SELECT AVG(Diverted), MIN(Distance) FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 AND DivAirportLandings IN (2, 1, 0, 9) LIMIT 23","hsqls":["SELECT AVG(Diverted), MIN(Distance) FROM mytable WHERE `Month` BETWEEN 1 AND 1 AND DivAirportLandings IN (2, 1, 0, 9) LIMIT 23"]}
{"sql":"SELECT LateAircraftDelay, Origin, COUNT(*) FROM mytable GROUP BY LateAircraftDelay, Origin","hsqls":["SELECT LateAircraftDelay, Origin, COUNT(*) FROM mytable GROUP BY LateAircraftDelay, Origin"]}
{"sql":"SELECT DepTimeBlk, AirTime, SUM(\"Year\") FROM mytable WHERE FlightDate BETWEEN '2014-01-26' AND '2014-01-06' OR TotalAddGTime NOT IN (103, 39) AND DestCityName NOT IN ('St. Louis, MO', 'Newark, NJ') GROUP BY DepTimeBlk, AirTime LIMIT 13","hsqls":["SELECT DepTimeBlk, AirTime, SUM(`Year`) FROM mytable WHERE FlightDate BETWEEN '2014-01-26' AND '2014-01-06' OR TotalAddGTime NOT IN (103, 39) AND DestCityName NOT IN ('St. Louis, MO', 'Newark, NJ') GROUP BY DepTimeBlk, AirTime LIMIT 13"]}
{"sql":"SELECT DivActualElapsedTime FROM mytable ORDER BY Carrier, ArrDelay, UniqueCarrier LIMIT 4"}
{"sql":"SELECT SUM(DivActualElapsedTime), MAX(\"Month\") FROM mytable WHERE Distance <> 788 AND DivWheelsOffs > 1851 LIMIT 5","hsqls":["SELECT SUM(DivActualElapsedTime), MAX(`Month`)  FROM mytable WHERE Distance <> 788 AND (DivWheelsOffs[1] > 1851 OR DivWheelsOffs[2] > 1851 OR DivWheelsOffs[3] > 1851 OR DivWheelsOffs[4] > 1851 OR DivWheelsOffs[5] > 1851) LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, AirTime FROM mytable LIMIT 3"}
{"sql":"SELECT Distance, DepTime, DepTimeBlk FROM mytable WHERE WheelsOn <> 1917 OR WheelsOn > 840 OR DivDistance IN (453, 289, 11) ORDER BY TaxiIn, TailNum LIMIT 17"}
{"sql":"SELECT DestAirportSeqID, NASDelay, AirTime FROM mytable ORDER BY ArrTimeBlk, DepTimeBlk LIMIT 9"}
{"sql":"SELECT TaxiOut, DepDelayMinutes FROM mytable WHERE OriginAirportID < 13422 AND CRSElapsedTime <> 19 LIMIT 28"}
{"sql":"SELECT TailNum, OriginWac, DayOfWeek, MAX(WheelsOff), SUM(CRSArrTime), MAX(TaxiIn) FROM mytable WHERE OriginWac NOT IN (45, 93, 23, 86) GROUP BY TailNum, OriginWac, DayOfWeek  ORDER BY TailNum, OriginWac, DayOfWeek LIMIT 28","hsqls":["SELECT TailNum, OriginWac, DayOfWeek, MAX(WheelsOff), SUM(CRSArrTime), MAX(TaxiIn) FROM mytable WHERE OriginWac NOT IN (45, 93, 23, 86) GROUP BY TailNum, OriginWac, DayOfWeek  ORDER BY TailNum, OriginWac, DayOfWeek LIMIT 28"]}
{"sql":"SELECT CRSArrTime, WheelsOn FROM mytable WHERE UniqueCarrier = 'WN' LIMIT 10"}
{"sql":"SELECT \"Year\", DepDel15, WheelsOn, COUNT(*) FROM mytable WHERE AirlineID <> 20398 AND OriginState BETWEEN 'OK' AND 'IA' AND DestAirportSeqID > 1199603 GROUP BY \"Year\", DepDel15, WheelsOn LIMIT 17","hsqls":["SELECT Year, DepDel15, WheelsOn, COUNT(*) FROM mytable WHERE AirlineID <> 20398 AND OriginState BETWEEN 'OK' AND 'IA' AND DestAirportSeqID > 1199603 GROUP BY Year, DepDel15, WheelsOn LIMIT 17"]}
{"sql":"SELECT OriginCityName, DepTimeBlk FROM mytable WHERE DestAirportID BETWEEN 11921 AND 12278 AND TaxiIn >= 52 ORDER BY Distance LIMIT 5"}
{"sql":"SELECT DestAirportSeqID FROM mytable WHERE OriginAirportSeqID >= 1530402 ORDER BY CarrierDelay, TailNum LIMIT 1"}
{"sql":"SELECT DayofMonth FROM mytable WHERE DivDistance NOT IN (80) ORDER BY Quarter, Dest LIMIT 14"}
{"sql":"SELECT OriginState, \"Month\", MAX(OriginAirportID), SUM(DestStateFips), AVG(DivAirportLandings) FROM mytable WHERE CarrierDelay IN (66, 153, 144, -9999) GROUP BY OriginState, \"Month\" LIMIT 28","hsqls":["SELECT OriginState, Month, MAX(OriginAirportID), SUM(DestStateFips), AVG(DivAirportLandings) FROM mytable WHERE CarrierDelay IN (66, 153, 144, -9999) GROUP BY OriginState, `Month` LIMIT 28"]}
{"sql":"SELECT TaxiIn, Cancelled FROM mytable WHERE DivAirportIDs BETWEEN 11721 AND 12915 OR DepartureDelayGroups IN (-2, 5, -9999) LIMIT 11","hsqls":["SELECT TaxiIn, Cancelled FROM mytable WHERE (DivAirportIDs[1] BETWEEN 11721 AND 12915 OR DivAirportIDs[2] BETWEEN 11721 AND 12915 OR DivAirportIDs[3] BETWEEN 11721 AND 12915 OR DivAirportIDs[4] BETWEEN 11721 AND 12915 OR DivAirportIDs[5] BETWEEN 11721 AND 12915) OR DepartureDelayGroups IN (-2, 5, -9999) LIMIT 10000"]}
{"sql":"SELECT DepDelayMinutes, DivArrDelay FROM mytable WHERE DayOfWeek BETWEEN 5 AND 1 ORDER BY DestStateName LIMIT 3"}
{"sql":"SELECT DivDistance FROM mytable WHERE DayOfWeek IN (2) OR DayOfWeek NOT IN (3, 1, 7, 6) OR CRSElapsedTime BETWEEN 288 AND 140 LIMIT 25"}
{"sql":"SELECT Origin, DivWheelsOffs, DestAirportID FROM mytable ORDER BY OriginAirportSeqID, FlightNum LIMIT 8","hsqls":["SELECT Origin, DivWheelsOffs, DestAirportID FROM mytable ORDER BY OriginAirportSeqID, FlightNum LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime, CRSDepTime FROM mytable WHERE CancellationCode >= 'noodles' LIMIT 7"}
{"sql":"SELECT Quarter, \"Month\", MAX(DaysSinceEpoch) FROM mytable WHERE WheelsOn BETWEEN 958 AND 1656 OR ActualElapsedTime < 223 GROUP BY Quarter, \"Month\" LIMIT 14","hsqls":["SELECT Quarter, Month, MAX(DaysSinceEpoch) FROM mytable WHERE WheelsOn BETWEEN 958 AND 1656 OR ActualElapsedTime < 223 GROUP BY Quarter, `Month` LIMIT 14"]}
{"sql":"SELECT DivLongestGTimes, SecurityDelay FROM mytable LIMIT 18","hsqls":["SELECT DivLongestGTimes, SecurityDelay FROM mytable LIMIT 10000"]}
{"sql":"SELECT AVG(CRSDepTime), MIN(DivReachedDest) FROM mytable WHERE \"Year\" = 2014 OR Origin BETWEEN 'MLU' AND 'BDL' OR DestStateFips > 18 LIMIT 22","hsqls":["SELECT AVG(CRSDepTime), MIN(DivReachedDest) FROM mytable WHERE `Year` = 2014 OR Origin BETWEEN 'MLU' AND 'BDL' OR DestStateFips > 18 LIMIT 22"]}
{"sql":"SELECT DepDel15, SUM(Flights), MIN(DivReachedDest) FROM mytable WHERE ArrivalDelayGroups BETWEEN 12 AND 9 AND Flights IN (1) OR DestCityName = 'Fort Lauderdale, FL' GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 8","hsqls":["SELECT DepDel15, SUM(Flights), MIN(DivReachedDest) FROM mytable WHERE ArrivalDelayGroups BETWEEN 12 AND 9 AND Flights IN (1) OR DestCityName = 'Fort Lauderdale, FL' GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 8"]}
{"sql":"SELECT TaxiIn FROM mytable WHERE OriginWac IN (92, 4, 22, 35, 33) ORDER BY LateAircraftDelay, FlightDate LIMIT 17"}
{"sql":"SELECT Distance, NASDelay, COUNT(FlightNum), AVG(DepDel15), COUNT(DivDistance) FROM mytable WHERE OriginAirportSeqID IN (1232303, 1252302, 1130802) GROUP BY Distance, NASDelay  ORDER BY Distance, NASDelay LIMIT 13","hsqls":["SELECT Distance, NASDelay, COUNT(FlightNum), AVG(DepDel15), COUNT(DivDistance) FROM mytable WHERE OriginAirportSeqID IN (1232303, 1252302, 1130802) GROUP BY Distance, NASDelay  ORDER BY Distance, NASDelay LIMIT 13"]}
{"sql":"SELECT Dest, DivTailNums FROM mytable ORDER BY CarrierDelay, DestCityName, DayofMonth LIMIT 10","hsqls":["SELECT Dest, DivTailNums FROM mytable ORDER BY CarrierDelay, DestCityName, DayofMonth LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, SUM(AirTime) FROM mytable GROUP BY DistanceGroup  ORDER BY DistanceGroup LIMIT 20","hsqls":["SELECT DistanceGroup, SUM(AirTime) FROM mytable GROUP BY DistanceGroup  ORDER BY DistanceGroup LIMIT 20"]}
{"sql":"SELECT MIN(DivDistance), MIN(OriginCityMarketID) FROM mytable LIMIT 10"}
{"sql":"SELECT AVG(Quarter) FROM mytable WHERE ArrDelayMinutes IN (180.0, 189.0, 153.0, 135.0) OR FlightNum NOT IN (16, 2203) AND DivAirportSeqIDs BETWEEN 1228002 AND 1481402 LIMIT 19","hsqls":["SELECT AVG(CAST(Quarter AS DOUBLE)) FROM mytable WHERE ArrDelayMinutes IN (180.0, 189.0, 153.0, 135.0) OR FlightNum NOT IN (16, 2203) AND (DivAirportSeqIDs[1] BETWEEN 1228002 AND 1481402 OR DivAirportSeqIDs[2] BETWEEN 1228002 AND 1481402 OR DivAirportSeqIDs[3] BETWEEN 1228002 AND 1481402 OR DivAirportSeqIDs[4] BETWEEN 1228002 AND 1481402 OR DivAirportSeqIDs[5] BETWEEN 1228002 AND 1481402) LIMIT 10000"]}
{"sql":"SELECT DivAirports, DayOfWeek FROM mytable WHERE OriginAirportID >= 15919 OR UniqueCarrier BETWEEN 'AS' AND 'B6' OR OriginAirportSeqID BETWEEN 1323202 AND 1448902 ORDER BY Quarter, Dest LIMIT 7","hsqls":["SELECT DivAirports, DayOfWeek FROM mytable WHERE OriginAirportID >= 15919 OR UniqueCarrier BETWEEN 'AS' AND 'B6' OR OriginAirportSeqID BETWEEN 1323202 AND 1448902 ORDER BY Quarter, Dest LIMIT 10000"]}
{"sql":"SELECT Origin, DestCityMarketID, CRSElapsedTime FROM mytable WHERE DepTime IN (1405, 534, 1417) AND DepDelay NOT IN (53.0, 81.0, 34.0, 117.0, -18.0) ORDER BY TotalAddGTime, ArrDel15, DestStateName LIMIT 10"}
{"sql":"SELECT DepDelayMinutes, TailNum, Origin, MAX(Flights), COUNT(AirlineID) FROM mytable GROUP BY DepDelayMinutes, TailNum, Origin  ORDER BY DepDelayMinutes, TailNum, Origin LIMIT 18","hsqls":["SELECT DepDelayMinutes, TailNum, Origin, MAX(Flights), COUNT(AirlineID) FROM mytable GROUP BY DepDelayMinutes, TailNum, Origin  ORDER BY DepDelayMinutes, TailNum, Origin LIMIT 18"]}
{"sql":"SELECT DestCityMarketID, MAX(OriginCityMarketID), SUM(DepDelayMinutes), COUNT(CRSElapsedTime) FROM mytable GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 22","hsqls":["SELECT DestCityMarketID, MAX(OriginCityMarketID), SUM(DepDelayMinutes), COUNT(CRSElapsedTime) FROM mytable GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 22"]}
{"sql":"SELECT CRSArrTime, OriginCityName, COUNT(*) FROM mytable GROUP BY CRSArrTime, OriginCityName  ORDER BY CRSArrTime, OriginCityName LIMIT 18","hsqls":["SELECT CRSArrTime, OriginCityName, COUNT(*) FROM mytable GROUP BY CRSArrTime, OriginCityName  ORDER BY CRSArrTime, OriginCityName LIMIT 18"]}
{"sql":"SELECT OriginState, DestWac, SUM(TotalAddGTime), COUNT(NASDelay), SUM(WheelsOff) FROM mytable GROUP BY OriginState, DestWac  ORDER BY OriginState, DestWac LIMIT 12","hsqls":["SELECT OriginState, DestWac, SUM(TotalAddGTime), COUNT(NASDelay), SUM(WheelsOff) FROM mytable GROUP BY OriginState, DestWac  ORDER BY OriginState, DestWac LIMIT 12"]}
{"sql":"SELECT LateAircraftDelay, FlightDate, DivArrDelay FROM mytable WHERE WheelsOn NOT IN (1526) OR DivWheelsOffs < 1144 ORDER BY ArrTimeBlk LIMIT 11","hsqls":["SELECT LateAircraftDelay, FlightDate, DivArrDelay FROM mytable WHERE WheelsOn NOT IN (1526) OR (DivWheelsOffs[1] < 1144 OR DivWheelsOffs[2] < 1144 OR DivWheelsOffs[3] < 1144 OR DivWheelsOffs[4] < 1144 OR DivWheelsOffs[5] < 1144) ORDER BY ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT Carrier, OriginWac FROM mytable WHERE ActualElapsedTime BETWEEN 396 AND 86 AND FirstDepTime = 857 ORDER BY AirlineID, DivArrDelay LIMIT 24"}
{"sql":"SELECT Diverted, SUM(AirTime), SUM(FlightNum) FROM mytable WHERE LateAircraftDelay IN (110, 158, 101) GROUP BY Diverted  ORDER BY Diverted LIMIT 17","hsqls":["SELECT Diverted, SUM(AirTime), SUM(FlightNum) FROM mytable WHERE LateAircraftDelay IN (110, 158, 101) GROUP BY Diverted  ORDER BY Diverted LIMIT 17"]}
{"sql":"SELECT DepDel15 FROM mytable WHERE ArrTimeBlk BETWEEN '0700-0759' AND '1900-1959' LIMIT 23"}
{"sql":"SELECT SUM(NASDelay), AVG(DivDistance), SUM(ActualElapsedTime) FROM mytable WHERE OriginStateName NOT IN ('Kentucky', 'South Dakota') OR DivWheelsOns <= 1038 AND DivDistance = 261","hsqls":["SELECT SUM(NASDelay), AVG(DivDistance), SUM(ActualElapsedTime)  FROM mytable WHERE OriginStateName NOT IN ('Kentucky', 'South Dakota') OR (DivWheelsOns[1] <= 1038 OR DivWheelsOns[2] <= 1038 OR DivWheelsOns[3] <= 1038 OR DivWheelsOns[4] <= 1038 OR DivWheelsOns[5] <= 1038) AND DivDistance = 261 LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, DaysSinceEpoch FROM mytable WHERE FlightDate < '2014-01-15' ORDER BY DestStateFips, WheelsOn LIMIT 11"}
{"sql":"SELECT Quarter, MAX(AirlineID), SUM(WheelsOff) FROM mytable WHERE NASDelay >= 57 AND AirTime > 115 GROUP BY Quarter  ORDER BY Quarter LIMIT 16","hsqls":["SELECT Quarter, MAX(AirlineID), SUM(WheelsOff) FROM mytable WHERE NASDelay >= 57 AND AirTime > 115 GROUP BY Quarter  ORDER BY Quarter LIMIT 16"]}
{"sql":"SELECT FirstDepTime, FlightDate, AVG(DestAirportID), AVG(LateAircraftDelay) FROM mytable WHERE Diverted < 0 OR DayofMonth = 12 GROUP BY FirstDepTime, FlightDate  ORDER BY FirstDepTime, FlightDate LIMIT 29","hsqls":["SELECT FirstDepTime, FlightDate, AVG(DestAirportID), AVG(LateAircraftDelay) FROM mytable WHERE Diverted < 0 OR DayofMonth = 12 GROUP BY FirstDepTime, FlightDate  ORDER BY FirstDepTime, FlightDate LIMIT 29"]}
{"sql":"SELECT TailNum, DivAirportLandings, DayOfWeek, COUNT(ArrivalDelayGroups), SUM(CRSElapsedTime), COUNT(DepartureDelayGroups) FROM mytable GROUP BY TailNum, DivAirportLandings, DayOfWeek  ORDER BY TailNum, DivAirportLandings, DayOfWeek LIMIT 23","hsqls":["SELECT TailNum, DivAirportLandings, DayOfWeek, COUNT(ArrivalDelayGroups), SUM(CRSElapsedTime), COUNT(DepartureDelayGroups) FROM mytable GROUP BY TailNum, DivAirportLandings, DayOfWeek  ORDER BY TailNum, DivAirportLandings, DayOfWeek LIMIT 23"]}
{"sql":"SELECT FlightNum, Distance FROM mytable WHERE OriginCityName IN ('Hayden, CO') OR OriginAirportSeqID < 1357702 ORDER BY OriginStateFips, Distance LIMIT 2"}
{"sql":"SELECT Quarter, COUNT(*) FROM mytable WHERE CarrierDelay < 56 GROUP BY Quarter  ORDER BY Quarter LIMIT 21","hsqls":["SELECT Quarter, COUNT(*) FROM mytable WHERE CarrierDelay < 56 GROUP BY Quarter  ORDER BY Quarter LIMIT 21"]}
{"sql":"SELECT ArrDelayMinutes, ArrTime FROM mytable ORDER BY TaxiOut, ArrDel15, DayofMonth LIMIT 17"}
{"sql":"SELECT DepartureDelayGroups, COUNT(*) FROM mytable GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 24","hsqls":["SELECT DepartureDelayGroups, COUNT(*) FROM mytable GROUP BY DepartureDelayGroups  ORDER BY DepartureDelayGroups LIMIT 24"]}
{"sql":"SELECT DivAirportIDs, ArrDelay, CRSElapsedTime FROM mytable WHERE DivTailNums IN ('N638MQ') ORDER BY CancellationCode LIMIT 22","hsqls":["SELECT DivAirportIDs, ArrDelay, CRSElapsedTime FROM mytable WHERE (DivTailNums[1] IN ('N638MQ') OR DivTailNums[2] IN ('N638MQ') OR DivTailNums[3] IN ('N638MQ') OR DivTailNums[4] IN ('N638MQ') OR DivTailNums[5] IN ('N638MQ')) ORDER BY CancellationCode LIMIT 10000"]}
{"sql":"SELECT COUNT(TaxiIn), COUNT(ArrTimeBlk), AVG(DestWac) FROM mytable WHERE DayOfWeek IN (3, 4) LIMIT 26"}
{"sql":"SELECT UniqueCarrier FROM mytable WHERE DestStateFips IN (2, 6, 55, 75) ORDER BY DistanceGroup, SecurityDelay, TailNum LIMIT 21"}
{"sql":"SELECT OriginState, DivDistance, DestStateName, MIN(DivArrDelay), MAX(FlightNum) FROM mytable WHERE CarrierDelay = 86 AND DivAirportLandings BETWEEN 0 AND 9 AND DestAirportID BETWEEN 13024 AND 13424 GROUP BY OriginState, DivDistance, DestStateName  ORDER BY OriginState, DivDistance, DestStateName LIMIT 9","hsqls":["SELECT OriginState, DivDistance, DestStateName, MIN(DivArrDelay), MAX(FlightNum) FROM mytable WHERE CarrierDelay = 86 AND DivAirportLandings BETWEEN 0 AND 9 AND DestAirportID BETWEEN 13024 AND 13424 GROUP BY OriginState, DivDistance, DestStateName  ORDER BY OriginState, DivDistance, DestStateName LIMIT 9"]}
{"sql":"SELECT OriginState, FlightNum, OriginStateName FROM mytable ORDER BY DistanceGroup, DepDelay LIMIT 8"}
{"sql":"SELECT FlightDate, OriginWac, DestAirportID, MAX(DayofMonth), COUNT(Distance) FROM mytable WHERE Dest BETWEEN 'SBA' AND 'HSV' OR Distance <> 1739 GROUP BY FlightDate, OriginWac, DestAirportID  ORDER BY FlightDate, OriginWac, DestAirportID LIMIT 14","hsqls":["SELECT FlightDate, OriginWac, DestAirportID, MAX(DayofMonth), COUNT(Distance) FROM mytable WHERE Dest BETWEEN 'SBA' AND 'HSV' OR Distance <> 1739 GROUP BY FlightDate, OriginWac, DestAirportID  ORDER BY FlightDate, OriginWac, DestAirportID LIMIT 14"]}
{"sql":"SELECT OriginAirportSeqID, OriginCityMarketID, UniqueCarrier FROM mytable WHERE FirstDepTime BETWEEN 710 AND 750 OR DivAirports = 'IAD' AND DivAirports BETWEEN 'MAF' AND 'YYC' ORDER BY AirTime LIMIT 29","hsqls":["SELECT OriginAirportSeqID, OriginCityMarketID, UniqueCarrier FROM mytable WHERE FirstDepTime BETWEEN 710 AND 750 OR (DivAirports[1] = 'IAD' OR DivAirports[2] = 'IAD' OR DivAirports[3] = 'IAD' OR DivAirports[4] = 'IAD' OR DivAirports[5] = 'IAD') AND (DivAirports[1] BETWEEN 'MAF' AND 'YYC' OR DivAirports[2] BETWEEN 'MAF' AND 'YYC' OR DivAirports[3] BETWEEN 'MAF' AND 'YYC' OR DivAirports[4] BETWEEN 'MAF' AND 'YYC' OR DivAirports[5] BETWEEN 'MAF' AND 'YYC') ORDER BY AirTime LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, DestCityName, AVG(\"Month\"), AVG(CRSElapsedTime) FROM mytable GROUP BY OriginCityMarketID, DestCityName LIMIT 12","hsqls":["SELECT OriginCityMarketID, DestCityName, AVG(`Month`), AVG(CRSElapsedTime) FROM mytable GROUP BY OriginCityMarketID, DestCityName LIMIT 12"]}
{"sql":"SELECT AVG(CRSDepTime) FROM mytable WHERE DepTimeBlk <= '0700-0759' OR Cancelled BETWEEN 0 AND 0 LIMIT 5"}
{"sql":"SELECT Quarter, DepTime, DestStateName FROM mytable WHERE Diverted > 1 ORDER BY DepTime LIMIT 21"}
{"sql":"SELECT SUM(ArrDelayMinutes), SUM(WheelsOn), COUNT(ArrTimeBlk) FROM mytable WHERE OriginCityMarketID IN (32467, 31721) OR TaxiIn NOT IN (116, 96, 44) AND OriginAirportSeqID BETWEEN 1295302 AND 1288403 LIMIT 19"}
{"sql":"SELECT TotalAddGTime, OriginCityName, DestCityMarketID, COUNT(*) FROM mytable WHERE AirlineID IN (20398, 20436, 20366, 19930, 20409) AND OriginAirportSeqID IN (1037203, 1186502, 1114002, 1295103) OR OriginAirportID BETWEEN 11298 AND 11865 GROUP BY TotalAddGTime, OriginCityName, DestCityMarketID  ORDER BY TotalAddGTime, OriginCityName, DestCityMarketID LIMIT 26","hsqls":["SELECT TotalAddGTime, OriginCityName, DestCityMarketID, COUNT(*) FROM mytable WHERE AirlineID IN (20398, 20436, 20366, 19930, 20409) AND OriginAirportSeqID IN (1037203, 1186502, 1114002, 1295103) OR OriginAirportID BETWEEN 11298 AND 11865 GROUP BY TotalAddGTime, OriginCityName, DestCityMarketID  ORDER BY TotalAddGTime, OriginCityName, DestCityMarketID LIMIT 26"]}
{"sql":"SELECT DestCityMarketID FROM mytable ORDER BY OriginStateName LIMIT 21"}
{"sql":"SELECT OriginStateName FROM mytable WHERE DepDelay NOT IN (2.0) AND TaxiIn NOT IN (6, 5, 64) AND DestStateName IN ('Texas', 'Tennessee') ORDER BY UniqueCarrier LIMIT 21"}
{"sql":"SELECT Carrier, MAX(DepTime), COUNT(DivActualElapsedTime) FROM mytable WHERE UniqueCarrier BETWEEN 'F9' AND 'AS' GROUP BY Carrier  ORDER BY Carrier LIMIT 27","hsqls":["SELECT Carrier, MAX(DepTime), COUNT(DivActualElapsedTime) FROM mytable WHERE UniqueCarrier BETWEEN 'F9' AND 'AS' GROUP BY Carrier  ORDER BY Carrier LIMIT 27"]}
{"sql":"SELECT OriginCityMarketID, DestCityName, AVG(TotalAddGTime), MIN(\"Month\") FROM mytable WHERE CarrierDelay NOT IN (266) OR WeatherDelay >= 123 AND ArrivalDelayGroups NOT IN (0) GROUP BY OriginCityMarketID, DestCityName LIMIT 7","hsqls":["SELECT OriginCityMarketID, DestCityName, AVG(TotalAddGTime), MIN(`Month`) FROM mytable WHERE CarrierDelay NOT IN (266) OR WeatherDelay >= 123 AND ArrivalDelayGroups NOT IN (0) GROUP BY OriginCityMarketID, DestCityName LIMIT 7"]}
{"sql":"SELECT Carrier, CarrierDelay, WheelsOn FROM mytable ORDER BY CarrierDelay, ArrivalDelayGroups LIMIT 10"}
{"sql":"SELECT DivWheelsOffs FROM mytable ORDER BY WheelsOff, ArrTime, DestCityName LIMIT 7","hsqls":["SELECT DivWheelsOffs FROM mytable ORDER BY WheelsOff, ArrTime, DestCityName LIMIT 10000"]}
{"sql":"SELECT DestStateFips, Origin FROM mytable WHERE ArrTime >= 1512 AND DepDelayMinutes >= 137.0 OR \"Year\" BETWEEN 2014 AND 2014 LIMIT 3","hsqls":["SELECT DestStateFips, Origin FROM mytable WHERE ArrTime >= 1512 AND DepDelayMinutes >= 137.0 OR `Year` BETWEEN 2014 AND 2014 LIMIT 3"]}
{"sql":"SELECT ArrTime, DivAirportLandings FROM mytable WHERE DepTime <> 2220 OR DepDel15 >= 1 ORDER BY LateAircraftDelay, ArrDelay LIMIT 27"}
{"sql":"SELECT ActualElapsedTime, MAX(DepDel15) FROM mytable WHERE TaxiIn NOT IN (40, 52, 102) GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 9","hsqls":["SELECT ActualElapsedTime, MAX(DepDel15) FROM mytable WHERE TaxiIn NOT IN (40, 52, 102) GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 9"]}
{"sql":"SELECT DistanceGroup FROM mytable WHERE DepDel15 BETWEEN -9999 AND 1 AND CRSDepTime BETWEEN 1838 AND 1519 AND CRSElapsedTime BETWEEN 295 AND 353 ORDER BY DepDelayMinutes, TotalAddGTime LIMIT 3"}
{"sql":"SELECT OriginAirportSeqID, DivAirports FROM mytable ORDER BY OriginStateFips, CRSArrTime LIMIT 9","hsqls":["SELECT OriginAirportSeqID, DivAirports FROM mytable ORDER BY OriginStateFips, CRSArrTime LIMIT 10000"]}
{"sql":"SELECT MAX(OriginWac) FROM mytable LIMIT 26"}
{"sql":"SELECT TotalAddGTime, UniqueCarrier FROM mytable ORDER BY DestWac, DestState, FlightNum LIMIT 7"}
{"sql":"SELECT AVG(LongestAddGTime), MIN(WheelsOn), MAX(Cancelled) FROM mytable LIMIT 11"}
{"sql":"SELECT DestCityName, OriginWac FROM mytable WHERE Diverted BETWEEN 0 AND 0 OR DivWheelsOns = 1322 OR Dest BETWEEN 'CWA' AND 'GUC' LIMIT 13","hsqls":["SELECT DestCityName, OriginWac FROM mytable WHERE Diverted BETWEEN 0 AND 0 OR (DivWheelsOns[1] = 1322 OR DivWheelsOns[2] = 1322 OR DivWheelsOns[3] = 1322 OR DivWheelsOns[4] = 1322 OR DivWheelsOns[5] = 1322) OR Dest BETWEEN 'CWA' AND 'GUC' LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, DestAirportSeqID, AirTime FROM mytable ORDER BY CRSElapsedTime LIMIT 11"}
{"sql":"SELECT DivLongestGTimes, DestCityMarketID, WheelsOn FROM mytable ORDER BY TaxiIn, WheelsOn LIMIT 20","hsqls":["SELECT DivLongestGTimes, DestCityMarketID, WheelsOn FROM mytable ORDER BY TaxiIn, WheelsOn LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime FROM mytable LIMIT 8"}
{"sql":"SELECT Quarter, MAX(DestAirportSeqID) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 27","hsqls":["SELECT Quarter, MAX(DestAirportSeqID) FROM mytable GROUP BY Quarter  ORDER BY Quarter LIMIT 27"]}
{"sql":"SELECT ArrDel15, OriginAirportID FROM mytable WHERE DivAirports IN ('SWF') AND DivTotalGTimes IN (2, 128, 6) ORDER BY DepDelayMinutes, CancellationCode, OriginStateName LIMIT 27","hsqls":["SELECT ArrDel15, OriginAirportID FROM mytable WHERE (DivAirports[1] IN ('SWF') OR DivAirports[2] IN ('SWF') OR DivAirports[3] IN ('SWF') OR DivAirports[4] IN ('SWF') OR DivAirports[5] IN ('SWF')) AND (DivTotalGTimes[1] IN (2, 128, 6) OR DivTotalGTimes[2] IN (2, 128, 6) OR DivTotalGTimes[3] IN (2, 128, 6) OR DivTotalGTimes[4] IN (2, 128, 6) OR DivTotalGTimes[5] IN (2, 128, 6)) ORDER BY DepDelayMinutes, CancellationCode, OriginStateName LIMIT 10000"]}
{"sql":"SELECT DepDel15, UniqueCarrier, CRSElapsedTime FROM mytable WHERE DayofMonth NOT IN (19, 22, 25, 29, 12) AND DivReachedDest BETWEEN -9999 AND 0 OR OriginAirportSeqID IN (1469605, 1240203) LIMIT 29"}
{"sql":"SELECT SUM(OriginStateFips) FROM mytable WHERE ArrTime > 858 LIMIT 27"}
{"sql":"SELECT FlightNum, CRSArrTime, DestStateFips FROM mytable WHERE DivAirportIDs IN (13871, 11996) ORDER BY DestState, DepDelayMinutes LIMIT 5","hsqls":["SELECT FlightNum, CRSArrTime, DestStateFips FROM mytable WHERE (DivAirportIDs[1] IN (13871, 11996) OR DivAirportIDs[2] IN (13871, 11996) OR DivAirportIDs[3] IN (13871, 11996) OR DivAirportIDs[4] IN (13871, 11996) OR DivAirportIDs[5] IN (13871, 11996)) ORDER BY DestState, DepDelayMinutes LIMIT 10000"]}
{"sql":"SELECT DivWheelsOns, \"Year\", DestStateName FROM mytable WHERE OriginCityMarketID < 33388 AND LongestAddGTime BETWEEN 2 AND 19 ORDER BY DepDelay, DepTime LIMIT 28","hsqls":["SELECT DivWheelsOns, Year, DestStateName FROM mytable WHERE OriginCityMarketID < 33388 AND LongestAddGTime BETWEEN 2 AND 19 ORDER BY DepDelay, DepTime LIMIT 10000"]}
{"sql":"SELECT Flights, TaxiIn FROM mytable WHERE ActualElapsedTime BETWEEN 149 AND 423 LIMIT 13"}
{"sql":"SELECT COUNT(Diverted), MIN(Cancelled) FROM mytable WHERE CRSArrTime NOT IN (725, 715, 1649, 1736, 1240) LIMIT 10"}
{"sql":"SELECT Carrier FROM mytable ORDER BY LateAircraftDelay, LongestAddGTime LIMIT 27"}
{"sql":"SELECT Cancelled, DestCityName, DaysSinceEpoch, COUNT(*) FROM mytable WHERE DayOfWeek IN (1, 6, 4) OR DestState >= 'WV' OR DestStateFips <= 54 GROUP BY Cancelled, DestCityName, DaysSinceEpoch  ORDER BY Cancelled, DestCityName, DaysSinceEpoch LIMIT 14","hsqls":["SELECT Cancelled, DestCityName, DaysSinceEpoch, COUNT(*) FROM mytable WHERE DayOfWeek IN (1, 6, 4) OR DestState >= 'WV' OR DestStateFips <= 54 GROUP BY Cancelled, DestCityName, DaysSinceEpoch  ORDER BY Cancelled, DestCityName, DaysSinceEpoch LIMIT 14"]}
{"sql":"SELECT OriginCityName, \"Month\" FROM mytable ORDER BY DepDelay LIMIT 1","hsqls":["SELECT OriginCityName, `Month` FROM mytable ORDER BY DepDelay LIMIT 1"]}
{"sql":"SELECT DepDelayMinutes FROM mytable ORDER BY WeatherDelay, OriginCityMarketID, DepTimeBlk LIMIT 22"}
{"sql":"SELECT ActualElapsedTime, UniqueCarrier, DivActualElapsedTime, COUNT(ArrTime) FROM mytable WHERE DestAirportSeqID IN (1295402, 1125203, 1142303, 1073103) OR DepTime BETWEEN 2253 AND 1531 AND AirTime < 323 GROUP BY ActualElapsedTime, UniqueCarrier, DivActualElapsedTime  ORDER BY ActualElapsedTime, UniqueCarrier, DivActualElapsedTime LIMIT 10","hsqls":["SELECT ActualElapsedTime, UniqueCarrier, DivActualElapsedTime, COUNT(ArrTime) FROM mytable WHERE DestAirportSeqID IN (1295402, 1125203, 1142303, 1073103) OR DepTime BETWEEN 2253 AND 1531 AND AirTime < 323 GROUP BY ActualElapsedTime, UniqueCarrier, DivActualElapsedTime  ORDER BY ActualElapsedTime, UniqueCarrier, DivActualElapsedTime LIMIT 10"]}
{"sql":"SELECT MIN(Diverted), MAX(\"Month\") FROM mytable LIMIT 20","hsqls":["SELECT MIN(Diverted), MAX(`Month`) FROM mytable LIMIT 20"]}
{"sql":"SELECT SecurityDelay, DepTime, OriginWac FROM mytable ORDER BY OriginWac LIMIT 9"}
{"sql":"SELECT WeatherDelay, DepDelayMinutes, SUM(TotalAddGTime) FROM mytable WHERE CarrierDelay = 105 OR FlightNum NOT IN (3353) AND DivAirportIDs BETWEEN 14314 AND 14843 GROUP BY WeatherDelay, DepDelayMinutes LIMIT 8","hsqls":["SELECT WeatherDelay, DepDelayMinutes, SUM(TotalAddGTime) FROM mytable WHERE CarrierDelay = 105 OR FlightNum NOT IN (3353) AND (DivAirportIDs[1] BETWEEN 14314 AND 14843 OR DivAirportIDs[2] BETWEEN 14314 AND 14843 OR DivAirportIDs[3] BETWEEN 14314 AND 14843 OR DivAirportIDs[4] BETWEEN 14314 AND 14843 OR DivAirportIDs[5] BETWEEN 14314 AND 14843) GROUP BY WeatherDelay, DepDelayMinutes LIMIT 10000"]}
{"sql":"SELECT DivWheelsOffs, DivArrDelay FROM mytable WHERE WheelsOn = 636 OR DestAirportSeqID NOT IN (1129202, 1014602) OR FlightDate BETWEEN '2014-01-14' AND '2014-01-21' ORDER BY DestStateFips, DepTimeBlk, CRSElapsedTime LIMIT 4","hsqls":["SELECT DivWheelsOffs, DivArrDelay FROM mytable WHERE WheelsOn = 636 OR DestAirportSeqID NOT IN (1129202, 1014602) OR FlightDate BETWEEN '2014-01-14' AND '2014-01-21' ORDER BY DestStateFips, DepTimeBlk, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT SUM(TaxiOut) FROM mytable LIMIT 19"}
{"sql":"SELECT TotalAddGTime FROM mytable WHERE CRSElapsedTime <> 51 ORDER BY CancellationCode, UniqueCarrier LIMIT 10"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 21"}
{"sql":"SELECT DestWac, OriginCityName, ArrDel15 FROM mytable ORDER BY DestWac, DepDel15, \"Month\" LIMIT 14","hsqls":["SELECT DestWac, OriginCityName, ArrDel15 FROM mytable ORDER BY DestWac, DepDel15, `Month` LIMIT 14"]}
{"sql":"SELECT Quarter, CarrierDelay, DivAirportSeqIDs FROM mytable WHERE FirstDepTime = 710 AND Cancelled BETWEEN 1 AND 0 ORDER BY DestState, DivArrDelay LIMIT 23","hsqls":["SELECT Quarter, CarrierDelay, DivAirportSeqIDs FROM mytable WHERE FirstDepTime = 710 AND Cancelled BETWEEN 1 AND 0 ORDER BY DestState, DivArrDelay LIMIT 10000"]}
{"sql":"SELECT DivArrDelay, MIN(AirTime) FROM mytable GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 24","hsqls":["SELECT DivArrDelay, MIN(AirTime) FROM mytable GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 24"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Dest BETWEEN 'CAK' AND 'JAN' AND Origin BETWEEN 'MBS' AND 'GGG' OR FlightNum <= 1073 LIMIT 29"}
{"sql":"SELECT Dest, DepTimeBlk FROM mytable WHERE DivTailNums = 'N606SK' ORDER BY DistanceGroup LIMIT 14","hsqls":["SELECT Dest, DepTimeBlk FROM mytable WHERE (DivTailNums[1] = 'N606SK' OR DivTailNums[2] = 'N606SK' OR DivTailNums[3] = 'N606SK' OR DivTailNums[4] = 'N606SK' OR DivTailNums[5] = 'N606SK') ORDER BY DistanceGroup LIMIT 10000"]}
{"sql":"SELECT DivDistance, SUM(CRSDepTime), COUNT(AirlineID) FROM mytable WHERE DestStateName NOT IN ('New Hampshire', 'Louisiana', 'Tennessee', 'Georgia') OR Diverted BETWEEN 0 AND 0 OR DepTimeBlk NOT IN ('2000-2059', '1700-1759', '0800-0859', '1400-1459') GROUP BY DivDistance  ORDER BY DivDistance LIMIT 20","hsqls":["SELECT DivDistance, SUM(CRSDepTime), COUNT(AirlineID) FROM mytable WHERE DestStateName NOT IN ('New Hampshire', 'Louisiana', 'Tennessee', 'Georgia') OR Diverted BETWEEN 0 AND 0 OR DepTimeBlk NOT IN ('2000-2059', '1700-1759', '0800-0859', '1400-1459') GROUP BY DivDistance  ORDER BY DivDistance LIMIT 20"]}
{"sql":"SELECT AVG(ArrTime), SUM(Cancelled) FROM mytable WHERE DistanceGroup <> 11"}
{"sql":"SELECT Distance, COUNT(*) FROM mytable WHERE DepDel15 BETWEEN 0 AND 1 OR DistanceGroup NOT IN (6, 9, 8) GROUP BY Distance  ORDER BY Distance LIMIT 29","hsqls":["SELECT Distance, COUNT(*) FROM mytable WHERE DepDel15 BETWEEN 0 AND 1 OR DistanceGroup NOT IN (6, 9, 8) GROUP BY Distance  ORDER BY Distance LIMIT 29"]}
{"sql":"SELECT Diverted, CancellationCode FROM mytable ORDER BY ArrDelayMinutes"}
{"sql":"SELECT OriginState, TotalAddGTime FROM mytable WHERE FirstDepTime NOT IN (2041, 1745, 1043, -9999) ORDER BY TaxiIn, DestAirportID, DivArrDelay LIMIT 24"}
{"sql":"SELECT OriginState, CarrierDelay, DestCityMarketID, COUNT(\"Month\"), MIN(CRSElapsedTime), MAX(OriginStateFips) FROM mytable WHERE FlightNum IN (1233, 5064, 6078, 307, 1795) OR Diverted IN (1, 0) AND Cancelled >= 0 GROUP BY OriginState, CarrierDelay, DestCityMarketID LIMIT 28","hsqls":["SELECT OriginState, CarrierDelay, DestCityMarketID, COUNT(`Month`), MIN(CRSElapsedTime), MAX(OriginStateFips) FROM mytable WHERE FlightNum IN (1233, 5064, 6078, 307, 1795) OR Diverted IN (1, 0) AND Cancelled >= 0 GROUP BY OriginState, CarrierDelay, DestCityMarketID LIMIT 28"]}
{"sql":"SELECT AirTime, AVG(\"Month\"), MAX(CarrierDelay), MAX(NASDelay) FROM mytable WHERE Origin = 'ISP' OR Diverted > 1 OR DayofMonth IN (31, 25) GROUP BY AirTime LIMIT 27","hsqls":["SELECT AirTime, AVG(`Month`), MAX(CarrierDelay), MAX(NASDelay) FROM mytable WHERE Origin = 'ISP' OR Diverted > 1 OR DayofMonth IN (31, 25) GROUP BY AirTime LIMIT 27"]}
{"sql":"SELECT DivReachedDest, OriginCityMarketID FROM mytable WHERE Diverted > 0 ORDER BY WheelsOff, DestWac LIMIT 8"}
{"sql":"SELECT CarrierDelay, DepTimeBlk, MAX(\"Year\"), MIN(NASDelay) FROM mytable GROUP BY CarrierDelay, DepTimeBlk LIMIT 7","hsqls":["SELECT CarrierDelay, DepTimeBlk, MAX(`Year`), MIN(NASDelay) FROM mytable GROUP BY CarrierDelay, DepTimeBlk LIMIT 7"]}
{"sql":"SELECT AVG(CarrierDelay) FROM mytable WHERE DestState IN ('OR', 'VA', 'WV', 'NY') AND DepTimeBlk NOT IN ('1700-1759', '1000-1059', '0700-0759', '1500-1559') LIMIT 22"}
{"sql":"SELECT FlightDate, Cancelled, MAX(OriginStateFips), AVG(DivAirportLandings) FROM mytable WHERE Origin <= 'MSO' AND DestAirportID BETWEEN 12819 AND 12523 GROUP BY FlightDate, Cancelled  ORDER BY FlightDate, Cancelled LIMIT 14","hsqls":["SELECT FlightDate, Cancelled, MAX(OriginStateFips), AVG(DivAirportLandings) FROM mytable WHERE Origin <= 'MSO' AND DestAirportID BETWEEN 12819 AND 12523 GROUP BY FlightDate, Cancelled  ORDER BY FlightDate, Cancelled LIMIT 14"]}
{"sql":"SELECT Origin, AirlineID, SUM(AirTime), COUNT(DaysSinceEpoch), COUNT(WeatherDelay) FROM mytable WHERE OriginState BETWEEN 'MS' AND 'PR' GROUP BY Origin, AirlineID  ORDER BY Origin, AirlineID LIMIT 26","hsqls":["SELECT Origin, AirlineID, SUM(AirTime), COUNT(DaysSinceEpoch), COUNT(WeatherDelay) FROM mytable WHERE OriginState BETWEEN 'MS' AND 'PR' GROUP BY Origin, AirlineID  ORDER BY Origin, AirlineID LIMIT 26"]}
{"sql":"SELECT LateAircraftDelay, DivArrDelay, COUNT(*) FROM mytable WHERE OriginState BETWEEN 'CT' AND 'MI' GROUP BY LateAircraftDelay, DivArrDelay  ORDER BY LateAircraftDelay, DivArrDelay LIMIT 27","hsqls":["SELECT LateAircraftDelay, DivArrDelay, COUNT(*) FROM mytable WHERE OriginState BETWEEN 'CT' AND 'MI' GROUP BY LateAircraftDelay, DivArrDelay  ORDER BY LateAircraftDelay, DivArrDelay LIMIT 27"]}
{"sql":"SELECT Cancelled, UniqueCarrier FROM mytable WHERE ArrivalDelayGroups NOT IN (-1, -9999) AND DivLongestGTimes BETWEEN 116.0 AND 15.0 ORDER BY LateAircraftDelay, ArrTimeBlk LIMIT 7","hsqls":["SELECT Cancelled, UniqueCarrier FROM mytable WHERE ArrivalDelayGroups NOT IN (-1, -9999) AND (DivLongestGTimes[1] BETWEEN 116.0 AND 15.0 OR DivLongestGTimes[2] BETWEEN 116.0 AND 15.0 OR DivLongestGTimes[3] BETWEEN 116.0 AND 15.0 OR DivLongestGTimes[4] BETWEEN 116.0 AND 15.0 OR DivLongestGTimes[5] BETWEEN 116.0 AND 15.0) ORDER BY LateAircraftDelay, ArrTimeBlk LIMIT 10000"]}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DayofMonth < 1 OR Diverted NOT IN (1, 0) ORDER BY ArrTime, AirTime, \"Month\" LIMIT 17","hsqls":["SELECT CRSArrTime FROM mytable WHERE DayofMonth < 1 OR Diverted NOT IN (1, 0) ORDER BY ArrTime, AirTime, `Month` LIMIT 17"]}
{"sql":"SELECT OriginState, WheelsOn, MIN(DestStateFips) FROM mytable WHERE CRSDepTime BETWEEN 1554 AND 1342 GROUP BY OriginState, WheelsOn  ORDER BY OriginState, WheelsOn LIMIT 9","hsqls":["SELECT OriginState, WheelsOn, MIN(DestStateFips) FROM mytable WHERE CRSDepTime BETWEEN 1554 AND 1342 GROUP BY OriginState, WheelsOn  ORDER BY OriginState, WheelsOn LIMIT 9"]}
{"sql":"SELECT DestStateName, MIN(ActualElapsedTime) FROM mytable WHERE Distance IN (2586, 139, 1749, 742, 667) OR CRSArrTime BETWEEN 1043 AND 1753 GROUP BY DestStateName","hsqls":["SELECT DestStateName, MIN(ActualElapsedTime) FROM mytable WHERE Distance IN (2586, 139, 1749, 742, 667) OR CRSArrTime BETWEEN 1043 AND 1753 GROUP BY DestStateName"]}
{"sql":"SELECT DivWheelsOns, LateAircraftDelay, DivAirportIDs FROM mytable WHERE TotalAddGTime < 111 ORDER BY Origin LIMIT 18","hsqls":["SELECT DivWheelsOns, LateAircraftDelay, DivAirportIDs FROM mytable WHERE TotalAddGTime < 111 ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT DestCityName, AVG(Quarter), MIN(Distance) FROM mytable GROUP BY DestCityName  ORDER BY DestCityName LIMIT 21","hsqls":["SELECT DestCityName, AVG(Quarter), MIN(Distance) FROM mytable GROUP BY DestCityName  ORDER BY DestCityName LIMIT 21"]}
{"sql":"SELECT Diverted, DepDel15 FROM mytable LIMIT 10"}
{"sql":"SELECT TaxiOut, DayofMonth, MIN(DistanceGroup), AVG(Flights), SUM(DivDistance) FROM mytable WHERE SecurityDelay BETWEEN 8 AND -9999 GROUP BY TaxiOut, DayofMonth  ORDER BY TaxiOut, DayofMonth LIMIT 29","hsqls":["SELECT TaxiOut, DayofMonth, MIN(DistanceGroup), AVG(Flights), SUM(DivDistance) FROM mytable WHERE SecurityDelay BETWEEN 8 AND -9999 GROUP BY TaxiOut, DayofMonth  ORDER BY TaxiOut, DayofMonth LIMIT 29"]}
{"sql":"SELECT DivLongestGTimes, TotalAddGTime FROM mytable LIMIT 5","hsqls":["SELECT DivLongestGTimes, TotalAddGTime FROM mytable LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DivTailNums FROM mytable WHERE FlightDate NOT IN ('2014-01-29', '2014-01-28', '2014-01-21', '2014-01-07', '2014-01-10') AND TailNum IN ('N547JB') AND UniqueCarrier <> 'AS' ORDER BY Diverted LIMIT 14","hsqls":["SELECT OriginAirportSeqID, DivTailNums FROM mytable WHERE FlightDate NOT IN ('2014-01-29', '2014-01-28', '2014-01-21', '2014-01-07', '2014-01-10') AND TailNum IN ('N547JB') AND UniqueCarrier <> 'AS' ORDER BY Diverted LIMIT 10000"]}
{"sql":"SELECT DestStateFips FROM mytable ORDER BY SecurityDelay, ArrDel15, DepTimeBlk LIMIT 22"}
{"sql":"SELECT LateAircraftDelay, SecurityDelay, DivTotalGTimes FROM mytable WHERE OriginCityMarketID <> 33495 OR DivArrDelay NOT IN (91) AND DepDel15 NOT IN (0, -9999) ORDER BY DepartureDelayGroups, DivReachedDest, Flights LIMIT 4","hsqls":["SELECT LateAircraftDelay, SecurityDelay, DivTotalGTimes FROM mytable WHERE OriginCityMarketID <> 33495 OR DivArrDelay NOT IN (91) AND DepDel15 NOT IN (0, -9999) ORDER BY DepartureDelayGroups, DivReachedDest, Flights LIMIT 10000"]}
{"sql":"SELECT Quarter, TotalAddGTime, OriginAirportID FROM mytable WHERE DivAirportIDs BETWEEN 10821 AND 14100 ORDER BY OriginAirportSeqID, AirTime, DayofMonth LIMIT 16","hsqls":["SELECT Quarter, TotalAddGTime, OriginAirportID FROM mytable WHERE (DivAirportIDs[1] BETWEEN 10821 AND 14100 OR DivAirportIDs[2] BETWEEN 10821 AND 14100 OR DivAirportIDs[3] BETWEEN 10821 AND 14100 OR DivAirportIDs[4] BETWEEN 10821 AND 14100 OR DivAirportIDs[5] BETWEEN 10821 AND 14100) ORDER BY OriginAirportSeqID, AirTime, DayofMonth LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes FROM mytable WHERE DestCityMarketID BETWEEN 31726 AND 30627 OR Cancelled >= 0 ORDER BY TotalAddGTime, OriginCityName LIMIT 7","hsqls":["SELECT DivLongestGTimes FROM mytable WHERE DestCityMarketID BETWEEN 31726 AND 30627 OR Cancelled >= 0 ORDER BY TotalAddGTime, OriginCityName LIMIT 10000"]}
{"sql":"SELECT CRSElapsedTime FROM mytable WHERE OriginCityMarketID <= 31041 OR DivWheelsOffs IN (2046) AND WeatherDelay NOT IN (316, 234, 37) ORDER BY CRSArrTime, DivActualElapsedTime LIMIT 1","hsqls":["SELECT CRSElapsedTime FROM mytable WHERE OriginCityMarketID <= 31041 OR (DivWheelsOffs[1] IN (2046) OR DivWheelsOffs[2] IN (2046) OR DivWheelsOffs[3] IN (2046) OR DivWheelsOffs[4] IN (2046) OR DivWheelsOffs[5] IN (2046)) AND WeatherDelay NOT IN (316, 234, 37) ORDER BY CRSArrTime, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(OriginCityMarketID), MIN(SecurityDelay), MAX(DepTime) FROM mytable LIMIT 6"}
{"sql":"SELECT OriginAirportSeqID, UniqueCarrier, OriginStateName, MAX(WheelsOff) FROM mytable WHERE FirstDepTime <= 947 AND Distance IN (989, 610, 1276, 1062) AND DestAirportSeqID BETWEEN 1033302 AND 1295103 GROUP BY OriginAirportSeqID, UniqueCarrier, OriginStateName  ORDER BY OriginAirportSeqID, UniqueCarrier, OriginStateName LIMIT 24","hsqls":["SELECT OriginAirportSeqID, UniqueCarrier, OriginStateName, MAX(WheelsOff) FROM mytable WHERE FirstDepTime <= 947 AND Distance IN (989, 610, 1276, 1062) AND DestAirportSeqID BETWEEN 1033302 AND 1295103 GROUP BY OriginAirportSeqID, UniqueCarrier, OriginStateName  ORDER BY OriginAirportSeqID, UniqueCarrier, OriginStateName LIMIT 24"]}
{"sql":"SELECT DepDel15, CRSDepTime, MAX(ActualElapsedTime) FROM mytable WHERE DistanceGroup <= 9 AND OriginStateName BETWEEN 'Tennessee' AND 'Kansas' GROUP BY DepDel15, CRSDepTime  ORDER BY DepDel15, CRSDepTime LIMIT 22","hsqls":["SELECT DepDel15, CRSDepTime, MAX(ActualElapsedTime) FROM mytable WHERE DistanceGroup <= 9 AND OriginStateName BETWEEN 'Tennessee' AND 'Kansas' GROUP BY DepDel15, CRSDepTime  ORDER BY DepDel15, CRSDepTime LIMIT 22"]}
{"sql":"SELECT OriginAirportSeqID, TaxiIn, \"Month\", COUNT(ArrTime) FROM mytable WHERE DivArrDelay IN (852, 507, 201, 346, 292) GROUP BY OriginAirportSeqID, TaxiIn, \"Month\" LIMIT 28","hsqls":["SELECT OriginAirportSeqID, TaxiIn, Month, COUNT(ArrTime) FROM mytable WHERE DivArrDelay IN (852, 507, 201, 346, 292) GROUP BY OriginAirportSeqID, TaxiIn, `Month` LIMIT 28"]}
{"sql":"SELECT Flights, DestCityName, CRSElapsedTime, COUNT(DivDistance) FROM mytable GROUP BY Flights, DestCityName, CRSElapsedTime  ORDER BY Flights, DestCityName, CRSElapsedTime LIMIT 18","hsqls":["SELECT Flights, DestCityName, CRSElapsedTime, COUNT(DivDistance) FROM mytable GROUP BY Flights, DestCityName, CRSElapsedTime  ORDER BY Flights, DestCityName, CRSElapsedTime LIMIT 18"]}
{"sql":"SELECT NASDelay FROM mytable ORDER BY \"Month\" LIMIT 8","hsqls":["SELECT NASDelay FROM mytable ORDER BY `Month` LIMIT 8"]}
{"sql":"SELECT AirTime, DayofMonth, CancellationCode, COUNT(*) FROM mytable WHERE CancellationCode >= 'B' GROUP BY AirTime, DayofMonth, CancellationCode  ORDER BY AirTime, DayofMonth, CancellationCode LIMIT 18","hsqls":["SELECT AirTime, DayofMonth, CancellationCode, COUNT(*) FROM mytable WHERE CancellationCode >= 'B' GROUP BY AirTime, DayofMonth, CancellationCode  ORDER BY AirTime, DayofMonth, CancellationCode LIMIT 18"]}
{"sql":"SELECT Cancelled FROM mytable WHERE DivWheelsOffs BETWEEN 1125 AND 2040 AND Distance <= 1846 ORDER BY TaxiIn, DestCityName LIMIT 10","hsqls":["SELECT Cancelled FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1125 AND 2040 OR DivWheelsOffs[2] BETWEEN 1125 AND 2040 OR DivWheelsOffs[3] BETWEEN 1125 AND 2040 OR DivWheelsOffs[4] BETWEEN 1125 AND 2040 OR DivWheelsOffs[5] BETWEEN 1125 AND 2040) AND Distance <= 1846 ORDER BY TaxiIn, DestCityName LIMIT 10000"]}
{"sql":"SELECT TailNum, OriginStateName, SUM(CarrierDelay), MAX(DayofMonth) FROM mytable WHERE ArrTimeBlk > '1400-1459' GROUP BY TailNum, OriginStateName","hsqls":["SELECT TailNum, OriginStateName, SUM(CarrierDelay), MAX(DayofMonth) FROM mytable WHERE ArrTimeBlk > '1400-1459' GROUP BY TailNum, OriginStateName"]}
{"sql":"SELECT FirstDepTime, DestCityName, OriginWac, COUNT(*) FROM mytable WHERE DestAirportSeqID BETWEEN 1501603 AND 1295302 GROUP BY FirstDepTime, DestCityName, OriginWac  ORDER BY FirstDepTime, DestCityName, OriginWac LIMIT 29","hsqls":["SELECT FirstDepTime, DestCityName, OriginWac, COUNT(*) FROM mytable WHERE DestAirportSeqID BETWEEN 1501603 AND 1295302 GROUP BY FirstDepTime, DestCityName, OriginWac  ORDER BY FirstDepTime, DestCityName, OriginWac LIMIT 29"]}
{"sql":"SELECT TotalAddGTime FROM mytable WHERE ArrivalDelayGroups IN (1, 0, 4, 8, -9999) ORDER BY DivDistance, Quarter LIMIT 6"}
{"sql":"SELECT CarrierDelay FROM mytable WHERE FlightDate NOT IN ('2014-01-14', '2014-01-21', '2014-01-07') AND ActualElapsedTime IN (298, 111, 413) AND Diverted BETWEEN 0 AND 0 ORDER BY DestWac, DepTime LIMIT 23"}
{"sql":"SELECT AVG(ActualElapsedTime) FROM mytable LIMIT 23"}
{"sql":"SELECT DayofMonth, SUM(CRSArrTime), MIN(CRSElapsedTime) FROM mytable WHERE ArrDelay <> 364.0 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 2","hsqls":["SELECT DayofMonth, SUM(CRSArrTime), MIN(CRSElapsedTime) FROM mytable WHERE ArrDelay <> 364.0 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 2"]}
{"sql":"SELECT OriginStateFips, DestCityName, OriginAirportID, MIN(OriginAirportID) FROM mytable WHERE DistanceGroup <= 8 GROUP BY OriginStateFips, DestCityName, OriginAirportID  ORDER BY OriginStateFips, DestCityName, OriginAirportID LIMIT 12","hsqls":["SELECT OriginStateFips, DestCityName, OriginAirportID, MIN(OriginAirportID) FROM mytable WHERE DistanceGroup <= 8 GROUP BY OriginStateFips, DestCityName, OriginAirportID  ORDER BY OriginStateFips, DestCityName, OriginAirportID LIMIT 12"]}
{"sql":"SELECT MIN(DistanceGroup), AVG(DepTime), MIN(TaxiOut) FROM mytable WHERE ActualElapsedTime NOT IN (182, 370, 345, 603) LIMIT 19"}
{"sql":"SELECT OriginState, DestState, DestAirportID, COUNT(*) FROM mytable GROUP BY OriginState, DestState, DestAirportID  ORDER BY OriginState, DestState, DestAirportID LIMIT 19","hsqls":["SELECT OriginState, DestState, DestAirportID, COUNT(*) FROM mytable GROUP BY OriginState, DestState, DestAirportID  ORDER BY OriginState, DestState, DestAirportID LIMIT 19"]}
{"sql":"SELECT DivAirportLandings FROM mytable WHERE CRSDepTime IN (554) OR DivDistance IN (110, 159, 237) OR WheelsOn IN (228) ORDER BY \"Year\", Cancelled LIMIT 13","hsqls":["SELECT DivAirportLandings FROM mytable WHERE CRSDepTime IN (554) OR DivDistance IN (110, 159, 237) OR WheelsOn IN (228) ORDER BY Year, Cancelled LIMIT 13"]}
{"sql":"SELECT DepDelay, CarrierDelay FROM mytable WHERE DivAirportSeqIDs < 1415305 ORDER BY Diverted, OriginCityName, CancellationCode LIMIT 3","hsqls":["SELECT DepDelay, CarrierDelay FROM mytable WHERE (DivAirportSeqIDs[1] < 1415305 OR DivAirportSeqIDs[2] < 1415305 OR DivAirportSeqIDs[3] < 1415305 OR DivAirportSeqIDs[4] < 1415305 OR DivAirportSeqIDs[5] < 1415305) ORDER BY Diverted, OriginCityName, CancellationCode LIMIT 10000"]}
{"sql":"SELECT MAX(DestAirportID), AVG(CRSElapsedTime), MAX(DivActualElapsedTime) FROM mytable LIMIT 18"}
{"sql":"SELECT LongestAddGTime, COUNT(*) FROM mytable GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 21","hsqls":["SELECT LongestAddGTime, COUNT(*) FROM mytable GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 21"]}
{"sql":"SELECT LateAircraftDelay, DestStateName, CRSDepTime, COUNT(*) FROM mytable WHERE FirstDepTime NOT IN (1032, 1030, 639, 1940, 835) OR TotalAddGTime BETWEEN 15 AND 19 AND WheelsOn IN (1703, 2345) GROUP BY LateAircraftDelay, DestStateName, CRSDepTime  ORDER BY LateAircraftDelay, DestStateName, CRSDepTime LIMIT 10","hsqls":["SELECT LateAircraftDelay, DestStateName, CRSDepTime, COUNT(*) FROM mytable WHERE FirstDepTime NOT IN (1032, 1030, 639, 1940, 835) OR TotalAddGTime BETWEEN 15 AND 19 AND WheelsOn IN (1703, 2345) GROUP BY LateAircraftDelay, DestStateName, CRSDepTime  ORDER BY LateAircraftDelay, DestStateName, CRSDepTime LIMIT 10"]}
{"sql":"SELECT COUNT(Cancelled), COUNT(CarrierDelay), AVG(AirlineID) FROM mytable WHERE DestAirportID IN (10279, 14122) LIMIT 26"}
{"sql":"SELECT OriginStateFips, ArrTime, COUNT(*) FROM mytable WHERE ArrivalDelayGroups IN (8) GROUP BY OriginStateFips, ArrTime  ORDER BY OriginStateFips, ArrTime LIMIT 1","hsqls":["SELECT OriginStateFips, ArrTime, COUNT(*) FROM mytable WHERE ArrivalDelayGroups IN (8) GROUP BY OriginStateFips, ArrTime  ORDER BY OriginStateFips, ArrTime LIMIT 1"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 6"}
{"sql":"SELECT DestStateFips FROM mytable WHERE SecurityDelay NOT IN (10, 4, 18, 8) ORDER BY DivDistance, CRSElapsedTime LIMIT 1"}
{"sql":"SELECT DestWac, LongestAddGTime, OriginStateName, SUM(ArrDelay) FROM mytable WHERE FirstDepTime BETWEEN 631 AND -9999 OR ActualElapsedTime BETWEEN 39 AND 206 GROUP BY DestWac, LongestAddGTime, OriginStateName  ORDER BY DestWac, LongestAddGTime, OriginStateName LIMIT 6","hsqls":["SELECT DestWac, LongestAddGTime, OriginStateName, SUM(ArrDelay) FROM mytable WHERE FirstDepTime BETWEEN 631 AND -9999 OR ActualElapsedTime BETWEEN 39 AND 206 GROUP BY DestWac, LongestAddGTime, OriginStateName  ORDER BY DestWac, LongestAddGTime, OriginStateName LIMIT 6"]}
{"sql":"SELECT FirstDepTime, OriginStateFips, DestAirportSeqID, COUNT(DestAirportSeqID) FROM mytable GROUP BY FirstDepTime, OriginStateFips, DestAirportSeqID  ORDER BY FirstDepTime, OriginStateFips, DestAirportSeqID LIMIT 21","hsqls":["SELECT FirstDepTime, OriginStateFips, DestAirportSeqID, COUNT(DestAirportSeqID) FROM mytable GROUP BY FirstDepTime, OriginStateFips, DestAirportSeqID  ORDER BY FirstDepTime, OriginStateFips, DestAirportSeqID LIMIT 21"]}
{"sql":"SELECT FlightDate, DestStateFips, DestAirportID, MAX(AirlineID), AVG(DestAirportSeqID), MIN(ArrivalDelayGroups) FROM mytable WHERE Carrier >= 'EV' OR DistanceGroup NOT IN (3, 1, 10, 7, 8) AND FlightDate BETWEEN '2014-01-19' AND '2014-01-08' GROUP BY FlightDate, DestStateFips, DestAirportID  ORDER BY FlightDate, DestStateFips, DestAirportID LIMIT 10","hsqls":["SELECT FlightDate, DestStateFips, DestAirportID, MAX(AirlineID), AVG(DestAirportSeqID), MIN(ArrivalDelayGroups) FROM mytable WHERE Carrier >= 'EV' OR DistanceGroup NOT IN (3, 1, 10, 7, 8) AND FlightDate BETWEEN '2014-01-19' AND '2014-01-08' GROUP BY FlightDate, DestStateFips, DestAirportID  ORDER BY FlightDate, DestStateFips, DestAirportID LIMIT 10"]}
{"sql":"SELECT AirTime, OriginAirportID FROM mytable WHERE DivDistance BETWEEN 108 AND 24 OR AirTime NOT IN (363, 269, 285, 282) ORDER BY LateAircraftDelay, DaysSinceEpoch LIMIT 16"}
{"sql":"SELECT DestAirportSeqID, ArrivalDelayGroups FROM mytable WHERE OriginCityName IN ('Hibbing, MN', 'Hayden, CO', 'Hartford, CT', 'Dayton, OH') LIMIT 17"}
{"sql":"SELECT CRSElapsedTime FROM mytable WHERE NASDelay BETWEEN 56 AND 25 OR DepDel15 NOT IN (1, 0, -9999) LIMIT 1"}
{"sql":"SELECT \"Year\" FROM mytable WHERE WheelsOff IN (2030) AND DivActualElapsedTime BETWEEN 485 AND 336 OR Origin <= 'PHF' ORDER BY SecurityDelay LIMIT 3","hsqls":["SELECT `Year` FROM mytable WHERE WheelsOff IN (2030) AND DivActualElapsedTime BETWEEN 485 AND 336 OR Origin <= 'PHF' ORDER BY SecurityDelay LIMIT 3"]}
{"sql":"SELECT OriginState, DepTimeBlk, MAX(AirlineID) FROM mytable WHERE ArrTimeBlk NOT IN ('1300-1359', '1400-1459', '1800-1859') GROUP BY OriginState, DepTimeBlk  ORDER BY OriginState, DepTimeBlk LIMIT 23","hsqls":["SELECT OriginState, DepTimeBlk, MAX(AirlineID) FROM mytable WHERE ArrTimeBlk NOT IN ('1300-1359', '1400-1459', '1800-1859') GROUP BY OriginState, DepTimeBlk  ORDER BY OriginState, DepTimeBlk LIMIT 23"]}
{"sql":"SELECT SecurityDelay, ArrTime, CRSElapsedTime FROM mytable WHERE OriginState NOT IN ('TN', 'TX', 'NE') ORDER BY OriginAirportSeqID, Diverted, TaxiIn LIMIT 9"}
{"sql":"SELECT ActualElapsedTime, DayofMonth, \"Month\" FROM mytable WHERE DivAirportIDs <= 10874 OR OriginCityMarketID >= 34457 LIMIT 29","hsqls":["SELECT ActualElapsedTime, DayofMonth, `Month` FROM mytable WHERE (DivAirportIDs[1] <= 10874 OR DivAirportIDs[2] <= 10874 OR DivAirportIDs[3] <= 10874 OR DivAirportIDs[4] <= 10874 OR DivAirportIDs[5] <= 10874) OR OriginCityMarketID >= 34457 LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, DayofMonth, OriginStateName, MIN(\"Year\"), COUNT(ArrDelay), COUNT(Distance) FROM mytable WHERE DivArrDelay BETWEEN 124 AND 159 AND DivLongestGTimes IN (56.0, 70.0) GROUP BY DepartureDelayGroups, DayofMonth, OriginStateName LIMIT 10","hsqls":["SELECT DepartureDelayGroups, DayofMonth, OriginStateName, MIN(`Year`), COUNT(ArrDelay), COUNT(Distance) FROM mytable WHERE DivArrDelay BETWEEN 124 AND 159 AND (DivLongestGTimes[1] IN (56.0, 70.0) OR DivLongestGTimes[2] IN (56.0, 70.0) OR DivLongestGTimes[3] IN (56.0, 70.0) OR DivLongestGTimes[4] IN (56.0, 70.0) OR DivLongestGTimes[5] IN (56.0, 70.0)) GROUP BY DepartureDelayGroups, DayofMonth, OriginStateName LIMIT 10000"]}
{"sql":"SELECT SUM(Flights), AVG(ArrDelayMinutes), AVG(DistanceGroup) FROM mytable WHERE CRSArrTime < 1216 LIMIT 14"}
{"sql":"SELECT COUNT(DestWac), MAX(CRSDepTime), MIN(FirstDepTime) FROM mytable WHERE DepTimeBlk > '2300-2359' OR DestAirportID IN (11982) LIMIT 15"}
{"sql":"SELECT DestState, COUNT(*) FROM mytable WHERE AirTime = 49 GROUP BY DestState  ORDER BY DestState LIMIT 8","hsqls":["SELECT DestState, COUNT(*) FROM mytable WHERE AirTime = 49 GROUP BY DestState  ORDER BY DestState LIMIT 8"]}
{"sql":"SELECT DistanceGroup, LateAircraftDelay, DepTimeBlk FROM mytable WHERE Cancelled BETWEEN 0 AND 0 AND DestStateFips IN (47, 16, 13, 27, 28) ORDER BY OriginState, DivDistance LIMIT 20"}
{"sql":"SELECT WheelsOff, DaysSinceEpoch, SUM(CRSDepTime), SUM(DepTime), AVG(ArrDelay) FROM mytable GROUP BY WheelsOff, DaysSinceEpoch  ORDER BY WheelsOff, DaysSinceEpoch LIMIT 2","hsqls":["SELECT WheelsOff, DaysSinceEpoch, SUM(CRSDepTime), SUM(DepTime), AVG(ArrDelay) FROM mytable GROUP BY WheelsOff, DaysSinceEpoch  ORDER BY WheelsOff, DaysSinceEpoch LIMIT 2"]}
{"sql":"SELECT COUNT(Origin), MAX(CarrierDelay) FROM mytable WHERE OriginCityName NOT IN ('Melbourne, FL') LIMIT 13"}
{"sql":"SELECT LateAircraftDelay, Origin FROM mytable ORDER BY CRSArrTime, DestAirportSeqID, TaxiIn LIMIT 19"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE Distance BETWEEN 187 AND 287 OR DestStateFips IN (48, 45, 19, 26) LIMIT 18"}
{"sql":"SELECT Dest, COUNT(OriginCityMarketID), MIN(OriginAirportSeqID), MIN(DivReachedDest) FROM mytable GROUP BY Dest  ORDER BY Dest LIMIT 15","hsqls":["SELECT Dest, COUNT(OriginCityMarketID), MIN(OriginAirportSeqID), MIN(DivReachedDest) FROM mytable GROUP BY Dest  ORDER BY Dest LIMIT 15"]}
{"sql":"SELECT Quarter FROM mytable WHERE OriginWac NOT IN (63, 13, 14) OR DestCityMarketID BETWEEN 30361 AND 31726 OR CRSArrTime >= 723 ORDER BY DestState, ArrDelayMinutes LIMIT 9"}
{"sql":"SELECT DestWac, DepDelay FROM mytable WHERE OriginAirportID BETWEEN 10372 AND 14730 AND DivAirportSeqIDs BETWEEN 1524903 AND 1348502 OR OriginStateFips BETWEEN 10 AND 45 ORDER BY TaxiOut, Diverted, ArrivalDelayGroups LIMIT 7","hsqls":["SELECT DestWac, DepDelay FROM mytable WHERE OriginAirportID BETWEEN 10372 AND 14730 AND (DivAirportSeqIDs[1] BETWEEN 1524903 AND 1348502 OR DivAirportSeqIDs[2] BETWEEN 1524903 AND 1348502 OR DivAirportSeqIDs[3] BETWEEN 1524903 AND 1348502 OR DivAirportSeqIDs[4] BETWEEN 1524903 AND 1348502 OR DivAirportSeqIDs[5] BETWEEN 1524903 AND 1348502) OR OriginStateFips BETWEEN 10 AND 45 ORDER BY TaxiOut, Diverted, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DivAirportSeqIDs BETWEEN 1532302 AND 1457002 ORDER BY ArrDel15, DayofMonth LIMIT 29","hsqls":["SELECT ArrDel15 FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1532302 AND 1457002 OR DivAirportSeqIDs[2] BETWEEN 1532302 AND 1457002 OR DivAirportSeqIDs[3] BETWEEN 1532302 AND 1457002 OR DivAirportSeqIDs[4] BETWEEN 1532302 AND 1457002 OR DivAirportSeqIDs[5] BETWEEN 1532302 AND 1457002) ORDER BY ArrDel15, DayofMonth LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, WheelsOff, AVG(DistanceGroup) FROM mytable WHERE DivWheelsOns <= 2132 OR Dest <> 'ADQ' AND TailNum IN ('N549AA') GROUP BY DepartureDelayGroups, WheelsOff LIMIT 23","hsqls":["SELECT DepartureDelayGroups, WheelsOff, AVG(CAST(DistanceGroup AS DOUBLE)) FROM mytable WHERE (DivWheelsOns[1] <= 2132 OR DivWheelsOns[2] <= 2132 OR DivWheelsOns[3] <= 2132 OR DivWheelsOns[4] <= 2132 OR DivWheelsOns[5] <= 2132) OR Dest <> 'ADQ' AND TailNum IN ('N549AA') GROUP BY DepartureDelayGroups, WheelsOff LIMIT 10000"]}
{"sql":"SELECT Diverted, LateAircraftDelay, DivAirportIDs FROM mytable WHERE DepartureDelayGroups < 3 OR CarrierDelay BETWEEN 59 AND 59 AND OriginCityMarketID BETWEEN 32448 AND 31778 ORDER BY DestAirportID","hsqls":["SELECT Diverted, LateAircraftDelay, DivAirportIDs FROM mytable WHERE DepartureDelayGroups < 3 OR CarrierDelay BETWEEN 59 AND 59 AND OriginCityMarketID BETWEEN 32448 AND 31778 ORDER BY DestAirportID LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, OriginCityName, COUNT(OriginStateName), SUM(DivActualElapsedTime), SUM(FlightNum) FROM mytable WHERE FlightNum BETWEEN 289 AND 992 GROUP BY CarrierDelay, OriginCityName  ORDER BY CarrierDelay, OriginCityName LIMIT 17","hsqls":["SELECT CarrierDelay, OriginCityName, COUNT(OriginStateName), SUM(DivActualElapsedTime), SUM(FlightNum) FROM mytable WHERE FlightNum BETWEEN 289 AND 992 GROUP BY CarrierDelay, OriginCityName  ORDER BY CarrierDelay, OriginCityName LIMIT 17"]}
{"sql":"SELECT Quarter, DepDelayMinutes, ArrTimeBlk FROM mytable ORDER BY FlightDate, DayofMonth LIMIT 10"}
{"sql":"SELECT DestAirportSeqID, DivAirportIDs FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 OR Distance BETWEEN 4502 AND 1313 OR OriginCityMarketID NOT IN (30466, 34108) ORDER BY DepDelay, TaxiIn, TailNum LIMIT 23","hsqls":["SELECT DestAirportSeqID, DivAirportIDs FROM mytable WHERE `Month` BETWEEN 1 AND 1 OR Distance BETWEEN 4502 AND 1313 OR OriginCityMarketID NOT IN (30466, 34108) ORDER BY DepDelay, TaxiIn, TailNum LIMIT 10000"]}
{"sql":"SELECT DestAirportSeqID, AirlineID FROM mytable WHERE SecurityDelay IN (18, 8, 27) LIMIT 18"}
{"sql":"SELECT DepTime, DestCityMarketID FROM mytable WHERE DestWac BETWEEN 34 AND 42 OR DepDelayMinutes BETWEEN 188.0 AND 48.0 AND DepDelayMinutes <> 5.0 ORDER BY OriginAirportID LIMIT 2"}
{"sql":"SELECT ArrDelayMinutes FROM mytable WHERE CRSArrTime > 1812 OR DepartureDelayGroups >= 1 AND LongestAddGTime BETWEEN 37 AND 31 ORDER BY DepartureDelayGroups, DestAirportID LIMIT 1"}
{"sql":"SELECT DestState, \"Month\" FROM mytable LIMIT 13","hsqls":["SELECT DestState, `Month` FROM mytable LIMIT 13"]}
{"sql":"SELECT \"Year\" FROM mytable WHERE \"Month\" NOT IN (1) AND Distance BETWEEN 471 AND 1023 ORDER BY TaxiOut, DivActualElapsedTime LIMIT 20","hsqls":["SELECT `Year` FROM mytable WHERE `Month` NOT IN (1) AND Distance BETWEEN 471 AND 1023 ORDER BY TaxiOut, DivActualElapsedTime LIMIT 20"]}
{"sql":"SELECT LateAircraftDelay, CRSArrTime, CarrierDelay, SUM(WeatherDelay) FROM mytable WHERE TailNum BETWEEN 'N952FR' AND 'N524AS' AND DepDelayMinutes NOT IN (114.0, 138.0, 218.0) AND AirlineID = 19805 GROUP BY LateAircraftDelay, CRSArrTime, CarrierDelay  ORDER BY LateAircraftDelay, CRSArrTime, CarrierDelay LIMIT 11","hsqls":["SELECT LateAircraftDelay, CRSArrTime, CarrierDelay, SUM(WeatherDelay) FROM mytable WHERE TailNum BETWEEN 'N952FR' AND 'N524AS' AND DepDelayMinutes NOT IN (114.0, 138.0, 218.0) AND AirlineID = 19805 GROUP BY LateAircraftDelay, CRSArrTime, CarrierDelay  ORDER BY LateAircraftDelay, CRSArrTime, CarrierDelay LIMIT 11"]}
{"sql":"SELECT DivArrDelay, AVG(DestStateFips), COUNT(Diverted) FROM mytable WHERE Distance IN (2442, 606) GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 10","hsqls":["SELECT DivArrDelay, AVG(DestStateFips), COUNT(Diverted) FROM mytable WHERE Distance IN (2442, 606) GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 10"]}
{"sql":"SELECT WeatherDelay, TotalAddGTime, UniqueCarrier, MIN(ArrDelayMinutes), AVG(DepDel15), SUM(DestWac) FROM mytable GROUP BY WeatherDelay, TotalAddGTime, UniqueCarrier  ORDER BY WeatherDelay, TotalAddGTime, UniqueCarrier LIMIT 22","hsqls":["SELECT WeatherDelay, TotalAddGTime, UniqueCarrier, MIN(ArrDelayMinutes), AVG(DepDel15), SUM(DestWac) FROM mytable GROUP BY WeatherDelay, TotalAddGTime, UniqueCarrier  ORDER BY WeatherDelay, TotalAddGTime, UniqueCarrier LIMIT 22"]}
{"sql":"SELECT DepDelayMinutes, TaxiIn, DestAirportSeqID, MAX(DepDelayMinutes) FROM mytable GROUP BY DepDelayMinutes, TaxiIn, DestAirportSeqID  ORDER BY DepDelayMinutes, TaxiIn, DestAirportSeqID LIMIT 11","hsqls":["SELECT DepDelayMinutes, TaxiIn, DestAirportSeqID, MAX(DepDelayMinutes) FROM mytable GROUP BY DepDelayMinutes, TaxiIn, DestAirportSeqID  ORDER BY DepDelayMinutes, TaxiIn, DestAirportSeqID LIMIT 11"]}
{"sql":"SELECT DepTime FROM mytable WHERE DivArrDelay < 260 OR WheelsOn BETWEEN 2205 AND 1326 ORDER BY TailNum, \"Month\" LIMIT 15","hsqls":["SELECT DepTime FROM mytable WHERE DivArrDelay < 260 OR WheelsOn BETWEEN 2205 AND 1326 ORDER BY TailNum, `Month` LIMIT 15"]}
{"sql":"SELECT AVG(Cancelled) FROM mytable LIMIT 16"}
{"sql":"SELECT DestStateFips FROM mytable WHERE FlightNum > 4875 OR SecurityDelay NOT IN (0, 4, 14, 27, -9999) OR DivActualElapsedTime BETWEEN 403 AND 379 LIMIT 15"}
{"sql":"SELECT ArrTime, COUNT(*) FROM mytable WHERE DivDistance <= 603 OR OriginWac > 45 GROUP BY ArrTime  ORDER BY ArrTime LIMIT 15","hsqls":["SELECT ArrTime, COUNT(*) FROM mytable WHERE DivDistance <= 603 OR OriginWac > 45 GROUP BY ArrTime  ORDER BY ArrTime LIMIT 15"]}
{"sql":"SELECT TaxiOut, DepDelay, DaysSinceEpoch, COUNT(NASDelay), COUNT(WheelsOff) FROM mytable GROUP BY TaxiOut, DepDelay, DaysSinceEpoch  ORDER BY TaxiOut, DepDelay, DaysSinceEpoch LIMIT 12","hsqls":["SELECT TaxiOut, DepDelay, DaysSinceEpoch, COUNT(NASDelay), COUNT(WheelsOff) FROM mytable GROUP BY TaxiOut, DepDelay, DaysSinceEpoch  ORDER BY TaxiOut, DepDelay, DaysSinceEpoch LIMIT 12"]}
{"sql":"SELECT Quarter FROM mytable WHERE OriginAirportID NOT IN (13158, 10732, 10980, 14006, 10781) AND Carrier >= 'MQ' OR Flights BETWEEN 1 AND 1 LIMIT 8"}
{"sql":"SELECT DistanceGroup, DivArrDelay, COUNT(*) FROM mytable WHERE TailNum BETWEEN 'N11206' AND 'N863AS' GROUP BY DistanceGroup, DivArrDelay  ORDER BY DistanceGroup, DivArrDelay LIMIT 7","hsqls":["SELECT DistanceGroup, DivArrDelay, COUNT(*) FROM mytable WHERE TailNum BETWEEN 'N11206' AND 'N863AS' GROUP BY DistanceGroup, DivArrDelay  ORDER BY DistanceGroup, DivArrDelay LIMIT 7"]}
{"sql":"SELECT DivDistance, NASDelay FROM mytable WHERE TaxiIn BETWEEN 15 AND 9 ORDER BY OriginCityName, ActualElapsedTime, CancellationCode LIMIT 5"}
{"sql":"SELECT OriginAirportSeqID, UniqueCarrier, DayOfWeek, COUNT(*) FROM mytable GROUP BY OriginAirportSeqID, UniqueCarrier, DayOfWeek  ORDER BY OriginAirportSeqID, UniqueCarrier, DayOfWeek LIMIT 7","hsqls":["SELECT OriginAirportSeqID, UniqueCarrier, DayOfWeek, COUNT(*) FROM mytable GROUP BY OriginAirportSeqID, UniqueCarrier, DayOfWeek  ORDER BY OriginAirportSeqID, UniqueCarrier, DayOfWeek LIMIT 7"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE TaxiIn >= 34 OR DestStateFips IN (48, 78, 26, 28) OR OriginAirportID IN (10821, 12915) ORDER BY OriginState, \"Month\", DivActualElapsedTime LIMIT 10","hsqls":["SELECT DivWheelsOns FROM mytable WHERE TaxiIn >= 34 OR DestStateFips IN (48, 78, 26, 28) OR OriginAirportID IN (10821, 12915) ORDER BY OriginState, Month, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT Dest, ArrDelay, AVG(DestStateFips), COUNT(ArrTimeBlk) FROM mytable WHERE DepDelayMinutes BETWEEN 146.0 AND 397.0 OR CancellationCode <= 'B' GROUP BY Dest, ArrDelay  ORDER BY Dest, ArrDelay LIMIT 7","hsqls":["SELECT Dest, ArrDelay, AVG(DestStateFips), COUNT(ArrTimeBlk) FROM mytable WHERE DepDelayMinutes BETWEEN 146.0 AND 397.0 OR CancellationCode <= 'B' GROUP BY Dest, ArrDelay  ORDER BY Dest, ArrDelay LIMIT 7"]}
{"sql":"SELECT WheelsOff, Carrier, DepDel15, AVG(\"Month\") FROM mytable GROUP BY WheelsOff, Carrier, DepDel15 LIMIT 9","hsqls":["SELECT WheelsOff, Carrier, DepDel15, AVG(`Month`) FROM mytable GROUP BY WheelsOff, Carrier, DepDel15 LIMIT 9"]}
{"sql":"SELECT DepTimeBlk FROM mytable WHERE DivAirportIDs >= 12451 AND Quarter BETWEEN 1 AND 1 ORDER BY DestAirportID LIMIT 16","hsqls":["SELECT DepTimeBlk FROM mytable WHERE (DivAirportIDs[1] >= 12451 OR DivAirportIDs[2] >= 12451 OR DivAirportIDs[3] >= 12451 OR DivAirportIDs[4] >= 12451 OR DivAirportIDs[5] >= 12451) AND Quarter BETWEEN 1 AND 1 ORDER BY DestAirportID LIMIT 10000"]}
{"sql":"SELECT SUM(DestAirportID) FROM mytable LIMIT 20"}
{"sql":"SELECT ArrDel15, WheelsOn, ArrivalDelayGroups FROM mytable WHERE DestStateFips BETWEEN 17 AND 9 OR LateAircraftDelay >= 9 AND OriginAirportID <= 15389 ORDER BY LongestAddGTime LIMIT 21"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE CRSArrTime <= 1412 AND DivLongestGTimes BETWEEN 69.0 AND 1.0 OR ActualElapsedTime BETWEEN 304 AND 336 LIMIT 15","hsqls":["SELECT COUNT(*) FROM mytable WHERE CRSArrTime <= 1412 AND (DivLongestGTimes[1] BETWEEN 69.0 AND 1.0 OR DivLongestGTimes[2] BETWEEN 69.0 AND 1.0 OR DivLongestGTimes[3] BETWEEN 69.0 AND 1.0 OR DivLongestGTimes[4] BETWEEN 69.0 AND 1.0 OR DivLongestGTimes[5] BETWEEN 69.0 AND 1.0) OR ActualElapsedTime BETWEEN 304 AND 336 LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DivAirports FROM mytable ORDER BY DivDistance LIMIT 9","hsqls":["SELECT OriginAirportSeqID, DivAirports FROM mytable ORDER BY DivDistance LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, DepDel15, SUM(NASDelay) FROM mytable GROUP BY FirstDepTime, DepDel15  ORDER BY FirstDepTime, DepDel15 LIMIT 19","hsqls":["SELECT FirstDepTime, DepDel15, SUM(NASDelay) FROM mytable GROUP BY FirstDepTime, DepDel15  ORDER BY FirstDepTime, DepDel15 LIMIT 19"]}
{"sql":"SELECT DivActualElapsedTime, OriginStateName FROM mytable WHERE Dest NOT IN ('WRG', 'HRL', 'GSO', 'EKO') AND DepTime NOT IN (747) AND WheelsOff < 914 LIMIT 22"}
{"sql":"SELECT CarrierDelay, DivArrDelay, WheelsOn FROM mytable WHERE Quarter BETWEEN 1 AND 1 OR Dest <= 'BMI' AND SecurityDelay <> 10 ORDER BY Flights"}
{"sql":"SELECT CarrierDelay, CRSElapsedTime FROM mytable WHERE \"Year\" NOT IN (2014) OR Distance NOT IN (997, 384, 350) AND SecurityDelay BETWEEN 18 AND -9999 ORDER BY OriginState, DayofMonth, CRSDepTime LIMIT 13","hsqls":["SELECT CarrierDelay, CRSElapsedTime FROM mytable WHERE `Year` NOT IN (2014) OR Distance NOT IN (997, 384, 350) AND SecurityDelay BETWEEN 18 AND -9999 ORDER BY OriginState, DayofMonth, CRSDepTime LIMIT 13"]}
{"sql":"SELECT CRSArrTime, NASDelay, \"Month\" FROM mytable LIMIT 28","hsqls":["SELECT CRSArrTime, NASDelay, `Month` FROM mytable LIMIT 28"]}
{"sql":"SELECT Dest, UniqueCarrier, AVG(OriginWac) FROM mytable WHERE DivAirports BETWEEN 'CDC' AND 'BHM' OR TaxiOut BETWEEN 26 AND 91 AND NASDelay IN (238) GROUP BY Dest, UniqueCarrier LIMIT 15","hsqls":["SELECT Dest, UniqueCarrier, AVG(CAST(OriginWac AS DOUBLE)) FROM mytable WHERE (DivAirports[1] BETWEEN 'CDC' AND 'BHM' OR DivAirports[2] BETWEEN 'CDC' AND 'BHM' OR DivAirports[3] BETWEEN 'CDC' AND 'BHM' OR DivAirports[4] BETWEEN 'CDC' AND 'BHM' OR DivAirports[5] BETWEEN 'CDC' AND 'BHM') OR TaxiOut BETWEEN 26 AND 91 AND NASDelay IN (238) GROUP BY Dest, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT ArrTimeBlk, OriginAirportID, AVG(CRSDepTime), AVG(DestWac) FROM mytable WHERE TaxiOut >= 96 AND DestStateName IN ('Wyoming', 'Pennsylvania', 'Kansas', 'Wisconsin') AND ArrivalDelayGroups <= 1 GROUP BY ArrTimeBlk, OriginAirportID  ORDER BY ArrTimeBlk, OriginAirportID LIMIT 8","hsqls":["SELECT ArrTimeBlk, OriginAirportID, AVG(CRSDepTime), AVG(DestWac) FROM mytable WHERE TaxiOut >= 96 AND DestStateName IN ('Wyoming', 'Pennsylvania', 'Kansas', 'Wisconsin') AND ArrivalDelayGroups <= 1 GROUP BY ArrTimeBlk, OriginAirportID  ORDER BY ArrTimeBlk, OriginAirportID LIMIT 8"]}
{"sql":"SELECT DestWac, Quarter, UniqueCarrier, AVG(SecurityDelay) FROM mytable WHERE Carrier NOT IN ('EV', 'FL') GROUP BY DestWac, Quarter, UniqueCarrier  ORDER BY DestWac, Quarter, UniqueCarrier LIMIT 24","hsqls":["SELECT DestWac, Quarter, UniqueCarrier, AVG(SecurityDelay) FROM mytable WHERE Carrier NOT IN ('EV', 'FL') GROUP BY DestWac, Quarter, UniqueCarrier  ORDER BY DestWac, Quarter, UniqueCarrier LIMIT 24"]}
{"sql":"SELECT ArrTime, DivAirportSeqIDs, OriginAirportID FROM mytable WHERE DestStateFips BETWEEN 49 AND 25 OR DepDel15 BETWEEN 0 AND -9999 ORDER BY DestState, OriginCityName LIMIT 20","hsqls":["SELECT ArrTime, DivAirportSeqIDs, OriginAirportID FROM mytable WHERE DestStateFips BETWEEN 49 AND 25 OR DepDel15 BETWEEN 0 AND -9999 ORDER BY DestState, OriginCityName LIMIT 10000"]}
{"sql":"SELECT SUM(TaxiOut) FROM mytable WHERE WeatherDelay <> 123 OR DivWheelsOffs IN (1352, 1758) OR DistanceGroup NOT IN (5) LIMIT 14","hsqls":["SELECT SUM(TaxiOut) FROM mytable WHERE WeatherDelay <> 123 OR (DivWheelsOffs[1] IN (1352, 1758) OR DivWheelsOffs[2] IN (1352, 1758) OR DivWheelsOffs[3] IN (1352, 1758) OR DivWheelsOffs[4] IN (1352, 1758) OR DivWheelsOffs[5] IN (1352, 1758)) OR DistanceGroup NOT IN (5) LIMIT 10000"]}
{"sql":"SELECT COUNT(ArrivalDelayGroups), MIN(DepartureDelayGroups), SUM(AirlineID) FROM mytable LIMIT 15"}
{"sql":"SELECT WheelsOff, DivReachedDest FROM mytable ORDER BY TaxiOut, DepTime, Dest LIMIT 27"}
{"sql":"SELECT DistanceGroup, CRSElapsedTime, AVG(\"Year\"), COUNT(WeatherDelay) FROM mytable WHERE DepartureDelayGroups < 1 OR DestWac >= 54 OR WheelsOn IN (755) GROUP BY DistanceGroup, CRSElapsedTime LIMIT 7","hsqls":["SELECT DistanceGroup, CRSElapsedTime, AVG(`Year`), COUNT(WeatherDelay) FROM mytable WHERE DepartureDelayGroups < 1 OR DestWac >= 54 OR WheelsOn IN (755) GROUP BY DistanceGroup, CRSElapsedTime LIMIT 7"]}
{"sql":"SELECT OriginStateFips, COUNT(DestAirportID), MIN(TaxiOut) FROM mytable WHERE TaxiOut >= 79 OR WheelsOn BETWEEN 520 AND 301 GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 27","hsqls":["SELECT OriginStateFips, COUNT(DestAirportID), MIN(TaxiOut) FROM mytable WHERE TaxiOut >= 79 OR WheelsOn BETWEEN 520 AND 301 GROUP BY OriginStateFips  ORDER BY OriginStateFips LIMIT 27"]}
{"sql":"SELECT WeatherDelay, DepDelayMinutes, COUNT(\"Month\"), MIN(DivAirportLandings) FROM mytable WHERE DaysSinceEpoch IN (16088) GROUP BY WeatherDelay, DepDelayMinutes LIMIT 13","hsqls":["SELECT WeatherDelay, DepDelayMinutes, COUNT(`Month`), MIN(DivAirportLandings) FROM mytable WHERE DaysSinceEpoch IN (16088) GROUP BY WeatherDelay, DepDelayMinutes LIMIT 13"]}
{"sql":"SELECT CarrierDelay, TaxiIn, OriginWac, MAX(OriginCityMarketID) FROM mytable GROUP BY CarrierDelay, TaxiIn, OriginWac  ORDER BY CarrierDelay, TaxiIn, OriginWac LIMIT 13","hsqls":["SELECT CarrierDelay, TaxiIn, OriginWac, MAX(OriginCityMarketID) FROM mytable GROUP BY CarrierDelay, TaxiIn, OriginWac  ORDER BY CarrierDelay, TaxiIn, OriginWac LIMIT 13"]}
{"sql":"SELECT DestCityMarketID, OriginWac, DaysSinceEpoch, MAX(WheelsOff) FROM mytable WHERE DivTailNums BETWEEN 'N551AS' AND 'N635AA' AND DivAirportSeqIDs < 1281902 OR DepDel15 NOT IN (1, 0) GROUP BY DestCityMarketID, OriginWac, DaysSinceEpoch LIMIT 23","hsqls":["SELECT DestCityMarketID, OriginWac, DaysSinceEpoch, MAX(WheelsOff) FROM mytable WHERE (DivTailNums[1] BETWEEN 'N551AS' AND 'N635AA' OR DivTailNums[2] BETWEEN 'N551AS' AND 'N635AA' OR DivTailNums[3] BETWEEN 'N551AS' AND 'N635AA' OR DivTailNums[4] BETWEEN 'N551AS' AND 'N635AA' OR DivTailNums[5] BETWEEN 'N551AS' AND 'N635AA') AND (DivAirportSeqIDs[1] < 1281902 OR DivAirportSeqIDs[2] < 1281902 OR DivAirportSeqIDs[3] < 1281902 OR DivAirportSeqIDs[4] < 1281902 OR DivAirportSeqIDs[5] < 1281902) OR DepDel15 NOT IN (1, 0) GROUP BY DestCityMarketID, OriginWac, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, DestCityName, DepTimeBlk, MAX(DestStateFips), MAX(TaxiIn), SUM(OriginStateFips) FROM mytable WHERE CRSElapsedTime BETWEEN 335 AND 45 AND DivAirportIDs BETWEEN 13851 AND 15370 AND ArrivalDelayGroups NOT IN (-2, 4, -9999) GROUP BY OriginCityMarketID, DestCityName, DepTimeBlk LIMIT 9","hsqls":["SELECT OriginCityMarketID, DestCityName, DepTimeBlk, MAX(DestStateFips), MAX(TaxiIn), SUM(OriginStateFips) FROM mytable WHERE CRSElapsedTime BETWEEN 335 AND 45 AND (DivAirportIDs[1] BETWEEN 13851 AND 15370 OR DivAirportIDs[2] BETWEEN 13851 AND 15370 OR DivAirportIDs[3] BETWEEN 13851 AND 15370 OR DivAirportIDs[4] BETWEEN 13851 AND 15370 OR DivAirportIDs[5] BETWEEN 13851 AND 15370) AND ArrivalDelayGroups NOT IN (-2, 4, -9999) GROUP BY OriginCityMarketID, DestCityName, DepTimeBlk LIMIT 10000"]}
{"sql":"SELECT TotalAddGTime, DivAirportIDs FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND Quarter IN (1) LIMIT 21","hsqls":["SELECT TotalAddGTime, DivAirportIDs FROM mytable WHERE Quarter BETWEEN 1 AND 1 AND Quarter IN (1) LIMIT 10000"]}
{"sql":"SELECT SecurityDelay, ActualElapsedTime, NASDelay FROM mytable WHERE OriginAirportSeqID <= 1130802 OR OriginStateFips >= 26 AND CRSArrTime <= 1017 LIMIT 13"}
{"sql":"SELECT SUM(TaxiOut) FROM mytable LIMIT 2"}
{"sql":"SELECT DivAirportIDs FROM mytable ORDER BY DivAirportLandings LIMIT 2","hsqls":["SELECT DivAirportIDs FROM mytable ORDER BY DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT DepDelay, AVG(ArrivalDelayGroups), MAX(DivReachedDest) FROM mytable WHERE AirlineID NOT IN (19690, 19790, 19805, 20366) OR DepDelayMinutes IN (359.0, 49.0, 17.0) AND Dest BETWEEN 'MCI' AND 'ECP' GROUP BY DepDelay  ORDER BY DepDelay LIMIT 18","hsqls":["SELECT DepDelay, AVG(ArrivalDelayGroups), MAX(DivReachedDest) FROM mytable WHERE AirlineID NOT IN (19690, 19790, 19805, 20366) OR DepDelayMinutes IN (359.0, 49.0, 17.0) AND Dest BETWEEN 'MCI' AND 'ECP' GROUP BY DepDelay  ORDER BY DepDelay LIMIT 18"]}
{"sql":"SELECT Flights, AVG(ArrivalDelayGroups) FROM mytable WHERE CarrierDelay >= 153 GROUP BY Flights  ORDER BY Flights LIMIT 3","hsqls":["SELECT Flights, AVG(ArrivalDelayGroups) FROM mytable WHERE CarrierDelay >= 153 GROUP BY Flights  ORDER BY Flights LIMIT 3"]}
{"sql":"SELECT SUM(DistanceGroup) FROM mytable WHERE CRSArrTime BETWEEN 2341 AND 931 OR DivWheelsOns IN (1642) OR DestCityName <> 'Indianapolis, IN' LIMIT 6","hsqls":["SELECT SUM(DistanceGroup) FROM mytable WHERE CRSArrTime BETWEEN 2341 AND 931 OR (DivWheelsOns[1] IN (1642) OR DivWheelsOns[2] IN (1642) OR DivWheelsOns[3] IN (1642) OR DivWheelsOns[4] IN (1642) OR DivWheelsOns[5] IN (1642)) OR DestCityName <> 'Indianapolis, IN' LIMIT 10000"]}
{"sql":"SELECT DivDistance, MIN(DayOfWeek) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 4","hsqls":["SELECT DivDistance, MIN(DayOfWeek) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 4"]}
{"sql":"SELECT FirstDepTime, SUM(DivReachedDest) FROM mytable WHERE ActualElapsedTime > 95 AND TailNum NOT IN ('N8609A') GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 15","hsqls":["SELECT FirstDepTime, SUM(DivReachedDest) FROM mytable WHERE ActualElapsedTime > 95 AND TailNum NOT IN ('N8609A') GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 15"]}
{"sql":"SELECT OriginAirportSeqID, OriginStateName FROM mytable ORDER BY DivDistance LIMIT 12"}
{"sql":"SELECT AVG(TotalAddGTime), AVG(OriginCityMarketID) FROM mytable WHERE Carrier < 'HA' LIMIT 17"}
{"sql":"SELECT DepDelay, DivTotalGTimes FROM mytable ORDER BY OriginCityMarketID, FlightNum LIMIT 25","hsqls":["SELECT DepDelay, DivTotalGTimes FROM mytable ORDER BY OriginCityMarketID, FlightNum LIMIT 10000"]}
{"sql":"SELECT DestAirportID FROM mytable WHERE OriginCityName BETWEEN 'Iron Mountain/Kingsfd, MI' AND 'Jacksonville/Camp Lejeune, NC' OR CRSArrTime = 849 LIMIT 10"}
{"sql":"SELECT TaxiOut, DepDel15, WheelsOn FROM mytable WHERE DivAirportIDs IN (11278, 10521, 10754) OR WheelsOff > 2032 AND TaxiIn IN (30, 94, 47, 27, 28) ORDER BY DestCityMarketID LIMIT 7","hsqls":["SELECT TaxiOut, DepDel15, WheelsOn FROM mytable WHERE (DivAirportIDs[1] IN (11278, 10521, 10754) OR DivAirportIDs[2] IN (11278, 10521, 10754) OR DivAirportIDs[3] IN (11278, 10521, 10754) OR DivAirportIDs[4] IN (11278, 10521, 10754) OR DivAirportIDs[5] IN (11278, 10521, 10754)) OR WheelsOff > 2032 AND TaxiIn IN (30, 94, 47, 27, 28) ORDER BY DestCityMarketID LIMIT 10000"]}
{"sql":"SELECT DistanceGroup, AVG(AirTime) FROM mytable WHERE DayOfWeek NOT IN (5) OR \"Month\" BETWEEN 1 AND 1 AND SecurityDelay IN (1, 10, 4, 8, 14) GROUP BY DistanceGroup LIMIT 24","hsqls":["SELECT DistanceGroup, AVG(AirTime) FROM mytable WHERE DayOfWeek NOT IN (5) OR `Month` BETWEEN 1 AND 1 AND SecurityDelay IN (1, 10, 4, 8, 14) GROUP BY DistanceGroup LIMIT 24"]}
{"sql":"SELECT TaxiOut, LongestAddGTime FROM mytable WHERE ArrTime <> 1932 OR OriginState IN ('CA', 'IL', 'WI') AND ArrDelay IN (63.0, 241.0, 21.0) LIMIT 14"}
{"sql":"SELECT DistanceGroup, FlightNum, NASDelay, MAX(FirstDepTime), COUNT(OriginAirportID) FROM mytable GROUP BY DistanceGroup, FlightNum, NASDelay  ORDER BY DistanceGroup, FlightNum, NASDelay LIMIT 24","hsqls":["SELECT DistanceGroup, FlightNum, NASDelay, MAX(FirstDepTime), COUNT(OriginAirportID) FROM mytable GROUP BY DistanceGroup, FlightNum, NASDelay  ORDER BY DistanceGroup, FlightNum, NASDelay LIMIT 24"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivWheelsOffs IN (1243, 204, 1430, 2104, 952) LIMIT 26","hsqls":["SELECT COUNT(*) FROM mytable WHERE (DivWheelsOffs[1] IN (1243, 204, 1430, 2104, 952) OR DivWheelsOffs[2] IN (1243, 204, 1430, 2104, 952) OR DivWheelsOffs[3] IN (1243, 204, 1430, 2104, 952) OR DivWheelsOffs[4] IN (1243, 204, 1430, 2104, 952) OR DivWheelsOffs[5] IN (1243, 204, 1430, 2104, 952)) LIMIT 10000"]}
{"sql":"SELECT OriginAirportSeqID, DivWheelsOns, ActualElapsedTime FROM mytable WHERE DivLongestGTimes >= 30.0 AND DivArrDelay <= 113 ORDER BY Distance, WheelsOn, CRSElapsedTime LIMIT 5","hsqls":["SELECT OriginAirportSeqID, DivWheelsOns, ActualElapsedTime FROM mytable WHERE (DivLongestGTimes[1] >= 30.0 OR DivLongestGTimes[2] >= 30.0 OR DivLongestGTimes[3] >= 30.0 OR DivLongestGTimes[4] >= 30.0 OR DivLongestGTimes[5] >= 30.0) AND DivArrDelay <= 113 ORDER BY Distance, WheelsOn, CRSElapsedTime LIMIT 10000"]}
{"sql":"SELECT COUNT(Origin), COUNT(NASDelay) FROM mytable WHERE OriginCityMarketID NOT IN (31205, 32177, 33038) LIMIT 3"}
{"sql":"SELECT TaxiOut FROM mytable ORDER BY ArrDelayMinutes, CRSElapsedTime LIMIT 5"}
{"sql":"SELECT OriginAirportSeqID, ArrDelayMinutes, AVG(ArrDelayMinutes) FROM mytable WHERE DestCityName > 'Christiansted, VI' OR Carrier >= 'FL' AND OriginCityName >= 'Duluth, MN' GROUP BY OriginAirportSeqID, ArrDelayMinutes  ORDER BY OriginAirportSeqID, ArrDelayMinutes LIMIT 20","hsqls":["SELECT OriginAirportSeqID, ArrDelayMinutes, AVG(ArrDelayMinutes) FROM mytable WHERE DestCityName > 'Christiansted, VI' OR Carrier >= 'FL' AND OriginCityName >= 'Duluth, MN' GROUP BY OriginAirportSeqID, ArrDelayMinutes  ORDER BY OriginAirportSeqID, ArrDelayMinutes LIMIT 20"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrivalDelayGroups >= 3 OR DivArrDelay NOT IN (1280, 252, 647, 71, 166) OR NASDelay IN (133, 35, 63, -9999, 12) LIMIT 16"}
{"sql":"SELECT ArrDelayMinutes, Cancelled, ArrivalDelayGroups, COUNT(DepTimeBlk), SUM(TaxiOut) FROM mytable WHERE DaysSinceEpoch BETWEEN 16077 AND 16072 AND Dest < 'GGG' AND TailNum BETWEEN 'N467UA' AND 'N440UA' GROUP BY ArrDelayMinutes, Cancelled, ArrivalDelayGroups  ORDER BY ArrDelayMinutes, Cancelled, ArrivalDelayGroups LIMIT 10","hsqls":["SELECT ArrDelayMinutes, Cancelled, ArrivalDelayGroups, COUNT(DepTimeBlk), SUM(TaxiOut) FROM mytable WHERE DaysSinceEpoch BETWEEN 16077 AND 16072 AND Dest < 'GGG' AND TailNum BETWEEN 'N467UA' AND 'N440UA' GROUP BY ArrDelayMinutes, Cancelled, ArrivalDelayGroups  ORDER BY ArrDelayMinutes, Cancelled, ArrivalDelayGroups LIMIT 10"]}
{"sql":"SELECT MIN(WeatherDelay) FROM mytable WHERE DestCityMarketID BETWEEN 32441 AND 34685 OR SecurityDelay NOT IN (1, 10, 4, 18) LIMIT 9"}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE DivDistance BETWEEN 50 AND 539 OR DestCityMarketID BETWEEN 31905 AND 33424 AND ArrDel15 BETWEEN 0 AND -9999 ORDER BY TaxiIn LIMIT 1","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE DivDistance BETWEEN 50 AND 539 OR DestCityMarketID BETWEEN 31905 AND 33424 AND ArrDel15 BETWEEN 0 AND -9999 ORDER BY TaxiIn LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, ArrTime, OriginStateName, MAX(DepDel15), COUNT(Cancelled) FROM mytable WHERE DivArrDelay BETWEEN 171 AND 762 AND DivTotalGTimes < 56 AND CRSArrTime = 931 GROUP BY FirstDepTime, ArrTime, OriginStateName LIMIT 10","hsqls":["SELECT FirstDepTime, ArrTime, OriginStateName, MAX(DepDel15), COUNT(Cancelled) FROM mytable WHERE DivArrDelay BETWEEN 171 AND 762 AND (DivTotalGTimes[1] < 56 OR DivTotalGTimes[2] < 56 OR DivTotalGTimes[3] < 56 OR DivTotalGTimes[4] < 56 OR DivTotalGTimes[5] < 56) AND CRSArrTime = 931 GROUP BY FirstDepTime, ArrTime, OriginStateName LIMIT 10000"]}
{"sql":"SELECT AirTime FROM mytable ORDER BY UniqueCarrier LIMIT 24"}
{"sql":"SELECT Distance, ArrDelayMinutes, ArrivalDelayGroups, MAX(ArrDel15), SUM(DivDistance) FROM mytable WHERE DivWheelsOns IN (1807, 1728, 2247, 1131, 1344) AND DestAirportID > 14679 OR DestState NOT IN ('ID') GROUP BY Distance, ArrDelayMinutes, ArrivalDelayGroups LIMIT 14","hsqls":["SELECT Distance, ArrDelayMinutes, ArrivalDelayGroups, MAX(ArrDel15), SUM(DivDistance) FROM mytable WHERE (DivWheelsOns[1] IN (1807, 1728, 2247, 1131, 1344) OR DivWheelsOns[2] IN (1807, 1728, 2247, 1131, 1344) OR DivWheelsOns[3] IN (1807, 1728, 2247, 1131, 1344) OR DivWheelsOns[4] IN (1807, 1728, 2247, 1131, 1344) OR DivWheelsOns[5] IN (1807, 1728, 2247, 1131, 1344)) AND DestAirportID > 14679 OR DestState NOT IN ('ID') GROUP BY Distance, ArrDelayMinutes, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DestCityMarketID, AVG(OriginWac) FROM mytable WHERE DestStateName IN ('Pennsylvania', 'Ohio', 'North Carolina', 'Nebraska', 'Oregon') OR OriginState IN ('DE', 'AK', 'HI') GROUP BY WeatherDelay, DestCityMarketID  ORDER BY WeatherDelay, DestCityMarketID LIMIT 26","hsqls":["SELECT WeatherDelay, DestCityMarketID, AVG(OriginWac) FROM mytable WHERE DestStateName IN ('Pennsylvania', 'Ohio', 'North Carolina', 'Nebraska', 'Oregon') OR OriginState IN ('DE', 'AK', 'HI') GROUP BY WeatherDelay, DestCityMarketID  ORDER BY WeatherDelay, DestCityMarketID LIMIT 26"]}
{"sql":"SELECT OriginAirportSeqID, DestState, Dest, AVG(OriginWac), COUNT(DivAirportLandings) FROM mytable GROUP BY OriginAirportSeqID, DestState, Dest  ORDER BY OriginAirportSeqID, DestState, Dest LIMIT 26","hsqls":["SELECT OriginAirportSeqID, DestState, Dest, AVG(OriginWac), COUNT(DivAirportLandings) FROM mytable GROUP BY OriginAirportSeqID, DestState, Dest  ORDER BY OriginAirportSeqID, DestState, Dest LIMIT 26"]}
{"sql":"SELECT SecurityDelay FROM mytable WHERE DivWheelsOns IN (1409) ORDER BY Distance, ArrTimeBlk, DaysSinceEpoch LIMIT 17","hsqls":["SELECT SecurityDelay FROM mytable WHERE (DivWheelsOns[1] IN (1409) OR DivWheelsOns[2] IN (1409) OR DivWheelsOns[3] IN (1409) OR DivWheelsOns[4] IN (1409) OR DivWheelsOns[5] IN (1409)) ORDER BY Distance, ArrTimeBlk, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT DepDelay, DivWheelsOffs FROM mytable ORDER BY DepTime, TailNum, DayofMonth LIMIT 8","hsqls":["SELECT DepDelay, DivWheelsOffs FROM mytable ORDER BY DepTime, TailNum, DayofMonth LIMIT 10000"]}
{"sql":"SELECT MAX(ArrDel15), COUNT(DivActualElapsedTime) FROM mytable LIMIT 9"}
{"sql":"SELECT LateAircraftDelay, DepDelayMinutes, SUM(CarrierDelay), MIN(DepDelayMinutes), AVG(DepDel15) FROM mytable WHERE OriginCityMarketID <= 30779 AND WheelsOff BETWEEN 1134 AND 1019 OR DestState > 'WA' GROUP BY LateAircraftDelay, DepDelayMinutes  ORDER BY LateAircraftDelay, DepDelayMinutes LIMIT 5","hsqls":["SELECT LateAircraftDelay, DepDelayMinutes, SUM(CarrierDelay), MIN(DepDelayMinutes), AVG(DepDel15) FROM mytable WHERE OriginCityMarketID <= 30779 AND WheelsOff BETWEEN 1134 AND 1019 OR DestState > 'WA' GROUP BY LateAircraftDelay, DepDelayMinutes  ORDER BY LateAircraftDelay, DepDelayMinutes LIMIT 5"]}
{"sql":"SELECT ActualElapsedTime, TaxiIn, Dest FROM mytable WHERE OriginWac BETWEEN 93 AND 62 ORDER BY FirstDepTime, OriginCityMarketID, DayOfWeek LIMIT 19"}
{"sql":"SELECT MAX(CRSDepTime) FROM mytable WHERE DestCityMarketID IN (30141, 31135) OR AirTime NOT IN (357, 196) OR LateAircraftDelay > 23 LIMIT 13"}
{"sql":"SELECT DepDel15, UniqueCarrier FROM mytable WHERE DestState < 'ND' AND Carrier BETWEEN 'WN' AND 'F9' LIMIT 14"}
{"sql":"SELECT AVG(ArrDelay) FROM mytable LIMIT 19"}
{"sql":"SELECT Dest FROM mytable WHERE DivTailNums >= 'N8315C' ORDER BY WeatherDelay","hsqls":["SELECT Dest FROM mytable WHERE (DivTailNums[1] >= 'N8315C' OR DivTailNums[2] >= 'N8315C' OR DivTailNums[3] >= 'N8315C' OR DivTailNums[4] >= 'N8315C' OR DivTailNums[5] >= 'N8315C') ORDER BY WeatherDelay LIMIT 10000"]}
{"sql":"SELECT DayofMonth, CRSDepTime, MAX(OriginAirportID), COUNT(DestCityMarketID) FROM mytable WHERE TaxiIn NOT IN (79, 7, 9, 101) GROUP BY DayofMonth, CRSDepTime  ORDER BY DayofMonth, CRSDepTime LIMIT 2","hsqls":["SELECT DayofMonth, CRSDepTime, MAX(OriginAirportID), COUNT(DestCityMarketID) FROM mytable WHERE TaxiIn NOT IN (79, 7, 9, 101) GROUP BY DayofMonth, CRSDepTime  ORDER BY DayofMonth, CRSDepTime LIMIT 2"]}
{"sql":"SELECT DepDelayMinutes, WheelsOn FROM mytable WHERE CancellationCode <= 'A' OR \"Year\" NOT IN (2014) AND TaxiIn BETWEEN 50 AND 29 ORDER BY DayOfWeek LIMIT 17","hsqls":["SELECT DepDelayMinutes, WheelsOn FROM mytable WHERE CancellationCode <= 'A' OR `Year` NOT IN (2014) AND TaxiIn BETWEEN 50 AND 29 ORDER BY DayOfWeek LIMIT 17"]}
{"sql":"SELECT CRSElapsedTime, OriginAirportID, COUNT(*) FROM mytable WHERE ActualElapsedTime <= 336 OR CRSDepTime = 1747 AND OriginCityName BETWEEN 'Mammoth Lakes, CA' AND 'Phoenix, AZ' GROUP BY CRSElapsedTime, OriginAirportID  ORDER BY CRSElapsedTime, OriginAirportID LIMIT 4","hsqls":["SELECT CRSElapsedTime, OriginAirportID, COUNT(*) FROM mytable WHERE ActualElapsedTime <= 336 OR CRSDepTime = 1747 AND OriginCityName BETWEEN 'Mammoth Lakes, CA' AND 'Phoenix, AZ' GROUP BY CRSElapsedTime, OriginAirportID  ORDER BY CRSElapsedTime, OriginAirportID LIMIT 4"]}
{"sql":"SELECT ArrDelayMinutes, Origin, DestCityMarketID FROM mytable WHERE ArrTime BETWEEN 1810 AND 122 LIMIT 11"}
{"sql":"SELECT TaxiIn, TailNum FROM mytable WHERE Distance IN (765, 1303, 3365, 2173) AND DivArrDelay NOT IN (170, 132, 753, 274, 76) ORDER BY DepDelay, TailNum, DaysSinceEpoch LIMIT 2"}
{"sql":"SELECT TaxiIn, DivArrDelay FROM mytable ORDER BY DivReachedDest, LateAircraftDelay, FlightDate LIMIT 26"}
{"sql":"SELECT FirstDepTime, ActualElapsedTime FROM mytable WHERE OriginCityMarketID <> 33933 AND TotalAddGTime BETWEEN 13 AND 39 LIMIT 18"}
{"sql":"SELECT OriginStateFips, WheelsOn FROM mytable LIMIT 14"}
{"sql":"SELECT DistanceGroup, CRSArrTime, OriginWac FROM mytable WHERE Diverted BETWEEN 1 AND 1 ORDER BY OriginCityMarketID LIMIT 22"}
{"sql":"SELECT OriginCityName FROM mytable ORDER BY ArrDel15 LIMIT 3"}
{"sql":"SELECT FlightNum, Dest, SUM(\"Month\") FROM mytable GROUP BY FlightNum, Dest LIMIT 18","hsqls":["SELECT FlightNum, Dest, SUM(`Month`) FROM mytable GROUP BY FlightNum, Dest LIMIT 18"]}
{"sql":"SELECT SUM(WheelsOff), SUM(CRSArrTime), SUM(DestStateFips) FROM mytable LIMIT 11"}
{"sql":"SELECT DestState, WeatherDelay FROM mytable WHERE Flights BETWEEN 1 AND 1 AND DayOfWeek >= 4 OR Carrier BETWEEN 'F9' AND 'WN' ORDER BY FlightNum, OriginCityName, ArrTime LIMIT 28"}
{"sql":"SELECT ArrDelayMinutes, SUM(Flights) FROM mytable WHERE DivTotalGTimes IN (20, 70, 13, 84, 38) OR CRSArrTime NOT IN (1708, 1043, 918, 1839, 1604) OR OriginAirportID BETWEEN 12016 AND 11537 GROUP BY ArrDelayMinutes LIMIT 24","hsqls":["SELECT ArrDelayMinutes, SUM(Flights) FROM mytable WHERE (DivTotalGTimes[1] IN (20, 70, 13, 84, 38) OR DivTotalGTimes[2] IN (20, 70, 13, 84, 38) OR DivTotalGTimes[3] IN (20, 70, 13, 84, 38) OR DivTotalGTimes[4] IN (20, 70, 13, 84, 38) OR DivTotalGTimes[5] IN (20, 70, 13, 84, 38)) OR CRSArrTime NOT IN (1708, 1043, 918, 1839, 1604) OR OriginAirportID BETWEEN 12016 AND 11537 GROUP BY ArrDelayMinutes LIMIT 10000"]}
{"sql":"SELECT DepTime FROM mytable WHERE DivAirports IN ('JAN', 'SJC', 'AEX', 'PUB', 'TUL') OR NASDelay IN (21, 7, 100) AND ArrivalDelayGroups IN (3, 9) ORDER BY CRSArrTime LIMIT 4","hsqls":["SELECT DepTime FROM mytable WHERE (DivAirports[1] IN ('JAN', 'SJC', 'AEX', 'PUB', 'TUL') OR DivAirports[2] IN ('JAN', 'SJC', 'AEX', 'PUB', 'TUL') OR DivAirports[3] IN ('JAN', 'SJC', 'AEX', 'PUB', 'TUL') OR DivAirports[4] IN ('JAN', 'SJC', 'AEX', 'PUB', 'TUL') OR DivAirports[5] IN ('JAN', 'SJC', 'AEX', 'PUB', 'TUL')) OR NASDelay IN (21, 7, 100) AND ArrivalDelayGroups IN (3, 9) ORDER BY CRSArrTime LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, LongestAddGTime, Cancelled, MIN(OriginCityMarketID) FROM mytable WHERE OriginAirportID <> 13204 OR DepTimeBlk >= '0600-0659' GROUP BY DivReachedDest, LongestAddGTime, Cancelled  ORDER BY DivReachedDest, LongestAddGTime, Cancelled LIMIT 10","hsqls":["SELECT DivReachedDest, LongestAddGTime, Cancelled, MIN(OriginCityMarketID) FROM mytable WHERE OriginAirportID <> 13204 OR DepTimeBlk >= '0600-0659' GROUP BY DivReachedDest, LongestAddGTime, Cancelled  ORDER BY DivReachedDest, LongestAddGTime, Cancelled LIMIT 10"]}
{"sql":"SELECT LateAircraftDelay, WeatherDelay, ArrTime, COUNT(*) FROM mytable WHERE ArrDelay = 307.0 GROUP BY LateAircraftDelay, WeatherDelay, ArrTime  ORDER BY LateAircraftDelay, WeatherDelay, ArrTime LIMIT 24","hsqls":["SELECT LateAircraftDelay, WeatherDelay, ArrTime, COUNT(*) FROM mytable WHERE ArrDelay = 307.0 GROUP BY LateAircraftDelay, WeatherDelay, ArrTime  ORDER BY LateAircraftDelay, WeatherDelay, ArrTime LIMIT 24"]}
{"sql":"SELECT DivArrDelay, MIN(FlightNum) FROM mytable WHERE CarrierDelay IN (49, 67, 463, 70, 81) GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 2","hsqls":["SELECT DivArrDelay, MIN(FlightNum) FROM mytable WHERE CarrierDelay IN (49, 67, 463, 70, 81) GROUP BY DivArrDelay  ORDER BY DivArrDelay LIMIT 2"]}
{"sql":"SELECT ArrDelayMinutes, AVG(WeatherDelay), MIN(DepartureDelayGroups) FROM mytable WHERE Origin IN ('HOU', 'CRW') AND DestWac = 61 GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 21","hsqls":["SELECT ArrDelayMinutes, AVG(WeatherDelay), MIN(DepartureDelayGroups) FROM mytable WHERE Origin IN ('HOU', 'CRW') AND DestWac = 61 GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 21"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE OriginCityName IN ('Green Bay, WI') OR Diverted BETWEEN 0 AND 0 OR WheelsOn > 2334 LIMIT 16","hsqls":["SELECT DivWheelsOns FROM mytable WHERE OriginCityName IN ('Green Bay, WI') OR Diverted BETWEEN 0 AND 0 OR WheelsOn > 2334 LIMIT 10000"]}
{"sql":"SELECT AirlineID, SUM(DistanceGroup), MIN(DestAirportSeqID) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 21","hsqls":["SELECT AirlineID, SUM(DistanceGroup), MIN(DestAirportSeqID) FROM mytable GROUP BY AirlineID  ORDER BY AirlineID LIMIT 21"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE AirlineID = 21171 AND SecurityDelay BETWEEN 18 AND 18 AND OriginStateFips NOT IN (55, 15, 54, 26, 29) LIMIT 22"}
{"sql":"SELECT DivDistance, TaxiIn, COUNT(DepTime) FROM mytable WHERE DepTime = 1045 GROUP BY DivDistance, TaxiIn  ORDER BY DivDistance, TaxiIn LIMIT 12","hsqls":["SELECT DivDistance, TaxiIn, COUNT(DepTime) FROM mytable WHERE DepTime = 1045 GROUP BY DivDistance, TaxiIn  ORDER BY DivDistance, TaxiIn LIMIT 12"]}
{"sql":"SELECT LateAircraftDelay FROM mytable WHERE TaxiIn NOT IN (79, 96, 44, 75, 50) OR \"Year\" IN (2014) LIMIT 21","hsqls":["SELECT LateAircraftDelay FROM mytable WHERE TaxiIn NOT IN (79, 96, 44, 75, 50) OR `Year` IN (2014) LIMIT 21"]}
{"sql":"SELECT MAX(OriginAirportID), COUNT(WheelsOff), COUNT(TailNum) FROM mytable LIMIT 12"}
{"sql":"SELECT FirstDepTime, OriginStateFips, SUM(DistanceGroup) FROM mytable WHERE DestCityName NOT IN ('Mobile, AL') OR DivTailNums < 'N183UW' AND DestCityName <= 'Milwaukee, WI' GROUP BY FirstDepTime, OriginStateFips LIMIT 26","hsqls":["SELECT FirstDepTime, OriginStateFips, SUM(DistanceGroup) FROM mytable WHERE DestCityName NOT IN ('Mobile, AL') OR (DivTailNums[1] < 'N183UW' OR DivTailNums[2] < 'N183UW' OR DivTailNums[3] < 'N183UW' OR DivTailNums[4] < 'N183UW' OR DivTailNums[5] < 'N183UW') AND DestCityName <= 'Milwaukee, WI' GROUP BY FirstDepTime, OriginStateFips LIMIT 10000"]}
{"sql":"SELECT OriginStateFips, DivActualElapsedTime FROM mytable WHERE TaxiIn = 4 ORDER BY OriginState, OriginCityName LIMIT 22"}
{"sql":"SELECT DestStateName FROM mytable WHERE OriginAirportID BETWEEN 11996 AND 14576 OR \"Month\" NOT IN (1) OR DivReachedDest BETWEEN -9999 AND -9999 LIMIT 2","hsqls":["SELECT DestStateName FROM mytable WHERE OriginAirportID BETWEEN 11996 AND 14576 OR `Month` NOT IN (1) OR DivReachedDest BETWEEN -9999 AND -9999 LIMIT 2"]}
{"sql":"SELECT COUNT(CRSElapsedTime) FROM mytable WHERE DivWheelsOffs BETWEEN 1257 AND 325 AND DestState IN ('LA', 'MS') AND \"Month\" BETWEEN 1 AND 1 LIMIT 6","hsqls":["SELECT COUNT(CRSElapsedTime) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1257 AND 325 OR DivWheelsOffs[2] BETWEEN 1257 AND 325 OR DivWheelsOffs[3] BETWEEN 1257 AND 325 OR DivWheelsOffs[4] BETWEEN 1257 AND 325 OR DivWheelsOffs[5] BETWEEN 1257 AND 325) AND DestState IN ('LA', 'MS') AND `Month` BETWEEN 1 AND 1 LIMIT 10000"]}
{"sql":"SELECT \"Year\", DepDelayMinutes, MIN(DepDelayMinutes), SUM(DivDistance) FROM mytable WHERE \"Month\" IN (1) AND DaysSinceEpoch > 16093 AND Distance BETWEEN 1379 AND 1585 GROUP BY \"Year\", DepDelayMinutes LIMIT 11","hsqls":["SELECT Year, DepDelayMinutes, MIN(DepDelayMinutes), SUM(DivDistance) FROM mytable WHERE `Month` IN (1) AND DaysSinceEpoch > 16093 AND Distance BETWEEN 1379 AND 1585 GROUP BY Year, DepDelayMinutes LIMIT 11"]}
{"sql":"SELECT DivTailNums, CRSDepTime FROM mytable WHERE DepartureDelayGroups IN (6) ORDER BY DepDelay, TailNum LIMIT 20","hsqls":["SELECT DivTailNums, CRSDepTime FROM mytable WHERE DepartureDelayGroups IN (6) ORDER BY DepDelay, TailNum LIMIT 10000"]}
{"sql":"SELECT CarrierDelay, OriginWac FROM mytable ORDER BY CarrierDelay LIMIT 9"}
{"sql":"SELECT COUNT(TailNum) FROM mytable WHERE ArrDelay IN (90.0) AND DayofMonth >= 24 OR ArrivalDelayGroups <> 9 LIMIT 7"}
{"sql":"SELECT MIN(OriginAirportSeqID) FROM mytable WHERE TaxiOut IN (112, 23, 37) LIMIT 10"}
{"sql":"SELECT DepTime, OriginStateName, MAX(ArrTime) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 GROUP BY DepTime, OriginStateName LIMIT 28","hsqls":["SELECT DepTime, OriginStateName, MAX(ArrTime) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 GROUP BY DepTime, OriginStateName LIMIT 28"]}
{"sql":"SELECT Diverted FROM mytable WHERE DayOfWeek >= 2 AND Distance BETWEEN 1488 AND 1107 ORDER BY Distance LIMIT 3"}
{"sql":"SELECT WheelsOff, DivWheelsOns, ArrTimeBlk FROM mytable WHERE OriginAirportID <= 13796 ORDER BY DepartureDelayGroups, DepDel15 LIMIT 26","hsqls":["SELECT WheelsOff, DivWheelsOns, ArrTimeBlk FROM mytable WHERE OriginAirportID <= 13796 ORDER BY DepartureDelayGroups, DepDel15 LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, DivAirportLandings FROM mytable WHERE DestAirportID NOT IN (10739, 11884, 10930, 10728) OR DivTailNums BETWEEN 'N14168' AND 'N684DA' OR DestWac IN (5, 84) ORDER BY TaxiOut, OriginStateFips LIMIT 15","hsqls":["SELECT OriginCityMarketID, DivAirportLandings FROM mytable WHERE DestAirportID NOT IN (10739, 11884, 10930, 10728) OR (DivTailNums[1] BETWEEN 'N14168' AND 'N684DA' OR DivTailNums[2] BETWEEN 'N14168' AND 'N684DA' OR DivTailNums[3] BETWEEN 'N14168' AND 'N684DA' OR DivTailNums[4] BETWEEN 'N14168' AND 'N684DA' OR DivTailNums[5] BETWEEN 'N14168' AND 'N684DA') OR DestWac IN (5, 84) ORDER BY TaxiOut, OriginStateFips LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime, CRSElapsedTime FROM mytable ORDER BY DestWac, TailNum LIMIT 27"}
{"sql":"SELECT AVG(ArrDel15), COUNT(OriginWac) FROM mytable WHERE DaysSinceEpoch BETWEEN 16100 AND 16080 OR ActualElapsedTime NOT IN (47, 83) AND CRSArrTime < 553 LIMIT 17"}
{"sql":"SELECT DestWac FROM mytable WHERE CancellationCode = 'B' OR DestCityName BETWEEN 'International Falls, MN' AND 'Fayetteville, NC' ORDER BY OriginStateFips, OriginCityMarketID, DestAirportSeqID LIMIT 24"}
{"sql":"SELECT DivAirports, ArrivalDelayGroups FROM mytable WHERE ArrTime NOT IN (1653, 2220, 1545) ORDER BY DivActualElapsedTime LIMIT 24","hsqls":["SELECT DivAirports, ArrivalDelayGroups FROM mytable WHERE ArrTime NOT IN (1653, 2220, 1545) ORDER BY DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT AirTime FROM mytable WHERE DestState BETWEEN 'NE' AND 'IL' AND Diverted BETWEEN 1 AND 1 OR DaysSinceEpoch IN (16088, 16086) ORDER BY WeatherDelay LIMIT 23"}
{"sql":"SELECT OriginCityMarketID, Distance, DestCityName, MAX(FirstDepTime) FROM mytable WHERE DestAirportID BETWEEN 10155 AND 11049 AND TaxiOut <= 3 GROUP BY OriginCityMarketID, Distance, DestCityName  ORDER BY OriginCityMarketID, Distance, DestCityName LIMIT 27","hsqls":["SELECT OriginCityMarketID, Distance, DestCityName, MAX(FirstDepTime) FROM mytable WHERE DestAirportID BETWEEN 10155 AND 11049 AND TaxiOut <= 3 GROUP BY OriginCityMarketID, Distance, DestCityName  ORDER BY OriginCityMarketID, Distance, DestCityName LIMIT 27"]}
{"sql":"SELECT OriginCityMarketID, CRSArrTime, Cancelled, AVG(Diverted), AVG(ArrivalDelayGroups) FROM mytable WHERE DayOfWeek BETWEEN 5 AND 2 AND DivDistance IN (190, 602) GROUP BY OriginCityMarketID, CRSArrTime, Cancelled  ORDER BY OriginCityMarketID, CRSArrTime, Cancelled LIMIT 22","hsqls":["SELECT OriginCityMarketID, CRSArrTime, Cancelled, AVG(Diverted), AVG(ArrivalDelayGroups) FROM mytable WHERE DayOfWeek BETWEEN 5 AND 2 AND DivDistance IN (190, 602) GROUP BY OriginCityMarketID, CRSArrTime, Cancelled  ORDER BY OriginCityMarketID, CRSArrTime, Cancelled LIMIT 22"]}
{"sql":"SELECT OriginCityMarketID FROM mytable WHERE DestCityName BETWEEN 'Gainesville, FL' AND 'Portland, OR' AND ArrDel15 IN (1, 0, -9999) ORDER BY DestAirportID, DaysSinceEpoch LIMIT 25"}
{"sql":"SELECT AVG(DestAirportSeqID), COUNT(DivAirportLandings) FROM mytable WHERE DepartureDelayGroups = 12 OR DivDistance BETWEEN 632 AND 804 LIMIT 24"}
{"sql":"SELECT MAX(DepDelay) FROM mytable WHERE Carrier NOT IN ('WN', 'HA', 'US') AND Distance = 1814 LIMIT 22"}
{"sql":"SELECT LongestAddGTime, Origin, DayofMonth, AVG(TaxiOut), SUM(TaxiIn) FROM mytable GROUP BY LongestAddGTime, Origin, DayofMonth  ORDER BY LongestAddGTime, Origin, DayofMonth LIMIT 7","hsqls":["SELECT LongestAddGTime, Origin, DayofMonth, AVG(TaxiOut), SUM(TaxiIn) FROM mytable GROUP BY LongestAddGTime, Origin, DayofMonth  ORDER BY LongestAddGTime, Origin, DayofMonth LIMIT 7"]}
{"sql":"SELECT Diverted, Carrier, DepTime, COUNT(*) FROM mytable GROUP BY Diverted, Carrier, DepTime  ORDER BY Diverted, Carrier, DepTime LIMIT 15","hsqls":["SELECT Diverted, Carrier, DepTime, COUNT(*) FROM mytable GROUP BY Diverted, Carrier, DepTime  ORDER BY Diverted, Carrier, DepTime LIMIT 15"]}
{"sql":"SELECT DivReachedDest, CancellationCode, DivArrDelay, COUNT(*) FROM mytable WHERE Quarter NOT IN (1) GROUP BY DivReachedDest, CancellationCode, DivArrDelay  ORDER BY DivReachedDest, CancellationCode, DivArrDelay LIMIT 7","hsqls":["SELECT DivReachedDest, CancellationCode, DivArrDelay, COUNT(*) FROM mytable WHERE Quarter NOT IN (1) GROUP BY DivReachedDest, CancellationCode, DivArrDelay  ORDER BY DivReachedDest, CancellationCode, DivArrDelay LIMIT 7"]}
{"sql":"SELECT MIN(TotalAddGTime), COUNT(ArrDel15) FROM mytable LIMIT 12"}
{"sql":"SELECT MIN(DepDelayMinutes), MIN(OriginCityMarketID) FROM mytable WHERE DivWheelsOffs BETWEEN 849 AND 1758 OR OriginCityMarketID NOT IN (33044) OR DivDistance = 861 LIMIT 26","hsqls":["SELECT MIN(DepDelayMinutes), MIN(OriginCityMarketID)  FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 849 AND 1758 OR DivWheelsOffs[2] BETWEEN 849 AND 1758 OR DivWheelsOffs[3] BETWEEN 849 AND 1758 OR DivWheelsOffs[4] BETWEEN 849 AND 1758 OR DivWheelsOffs[5] BETWEEN 849 AND 1758) OR OriginCityMarketID NOT IN (33044) OR DivDistance = 861 LIMIT 10000"]}
{"sql":"SELECT Cancelled, DepTimeBlk, AirlineID FROM mytable WHERE DepTime >= 2314 OR AirTime < 242 ORDER BY OriginAirportSeqID, AirTime, DivActualElapsedTime LIMIT 25"}
{"sql":"SELECT Diverted, FlightDate, DayOfWeek FROM mytable WHERE DivActualElapsedTime >= 102 LIMIT 28"}
{"sql":"SELECT Quarter, ArrDelay, OriginStateName, SUM(DepDelayMinutes), AVG(DepDelay) FROM mytable WHERE ArrDel15 = 0 GROUP BY Quarter, ArrDelay, OriginStateName  ORDER BY Quarter, ArrDelay, OriginStateName LIMIT 5","hsqls":["SELECT Quarter, ArrDelay, OriginStateName, SUM(DepDelayMinutes), AVG(DepDelay) FROM mytable WHERE ArrDel15 = 0 GROUP BY Quarter, ArrDelay, OriginStateName  ORDER BY Quarter, ArrDelay, OriginStateName LIMIT 5"]}
{"sql":"SELECT \"Year\", DayofMonth FROM mytable WHERE DestAirportID BETWEEN 10155 AND 13127 ORDER BY DistanceGroup, OriginCityMarketID, DestAirportID LIMIT 17","hsqls":["SELECT Year, DayofMonth FROM mytable WHERE DestAirportID BETWEEN 10155 AND 13127 ORDER BY DistanceGroup, OriginCityMarketID, DestAirportID LIMIT 17"]}
{"sql":"SELECT Diverted, TaxiIn FROM mytable WHERE OriginAirportSeqID <= 1324402 AND ArrDelayMinutes BETWEEN 100.0 AND 130.0 AND OriginStateFips >= 4 ORDER BY OriginCityMarketID, DestCityMarketID LIMIT 10"}
{"sql":"SELECT DestAirportID, MIN(CRSArrTime) FROM mytable WHERE DepTime IN (2256, 1222, 918, 1720, 1358) OR Carrier NOT IN ('B6', 'UA', 'VX') GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 23","hsqls":["SELECT DestAirportID, MIN(CRSArrTime) FROM mytable WHERE DepTime IN (2256, 1222, 918, 1720, 1358) OR Carrier NOT IN ('B6', 'UA', 'VX') GROUP BY DestAirportID  ORDER BY DestAirportID LIMIT 23"]}
{"sql":"SELECT DepDel15, Origin FROM mytable WHERE ArrDelayMinutes BETWEEN 138.0 AND 315.0 AND Dest BETWEEN 'MKE' AND 'STX' ORDER BY Quarter LIMIT 9"}
{"sql":"SELECT ArrTimeBlk, CancellationCode, OriginStateName FROM mytable WHERE DivReachedDest BETWEEN -9999 AND 0 ORDER BY ArrDelayMinutes, DaysSinceEpoch LIMIT 10"}
{"sql":"SELECT OriginStateFips, DepTime FROM mytable WHERE LateAircraftDelay BETWEEN 2 AND 108 OR ArrDelay NOT IN (50.0, 117.0) OR DivWheelsOffs IN (955, 1919, 2010, 1126) ORDER BY OriginStateFips LIMIT 22","hsqls":["SELECT OriginStateFips, DepTime FROM mytable WHERE LateAircraftDelay BETWEEN 2 AND 108 OR ArrDelay NOT IN (50.0, 117.0) OR (DivWheelsOffs[1] IN (955, 1919, 2010, 1126) OR DivWheelsOffs[2] IN (955, 1919, 2010, 1126) OR DivWheelsOffs[3] IN (955, 1919, 2010, 1126) OR DivWheelsOffs[4] IN (955, 1919, 2010, 1126) OR DivWheelsOffs[5] IN (955, 1919, 2010, 1126)) ORDER BY OriginStateFips LIMIT 10000"]}
{"sql":"SELECT Flights, AirlineID FROM mytable WHERE DestWac NOT IN (1, 91, 83, 86) AND DestWac IN (43) ORDER BY DivDistance, DepTime, ArrTime LIMIT 21"}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE Distance <> 1157 ORDER BY DepDelay, Carrier, DivAirportLandings LIMIT 11","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE Distance <> 1157 ORDER BY DepDelay, Carrier, DivAirportLandings LIMIT 10000"]}
{"sql":"SELECT WeatherDelay FROM mytable WHERE WeatherDelay >= 138 ORDER BY OriginStateFips, ArrDelayMinutes, DestAirportID LIMIT 7"}
{"sql":"SELECT SUM(NASDelay) FROM mytable LIMIT 15"}
{"sql":"SELECT SecurityDelay, COUNT(CRSDepTime), MAX(DayofMonth) FROM mytable GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 15","hsqls":["SELECT SecurityDelay, COUNT(CRSDepTime), MAX(DayofMonth) FROM mytable GROUP BY SecurityDelay  ORDER BY SecurityDelay LIMIT 15"]}
{"sql":"SELECT ArrDelay FROM mytable ORDER BY WheelsOff, DayOfWeek LIMIT 26"}
{"sql":"SELECT Origin, COUNT(*) FROM mytable GROUP BY Origin  ORDER BY Origin LIMIT 29","hsqls":["SELECT Origin, COUNT(*) FROM mytable GROUP BY Origin  ORDER BY Origin LIMIT 29"]}
{"sql":"SELECT WeatherDelay, OriginCityName, ArrTimeBlk FROM mytable WHERE TotalAddGTime BETWEEN 30 AND 31 ORDER BY FirstDepTime, NASDelay, AirlineID LIMIT 8"}
{"sql":"SELECT OriginCityName, ArrivalDelayGroups FROM mytable WHERE TaxiOut BETWEEN 38 AND 62 LIMIT 11"}
{"sql":"SELECT DepDelayMinutes, ArrDelayMinutes, ArrDelay, COUNT(*) FROM mytable WHERE DivDistance NOT IN (204) AND DestAirportID BETWEEN 14869 AND 11503 GROUP BY DepDelayMinutes, ArrDelayMinutes, ArrDelay  ORDER BY DepDelayMinutes, ArrDelayMinutes, ArrDelay LIMIT 10","hsqls":["SELECT DepDelayMinutes, ArrDelayMinutes, ArrDelay, COUNT(*) FROM mytable WHERE DivDistance NOT IN (204) AND DestAirportID BETWEEN 14869 AND 11503 GROUP BY DepDelayMinutes, ArrDelayMinutes, ArrDelay  ORDER BY DepDelayMinutes, ArrDelayMinutes, ArrDelay LIMIT 10"]}
{"sql":"SELECT Origin, CRSDepTime, COUNT(OriginAirportID), AVG(SecurityDelay), MAX(CRSElapsedTime) FROM mytable WHERE DestCityName NOT IN ('Huntsville, AL', 'Grand Junction, CO', 'Tampa, FL', 'New York, NY', 'St. George, UT') GROUP BY Origin, CRSDepTime  ORDER BY Origin, CRSDepTime LIMIT 27","hsqls":["SELECT Origin, CRSDepTime, COUNT(OriginAirportID), AVG(SecurityDelay), MAX(CRSElapsedTime) FROM mytable WHERE DestCityName NOT IN ('Huntsville, AL', 'Grand Junction, CO', 'Tampa, FL', 'New York, NY', 'St. George, UT') GROUP BY Origin, CRSDepTime  ORDER BY Origin, CRSDepTime LIMIT 27"]}
{"sql":"SELECT TaxiOut, DayofMonth, COUNT(*) FROM mytable WHERE OriginCityMarketID < 30141 AND AirlineID BETWEEN 20398 AND 20437 GROUP BY TaxiOut, DayofMonth  ORDER BY TaxiOut, DayofMonth LIMIT 29","hsqls":["SELECT TaxiOut, DayofMonth, COUNT(*) FROM mytable WHERE OriginCityMarketID < 30141 AND AirlineID BETWEEN 20398 AND 20437 GROUP BY TaxiOut, DayofMonth  ORDER BY TaxiOut, DayofMonth LIMIT 29"]}
{"sql":"SELECT LongestAddGTime, NASDelay, DivTailNums FROM mytable WHERE Origin NOT IN ('EYW', 'ACV', 'APN') LIMIT 29","hsqls":["SELECT LongestAddGTime, NASDelay, DivTailNums FROM mytable WHERE Origin NOT IN ('EYW', 'ACV', 'APN') LIMIT 10000"]}
{"sql":"SELECT ArrDelay, COUNT(*) FROM mytable WHERE DepDelay >= -14.0 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 11","hsqls":["SELECT ArrDelay, COUNT(*) FROM mytable WHERE DepDelay >= -14.0 GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 11"]}
{"sql":"SELECT TaxiOut, CarrierDelay, Origin FROM mytable WHERE CRSDepTime BETWEEN 922 AND 752 OR \"Month\" BETWEEN 1 AND 1 ORDER BY DayofMonth, DivArrDelay LIMIT 12","hsqls":["SELECT TaxiOut, CarrierDelay, Origin FROM mytable WHERE CRSDepTime BETWEEN 922 AND 752 OR `Month` BETWEEN 1 AND 1 ORDER BY DayofMonth, DivArrDelay LIMIT 12"]}
{"sql":"SELECT DivDistance, ArrDelayMinutes FROM mytable WHERE DestAirportSeqID <= 1584102 OR ArrDel15 IN (1, 0, -9999) AND Diverted NOT IN (1, 0) ORDER BY AirTime LIMIT 14"}
{"sql":"SELECT DestCityMarketID, SUM(DivDistance) FROM mytable WHERE WheelsOff BETWEEN 735 AND 921 GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 4","hsqls":["SELECT DestCityMarketID, SUM(DivDistance) FROM mytable WHERE WheelsOff BETWEEN 735 AND 921 GROUP BY DestCityMarketID  ORDER BY DestCityMarketID LIMIT 4"]}
{"sql":"SELECT DivReachedDest, DayofMonth, AVG(DepDelay), SUM(DaysSinceEpoch), AVG(CRSArrTime) FROM mytable GROUP BY DivReachedDest, DayofMonth  ORDER BY DivReachedDest, DayofMonth LIMIT 19","hsqls":["SELECT DivReachedDest, DayofMonth, AVG(DepDelay), SUM(DaysSinceEpoch), AVG(CRSArrTime) FROM mytable GROUP BY DivReachedDest, DayofMonth  ORDER BY DivReachedDest, DayofMonth LIMIT 19"]}
{"sql":"SELECT LongestAddGTime, SecurityDelay, CancellationCode FROM mytable WHERE WeatherDelay > 234 ORDER BY DepTime, DestCityMarketID, CRSDepTime LIMIT 24"}
{"sql":"SELECT OriginAirportSeqID, DestAirportSeqID, DestCityMarketID, COUNT(*) FROM mytable WHERE DestAirportID < 10631 GROUP BY OriginAirportSeqID, DestAirportSeqID, DestCityMarketID  ORDER BY OriginAirportSeqID, DestAirportSeqID, DestCityMarketID LIMIT 7","hsqls":["SELECT OriginAirportSeqID, DestAirportSeqID, DestCityMarketID, COUNT(*) FROM mytable WHERE DestAirportID < 10631 GROUP BY OriginAirportSeqID, DestAirportSeqID, DestCityMarketID  ORDER BY OriginAirportSeqID, DestAirportSeqID, DestCityMarketID LIMIT 7"]}
{"sql":"SELECT DestWac, LongestAddGTime, DivAirportLandings FROM mytable WHERE Diverted IN (0) LIMIT 20"}
{"sql":"SELECT AVG(LongestAddGTime), AVG(TaxiOut), MIN(TotalAddGTime) FROM mytable WHERE DepartureDelayGroups >= -9999 LIMIT 1"}
{"sql":"SELECT OriginWac, DayofMonth, \"Month\" FROM mytable WHERE DayOfWeek BETWEEN 2 AND 3 ORDER BY OriginState LIMIT 25","hsqls":["SELECT OriginWac, DayofMonth, `Month` FROM mytable WHERE DayOfWeek BETWEEN 2 AND 3 ORDER BY OriginState LIMIT 25"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 21"}
{"sql":"SELECT DestStateName, DepTimeBlk, AVG(ArrDelay), SUM(DaysSinceEpoch), COUNT(DepTime) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND OriginStateFips BETWEEN 44 AND 55 GROUP BY DestStateName, DepTimeBlk LIMIT 14","hsqls":["SELECT DestStateName, DepTimeBlk, AVG(ArrDelay), SUM(DaysSinceEpoch), COUNT(DepTime) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND OriginStateFips BETWEEN 44 AND 55 GROUP BY DestStateName, DepTimeBlk LIMIT 14"]}
{"sql":"SELECT LateAircraftDelay, WeatherDelay FROM mytable WHERE LongestAddGTime > 2 ORDER BY FlightDate LIMIT 25"}
{"sql":"SELECT WheelsOn FROM mytable WHERE DivReachedDest IN (0, -9999) OR ArrDelayMinutes <> 61.0 LIMIT 16"}
{"sql":"SELECT FlightDate, TotalAddGTime, DepTime FROM mytable WHERE ArrDelayMinutes NOT IN (132.0, 159.0) AND DepTimeBlk BETWEEN '1800-1859' AND '0600-0659' AND OriginStateName <= 'New Hampshire' ORDER BY DivArrDelay"}
{"sql":"SELECT DepDel15, AirlineID, MIN(WeatherDelay), AVG(TaxiIn), SUM(ArrTime) FROM mytable WHERE OriginWac >= 83 OR DaysSinceEpoch < 16093 GROUP BY DepDel15, AirlineID  ORDER BY DepDel15, AirlineID LIMIT 27","hsqls":["SELECT DepDel15, AirlineID, MIN(WeatherDelay), AVG(TaxiIn), SUM(ArrTime) FROM mytable WHERE OriginWac >= 83 OR DaysSinceEpoch < 16093 GROUP BY DepDel15, AirlineID  ORDER BY DepDel15, AirlineID LIMIT 27"]}
{"sql":"SELECT LongestAddGTime, Cancelled, COUNT(*) FROM mytable WHERE TaxiIn BETWEEN 3 AND 56 GROUP BY LongestAddGTime, Cancelled  ORDER BY LongestAddGTime, Cancelled LIMIT 7","hsqls":["SELECT LongestAddGTime, Cancelled, COUNT(*) FROM mytable WHERE TaxiIn BETWEEN 3 AND 56 GROUP BY LongestAddGTime, Cancelled  ORDER BY LongestAddGTime, Cancelled LIMIT 7"]}
{"sql":"SELECT DestCityMarketID FROM mytable WHERE CarrierDelay BETWEEN 123 AND 123 OR DivTailNums BETWEEN 'N8621A' AND 'N952WN' AND DivWheelsOns IN (1119, 1841, 2038, 1402, 1118) ORDER BY DayofMonth LIMIT 28","hsqls":["SELECT DestCityMarketID FROM mytable WHERE CarrierDelay BETWEEN 123 AND 123 OR (DivTailNums[1] BETWEEN 'N8621A' AND 'N952WN' OR DivTailNums[2] BETWEEN 'N8621A' AND 'N952WN' OR DivTailNums[3] BETWEEN 'N8621A' AND 'N952WN' OR DivTailNums[4] BETWEEN 'N8621A' AND 'N952WN' OR DivTailNums[5] BETWEEN 'N8621A' AND 'N952WN') AND (DivWheelsOns[1] IN (1119, 1841, 2038, 1402, 1118) OR DivWheelsOns[2] IN (1119, 1841, 2038, 1402, 1118) OR DivWheelsOns[3] IN (1119, 1841, 2038, 1402, 1118) OR DivWheelsOns[4] IN (1119, 1841, 2038, 1402, 1118) OR DivWheelsOns[5] IN (1119, 1841, 2038, 1402, 1118)) ORDER BY DayofMonth LIMIT 10000"]}
{"sql":"SELECT MIN(WheelsOn), MIN(ActualElapsedTime), AVG(OriginAirportID) FROM mytable LIMIT 1"}
{"sql":"SELECT DestAirportSeqID, Origin, DepTimeBlk, AVG(NASDelay), MIN(DivReachedDest) FROM mytable WHERE FirstDepTime BETWEEN 908 AND 1301 OR FlightDate BETWEEN '2014-01-20' AND '2014-01-16' OR WeatherDelay IN (3, 35, 52, 27, 271) GROUP BY DestAirportSeqID, Origin, DepTimeBlk  ORDER BY DestAirportSeqID, Origin, DepTimeBlk LIMIT 4","hsqls":["SELECT DestAirportSeqID, Origin, DepTimeBlk, AVG(NASDelay), MIN(DivReachedDest) FROM mytable WHERE FirstDepTime BETWEEN 908 AND 1301 OR FlightDate BETWEEN '2014-01-20' AND '2014-01-16' OR WeatherDelay IN (3, 35, 52, 27, 271) GROUP BY DestAirportSeqID, Origin, DepTimeBlk  ORDER BY DestAirportSeqID, Origin, DepTimeBlk LIMIT 4"]}
{"sql":"SELECT SUM(Diverted), MAX(DivReachedDest) FROM mytable WHERE DestState BETWEEN 'AZ' AND 'GA' OR TailNum IN ('N341NB') OR Dest <> 'RNO' LIMIT 21"}
{"sql":"SELECT Diverted, CarrierDelay, OriginWac, AVG(FlightNum), COUNT(Diverted), MIN(CarrierDelay) FROM mytable GROUP BY Diverted, CarrierDelay, OriginWac  ORDER BY Diverted, CarrierDelay, OriginWac LIMIT 26","hsqls":["SELECT Diverted, CarrierDelay, OriginWac, AVG(FlightNum), COUNT(Diverted), MIN(CarrierDelay) FROM mytable GROUP BY Diverted, CarrierDelay, OriginWac  ORDER BY Diverted, CarrierDelay, OriginWac LIMIT 26"]}
{"sql":"SELECT CRSDepTime, MIN(DivActualElapsedTime), MIN(Quarter) FROM mytable WHERE OriginCityMarketID BETWEEN 34986 AND 32945 OR DestStateFips NOT IN (20, 19, 40, 13, 27) GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 2","hsqls":["SELECT CRSDepTime, MIN(DivActualElapsedTime), MIN(Quarter) FROM mytable WHERE OriginCityMarketID BETWEEN 34986 AND 32945 OR DestStateFips NOT IN (20, 19, 40, 13, 27) GROUP BY CRSDepTime  ORDER BY CRSDepTime LIMIT 2"]}
{"sql":"SELECT OriginStateFips, LateAircraftDelay, Origin, MIN(DepDelayMinutes), SUM(ArrDelay), MAX(OriginAirportID) FROM mytable WHERE DestState IN ('VI', 'WA', 'AZ', 'NJ') AND ArrDelayMinutes = 78.0 GROUP BY OriginStateFips, LateAircraftDelay, Origin  ORDER BY OriginStateFips, LateAircraftDelay, Origin LIMIT 10","hsqls":["SELECT OriginStateFips, LateAircraftDelay, Origin, MIN(DepDelayMinutes), SUM(ArrDelay), MAX(OriginAirportID) FROM mytable WHERE DestState IN ('VI', 'WA', 'AZ', 'NJ') AND ArrDelayMinutes = 78.0 GROUP BY OriginStateFips, LateAircraftDelay, Origin  ORDER BY OriginStateFips, LateAircraftDelay, Origin LIMIT 10"]}
{"sql":"SELECT OriginStateFips, LongestAddGTime, Distance FROM mytable WHERE DayofMonth >= 6 OR DestStateFips > 28 ORDER BY \"Year\" LIMIT 13","hsqls":["SELECT OriginStateFips, LongestAddGTime, Distance FROM mytable WHERE DayofMonth >= 6 OR DestStateFips > 28 ORDER BY `Year` LIMIT 13"]}
{"sql":"SELECT LongestAddGTime FROM mytable WHERE DepDelay = 23.0 AND CRSDepTime >= 619 AND CRSDepTime BETWEEN 1955 AND 1448 ORDER BY Diverted, Cancelled LIMIT 26"}
{"sql":"SELECT TailNum FROM mytable WHERE Origin BETWEEN 'RAP' AND 'SGF' ORDER BY OriginCityMarketID LIMIT 11"}
{"sql":"SELECT Quarter, SUM(CarrierDelay), MAX(DivReachedDest) FROM mytable WHERE AirlineID = 19977 AND DayofMonth NOT IN (22, 23, 26, 14, 11) AND CRSElapsedTime BETWEEN 252 AND 87 GROUP BY Quarter  ORDER BY Quarter LIMIT 18","hsqls":["SELECT Quarter, SUM(CarrierDelay), MAX(DivReachedDest) FROM mytable WHERE AirlineID = 19977 AND DayofMonth NOT IN (22, 23, 26, 14, 11) AND CRSElapsedTime BETWEEN 252 AND 87 GROUP BY Quarter  ORDER BY Quarter LIMIT 18"]}
{"sql":"SELECT SUM(\"Year\"), MAX(DayofMonth), AVG(CRSArrTime) FROM mytable WHERE WheelsOff > 1737 AND DivTotalGTimes IN (30, 113, 102, 37) LIMIT 10","hsqls":["SELECT SUM(`Year`), MAX(DayofMonth), AVG(CRSArrTime)  FROM mytable WHERE WheelsOff > 1737 AND (DivTotalGTimes[1] IN (30, 113, 102, 37) OR DivTotalGTimes[2] IN (30, 113, 102, 37) OR DivTotalGTimes[3] IN (30, 113, 102, 37) OR DivTotalGTimes[4] IN (30, 113, 102, 37) OR DivTotalGTimes[5] IN (30, 113, 102, 37)) LIMIT 10000"]}
{"sql":"SELECT OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch, SUM(CRSElapsedTime) FROM mytable WHERE Cancelled <= 1 OR ArrDelay NOT IN (245.0, 193.0, 450.0) AND Distance > 1156 GROUP BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch  ORDER BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch LIMIT 26","hsqls":["SELECT OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch, SUM(CRSElapsedTime) FROM mytable WHERE Cancelled <= 1 OR ArrDelay NOT IN (245.0, 193.0, 450.0) AND Distance > 1156 GROUP BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch  ORDER BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch LIMIT 26"]}
{"sql":"SELECT WheelsOff, TaxiIn, WheelsOn, AVG(CRSDepTime) FROM mytable WHERE ArrivalDelayGroups BETWEEN 4 AND 3 OR DestAirportID IN (14252, 13422) OR Flights IN (1) GROUP BY WheelsOff, TaxiIn, WheelsOn","hsqls":["SELECT WheelsOff, TaxiIn, WheelsOn, AVG(CRSDepTime) FROM mytable WHERE ArrivalDelayGroups BETWEEN 4 AND 3 OR DestAirportID IN (14252, 13422) OR Flights IN (1) GROUP BY WheelsOff, TaxiIn, WheelsOn"]}
{"sql":"SELECT Dest, DestCityMarketID, COUNT(*) FROM mytable WHERE Quarter NOT IN (1) GROUP BY Dest, DestCityMarketID  ORDER BY Dest, DestCityMarketID LIMIT 29","hsqls":["SELECT Dest, DestCityMarketID, COUNT(*) FROM mytable WHERE Quarter NOT IN (1) GROUP BY Dest, DestCityMarketID  ORDER BY Dest, DestCityMarketID LIMIT 29"]}
{"sql":"SELECT DivWheelsOns, DestCityName, AirTime FROM mytable WHERE WeatherDelay NOT IN (6, 54, 973, 86, 237) AND TaxiIn = 113 ORDER BY CRSArrTime, DepDel15 LIMIT 17","hsqls":["SELECT DivWheelsOns, DestCityName, AirTime FROM mytable WHERE WeatherDelay NOT IN (6, 54, 973, 86, 237) AND TaxiIn = 113 ORDER BY CRSArrTime, DepDel15 LIMIT 10000"]}
{"sql":"SELECT DestState, COUNT(Cancelled) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 13","hsqls":["SELECT DestState, COUNT(Cancelled) FROM mytable GROUP BY DestState  ORDER BY DestState LIMIT 13"]}
{"sql":"SELECT Carrier, ArrDelay FROM mytable ORDER BY DivDistance, LongestAddGTime, UniqueCarrier LIMIT 22"}
{"sql":"SELECT DivAirports, Distance FROM mytable ORDER BY UniqueCarrier, CRSElapsedTime, OriginStateName LIMIT 13","hsqls":["SELECT DivAirports, Distance FROM mytable ORDER BY UniqueCarrier, CRSElapsedTime, OriginStateName LIMIT 10000"]}
{"sql":"SELECT WheelsOff, OriginCityName, \"Month\", AVG(DivReachedDest), MIN(ArrDelay) FROM mytable WHERE DepDel15 >= 0 GROUP BY WheelsOff, OriginCityName, \"Month\" LIMIT 27","hsqls":["SELECT WheelsOff, OriginCityName, Month, AVG(DivReachedDest), MIN(ArrDelay) FROM mytable WHERE DepDel15 >= 0 GROUP BY WheelsOff, OriginCityName, `Month` LIMIT 27"]}
{"sql":"SELECT NASDelay, DestCityName, DestStateName FROM mytable WHERE DestWac NOT IN (5, 4, 52, 72, 74) ORDER BY Dest, \"Month\" LIMIT 4","hsqls":["SELECT NASDelay, DestCityName, DestStateName FROM mytable WHERE DestWac NOT IN (5, 4, 52, 72, 74) ORDER BY Dest, `Month` LIMIT 4"]}
{"sql":"SELECT Flights, MAX(OriginCityMarketID), COUNT(OriginAirportID) FROM mytable WHERE DivTailNums IN ('N12126') GROUP BY Flights LIMIT 16","hsqls":["SELECT Flights, MAX(OriginCityMarketID), COUNT(OriginAirportID) FROM mytable WHERE (DivTailNums[1] IN ('N12126') OR DivTailNums[2] IN ('N12126') OR DivTailNums[3] IN ('N12126') OR DivTailNums[4] IN ('N12126') OR DivTailNums[5] IN ('N12126')) GROUP BY Flights LIMIT 10000"]}
{"sql":"SELECT WheelsOn, DaysSinceEpoch FROM mytable WHERE DestWac < 52 OR ArrDel15 > -9999 ORDER BY Carrier, Origin LIMIT 29"}
{"sql":"SELECT TaxiOut, OriginAirportSeqID, OriginAirportID, SUM(NASDelay), MIN(ActualElapsedTime) FROM mytable GROUP BY TaxiOut, OriginAirportSeqID, OriginAirportID  ORDER BY TaxiOut, OriginAirportSeqID, OriginAirportID LIMIT 1","hsqls":["SELECT TaxiOut, OriginAirportSeqID, OriginAirportID, SUM(NASDelay), MIN(ActualElapsedTime) FROM mytable GROUP BY TaxiOut, OriginAirportSeqID, OriginAirportID  ORDER BY TaxiOut, OriginAirportSeqID, OriginAirportID LIMIT 1"]}
{"sql":"SELECT SUM(AirlineID) FROM mytable WHERE DayOfWeek BETWEEN 5 AND 7 OR LateAircraftDelay NOT IN (102, 118) OR DistanceGroup BETWEEN 10 AND 6 LIMIT 1"}
{"sql":"SELECT OriginAirportSeqID, TaxiIn FROM mytable WHERE DivWheelsOns IN (1139, 2039) AND FlightDate >= '2014-01-01' ORDER BY DivArrDelay LIMIT 18","hsqls":["SELECT OriginAirportSeqID, TaxiIn FROM mytable WHERE (DivWheelsOns[1] IN (1139, 2039) OR DivWheelsOns[2] IN (1139, 2039) OR DivWheelsOns[3] IN (1139, 2039) OR DivWheelsOns[4] IN (1139, 2039) OR DivWheelsOns[5] IN (1139, 2039)) AND FlightDate >= '2014-01-01' ORDER BY DivArrDelay LIMIT 10000"]}
{"sql":"SELECT DestStateFips, COUNT(*) FROM mytable WHERE DaysSinceEpoch BETWEEN 16071 AND 16081 GROUP BY DestStateFips  ORDER BY DestStateFips LIMIT 22","hsqls":["SELECT DestStateFips, COUNT(*) FROM mytable WHERE DaysSinceEpoch BETWEEN 16071 AND 16081 GROUP BY DestStateFips  ORDER BY DestStateFips LIMIT 22"]}
{"sql":"SELECT WheelsOff, TotalAddGTime, SUM(OriginAirportSeqID), MAX(DestWac) FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'B' OR DayofMonth < 21 OR DivArrDelay BETWEEN 231 AND 1651 GROUP BY WheelsOff, TotalAddGTime  ORDER BY WheelsOff, TotalAddGTime LIMIT 27","hsqls":["SELECT WheelsOff, TotalAddGTime, SUM(OriginAirportSeqID), MAX(DestWac) FROM mytable WHERE CancellationCode BETWEEN 'C' AND 'B' OR DayofMonth < 21 OR DivArrDelay BETWEEN 231 AND 1651 GROUP BY WheelsOff, TotalAddGTime  ORDER BY WheelsOff, TotalAddGTime LIMIT 27"]}
{"sql":"SELECT DayofMonth, COUNT(DivArrDelay), SUM(DestAirportSeqID) FROM mytable WHERE DivArrDelay BETWEEN 126 AND 187 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 29","hsqls":["SELECT DayofMonth, COUNT(DivArrDelay), SUM(DestAirportSeqID) FROM mytable WHERE DivArrDelay BETWEEN 126 AND 187 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 29"]}
{"sql":"SELECT LateAircraftDelay, DivActualElapsedTime, AVG(DivReachedDest), MAX(ArrivalDelayGroups), AVG(WheelsOn) FROM mytable WHERE DivWheelsOffs BETWEEN 2329 AND 2010 AND ArrivalDelayGroups IN (-1) GROUP BY LateAircraftDelay, DivActualElapsedTime LIMIT 14","hsqls":["SELECT LateAircraftDelay, DivActualElapsedTime, AVG(DivReachedDest), MAX(ArrivalDelayGroups), AVG(WheelsOn) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 2329 AND 2010 OR DivWheelsOffs[2] BETWEEN 2329 AND 2010 OR DivWheelsOffs[3] BETWEEN 2329 AND 2010 OR DivWheelsOffs[4] BETWEEN 2329 AND 2010 OR DivWheelsOffs[5] BETWEEN 2329 AND 2010) AND ArrivalDelayGroups IN (-1) GROUP BY LateAircraftDelay, DivActualElapsedTime LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, ActualElapsedTime, CRSElapsedTime FROM mytable WHERE UniqueCarrier BETWEEN 'UA' AND 'MQ' AND DepTime <= 1344 AND DivLongestGTimes IN (49.0) ORDER BY WheelsOff, DistanceGroup, ArrDel15 LIMIT 10","hsqls":["SELECT FirstDepTime, ActualElapsedTime, CRSElapsedTime FROM mytable WHERE UniqueCarrier BETWEEN 'UA' AND 'MQ' AND DepTime <= 1344 AND (DivLongestGTimes[1] IN (49.0) OR DivLongestGTimes[2] IN (49.0) OR DivLongestGTimes[3] IN (49.0) OR DivLongestGTimes[4] IN (49.0) OR DivLongestGTimes[5] IN (49.0)) ORDER BY WheelsOff, DistanceGroup, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT OriginState, \"Month\" FROM mytable ORDER BY Distance, TotalAddGTime, ArrTime LIMIT 14","hsqls":["SELECT OriginState, `Month` FROM mytable ORDER BY Distance, TotalAddGTime, ArrTime LIMIT 14"]}
{"sql":"SELECT MAX(ArrDel15), COUNT(DestWac), AVG(WheelsOn) FROM mytable LIMIT 16"}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 2"}
{"sql":"SELECT DivReachedDest, Carrier, AVG(OriginAirportSeqID), MIN(DivArrDelay), SUM(DivActualElapsedTime) FROM mytable GROUP BY DivReachedDest, Carrier  ORDER BY DivReachedDest, Carrier LIMIT 19","hsqls":["SELECT DivReachedDest, Carrier, AVG(OriginAirportSeqID), MIN(DivArrDelay), SUM(DivActualElapsedTime) FROM mytable GROUP BY DivReachedDest, Carrier  ORDER BY DivReachedDest, Carrier LIMIT 19"]}
{"sql":"SELECT NASDelay, Origin, DayOfWeek FROM mytable WHERE FlightNum IN (1593, 1703, 2229, 5649) OR DestState <> 'GA' OR LongestAddGTime NOT IN (97, 42, 47, 40, 29) ORDER BY OriginAirportSeqID, DistanceGroup, FlightNum LIMIT 19"}
{"sql":"SELECT Origin, DivActualElapsedTime FROM mytable WHERE WheelsOn IN (1339) ORDER BY OriginState, DivAirportLandings, UniqueCarrier LIMIT 14"}
{"sql":"SELECT ArrDelayMinutes, DestCityName FROM mytable WHERE OriginWac NOT IN (21, 72) ORDER BY DivDistance, AirTime, \"Month\" LIMIT 7","hsqls":["SELECT ArrDelayMinutes, DestCityName FROM mytable WHERE OriginWac NOT IN (21, 72) ORDER BY DivDistance, AirTime, `Month` LIMIT 7"]}
{"sql":"SELECT FlightDate, AirTime FROM mytable WHERE DepTime BETWEEN 1208 AND 903 AND DestCityName BETWEEN 'Barrow, AK' AND 'Grand Island, NE' OR Carrier = 'MQ' ORDER BY Diverted, CarrierDelay LIMIT 4"}
{"sql":"SELECT DepDelay, DivAirportSeqIDs, DivActualElapsedTime FROM mytable WHERE DivAirportLandings IN (2, 1, 0, 9) AND OriginWac IN (1, 92, 31, 64, 74) ORDER BY Diverted, ArrDelay, OriginAirportID LIMIT 20","hsqls":["SELECT DepDelay, DivAirportSeqIDs, DivActualElapsedTime FROM mytable WHERE DivAirportLandings IN (2, 1, 0, 9) AND OriginWac IN (1, 92, 31, 64, 74) ORDER BY Diverted, ArrDelay, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT AVG(FirstDepTime), MIN(FirstDepTime) FROM mytable LIMIT 10"}
{"sql":"SELECT FlightNum FROM mytable WHERE UniqueCarrier IN ('EV', 'F9', 'WN', 'HA', 'FL') ORDER BY Distance, WheelsOn LIMIT 18"}
{"sql":"SELECT WheelsOff, AirTime, COUNT(*) FROM mytable WHERE DepDel15 IN (1, 0, -9999) GROUP BY WheelsOff, AirTime  ORDER BY WheelsOff, AirTime LIMIT 11","hsqls":["SELECT WheelsOff, AirTime, COUNT(*) FROM mytable WHERE DepDel15 IN (1, 0, -9999) GROUP BY WheelsOff, AirTime  ORDER BY WheelsOff, AirTime LIMIT 11"]}
{"sql":"SELECT OriginState, OriginStateName FROM mytable WHERE FlightNum <= 1275 ORDER BY Diverted, ArrivalDelayGroups LIMIT 24"}
{"sql":"SELECT Origin, CRSDepTime, ArrivalDelayGroups FROM mytable ORDER BY AirlineID LIMIT 14"}
{"sql":"SELECT TaxiOut, ArrivalDelayGroups, DivTotalGTimes FROM mytable WHERE FlightNum <> 926 AND DivWheelsOffs IN (2053, 1549, 137, 2139) AND DistanceGroup >= 5 LIMIT 24","hsqls":["SELECT TaxiOut, ArrivalDelayGroups, DivTotalGTimes FROM mytable WHERE FlightNum <> 926 AND (DivWheelsOffs[1] IN (2053, 1549, 137, 2139) OR DivWheelsOffs[2] IN (2053, 1549, 137, 2139) OR DivWheelsOffs[3] IN (2053, 1549, 137, 2139) OR DivWheelsOffs[4] IN (2053, 1549, 137, 2139) OR DivWheelsOffs[5] IN (2053, 1549, 137, 2139)) AND DistanceGroup >= 5 LIMIT 10000"]}
{"sql":"SELECT DivLongestGTimes FROM mytable ORDER BY ArrDel15 LIMIT 29","hsqls":["SELECT DivLongestGTimes FROM mytable ORDER BY ArrDel15 LIMIT 10000"]}
{"sql":"SELECT DayOfWeek FROM mytable WHERE DestAirportSeqID BETWEEN 1538902 AND 1072102 OR OriginAirportID BETWEEN 11337 AND 10994 LIMIT 11"}
{"sql":"SELECT TaxiOut, DistanceGroup, ActualElapsedTime FROM mytable WHERE DivAirportIDs = 15070 AND DestCityName IN ('San Jose, CA', 'Twin Falls, ID', 'Fort Smith, AR', 'Fort Myers, FL', 'Columbia, SC') ORDER BY DestStateFips, Dest LIMIT 8","hsqls":["SELECT TaxiOut, DistanceGroup, ActualElapsedTime FROM mytable WHERE (DivAirportIDs[1] = 15070 OR DivAirportIDs[2] = 15070 OR DivAirportIDs[3] = 15070 OR DivAirportIDs[4] = 15070 OR DivAirportIDs[5] = 15070) AND DestCityName IN ('San Jose, CA', 'Twin Falls, ID', 'Fort Smith, AR', 'Fort Myers, FL', 'Columbia, SC') ORDER BY DestStateFips, Dest LIMIT 10000"]}
{"sql":"SELECT DivAirports FROM mytable ORDER BY DepartureDelayGroups, UniqueCarrier LIMIT 1","hsqls":["SELECT DivAirports FROM mytable ORDER BY DepartureDelayGroups, UniqueCarrier LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime FROM mytable ORDER BY OriginCityName, ArrTime, DestAirportID LIMIT 1"}
{"sql":"SELECT OriginCityName, Dest, SUM(Flights), SUM(DistanceGroup) FROM mytable GROUP BY OriginCityName, Dest  ORDER BY OriginCityName, Dest LIMIT 27","hsqls":["SELECT OriginCityName, Dest, SUM(Flights), SUM(DistanceGroup) FROM mytable GROUP BY OriginCityName, Dest  ORDER BY OriginCityName, Dest LIMIT 27"]}
{"sql":"SELECT Carrier, FlightDate, Origin FROM mytable WHERE OriginState BETWEEN 'MN' AND 'AK' AND CRSDepTime <> 1549 OR DepartureDelayGroups BETWEEN 1 AND -9999 LIMIT 16"}
{"sql":"SELECT Quarter, MIN(LateAircraftDelay) FROM mytable WHERE DivLongestGTimes BETWEEN 14.0 AND 34.0 OR ArrDelay NOT IN (-21.0, 245.0, 90.0, -28.0, 187.0) GROUP BY Quarter LIMIT 14","hsqls":["SELECT Quarter, MIN(LateAircraftDelay) FROM mytable WHERE (DivLongestGTimes[1] BETWEEN 14.0 AND 34.0 OR DivLongestGTimes[2] BETWEEN 14.0 AND 34.0 OR DivLongestGTimes[3] BETWEEN 14.0 AND 34.0 OR DivLongestGTimes[4] BETWEEN 14.0 AND 34.0 OR DivLongestGTimes[5] BETWEEN 14.0 AND 34.0) OR ArrDelay NOT IN (-21.0, 245.0, 90.0, -28.0, 187.0) GROUP BY Quarter LIMIT 10000"]}
{"sql":"SELECT AVG(ActualElapsedTime), COUNT(DepDelayMinutes) FROM mytable WHERE DepDelayMinutes <> 297.0 LIMIT 11"}
{"sql":"SELECT WheelsOn FROM mytable ORDER BY DestState, OriginCityName, NASDelay LIMIT 19"}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DayofMonth = 20 ORDER BY NASDelay, AirlineID LIMIT 19"}
{"sql":"SELECT SUM(DivReachedDest), MAX(Diverted), SUM(DestCityMarketID) FROM mytable LIMIT 29"}
{"sql":"SELECT CRSArrTime, AVG(OriginWac), SUM(TotalAddGTime), SUM(WheelsOn) FROM mytable WHERE DestAirportSeqID IN (1141303, 1343302, 1410002) AND ArrDel15 >= -9999 GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 10","hsqls":["SELECT CRSArrTime, AVG(OriginWac), SUM(TotalAddGTime), SUM(WheelsOn) FROM mytable WHERE DestAirportSeqID IN (1141303, 1343302, 1410002) AND ArrDel15 >= -9999 GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 10"]}
{"sql":"SELECT DivAirports FROM mytable WHERE DestStateFips > 17 ORDER BY Distance, ArrDelay, OriginAirportID LIMIT 8","hsqls":["SELECT DivAirports FROM mytable WHERE DestStateFips > 17 ORDER BY Distance, ArrDelay, OriginAirportID LIMIT 10000"]}
{"sql":"SELECT CancellationCode FROM mytable WHERE DaysSinceEpoch BETWEEN 16078 AND 16076 ORDER BY OriginWac LIMIT 23"}
{"sql":"SELECT OriginStateFips, FlightDate, OriginStateName, MAX(AirlineID), COUNT(DivReachedDest), COUNT(ArrDel15) FROM mytable GROUP BY OriginStateFips, FlightDate, OriginStateName  ORDER BY OriginStateFips, FlightDate, OriginStateName LIMIT 17","hsqls":["SELECT OriginStateFips, FlightDate, OriginStateName, MAX(AirlineID), COUNT(DivReachedDest), COUNT(ArrDel15) FROM mytable GROUP BY OriginStateFips, FlightDate, OriginStateName  ORDER BY OriginStateFips, FlightDate, OriginStateName LIMIT 17"]}
{"sql":"SELECT Diverted, Flights, ArrivalDelayGroups FROM mytable WHERE DivAirportSeqIDs BETWEEN 1425202 AND 1451202 OR LongestAddGTime NOT IN (128, 32) OR DivWheelsOns BETWEEN 1033 AND 1118 ORDER BY OriginCityMarketID LIMIT 23","hsqls":["SELECT Diverted, Flights, ArrivalDelayGroups FROM mytable WHERE (DivAirportSeqIDs[1] BETWEEN 1425202 AND 1451202 OR DivAirportSeqIDs[2] BETWEEN 1425202 AND 1451202 OR DivAirportSeqIDs[3] BETWEEN 1425202 AND 1451202 OR DivAirportSeqIDs[4] BETWEEN 1425202 AND 1451202 OR DivAirportSeqIDs[5] BETWEEN 1425202 AND 1451202) OR LongestAddGTime NOT IN (128, 32) OR (DivWheelsOns[1] BETWEEN 1033 AND 1118 OR DivWheelsOns[2] BETWEEN 1033 AND 1118 OR DivWheelsOns[3] BETWEEN 1033 AND 1118 OR DivWheelsOns[4] BETWEEN 1033 AND 1118 OR DivWheelsOns[5] BETWEEN 1033 AND 1118) ORDER BY OriginCityMarketID LIMIT 10000"]}
{"sql":"SELECT DestStateFips, MIN(WheelsOn), COUNT(DivReachedDest), SUM(OriginCityMarketID) FROM mytable WHERE WheelsOn NOT IN (824, 1215, 2156, 1251) AND LongestAddGTime < 27 AND DivTailNums IN ('N530MQ', 'N805SK', 'N753SK') GROUP BY DestStateFips LIMIT 12","hsqls":["SELECT DestStateFips, MIN(WheelsOn), COUNT(DivReachedDest), SUM(OriginCityMarketID) FROM mytable WHERE WheelsOn NOT IN (824, 1215, 2156, 1251) AND LongestAddGTime < 27 AND (DivTailNums[1] IN ('N530MQ', 'N805SK', 'N753SK') OR DivTailNums[2] IN ('N530MQ', 'N805SK', 'N753SK') OR DivTailNums[3] IN ('N530MQ', 'N805SK', 'N753SK') OR DivTailNums[4] IN ('N530MQ', 'N805SK', 'N753SK') OR DivTailNums[5] IN ('N530MQ', 'N805SK', 'N753SK')) GROUP BY DestStateFips LIMIT 10000"]}
{"sql":"SELECT COUNT(OriginAirportSeqID), MIN(AirlineID) FROM mytable WHERE Flights NOT IN (1) LIMIT 16"}
{"sql":"SELECT DepTime FROM mytable WHERE TotalAddGTime = 4 OR Carrier NOT IN ('UA') OR DestAirportSeqID BETWEEN 1152502 AND 1199603 ORDER BY ArrDelayMinutes, CRSDepTime, DivActualElapsedTime LIMIT 5"}
{"sql":"SELECT DestStateFips, ArrTimeBlk, DepTimeBlk FROM mytable WHERE DepartureDelayGroups <> 9 AND DaysSinceEpoch BETWEEN 16089 AND 16084 ORDER BY OriginState, DepTime LIMIT 24"}
{"sql":"SELECT Dest, Origin, COUNT(*) FROM mytable GROUP BY Dest, Origin  ORDER BY Dest, Origin LIMIT 23","hsqls":["SELECT Dest, Origin, COUNT(*) FROM mytable GROUP BY Dest, Origin  ORDER BY Dest, Origin LIMIT 23"]}
{"sql":"SELECT Carrier, Origin, ArrDelay, MIN(Cancelled) FROM mytable GROUP BY Carrier, Origin, ArrDelay  ORDER BY Carrier, Origin, ArrDelay LIMIT 19","hsqls":["SELECT Carrier, Origin, ArrDelay, MIN(Cancelled) FROM mytable GROUP BY Carrier, Origin, ArrDelay  ORDER BY Carrier, Origin, ArrDelay LIMIT 19"]}
{"sql":"SELECT DivReachedDest, Distance, MAX(LongestAddGTime), SUM(DestAirportID), SUM(Distance) FROM mytable GROUP BY DivReachedDest, Distance  ORDER BY DivReachedDest, Distance LIMIT 11","hsqls":["SELECT DivReachedDest, Distance, MAX(LongestAddGTime), SUM(DestAirportID), SUM(Distance) FROM mytable GROUP BY DivReachedDest, Distance  ORDER BY DivReachedDest, Distance LIMIT 11"]}
{"sql":"SELECT UniqueCarrier, DaysSinceEpoch FROM mytable WHERE Carrier IN ('DL', 'B6', 'VX') OR Flights < 1 ORDER BY DivActualElapsedTime LIMIT 10"}
{"sql":"SELECT MIN(ArrDelayMinutes), AVG(OriginAirportSeqID) FROM mytable WHERE ActualElapsedTime < 185 LIMIT 6"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivDistance NOT IN (539, 1105) LIMIT 10"}
{"sql":"SELECT OriginState, COUNT(DistanceGroup), SUM(DestAirportID) FROM mytable WHERE \"Year\" < 2014 AND CRSDepTime BETWEEN 738 AND 1423 GROUP BY OriginState LIMIT 25","hsqls":["SELECT OriginState, COUNT(DistanceGroup), SUM(DestAirportID) FROM mytable WHERE `Year` < 2014 AND CRSDepTime BETWEEN 738 AND 1423 GROUP BY OriginState LIMIT 25"]}
{"sql":"SELECT DepTime, \"Month\", CRSElapsedTime, AVG(Quarter) FROM mytable GROUP BY DepTime, \"Month\", CRSElapsedTime LIMIT 4","hsqls":["SELECT DepTime, Month, CRSElapsedTime, AVG(Quarter) FROM mytable GROUP BY DepTime, Month, CRSElapsedTime LIMIT 4"]}
{"sql":"SELECT DestState, AVG(DestAirportSeqID), COUNT(AirTime), MAX(Diverted) FROM mytable WHERE Carrier NOT IN ('B6', 'FL', 'AS') GROUP BY DestState  ORDER BY DestState LIMIT 6","hsqls":["SELECT DestState, AVG(DestAirportSeqID), COUNT(AirTime), MAX(Diverted) FROM mytable WHERE Carrier NOT IN ('B6', 'FL', 'AS') GROUP BY DestState  ORDER BY DestState LIMIT 6"]}
{"sql":"SELECT Cancelled FROM mytable WHERE TaxiIn = 11 OR DivAirportSeqIDs >= 1320302 OR CarrierDelay NOT IN (48, 115, 18, 280) ORDER BY DepDelay, OriginCityMarketID LIMIT 27","hsqls":["SELECT Cancelled FROM mytable WHERE TaxiIn = 11 OR (DivAirportSeqIDs[1] >= 1320302 OR DivAirportSeqIDs[2] >= 1320302 OR DivAirportSeqIDs[3] >= 1320302 OR DivAirportSeqIDs[4] >= 1320302 OR DivAirportSeqIDs[5] >= 1320302) OR CarrierDelay NOT IN (48, 115, 18, 280) ORDER BY DepDelay, OriginCityMarketID LIMIT 10000"]}
{"sql":"SELECT OriginState, DayofMonth, AVG(ArrDel15), COUNT(DayOfWeek) FROM mytable WHERE DistanceGroup > 8 OR UniqueCarrier NOT IN ('HA', 'B6', 'MQ', 'UA') GROUP BY OriginState, DayofMonth","hsqls":["SELECT OriginState, DayofMonth, AVG(ArrDel15), COUNT(DayOfWeek) FROM mytable WHERE DistanceGroup > 8 OR UniqueCarrier NOT IN ('HA', 'B6', 'MQ', 'UA') GROUP BY OriginState, DayofMonth"]}
{"sql":"SELECT DepDel15 FROM mytable WHERE FlightDate > '2014-01-17' OR Dest BETWEEN 'SPS' AND 'ISP' ORDER BY DaysSinceEpoch LIMIT 13"}
{"sql":"SELECT LateAircraftDelay, AirlineID, MAX(FlightNum) FROM mytable WHERE LongestAddGTime NOT IN (58, 32, 26) AND CRSArrTime = 1200 GROUP BY LateAircraftDelay, AirlineID  ORDER BY LateAircraftDelay, AirlineID LIMIT 11","hsqls":["SELECT LateAircraftDelay, AirlineID, MAX(FlightNum) FROM mytable WHERE LongestAddGTime NOT IN (58, 32, 26) AND CRSArrTime = 1200 GROUP BY LateAircraftDelay, AirlineID  ORDER BY LateAircraftDelay, AirlineID LIMIT 11"]}
{"sql":"SELECT COUNT(OriginCityMarketID), MAX(TaxiOut), COUNT(AirlineID) FROM mytable WHERE AirlineID < 19393 OR DivArrDelay < 252 AND ArrDel15 NOT IN (1, 0, -9999) LIMIT 8"}
{"sql":"SELECT CarrierDelay FROM mytable WHERE CRSArrTime IN (1651, 1550, 1630) AND DepDelayMinutes BETWEEN 100.0 AND 229.0 AND Flights IN (1) ORDER BY Origin LIMIT 18"}
{"sql":"SELECT COUNT(CRSElapsedTime) FROM mytable LIMIT 11"}
{"sql":"SELECT DepTimeBlk, SUM(ArrivalDelayGroups), COUNT(OriginStateName), AVG(DayofMonth) FROM mytable WHERE ArrivalDelayGroups BETWEEN -1 AND 4 GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 27","hsqls":["SELECT DepTimeBlk, SUM(ArrivalDelayGroups), COUNT(OriginStateName), AVG(DayofMonth) FROM mytable WHERE ArrivalDelayGroups BETWEEN -1 AND 4 GROUP BY DepTimeBlk  ORDER BY DepTimeBlk LIMIT 27"]}
{"sql":"SELECT DivWheelsOns, SecurityDelay, DivWheelsOffs FROM mytable WHERE TaxiIn BETWEEN 40 AND 162 LIMIT 4","hsqls":["SELECT DivWheelsOns, SecurityDelay, DivWheelsOffs FROM mytable WHERE TaxiIn BETWEEN 40 AND 162 LIMIT 10000"]}
{"sql":"SELECT Flights, CRSElapsedTime, AVG(ArrTime), COUNT(DestCityName) FROM mytable WHERE DepDelay >= 113.0 OR ArrDel15 BETWEEN 0 AND -9999 GROUP BY Flights, CRSElapsedTime  ORDER BY Flights, CRSElapsedTime LIMIT 3","hsqls":["SELECT Flights, CRSElapsedTime, AVG(ArrTime), COUNT(DestCityName) FROM mytable WHERE DepDelay >= 113.0 OR ArrDel15 BETWEEN 0 AND -9999 GROUP BY Flights, CRSElapsedTime  ORDER BY Flights, CRSElapsedTime LIMIT 3"]}
{"sql":"SELECT DestCityName, DayofMonth FROM mytable WHERE \"Month\" < 1 AND TotalAddGTime = 74 ORDER BY Carrier, DayofMonth, WheelsOn LIMIT 5","hsqls":["SELECT DestCityName, DayofMonth FROM mytable WHERE `Month` < 1 AND TotalAddGTime = 74 ORDER BY Carrier, DayofMonth, WheelsOn LIMIT 5"]}
{"sql":"SELECT DivWheelsOns FROM mytable WHERE OriginState > 'HI' OR DestAirportID IN (11953, 14570, 10781) ORDER BY DepDel15, ArrDel15","hsqls":["SELECT DivWheelsOns FROM mytable WHERE OriginState > 'HI' OR DestAirportID IN (11953, 14570, 10781) ORDER BY DepDel15, ArrDel15 LIMIT 10000"]}
{"sql":"SELECT DivReachedDest, FlightNum, DepDelayMinutes FROM mytable WHERE SecurityDelay BETWEEN 8 AND 0 ORDER BY Dest, ArrDelay LIMIT 14"}
{"sql":"SELECT DaysSinceEpoch FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND TaxiIn < 18 LIMIT 15","hsqls":["SELECT DaysSinceEpoch FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND TaxiIn < 18 LIMIT 15"]}
{"sql":"SELECT DepTime, DestAirportID, AVG(TaxiIn), MAX(Cancelled) FROM mytable GROUP BY DepTime, DestAirportID  ORDER BY DepTime, DestAirportID LIMIT 18","hsqls":["SELECT DepTime, DestAirportID, AVG(TaxiIn), MAX(Cancelled) FROM mytable GROUP BY DepTime, DestAirportID  ORDER BY DepTime, DestAirportID LIMIT 18"]}
{"sql":"SELECT DestAirportSeqID FROM mytable WHERE TaxiOut BETWEEN 92 AND 37 OR Flights BETWEEN 1 AND 1 OR Dest BETWEEN 'GRI' AND 'LRD' ORDER BY LongestAddGTime LIMIT 24"}
{"sql":"SELECT AVG(CarrierDelay) FROM mytable WHERE CRSArrTime < 21 LIMIT 4"}
{"sql":"SELECT ArrDel15, DestCityName, ArrivalDelayGroups, SUM(Cancelled), SUM(CRSElapsedTime), SUM(Quarter) FROM mytable WHERE DivTotalGTimes IN (16) AND OriginCityMarketID BETWEEN 31002 AND 30135 OR FlightDate NOT IN ('2014-01-29', '2014-01-09', '2014-01-24', '2014-01-26') GROUP BY ArrDel15, DestCityName, ArrivalDelayGroups LIMIT 5","hsqls":["SELECT ArrDel15, DestCityName, ArrivalDelayGroups, SUM(Cancelled), SUM(CRSElapsedTime), SUM(Quarter) FROM mytable WHERE (DivTotalGTimes[1] IN (16) OR DivTotalGTimes[2] IN (16) OR DivTotalGTimes[3] IN (16) OR DivTotalGTimes[4] IN (16) OR DivTotalGTimes[5] IN (16)) AND OriginCityMarketID BETWEEN 31002 AND 30135 OR FlightDate NOT IN ('2014-01-29', '2014-01-09', '2014-01-24', '2014-01-26') GROUP BY ArrDel15, DestCityName, ArrivalDelayGroups LIMIT 10000"]}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DepartureDelayGroups BETWEEN 0 AND 7 AND TaxiIn = 55 LIMIT 18"}
{"sql":"SELECT WheelsOff, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE \"Month\" IN (1) OR SecurityDelay NOT IN (4) GROUP BY WheelsOff, ArrivalDelayGroups LIMIT 6","hsqls":["SELECT WheelsOff, ArrivalDelayGroups, COUNT(*) FROM mytable WHERE `Month` IN (1) OR SecurityDelay NOT IN (4) GROUP BY WheelsOff, ArrivalDelayGroups LIMIT 6"]}
{"sql":"SELECT DivWheelsOns, SecurityDelay FROM mytable WHERE Diverted BETWEEN 1 AND 0 ORDER BY WheelsOff, Dest, DestCityName LIMIT 3","hsqls":["SELECT DivWheelsOns, SecurityDelay FROM mytable WHERE Diverted BETWEEN 1 AND 0 ORDER BY WheelsOff, Dest, DestCityName LIMIT 10000"]}
{"sql":"SELECT DepartureDelayGroups, Quarter, CancellationCode, MAX(Flights), AVG(AirlineID), MAX(DepDelay) FROM mytable WHERE CRSArrTime BETWEEN 1429 AND 1750 OR DepartureDelayGroups >= 3 OR Flights IN (1) GROUP BY DepartureDelayGroups, Quarter, CancellationCode  ORDER BY DepartureDelayGroups, Quarter, CancellationCode LIMIT 22","hsqls":["SELECT DepartureDelayGroups, Quarter, CancellationCode, MAX(Flights), AVG(AirlineID), MAX(DepDelay) FROM mytable WHERE CRSArrTime BETWEEN 1429 AND 1750 OR DepartureDelayGroups >= 3 OR Flights IN (1) GROUP BY DepartureDelayGroups, Quarter, CancellationCode  ORDER BY DepartureDelayGroups, Quarter, CancellationCode LIMIT 22"]}
{"sql":"SELECT MAX(FirstDepTime), MIN(ActualElapsedTime) FROM mytable WHERE OriginAirportSeqID IN (1350202, 1192102, 1073203, 1244102, 1470903) AND Carrier BETWEEN 'EV' AND 'FL' OR ArrDelay NOT IN (252.0) LIMIT 8"}
{"sql":"SELECT DestAirportSeqID, ArrDelay, WheelsOn, COUNT(*) FROM mytable WHERE SecurityDelay <> 1 GROUP BY DestAirportSeqID, ArrDelay, WheelsOn  ORDER BY DestAirportSeqID, ArrDelay, WheelsOn LIMIT 9","hsqls":["SELECT DestAirportSeqID, ArrDelay, WheelsOn, COUNT(*) FROM mytable WHERE SecurityDelay <> 1 GROUP BY DestAirportSeqID, ArrDelay, WheelsOn  ORDER BY DestAirportSeqID, ArrDelay, WheelsOn LIMIT 9"]}
{"sql":"SELECT AVG(DepDel15), SUM(DivArrDelay), COUNT(DestState) FROM mytable WHERE OriginStateName > 'Maine' OR CancellationCode BETWEEN 'noodles' AND 'C' AND OriginWac IN (34, 37, 85) LIMIT 20"}
{"sql":"SELECT FlightDate, DayofMonth FROM mytable ORDER BY CancellationCode, \"Month\"","hsqls":["SELECT FlightDate, DayofMonth FROM mytable ORDER BY CancellationCode, Month"]}
{"sql":"SELECT Dest FROM mytable WHERE DestState BETWEEN 'CO' AND 'MA' AND DepartureDelayGroups BETWEEN 5 AND 3 OR DivAirports BETWEEN 'MCN' AND 'CID' ORDER BY WeatherDelay, AirlineID LIMIT 24","hsqls":["SELECT Dest FROM mytable WHERE DestState BETWEEN 'CO' AND 'MA' AND DepartureDelayGroups BETWEEN 5 AND 3 OR (DivAirports[1] BETWEEN 'MCN' AND 'CID' OR DivAirports[2] BETWEEN 'MCN' AND 'CID' OR DivAirports[3] BETWEEN 'MCN' AND 'CID' OR DivAirports[4] BETWEEN 'MCN' AND 'CID' OR DivAirports[5] BETWEEN 'MCN' AND 'CID') ORDER BY WeatherDelay, AirlineID LIMIT 10000"]}
{"sql":"SELECT AVG(OriginStateFips) FROM mytable WHERE DivAirports IN ('OGG') OR DivAirportLandings < 0 LIMIT 26","hsqls":["SELECT AVG(CAST(OriginStateFips AS DOUBLE)) FROM mytable WHERE (DivAirports[1] IN ('OGG') OR DivAirports[2] IN ('OGG') OR DivAirports[3] IN ('OGG') OR DivAirports[4] IN ('OGG') OR DivAirports[5] IN ('OGG')) OR DivAirportLandings < 0 LIMIT 10000"]}
{"sql":"SELECT TaxiIn, ArrTimeBlk, AirlineID, MIN(CarrierDelay) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR ArrDelay BETWEEN 118.0 AND -9.0 GROUP BY TaxiIn, ArrTimeBlk, AirlineID LIMIT 27","hsqls":["SELECT TaxiIn, ArrTimeBlk, AirlineID, MIN(CarrierDelay) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR ArrDelay BETWEEN 118.0 AND -9.0 GROUP BY TaxiIn, ArrTimeBlk, AirlineID LIMIT 27"]}
{"sql":"SELECT FirstDepTime, ArrTimeBlk, DivAirportIDs FROM mytable WHERE Diverted BETWEEN 1 AND 0 AND \"Year\" <> 2014 OR DepartureDelayGroups BETWEEN 12 AND -1 ORDER BY DestCityName, DepTimeBlk, AirTime LIMIT 3","hsqls":["SELECT FirstDepTime, ArrTimeBlk, DivAirportIDs FROM mytable WHERE Diverted BETWEEN 1 AND 0 AND `Year` <> 2014 OR DepartureDelayGroups BETWEEN 12 AND -1 ORDER BY DestCityName, DepTimeBlk, AirTime LIMIT 10000"]}
{"sql":"SELECT AVG(OriginStateFips) FROM mytable WHERE DivDistance IN (261, 176, 60, 283) AND OriginAirportSeqID BETWEEN 1043403 AND 1325602 LIMIT 16"}
{"sql":"SELECT DepartureDelayGroups, ArrDel15, DepTimeBlk FROM mytable ORDER BY DistanceGroup, Diverted, ActualElapsedTime LIMIT 26"}
{"sql":"SELECT ActualElapsedTime, SUM(TotalAddGTime), MAX(DivReachedDest), AVG(ArrDelay) FROM mytable GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 1","hsqls":["SELECT ActualElapsedTime, SUM(TotalAddGTime), MAX(DivReachedDest), AVG(ArrDelay) FROM mytable GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 1"]}
{"sql":"SELECT AVG(ArrTime), AVG(DayofMonth), MIN(ActualElapsedTime) FROM mytable WHERE Dest BETWEEN 'GJT' AND 'GPT' LIMIT 5"}
{"sql":"SELECT OriginCityMarketID, CRSArrTime, CRSElapsedTime FROM mytable WHERE TaxiOut NOT IN (64) ORDER BY OriginAirportSeqID LIMIT 21"}
{"sql":"SELECT DayofMonth, CRSDepTime FROM mytable WHERE SecurityDelay NOT IN (-9999) AND Flights > 1 ORDER BY DivArrDelay LIMIT 16"}
{"sql":"SELECT DestStateFips FROM mytable WHERE WheelsOn IN (2147, 1707, 2116, 1640) ORDER BY DepartureDelayGroups, DestWac LIMIT 10"}
{"sql":"SELECT LateAircraftDelay, Carrier, DepDelayMinutes, AVG(AirTime) FROM mytable WHERE DestState NOT IN ('ND', 'GA', 'VI', 'DE', 'ME') GROUP BY LateAircraftDelay, Carrier, DepDelayMinutes  ORDER BY LateAircraftDelay, Carrier, DepDelayMinutes LIMIT 22","hsqls":["SELECT LateAircraftDelay, Carrier, DepDelayMinutes, AVG(AirTime) FROM mytable WHERE DestState NOT IN ('ND', 'GA', 'VI', 'DE', 'ME') GROUP BY LateAircraftDelay, Carrier, DepDelayMinutes  ORDER BY LateAircraftDelay, Carrier, DepDelayMinutes LIMIT 22"]}
{"sql":"SELECT OriginCityName FROM mytable ORDER BY DestAirportID LIMIT 12"}
{"sql":"SELECT AirlineID FROM mytable WHERE ArrivalDelayGroups BETWEEN 11 AND 0 AND OriginAirportID BETWEEN 14576 AND 12003 ORDER BY ArrDelay LIMIT 16"}
{"sql":"SELECT CarrierDelay, \"Month\" FROM mytable WHERE DivWheelsOffs IN (153, 1908, 2107) AND DestState BETWEEN 'WV' AND 'TT' OR DivWheelsOffs IN (1330, 1531) ORDER BY AirlineID, DestAirportID LIMIT 26","hsqls":["SELECT CarrierDelay, `Month` FROM mytable WHERE (DivWheelsOffs[1] IN (153, 1908, 2107) OR DivWheelsOffs[2] IN (153, 1908, 2107) OR DivWheelsOffs[3] IN (153, 1908, 2107) OR DivWheelsOffs[4] IN (153, 1908, 2107) OR DivWheelsOffs[5] IN (153, 1908, 2107)) AND DestState BETWEEN 'WV' AND 'TT' OR (DivWheelsOffs[1] IN (1330, 1531) OR DivWheelsOffs[2] IN (1330, 1531) OR DivWheelsOffs[3] IN (1330, 1531) OR DivWheelsOffs[4] IN (1330, 1531) OR DivWheelsOffs[5] IN (1330, 1531)) ORDER BY AirlineID, DestAirportID LIMIT 10000"]}
{"sql":"SELECT DestWac, OriginStateFips, DivActualElapsedTime, MIN(LateAircraftDelay) FROM mytable WHERE ArrDelay > 227.0 GROUP BY DestWac, OriginStateFips, DivActualElapsedTime","hsqls":["SELECT DestWac, OriginStateFips, DivActualElapsedTime, MIN(LateAircraftDelay) FROM mytable WHERE ArrDelay > 227.0 GROUP BY DestWac, OriginStateFips, DivActualElapsedTime"]}
{"sql":"SELECT \"Year\", DivAirports FROM mytable WHERE CancellationCode IN ('A', 'B', 'C', 'noodles') ORDER BY WheelsOff, FlightNum, DestAirportSeqID LIMIT 16","hsqls":["SELECT Year, DivAirports FROM mytable WHERE CancellationCode IN ('A', 'B', 'C', 'noodles') ORDER BY WheelsOff, FlightNum, DestAirportSeqID LIMIT 10000"]}
{"sql":"SELECT WeatherDelay, DestStateName, CancellationCode FROM mytable WHERE DivDistance NOT IN (842, 786, 545, 187, 236) AND CRSDepTime IN (1350, 510, 1339, 836) ORDER BY Flights LIMIT 26"}
{"sql":"SELECT ArrDelayMinutes, DivActualElapsedTime FROM mytable ORDER BY TaxiOut, CRSElapsedTime LIMIT 7"}
{"sql":"SELECT CRSArrTime FROM mytable WHERE DivAirportIDs BETWEEN 10994 AND 10918 AND DivArrDelay < 161 AND DivAirportIDs > 14057 ORDER BY ArrDelay, ArrivalDelayGroups, OriginStateName LIMIT 27","hsqls":["SELECT CRSArrTime FROM mytable WHERE (DivAirportIDs[1] BETWEEN 10994 AND 10918 OR DivAirportIDs[2] BETWEEN 10994 AND 10918 OR DivAirportIDs[3] BETWEEN 10994 AND 10918 OR DivAirportIDs[4] BETWEEN 10994 AND 10918 OR DivAirportIDs[5] BETWEEN 10994 AND 10918) AND DivArrDelay < 161 AND (DivAirportIDs[1] > 14057 OR DivAirportIDs[2] > 14057 OR DivAirportIDs[3] > 14057 OR DivAirportIDs[4] > 14057 OR DivAirportIDs[5] > 14057) ORDER BY ArrDelay, ArrivalDelayGroups, OriginStateName LIMIT 10000"]}
{"sql":"SELECT DivDistance, OriginCityMarketID, DivArrDelay, MAX(WheelsOn), AVG(TaxiOut), MIN(DepartureDelayGroups) FROM mytable WHERE WheelsOn >= 1754 OR Diverted >= 0 GROUP BY DivDistance, OriginCityMarketID, DivArrDelay  ORDER BY DivDistance, OriginCityMarketID, DivArrDelay LIMIT 12","hsqls":["SELECT DivDistance, OriginCityMarketID, DivArrDelay, MAX(WheelsOn), AVG(TaxiOut), MIN(DepartureDelayGroups) FROM mytable WHERE WheelsOn >= 1754 OR Diverted >= 0 GROUP BY DivDistance, OriginCityMarketID, DivArrDelay  ORDER BY DivDistance, OriginCityMarketID, DivArrDelay LIMIT 12"]}
{"sql":"SELECT COUNT(DepDel15), SUM(DayOfWeek) FROM mytable WHERE Dest <> 'ONT' AND TailNum <= 'N927EV' OR CRSDepTime > 1752 LIMIT 29"}
{"sql":"SELECT DivLongestGTimes, DestWac FROM mytable LIMIT 11","hsqls":["SELECT DivLongestGTimes, DestWac FROM mytable LIMIT 10000"]}
{"sql":"SELECT \"Year\", DestWac, COUNT(\"Month\"), COUNT(OriginCityName) FROM mytable WHERE TailNum BETWEEN 'N931MQ' AND 'N778SK' GROUP BY \"Year\", DestWac LIMIT 26","hsqls":["SELECT Year, DestWac, COUNT(`Month`), COUNT(OriginCityName) FROM mytable WHERE TailNum BETWEEN 'N931MQ' AND 'N778SK' GROUP BY Year, DestWac LIMIT 26"]}
{"sql":"SELECT Flights, COUNT(*) FROM mytable WHERE DivActualElapsedTime BETWEEN 350 AND 259 AND OriginState NOT IN ('LA', 'VT', 'UT', 'OR', 'RI') GROUP BY Flights  ORDER BY Flights LIMIT 25","hsqls":["SELECT Flights, COUNT(*) FROM mytable WHERE DivActualElapsedTime BETWEEN 350 AND 259 AND OriginState NOT IN ('LA', 'VT', 'UT', 'OR', 'RI') GROUP BY Flights  ORDER BY Flights LIMIT 25"]}
{"sql":"SELECT Carrier, DivActualElapsedTime FROM mytable ORDER BY TotalAddGTime, CancellationCode, WheelsOn LIMIT 28"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivArrDelay NOT IN (205) LIMIT 9"}
{"sql":"SELECT OriginAirportSeqID, COUNT(OriginCityName), SUM(OriginStateFips) FROM mytable GROUP BY OriginAirportSeqID  ORDER BY OriginAirportSeqID LIMIT 12","hsqls":["SELECT OriginAirportSeqID, COUNT(OriginCityName), SUM(OriginStateFips) FROM mytable GROUP BY OriginAirportSeqID  ORDER BY OriginAirportSeqID LIMIT 12"]}
{"sql":"SELECT DivReachedDest, MIN(DestStateFips), MIN(ArrTime) FROM mytable WHERE DivAirports IN ('SEA', 'BRW', 'ONT') GROUP BY DivReachedDest LIMIT 15","hsqls":["SELECT DivReachedDest, MIN(DestStateFips), MIN(ArrTime) FROM mytable WHERE (DivAirports[1] IN ('SEA', 'BRW', 'ONT') OR DivAirports[2] IN ('SEA', 'BRW', 'ONT') OR DivAirports[3] IN ('SEA', 'BRW', 'ONT') OR DivAirports[4] IN ('SEA', 'BRW', 'ONT') OR DivAirports[5] IN ('SEA', 'BRW', 'ONT')) GROUP BY DivReachedDest LIMIT 10000"]}
{"sql":"SELECT Dest, NASDelay, SUM(DepDel15), MAX(WeatherDelay) FROM mytable GROUP BY Dest, NASDelay  ORDER BY Dest, NASDelay LIMIT 19","hsqls":["SELECT Dest, NASDelay, SUM(DepDel15), MAX(WeatherDelay) FROM mytable GROUP BY Dest, NASDelay  ORDER BY Dest, NASDelay LIMIT 19"]}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE OriginStateName IN ('Pennsylvania', 'Idaho', 'Alabama') ORDER BY OriginStateFips, OriginCityName LIMIT 13","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE OriginStateName IN ('Pennsylvania', 'Idaho', 'Alabama') ORDER BY OriginStateFips, OriginCityName LIMIT 10000"]}
{"sql":"SELECT DestCityMarketID, OriginAirportID FROM mytable WHERE CancellationCode NOT IN ('A', 'B', 'C', 'noodles') OR CRSArrTime BETWEEN 2023 AND 1142 ORDER BY DestState, DivArrDelay, OriginAirportID LIMIT 23"}
{"sql":"SELECT FirstDepTime, DestAirportSeqID FROM mytable LIMIT 10"}
{"sql":"SELECT COUNT(Quarter), SUM(OriginWac) FROM mytable LIMIT 6"}
{"sql":"SELECT CancellationCode, OriginAirportID FROM mytable WHERE CancellationCode IN ('A', 'noodles') ORDER BY WheelsOff, DepDelayMinutes, DestCityMarketID LIMIT 14"}
{"sql":"SELECT ArrDel15, Dest FROM mytable WHERE DaysSinceEpoch BETWEEN 16082 AND 16084 ORDER BY Carrier, DepTimeBlk LIMIT 22"}
{"sql":"SELECT WheelsOff, WeatherDelay, COUNT(*) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR OriginStateFips BETWEEN 37 AND 12 GROUP BY WheelsOff, WeatherDelay  ORDER BY WheelsOff, WeatherDelay LIMIT 27","hsqls":["SELECT WheelsOff, WeatherDelay, COUNT(*) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR OriginStateFips BETWEEN 37 AND 12 GROUP BY WheelsOff, WeatherDelay  ORDER BY WheelsOff, WeatherDelay LIMIT 27"]}
{"sql":"SELECT AVG(DestWac) FROM mytable WHERE Origin NOT IN ('CLL', 'DTW') OR ArrivalDelayGroups IN (-1, 5, 8, -9999) LIMIT 9"}
{"sql":"SELECT \"Month\" FROM mytable WHERE Carrier >= 'US' LIMIT 29","hsqls":["SELECT `Month` FROM mytable WHERE Carrier >= 'US' LIMIT 29"]}
{"sql":"SELECT DepartureDelayGroups, FlightDate FROM mytable LIMIT 5"}
{"sql":"SELECT ArrDelayMinutes, WheelsOn, DivArrDelay FROM mytable WHERE DestAirportID < 11778 OR TaxiIn IN (67, 109, 65, 63, 11) ORDER BY NASDelay LIMIT 27"}
{"sql":"SELECT DepDelayMinutes FROM mytable WHERE ArrDelayMinutes IN (53.0, 92.0, 79.0, 250.0, 120.0) ORDER BY OriginAirportSeqID, DivArrDelay, ArrivalDelayGroups LIMIT 18"}
{"sql":"SELECT DestAirportSeqID, AVG(CarrierDelay), MAX(NASDelay) FROM mytable GROUP BY DestAirportSeqID  ORDER BY DestAirportSeqID LIMIT 22","hsqls":["SELECT DestAirportSeqID, AVG(CarrierDelay), MAX(NASDelay) FROM mytable GROUP BY DestAirportSeqID  ORDER BY DestAirportSeqID LIMIT 22"]}
{"sql":"SELECT DivTotalGTimes FROM mytable WHERE OriginWac BETWEEN 51 AND 67 ORDER BY AirlineID LIMIT 3","hsqls":["SELECT DivTotalGTimes FROM mytable WHERE OriginWac BETWEEN 51 AND 67 ORDER BY AirlineID LIMIT 10000"]}
{"sql":"SELECT Distance, WheelsOn FROM mytable WHERE OriginStateFips BETWEEN 28 AND 33 AND NASDelay NOT IN (2, 106) ORDER BY DestCityMarketID LIMIT 5"}
{"sql":"SELECT DestWac, DepDelay, MIN(AirTime), MIN(DepDelay) FROM mytable WHERE DayofMonth BETWEEN 25 AND 9 GROUP BY DestWac, DepDelay  ORDER BY DestWac, DepDelay LIMIT 17","hsqls":["SELECT DestWac, DepDelay, MIN(AirTime), MIN(DepDelay) FROM mytable WHERE DayofMonth BETWEEN 25 AND 9 GROUP BY DestWac, DepDelay  ORDER BY DestWac, DepDelay LIMIT 17"]}
{"sql":"SELECT CancellationCode FROM mytable ORDER BY DistanceGroup, FirstDepTime, LateAircraftDelay LIMIT 19"}
{"sql":"SELECT TailNum, DestCityName, AVG(ArrivalDelayGroups) FROM mytable WHERE WheelsOff BETWEEN 510 AND 1347 AND DestState < 'VI' GROUP BY TailNum, DestCityName  ORDER BY TailNum, DestCityName LIMIT 23","hsqls":["SELECT TailNum, DestCityName, AVG(ArrivalDelayGroups) FROM mytable WHERE WheelsOff BETWEEN 510 AND 1347 AND DestState < 'VI' GROUP BY TailNum, DestCityName  ORDER BY TailNum, DestCityName LIMIT 23"]}
{"sql":"SELECT DestWac, DestAirportID FROM mytable WHERE OriginCityMarketID NOT IN (33342, 30739, 31471, 31123, 30185) AND FlightNum NOT IN (4707) AND FirstDepTime > 1800 LIMIT 7"}
{"sql":"SELECT DivLongestGTimes, CarrierDelay, DestCityMarketID FROM mytable WHERE Carrier NOT IN ('AA') ORDER BY Origin LIMIT 10","hsqls":["SELECT DivLongestGTimes, CarrierDelay, DestCityMarketID FROM mytable WHERE Carrier NOT IN ('AA') ORDER BY Origin LIMIT 10000"]}
{"sql":"SELECT DivActualElapsedTime FROM mytable WHERE CRSDepTime <> 1517 ORDER BY FlightNum, DestAirportSeqID, DivActualElapsedTime LIMIT 24"}
{"sql":"SELECT OriginWac, UniqueCarrier, MAX(WheelsOn), COUNT(NASDelay), AVG(TaxiOut) FROM mytable WHERE OriginCityMarketID NOT IN (34614) OR Distance BETWEEN 1565 AND 1237 GROUP BY OriginWac, UniqueCarrier  ORDER BY OriginWac, UniqueCarrier LIMIT 7","hsqls":["SELECT OriginWac, UniqueCarrier, MAX(WheelsOn), COUNT(NASDelay), AVG(TaxiOut) FROM mytable WHERE OriginCityMarketID NOT IN (34614) OR Distance BETWEEN 1565 AND 1237 GROUP BY OriginWac, UniqueCarrier  ORDER BY OriginWac, UniqueCarrier LIMIT 7"]}
{"sql":"SELECT CarrierDelay, LongestAddGTime, DaysSinceEpoch, COUNT(DivDistance), MIN(DestAirportSeqID) FROM mytable WHERE OriginStateName BETWEEN 'Oklahoma' AND 'Mississippi' AND WeatherDelay = 95 AND TailNum IN ('N588UA', 'N742SK', 'N374DA', 'N549AS', 'N329NB') GROUP BY CarrierDelay, LongestAddGTime, DaysSinceEpoch  ORDER BY CarrierDelay, LongestAddGTime, DaysSinceEpoch LIMIT 26","hsqls":["SELECT CarrierDelay, LongestAddGTime, DaysSinceEpoch, COUNT(DivDistance), MIN(DestAirportSeqID) FROM mytable WHERE OriginStateName BETWEEN 'Oklahoma' AND 'Mississippi' AND WeatherDelay = 95 AND TailNum IN ('N588UA', 'N742SK', 'N374DA', 'N549AS', 'N329NB') GROUP BY CarrierDelay, LongestAddGTime, DaysSinceEpoch  ORDER BY CarrierDelay, LongestAddGTime, DaysSinceEpoch LIMIT 26"]}
{"sql":"SELECT MIN(ArrDel15) FROM mytable WHERE DepartureDelayGroups < 1 OR CRSArrTime BETWEEN 533 AND 741 OR TaxiIn IN (95, 57, 22, 83) LIMIT 20"}
{"sql":"SELECT ArrDelayMinutes, ActualElapsedTime, MIN(SecurityDelay) FROM mytable WHERE TotalAddGTime NOT IN (97) GROUP BY ArrDelayMinutes, ActualElapsedTime  ORDER BY ArrDelayMinutes, ActualElapsedTime LIMIT 9","hsqls":["SELECT ArrDelayMinutes, ActualElapsedTime, MIN(SecurityDelay) FROM mytable WHERE TotalAddGTime NOT IN (97) GROUP BY ArrDelayMinutes, ActualElapsedTime  ORDER BY ArrDelayMinutes, ActualElapsedTime LIMIT 9"]}
{"sql":"SELECT DistanceGroup FROM mytable WHERE \"Month\" BETWEEN 1 AND 1 AND DivAirportSeqIDs IN (1078102, 1142303, 1530402, 1172102, 1291503) OR SecurityDelay IN (1, 0, 14, -9999) LIMIT 10","hsqls":["SELECT DistanceGroup FROM mytable WHERE `Month` BETWEEN 1 AND 1 AND (DivAirportSeqIDs[1] IN (1078102, 1142303, 1530402, 1172102, 1291503) OR DivAirportSeqIDs[2] IN (1078102, 1142303, 1530402, 1172102, 1291503) OR DivAirportSeqIDs[3] IN (1078102, 1142303, 1530402, 1172102, 1291503) OR DivAirportSeqIDs[4] IN (1078102, 1142303, 1530402, 1172102, 1291503) OR DivAirportSeqIDs[5] IN (1078102, 1142303, 1530402, 1172102, 1291503)) OR SecurityDelay IN (1, 0, 14, -9999) LIMIT 10000"]}
{"sql":"SELECT DayofMonth, SUM(AirTime) FROM mytable WHERE \"Year\" < 2014 GROUP BY DayofMonth LIMIT 12","hsqls":["SELECT DayofMonth, SUM(AirTime) FROM mytable WHERE `Year` < 2014 GROUP BY DayofMonth LIMIT 12"]}
{"sql":"SELECT \"Month\", ArrivalDelayGroups FROM mytable ORDER BY LateAircraftDelay LIMIT 11","hsqls":["SELECT Month, ArrivalDelayGroups FROM mytable ORDER BY LateAircraftDelay LIMIT 11"]}
{"sql":"SELECT FlightNum, DivAirportIDs, Origin FROM mytable WHERE OriginStateFips BETWEEN 47 AND 37 ORDER BY Distance, OriginCityName, DepTime LIMIT 28","hsqls":["SELECT FlightNum, DivAirportIDs, Origin FROM mytable WHERE OriginStateFips BETWEEN 47 AND 37 ORDER BY Distance, OriginCityName, DepTime LIMIT 10000"]}
{"sql":"SELECT UniqueCarrier, DivTotalGTimes FROM mytable WHERE CRSDepTime BETWEEN 1904 AND 2320 OR DestWac >= 42 LIMIT 26","hsqls":["SELECT UniqueCarrier, DivTotalGTimes FROM mytable WHERE CRSDepTime BETWEEN 1904 AND 2320 OR DestWac >= 42 LIMIT 10000"]}
{"sql":"SELECT OriginState, DaysSinceEpoch FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'noodles' OR DivTailNums BETWEEN 'N726SK' AND 'N13988' LIMIT 10","hsqls":["SELECT OriginState, DaysSinceEpoch FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'noodles' OR (DivTailNums[1] BETWEEN 'N726SK' AND 'N13988' OR DivTailNums[2] BETWEEN 'N726SK' AND 'N13988' OR DivTailNums[3] BETWEEN 'N726SK' AND 'N13988' OR DivTailNums[4] BETWEEN 'N726SK' AND 'N13988' OR DivTailNums[5] BETWEEN 'N726SK' AND 'N13988') LIMIT 10000"]}
{"sql":"SELECT ActualElapsedTime, DaysSinceEpoch FROM mytable WHERE DivAirportIDs > 14113 ORDER BY TaxiOut LIMIT 8","hsqls":["SELECT ActualElapsedTime, DaysSinceEpoch FROM mytable WHERE (DivAirportIDs[1] > 14113 OR DivAirportIDs[2] > 14113 OR DivAirportIDs[3] > 14113 OR DivAirportIDs[4] > 14113 OR DivAirportIDs[5] > 14113) ORDER BY TaxiOut LIMIT 10000"]}
{"sql":"SELECT DestStateName, DaysSinceEpoch FROM mytable ORDER BY DestState, WeatherDelay, OriginWac LIMIT 6"}
{"sql":"SELECT ArrDel15 FROM mytable WHERE DivTailNums BETWEEN 'N641SW' AND 'N982SW' ORDER BY TotalAddGTime LIMIT 3","hsqls":["SELECT ArrDel15 FROM mytable WHERE (DivTailNums[1] BETWEEN 'N641SW' AND 'N982SW' OR DivTailNums[2] BETWEEN 'N641SW' AND 'N982SW' OR DivTailNums[3] BETWEEN 'N641SW' AND 'N982SW' OR DivTailNums[4] BETWEEN 'N641SW' AND 'N982SW' OR DivTailNums[5] BETWEEN 'N641SW' AND 'N982SW') ORDER BY TotalAddGTime LIMIT 10000"]}
{"sql":"SELECT \"Year\", OriginState, DivLongestGTimes FROM mytable WHERE Quarter > 1 AND DivReachedDest BETWEEN 0 AND 0 OR DayOfWeek <= 2 LIMIT 8","hsqls":["SELECT Year, OriginState, DivLongestGTimes FROM mytable WHERE Quarter > 1 AND DivReachedDest BETWEEN 0 AND 0 OR DayOfWeek <= 2 LIMIT 10000"]}
{"sql":"SELECT WheelsOff, LateAircraftDelay, CRSArrTime, COUNT(*) FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'B' AND TaxiIn < 40 GROUP BY WheelsOff, LateAircraftDelay, CRSArrTime  ORDER BY WheelsOff, LateAircraftDelay, CRSArrTime LIMIT 12","hsqls":["SELECT WheelsOff, LateAircraftDelay, CRSArrTime, COUNT(*) FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'B' AND TaxiIn < 40 GROUP BY WheelsOff, LateAircraftDelay, CRSArrTime  ORDER BY WheelsOff, LateAircraftDelay, CRSArrTime LIMIT 12"]}
{"sql":"SELECT ArrivalDelayGroups, COUNT(DivActualElapsedTime), MIN(ArrDel15), MIN(CarrierDelay) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 16","hsqls":["SELECT ArrivalDelayGroups, COUNT(DivActualElapsedTime), MIN(ArrDel15), MIN(CarrierDelay) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 16"]}
{"sql":"SELECT CarrierDelay, ArrivalDelayGroups FROM mytable WHERE Dest <> 'CVG' AND OriginCityMarketID IN (33344, 34945, 34992) LIMIT 14"}
{"sql":"SELECT Flights, DayOfWeek FROM mytable WHERE ArrDelay < -9.0 LIMIT 3"}
{"sql":"SELECT AVG(ArrDel15), MIN(DivDistance), MIN(DestCityMarketID) FROM mytable WHERE TailNum IN ('N651SW', 'N156UW') OR ArrTimeBlk BETWEEN '1200-1259' AND '1500-1559' LIMIT 1"}
{"sql":"SELECT Diverted, OriginCityName, DepDel15 FROM mytable WHERE TaxiIn NOT IN (79, 75, 89) AND DestCityName > 'San Angelo, TX' ORDER BY Origin LIMIT 29"}
{"sql":"SELECT ArrTimeBlk, COUNT(DivAirportLandings) FROM mytable WHERE AirlineID BETWEEN 19790 AND 19690 OR DepDelayMinutes IN (397.0, 69.0) GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 13","hsqls":["SELECT ArrTimeBlk, COUNT(DivAirportLandings) FROM mytable WHERE AirlineID BETWEEN 19790 AND 19690 OR DepDelayMinutes IN (397.0, 69.0) GROUP BY ArrTimeBlk  ORDER BY ArrTimeBlk LIMIT 13"]}
{"sql":"SELECT DivWheelsOffs FROM mytable WHERE Flights = 1 AND ArrTimeBlk > '1500-1559' ORDER BY WheelsOff LIMIT 8","hsqls":["SELECT DivWheelsOffs FROM mytable WHERE Flights = 1 AND ArrTimeBlk > '1500-1559' ORDER BY WheelsOff LIMIT 10000"]}
{"sql":"SELECT WheelsOff FROM mytable WHERE TaxiIn BETWEEN 36 AND 65 AND DestWac >= 88 LIMIT 27"}
{"sql":"SELECT DestCityName, WheelsOn FROM mytable WHERE ArrTimeBlk <> '2300-2359' OR FlightDate NOT IN ('2014-01-21', '2014-01-30', '2014-01-11', '2014-01-26', '2014-01-16') OR UniqueCarrier NOT IN ('DL', 'F9', 'WN', 'FL') ORDER BY DestStateFips, TotalAddGTime LIMIT 11"}
{"sql":"SELECT Diverted, OriginCityMarketID FROM mytable WHERE OriginWac IN (3, 67, 83, 87) LIMIT 12"}
{"sql":"SELECT ArrDelay, COUNT(*) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 17","hsqls":["SELECT ArrDelay, COUNT(*) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 17"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE DivReachedDest IN (1, -9999) AND DestCityName BETWEEN 'Eagle, CO' AND 'Toledo, OH' LIMIT 3"}
{"sql":"SELECT DestAirportSeqID FROM mytable WHERE OriginState > 'UT' ORDER BY AirlineID LIMIT 3"}
{"sql":"SELECT ArrTime, DayofMonth, WheelsOn, MIN(ArrDelay), MAX(DestWac) FROM mytable GROUP BY ArrTime, DayofMonth, WheelsOn  ORDER BY ArrTime, DayofMonth, WheelsOn LIMIT 17","hsqls":["SELECT ArrTime, DayofMonth, WheelsOn, MIN(ArrDelay), MAX(DestWac) FROM mytable GROUP BY ArrTime, DayofMonth, WheelsOn  ORDER BY ArrTime, DayofMonth, WheelsOn LIMIT 17"]}
{"sql":"SELECT OriginState, Flights, DestCityMarketID, MIN(DivActualElapsedTime), MAX(ArrDel15), AVG(DayofMonth) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DaysSinceEpoch BETWEEN 16090 AND 16073 GROUP BY OriginState, Flights, DestCityMarketID  ORDER BY OriginState, Flights, DestCityMarketID LIMIT 10","hsqls":["SELECT OriginState, Flights, DestCityMarketID, MIN(DivActualElapsedTime), MAX(ArrDel15), AVG(DayofMonth) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DaysSinceEpoch BETWEEN 16090 AND 16073 GROUP BY OriginState, Flights, DestCityMarketID  ORDER BY OriginState, Flights, DestCityMarketID LIMIT 10"]}
{"sql":"SELECT COUNT(*) FROM mytable LIMIT 28"}
{"sql":"SELECT AirTime, COUNT(DaysSinceEpoch) FROM mytable GROUP BY AirTime  ORDER BY AirTime LIMIT 20","hsqls":["SELECT AirTime, COUNT(DaysSinceEpoch) FROM mytable GROUP BY AirTime  ORDER BY AirTime LIMIT 20"]}
{"sql":"SELECT AVG(DayofMonth), COUNT(CRSElapsedTime) FROM mytable WHERE LateAircraftDelay BETWEEN 151 AND 72 OR \"Year\" IN (2014) LIMIT 14","hsqls":["SELECT AVG(DayofMonth), COUNT(CRSElapsedTime) FROM mytable WHERE LateAircraftDelay BETWEEN 151 AND 72 OR `Year` IN (2014) LIMIT 14"]}
{"sql":"SELECT SUM(DepartureDelayGroups) FROM mytable WHERE OriginState = 'MD' OR DestWac BETWEEN 83 AND 43 OR Flights < 1 LIMIT 26"}
{"sql":"SELECT DivDistance, COUNT(*) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 6","hsqls":["SELECT DivDistance, COUNT(*) FROM mytable GROUP BY DivDistance  ORDER BY DivDistance LIMIT 6"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 295.0 AND 103.0 GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 21","hsqls":["SELECT DaysSinceEpoch, COUNT(*) FROM mytable WHERE ArrDelayMinutes BETWEEN 295.0 AND 103.0 GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 21"]}
{"sql":"SELECT DestStateName FROM mytable WHERE DayOfWeek >= 1 LIMIT 15"}
{"sql":"SELECT Cancelled, DivArrDelay, DayOfWeek, COUNT(CancellationCode) FROM mytable WHERE AirTime NOT IN (112, 305, 177) OR DistanceGroup BETWEEN 7 AND 8 GROUP BY Cancelled, DivArrDelay, DayOfWeek  ORDER BY Cancelled, DivArrDelay, DayOfWeek LIMIT 10","hsqls":["SELECT Cancelled, DivArrDelay, DayOfWeek, COUNT(CancellationCode) FROM mytable WHERE AirTime NOT IN (112, 305, 177) OR DistanceGroup BETWEEN 7 AND 8 GROUP BY Cancelled, DivArrDelay, DayOfWeek  ORDER BY Cancelled, DivArrDelay, DayOfWeek LIMIT 10"]}
{"sql":"SELECT OriginAirportSeqID, DivArrDelay FROM mytable WHERE DivTailNums > 'N565AA' AND DestAirportID BETWEEN 11603 AND 11865 LIMIT 22","hsqls":["SELECT OriginAirportSeqID, DivArrDelay FROM mytable WHERE (DivTailNums[1] > 'N565AA' OR DivTailNums[2] > 'N565AA' OR DivTailNums[3] > 'N565AA' OR DivTailNums[4] > 'N565AA' OR DivTailNums[5] > 'N565AA') AND DestAirportID BETWEEN 11603 AND 11865 LIMIT 10000"]}
{"sql":"SELECT FirstDepTime, NASDelay, SUM(WheelsOff), AVG(DistanceGroup) FROM mytable WHERE DivReachedDest >= 1 GROUP BY FirstDepTime, NASDelay  ORDER BY FirstDepTime, NASDelay LIMIT 16","hsqls":["SELECT FirstDepTime, NASDelay, SUM(WheelsOff), AVG(DistanceGroup) FROM mytable WHERE DivReachedDest >= 1 GROUP BY FirstDepTime, NASDelay  ORDER BY FirstDepTime, NASDelay LIMIT 16"]}
{"sql":"SELECT LongestAddGTime, DayofMonth, OriginAirportID FROM mytable WHERE OriginState = 'OR' AND Cancelled = 0 LIMIT 23"}
{"sql":"SELECT Carrier, OriginAirportID FROM mytable WHERE DivAirportSeqIDs IN (1385103, 1302402) ORDER BY OriginState LIMIT 25","hsqls":["SELECT Carrier, OriginAirportID FROM mytable WHERE (DivAirportSeqIDs[1] IN (1385103, 1302402) OR DivAirportSeqIDs[2] IN (1385103, 1302402) OR DivAirportSeqIDs[3] IN (1385103, 1302402) OR DivAirportSeqIDs[4] IN (1385103, 1302402) OR DivAirportSeqIDs[5] IN (1385103, 1302402)) ORDER BY OriginState LIMIT 10000"]}
{"sql":"SELECT OriginCityName, ArrDelayMinutes, DayOfWeek FROM mytable WHERE AirTime BETWEEN 265 AND 481 AND DivLongestGTimes IN (13.0, 22.0, 118.0, 62.0, 90.0) OR DivWheelsOffs BETWEEN 1955 AND 1240 ORDER BY DestStateName LIMIT 4","hsqls":["SELECT OriginCityName, ArrDelayMinutes, DayOfWeek FROM mytable WHERE AirTime BETWEEN 265 AND 481 AND (DivLongestGTimes[1] IN (13.0, 22.0, 118.0, 62.0, 90.0) OR DivLongestGTimes[2] IN (13.0, 22.0, 118.0, 62.0, 90.0) OR DivLongestGTimes[3] IN (13.0, 22.0, 118.0, 62.0, 90.0) OR DivLongestGTimes[4] IN (13.0, 22.0, 118.0, 62.0, 90.0) OR DivLongestGTimes[5] IN (13.0, 22.0, 118.0, 62.0, 90.0)) OR (DivWheelsOffs[1] BETWEEN 1955 AND 1240 OR DivWheelsOffs[2] BETWEEN 1955 AND 1240 OR DivWheelsOffs[3] BETWEEN 1955 AND 1240 OR DivWheelsOffs[4] BETWEEN 1955 AND 1240 OR DivWheelsOffs[5] BETWEEN 1955 AND 1240) ORDER BY DestStateName LIMIT 10000"]}
{"sql":"SELECT SUM(\"Year\") FROM mytable WHERE ArrivalDelayGroups NOT IN (10, 0, 4, 9, -9999) LIMIT 24","hsqls":["SELECT SUM(`Year`) FROM mytable WHERE ArrivalDelayGroups NOT IN (10, 0, 4, 9, -9999) LIMIT 24"]}
{"sql":"SELECT OriginWac, CRSDepTime FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 AND OriginStateName BETWEEN 'Mississippi' AND 'Utah' AND AirlineID BETWEEN 20436 AND 20304 ORDER BY DivArrDelay LIMIT 2","hsqls":["SELECT OriginWac, CRSDepTime FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 AND OriginStateName BETWEEN 'Mississippi' AND 'Utah' AND AirlineID BETWEEN 20436 AND 20304 ORDER BY DivArrDelay LIMIT 2"]}
{"sql":"SELECT OriginStateFips, ArrDel15, OriginStateName, AVG(OriginWac), MAX(DepDel15), SUM(TaxiIn) FROM mytable WHERE LateAircraftDelay = 31 OR DivReachedDest = 0 OR OriginCityMarketID = 30255 GROUP BY OriginStateFips, ArrDel15, OriginStateName  ORDER BY OriginStateFips, ArrDel15, OriginStateName LIMIT 23","hsqls":["SELECT OriginStateFips, ArrDel15, OriginStateName, AVG(OriginWac), MAX(DepDel15), SUM(TaxiIn) FROM mytable WHERE LateAircraftDelay = 31 OR DivReachedDest = 0 OR OriginCityMarketID = 30255 GROUP BY OriginStateFips, ArrDel15, OriginStateName  ORDER BY OriginStateFips, ArrDel15, OriginStateName LIMIT 23"]}
{"sql":"SELECT OriginStateFips, AirlineID, ArrivalDelayGroups, AVG(Quarter) FROM mytable GROUP BY OriginStateFips, AirlineID, ArrivalDelayGroups  ORDER BY OriginStateFips, AirlineID, ArrivalDelayGroups LIMIT 2","hsqls":["SELECT OriginStateFips, AirlineID, ArrivalDelayGroups, AVG(Quarter) FROM mytable GROUP BY OriginStateFips, AirlineID, ArrivalDelayGroups  ORDER BY OriginStateFips, AirlineID, ArrivalDelayGroups LIMIT 2"]}
{"sql":"SELECT DivReachedDest, CRSArrTime, FlightDate, COUNT(DepTimeBlk) FROM mytable WHERE OriginAirportID < 14842 GROUP BY DivReachedDest, CRSArrTime, FlightDate  ORDER BY DivReachedDest, CRSArrTime, FlightDate LIMIT 15","hsqls":["SELECT DivReachedDest, CRSArrTime, FlightDate, COUNT(DepTimeBlk) FROM mytable WHERE OriginAirportID < 14842 GROUP BY DivReachedDest, CRSArrTime, FlightDate  ORDER BY DivReachedDest, CRSArrTime, FlightDate LIMIT 15"]}
{"sql":"SELECT DestStateFips, ArrivalDelayGroups FROM mytable WHERE OriginAirportSeqID BETWEEN 1357702 AND 1153703 ORDER BY \"Month\" LIMIT 5","hsqls":["SELECT DestStateFips, ArrivalDelayGroups FROM mytable WHERE OriginAirportSeqID BETWEEN 1357702 AND 1153703 ORDER BY `Month` LIMIT 5"]}
{"sql":"SELECT DestState, FlightNum, DaysSinceEpoch, SUM(OriginAirportID), AVG(Quarter) FROM mytable WHERE DivWheelsOns < 1226 OR AirTime = 163 GROUP BY DestState, FlightNum, DaysSinceEpoch LIMIT 25","hsqls":["SELECT DestState, FlightNum, DaysSinceEpoch, SUM(OriginAirportID), AVG(Quarter) FROM mytable WHERE (DivWheelsOns[1] < 1226 OR DivWheelsOns[2] < 1226 OR DivWheelsOns[3] < 1226 OR DivWheelsOns[4] < 1226 OR DivWheelsOns[5] < 1226) OR AirTime = 163 GROUP BY DestState, FlightNum, DaysSinceEpoch LIMIT 10000"]}
{"sql":"SELECT AVG(ArrTime), COUNT(DistanceGroup), MIN(DepTime) FROM mytable WHERE OriginStateName IN ('Colorado', 'Kansas', 'New York')"}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ArrTime IN (19, 1835) OR OriginAirportID NOT IN (13502, 14570, 13487) OR NASDelay BETWEEN 60 AND 42 LIMIT 28"}
{"sql":"SELECT TaxiOut, NASDelay, DepTimeBlk FROM mytable WHERE Diverted IN (1, 0) AND DestAirportSeqID = 1336703 ORDER BY DestStateName, ArrivalDelayGroups LIMIT 14"}
{"sql":"SELECT DestAirportID, COUNT(*) FROM mytable WHERE DivAirportIDs BETWEEN 10135 AND 11109 GROUP BY DestAirportID LIMIT 12","hsqls":["SELECT DestAirportID, COUNT(*) FROM mytable WHERE (DivAirportIDs[1] BETWEEN 10135 AND 11109 OR DivAirportIDs[2] BETWEEN 10135 AND 11109 OR DivAirportIDs[3] BETWEEN 10135 AND 11109 OR DivAirportIDs[4] BETWEEN 10135 AND 11109 OR DivAirportIDs[5] BETWEEN 10135 AND 11109) GROUP BY DestAirportID LIMIT 10000"]}
{"sql":"SELECT DepTime FROM mytable WHERE DivReachedDest BETWEEN 1 AND 1 ORDER BY DepartureDelayGroups, CRSElapsedTime LIMIT 10"}
{"sql":"SELECT DepDelayMinutes, MIN(DestAirportID) FROM mytable GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 2","hsqls":["SELECT DepDelayMinutes, MIN(DestAirportID) FROM mytable GROUP BY DepDelayMinutes  ORDER BY DepDelayMinutes LIMIT 2"]}
{"sql":"SELECT OriginStateFips, TailNum, COUNT(*) FROM mytable WHERE DivTailNums BETWEEN 'N914DE' AND 'N703JB' OR Carrier BETWEEN 'EV' AND 'F9' GROUP BY OriginStateFips, TailNum LIMIT 20","hsqls":["SELECT OriginStateFips, TailNum, COUNT(*) FROM mytable WHERE (DivTailNums[1] BETWEEN 'N914DE' AND 'N703JB' OR DivTailNums[2] BETWEEN 'N914DE' AND 'N703JB' OR DivTailNums[3] BETWEEN 'N914DE' AND 'N703JB' OR DivTailNums[4] BETWEEN 'N914DE' AND 'N703JB' OR DivTailNums[5] BETWEEN 'N914DE' AND 'N703JB') OR Carrier BETWEEN 'EV' AND 'F9' GROUP BY OriginStateFips, TailNum LIMIT 10000"]}
{"sql":"SELECT AVG(AirTime), COUNT(ArrDel15) FROM mytable WHERE CRSDepTime BETWEEN 1834 AND 607 AND Flights > 1 LIMIT 18"}
{"sql":"SELECT Distance, COUNT(TaxiIn) FROM mytable WHERE OriginState IN ('MT', 'VA', 'KY', 'WV') OR OriginStateName >= 'South Dakota' GROUP BY Distance  ORDER BY Distance LIMIT 19","hsqls":["SELECT Distance, COUNT(TaxiIn) FROM mytable WHERE OriginState IN ('MT', 'VA', 'KY', 'WV') OR OriginStateName >= 'South Dakota' GROUP BY Distance  ORDER BY Distance LIMIT 19"]}
{"sql":"SELECT COUNT(DistanceGroup) FROM mytable WHERE DivTailNums BETWEEN 'N541AA' AND 'N14174' OR \"Month\" = 1 AND TaxiOut BETWEEN -9999 AND 34 LIMIT 7","hsqls":["SELECT COUNT(DistanceGroup) FROM mytable WHERE (DivTailNums[1] BETWEEN 'N541AA' AND 'N14174' OR DivTailNums[2] BETWEEN 'N541AA' AND 'N14174' OR DivTailNums[3] BETWEEN 'N541AA' AND 'N14174' OR DivTailNums[4] BETWEEN 'N541AA' AND 'N14174' OR DivTailNums[5] BETWEEN 'N541AA' AND 'N14174') OR `Month` = 1 AND TaxiOut BETWEEN -9999 AND 34 LIMIT 10000"]}
{"sql":"SELECT DepDel15, COUNT(*) FROM mytable GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 4","hsqls":["SELECT DepDel15, COUNT(*) FROM mytable GROUP BY DepDel15  ORDER BY DepDel15 LIMIT 4"]}
{"sql":"SELECT OriginAirportSeqID, FirstDepTime, SUM(CarrierDelay), MAX(Flights), AVG(DestStateFips) FROM mytable GROUP BY OriginAirportSeqID, FirstDepTime  ORDER BY OriginAirportSeqID, FirstDepTime LIMIT 7","hsqls":["SELECT OriginAirportSeqID, FirstDepTime, SUM(CarrierDelay), MAX(Flights), AVG(DestStateFips) FROM mytable GROUP BY OriginAirportSeqID, FirstDepTime  ORDER BY OriginAirportSeqID, FirstDepTime LIMIT 7"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE UniqueCarrier BETWEEN 'VX' AND 'US' LIMIT 12"}
{"sql":"SELECT OriginState, DepTimeBlk, UniqueCarrier FROM mytable WHERE Flights NOT IN (1) OR DivAirportSeqIDs > 1234302 ORDER BY DivReachedDest, ArrTimeBlk LIMIT 1","hsqls":["SELECT OriginState, DepTimeBlk, UniqueCarrier FROM mytable WHERE Flight