/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.header.ODataPreferences;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.batch.BatchManager;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.core.communication.request.batch.AbstractBatchManager;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.communication.response.batch.ODataBatchResponseManager;

public class ODataBatchRequestImpl
extends AbstractODataBatchRequest<ODataBatchResponse, BatchManager>
implements ODataBatchRequest {
    public ODataBatchRequestImpl(ODataClient odataClient, URI uri) {
        super(odataClient, uri);
        this.setAccept(odataClient.getConfiguration().getDefaultBatchAcceptFormat().toContentTypeString());
    }

    @Override
    protected BatchManager getPayloadManager() {
        if (this.payloadManager == null) {
            this.payloadManager = new BatchManagerImpl(this);
        }
        return (BatchManager)this.payloadManager;
    }

    public ODataBatchRequest rawAppend(byte[] toBeStreamed) throws IOException {
        this.getPayloadManager().getBodyStreamWriter().write(toBeStreamed);
        return this;
    }

    public ODataBatchRequest rawAppend(byte[] toBeStreamed, int off, int len) throws IOException {
        this.getPayloadManager().getBodyStreamWriter().write(toBeStreamed, off, len);
        return this;
    }

    @Override
    protected HttpResponse doExecute() {
        if (this.odataClient.getConfiguration().isContinueOnError()) {
            this.setPrefer(new ODataPreferences().continueOnError());
        }
        return super.doExecute();
    }

    public class BatchManagerImpl
    extends AbstractBatchManager
    implements BatchManager {
        public BatchManagerImpl(ODataBatchRequest req) {
            super(req, ODataBatchRequestImpl.this.futureWrapper, ODataBatchRequestImpl.this.odataClient.getConfiguration().isContinueOnError());
        }

        @Override
        protected ODataBatchResponse getResponseInstance(long timeout, TimeUnit unit) {
            return new ODataBatchResponseImpl(ODataBatchRequestImpl.this.odataClient, ODataBatchRequestImpl.this.httpClient, this.getHttpResponse(timeout, unit));
        }

        @Override
        protected void validateSingleRequest(ODataBatchableRequest request) {
        }
    }

    protected class ODataBatchResponseImpl
    extends AbstractODataResponse
    implements ODataBatchResponse {
        protected ODataBatchResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
        }

        public Iterator<ODataBatchResponseItem> getBody() {
            return new ODataBatchResponseManager(this, ODataBatchRequestImpl.this.expectedResItems, this.odataClient.getConfiguration().isContinueOnError());
        }

        @Override
        public void close() {
            for (ODataBatchResponseItem resItem : ODataBatchRequestImpl.this.expectedResItems) {
                resItem.close();
            }
            super.close();
        }
    }
}

