/****************************************************************************
 * arch/risc-v/src/rp23xx-rv/hardware/rp23xx_io_qspi.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_IO_QSPI_H
#define __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_IO_QSPI_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/rp23xx_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Register offsets *********************************************************/

#define RP23XX_IO_QSPI_USBPHY_DP_STATUS_OFFSET                  0x00000000
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_OFFSET                    0x00000004
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS_OFFSET                  0x00000008
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_OFFSET                    0x0000000c
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_OFFSET             0x00000010
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_OFFSET               0x00000014
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_OFFSET               0x00000018
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_OFFSET                 0x0000001c
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_OFFSET              0x00000020
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_OFFSET                0x00000024
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_OFFSET              0x00000028
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_OFFSET                0x0000002c
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_OFFSET              0x00000030
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_OFFSET                0x00000034
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_OFFSET              0x00000038
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_OFFSET                0x0000003c
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_OFFSET           0x00000200
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_OFFSET        0x00000204
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_OFFSET           0x00000208
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_OFFSET        0x0000020c
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_OFFSET    0x00000210
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_OFFSET 0x00000214
#define RP23XX_IO_QSPI_INTR_OFFSET                              0x00000218
#define RP23XX_IO_QSPI_PROC0_INTE_OFFSET                        0x0000021c
#define RP23XX_IO_QSPI_PROC0_INTF_OFFSET                        0x00000220
#define RP23XX_IO_QSPI_PROC0_INTS_OFFSET                        0x00000224
#define RP23XX_IO_QSPI_PROC1_INTE_OFFSET                        0x00000228
#define RP23XX_IO_QSPI_PROC1_INTF_OFFSET                        0x0000022c
#define RP23XX_IO_QSPI_PROC1_INTS_OFFSET                        0x00000230
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_OFFSET                 0x00000234
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_OFFSET                 0x00000238
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_OFFSET                 0x0000023c

/* Register definitions *****************************************************/

#define RP23XX_IO_QSPI_USBPHY_DP_STATUS                     (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_USBPHY_DP_STATUS_OFFSET)
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL                       (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_USBPHY_DP_CTRL_OFFSET)
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS                     (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_USBPHY_DM_STATUS_OFFSET)
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL                       (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_USBPHY_DM_CTRL_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS                (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL                  (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS                  (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL                    (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS                 (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL                   (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS                 (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL                   (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS                 (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL                   (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS                 (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_OFFSET)
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL                   (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_OFFSET)
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE              (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_OFFSET)
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_OFFSET)
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE              (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_OFFSET)
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_OFFSET)
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE       (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_OFFSET)
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE    (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_OFFSET)
#define RP23XX_IO_QSPI_INTR                                 (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_INTR_OFFSET)
#define RP23XX_IO_QSPI_PROC0_INTE                           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_PROC0_INTE_OFFSET)
#define RP23XX_IO_QSPI_PROC0_INTF                           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_PROC0_INTF_OFFSET)
#define RP23XX_IO_QSPI_PROC0_INTS                           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_PROC0_INTS_OFFSET)
#define RP23XX_IO_QSPI_PROC1_INTE                           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_PROC1_INTE_OFFSET)
#define RP23XX_IO_QSPI_PROC1_INTF                           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_PROC1_INTF_OFFSET)
#define RP23XX_IO_QSPI_PROC1_INTS                           (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_PROC1_INTS_OFFSET)
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE                    (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_DORMANT_WAKE_INTE_OFFSET)
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF                    (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_DORMANT_WAKE_INTF_OFFSET)
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS                    (RP23XX_IO_QSPI_BASE + RP23XX_IO_QSPI_DORMANT_WAKE_INTS_OFFSET)

/* Register bit definitions *************************************************/

#define RP23XX_IO_QSPI_USBPHY_DP_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_USBPHY_DP_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_USBPHY_DP_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_USBPHY_DP_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_USBPHY_DP_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_USBPHY_DP_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_USBPHY_DM_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_USBPHY_DM_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_GPIO_QSPI_SCLK_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_GPIO_QSPI_SS_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD0_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD1_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD2_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_MASK   0x04022200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQTOPROC_MASK   0x04000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_INFROMPAD_MASK   0x00020000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_OETOPAD_MASK   0x00002000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTTOPAD_MASK   0x00000200
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_MASK   0x3003f01f
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_MASK   0x30000000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_MASK   0x00030000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_MASK   0x0000c000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_MASK   0x00003000
#define RP23XX_IO_QSPI_GPIO_QSPI_SD3_CTRL_FUNCSEL_MASK   0x0000001f
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_MASK   0x000000ff
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD3_MASK   0x00000080
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD2_MASK   0x00000040
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD1_MASK   0x00000020
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD0_MASK   0x00000010
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SS_MASK   0x00000008
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SCLK_MASK   0x00000004
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_USBPHY_DM_MASK   0x00000002
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_SECURE_USBPHY_DP_MASK   0x00000001
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_MASK   0x000000ff
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD3_MASK   0x00000080
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD2_MASK   0x00000040
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD1_MASK   0x00000020
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD0_MASK   0x00000010
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SS_MASK   0x00000008
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SCLK_MASK   0x00000004
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_USBPHY_DM_MASK   0x00000002
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC0_NONSECURE_USBPHY_DP_MASK   0x00000001
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_MASK   0x000000ff
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD3_MASK   0x00000080
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD2_MASK   0x00000040
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD1_MASK   0x00000020
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD0_MASK   0x00000010
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SS_MASK   0x00000008
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SCLK_MASK   0x00000004
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_USBPHY_DM_MASK   0x00000002
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_SECURE_USBPHY_DP_MASK   0x00000001
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_MASK   0x000000ff
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD3_MASK   0x00000080
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD2_MASK   0x00000040
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD1_MASK   0x00000020
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD0_MASK   0x00000010
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SS_MASK   0x00000008
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SCLK_MASK   0x00000004
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_USBPHY_DM_MASK   0x00000002
#define RP23XX_IO_QSPI_IRQSUMMARY_PROC1_NONSECURE_USBPHY_DP_MASK   0x00000001
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_MASK   0x000000ff
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD3_MASK   0x00000080
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD2_MASK   0x00000040
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD1_MASK   0x00000020
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD0_MASK   0x00000010
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SS_MASK   0x00000008
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SCLK_MASK   0x00000004
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_USBPHY_DM_MASK   0x00000002
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_SECURE_USBPHY_DP_MASK   0x00000001
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_MASK   0x000000ff
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD3_MASK   0x00000080
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD2_MASK   0x00000040
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD1_MASK   0x00000020
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD0_MASK   0x00000010
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SS_MASK   0x00000008
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SCLK_MASK   0x00000004
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_USBPHY_DM_MASK   0x00000002
#define RP23XX_IO_QSPI_IRQSUMMARY_DORMANT_WAKE_NONSECURE_USBPHY_DP_MASK   0x00000001
#define RP23XX_IO_QSPI_INTR_MASK   0xffffffff
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_INTR_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_INTR_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_INTR_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_INTR_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_INTR_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_INTR_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_INTR_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_INTR_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_PROC0_INTE_MASK   0xffffffff
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_PROC0_INTE_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_PROC0_INTF_MASK   0xffffffff
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_PROC0_INTF_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_PROC0_INTS_MASK   0xffffffff
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_PROC0_INTS_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_PROC1_INTE_MASK   0xffffffff
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_PROC1_INTE_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_PROC1_INTF_MASK   0xffffffff
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_PROC1_INTF_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_PROC1_INTS_MASK   0xffffffff
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_PROC1_INTS_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_MASK   0xffffffff
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTE_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_MASK   0xffffffff
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTF_USBPHY_DP_LEVEL_LOW_MASK   0x00000001
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_MASK   0xffffffff
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH_MASK   0x80000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW_MASK   0x40000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_MASK   0x20000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW_MASK   0x10000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH_MASK   0x08000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW_MASK   0x04000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_MASK   0x02000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW_MASK   0x01000000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH_MASK   0x00800000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW_MASK   0x00400000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_MASK   0x00200000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW_MASK   0x00100000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH_MASK   0x00080000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW_MASK   0x00040000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_MASK   0x00020000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW_MASK   0x00010000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH_MASK   0x00008000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW_MASK   0x00004000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH_MASK   0x00002000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW_MASK   0x00001000
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_MASK   0x00000800
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW_MASK   0x00000400
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_MASK   0x00000200
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_MASK   0x00000100
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DM_EDGE_HIGH_MASK   0x00000080
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DM_EDGE_LOW_MASK   0x00000040
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DM_LEVEL_HIGH_MASK   0x00000020
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DM_LEVEL_LOW_MASK   0x00000010
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DP_EDGE_HIGH_MASK   0x00000008
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DP_EDGE_LOW_MASK   0x00000004
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DP_LEVEL_HIGH_MASK   0x00000002
#define RP23XX_IO_QSPI_DORMANT_WAKE_INTS_USBPHY_DP_LEVEL_LOW_MASK   0x00000001

#endif /* __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_IO_QSPI_H */
