/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class MinusEvaluator
extends NumberEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<Number> minusValue;

    public MinusEvaluator(Evaluator<Number> subject, Evaluator<Number> minusValue) {
        this.subject = subject;
        this.minusValue = minusValue;
    }

    @Override
    public QueryResult<Number> evaluate(EvaluationContext evaluationContext) {
        Number subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Number minus = this.minusValue.evaluate(evaluationContext).getValue();
        if (minus == null) {
            return new NumberQueryResult(null);
        }
        Number result = subjectValue instanceof Double || minus instanceof Double ? (Number)(subjectValue.doubleValue() - minus.doubleValue()) : (Number)(subjectValue.longValue() - minus.longValue());
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

