/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

abstract class BusyIcon
implements Icon {
    protected final int width;
    protected final int height;

    protected BusyIcon(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static BusyIcon create(boolean selectedTab) {
        Icon img = UIManager.getIcon("nb.tabcontrol.busy.icon." + (selectedTab ? "selected" : "normal"));
        if (null != img) {
            return new ImageBusyIcon(ImageUtilities.icon2Image(img));
        }
        return VectorBusyIcon.create();
    }

    abstract void tick();

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    private static int getBusyIconSize() {
        int res = UIManager.getInt("Nb.BusyIcon.Height");
        if (res < 1) {
            res = 16;
        }
        return res;
    }

    private static class VectorBusyIcon
    extends BusyIcon {
        private static final float MIN_ALPHA = 0.16f;
        private static final float MAX_ALPHA = 0.89f;
        private static final int ARMS = 12;
        private static final float STROKE_WIDTH = 1.25f;
        private static final double INNER_RADIUS = 4.0;
        private static final double OUTER_RADIUS = 7.0;
        private int darkestArm = 0;

        private VectorBusyIcon(int height) {
            super(height, height);
        }

        public static BusyIcon create() {
            return new VectorBusyIcon(BusyIcon.getBusyIconSize());
        }

        @Override
        void tick() {
            this.darkestArm = (this.darkestArm + 1) % 12;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g0, int x, int y) {
            Graphics2D g = (Graphics2D)g0.create();
            try {
                g.translate(x, y);
                this.paintHelper(g);
            }
            finally {
                g.dispose();
            }
        }

        private void paintHelper(Graphics2D g) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setStroke(new BasicStroke(1.25f, 1, 1));
            g.translate((double)this.getIconWidth() / 2.0, (double)this.getIconHeight() / 2.0);
            for (int i = 0; i < 12; ++i) {
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.16f + 0.73f * (float)Math.pow((float)((this.darkestArm + i) % 12) / 11.0f, 3.0)));
                double angle = -0.5235987755982988 * (double)i;
                double kY = Math.sin(angle);
                double kX = Math.cos(angle);
                g.draw(new Line2D.Double(4.0 * kX, 4.0 * kY, 7.0 * kX, 7.0 * kY));
            }
        }
    }

    private static class ImageBusyIcon
    extends BusyIcon {
        private final Image img;
        private int state = 0;
        private AffineTransform at;
        private static final int STEP = 15;

        public ImageBusyIcon(Image img) {
            super(img.getWidth(null), img.getHeight(null));
            this.img = img;
        }

        @Override
        void tick() {
            this.state += 15;
            if (this.state >= 360) {
                this.state = 0;
            }
            this.at = new AffineTransform();
            this.at.rotate((double)this.state * Math.PI / 180.0, this.width / 2, this.height / 2);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2d.translate(x, y);
                g2d.drawImage(this.img, this.at, null);
                g2d.translate(-x, -y);
            }
        }
    }
}

