/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.analysis.DescriptionReader;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.Utils;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.analysis.ui.Bundle;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class RequiredPluginsNode
extends AbstractNode {
    private final Collection<? extends Analyzer.MissingPlugin> requiredPlugins;

    public RequiredPluginsNode(final Collection<? extends Analyzer.MissingPlugin> requiredPlugins) {
        super(Children.LEAF, Lookups.fixed(new DescriptionReader(){

            @Override
            public CharSequence getDescription() {
                StringBuilder missingPlugins = new StringBuilder();
                for (Analyzer.MissingPlugin p : requiredPlugins) {
                    missingPlugins.append("<li>").append(SPIAccessor.ACCESSOR.getDisplayName(p)).append("</li>");
                }
                return Bundle.DESC_MissingPlugins(missingPlugins.toString());
            }
        }));
        this.requiredPlugins = new ArrayList<Analyzer.MissingPlugin>(requiredPlugins);
        this.setDisplayName(Bundle.DN_MissingPlugins());
        this.setIconBaseWithExtension("org/netbeans/modules/analysis/ui/resources/warning.gif");
    }

    @Override
    public Action[] getActions(boolean context) {
        return new Action[]{new ActionImpl(this.requiredPlugins)};
    }

    private static final class ActionImpl
    extends AbstractAction {
        private Collection<? extends Analyzer.MissingPlugin> requiredPlugins;

        public ActionImpl(Collection<? extends Analyzer.MissingPlugin> requiredPlugins) {
            this.putValue("Name", Bundle.LBL_InstallPlugins());
            this.requiredPlugins = requiredPlugins;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Utils.installMissingPlugins(this.requiredPlugins);
        }
    }
}

