/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.FileBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class CreateFromTemplateHandler {
    private static final String PROP_TEMPLATE = "template";
    private static final String ATTR_TEMPLATE_PREFIX = "template.";

    protected abstract boolean accept(CreateDescriptor var1);

    @NonNull
    protected abstract List<FileObject> createFromTemplate(CreateDescriptor var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     */
    static String mapParameters(String expression, Map<String, ?> parameters) {
        int start = 0;
        int pos = 0;
        StringBuilder sb = null;
        while (true) {
            Object v;
            int nested;
            int state;
            int endPos;
            if ((pos = expression.indexOf("${", pos)) != -1) {
                if (pos > 0 && expression.charAt(pos - 1) == '\\') {
                    pos += 2;
                    continue;
                }
                endPos = pos + 2;
                state = 0;
                nested = 0;
            } else {
                if (sb == null) {
                    return expression;
                }
                if (start < expression.length()) {
                    sb.append(expression.substring(start));
                }
                return CreateFromTemplateHandler.mapParameters(sb.toString(), parameters);
            }
            block7: while (endPos < expression.length()) {
                char c = expression.charAt(endPos);
                if (state == 1) {
                    state = 0;
                    ++endPos;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        state = 1;
                        break;
                    }
                    case '$': {
                        state = 2;
                        break;
                    }
                    case '{': {
                        if (state != 2) break;
                        state = 0;
                        ++nested;
                        break;
                    }
                    case '}': {
                        if (state == 0 && nested-- == 0) break block7;
                    }
                }
                ++endPos;
            }
            if (endPos >= expression.length()) {
                pos += 2;
                continue;
            }
            String token = expression.substring(pos + 2, endPos);
            String defValue = null;
            int colon = token.indexOf(58);
            if (colon != -1) {
                defValue = token.substring(colon + 1);
                token = token.substring(0, colon);
            }
            if ((v = parameters.get(token)) == null) {
                v = defValue;
            }
            if (v == null) {
                pos += 2;
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(expression.substring(start, pos)).append(v.toString());
            pos = start = endPos + 1;
        }
    }

    public static void copyAttributesFromTemplate(CreateFromTemplateHandler h, FileObject from, FileObject to) throws IOException {
        FileUtil.copyAttributes(from, to, (n, v) -> {
            if ("javax.script.ScriptEngine".equals(n) || n.startsWith(ATTR_TEMPLATE_PREFIX) || PROP_TEMPLATE.equals(n)) {
                return null;
            }
            return FileUtil.defaultAttributesTransformer().apply((String)n, v);
        });
    }

    protected static List<FileObject> defaultCopyContents(CreateDescriptor origDescriptor, FileObject contentsParent, FileObject target) throws IOException {
        if (contentsParent == null) {
            contentsParent = origDescriptor.getTemplate();
        }
        if (contentsParent == null || !contentsParent.isFolder()) {
            throw new IllegalArgumentException("contentsParent is not a folder: " + contentsParent.getPath());
        }
        ArrayList<FileObject> r = new ArrayList<FileObject>();
        if (!origDescriptor.getParameters().containsKey("_noFolders")) {
            r.add(target);
        }
        for (FileObject child : origDescriptor.getTemplate().getChildren()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>(origDescriptor.getParameters());
            parameters.remove("name");
            parameters.remove("nameAndExt");
            parameters.put("_noFolders", Boolean.TRUE);
            FileBuilder b = new FileBuilder(child, target);
            b.defaultMode(FileBuilder.Mode.COPY).useLookup(origDescriptor.getLookup()).withParameters(parameters).createDescriptor(true);
            List<FileObject> files = b.build();
            if (!child.isFolder() && !Boolean.TRUE.equals(child.getAttribute("template.openFile"))) continue;
            r.addAll(files);
        }
        return r;
    }
}

