/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import jpt.sun.tools.classfile.Instruction;

public enum Opcode {
    NOP(0),
    ACONST_NULL(1),
    ICONST_M1(2),
    ICONST_0(3),
    ICONST_1(4),
    ICONST_2(5),
    ICONST_3(6),
    ICONST_4(7),
    ICONST_5(8),
    LCONST_0(9),
    LCONST_1(10),
    FCONST_0(11),
    FCONST_1(12),
    FCONST_2(13),
    DCONST_0(14),
    DCONST_1(15),
    BIPUSH(16, Instruction.Kind.BYTE),
    SIPUSH(17, Instruction.Kind.SHORT),
    LDC(18, Instruction.Kind.CPREF),
    LDC_W(19, Instruction.Kind.CPREF_W),
    LDC2_W(20, Instruction.Kind.CPREF_W),
    ILOAD(21, Instruction.Kind.LOCAL),
    LLOAD(22, Instruction.Kind.LOCAL),
    FLOAD(23, Instruction.Kind.LOCAL),
    DLOAD(24, Instruction.Kind.LOCAL),
    ALOAD(25, Instruction.Kind.LOCAL),
    ILOAD_0(26),
    ILOAD_1(27),
    ILOAD_2(28),
    ILOAD_3(29),
    LLOAD_0(30),
    LLOAD_1(31),
    LLOAD_2(32),
    LLOAD_3(33),
    FLOAD_0(34),
    FLOAD_1(35),
    FLOAD_2(36),
    FLOAD_3(37),
    DLOAD_0(38),
    DLOAD_1(39),
    DLOAD_2(40),
    DLOAD_3(41),
    ALOAD_0(42),
    ALOAD_1(43),
    ALOAD_2(44),
    ALOAD_3(45),
    IALOAD(46),
    LALOAD(47),
    FALOAD(48),
    DALOAD(49),
    AALOAD(50),
    BALOAD(51),
    CALOAD(52),
    SALOAD(53),
    ISTORE(54, Instruction.Kind.LOCAL),
    LSTORE(55, Instruction.Kind.LOCAL),
    FSTORE(56, Instruction.Kind.LOCAL),
    DSTORE(57, Instruction.Kind.LOCAL),
    ASTORE(58, Instruction.Kind.LOCAL),
    ISTORE_0(59),
    ISTORE_1(60),
    ISTORE_2(61),
    ISTORE_3(62),
    LSTORE_0(63),
    LSTORE_1(64),
    LSTORE_2(65),
    LSTORE_3(66),
    FSTORE_0(67),
    FSTORE_1(68),
    FSTORE_2(69),
    FSTORE_3(70),
    DSTORE_0(71),
    DSTORE_1(72),
    DSTORE_2(73),
    DSTORE_3(74),
    ASTORE_0(75),
    ASTORE_1(76),
    ASTORE_2(77),
    ASTORE_3(78),
    IASTORE(79),
    LASTORE(80),
    FASTORE(81),
    DASTORE(82),
    AASTORE(83),
    BASTORE(84),
    CASTORE(85),
    SASTORE(86),
    POP(87),
    POP2(88),
    DUP(89),
    DUP_X1(90),
    DUP_X2(91),
    DUP2(92),
    DUP2_X1(93),
    DUP2_X2(94),
    SWAP(95),
    IADD(96),
    LADD(97),
    FADD(98),
    DADD(99),
    ISUB(100),
    LSUB(101),
    FSUB(102),
    DSUB(103),
    IMUL(104),
    LMUL(105),
    FMUL(106),
    DMUL(107),
    IDIV(108),
    LDIV(109),
    FDIV(110),
    DDIV(111),
    IREM(112),
    LREM(113),
    FREM(114),
    DREM(115),
    INEG(116),
    LNEG(117),
    FNEG(118),
    DNEG(119),
    ISHL(120),
    LSHL(121),
    ISHR(122),
    LSHR(123),
    IUSHR(124),
    LUSHR(125),
    IAND(126),
    LAND(127),
    IOR(128),
    LOR(129),
    IXOR(130),
    LXOR(131),
    IINC(132, Instruction.Kind.LOCAL_BYTE),
    I2L(133),
    I2F(134),
    I2D(135),
    L2I(136),
    L2F(137),
    L2D(138),
    F2I(139),
    F2L(140),
    F2D(141),
    D2I(142),
    D2L(143),
    D2F(144),
    I2B(145),
    I2C(146),
    I2S(147),
    LCMP(148),
    FCMPL(149),
    FCMPG(150),
    DCMPL(151),
    DCMPG(152),
    IFEQ(153, Instruction.Kind.BRANCH),
    IFNE(154, Instruction.Kind.BRANCH),
    IFLT(155, Instruction.Kind.BRANCH),
    IFGE(156, Instruction.Kind.BRANCH),
    IFGT(157, Instruction.Kind.BRANCH),
    IFLE(158, Instruction.Kind.BRANCH),
    IF_ICMPEQ(159, Instruction.Kind.BRANCH),
    IF_ICMPNE(160, Instruction.Kind.BRANCH),
    IF_ICMPLT(161, Instruction.Kind.BRANCH),
    IF_ICMPGE(162, Instruction.Kind.BRANCH),
    IF_ICMPGT(163, Instruction.Kind.BRANCH),
    IF_ICMPLE(164, Instruction.Kind.BRANCH),
    IF_ACMPEQ(165, Instruction.Kind.BRANCH),
    IF_ACMPNE(166, Instruction.Kind.BRANCH),
    GOTO(167, Instruction.Kind.BRANCH),
    JSR(168, Instruction.Kind.BRANCH),
    RET(169, Instruction.Kind.LOCAL),
    TABLESWITCH(170, Instruction.Kind.DYNAMIC),
    LOOKUPSWITCH(171, Instruction.Kind.DYNAMIC),
    IRETURN(172),
    LRETURN(173),
    FRETURN(174),
    DRETURN(175),
    ARETURN(176),
    RETURN(177),
    GETSTATIC(178, Instruction.Kind.CPREF_W),
    PUTSTATIC(179, Instruction.Kind.CPREF_W),
    GETFIELD(180, Instruction.Kind.CPREF_W),
    PUTFIELD(181, Instruction.Kind.CPREF_W),
    INVOKEVIRTUAL(182, Instruction.Kind.CPREF_W),
    INVOKESPECIAL(183, Instruction.Kind.CPREF_W),
    INVOKESTATIC(184, Instruction.Kind.CPREF_W),
    INVOKEINTERFACE(185, Instruction.Kind.CPREF_W_UBYTE_ZERO),
    INVOKEDYNAMIC(186, Instruction.Kind.CPREF_W_UBYTE_ZERO),
    NEW(187, Instruction.Kind.CPREF_W),
    NEWARRAY(188, Instruction.Kind.ATYPE),
    ANEWARRAY(189, Instruction.Kind.CPREF_W),
    ARRAYLENGTH(190),
    ATHROW(191),
    CHECKCAST(192, Instruction.Kind.CPREF_W),
    INSTANCEOF(193, Instruction.Kind.CPREF_W),
    MONITORENTER(194),
    MONITOREXIT(195),
    MULTIANEWARRAY(197, Instruction.Kind.CPREF_W_UBYTE),
    IFNULL(198, Instruction.Kind.BRANCH),
    IFNONNULL(199, Instruction.Kind.BRANCH),
    GOTO_W(200, Instruction.Kind.BRANCH_W),
    JSR_W(201, Instruction.Kind.BRANCH_W),
    ILOAD_W(50197, Instruction.Kind.WIDE_LOCAL),
    LLOAD_W(50198, Instruction.Kind.WIDE_LOCAL),
    FLOAD_W(50199, Instruction.Kind.WIDE_LOCAL),
    DLOAD_W(50200, Instruction.Kind.WIDE_LOCAL),
    ALOAD_W(50201, Instruction.Kind.WIDE_LOCAL),
    ISTORE_W(50230, Instruction.Kind.WIDE_LOCAL),
    LSTORE_W(50231, Instruction.Kind.WIDE_LOCAL),
    FSTORE_W(50232, Instruction.Kind.WIDE_LOCAL),
    DSTORE_W(50233, Instruction.Kind.WIDE_LOCAL),
    ASTORE_W(50234, Instruction.Kind.WIDE_LOCAL),
    IINC_W(50308, Instruction.Kind.WIDE_LOCAL_SHORT),
    RET_W(50345, Instruction.Kind.WIDE_LOCAL),
    LOAD_UBYTE(Set.PICOJAVA, 65024),
    LOAD_BYTE(Set.PICOJAVA, 65025),
    LOAD_CHAR(Set.PICOJAVA, 65026),
    LOAD_SHORT(Set.PICOJAVA, 65027),
    LOAD_WORD(Set.PICOJAVA, 65028),
    RET_FROM_SUB(Set.PICOJAVA, 65029),
    LOAD_CHAR_OE(Set.PICOJAVA, 65034),
    LOAD_SHORT_OE(Set.PICOJAVA, 65035),
    LOAD_WORD_OE(Set.PICOJAVA, 65036),
    NCLOAD_UBYTE(Set.PICOJAVA, 65040),
    NCLOAD_BYTE(Set.PICOJAVA, 65041),
    NCLOAD_CHAR(Set.PICOJAVA, 65042),
    NCLOAD_SHORT(Set.PICOJAVA, 65043),
    NCLOAD_WORD(Set.PICOJAVA, 65044),
    NCLOAD_CHAR_OE(Set.PICOJAVA, 65050),
    NCLOAD_SHORT_OE(Set.PICOJAVA, 65051),
    NCLOAD_WORD_OE(Set.PICOJAVA, 65052),
    CACHE_FLUSH(Set.PICOJAVA, 65054),
    STORE_BYTE(Set.PICOJAVA, 65056),
    STORE_SHORT(Set.PICOJAVA, 65058),
    STORE_WORD(Set.PICOJAVA, 65060),
    STORE_SHORT_OE(Set.PICOJAVA, 65066),
    STORE_WORD_OE(Set.PICOJAVA, 65068),
    NCSTORE_BYTE(Set.PICOJAVA, 65072),
    NCSTORE_SHORT(Set.PICOJAVA, 65074),
    NCSTORE_WORD(Set.PICOJAVA, 65076),
    NCSTORE_SHORT_OE(Set.PICOJAVA, 65082),
    NCSTORE_WORD_OE(Set.PICOJAVA, 65084),
    ZERO_LINE(Set.PICOJAVA, 65086),
    ENTER_SYNC_METHOD(Set.PICOJAVA, 65087),
    PRIV_LOAD_UBYTE(Set.PICOJAVA, 65280),
    PRIV_LOAD_BYTE(Set.PICOJAVA, 65281),
    PRIV_LOAD_CHAR(Set.PICOJAVA, 65282),
    PRIV_LOAD_SHORT(Set.PICOJAVA, 65283),
    PRIV_LOAD_WORD(Set.PICOJAVA, 65284),
    PRIV_RET_FROM_TRAP(Set.PICOJAVA, 65285),
    PRIV_READ_DCACHE_TAG(Set.PICOJAVA, 65286),
    PRIV_READ_DCACHE_DATA(Set.PICOJAVA, 65287),
    PRIV_LOAD_CHAR_OE(Set.PICOJAVA, 65290),
    PRIV_LOAD_SHORT_OE(Set.PICOJAVA, 65291),
    PRIV_LOAD_WORD_OE(Set.PICOJAVA, 65292),
    PRIV_READ_ICACHE_TAG(Set.PICOJAVA, 65294),
    PRIV_READ_ICACHE_DATA(Set.PICOJAVA, 65295),
    PRIV_NCLOAD_UBYTE(Set.PICOJAVA, 65296),
    PRIV_NCLOAD_BYTE(Set.PICOJAVA, 65297),
    PRIV_NCLOAD_CHAR(Set.PICOJAVA, 65298),
    PRIV_NCLOAD_SHORT(Set.PICOJAVA, 65299),
    PRIV_NCLOAD_WORD(Set.PICOJAVA, 65300),
    PRIV_POWERDOWN(Set.PICOJAVA, 65302),
    PRIV_READ_SCACHE_DATA(Set.PICOJAVA, 65303),
    PRIV_NCLOAD_CHAR_OE(Set.PICOJAVA, 65306),
    PRIV_NCLOAD_SHORT_OE(Set.PICOJAVA, 65307),
    PRIV_NCLOAD_WORD_OE(Set.PICOJAVA, 65308),
    PRIV_CACHE_FLUSH(Set.PICOJAVA, 65310),
    PRIV_CACHE_INDEX_FLUSH(Set.PICOJAVA, 65311),
    PRIV_STORE_BYTE(Set.PICOJAVA, 65312),
    PRIV_STORE_SHORT(Set.PICOJAVA, 65314),
    PRIV_STORE_WORD(Set.PICOJAVA, 65316),
    PRIV_WRITE_DCACHE_TAG(Set.PICOJAVA, 65318),
    PRIV_WRITE_DCACHE_DATA(Set.PICOJAVA, 65319),
    PRIV_STORE_SHORT_OE(Set.PICOJAVA, 65322),
    PRIV_STORE_WORD_OE(Set.PICOJAVA, 65324),
    PRIV_WRITE_ICACHE_TAG(Set.PICOJAVA, 65326),
    PRIV_WRITE_ICACHE_DATA(Set.PICOJAVA, 65327),
    PRIV_NCSTORE_BYTE(Set.PICOJAVA, 65328),
    PRIV_NCSTORE_SHORT(Set.PICOJAVA, 65330),
    PRIV_NCSTORE_WORD(Set.PICOJAVA, 65332),
    PRIV_RESET(Set.PICOJAVA, 65334),
    PRIV_WRITE_SCACHE_DATA(Set.PICOJAVA, 65335),
    PRIV_NCSTORE_SHORT_OE(Set.PICOJAVA, 65338),
    PRIV_NCSTORE_WORD_OE(Set.PICOJAVA, 65340),
    PRIV_ZERO_LINE(Set.PICOJAVA, 65342),
    PRIV_READ_REG_0(Set.PICOJAVA, 65344),
    PRIV_READ_REG_1(Set.PICOJAVA, 65345),
    PRIV_READ_REG_2(Set.PICOJAVA, 65346),
    PRIV_READ_REG_3(Set.PICOJAVA, 65347),
    PRIV_READ_REG_4(Set.PICOJAVA, 65348),
    PRIV_READ_REG_5(Set.PICOJAVA, 65349),
    PRIV_READ_REG_6(Set.PICOJAVA, 65350),
    PRIV_READ_REG_7(Set.PICOJAVA, 65351),
    PRIV_READ_REG_8(Set.PICOJAVA, 65352),
    PRIV_READ_REG_9(Set.PICOJAVA, 65353),
    PRIV_READ_REG_10(Set.PICOJAVA, 65354),
    PRIV_READ_REG_11(Set.PICOJAVA, 65355),
    PRIV_READ_REG_12(Set.PICOJAVA, 65356),
    PRIV_READ_REG_13(Set.PICOJAVA, 65357),
    PRIV_READ_REG_14(Set.PICOJAVA, 65358),
    PRIV_READ_REG_15(Set.PICOJAVA, 65359),
    PRIV_READ_REG_16(Set.PICOJAVA, 65360),
    PRIV_READ_REG_17(Set.PICOJAVA, 65361),
    PRIV_READ_REG_18(Set.PICOJAVA, 65362),
    PRIV_READ_REG_19(Set.PICOJAVA, 65363),
    PRIV_READ_REG_20(Set.PICOJAVA, 65364),
    PRIV_READ_REG_21(Set.PICOJAVA, 65365),
    PRIV_READ_REG_22(Set.PICOJAVA, 65366),
    PRIV_READ_REG_23(Set.PICOJAVA, 65367),
    PRIV_READ_REG_24(Set.PICOJAVA, 65368),
    PRIV_READ_REG_25(Set.PICOJAVA, 65369),
    PRIV_READ_REG_26(Set.PICOJAVA, 65370),
    PRIV_READ_REG_27(Set.PICOJAVA, 65371),
    PRIV_READ_REG_28(Set.PICOJAVA, 65372),
    PRIV_READ_REG_29(Set.PICOJAVA, 65373),
    PRIV_READ_REG_30(Set.PICOJAVA, 65374),
    PRIV_READ_REG_31(Set.PICOJAVA, 65375),
    PRIV_WRITE_REG_0(Set.PICOJAVA, 65376),
    PRIV_WRITE_REG_1(Set.PICOJAVA, 65377),
    PRIV_WRITE_REG_2(Set.PICOJAVA, 65378),
    PRIV_WRITE_REG_3(Set.PICOJAVA, 65379),
    PRIV_WRITE_REG_4(Set.PICOJAVA, 65380),
    PRIV_WRITE_REG_5(Set.PICOJAVA, 65381),
    PRIV_WRITE_REG_6(Set.PICOJAVA, 65382),
    PRIV_WRITE_REG_7(Set.PICOJAVA, 65383),
    PRIV_WRITE_REG_8(Set.PICOJAVA, 65384),
    PRIV_WRITE_REG_9(Set.PICOJAVA, 65385),
    PRIV_WRITE_REG_10(Set.PICOJAVA, 65386),
    PRIV_WRITE_REG_11(Set.PICOJAVA, 65387),
    PRIV_WRITE_REG_12(Set.PICOJAVA, 65388),
    PRIV_WRITE_REG_13(Set.PICOJAVA, 65389),
    PRIV_WRITE_REG_14(Set.PICOJAVA, 65390),
    PRIV_WRITE_REG_15(Set.PICOJAVA, 65391),
    PRIV_WRITE_REG_16(Set.PICOJAVA, 65392),
    PRIV_WRITE_REG_17(Set.PICOJAVA, 65393),
    PRIV_WRITE_REG_18(Set.PICOJAVA, 65394),
    PRIV_WRITE_REG_19(Set.PICOJAVA, 65395),
    PRIV_WRITE_REG_20(Set.PICOJAVA, 65396),
    PRIV_WRITE_REG_21(Set.PICOJAVA, 65397),
    PRIV_WRITE_REG_22(Set.PICOJAVA, 65398),
    PRIV_WRITE_REG_23(Set.PICOJAVA, 65399),
    PRIV_WRITE_REG_24(Set.PICOJAVA, 65400),
    PRIV_WRITE_REG_25(Set.PICOJAVA, 65401),
    PRIV_WRITE_REG_26(Set.PICOJAVA, 65402),
    PRIV_WRITE_REG_27(Set.PICOJAVA, 65403),
    PRIV_WRITE_REG_28(Set.PICOJAVA, 65404),
    PRIV_WRITE_REG_29(Set.PICOJAVA, 65405),
    PRIV_WRITE_REG_30(Set.PICOJAVA, 65406),
    PRIV_WRITE_REG_31(Set.PICOJAVA, 65407);

    public final Set set;
    public final int opcode;
    public final Instruction.Kind kind;
    private static final Opcode[] stdOpcodes;
    private static final Opcode[] wideOpcodes;
    private static final Opcode[] nonPrivOpcodes;
    private static final Opcode[] privOpcodes;
    public static final int WIDE = 196;
    public static final int NONPRIV = 254;
    public static final int PRIV = 255;

    private Opcode(int opcode) {
        this(Set.STANDARD, opcode, Instruction.Kind.NO_OPERANDS);
    }

    private Opcode(int opcode, Instruction.Kind kind) {
        this(Set.STANDARD, opcode, kind);
    }

    private Opcode(Set set, int opcode) {
        this(set, opcode, set == Set.STANDARD ? Instruction.Kind.NO_OPERANDS : Instruction.Kind.WIDE_NO_OPERANDS);
    }

    private Opcode(Set set, int opcode, Instruction.Kind kind) {
        this.set = set;
        this.opcode = opcode;
        this.kind = kind;
    }

    public static Opcode get(int opcode) {
        return stdOpcodes[opcode];
    }

    public static Opcode get(int opcodePrefix, int opcode) {
        Opcode[] block = Opcode.getOpcodeBlock(opcodePrefix);
        return block == null ? null : block[opcode];
    }

    private static Opcode[] getOpcodeBlock(int opcodePrefix) {
        switch (opcodePrefix) {
            case 0: {
                return stdOpcodes;
            }
            case 196: {
                return wideOpcodes;
            }
            case 254: {
                return nonPrivOpcodes;
            }
            case 255: {
                return privOpcodes;
            }
        }
        return null;
    }

    static {
        stdOpcodes = new Opcode[256];
        wideOpcodes = new Opcode[256];
        nonPrivOpcodes = new Opcode[256];
        privOpcodes = new Opcode[256];
        Opcode[] opcodeArray = Opcode.values();
        int n = opcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Opcode o;
            Opcode.getOpcodeBlock((int)(o.opcode >> 8))[o.opcode & 0xFF] = o = opcodeArray[i];
        }
    }

    public static enum Set {
        STANDARD,
        PICOJAVA;

    }
}

