/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.portlet.faces.util.map.PortletAbstractMap;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestHeaderValuesMap
extends PortletAbstractMap<String[]> {
    private final PortletRequestHeaders mPortletRequestHeaders;
    private final Map<String, String[]> mValueCache = new HashMap<String, String[]>();

    public PortletRequestHeaderValuesMap(PortletRequestHeaders portletRequestHeaders) {
        this.mPortletRequestHeaders = portletRequestHeaders;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                String key = e.getKey();
                Object[] value = (String[])e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !Arrays.equals(value, (Object[])t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    protected String[] getAttribute(String key) {
        String[] ret = this.mValueCache.get(key);
        if (ret == null) {
            ret = this.toArray(this.mPortletRequestHeaders.getHeaders(key));
            this.mValueCache.put(key, ret);
        }
        return ret;
    }

    @Override
    protected void setAttribute(String key, String[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("");
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        return this.mPortletRequestHeaders.getHeaderNames();
    }

    private String[] toArray(Enumeration<String> e) {
        ArrayList<String> ret = new ArrayList<String>();
        while (e.hasMoreElements()) {
            ret.add(e.nextElement());
        }
        return ret.toArray(new String[ret.size()]);
    }
}

