/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler.webapp.config.element.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.myfaces.commons.resourcehandler.webapp.config.element.ServletRegistration;

/**
 * 
 * @author Leonardo Uribe
 *
 */
public class ServletRegistrationImpl implements ServletRegistration
{

    private final String name;
    private String className;
    private Set<String> mappings = new HashSet<String>();

    public ServletRegistrationImpl(
            String name)
    {
        this.name = name;
    }

    public ServletRegistrationImpl(
            String name,
            String className)
    {
        this.name = name;
        this.className = className;
    }
    
    public String getClassName()
    {
        return className;
    }

    public String getName()
    {
        return name;
    }

    public Collection<String> getMappings()
    {
        return Collections.unmodifiableCollection(mappings);
    }
    
    public void addMapping(String url)
    {
        mappings.add(url);
    }
    
    public void setClassName(String className)
    {
        this.className = className;
    }

}
