/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.converter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;

final class _TimeZoneRule extends MetaRule {

    final static class ValueBindingMetadata extends Metadata {

        private final String name;

        private final TagAttribute attr;

        private final Class type;

        public ValueBindingMetadata(String name, Class type,
                TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.type = type;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ConverterBase) instance).setValueBinding(this.name, new LegacyValueBinding(this.attr
                    .getValueExpression(ctx, this.type)));
        }

    }
    
    final static class LiteralPropertyMetadata extends Metadata
    {

        private final Method method;

        private final TagAttribute attribute;

        private Object[] value;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute)
        {
            this.method = method;
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance)
        {
            if (value == null)
            {
                String str = this.attribute.getValue();
                value = new Object[] { java.util.TimeZone.getTimeZone( str ) };
            }
            try
            {
                method.invoke(instance, this.value);
            }
            catch (InvocationTargetException e)
            {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e)
            {
                throw new TagAttributeException(this.attribute, e);
            }
        }

    }

    public final static _TimeZoneRule Instance = new _TimeZoneRule();

    public _TimeZoneRule() {
        super();
    }

    public Metadata applyRule(String name, TagAttribute attribute,
            MetadataTarget meta) {
        if (meta.isTargetInstanceOf(ConverterBase.class)) {

            if ("timeZone".equals(name))
            {
                // if component and dynamic, then must set expression
                if (!attribute.isLiteral()) {
                    return new ValueBindingMetadata(name, Object.class, attribute);
                }
                else
                {
                    Method m = meta.getWriteMethod(name);

                    return new LiteralPropertyMetadata(m, attribute);
                }
            }
        }
        return null;
    }
}
