/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.Range;

public final class Version
implements Comparable<Version> {
    public static final Version MIN_VERSION;
    public static final Version MAX_VERSION;
    public static final Range<Version> ALL_VERSIONS;
    private final String[] _versions;
    private final int[] _intVersions;
    private final String _versionPadding;
    private final int _hashCode;
    private static final String _WILDCARD = "*";
    private static final Pattern _DOT_SPLITTER;
    private static final Pattern _DIGITS_PATTERN;
    private static final int _NON_INT_VERSION = -1;
    private static final String _MAX_STRING;
    private static final TrinidadLogger _LOG;

    public Version(String version) {
        this(version, null);
    }

    public Version(String version, String versionPadding) {
        this._checkNonEmptyString(version, "version");
        if (versionPadding == null) {
            versionPadding = "";
        }
        this._versions = _DOT_SPLITTER.split(version, 0);
        this._intVersions = Version._toIntVersions(this._versions, version);
        this._versionPadding = versionPadding;
        this._hashCode = version.hashCode() * 37 + versionPadding.hashCode();
    }

    @Override
    public int compareTo(Version otherVersion) {
        int ourVersionCount = this._versions.length;
        int otherVersionCount = otherVersion._versions.length;
        int compareCount = ourVersionCount > otherVersionCount ? ourVersionCount : otherVersionCount;
        for (int versionIndex = 0; versionIndex < compareCount; ++versionIndex) {
            int result = this._compareVersions(otherVersion, versionIndex);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public Version toMinimumVersion() {
        if (!this._containsWildcard() && !Version._isWildcard(this._versionPadding)) {
            return this;
        }
        return new Version(this._toString("0", true));
    }

    public Version toMaximumVersion() {
        if (!this._containsWildcard() && !Version._isWildcard(this._versionPadding)) {
            return this;
        }
        return new Version(this._toString(_MAX_STRING, false), _MAX_STRING);
    }

    public String toString() {
        return this._toString(_WILDCARD, false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version otherVersion = (Version)o;
        return this._versionPadding.equals(otherVersion._versionPadding) && Arrays.equals(this._versions, otherVersion._versions);
    }

    public int hashCode() {
        return this._hashCode;
    }

    private static int[] _toIntVersions(String[] versions, String fullVersion) {
        assert (versions != null);
        int[] intVersions = new int[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            intVersions[i] = Version._toIntVersion(versions[i], fullVersion);
        }
        return intVersions;
    }

    private static int _toIntVersion(String versionSegment, String fullVersion) {
        if (_DIGITS_PATTERN.matcher(versionSegment).matches()) {
            try {
                return Integer.parseInt(versionSegment);
            }
            catch (NumberFormatException e) {
                _LOG.warning("UNEXPECTED_VERSION_VALUE", new Object[]{versionSegment, fullVersion});
            }
        }
        return -1;
    }

    private int _compareVersions(Version otherVersion, int versionIndex) {
        if (this._isIntComparable(otherVersion, versionIndex)) {
            return this._compareIntVersions(otherVersion, versionIndex);
        }
        return this._compareStringVersions(otherVersion, versionIndex);
    }

    private boolean _isIntComparable(Version otherVersion, int versionIndex) {
        int[] ourIntVersions = this._intVersions;
        int[] otherIntVersions = otherVersion._intVersions;
        return versionIndex < ourIntVersions.length && versionIndex < otherIntVersions.length && ourIntVersions[versionIndex] != -1 && otherIntVersions[versionIndex] != -1;
    }

    private int _compareIntVersions(Version otherVersion, int versionIndex) {
        assert (this._isIntComparable(otherVersion, versionIndex));
        int ourIntVersion = this._intVersions[versionIndex];
        int otherIntVersion = otherVersion._intVersions[versionIndex];
        return ourIntVersion < otherIntVersion ? -1 : (ourIntVersion > otherIntVersion ? 1 : 0);
    }

    private int _compareStringVersions(Version otherVersion, int versionIndex) {
        String ourSubVersion = this._getSubVersion(versionIndex);
        String otherSubVersion = otherVersion._getSubVersion(versionIndex);
        if (Version._isWildcard(ourSubVersion) || Version._isWildcard(otherSubVersion)) {
            return 0;
        }
        return ourSubVersion.compareTo(otherSubVersion);
    }

    private String _toString(String wildcardReplacement, boolean dropTrailingWildcard) {
        assert (wildcardReplacement != null);
        StringBuilder versionBuilder = new StringBuilder();
        int versionCount = this._versions.length;
        int i = 0;
        while (true) {
            String subVersion;
            if (Version._isWildcard(subVersion = this._versions[i])) {
                subVersion = wildcardReplacement;
            }
            versionBuilder.append(subVersion);
            if (++i == versionCount || dropTrailingWildcard && i == versionCount - 1 && Version._isWildcard(this._versions[i])) break;
            versionBuilder.append('.');
        }
        return versionBuilder.toString();
    }

    private String _getSubVersion(int versionIndex) {
        if (versionIndex >= this._versions.length) {
            return this._versionPadding;
        }
        return this._versions[versionIndex];
    }

    private void _checkNonEmptyString(String checkedString, String identifier) {
        if (checkedString == null) {
            throw new NullPointerException(identifier + " must be non-null");
        }
        if (checkedString.length() == 0) {
            throw new IllegalArgumentException(identifier + " must be non-empty");
        }
    }

    private boolean _containsWildcard() {
        for (int i = 0; i < this._versions.length; ++i) {
            if (!Version._isWildcard(this._versions[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean _isWildcard(String subVersion) {
        return _WILDCARD.equals(subVersion);
    }

    static {
        _DOT_SPLITTER = Pattern.compile("\\.");
        _DIGITS_PATTERN = Pattern.compile("\\d+");
        _MAX_STRING = Integer.toString(Integer.MAX_VALUE);
        _LOG = TrinidadLogger.createTrinidadLogger(Version.class);
        MIN_VERSION = new Version("0");
        MAX_VERSION = new Version(_MAX_STRING, _MAX_STRING);
        ALL_VERSIONS = Range.of(MIN_VERSION, MAX_VERSION);
    }
}

