/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.config;

import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.config.ConfigPropertyService;
import org.apache.myfaces.trinidad.config.PropertyValueProvider;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class TestPropertyValueProvider
extends PropertyValueProvider {
    private final ConcurrentHashMap<String, String> _testValues = new ConcurrentHashMap();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TestPropertyValueProvider.class);

    public static TestPropertyValueProvider getInstance(ExternalContext externalContext) {
        ConfigPropertyService service = ConfigPropertyService.getInstance(externalContext);
        if (service == null) {
            throw new IllegalStateException(_LOG.getMessage("CONFIG_PROPERTY_SERVICE_NOT_INITIALIZED"));
        }
        return service.getTestProvider();
    }

    @Override
    public String getValue(ExternalContext extCtx, String name) {
        if (name == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_CONFIG_PROPERTY_NAME"));
        }
        String value = this._testValues.get(name);
        return value;
    }

    public void setProperty(ExternalContext externalContext, String name, String value) {
        if (name == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_CONFIG_PROPERTY_NAME"));
        }
        String oldValue = ConfigPropertyService.getInstance(externalContext).getProperty(externalContext, name);
        this._testValues.put(name, value);
        this.notifyValueChanged(externalContext, name, oldValue);
    }

    public void removeProperty(ExternalContext externalContext, String name) {
        if (name == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_CONFIG_PROPERTY_NAME"));
        }
        String oldValue = ConfigPropertyService.getInstance(externalContext).getProperty(externalContext, name);
        this._testValues.remove(name);
        this.notifyValueChanged(externalContext, name, oldValue);
    }

    public void resetValues() {
        this._testValues.clear();
    }
}

