/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.component.core.data.CoreTree;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class TreeRenderer
extends XhtmlRenderer {
    private static final String _BACKGROUND_IMAGE_URL = "background-image:url(";
    private static final String _END_FUNC = ");";
    private static final String _BACKGROUND_NO_REPEAT = "background-repeat:no-repeat;";
    private static final String _ICON_WIDTH = "19";
    private static final String _ICON_HEIGHT = "18";
    private static final String _NODE_SPACER = "3";
    protected static final int NO_CHILDREN = 0;
    protected static final int EXPAND_CLOSED = 1;
    protected static final int EXPAND_OPEN = 2;
    protected static final int EXPAND_ALWAYS = 3;
    private static final int _DEFAULT_TREE_DEPTH = 10;
    private static final int _DEFAULT_TREE_INCREMENT = 5;
    private static final Object _JS_RENDERED_KEY = new Object();
    static final String _STYLE_CLASS_KEY = "_styleClass";
    private PropertyKey _immediateKey;
    private static final String _DISABLED_COLLAPSE_TIP_KEY = "af_tree.DISABLED_COLLAPSE_TIP";
    private static final String _COLLAPSE_TIP_KEY = "af_tree.COLLAPSE_TIP";
    private static final String _EXPAND_TIP_KEY = "af_tree.EXPAND_TIP";
    private static final String _NODE_LEVEL_TEXT_KEY = "af_tree.NODE_LEVEL";
    private static final String _PATH_PARAM = "path";
    public static final String SELECTED_PARAM = "_selected";
    public static final String NODE_ICON_EXPANDED_SUFFIX = "-expanded";
    public static final String NODE_ICON_COLLAPSED_SUFFIX = "-collapsed";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TreeRenderer.class);

    public TreeRenderer() {
        this(CoreTree.TYPE);
    }

    protected TreeRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._immediateKey = type.findKey("immediate");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String source = (String)parameters.get("source");
        if (clientId == null) {
            clientId = this.getClientId(facesContext, component);
        }
        if (!clientId.equals(source)) {
            return;
        }
        TreeUtils.decodeExpandEvents(parameters, component, Collections.emptyList());
        String currencyStrParam = source + ':' + SELECTED_PARAM;
        String currencyStr = (String)parameters.get(currencyStrParam);
        if (currencyStr != null && !"".equals(currencyStr)) {
            UIXTree tree = (UIXTree)component;
            Object oldPath = tree.getRowKey();
            tree.setClientRowKey(currencyStr);
            tree.getSelectedRowKeys().clear();
            tree.getSelectedRowKeys().add();
            tree.setRowKey(oldPath);
        }
        RequestContext.getCurrentInstance().addPartialTarget(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!PartialPageUtils.containsPprTargets(rc, component, this.getClientId(context, component))) {
            return;
        }
        UIXHierarchy tree = (UIXHierarchy)component;
        TreeUtils.expandFocusRowKey((UIXTree)component);
        Object oldPath = tree.getRowKey();
        try {
            boolean continueRendering = this.setInitialPath(tree, bean);
            if (!continueRendering) {
                return;
            }
            this._renderContent(context, rc, tree, bean);
        }
        finally {
            tree.setRowKey(oldPath);
        }
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    private void _renderContent(FacesContext context, RenderingContext rc, UIXHierarchy tree, FacesBean bean) throws IOException {
        FormData fd = rc.getFormData();
        if (fd == null) {
            _LOG.warning("TREE_COMPONENT_MUST_INSIDE_FORM");
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", (UIComponent)tree);
        this.renderId(context, (UIComponent)tree);
        this.renderAllAttributes(context, rc, (UIComponent)tree, bean);
        String id = this.getClientId(context, (UIComponent)tree);
        UIComponent stamp = TreeRenderer.getFacet((UIComponent)tree, (String)"nodeStamp");
        Object focusPath = tree.getFocusRowKey();
        String formName = fd.getName();
        String varName = "_adftree" + XhtmlUtils.getJSIdentifier(id);
        boolean leftToRight = !rc.isRightToLeft();
        int rootSize = tree.getRowCount();
        RowKeySet state = this.getExpandedRowKeys(tree);
        Map<Object, Boolean> selectedPaths = this.getSelectedPaths(focusPath);
        for (int i = 0; i < rootSize; ++i) {
            tree.setRowIndex(i);
            this._renderNode(context, rc, tree, bean, stamp, varName, state, selectedPaths, new Boolean[10], leftToRight, i == 0, i == rootSize - 1, 0);
        }
        if (TreeRenderer.supportsScripting(rc)) {
            rw.startElement("script", null);
            TreeRenderer.renderScriptDeferAttribute(context, rc);
            TreeRenderer.renderScriptTypeAttribute(context, rc);
            this._renderTreeJS(context, rc, (UIComponent)tree, bean);
            String selectedParam = id + ':' + SELECTED_PARAM;
            String focusNodeId = TreeUtils.getFocusNodeClientId(context, tree);
            rw.writeText((Object)("var " + varName + " = " + this._createNewJSSelectionState(formName, id, selectedParam, focusNodeId)), null);
            rw.endElement("script");
            fd.addNeededValue(selectedParam);
        }
        rw.endElement("div");
        fd.addNeededValue(_PATH_PARAM);
    }

    protected boolean setInitialPath(UIXHierarchy tree, FacesBean bean) {
        tree.setRowKey(null);
        return true;
    }

    private boolean _isShownSelected(UIXHierarchy tree, Map<Object, Boolean> selectedPaths, Object currPath) {
        boolean selected = false;
        if (tree instanceof UIXTree) {
            selected = ((UIXTree)tree).getSelectedRowKeys().isContained();
        }
        if (selected) {
            return true;
        }
        Boolean value = selectedPaths.get(currPath);
        return value != null;
    }

    protected Map<Object, Boolean> getSelectedPaths(Object focusPath) {
        if (focusPath == null) {
            return new HashMap<Object, Boolean>(0);
        }
        HashMap<Object, Boolean> selectedPaths = new HashMap<Object, Boolean>(1);
        selectedPaths.put(focusPath, Boolean.TRUE);
        return selectedPaths;
    }

    protected RowKeySet getExpandedRowKeys(UIXHierarchy tree) {
        return ((UIXTree)tree).getDisclosedRowKeys();
    }

    protected boolean isShowLines(RenderingContext rc) {
        Object showLines = rc.getSkin().getProperty((Object)"af|tree-tr-show-lines");
        return showLines == null || showLines.equals(Boolean.TRUE);
    }

    protected String getConnectingBackgroundIcon(FacesContext context, RenderingContext rc, boolean isLine, boolean leftToRight) {
        if (!isLine || !this.isShowLines(rc)) {
            return null;
        }
        Icon icon = rc.getIcon("af|tree::line-icon");
        return icon == null ? null : icon.getImageURI(context, rc).toString();
    }

    protected String getIconBackgroundIcon(FacesContext context, RenderingContext rc, boolean isLastSibling, boolean isLeftToRight) {
        Object showLines = rc.getSkin().getProperty((Object)"af|tree-tr-show-lines");
        if (!this.isShowLines(rc)) {
            return null;
        }
        Icon nodeBackgroundIcon = rc.getIcon(isLastSibling ? "af|tree::line-last-icon" : "af|tree::line-middle-icon");
        return nodeBackgroundIcon != null ? nodeBackgroundIcon.getImageURI(context, rc).toString() : null;
    }

    protected void renderExpandCell(FacesContext context, RenderingContext rc, UIXHierarchy tree, int expanded, boolean isLastSibling, String onclick) throws IOException {
        Object o;
        Icon icon = null;
        String iconURI = null;
        boolean isAbsoluteImageURI = true;
        String iconHeight = null;
        String altText = null;
        String text = null;
        boolean isMacOS = "mac".equals(rc.getAgent().getPlatformName());
        switch (expanded) {
            case 0: {
                icon = rc.getIcon("af|tree::no-children-icon");
                if (icon != null && icon.getImageURI(context, rc) != null) break;
                iconURI = "t.gif";
                iconHeight = _ICON_HEIGHT;
                isAbsoluteImageURI = false;
                break;
            }
            case 1: {
                text = isMacOS ? (rc.isRightToLeft() ? "\u2190" : "\u2192") : (TreeRenderer.isPDA((RenderingContext)rc) ? "[+]" : (rc.isRightToLeft() ? "\u25c4" : "\u25ba"));
                altText = rc.getTranslatedString(_EXPAND_TIP_KEY);
                icon = rc.getIcon("af|tree::collapsed-icon");
                break;
            }
            case 2: {
                text = isMacOS ? "\u2193" : (TreeRenderer.isPDA((RenderingContext)rc) ? "[-]" : "\u25bc");
                altText = rc.getTranslatedString(_COLLAPSE_TIP_KEY);
                icon = rc.getIcon("af|tree::expanded-icon");
                break;
            }
            case 3: {
                text = isMacOS ? "\u2193" : (TreeRenderer.isPDA((RenderingContext)rc) ? "[-]" : "\u25bc");
                altText = rc.getTranslatedString(_DISABLED_COLLAPSE_TIP_KEY);
                icon = rc.getIcon("af|tree::expanded-icon");
            }
        }
        if (iconURI == null && icon != null && (o = icon.getImageURI(context, rc)) != null) {
            iconURI = o.toString();
        }
        String backgroundIconURI = this.getConnectingBackgroundIcon(context, rc, !isLastSibling, true);
        String nodeBackgroundIconURI = this.getIconBackgroundIcon(context, rc, isLastSibling, true);
        if (iconURI != null) {
            this.renderExpandIconCell(context, rc, backgroundIconURI, nodeBackgroundIconURI, iconURI, isAbsoluteImageURI, altText, _ICON_WIDTH, iconHeight, onclick);
        } else {
            this._renderTextCell(context, rc, tree, expanded, text, altText, _ICON_WIDTH, onclick, "p_OraTreeDisclosedSymbol");
        }
    }

    private void _renderTextCell(FacesContext context, RenderingContext rc, UIXHierarchy tree, int expanded, String text, Object altText, String width, String onclick, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("title", altText, null);
        TreeRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)styleClass);
        boolean jsSupport = TreeRenderer.supportsScripting(rc);
        if (onclick != null) {
            if (jsSupport) {
                writer.startElement("a", null);
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)onclick, null);
            } else {
                String nameAttr = TreeUtils.renderEncodedNameAttri(context, rc, tree, this.getClientId(context, (UIComponent)tree), expanded == 1);
                writer.startElement("input", null);
                writer.writeAttribute("type", (Object)"submit", null);
                writer.writeAttribute("name", (Object)nameAttr, null);
                writer.writeAttribute("value", (Object)text, null);
            }
        }
        if (text != null && jsSupport) {
            writer.writeText((Object)text, null);
        }
        if (onclick != null) {
            if (jsSupport) {
                writer.endElement("a");
            } else {
                writer.endElement("input");
            }
        }
        writer.endElement("td");
    }

    protected void renderExpandIconCell(FacesContext context, RenderingContext rc, String backgroundIcon, String nodeBackgroundIcon, String icon, boolean isIconAbsoluteURI, Object altText, String width, String height, String onclick) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("height", (Object)"100%", null);
        writer.writeAttribute("valign", (Object)"top", null);
        if (backgroundIcon != null) {
            writer.writeAttribute("style", (Object)(_BACKGROUND_IMAGE_URL + backgroundIcon + _END_FUNC), null);
        }
        if (nodeBackgroundIcon != null) {
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)(_BACKGROUND_IMAGE_URL + nodeBackgroundIcon + _END_FUNC + _BACKGROUND_NO_REPEAT), null);
        }
        if (onclick != null) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        this._renderIcon(context, rc, icon, isIconAbsoluteURI, altText, null, height);
        if (onclick != null) {
            writer.endElement("a");
        }
        if (nodeBackgroundIcon != null) {
            writer.endElement("div");
        }
        writer.endElement("td");
    }

    protected void renderIconCell(FacesContext context, RenderingContext rc, UIXHierarchy tree, String backgroundIcon, String icon, boolean isIconAbsoluteURI, Object altText, String width, String height, String onclick) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)width, null);
        if (backgroundIcon != null) {
            String backgroundIconURI = backgroundIcon;
            writer.writeAttribute("style", (Object)(_BACKGROUND_IMAGE_URL + backgroundIconURI + _END_FUNC), null);
        }
        if (onclick != null) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
            String treeName = this.getClientId(context, (UIComponent)tree);
            String id = treeName + ':' + "lnk";
            writer.writeAttribute("id", (Object)id, null);
        }
        this._renderIcon(context, rc, icon, isIconAbsoluteURI, altText, width, height);
        if (onclick != null) {
            writer.endElement("a");
        }
        writer.endElement("td");
    }

    private static String _createFocusNodeGetter(String focusNodeId) {
        return focusNodeId != null ? "document.getElementById('" + focusNodeId + "')" : null;
    }

    private static String _callJSSelect(UIXHierarchy tree, String jsVarName) {
        String currencyStr = tree.getClientRowKey();
        return jsVarName + ".select(this,'" + currencyStr + "');";
    }

    private String _createNewJSSelectionState(String formName, String treeClientId, String selectParam, String focusNodeId) {
        String treeState = TreeUtils.createNewJSCollectionComponentState(formName, treeClientId);
        String focusNode = TreeRenderer._createFocusNodeGetter(focusNodeId);
        String jsSelectionState = null;
        jsSelectionState = focusNode == null ? "new _adfTreeSelector('" + selectParam + "'," + treeState + _END_FUNC : "new _adfTreeSelector('" + selectParam + "'," + treeState + "," + focusNode + _END_FUNC;
        return jsSelectionState;
    }

    private void _renderTreeJS(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!rc.getProperties().containsKey(_JS_RENDERED_KEY)) {
            rc.getProperties().put(_JS_RENDERED_KEY, Boolean.TRUE);
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)"function _adfTreeSelector(selectParam,tState,focusNode) {this._selectParam = selectParam;this.treeState = tState;this._pTag = focusNode;}_adfTreeSelector.prototype.select = function(tag,path) {if (this._pTag != null) {this._pTag.className='p_OraTreeRow';}this._pTag = tag;tag.className='p_OraTreeRowSelected';};", null);
            boolean immediate = this.getImmediate(component, bean);
            String buff = TreeUtils.setupJSTreeCollectionComponent(!immediate) + ";";
            writer.writeText((Object)buff, null);
        }
    }

    private void _renderNode(FacesContext context, RenderingContext rc, UIXHierarchy tree, FacesBean bean, UIComponent stamp, String varName, RowKeySet state, Map<Object, Boolean> selectedPaths, Boolean[] prepend, boolean leftToRight, boolean isFirstSibling, boolean isLastSibling, int nodeDepth) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, rc, "0", "0", "0", null);
        writer.startElement("tr", null);
        this._prependIcons(context, rc, tree, prepend, leftToRight);
        String onclickExpand = null;
        int expand = this._getExpandValue(tree, state);
        if (expand != 0 && TreeRenderer.supportsNavigation(rc)) {
            onclickExpand = TreeUtils.callJSExpandNode(tree, varName + ".treeState", expand == 1);
        }
        this.renderExpandCell(context, rc, tree, expand, isLastSibling, onclickExpand);
        String treeStyle = "p_OraTreeRow";
        Object currPath = tree.getRowKey();
        boolean selected = this._isShownSelected(tree, selectedPaths, currPath);
        String onClick = TreeRenderer._callJSSelect(tree, varName);
        if (selected) {
            treeStyle = "p_OraTreeRowSelected";
        }
        this.renderNodeIconCell(context, rc, tree, expand);
        this.renderIconCell(context, rc, tree, null, "t.gif", false, null, _NODE_SPACER, _ICON_HEIGHT, null);
        this.renderStampCell(context, rc, tree, stamp, onClick, treeStyle, nodeDepth);
        writer.endElement("tr");
        writer.endElement("table");
        if (expand == 2 || expand == 3) {
            this._renderNodeChildren(context, rc, tree, bean, stamp, varName, state, selectedPaths, prepend, leftToRight, isFirstSibling, isLastSibling, nodeDepth);
        }
    }

    protected void renderNodeIconCell(FacesContext context, RenderingContext rc, UIXHierarchy tree, int expand) throws IOException {
        String nodeType = this.getNodeType(tree);
        Icon nodeIcon = this.getNodeIcon(rc, nodeType, expand);
        ResponseWriter writer = context.getResponseWriter();
        if (nodeIcon != null) {
            writer.startElement("td", null);
            writer.writeAttribute("width", (Object)_ICON_WIDTH, null);
            writer.writeAttribute("height", (Object)_ICON_HEIGHT, null);
            writer.writeAttribute("valign", (Object)"top", null);
            this._renderIcon(context, rc, nodeIcon.getImageURI(context, rc).toString(), true, null, null, null);
            writer.endElement("td");
        }
    }

    protected String getNodeType(UIXHierarchy tree) {
        String nodeType = null;
        Object rowData = tree.getRowData();
        Class<?> rowClass = rowData.getClass();
        Method method = null;
        try {
            method = rowClass.getMethod("getNodeType", new Class[0]);
            if (method != null && method.getReturnType().equals(String.class)) {
                nodeType = (String)method.invoke(rowData, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return nodeType;
    }

    protected String getNodeIconSelector(String nodeType, int expandedState) {
        switch (expandedState) {
            case 2: {
                nodeType = nodeType + NODE_ICON_EXPANDED_SUFFIX;
                break;
            }
            case 1: {
                nodeType = nodeType + NODE_ICON_COLLAPSED_SUFFIX;
            }
        }
        return "af|tree::node-icon:" + nodeType;
    }

    protected Icon getNodeIcon(RenderingContext rc, String nodeType, int expandedState) {
        if (nodeType == null || nodeType.length() == 0) {
            return null;
        }
        Icon icon = rc.getIcon(this.getNodeIconSelector(nodeType, expandedState));
        if (icon == null) {
            icon = expandedState != 0 ? rc.getIcon(this.getNodeIconSelector(nodeType, 0)) : rc.getIcon(this.getNodeIconSelector(nodeType, 1));
        }
        return icon;
    }

    protected void renderStampCell(FacesContext context, RenderingContext rc, UIXHierarchy tree, UIComponent stamp, String onClick, String treeStyle, int nodeDepth) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("nowrap", (Object)Boolean.FALSE, null);
        TreeRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"p_OraTreeNodeAdjust");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)stamp.getClientId(), null);
        TreeRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)treeStyle);
        if (TreeRenderer.supportsScripting(rc)) {
            writer.writeAttribute("onclick", (Object)onClick, null);
        }
        this._renderStampBasedOnAccessibilty(context, rc, stamp, nodeDepth);
        writer.endElement("span");
        writer.endElement("td");
    }

    private void _renderNodeChildren(FacesContext context, RenderingContext rc, UIXHierarchy tree, FacesBean bean, UIComponent stamp, String varName, RowKeySet state, Map<Object, Boolean> selectedPaths, Boolean[] prepend, boolean leftToRight, boolean isFirstSibling, boolean isLastSibling, int nodeDepth) throws IOException {
        tree.enterContainer();
        int childCount = tree.getRowCount();
        if (childCount > 0) {
            prepend = this._appendIcon(prepend, isLastSibling ? Boolean.FALSE : Boolean.TRUE);
            ++nodeDepth;
            int oldIndex = tree.getRowIndex();
            for (int i = 0; i < childCount; ++i) {
                Boolean[] currClone = new Boolean[prepend.length];
                System.arraycopy(prepend, 0, currClone, 0, prepend.length);
                tree.setRowIndex(i);
                this._renderNode(context, rc, tree, bean, stamp, varName, state, selectedPaths, currClone, leftToRight, i == 0, i == childCount - 1, nodeDepth);
            }
            tree.setRowIndex(oldIndex);
            --nodeDepth;
        }
        tree.exitContainer();
    }

    private int _getExpandValue(UIXHierarchy tree, RowKeySet state) {
        if (tree.isContainer()) {
            if (state.isContained()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void _renderIcon(FacesContext context, RenderingContext rc, String icon, boolean isIconAbsoluteURI, Object text, String width, String height) throws IOException {
        if (icon != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("img", null);
            TreeRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"p_OraTreeIcon");
            if (width != null) {
                writer.writeAttribute("width", (Object)width, null);
            }
            if (height != null) {
                writer.writeAttribute("height", (Object)height, null);
            }
            if (!isIconAbsoluteURI) {
                icon = TreeRenderer.getAbsoluteImageUri(context, rc, icon);
            }
            this.renderEncodedResourceURI(context, "src", icon);
            OutputUtils.renderAltAndTooltipForImage(context, rc, text == null ? "" : text);
            writer.writeAttribute("border", (Object)"0", null);
            writer.endElement("img");
        }
    }

    private Boolean[] _appendIcon(Boolean[] prepend, Boolean isLine) {
        int currLength = prepend.length;
        if (prepend[currLength - 1] != null) {
            Boolean[] newBools = new Boolean[currLength + 5];
            System.arraycopy(prepend, 0, newBools, 0, currLength);
            prepend = newBools;
        }
        for (int i = 0; i < currLength; ++i) {
            if (prepend[i] != null) continue;
            prepend[i] = isLine;
            break;
        }
        return prepend;
    }

    private void _prependIcons(FacesContext context, RenderingContext rc, UIXHierarchy tree, Boolean[] prepend, boolean leftToRight) throws IOException {
        for (Boolean isLine : prepend) {
            if (isLine == null) continue;
            String icon = "t.gif";
            String backgroundIcon = this.getConnectingBackgroundIcon(context, rc, isLine, leftToRight);
            this.renderIconCell(context, rc, tree, backgroundIcon, icon, false, null, _ICON_WIDTH, "100%", null);
        }
    }

    protected boolean getImmediate(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._immediateKey);
        if (o == null) {
            o = this._immediateKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getDefaultIconName() {
        return null;
    }

    private void _renderStampBasedOnAccessibilty(FacesContext context, RenderingContext rc, UIComponent stamp, int depth) throws IOException {
        if (TreeRenderer.isScreenReaderMode((RenderingContext)rc)) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            FacesContext fc = FacesContext.getCurrentInstance();
            if (rc.isRightToLeft()) {
                this.encodeChild(context, stamp);
                TreeUtils.writeNodeLevel(fc, arc, depth, _NODE_LEVEL_TEXT_KEY);
            } else {
                TreeUtils.writeNodeLevel(fc, arc, depth, _NODE_LEVEL_TEXT_KEY);
                this.encodeChild(context, stamp);
            }
        } else {
            this.encodeChild(context, stamp);
        }
    }
}

