/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ValidatorUtils;

public class LengthValidator
extends javax.faces.validator.LengthValidator {
    public static final String VALIDATOR_ID = "org.apache.myfaces.trinidad.Length";
    public static final String MAXIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.LengthValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.LengthValidator.NOT_IN_RANGE";
    public static final String EXACT_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.LengthValidator.EXACT";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _DISABLED_KEY = _TYPE.registerKey("disabled", Boolean.class, Boolean.FALSE);
    private static final PropertyKey _MINIMUM_KEY = _TYPE.registerKey("minimum", Integer.class, (Object)0);
    private static final PropertyKey _MAXIMUM_KEY = _TYPE.registerKey("maximum", Integer.class, (Object)0);
    private static final PropertyKey _MAXIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMaximum", String.class);
    private static final PropertyKey _MINIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMinimum", String.class);
    private static final PropertyKey _NOT_IN_RANGE_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailNotInRange", String.class);
    private static final PropertyKey _EXACT_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailExact", String.class);
    private static final PropertyKey _HINT_MAXIMUM_KEY = _TYPE.registerKey("hintMaximum", String.class);
    private static final PropertyKey _HINT_MINIMUM_KEY = _TYPE.registerKey("hintMinimum", String.class);
    private static final PropertyKey _HINT_NOT_IN_RANGE = _TYPE.registerKey("hintNotInRange", String.class);
    private static final PropertyKey _HINT_EXACT = _TYPE.registerKey("hintExact", String.class);
    private FacesBean _facesBean = ValidatorUtils.getFacesBean(_TYPE);
    private boolean _transientValue = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        super(maximum);
    }

    public LengthValidator(int maximum, int minimum) {
        super(maximum, minimum);
    }

    public int getMaximum() {
        Object maxInt = this._facesBean.getProperty(_MAXIMUM_KEY);
        return ComponentUtils.resolveInteger(maxInt);
    }

    public void setMaximum(int maximum) {
        this._facesBean.setProperty(_MAXIMUM_KEY, maximum);
    }

    public int getMinimum() {
        Object minInt = this._facesBean.getProperty(_MINIMUM_KEY);
        return ComponentUtils.resolveInteger(minInt);
    }

    public void setMinimum(int minimum) {
        this._facesBean.setProperty(_MINIMUM_KEY, minimum);
    }

    public void setMessageDetailMaximum(String maximumMessageDetail) {
        this._facesBean.setProperty(_MAXIMUM_MESSAGE_DETAIL_KEY, maximumMessageDetail);
    }

    public String getMessageDetailMaximum() {
        Object maxMsgDet = this._facesBean.getProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(maxMsgDet);
    }

    public void setMessageDetailMinimum(String minimumMessageDetail) {
        this._facesBean.setProperty(_MINIMUM_MESSAGE_DETAIL_KEY, minimumMessageDetail);
    }

    public String getMessageDetailMinimum() {
        Object minMsgDet = this._facesBean.getProperty(_MINIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(minMsgDet);
    }

    public void setMessageDetailNotInRange(String notInRangeMessageDetail) {
        this._facesBean.setProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY, notInRangeMessageDetail);
    }

    public String getMessageDetailNotInRange() {
        Object notInRngMsg = this._facesBean.getProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(notInRngMsg);
    }

    public void setMessageDetailExact(String exactMessageDetail) {
        this._facesBean.setProperty(_EXACT_MESSAGE_DETAIL_KEY, exactMessageDetail);
    }

    public String getMessageDetailExact() {
        Object msg = this._facesBean.getProperty(_EXACT_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setHintMaximum(String hintMaximum) {
        this._facesBean.setProperty(_HINT_MAXIMUM_KEY, hintMaximum);
    }

    public String getHintMaximum() {
        Object obj = this._facesBean.getProperty(_HINT_MAXIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintMinimum(String hintMinimum) {
        this._facesBean.setProperty(_HINT_MINIMUM_KEY, hintMinimum);
    }

    public String getHintMinimum() {
        Object obj = this._facesBean.getProperty(_HINT_MINIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintNotInRange(String hintNotInRange) {
        this._facesBean.setProperty(_HINT_NOT_IN_RANGE, hintNotInRange);
    }

    public String getHintNotInRange() {
        Object obj = this._facesBean.getProperty(_HINT_NOT_IN_RANGE);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintExact(String hintExact) {
        this._facesBean.setProperty(_HINT_EXACT, hintExact);
    }

    public String getHintExact() {
        Object obj = this._facesBean.getProperty(_HINT_EXACT);
        return ComponentUtils.resolveString(obj);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (this.isDisabled()) {
            return;
        }
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            int length;
            int max = this.getMaximum();
            int min = this.getMinimum();
            int n = length = value instanceof String ? ((String)value).length() : value.toString().length();
            if (this.isMaximumSet() && this.isMinimumSet() && (length < min || length > max)) {
                throw new ValidatorException(this._getNotInRangeMessage(context, component, value, min, max));
            }
            if (this.isMinimumSet() && length < min) {
                throw new ValidatorException(this._getMinimumMessage(context, component, value, min));
            }
            if (this.isMaximumSet() && length > max) {
                throw new ValidatorException(this._getMaximumMessage(context, component, value, max));
            }
        }
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        ValidatorUtils.setValueExpression(this._facesBean, name, expression);
    }

    public ValueExpression getValueExpression(String name) {
        return ValidatorUtils.getValueExpression(this._facesBean, name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ValidatorUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ValidatorUtils.getValueBinding(this._facesBean, name);
    }

    public boolean isTransient() {
        return this._transientValue;
    }

    public void setTransient(boolean transientValue) {
        this._transientValue = transientValue;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof LengthValidator)) {
            return false;
        }
        LengthValidator other = (LengthValidator)((Object)otherObj);
        return this.getMaximum() == other.getMaximum() && this.getMinimum() == other.getMinimum() && this.isMinimumSet() == other.isMinimumSet() && this.isMaximumSet() == other.isMaximumSet() && this.isDisabled() == other.isDisabled() && this.isTransient() == other.isTransient();
    }

    public int hashCode() {
        int result = 17;
        String msgDetExact = this.getMessageDetailExact();
        String maxMsgDet = this.getMessageDetailMaximum();
        String minMsgDet = this.getMessageDetailMinimum();
        String notInRangeMsgDet = this.getMessageDetailNotInRange();
        result = 37 * result + (this.isDisabled() ? 1 : 0);
        result = 37 * result + (this.isTransient() ? 0 : 1);
        result = 37 * result + (this.isMaximumSet() ? 0 : 1);
        result = 37 * result + (this.isMinimumSet() ? 0 : 1);
        result = 37 * result + Integer.valueOf(this.getMinimum()).hashCode();
        result = 37 * result + Integer.valueOf(this.getMaximum()).hashCode();
        result = 37 * result + (msgDetExact == null ? 0 : msgDetExact.hashCode());
        result = 37 * result + (maxMsgDet == null ? 0 : maxMsgDet.hashCode());
        result = 37 * result + (minMsgDet == null ? 0 : minMsgDet.hashCode());
        result = 37 * result + (notInRangeMsgDet == null ? 0 : notInRangeMsgDet.hashCode());
        return result;
    }

    public void setDisabled(boolean isDisabled) {
        this._facesBean.setProperty(_DISABLED_KEY, isDisabled);
    }

    public boolean isDisabled() {
        Boolean disabled = (Boolean)this._facesBean.getProperty(_DISABLED_KEY);
        return disabled != null ? disabled : false;
    }

    protected boolean isMaximumSet() {
        return this._facesBean.getProperty(_MAXIMUM_KEY) != null;
    }

    protected boolean isMinimumSet() {
        return this._facesBean.getProperty(_MINIMUM_KEY) != null;
    }

    private FacesMessage _getNotInRangeMessage(FacesContext context, UIComponent component, Object value, Object min, Object max) {
        if (min.equals(max)) {
            return this._getExactMessage(context, component, value, min);
        }
        Object msg = this._getRawNotInRangeMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, min, max};
        return MessageFactory.getMessage(context, NOT_IN_RANGE_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawNotInRangeMessageDetail() {
        return this._facesBean.getRawProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getExactMessage(FacesContext context, UIComponent component, Object value, Object minMax) {
        Object msg = this._getRawExactMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, minMax};
        return MessageFactory.getMessage(context, EXACT_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawExactMessageDetail() {
        return this._facesBean.getRawProperty(_EXACT_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getMaximumMessage(FacesContext context, UIComponent component, Object value, Object max) {
        Object msg = this._getRawMaximumMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, max};
        return MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawMaximumMessageDetail() {
        return this._facesBean.getRawProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getMinimumMessage(FacesContext context, UIComponent component, Object value, Object min) {
        Object msg = this._getRawMinimumMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, min};
        return MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawMinimumMessageDetail() {
        return this._facesBean.getRawProperty(_MINIMUM_MESSAGE_DETAIL_KEY);
    }
}

