/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectManyShuttle;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelBoxRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectManyListboxRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.uix.SelectItemSupport;

public class SelectManyShuttleRenderer
extends SimpleSelectManyRenderer {
    private PropertyKey _sizeKey;
    private PropertyKey _leadingDescShownKey;
    private PropertyKey _leadingHeaderKey;
    private PropertyKey _trailingDescShownKey;
    private PropertyKey _trailingHeaderKey;
    private Box _leadingBox;
    private Box _trailingBox;
    private static final int _MAXIMUM_LIST_LEN = 20;
    private static final int _MINIMUM_LIST_LEN = 10;
    private static final int _BARS_MINIMUM_WIDTH = 15;
    private static final String _BARS_MINIMUM = "_______________";
    private static final int _DEFAULT_DESC_AREA_HEIGHT = 68;
    private static final int _DEFAULT_FILTER_HEIGHT = 36;
    private static final int _DEFAULT_FOOTER_HEIGHT = 36;
    private static final String _LEADING_COMPLETE = ":leading";
    private static final String _TRAILING_COMPLETE = ":trailing";
    private static final String _ITEMS_COMPLETE = ":items";
    private static final String _DESC_FIELD_COMPLETE = ":desc";
    private static final String _DESCRIPTION_COMPLETE = "_desc";
    private static final String _TRANSLATED_JS_FEEDBACK_NO_ITEMS = "var _shuttle_no_items='";
    private static final String _TRANSLATED_JS_FEEDBACK_NO_ITEMS_SELECTED = "var _shuttle_no_items_selected='";
    private static final Object _TRANSLATED_VARS_EXIST_PROPERTY_KEY = new Object();
    private static final Object _SHUTTLE_INFO_KEY = new Object();
    private static final int[] _EMPTY_INT_ARRAY = new int[0];
    private static final String _SHUTTLE_NO_ITEMS_FEEDBACK_KEY = "SHUTTLE_NO_ITEMS_FEEDBACK";
    private static final String _SHUTTLE_NO_ITEM_SELECTED_FEEDBACK_KEY = "SHUTTLE_NO_ITEM_SELECTED_FEEDBACK";
    protected static final String _SELECT_MANY_DESCRIPTION_LABEL_KEY = "af_selectManyShuttle.DESCRIPTION_LABEL";
    protected static final String _SELECT_MANY_MOVE_ALL_TIP_KEY = "af_selectManyShuttle.MOVE_ALL_TIP";
    protected static final String _SELECT_MANY_MOVE_TIP_KEY = "af_selectManyShuttle.MOVE_TIP";
    protected static final String _SELECT_MANY_REMOVE_ALL_TIP_KEY = "af_selectManyShuttle.REMOVE_ALL_TIP";
    protected static final String _SELECT_MANY_REMOVE_TIP_KEY = "af_selectManyShuttle.REMOVE_TIP";
    protected static final String _SELECT_MANY_MOVE_ALL_KEY = "af_selectManyShuttle.MOVE_ALL";
    protected static final String _SELECT_MANY_MOVE_KEY = "af_selectManyShuttle.MOVE";
    protected static final String _SELECT_MANY_REMOVE_ALL_KEY = "af_selectManyShuttle.REMOVE_ALL";
    protected static final String _SELECT_MANY_REMOVE_KEY = "af_selectManyShuttle.REMOVE";
    private static final Map<String, String> _SHUTTLE_KEY_MAP = new HashMap<String, String>();
    private static final TrinidadLogger _LOG;

    public SelectManyShuttleRenderer() {
        this(CoreSelectManyShuttle.TYPE);
    }

    protected SelectManyShuttleRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._sizeKey = type.findKey("size");
        this._leadingHeaderKey = type.findKey("leadingHeader");
        this._leadingDescShownKey = type.findKey("leadingDescShown");
        this._trailingHeaderKey = type.findKey("trailingHeader");
        this._trailingDescShownKey = type.findKey("trailingDescShown");
        this._leadingBox = new Box(type, new ShuttleList(type, true), true);
        this._trailingBox = new Box(type, new ShuttleList(type, false), false);
    }

    @Override
    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        this.detectAutoSubmit(context, component, clientId);
        String trailingId = clientId + ":trailing:items";
        String paramValue = (String)context.getExternalContext().getRequestParameterMap().get(trailingId);
        if (paramValue == null || "".equals(paramValue)) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(paramValue, ";");
        int availableItems = SelectItemSupport.getSelectItemCount(component);
        int numItems = 0;
        while (tokenizer.hasMoreElements()) {
            if (++numItems > availableItems) {
                _LOG.severe("SELECTED_SHUTTLE_ITEMS_EXCEEDED_TOTAL_NUMBER", (Object)clientId);
                return new String[0];
            }
            list.add(tokenizer.nextToken());
        }
        if (_LOG.isFiner()) {
            _LOG.finer("Found " + list.size() + " entries for shuttle " + clientId);
        }
        return list.toArray(new String[list.size()]);
    }

    protected Integer getSize(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._sizeKey);
        if (o == null) {
            o = this._sizeKey.getDefault();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return null;
    }

    protected boolean getReorderOnly(UIComponent component, FacesBean bean) {
        return false;
    }

    protected boolean getLeadingDescShown(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._leadingDescShownKey);
        if (o == null) {
            o = this._leadingDescShownKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getLeadingHeader(UIComponent component, FacesBean bean) {
        return SelectManyShuttleRenderer.toString((Object)bean.getProperty(this._leadingHeaderKey));
    }

    protected boolean getTrailingDescShown(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._trailingDescShownKey);
        if (o == null) {
            o = this._trailingDescShownKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getTrailingHeader(UIComponent component, FacesBean bean) {
        return SelectManyShuttleRenderer.toString((Object)bean.getProperty(this._trailingHeaderKey));
    }

    @Override
    protected boolean isAutoSubmit(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    public boolean getSimple(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected boolean renderReadOnlyAsElement(RenderingContext rc, UIComponent component, FacesBean bean) {
        return true;
    }

    @Override
    protected boolean getDisabled(UIComponent component, FacesBean bean) {
        if (super.getDisabled(component, bean)) {
            return true;
        }
        return super.getReadOnly(FacesContext.getCurrentInstance(), component, bean);
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectManyShuttle::content";
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectManyShuttle";
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int[] selectedIndices, Converter converter, boolean valuePassThru) throws IOException {
        int selectedIndex;
        int i;
        FormData fData = rc.getFormData();
        if (fData == null) {
            _LOG.warning("COMPONENT_REQUIRES_FORM", (Object)component);
            return;
        }
        String clientId = this.getClientId(context, component);
        XhtmlUtils.addLib(context, rc, "ShuttleProxy()");
        if (!valuePassThru) {
            SelectManyShuttleRenderer._convertSelectItemListToIndices(selectItems);
        }
        ArrayList<SelectItem> leadingSelectItems = new ArrayList<SelectItem>(selectItems);
        ArrayList<SelectItem> trailingSelectItems = new ArrayList<SelectItem>(selectedIndices.length);
        for (i = 0; i < selectedIndices.length; ++i) {
            selectedIndex = selectedIndices[i];
            if (selectedIndex < 0) continue;
            trailingSelectItems.add(selectItems.get(selectedIndex));
        }
        Arrays.sort(selectedIndices);
        for (i = selectedIndices.length - 1; i >= 0 && (selectedIndex = selectedIndices[i]) >= 0; --i) {
            leadingSelectItems.remove(selectedIndex);
        }
        ShuttleInfo info = this._createAndSetShuttleInfo(rc, component, bean, leadingSelectItems, trailingSelectItems, clientId);
        leadingSelectItems.add(new SelectItem((Object)"", info.barText));
        trailingSelectItems.add(new SelectItem((Object)"", info.barText));
        Map originalSkinResourceMap = rc.getSkinResourceKeyMap();
        rc.setSkinResourceKeyMap(this.getResourceKeyMap());
        ResponseWriter rw = context.getResponseWriter();
        this._addTranslations(context, rc);
        boolean onlyOneList = this.getReorderOnly(component, bean);
        rw.startElement("table", component);
        OutputUtils.renderLayoutTableAttributes(context, rc, "0", "10%");
        rw.writeAttribute("id", (Object)clientId, null);
        this.renderShortDescAttribute(context, rc, component, bean);
        this.renderEventHandlers(context, component, bean);
        this.renderRootDomElementStyles(context, rc, component, bean);
        this._renderHeaderRow(context, rc, component, bean, onlyOneList);
        this._renderContainerRow(context, rc, component, bean, onlyOneList, clientId);
        rw.endElement("table");
        rc.setSkinResourceKeyMap(originalSkinResourceMap);
        SelectManyShuttleRenderer._clearContext(rc);
    }

    private void _renderScriptsAndValues(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String clientId, boolean onlyOneList) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        ContainerInfo leadingInfo = this._getContainerInfo(rc, true);
        ContainerInfo trailingInfo = this._getContainerInfo(rc, false);
        if (!onlyOneList) {
            rw.startElement("input", null);
            rw.writeAttribute("type", (Object)"hidden", null);
            rw.writeAttribute("name", (Object)(leadingInfo.id + _ITEMS_COMPLETE), null);
            rw.writeAttribute("value", (Object)this._getValue(leadingInfo.itemsList), null);
            rw.endElement("input");
        }
        rw.startElement("input", null);
        rw.writeAttribute("type", (Object)"hidden", null);
        rw.writeAttribute("name", (Object)(trailingInfo.id + _ITEMS_COMPLETE), null);
        rw.writeAttribute("value", (Object)this._getValue(trailingInfo.itemsList), null);
        rw.endElement("input");
        rw.startElement("script", null);
        SelectManyShuttleRenderer.renderScriptDeferAttribute(context, rc);
        SelectManyShuttleRenderer.renderScriptTypeAttribute(context, rc);
        if (!onlyOneList && this.getLeadingDescShown(component, bean)) {
            this._writeDescriptionScript(context, leadingInfo.itemsList, leadingInfo.id + _DESCRIPTION_COMPLETE);
        }
        this._writeDescriptionScript(context, trailingInfo.itemsList, trailingInfo.id + _DESCRIPTION_COMPLETE);
        this._writeResetScript(context, rc, clientId);
        rw.endElement("script");
    }

    protected void renderReorderButtons(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String listId) throws IOException {
    }

    private void _writeResetScript(FacesContext context, RenderingContext rc, String clientId) throws IOException {
        String formName = rc.getFormData().getName();
        String jsFormName = XhtmlUtils.getJSIdentifier(formName);
        String jsClientId = XhtmlUtils.getJSIdentifier(clientId);
        StringBuilder funcCallBuffer = new StringBuilder(19 + formName.length() + clientId.length());
        funcCallBuffer.append("TrShuttleProxy._resetItems('").append(clientId);
        funcCallBuffer.append("','").append(formName).append("');");
        FormRenderer.addResetCall(clientId, funcCallBuffer.toString());
        ResponseWriter rw = context.getResponseWriter();
        rw.writeText((Object)"window[\"_", null);
        rw.writeText((Object)jsFormName, null);
        rw.writeText((Object)"_", null);
        rw.writeText((Object)jsClientId, null);
        rw.writeText((Object)"_orig\"]=TrShuttleProxy._copyLists('", null);
        rw.writeText((Object)clientId, null);
        rw.writeText((Object)"','", null);
        rw.writeText((Object)formName, null);
        rw.writeText((Object)"');", null);
    }

    private void _writeDescriptionScript(FacesContext context, List<SelectItem> selectItems, String id) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        id = XhtmlUtils.getJSIdentifier(id);
        rw.writeText((Object)id, null);
        rw.writeText((Object)"=new Array(", null);
        boolean writtenOne = false;
        for (SelectItem item : selectItems) {
            if (writtenOne) {
                rw.writeText((Object)",", null);
            } else {
                writtenOne = true;
            }
            String description = item.getDescription();
            if (description == null) {
                rw.writeText((Object)"''", null);
                continue;
            }
            rw.writeText((Object)"'", null);
            rw.writeText((Object)XhtmlUtils.escapeJS(description, true), null);
            rw.writeText((Object)"'", null);
        }
        rw.writeText((Object)");", null);
    }

    private static void _convertSelectItemListToIndices(List<SelectItem> itemsToConvert) {
        int length = itemsToConvert.size();
        for (int j = 0; j < length; ++j) {
            SelectItem oldSelectItem = itemsToConvert.get(j);
            SelectItem newSelectItem = new SelectItem((Object)j, oldSelectItem.getLabel(), oldSelectItem.getDescription(), oldSelectItem.isDisabled());
            itemsToConvert.set(j, newSelectItem);
        }
    }

    private String _getValue(List<SelectItem> items) {
        StringBuilder vals = new StringBuilder();
        for (SelectItem item : items) {
            if (vals.length() > 0) {
                vals.append(';');
            }
            vals.append(item.getValue());
        }
        return vals.toString();
    }

    private void _addTranslations(FacesContext context, RenderingContext rc) throws IOException {
        if (!rc.getProperties().containsKey(_TRANSLATED_VARS_EXIST_PROPERTY_KEY)) {
            ResponseWriter rw = context.getResponseWriter();
            rc.getProperties().put(_TRANSLATED_VARS_EXIST_PROPERTY_KEY, Boolean.TRUE);
            rw.startElement("script", null);
            SelectManyShuttleRenderer.renderScriptDeferAttribute(context, rc);
            SelectManyShuttleRenderer.renderScriptTypeAttribute(context, rc);
            String noItems = rc.getTranslatedString(_SHUTTLE_NO_ITEMS_FEEDBACK_KEY);
            String noItemsSelected = rc.getTranslatedString(_SHUTTLE_NO_ITEM_SELECTED_FEEDBACK_KEY);
            rw.writeText((Object)_TRANSLATED_JS_FEEDBACK_NO_ITEMS, null);
            if (noItems != null) {
                rw.writeText((Object)XhtmlUtils.escapeJS(noItems, true), null);
            }
            rw.writeText((Object)"';", null);
            rw.writeText((Object)_TRANSLATED_JS_FEEDBACK_NO_ITEMS_SELECTED, null);
            if (noItemsSelected != null) {
                rw.writeText((Object)XhtmlUtils.escapeJS(noItemsSelected, true), null);
            }
            rw.writeText((Object)"';", null);
            rw.endElement("script");
        }
    }

    private void _renderHeaderRow(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean onlyOneList) throws IOException {
        String trailingHeader;
        Icon icon;
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("tr", null);
        if (!onlyOneList) {
            rw.startElement("td", null);
            SelectManyShuttleRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraShuttleHeader");
            rw.writeAttribute("valign", (Object)"bottom", null);
            String leadingHeader = this.getLeadingHeader(component, bean);
            if (leadingHeader != null) {
                rw.writeText((Object)leadingHeader, "leadingHeader");
            }
            rw.endElement("td");
            rw.startElement("td", null);
            rw.endElement("td");
        }
        rw.startElement("td", null);
        SelectManyShuttleRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraShuttleHeader");
        rw.writeAttribute("valign", (Object)"bottom", null);
        if ((this.getRequired(component, bean) || this.getShowRequired(component, bean)) && (icon = rc.getIcon("AFRequiredIcon")) != null) {
            OutputUtils.renderIcon(context, rc, icon, rc.getTranslatedString("REQUIRED_TIP"), null);
            this.renderSpacer(context, rc, "1", "1");
        }
        if ((trailingHeader = this.getTrailingHeader(component, bean)) != null) {
            rw.writeText((Object)trailingHeader, "trailingHeader");
        }
        rw.endElement("td");
        rw.endElement("tr");
    }

    private void _renderContainerRow(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean onlyOneList, String clientId) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!onlyOneList) {
            rw.startElement("tr", null);
            rw.startElement("td", null);
            this.delegateRenderer(context, rc, component, bean, this._leadingBox);
            rw.endElement("td");
            rw.startElement("td", null);
            rw.writeAttribute("align", (Object)"center", null);
            rw.writeAttribute("valign", (Object)"middle", null);
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            rw.writeAttribute("style", (Object)"padding:5px", null);
            this._renderMoveButtons(context, rc, component, bean);
            rw.endElement("td");
        }
        rw.startElement("td", null);
        this.delegateRenderer(context, rc, component, bean, this._trailingBox);
        this._renderScriptsAndValues(context, rc, component, bean, clientId, onlyOneList);
        rw.endElement("td");
        rw.endElement("tr");
    }

    private void _renderMoveButtons(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        ShuttleInfo info = this._getShuttleInfo(rc);
        String leadingId = info.leadingInfo.id;
        String trailingId = info.trailingInfo.id;
        boolean disabled = this.getDisabled(component, bean);
        String moveUrl = disabled ? null : "javascript:TrShuttleProxy._moveItems('" + leadingId + "','" + trailingId + "');";
        this.renderButton(context, rc, "af|selectManyShuttle::move-icon", _SELECT_MANY_MOVE_TIP_KEY, moveUrl);
        this._renderLink(context, rc, _SELECT_MANY_MOVE_KEY, _SELECT_MANY_MOVE_TIP_KEY, moveUrl);
        rw.startElement("div", null);
        rw.writeAttribute("style", (Object)"margin-top:5px", null);
        rw.endElement("div");
        String moveAllUrl = disabled ? null : "javascript:TrShuttleProxy._moveAllItems('" + leadingId + "','" + trailingId + "');";
        this.renderButton(context, rc, "af|selectManyShuttle::move-all-icon", _SELECT_MANY_MOVE_ALL_TIP_KEY, moveAllUrl);
        this._renderLink(context, rc, _SELECT_MANY_MOVE_ALL_KEY, _SELECT_MANY_MOVE_ALL_TIP_KEY, moveAllUrl);
        rw.startElement("div", null);
        rw.writeAttribute("style", (Object)"margin-top:5px", null);
        rw.endElement("div");
        String removeUrl = disabled ? null : "javascript:TrShuttleProxy._moveItems('" + trailingId + "','" + leadingId + "');";
        this.renderButton(context, rc, "af|selectManyShuttle::remove-icon", _SELECT_MANY_REMOVE_TIP_KEY, removeUrl);
        this._renderLink(context, rc, _SELECT_MANY_REMOVE_KEY, _SELECT_MANY_REMOVE_TIP_KEY, removeUrl);
        rw.startElement("div", null);
        rw.writeAttribute("style", (Object)"margin-top:5px", null);
        rw.endElement("div");
        String removeAllUrl = disabled ? null : "javascript:TrShuttleProxy._moveAllItems('" + trailingId + "','" + leadingId + "');";
        this.renderButton(context, rc, "af|selectManyShuttle::remove-all-icon", _SELECT_MANY_REMOVE_ALL_TIP_KEY, removeAllUrl);
        this._renderLink(context, rc, _SELECT_MANY_REMOVE_ALL_KEY, _SELECT_MANY_REMOVE_ALL_TIP_KEY, removeAllUrl);
    }

    private int _getBestListLen(UIComponent component, FacesBean bean, int leadingListCount, int trailingListCount) {
        boolean between2;
        Integer rows = this.getSize(component, bean);
        if (rows != null) {
            return Math.min(20, Math.max(10, rows));
        }
        boolean higher1 = leadingListCount > 20;
        boolean higher2 = trailingListCount > 20;
        boolean between1 = leadingListCount > 10 && leadingListCount < 20;
        boolean bl = between2 = trailingListCount > 10 && trailingListCount < 20;
        if (higher1 || higher2) {
            return 20;
        }
        if (between1 && between2) {
            return Math.min(leadingListCount, trailingListCount);
        }
        if (between1 || between2) {
            return Math.max(leadingListCount, trailingListCount);
        }
        return 10;
    }

    private static final void _clearContext(RenderingContext rc) {
        rc.getProperties().remove(_SHUTTLE_INFO_KEY);
    }

    private void _startRow(FacesContext context, int colspan) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("tr", null);
        rw.startElement("td", null);
        rw.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        rw.writeAttribute("valign", (Object)"middle", null);
        if (colspan > 1) {
            rw.writeAttribute("colspan", (Object)colspan, null);
        }
    }

    private void _endRow(FacesContext context, RenderingContext rc, int height) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.endElement("td");
        if (height > 0) {
            rw.startElement("td", null);
            this.renderSpacer(context, rc, "1", Integer.toString(height));
            rw.endElement("td");
        }
        rw.endElement("tr");
    }

    protected void renderButton(FacesContext context, RenderingContext rc, String iconName, String shortDescKey, String href) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("a", null);
        this.renderEncodedActionURI(context, "href", href);
        Icon icon = rc.getIcon(iconName);
        if (icon != null) {
            OutputUtils.renderIcon(context, rc, icon, rc.getTranslatedString(shortDescKey), null, true);
        }
        rw.endElement("a");
    }

    private void _renderLink(FacesContext context, RenderingContext rc, String textKey, String shortDescKey, String href) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("a", null);
        this.renderEncodedActionURI(context, "href", href);
        SelectManyShuttleRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)(href == null ? "OraLinkDisabled" : "OraLink"));
        rw.writeAttribute("title", (Object)rc.getTranslatedString(shortDescKey), null);
        rw.writeText((Object)rc.getTranslatedString(textKey), null);
        rw.endElement("a");
    }

    protected Map<String, String> getResourceKeyMap() {
        return _SHUTTLE_KEY_MAP;
    }

    private ShuttleInfo _getShuttleInfo(RenderingContext rc) {
        return (ShuttleInfo)rc.getProperties().get(_SHUTTLE_INFO_KEY);
    }

    private ContainerInfo _getContainerInfo(RenderingContext rc, boolean isLeading) {
        ShuttleInfo shuttleInfo = this._getShuttleInfo(rc);
        return isLeading ? shuttleInfo.leadingInfo : shuttleInfo.trailingInfo;
    }

    private ShuttleInfo _createAndSetShuttleInfo(RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> leadingItems, List<SelectItem> trailingItems, String clientId) {
        int barWidth;
        ShuttleInfo shuttleInfo = new ShuttleInfo();
        ContainerInfo leadingInfo = new ContainerInfo(leadingItems);
        ContainerInfo trailingInfo = new ContainerInfo(trailingItems);
        leadingInfo.id = clientId + _LEADING_COMPLETE;
        trailingInfo.id = clientId + _TRAILING_COMPLETE;
        shuttleInfo.listLen = this._getBestListLen(component, bean, leadingInfo.listCount, trailingInfo.listCount);
        int descWidth = barWidth = Math.max(Math.max(trailingInfo.maxWidth, leadingInfo.maxWidth), 15);
        if (SelectManyShuttleRenderer.isIE((RenderingContext)rc) || SelectManyShuttleRenderer.isGecko((RenderingContext)rc)) {
            descWidth = descWidth * 6 / 5;
        }
        shuttleInfo.descWidth = descWidth;
        if (barWidth <= 15) {
            shuttleInfo.barText = _BARS_MINIMUM;
        } else {
            char[] addedChars = new char[barWidth - 15];
            for (int i = 0; i < barWidth - 15; ++i) {
                addedChars[i] = 95;
            }
            shuttleInfo.barText = _BARS_MINIMUM + new String(addedChars);
        }
        shuttleInfo.leadingInfo = leadingInfo;
        shuttleInfo.trailingInfo = trailingInfo;
        rc.getProperties().put(_SHUTTLE_INFO_KEY, shuttleInfo);
        return shuttleInfo;
    }

    static {
        _SHUTTLE_KEY_MAP.put("af|panelBox::light", "af|selectManyShuttle::box");
        _SHUTTLE_KEY_MAP.put("af|panelBox::body", "af|selectManyShuttle::box-body");
        _SHUTTLE_KEY_MAP.put("af|panelBox::top-start", "af|selectManyShuttle::box-top-start");
        _SHUTTLE_KEY_MAP.put("af|panelBox::top", "af|selectManyShuttle::box-top");
        _SHUTTLE_KEY_MAP.put("af|panelBox::top-end", "af|selectManyShuttle::box-top-end");
        _SHUTTLE_KEY_MAP.put("af|panelBox::start", "af|selectManyShuttle::box-start");
        _SHUTTLE_KEY_MAP.put("af|panelBox::content", "af|selectManyShuttle::box-content");
        _SHUTTLE_KEY_MAP.put("af|panelBox::end", "af|selectManyShuttle::box-end");
        _SHUTTLE_KEY_MAP.put("af|panelBox::bottom-start", "af|selectManyShuttle::box-bottom-start");
        _SHUTTLE_KEY_MAP.put("af|panelBox::bottom", "af|selectManyShuttle::box-bottom");
        _SHUTTLE_KEY_MAP.put("af|panelBox::bottom-end", "af|selectManyShuttle::box-bottom-end");
        _LOG = TrinidadLogger.createTrinidadLogger(SelectManyShuttleRenderer.class);
    }

    private static class ContainerInfo {
        public final List<SelectItem> itemsList;
        public final int listCount;
        public String id;
        public int maxWidth = 0;

        public ContainerInfo(List<SelectItem> itemsList) {
            this.itemsList = itemsList;
            this.listCount = itemsList.size();
            for (SelectItem item : itemsList) {
                String text = item.getLabel();
                if (text == null) continue;
                this.maxWidth = Math.max(text.length(), this.maxWidth);
            }
        }
    }

    private static class ShuttleInfo {
        public String barText;
        public int listLen;
        public int descWidth;
        public ContainerInfo leadingInfo = null;
        public ContainerInfo trailingInfo = null;

        private ShuttleInfo() {
        }
    }

    private class Box
    extends PanelBoxRenderer {
        private ShuttleList _list;
        private boolean _isLeading;

        public Box(FacesBean.Type type, ShuttleList list, boolean isLeading) {
            super(type);
            this._list = list;
            this._isLeading = isLeading;
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            return null;
        }

        @Override
        protected boolean hasChildren(UIComponent component) {
            return true;
        }

        @Override
        protected String getShortDesc(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getStyleClass(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getInlineStyle(UIComponent component, FacesBean bean) {
            return "width:100%";
        }

        @Override
        protected String getText(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getIcon(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getContentStyle(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getBackground(UIComponent component, FacesBean bean) {
            return null;
        }

        protected void encodeAllChildren(FacesContext context, UIComponent component) throws IOException {
            UIComponent filter;
            ResponseWriter rw = context.getResponseWriter();
            RenderingContext rc = RenderingContext.getCurrentInstance();
            FacesBean bean = this.getFacesBean(component);
            ShuttleInfo shuttleInfo = SelectManyShuttleRenderer.this._getShuttleInfo(rc);
            ContainerInfo containerInfo = SelectManyShuttleRenderer.this._getContainerInfo(rc, this._isLeading);
            rw.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, rc, null, null);
            if (this._isLeading && (filter = Box.getFacet((UIComponent)component, (String)"filter")) != null) {
                SelectManyShuttleRenderer.this._startRow(context, 3);
                this.encodeChild(context, filter);
                SelectManyShuttleRenderer.this._endRow(context, rc, 36);
            }
            SelectManyShuttleRenderer.this._startRow(context, 1);
            this.delegateRenderer(context, rc, component, bean, this._list);
            if (!this._isLeading && SelectManyShuttleRenderer.this.isReorderable()) {
                rw.endElement("td");
                SelectManyShuttleRenderer.this.renderReorderButtons(context, rc, component, bean, containerInfo.id);
                rw.startElement("td", null);
            }
            boolean hasLeadingDesc = SelectManyShuttleRenderer.this.getLeadingDescShown(component, bean);
            boolean hasTrailingDesc = SelectManyShuttleRenderer.this.getTrailingDescShown(component, bean);
            boolean hasDescArea = hasLeadingDesc || hasTrailingDesc;
            SelectManyShuttleRenderer.this._endRow(context, rc, 0);
            if (hasDescArea) {
                SelectManyShuttleRenderer.this._startRow(context, 1);
                SelectManyShuttleRenderer.this._endRow(context, rc, 8);
                SelectManyShuttleRenderer.this._startRow(context, 3);
                rw.startElement("span", null);
                Box.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"AFInstructionText");
                String label = rc.getTranslatedString(SelectManyShuttleRenderer._SELECT_MANY_DESCRIPTION_LABEL_KEY);
                rw.writeText((Object)label, null);
                rw.endElement("span");
                rw.startElement("div", null);
                rw.endElement("div");
                rw.startElement("textarea", null);
                rw.writeAttribute("rows", (Object)"2", null);
                String textareaId = containerInfo.id + SelectManyShuttleRenderer._DESC_FIELD_COMPLETE;
                rw.writeAttribute("id", (Object)textareaId, null);
                rw.writeAttribute("name", (Object)textareaId, null);
                rw.writeAttribute("readonly", (Object)Boolean.TRUE, null);
                rw.writeAttribute("cols", (Object)shuttleInfo.descWidth, null);
                rw.writeAttribute("wrap", (Object)"soft", null);
                rw.endElement("textarea");
                HiddenLabelUtils.outputHiddenLabelIfNeeded(context, rc, textareaId, label, component);
                SelectManyShuttleRenderer.this._endRow(context, rc, 68);
            }
            UIComponent leadingFooter = Box.getFacet((UIComponent)component, (String)"leadingFooter");
            UIComponent trailingFooter = Box.getFacet((UIComponent)component, (String)"trailingFooter");
            if (leadingFooter != null && trailingFooter != null) {
                UIComponent footer;
                SelectManyShuttleRenderer.this._startRow(context, 1);
                SelectManyShuttleRenderer.this._endRow(context, rc, 8);
                SelectManyShuttleRenderer.this._startRow(context, 3);
                UIComponent uIComponent = footer = this._isLeading ? leadingFooter : trailingFooter;
                if (footer != null) {
                    this.encodeChild(context, footer);
                }
                SelectManyShuttleRenderer.this._endRow(context, rc, 36);
            }
            rw.endElement("table");
        }
    }

    private class ShuttleList
    extends SimpleSelectManyListboxRenderer {
        private boolean _isLeading;

        public ShuttleList(FacesBean.Type type, boolean isLeading) {
            super(type);
            this._isLeading = isLeading;
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            ContainerInfo info = SelectManyShuttleRenderer.this._getContainerInfo(rc, this._isLeading);
            return info.id;
        }

        @Override
        protected String getOndblclick(UIComponent component, FacesBean bean) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            ContainerInfo info = SelectManyShuttleRenderer.this._getContainerInfo(rc, this._isLeading);
            ContainerInfo otherInfo = SelectManyShuttleRenderer.this._getContainerInfo(rc, !this._isLeading);
            StringBuilder builder = new StringBuilder();
            builder.append("TrShuttleProxy._moveItems('");
            builder.append(info.id);
            builder.append("','");
            builder.append(otherInfo.id);
            builder.append("','");
            builder.append(rc.getFormData().getName());
            builder.append("');");
            return builder.toString();
        }

        @Override
        protected String getShortDesc(UIComponent component, FacesBean bean) {
            if (this._isLeading) {
                return SelectManyShuttleRenderer.this.getLeadingHeader(component, bean);
            }
            return SelectManyShuttleRenderer.this.getTrailingHeader(component, bean);
        }

        @Override
        protected boolean getDisabled(UIComponent component, FacesBean bean) {
            if (super.getDisabled(component, bean)) {
                return true;
            }
            return super.getReadOnly(FacesContext.getCurrentInstance(), component, bean);
        }

        @Override
        protected boolean getReadOnly(FacesContext context, UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        protected String getOnchange(UIComponent component, FacesBean bean) {
            if (this._isLeading ? !SelectManyShuttleRenderer.this.getLeadingDescShown(component, bean) : !SelectManyShuttleRenderer.this.getTrailingDescShown(component, bean)) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            RenderingContext rc = RenderingContext.getCurrentInstance();
            ContainerInfo info = SelectManyShuttleRenderer.this._getContainerInfo(rc, this._isLeading);
            builder.append("TrShuttleProxy._displayDesc('");
            builder.append(info.id);
            builder.append("','");
            builder.append(rc.getFormData().getName());
            builder.append("');");
            return builder.toString();
        }

        @Override
        protected int[] getSelectedIndices(FacesContext context, UIComponent component, FacesBean bean, List<SelectItem> selectItems, Converter converter, boolean valuePassThru) {
            return _EMPTY_INT_ARRAY;
        }

        @Override
        protected List<SelectItem> getSelectItems(UIComponent component, Converter converter) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            ContainerInfo info = SelectManyShuttleRenderer.this._getContainerInfo(rc, this._isLeading);
            return info.itemsList;
        }

        @Override
        protected int getSize(UIComponent component, FacesBean bean) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            ShuttleInfo info = SelectManyShuttleRenderer.this._getShuttleInfo(rc);
            return info.listLen;
        }

        @Override
        protected boolean isAutoSubmit(UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        public boolean getSimple(UIComponent component, FacesBean bean) {
            return true;
        }

        @Override
        protected boolean getValuePassThru(UIComponent component, FacesBean bean) {
            return true;
        }

        @Override
        protected String getStyleClass(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getInlineStyle(UIComponent component, FacesBean bean) {
            return null;
        }
    }
}

