/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlHtml;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.util.FrameBustingUtils;

public class HtmlRenderer
extends XhtmlRenderer {
    private PropertyKey _modeKey;
    protected static final String HTML_QUIRKS_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    protected static final String HTML_STANDARDS_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    protected static final String HTML_STRICT_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    protected static final String HTML_FRAMESET_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">";
    protected static final String XHTML_STRICT_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    protected static final String XHTML_TRANSITIONAL_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    protected static final String XHTML_FRAMESET_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">";
    protected static final String BASIC_XHTML_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML Basic 1.0//EN\" \"http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd\">";
    protected static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final String _DISABLE_STANDARDS_MODE = "org.apache.myfaces.trinidad.ENABLE_QUIRKS_MODE";

    public static boolean isStandardsModeDisabled(FacesContext context) {
        String disableStandardsMode = context.getExternalContext().getInitParameter(_DISABLE_STANDARDS_MODE);
        return disableStandardsMode != null && disableStandardsMode.equalsIgnoreCase("true");
    }

    public HtmlRenderer() {
        this(HtmlHtml.TYPE);
    }

    protected HtmlRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._modeKey = type.findKey("mode");
    }

    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        String documentNamespace;
        String frameBusting = FrameBustingUtils.getFrameBustingValue(context, rc.getRequestContext());
        if (!"never".equalsIgnoreCase(frameBusting)) {
            try {
                if ("always".equalsIgnoreCase(frameBusting)) {
                    context.getExternalContext().addResponseHeader("X-Frame-Options", "deny");
                } else {
                    context.getExternalContext().addResponseHeader("X-Frame-Options", "sameorigin");
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
        ResponseWriter writer = context.getResponseWriter();
        String docType = this.getDocType(context, comp, bean);
        if (docType != null) {
            writer.write(docType);
        }
        writer.startElement("html", comp);
        boolean isXML = this.isXMLDocument(context);
        if (isXML && (documentNamespace = this.getDocumentNamespace()) != null) {
            writer.writeAttribute("xmlns", (Object)documentNamespace, null);
        }
        String direction = rc.isRightToLeft() ? "rtl" : "ltr";
        writer.writeAttribute("dir", (Object)direction, null);
        String lang = rc.getLocaleContext().getTranslationIANALocaleString();
        if (lang != null) {
            if (isXML) {
                writer.writeAttribute("xml:lang", (Object)lang, null);
            } else {
                writer.writeAttribute("lang", (Object)lang, null);
            }
        }
    }

    public void encodeEnd(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.endElement("html");
    }

    protected String getMode(UIComponent component, FacesBean bean) {
        return HtmlRenderer.toString((Object)bean.getProperty(this._modeKey));
    }

    protected String getDocType(FacesContext context, UIComponent component, FacesBean bean) {
        if (this._hasFrameSet(component)) {
            return this.getFrameSetDocType(context);
        }
        return this.getDocumentDocType(context, component, bean);
    }

    protected String getFrameSetDocType(FacesContext context) {
        if (this.isXMLDocument(context)) {
            return XHTML_FRAMESET_DOCTYPE;
        }
        return HTML_FRAMESET_DOCTYPE;
    }

    protected String getDocumentDocType(FacesContext context, UIComponent component, FacesBean bean) {
        String mode = this.getMode(component, bean);
        if (this.isXMLDocument(context)) {
            if ("strict".equals(mode)) {
                return XHTML_STRICT_DOCTYPE;
            }
            return XHTML_TRANSITIONAL_DOCTYPE;
        }
        if (HtmlRenderer.isStandardsModeDisabled(context) || "quirks".equals(mode)) {
            return HTML_QUIRKS_DOCTYPE;
        }
        if ("strict".equals(mode)) {
            return HTML_STRICT_DOCTYPE;
        }
        return HTML_STANDARDS_DOCTYPE;
    }

    private boolean _hasFrameSet(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (!"org.apache.myfaces.trinidad.FrameBorderLayout".equals(child.getFamily())) continue;
            return true;
        }
        return false;
    }

    protected String getDocumentNamespace() {
        return XHTML_NAMESPACE;
    }

    protected boolean isXMLDocument(FacesContext context) {
        String contentType = null;
        contentType = context.getResponseWriter().getContentType();
        return "text/xml".equals(contentType) || "application/xhtml+xml".equals(contentType) || "application/xml".equals(contentType);
    }
}

