/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.beans.BeanInfo;
import java.io.IOException;
import java.util.Locale;
import javax.faces.application.Resource;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.trinidad.render.InternalView;
import org.apache.myfaces.trinidadinternal.application.ViewDeclarationLanguageFactoryImpl;

public class InternalViewHandlingStrategy
extends ViewDeclarationLanguage {
    private final ViewDeclarationLanguageFactoryImpl.InternalViewFinder _finder;
    private static final StateManagementStrategy _STATELESS_STRATEGY = new StateManagementStrategy(){

        public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
            return null;
        }

        public Object saveView(FacesContext context) {
            return null;
        }
    };

    public InternalViewHandlingStrategy(ViewDeclarationLanguageFactoryImpl.InternalViewFinder finder) {
        this._finder = finder;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot root = this._finder.getInternalView(context, viewId).createView(context, viewId);
        if (root != null) {
            return root;
        }
        return this._defaultCreateView(context, viewId);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this._finder.getInternalView(context, viewId).restoreView(context, viewId);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        this._finder.getInternalView(context, viewToRender.getViewId()).renderView(context, viewToRender);
    }

    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        InternalView internal = this._finder.getInternalView(context, viewId);
        if (!internal.isStateless(context, viewId)) {
            return null;
        }
        return _STATELESS_STRATEGY;
    }

    public BeanInfo getComponentMetadata(FacesContext facesContext, Resource resource) {
        return null;
    }

    public ViewMetadata getViewMetadata(FacesContext facesContext, String string) {
        return null;
    }

    public Resource getScriptComponentResource(FacesContext facesContext, Resource resource) {
        return null;
    }

    public void buildView(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException {
    }

    boolean __isStateless(FacesContext context, String viewId) {
        InternalView internal = this._finder.getInternalView(context, viewId);
        return internal.isStateless(context, viewId);
    }

    private UIViewRoot _defaultCreateView(FacesContext context, String viewId) {
        UIViewRoot result = (UIViewRoot)context.getApplication().createComponent("javax.faces.ViewRoot");
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        if (locale == null) {
            locale = context.getApplication().getViewHandler().calculateLocale(context);
        }
        if (renderKitId == null) {
            renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        result.setViewId(viewId);
        return result;
    }
}

