/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderChildrenComponentChange
extends ComponentChange
implements DocumentChange {
    private final List<String> _childIds;
    private final String _identifier;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ReorderChildrenComponentChange.class);
    private static final long serialVersionUID = 1L;

    public ReorderChildrenComponentChange(List<String> childIds) {
        this(childIds, "id");
    }

    public ReorderChildrenComponentChange(List<String> childIds, String identifier) {
        if (childIds == null) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONSTRUCT_REORDERCHANGE_WITH_NULL_ID"));
        }
        if (identifier == null || "".equals(identifier)) {
            throw new IllegalArgumentException(_LOG.getMessage("IDENTIFIER_TYPE_CANNOT_BE_NULL"));
        }
        this._childIds = Collections.unmodifiableList(new ArrayList<String>(childIds));
        this._identifier = identifier;
    }

    public List<String> getChildIds() {
        return this._childIds;
    }

    public final String getIdentifier() {
        return this._identifier;
    }

    @Override
    public void changeComponent(UIComponent uiComponent) {
        int childCount = uiComponent.getChildCount();
        if (childCount == 0) {
            return;
        }
        LinkedHashMap<String, UIComponent> childrenMap = new LinkedHashMap<String, UIComponent>();
        List children = uiComponent.getChildren();
        int fakeIndex = 0;
        for (UIComponent child : children) {
            String attrValue = (String)child.getAttributes().get(this._identifier);
            if (attrValue == null) {
                attrValue = Integer.valueOf(fakeIndex++).toString();
            }
            childrenMap.put(attrValue, child);
        }
        children.clear();
        for (String currReorderID : this._childIds) {
            UIComponent currChild = (UIComponent)childrenMap.remove(currReorderID);
            if (currChild == null) continue;
            children.add(currChild);
        }
        children.addAll(childrenMap.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void changeDocument(Node componentNode) {
        LinkedHashMap<void, Node> currChildrenMap = new LinkedHashMap<void, Node>(13);
        Node currChild = componentNode.getFirstChild();
        int fakeIndex = 0;
        while (currChild != null) {
            void var6_6;
            void var6_9;
            Node idAttr;
            NamedNodeMap attributes = currChild.getAttributes();
            Object var6_7 = null;
            if (attributes != null && (idAttr = attributes.getNamedItem(this._identifier)) != null) {
                String string = idAttr.getNodeValue();
            }
            if (var6_9 == null) {
                String string = Integer.valueOf(fakeIndex++).toString();
            }
            currChildrenMap.put(var6_6, currChild);
            componentNode.removeChild(currChild);
            currChild = componentNode.getFirstChild();
        }
        for (String string : this._childIds) {
            currChild = (Node)currChildrenMap.remove(string);
            if (currChild == null) continue;
            componentNode.appendChild(currChild);
        }
        for (Map.Entry entry : currChildrenMap.entrySet()) {
            componentNode.appendChild((Node)entry.getValue());
        }
    }

    @Override
    public boolean getForcesDocumentReload() {
        return false;
    }
}

