/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import org.apache.myfaces.trinidad.component.UIXEditableValue;
import org.apache.myfaces.trinidad.component.UIXInput;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.convert.ClientConverter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.FastMessageFormat;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ClientValidator;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreFormData
extends FormData {
    private int _inputTextCount = 0;
    private boolean _hasImmediateComponent = false;
    private Map<String, Integer> _validationMap = null;
    private Map<String, Integer> _errorFormatMap = null;
    private Map<String, List<ConvertValidate>> _formValidatorsInfo;
    private List<String> _clientDependencies;
    private List<String> _validatedInputList;
    private boolean _useCompoundNames = false;
    private List<String> _neededValues;
    private Set<String> _renderedSet;
    private Map<String, String> _labelMap = null;
    private Map<String, String> _resetCallsList = null;
    private String _formName = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CoreFormData.class);

    public CoreFormData(String name) {
        this._formName = name;
    }

    public int getInputTextCount() {
        return this._inputTextCount;
    }

    public void incrementInputTextCount() {
        ++this._inputTextCount;
    }

    public boolean hasImmediateComponent() {
        return this._hasImmediateComponent;
    }

    public String getName() {
        return this._formName;
    }

    public void addLabel(String targetId, String label) {
        if (targetId == null || label == null) {
            return;
        }
        Map<String, String> labelMap = this.getLabelMap(true);
        labelMap.put(targetId, label);
    }

    public Map<String, String> getLabelMap(boolean createIfNecessary) {
        if (this._labelMap == null && createIfNecessary) {
            this._labelMap = new HashMap<String, String>(31);
        }
        return this._labelMap;
    }

    public void addNeededValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if ("_compNm".equals(name)) {
            this._useCompoundNames = true;
            return;
        }
        List<String> neededValues = this.getNeededValues(true);
        neededValues.add(name);
    }

    public void addRenderedValue(String name) {
        Set<String> renderedSet = this.getRenderedValues(true);
        renderedSet.add(name);
    }

    public boolean useCompoundNames() {
        return this._useCompoundNames;
    }

    public void addResetCall(String clientId, String call) {
        if (call != null) {
            Map<String, String> resetCalls = this.getResetCalls(true);
            resetCalls.put(clientId, call);
        }
    }

    public Map<String, String> getResetCalls(boolean createIfNecessary) {
        if (this._resetCallsList == null && createIfNecessary) {
            this._resetCallsList = new HashMap<String, String>();
        }
        return this._resetCallsList;
    }

    public List<String> getClientDependencies(boolean createIfNecessary) {
        if (this._clientDependencies == null && createIfNecessary) {
            this._clientDependencies = new ArrayList<String>(10);
        }
        return this._clientDependencies;
    }

    public List<String> getNeededValues(boolean createIfNecessary) {
        if (this._neededValues == null && createIfNecessary) {
            this._neededValues = new ArrayList<String>(10);
        }
        return this._neededValues;
    }

    public Set<String> getRenderedValues(boolean createIfNecessary) {
        if (this._renderedSet == null && createIfNecessary) {
            this._renderedSet = new HashSet<String>(23);
        }
        return this._renderedSet;
    }

    public Iterator<String> getValidationIterator() {
        Map<String, Integer> validationMap = this._getValidationMap(false);
        if (validationMap == null) {
            return null;
        }
        return validationMap.keySet().iterator();
    }

    public Iterator<String> getErrorFormatIterator() {
        Map<String, Integer> errorFormatMap = this._getErrorFormatMap(false);
        if (errorFormatMap == null) {
            return null;
        }
        return errorFormatMap.keySet().iterator();
    }

    public Map<String, List<ConvertValidate>> getFormValidatorsInfo(boolean createIfNecessary) {
        if (this._formValidatorsInfo == null && createIfNecessary) {
            this._formValidatorsInfo = new HashMap<String, List<ConvertValidate>>();
        }
        return this._formValidatorsInfo;
    }

    public List<String> getValidatedInputList(boolean createIfNecessary) {
        if (this._validatedInputList == null && createIfNecessary) {
            this._validatedInputList = new ArrayList<String>();
        }
        return this._validatedInputList;
    }

    public void addOnSubmitConverterValidators(UIComponent component, Converter converter, Iterator<Validator> validators, String clientId, boolean immediate, boolean required, String requiredMessageKey) throws IOException {
        if (clientId == null) {
            _LOG.warning("NULL_NODE_NAME_CANNOT_ADD_CONVERTER_AND_VALIDATOR");
            return;
        }
        if (immediate) {
            this._hasImmediateComponent = true;
        }
        ConvertValidate convertValidateInfo = null;
        if (required) {
            Integer formatIndex;
            convertValidateInfo = this._getNewConvertValidate(clientId);
            convertValidateInfo.required = true;
            String reqMsgDetail = CoreFormData._getRequiredDetailMessage(component, requiredMessageKey);
            convertValidateInfo.requiredFormatIndex = formatIndex = this._addErrorFormat(reqMsgDetail);
            this._addValidatedInput(clientId);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        RenderingContext rc = RenderingContext.getCurrentInstance();
        if (converter != null && converter instanceof ClientConverter) {
            if (convertValidateInfo == null) {
                convertValidateInfo = this._getNewConvertValidate(clientId);
            }
            this._addOnSubmitConverter(context, rc, component, (ClientConverter)converter, convertValidateInfo, clientId);
        }
        if (validators != null) {
            while (validators.hasNext()) {
                Validator validator = validators.next();
                if (!(validator instanceof ClientValidator)) continue;
                if (convertValidateInfo == null) {
                    convertValidateInfo = this._getNewConvertValidate(clientId);
                }
                this._addOnSubmitValidator(context, rc, component, (ClientValidator)validator, convertValidateInfo, clientId);
            }
        }
    }

    private void _addFormConverterInfo(String converter, ConvertValidate convertValidate, String clientId) {
        if (converter != null && convertValidate != null) {
            if (convertValidate.converter == null) {
                convertValidate.converter = new Object[2];
            } else {
                _LOG.warning("DUPLICATE_CONVERTER_ONE_PER_COMPONENT", (Object)clientId);
            }
            convertValidate.converter = this._addValidation(converter);
        }
    }

    private void _addFormValidatorInfo(String validator, ConvertValidate convertValidate) {
        if (validator != null && convertValidate != null) {
            if (convertValidate.validators == null) {
                convertValidate.validators = new ArrayList();
            }
            convertValidate.validators.add(this._addValidation(validator));
        }
    }

    private void _addOnSubmitConverter(FacesContext context, RenderingContext rc, UIComponent component, ClientConverter submitConverter, ConvertValidate convertValidate, String clientId) throws IOException {
        if (component == null) {
            component = new UIXInput();
            component.setId(clientId);
        }
        String libURI = submitConverter.getClientLibrarySource(context);
        String clientScript = submitConverter.getClientScript(context, component);
        Collection libRefs = submitConverter.getClientImportNames();
        this._addClientScripts(context, rc, libURI, clientScript, libRefs, "TrConverter()");
        String converter = submitConverter.getClientConversion(context, component);
        if (converter != null) {
            this._addFormConverterInfo(converter, convertValidate, clientId);
            this._addValidatedInput(clientId);
        }
    }

    private void _addClientScripts(FacesContext context, RenderingContext rc, String libURI, String clientScript, Collection<String> libRefs, String defaultLibRef) throws IOException {
        if (libURI != null) {
            XhtmlUtils.writeLibImport(context, rc, libURI);
        }
        if (libRefs != null) {
            CoreFormData._writeDependencies(context, rc, libRefs);
        } else {
            CoreFormData._writeDependencies(context, rc, defaultLibRef);
        }
        if (clientScript != null) {
            List<String> clientDependencies = this.getClientDependencies(true);
            clientDependencies.add(clientScript);
        }
    }

    private void _addOnSubmitValidator(FacesContext context, RenderingContext rc, UIComponent component, ClientValidator submitValidator, ConvertValidate convertValidate, String clientId) throws IOException {
        String libURI = submitValidator.getClientLibrarySource(context);
        String clientScript = submitValidator.getClientScript(context, component);
        Collection libRefs = submitValidator.getClientImportNames();
        this._addClientScripts(context, rc, libURI, clientScript, libRefs, "TrValidator()");
        String validator = submitValidator.getClientValidation(context, component);
        if (validator != null) {
            this._addFormValidatorInfo(validator, convertValidate);
            this._addValidatedInput(clientId);
        }
    }

    private Integer _addValidation(String validation) {
        Map<String, Integer> validationMap = this._getValidationMap(true);
        Integer validationIndex = validationMap.get(validation);
        if (validationIndex == null) {
            validationIndex = validationMap.size();
            validationMap.put(validation, validationIndex);
        }
        return validationIndex;
    }

    private Integer _addErrorFormat(String errorFormat) {
        if (errorFormat != null) {
            Map<String, Integer> errorFormatMap = this._getErrorFormatMap(true);
            Integer errorFormatIndex = errorFormatMap.get(errorFormat);
            if (errorFormatIndex == null) {
                errorFormatIndex = errorFormatMap.size();
                errorFormatMap.put(errorFormat, errorFormatIndex);
            }
            return errorFormatIndex;
        }
        return null;
    }

    private ConvertValidate _getNewConvertValidate(String clientId) {
        ConvertValidate convertValidateInfo = new ConvertValidate();
        Map<String, List<ConvertValidate>> map = this.getFormValidatorsInfo(true);
        List<ConvertValidate> convertValidateList = map.get(clientId);
        if (convertValidateList == null) {
            convertValidateList = new ArrayList<ConvertValidate>();
            map.put(clientId, convertValidateList);
        }
        convertValidateList.add(convertValidateInfo);
        return convertValidateInfo;
    }

    private void _addValidatedInput(String clientId) {
        if (clientId != null) {
            this.getValidatedInputList(true).add(clientId);
        }
    }

    private Map<String, Integer> _getValidationMap(boolean createIfNecessary) {
        if (this._validationMap == null && createIfNecessary) {
            this._validationMap = new LinkedHashMap<String, Integer>(31);
        }
        return this._validationMap;
    }

    private Map<String, Integer> _getErrorFormatMap(boolean createIfNecessary) {
        if (this._errorFormatMap == null && createIfNecessary) {
            this._errorFormatMap = new LinkedHashMap<String, Integer>(31);
        }
        return this._errorFormatMap;
    }

    private static String _getRequiredDetailMessage(UIComponent component, String requiredMessageKey) {
        String requiredMessageDetail;
        if (component == null) {
            return null;
        }
        FacesContext fContext = FacesContext.getCurrentInstance();
        String detail = null;
        String label = "{0}";
        Object[] params = new Object[]{label};
        if (component instanceof UIXEditableValue && (requiredMessageDetail = ((UIXEditableValue)component).getRequiredMessageDetail()) != null) {
            FastMessageFormat format = new FastMessageFormat(requiredMessageDetail);
            detail = format.format(params);
        }
        if (detail == null) {
            if (requiredMessageKey == null) {
                requiredMessageKey = "org.apache.myfaces.trinidad.UIXEditableValue.REQUIRED";
            }
            detail = MessageFactory.getMessage((FacesContext)fContext, (String)requiredMessageKey, (Object[])params).getDetail();
        }
        return detail;
    }

    private static void _writeDependencies(FacesContext context, RenderingContext rc, String libReference) throws IOException {
        String contentType = context.getResponseWriter().getContentType();
        if ("text/html".equals(contentType) || "application/xhtml+xml".equals(contentType) || null == contentType) {
            XhtmlUtils.addLib(context, rc, libReference);
        }
    }

    private static void _writeDependencies(FacesContext context, RenderingContext rc, Collection<String> libRefs) throws IOException {
        String contentType = context.getResponseWriter().getContentType();
        if ("text/html".equals(contentType) || "application/xhtml+xml".equals(contentType) || null == contentType) {
            Object[] libRefArray = libRefs.toArray();
            for (int i = 0; i < libRefArray.length; ++i) {
                XhtmlUtils.addLib(context, rc, libRefArray[i]);
            }
        }
    }

    public static final class ConvertValidate {
        public boolean required = false;
        public Integer requiredFormatIndex;
        public ArrayList<Integer> validators;
        public Object converter;
    }
}

