/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pda;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CommandLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PdaCommandLinkRenderer
extends CommandLinkRenderer {
    public PdaCommandLinkRenderer() {
        super(CoreCommandLink.TYPE);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (PdaCommandLinkRenderer.supportsScripting(arc)) {
            this.encodeBegin(context, arc, component, bean);
            this.encodeEnd(context, arc, component, bean);
            return;
        }
        String clientId = this.getClientId(context, component);
        if (this.canSkipRendering(arc, clientId)) {
            return;
        }
        assert (arc.getCurrentClientId() == null);
        arc.setCurrentClientId(clientId);
        ResponseWriter rw = context.getResponseWriter();
        String element = "input";
        rw.startElement(element, component);
        this.renderId(context, component);
        String text = this.getText(bean);
        rw.writeAttribute("type", (Object)"submit", null);
        if (this.getDisabled(bean)) {
            rw.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
            this.renderStyleAttributes(context, arc, bean);
        } else {
            this.renderAllAttributes(context, arc, bean);
        }
        if (PdaCommandLinkRenderer.supportsAccessKeys(arc)) {
            char accessKey = this.getAccessKey(bean);
            if (accessKey != '\uffff') {
                rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
            }
        } else {
            int accessKey = 65535;
        }
        rw.writeAttribute("name", (Object)(XhtmlUtils.getEncodedParameter("source") + clientId), null);
        rw.writeAttribute("id", (Object)clientId, "id");
        rw.writeAttribute("value", (Object)text, "text");
        rw.writeAttribute("style", (Object)"border:none;background:inherit;text-decoration:underline;", null);
        rw.endElement(element);
        arc.setCurrentClientId(null);
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeURIAttribute("id", (Object)clientId, "id");
            RenderingContext arc = RenderingContext.getCurrentInstance();
            if (PdaCommandLinkRenderer.supportsScripting(arc)) {
                context.getResponseWriter().writeURIAttribute("name", (Object)clientId, "id");
            }
        }
    }
}

