/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.CapabilityMap;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesDocument;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesDocumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitiesProvider {
    private URL _capUrl;
    private volatile CapabilitiesDocument _document;
    private static CapabilityMap _EMPTY_MAP = new CapabilityMap(new Object[0][0]);
    private static HashMap<CacheKey, CapabilityMap> _sCache = new HashMap(64);
    private static Map<URL, CapabilitiesProvider> _providerMap = new HashMap<URL, CapabilitiesProvider>(4);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CapabilitiesProvider.class);

    private CapabilitiesProvider(URL capUrl) {
        this._capUrl = capUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CapabilitiesProvider getCapabilitiesProvider(URL capUrl) {
        Map<URL, CapabilitiesProvider> providerMap;
        CapabilitiesProvider provider = null;
        Map<URL, CapabilitiesProvider> map = providerMap = CapabilitiesProvider._getProviderMap();
        synchronized (map) {
            provider = providerMap.get(capUrl);
            if (provider == null) {
                provider = new CapabilitiesProvider(capUrl);
                providerMap.put(capUrl, provider);
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CapabilityMap getCapabilities(Agent agent) {
        if (agent == null) {
            return _EMPTY_MAP;
        }
        CapabilityMap caps = null;
        CacheKey key = new CacheKey(agent);
        CapabilitiesProvider capabilitiesProvider = this;
        synchronized (capabilitiesProvider) {
            try {
                caps = _sCache.get(key);
                if (caps == null) {
                    caps = this._getCapabilities(agent);
                    _sCache.put(key, caps);
                }
            }
            catch (RuntimeException re) {
                _LOG.severe("CANNOT_GET_CAPABILITIES", (Throwable)re);
            }
        }
        caps = caps.merge(agent.getCapabilities());
        return caps;
    }

    private CapabilityMap _getCapabilities(Agent agent) {
        CapabilitiesDocument doc = this._getCapabilityDocument();
        Object[][] capArray = doc.getCapabilities(agent);
        if (capArray != null) {
            return new CapabilityMap(capArray);
        }
        return _EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CapabilitiesDocument _getCapabilityDocument() {
        if (this._document != null) {
            return this._document;
        }
        CapabilitiesProvider capabilitiesProvider = this;
        synchronized (capabilitiesProvider) {
            if (this._document == null) {
                CapabilitiesDocument doc;
                this._document = doc = CapabilitiesDocumentParser.createInstance(this._capUrl);
            }
        }
        return this._document;
    }

    private static Map<URL, CapabilitiesProvider> _getProviderMap() {
        return _providerMap;
    }

    private static class CacheKey {
        private Object _agentName;
        private Object _agentVersion;
        private Object _platformName;
        private Object _platformVersion;
        private Object _hardwareMakeModel;
        private int _hashCode;
        private static final Object _EMPTY = new Object();

        CacheKey(Agent ag) {
            this._agentName = ag.getAgentName();
            if (this._agentName == null) {
                this._agentName = _EMPTY;
            }
            this._agentVersion = ag.getAgentVersion();
            if (this._agentVersion == null) {
                this._agentVersion = _EMPTY;
            }
            this._platformName = ag.getPlatformName();
            if (this._platformName == null) {
                this._platformName = _EMPTY;
            }
            this._platformVersion = ag.getPlatformVersion();
            if (this._platformVersion == null) {
                this._platformVersion = _EMPTY;
            }
            this._hardwareMakeModel = null;
            if (this._hardwareMakeModel == null) {
                this._hardwareMakeModel = _EMPTY;
            }
            this._hashCode = this._agentName.hashCode() ^ this._agentVersion.hashCode() ^ this._platformName.hashCode() ^ this._platformVersion.hashCode() ^ this._hardwareMakeModel.hashCode();
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey key = (CacheKey)obj;
            return this._agentName.equals(key._agentName) && this._agentVersion.equals(key._agentVersion) && this._platformName.equals(key._platformName) && this._platformVersion.equals(key._platformVersion) && this._hardwareMakeModel.equals(key._hardwareMakeModel);
        }
    }
}

