/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputTextHelp;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.custom.inputTextHelp.HtmlInputTextHelp;
import org.apache.myfaces.renderkit.html.ext.HtmlTextRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependency(library="oam.custom.inputTextHelp", name="inputTextHelp.js")
public class HtmlTextHelpRenderer
extends HtmlTextRenderer {
    private static final String JAVASCRIPT_ENCODED = "org.apache.myfaces.inputTextHelp.JAVASCRIPT_ENCODED";

    @Override
    protected void renderNormal(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlInputTextHelp) {
            HtmlInputTextHelp helpTextComp = (HtmlInputTextHelp)component;
            this.renderInputTextHelp(facesContext, (UIInput)helpTextComp);
        } else {
            super.renderNormal(facesContext, component);
        }
    }

    public static boolean isSelectText(UIComponent component) {
        if (component instanceof HtmlInputTextHelp) {
            HtmlInputTextHelp helpTextComp = (HtmlInputTextHelp)component;
            return helpTextComp.isSelectText();
        }
        return false;
    }

    public static String getHelpText(UIComponent component) {
        HtmlInputTextHelp helpTextComp;
        if (component instanceof HtmlInputTextHelp && (helpTextComp = (HtmlInputTextHelp)component).getHelpText() != null) {
            return helpTextComp.getHelpText();
        }
        return null;
    }

    public void renderInputTextHelp(FacesContext facesContext, UIInput input) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (input instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)input).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("id", (Object)input.getClientId(facesContext), null);
        String name = (String)input.getAttributes().get("name");
        if (name == null) {
            name = input.getClientId(facesContext);
        }
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"text", null);
        this.renderHelpTextAttributes((UIComponent)input, writer, facesContext);
        String value = RendererUtils.getStringValue(facesContext, (UIComponent)input);
        String string = value = value == null || value.length() == 0 ? HtmlTextHelpRenderer.getHelpText((UIComponent)input) : value;
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        writer.endElement("input");
    }

    private void renderHelpTextAttributes(UIComponent component, ResponseWriter writer, FacesContext facesContext) throws IOException {
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            String targetClientId = (String)component.getAttributes().get("targetClientId");
            if (targetClientId == null) {
                targetClientId = component.getClientId(facesContext);
            }
            HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, component, behaviors);
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, component, targetClientId, behaviors);
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", component, targetClientId, "blur", behaviors, "onblur");
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", component, targetClientId, "select", behaviors, "onselect");
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            if (!(component instanceof HtmlInputTextHelp) || HtmlTextHelpRenderer.getHelpText(component) == null || "".equals(HtmlTextHelpRenderer.getHelpText(component).trim())) {
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", component, targetClientId, "focus", behaviors, "onfocus");
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", component, targetClientId, "click", behaviors, "onclick");
            } else {
                String id = component.getClientId(facesContext);
                HtmlInputTextHelp textHelp = (HtmlInputTextHelp)component;
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", component, targetClientId, "focus", null, behaviors, "onfocus", null, this.buildJavascriptFunction(component, id, textHelp.getOnfocus()));
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", component, targetClientId, "click", null, behaviors, "onclick", null, this.buildJavascriptFunction(component, id, textHelp.getOnclick()));
            }
        } else if (!(component instanceof HtmlInputTextHelp) || HtmlTextHelpRenderer.getHelpText(component) == null || "".equals(HtmlTextHelpRenderer.getHelpText(component).trim())) {
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        } else {
            String id = component.getClientId(facesContext);
            HtmlInputTextHelp textHelp = (HtmlInputTextHelp)component;
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS_AND_ONCLICK);
            writer.writeAttribute("onfocus", (Object)this.buildJavascriptFunction(component, id, textHelp.getOnfocus()), null);
            writer.writeAttribute("onclick", (Object)this.buildJavascriptFunction(component, id, textHelp.getOnclick()), null);
        }
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, targetClientId, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, targetClientId, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, targetClientId, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, targetClientId, "mouseover", clientBehaviors, "onmouseover");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, targetClientId, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, targetClientId, "mouseout", clientBehaviors, "onmouseout");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, targetClientId, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, targetClientId, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, targetClientId, "keyup", clientBehaviors, "onkeyup");
    }

    private String buildJavascriptFunction(UIComponent component, String id, String componentScript) {
        StringBuffer jsFunction = new StringBuffer();
        if (HtmlTextHelpRenderer.isSelectText(component)) {
            jsFunction.append("selectText");
            jsFunction.append("('");
            jsFunction.append(HtmlTextHelpRenderer.getHelpText(component)).append("', '");
            jsFunction.append(id);
            jsFunction.append("')");
        } else {
            jsFunction.append("resetHelpValue");
            jsFunction.append("('");
            jsFunction.append(HtmlTextHelpRenderer.getHelpText(component)).append("', '");
            jsFunction.append(id);
            jsFunction.append("')");
        }
        if (componentScript != null && !"".equals(componentScript.trim())) {
            jsFunction.append(";");
            jsFunction.append(componentScript);
        }
        return jsFunction.toString();
    }

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
    }

    @Override
    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue != null && component instanceof HtmlInputTextHelp && ((HtmlInputTextHelp)component).getHelpText() != null && submittedValue.equals(((HtmlInputTextHelp)component).getHelpText())) {
            submittedValue = "";
        }
        return super.getConvertedValue(facesContext, component, submittedValue);
    }
}

