/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datalist;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.datalist.HtmlDataList;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlListRenderer
extends HtmlRenderer {
    public static final String LAYOUT_SIMPLE = "simple";
    public static final String LAYOUT_UL = "unorderedList";
    public static final String LAYOUT_OL = "orderedList";
    public static final String LAYOUT_GRID = "grid";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIData.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        String layout = this.getLayout(uiComponent);
        if (layout != null) {
            if (!layout.equals(LAYOUT_SIMPLE)) {
                HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            }
            if (layout.equals(LAYOUT_UL)) {
                writer.startElement("ul", uiComponent);
                writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else if (layout.equals(LAYOUT_OL)) {
                writer.startElement("ol", uiComponent);
                writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else if (layout.equals(LAYOUT_GRID)) {
                writer.startElement("table", uiComponent);
                writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else if (uiComponent.getId() != null && !uiComponent.getId().startsWith("_id")) {
                writer.startElement("span", uiComponent);
                writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, uiComponent, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        int last;
        RendererUtils.checkParamValidity(facesContext, component, UIData.class);
        UIData uiData = (UIData)component;
        String layout = this.getLayout(component);
        ResponseWriter writer = facesContext.getResponseWriter();
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        int rowCount = uiData.getRowCount();
        if (rows <= 0) {
            rows = rowCount - first;
        }
        if ((last = first + rows) > rowCount) {
            last = rowCount;
        }
        if (layout != null && layout.equals(LAYOUT_GRID)) {
            writer.startElement("tr", null);
        }
        for (int i = first; i < last; ++i) {
            uiData.setRowIndex(i);
            if (!uiData.isRowAvailable()) continue;
            if (layout != null) {
                if (!layout.equals(LAYOUT_SIMPLE)) {
                    HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                }
                if (layout.equals(LAYOUT_UL) || layout.equals(LAYOUT_OL)) {
                    writer.startElement("li", component);
                    HtmlRendererUtils.renderHTMLAttribute(writer, component, "itemStyleClass", "styleClass");
                    HtmlRendererUtils.renderHTMLAttribute(writer, component, "itemOnClick", "onclick");
                } else if (layout.equals(LAYOUT_GRID)) {
                    writer.startElement("td", null);
                }
            }
            RendererUtils.renderChildren(facesContext, component);
            if (layout == null) continue;
            if (layout.equals(LAYOUT_UL) || layout.equals(LAYOUT_OL)) {
                writer.endElement("li");
                continue;
            }
            if (!layout.equals(LAYOUT_GRID)) continue;
            writer.endElement("td");
        }
        if (layout != null && layout.equals(LAYOUT_GRID)) {
            writer.endElement("tr");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIData.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        String layout = this.getLayout(uiComponent);
        if (layout != null) {
            if (!layout.equals(LAYOUT_SIMPLE)) {
                HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            }
            if (layout.equals(LAYOUT_UL)) {
                writer.endElement("ul");
            } else if (layout.equals(LAYOUT_OL)) {
                writer.endElement("ol");
            } else if (layout.equals(LAYOUT_GRID)) {
                writer.endElement("table");
            } else if (uiComponent.getId() != null && !uiComponent.getId().startsWith("_id")) {
                writer.endElement("span");
            } else {
                HtmlRendererUtils.renderOptionalEndElement(writer, uiComponent, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
        }
    }

    private String getLayout(UIComponent component) {
        if (component instanceof HtmlDataList) {
            return ((HtmlDataList)component).getLayout();
        }
        return (String)component.getAttributes().get("layout");
    }
}

