/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.portlet.faces.util.map;

import java.util.Enumeration;

import javax.faces.context.FacesContext;

import javax.portlet.PortletRequest;

/**
 * Map of portlet request attributes
 */
public class PortletRequestMap extends PortletAbstractMap<Object>
{
  private final PortletRequest mPortletRequest;

  public PortletRequestMap(Object request)
  {
    if (request instanceof PortletRequest)
    {
      mPortletRequest = (PortletRequest) request;
    }
    else
    {
      throw new IllegalArgumentException(ILLEGAL_ARGUMENT);
    }
  }

  @Override
  public Object getAttribute(String key)
  {
    if (mPortletRequest != null)
    {
      // Total Hack -- The bridge has to delay computing the viewId (and 
      // hence the paths until the paths are asked for so as not to prematurely
      // read the request parameters thus avoiding exceptions from
      // EC.setRequestCharacter encoding (during MyFaces action processing).
      // However, Faces RI needs the paths set before it would calculate 
      // because it doesn't read the paths from the EC -- setting the paths
      // has the side effect of setting the RI request attribute (another hack)
      // which the RI uses instead of calculating.  
      Object attr = mPortletRequest.getAttribute(key);
      if (attr == null && key.equals("com.sun.faces.INVOCATION_PATH"))
      {
        // side effect of this will cause the viewid to be computed
        // and this attribute to be set
        FacesContext.getCurrentInstance().getExternalContext().getRequestServletPath();
        attr =  mPortletRequest.getAttribute(key);
      }
      return attr;
    }
    else
    {
      throw new IllegalArgumentException(ILLEGAL_ARGUMENT);
    }
  }

  @Override
  public void setAttribute(String key, Object value)
  {
    if (mPortletRequest != null)
    {
      mPortletRequest.setAttribute(key, value);
    }
  }

  @Override
  public void removeAttribute(String key)
  {
    if (mPortletRequest != null)
    {
      mPortletRequest.removeAttribute(key);
    }
  }

  @SuppressWarnings("unchecked")
  @Override
  public Enumeration<String> getAttributeNames()
  {
    if (mPortletRequest != null)
    {
      return mPortletRequest.getAttributeNames();
    }
    else
    {
      throw new IllegalArgumentException(ILLEGAL_ARGUMENT);
    }
  }
}
