/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Markup
implements Serializable,
Iterable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Markup NULL = new Markup((String)null);
    public static final Markup ASCENDING = Markup.valueOf("ascending");
    public static final Markup BADGE = Markup.valueOf("badge");
    public static final Markup BIG = Markup.valueOf("big");
    public static final Markup BOLD = Markup.valueOf("bold");
    public static final Markup BORDERED = Markup.valueOf("bordered");
    public static final Markup BOTTOM = Markup.valueOf("bottom");
    public static final Markup CLICKABLE = Markup.valueOf("clickable");
    public static final Markup DANGER = Markup.valueOf("danger");
    public static final Markup DARK = Markup.valueOf("dark");
    public static final Markup DEFAULT = Markup.valueOf("default");
    public static final Markup DELETED = Markup.valueOf("deleted");
    public static final Markup DESCENDING = Markup.valueOf("descending");
    public static final Markup DISABLED = Markup.valueOf("disabled");
    public static final Markup ERROR = Markup.valueOf("error");
    public static final Markup EVEN = Markup.valueOf("even");
    public static final Markup EXPANDED = Markup.valueOf("expanded");
    public static final Markup EXTRA_LARGE = Markup.valueOf("extraLarge");
    public static final Markup FATAL = Markup.valueOf("fatal");
    public static final Markup FOLDER = Markup.valueOf("folder");
    public static final Markup HIDE_TOGGLE_ICON = Markup.valueOf("hideToggleIcon");
    public static final Markup HOVER = Markup.valueOf("hover");
    public static final Markup INFO = Markup.valueOf("info");
    public static final Markup INLINE = Markup.valueOf("inline");
    public static final Markup ITALIC = Markup.valueOf("italic");
    public static final Markup JUSTIFY = Markup.valueOf("justify");
    public static final Markup LARGE = Markup.valueOf("large");
    public static final Markup LIGHT = Markup.valueOf("light");
    public static final Markup MARKED = Markup.valueOf("marked");
    public static final Markup MEDIUM = Markup.valueOf("medium");
    public static final Markup MIDDLE = Markup.valueOf("middle");
    public static final Markup MODAL = Markup.valueOf("modal");
    public static final Markup NONE = Markup.valueOf("none");
    public static final Markup NUMBER = Markup.valueOf("number");
    public static final Markup ODD = Markup.valueOf("odd");
    public static final Markup OUTLINE_DANGER = Markup.valueOf("outlineDanger");
    public static final Markup OUTLINE_DARK = Markup.valueOf("outlineDark");
    public static final Markup OUTLINE_INFO = Markup.valueOf("outlineInfo");
    public static final Markup OUTLINE_LIGHT = Markup.valueOf("outlineLight");
    public static final Markup OUTLINE_PRIMARY = Markup.valueOf("outlinePrimary");
    public static final Markup OUTLINE_SECONDARY = Markup.valueOf("outlineSecondary");
    public static final Markup OUTLINE_SUCCESS = Markup.valueOf("outlineSuccess");
    public static final Markup OUTLINE_WARNING = Markup.valueOf("outlineWarning");
    public static final Markup PILL = Markup.valueOf("pill");
    public static final Markup PRIMARY = Markup.valueOf("primary");
    public static final Markup READONLY = Markup.valueOf("readonly");
    public static final Markup REQUIRED = Markup.valueOf("required");
    public static final Markup RESIZABLE = Markup.valueOf("resizable");
    public static final Markup SECONDARY = Markup.valueOf("secondary");
    public static final Markup SECONDS = Markup.valueOf("seconds");
    public static final Markup SELECTED = Markup.valueOf("selected");
    public static final Markup SMALL = Markup.valueOf("small");
    public static final Markup SORTABLE = Markup.valueOf("sortable");
    public static final Markup SPREAD = Markup.valueOf("spread");
    public static final Markup STRIPED = Markup.valueOf("striped");
    public static final Markup STRONG = Markup.valueOf("strong");
    public static final Markup SUCCESS = Markup.valueOf("success");
    public static final Markup THIN = Markup.valueOf("thin");
    public static final Markup TOGGLER_LEFT = Markup.valueOf("togglerLeft");
    public static final Markup TOP = Markup.valueOf("top");
    public static final Markup VERTICALLY = Markup.valueOf("vertically");
    public static final Markup WARN = Markup.valueOf("warn");
    public static final Markup WARNING = Markup.valueOf("warning");
    public static final String STRING_ASCENDING = "ascending";
    public static final String STRING_BADGE = "badge";
    public static final String STRING_BIG = "big";
    public static final String STRING_BOLD = "bold";
    public static final String STRING_BORDERED = "bordered";
    public static final String STRING_BOTTOM = "bottom";
    public static final String STRING_CLICKABLE = "clickable";
    public static final String STRING_DANGER = "danger";
    public static final String STRING_DARK = "dark";
    public static final String STRING_DEFAULT = "default";
    public static final String STRING_DELETED = "deleted";
    public static final String STRING_DESCENDING = "descending";
    public static final String STRING_DISABLED = "disabled";
    public static final String STRING_ERROR = "error";
    public static final String STRING_EVEN = "even";
    public static final String STRING_EXPANDED = "expanded";
    public static final String STRING_EXTRA_LARGE = "extraLarge";
    public static final String STRING_FATAL = "fatal";
    public static final String STRING_FOLDER = "folder";
    public static final String STRING_HIDE_TOGGLE_ICON = "hideToggleIcon";
    public static final String STRING_HOVER = "hover";
    public static final String STRING_INFO = "info";
    public static final String STRING_INLINE = "inline";
    public static final String STRING_ITALIC = "italic";
    public static final String STRING_JUSTIFY = "justify";
    public static final String STRING_LARGE = "large";
    public static final String STRING_LIGHT = "light";
    public static final String STRING_MARKED = "marked";
    public static final String STRING_MEDIUM = "medium";
    public static final String STRING_MIDDLE = "middle";
    public static final String STRING_MODAL = "modal";
    public static final String STRING_NONE = "none";
    public static final String STRING_NUMBER = "number";
    public static final String STRING_ODD = "odd";
    public static final String STRING_OUTLINE_DANGER = "outlineDanger";
    public static final String STRING_OUTLINE_DARK = "outlineDark";
    public static final String STRING_OUTLINE_INFO = "outlineInfo";
    public static final String STRING_OUTLINE_LIGHT = "outlineLight";
    public static final String STRING_OUTLINE_PRIMARY = "outlinePrimary";
    public static final String STRING_OUTLINE_SECONDARY = "outlineSecondary";
    public static final String STRING_OUTLINE_SUCCESS = "outlineSuccess";
    public static final String STRING_OUTLINE_WARNING = "outlineWarning";
    public static final String STRING_PILL = "pill";
    public static final String STRING_PRIMARY = "primary";
    public static final String STRING_READONLY = "readonly";
    public static final String STRING_REQUIRED = "required";
    public static final String STRING_RESIZABLE = "resizable";
    public static final String STRING_SECONDARY = "secondary";
    public static final String STRING_SECONDS = "seconds";
    public static final String STRING_SELECTED = "selected";
    public static final String STRING_SMALL = "small";
    public static final String STRING_SORTABLE = "sortable";
    public static final String STRING_SPREAD = "spread";
    public static final String STRING_STRIPED = "striped";
    public static final String STRING_STRONG = "strong";
    public static final String STRING_SUCCESS = "success";
    public static final String STRING_THIN = "thin";
    public static final String STRING_TOGGLER_LEFT = "togglerLeft";
    public static final String STRING_TOP = "top";
    public static final String STRING_VERTICALLY = "vertically";
    public static final String STRING_WARN = "warn";
    public static final String STRING_WARNING = "warning";
    private final String[] values;
    private final String value;

    private Markup(String[] values) {
        this.values = values != null ? this.filterSpecialChars(values) : null;
        this.value = null;
    }

    private Markup(String value) {
        this.values = null;
        this.value = value != null ? this.filterSpecialChars(value) : null;
    }

    private String[] filterSpecialChars(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.filterSpecialChars(strings[i]);
        }
        return strings;
    }

    private String filterSpecialChars(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean forbiddenCharFound = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                stringBuilder.append(c);
                continue;
            }
            forbiddenCharFound = true;
        }
        if (forbiddenCharFound) {
            String newString = stringBuilder.toString();
            LOG.warn("Only numeric and alphabetic characters are allowed for markups: '{}' converted to '{}'.", (Object)string, (Object)newString);
            return newString;
        }
        return string;
    }

    public static Markup valueOf(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return Markup.valueOf(values[0]);
        }
        String[] clonedValues = (String[])values.clone();
        for (int i = 0; i < clonedValues.length; ++i) {
            clonedValues[i] = clonedValues[i].trim();
        }
        return new Markup(clonedValues);
    }

    public static Markup valueOf(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        if (value.contains(" ") || value.contains(",")) {
            String[] strings = StringUtils.split(value, ", \t\n");
            return new Markup(strings);
        }
        return new Markup(value.trim());
    }

    public static Markup valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Markup) {
            return (Markup)value;
        }
        if (value instanceof String) {
            return Markup.valueOf((String)value);
        }
        if (value instanceof String[]) {
            return Markup.valueOf((String[])value);
        }
        if (value instanceof Iterable) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object object : (Iterable)value) {
                list.add(object.toString());
            }
            return Markup.valueOf(list.toArray(new String[0]));
        }
        return Markup.valueOf(value.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Markup markup = (Markup)o;
        if (!Objects.equals(this.value, markup.value)) {
            return false;
        }
        return Arrays.equals(this.values, markup.values);
    }

    public int hashCode() {
        int result = this.values != null ? Arrays.hashCode(this.values) : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        if (this.value != null) {
            return Collections.singleton(this.value).iterator();
        }
        if (this.values != null) {
            return Arrays.asList(this.values).iterator();
        }
        return Collections.emptyIterator();
    }

    public Markup add(Markup markup) {
        if (markup == null) {
            return this;
        }
        if (markup == NULL) {
            return this;
        }
        if (markup.value != null) {
            return this.add(markup.value);
        }
        Markup result = this;
        if (markup.values != null) {
            for (String summand : markup.values) {
                Markup combined = result.add(summand);
                if (combined == null) continue;
                result = combined;
            }
        }
        return result;
    }

    private Markup add(String summand) {
        if (summand == null) {
            return this;
        }
        if (this.values == null) {
            if (this.value == null) {
                return Markup.valueOf(summand);
            }
            if (summand.equals(this.value)) {
                return this;
            }
            return Markup.valueOf(new String[]{this.value, summand});
        }
        if (ArrayUtils.contains(this.values, summand)) {
            return this;
        }
        String[] strings = new String[this.values.length + 1];
        System.arraycopy(this.values, 0, strings, 0, this.values.length);
        strings[this.values.length] = summand;
        return Markup.valueOf(strings);
    }

    public Markup remove(Markup markup) {
        if (markup.value != null) {
            return this.remove(markup.value);
        }
        Markup result = this;
        for (String summand : markup.values) {
            Markup removed = result.remove(summand);
            result = removed == null ? NULL : removed;
        }
        return result;
    }

    private Markup remove(String summand) {
        if (summand == null) {
            return this;
        }
        if (this.values == null) {
            if (this.value == null) {
                return this;
            }
            if (summand.equals(this.value)) {
                return NULL;
            }
            return this;
        }
        if (ArrayUtils.contains(this.values, summand)) {
            String[] strings = new String[this.values.length - 1];
            int found = 0;
            for (int i = 0; i < strings.length; ++i) {
                if (summand.equals(this.values[i])) {
                    ++found;
                }
                strings[i] = this.values[i + found];
            }
            return Markup.valueOf(strings);
        }
        return this;
    }

    public boolean contains(String markup) {
        if (markup == null) {
            return true;
        }
        if (this == NULL) {
            return this == Markup.valueOf(markup);
        }
        if (this.value != null) {
            return this.value.equals(markup);
        }
        for (String v : this.values) {
            if (!v.equals(markup)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Markup markup) {
        if (markup == null || markup == NULL) {
            return true;
        }
        if (this == NULL) {
            return this == markup;
        }
        if (markup.value != null) {
            if (this.value != null) {
                return this.value.equals(markup.value);
            }
            for (String v : this.values) {
                if (!v.equals(markup.value)) continue;
                return true;
            }
            return false;
        }
        if (this.value != null) {
            return false;
        }
        for (String markupString : markup.values) {
            if (this.contains(markupString)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.value == null && (this.values == null || this.values.length == 0);
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        if (this.values == null) {
            return "null";
        }
        return Arrays.toString(this.values);
    }
}

