/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.component.UIMenuBar;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.layout.LayoutContext;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.apache.myfaces.tobago.renderkit.PageRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.EncodeUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRenderer
extends PageRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PageRenderer.class);
    private static final String CLIENT_DEBUG_SEVERITY = "clientDebugSeverity";
    private static final String LAST_FOCUS_ID = "lastFocusId";

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        String lastFocusId;
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        String severity = (String)externalContext.getRequestParameterMap().get(clientId + "::" + "clientSeverity");
        if (severity != null) {
            externalContext.getRequestMap().put(CLIENT_DEBUG_SEVERITY, severity);
        }
        if ((lastFocusId = (String)externalContext.getRequestParameterMap().get(clientId + "::" + LAST_FOCUS_ID)) != null) {
            FacesContextUtils.setFocusId((FacesContext)facesContext, (String)lastFocusId);
        }
        String name = clientId + "::" + "scrollbarWeight";
        String value = null;
        try {
            value = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
            if (StringUtils.isNotBlank((String)value)) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                Measure vertical = Measure.valueOf((String)tokenizer.nextToken());
                Measure horizontal = Measure.valueOf((String)tokenizer.nextToken());
                if (vertical.greaterThan(Measure.valueOf((int)30)) || vertical.lessThan(Measure.valueOf((int)3)) || horizontal.greaterThan(Measure.valueOf((int)30)) || horizontal.lessThan(Measure.valueOf((int)3))) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring strange scrollbarWeight: vertical=" + vertical + " horizontal=" + horizontal);
                    }
                } else {
                    ClientProperties client = ClientProperties.getInstance((FacesContext)facesContext);
                    client.setVerticalScrollbarWeight(vertical);
                    client.setHorizontalScrollbarWeight(horizontal);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error in decoding '" + name + "': value='" + value + "'", (Throwable)e);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenuBar menuBar;
        boolean calculateScrollbarWeight;
        String partialAction;
        boolean portlet;
        UIPage page = (UIPage)component;
        TobagoConfig tobagoConfig = TobagoConfig.getInstance((FacesContext)facesContext);
        EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)page);
        LayoutContext layoutContext = new LayoutContext((LayoutContainer)page);
        layoutContext.layout();
        if (FacesContextUtils.getFocusId((FacesContext)facesContext) == null && !StringUtils.isBlank((String)page.getFocusId())) {
            FacesContextUtils.setFocusId((FacesContext)facesContext, (String)page.getFocusId());
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        facesContext.setResponseWriter((ResponseWriter)writer);
        ResponseUtils.ensureNoCacheHeader((FacesContext)facesContext);
        ResponseUtils.ensureContentSecurityPolicyHeader((FacesContext)facesContext, (ContentSecurityPolicy)tobagoConfig.getContentSecurityPolicy());
        if (LOG.isDebugEnabled()) {
            Iterator iterator = page.getAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                LOG.debug("*** '" + entry.getKey() + "' -> '" + entry.getValue() + "'");
            }
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Object response = externalContext.getResponse();
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String formAction = externalContext.encodeActionURL(viewHandler.getActionURL(facesContext, viewId));
        boolean bl = portlet = PortletUtils.isPortletApiAvailable() && response instanceof MimeResponse;
        if (portlet) {
            MimeResponse mimeResponse = (MimeResponse)response;
            ResourceURL resourceURL = mimeResponse.createResourceURL();
            partialAction = externalContext.encodeResourceURL(resourceURL.toString());
        } else {
            partialAction = null;
        }
        String contentType = writer.getContentTypeWithCharSet();
        ResponseUtils.ensureContentTypeHeader((FacesContext)facesContext, (String)contentType);
        if (tobagoConfig.isSetNosniffHeader()) {
            ResponseUtils.ensureNosniffHeader((FacesContext)facesContext);
        }
        String clientId = page.getClientId(facesContext);
        ClientProperties client = ClientProperties.getInstance((FacesContext)facesContext);
        ProjectStage projectStage = tobagoConfig.getProjectStage();
        boolean developmentMode = projectStage == ProjectStage.Development;
        boolean productionMode = projectStage == ProjectStage.Production;
        int clientLogSeverity = 2;
        if (developmentMode) {
            String severity = (String)externalContext.getRequestMap().get(CLIENT_DEBUG_SEVERITY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("get clientDebugSeverity = " + severity);
            }
            if (severity != null) {
                try {
                    int index = severity.indexOf(59);
                    if (index == -1) {
                        index = severity.length();
                    }
                    clientLogSeverity = Integer.parseInt(severity.substring(0, index));
                }
                catch (NumberFormatException index) {
                    // empty catch block
                }
            }
        }
        boolean preventFrameAttacks = tobagoConfig.isPreventFrameAttacks();
        if (!FacesContextUtils.isAjax((FacesContext)facesContext)) {
            Set styleBlocks;
            String icon;
            String title = (String)page.getAttributes().get("label");
            writer.startElement("head", null);
            writer.startElement("meta", null);
            writer.writeAttribute("http-equiv", "Content-Type", false);
            writer.writeAttribute("content", contentType, false);
            writer.endElement("meta");
            writer.startElement("title", null);
            writer.writeText(title != null ? title : "");
            writer.endElement("title");
            Theme theme = client.getTheme();
            for (String styleFile : theme.getStyleResources(productionMode)) {
                this.writeStyle(facesContext, writer, styleFile);
            }
            for (String styleFile : FacesContextUtils.getStyleFiles((FacesContext)facesContext)) {
                this.writeStyle(facesContext, writer, styleFile);
            }
            if (!productionMode) {
                this.checkDuplicates(theme.getStyleResources(productionMode), FacesContextUtils.getStyleFiles((FacesContext)facesContext));
            }
            if ((icon = page.getApplicationIcon()) != null) {
                String href = ResourceManagerUtils.isAbsoluteResource((String)icon) ? icon : ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)icon);
                if (href != null) {
                    writer.startElement("link", null);
                    if (href.endsWith(".ico")) {
                        writer.writeAttribute("rel", "shortcut icon", false);
                        writer.writeAttribute("href", href, true);
                    } else {
                        writer.writeAttribute("rel", "icon", false);
                        writer.writeAttribute("type", MimeTypeUtils.getMimeTypeForFile((String)href), true);
                        writer.writeAttribute("href", href, true);
                    }
                    writer.endElement("link");
                } else {
                    LOG.warn("Application icon '" + icon + "' not found!");
                }
            }
            if ((styleBlocks = FacesContextUtils.getStyleBlocks((FacesContext)facesContext)).size() > 0) {
                writer.startElement("style", null);
                writer.flush();
                for (String cssBlock : styleBlocks) {
                    writer.write(cssBlock);
                }
                writer.endElement("style");
            }
            for (String scriptFile : theme.getScriptResources(productionMode)) {
                this.encodeScript(facesContext, writer, scriptFile);
            }
            for (String scriptFile : FacesContextUtils.getScriptFiles((FacesContext)facesContext)) {
                this.encodeScript(facesContext, writer, scriptFile);
            }
            if (!productionMode) {
                this.checkDuplicates(theme.getScriptResources(productionMode), FacesContextUtils.getScriptFiles((FacesContext)facesContext));
            }
            writer.startJavascript();
            this.writeEventFunction(writer, FacesContextUtils.getOnloadScripts((FacesContext)facesContext), "load", false);
            this.writeEventFunction(writer, FacesContextUtils.getOnunloadScripts((FacesContext)facesContext), "unload", false);
            this.writeEventFunction(writer, FacesContextUtils.getOnexitScripts((FacesContext)facesContext), "exit", false);
            this.writeEventFunction(writer, FacesContextUtils.getOnsubmitScripts((FacesContext)facesContext), "submit", true);
            int debugCounter = 0;
            for (String scriptBlock : FacesContextUtils.getScriptBlocks((FacesContext)facesContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("write scriptblock " + ++debugCounter + " :\n" + scriptBlock);
                }
                writer.write(scriptBlock);
                writer.write(10);
            }
            writer.endJavascript();
            writer.endElement("head");
        }
        if (portlet) {
            writer.startElement("div", (UIComponent)page);
            writer.writeClassAttribute(Classes.create((UIComponent)page, (Markup)Markup.PORTLET));
        } else {
            writer.startElement("body", (UIComponent)page);
            writer.writeClassAttribute(Classes.create((UIComponent)page));
        }
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)page);
        HtmlRendererUtils.renderCommandFacet((UIComponent)page, facesContext, writer);
        writer.startElement("form", (UIComponent)page);
        if (preventFrameAttacks && !FacesContextUtils.isAjax((FacesContext)facesContext)) {
            writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"preventFrameAttacks", (Markup)Markup.NULL));
        }
        if (!FacesContextUtils.isAjax((FacesContext)facesContext)) {
            writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"initializing", (Markup)Markup.NULL));
        }
        writer.writeAttribute("action", formAction, true);
        if (partialAction != null) {
            writer.writeAttribute("data-tobago-partial-action", partialAction, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("partial action = " + partialAction);
        }
        writer.writeIdAttribute(page.getFormId(facesContext));
        writer.writeAttribute("method", this.getMethod(page), false);
        String enctype = FacesContextUtils.getEnctype((FacesContext)facesContext);
        if (enctype != null) {
            writer.writeAttribute("enctype", enctype, false);
        }
        writer.writeAttribute("accept-charset", "utf-8", false);
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "form-action");
        writer.writeIdAttribute(clientId + "::" + "form-action");
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "context-path");
        writer.writeIdAttribute(clientId + "::" + "context-path");
        writer.writeAttribute("value", externalContext.getRequestContextPath(), true);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "action-position");
        writer.writeIdAttribute(clientId + "::" + "action-position");
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "form-clientDimension");
        writer.writeIdAttribute(clientId + "::" + "form-clientDimension");
        writer.endElement("input");
        boolean bl2 = calculateScrollbarWeight = client.getVerticalScrollbarWeight() == null || client.getHorizontalScrollbarWeight() == null;
        if (calculateScrollbarWeight) {
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"scrollbarWeight", (Markup)Markup.NULL));
            writer.startElement("div", null);
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "scrollbarWeight");
        writer.writeIdAttribute(clientId + "::" + "scrollbarWeight");
        if (client.getVerticalScrollbarWeight() != null && client.getHorizontalScrollbarWeight() != null) {
            writer.writeAttribute("value", client.getVerticalScrollbarWeight().getPixel() + ";" + client.getHorizontalScrollbarWeight().getPixel(), false);
        }
        writer.endElement("input");
        if (TobagoConfig.getInstance((FacesContext)FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            Secret.encode((FacesContext)facesContext, (TobagoResponseWriter)writer);
        }
        if (developmentMode) {
            writer.startElement("input", null);
            writer.writeAttribute("value", clientLogSeverity);
            writer.writeAttribute("id", clientId + "::" + "clientSeverity", false);
            writer.writeAttribute("name", clientId + "::" + "clientSeverity", false);
            writer.writeAttribute("type", "hidden", false);
            writer.endElement("input");
        }
        if (component.getFacet("backButtonDetector") != null) {
            UIComponent hidden = component.getFacet("backButtonDetector");
            RenderUtils.encode(facesContext, hidden);
        }
        if ((menuBar = (UIMenuBar)ComponentUtils.findFacetDescendant((UIComponent)page, (String)"menuBar", UIMenuBar.class)) != null) {
            menuBar.getAttributes().put("pageMenu", Boolean.TRUE);
            RenderUtils.encode(facesContext, (UIComponent)menuBar);
        }
        writer.startElement("div", (UIComponent)page);
        if (portlet) {
            writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"content", (Markup)Markup.PORTLET));
        } else {
            writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"content"));
        }
        writer.writeIdAttribute(clientId + "::" + "content");
        Style style = new Style(facesContext, (LayoutBase)page);
        Measure border = this.getBorderBottom(facesContext, (Configurable)page);
        style.setHeight(page.getCurrentHeight().subtract(border));
        style.setTop(border);
        writer.writeStyleAttribute(style);
    }

    private void checkDuplicates(String[] resources, Collection<String> files) {
        for (String resource : resources) {
            if (!files.contains(resource)) continue;
            throw new RuntimeException("The resource '" + resource + "' will be included twice! The resource is in the theme list, and explicit in the page. Please remove it from the page!");
        }
    }

    private void writeStyle(FacesContext facesContext, TobagoResponseWriter writer, String styleFile) throws IOException {
        List styles = ResourceManagerUtils.getStyles((FacesContext)facesContext, (String)styleFile);
        for (String styleString : styles) {
            if (styleString.length() <= 0) continue;
            writer.startElement("link", null);
            writer.writeAttribute("rel", "stylesheet", false);
            writer.writeAttribute("href", styleString, true);
            writer.writeAttribute("type", "text/css", false);
            writer.endElement("link");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        List messageClientIds;
        boolean developmentMode;
        UIPopup[] popupArray;
        UIPage page = (UIPage)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.endElement("div");
        for (UIPopup popup : popupArray = FacesContextUtils.getPopups((FacesContext)facesContext).toArray(new UIPopup[FacesContextUtils.getPopups((FacesContext)facesContext).size()])) {
            RenderUtils.encode(facesContext, (UIComponent)popup);
        }
        String clientId = page.getClientId(facesContext);
        ClientProperties clientProperties = ClientProperties.getInstance((FacesContext)facesContext);
        ProjectStage projectStage = TobagoConfig.getInstance((FacesContext)facesContext).getProjectStage();
        boolean bl = developmentMode = projectStage == ProjectStage.Development;
        if (clientProperties.getUserAgent().isMsie()) {
            writer.startElement("input", null);
            writer.writeAttribute("type", "text", false);
            writer.writeAttribute("name", "tobago.dummy", false);
            writer.writeAttribute("tabindex", -1);
            writer.writeAttribute("style", "visibility:hidden;display:none;", false);
            writer.endElement("input");
        }
        if ((messageClientIds = AjaxInternalUtils.getMessagesClientIds((FacesContext)facesContext)) != null) {
            writer.startElement("input", null);
            writer.writeAttribute("value", StringUtils.join((List)messageClientIds, (char)','), true);
            writer.writeAttribute("id", clientId + "::" + "messagesClientIds", false);
            writer.writeAttribute("name", clientId + "::" + "messagesClientIds", false);
            writer.writeAttribute("type", "hidden", false);
            writer.endElement("input");
        }
        writer.startElement("div", (UIComponent)page);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"menuStore"));
        writer.endElement("div");
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        writer.startElement("span", null);
        writer.writeIdAttribute(clientId + "::" + "jsf-state-container");
        writer.flush();
        if (!FacesContextUtils.isAjax((FacesContext)facesContext)) {
            viewHandler.writeState(facesContext);
        }
        writer.endElement("span");
        writer.endElement("form");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"overlayWaitPreloadedImage"));
        String wait = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/tobago-overlay-wait");
        writer.writeAttribute("src", wait, true);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"overlayErrorPreloadedImage"));
        String error = clientProperties.getUserAgent().isMsie6() ? ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/remove") : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/dialog-error");
        writer.writeAttribute("src", error, true);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"pngFixBlankImage"));
        String pngFixBlankImage = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/blank");
        writer.writeAttribute("src", pngFixBlankImage, true);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"overlayBackgroundImage"));
        String overlayBackgroundImage = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/tobago-overlay-background");
        writer.writeAttribute("src", overlayBackgroundImage, true);
        writer.endElement("img");
        if (developmentMode) {
            ArrayList<String> logMessages = new ArrayList<String>();
            String id = null;
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                for (FacesMessage message : facesContext.getMessageList(id)) {
                    logMessages.add(this.errorMessageForDebugging(id, message));
                }
                id = (String)ids.next();
            }
            if (!logMessages.isEmpty()) {
                logMessages.add(0, "LOG.show();");
            }
            HtmlRendererUtils.writeScriptLoader(facesContext, null, logMessages.toArray(new String[logMessages.size()]));
        }
        writer.startElement("noscript", null);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"noscript"));
        writer.writeText(ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"pageNoscript"));
        writer.endElement("div");
        writer.endElement("noscript");
        Object response = facesContext.getExternalContext().getResponse();
        if (PortletUtils.isPortletApiAvailable() && response instanceof MimeResponse) {
            writer.endElement("div");
        } else {
            writer.endElement("body");
        }
        AccessKeyLogger.logStatus((FacesContext)facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().get("X") != null) {
            throw new RuntimeException("Debugging activated via X parameter");
        }
    }

    private void writeEventFunction(TobagoResponseWriter writer, Collection<String> eventFunctions, String event, boolean returnBoolean) throws IOException {
        if (!eventFunctions.isEmpty()) {
            writer.write("Tobago.applicationOn");
            writer.write(event);
            writer.write(" = function(listenerOptions) {\n");
            if (returnBoolean) {
                writer.write("  var result;\n");
            }
            for (String function : eventFunctions) {
                if (returnBoolean) {
                    writer.write("  result = ");
                } else {
                    writer.write("  ");
                }
                writer.write(function);
                if (!function.trim().endsWith(";")) {
                    writer.write(";\n");
                } else {
                    writer.write("\n");
                }
                if (!returnBoolean) continue;
                writer.write("  if (typeof result == \"boolean\" && ! result) {\n");
                writer.write("    return false;\n");
                writer.write("  }\n");
            }
            writer.write("\n  return true;\n}\n");
        }
    }

    private void encodeScript(FacesContext facesContext, TobagoResponseWriter writer, String script) throws IOException {
        List<String> list;
        if (ResourceManagerUtils.isAbsoluteResource((String)script)) {
            list = new ArrayList();
            list.add(script);
        } else {
            list = ResourceManagerUtils.getScripts((FacesContext)facesContext, (String)script);
        }
        for (String src : list) {
            if (!StringUtils.isNotBlank((String)src)) continue;
            writer.startElement("script", null);
            writer.writeAttribute("src", src, true);
            writer.writeAttribute("type", "text/javascript", false);
            writer.endElement("script");
        }
    }

    private void errorMessageForDebugging(String id, FacesMessage message, ResponseWriter writer) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("style", (Object)"color: red", null);
        writer.flush();
        writer.write("[");
        writer.write(id != null ? id : "null");
        writer.write("]");
        writer.write("[");
        writer.write(message.getSummary() == null ? "null" : message.getSummary());
        writer.write("/");
        writer.write(message.getDetail() == null ? "null" : message.getDetail());
        writer.write("]");
        writer.endElement("div");
        writer.startElement("br", null);
        writer.endElement("br");
    }

    private String errorMessageForDebugging(String id, FacesMessage message) {
        StringBuilder sb = new StringBuilder("LOG.info(\"FacesMessage: [");
        sb.append(id != null ? id : "null");
        sb.append("][");
        sb.append(message.getSummary() == null ? "null" : this.escape(message.getSummary()));
        sb.append("/");
        sb.append(message.getDetail() == null ? "null" : this.escape(message.getDetail()));
        sb.append("]\");");
        return sb.toString();
    }

    private String escape(String s) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)"\\", (String)"\\\\"), (String)"\"", (String)"\\\"");
    }

    private String getMethod(UIPage page) {
        String method = (String)page.getAttributes().get("method");
        return method == null ? "post" : method;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public Measure getBorderBottom(FacesContext facesContext, Configurable component) {
        UIPage page = (UIPage)component;
        UIMenuBar menuBar = (UIMenuBar)ComponentUtils.findFacetDescendant((UIComponent)page, (String)"menuBar", UIMenuBar.class);
        if (menuBar != null) {
            return this.getResourceManager().getThemeMeasure(facesContext, (Configurable)page, "custom.menuBar-height");
        }
        return Measure.ZERO;
    }

    public Measure getWidth(FacesContext facesContext, Configurable component) {
        int fromState;
        UIPage page = (UIPage)component;
        PageState pageState = page.getPageState(facesContext);
        int n = fromState = pageState != null ? pageState.getClientWidth() : 0;
        if (fromState > 0) {
            return Measure.valueOf((int)fromState);
        }
        Measure width = ClientProperties.getInstance((FacesContext)facesContext).getPageWidth();
        if (width != null) {
            return width;
        }
        return super.getWidth(facesContext, component);
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        int fromState;
        UIPage page = (UIPage)component;
        PageState pageState = page.getPageState(facesContext);
        int n = fromState = pageState != null ? pageState.getClientHeight() : 0;
        if (fromState > 0) {
            return Measure.valueOf((int)fromState);
        }
        Measure height = ClientProperties.getInstance((FacesContext)facesContext).getPageHeight();
        if (height != null) {
            return height;
        }
        return super.getHeight(facesContext, component);
    }
}

