/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public class MockVariableValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 4475919948345298291L;
    private Class expectedType = null;
    private Object instance = null;

    public MockVariableValueExpression(Object instance, Class expectedType) {
        if (instance == null) {
            throw new NullPointerException("Instance cannot be null");
        }
        this.instance = instance;
        this.expectedType = expectedType;
    }

    public boolean equals(Object obj) {
        if (obj != null & obj instanceof ValueExpression) {
            return this.instance.toString().equals(((ValueExpression)obj).getExpressionString());
        }
        return false;
    }

    public String getExpressionString() {
        return this.instance.toString();
    }

    public int hashCode() {
        return this.instance.toString().hashCode();
    }

    public boolean isLiteralText() {
        return true;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public Class getType(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return this.instance.getClass();
    }

    public Object getValue(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        FacesContext fcontext = (FacesContext)context.getContext(FacesContext.class);
        return fcontext.getApplication().getExpressionFactory().coerceToType(this.instance, this.expectedType);
    }

    public boolean isReadOnly(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return true;
    }

    public void setValue(ELContext context, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        throw new PropertyNotWritableException();
    }
}

