/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.connectionManager;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.connectionManager.ConnectionManagerDataSource;
import org.apache.myfaces.orchestra.connectionManager.DisconnectableConnection;

public class DisconnectableConnectionFactory {
    private DisconnectableConnectionFactory() {
    }

    public static DisconnectableConnection create(final ConnectionManagerDataSource connectionManager) {
        return (DisconnectableConnection)Proxy.newProxyInstance(DisconnectableConnection.class.getClassLoader(), new Class[]{DisconnectableConnection.class}, new InvocationHandler(){
            private Map connectionConfiguration = new HashMap();
            private Connection connection;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("equals".equals(method.getName()) || "hashCode".equals(method.getName())) {
                    return method.invoke((Object)this, args);
                }
                if ("close".equals(method.getName())) {
                    try {
                        if (this.connection != null) {
                            this.connection.close();
                        }
                        this.connection = null;
                    }
                    finally {
                        connectionManager.onAfterReleaseConnection((Connection)proxy);
                    }
                    return null;
                }
                if ("disconnect".equals(method.getName())) {
                    block18: {
                        try {
                            if (this.connection == null) break block18;
                            try {
                                if (!this.connection.isClosed()) {
                                    this.connection.close();
                                }
                            }
                            catch (SQLException e) {
                                LogFactory.getLog(DisconnectableConnectionFactory.class).warn((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        finally {
                            connectionManager.onAfterReleaseConnection((Connection)proxy);
                            this.connection = null;
                        }
                    }
                    return null;
                }
                if ("getConnection".equals(method.getName())) {
                    return this.connection;
                }
                if (this.connection == null) {
                    this.connection = connectionManager.getDataSource().getConnection();
                    for (Map.Entry config : this.connectionConfiguration.entrySet()) {
                        ((Method)config.getKey()).invoke((Object)this.connection, (Object[])config.getValue());
                    }
                    connectionManager.onAfterBorrowConnection((Connection)proxy);
                }
                Object ret = method.invoke((Object)this.connection, args);
                if (method.getName().startsWith("set")) {
                    this.connectionConfiguration.put(method, args);
                }
                return ret;
            }
        });
    }
}

