/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.jsf;

import java.util.Iterator;

import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;

import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.conversation.jsf.components.AbstractConversationComponent;
import org.apache.myfaces.orchestra.conversation.jsf.components.UIEndConversation;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;

/**
 * <p>Various utilities used by the conversation framework</p>
 * <p>Notice: this class is not meant to be used outside of this library</p>
 */
public class _JsfConversationUtils
{
    private _JsfConversationUtils()
    {
    }

    /**
     * Find the first parent which is a command
     */
    public static UICommand findParentCommand(UIComponent base)
    {
        UIComponent parent = base;
        do
        {
            parent = parent.getParent();
            if (parent instanceof UICommand)
            {
                return (UICommand) parent;
            }
        }
        while (parent != null);

        return null;
    }

    /**
     * Find a child start or end conversation component for the given conversation name
     */
    public static AbstractConversationComponent findEndConversationComponent(
            UIComponent component, String conversationName)
    {
        Iterator iterComponents = component.getFacetsAndChildren();
        while (iterComponents.hasNext())
        {
            Object child = iterComponents.next();
            AbstractConversationComponent conversation;

            if (child instanceof UIEndConversation)
            {
                conversation = (AbstractConversationComponent) child;
                if (conversation.getName().equals(conversationName))
                {
                    return conversation;
                }
            }
            else if (child instanceof UIComponent)
            {
                conversation = findEndConversationComponent((UIComponent) child, conversationName);
                if (conversation != null)
                {
                    return conversation;
                }
            }
        }

        return null;
    }

    /**
     * end and restart a conversation
     */
    public static void endAndRestartConversation(FacesContext context,
            String conversationName, Boolean restart, MethodBinding restartAction)
    {
        ConversationManager conversationManager = ConversationManager.getInstance();
        Conversation conversation = conversationManager.getConversation(conversationName);
        if (conversation != null)
        {
            conversation.invalidate();
        }

        if (restart != null && restart.booleanValue())
        {
            FrameworkAdapter.getCurrentInstance().getBean(conversationName);

            if (restartAction != null)
            {
                restartAction.invoke(context, null);
            }
        }
    }
}
