/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.message.resolver;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.factory.AbstractNameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.factory.ClassMappingFactory;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationEntry;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationNames;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.DefaultValidationErrorMessageResolver;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.MessageResolver;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ToDo(value=Priority.MEDIUM, description="add generic java api (de-/register mapping)")
@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.CUSTOMIZABLE})
public class DefaultMessageResolverFactory
extends AbstractNameMapperAwareFactory<ValidationStrategy>
implements ClassMappingFactory<ValidationStrategy, MessageResolver> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, String> strategyMessageResolverMapping;
    private List<NameMapper<ValidationStrategy>> nameMapperList = new CopyOnWriteArrayList<NameMapper<ValidationStrategy>>();

    public DefaultMessageResolverFactory() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    @Override
    public MessageResolver create(ValidationStrategy validationStrategy) {
        String strategyName = ProxyUtils.getClassName(validationStrategy.getClass());
        if (this.strategyMessageResolverMapping == null) {
            this.initStaticMappings();
        }
        if (this.strategyMessageResolverMapping.containsKey(strategyName)) {
            return (MessageResolver)ClassUtils.tryToInstantiateClassForName(this.strategyMessageResolverMapping.get(strategyName));
        }
        for (NameMapper<ValidationStrategy> nameMapper : this.nameMapperList) {
            MessageResolver messageResolver;
            String resolverName = nameMapper.createName(validationStrategy);
            if (resolverName == null || ProxyUtils.getClassName(validationStrategy.getClass()).equals(resolverName) || (messageResolver = (MessageResolver)ClassUtils.tryToInstantiateClassForName(resolverName)) == null) continue;
            this.addMapping(strategyName, resolverName);
            this.logger.finest(resolverName + " used for " + strategyName);
            return messageResolver;
        }
        this.addMapping(strategyName, DefaultValidationErrorMessageResolver.class.getName());
        return new DefaultValidationErrorMessageResolver();
    }

    private synchronized void initStaticMappings() {
        this.strategyMessageResolverMapping = new NullValueAwareConcurrentHashMap<String, String>(String.class);
        for (StaticConfiguration<String, String> staticConfig : ExtValContext.getContext().getStaticConfiguration(StaticConfigurationNames.VALIDATION_STRATEGY_TO_MESSAGE_RESOLVER_CONFIG)) {
            this.setupMappings(staticConfig.getMapping());
        }
    }

    private void setupMappings(List<StaticConfigurationEntry<String, String>> mappings) {
        for (StaticConfigurationEntry<String, String> mapping : mappings) {
            this.addMapping(mapping.getSource(), mapping.getTarget());
        }
    }

    @ToDo(value=Priority.MEDIUM, description="logging")
    private synchronized void addMapping(String validationStrategyName, String messageResolverName) {
        this.logger.finest("adding static validation strategy to message resolver mapping: " + validationStrategyName + " -> " + messageResolverName);
        this.strategyMessageResolverMapping.put(validationStrategyName, messageResolverName);
    }

    @Override
    protected List<NameMapper<ValidationStrategy>> getNameMapperList() {
        return this.nameMapperList;
    }
}

