/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.storage.FacesMessageStorage;
import org.apache.myfaces.extensions.validator.core.storage.ValidationResult;
import org.apache.myfaces.extensions.validator.core.validation.message.FacesMessageHolder;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ToDo(value=Priority.LOW, description="optional parameter to deactivate sorting")
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultFacesMessageStorage
implements FacesMessageStorage {
    Map<String, ValidationResult> results = new HashMap<String, ValidationResult>();

    @Override
    public void addFacesMessage(String clientId, FacesMessage facesMessage) {
        if (clientId == null) {
            clientId = "*";
        }
        if (!this.results.containsKey(clientId)) {
            this.results.put(clientId, new ValidationResult());
        }
        this.results.get(clientId).addFacesMessageHolder(new FacesMessageHolder(facesMessage, clientId));
    }

    @Override
    public List<FacesMessageHolder> getFacesMessages() {
        ArrayList<FacesMessageHolder> result = new ArrayList<FacesMessageHolder>();
        for (ValidationResult validationResult : this.results.values()) {
            result.addAll(validationResult.getFacesMessageHolderList());
        }
        return result;
    }

    @Override
    public void addAll() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        for (ValidationResult validationResult : this.results.values()) {
            List<FacesMessageHolder> facesMessageHolderList = validationResult.getFacesMessageHolderList();
            this.sortFacesMessageHolderList(facesMessageHolderList);
            for (FacesMessageHolder facesMessageHolder : facesMessageHolderList) {
                facesContext.addMessage(facesMessageHolder.getClientId(), facesMessageHolder.getFacesMessage());
            }
        }
    }

    private void sortFacesMessageHolderList(List<FacesMessageHolder> facesMessageHolderList) {
        Collections.sort(facesMessageHolderList, this.getFacesMessageComparator());
    }

    protected Comparator<FacesMessageHolder> getFacesMessageComparator() {
        return new Comparator<FacesMessageHolder>(){

            @Override
            public int compare(FacesMessageHolder holder1, FacesMessageHolder holder2) {
                if (holder1.getFacesMessage().getSeverity() == null) {
                    return 1;
                }
                if (DefaultFacesMessageStorage.this.isSameSeverity(holder1, holder2)) {
                    return this.compareMessageText(holder1.getFacesMessage(), holder2.getFacesMessage());
                }
                if (holder1.getFacesMessage().getSeverity().getOrdinal() > holder2.getFacesMessage().getSeverity().getOrdinal()) {
                    return -1;
                }
                return 1;
            }

            private int compareMessageText(FacesMessage facesMessage1, FacesMessage facesMessage2) {
                String text1 = facesMessage1.getDetail();
                String text2 = facesMessage2.getDetail();
                if (text1 == null) {
                    text1 = facesMessage1.getSummary();
                }
                if (text2 == null) {
                    text2 = facesMessage2.getSummary();
                }
                if (text1 == null) {
                    return 1;
                }
                if (text2 == null) {
                    return -1;
                }
                return text1.compareToIgnoreCase(text2);
            }
        };
    }

    private boolean isSameSeverity(FacesMessageHolder holder1, FacesMessageHolder holder2) {
        return holder1.getFacesMessage().getSeverity().equals(holder2.getFacesMessage().getSeverity());
    }
}

