/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.factory.AbstractNameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.factory.ClassMappingFactory;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationEntry;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationNames;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.storage.DefaultFacesInformationStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultFacesMessageStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultGroupStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultMappedConstraintSourceStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultMetaDataStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultPropertyStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultRendererInterceptorPropertyStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultRendererProxyStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.DefaultViolationSeverityInterpreterStorageManager;
import org.apache.myfaces.extensions.validator.core.storage.FacesInformationStorage;
import org.apache.myfaces.extensions.validator.core.storage.FacesMessageStorage;
import org.apache.myfaces.extensions.validator.core.storage.GroupStorage;
import org.apache.myfaces.extensions.validator.core.storage.MappedConstraintSourceStorage;
import org.apache.myfaces.extensions.validator.core.storage.MetaDataStorage;
import org.apache.myfaces.extensions.validator.core.storage.PropertyStorage;
import org.apache.myfaces.extensions.validator.core.storage.RendererInterceptorPropertyStorage;
import org.apache.myfaces.extensions.validator.core.storage.RendererProxyStorage;
import org.apache.myfaces.extensions.validator.core.storage.StorageManager;
import org.apache.myfaces.extensions.validator.core.storage.StorageManagerHolder;
import org.apache.myfaces.extensions.validator.core.storage.ViolationSeverityInterpreterStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultStorageManagerFactory
extends AbstractNameMapperAwareFactory<Class>
implements ClassMappingFactory<Class, StorageManager>,
StorageManagerHolder {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean lazyStaticMappingApplied = false;
    private List<NameMapper<Class>> nameMapperList = new CopyOnWriteArrayList<NameMapper<Class>>();
    private Map<Class, StorageManager> storageTypeToStorageManagerMap = new ConcurrentHashMap<Class, StorageManager>();

    public DefaultStorageManagerFactory() {
        this.logger.fine(this.getClass().getName() + " instantiated");
        this.setStorageManager(RendererProxyStorage.class, new DefaultRendererProxyStorageManager(), false);
        this.setStorageManager(GroupStorage.class, new DefaultGroupStorageManager(), false);
        this.setStorageManager(MetaDataStorage.class, new DefaultMetaDataStorageManager(), false);
        this.setStorageManager(FacesMessageStorage.class, new DefaultFacesMessageStorageManager(), false);
        this.setStorageManager(PropertyStorage.class, new DefaultPropertyStorageManager(), false);
        this.setStorageManager(RendererInterceptorPropertyStorage.class, new DefaultRendererInterceptorPropertyStorageManager(), false);
        this.setStorageManager(ViolationSeverityInterpreterStorage.class, new DefaultViolationSeverityInterpreterStorageManager(), false);
        this.setStorageManager(MappedConstraintSourceStorage.class, new DefaultMappedConstraintSourceStorageManager(), false);
        this.setStorageManager(FacesInformationStorage.class, new DefaultFacesInformationStorageManager(), false);
    }

    @Override
    public StorageManager create(Class storageType) {
        if (!this.lazyStaticMappingApplied) {
            this.initStaticMappings();
        }
        for (NameMapper<Class> nameMapper : this.nameMapperList) {
            StorageManager storageManager;
            String storageManagerName = nameMapper.createName(storageType);
            if (storageManagerName == null || (storageManager = (StorageManager)ClassUtils.tryToInstantiateClassForName(storageManagerName)) == null) continue;
            this.addMapping(storageType, storageManager);
            return storageManager;
        }
        return this.getStorageManager(storageType);
    }

    private synchronized void addMapping(Class storageType, StorageManager storageManager) {
        boolean isValidEntry = true;
        if (storageType == null) {
            isValidEntry = false;
            this.logger.severe("you tried to add an invalid storage type");
        }
        if (storageManager == null) {
            isValidEntry = false;
            this.logger.severe("you tried to add an invalid storage manager");
        }
        if (!isValidEntry) {
            return;
        }
        this.setStorageManager(storageType, storageManager, true);
    }

    private void initStaticMappings() {
        this.lazyStaticMappingApplied = true;
        for (StaticConfiguration<String, String> staticConfig : ExtValContext.getContext().getStaticConfiguration(StaticConfigurationNames.STORAGE_TYPE_TO_STORAGE_MANAGER_CONFIG)) {
            this.setupMappings(staticConfig.getMapping());
        }
    }

    private void setupMappings(List<StaticConfigurationEntry<String, String>> mappings) {
        for (StaticConfigurationEntry<String, String> mapping : mappings) {
            this.addMapping(ClassUtils.tryToLoadClassForName(mapping.getSource()), (StorageManager)ClassUtils.tryToInstantiateClassForName(mapping.getTarget()));
        }
    }

    @Override
    protected List<NameMapper<Class>> getNameMapperList() {
        return this.nameMapperList;
    }

    @Override
    public void setStorageManager(Class storageType, StorageManager storageManager, boolean override) {
        if (!this.storageTypeToStorageManagerMap.containsKey(storageType) || this.storageTypeToStorageManagerMap.containsKey(storageType) && override) {
            this.logger.finest("adding type to storage-manager mapping: " + storageType.getName() + " -> " + storageManager.getClass().getName());
            this.storageTypeToStorageManagerMap.put(storageType, storageManager);
        }
    }

    @Override
    public StorageManager getStorageManager(Class type) {
        return this.storageTypeToStorageManagerMap.get(type);
    }
}

