/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.CrossValidationHelper;
import org.apache.myfaces.extensions.validator.crossval.strategy.ReferencingStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.CrossValidationUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
class LocalCompareStrategy
implements ReferencingStrategy {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    LocalCompareStrategy() {
    }

    public boolean evaluateReferenceAndValidate(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage, String validationTarget, AbstractCompareStrategy compareStrategy) {
        if (validationTarget.contains(".")) {
            return false;
        }
        return this.tryToValidateLocally(crossValidationStorageEntry, crossValidationStorage, validationTarget, compareStrategy);
    }

    protected boolean tryToValidateLocally(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage, String targetKey, AbstractCompareStrategy compareStrategy) {
        ProcessedInformationStorage processedInformationStorage = CrossValidationUtils.getOrInitProcessedInformationStorage();
        boolean isModelAwareValidation = this.isModelAwareCrossValidation(crossValidationStorageEntry, processedInformationStorage, targetKey);
        String targetProperty = targetKey;
        String sourceKey = this.resolveSourceKey(crossValidationStorageEntry);
        targetKey = sourceKey.substring(0, sourceKey.lastIndexOf(".") + 1) + targetKey;
        ProcessedInformationStorageEntry validationTargetEntry = CrossValidationUtils.resolveValidationTargetEntry(processedInformationStorage, targetKey, crossValidationStorageEntry);
        if (validationTargetEntry != null && validationTargetEntry.getComponent() != null && !isModelAwareValidation) {
            this.processCrossComponentValidation(compareStrategy, crossValidationStorageEntry, validationTargetEntry);
        } else if (isModelAwareValidation) {
            this.processModelAwareCrossValidation(compareStrategy, crossValidationStorageEntry, targetProperty);
        } else {
            this.unsupportedCase(crossValidationStorageEntry);
        }
        return true;
    }

    protected String createTargetKey(CrossValidationStorageEntry crossValidationStorageEntry, String targetKey) {
        ValueBindingExpression baseExpression = new ValueBindingExpression("#{" + ((PropertyDetails)crossValidationStorageEntry.getMetaDataEntry().getProperty("property_details", PropertyDetails.class)).getKey() + "}");
        String result = ValueBindingExpression.replaceOrAddProperty((ValueBindingExpression)baseExpression, (String)targetKey).getExpressionString();
        return result.substring(2, result.length() - 1);
    }

    protected Object getValueOfProperty(Object base, String property) {
        property = property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
        Class targetClass = ProxyUtils.getUnproxiedClass(base.getClass());
        Method targetMethod = ReflectionUtils.tryToGetMethod((Class)targetClass, (String)("get" + property));
        if (targetMethod == null) {
            targetMethod = ReflectionUtils.tryToGetMethod((Class)targetClass, (String)("is" + property));
        }
        if (targetMethod == null) {
            throw new IllegalStateException("class " + base.getClass() + " has no public get/is " + property.toLowerCase());
        }
        return ReflectionUtils.tryToInvokeMethod((Object)base, (Method)targetMethod);
    }

    private boolean isModelAwareCrossValidation(CrossValidationStorageEntry crossValidationStorageEntry, ProcessedInformationStorage keyConvertedValueMapping, String targetKey) {
        String newKey = this.createTargetKey(crossValidationStorageEntry, targetKey);
        return !keyConvertedValueMapping.containsEntry(newKey);
    }

    private String resolveSourceKey(CrossValidationStorageEntry crossValidationStorageEntry) {
        PropertyDetails propertyDetails = (PropertyDetails)crossValidationStorageEntry.getMetaDataEntry().getProperty("property_details", PropertyDetails.class);
        String sourceKey = propertyDetails.getKey();
        if (!sourceKey.contains(".")) {
            throw new IllegalStateException("source path: " + sourceKey + " invalid");
        }
        return sourceKey;
    }

    private void unsupportedCase(CrossValidationStorageEntry crossValidationStorageEntry) {
        this.logger.warning("couldn't find converted object for " + ((PropertyDetails)crossValidationStorageEntry.getMetaDataEntry().getProperty("property_details", PropertyDetails.class)).getKey());
    }

    private void processCrossComponentValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, ProcessedInformationStorageEntry validationTargetEntry) {
        CrossValidationHelper.crossValidateCompareStrategy(compareStrategy, crossValidationStorageEntry, validationTargetEntry, false);
    }

    private void processModelAwareCrossValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, String targetProperty) {
        ProcessedInformationStorageEntry targetEntry = new ProcessedInformationStorageEntry();
        targetEntry.setBean(((PropertyDetails)crossValidationStorageEntry.getMetaDataEntry().getProperty("property_details", PropertyDetails.class)).getBaseObject());
        targetEntry.setConvertedValue(this.getValueOfProperty(targetEntry.getBean(), targetProperty));
        CrossValidationHelper.crossValidateCompareStrategy(compareStrategy, crossValidationStorageEntry, targetEntry, true);
    }
}

